# coding: utf-8

"""
    Yagna Activity API

     The Activity API can be perceived as controls which a Requestor-side application has to steer the execution of an Activity as specified in an Agreement which has been negotiated via the Market API/Protocol. This defines possible interactions between the Requestor application (via Activity API) and the generic components running on the Provider node, which host the Provider-side application code. The possible interactions imply a logical “execution environment” component, which is the host/container for the “payload” code. The “execution environment” is specified as an ExeUnit, with a generic interface via which a Provider node’s Activity Controller can operate the hosted code. It conforms with capability level 1 of the [Activity API specification] (https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


from ya_activity.configuration import Configuration


class ProviderEvent(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'event_type': 'str',
        'event_date': 'datetime',
        'activity_id': 'str',
        'agreement_id': 'str'
    }

    attribute_map = {
        'event_type': 'eventType',
        'event_date': 'eventDate',
        'activity_id': 'activityId',
        'agreement_id': 'agreementId'
    }

    discriminator_value_class_map = {
        'GetActivityState': 'GetActivityState',
        'CreateActivity': 'CreateActivity',
        'DestroyActivity': 'DestroyActivity',
        'GetActivityUsage': 'GetActivityUsage'
    }

    def __init__(self, event_type=None, event_date=None, activity_id=None, agreement_id=None, local_vars_configuration=None):  # noqa: E501
        """ProviderEvent - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._event_type = None
        self._event_date = None
        self._activity_id = None
        self._agreement_id = None
        self.discriminator = 'event_type'

        self.event_type = event_type
        self.event_date = event_date
        self.activity_id = activity_id
        self.agreement_id = agreement_id

    @property
    def event_type(self):
        """Gets the event_type of this ProviderEvent.  # noqa: E501


        :return: The event_type of this ProviderEvent.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this ProviderEvent.


        :param event_type: The event_type of this ProviderEvent.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and event_type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `event_type`, must not be `None`"
            )  # noqa: E501

        self._event_type = event_type

    @property
    def event_date(self):
        """Gets the event_date of this ProviderEvent.  # noqa: E501


        :return: The event_date of this ProviderEvent.  # noqa: E501
        :rtype: datetime
        """
        return self._event_date

    @event_date.setter
    def event_date(self, event_date):
        """Sets the event_date of this ProviderEvent.


        :param event_date: The event_date of this ProviderEvent.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and event_date is None:  # noqa: E501
            raise ValueError("Invalid value for `event_date`, must not be `None`")  # noqa: E501

        self._event_date = event_date

    @property
    def activity_id(self):
        """Gets the activity_id of this ProviderEvent.  # noqa: E501


        :return: The activity_id of this ProviderEvent.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this ProviderEvent.


        :param activity_id: The activity_id of this ProviderEvent.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and activity_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `activity_id`, must not be `None`"
            )  # noqa: E501

        self._activity_id = activity_id

    @property
    def agreement_id(self):
        """Gets the agreement_id of this ProviderEvent.  # noqa: E501


        :return: The agreement_id of this ProviderEvent.  # noqa: E501
        :rtype: str
        """
        return self._agreement_id

    @agreement_id.setter
    def agreement_id(self, agreement_id):
        """Sets the agreement_id of this ProviderEvent.


        :param agreement_id: The agreement_id of this ProviderEvent.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and agreement_id is None:  # noqa: E501
            raise ValueError("Invalid value for `agreement_id`, must not be `None`")  # noqa: E501

        self._agreement_id = agreement_id

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_key = self.attribute_map[self.discriminator]
        discriminator_value = data[discriminator_key]
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProviderEvent):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProviderEvent):
            return True

        return self.to_dict() != other.to_dict()
