# coding: utf-8

"""
    Yagna Activity API

     The Activity API can be perceived as controls which a Requestor-side application has to steer the execution of an Activity as specified in an Agreement which has been negotiated via the Market API/Protocol. This defines possible interactions between the Requestor application (via Activity API) and the generic components running on the Provider node, which host the Provider-side application code. The possible interactions imply a logical “execution environment” component, which is the host/container for the “payload” code. The “execution environment” is specified as an ExeUnit, with a generic interface via which a Provider node’s Activity Controller can operate the hosted code. It conforms with capability level 1 of the [Activity API specification] (https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

from ya_activity.configuration import Configuration


class TransferCommandBody(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_from': 'str',
        'to': 'str',
        'format': 'str',
        'depth': 'float',
        'fileset': 'list[FileSet]'
    }

    attribute_map = {
        '_from': 'from',
        'to': 'to',
        'format': 'format',
        'depth': 'depth',
        'fileset': 'fileset'
    }

    def __init__(self, _from=None, to=None, format=None, depth=None, fileset=None, local_vars_configuration=None):  # noqa: E501
        """TransferCommandBody - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self.__from = None
        self._to = None
        self._format = None
        self._depth = None
        self._fileset = None
        self.discriminator = None

        self._from = _from
        self.to = to
        if format is not None:
            self.format = format
        if depth is not None:
            self.depth = depth
        if fileset is not None:
            self.fileset = fileset

    @property
    def _from(self):
        """Gets the _from of this TransferCommandBody.  # noqa: E501


        :return: The _from of this TransferCommandBody.  # noqa: E501
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this TransferCommandBody.


        :param _from: The _from of this TransferCommandBody.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and _from is None:  # noqa: E501
            raise ValueError("Invalid value for `_from`, must not be `None`")  # noqa: E501

        self.__from = _from

    @property
    def to(self):
        """Gets the to of this TransferCommandBody.  # noqa: E501


        :return: The to of this TransferCommandBody.  # noqa: E501
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this TransferCommandBody.


        :param to: The to of this TransferCommandBody.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and to is None:  # noqa: E501
            raise ValueError("Invalid value for `to`, must not be `None`")  # noqa: E501

        self._to = to

    @property
    def format(self):
        """Gets the format of this TransferCommandBody.  # noqa: E501


        :return: The format of this TransferCommandBody.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this TransferCommandBody.


        :param format: The format of this TransferCommandBody.  # noqa: E501
        :type: str
        """

        self._format = format

    @property
    def depth(self):
        """Gets the depth of this TransferCommandBody.  # noqa: E501


        :return: The depth of this TransferCommandBody.  # noqa: E501
        :rtype: float
        """
        return self._depth

    @depth.setter
    def depth(self, depth):
        """Sets the depth of this TransferCommandBody.


        :param depth: The depth of this TransferCommandBody.  # noqa: E501
        :type: float
        """

        self._depth = depth

    @property
    def fileset(self):
        """Gets the fileset of this TransferCommandBody.  # noqa: E501


        :return: The fileset of this TransferCommandBody.  # noqa: E501
        :rtype: list[FileSet]
        """
        return self._fileset

    @fileset.setter
    def fileset(self, fileset):
        """Sets the fileset of this TransferCommandBody.


        :param fileset: The fileset of this TransferCommandBody.  # noqa: E501
        :type: list[FileSet]
        """

        self._fileset = fileset

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr in self.openapi_types:
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransferCommandBody):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransferCommandBody):
            return True

        return self.to_dict() != other.to_dict()
