# coding: utf-8

"""
    Yagna Payment API

     Invoicing and Payments is a fundamental area of Yagna Ecosystem functionality. It includes aspects of communication between Requestor, Provider and a selected Payment Platform, which becomes crucial when Activities are executed in the context of negotiated Agreements. Yagna applications must be able to exercise various payment models, and the Invoicing/Payment-related communication is happening in parallel to Activity control communication. To define functional patterns of Requestor/Provider interaction in this area, Payment API is specified.  An important principle of the Yagna Payment API is that the actual payment transactions are hidden behind the Invoice flow. In other words, a Yagna Application on Requestor side isn’t expected to trigger actual payment transactions. Instead it is expected to receive and accept Invoices raised by the Provider - based on Application’s Invoice Accept notifications, the Payment API implementation orchestrates the payment via a configured Payment platform.  **NOTE: This specification is work-in-progress.**   # noqa: E501

    The version of the OpenAPI document: 1.6.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

from ya_payment.configuration import Configuration


class Account(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'platform': 'str',
        'address': 'str',
        'driver': 'str',
        'network': 'str',
        'token': 'str',
        'send': 'bool',
        'receive': 'bool'
    }

    attribute_map = {
        'platform': 'platform',
        'address': 'address',
        'driver': 'driver',
        'network': 'network',
        'token': 'token',
        'send': 'send',
        'receive': 'receive'
    }

    def __init__(self, platform=None, address=None, driver=None, network=None, token=None, send=None, receive=None, local_vars_configuration=None):  # noqa: E501
        """Account - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._platform = None
        self._address = None
        self._driver = None
        self._network = None
        self._token = None
        self._send = None
        self._receive = None
        self.discriminator = None

        self.platform = platform
        self.address = address
        self.driver = driver
        self.network = network
        self.token = token
        self.send = send
        self.receive = receive

    @property
    def platform(self):
        """Gets the platform of this Account.  # noqa: E501


        :return: The platform of this Account.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this Account.


        :param platform: The platform of this Account.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and platform is None:  # noqa: E501
            raise ValueError("Invalid value for `platform`, must not be `None`")  # noqa: E501

        self._platform = platform

    @property
    def address(self):
        """Gets the address of this Account.  # noqa: E501


        :return: The address of this Account.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this Account.


        :param address: The address of this Account.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and address is None:  # noqa: E501
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501

        self._address = address

    @property
    def driver(self):
        """Gets the driver of this Account.  # noqa: E501


        :return: The driver of this Account.  # noqa: E501
        :rtype: str
        """
        return self._driver

    @driver.setter
    def driver(self, driver):
        """Sets the driver of this Account.


        :param driver: The driver of this Account.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and driver is None:  # noqa: E501
            raise ValueError("Invalid value for `driver`, must not be `None`")  # noqa: E501

        self._driver = driver

    @property
    def network(self):
        """Gets the network of this Account.  # noqa: E501


        :return: The network of this Account.  # noqa: E501
        :rtype: str
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this Account.


        :param network: The network of this Account.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and network is None:  # noqa: E501
            raise ValueError("Invalid value for `network`, must not be `None`")  # noqa: E501

        self._network = network

    @property
    def token(self):
        """Gets the token of this Account.  # noqa: E501


        :return: The token of this Account.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this Account.


        :param token: The token of this Account.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and token is None:  # noqa: E501
            raise ValueError("Invalid value for `token`, must not be `None`")  # noqa: E501

        self._token = token

    @property
    def send(self):
        """Gets the send of this Account.  # noqa: E501


        :return: The send of this Account.  # noqa: E501
        :rtype: bool
        """
        return self._send

    @send.setter
    def send(self, send):
        """Sets the send of this Account.


        :param send: The send of this Account.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and send is None:  # noqa: E501
            raise ValueError("Invalid value for `send`, must not be `None`")  # noqa: E501

        self._send = send

    @property
    def receive(self):
        """Gets the receive of this Account.  # noqa: E501


        :return: The receive of this Account.  # noqa: E501
        :rtype: bool
        """
        return self._receive

    @receive.setter
    def receive(self, receive):
        """Sets the receive of this Account.


        :param receive: The receive of this Account.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and receive is None:  # noqa: E501
            raise ValueError("Invalid value for `receive`, must not be `None`")  # noqa: E501

        self._receive = receive

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr in self.openapi_types:
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Account):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Account):
            return True

        return self.to_dict() != other.to_dict()
