# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoTrustsecFeatureTemplateArgs', 'CiscoTrustsecFeatureTemplate']

@pulumi.input_type
class CiscoTrustsecFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 credentials_id_variable: Optional[pulumi.Input[str]] = None,
                 credentials_password: Optional[pulumi.Input[str]] = None,
                 credentials_password_variable: Optional[pulumi.Input[str]] = None,
                 device_sgt: Optional[pulumi.Input[int]] = None,
                 device_sgt_variable: Optional[pulumi.Input[str]] = None,
                 enable_enforcement: Optional[pulumi.Input[bool]] = None,
                 enable_enforcement_variable: Optional[pulumi.Input[str]] = None,
                 enable_sxp: Optional[pulumi.Input[bool]] = None,
                 maximum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 maximum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 minimum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 minimum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 speaker_hold_time: Optional[pulumi.Input[int]] = None,
                 speaker_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 sxp_connections: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]]] = None,
                 sxp_default_password: Optional[pulumi.Input[str]] = None,
                 sxp_default_password_variable: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain_variable: Optional[pulumi.Input[str]] = None,
                 sxp_log_binding_changes: Optional[pulumi.Input[bool]] = None,
                 sxp_log_binding_changes_variable: Optional[pulumi.Input[str]] = None,
                 sxp_node_id: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_type: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_variable: Optional[pulumi.Input[str]] = None,
                 sxp_reconciliation_period: Optional[pulumi.Input[int]] = None,
                 sxp_reconciliation_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_retry_period: Optional[pulumi.Input[int]] = None,
                 sxp_retry_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoTrustsecFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] credentials_id: Specify the TrustSec Network Access Device ID, should be same as mentioned in the Identity Services Engine (upto 32
               char)
        :param pulumi.Input[str] credentials_id_variable: Variable name
        :param pulumi.Input[str] credentials_password: Set the password for the device
        :param pulumi.Input[str] credentials_password_variable: Variable name
        :param pulumi.Input[int] device_sgt: Configure Local device security group <2..65519> - Range: `2`-`65519`
        :param pulumi.Input[str] device_sgt_variable: Variable name
        :param pulumi.Input[bool] enable_enforcement: Enable Role-based Access Control enforcement - Default value: `false`
        :param pulumi.Input[str] enable_enforcement_variable: Variable name
        :param pulumi.Input[bool] enable_sxp: Enable CTS SXP support - Default value: `false`
        :param pulumi.Input[int] maximum_listener_hold_time: Configure Maximum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `180`
        :param pulumi.Input[str] maximum_listener_hold_time_variable: Variable name
        :param pulumi.Input[int] minimum_listener_hold_time: Configure Minimum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `90`
        :param pulumi.Input[str] minimum_listener_hold_time_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] speaker_hold_time: Configure Speaker hold-time in seconds <1..65534> - Range: `1`-`65534` - Default value: `120`
        :param pulumi.Input[str] speaker_hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]] sxp_connections: Configure SXP Connections
        :param pulumi.Input[str] sxp_default_password: Configure SXP default password
        :param pulumi.Input[str] sxp_default_password_variable: Variable name
        :param pulumi.Input[str] sxp_key_chain: Configure SXP key-chain
        :param pulumi.Input[str] sxp_key_chain_variable: Variable name
        :param pulumi.Input[bool] sxp_log_binding_changes: Enables logging for IP-to-SGT binding changes - Default value: `false`
        :param pulumi.Input[str] sxp_log_binding_changes_variable: Variable name
        :param pulumi.Input[str] sxp_node_id: Configure SXP Node ID <IP, 8 char string or interface name>
        :param pulumi.Input[str] sxp_node_id_type: Define SXP Node ID type <IP, 8 char string or interface name> - Choices: `ip`, `interface-name`, `8-char-hex-string` -
               Default value: `ip`
        :param pulumi.Input[str] sxp_node_id_variable: Variable name
        :param pulumi.Input[int] sxp_reconciliation_period: Configure the SXP reconciliation period in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_reconciliation_period_variable: Variable name
        :param pulumi.Input[int] sxp_retry_period: Configure Retry period for SXP connection in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_retry_period_variable: Variable name
        :param pulumi.Input[str] sxp_source_ip: SXP Source IP
        :param pulumi.Input[str] sxp_source_ip_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if credentials_id_variable is not None:
            pulumi.set(__self__, "credentials_id_variable", credentials_id_variable)
        if credentials_password is not None:
            pulumi.set(__self__, "credentials_password", credentials_password)
        if credentials_password_variable is not None:
            pulumi.set(__self__, "credentials_password_variable", credentials_password_variable)
        if device_sgt is not None:
            pulumi.set(__self__, "device_sgt", device_sgt)
        if device_sgt_variable is not None:
            pulumi.set(__self__, "device_sgt_variable", device_sgt_variable)
        if enable_enforcement is not None:
            pulumi.set(__self__, "enable_enforcement", enable_enforcement)
        if enable_enforcement_variable is not None:
            pulumi.set(__self__, "enable_enforcement_variable", enable_enforcement_variable)
        if enable_sxp is not None:
            pulumi.set(__self__, "enable_sxp", enable_sxp)
        if maximum_listener_hold_time is not None:
            pulumi.set(__self__, "maximum_listener_hold_time", maximum_listener_hold_time)
        if maximum_listener_hold_time_variable is not None:
            pulumi.set(__self__, "maximum_listener_hold_time_variable", maximum_listener_hold_time_variable)
        if minimum_listener_hold_time is not None:
            pulumi.set(__self__, "minimum_listener_hold_time", minimum_listener_hold_time)
        if minimum_listener_hold_time_variable is not None:
            pulumi.set(__self__, "minimum_listener_hold_time_variable", minimum_listener_hold_time_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if speaker_hold_time is not None:
            pulumi.set(__self__, "speaker_hold_time", speaker_hold_time)
        if speaker_hold_time_variable is not None:
            pulumi.set(__self__, "speaker_hold_time_variable", speaker_hold_time_variable)
        if sxp_connections is not None:
            pulumi.set(__self__, "sxp_connections", sxp_connections)
        if sxp_default_password is not None:
            pulumi.set(__self__, "sxp_default_password", sxp_default_password)
        if sxp_default_password_variable is not None:
            pulumi.set(__self__, "sxp_default_password_variable", sxp_default_password_variable)
        if sxp_key_chain is not None:
            pulumi.set(__self__, "sxp_key_chain", sxp_key_chain)
        if sxp_key_chain_variable is not None:
            pulumi.set(__self__, "sxp_key_chain_variable", sxp_key_chain_variable)
        if sxp_log_binding_changes is not None:
            pulumi.set(__self__, "sxp_log_binding_changes", sxp_log_binding_changes)
        if sxp_log_binding_changes_variable is not None:
            pulumi.set(__self__, "sxp_log_binding_changes_variable", sxp_log_binding_changes_variable)
        if sxp_node_id is not None:
            pulumi.set(__self__, "sxp_node_id", sxp_node_id)
        if sxp_node_id_type is not None:
            pulumi.set(__self__, "sxp_node_id_type", sxp_node_id_type)
        if sxp_node_id_variable is not None:
            pulumi.set(__self__, "sxp_node_id_variable", sxp_node_id_variable)
        if sxp_reconciliation_period is not None:
            pulumi.set(__self__, "sxp_reconciliation_period", sxp_reconciliation_period)
        if sxp_reconciliation_period_variable is not None:
            pulumi.set(__self__, "sxp_reconciliation_period_variable", sxp_reconciliation_period_variable)
        if sxp_retry_period is not None:
            pulumi.set(__self__, "sxp_retry_period", sxp_retry_period)
        if sxp_retry_period_variable is not None:
            pulumi.set(__self__, "sxp_retry_period_variable", sxp_retry_period_variable)
        if sxp_source_ip is not None:
            pulumi.set(__self__, "sxp_source_ip", sxp_source_ip)
        if sxp_source_ip_variable is not None:
            pulumi.set(__self__, "sxp_source_ip_variable", sxp_source_ip_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the TrustSec Network Access Device ID, should be same as mentioned in the Identity Services Engine (upto 32
        char)
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter(name="credentialsIdVariable")
    def credentials_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "credentials_id_variable")

    @credentials_id_variable.setter
    def credentials_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_id_variable", value)

    @property
    @pulumi.getter(name="credentialsPassword")
    def credentials_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set the password for the device
        """
        return pulumi.get(self, "credentials_password")

    @credentials_password.setter
    def credentials_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_password", value)

    @property
    @pulumi.getter(name="credentialsPasswordVariable")
    def credentials_password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "credentials_password_variable")

    @credentials_password_variable.setter
    def credentials_password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_password_variable", value)

    @property
    @pulumi.getter(name="deviceSgt")
    def device_sgt(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Local device security group <2..65519> - Range: `2`-`65519`
        """
        return pulumi.get(self, "device_sgt")

    @device_sgt.setter
    def device_sgt(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "device_sgt", value)

    @property
    @pulumi.getter(name="deviceSgtVariable")
    def device_sgt_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "device_sgt_variable")

    @device_sgt_variable.setter
    def device_sgt_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_sgt_variable", value)

    @property
    @pulumi.getter(name="enableEnforcement")
    def enable_enforcement(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Role-based Access Control enforcement - Default value: `false`
        """
        return pulumi.get(self, "enable_enforcement")

    @enable_enforcement.setter
    def enable_enforcement(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_enforcement", value)

    @property
    @pulumi.getter(name="enableEnforcementVariable")
    def enable_enforcement_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_enforcement_variable")

    @enable_enforcement_variable.setter
    def enable_enforcement_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_enforcement_variable", value)

    @property
    @pulumi.getter(name="enableSxp")
    def enable_sxp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CTS SXP support - Default value: `false`
        """
        return pulumi.get(self, "enable_sxp")

    @enable_sxp.setter
    def enable_sxp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sxp", value)

    @property
    @pulumi.getter(name="maximumListenerHoldTime")
    def maximum_listener_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Maximum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `180`
        """
        return pulumi.get(self, "maximum_listener_hold_time")

    @maximum_listener_hold_time.setter
    def maximum_listener_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_listener_hold_time", value)

    @property
    @pulumi.getter(name="maximumListenerHoldTimeVariable")
    def maximum_listener_hold_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "maximum_listener_hold_time_variable")

    @maximum_listener_hold_time_variable.setter
    def maximum_listener_hold_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_listener_hold_time_variable", value)

    @property
    @pulumi.getter(name="minimumListenerHoldTime")
    def minimum_listener_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Minimum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `90`
        """
        return pulumi.get(self, "minimum_listener_hold_time")

    @minimum_listener_hold_time.setter
    def minimum_listener_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_listener_hold_time", value)

    @property
    @pulumi.getter(name="minimumListenerHoldTimeVariable")
    def minimum_listener_hold_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "minimum_listener_hold_time_variable")

    @minimum_listener_hold_time_variable.setter
    def minimum_listener_hold_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_listener_hold_time_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="speakerHoldTime")
    def speaker_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Speaker hold-time in seconds <1..65534> - Range: `1`-`65534` - Default value: `120`
        """
        return pulumi.get(self, "speaker_hold_time")

    @speaker_hold_time.setter
    def speaker_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "speaker_hold_time", value)

    @property
    @pulumi.getter(name="speakerHoldTimeVariable")
    def speaker_hold_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "speaker_hold_time_variable")

    @speaker_hold_time_variable.setter
    def speaker_hold_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speaker_hold_time_variable", value)

    @property
    @pulumi.getter(name="sxpConnections")
    def sxp_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]]]:
        """
        Configure SXP Connections
        """
        return pulumi.get(self, "sxp_connections")

    @sxp_connections.setter
    def sxp_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]]]):
        pulumi.set(self, "sxp_connections", value)

    @property
    @pulumi.getter(name="sxpDefaultPassword")
    def sxp_default_password(self) -> Optional[pulumi.Input[str]]:
        """
        Configure SXP default password
        """
        return pulumi.get(self, "sxp_default_password")

    @sxp_default_password.setter
    def sxp_default_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_default_password", value)

    @property
    @pulumi.getter(name="sxpDefaultPasswordVariable")
    def sxp_default_password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_default_password_variable")

    @sxp_default_password_variable.setter
    def sxp_default_password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_default_password_variable", value)

    @property
    @pulumi.getter(name="sxpKeyChain")
    def sxp_key_chain(self) -> Optional[pulumi.Input[str]]:
        """
        Configure SXP key-chain
        """
        return pulumi.get(self, "sxp_key_chain")

    @sxp_key_chain.setter
    def sxp_key_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_key_chain", value)

    @property
    @pulumi.getter(name="sxpKeyChainVariable")
    def sxp_key_chain_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_key_chain_variable")

    @sxp_key_chain_variable.setter
    def sxp_key_chain_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_key_chain_variable", value)

    @property
    @pulumi.getter(name="sxpLogBindingChanges")
    def sxp_log_binding_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables logging for IP-to-SGT binding changes - Default value: `false`
        """
        return pulumi.get(self, "sxp_log_binding_changes")

    @sxp_log_binding_changes.setter
    def sxp_log_binding_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sxp_log_binding_changes", value)

    @property
    @pulumi.getter(name="sxpLogBindingChangesVariable")
    def sxp_log_binding_changes_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_log_binding_changes_variable")

    @sxp_log_binding_changes_variable.setter
    def sxp_log_binding_changes_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_log_binding_changes_variable", value)

    @property
    @pulumi.getter(name="sxpNodeId")
    def sxp_node_id(self) -> Optional[pulumi.Input[str]]:
        """
        Configure SXP Node ID <IP, 8 char string or interface name>
        """
        return pulumi.get(self, "sxp_node_id")

    @sxp_node_id.setter
    def sxp_node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_node_id", value)

    @property
    @pulumi.getter(name="sxpNodeIdType")
    def sxp_node_id_type(self) -> Optional[pulumi.Input[str]]:
        """
        Define SXP Node ID type <IP, 8 char string or interface name> - Choices: `ip`, `interface-name`, `8-char-hex-string` -
        Default value: `ip`
        """
        return pulumi.get(self, "sxp_node_id_type")

    @sxp_node_id_type.setter
    def sxp_node_id_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_node_id_type", value)

    @property
    @pulumi.getter(name="sxpNodeIdVariable")
    def sxp_node_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_node_id_variable")

    @sxp_node_id_variable.setter
    def sxp_node_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_node_id_variable", value)

    @property
    @pulumi.getter(name="sxpReconciliationPeriod")
    def sxp_reconciliation_period(self) -> Optional[pulumi.Input[int]]:
        """
        Configure the SXP reconciliation period in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        """
        return pulumi.get(self, "sxp_reconciliation_period")

    @sxp_reconciliation_period.setter
    def sxp_reconciliation_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sxp_reconciliation_period", value)

    @property
    @pulumi.getter(name="sxpReconciliationPeriodVariable")
    def sxp_reconciliation_period_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_reconciliation_period_variable")

    @sxp_reconciliation_period_variable.setter
    def sxp_reconciliation_period_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_reconciliation_period_variable", value)

    @property
    @pulumi.getter(name="sxpRetryPeriod")
    def sxp_retry_period(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Retry period for SXP connection in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        """
        return pulumi.get(self, "sxp_retry_period")

    @sxp_retry_period.setter
    def sxp_retry_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sxp_retry_period", value)

    @property
    @pulumi.getter(name="sxpRetryPeriodVariable")
    def sxp_retry_period_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_retry_period_variable")

    @sxp_retry_period_variable.setter
    def sxp_retry_period_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_retry_period_variable", value)

    @property
    @pulumi.getter(name="sxpSourceIp")
    def sxp_source_ip(self) -> Optional[pulumi.Input[str]]:
        """
        SXP Source IP
        """
        return pulumi.get(self, "sxp_source_ip")

    @sxp_source_ip.setter
    def sxp_source_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_source_ip", value)

    @property
    @pulumi.getter(name="sxpSourceIpVariable")
    def sxp_source_ip_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_source_ip_variable")

    @sxp_source_ip_variable.setter
    def sxp_source_ip_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_source_ip_variable", value)


@pulumi.input_type
class _CiscoTrustsecFeatureTemplateState:
    def __init__(__self__, *,
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 credentials_id_variable: Optional[pulumi.Input[str]] = None,
                 credentials_password: Optional[pulumi.Input[str]] = None,
                 credentials_password_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_sgt: Optional[pulumi.Input[int]] = None,
                 device_sgt_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_enforcement: Optional[pulumi.Input[bool]] = None,
                 enable_enforcement_variable: Optional[pulumi.Input[str]] = None,
                 enable_sxp: Optional[pulumi.Input[bool]] = None,
                 maximum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 maximum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 minimum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 minimum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 speaker_hold_time: Optional[pulumi.Input[int]] = None,
                 speaker_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 sxp_connections: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]]] = None,
                 sxp_default_password: Optional[pulumi.Input[str]] = None,
                 sxp_default_password_variable: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain_variable: Optional[pulumi.Input[str]] = None,
                 sxp_log_binding_changes: Optional[pulumi.Input[bool]] = None,
                 sxp_log_binding_changes_variable: Optional[pulumi.Input[str]] = None,
                 sxp_node_id: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_type: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_variable: Optional[pulumi.Input[str]] = None,
                 sxp_reconciliation_period: Optional[pulumi.Input[int]] = None,
                 sxp_reconciliation_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_retry_period: Optional[pulumi.Input[int]] = None,
                 sxp_retry_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoTrustsecFeatureTemplate resources.
        :param pulumi.Input[str] credentials_id: Specify the TrustSec Network Access Device ID, should be same as mentioned in the Identity Services Engine (upto 32
               char)
        :param pulumi.Input[str] credentials_id_variable: Variable name
        :param pulumi.Input[str] credentials_password: Set the password for the device
        :param pulumi.Input[str] credentials_password_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[int] device_sgt: Configure Local device security group <2..65519> - Range: `2`-`65519`
        :param pulumi.Input[str] device_sgt_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] enable_enforcement: Enable Role-based Access Control enforcement - Default value: `false`
        :param pulumi.Input[str] enable_enforcement_variable: Variable name
        :param pulumi.Input[bool] enable_sxp: Enable CTS SXP support - Default value: `false`
        :param pulumi.Input[int] maximum_listener_hold_time: Configure Maximum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `180`
        :param pulumi.Input[str] maximum_listener_hold_time_variable: Variable name
        :param pulumi.Input[int] minimum_listener_hold_time: Configure Minimum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `90`
        :param pulumi.Input[str] minimum_listener_hold_time_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] speaker_hold_time: Configure Speaker hold-time in seconds <1..65534> - Range: `1`-`65534` - Default value: `120`
        :param pulumi.Input[str] speaker_hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]] sxp_connections: Configure SXP Connections
        :param pulumi.Input[str] sxp_default_password: Configure SXP default password
        :param pulumi.Input[str] sxp_default_password_variable: Variable name
        :param pulumi.Input[str] sxp_key_chain: Configure SXP key-chain
        :param pulumi.Input[str] sxp_key_chain_variable: Variable name
        :param pulumi.Input[bool] sxp_log_binding_changes: Enables logging for IP-to-SGT binding changes - Default value: `false`
        :param pulumi.Input[str] sxp_log_binding_changes_variable: Variable name
        :param pulumi.Input[str] sxp_node_id: Configure SXP Node ID <IP, 8 char string or interface name>
        :param pulumi.Input[str] sxp_node_id_type: Define SXP Node ID type <IP, 8 char string or interface name> - Choices: `ip`, `interface-name`, `8-char-hex-string` -
               Default value: `ip`
        :param pulumi.Input[str] sxp_node_id_variable: Variable name
        :param pulumi.Input[int] sxp_reconciliation_period: Configure the SXP reconciliation period in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_reconciliation_period_variable: Variable name
        :param pulumi.Input[int] sxp_retry_period: Configure Retry period for SXP connection in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_retry_period_variable: Variable name
        :param pulumi.Input[str] sxp_source_ip: SXP Source IP
        :param pulumi.Input[str] sxp_source_ip_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if credentials_id_variable is not None:
            pulumi.set(__self__, "credentials_id_variable", credentials_id_variable)
        if credentials_password is not None:
            pulumi.set(__self__, "credentials_password", credentials_password)
        if credentials_password_variable is not None:
            pulumi.set(__self__, "credentials_password_variable", credentials_password_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_sgt is not None:
            pulumi.set(__self__, "device_sgt", device_sgt)
        if device_sgt_variable is not None:
            pulumi.set(__self__, "device_sgt_variable", device_sgt_variable)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if enable_enforcement is not None:
            pulumi.set(__self__, "enable_enforcement", enable_enforcement)
        if enable_enforcement_variable is not None:
            pulumi.set(__self__, "enable_enforcement_variable", enable_enforcement_variable)
        if enable_sxp is not None:
            pulumi.set(__self__, "enable_sxp", enable_sxp)
        if maximum_listener_hold_time is not None:
            pulumi.set(__self__, "maximum_listener_hold_time", maximum_listener_hold_time)
        if maximum_listener_hold_time_variable is not None:
            pulumi.set(__self__, "maximum_listener_hold_time_variable", maximum_listener_hold_time_variable)
        if minimum_listener_hold_time is not None:
            pulumi.set(__self__, "minimum_listener_hold_time", minimum_listener_hold_time)
        if minimum_listener_hold_time_variable is not None:
            pulumi.set(__self__, "minimum_listener_hold_time_variable", minimum_listener_hold_time_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if speaker_hold_time is not None:
            pulumi.set(__self__, "speaker_hold_time", speaker_hold_time)
        if speaker_hold_time_variable is not None:
            pulumi.set(__self__, "speaker_hold_time_variable", speaker_hold_time_variable)
        if sxp_connections is not None:
            pulumi.set(__self__, "sxp_connections", sxp_connections)
        if sxp_default_password is not None:
            pulumi.set(__self__, "sxp_default_password", sxp_default_password)
        if sxp_default_password_variable is not None:
            pulumi.set(__self__, "sxp_default_password_variable", sxp_default_password_variable)
        if sxp_key_chain is not None:
            pulumi.set(__self__, "sxp_key_chain", sxp_key_chain)
        if sxp_key_chain_variable is not None:
            pulumi.set(__self__, "sxp_key_chain_variable", sxp_key_chain_variable)
        if sxp_log_binding_changes is not None:
            pulumi.set(__self__, "sxp_log_binding_changes", sxp_log_binding_changes)
        if sxp_log_binding_changes_variable is not None:
            pulumi.set(__self__, "sxp_log_binding_changes_variable", sxp_log_binding_changes_variable)
        if sxp_node_id is not None:
            pulumi.set(__self__, "sxp_node_id", sxp_node_id)
        if sxp_node_id_type is not None:
            pulumi.set(__self__, "sxp_node_id_type", sxp_node_id_type)
        if sxp_node_id_variable is not None:
            pulumi.set(__self__, "sxp_node_id_variable", sxp_node_id_variable)
        if sxp_reconciliation_period is not None:
            pulumi.set(__self__, "sxp_reconciliation_period", sxp_reconciliation_period)
        if sxp_reconciliation_period_variable is not None:
            pulumi.set(__self__, "sxp_reconciliation_period_variable", sxp_reconciliation_period_variable)
        if sxp_retry_period is not None:
            pulumi.set(__self__, "sxp_retry_period", sxp_retry_period)
        if sxp_retry_period_variable is not None:
            pulumi.set(__self__, "sxp_retry_period_variable", sxp_retry_period_variable)
        if sxp_source_ip is not None:
            pulumi.set(__self__, "sxp_source_ip", sxp_source_ip)
        if sxp_source_ip_variable is not None:
            pulumi.set(__self__, "sxp_source_ip_variable", sxp_source_ip_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the TrustSec Network Access Device ID, should be same as mentioned in the Identity Services Engine (upto 32
        char)
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter(name="credentialsIdVariable")
    def credentials_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "credentials_id_variable")

    @credentials_id_variable.setter
    def credentials_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_id_variable", value)

    @property
    @pulumi.getter(name="credentialsPassword")
    def credentials_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set the password for the device
        """
        return pulumi.get(self, "credentials_password")

    @credentials_password.setter
    def credentials_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_password", value)

    @property
    @pulumi.getter(name="credentialsPasswordVariable")
    def credentials_password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "credentials_password_variable")

    @credentials_password_variable.setter
    def credentials_password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_password_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceSgt")
    def device_sgt(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Local device security group <2..65519> - Range: `2`-`65519`
        """
        return pulumi.get(self, "device_sgt")

    @device_sgt.setter
    def device_sgt(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "device_sgt", value)

    @property
    @pulumi.getter(name="deviceSgtVariable")
    def device_sgt_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "device_sgt_variable")

    @device_sgt_variable.setter
    def device_sgt_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_sgt_variable", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="enableEnforcement")
    def enable_enforcement(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Role-based Access Control enforcement - Default value: `false`
        """
        return pulumi.get(self, "enable_enforcement")

    @enable_enforcement.setter
    def enable_enforcement(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_enforcement", value)

    @property
    @pulumi.getter(name="enableEnforcementVariable")
    def enable_enforcement_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_enforcement_variable")

    @enable_enforcement_variable.setter
    def enable_enforcement_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_enforcement_variable", value)

    @property
    @pulumi.getter(name="enableSxp")
    def enable_sxp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CTS SXP support - Default value: `false`
        """
        return pulumi.get(self, "enable_sxp")

    @enable_sxp.setter
    def enable_sxp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sxp", value)

    @property
    @pulumi.getter(name="maximumListenerHoldTime")
    def maximum_listener_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Maximum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `180`
        """
        return pulumi.get(self, "maximum_listener_hold_time")

    @maximum_listener_hold_time.setter
    def maximum_listener_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_listener_hold_time", value)

    @property
    @pulumi.getter(name="maximumListenerHoldTimeVariable")
    def maximum_listener_hold_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "maximum_listener_hold_time_variable")

    @maximum_listener_hold_time_variable.setter
    def maximum_listener_hold_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_listener_hold_time_variable", value)

    @property
    @pulumi.getter(name="minimumListenerHoldTime")
    def minimum_listener_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Minimum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `90`
        """
        return pulumi.get(self, "minimum_listener_hold_time")

    @minimum_listener_hold_time.setter
    def minimum_listener_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_listener_hold_time", value)

    @property
    @pulumi.getter(name="minimumListenerHoldTimeVariable")
    def minimum_listener_hold_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "minimum_listener_hold_time_variable")

    @minimum_listener_hold_time_variable.setter
    def minimum_listener_hold_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_listener_hold_time_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="speakerHoldTime")
    def speaker_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Speaker hold-time in seconds <1..65534> - Range: `1`-`65534` - Default value: `120`
        """
        return pulumi.get(self, "speaker_hold_time")

    @speaker_hold_time.setter
    def speaker_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "speaker_hold_time", value)

    @property
    @pulumi.getter(name="speakerHoldTimeVariable")
    def speaker_hold_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "speaker_hold_time_variable")

    @speaker_hold_time_variable.setter
    def speaker_hold_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speaker_hold_time_variable", value)

    @property
    @pulumi.getter(name="sxpConnections")
    def sxp_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]]]:
        """
        Configure SXP Connections
        """
        return pulumi.get(self, "sxp_connections")

    @sxp_connections.setter
    def sxp_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoTrustsecFeatureTemplateSxpConnectionArgs']]]]):
        pulumi.set(self, "sxp_connections", value)

    @property
    @pulumi.getter(name="sxpDefaultPassword")
    def sxp_default_password(self) -> Optional[pulumi.Input[str]]:
        """
        Configure SXP default password
        """
        return pulumi.get(self, "sxp_default_password")

    @sxp_default_password.setter
    def sxp_default_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_default_password", value)

    @property
    @pulumi.getter(name="sxpDefaultPasswordVariable")
    def sxp_default_password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_default_password_variable")

    @sxp_default_password_variable.setter
    def sxp_default_password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_default_password_variable", value)

    @property
    @pulumi.getter(name="sxpKeyChain")
    def sxp_key_chain(self) -> Optional[pulumi.Input[str]]:
        """
        Configure SXP key-chain
        """
        return pulumi.get(self, "sxp_key_chain")

    @sxp_key_chain.setter
    def sxp_key_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_key_chain", value)

    @property
    @pulumi.getter(name="sxpKeyChainVariable")
    def sxp_key_chain_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_key_chain_variable")

    @sxp_key_chain_variable.setter
    def sxp_key_chain_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_key_chain_variable", value)

    @property
    @pulumi.getter(name="sxpLogBindingChanges")
    def sxp_log_binding_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables logging for IP-to-SGT binding changes - Default value: `false`
        """
        return pulumi.get(self, "sxp_log_binding_changes")

    @sxp_log_binding_changes.setter
    def sxp_log_binding_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sxp_log_binding_changes", value)

    @property
    @pulumi.getter(name="sxpLogBindingChangesVariable")
    def sxp_log_binding_changes_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_log_binding_changes_variable")

    @sxp_log_binding_changes_variable.setter
    def sxp_log_binding_changes_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_log_binding_changes_variable", value)

    @property
    @pulumi.getter(name="sxpNodeId")
    def sxp_node_id(self) -> Optional[pulumi.Input[str]]:
        """
        Configure SXP Node ID <IP, 8 char string or interface name>
        """
        return pulumi.get(self, "sxp_node_id")

    @sxp_node_id.setter
    def sxp_node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_node_id", value)

    @property
    @pulumi.getter(name="sxpNodeIdType")
    def sxp_node_id_type(self) -> Optional[pulumi.Input[str]]:
        """
        Define SXP Node ID type <IP, 8 char string or interface name> - Choices: `ip`, `interface-name`, `8-char-hex-string` -
        Default value: `ip`
        """
        return pulumi.get(self, "sxp_node_id_type")

    @sxp_node_id_type.setter
    def sxp_node_id_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_node_id_type", value)

    @property
    @pulumi.getter(name="sxpNodeIdVariable")
    def sxp_node_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_node_id_variable")

    @sxp_node_id_variable.setter
    def sxp_node_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_node_id_variable", value)

    @property
    @pulumi.getter(name="sxpReconciliationPeriod")
    def sxp_reconciliation_period(self) -> Optional[pulumi.Input[int]]:
        """
        Configure the SXP reconciliation period in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        """
        return pulumi.get(self, "sxp_reconciliation_period")

    @sxp_reconciliation_period.setter
    def sxp_reconciliation_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sxp_reconciliation_period", value)

    @property
    @pulumi.getter(name="sxpReconciliationPeriodVariable")
    def sxp_reconciliation_period_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_reconciliation_period_variable")

    @sxp_reconciliation_period_variable.setter
    def sxp_reconciliation_period_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_reconciliation_period_variable", value)

    @property
    @pulumi.getter(name="sxpRetryPeriod")
    def sxp_retry_period(self) -> Optional[pulumi.Input[int]]:
        """
        Configure Retry period for SXP connection in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        """
        return pulumi.get(self, "sxp_retry_period")

    @sxp_retry_period.setter
    def sxp_retry_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sxp_retry_period", value)

    @property
    @pulumi.getter(name="sxpRetryPeriodVariable")
    def sxp_retry_period_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_retry_period_variable")

    @sxp_retry_period_variable.setter
    def sxp_retry_period_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_retry_period_variable", value)

    @property
    @pulumi.getter(name="sxpSourceIp")
    def sxp_source_ip(self) -> Optional[pulumi.Input[str]]:
        """
        SXP Source IP
        """
        return pulumi.get(self, "sxp_source_ip")

    @sxp_source_ip.setter
    def sxp_source_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_source_ip", value)

    @property
    @pulumi.getter(name="sxpSourceIpVariable")
    def sxp_source_ip_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_source_ip_variable")

    @sxp_source_ip_variable.setter
    def sxp_source_ip_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sxp_source_ip_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoTrustsecFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 credentials_id_variable: Optional[pulumi.Input[str]] = None,
                 credentials_password: Optional[pulumi.Input[str]] = None,
                 credentials_password_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_sgt: Optional[pulumi.Input[int]] = None,
                 device_sgt_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_enforcement: Optional[pulumi.Input[bool]] = None,
                 enable_enforcement_variable: Optional[pulumi.Input[str]] = None,
                 enable_sxp: Optional[pulumi.Input[bool]] = None,
                 maximum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 maximum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 minimum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 minimum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 speaker_hold_time: Optional[pulumi.Input[int]] = None,
                 speaker_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 sxp_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoTrustsecFeatureTemplateSxpConnectionArgs', 'CiscoTrustsecFeatureTemplateSxpConnectionArgsDict']]]]] = None,
                 sxp_default_password: Optional[pulumi.Input[str]] = None,
                 sxp_default_password_variable: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain_variable: Optional[pulumi.Input[str]] = None,
                 sxp_log_binding_changes: Optional[pulumi.Input[bool]] = None,
                 sxp_log_binding_changes_variable: Optional[pulumi.Input[str]] = None,
                 sxp_node_id: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_type: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_variable: Optional[pulumi.Input[str]] = None,
                 sxp_reconciliation_period: Optional[pulumi.Input[int]] = None,
                 sxp_reconciliation_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_retry_period: Optional[pulumi.Input[int]] = None,
                 sxp_retry_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco TrustSec feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoTrustsecFeatureTemplate:CiscoTrustsecFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] credentials_id: Specify the TrustSec Network Access Device ID, should be same as mentioned in the Identity Services Engine (upto 32
               char)
        :param pulumi.Input[str] credentials_id_variable: Variable name
        :param pulumi.Input[str] credentials_password: Set the password for the device
        :param pulumi.Input[str] credentials_password_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[int] device_sgt: Configure Local device security group <2..65519> - Range: `2`-`65519`
        :param pulumi.Input[str] device_sgt_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] enable_enforcement: Enable Role-based Access Control enforcement - Default value: `false`
        :param pulumi.Input[str] enable_enforcement_variable: Variable name
        :param pulumi.Input[bool] enable_sxp: Enable CTS SXP support - Default value: `false`
        :param pulumi.Input[int] maximum_listener_hold_time: Configure Maximum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `180`
        :param pulumi.Input[str] maximum_listener_hold_time_variable: Variable name
        :param pulumi.Input[int] minimum_listener_hold_time: Configure Minimum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `90`
        :param pulumi.Input[str] minimum_listener_hold_time_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] speaker_hold_time: Configure Speaker hold-time in seconds <1..65534> - Range: `1`-`65534` - Default value: `120`
        :param pulumi.Input[str] speaker_hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoTrustsecFeatureTemplateSxpConnectionArgs', 'CiscoTrustsecFeatureTemplateSxpConnectionArgsDict']]]] sxp_connections: Configure SXP Connections
        :param pulumi.Input[str] sxp_default_password: Configure SXP default password
        :param pulumi.Input[str] sxp_default_password_variable: Variable name
        :param pulumi.Input[str] sxp_key_chain: Configure SXP key-chain
        :param pulumi.Input[str] sxp_key_chain_variable: Variable name
        :param pulumi.Input[bool] sxp_log_binding_changes: Enables logging for IP-to-SGT binding changes - Default value: `false`
        :param pulumi.Input[str] sxp_log_binding_changes_variable: Variable name
        :param pulumi.Input[str] sxp_node_id: Configure SXP Node ID <IP, 8 char string or interface name>
        :param pulumi.Input[str] sxp_node_id_type: Define SXP Node ID type <IP, 8 char string or interface name> - Choices: `ip`, `interface-name`, `8-char-hex-string` -
               Default value: `ip`
        :param pulumi.Input[str] sxp_node_id_variable: Variable name
        :param pulumi.Input[int] sxp_reconciliation_period: Configure the SXP reconciliation period in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_reconciliation_period_variable: Variable name
        :param pulumi.Input[int] sxp_retry_period: Configure Retry period for SXP connection in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_retry_period_variable: Variable name
        :param pulumi.Input[str] sxp_source_ip: SXP Source IP
        :param pulumi.Input[str] sxp_source_ip_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoTrustsecFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco TrustSec feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoTrustsecFeatureTemplate:CiscoTrustsecFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoTrustsecFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoTrustsecFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 credentials_id_variable: Optional[pulumi.Input[str]] = None,
                 credentials_password: Optional[pulumi.Input[str]] = None,
                 credentials_password_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_sgt: Optional[pulumi.Input[int]] = None,
                 device_sgt_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_enforcement: Optional[pulumi.Input[bool]] = None,
                 enable_enforcement_variable: Optional[pulumi.Input[str]] = None,
                 enable_sxp: Optional[pulumi.Input[bool]] = None,
                 maximum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 maximum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 minimum_listener_hold_time: Optional[pulumi.Input[int]] = None,
                 minimum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 speaker_hold_time: Optional[pulumi.Input[int]] = None,
                 speaker_hold_time_variable: Optional[pulumi.Input[str]] = None,
                 sxp_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoTrustsecFeatureTemplateSxpConnectionArgs', 'CiscoTrustsecFeatureTemplateSxpConnectionArgsDict']]]]] = None,
                 sxp_default_password: Optional[pulumi.Input[str]] = None,
                 sxp_default_password_variable: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain: Optional[pulumi.Input[str]] = None,
                 sxp_key_chain_variable: Optional[pulumi.Input[str]] = None,
                 sxp_log_binding_changes: Optional[pulumi.Input[bool]] = None,
                 sxp_log_binding_changes_variable: Optional[pulumi.Input[str]] = None,
                 sxp_node_id: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_type: Optional[pulumi.Input[str]] = None,
                 sxp_node_id_variable: Optional[pulumi.Input[str]] = None,
                 sxp_reconciliation_period: Optional[pulumi.Input[int]] = None,
                 sxp_reconciliation_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_retry_period: Optional[pulumi.Input[int]] = None,
                 sxp_retry_period_variable: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip: Optional[pulumi.Input[str]] = None,
                 sxp_source_ip_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoTrustsecFeatureTemplateArgs.__new__(CiscoTrustsecFeatureTemplateArgs)

            __props__.__dict__["credentials_id"] = credentials_id
            __props__.__dict__["credentials_id_variable"] = credentials_id_variable
            __props__.__dict__["credentials_password"] = credentials_password
            __props__.__dict__["credentials_password_variable"] = credentials_password_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["device_sgt"] = device_sgt
            __props__.__dict__["device_sgt_variable"] = device_sgt_variable
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["enable_enforcement"] = enable_enforcement
            __props__.__dict__["enable_enforcement_variable"] = enable_enforcement_variable
            __props__.__dict__["enable_sxp"] = enable_sxp
            __props__.__dict__["maximum_listener_hold_time"] = maximum_listener_hold_time
            __props__.__dict__["maximum_listener_hold_time_variable"] = maximum_listener_hold_time_variable
            __props__.__dict__["minimum_listener_hold_time"] = minimum_listener_hold_time
            __props__.__dict__["minimum_listener_hold_time_variable"] = minimum_listener_hold_time_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["speaker_hold_time"] = speaker_hold_time
            __props__.__dict__["speaker_hold_time_variable"] = speaker_hold_time_variable
            __props__.__dict__["sxp_connections"] = sxp_connections
            __props__.__dict__["sxp_default_password"] = sxp_default_password
            __props__.__dict__["sxp_default_password_variable"] = sxp_default_password_variable
            __props__.__dict__["sxp_key_chain"] = sxp_key_chain
            __props__.__dict__["sxp_key_chain_variable"] = sxp_key_chain_variable
            __props__.__dict__["sxp_log_binding_changes"] = sxp_log_binding_changes
            __props__.__dict__["sxp_log_binding_changes_variable"] = sxp_log_binding_changes_variable
            __props__.__dict__["sxp_node_id"] = sxp_node_id
            __props__.__dict__["sxp_node_id_type"] = sxp_node_id_type
            __props__.__dict__["sxp_node_id_variable"] = sxp_node_id_variable
            __props__.__dict__["sxp_reconciliation_period"] = sxp_reconciliation_period
            __props__.__dict__["sxp_reconciliation_period_variable"] = sxp_reconciliation_period_variable
            __props__.__dict__["sxp_retry_period"] = sxp_retry_period
            __props__.__dict__["sxp_retry_period_variable"] = sxp_retry_period_variable
            __props__.__dict__["sxp_source_ip"] = sxp_source_ip
            __props__.__dict__["sxp_source_ip_variable"] = sxp_source_ip_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoTrustsecFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoTrustsecFeatureTemplate:CiscoTrustsecFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials_id: Optional[pulumi.Input[str]] = None,
            credentials_id_variable: Optional[pulumi.Input[str]] = None,
            credentials_password: Optional[pulumi.Input[str]] = None,
            credentials_password_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_sgt: Optional[pulumi.Input[int]] = None,
            device_sgt_variable: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_enforcement: Optional[pulumi.Input[bool]] = None,
            enable_enforcement_variable: Optional[pulumi.Input[str]] = None,
            enable_sxp: Optional[pulumi.Input[bool]] = None,
            maximum_listener_hold_time: Optional[pulumi.Input[int]] = None,
            maximum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
            minimum_listener_hold_time: Optional[pulumi.Input[int]] = None,
            minimum_listener_hold_time_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            speaker_hold_time: Optional[pulumi.Input[int]] = None,
            speaker_hold_time_variable: Optional[pulumi.Input[str]] = None,
            sxp_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoTrustsecFeatureTemplateSxpConnectionArgs', 'CiscoTrustsecFeatureTemplateSxpConnectionArgsDict']]]]] = None,
            sxp_default_password: Optional[pulumi.Input[str]] = None,
            sxp_default_password_variable: Optional[pulumi.Input[str]] = None,
            sxp_key_chain: Optional[pulumi.Input[str]] = None,
            sxp_key_chain_variable: Optional[pulumi.Input[str]] = None,
            sxp_log_binding_changes: Optional[pulumi.Input[bool]] = None,
            sxp_log_binding_changes_variable: Optional[pulumi.Input[str]] = None,
            sxp_node_id: Optional[pulumi.Input[str]] = None,
            sxp_node_id_type: Optional[pulumi.Input[str]] = None,
            sxp_node_id_variable: Optional[pulumi.Input[str]] = None,
            sxp_reconciliation_period: Optional[pulumi.Input[int]] = None,
            sxp_reconciliation_period_variable: Optional[pulumi.Input[str]] = None,
            sxp_retry_period: Optional[pulumi.Input[int]] = None,
            sxp_retry_period_variable: Optional[pulumi.Input[str]] = None,
            sxp_source_ip: Optional[pulumi.Input[str]] = None,
            sxp_source_ip_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoTrustsecFeatureTemplate':
        """
        Get an existing CiscoTrustsecFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] credentials_id: Specify the TrustSec Network Access Device ID, should be same as mentioned in the Identity Services Engine (upto 32
               char)
        :param pulumi.Input[str] credentials_id_variable: Variable name
        :param pulumi.Input[str] credentials_password: Set the password for the device
        :param pulumi.Input[str] credentials_password_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[int] device_sgt: Configure Local device security group <2..65519> - Range: `2`-`65519`
        :param pulumi.Input[str] device_sgt_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] enable_enforcement: Enable Role-based Access Control enforcement - Default value: `false`
        :param pulumi.Input[str] enable_enforcement_variable: Variable name
        :param pulumi.Input[bool] enable_sxp: Enable CTS SXP support - Default value: `false`
        :param pulumi.Input[int] maximum_listener_hold_time: Configure Maximum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `180`
        :param pulumi.Input[str] maximum_listener_hold_time_variable: Variable name
        :param pulumi.Input[int] minimum_listener_hold_time: Configure Minimum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `90`
        :param pulumi.Input[str] minimum_listener_hold_time_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] speaker_hold_time: Configure Speaker hold-time in seconds <1..65534> - Range: `1`-`65534` - Default value: `120`
        :param pulumi.Input[str] speaker_hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoTrustsecFeatureTemplateSxpConnectionArgs', 'CiscoTrustsecFeatureTemplateSxpConnectionArgsDict']]]] sxp_connections: Configure SXP Connections
        :param pulumi.Input[str] sxp_default_password: Configure SXP default password
        :param pulumi.Input[str] sxp_default_password_variable: Variable name
        :param pulumi.Input[str] sxp_key_chain: Configure SXP key-chain
        :param pulumi.Input[str] sxp_key_chain_variable: Variable name
        :param pulumi.Input[bool] sxp_log_binding_changes: Enables logging for IP-to-SGT binding changes - Default value: `false`
        :param pulumi.Input[str] sxp_log_binding_changes_variable: Variable name
        :param pulumi.Input[str] sxp_node_id: Configure SXP Node ID <IP, 8 char string or interface name>
        :param pulumi.Input[str] sxp_node_id_type: Define SXP Node ID type <IP, 8 char string or interface name> - Choices: `ip`, `interface-name`, `8-char-hex-string` -
               Default value: `ip`
        :param pulumi.Input[str] sxp_node_id_variable: Variable name
        :param pulumi.Input[int] sxp_reconciliation_period: Configure the SXP reconciliation period in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_reconciliation_period_variable: Variable name
        :param pulumi.Input[int] sxp_retry_period: Configure Retry period for SXP connection in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        :param pulumi.Input[str] sxp_retry_period_variable: Variable name
        :param pulumi.Input[str] sxp_source_ip: SXP Source IP
        :param pulumi.Input[str] sxp_source_ip_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoTrustsecFeatureTemplateState.__new__(_CiscoTrustsecFeatureTemplateState)

        __props__.__dict__["credentials_id"] = credentials_id
        __props__.__dict__["credentials_id_variable"] = credentials_id_variable
        __props__.__dict__["credentials_password"] = credentials_password
        __props__.__dict__["credentials_password_variable"] = credentials_password_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_sgt"] = device_sgt
        __props__.__dict__["device_sgt_variable"] = device_sgt_variable
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["enable_enforcement"] = enable_enforcement
        __props__.__dict__["enable_enforcement_variable"] = enable_enforcement_variable
        __props__.__dict__["enable_sxp"] = enable_sxp
        __props__.__dict__["maximum_listener_hold_time"] = maximum_listener_hold_time
        __props__.__dict__["maximum_listener_hold_time_variable"] = maximum_listener_hold_time_variable
        __props__.__dict__["minimum_listener_hold_time"] = minimum_listener_hold_time
        __props__.__dict__["minimum_listener_hold_time_variable"] = minimum_listener_hold_time_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["speaker_hold_time"] = speaker_hold_time
        __props__.__dict__["speaker_hold_time_variable"] = speaker_hold_time_variable
        __props__.__dict__["sxp_connections"] = sxp_connections
        __props__.__dict__["sxp_default_password"] = sxp_default_password
        __props__.__dict__["sxp_default_password_variable"] = sxp_default_password_variable
        __props__.__dict__["sxp_key_chain"] = sxp_key_chain
        __props__.__dict__["sxp_key_chain_variable"] = sxp_key_chain_variable
        __props__.__dict__["sxp_log_binding_changes"] = sxp_log_binding_changes
        __props__.__dict__["sxp_log_binding_changes_variable"] = sxp_log_binding_changes_variable
        __props__.__dict__["sxp_node_id"] = sxp_node_id
        __props__.__dict__["sxp_node_id_type"] = sxp_node_id_type
        __props__.__dict__["sxp_node_id_variable"] = sxp_node_id_variable
        __props__.__dict__["sxp_reconciliation_period"] = sxp_reconciliation_period
        __props__.__dict__["sxp_reconciliation_period_variable"] = sxp_reconciliation_period_variable
        __props__.__dict__["sxp_retry_period"] = sxp_retry_period
        __props__.__dict__["sxp_retry_period_variable"] = sxp_retry_period_variable
        __props__.__dict__["sxp_source_ip"] = sxp_source_ip
        __props__.__dict__["sxp_source_ip_variable"] = sxp_source_ip_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CiscoTrustsecFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specify the TrustSec Network Access Device ID, should be same as mentioned in the Identity Services Engine (upto 32
        char)
        """
        return pulumi.get(self, "credentials_id")

    @property
    @pulumi.getter(name="credentialsIdVariable")
    def credentials_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "credentials_id_variable")

    @property
    @pulumi.getter(name="credentialsPassword")
    def credentials_password(self) -> pulumi.Output[Optional[str]]:
        """
        Set the password for the device
        """
        return pulumi.get(self, "credentials_password")

    @property
    @pulumi.getter(name="credentialsPasswordVariable")
    def credentials_password_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "credentials_password_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceSgt")
    def device_sgt(self) -> pulumi.Output[Optional[int]]:
        """
        Configure Local device security group <2..65519> - Range: `2`-`65519`
        """
        return pulumi.get(self, "device_sgt")

    @property
    @pulumi.getter(name="deviceSgtVariable")
    def device_sgt_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "device_sgt_variable")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="enableEnforcement")
    def enable_enforcement(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Role-based Access Control enforcement - Default value: `false`
        """
        return pulumi.get(self, "enable_enforcement")

    @property
    @pulumi.getter(name="enableEnforcementVariable")
    def enable_enforcement_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_enforcement_variable")

    @property
    @pulumi.getter(name="enableSxp")
    def enable_sxp(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable CTS SXP support - Default value: `false`
        """
        return pulumi.get(self, "enable_sxp")

    @property
    @pulumi.getter(name="maximumListenerHoldTime")
    def maximum_listener_hold_time(self) -> pulumi.Output[Optional[int]]:
        """
        Configure Maximum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `180`
        """
        return pulumi.get(self, "maximum_listener_hold_time")

    @property
    @pulumi.getter(name="maximumListenerHoldTimeVariable")
    def maximum_listener_hold_time_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "maximum_listener_hold_time_variable")

    @property
    @pulumi.getter(name="minimumListenerHoldTime")
    def minimum_listener_hold_time(self) -> pulumi.Output[Optional[int]]:
        """
        Configure Minimum allowed hold-time for listener in seconds <1..65534> - Range: `1`-`65534` - Default value: `90`
        """
        return pulumi.get(self, "minimum_listener_hold_time")

    @property
    @pulumi.getter(name="minimumListenerHoldTimeVariable")
    def minimum_listener_hold_time_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "minimum_listener_hold_time_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="speakerHoldTime")
    def speaker_hold_time(self) -> pulumi.Output[Optional[int]]:
        """
        Configure Speaker hold-time in seconds <1..65534> - Range: `1`-`65534` - Default value: `120`
        """
        return pulumi.get(self, "speaker_hold_time")

    @property
    @pulumi.getter(name="speakerHoldTimeVariable")
    def speaker_hold_time_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "speaker_hold_time_variable")

    @property
    @pulumi.getter(name="sxpConnections")
    def sxp_connections(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoTrustsecFeatureTemplateSxpConnection']]]:
        """
        Configure SXP Connections
        """
        return pulumi.get(self, "sxp_connections")

    @property
    @pulumi.getter(name="sxpDefaultPassword")
    def sxp_default_password(self) -> pulumi.Output[Optional[str]]:
        """
        Configure SXP default password
        """
        return pulumi.get(self, "sxp_default_password")

    @property
    @pulumi.getter(name="sxpDefaultPasswordVariable")
    def sxp_default_password_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_default_password_variable")

    @property
    @pulumi.getter(name="sxpKeyChain")
    def sxp_key_chain(self) -> pulumi.Output[Optional[str]]:
        """
        Configure SXP key-chain
        """
        return pulumi.get(self, "sxp_key_chain")

    @property
    @pulumi.getter(name="sxpKeyChainVariable")
    def sxp_key_chain_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_key_chain_variable")

    @property
    @pulumi.getter(name="sxpLogBindingChanges")
    def sxp_log_binding_changes(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables logging for IP-to-SGT binding changes - Default value: `false`
        """
        return pulumi.get(self, "sxp_log_binding_changes")

    @property
    @pulumi.getter(name="sxpLogBindingChangesVariable")
    def sxp_log_binding_changes_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_log_binding_changes_variable")

    @property
    @pulumi.getter(name="sxpNodeId")
    def sxp_node_id(self) -> pulumi.Output[Optional[str]]:
        """
        Configure SXP Node ID <IP, 8 char string or interface name>
        """
        return pulumi.get(self, "sxp_node_id")

    @property
    @pulumi.getter(name="sxpNodeIdType")
    def sxp_node_id_type(self) -> pulumi.Output[Optional[str]]:
        """
        Define SXP Node ID type <IP, 8 char string or interface name> - Choices: `ip`, `interface-name`, `8-char-hex-string` -
        Default value: `ip`
        """
        return pulumi.get(self, "sxp_node_id_type")

    @property
    @pulumi.getter(name="sxpNodeIdVariable")
    def sxp_node_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_node_id_variable")

    @property
    @pulumi.getter(name="sxpReconciliationPeriod")
    def sxp_reconciliation_period(self) -> pulumi.Output[Optional[int]]:
        """
        Configure the SXP reconciliation period in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        """
        return pulumi.get(self, "sxp_reconciliation_period")

    @property
    @pulumi.getter(name="sxpReconciliationPeriodVariable")
    def sxp_reconciliation_period_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_reconciliation_period_variable")

    @property
    @pulumi.getter(name="sxpRetryPeriod")
    def sxp_retry_period(self) -> pulumi.Output[Optional[int]]:
        """
        Configure Retry period for SXP connection in seconds <0..64000> - Range: `0`-`64000` - Default value: `120`
        """
        return pulumi.get(self, "sxp_retry_period")

    @property
    @pulumi.getter(name="sxpRetryPeriodVariable")
    def sxp_retry_period_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_retry_period_variable")

    @property
    @pulumi.getter(name="sxpSourceIp")
    def sxp_source_ip(self) -> pulumi.Output[Optional[str]]:
        """
        SXP Source IP
        """
        return pulumi.get(self, "sxp_source_ip")

    @property
    @pulumi.getter(name="sxpSourceIpVariable")
    def sxp_source_ip_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sxp_source_ip_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

