# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoWirelessLanFeatureTemplateArgs', 'CiscoWirelessLanFeatureTemplate']

@pulumi.input_type
class CiscoWirelessLanFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 controller_default_gateway: Optional[pulumi.Input[str]] = None,
                 controller_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 controller_ip_address: Optional[pulumi.Input[str]] = None,
                 controller_ip_address_variable: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask_variable: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 country_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_variable: Optional[pulumi.Input[str]] = None,
                 shutdown24ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown24ghz_variable: Optional[pulumi.Input[str]] = None,
                 shutdown5ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown5ghz_variable: Optional[pulumi.Input[str]] = None,
                 ssids: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoWirelessLanFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] controller_default_gateway: Set mobile express default gateway - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_default_gateway_variable: Variable name
        :param pulumi.Input[str] controller_ip_address: Set mobile express controller address - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_ip_address_variable: Variable name
        :param pulumi.Input[str] controller_subnet_mask: Set mobile express controller subnet mask - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_subnet_mask_variable: Variable name
        :param pulumi.Input[str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[str] country_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] password: Set management password
        :param pulumi.Input[str] password_variable: Variable name
        :param pulumi.Input[bool] shutdown24ghz: 2.4GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown24ghz_variable: Variable name
        :param pulumi.Input[bool] shutdown5ghz: 5GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown5ghz_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]] ssids: Configure Wi-Fi SSID
        :param pulumi.Input[str] username: Set management username
        :param pulumi.Input[str] username_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if controller_default_gateway is not None:
            pulumi.set(__self__, "controller_default_gateway", controller_default_gateway)
        if controller_default_gateway_variable is not None:
            pulumi.set(__self__, "controller_default_gateway_variable", controller_default_gateway_variable)
        if controller_ip_address is not None:
            pulumi.set(__self__, "controller_ip_address", controller_ip_address)
        if controller_ip_address_variable is not None:
            pulumi.set(__self__, "controller_ip_address_variable", controller_ip_address_variable)
        if controller_subnet_mask is not None:
            pulumi.set(__self__, "controller_subnet_mask", controller_subnet_mask)
        if controller_subnet_mask_variable is not None:
            pulumi.set(__self__, "controller_subnet_mask_variable", controller_subnet_mask_variable)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if country_variable is not None:
            pulumi.set(__self__, "country_variable", country_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_variable is not None:
            pulumi.set(__self__, "password_variable", password_variable)
        if shutdown24ghz is not None:
            pulumi.set(__self__, "shutdown24ghz", shutdown24ghz)
        if shutdown24ghz_variable is not None:
            pulumi.set(__self__, "shutdown24ghz_variable", shutdown24ghz_variable)
        if shutdown5ghz is not None:
            pulumi.set(__self__, "shutdown5ghz", shutdown5ghz)
        if shutdown5ghz_variable is not None:
            pulumi.set(__self__, "shutdown5ghz_variable", shutdown5ghz_variable)
        if ssids is not None:
            pulumi.set(__self__, "ssids", ssids)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_variable is not None:
            pulumi.set(__self__, "username_variable", username_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="controllerDefaultGateway")
    def controller_default_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        Set mobile express default gateway - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_default_gateway")

    @controller_default_gateway.setter
    def controller_default_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_default_gateway", value)

    @property
    @pulumi.getter(name="controllerDefaultGatewayVariable")
    def controller_default_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_default_gateway_variable")

    @controller_default_gateway_variable.setter
    def controller_default_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_default_gateway_variable", value)

    @property
    @pulumi.getter(name="controllerIpAddress")
    def controller_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Set mobile express controller address - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_ip_address")

    @controller_ip_address.setter
    def controller_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_ip_address", value)

    @property
    @pulumi.getter(name="controllerIpAddressVariable")
    def controller_ip_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_ip_address_variable")

    @controller_ip_address_variable.setter
    def controller_ip_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_ip_address_variable", value)

    @property
    @pulumi.getter(name="controllerSubnetMask")
    def controller_subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Set mobile express controller subnet mask - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_subnet_mask")

    @controller_subnet_mask.setter
    def controller_subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_subnet_mask", value)

    @property
    @pulumi.getter(name="controllerSubnetMaskVariable")
    def controller_subnet_mask_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_subnet_mask_variable")

    @controller_subnet_mask_variable.setter
    def controller_subnet_mask_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_subnet_mask_variable", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
        `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
        `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
        `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
        `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
        `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="countryVariable")
    def country_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "country_variable")

    @country_variable.setter
    def country_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Set management password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordVariable")
    def password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "password_variable")

    @password_variable.setter
    def password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_variable", value)

    @property
    @pulumi.getter
    def shutdown24ghz(self) -> Optional[pulumi.Input[bool]]:
        """
        2.4GHz Shutdown - Default value: `false`
        """
        return pulumi.get(self, "shutdown24ghz")

    @shutdown24ghz.setter
    def shutdown24ghz(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown24ghz", value)

    @property
    @pulumi.getter(name="shutdown24ghzVariable")
    def shutdown24ghz_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown24ghz_variable")

    @shutdown24ghz_variable.setter
    def shutdown24ghz_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown24ghz_variable", value)

    @property
    @pulumi.getter
    def shutdown5ghz(self) -> Optional[pulumi.Input[bool]]:
        """
        5GHz Shutdown - Default value: `false`
        """
        return pulumi.get(self, "shutdown5ghz")

    @shutdown5ghz.setter
    def shutdown5ghz(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown5ghz", value)

    @property
    @pulumi.getter(name="shutdown5ghzVariable")
    def shutdown5ghz_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown5ghz_variable")

    @shutdown5ghz_variable.setter
    def shutdown5ghz_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown5ghz_variable", value)

    @property
    @pulumi.getter
    def ssids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]]]:
        """
        Configure Wi-Fi SSID
        """
        return pulumi.get(self, "ssids")

    @ssids.setter
    def ssids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]]]):
        pulumi.set(self, "ssids", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Set management username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="usernameVariable")
    def username_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "username_variable")

    @username_variable.setter
    def username_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_variable", value)


@pulumi.input_type
class _CiscoWirelessLanFeatureTemplateState:
    def __init__(__self__, *,
                 controller_default_gateway: Optional[pulumi.Input[str]] = None,
                 controller_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 controller_ip_address: Optional[pulumi.Input[str]] = None,
                 controller_ip_address_variable: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask_variable: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 country_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_variable: Optional[pulumi.Input[str]] = None,
                 shutdown24ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown24ghz_variable: Optional[pulumi.Input[str]] = None,
                 shutdown5ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown5ghz_variable: Optional[pulumi.Input[str]] = None,
                 ssids: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoWirelessLanFeatureTemplate resources.
        :param pulumi.Input[str] controller_default_gateway: Set mobile express default gateway - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_default_gateway_variable: Variable name
        :param pulumi.Input[str] controller_ip_address: Set mobile express controller address - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_ip_address_variable: Variable name
        :param pulumi.Input[str] controller_subnet_mask: Set mobile express controller subnet mask - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_subnet_mask_variable: Variable name
        :param pulumi.Input[str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[str] country_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] password: Set management password
        :param pulumi.Input[str] password_variable: Variable name
        :param pulumi.Input[bool] shutdown24ghz: 2.4GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown24ghz_variable: Variable name
        :param pulumi.Input[bool] shutdown5ghz: 5GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown5ghz_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]] ssids: Configure Wi-Fi SSID
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] username: Set management username
        :param pulumi.Input[str] username_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        if controller_default_gateway is not None:
            pulumi.set(__self__, "controller_default_gateway", controller_default_gateway)
        if controller_default_gateway_variable is not None:
            pulumi.set(__self__, "controller_default_gateway_variable", controller_default_gateway_variable)
        if controller_ip_address is not None:
            pulumi.set(__self__, "controller_ip_address", controller_ip_address)
        if controller_ip_address_variable is not None:
            pulumi.set(__self__, "controller_ip_address_variable", controller_ip_address_variable)
        if controller_subnet_mask is not None:
            pulumi.set(__self__, "controller_subnet_mask", controller_subnet_mask)
        if controller_subnet_mask_variable is not None:
            pulumi.set(__self__, "controller_subnet_mask_variable", controller_subnet_mask_variable)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if country_variable is not None:
            pulumi.set(__self__, "country_variable", country_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_variable is not None:
            pulumi.set(__self__, "password_variable", password_variable)
        if shutdown24ghz is not None:
            pulumi.set(__self__, "shutdown24ghz", shutdown24ghz)
        if shutdown24ghz_variable is not None:
            pulumi.set(__self__, "shutdown24ghz_variable", shutdown24ghz_variable)
        if shutdown5ghz is not None:
            pulumi.set(__self__, "shutdown5ghz", shutdown5ghz)
        if shutdown5ghz_variable is not None:
            pulumi.set(__self__, "shutdown5ghz_variable", shutdown5ghz_variable)
        if ssids is not None:
            pulumi.set(__self__, "ssids", ssids)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_variable is not None:
            pulumi.set(__self__, "username_variable", username_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="controllerDefaultGateway")
    def controller_default_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        Set mobile express default gateway - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_default_gateway")

    @controller_default_gateway.setter
    def controller_default_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_default_gateway", value)

    @property
    @pulumi.getter(name="controllerDefaultGatewayVariable")
    def controller_default_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_default_gateway_variable")

    @controller_default_gateway_variable.setter
    def controller_default_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_default_gateway_variable", value)

    @property
    @pulumi.getter(name="controllerIpAddress")
    def controller_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Set mobile express controller address - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_ip_address")

    @controller_ip_address.setter
    def controller_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_ip_address", value)

    @property
    @pulumi.getter(name="controllerIpAddressVariable")
    def controller_ip_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_ip_address_variable")

    @controller_ip_address_variable.setter
    def controller_ip_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_ip_address_variable", value)

    @property
    @pulumi.getter(name="controllerSubnetMask")
    def controller_subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Set mobile express controller subnet mask - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_subnet_mask")

    @controller_subnet_mask.setter
    def controller_subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_subnet_mask", value)

    @property
    @pulumi.getter(name="controllerSubnetMaskVariable")
    def controller_subnet_mask_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_subnet_mask_variable")

    @controller_subnet_mask_variable.setter
    def controller_subnet_mask_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_subnet_mask_variable", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
        `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
        `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
        `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
        `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
        `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="countryVariable")
    def country_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "country_variable")

    @country_variable.setter
    def country_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Set management password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordVariable")
    def password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "password_variable")

    @password_variable.setter
    def password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_variable", value)

    @property
    @pulumi.getter
    def shutdown24ghz(self) -> Optional[pulumi.Input[bool]]:
        """
        2.4GHz Shutdown - Default value: `false`
        """
        return pulumi.get(self, "shutdown24ghz")

    @shutdown24ghz.setter
    def shutdown24ghz(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown24ghz", value)

    @property
    @pulumi.getter(name="shutdown24ghzVariable")
    def shutdown24ghz_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown24ghz_variable")

    @shutdown24ghz_variable.setter
    def shutdown24ghz_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown24ghz_variable", value)

    @property
    @pulumi.getter
    def shutdown5ghz(self) -> Optional[pulumi.Input[bool]]:
        """
        5GHz Shutdown - Default value: `false`
        """
        return pulumi.get(self, "shutdown5ghz")

    @shutdown5ghz.setter
    def shutdown5ghz(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown5ghz", value)

    @property
    @pulumi.getter(name="shutdown5ghzVariable")
    def shutdown5ghz_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown5ghz_variable")

    @shutdown5ghz_variable.setter
    def shutdown5ghz_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown5ghz_variable", value)

    @property
    @pulumi.getter
    def ssids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]]]:
        """
        Configure Wi-Fi SSID
        """
        return pulumi.get(self, "ssids")

    @ssids.setter
    def ssids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoWirelessLanFeatureTemplateSsidArgs']]]]):
        pulumi.set(self, "ssids", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Set management username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="usernameVariable")
    def username_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "username_variable")

    @username_variable.setter
    def username_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoWirelessLanFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 controller_default_gateway: Optional[pulumi.Input[str]] = None,
                 controller_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 controller_ip_address: Optional[pulumi.Input[str]] = None,
                 controller_ip_address_variable: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask_variable: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 country_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_variable: Optional[pulumi.Input[str]] = None,
                 shutdown24ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown24ghz_variable: Optional[pulumi.Input[str]] = None,
                 shutdown5ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown5ghz_variable: Optional[pulumi.Input[str]] = None,
                 ssids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoWirelessLanFeatureTemplateSsidArgs', 'CiscoWirelessLanFeatureTemplateSsidArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco Wireless LAN feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoWirelessLanFeatureTemplate:CiscoWirelessLanFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] controller_default_gateway: Set mobile express default gateway - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_default_gateway_variable: Variable name
        :param pulumi.Input[str] controller_ip_address: Set mobile express controller address - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_ip_address_variable: Variable name
        :param pulumi.Input[str] controller_subnet_mask: Set mobile express controller subnet mask - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_subnet_mask_variable: Variable name
        :param pulumi.Input[str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[str] country_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] password: Set management password
        :param pulumi.Input[str] password_variable: Variable name
        :param pulumi.Input[bool] shutdown24ghz: 2.4GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown24ghz_variable: Variable name
        :param pulumi.Input[bool] shutdown5ghz: 5GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown5ghz_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoWirelessLanFeatureTemplateSsidArgs', 'CiscoWirelessLanFeatureTemplateSsidArgsDict']]]] ssids: Configure Wi-Fi SSID
        :param pulumi.Input[str] username: Set management username
        :param pulumi.Input[str] username_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoWirelessLanFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco Wireless LAN feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoWirelessLanFeatureTemplate:CiscoWirelessLanFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoWirelessLanFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoWirelessLanFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 controller_default_gateway: Optional[pulumi.Input[str]] = None,
                 controller_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 controller_ip_address: Optional[pulumi.Input[str]] = None,
                 controller_ip_address_variable: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask: Optional[pulumi.Input[str]] = None,
                 controller_subnet_mask_variable: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 country_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_variable: Optional[pulumi.Input[str]] = None,
                 shutdown24ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown24ghz_variable: Optional[pulumi.Input[str]] = None,
                 shutdown5ghz: Optional[pulumi.Input[bool]] = None,
                 shutdown5ghz_variable: Optional[pulumi.Input[str]] = None,
                 ssids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoWirelessLanFeatureTemplateSsidArgs', 'CiscoWirelessLanFeatureTemplateSsidArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoWirelessLanFeatureTemplateArgs.__new__(CiscoWirelessLanFeatureTemplateArgs)

            __props__.__dict__["controller_default_gateway"] = controller_default_gateway
            __props__.__dict__["controller_default_gateway_variable"] = controller_default_gateway_variable
            __props__.__dict__["controller_ip_address"] = controller_ip_address
            __props__.__dict__["controller_ip_address_variable"] = controller_ip_address_variable
            __props__.__dict__["controller_subnet_mask"] = controller_subnet_mask
            __props__.__dict__["controller_subnet_mask_variable"] = controller_subnet_mask_variable
            __props__.__dict__["country"] = country
            __props__.__dict__["country_variable"] = country_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = password
            __props__.__dict__["password_variable"] = password_variable
            __props__.__dict__["shutdown24ghz"] = shutdown24ghz
            __props__.__dict__["shutdown24ghz_variable"] = shutdown24ghz_variable
            __props__.__dict__["shutdown5ghz"] = shutdown5ghz
            __props__.__dict__["shutdown5ghz_variable"] = shutdown5ghz_variable
            __props__.__dict__["ssids"] = ssids
            __props__.__dict__["username"] = username
            __props__.__dict__["username_variable"] = username_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoWirelessLanFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoWirelessLanFeatureTemplate:CiscoWirelessLanFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            controller_default_gateway: Optional[pulumi.Input[str]] = None,
            controller_default_gateway_variable: Optional[pulumi.Input[str]] = None,
            controller_ip_address: Optional[pulumi.Input[str]] = None,
            controller_ip_address_variable: Optional[pulumi.Input[str]] = None,
            controller_subnet_mask: Optional[pulumi.Input[str]] = None,
            controller_subnet_mask_variable: Optional[pulumi.Input[str]] = None,
            country: Optional[pulumi.Input[str]] = None,
            country_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_variable: Optional[pulumi.Input[str]] = None,
            shutdown24ghz: Optional[pulumi.Input[bool]] = None,
            shutdown24ghz_variable: Optional[pulumi.Input[str]] = None,
            shutdown5ghz: Optional[pulumi.Input[bool]] = None,
            shutdown5ghz_variable: Optional[pulumi.Input[str]] = None,
            ssids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoWirelessLanFeatureTemplateSsidArgs', 'CiscoWirelessLanFeatureTemplateSsidArgsDict']]]]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            username_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoWirelessLanFeatureTemplate':
        """
        Get an existing CiscoWirelessLanFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] controller_default_gateway: Set mobile express default gateway - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_default_gateway_variable: Variable name
        :param pulumi.Input[str] controller_ip_address: Set mobile express controller address - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_ip_address_variable: Variable name
        :param pulumi.Input[str] controller_subnet_mask: Set mobile express controller subnet mask - Default value: `0.0.0.0`
        :param pulumi.Input[str] controller_subnet_mask_variable: Variable name
        :param pulumi.Input[str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[str] country_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] password: Set management password
        :param pulumi.Input[str] password_variable: Variable name
        :param pulumi.Input[bool] shutdown24ghz: 2.4GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown24ghz_variable: Variable name
        :param pulumi.Input[bool] shutdown5ghz: 5GHz Shutdown - Default value: `false`
        :param pulumi.Input[str] shutdown5ghz_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoWirelessLanFeatureTemplateSsidArgs', 'CiscoWirelessLanFeatureTemplateSsidArgsDict']]]] ssids: Configure Wi-Fi SSID
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] username: Set management username
        :param pulumi.Input[str] username_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoWirelessLanFeatureTemplateState.__new__(_CiscoWirelessLanFeatureTemplateState)

        __props__.__dict__["controller_default_gateway"] = controller_default_gateway
        __props__.__dict__["controller_default_gateway_variable"] = controller_default_gateway_variable
        __props__.__dict__["controller_ip_address"] = controller_ip_address
        __props__.__dict__["controller_ip_address_variable"] = controller_ip_address_variable
        __props__.__dict__["controller_subnet_mask"] = controller_subnet_mask
        __props__.__dict__["controller_subnet_mask_variable"] = controller_subnet_mask_variable
        __props__.__dict__["country"] = country
        __props__.__dict__["country_variable"] = country_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["password_variable"] = password_variable
        __props__.__dict__["shutdown24ghz"] = shutdown24ghz
        __props__.__dict__["shutdown24ghz_variable"] = shutdown24ghz_variable
        __props__.__dict__["shutdown5ghz"] = shutdown5ghz
        __props__.__dict__["shutdown5ghz_variable"] = shutdown5ghz_variable
        __props__.__dict__["ssids"] = ssids
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["username"] = username
        __props__.__dict__["username_variable"] = username_variable
        __props__.__dict__["version"] = version
        return CiscoWirelessLanFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="controllerDefaultGateway")
    def controller_default_gateway(self) -> pulumi.Output[Optional[str]]:
        """
        Set mobile express default gateway - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_default_gateway")

    @property
    @pulumi.getter(name="controllerDefaultGatewayVariable")
    def controller_default_gateway_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_default_gateway_variable")

    @property
    @pulumi.getter(name="controllerIpAddress")
    def controller_ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        Set mobile express controller address - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_ip_address")

    @property
    @pulumi.getter(name="controllerIpAddressVariable")
    def controller_ip_address_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_ip_address_variable")

    @property
    @pulumi.getter(name="controllerSubnetMask")
    def controller_subnet_mask(self) -> pulumi.Output[Optional[str]]:
        """
        Set mobile express controller subnet mask - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "controller_subnet_mask")

    @property
    @pulumi.getter(name="controllerSubnetMaskVariable")
    def controller_subnet_mask_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_subnet_mask_variable")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[str]]:
        """
        Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
        `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
        `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
        `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
        `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
        `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="countryVariable")
    def country_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "country_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Set management password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordVariable")
    def password_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "password_variable")

    @property
    @pulumi.getter
    def shutdown24ghz(self) -> pulumi.Output[Optional[bool]]:
        """
        2.4GHz Shutdown - Default value: `false`
        """
        return pulumi.get(self, "shutdown24ghz")

    @property
    @pulumi.getter(name="shutdown24ghzVariable")
    def shutdown24ghz_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown24ghz_variable")

    @property
    @pulumi.getter
    def shutdown5ghz(self) -> pulumi.Output[Optional[bool]]:
        """
        5GHz Shutdown - Default value: `false`
        """
        return pulumi.get(self, "shutdown5ghz")

    @property
    @pulumi.getter(name="shutdown5ghzVariable")
    def shutdown5ghz_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown5ghz_variable")

    @property
    @pulumi.getter
    def ssids(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoWirelessLanFeatureTemplateSsid']]]:
        """
        Configure Wi-Fi SSID
        """
        return pulumi.get(self, "ssids")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        Set management username
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameVariable")
    def username_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "username_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

