# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationGroupDeployArgs', 'ConfigurationGroupDeploy']

@pulumi.input_type
class ConfigurationGroupDeployArgs:
    def __init__(__self__, *,
                 configuration_group_id: pulumi.Input[str],
                 devices: pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]]):
        """
        The set of arguments for constructing a ConfigurationGroupDeploy resource.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]] devices: List of devices
        """
        pulumi.set(__self__, "configuration_group_id", configuration_group_id)
        pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter(name="configurationGroupId")
    def configuration_group_id(self) -> pulumi.Input[str]:
        """
        Configuration Group ID
        """
        return pulumi.get(self, "configuration_group_id")

    @configuration_group_id.setter
    def configuration_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_group_id", value)

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]]):
        pulumi.set(self, "devices", value)


@pulumi.input_type
class _ConfigurationGroupDeployState:
    def __init__(__self__, *,
                 configuration_group_id: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]]] = None):
        """
        Input properties used for looking up and filtering ConfigurationGroupDeploy resources.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]] devices: List of devices
        """
        if configuration_group_id is not None:
            pulumi.set(__self__, "configuration_group_id", configuration_group_id)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter(name="configurationGroupId")
    def configuration_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration Group ID
        """
        return pulumi.get(self, "configuration_group_id")

    @configuration_group_id.setter
    def configuration_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_group_id", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]]]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeployDeviceArgs']]]]):
        pulumi.set(self, "devices", value)


class ConfigurationGroupDeploy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_group_id: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeployDeviceArgs', 'ConfigurationGroupDeployDeviceArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Configuration Group Deploy .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ConfigurationGroupDeploy("example",
            configuration_group_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            devices=[{
                "id": "C8K-15411CCC-D476-0B3B-21F2-5D6AC387EE7B",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeployDeviceArgs', 'ConfigurationGroupDeployDeviceArgsDict']]]] devices: List of devices
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationGroupDeployArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Configuration Group Deploy .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ConfigurationGroupDeploy("example",
            configuration_group_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            devices=[{
                "id": "C8K-15411CCC-D476-0B3B-21F2-5D6AC387EE7B",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationGroupDeployArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationGroupDeployArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_group_id: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeployDeviceArgs', 'ConfigurationGroupDeployDeviceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationGroupDeployArgs.__new__(ConfigurationGroupDeployArgs)

            if configuration_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_group_id'")
            __props__.__dict__["configuration_group_id"] = configuration_group_id
            if devices is None and not opts.urn:
                raise TypeError("Missing required property 'devices'")
            __props__.__dict__["devices"] = devices
        super(ConfigurationGroupDeploy, __self__).__init__(
            'sdwan:index/configurationGroupDeploy:ConfigurationGroupDeploy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_group_id: Optional[pulumi.Input[str]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeployDeviceArgs', 'ConfigurationGroupDeployDeviceArgsDict']]]]] = None) -> 'ConfigurationGroupDeploy':
        """
        Get an existing ConfigurationGroupDeploy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeployDeviceArgs', 'ConfigurationGroupDeployDeviceArgsDict']]]] devices: List of devices
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationGroupDeployState.__new__(_ConfigurationGroupDeployState)

        __props__.__dict__["configuration_group_id"] = configuration_group_id
        __props__.__dict__["devices"] = devices
        return ConfigurationGroupDeploy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationGroupId")
    def configuration_group_id(self) -> pulumi.Output[str]:
        """
        Configuration Group ID
        """
        return pulumi.get(self, "configuration_group_id")

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Sequence['outputs.ConfigurationGroupDeployDevice']]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

