# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationGroupDeviceVariablesArgs', 'ConfigurationGroupDeviceVariables']

@pulumi.input_type
class ConfigurationGroupDeviceVariablesArgs:
    def __init__(__self__, *,
                 configuration_group_id: pulumi.Input[str],
                 devices: pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]],
                 solution: pulumi.Input[str],
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]]] = None):
        """
        The set of arguments for constructing a ConfigurationGroupDeviceVariables resource.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]] devices: List of devices
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]] groups: List of device groups
        """
        pulumi.set(__self__, "configuration_group_id", configuration_group_id)
        pulumi.set(__self__, "devices", devices)
        pulumi.set(__self__, "solution", solution)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter(name="configurationGroupId")
    def configuration_group_id(self) -> pulumi.Input[str]:
        """
        Configuration Group ID
        """
        return pulumi.get(self, "configuration_group_id")

    @configuration_group_id.setter
    def configuration_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_group_id", value)

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def solution(self) -> pulumi.Input[str]:
        """
        Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        return pulumi.get(self, "solution")

    @solution.setter
    def solution(self, value: pulumi.Input[str]):
        pulumi.set(self, "solution", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]]]:
        """
        List of device groups
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]]]):
        pulumi.set(self, "groups", value)


@pulumi.input_type
class _ConfigurationGroupDeviceVariablesState:
    def __init__(__self__, *,
                 configuration_group_id: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]]] = None,
                 solution: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConfigurationGroupDeviceVariables resources.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]] devices: List of devices
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]] groups: List of device groups
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        if configuration_group_id is not None:
            pulumi.set(__self__, "configuration_group_id", configuration_group_id)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if solution is not None:
            pulumi.set(__self__, "solution", solution)

    @property
    @pulumi.getter(name="configurationGroupId")
    def configuration_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration Group ID
        """
        return pulumi.get(self, "configuration_group_id")

    @configuration_group_id.setter
    def configuration_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_group_id", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]]]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]]]:
        """
        List of device groups
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupDeviceVariablesGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def solution(self) -> Optional[pulumi.Input[str]]:
        """
        Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        return pulumi.get(self, "solution")

    @solution.setter
    def solution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "solution", value)


class ConfigurationGroupDeviceVariables(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_group_id: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesDeviceArgs', 'ConfigurationGroupDeviceVariablesDeviceArgsDict']]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesGroupArgs', 'ConfigurationGroupDeviceVariablesGroupArgsDict']]]]] = None,
                 solution: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Configuration Group Device Variables .
          - Minimum SD-WAN Manager version: `20.12.0`

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesDeviceArgs', 'ConfigurationGroupDeviceVariablesDeviceArgsDict']]]] devices: List of devices
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesGroupArgs', 'ConfigurationGroupDeviceVariablesGroupArgsDict']]]] groups: List of device groups
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationGroupDeviceVariablesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Configuration Group Device Variables .
          - Minimum SD-WAN Manager version: `20.12.0`

        :param str resource_name: The name of the resource.
        :param ConfigurationGroupDeviceVariablesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationGroupDeviceVariablesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_group_id: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesDeviceArgs', 'ConfigurationGroupDeviceVariablesDeviceArgsDict']]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesGroupArgs', 'ConfigurationGroupDeviceVariablesGroupArgsDict']]]]] = None,
                 solution: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationGroupDeviceVariablesArgs.__new__(ConfigurationGroupDeviceVariablesArgs)

            if configuration_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_group_id'")
            __props__.__dict__["configuration_group_id"] = configuration_group_id
            if devices is None and not opts.urn:
                raise TypeError("Missing required property 'devices'")
            __props__.__dict__["devices"] = devices
            __props__.__dict__["groups"] = groups
            if solution is None and not opts.urn:
                raise TypeError("Missing required property 'solution'")
            __props__.__dict__["solution"] = solution
        super(ConfigurationGroupDeviceVariables, __self__).__init__(
            'sdwan:index/configurationGroupDeviceVariables:ConfigurationGroupDeviceVariables',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_group_id: Optional[pulumi.Input[str]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesDeviceArgs', 'ConfigurationGroupDeviceVariablesDeviceArgsDict']]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesGroupArgs', 'ConfigurationGroupDeviceVariablesGroupArgsDict']]]]] = None,
            solution: Optional[pulumi.Input[str]] = None) -> 'ConfigurationGroupDeviceVariables':
        """
        Get an existing ConfigurationGroupDeviceVariables resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_group_id: Configuration Group ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesDeviceArgs', 'ConfigurationGroupDeviceVariablesDeviceArgsDict']]]] devices: List of devices
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationGroupDeviceVariablesGroupArgs', 'ConfigurationGroupDeviceVariablesGroupArgsDict']]]] groups: List of device groups
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationGroupDeviceVariablesState.__new__(_ConfigurationGroupDeviceVariablesState)

        __props__.__dict__["configuration_group_id"] = configuration_group_id
        __props__.__dict__["devices"] = devices
        __props__.__dict__["groups"] = groups
        __props__.__dict__["solution"] = solution
        return ConfigurationGroupDeviceVariables(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationGroupId")
    def configuration_group_id(self) -> pulumi.Output[str]:
        """
        Configuration Group ID
        """
        return pulumi.get(self, "configuration_group_id")

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Sequence['outputs.ConfigurationGroupDeviceVariablesDevice']]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationGroupDeviceVariablesGroup']]]:
        """
        List of device groups
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def solution(self) -> pulumi.Output[str]:
        """
        Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        return pulumi.get(self, "solution")

