# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoSecureInternetGatewayFeatureTemplateResult',
    'AwaitableGetCiscoSecureInternetGatewayFeatureTemplateResult',
    'get_cisco_secure_internet_gateway_feature_template',
    'get_cisco_secure_internet_gateway_feature_template_output',
]

@pulumi.output_type
class GetCiscoSecureInternetGatewayFeatureTemplateResult:
    """
    A collection of values returned by getCiscoSecureInternetGatewayFeatureTemplate.
    """
    def __init__(__self__, description=None, device_types=None, id=None, interfaces=None, name=None, services=None, template_type=None, tracker_source_ip=None, tracker_source_ip_variable=None, trackers=None, version=None, vpn_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interfaces and not isinstance(interfaces, list):
            raise TypeError("Expected argument 'interfaces' to be a list")
        pulumi.set(__self__, "interfaces", interfaces)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if tracker_source_ip and not isinstance(tracker_source_ip, str):
            raise TypeError("Expected argument 'tracker_source_ip' to be a str")
        pulumi.set(__self__, "tracker_source_ip", tracker_source_ip)
        if tracker_source_ip_variable and not isinstance(tracker_source_ip_variable, str):
            raise TypeError("Expected argument 'tracker_source_ip_variable' to be a str")
        pulumi.set(__self__, "tracker_source_ip_variable", tracker_source_ip_variable)
        if trackers and not isinstance(trackers, list):
            raise TypeError("Expected argument 'trackers' to be a list")
        pulumi.set(__self__, "trackers", trackers)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if vpn_id and not isinstance(vpn_id, int):
            raise TypeError("Expected argument 'vpn_id' to be a int")
        pulumi.set(__self__, "vpn_id", vpn_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetCiscoSecureInternetGatewayFeatureTemplateInterfaceResult']:
        """
        Interface name: IPsec when present
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetCiscoSecureInternetGatewayFeatureTemplateServiceResult']:
        """
        Configure services
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="trackerSourceIp")
    def tracker_source_ip(self) -> str:
        """
        Source IP address for Tracker
        """
        return pulumi.get(self, "tracker_source_ip")

    @property
    @pulumi.getter(name="trackerSourceIpVariable")
    def tracker_source_ip_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_source_ip_variable")

    @property
    @pulumi.getter
    def trackers(self) -> Sequence['outputs.GetCiscoSecureInternetGatewayFeatureTemplateTrackerResult']:
        """
        Tracker configuration
        """
        return pulumi.get(self, "trackers")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> int:
        """
        List of VPN instances
        """
        return pulumi.get(self, "vpn_id")


class AwaitableGetCiscoSecureInternetGatewayFeatureTemplateResult(GetCiscoSecureInternetGatewayFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoSecureInternetGatewayFeatureTemplateResult(
            description=self.description,
            device_types=self.device_types,
            id=self.id,
            interfaces=self.interfaces,
            name=self.name,
            services=self.services,
            template_type=self.template_type,
            tracker_source_ip=self.tracker_source_ip,
            tracker_source_ip_variable=self.tracker_source_ip_variable,
            trackers=self.trackers,
            version=self.version,
            vpn_id=self.vpn_id)


def get_cisco_secure_internet_gateway_feature_template(id: Optional[str] = None,
                                                       name: Optional[str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoSecureInternetGatewayFeatureTemplateResult:
    """
    This data source can read the Cisco Secure Internet Gateway feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_secure_internet_gateway_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoSecureInternetGatewayFeatureTemplate:getCiscoSecureInternetGatewayFeatureTemplate', __args__, opts=opts, typ=GetCiscoSecureInternetGatewayFeatureTemplateResult).value

    return AwaitableGetCiscoSecureInternetGatewayFeatureTemplateResult(
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        id=pulumi.get(__ret__, 'id'),
        interfaces=pulumi.get(__ret__, 'interfaces'),
        name=pulumi.get(__ret__, 'name'),
        services=pulumi.get(__ret__, 'services'),
        template_type=pulumi.get(__ret__, 'template_type'),
        tracker_source_ip=pulumi.get(__ret__, 'tracker_source_ip'),
        tracker_source_ip_variable=pulumi.get(__ret__, 'tracker_source_ip_variable'),
        trackers=pulumi.get(__ret__, 'trackers'),
        version=pulumi.get(__ret__, 'version'),
        vpn_id=pulumi.get(__ret__, 'vpn_id'))


@_utilities.lift_output_func(get_cisco_secure_internet_gateway_feature_template)
def get_cisco_secure_internet_gateway_feature_template_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                                              name: Optional[pulumi.Input[Optional[str]]] = None,
                                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCiscoSecureInternetGatewayFeatureTemplateResult]:
    """
    This data source can read the Cisco Secure Internet Gateway feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_secure_internet_gateway_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    ...
