# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoSecurityFeatureTemplateResult',
    'AwaitableGetCiscoSecurityFeatureTemplateResult',
    'get_cisco_security_feature_template',
    'get_cisco_security_feature_template_output',
]

@pulumi.output_type
class GetCiscoSecurityFeatureTemplateResult:
    """
    A collection of values returned by getCiscoSecurityFeatureTemplate.
    """
    def __init__(__self__, authentication_type_variable=None, authentication_types=None, description=None, device_types=None, extended_ar_window=None, extended_ar_window_variable=None, id=None, integrity_type_variable=None, integrity_types=None, keychains=None, keys=None, name=None, pairwise_keying=None, pairwise_keying_variable=None, rekey_interval=None, rekey_interval_variable=None, replay_window=None, replay_window_variable=None, template_type=None, version=None):
        if authentication_type_variable and not isinstance(authentication_type_variable, str):
            raise TypeError("Expected argument 'authentication_type_variable' to be a str")
        pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if authentication_types and not isinstance(authentication_types, list):
            raise TypeError("Expected argument 'authentication_types' to be a list")
        pulumi.set(__self__, "authentication_types", authentication_types)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if extended_ar_window and not isinstance(extended_ar_window, int):
            raise TypeError("Expected argument 'extended_ar_window' to be a int")
        pulumi.set(__self__, "extended_ar_window", extended_ar_window)
        if extended_ar_window_variable and not isinstance(extended_ar_window_variable, str):
            raise TypeError("Expected argument 'extended_ar_window_variable' to be a str")
        pulumi.set(__self__, "extended_ar_window_variable", extended_ar_window_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integrity_type_variable and not isinstance(integrity_type_variable, str):
            raise TypeError("Expected argument 'integrity_type_variable' to be a str")
        pulumi.set(__self__, "integrity_type_variable", integrity_type_variable)
        if integrity_types and not isinstance(integrity_types, list):
            raise TypeError("Expected argument 'integrity_types' to be a list")
        pulumi.set(__self__, "integrity_types", integrity_types)
        if keychains and not isinstance(keychains, list):
            raise TypeError("Expected argument 'keychains' to be a list")
        pulumi.set(__self__, "keychains", keychains)
        if keys and not isinstance(keys, list):
            raise TypeError("Expected argument 'keys' to be a list")
        pulumi.set(__self__, "keys", keys)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pairwise_keying and not isinstance(pairwise_keying, bool):
            raise TypeError("Expected argument 'pairwise_keying' to be a bool")
        pulumi.set(__self__, "pairwise_keying", pairwise_keying)
        if pairwise_keying_variable and not isinstance(pairwise_keying_variable, str):
            raise TypeError("Expected argument 'pairwise_keying_variable' to be a str")
        pulumi.set(__self__, "pairwise_keying_variable", pairwise_keying_variable)
        if rekey_interval and not isinstance(rekey_interval, int):
            raise TypeError("Expected argument 'rekey_interval' to be a int")
        pulumi.set(__self__, "rekey_interval", rekey_interval)
        if rekey_interval_variable and not isinstance(rekey_interval_variable, str):
            raise TypeError("Expected argument 'rekey_interval_variable' to be a str")
        pulumi.set(__self__, "rekey_interval_variable", rekey_interval_variable)
        if replay_window and not isinstance(replay_window, str):
            raise TypeError("Expected argument 'replay_window' to be a str")
        pulumi.set(__self__, "replay_window", replay_window)
        if replay_window_variable and not isinstance(replay_window_variable, str):
            raise TypeError("Expected argument 'replay_window_variable' to be a str")
        pulumi.set(__self__, "replay_window_variable", replay_window_variable)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @property
    @pulumi.getter(name="authenticationTypes")
    def authentication_types(self) -> Sequence[str]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "authentication_types")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="extendedArWindow")
    def extended_ar_window(self) -> int:
        """
        Extended Anti-Replay Window
        """
        return pulumi.get(self, "extended_ar_window")

    @property
    @pulumi.getter(name="extendedArWindowVariable")
    def extended_ar_window_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "extended_ar_window_variable")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integrityTypeVariable")
    def integrity_type_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "integrity_type_variable")

    @property
    @pulumi.getter(name="integrityTypes")
    def integrity_types(self) -> Sequence[str]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "integrity_types")

    @property
    @pulumi.getter
    def keychains(self) -> Sequence['outputs.GetCiscoSecurityFeatureTemplateKeychainResult']:
        """
        Configure a Keychain
        """
        return pulumi.get(self, "keychains")

    @property
    @pulumi.getter
    def keys(self) -> Sequence['outputs.GetCiscoSecurityFeatureTemplateKeyResult']:
        """
        Configure a Key
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pairwiseKeying")
    def pairwise_keying(self) -> bool:
        """
        Enable or disable IPsec pairwise-keying
        """
        return pulumi.get(self, "pairwise_keying")

    @property
    @pulumi.getter(name="pairwiseKeyingVariable")
    def pairwise_keying_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "pairwise_keying_variable")

    @property
    @pulumi.getter(name="rekeyInterval")
    def rekey_interval(self) -> int:
        """
        Set how often to change the AES key for DTLS connections
        """
        return pulumi.get(self, "rekey_interval")

    @property
    @pulumi.getter(name="rekeyIntervalVariable")
    def rekey_interval_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "rekey_interval_variable")

    @property
    @pulumi.getter(name="replayWindow")
    def replay_window(self) -> str:
        """
        Set the sliding replay window size
        """
        return pulumi.get(self, "replay_window")

    @property
    @pulumi.getter(name="replayWindowVariable")
    def replay_window_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "replay_window_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCiscoSecurityFeatureTemplateResult(GetCiscoSecurityFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoSecurityFeatureTemplateResult(
            authentication_type_variable=self.authentication_type_variable,
            authentication_types=self.authentication_types,
            description=self.description,
            device_types=self.device_types,
            extended_ar_window=self.extended_ar_window,
            extended_ar_window_variable=self.extended_ar_window_variable,
            id=self.id,
            integrity_type_variable=self.integrity_type_variable,
            integrity_types=self.integrity_types,
            keychains=self.keychains,
            keys=self.keys,
            name=self.name,
            pairwise_keying=self.pairwise_keying,
            pairwise_keying_variable=self.pairwise_keying_variable,
            rekey_interval=self.rekey_interval,
            rekey_interval_variable=self.rekey_interval_variable,
            replay_window=self.replay_window,
            replay_window_variable=self.replay_window_variable,
            template_type=self.template_type,
            version=self.version)


def get_cisco_security_feature_template(id: Optional[str] = None,
                                        name: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoSecurityFeatureTemplateResult:
    """
    This data source can read the Cisco Security feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_security_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoSecurityFeatureTemplate:getCiscoSecurityFeatureTemplate', __args__, opts=opts, typ=GetCiscoSecurityFeatureTemplateResult).value

    return AwaitableGetCiscoSecurityFeatureTemplateResult(
        authentication_type_variable=pulumi.get(__ret__, 'authentication_type_variable'),
        authentication_types=pulumi.get(__ret__, 'authentication_types'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        extended_ar_window=pulumi.get(__ret__, 'extended_ar_window'),
        extended_ar_window_variable=pulumi.get(__ret__, 'extended_ar_window_variable'),
        id=pulumi.get(__ret__, 'id'),
        integrity_type_variable=pulumi.get(__ret__, 'integrity_type_variable'),
        integrity_types=pulumi.get(__ret__, 'integrity_types'),
        keychains=pulumi.get(__ret__, 'keychains'),
        keys=pulumi.get(__ret__, 'keys'),
        name=pulumi.get(__ret__, 'name'),
        pairwise_keying=pulumi.get(__ret__, 'pairwise_keying'),
        pairwise_keying_variable=pulumi.get(__ret__, 'pairwise_keying_variable'),
        rekey_interval=pulumi.get(__ret__, 'rekey_interval'),
        rekey_interval_variable=pulumi.get(__ret__, 'rekey_interval_variable'),
        replay_window=pulumi.get(__ret__, 'replay_window'),
        replay_window_variable=pulumi.get(__ret__, 'replay_window_variable'),
        template_type=pulumi.get(__ret__, 'template_type'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_cisco_security_feature_template)
def get_cisco_security_feature_template_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                               name: Optional[pulumi.Input[Optional[str]]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCiscoSecurityFeatureTemplateResult]:
    """
    This data source can read the Cisco Security feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_security_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    ...
