# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoVpnFeatureTemplateResult',
    'AwaitableGetCiscoVpnFeatureTemplateResult',
    'get_cisco_vpn_feature_template',
    'get_cisco_vpn_feature_template_output',
]

@pulumi.output_type
class GetCiscoVpnFeatureTemplateResult:
    """
    A collection of values returned by getCiscoVpnFeatureTemplate.
    """
    def __init__(__self__, description=None, device_types=None, dns_hosts=None, dns_ipv4_servers=None, dns_ipv6_servers=None, enhance_ecmp_keying=None, enhance_ecmp_keying_variable=None, id=None, ipv4_static_gre_routes=None, ipv4_static_ipsec_routes=None, ipv4_static_routes=None, ipv4_static_service_routes=None, ipv6_static_routes=None, name=None, nat64_pools=None, nat_pools=None, omp_admin_distance_ipv4=None, omp_admin_distance_ipv4_variable=None, omp_admin_distance_ipv6=None, omp_admin_distance_ipv6_variable=None, omp_advertise_ipv4_routes=None, omp_advertise_ipv6_routes=None, organization_name=None, port_forward_rules=None, route_global_exports=None, route_global_imports=None, route_vpn_imports=None, services=None, static_nat_rules=None, static_nat_subnet_rules=None, template_type=None, tenant_vpn_id=None, version=None, vpn_id=None, vpn_name=None, vpn_name_variable=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if dns_hosts and not isinstance(dns_hosts, list):
            raise TypeError("Expected argument 'dns_hosts' to be a list")
        pulumi.set(__self__, "dns_hosts", dns_hosts)
        if dns_ipv4_servers and not isinstance(dns_ipv4_servers, list):
            raise TypeError("Expected argument 'dns_ipv4_servers' to be a list")
        pulumi.set(__self__, "dns_ipv4_servers", dns_ipv4_servers)
        if dns_ipv6_servers and not isinstance(dns_ipv6_servers, list):
            raise TypeError("Expected argument 'dns_ipv6_servers' to be a list")
        pulumi.set(__self__, "dns_ipv6_servers", dns_ipv6_servers)
        if enhance_ecmp_keying and not isinstance(enhance_ecmp_keying, bool):
            raise TypeError("Expected argument 'enhance_ecmp_keying' to be a bool")
        pulumi.set(__self__, "enhance_ecmp_keying", enhance_ecmp_keying)
        if enhance_ecmp_keying_variable and not isinstance(enhance_ecmp_keying_variable, str):
            raise TypeError("Expected argument 'enhance_ecmp_keying_variable' to be a str")
        pulumi.set(__self__, "enhance_ecmp_keying_variable", enhance_ecmp_keying_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv4_static_gre_routes and not isinstance(ipv4_static_gre_routes, list):
            raise TypeError("Expected argument 'ipv4_static_gre_routes' to be a list")
        pulumi.set(__self__, "ipv4_static_gre_routes", ipv4_static_gre_routes)
        if ipv4_static_ipsec_routes and not isinstance(ipv4_static_ipsec_routes, list):
            raise TypeError("Expected argument 'ipv4_static_ipsec_routes' to be a list")
        pulumi.set(__self__, "ipv4_static_ipsec_routes", ipv4_static_ipsec_routes)
        if ipv4_static_routes and not isinstance(ipv4_static_routes, list):
            raise TypeError("Expected argument 'ipv4_static_routes' to be a list")
        pulumi.set(__self__, "ipv4_static_routes", ipv4_static_routes)
        if ipv4_static_service_routes and not isinstance(ipv4_static_service_routes, list):
            raise TypeError("Expected argument 'ipv4_static_service_routes' to be a list")
        pulumi.set(__self__, "ipv4_static_service_routes", ipv4_static_service_routes)
        if ipv6_static_routes and not isinstance(ipv6_static_routes, list):
            raise TypeError("Expected argument 'ipv6_static_routes' to be a list")
        pulumi.set(__self__, "ipv6_static_routes", ipv6_static_routes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nat64_pools and not isinstance(nat64_pools, list):
            raise TypeError("Expected argument 'nat64_pools' to be a list")
        pulumi.set(__self__, "nat64_pools", nat64_pools)
        if nat_pools and not isinstance(nat_pools, list):
            raise TypeError("Expected argument 'nat_pools' to be a list")
        pulumi.set(__self__, "nat_pools", nat_pools)
        if omp_admin_distance_ipv4 and not isinstance(omp_admin_distance_ipv4, int):
            raise TypeError("Expected argument 'omp_admin_distance_ipv4' to be a int")
        pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable and not isinstance(omp_admin_distance_ipv4_variable, str):
            raise TypeError("Expected argument 'omp_admin_distance_ipv4_variable' to be a str")
        pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 and not isinstance(omp_admin_distance_ipv6, int):
            raise TypeError("Expected argument 'omp_admin_distance_ipv6' to be a int")
        pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable and not isinstance(omp_admin_distance_ipv6_variable, str):
            raise TypeError("Expected argument 'omp_admin_distance_ipv6_variable' to be a str")
        pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if omp_advertise_ipv4_routes and not isinstance(omp_advertise_ipv4_routes, list):
            raise TypeError("Expected argument 'omp_advertise_ipv4_routes' to be a list")
        pulumi.set(__self__, "omp_advertise_ipv4_routes", omp_advertise_ipv4_routes)
        if omp_advertise_ipv6_routes and not isinstance(omp_advertise_ipv6_routes, list):
            raise TypeError("Expected argument 'omp_advertise_ipv6_routes' to be a list")
        pulumi.set(__self__, "omp_advertise_ipv6_routes", omp_advertise_ipv6_routes)
        if organization_name and not isinstance(organization_name, str):
            raise TypeError("Expected argument 'organization_name' to be a str")
        pulumi.set(__self__, "organization_name", organization_name)
        if port_forward_rules and not isinstance(port_forward_rules, list):
            raise TypeError("Expected argument 'port_forward_rules' to be a list")
        pulumi.set(__self__, "port_forward_rules", port_forward_rules)
        if route_global_exports and not isinstance(route_global_exports, list):
            raise TypeError("Expected argument 'route_global_exports' to be a list")
        pulumi.set(__self__, "route_global_exports", route_global_exports)
        if route_global_imports and not isinstance(route_global_imports, list):
            raise TypeError("Expected argument 'route_global_imports' to be a list")
        pulumi.set(__self__, "route_global_imports", route_global_imports)
        if route_vpn_imports and not isinstance(route_vpn_imports, list):
            raise TypeError("Expected argument 'route_vpn_imports' to be a list")
        pulumi.set(__self__, "route_vpn_imports", route_vpn_imports)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if static_nat_rules and not isinstance(static_nat_rules, list):
            raise TypeError("Expected argument 'static_nat_rules' to be a list")
        pulumi.set(__self__, "static_nat_rules", static_nat_rules)
        if static_nat_subnet_rules and not isinstance(static_nat_subnet_rules, list):
            raise TypeError("Expected argument 'static_nat_subnet_rules' to be a list")
        pulumi.set(__self__, "static_nat_subnet_rules", static_nat_subnet_rules)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if tenant_vpn_id and not isinstance(tenant_vpn_id, int):
            raise TypeError("Expected argument 'tenant_vpn_id' to be a int")
        pulumi.set(__self__, "tenant_vpn_id", tenant_vpn_id)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if vpn_id and not isinstance(vpn_id, int):
            raise TypeError("Expected argument 'vpn_id' to be a int")
        pulumi.set(__self__, "vpn_id", vpn_id)
        if vpn_name and not isinstance(vpn_name, str):
            raise TypeError("Expected argument 'vpn_name' to be a str")
        pulumi.set(__self__, "vpn_name", vpn_name)
        if vpn_name_variable and not isinstance(vpn_name_variable, str):
            raise TypeError("Expected argument 'vpn_name_variable' to be a str")
        pulumi.set(__self__, "vpn_name_variable", vpn_name_variable)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="dnsHosts")
    def dns_hosts(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateDnsHostResult']:
        """
        Static DNS mapping
        """
        return pulumi.get(self, "dns_hosts")

    @property
    @pulumi.getter(name="dnsIpv4Servers")
    def dns_ipv4_servers(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateDnsIpv4ServerResult']:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv4_servers")

    @property
    @pulumi.getter(name="dnsIpv6Servers")
    def dns_ipv6_servers(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateDnsIpv6ServerResult']:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv6_servers")

    @property
    @pulumi.getter(name="enhanceEcmpKeying")
    def enhance_ecmp_keying(self) -> bool:
        """
        Optional packet fields for ECMP keying
        """
        return pulumi.get(self, "enhance_ecmp_keying")

    @property
    @pulumi.getter(name="enhanceEcmpKeyingVariable")
    def enhance_ecmp_keying_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "enhance_ecmp_keying_variable")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv4StaticGreRoutes")
    def ipv4_static_gre_routes(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateIpv4StaticGreRouteResult']:
        """
        Configure routes pointing to a GRE tunnel
        """
        return pulumi.get(self, "ipv4_static_gre_routes")

    @property
    @pulumi.getter(name="ipv4StaticIpsecRoutes")
    def ipv4_static_ipsec_routes(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateIpv4StaticIpsecRouteResult']:
        """
        Configure routes pointing to a IPSEC tunnel
        """
        return pulumi.get(self, "ipv4_static_ipsec_routes")

    @property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateIpv4StaticRouteResult']:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "ipv4_static_routes")

    @property
    @pulumi.getter(name="ipv4StaticServiceRoutes")
    def ipv4_static_service_routes(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateIpv4StaticServiceRouteResult']:
        """
        Configure IPv4 Static Service Routes
        """
        return pulumi.get(self, "ipv4_static_service_routes")

    @property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateIpv6StaticRouteResult']:
        """
        Configure IPv6 Static Routes
        """
        return pulumi.get(self, "ipv6_static_routes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nat64Pools")
    def nat64_pools(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateNat64PoolResult']:
        """
        Set NAT64 v4 pool range
        """
        return pulumi.get(self, "nat64_pools")

    @property
    @pulumi.getter(name="natPools")
    def nat_pools(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateNatPoolResult']:
        """
        Configure NAT Pool entries
        """
        return pulumi.get(self, "nat_pools")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> int:
        """
        omp-admin-distance-ipv4
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> int:
        """
        omp-admin-distance-ipv6
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @property
    @pulumi.getter(name="ompAdvertiseIpv4Routes")
    def omp_advertise_ipv4_routes(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteResult']:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv4_routes")

    @property
    @pulumi.getter(name="ompAdvertiseIpv6Routes")
    def omp_advertise_ipv6_routes(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteResult']:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv6_routes")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        """
        Org Name selected
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="portForwardRules")
    def port_forward_rules(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplatePortForwardRuleResult']:
        """
        Configure Port Forward entries
        """
        return pulumi.get(self, "port_forward_rules")

    @property
    @pulumi.getter(name="routeGlobalExports")
    def route_global_exports(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateRouteGlobalExportResult']:
        """
        Enable route leaking to Global VPN from this Service VPN
        """
        return pulumi.get(self, "route_global_exports")

    @property
    @pulumi.getter(name="routeGlobalImports")
    def route_global_imports(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateRouteGlobalImportResult']:
        """
        Enable route leaking from Global VPN to this Service VPN
        """
        return pulumi.get(self, "route_global_imports")

    @property
    @pulumi.getter(name="routeVpnImports")
    def route_vpn_imports(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateRouteVpnImportResult']:
        """
        Enable route leak from Service VPN to current VPN
        """
        return pulumi.get(self, "route_vpn_imports")

    @property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateServiceResult']:
        """
        Configure services
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="staticNatRules")
    def static_nat_rules(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateStaticNatRuleResult']:
        """
        Configure static NAT entries
        """
        return pulumi.get(self, "static_nat_rules")

    @property
    @pulumi.getter(name="staticNatSubnetRules")
    def static_nat_subnet_rules(self) -> Sequence['outputs.GetCiscoVpnFeatureTemplateStaticNatSubnetRuleResult']:
        """
        Configure static NAT Subnet entries
        """
        return pulumi.get(self, "static_nat_subnet_rules")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="tenantVpnId")
    def tenant_vpn_id(self) -> int:
        """
        Tenant VPN
        """
        return pulumi.get(self, "tenant_vpn_id")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> int:
        """
        List of VPN instances
        """
        return pulumi.get(self, "vpn_id")

    @property
    @pulumi.getter(name="vpnName")
    def vpn_name(self) -> str:
        """
        Name
        """
        return pulumi.get(self, "vpn_name")

    @property
    @pulumi.getter(name="vpnNameVariable")
    def vpn_name_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_name_variable")


class AwaitableGetCiscoVpnFeatureTemplateResult(GetCiscoVpnFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoVpnFeatureTemplateResult(
            description=self.description,
            device_types=self.device_types,
            dns_hosts=self.dns_hosts,
            dns_ipv4_servers=self.dns_ipv4_servers,
            dns_ipv6_servers=self.dns_ipv6_servers,
            enhance_ecmp_keying=self.enhance_ecmp_keying,
            enhance_ecmp_keying_variable=self.enhance_ecmp_keying_variable,
            id=self.id,
            ipv4_static_gre_routes=self.ipv4_static_gre_routes,
            ipv4_static_ipsec_routes=self.ipv4_static_ipsec_routes,
            ipv4_static_routes=self.ipv4_static_routes,
            ipv4_static_service_routes=self.ipv4_static_service_routes,
            ipv6_static_routes=self.ipv6_static_routes,
            name=self.name,
            nat64_pools=self.nat64_pools,
            nat_pools=self.nat_pools,
            omp_admin_distance_ipv4=self.omp_admin_distance_ipv4,
            omp_admin_distance_ipv4_variable=self.omp_admin_distance_ipv4_variable,
            omp_admin_distance_ipv6=self.omp_admin_distance_ipv6,
            omp_admin_distance_ipv6_variable=self.omp_admin_distance_ipv6_variable,
            omp_advertise_ipv4_routes=self.omp_advertise_ipv4_routes,
            omp_advertise_ipv6_routes=self.omp_advertise_ipv6_routes,
            organization_name=self.organization_name,
            port_forward_rules=self.port_forward_rules,
            route_global_exports=self.route_global_exports,
            route_global_imports=self.route_global_imports,
            route_vpn_imports=self.route_vpn_imports,
            services=self.services,
            static_nat_rules=self.static_nat_rules,
            static_nat_subnet_rules=self.static_nat_subnet_rules,
            template_type=self.template_type,
            tenant_vpn_id=self.tenant_vpn_id,
            version=self.version,
            vpn_id=self.vpn_id,
            vpn_name=self.vpn_name,
            vpn_name_variable=self.vpn_name_variable)


def get_cisco_vpn_feature_template(id: Optional[str] = None,
                                   name: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoVpnFeatureTemplateResult:
    """
    This data source can read the Cisco VPN feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_vpn_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoVpnFeatureTemplate:getCiscoVpnFeatureTemplate', __args__, opts=opts, typ=GetCiscoVpnFeatureTemplateResult).value

    return AwaitableGetCiscoVpnFeatureTemplateResult(
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        dns_hosts=pulumi.get(__ret__, 'dns_hosts'),
        dns_ipv4_servers=pulumi.get(__ret__, 'dns_ipv4_servers'),
        dns_ipv6_servers=pulumi.get(__ret__, 'dns_ipv6_servers'),
        enhance_ecmp_keying=pulumi.get(__ret__, 'enhance_ecmp_keying'),
        enhance_ecmp_keying_variable=pulumi.get(__ret__, 'enhance_ecmp_keying_variable'),
        id=pulumi.get(__ret__, 'id'),
        ipv4_static_gre_routes=pulumi.get(__ret__, 'ipv4_static_gre_routes'),
        ipv4_static_ipsec_routes=pulumi.get(__ret__, 'ipv4_static_ipsec_routes'),
        ipv4_static_routes=pulumi.get(__ret__, 'ipv4_static_routes'),
        ipv4_static_service_routes=pulumi.get(__ret__, 'ipv4_static_service_routes'),
        ipv6_static_routes=pulumi.get(__ret__, 'ipv6_static_routes'),
        name=pulumi.get(__ret__, 'name'),
        nat64_pools=pulumi.get(__ret__, 'nat64_pools'),
        nat_pools=pulumi.get(__ret__, 'nat_pools'),
        omp_admin_distance_ipv4=pulumi.get(__ret__, 'omp_admin_distance_ipv4'),
        omp_admin_distance_ipv4_variable=pulumi.get(__ret__, 'omp_admin_distance_ipv4_variable'),
        omp_admin_distance_ipv6=pulumi.get(__ret__, 'omp_admin_distance_ipv6'),
        omp_admin_distance_ipv6_variable=pulumi.get(__ret__, 'omp_admin_distance_ipv6_variable'),
        omp_advertise_ipv4_routes=pulumi.get(__ret__, 'omp_advertise_ipv4_routes'),
        omp_advertise_ipv6_routes=pulumi.get(__ret__, 'omp_advertise_ipv6_routes'),
        organization_name=pulumi.get(__ret__, 'organization_name'),
        port_forward_rules=pulumi.get(__ret__, 'port_forward_rules'),
        route_global_exports=pulumi.get(__ret__, 'route_global_exports'),
        route_global_imports=pulumi.get(__ret__, 'route_global_imports'),
        route_vpn_imports=pulumi.get(__ret__, 'route_vpn_imports'),
        services=pulumi.get(__ret__, 'services'),
        static_nat_rules=pulumi.get(__ret__, 'static_nat_rules'),
        static_nat_subnet_rules=pulumi.get(__ret__, 'static_nat_subnet_rules'),
        template_type=pulumi.get(__ret__, 'template_type'),
        tenant_vpn_id=pulumi.get(__ret__, 'tenant_vpn_id'),
        version=pulumi.get(__ret__, 'version'),
        vpn_id=pulumi.get(__ret__, 'vpn_id'),
        vpn_name=pulumi.get(__ret__, 'vpn_name'),
        vpn_name_variable=pulumi.get(__ret__, 'vpn_name_variable'))


@_utilities.lift_output_func(get_cisco_vpn_feature_template)
def get_cisco_vpn_feature_template_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                          name: Optional[pulumi.Input[Optional[str]]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCiscoVpnFeatureTemplateResult]:
    """
    This data source can read the Cisco VPN feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_vpn_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    ...
