# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetConfigurationGroupResult',
    'AwaitableGetConfigurationGroupResult',
    'get_configuration_group',
    'get_configuration_group_output',
]

@pulumi.output_type
class GetConfigurationGroupResult:
    """
    A collection of values returned by getConfigurationGroup.
    """
    def __init__(__self__, description=None, feature_profiles=None, id=None, name=None, solution=None, topology_devices=None, topology_site_devices=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profiles and not isinstance(feature_profiles, list):
            raise TypeError("Expected argument 'feature_profiles' to be a list")
        pulumi.set(__self__, "feature_profiles", feature_profiles)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if solution and not isinstance(solution, str):
            raise TypeError("Expected argument 'solution' to be a str")
        pulumi.set(__self__, "solution", solution)
        if topology_devices and not isinstance(topology_devices, list):
            raise TypeError("Expected argument 'topology_devices' to be a list")
        pulumi.set(__self__, "topology_devices", topology_devices)
        if topology_site_devices and not isinstance(topology_site_devices, int):
            raise TypeError("Expected argument 'topology_site_devices' to be a int")
        pulumi.set(__self__, "topology_site_devices", topology_site_devices)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfiles")
    def feature_profiles(self) -> Sequence['outputs.GetConfigurationGroupFeatureProfileResult']:
        """
        List of feature profiles
        """
        return pulumi.get(self, "feature_profiles")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the configuration group
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def solution(self) -> str:
        """
        Type of solution
        """
        return pulumi.get(self, "solution")

    @property
    @pulumi.getter(name="topologyDevices")
    def topology_devices(self) -> Sequence['outputs.GetConfigurationGroupTopologyDeviceResult']:
        """
        List of topology device types
        """
        return pulumi.get(self, "topology_devices")

    @property
    @pulumi.getter(name="topologySiteDevices")
    def topology_site_devices(self) -> int:
        """
        Number of devices per site
        """
        return pulumi.get(self, "topology_site_devices")


class AwaitableGetConfigurationGroupResult(GetConfigurationGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationGroupResult(
            description=self.description,
            feature_profiles=self.feature_profiles,
            id=self.id,
            name=self.name,
            solution=self.solution,
            topology_devices=self.topology_devices,
            topology_site_devices=self.topology_site_devices)


def get_configuration_group(id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationGroupResult:
    """
    This data source can read the Configuration Group .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_configuration_group(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the object
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getConfigurationGroup:getConfigurationGroup', __args__, opts=opts, typ=GetConfigurationGroupResult).value

    return AwaitableGetConfigurationGroupResult(
        description=pulumi.get(__ret__, 'description'),
        feature_profiles=pulumi.get(__ret__, 'feature_profiles'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        solution=pulumi.get(__ret__, 'solution'),
        topology_devices=pulumi.get(__ret__, 'topology_devices'),
        topology_site_devices=pulumi.get(__ret__, 'topology_site_devices'))


@_utilities.lift_output_func(get_configuration_group)
def get_configuration_group_output(id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConfigurationGroupResult]:
    """
    This data source can read the Configuration Group .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_configuration_group(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the object
    """
    ...
