# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemBfdProfileParcelArgs', 'SystemBfdProfileParcel']

@pulumi.input_type
class SystemBfdProfileParcelArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[str],
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SystemBfdProfileParcel resource.
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if default_dscp is not None:
            pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable is not None:
            pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable is not None:
            pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @colors.setter
    def colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]]]):
        pulumi.set(self, "colors", value)

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> Optional[pulumi.Input[int]]:
        """
        - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @default_dscp.setter
    def default_dscp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_dscp", value)

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @default_dscp_variable.setter
    def default_dscp_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_dscp_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[int]]:
        """
        - Range: `1`-`4294967295` - Default value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @poll_interval_variable.setter
    def poll_interval_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_interval_variable", value)


@pulumi.input_type
class _SystemBfdProfileParcelState:
    def __init__(__self__, *,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SystemBfdProfileParcel resources.
        :param pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        :param pulumi.Input[int] version: The version of the profile parcel
        """
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if default_dscp is not None:
            pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable is not None:
            pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable is not None:
            pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @colors.setter
    def colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdProfileParcelColorArgs']]]]):
        pulumi.set(self, "colors", value)

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> Optional[pulumi.Input[int]]:
        """
        - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @default_dscp.setter
    def default_dscp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_dscp", value)

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @default_dscp_variable.setter
    def default_dscp_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_dscp_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[int]]:
        """
        - Range: `1`-`4294967295` - Default value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @poll_interval_variable.setter
    def poll_interval_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_interval_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the profile parcel
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class SystemBfdProfileParcel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdProfileParcelColorArgs', 'SystemBfdProfileParcelColorArgsDict']]]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a System BFD profile parcel.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/systemBfdProfileParcel:SystemBfdProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdProfileParcelColorArgs', 'SystemBfdProfileParcelColorArgsDict']]]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemBfdProfileParcelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System BFD profile parcel.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/systemBfdProfileParcel:SystemBfdProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param SystemBfdProfileParcelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemBfdProfileParcelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdProfileParcelColorArgs', 'SystemBfdProfileParcelColorArgsDict']]]]] = None,
                 default_dscp: Optional[pulumi.Input[int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 multiplier_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemBfdProfileParcelArgs.__new__(SystemBfdProfileParcelArgs)

            __props__.__dict__["colors"] = colors
            __props__.__dict__["default_dscp"] = default_dscp
            __props__.__dict__["default_dscp_variable"] = default_dscp_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["multiplier"] = multiplier
            __props__.__dict__["multiplier_variable"] = multiplier_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["poll_interval"] = poll_interval
            __props__.__dict__["poll_interval_variable"] = poll_interval_variable
            __props__.__dict__["version"] = None
        super(SystemBfdProfileParcel, __self__).__init__(
            'sdwan:index/systemBfdProfileParcel:SystemBfdProfileParcel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdProfileParcelColorArgs', 'SystemBfdProfileParcelColorArgsDict']]]]] = None,
            default_dscp: Optional[pulumi.Input[int]] = None,
            default_dscp_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            multiplier: Optional[pulumi.Input[int]] = None,
            multiplier_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            poll_interval: Optional[pulumi.Input[int]] = None,
            poll_interval_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'SystemBfdProfileParcel':
        """
        Get an existing SystemBfdProfileParcel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdProfileParcelColorArgs', 'SystemBfdProfileParcelColorArgsDict']]]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[str] default_dscp_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[str] multiplier_variable: Variable name
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[str] poll_interval_variable: Variable name
        :param pulumi.Input[int] version: The version of the profile parcel
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemBfdProfileParcelState.__new__(_SystemBfdProfileParcelState)

        __props__.__dict__["colors"] = colors
        __props__.__dict__["default_dscp"] = default_dscp
        __props__.__dict__["default_dscp_variable"] = default_dscp_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["multiplier"] = multiplier
        __props__.__dict__["multiplier_variable"] = multiplier_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["poll_interval"] = poll_interval
        __props__.__dict__["poll_interval_variable"] = poll_interval_variable
        __props__.__dict__["version"] = version
        return SystemBfdProfileParcel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def colors(self) -> pulumi.Output[Optional[Sequence['outputs.SystemBfdProfileParcelColor']]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> pulumi.Output[Optional[int]]:
        """
        - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def multiplier(self) -> pulumi.Output[Optional[int]]:
        """
        - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> pulumi.Output[Optional[int]]:
        """
        - Range: `1`-`4294967295` - Default value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the profile parcel
        """
        return pulumi.get(self, "version")

