# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemNtpProfileParcelArgs', 'SystemNtpProfileParcel']

@pulumi.input_type
class SystemNtpProfileParcelArgs:
    def __init__(__self__, *,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]]] = None,
                 source_interface: Optional[pulumi.Input[str]] = None,
                 source_interface_variable: Optional[pulumi.Input[str]] = None,
                 stratum: Optional[pulumi.Input[int]] = None,
                 stratum_variable: Optional[pulumi.Input[str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SystemNtpProfileParcel resource.
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[bool] authoritative_ntp_server: Enable device as NTP Leader - Default value: `false`
        :param pulumi.Input[str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]] servers: Configure NTP servers
        :param pulumi.Input[str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[str] source_interface_variable: Variable name
        :param pulumi.Input[int] stratum: Enable device as NTP Leader - Range: `1`-`15`
        :param pulumi.Input[str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[str] trusted_keys_variable: Variable name
        """
        if authentication_keys is not None:
            pulumi.set(__self__, "authentication_keys", authentication_keys)
        if authoritative_ntp_server is not None:
            pulumi.set(__self__, "authoritative_ntp_server", authoritative_ntp_server)
        if authoritative_ntp_server_variable is not None:
            pulumi.set(__self__, "authoritative_ntp_server_variable", authoritative_ntp_server_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if source_interface is not None:
            pulumi.set(__self__, "source_interface", source_interface)
        if source_interface_variable is not None:
            pulumi.set(__self__, "source_interface_variable", source_interface_variable)
        if stratum is not None:
            pulumi.set(__self__, "stratum", stratum)
        if stratum_variable is not None:
            pulumi.set(__self__, "stratum_variable", stratum_variable)
        if trusted_keys is not None:
            pulumi.set(__self__, "trusted_keys", trusted_keys)
        if trusted_keys_variable is not None:
            pulumi.set(__self__, "trusted_keys_variable", trusted_keys_variable)

    @property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @authentication_keys.setter
    def authentication_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]]]):
        pulumi.set(self, "authentication_keys", value)

    @property
    @pulumi.getter(name="authoritativeNtpServer")
    def authoritative_ntp_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable device as NTP Leader - Default value: `false`
        """
        return pulumi.get(self, "authoritative_ntp_server")

    @authoritative_ntp_server.setter
    def authoritative_ntp_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authoritative_ntp_server", value)

    @property
    @pulumi.getter(name="authoritativeNtpServerVariable")
    def authoritative_ntp_server_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authoritative_ntp_server_variable")

    @authoritative_ntp_server_variable.setter
    def authoritative_ntp_server_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authoritative_ntp_server_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="sourceInterface")
    def source_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Enable device as NTP Leader
        """
        return pulumi.get(self, "source_interface")

    @source_interface.setter
    def source_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_interface", value)

    @property
    @pulumi.getter(name="sourceInterfaceVariable")
    def source_interface_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_interface_variable")

    @source_interface_variable.setter
    def source_interface_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_interface_variable", value)

    @property
    @pulumi.getter
    def stratum(self) -> Optional[pulumi.Input[int]]:
        """
        Enable device as NTP Leader - Range: `1`-`15`
        """
        return pulumi.get(self, "stratum")

    @stratum.setter
    def stratum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stratum", value)

    @property
    @pulumi.getter(name="stratumVariable")
    def stratum_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "stratum_variable")

    @stratum_variable.setter
    def stratum_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stratum_variable", value)

    @property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @trusted_keys.setter
    def trusted_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "trusted_keys", value)

    @property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @trusted_keys_variable.setter
    def trusted_keys_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trusted_keys_variable", value)


@pulumi.input_type
class _SystemNtpProfileParcelState:
    def __init__(__self__, *,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]]] = None,
                 source_interface: Optional[pulumi.Input[str]] = None,
                 source_interface_variable: Optional[pulumi.Input[str]] = None,
                 stratum: Optional[pulumi.Input[int]] = None,
                 stratum_variable: Optional[pulumi.Input[str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SystemNtpProfileParcel resources.
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[bool] authoritative_ntp_server: Enable device as NTP Leader - Default value: `false`
        :param pulumi.Input[str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]] servers: Configure NTP servers
        :param pulumi.Input[str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[str] source_interface_variable: Variable name
        :param pulumi.Input[int] stratum: Enable device as NTP Leader - Range: `1`-`15`
        :param pulumi.Input[str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[str] trusted_keys_variable: Variable name
        :param pulumi.Input[int] version: The version of the profile parcel
        """
        if authentication_keys is not None:
            pulumi.set(__self__, "authentication_keys", authentication_keys)
        if authoritative_ntp_server is not None:
            pulumi.set(__self__, "authoritative_ntp_server", authoritative_ntp_server)
        if authoritative_ntp_server_variable is not None:
            pulumi.set(__self__, "authoritative_ntp_server_variable", authoritative_ntp_server_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if source_interface is not None:
            pulumi.set(__self__, "source_interface", source_interface)
        if source_interface_variable is not None:
            pulumi.set(__self__, "source_interface_variable", source_interface_variable)
        if stratum is not None:
            pulumi.set(__self__, "stratum", stratum)
        if stratum_variable is not None:
            pulumi.set(__self__, "stratum_variable", stratum_variable)
        if trusted_keys is not None:
            pulumi.set(__self__, "trusted_keys", trusted_keys)
        if trusted_keys_variable is not None:
            pulumi.set(__self__, "trusted_keys_variable", trusted_keys_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @authentication_keys.setter
    def authentication_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelAuthenticationKeyArgs']]]]):
        pulumi.set(self, "authentication_keys", value)

    @property
    @pulumi.getter(name="authoritativeNtpServer")
    def authoritative_ntp_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable device as NTP Leader - Default value: `false`
        """
        return pulumi.get(self, "authoritative_ntp_server")

    @authoritative_ntp_server.setter
    def authoritative_ntp_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "authoritative_ntp_server", value)

    @property
    @pulumi.getter(name="authoritativeNtpServerVariable")
    def authoritative_ntp_server_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authoritative_ntp_server_variable")

    @authoritative_ntp_server_variable.setter
    def authoritative_ntp_server_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authoritative_ntp_server_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpProfileParcelServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="sourceInterface")
    def source_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Enable device as NTP Leader
        """
        return pulumi.get(self, "source_interface")

    @source_interface.setter
    def source_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_interface", value)

    @property
    @pulumi.getter(name="sourceInterfaceVariable")
    def source_interface_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_interface_variable")

    @source_interface_variable.setter
    def source_interface_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_interface_variable", value)

    @property
    @pulumi.getter
    def stratum(self) -> Optional[pulumi.Input[int]]:
        """
        Enable device as NTP Leader - Range: `1`-`15`
        """
        return pulumi.get(self, "stratum")

    @stratum.setter
    def stratum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stratum", value)

    @property
    @pulumi.getter(name="stratumVariable")
    def stratum_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "stratum_variable")

    @stratum_variable.setter
    def stratum_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stratum_variable", value)

    @property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @trusted_keys.setter
    def trusted_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "trusted_keys", value)

    @property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @trusted_keys_variable.setter
    def trusted_keys_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trusted_keys_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the profile parcel
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class SystemNtpProfileParcel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelAuthenticationKeyArgs', 'SystemNtpProfileParcelAuthenticationKeyArgsDict']]]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelServerArgs', 'SystemNtpProfileParcelServerArgsDict']]]]] = None,
                 source_interface: Optional[pulumi.Input[str]] = None,
                 source_interface_variable: Optional[pulumi.Input[str]] = None,
                 stratum: Optional[pulumi.Input[int]] = None,
                 stratum_variable: Optional[pulumi.Input[str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a System NTP profile parcel.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/systemNtpProfileParcel:SystemNtpProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelAuthenticationKeyArgs', 'SystemNtpProfileParcelAuthenticationKeyArgsDict']]]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[bool] authoritative_ntp_server: Enable device as NTP Leader - Default value: `false`
        :param pulumi.Input[str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelServerArgs', 'SystemNtpProfileParcelServerArgsDict']]]] servers: Configure NTP servers
        :param pulumi.Input[str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[str] source_interface_variable: Variable name
        :param pulumi.Input[int] stratum: Enable device as NTP Leader - Range: `1`-`15`
        :param pulumi.Input[str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[str] trusted_keys_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SystemNtpProfileParcelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System NTP profile parcel.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/systemNtpProfileParcel:SystemNtpProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param SystemNtpProfileParcelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemNtpProfileParcelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelAuthenticationKeyArgs', 'SystemNtpProfileParcelAuthenticationKeyArgsDict']]]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelServerArgs', 'SystemNtpProfileParcelServerArgsDict']]]]] = None,
                 source_interface: Optional[pulumi.Input[str]] = None,
                 source_interface_variable: Optional[pulumi.Input[str]] = None,
                 stratum: Optional[pulumi.Input[int]] = None,
                 stratum_variable: Optional[pulumi.Input[str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemNtpProfileParcelArgs.__new__(SystemNtpProfileParcelArgs)

            __props__.__dict__["authentication_keys"] = authentication_keys
            __props__.__dict__["authoritative_ntp_server"] = authoritative_ntp_server
            __props__.__dict__["authoritative_ntp_server_variable"] = authoritative_ntp_server_variable
            __props__.__dict__["description"] = description
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["servers"] = servers
            __props__.__dict__["source_interface"] = source_interface
            __props__.__dict__["source_interface_variable"] = source_interface_variable
            __props__.__dict__["stratum"] = stratum
            __props__.__dict__["stratum_variable"] = stratum_variable
            __props__.__dict__["trusted_keys"] = trusted_keys
            __props__.__dict__["trusted_keys_variable"] = trusted_keys_variable
            __props__.__dict__["version"] = None
        super(SystemNtpProfileParcel, __self__).__init__(
            'sdwan:index/systemNtpProfileParcel:SystemNtpProfileParcel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelAuthenticationKeyArgs', 'SystemNtpProfileParcelAuthenticationKeyArgsDict']]]]] = None,
            authoritative_ntp_server: Optional[pulumi.Input[bool]] = None,
            authoritative_ntp_server_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelServerArgs', 'SystemNtpProfileParcelServerArgsDict']]]]] = None,
            source_interface: Optional[pulumi.Input[str]] = None,
            source_interface_variable: Optional[pulumi.Input[str]] = None,
            stratum: Optional[pulumi.Input[int]] = None,
            stratum_variable: Optional[pulumi.Input[str]] = None,
            trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            trusted_keys_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'SystemNtpProfileParcel':
        """
        Get an existing SystemNtpProfileParcel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelAuthenticationKeyArgs', 'SystemNtpProfileParcelAuthenticationKeyArgsDict']]]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[bool] authoritative_ntp_server: Enable device as NTP Leader - Default value: `false`
        :param pulumi.Input[str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpProfileParcelServerArgs', 'SystemNtpProfileParcelServerArgsDict']]]] servers: Configure NTP servers
        :param pulumi.Input[str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[str] source_interface_variable: Variable name
        :param pulumi.Input[int] stratum: Enable device as NTP Leader - Range: `1`-`15`
        :param pulumi.Input[str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[str] trusted_keys_variable: Variable name
        :param pulumi.Input[int] version: The version of the profile parcel
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemNtpProfileParcelState.__new__(_SystemNtpProfileParcelState)

        __props__.__dict__["authentication_keys"] = authentication_keys
        __props__.__dict__["authoritative_ntp_server"] = authoritative_ntp_server
        __props__.__dict__["authoritative_ntp_server_variable"] = authoritative_ntp_server_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["servers"] = servers
        __props__.__dict__["source_interface"] = source_interface
        __props__.__dict__["source_interface_variable"] = source_interface_variable
        __props__.__dict__["stratum"] = stratum
        __props__.__dict__["stratum_variable"] = stratum_variable
        __props__.__dict__["trusted_keys"] = trusted_keys
        __props__.__dict__["trusted_keys_variable"] = trusted_keys_variable
        __props__.__dict__["version"] = version
        return SystemNtpProfileParcel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> pulumi.Output[Optional[Sequence['outputs.SystemNtpProfileParcelAuthenticationKey']]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @property
    @pulumi.getter(name="authoritativeNtpServer")
    def authoritative_ntp_server(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable device as NTP Leader - Default value: `false`
        """
        return pulumi.get(self, "authoritative_ntp_server")

    @property
    @pulumi.getter(name="authoritativeNtpServerVariable")
    def authoritative_ntp_server_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authoritative_ntp_server_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[Optional[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Optional[Sequence['outputs.SystemNtpProfileParcelServer']]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="sourceInterface")
    def source_interface(self) -> pulumi.Output[Optional[str]]:
        """
        Enable device as NTP Leader
        """
        return pulumi.get(self, "source_interface")

    @property
    @pulumi.getter(name="sourceInterfaceVariable")
    def source_interface_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_interface_variable")

    @property
    @pulumi.getter
    def stratum(self) -> pulumi.Output[Optional[int]]:
        """
        Enable device as NTP Leader - Range: `1`-`15`
        """
        return pulumi.get(self, "stratum")

    @property
    @pulumi.getter(name="stratumVariable")
    def stratum_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "stratum_variable")

    @property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the profile parcel
        """
        return pulumi.get(self, "version")

