import json
import numpy as np
# 2-B-007 1-IR-014 2-IR-014 1-OR-007 0-OR-014 1-OR-021
# 示例字典（值为 NumPy 数组）
# dict_data = {
#     '0-B-007': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '0-B-014': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '0-B-021': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '0-IR-007': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '0-IR-014': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '0-IR-021': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '0-No': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [0, 0, 0, 1],  # 第二个字母: No → [0,0,0,1]
#         [1, 0, 0, 0]  # 第三个数字: 000 → [1,0,0,0]
#     ],
#
#     '0-OR-007': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '0-OR-014': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '0-OR-021': [
#         [1, 0, 0],  # 第一个数字: 0 → [1,0,0]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '1-B-007': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '1-B-014': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '1-B-021': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '1-IR-007': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '1-IR-014': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '1-IR-021': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '1-No': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [0, 0, 0, 1],  # 第二个字母: No → [0,0,0,1]
#         [1, 0, 0, 0]  # 第三个数字: 000 → [1,0,0,0]
#     ],
#
#     '1-OR-007': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '1-OR-014': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '1-OR-021': [
#         [0, 1, 0],  # 第一个数字: 1 → [0,1,0]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '2-B-007': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '2-B-014': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '2-B-021': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [1, 0, 0, 0],  # 第二个字母: B → [1,0,0,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '2-IR-007': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '2-IR-014': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '2-IR-021': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [0, 1, 0, 0],  # 第二个字母: IR → [0,1,0,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
#
#     '2-No': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [0, 0, 0, 1],  # 第二个字母: No → [0,0,0,1]
#         [1, 0, 0, 0]  # 第三个数字: 000 → [1,0,0,0]
#     ],
#
#     '2-OR-007': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 1, 0, 0]  # 第三个数字: 007 → [0,1,0,0]
#     ],
#     '2-OR-014': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 0, 1, 0]  # 第三个数字: 014 → [0,0,1,0]
#     ],
#     '2-OR-021': [
#         [0, 0, 1],  # 第一个数字: 2 → [0,0,1]
#         [0, 0, 1, 0],  # 第二个字母: OR → [0,0,1,0]
#         [0, 0, 0, 1]  # 第三个数字: 021 → [0,0,0,1]
#     ],
# }
dict_data = {
    '0-B-007': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '0-B-014': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '0-B-021': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '0-IR-007': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '0-IR-014': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '0-IR-021': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '0-No': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        0, 0, 0, 1,  # 第二个字母: No → [0,0,0,1]
        1, 0, 0, 0  # 第三个数字: 000 → [1,0,0,0]
    ],

    '0-OR-007': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '0-OR-014': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '0-OR-021': [
        1, 0, 0,  # 第一个数字: 0 → [1,0,0]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '1-B-007': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '1-B-014': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '1-B-021': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '1-IR-007': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '1-IR-014': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '1-IR-021': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '1-No': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        0, 0, 0, 1,  # 第二个字母: No → [0,0,0,1]
        1, 0, 0, 0  # 第三个数字: 000 → [1,0,0,0]
    ],

    '1-OR-007': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '1-OR-014': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '1-OR-021': [
        0, 1, 0,  # 第一个数字: 1 → [0,1,0]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '2-B-007': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '2-B-014': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '2-B-021': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        1, 0, 0, 0,  # 第二个字母: B → [1,0,0,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '2-IR-007': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '2-IR-014': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 0, 1, 0  # 第三个数字: 014 → [0,0,1,0]
    ],
    '2-IR-021': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        0, 1, 0, 0,  # 第二个字母: IR → [0,1,0,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],

    '2-No': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        0, 0, 0, 1,  # 第二个字母: No → [0,0,0,1]
        1, 0, 0, 0  # 第三个数字: 000 → [1,0,0,0]
    ],

    '2-OR-007': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 1, 0, 0  # 第三个数字: 007 → [0,1,0,0]
    ],
    '2-OR-014': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 0, 1, 0 # 第三个数字: 014 → [0,0,1,0]
    ],
    '2-OR-021': [
        0, 0, 1,  # 第一个数字: 2 → [0,0,1]
        0, 0, 1, 0,  # 第二个字母: OR → [0,0,1,0]
        0, 0, 0, 1  # 第三个数字: 021 → [0,0,0,1]
    ],
}
def split_dict_by_full_keys(full_dict, include_keys):
    """
    根据完整键名列表将字典拆分为两个部分

    参数:
    full_dict (dict): 完整的字典
    include_keys (list): 需要包含的完整键名列表

    返回:
    tuple: 包含两个字典的元组 (include_dict, exclude_dict)
    """
    include_dict = {}
    exclude_dict = {}

    # 遍历完整字典的每个键值对
    for key, value in full_dict.items():
        # 检查当前键是否在给定的完整键名列表中
        if key in include_keys:
            include_dict[key] = value
        else:
            exclude_dict[key] = value

    return include_dict, exclude_dict


unseen_class = ['1-IR-007', '2-B-014', '0-OR-021', '2-IR-021', '0-B-014', '1-OR-014']
unseen, seen = split_dict_by_full_keys(dict_data, unseen_class)
seen_att = {key: np.array(value, dtype=object) for key, value in seen.items()}
unseen_att = {key: np.array(value, dtype=object) for key, value in unseen.items()}
np.savez(r'D:\Code\2-ZSL\Zero-Shot-Learning\data\A\unseen_att.npz', **unseen_att)
np.savez(r'D:\Code\2-ZSL\Zero-Shot-Learning\data\A\seen_att.npz', **seen_att)
# 保存字典到 .npz 文件
# with open('unseen_att.json', 'w') as f:
#     json.dump(unseen_att, f)
#
# with open('seen_att.json', 'w') as f:
#     json.dump(seen_att, f)
# 读取 .npz 文件（返回一个类似字典的对象）
# loaded_data = np.load(r'unseen_att.npz', allow_pickle=True)
# print(loaded_data.files)  # 查看所有键：['image', 'labels', 'metadata']
# a =  [item for sublist in loaded_data['0-B-007'] for item in sublist]# 输出：(100, 100)
# print(a)
# flattened_arrays = []
# for f in loaded_data.files:
#     flattened_arrays.append([item for sublist in loaded_data[f] for item in sublist])
# print(flattened_arrays)
# final_array = np.stack(flattened_arrays, axis=0)
# print(final_array)

