from typing import Any, Callable, Tuple, TypeVar
from weakref import WeakSet

__version__: str

T = TypeVar('T')

class CBHandle:
    def cancel(self): ...
    def cancelled(self) -> bool: ...

class TimerHandle:
    when: int

    def cancel(self): ...
    def cancelled(self) -> bool: ...

class EventLoop:
    _asyncgens: WeakSet
    _asyncgens_shutdown_called: bool
    _base_ctx: Any
    _clock: int
    _closed: bool
    _default_executor: Any
    _executor_shutdown_called: bool
    _exc_handler: Any
    _exception_handler: Any
    _sig_listening: bool
    _sig_loop_handled: bool
    _sig_wfd: Any
    _signals: set
    _ssock_r: Any
    _ssock_w: Any
    _stopping: bool
    _task_factory: Any
    _thread_id: int
    _watcher_child: Any

    def _run(self): ...
    def _call_later(self, delay, callback, args, context) -> TimerHandle: ...
    def _sig_add(self, sig, callback, context): ...
    def _sig_rem(self, sig) -> bool: ...
    def _sig_clear(self): ...
    def _ssock_set(self, fd): ...
    def _ssock_del(self, fd): ...
    def _tcp_conn(self, sock, protocol_factory: Callable[[], T]) -> Tuple[Any, T]: ...
    def _tcp_server(self, socks, rsocks, protocol_factory, backlog) -> Server: ...
    def add_reader(self, fd, callback, *args) -> CBHandle: ...
    def add_writer(self, fd, callback, *args) -> CBHandle: ...
    def call_soon(self, callback, *args, context=None) -> CBHandle: ...
    def call_soon_threadsafe(self, callback, *args, context=None) -> CBHandle: ...
    def remove_reader(self, fd) -> bool: ...
    def remove_writer(self, fd) -> bool: ...

class Server:
    _loop: Any
    _sockets: list[int]

    def _close(self): ...
    def _is_serving(self) -> bool: ...
    def _start_serving(self): ...
    def _streams_abort(self): ...
    def _streams_close(self): ...
