# Requires mslex and Windows to compare results
from w32lex import *
import mslex
from ctypes import *
from ctypes import windll, wintypes

CommandLineToArgvW = windll.shell32.CommandLineToArgvW
CommandLineToArgvW.argtypes = [wintypes.LPCWSTR, POINTER(c_int)]
CommandLineToArgvW.restype = POINTER(wintypes.LPWSTR)

LocalFree = windll.kernel32.LocalFree
LocalFree.argtypes = [wintypes.HLOCAL]
LocalFree.restype = wintypes.HLOCAL

def ctypes_split(s):
    argc = c_int()
    argv = CommandLineToArgvW("foo.exe " + s, byref(argc))
    result = [argv[i] for i in range(1, argc.value)]
    LocalFree(argv)
    return result



# from https://github.com/smoofra/mslex
examples = [
    (r"", []),
    (r'"', [""]),
    (r"x", ["x"]),
    (r'x"', ["x"]),
    (r"foo", ["foo"]),
    (r'foo    "bar baz"', ["foo", "bar baz"]),
    (r'"abc" d e', ["abc", "d", "e"]),
    (r'a\\\b d"e f"g h', [r"a\\\b", "de fg", "h"]),
    (r"a\\\"b c d", [r"a\"b", "c", "d"]),
    (r'a\\\\"b c" d e', [r"a\\b c", "d", "e"]),
    ('"" "" ""', ["", "", ""]),
    ('" x', [" x"]),
    ('"" x', ["", "x"]),
    ('""" x', ['"', "x"]),
    ('"""" x', ['" x']),
    ('""""" x', ['"', "x"]),
    ('"""""" x', ['""', "x"]),
    ('""""""" x', ['"" x']),
    ('"""""""" x', ['""', "x"]),
    ('""""""""" x', ['"""', "x"]),
    ('"""""""""" x', ['""" x']),
    ('""""""""""" x', ['"""', "x"]),
    ('"""""""""""" x', ['""""', "x"]),
    ('""""""""""""" x', ['"""" x']),
    ('"aaa x', ["aaa x"]),
    ('"aaa" x', ["aaa", "x"]),
    ('"aaa"" x', ['aaa"', "x"]),
    ('"aaa""" x', ['aaa" x']),
    ('"aaa"""" x', ['aaa"', "x"]),
    ('"aaa""""" x', ['aaa""', "x"]),
    ('"aaa"""""" x', ['aaa"" x']),
    ('"aaa""""""" x', ['aaa""', "x"]),
    ('"aaa"""""""" x', ['aaa"""', "x"]),
    ('"aaa""""""""" x', ['aaa""" x']),
    ('"aaa"""""""""" x', ['aaa"""', "x"]),
    ('"aaa""""""""""" x', ['aaa""""', "x"]),
    ('"aaa"""""""""""" x', ['aaa"""" x']),
    ('"aaa\\ x', ["aaa\\ x"]),
    ('"aaa\\" x', ['aaa" x']),
    ('"aaa\\"" x', ['aaa"', "x"]),
    ('"aaa\\""" x', ['aaa""', "x"]),
    ('"aaa\\"""" x', ['aaa"" x']),
    ('"aaa\\""""" x', ['aaa""', "x"]),
    ('"aaa\\"""""" x', ['aaa"""', "x"]),
    ('"aaa\\""""""" x', ['aaa""" x']),
    ('"aaa\\"""""""" x', ['aaa"""', "x"]),
    ('"aaa\\""""""""" x', ['aaa""""', "x"]),
    ('"aaa\\"""""""""" x', ['aaa"""" x']),
    ('"aaa\\""""""""""" x', ['aaa""""', "x"]),
    ('"aaa\\"""""""""""" x', ['aaa"""""', "x"]),
    ('"aaa\\\\ x', ["aaa\\\\ x"]),
    ('"aaa\\\\" x', ["aaa\\", "x"]),
    ('"aaa\\\\"" x', ['aaa\\"', "x"]),
    ('"aaa\\\\""" x', ['aaa\\" x']),
    ('"aaa\\\\"""" x', ['aaa\\"', "x"]),
    ('"aaa\\\\""""" x', ['aaa\\""', "x"]),
    ('"aaa\\\\"""""" x', ['aaa\\"" x']),
    ('"aaa\\\\""""""" x', ['aaa\\""', "x"]),
    ('"aaa\\\\"""""""" x', ['aaa\\"""', "x"]),
    ('"aaa\\\\""""""""" x', ['aaa\\""" x']),
    ('"aaa\\\\"""""""""" x', ['aaa\\"""', "x"]),
    ('"aaa\\\\""""""""""" x', ['aaa\\""""', "x"]),
    ('"aaa\\\\"""""""""""" x', ['aaa\\"""" x']),
    ('"aaa\\\\\\ x', ["aaa\\\\\\ x"]),
    ('"aaa\\\\\\" x', ['aaa\\" x']),
    ('"aaa\\\\\\"" x', ['aaa\\"', "x"]),
    ('"aaa\\\\\\""" x', ['aaa\\""', "x"]),
    ('"aaa\\\\\\"""" x', ['aaa\\"" x']),
    ('"aaa\\\\\\""""" x', ['aaa\\""', "x"]),
    ('"aaa\\\\\\"""""" x', ['aaa\\"""', "x"]),
    ('"aaa\\\\\\""""""" x', ['aaa\\""" x']),
    ('"aaa\\\\\\"""""""" x', ['aaa\\"""', "x"]),
    ('"aaa\\\\\\""""""""" x', ['aaa\\""""', "x"]),
    ('"aaa\\\\\\"""""""""" x', ['aaa\\"""" x']),
    ('"aaa\\\\\\""""""""""" x', ['aaa\\""""', "x"]),
    ('"aaa\\\\\\"""""""""""" x', ['aaa\\"""""', "x"]),
    ('"aaa\\\\\\\\ x', ["aaa\\\\\\\\ x"]),
    ('"aaa\\\\\\\\" x', ["aaa\\\\", "x"]),
    ('"aaa\\\\\\\\"" x', ['aaa\\\\"', "x"]),
    ('"aaa\\\\\\\\""" x', ['aaa\\\\" x']),
    ('"aaa\\\\\\\\"""" x', ['aaa\\\\"', "x"]),
    ('"aaa\\\\\\\\""""" x', ['aaa\\\\""', "x"]),
    ('"aaa\\\\\\\\"""""" x', ['aaa\\\\"" x']),
    ('"aaa\\\\\\\\""""""" x', ['aaa\\\\""', "x"]),
    ('"aaa\\\\\\\\"""""""" x', ['aaa\\\\"""', "x"]),
    ('"aaa\\\\\\\\""""""""" x', ['aaa\\\\""" x']),
    ('"aaa\\\\\\\\"""""""""" x', ['aaa\\\\"""', "x"]),
    ('"aaa\\\\\\\\""""""""""" x', ['aaa\\\\""""', "x"]),
    ('"aaa\\\\\\\\"""""""""""" x', ['aaa\\\\"""" x']),
    (" x", ["x"]),
    ('" x', [" x"]),
    ('"" x', ["", "x"]),
    ('""" x', ['"', "x"]),
    ('"""" x', ['" x']),
    ('""""" x', ['"', "x"]),
    ('"""""" x', ['""', "x"]),
    ('""""""" x', ['"" x']),
    ('"""""""" x', ['""', "x"]),
    ('""""""""" x', ['"""', "x"]),
    ('"""""""""" x', ['""" x']),
    ('""""""""""" x', ['"""', "x"]),
    ('"""""""""""" x', ['""""', "x"]),
    ("\\ x", ["\\", "x"]),
    ('\\" x', ['"', "x"]),
    ('\\"" x', ['" x']),
    ('\\""" x', ['"', "x"]),
    ('\\"""" x', ['""', "x"]),
    ('\\""""" x', ['"" x']),
    ('\\"""""" x', ['""', "x"]),
    ('\\""""""" x', ['"""', "x"]),
    ('\\"""""""" x', ['""" x']),
    ('\\""""""""" x', ['"""', "x"]),
    ('\\"""""""""" x', ['""""', "x"]),
    ('\\""""""""""" x', ['"""" x']),
    ('\\"""""""""""" x', ['""""', "x"]),
    ("\\\\ x", ["\\\\", "x"]),
    ('\\\\" x', ["\\ x"]),
    ('\\\\"" x', ["\\", "x"]),
    ('\\\\""" x', ['\\"', "x"]),
    ('\\\\"""" x', ['\\" x']),
    ('\\\\""""" x', ['\\"', "x"]),
    ('\\\\"""""" x', ['\\""', "x"]),
    ('\\\\""""""" x', ['\\"" x']),
    ('\\\\"""""""" x', ['\\""', "x"]),
    ('\\\\""""""""" x', ['\\"""', "x"]),
    ('\\\\"""""""""" x', ['\\""" x']),
    ('\\\\""""""""""" x', ['\\"""', "x"]),
    ('\\\\"""""""""""" x', ['\\""""', "x"]),
    ("\\\\\\ x", ["\\\\\\", "x"]),
    ('\\\\\\" x', ['\\"', "x"]),
    ('\\\\\\"" x', ['\\" x']),
    ('\\\\\\""" x', ['\\"', "x"]),
    ('\\\\\\"""" x', ['\\""', "x"]),
    ('\\\\\\""""" x', ['\\"" x']),
    ('\\\\\\"""""" x', ['\\""', "x"]),
    ('\\\\\\""""""" x', ['\\"""', "x"]),
    ('\\\\\\"""""""" x', ['\\""" x']),
    ('\\\\\\""""""""" x', ['\\"""', "x"]),
    ('\\\\\\"""""""""" x', ['\\""""', "x"]),
    ('\\\\\\""""""""""" x', ['\\"""" x']),
    ('\\\\\\"""""""""""" x', ['\\""""', "x"]),
    ("\\\\\\\\ x", ["\\\\\\\\", "x"]),
    ('\\\\\\\\" x', ["\\\\ x"]),
    ('\\\\\\\\"" x', ["\\\\", "x"]),
    ('\\\\\\\\""" x', ['\\\\"', "x"]),
    ('\\\\\\\\"""" x', ['\\\\" x']),
    ('\\\\\\\\""""" x', ['\\\\"', "x"]),
    ('\\\\\\\\"""""" x', ['\\\\""', "x"]),
    ('\\\\\\\\""""""" x', ['\\\\"" x']),
    ('\\\\\\\\"""""""" x', ['\\\\""', "x"]),
    ('\\\\\\\\""""""""" x', ['\\\\"""', "x"]),
    ('\\\\\\\\"""""""""" x', ['\\\\""" x']),
    ('\\\\\\\\""""""""""" x', ['\\\\"""', "x"]),
    ('\\\\\\\\"""""""""""" x', ['\\\\""""', "x"]),
# my additional cases
    ('"a', ['a']), # 1 "
    ('""a', ['a']),
    ('"""a', ['"a']),
    ('""""a', ['"a']),
    ('"""""a', ['"a']),
    ('""""""a', ['""a']),
    ('"""""""a', ['""a']),
    ('""""""""a', ['""a']),
    ('"""""""""a', ['"""a']),
    ('""""""""""a', ['"""a']),
    ('"""""""""""a', ['"""a']),
    ('""""""""""""a', ['""""a']), #12 "
    ('"a b', ['a b']),             # open
    ('""a b', ['a', 'b']),         # open-close
    ('"""a b', ['"a', 'b']),       # open-quote-close
    ('""""a b', ['"a b']),         # open-quote-close-open
    ('"""""a b', ['"a', 'b']),     # open-quote-close-open-close
    ('""""""a b', ['""a', 'b']),   # open-quote-close x 2
    ('"""""""a b', ['""a b']),     # open-quote-close x 2 - open
    ('""""""""a b', ['""a', 'b']), # open-quote-close x 2 - open-close
    ('"""""""""a b', ['"""a', 'b']),
    ('""""""""""a b', ['"""a b']),
    ('"""""""""""a b', ['"""a', 'b']),
    ('""""""""""""a b', ['""""a', 'b']),
    (r'\"a b', ['"a', 'b']),         # quote
    (r'\""a b', ['"a b']),           # quote-open
    (r'\"""a b', ['"a', 'b']),       # quote-open-close
    (r'\""""a b', ['""a', 'b']),     # quote-open-quote-close
    (r'\"""""a b', ['""a b']),       # quote-open-quote-close-open
    (r'\""""""a b', ['""a', 'b']),   # quote-open-quote-close-open-close
    (r'\"""""""a b', ['"""a', 'b']), # quote-[open-quote-close x 2]
    (r'\""""""""a b', ['"""a b']),
    (r'\"""""""""a b', ['"""a', 'b']),
    (r'\""""""""""a b', ['""""a', 'b']),
    (r'\"""""""""""a b', ['""""a b']),
    (r'\""""""""""""a b', ['""""a', 'b']),
    (r'\\"a b', ['\\a b']),         # backslash-open
    (r'\\""a b', ['\\a', 'b']),     # backslash-open-close
    (r'\\"""a b', ['\\"a', 'b']),   # backslash-open-quote-close
    (r'\\""""a b', ['\\"a b']),     # backslash-open-quote-close-open
    (r'\\"""""a b', ['\\"a', 'b']), # backslash-open-quote-close-open-close
    (r'\\""""""a b', ['\\""a', 'b']),
    (r'\\"""""""a b', ['\\""a b']),
    (r'\\""""""""a b', ['\\""a', 'b']),
    (r'\\"""""""""a b', ['\\"""a', 'b']),
    (r'\\""""""""""a b', ['\\"""a b']),
    (r'\\"""""""""""a b', ['\\"""a', 'b']),
    (r'\\""""""""""""a b', ['\\""""a', 'b']),
    ('"a b" c', ['a b', 'c']),     # open-close
    ('""a b" c', ['a', 'b c']),    # open-close+a b+open
    ('"""a b" c', ['"a', 'b c']),  # open-quote-close+a b+open
    ('""""a b" c', ['"a b', 'c']), # open-quote-close-open+a b-close
    ('"""""a b" c', ['"a', 'b c']),# open-quote-close-open-close+a b+open
    ('""""""a b" c', ['""a', 'b c']),
    ('"""""""a b" c', ['""a b', 'c']),
    ('""""""""a b" c', ['""a', 'b c']),
    ('"""""""""a b" c', ['"""a', 'b c']),
    ('""""""""""a b" c', ['"""a b', 'c']),
    ('"""""""""""a b" c', ['"""a', 'b c']),
    ('""""""""""""a b" c', ['""""a', 'b c']),
    ('"a b"" c', ['a b"', 'c']),          # open+a b+quote-close
    ('""a b"" c', ['a', 'b', 'c']),       # open-close+a b+open-close c
    ('"""a b"" c', ['"a', 'b', 'c']),     # open-quote-close+a b+open-close c
    ('""""a b"" c', ['"a b"', 'c']),      # open-quote-close-open+a b+quote-close c
    ('"""""a b"" c', ['"a', 'b', 'c']),   # open-quote-close-open-close+a b c
    ('""""""a b"" c', ['""a', 'b', 'c']), # open-quote-close x 2 +a b c
    ('"""""""a b"" c', ['""a b"', 'c']),  # open-quote-close x 2 - open+a b+quote-close
    ('""""""""a b"" c', ['""a', 'b', 'c']),
    ('"""""""""a b"" c', ['"""a', 'b', 'c']),
    ('""""""""""a b"" c', ['"""a b"', 'c']),
    ('"""""""""""a b"" c', ['"""a', 'b', 'c']),
    ('""""""""""""a b"" c', ['""""a', 'b', 'c']),
    ('"a b""" c', ['a b" c']), # open+a b+close-quote-open+c
    ('""a b""" c', ['a', 'b"', 'c']),
    ('"""a b""" c', ['"a', 'b"', 'c']),
    ('""""a b""" c', ['"a b" c']),
    ('"""""a b""" c', ['"a', 'b"', 'c']),
    ('""""""a b""" c', ['""a', 'b"', 'c']),
    ('"""""""a b""" c', ['""a b" c']),
    ('""""""""a b""" c', ['""a', 'b"', 'c']),
    ('"""""""""a b""" c', ['"""a', 'b"', 'c']),
    ('""""""""""a b""" c', ['"""a b" c']),
    ('"""""""""""a b""" c', ['"""a', 'b"', 'c']),
    ('""""""""""""a b""" c', ['""""a', 'b"', 'c']),
    (' \t  \\"a     "\\"b   \\"c" \t ', ['"a', '"b   "c']),
    (r'\"a     "\"b   \"c" \\\\\\', ['"a', '"b   "c', '\\\\\\\\\\\\']),
    (r'\"a     "\"b   \"c" \\\\\\"', ['"a', '"b   "c', '\\\\\\']),
    (r'\"a     "\"[!b()]   \"c" []\\\\\\"', ['"a', '"[!b()]   "c', '[]\\\\\\']),
    (r'^|!(["\"])', ['^|!([])']),
    (r'a "<>||&&^', ['po']),
]


n=0
m = 0
for ex in examples:
    a, b, c = split(ex[0]), mslex.split(ex[0],0), ctypes_split(ex[0])
    assert b==c
    if a != b:
        print ('%s differ from mslex: case=<%s> --> res=<%s>' %(a,ex[0],ex[1]))
        n += 1
    d = split(join(a))
    if d != a:
        print('quote failed on <%s>: quoted=<%s>, splitted=<%s>, orig=<%s>' % (a,join(a),d,ex[0]))
        m += 1
if n:
    print('%d/%d tests failed (split)' % (n,len(examples)))
if m:
    print('%d/%d tests failed (quote)' % (m,len(examples)))
if not m and not n:
    print('All %d tests passed!'%len(examples))

assert split(r'"quoted ""block"" continues"', 0) == ctypes_split(r'"quoted ""block"" continues"')
