from holehe.core import *
from holehe.localuseragent import *


async def komoot(email, client, out):
    name = "komoot"
    headers = {
        'User-Agent': random.choice(ua["browsers"]["firefox"]),
        'Accept': '*/*',
        'Accept-Language': 'fr,fr-FR;q=0.8,en-US;q=0.5,en;q=0.3',
        'Content-Type': 'application/json',
        'Origin': 'https://account.komoot.com',
        'Connection': 'keep-alive',
        'Referer': 'https://account.komoot.com/signin',
    }

    data = '{"email":"'+email+'"}'

    try:
        response = await client.post('https://account.komoot.com/v1/signin',headers=headers,data=data)
        if 'login' in response.json()['type']:
            out.append({"name": name,
                        "rateLimit": False,
                        "exists": True,
                        "emailrecovery": None,
                        "phoneNumber": None,
                        "others": None})
        else:
            out.append({"name": name,
                    "rateLimit": False,
                    "exists": False,
                    "emailrecovery": None,
                    "phoneNumber": None,
                    "others": None})
    except :
        out.append({"name": name,
                    "rateLimit": True,
                    "exists": False,
                    "emailrecovery": None,
                    "phoneNumber": None,
                    "others": None})
