# Barrel import for all Dars components and core modules
# Usage: from dars.all import *

# Advanced Components
from dars.components.advanced.accordion import Accordion
from dars.components.advanced.card import Card
from dars.components.advanced.modal import Modal
from dars.components.advanced.navbar import Navbar
from dars.components.advanced.table import Table
from dars.components.advanced.tabs import Tabs
# Basic Components
from dars.components.basic.button import Button
from dars.components.basic.checkbox import Checkbox
from dars.components.basic.container import Container
from dars.components.basic.datepicker import DatePicker
from dars.components.basic.image import Image
from dars.components.basic.input import Input
from dars.components.basic.link import Link
from dars.components.basic.markdown import Markdown
from dars.components.basic.page import Page
from dars.components.basic.progressbar import ProgressBar
from dars.components.basic.radiobutton import RadioButton
from dars.components.basic.select import Select, SelectOption
from dars.components.basic.slider import Slider
from dars.components.basic.spinner import Spinner
from dars.components.basic.text import Text
from dars.components.basic.textarea import Textarea
from dars.components.basic.tooltip import Tooltip
from dars.components.layout.anchor import AnchorPoint
from dars.components.layout.flex import FlexLayout
from dars.components.basic.section import Section
# Layout
from dars.components.layout.grid import GridLayout, LayoutBase
# Core
from dars.core.app import App
from dars.core.component import Component
from dars.core.events import EventHandler, EventEmitter, EventManager
from dars.core.events import EventManager
from dars.core.events import EventTypes
# CLI (optional, for advanced usage)
# from dars.cli.main import main as dars_cli_main
from dars.core.state import dState, Mod, this, this_for
from dars.dars_tests.run_tests import run_app_tests, run_unit_tests, main
# Exporters (optional, for direct use)
from dars.exporters.web.html_css_js import HTMLCSSJSExporter
from dars.scripts.dscript import dScript, RawJS, Arg
from dars.scripts.utils_ds import showModal, hideModal, goTo, goToNew, reload, goBack, goForward, alert, confirm, log, show, hide, toggle, addClass, removeClass, toggleClass, scrollTo, scrollToTop, scrollToBottom, scrollToElement, submitForm, resetForm, getValue, clearInput, saveToLocal, loadFromLocal, removeFromLocal, clearLocalStorage, copyToClipboard, copyElementText, focus, blur, setText, setTimeout
from dars.scripts.script import *
from dars.version import __version__
from dars.backend import createComp, deleteComp
from dars.backend import updateComp
# from dars.core.properties import *

__all__ = [
    'App', 'Component', 'EventManager',
    'Button', 'Checkbox', 'Container', 'DatePicker', 'Image', 'Input', 'Link', 'Page', 'ProgressBar',
    'RadioButton', 'Select', 'Slider', 'Spinner', 'Text', 'Textarea', 'Tooltip',
    'Accordion', 'Card', 'Modal', 'Navbar', 'Table', 'Tabs', 'Section',
    'GridLayout', 'FlexLayout', 'LayoutBase', 'AnchorPoint',
    'InlineScript', 'FileScript', 'dScript', 'HTMLCSSJSExporter',
    'EventTypes', 'EventHandler', 'EventEmitter', 'EventManager', 'Markdown',
    '__version__',
    'run_app_tests', 'run_unit_tests', 'main',
    'dState', 'Mod', 'this_for',
    'createComp', 'deleteComp', 'updateComp', 'RawJS', 'this', 'Arg', 'SelectOption', 
    # Modal utilities
    'showModal', 'hideModal',
    # Navigation utilities
    'goTo', 'goToNew', 'reload', 'goBack', 'goForward',
    # Alert & console utilities
    'alert', 'confirm', 'log',
    # DOM manipulation utilities
    'show', 'hide', 'toggle', 'addClass', 'removeClass', 'toggleClass', 'setText',
    # Scroll utilities
    'scrollTo', 'scrollToTop', 'scrollToBottom', 'scrollToElement',
    # Form utilities
    'submitForm', 'resetForm', 'getValue', 'clearInput',
    # Storage utilities
    'saveToLocal', 'loadFromLocal', 'removeFromLocal', 'clearLocalStorage',
    # Clipboard utilities
    'copyToClipboard', 'copyElementText',
    # Focus utilities
    'focus', 'blur',
    # Timer utilities
    'setTimeout',
]
