"""Utilities for serialization."""

from typing import Optional, Union

import mlflow.entities as mlflow_entities


def serialize_trace(trace: Optional[mlflow_entities.Trace]) -> Optional[str]:
    """
    Serialize a trace object to a JSON string.

    :param trace: The trace
    :return: The JSON string of the trace object
    """
    return trace.to_json() if trace is not None else None


def deserialize_trace(
    trace_json_str: Optional[Union[str, mlflow_entities.Trace]],
) -> Optional[mlflow_entities.Trace]:
    """
    Parse a trace object from a JSON string.
    Assume the input trace JSON string is generated by serialize_trace().

    :param trace_json_str: The JSON string of the trace object, or the object itself
    :return: The trace object
    """
    if trace_json_str is None:
        return None
    if isinstance(trace_json_str, mlflow_entities.Trace):
        return trace_json_str
    try:
        return mlflow_entities.Trace.from_json(trace_json_str)
    except Exception as e:
        raise ValueError("Fail to deserialize trace from JSON string.") from e
