(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(require('jquery'), require('babel-plugin-dedent')) :
	typeof define === 'function' && define.amd ? define(['jquery', 'babel-plugin-dedent'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.$));
})(this, (function (require$$0$1) { 'use strict';

	/*! jQuery UI - v1.13.3 - 2024-04-26
	* https://jqueryui.com
	* Includes: widget.js, position.js, data.js, disable-selection.js, effect.js, effects/effect-blind.js, effects/effect-bounce.js, effects/effect-clip.js, effects/effect-drop.js, effects/effect-explode.js, effects/effect-fade.js, effects/effect-fold.js, effects/effect-highlight.js, effects/effect-puff.js, effects/effect-pulsate.js, effects/effect-scale.js, effects/effect-shake.js, effects/effect-size.js, effects/effect-slide.js, effects/effect-transfer.js, focusable.js, form-reset-mixin.js, jquery-patch.js, keycode.js, labels.js, scroll-parent.js, tabbable.js, unique-id.js, widgets/accordion.js, widgets/autocomplete.js, widgets/button.js, widgets/checkboxradio.js, widgets/controlgroup.js, widgets/datepicker.js, widgets/dialog.js, widgets/draggable.js, widgets/droppable.js, widgets/menu.js, widgets/mouse.js, widgets/progressbar.js, widgets/resizable.js, widgets/selectable.js, widgets/selectmenu.js, widgets/slider.js, widgets/sortable.js, widgets/spinner.js, widgets/tabs.js, widgets/tooltip.js
	* Copyright OpenJS Foundation and other contributors; Licensed MIT */(function(factory){if(typeof define==="function"&&define.amd){// AMD. Register as an anonymous module.
	define(["jquery"],factory);}else {// Browser globals
	factory(jQuery);}})(function($){$.ui=$.ui||{};$.ui.version="1.13.3";/*!
	 * jQuery UI Widget 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Widget
	//>>group: Core
	//>>description: Provides a factory for creating stateful widgets with a common API.
	//>>docs: https://api.jqueryui.com/jQuery.widget/
	//>>demos: https://jqueryui.com/widget/
	var widgetUuid=0;var widgetHasOwnProperty=Array.prototype.hasOwnProperty;var widgetSlice=Array.prototype.slice;$.cleanData=function(orig){return function(elems){var events,elem,i;for(i=0;(elem=elems[i])!=null;i++){// Only trigger remove when necessary to save time
	events=$._data(elem,"events");if(events&&events.remove){$(elem).triggerHandler("remove");}}orig(elems);};}($.cleanData);$.widget=function(name,base,prototype){var existingConstructor,constructor,basePrototype;// ProxiedPrototype allows the provided prototype to remain unmodified
	// so that it can be used as a mixin for multiple widgets (#8876)
	var proxiedPrototype={};var namespace=name.split(".")[0];name=name.split(".")[1];var fullName=namespace+"-"+name;if(!prototype){prototype=base;base=$.Widget;}if(Array.isArray(prototype)){prototype=$.extend.apply(null,[{}].concat(prototype));}// Create selector for plugin
	$.expr.pseudos[fullName.toLowerCase()]=function(elem){return !!$.data(elem,fullName);};$[namespace]=$[namespace]||{};existingConstructor=$[namespace][name];constructor=$[namespace][name]=function(options,element){// Allow instantiation without "new" keyword
	if(!this||!this._createWidget){return new constructor(options,element);}// Allow instantiation without initializing for simple inheritance
	// must use "new" keyword (the code above always passes args)
	if(arguments.length){this._createWidget(options,element);}};// Extend with the existing constructor to carry over any static properties
	$.extend(constructor,existingConstructor,{version:prototype.version,// Copy the object used to create the prototype in case we need to
	// redefine the widget later
	_proto:$.extend({},prototype),// Track widgets that inherit from this widget in case this widget is
	// redefined after a widget inherits from it
	_childConstructors:[]});basePrototype=new base();// We need to make the options hash a property directly on the new instance
	// otherwise we'll modify the options hash on the prototype that we're
	// inheriting from
	basePrototype.options=$.widget.extend({},basePrototype.options);$.each(prototype,function(prop,value){if(typeof value!=="function"){proxiedPrototype[prop]=value;return;}proxiedPrototype[prop]=function(){function _super(){return base.prototype[prop].apply(this,arguments);}function _superApply(args){return base.prototype[prop].apply(this,args);}return function(){var __super=this._super;var __superApply=this._superApply;var returnValue;this._super=_super;this._superApply=_superApply;returnValue=value.apply(this,arguments);this._super=__super;this._superApply=__superApply;return returnValue;};}();});constructor.prototype=$.widget.extend(basePrototype,{// TODO: remove support for widgetEventPrefix
	// always use the name + a colon as the prefix, e.g., draggable:start
	// don't prefix for widgets that aren't DOM-based
	widgetEventPrefix:existingConstructor?basePrototype.widgetEventPrefix||name:name},proxiedPrototype,{constructor:constructor,namespace:namespace,widgetName:name,widgetFullName:fullName});// If this widget is being redefined then we need to find all widgets that
	// are inheriting from it and redefine all of them so that they inherit from
	// the new version of this widget. We're essentially trying to replace one
	// level in the prototype chain.
	if(existingConstructor){$.each(existingConstructor._childConstructors,function(i,child){var childPrototype=child.prototype;// Redefine the child widget using the same prototype that was
	// originally used, but inherit from the new version of the base
	$.widget(childPrototype.namespace+"."+childPrototype.widgetName,constructor,child._proto);});// Remove the list of existing child constructors from the old constructor
	// so the old child constructors can be garbage collected
	delete existingConstructor._childConstructors;}else {base._childConstructors.push(constructor);}$.widget.bridge(name,constructor);return constructor;};$.widget.extend=function(target){var input=widgetSlice.call(arguments,1);var inputIndex=0;var inputLength=input.length;var key;var value;for(;inputIndex<inputLength;inputIndex++){for(key in input[inputIndex]){value=input[inputIndex][key];if(widgetHasOwnProperty.call(input[inputIndex],key)&&value!==undefined){// Clone objects
	if($.isPlainObject(value)){target[key]=$.isPlainObject(target[key])?$.widget.extend({},target[key],value):// Don't extend strings, arrays, etc. with objects
	$.widget.extend({},value);// Copy everything else by reference
	}else {target[key]=value;}}}}return target;};$.widget.bridge=function(name,object){var fullName=object.prototype.widgetFullName||name;$.fn[name]=function(options){var isMethodCall=typeof options==="string";var args=widgetSlice.call(arguments,1);var returnValue=this;if(isMethodCall){// If this is an empty collection, we need to have the instance method
	// return undefined instead of the jQuery instance
	if(!this.length&&options==="instance"){returnValue=undefined;}else {this.each(function(){var methodValue;var instance=$.data(this,fullName);if(options==="instance"){returnValue=instance;return false;}if(!instance){return $.error("cannot call methods on "+name+" prior to initialization; "+"attempted to call method '"+options+"'");}if(typeof instance[options]!=="function"||options.charAt(0)==="_"){return $.error("no such method '"+options+"' for "+name+" widget instance");}methodValue=instance[options].apply(instance,args);if(methodValue!==instance&&methodValue!==undefined){returnValue=methodValue&&methodValue.jquery?returnValue.pushStack(methodValue.get()):methodValue;return false;}});}}else {// Allow multiple hashes to be passed on init
	if(args.length){options=$.widget.extend.apply(null,[options].concat(args));}this.each(function(){var instance=$.data(this,fullName);if(instance){instance.option(options||{});if(instance._init){instance._init();}}else {$.data(this,fullName,new object(options,this));}});}return returnValue;};};$.Widget=function/* options, element */(){};$.Widget._childConstructors=[];$.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{classes:{},disabled:false,// Callbacks
	create:null},_createWidget:function(options,element){element=$(element||this.defaultElement||this)[0];this.element=$(element);this.uuid=widgetUuid++;this.eventNamespace="."+this.widgetName+this.uuid;this.bindings=$();this.hoverable=$();this.focusable=$();this.classesElementLookup={};if(element!==this){$.data(element,this.widgetFullName,this);this._on(true,this.element,{remove:function(event){if(event.target===element){this.destroy();}}});this.document=$(element.style?// Element within the document
	element.ownerDocument:// Element is window or document
	element.document||element);this.window=$(this.document[0].defaultView||this.document[0].parentWindow);}this.options=$.widget.extend({},this.options,this._getCreateOptions(),options);this._create();if(this.options.disabled){this._setOptionDisabled(this.options.disabled);}this._trigger("create",null,this._getCreateEventData());this._init();},_getCreateOptions:function(){return {};},_getCreateEventData:$.noop,_create:$.noop,_init:$.noop,destroy:function(){var that=this;this._destroy();$.each(this.classesElementLookup,function(key,value){that._removeClass(value,key);});// We can probably remove the unbind calls in 2.0
	// all event bindings should go through this._on()
	this.element.off(this.eventNamespace).removeData(this.widgetFullName);this.widget().off(this.eventNamespace).removeAttr("aria-disabled");// Clean up events and states
	this.bindings.off(this.eventNamespace);},_destroy:$.noop,widget:function(){return this.element;},option:function(key,value){var options=key;var parts;var curOption;var i;if(arguments.length===0){// Don't return a reference to the internal hash
	return $.widget.extend({},this.options);}if(typeof key==="string"){// Handle nested keys, e.g., "foo.bar" => { foo: { bar: ___ } }
	options={};parts=key.split(".");key=parts.shift();if(parts.length){curOption=options[key]=$.widget.extend({},this.options[key]);for(i=0;i<parts.length-1;i++){curOption[parts[i]]=curOption[parts[i]]||{};curOption=curOption[parts[i]];}key=parts.pop();if(arguments.length===1){return curOption[key]===undefined?null:curOption[key];}curOption[key]=value;}else {if(arguments.length===1){return this.options[key]===undefined?null:this.options[key];}options[key]=value;}}this._setOptions(options);return this;},_setOptions:function(options){var key;for(key in options){this._setOption(key,options[key]);}return this;},_setOption:function(key,value){if(key==="classes"){this._setOptionClasses(value);}this.options[key]=value;if(key==="disabled"){this._setOptionDisabled(value);}return this;},_setOptionClasses:function(value){var classKey,elements,currentElements;for(classKey in value){currentElements=this.classesElementLookup[classKey];if(value[classKey]===this.options.classes[classKey]||!currentElements||!currentElements.length){continue;}// We are doing this to create a new jQuery object because the _removeClass() call
	// on the next line is going to destroy the reference to the current elements being
	// tracked. We need to save a copy of this collection so that we can add the new classes
	// below.
	elements=$(currentElements.get());this._removeClass(currentElements,classKey);// We don't use _addClass() here, because that uses this.options.classes
	// for generating the string of classes. We want to use the value passed in from
	// _setOption(), this is the new value of the classes option which was passed to
	// _setOption(). We pass this value directly to _classes().
	elements.addClass(this._classes({element:elements,keys:classKey,classes:value,add:true}));}},_setOptionDisabled:function(value){this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!!value);// If the widget is becoming disabled, then nothing is interactive
	if(value){this._removeClass(this.hoverable,null,"ui-state-hover");this._removeClass(this.focusable,null,"ui-state-focus");}},enable:function(){return this._setOptions({disabled:false});},disable:function(){return this._setOptions({disabled:true});},_classes:function(options){var full=[];var that=this;options=$.extend({element:this.element,classes:this.options.classes||{}},options);function bindRemoveEvent(){var nodesToBind=[];options.element.each(function(_,element){var isTracked=$.map(that.classesElementLookup,function(elements){return elements;}).some(function(elements){return elements.is(element);});if(!isTracked){nodesToBind.push(element);}});that._on($(nodesToBind),{remove:"_untrackClassesElement"});}function processClassString(classes,checkOption){var current,i;for(i=0;i<classes.length;i++){current=that.classesElementLookup[classes[i]]||$();if(options.add){bindRemoveEvent();current=$($.uniqueSort(current.get().concat(options.element.get())));}else {current=$(current.not(options.element).get());}that.classesElementLookup[classes[i]]=current;full.push(classes[i]);if(checkOption&&options.classes[classes[i]]){full.push(options.classes[classes[i]]);}}}if(options.keys){processClassString(options.keys.match(/\S+/g)||[],true);}if(options.extra){processClassString(options.extra.match(/\S+/g)||[]);}return full.join(" ");},_untrackClassesElement:function(event){var that=this;$.each(that.classesElementLookup,function(key,value){if($.inArray(event.target,value)!==-1){that.classesElementLookup[key]=$(value.not(event.target).get());}});this._off($(event.target));},_removeClass:function(element,keys,extra){return this._toggleClass(element,keys,extra,false);},_addClass:function(element,keys,extra){return this._toggleClass(element,keys,extra,true);},_toggleClass:function(element,keys,extra,add){add=typeof add==="boolean"?add:extra;var shift=typeof element==="string"||element===null,options={extra:shift?keys:extra,keys:shift?element:keys,element:shift?this.element:element,add:add};options.element.toggleClass(this._classes(options),add);return this;},_on:function(suppressDisabledCheck,element,handlers){var delegateElement;var instance=this;// No suppressDisabledCheck flag, shuffle arguments
	if(typeof suppressDisabledCheck!=="boolean"){handlers=element;element=suppressDisabledCheck;suppressDisabledCheck=false;}// No element argument, shuffle and use this.element
	if(!handlers){handlers=element;element=this.element;delegateElement=this.widget();}else {element=delegateElement=$(element);this.bindings=this.bindings.add(element);}$.each(handlers,function(event,handler){function handlerProxy(){// Allow widgets to customize the disabled handling
	// - disabled as an array instead of boolean
	// - disabled class as method for disabling individual parts
	if(!suppressDisabledCheck&&(instance.options.disabled===true||$(this).hasClass("ui-state-disabled"))){return;}return (typeof handler==="string"?instance[handler]:handler).apply(instance,arguments);}// Copy the guid so direct unbinding works
	if(typeof handler!=="string"){handlerProxy.guid=handler.guid=handler.guid||handlerProxy.guid||$.guid++;}var match=event.match(/^([\w:-]*)\s*(.*)$/);var eventName=match[1]+instance.eventNamespace;var selector=match[2];if(selector){delegateElement.on(eventName,selector,handlerProxy);}else {element.on(eventName,handlerProxy);}});},_off:function(element,eventName){eventName=(eventName||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace;element.off(eventName);// Clear the stack to avoid memory leaks (#10056)
	this.bindings=$(this.bindings.not(element).get());this.focusable=$(this.focusable.not(element).get());this.hoverable=$(this.hoverable.not(element).get());},_delay:function(handler,delay){function handlerProxy(){return (typeof handler==="string"?instance[handler]:handler).apply(instance,arguments);}var instance=this;return setTimeout(handlerProxy,delay||0);},_hoverable:function(element){this.hoverable=this.hoverable.add(element);this._on(element,{mouseenter:function(event){this._addClass($(event.currentTarget),null,"ui-state-hover");},mouseleave:function(event){this._removeClass($(event.currentTarget),null,"ui-state-hover");}});},_focusable:function(element){this.focusable=this.focusable.add(element);this._on(element,{focusin:function(event){this._addClass($(event.currentTarget),null,"ui-state-focus");},focusout:function(event){this._removeClass($(event.currentTarget),null,"ui-state-focus");}});},_trigger:function(type,event,data){var prop,orig;var callback=this.options[type];data=data||{};event=$.Event(event);event.type=(type===this.widgetEventPrefix?type:this.widgetEventPrefix+type).toLowerCase();// The original event may come from any element
	// so we need to reset the target on the new event
	event.target=this.element[0];// Copy original event properties over to the new event
	orig=event.originalEvent;if(orig){for(prop in orig){if(!(prop in event)){event[prop]=orig[prop];}}}this.element.trigger(event,data);return !(typeof callback==="function"&&callback.apply(this.element[0],[event].concat(data))===false||event.isDefaultPrevented());}};$.each({show:"fadeIn",hide:"fadeOut"},function(method,defaultEffect){$.Widget.prototype["_"+method]=function(element,options,callback){if(typeof options==="string"){options={effect:options};}var hasOptions;var effectName=!options?method:options===true||typeof options==="number"?defaultEffect:options.effect||defaultEffect;options=options||{};if(typeof options==="number"){options={duration:options};}else if(options===true){options={};}hasOptions=!$.isEmptyObject(options);options.complete=callback;if(options.delay){element.delay(options.delay);}if(hasOptions&&$.effects&&$.effects.effect[effectName]){element[method](options);}else if(effectName!==method&&element[effectName]){element[effectName](options.duration,options.easing,callback);}else {element.queue(function(next){$(this)[method]();if(callback){callback.call(element[0]);}next();});}};});$.widget;/*!
	 * jQuery UI Position 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *
	 * https://api.jqueryui.com/position/
	 *///>>label: Position
	//>>group: Core
	//>>description: Positions elements relative to other elements.
	//>>docs: https://api.jqueryui.com/position/
	//>>demos: https://jqueryui.com/position/
	(function(){var cachedScrollbarWidth,max=Math.max,abs=Math.abs,rhorizontal=/left|center|right/,rvertical=/top|center|bottom/,roffset=/[\+\-]\d+(\.[\d]+)?%?/,rposition=/^\w+/,rpercent=/%$/,_position=$.fn.position;function getOffsets(offsets,width,height){return [parseFloat(offsets[0])*(rpercent.test(offsets[0])?width/100:1),parseFloat(offsets[1])*(rpercent.test(offsets[1])?height/100:1)];}function parseCss(element,property){return parseInt($.css(element,property),10)||0;}function isWindow(obj){return obj!=null&&obj===obj.window;}function getDimensions(elem){var raw=elem[0];if(raw.nodeType===9){return {width:elem.width(),height:elem.height(),offset:{top:0,left:0}};}if(isWindow(raw)){return {width:elem.width(),height:elem.height(),offset:{top:elem.scrollTop(),left:elem.scrollLeft()}};}if(raw.preventDefault){return {width:0,height:0,offset:{top:raw.pageY,left:raw.pageX}};}return {width:elem.outerWidth(),height:elem.outerHeight(),offset:elem.offset()};}$.position={scrollbarWidth:function(){if(cachedScrollbarWidth!==undefined){return cachedScrollbarWidth;}var w1,w2,div=$("<div style="+"'display:block;position:absolute;width:200px;height:200px;overflow:hidden;'>"+"<div style='height:300px;width:auto;'></div></div>"),innerDiv=div.children()[0];$("body").append(div);w1=innerDiv.offsetWidth;div.css("overflow","scroll");w2=innerDiv.offsetWidth;if(w1===w2){w2=div[0].clientWidth;}div.remove();return cachedScrollbarWidth=w1-w2;},getScrollInfo:function(within){var overflowX=within.isWindow||within.isDocument?"":within.element.css("overflow-x"),overflowY=within.isWindow||within.isDocument?"":within.element.css("overflow-y"),hasOverflowX=overflowX==="scroll"||overflowX==="auto"&&within.width<within.element[0].scrollWidth,hasOverflowY=overflowY==="scroll"||overflowY==="auto"&&within.height<within.element[0].scrollHeight;return {width:hasOverflowY?$.position.scrollbarWidth():0,height:hasOverflowX?$.position.scrollbarWidth():0};},getWithinInfo:function(element){var withinElement=$(element||window),isElemWindow=isWindow(withinElement[0]),isDocument=!!withinElement[0]&&withinElement[0].nodeType===9,hasOffset=!isElemWindow&&!isDocument;return {element:withinElement,isWindow:isElemWindow,isDocument:isDocument,offset:hasOffset?$(element).offset():{left:0,top:0},scrollLeft:withinElement.scrollLeft(),scrollTop:withinElement.scrollTop(),width:withinElement.outerWidth(),height:withinElement.outerHeight()};}};$.fn.position=function(options){if(!options||!options.of){return _position.apply(this,arguments);}// Make a copy, we don't want to modify arguments
	options=$.extend({},options);var atOffset,targetWidth,targetHeight,targetOffset,basePosition,dimensions,// Make sure string options are treated as CSS selectors
	target=typeof options.of==="string"?$(document).find(options.of):$(options.of),within=$.position.getWithinInfo(options.within),scrollInfo=$.position.getScrollInfo(within),collision=(options.collision||"flip").split(" "),offsets={};dimensions=getDimensions(target);if(target[0].preventDefault){// Force left top to allow flipping
	options.at="left top";}targetWidth=dimensions.width;targetHeight=dimensions.height;targetOffset=dimensions.offset;// Clone to reuse original targetOffset later
	basePosition=$.extend({},targetOffset);// Force my and at to have valid horizontal and vertical positions
	// if a value is missing or invalid, it will be converted to center
	$.each(["my","at"],function(){var pos=(options[this]||"").split(" "),horizontalOffset,verticalOffset;if(pos.length===1){pos=rhorizontal.test(pos[0])?pos.concat(["center"]):rvertical.test(pos[0])?["center"].concat(pos):["center","center"];}pos[0]=rhorizontal.test(pos[0])?pos[0]:"center";pos[1]=rvertical.test(pos[1])?pos[1]:"center";// Calculate offsets
	horizontalOffset=roffset.exec(pos[0]);verticalOffset=roffset.exec(pos[1]);offsets[this]=[horizontalOffset?horizontalOffset[0]:0,verticalOffset?verticalOffset[0]:0];// Reduce to just the positions without the offsets
	options[this]=[rposition.exec(pos[0])[0],rposition.exec(pos[1])[0]];});// Normalize collision option
	if(collision.length===1){collision[1]=collision[0];}if(options.at[0]==="right"){basePosition.left+=targetWidth;}else if(options.at[0]==="center"){basePosition.left+=targetWidth/2;}if(options.at[1]==="bottom"){basePosition.top+=targetHeight;}else if(options.at[1]==="center"){basePosition.top+=targetHeight/2;}atOffset=getOffsets(offsets.at,targetWidth,targetHeight);basePosition.left+=atOffset[0];basePosition.top+=atOffset[1];return this.each(function(){var collisionPosition,using,elem=$(this),elemWidth=elem.outerWidth(),elemHeight=elem.outerHeight(),marginLeft=parseCss(this,"marginLeft"),marginTop=parseCss(this,"marginTop"),collisionWidth=elemWidth+marginLeft+parseCss(this,"marginRight")+scrollInfo.width,collisionHeight=elemHeight+marginTop+parseCss(this,"marginBottom")+scrollInfo.height,position=$.extend({},basePosition),myOffset=getOffsets(offsets.my,elem.outerWidth(),elem.outerHeight());if(options.my[0]==="right"){position.left-=elemWidth;}else if(options.my[0]==="center"){position.left-=elemWidth/2;}if(options.my[1]==="bottom"){position.top-=elemHeight;}else if(options.my[1]==="center"){position.top-=elemHeight/2;}position.left+=myOffset[0];position.top+=myOffset[1];collisionPosition={marginLeft:marginLeft,marginTop:marginTop};$.each(["left","top"],function(i,dir){if($.ui.position[collision[i]]){$.ui.position[collision[i]][dir](position,{targetWidth:targetWidth,targetHeight:targetHeight,elemWidth:elemWidth,elemHeight:elemHeight,collisionPosition:collisionPosition,collisionWidth:collisionWidth,collisionHeight:collisionHeight,offset:[atOffset[0]+myOffset[0],atOffset[1]+myOffset[1]],my:options.my,at:options.at,within:within,elem:elem});}});if(options.using){// Adds feedback as second argument to using callback, if present
	using=function(props){var left=targetOffset.left-position.left,right=left+targetWidth-elemWidth,top=targetOffset.top-position.top,bottom=top+targetHeight-elemHeight,feedback={target:{element:target,left:targetOffset.left,top:targetOffset.top,width:targetWidth,height:targetHeight},element:{element:elem,left:position.left,top:position.top,width:elemWidth,height:elemHeight},horizontal:right<0?"left":left>0?"right":"center",vertical:bottom<0?"top":top>0?"bottom":"middle"};if(targetWidth<elemWidth&&abs(left+right)<targetWidth){feedback.horizontal="center";}if(targetHeight<elemHeight&&abs(top+bottom)<targetHeight){feedback.vertical="middle";}if(max(abs(left),abs(right))>max(abs(top),abs(bottom))){feedback.important="horizontal";}else {feedback.important="vertical";}options.using.call(this,props,feedback);};}elem.offset($.extend(position,{using:using}));});};$.ui.position={fit:{left:function(position,data){var within=data.within,withinOffset=within.isWindow?within.scrollLeft:within.offset.left,outerWidth=within.width,collisionPosLeft=position.left-data.collisionPosition.marginLeft,overLeft=withinOffset-collisionPosLeft,overRight=collisionPosLeft+data.collisionWidth-outerWidth-withinOffset,newOverRight;// Element is wider than within
	if(data.collisionWidth>outerWidth){// Element is initially over the left side of within
	if(overLeft>0&&overRight<=0){newOverRight=position.left+overLeft+data.collisionWidth-outerWidth-withinOffset;position.left+=overLeft-newOverRight;// Element is initially over right side of within
	}else if(overRight>0&&overLeft<=0){position.left=withinOffset;// Element is initially over both left and right sides of within
	}else {if(overLeft>overRight){position.left=withinOffset+outerWidth-data.collisionWidth;}else {position.left=withinOffset;}}// Too far left -> align with left edge
	}else if(overLeft>0){position.left+=overLeft;// Too far right -> align with right edge
	}else if(overRight>0){position.left-=overRight;// Adjust based on position and margin
	}else {position.left=max(position.left-collisionPosLeft,position.left);}},top:function(position,data){var within=data.within,withinOffset=within.isWindow?within.scrollTop:within.offset.top,outerHeight=data.within.height,collisionPosTop=position.top-data.collisionPosition.marginTop,overTop=withinOffset-collisionPosTop,overBottom=collisionPosTop+data.collisionHeight-outerHeight-withinOffset,newOverBottom;// Element is taller than within
	if(data.collisionHeight>outerHeight){// Element is initially over the top of within
	if(overTop>0&&overBottom<=0){newOverBottom=position.top+overTop+data.collisionHeight-outerHeight-withinOffset;position.top+=overTop-newOverBottom;// Element is initially over bottom of within
	}else if(overBottom>0&&overTop<=0){position.top=withinOffset;// Element is initially over both top and bottom of within
	}else {if(overTop>overBottom){position.top=withinOffset+outerHeight-data.collisionHeight;}else {position.top=withinOffset;}}// Too far up -> align with top
	}else if(overTop>0){position.top+=overTop;// Too far down -> align with bottom edge
	}else if(overBottom>0){position.top-=overBottom;// Adjust based on position and margin
	}else {position.top=max(position.top-collisionPosTop,position.top);}}},flip:{left:function(position,data){var within=data.within,withinOffset=within.offset.left+within.scrollLeft,outerWidth=within.width,offsetLeft=within.isWindow?within.scrollLeft:within.offset.left,collisionPosLeft=position.left-data.collisionPosition.marginLeft,overLeft=collisionPosLeft-offsetLeft,overRight=collisionPosLeft+data.collisionWidth-outerWidth-offsetLeft,myOffset=data.my[0]==="left"?-data.elemWidth:data.my[0]==="right"?data.elemWidth:0,atOffset=data.at[0]==="left"?data.targetWidth:data.at[0]==="right"?-data.targetWidth:0,offset=-2*data.offset[0],newOverRight,newOverLeft;if(overLeft<0){newOverRight=position.left+myOffset+atOffset+offset+data.collisionWidth-outerWidth-withinOffset;if(newOverRight<0||newOverRight<abs(overLeft)){position.left+=myOffset+atOffset+offset;}}else if(overRight>0){newOverLeft=position.left-data.collisionPosition.marginLeft+myOffset+atOffset+offset-offsetLeft;if(newOverLeft>0||abs(newOverLeft)<overRight){position.left+=myOffset+atOffset+offset;}}},top:function(position,data){var within=data.within,withinOffset=within.offset.top+within.scrollTop,outerHeight=within.height,offsetTop=within.isWindow?within.scrollTop:within.offset.top,collisionPosTop=position.top-data.collisionPosition.marginTop,overTop=collisionPosTop-offsetTop,overBottom=collisionPosTop+data.collisionHeight-outerHeight-offsetTop,top=data.my[1]==="top",myOffset=top?-data.elemHeight:data.my[1]==="bottom"?data.elemHeight:0,atOffset=data.at[1]==="top"?data.targetHeight:data.at[1]==="bottom"?-data.targetHeight:0,offset=-2*data.offset[1],newOverTop,newOverBottom;if(overTop<0){newOverBottom=position.top+myOffset+atOffset+offset+data.collisionHeight-outerHeight-withinOffset;if(newOverBottom<0||newOverBottom<abs(overTop)){position.top+=myOffset+atOffset+offset;}}else if(overBottom>0){newOverTop=position.top-data.collisionPosition.marginTop+myOffset+atOffset+offset-offsetTop;if(newOverTop>0||abs(newOverTop)<overBottom){position.top+=myOffset+atOffset+offset;}}}},flipfit:{left:function(){$.ui.position.flip.left.apply(this,arguments);$.ui.position.fit.left.apply(this,arguments);},top:function(){$.ui.position.flip.top.apply(this,arguments);$.ui.position.fit.top.apply(this,arguments);}}};})();$.ui.position;/*!
	 * jQuery UI :data 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: :data Selector
	//>>group: Core
	//>>description: Selects elements which have data stored under the specified key.
	//>>docs: https://api.jqueryui.com/data-selector/
	$.extend($.expr.pseudos,{data:$.expr.createPseudo?$.expr.createPseudo(function(dataName){return function(elem){return !!$.data(elem,dataName);};}):// Support: jQuery <1.8
	function(elem,i,match){return !!$.data(elem,match[3]);}});/*!
	 * jQuery UI Disable Selection 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: disableSelection
	//>>group: Core
	//>>description: Disable selection of text content within the set of matched elements.
	//>>docs: https://api.jqueryui.com/disableSelection/
	// This file is deprecated
	$.fn.extend({disableSelection:function(){var eventType="onselectstart"in document.createElement("div")?"selectstart":"mousedown";return function(){return this.on(eventType+".ui-disableSelection",function(event){event.preventDefault();});};}(),enableSelection:function(){return this.off(".ui-disableSelection");}});// Create a local jQuery because jQuery Color relies on it and the
	// global may not exist with AMD and a custom build (#10199).
	// This module is a noop if used as a regular AMD module.
	// eslint-disable-next-line no-unused-vars
	var jQuery=$;/*!
	 * jQuery Color Animations v2.2.0
	 * https://github.com/jquery/jquery-color
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *
	 * Date: Sun May 10 09:02:36 2020 +0200
	 */var stepHooks="backgroundColor borderBottomColor borderLeftColor borderRightColor "+"borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor",class2type={},toString=class2type.toString,// plusequals test for += 100 -= 100
	rplusequals=/^([\-+])=\s*(\d+\.?\d*)/,// a set of RE's that can match strings and generate color tuples.
	stringParsers=[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(execResult){return [execResult[1],execResult[2],execResult[3],execResult[4]];}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(execResult){return [execResult[1]*2.55,execResult[2]*2.55,execResult[3]*2.55,execResult[4]];}},{// this regex ignores A-F because it's compared against an already lowercased string
	re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?/,parse:function(execResult){return [parseInt(execResult[1],16),parseInt(execResult[2],16),parseInt(execResult[3],16),execResult[4]?(parseInt(execResult[4],16)/255).toFixed(2):1];}},{// this regex ignores A-F because it's compared against an already lowercased string
	re:/#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?/,parse:function(execResult){return [parseInt(execResult[1]+execResult[1],16),parseInt(execResult[2]+execResult[2],16),parseInt(execResult[3]+execResult[3],16),execResult[4]?(parseInt(execResult[4]+execResult[4],16)/255).toFixed(2):1];}},{re:/hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,space:"hsla",parse:function(execResult){return [execResult[1],execResult[2]/100,execResult[3]/100,execResult[4]];}}],// jQuery.Color( )
	color=jQuery.Color=function(color,green,blue,alpha){return new jQuery.Color.fn.parse(color,green,blue,alpha);},spaces={rgba:{props:{red:{idx:0,type:"byte"},green:{idx:1,type:"byte"},blue:{idx:2,type:"byte"}}},hsla:{props:{hue:{idx:0,type:"degrees"},saturation:{idx:1,type:"percent"},lightness:{idx:2,type:"percent"}}}},propTypes={"byte":{floor:true,max:255},"percent":{max:1},"degrees":{mod:360,floor:true}},support=color.support={},// element for support tests
	supportElem=jQuery("<p>")[0],// colors = jQuery.Color.names
	colors,// local aliases of functions called often
	each=jQuery.each;// determine rgba support immediately
	supportElem.style.cssText="background-color:rgba(1,1,1,.5)";support.rgba=supportElem.style.backgroundColor.indexOf("rgba")>-1;// define cache name and alpha properties
	// for rgba and hsla spaces
	each(spaces,function(spaceName,space){space.cache="_"+spaceName;space.props.alpha={idx:3,type:"percent",def:1};});// Populate the class2type map
	jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(_i,name){class2type["[object "+name+"]"]=name.toLowerCase();});function getType(obj){if(obj==null){return obj+"";}return typeof obj==="object"?class2type[toString.call(obj)]||"object":typeof obj;}function clamp(value,prop,allowEmpty){var type=propTypes[prop.type]||{};if(value==null){return allowEmpty||!prop.def?null:prop.def;}// ~~ is an short way of doing floor for positive numbers
	value=type.floor?~~value:parseFloat(value);// IE will pass in empty strings as value for alpha,
	// which will hit this case
	if(isNaN(value)){return prop.def;}if(type.mod){// we add mod before modding to make sure that negatives values
	// get converted properly: -10 -> 350
	return (value+type.mod)%type.mod;}// for now all property types without mod have min and max
	return Math.min(type.max,Math.max(0,value));}function stringParse(string){var inst=color(),rgba=inst._rgba=[];string=string.toLowerCase();each(stringParsers,function(_i,parser){var parsed,match=parser.re.exec(string),values=match&&parser.parse(match),spaceName=parser.space||"rgba";if(values){parsed=inst[spaceName](values);// if this was an rgba parse the assignment might happen twice
	// oh well....
	inst[spaces[spaceName].cache]=parsed[spaces[spaceName].cache];rgba=inst._rgba=parsed._rgba;// exit each( stringParsers ) here because we matched
	return false;}});// Found a stringParser that handled it
	if(rgba.length){// if this came from a parsed string, force "transparent" when alpha is 0
	// chrome, (and maybe others) return "transparent" as rgba(0,0,0,0)
	if(rgba.join()==="0,0,0,0"){jQuery.extend(rgba,colors.transparent);}return inst;}// named colors
	return colors[string];}color.fn=jQuery.extend(color.prototype,{parse:function(red,green,blue,alpha){if(red===undefined){this._rgba=[null,null,null,null];return this;}if(red.jquery||red.nodeType){red=jQuery(red).css(green);green=undefined;}var inst=this,type=getType(red),rgba=this._rgba=[];// more than 1 argument specified - assume ( red, green, blue, alpha )
	if(green!==undefined){red=[red,green,blue,alpha];type="array";}if(type==="string"){return this.parse(stringParse(red)||colors._default);}if(type==="array"){each(spaces.rgba.props,function(_key,prop){rgba[prop.idx]=clamp(red[prop.idx],prop);});return this;}if(type==="object"){if(red instanceof color){each(spaces,function(_spaceName,space){if(red[space.cache]){inst[space.cache]=red[space.cache].slice();}});}else {each(spaces,function(_spaceName,space){var cache=space.cache;each(space.props,function(key,prop){// if the cache doesn't exist, and we know how to convert
	if(!inst[cache]&&space.to){// if the value was null, we don't need to copy it
	// if the key was alpha, we don't need to copy it either
	if(key==="alpha"||red[key]==null){return;}inst[cache]=space.to(inst._rgba);}// this is the only case where we allow nulls for ALL properties.
	// call clamp with alwaysAllowEmpty
	inst[cache][prop.idx]=clamp(red[key],prop,true);});// everything defined but alpha?
	if(inst[cache]&&jQuery.inArray(null,inst[cache].slice(0,3))<0){// use the default of 1
	if(inst[cache][3]==null){inst[cache][3]=1;}if(space.from){inst._rgba=space.from(inst[cache]);}}});}return this;}},is:function(compare){var is=color(compare),same=true,inst=this;each(spaces,function(_,space){var localCache,isCache=is[space.cache];if(isCache){localCache=inst[space.cache]||space.to&&space.to(inst._rgba)||[];each(space.props,function(_,prop){if(isCache[prop.idx]!=null){same=isCache[prop.idx]===localCache[prop.idx];return same;}});}return same;});return same;},_space:function(){var used=[],inst=this;each(spaces,function(spaceName,space){if(inst[space.cache]){used.push(spaceName);}});return used.pop();},transition:function(other,distance){var end=color(other),spaceName=end._space(),space=spaces[spaceName],startColor=this.alpha()===0?color("transparent"):this,start=startColor[space.cache]||space.to(startColor._rgba),result=start.slice();end=end[space.cache];each(space.props,function(_key,prop){var index=prop.idx,startValue=start[index],endValue=end[index],type=propTypes[prop.type]||{};// if null, don't override start value
	if(endValue===null){return;}// if null - use end
	if(startValue===null){result[index]=endValue;}else {if(type.mod){if(endValue-startValue>type.mod/2){startValue+=type.mod;}else if(startValue-endValue>type.mod/2){startValue-=type.mod;}}result[index]=clamp((endValue-startValue)*distance+startValue,prop);}});return this[spaceName](result);},blend:function(opaque){// if we are already opaque - return ourself
	if(this._rgba[3]===1){return this;}var rgb=this._rgba.slice(),a=rgb.pop(),blend=color(opaque)._rgba;return color(jQuery.map(rgb,function(v,i){return (1-a)*blend[i]+a*v;}));},toRgbaString:function(){var prefix="rgba(",rgba=jQuery.map(this._rgba,function(v,i){if(v!=null){return v;}return i>2?1:0;});if(rgba[3]===1){rgba.pop();prefix="rgb(";}return prefix+rgba.join()+")";},toHslaString:function(){var prefix="hsla(",hsla=jQuery.map(this.hsla(),function(v,i){if(v==null){v=i>2?1:0;}// catch 1 and 2
	if(i&&i<3){v=Math.round(v*100)+"%";}return v;});if(hsla[3]===1){hsla.pop();prefix="hsl(";}return prefix+hsla.join()+")";},toHexString:function(includeAlpha){var rgba=this._rgba.slice(),alpha=rgba.pop();if(includeAlpha){rgba.push(~~(alpha*255));}return "#"+jQuery.map(rgba,function(v){// default to 0 when nulls exist
	v=(v||0).toString(16);return v.length===1?"0"+v:v;}).join("");},toString:function(){return this._rgba[3]===0?"transparent":this.toRgbaString();}});color.fn.parse.prototype=color.fn;// hsla conversions adapted from:
	// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021
	function hue2rgb(p,q,h){h=(h+1)%1;if(h*6<1){return p+(q-p)*h*6;}if(h*2<1){return q;}if(h*3<2){return p+(q-p)*(2/3-h)*6;}return p;}spaces.hsla.to=function(rgba){if(rgba[0]==null||rgba[1]==null||rgba[2]==null){return [null,null,null,rgba[3]];}var r=rgba[0]/255,g=rgba[1]/255,b=rgba[2]/255,a=rgba[3],max=Math.max(r,g,b),min=Math.min(r,g,b),diff=max-min,add=max+min,l=add*0.5,h,s;if(min===max){h=0;}else if(r===max){h=60*(g-b)/diff+360;}else if(g===max){h=60*(b-r)/diff+120;}else {h=60*(r-g)/diff+240;}// chroma (diff) == 0 means greyscale which, by definition, saturation = 0%
	// otherwise, saturation is based on the ratio of chroma (diff) to lightness (add)
	if(diff===0){s=0;}else if(l<=0.5){s=diff/add;}else {s=diff/(2-add);}return [Math.round(h)%360,s,l,a==null?1:a];};spaces.hsla.from=function(hsla){if(hsla[0]==null||hsla[1]==null||hsla[2]==null){return [null,null,null,hsla[3]];}var h=hsla[0]/360,s=hsla[1],l=hsla[2],a=hsla[3],q=l<=0.5?l*(1+s):l+s-l*s,p=2*l-q;return [Math.round(hue2rgb(p,q,h+1/3)*255),Math.round(hue2rgb(p,q,h)*255),Math.round(hue2rgb(p,q,h-1/3)*255),a];};each(spaces,function(spaceName,space){var props=space.props,cache=space.cache,to=space.to,from=space.from;// makes rgba() and hsla()
	color.fn[spaceName]=function(value){// generate a cache for this space if it doesn't exist
	if(to&&!this[cache]){this[cache]=to(this._rgba);}if(value===undefined){return this[cache].slice();}var ret,type=getType(value),arr=type==="array"||type==="object"?value:arguments,local=this[cache].slice();each(props,function(key,prop){var val=arr[type==="object"?key:prop.idx];if(val==null){val=local[prop.idx];}local[prop.idx]=clamp(val,prop);});if(from){ret=color(from(local));ret[cache]=local;return ret;}else {return color(local);}};// makes red() green() blue() alpha() hue() saturation() lightness()
	each(props,function(key,prop){// alpha is included in more than one space
	if(color.fn[key]){return;}color.fn[key]=function(value){var local,cur,match,fn,vtype=getType(value);if(key==="alpha"){fn=this._hsla?"hsla":"rgba";}else {fn=spaceName;}local=this[fn]();cur=local[prop.idx];if(vtype==="undefined"){return cur;}if(vtype==="function"){value=value.call(this,cur);vtype=getType(value);}if(value==null&&prop.empty){return this;}if(vtype==="string"){match=rplusequals.exec(value);if(match){value=cur+parseFloat(match[2])*(match[1]==="+"?1:-1);}}local[prop.idx]=value;return this[fn](local);};});});// add cssHook and .fx.step function for each named hook.
	// accept a space separated string of properties
	color.hook=function(hook){var hooks=hook.split(" ");each(hooks,function(_i,hook){jQuery.cssHooks[hook]={set:function(elem,value){var parsed,curElem,backgroundColor="";if(value!=="transparent"&&(getType(value)!=="string"||(parsed=stringParse(value)))){value=color(parsed||value);if(!support.rgba&&value._rgba[3]!==1){curElem=hook==="backgroundColor"?elem.parentNode:elem;while((backgroundColor===""||backgroundColor==="transparent")&&curElem&&curElem.style){try{backgroundColor=jQuery.css(curElem,"backgroundColor");curElem=curElem.parentNode;}catch(e){}}value=value.blend(backgroundColor&&backgroundColor!=="transparent"?backgroundColor:"_default");}value=value.toRgbaString();}try{elem.style[hook]=value;}catch(e){// wrapped to prevent IE from throwing errors on "invalid" values like 'auto' or 'inherit'
	}}};jQuery.fx.step[hook]=function(fx){if(!fx.colorInit){fx.start=color(fx.elem,hook);fx.end=color(fx.end);fx.colorInit=true;}jQuery.cssHooks[hook].set(fx.elem,fx.start.transition(fx.end,fx.pos));};});};color.hook(stepHooks);jQuery.cssHooks.borderColor={expand:function(value){var expanded={};each(["Top","Right","Bottom","Left"],function(_i,part){expanded["border"+part+"Color"]=value;});return expanded;}};// Basic color names only.
	// Usage of any of the other color names requires adding yourself or including
	// jquery.color.svg-names.js.
	colors=jQuery.Color.names={// 4.1. Basic color keywords
	aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00",// 4.2.3. "transparent" color keyword
	transparent:[null,null,null,0],_default:"#ffffff"};/*!
	 * jQuery UI Effects 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Effects Core
	//>>group: Effects
	/* eslint-disable max-len *///>>description: Extends the internal jQuery effects. Includes morphing and easing. Required by all other effects.
	/* eslint-enable max-len *///>>docs: https://api.jqueryui.com/category/effects-core/
	//>>demos: https://jqueryui.com/effect/
	var dataSpace="ui-effects-",dataSpaceStyle="ui-effects-style",dataSpaceAnimated="ui-effects-animated";$.effects={effect:{}};/******************************************************************************//****************************** CLASS ANIMATIONS ******************************//******************************************************************************/(function(){var classAnimationActions=["add","remove","toggle"],shorthandStyles={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};$.each(["borderLeftStyle","borderRightStyle","borderBottomStyle","borderTopStyle"],function(_,prop){$.fx.step[prop]=function(fx){if(fx.end!=="none"&&!fx.setAttr||fx.pos===1&&!fx.setAttr){jQuery.style(fx.elem,prop,fx.end);fx.setAttr=true;}};});function camelCase(string){return string.replace(/-([\da-z])/gi,function(all,letter){return letter.toUpperCase();});}function getElementStyles(elem){var key,len,style=elem.ownerDocument.defaultView?elem.ownerDocument.defaultView.getComputedStyle(elem,null):elem.currentStyle,styles={};if(style&&style.length&&style[0]&&style[style[0]]){len=style.length;while(len--){key=style[len];if(typeof style[key]==="string"){styles[camelCase(key)]=style[key];}}// Support: Opera, IE <9
	}else {for(key in style){if(typeof style[key]==="string"){styles[key]=style[key];}}}return styles;}function styleDifference(oldStyle,newStyle){var diff={},name,value;for(name in newStyle){value=newStyle[name];if(oldStyle[name]!==value){if(!shorthandStyles[name]){if($.fx.step[name]||!isNaN(parseFloat(value))){diff[name]=value;}}}}return diff;}// Support: jQuery <1.8
	if(!$.fn.addBack){$.fn.addBack=function(selector){return this.add(selector==null?this.prevObject:this.prevObject.filter(selector));};}$.effects.animateClass=function(value,duration,easing,callback){var o=$.speed(duration,easing,callback);return this.queue(function(){var animated=$(this),baseClass=animated.attr("class")||"",applyClassChange,allAnimations=o.children?animated.find("*").addBack():animated;// Map the animated objects to store the original styles.
	allAnimations=allAnimations.map(function(){var el=$(this);return {el:el,start:getElementStyles(this)};});// Apply class change
	applyClassChange=function(){$.each(classAnimationActions,function(i,action){if(value[action]){animated[action+"Class"](value[action]);}});};applyClassChange();// Map all animated objects again - calculate new styles and diff
	allAnimations=allAnimations.map(function(){this.end=getElementStyles(this.el[0]);this.diff=styleDifference(this.start,this.end);return this;});// Apply original class
	animated.attr("class",baseClass);// Map all animated objects again - this time collecting a promise
	allAnimations=allAnimations.map(function(){var styleInfo=this,dfd=$.Deferred(),opts=$.extend({},o,{queue:false,complete:function(){dfd.resolve(styleInfo);}});this.el.animate(this.diff,opts);return dfd.promise();});// Once all animations have completed:
	$.when.apply($,allAnimations.get()).done(function(){// Set the final class
	applyClassChange();// For each animated element,
	// clear all css properties that were animated
	$.each(arguments,function(){var el=this.el;$.each(this.diff,function(key){el.css(key,"");});});// This is guarnteed to be there if you use jQuery.speed()
	// it also handles dequeuing the next anim...
	o.complete.call(animated[0]);});});};$.fn.extend({addClass:function(orig){return function(classNames,speed,easing,callback){return speed?$.effects.animateClass.call(this,{add:classNames},speed,easing,callback):orig.apply(this,arguments);};}($.fn.addClass),removeClass:function(orig){return function(classNames,speed,easing,callback){return arguments.length>1?$.effects.animateClass.call(this,{remove:classNames},speed,easing,callback):orig.apply(this,arguments);};}($.fn.removeClass),toggleClass:function(orig){return function(classNames,force,speed,easing,callback){if(typeof force==="boolean"||force===undefined){if(!speed){// Without speed parameter
	return orig.apply(this,arguments);}else {return $.effects.animateClass.call(this,force?{add:classNames}:{remove:classNames},speed,easing,callback);}}else {// Without force parameter
	return $.effects.animateClass.call(this,{toggle:classNames},force,speed,easing);}};}($.fn.toggleClass),switchClass:function(remove,add,speed,easing,callback){return $.effects.animateClass.call(this,{add:add,remove:remove},speed,easing,callback);}});})();/******************************************************************************//*********************************** EFFECTS **********************************//******************************************************************************/(function(){if($.expr&&$.expr.pseudos&&$.expr.pseudos.animated){$.expr.pseudos.animated=function(orig){return function(elem){return !!$(elem).data(dataSpaceAnimated)||orig(elem);};}($.expr.pseudos.animated);}if($.uiBackCompat!==false){$.extend($.effects,{// Saves a set of properties in a data storage
	save:function(element,set){var i=0,length=set.length;for(;i<length;i++){if(set[i]!==null){element.data(dataSpace+set[i],element[0].style[set[i]]);}}},// Restores a set of previously saved properties from a data storage
	restore:function(element,set){var val,i=0,length=set.length;for(;i<length;i++){if(set[i]!==null){val=element.data(dataSpace+set[i]);element.css(set[i],val);}}},setMode:function(el,mode){if(mode==="toggle"){mode=el.is(":hidden")?"show":"hide";}return mode;},// Wraps the element around a wrapper that copies position properties
	createWrapper:function(element){// If the element is already wrapped, return it
	if(element.parent().is(".ui-effects-wrapper")){return element.parent();}// Wrap the element
	var props={width:element.outerWidth(true),height:element.outerHeight(true),"float":element.css("float")},wrapper=$("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),// Store the size in case width/height are defined in % - Fixes #5245
	size={width:element.width(),height:element.height()},active=document.activeElement;// Support: Firefox
	// Firefox incorrectly exposes anonymous content
	// https://bugzilla.mozilla.org/show_bug.cgi?id=561664
	try{// eslint-disable-next-line no-unused-expressions
	active.id;}catch(e){active=document.body;}element.wrap(wrapper);// Fixes #7595 - Elements lose focus when wrapped.
	if(element[0]===active||$.contains(element[0],active)){$(active).trigger("focus");}// Hotfix for jQuery 1.4 since some change in wrap() seems to actually
	// lose the reference to the wrapped element
	wrapper=element.parent();// Transfer positioning properties to the wrapper
	if(element.css("position")==="static"){wrapper.css({position:"relative"});element.css({position:"relative"});}else {$.extend(props,{position:element.css("position"),zIndex:element.css("z-index")});$.each(["top","left","bottom","right"],function(i,pos){props[pos]=element.css(pos);if(isNaN(parseInt(props[pos],10))){props[pos]="auto";}});element.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"});}element.css(size);return wrapper.css(props).show();},removeWrapper:function(element){var active=document.activeElement;if(element.parent().is(".ui-effects-wrapper")){element.parent().replaceWith(element);// Fixes #7595 - Elements lose focus when wrapped.
	if(element[0]===active||$.contains(element[0],active)){$(active).trigger("focus");}}return element;}});}$.extend($.effects,{version:"1.13.3",define:function(name,mode,effect){if(!effect){effect=mode;mode="effect";}$.effects.effect[name]=effect;$.effects.effect[name].mode=mode;return effect;},scaledDimensions:function(element,percent,direction){if(percent===0){return {height:0,width:0,outerHeight:0,outerWidth:0};}var x=direction!=="horizontal"?(percent||100)/100:1,y=direction!=="vertical"?(percent||100)/100:1;return {height:element.height()*y,width:element.width()*x,outerHeight:element.outerHeight()*y,outerWidth:element.outerWidth()*x};},clipToBox:function(animation){return {width:animation.clip.right-animation.clip.left,height:animation.clip.bottom-animation.clip.top,left:animation.clip.left,top:animation.clip.top};},// Injects recently queued functions to be first in line (after "inprogress")
	unshift:function(element,queueLength,count){var queue=element.queue();if(queueLength>1){queue.splice.apply(queue,[1,0].concat(queue.splice(queueLength,count)));}element.dequeue();},saveStyle:function(element){element.data(dataSpaceStyle,element[0].style.cssText);},restoreStyle:function(element){element[0].style.cssText=element.data(dataSpaceStyle)||"";element.removeData(dataSpaceStyle);},mode:function(element,mode){var hidden=element.is(":hidden");if(mode==="toggle"){mode=hidden?"show":"hide";}if(hidden?mode==="hide":mode==="show"){mode="none";}return mode;},// Translates a [top,left] array into a baseline value
	getBaseline:function(origin,original){var y,x;switch(origin[0]){case"top":y=0;break;case"middle":y=0.5;break;case"bottom":y=1;break;default:y=origin[0]/original.height;}switch(origin[1]){case"left":x=0;break;case"center":x=0.5;break;case"right":x=1;break;default:x=origin[1]/original.width;}return {x:x,y:y};},// Creates a placeholder element so that the original element can be made absolute
	createPlaceholder:function(element){var placeholder,cssPosition=element.css("position"),position=element.position();// Lock in margins first to account for form elements, which
	// will change margin if you explicitly set height
	// see: https://jsfiddle.net/JZSMt/3/ https://bugs.webkit.org/show_bug.cgi?id=107380
	// Support: Safari
	element.css({marginTop:element.css("marginTop"),marginBottom:element.css("marginBottom"),marginLeft:element.css("marginLeft"),marginRight:element.css("marginRight")}).outerWidth(element.outerWidth()).outerHeight(element.outerHeight());if(/^(static|relative)/.test(cssPosition)){cssPosition="absolute";placeholder=$("<"+element[0].nodeName+">").insertAfter(element).css({// Convert inline to inline block to account for inline elements
	// that turn to inline block based on content (like img)
	display:/^(inline|ruby)/.test(element.css("display"))?"inline-block":"block",visibility:"hidden",// Margins need to be set to account for margin collapse
	marginTop:element.css("marginTop"),marginBottom:element.css("marginBottom"),marginLeft:element.css("marginLeft"),marginRight:element.css("marginRight"),"float":element.css("float")}).outerWidth(element.outerWidth()).outerHeight(element.outerHeight()).addClass("ui-effects-placeholder");element.data(dataSpace+"placeholder",placeholder);}element.css({position:cssPosition,left:position.left,top:position.top});return placeholder;},removePlaceholder:function(element){var dataKey=dataSpace+"placeholder",placeholder=element.data(dataKey);if(placeholder){placeholder.remove();element.removeData(dataKey);}},// Removes a placeholder if it exists and restores
	// properties that were modified during placeholder creation
	cleanUp:function(element){$.effects.restoreStyle(element);$.effects.removePlaceholder(element);},setTransition:function(element,list,factor,value){value=value||{};$.each(list,function(i,x){var unit=element.cssUnit(x);if(unit[0]>0){value[x]=unit[0]*factor+unit[1];}});return value;}});// Return an effect options object for the given parameters:
	function _normalizeArguments(effect,options,speed,callback){// Allow passing all options as the first parameter
	if($.isPlainObject(effect)){options=effect;effect=effect.effect;}// Convert to an object
	effect={effect:effect};// Catch (effect, null, ...)
	if(options==null){options={};}// Catch (effect, callback)
	if(typeof options==="function"){callback=options;speed=null;options={};}// Catch (effect, speed, ?)
	if(typeof options==="number"||$.fx.speeds[options]){callback=speed;speed=options;options={};}// Catch (effect, options, callback)
	if(typeof speed==="function"){callback=speed;speed=null;}// Add options to effect
	if(options){$.extend(effect,options);}speed=speed||options.duration;effect.duration=$.fx.off?0:typeof speed==="number"?speed:speed in $.fx.speeds?$.fx.speeds[speed]:$.fx.speeds._default;effect.complete=callback||options.complete;return effect;}function standardAnimationOption(option){// Valid standard speeds (nothing, number, named speed)
	if(!option||typeof option==="number"||$.fx.speeds[option]){return true;}// Invalid strings - treat as "normal" speed
	if(typeof option==="string"&&!$.effects.effect[option]){return true;}// Complete callback
	if(typeof option==="function"){return true;}// Options hash (but not naming an effect)
	if(typeof option==="object"&&!option.effect){return true;}// Didn't match any standard API
	return false;}$.fn.extend({effect:function/* effect, options, speed, callback */(){var args=_normalizeArguments.apply(this,arguments),effectMethod=$.effects.effect[args.effect],defaultMode=effectMethod.mode,queue=args.queue,queueName=queue||"fx",complete=args.complete,mode=args.mode,modes=[],prefilter=function(next){var el=$(this),normalizedMode=$.effects.mode(el,mode)||defaultMode;// Sentinel for duck-punching the :animated pseudo-selector
	el.data(dataSpaceAnimated,true);// Save effect mode for later use,
	// we can't just call $.effects.mode again later,
	// as the .show() below destroys the initial state
	modes.push(normalizedMode);// See $.uiBackCompat inside of run() for removal of defaultMode in 1.14
	if(defaultMode&&(normalizedMode==="show"||normalizedMode===defaultMode&&normalizedMode==="hide")){el.show();}if(!defaultMode||normalizedMode!=="none"){$.effects.saveStyle(el);}if(typeof next==="function"){next();}};if($.fx.off||!effectMethod){// Delegate to the original method (e.g., .show()) if possible
	if(mode){return this[mode](args.duration,complete);}else {return this.each(function(){if(complete){complete.call(this);}});}}function run(next){var elem=$(this);function cleanup(){elem.removeData(dataSpaceAnimated);$.effects.cleanUp(elem);if(args.mode==="hide"){elem.hide();}done();}function done(){if(typeof complete==="function"){complete.call(elem[0]);}if(typeof next==="function"){next();}}// Override mode option on a per element basis,
	// as toggle can be either show or hide depending on element state
	args.mode=modes.shift();if($.uiBackCompat!==false&&!defaultMode){if(elem.is(":hidden")?mode==="hide":mode==="show"){// Call the core method to track "olddisplay" properly
	elem[mode]();done();}else {effectMethod.call(elem[0],args,done);}}else {if(args.mode==="none"){// Call the core method to track "olddisplay" properly
	elem[mode]();done();}else {effectMethod.call(elem[0],args,cleanup);}}}// Run prefilter on all elements first to ensure that
	// any showing or hiding happens before placeholder creation,
	// which ensures that any layout changes are correctly captured.
	return queue===false?this.each(prefilter).each(run):this.queue(queueName,prefilter).queue(queueName,run);},show:function(orig){return function(option){if(standardAnimationOption(option)){return orig.apply(this,arguments);}else {var args=_normalizeArguments.apply(this,arguments);args.mode="show";return this.effect.call(this,args);}};}($.fn.show),hide:function(orig){return function(option){if(standardAnimationOption(option)){return orig.apply(this,arguments);}else {var args=_normalizeArguments.apply(this,arguments);args.mode="hide";return this.effect.call(this,args);}};}($.fn.hide),toggle:function(orig){return function(option){if(standardAnimationOption(option)||typeof option==="boolean"){return orig.apply(this,arguments);}else {var args=_normalizeArguments.apply(this,arguments);args.mode="toggle";return this.effect.call(this,args);}};}($.fn.toggle),cssUnit:function(key){var style=this.css(key),val=[];$.each(["em","px","%","pt"],function(i,unit){if(style.indexOf(unit)>0){val=[parseFloat(style),unit];}});return val;},cssClip:function(clipObj){if(clipObj){return this.css("clip","rect("+clipObj.top+"px "+clipObj.right+"px "+clipObj.bottom+"px "+clipObj.left+"px)");}return parseClip(this.css("clip"),this);},transfer:function(options,done){var element=$(this),target=$(options.to),targetFixed=target.css("position")==="fixed",body=$("body"),fixTop=targetFixed?body.scrollTop():0,fixLeft=targetFixed?body.scrollLeft():0,endPosition=target.offset(),animation={top:endPosition.top-fixTop,left:endPosition.left-fixLeft,height:target.innerHeight(),width:target.innerWidth()},startPosition=element.offset(),transfer=$("<div class='ui-effects-transfer'></div>");transfer.appendTo("body").addClass(options.className).css({top:startPosition.top-fixTop,left:startPosition.left-fixLeft,height:element.innerHeight(),width:element.innerWidth(),position:targetFixed?"fixed":"absolute"}).animate(animation,options.duration,options.easing,function(){transfer.remove();if(typeof done==="function"){done();}});}});function parseClip(str,element){var outerWidth=element.outerWidth(),outerHeight=element.outerHeight(),clipRegex=/^rect\((-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto)\)$/,values=clipRegex.exec(str)||["",0,outerWidth,outerHeight,0];return {top:parseFloat(values[1])||0,right:values[2]==="auto"?outerWidth:parseFloat(values[2]),bottom:values[3]==="auto"?outerHeight:parseFloat(values[3]),left:parseFloat(values[4])||0};}$.fx.step.clip=function(fx){if(!fx.clipInit){fx.start=$(fx.elem).cssClip();if(typeof fx.end==="string"){fx.end=parseClip(fx.end,fx.elem);}fx.clipInit=true;}$(fx.elem).cssClip({top:fx.pos*(fx.end.top-fx.start.top)+fx.start.top,right:fx.pos*(fx.end.right-fx.start.right)+fx.start.right,bottom:fx.pos*(fx.end.bottom-fx.start.bottom)+fx.start.bottom,left:fx.pos*(fx.end.left-fx.start.left)+fx.start.left});};})();/******************************************************************************//*********************************** EASING ***********************************//******************************************************************************/(function(){// Based on easing equations from Robert Penner (http://robertpenner.com/easing)
	var baseEasings={};$.each(["Quad","Cubic","Quart","Quint","Expo"],function(i,name){baseEasings[name]=function(p){return Math.pow(p,i+2);};});$.extend(baseEasings,{Sine:function(p){return 1-Math.cos(p*Math.PI/2);},Circ:function(p){return 1-Math.sqrt(1-p*p);},Elastic:function(p){return p===0||p===1?p:-Math.pow(2,8*(p-1))*Math.sin(((p-1)*80-7.5)*Math.PI/15);},Back:function(p){return p*p*(3*p-2);},Bounce:function(p){var pow2,bounce=4;while(p<((pow2=Math.pow(2,--bounce))-1)/11){}return 1/Math.pow(4,3-bounce)-7.5625*Math.pow((pow2*3-2)/22-p,2);}});$.each(baseEasings,function(name,easeIn){$.easing["easeIn"+name]=easeIn;$.easing["easeOut"+name]=function(p){return 1-easeIn(1-p);};$.easing["easeInOut"+name]=function(p){return p<0.5?easeIn(p*2)/2:1-easeIn(p*-2+2)/2;};});})();$.effects;/*!
	 * jQuery UI Effects Blind 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Blind Effect
	//>>group: Effects
	//>>description: Blinds the element.
	//>>docs: https://api.jqueryui.com/blind-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("blind","hide",function(options,done){var map={up:["bottom","top"],vertical:["bottom","top"],down:["top","bottom"],left:["right","left"],horizontal:["right","left"],right:["left","right"]},element=$(this),direction=options.direction||"up",start=element.cssClip(),animate={clip:$.extend({},start)},placeholder=$.effects.createPlaceholder(element);animate.clip[map[direction][0]]=animate.clip[map[direction][1]];if(options.mode==="show"){element.cssClip(animate.clip);if(placeholder){placeholder.css($.effects.clipToBox(animate));}animate.clip=start;}if(placeholder){placeholder.animate($.effects.clipToBox(animate),options.duration,options.easing);}element.animate(animate,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
	 * jQuery UI Effects Bounce 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Bounce Effect
	//>>group: Effects
	//>>description: Bounces an element horizontally or vertically n times.
	//>>docs: https://api.jqueryui.com/bounce-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("bounce",function(options,done){var upAnim,downAnim,refValue,element=$(this),// Defaults:
	mode=options.mode,hide=mode==="hide",show=mode==="show",direction=options.direction||"up",distance=options.distance,times=options.times||5,// Number of internal animations
	anims=times*2+(show||hide?1:0),speed=options.duration/anims,easing=options.easing,// Utility:
	ref=direction==="up"||direction==="down"?"top":"left",motion=direction==="up"||direction==="left",i=0,queuelen=element.queue().length;$.effects.createPlaceholder(element);refValue=element.css(ref);// Default distance for the BIGGEST bounce is the outer Distance / 3
	if(!distance){distance=element[ref==="top"?"outerHeight":"outerWidth"]()/3;}if(show){downAnim={opacity:1};downAnim[ref]=refValue;// If we are showing, force opacity 0 and set the initial position
	// then do the "first" animation
	element.css("opacity",0).css(ref,motion?-distance*2:distance*2).animate(downAnim,speed,easing);}// Start at the smallest distance if we are hiding
	if(hide){distance=distance/Math.pow(2,times-1);}downAnim={};downAnim[ref]=refValue;// Bounces up/down/left/right then back to 0 -- times * 2 animations happen here
	for(;i<times;i++){upAnim={};upAnim[ref]=(motion?"-=":"+=")+distance;element.animate(upAnim,speed,easing).animate(downAnim,speed,easing);distance=hide?distance*2:distance/2;}// Last Bounce when Hiding
	if(hide){upAnim={opacity:0};upAnim[ref]=(motion?"-=":"+=")+distance;element.animate(upAnim,speed,easing);}element.queue(done);$.effects.unshift(element,queuelen,anims+1);});/*!
	 * jQuery UI Effects Clip 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Clip Effect
	//>>group: Effects
	//>>description: Clips the element on and off like an old TV.
	//>>docs: https://api.jqueryui.com/clip-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("clip","hide",function(options,done){var start,animate={},element=$(this),direction=options.direction||"vertical",both=direction==="both",horizontal=both||direction==="horizontal",vertical=both||direction==="vertical";start=element.cssClip();animate.clip={top:vertical?(start.bottom-start.top)/2:start.top,right:horizontal?(start.right-start.left)/2:start.right,bottom:vertical?(start.bottom-start.top)/2:start.bottom,left:horizontal?(start.right-start.left)/2:start.left};$.effects.createPlaceholder(element);if(options.mode==="show"){element.cssClip(animate.clip);animate.clip=start;}element.animate(animate,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
	 * jQuery UI Effects Drop 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Drop Effect
	//>>group: Effects
	//>>description: Moves an element in one direction and hides it at the same time.
	//>>docs: https://api.jqueryui.com/drop-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("drop","hide",function(options,done){var distance,element=$(this),mode=options.mode,show=mode==="show",direction=options.direction||"left",ref=direction==="up"||direction==="down"?"top":"left",motion=direction==="up"||direction==="left"?"-=":"+=",oppositeMotion=motion==="+="?"-=":"+=",animation={opacity:0};$.effects.createPlaceholder(element);distance=options.distance||element[ref==="top"?"outerHeight":"outerWidth"](true)/2;animation[ref]=motion+distance;if(show){element.css(animation);animation[ref]=oppositeMotion+distance;animation.opacity=1;}// Animate
	element.animate(animation,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
	 * jQuery UI Effects Explode 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Explode Effect
	//>>group: Effects
	/* eslint-disable max-len *///>>description: Explodes an element in all directions into n pieces. Implodes an element to its original wholeness.
	/* eslint-enable max-len *///>>docs: https://api.jqueryui.com/explode-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("explode","hide",function(options,done){var i,j,left,top,mx,my,rows=options.pieces?Math.round(Math.sqrt(options.pieces)):3,cells=rows,element=$(this),mode=options.mode,show=mode==="show",// Show and then visibility:hidden the element before calculating offset
	offset=element.show().css("visibility","hidden").offset(),// Width and height of a piece
	width=Math.ceil(element.outerWidth()/cells),height=Math.ceil(element.outerHeight()/rows),pieces=[];// Children animate complete:
	function childComplete(){pieces.push(this);if(pieces.length===rows*cells){animComplete();}}// Clone the element for each row and cell.
	for(i=0;i<rows;i++){// ===>
	top=offset.top+i*height;my=i-(rows-1)/2;for(j=0;j<cells;j++){// |||
	left=offset.left+j*width;mx=j-(cells-1)/2;// Create a clone of the now hidden main element that will be absolute positioned
	// within a wrapper div off the -left and -top equal to size of our pieces
	element.clone().appendTo("body").wrap("<div></div>").css({position:"absolute",visibility:"visible",left:-j*width,top:-i*height})// Select the wrapper - make it overflow: hidden and absolute positioned based on
	// where the original was located +left and +top equal to the size of pieces
	.parent().addClass("ui-effects-explode").css({position:"absolute",overflow:"hidden",width:width,height:height,left:left+(show?mx*width:0),top:top+(show?my*height:0),opacity:show?0:1}).animate({left:left+(show?0:mx*width),top:top+(show?0:my*height),opacity:show?1:0},options.duration||500,options.easing,childComplete);}}function animComplete(){element.css({visibility:"visible"});$(pieces).remove();done();}});/*!
	 * jQuery UI Effects Fade 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Fade Effect
	//>>group: Effects
	//>>description: Fades the element.
	//>>docs: https://api.jqueryui.com/fade-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("fade","toggle",function(options,done){var show=options.mode==="show";$(this).css("opacity",show?0:1).animate({opacity:show?1:0},{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
	 * jQuery UI Effects Fold 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Fold Effect
	//>>group: Effects
	//>>description: Folds an element first horizontally and then vertically.
	//>>docs: https://api.jqueryui.com/fold-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("fold","hide",function(options,done){// Create element
	var element=$(this),mode=options.mode,show=mode==="show",hide=mode==="hide",size=options.size||15,percent=/([0-9]+)%/.exec(size),horizFirst=!!options.horizFirst,ref=horizFirst?["right","bottom"]:["bottom","right"],duration=options.duration/2,placeholder=$.effects.createPlaceholder(element),start=element.cssClip(),animation1={clip:$.extend({},start)},animation2={clip:$.extend({},start)},distance=[start[ref[0]],start[ref[1]]],queuelen=element.queue().length;if(percent){size=parseInt(percent[1],10)/100*distance[hide?0:1];}animation1.clip[ref[0]]=size;animation2.clip[ref[0]]=size;animation2.clip[ref[1]]=0;if(show){element.cssClip(animation2.clip);if(placeholder){placeholder.css($.effects.clipToBox(animation2));}animation2.clip=start;}// Animate
	element.queue(function(next){if(placeholder){placeholder.animate($.effects.clipToBox(animation1),duration,options.easing).animate($.effects.clipToBox(animation2),duration,options.easing);}next();}).animate(animation1,duration,options.easing).animate(animation2,duration,options.easing).queue(done);$.effects.unshift(element,queuelen,4);});/*!
	 * jQuery UI Effects Highlight 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Highlight Effect
	//>>group: Effects
	//>>description: Highlights the background of an element in a defined color for a custom duration.
	//>>docs: https://api.jqueryui.com/highlight-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("highlight","show",function(options,done){var element=$(this),animation={backgroundColor:element.css("backgroundColor")};if(options.mode==="hide"){animation.opacity=0;}$.effects.saveStyle(element);element.css({backgroundImage:"none",backgroundColor:options.color||"#ffff99"}).animate(animation,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
	 * jQuery UI Effects Size 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Size Effect
	//>>group: Effects
	//>>description: Resize an element to a specified width and height.
	//>>docs: https://api.jqueryui.com/size-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("size",function(options,done){// Create element
	var baseline,factor,temp,element=$(this),// Copy for children
	cProps=["fontSize"],vProps=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],hProps=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],// Set options
	mode=options.mode,restore=mode!=="effect",scale=options.scale||"both",origin=options.origin||["middle","center"],position=element.css("position"),pos=element.position(),original=$.effects.scaledDimensions(element),from=options.from||original,to=options.to||$.effects.scaledDimensions(element,0);$.effects.createPlaceholder(element);if(mode==="show"){temp=from;from=to;to=temp;}// Set scaling factor
	factor={from:{y:from.height/original.height,x:from.width/original.width},to:{y:to.height/original.height,x:to.width/original.width}};// Scale the css box
	if(scale==="box"||scale==="both"){// Vertical props scaling
	if(factor.from.y!==factor.to.y){from=$.effects.setTransition(element,vProps,factor.from.y,from);to=$.effects.setTransition(element,vProps,factor.to.y,to);}// Horizontal props scaling
	if(factor.from.x!==factor.to.x){from=$.effects.setTransition(element,hProps,factor.from.x,from);to=$.effects.setTransition(element,hProps,factor.to.x,to);}}// Scale the content
	if(scale==="content"||scale==="both"){// Vertical props scaling
	if(factor.from.y!==factor.to.y){from=$.effects.setTransition(element,cProps,factor.from.y,from);to=$.effects.setTransition(element,cProps,factor.to.y,to);}}// Adjust the position properties based on the provided origin points
	if(origin){baseline=$.effects.getBaseline(origin,original);from.top=(original.outerHeight-from.outerHeight)*baseline.y+pos.top;from.left=(original.outerWidth-from.outerWidth)*baseline.x+pos.left;to.top=(original.outerHeight-to.outerHeight)*baseline.y+pos.top;to.left=(original.outerWidth-to.outerWidth)*baseline.x+pos.left;}delete from.outerHeight;delete from.outerWidth;element.css(from);// Animate the children if desired
	if(scale==="content"||scale==="both"){vProps=vProps.concat(["marginTop","marginBottom"]).concat(cProps);hProps=hProps.concat(["marginLeft","marginRight"]);// Only animate children with width attributes specified
	// TODO: is this right? should we include anything with css width specified as well
	element.find("*[width]").each(function(){var child=$(this),childOriginal=$.effects.scaledDimensions(child),childFrom={height:childOriginal.height*factor.from.y,width:childOriginal.width*factor.from.x,outerHeight:childOriginal.outerHeight*factor.from.y,outerWidth:childOriginal.outerWidth*factor.from.x},childTo={height:childOriginal.height*factor.to.y,width:childOriginal.width*factor.to.x,outerHeight:childOriginal.height*factor.to.y,outerWidth:childOriginal.width*factor.to.x};// Vertical props scaling
	if(factor.from.y!==factor.to.y){childFrom=$.effects.setTransition(child,vProps,factor.from.y,childFrom);childTo=$.effects.setTransition(child,vProps,factor.to.y,childTo);}// Horizontal props scaling
	if(factor.from.x!==factor.to.x){childFrom=$.effects.setTransition(child,hProps,factor.from.x,childFrom);childTo=$.effects.setTransition(child,hProps,factor.to.x,childTo);}if(restore){$.effects.saveStyle(child);}// Animate children
	child.css(childFrom);child.animate(childTo,options.duration,options.easing,function(){// Restore children
	if(restore){$.effects.restoreStyle(child);}});});}// Animate
	element.animate(to,{queue:false,duration:options.duration,easing:options.easing,complete:function(){var offset=element.offset();if(to.opacity===0){element.css("opacity",from.opacity);}if(!restore){element.css("position",position==="static"?"relative":position).offset(offset);// Need to save style here so that automatic style restoration
	// doesn't restore to the original styles from before the animation.
	$.effects.saveStyle(element);}done();}});});/*!
	 * jQuery UI Effects Scale 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Scale Effect
	//>>group: Effects
	//>>description: Grows or shrinks an element and its content.
	//>>docs: https://api.jqueryui.com/scale-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("scale",function(options,done){// Create element
	var el=$(this),mode=options.mode,percent=parseInt(options.percent,10)||(parseInt(options.percent,10)===0?0:mode!=="effect"?0:100),newOptions=$.extend(true,{from:$.effects.scaledDimensions(el),to:$.effects.scaledDimensions(el,percent,options.direction||"both"),origin:options.origin||["middle","center"]},options);// Fade option to support puff
	if(options.fade){newOptions.from.opacity=1;newOptions.to.opacity=0;}$.effects.effect.size.call(this,newOptions,done);});/*!
	 * jQuery UI Effects Puff 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Puff Effect
	//>>group: Effects
	//>>description: Creates a puff effect by scaling the element up and hiding it at the same time.
	//>>docs: https://api.jqueryui.com/puff-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("puff","hide",function(options,done){var newOptions=$.extend(true,{},options,{fade:true,percent:parseInt(options.percent,10)||150});$.effects.effect.scale.call(this,newOptions,done);});/*!
	 * jQuery UI Effects Pulsate 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Pulsate Effect
	//>>group: Effects
	//>>description: Pulsates an element n times by changing the opacity to zero and back.
	//>>docs: https://api.jqueryui.com/pulsate-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("pulsate","show",function(options,done){var element=$(this),mode=options.mode,show=mode==="show",hide=mode==="hide",showhide=show||hide,// Showing or hiding leaves off the "last" animation
	anims=(options.times||5)*2+(showhide?1:0),duration=options.duration/anims,animateTo=0,i=1,queuelen=element.queue().length;if(show||!element.is(":visible")){element.css("opacity",0).show();animateTo=1;}// Anims - 1 opacity "toggles"
	for(;i<anims;i++){element.animate({opacity:animateTo},duration,options.easing);animateTo=1-animateTo;}element.animate({opacity:animateTo},duration,options.easing);element.queue(done);$.effects.unshift(element,queuelen,anims+1);});/*!
	 * jQuery UI Effects Shake 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Shake Effect
	//>>group: Effects
	//>>description: Shakes an element horizontally or vertically n times.
	//>>docs: https://api.jqueryui.com/shake-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("shake",function(options,done){var i=1,element=$(this),direction=options.direction||"left",distance=options.distance||20,times=options.times||3,anims=times*2+1,speed=Math.round(options.duration/anims),ref=direction==="up"||direction==="down"?"top":"left",positiveMotion=direction==="up"||direction==="left",animation={},animation1={},animation2={},queuelen=element.queue().length;$.effects.createPlaceholder(element);// Animation
	animation[ref]=(positiveMotion?"-=":"+=")+distance;animation1[ref]=(positiveMotion?"+=":"-=")+distance*2;animation2[ref]=(positiveMotion?"-=":"+=")+distance*2;// Animate
	element.animate(animation,speed,options.easing);// Shakes
	for(;i<times;i++){element.animate(animation1,speed,options.easing).animate(animation2,speed,options.easing);}element.animate(animation1,speed,options.easing).animate(animation,speed/2,options.easing).queue(done);$.effects.unshift(element,queuelen,anims+1);});/*!
	 * jQuery UI Effects Slide 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Slide Effect
	//>>group: Effects
	//>>description: Slides an element in and out of the viewport.
	//>>docs: https://api.jqueryui.com/slide-effect/
	//>>demos: https://jqueryui.com/effect/
	$.effects.define("slide","show",function(options,done){var startClip,startRef,element=$(this),map={up:["bottom","top"],down:["top","bottom"],left:["right","left"],right:["left","right"]},mode=options.mode,direction=options.direction||"left",ref=direction==="up"||direction==="down"?"top":"left",positiveMotion=direction==="up"||direction==="left",distance=options.distance||element[ref==="top"?"outerHeight":"outerWidth"](true),animation={};$.effects.createPlaceholder(element);startClip=element.cssClip();startRef=element.position()[ref];// Define hide animation
	animation[ref]=(positiveMotion?-1:1)*distance+startRef;animation.clip=element.cssClip();animation.clip[map[direction][1]]=animation.clip[map[direction][0]];// Reverse the animation if we're showing
	if(mode==="show"){element.cssClip(animation.clip);element.css(ref,animation[ref]);animation.clip=startClip;animation[ref]=startRef;}// Actually animate
	element.animate(animation,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
	 * jQuery UI Effects Transfer 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Transfer Effect
	if($.uiBackCompat!==false){$.effects.define("transfer",function(options,done){$(this).transfer(options,done);});}//>>group: Core
	//>>description: Selects elements which can be focused.
	//>>docs: https://api.jqueryui.com/focusable-selector/
	// Selectors
	$.ui.focusable=function(element,hasTabindex){var map,mapName,img,focusableIfVisible,fieldset,nodeName=element.nodeName.toLowerCase();if("area"===nodeName){map=element.parentNode;mapName=map.name;if(!element.href||!mapName||map.nodeName.toLowerCase()!=="map"){return false;}img=$("img[usemap='#"+mapName+"']");return img.length>0&&img.is(":visible");}if(/^(input|select|textarea|button|object)$/.test(nodeName)){focusableIfVisible=!element.disabled;if(focusableIfVisible){// Form controls within a disabled fieldset are disabled.
	// However, controls within the fieldset's legend do not get disabled.
	// Since controls generally aren't placed inside legends, we skip
	// this portion of the check.
	fieldset=$(element).closest("fieldset")[0];if(fieldset){focusableIfVisible=!fieldset.disabled;}}}else if("a"===nodeName){focusableIfVisible=element.href||hasTabindex;}else {focusableIfVisible=hasTabindex;}return focusableIfVisible&&$(element).is(":visible")&&visible($(element));};// Support: IE 8 only
	// IE 8 doesn't resolve inherit to visible/hidden for computed values
	function visible(element){var visibility=element.css("visibility");while(visibility==="inherit"){element=element.parent();visibility=element.css("visibility");}return visibility==="visible";}$.extend($.expr.pseudos,{focusable:function(element){return $.ui.focusable(element,$.attr(element,"tabindex")!=null);}});$.ui.focusable;// Support: IE8 Only
	// IE8 does not support the form attribute and when it is supplied. It overwrites the form prop
	// with a string, so we need to find the proper form.
	$.fn._form=function(){return typeof this[0].form==="string"?this.closest("form"):$(this[0].form);};/*!
	 * jQuery UI Form Reset Mixin 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Form Reset Mixin
	//>>group: Core
	//>>description: Refresh input widgets when their form is reset
	//>>docs: https://api.jqueryui.com/form-reset-mixin/
	$.ui.formResetMixin={_formResetHandler:function(){var form=$(this);// Wait for the form reset to actually happen before refreshing
	setTimeout(function(){var instances=form.data("ui-form-reset-instances");$.each(instances,function(){this.refresh();});});},_bindFormResetHandler:function(){this.form=this.element._form();if(!this.form.length){return;}var instances=this.form.data("ui-form-reset-instances")||[];if(!instances.length){// We don't use _on() here because we use a single event handler per form
	this.form.on("reset.ui-form-reset",this._formResetHandler);}instances.push(this);this.form.data("ui-form-reset-instances",instances);},_unbindFormResetHandler:function(){if(!this.form.length){return;}var instances=this.form.data("ui-form-reset-instances");instances.splice($.inArray(this,instances),1);if(instances.length){this.form.data("ui-form-reset-instances",instances);}else {this.form.removeData("ui-form-reset-instances").off("reset.ui-form-reset");}}};/*!
	 * jQuery UI Support for jQuery core 1.8.x and newer 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *
	 *///>>label: jQuery 1.8+ Support
	//>>group: Core
	//>>description: Support version 1.8.x and newer of jQuery core
	// Support: jQuery 1.9.x or older
	// $.expr[ ":" ] is deprecated.
	if(!$.expr.pseudos){$.expr.pseudos=$.expr[":"];}// Support: jQuery 1.11.x or older
	// $.unique has been renamed to $.uniqueSort
	if(!$.uniqueSort){$.uniqueSort=$.unique;}// Support: jQuery 2.2.x or older.
	// This method has been defined in jQuery 3.0.0.
	// Code from https://github.com/jquery/jquery/blob/e539bac79e666bba95bba86d690b4e609dca2286/src/selector/escapeSelector.js
	if(!$.escapeSelector){// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	var rcssescape=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;var fcssescape=function(ch,asCodePoint){if(asCodePoint){// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
	if(ch==="\0"){return "\uFFFD";}// Control characters and (dependent upon position) numbers get escaped as code points
	return ch.slice(0,-1)+"\\"+ch.charCodeAt(ch.length-1).toString(16)+" ";}// Other potentially-special ASCII characters get backslash-escaped
	return "\\"+ch;};$.escapeSelector=function(sel){return (sel+"").replace(rcssescape,fcssescape);};}// Support: jQuery 3.4.x or older
	// These methods have been defined in jQuery 3.5.0.
	if(!$.fn.even||!$.fn.odd){$.fn.extend({even:function(){return this.filter(function(i){return i%2===0;});},odd:function(){return this.filter(function(i){return i%2===1;});}});}//>>group: Core
	//>>description: Provide keycodes as keynames
	//>>docs: https://api.jqueryui.com/jQuery.ui.keyCode/
	$.ui.keyCode={BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38};/*!
	 * jQuery UI Labels 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: labels
	//>>group: Core
	//>>description: Find all the labels associated with a given input
	//>>docs: https://api.jqueryui.com/labels/
	$.fn.labels=function(){var ancestor,selector,id,labels,ancestors;if(!this.length){return this.pushStack([]);}// Check control.labels first
	if(this[0].labels&&this[0].labels.length){return this.pushStack(this[0].labels);}// Support: IE <= 11, FF <= 37, Android <= 2.3 only
	// Above browsers do not support control.labels. Everything below is to support them
	// as well as document fragments. control.labels does not work on document fragments
	labels=this.eq(0).parents("label");// Look for the label based on the id
	id=this.attr("id");if(id){// We don't search against the document in case the element
	// is disconnected from the DOM
	ancestor=this.eq(0).parents().last();// Get a full set of top level ancestors
	ancestors=ancestor.add(ancestor.length?ancestor.siblings():this.siblings());// Create a selector for the label based on the id
	selector="label[for='"+$.escapeSelector(id)+"']";labels=labels.add(ancestors.find(selector).addBack(selector));}// Return whatever we have found for labels
	return this.pushStack(labels);};/*!
	 * jQuery UI Scroll Parent 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: scrollParent
	//>>group: Core
	//>>description: Get the closest ancestor element that is scrollable.
	//>>docs: https://api.jqueryui.com/scrollParent/
	$.fn.scrollParent=function(includeHidden){var position=this.css("position"),excludeStaticParent=position==="absolute",overflowRegex=includeHidden?/(auto|scroll|hidden)/:/(auto|scroll)/,scrollParent=this.parents().filter(function(){var parent=$(this);if(excludeStaticParent&&parent.css("position")==="static"){return false;}return overflowRegex.test(parent.css("overflow")+parent.css("overflow-y")+parent.css("overflow-x"));}).eq(0);return position==="fixed"||!scrollParent.length?$(this[0].ownerDocument||document):scrollParent;};/*!
	 * jQuery UI Tabbable 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: :tabbable Selector
	//>>group: Core
	//>>description: Selects elements which can be tabbed to.
	//>>docs: https://api.jqueryui.com/tabbable-selector/
	$.extend($.expr.pseudos,{tabbable:function(element){var tabIndex=$.attr(element,"tabindex"),hasTabindex=tabIndex!=null;return (!hasTabindex||tabIndex>=0)&&$.ui.focusable(element,hasTabindex);}});/*!
	 * jQuery UI Unique ID 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: uniqueId
	//>>group: Core
	//>>description: Functions to generate and remove uniqueId's
	//>>docs: https://api.jqueryui.com/uniqueId/
	$.fn.extend({uniqueId:function(){var uuid=0;return function(){return this.each(function(){if(!this.id){this.id="ui-id-"+ ++uuid;}});};}(),removeUniqueId:function(){return this.each(function(){if(/^ui-id-\d+$/.test(this.id)){$(this).removeAttr("id");}});}});/*!
	 * jQuery UI Accordion 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Accordion
	//>>group: Widgets
	/* eslint-disable max-len *///>>description: Displays collapsible content panels for presenting information in a limited amount of space.
	/* eslint-enable max-len *///>>docs: https://api.jqueryui.com/accordion/
	//>>demos: https://jqueryui.com/accordion/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/accordion.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.accordion",{version:"1.13.3",options:{active:0,animate:{},classes:{"ui-accordion-header":"ui-corner-top","ui-accordion-header-collapsed":"ui-corner-all","ui-accordion-content":"ui-corner-bottom"},collapsible:false,event:"click",header:function(elem){return elem.find("> li > :first-child").add(elem.find("> :not(li)").even());},heightStyle:"auto",icons:{activeHeader:"ui-icon-triangle-1-s",header:"ui-icon-triangle-1-e"},// Callbacks
	activate:null,beforeActivate:null},hideProps:{borderTopWidth:"hide",borderBottomWidth:"hide",paddingTop:"hide",paddingBottom:"hide",height:"hide"},showProps:{borderTopWidth:"show",borderBottomWidth:"show",paddingTop:"show",paddingBottom:"show",height:"show"},_create:function(){var options=this.options;this.prevShow=this.prevHide=$();this._addClass("ui-accordion","ui-widget ui-helper-reset");this.element.attr("role","tablist");// Don't allow collapsible: false and active: false / null
	if(!options.collapsible&&(options.active===false||options.active==null)){options.active=0;}this._processPanels();// handle negative values
	if(options.active<0){options.active+=this.headers.length;}this._refresh();},_getCreateEventData:function(){return {header:this.active,panel:!this.active.length?$():this.active.next()};},_createIcons:function(){var icon,children,icons=this.options.icons;if(icons){icon=$("<span>");this._addClass(icon,"ui-accordion-header-icon","ui-icon "+icons.header);icon.prependTo(this.headers);children=this.active.children(".ui-accordion-header-icon");this._removeClass(children,icons.header)._addClass(children,null,icons.activeHeader)._addClass(this.headers,"ui-accordion-icons");}},_destroyIcons:function(){this._removeClass(this.headers,"ui-accordion-icons");this.headers.children(".ui-accordion-header-icon").remove();},_destroy:function(){var contents;// Clean up main element
	this.element.removeAttr("role");// Clean up headers
	this.headers.removeAttr("role aria-expanded aria-selected aria-controls tabIndex").removeUniqueId();this._destroyIcons();// Clean up content panels
	contents=this.headers.next().css("display","").removeAttr("role aria-hidden aria-labelledby").removeUniqueId();if(this.options.heightStyle!=="content"){contents.css("height","");}},_setOption:function(key,value){if(key==="active"){// _activate() will handle invalid values and update this.options
	this._activate(value);return;}if(key==="event"){if(this.options.event){this._off(this.headers,this.options.event);}this._setupEvents(value);}this._super(key,value);// Setting collapsible: false while collapsed; open first panel
	if(key==="collapsible"&&!value&&this.options.active===false){this._activate(0);}if(key==="icons"){this._destroyIcons();if(value){this._createIcons();}}},_setOptionDisabled:function(value){this._super(value);this.element.attr("aria-disabled",value);// Support: IE8 Only
	// #5332 / #6059 - opacity doesn't cascade to positioned elements in IE
	// so we need to add the disabled class to the headers and panels
	this._toggleClass(null,"ui-state-disabled",!!value);this._toggleClass(this.headers.add(this.headers.next()),null,"ui-state-disabled",!!value);},_keydown:function(event){if(event.altKey||event.ctrlKey){return;}var keyCode=$.ui.keyCode,length=this.headers.length,currentIndex=this.headers.index(event.target),toFocus=false;switch(event.keyCode){case keyCode.RIGHT:case keyCode.DOWN:toFocus=this.headers[(currentIndex+1)%length];break;case keyCode.LEFT:case keyCode.UP:toFocus=this.headers[(currentIndex-1+length)%length];break;case keyCode.SPACE:case keyCode.ENTER:this._eventHandler(event);break;case keyCode.HOME:toFocus=this.headers[0];break;case keyCode.END:toFocus=this.headers[length-1];break;}if(toFocus){$(event.target).attr("tabIndex",-1);$(toFocus).attr("tabIndex",0);$(toFocus).trigger("focus");event.preventDefault();}},_panelKeyDown:function(event){if(event.keyCode===$.ui.keyCode.UP&&event.ctrlKey){$(event.currentTarget).prev().trigger("focus");}},refresh:function(){var options=this.options;this._processPanels();// Was collapsed or no panel
	if(options.active===false&&options.collapsible===true||!this.headers.length){options.active=false;this.active=$();// active false only when collapsible is true
	}else if(options.active===false){this._activate(0);// was active, but active panel is gone
	}else if(this.active.length&&!$.contains(this.element[0],this.active[0])){// all remaining panel are disabled
	if(this.headers.length===this.headers.find(".ui-state-disabled").length){options.active=false;this.active=$();// activate previous panel
	}else {this._activate(Math.max(0,options.active-1));}// was active, active panel still exists
	}else {// make sure active index is correct
	options.active=this.headers.index(this.active);}this._destroyIcons();this._refresh();},_processPanels:function(){var prevHeaders=this.headers,prevPanels=this.panels;if(typeof this.options.header==="function"){this.headers=this.options.header(this.element);}else {this.headers=this.element.find(this.options.header);}this._addClass(this.headers,"ui-accordion-header ui-accordion-header-collapsed","ui-state-default");this.panels=this.headers.next().filter(":not(.ui-accordion-content-active)").hide();this._addClass(this.panels,"ui-accordion-content","ui-helper-reset ui-widget-content");// Avoid memory leaks (#10056)
	if(prevPanels){this._off(prevHeaders.not(this.headers));this._off(prevPanels.not(this.panels));}},_refresh:function(){var maxHeight,options=this.options,heightStyle=options.heightStyle,parent=this.element.parent();this.active=this._findActive(options.active);this._addClass(this.active,"ui-accordion-header-active","ui-state-active")._removeClass(this.active,"ui-accordion-header-collapsed");this._addClass(this.active.next(),"ui-accordion-content-active");this.active.next().show();this.headers.attr("role","tab").each(function(){var header=$(this),headerId=header.uniqueId().attr("id"),panel=header.next(),panelId=panel.uniqueId().attr("id");header.attr("aria-controls",panelId);panel.attr("aria-labelledby",headerId);}).next().attr("role","tabpanel");this.headers.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}).next().attr({"aria-hidden":"true"}).hide();// Make sure at least one header is in the tab order
	if(!this.active.length){this.headers.eq(0).attr("tabIndex",0);}else {this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}).next().attr({"aria-hidden":"false"});}this._createIcons();this._setupEvents(options.event);if(heightStyle==="fill"){maxHeight=parent.height();this.element.siblings(":visible").each(function(){var elem=$(this),position=elem.css("position");if(position==="absolute"||position==="fixed"){return;}maxHeight-=elem.outerHeight(true);});this.headers.each(function(){maxHeight-=$(this).outerHeight(true);});this.headers.next().each(function(){$(this).height(Math.max(0,maxHeight-$(this).innerHeight()+$(this).height()));}).css("overflow","auto");}else if(heightStyle==="auto"){maxHeight=0;this.headers.next().each(function(){var isVisible=$(this).is(":visible");if(!isVisible){$(this).show();}maxHeight=Math.max(maxHeight,$(this).css("height","").height());if(!isVisible){$(this).hide();}}).height(maxHeight);}},_activate:function(index){var active=this._findActive(index)[0];// Trying to activate the already active panel
	if(active===this.active[0]){return;}// Trying to collapse, simulate a click on the currently active header
	active=active||this.active[0];this._eventHandler({target:active,currentTarget:active,preventDefault:$.noop});},_findActive:function(selector){return typeof selector==="number"?this.headers.eq(selector):$();},_setupEvents:function(event){var events={keydown:"_keydown"};if(event){$.each(event.split(" "),function(index,eventName){events[eventName]="_eventHandler";});}this._off(this.headers.add(this.headers.next()));this._on(this.headers,events);this._on(this.headers.next(),{keydown:"_panelKeyDown"});this._hoverable(this.headers);this._focusable(this.headers);},_eventHandler:function(event){var activeChildren,clickedChildren,options=this.options,active=this.active,clicked=$(event.currentTarget),clickedIsActive=clicked[0]===active[0],collapsing=clickedIsActive&&options.collapsible,toShow=collapsing?$():clicked.next(),toHide=active.next(),eventData={oldHeader:active,oldPanel:toHide,newHeader:collapsing?$():clicked,newPanel:toShow};event.preventDefault();if(// click on active header, but not collapsible
	clickedIsActive&&!options.collapsible||// allow canceling activation
	this._trigger("beforeActivate",event,eventData)===false){return;}options.active=collapsing?false:this.headers.index(clicked);// When the call to ._toggle() comes after the class changes
	// it causes a very odd bug in IE 8 (see #6720)
	this.active=clickedIsActive?$():clicked;this._toggle(eventData);// Switch classes
	// corner classes on the previously active header stay after the animation
	this._removeClass(active,"ui-accordion-header-active","ui-state-active");if(options.icons){activeChildren=active.children(".ui-accordion-header-icon");this._removeClass(activeChildren,null,options.icons.activeHeader)._addClass(activeChildren,null,options.icons.header);}if(!clickedIsActive){this._removeClass(clicked,"ui-accordion-header-collapsed")._addClass(clicked,"ui-accordion-header-active","ui-state-active");if(options.icons){clickedChildren=clicked.children(".ui-accordion-header-icon");this._removeClass(clickedChildren,null,options.icons.header)._addClass(clickedChildren,null,options.icons.activeHeader);}this._addClass(clicked.next(),"ui-accordion-content-active");}},_toggle:function(data){var toShow=data.newPanel,toHide=this.prevShow.length?this.prevShow:data.oldPanel;// Handle activating a panel during the animation for another activation
	this.prevShow.add(this.prevHide).stop(true,true);this.prevShow=toShow;this.prevHide=toHide;if(this.options.animate){this._animate(toShow,toHide,data);}else {toHide.hide();toShow.show();this._toggleComplete(data);}toHide.attr({"aria-hidden":"true"});toHide.prev().attr({"aria-selected":"false","aria-expanded":"false"});// if we're switching panels, remove the old header from the tab order
	// if we're opening from collapsed state, remove the previous header from the tab order
	// if we're collapsing, then keep the collapsing header in the tab order
	if(toShow.length&&toHide.length){toHide.prev().attr({"tabIndex":-1,"aria-expanded":"false"});}else if(toShow.length){this.headers.filter(function(){return parseInt($(this).attr("tabIndex"),10)===0;}).attr("tabIndex",-1);}toShow.attr("aria-hidden","false").prev().attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0});},_animate:function(toShow,toHide,data){var total,easing,duration,that=this,adjust=0,boxSizing=toShow.css("box-sizing"),down=toShow.length&&(!toHide.length||toShow.index()<toHide.index()),animate=this.options.animate||{},options=down&&animate.down||animate,complete=function(){that._toggleComplete(data);};if(typeof options==="number"){duration=options;}if(typeof options==="string"){easing=options;}// fall back from options to animation in case of partial down settings
	easing=easing||options.easing||animate.easing;duration=duration||options.duration||animate.duration;if(!toHide.length){return toShow.animate(this.showProps,duration,easing,complete);}if(!toShow.length){return toHide.animate(this.hideProps,duration,easing,complete);}total=toShow.show().outerHeight();toHide.animate(this.hideProps,{duration:duration,easing:easing,step:function(now,fx){fx.now=Math.round(now);}});toShow.hide().animate(this.showProps,{duration:duration,easing:easing,complete:complete,step:function(now,fx){fx.now=Math.round(now);if(fx.prop!=="height"){if(boxSizing==="content-box"){adjust+=fx.now;}}else if(that.options.heightStyle!=="content"){fx.now=Math.round(total-toHide.outerHeight()-adjust);adjust=0;}}});},_toggleComplete:function(data){var toHide=data.oldPanel,prev=toHide.prev();this._removeClass(toHide,"ui-accordion-content-active");this._removeClass(prev,"ui-accordion-header-active")._addClass(prev,"ui-accordion-header-collapsed");// Work around for rendering bug in IE (#5421)
	if(toHide.length){toHide.parent()[0].className=toHide.parent()[0].className;}this._trigger("activate",null,data);}});$.ui.safeActiveElement=function(document){var activeElement;// Support: IE 9 only
	// IE9 throws an "Unspecified error" accessing document.activeElement from an <iframe>
	try{activeElement=document.activeElement;}catch(error){activeElement=document.body;}// Support: IE 9 - 11 only
	// IE may return null instead of an element
	// Interestingly, this only seems to occur when NOT in an iframe
	if(!activeElement){activeElement=document.body;}// Support: IE 11 only
	// IE11 returns a seemingly empty object in some cases when accessing
	// document.activeElement from an <iframe>
	if(!activeElement.nodeName){activeElement=document.body;}return activeElement;};/*!
	 * jQuery UI Menu 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Menu
	//>>group: Widgets
	//>>description: Creates nestable menus.
	//>>docs: https://api.jqueryui.com/menu/
	//>>demos: https://jqueryui.com/menu/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/menu.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.menu",{version:"1.13.3",defaultElement:"<ul>",delay:300,options:{icons:{submenu:"ui-icon-caret-1-e"},items:"> *",menus:"ul",position:{my:"left top",at:"right top"},role:"menu",// Callbacks
	blur:null,focus:null,select:null},_create:function(){this.activeMenu=this.element;// Flag used to prevent firing of the click handler
	// as the event bubbles up through nested menus
	this.mouseHandled=false;this.lastMousePosition={x:null,y:null};this.element.uniqueId().attr({role:this.options.role,tabIndex:0});this._addClass("ui-menu","ui-widget ui-widget-content");this._on({// Prevent focus from sticking to links inside menu after clicking
	// them (focus should always stay on UL during navigation).
	"mousedown .ui-menu-item":function(event){event.preventDefault();this._activateItem(event);},"click .ui-menu-item":function(event){var target=$(event.target);var active=$($.ui.safeActiveElement(this.document[0]));if(!this.mouseHandled&&target.not(".ui-state-disabled").length){this.select(event);// Only set the mouseHandled flag if the event will bubble, see #9469.
	if(!event.isPropagationStopped()){this.mouseHandled=true;}// Open submenu on click
	if(target.has(".ui-menu").length){this.expand(event);}else if(!this.element.is(":focus")&&active.closest(".ui-menu").length){// Redirect focus to the menu
	this.element.trigger("focus",[true]);// If the active item is on the top level, let it stay active.
	// Otherwise, blur the active item since it is no longer visible.
	if(this.active&&this.active.parents(".ui-menu").length===1){clearTimeout(this.timer);}}}},"mouseenter .ui-menu-item":"_activateItem","mousemove .ui-menu-item":"_activateItem",mouseleave:"collapseAll","mouseleave .ui-menu":"collapseAll",focus:function(event,keepActiveItem){// If there's already an active item, keep it active
	// If not, activate the first item
	var item=this.active||this._menuItems().first();if(!keepActiveItem){this.focus(event,item);}},blur:function(event){this._delay(function(){var notContained=!$.contains(this.element[0],$.ui.safeActiveElement(this.document[0]));if(notContained){this.collapseAll(event);}});},keydown:"_keydown"});this.refresh();// Clicks outside of a menu collapse any open menus
	this._on(this.document,{click:function(event){if(this._closeOnDocumentClick(event)){this.collapseAll(event,true);}// Reset the mouseHandled flag
	this.mouseHandled=false;}});},_activateItem:function(event){// Ignore mouse events while typeahead is active, see #10458.
	// Prevents focusing the wrong item when typeahead causes a scroll while the mouse
	// is over an item in the menu
	if(this.previousFilter){return;}// If the mouse didn't actually move, but the page was scrolled, ignore the event (#9356)
	if(event.clientX===this.lastMousePosition.x&&event.clientY===this.lastMousePosition.y){return;}this.lastMousePosition={x:event.clientX,y:event.clientY};var actualTarget=$(event.target).closest(".ui-menu-item"),target=$(event.currentTarget);// Ignore bubbled events on parent items, see #11641
	if(actualTarget[0]!==target[0]){return;}// If the item is already active, there's nothing to do
	if(target.is(".ui-state-active")){return;}// Remove ui-state-active class from siblings of the newly focused menu item
	// to avoid a jump caused by adjacent elements both having a class with a border
	this._removeClass(target.siblings().children(".ui-state-active"),null,"ui-state-active");this.focus(event,target);},_destroy:function(){var items=this.element.find(".ui-menu-item").removeAttr("role aria-disabled"),submenus=items.children(".ui-menu-item-wrapper").removeUniqueId().removeAttr("tabIndex role aria-haspopup");// Destroy (sub)menus
	this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeAttr("role aria-labelledby aria-expanded aria-hidden aria-disabled "+"tabIndex").removeUniqueId().show();submenus.children().each(function(){var elem=$(this);if(elem.data("ui-menu-submenu-caret")){elem.remove();}});},_keydown:function(event){var match,prev,character,skip,preventDefault=true;switch(event.keyCode){case $.ui.keyCode.PAGE_UP:this.previousPage(event);break;case $.ui.keyCode.PAGE_DOWN:this.nextPage(event);break;case $.ui.keyCode.HOME:this._move("first","first",event);break;case $.ui.keyCode.END:this._move("last","last",event);break;case $.ui.keyCode.UP:this.previous(event);break;case $.ui.keyCode.DOWN:this.next(event);break;case $.ui.keyCode.LEFT:this.collapse(event);break;case $.ui.keyCode.RIGHT:if(this.active&&!this.active.is(".ui-state-disabled")){this.expand(event);}break;case $.ui.keyCode.ENTER:case $.ui.keyCode.SPACE:this._activate(event);break;case $.ui.keyCode.ESCAPE:this.collapse(event);break;default:preventDefault=false;prev=this.previousFilter||"";skip=false;// Support number pad values
	character=event.keyCode>=96&&event.keyCode<=105?(event.keyCode-96).toString():String.fromCharCode(event.keyCode);clearTimeout(this.filterTimer);if(character===prev){skip=true;}else {character=prev+character;}match=this._filterMenuItems(character);match=skip&&match.index(this.active.next())!==-1?this.active.nextAll(".ui-menu-item"):match;// If no matches on the current filter, reset to the last character pressed
	// to move down the menu to the first item that starts with that character
	if(!match.length){character=String.fromCharCode(event.keyCode);match=this._filterMenuItems(character);}if(match.length){this.focus(event,match);this.previousFilter=character;this.filterTimer=this._delay(function(){delete this.previousFilter;},1000);}else {delete this.previousFilter;}}if(preventDefault){event.preventDefault();}},_activate:function(event){if(this.active&&!this.active.is(".ui-state-disabled")){if(this.active.children("[aria-haspopup='true']").length){this.expand(event);}else {this.select(event);}}},refresh:function(){var menus,items,newSubmenus,newItems,newWrappers,that=this,icon=this.options.icons.submenu,submenus=this.element.find(this.options.menus);this._toggleClass("ui-menu-icons",null,!!this.element.find(".ui-icon").length);// Initialize nested menus
	newSubmenus=submenus.filter(":not(.ui-menu)").hide().attr({role:this.options.role,"aria-hidden":"true","aria-expanded":"false"}).each(function(){var menu=$(this),item=menu.prev(),submenuCaret=$("<span>").data("ui-menu-submenu-caret",true);that._addClass(submenuCaret,"ui-menu-icon","ui-icon "+icon);item.attr("aria-haspopup","true").prepend(submenuCaret);menu.attr("aria-labelledby",item.attr("id"));});this._addClass(newSubmenus,"ui-menu","ui-widget ui-widget-content ui-front");menus=submenus.add(this.element);items=menus.find(this.options.items);// Initialize menu-items containing spaces and/or dashes only as dividers
	items.not(".ui-menu-item").each(function(){var item=$(this);if(that._isDivider(item)){that._addClass(item,"ui-menu-divider","ui-widget-content");}});// Don't refresh list items that are already adapted
	newItems=items.not(".ui-menu-item, .ui-menu-divider");newWrappers=newItems.children().not(".ui-menu").uniqueId().attr({tabIndex:-1,role:this._itemRole()});this._addClass(newItems,"ui-menu-item")._addClass(newWrappers,"ui-menu-item-wrapper");// Add aria-disabled attribute to any disabled menu item
	items.filter(".ui-state-disabled").attr("aria-disabled","true");// If the active item has been removed, blur the menu
	if(this.active&&!$.contains(this.element[0],this.active[0])){this.blur();}},_itemRole:function(){return {menu:"menuitem",listbox:"option"}[this.options.role];},_setOption:function(key,value){if(key==="icons"){var icons=this.element.find(".ui-menu-icon");this._removeClass(icons,null,this.options.icons.submenu)._addClass(icons,null,value.submenu);}this._super(key,value);},_setOptionDisabled:function(value){this._super(value);this.element.attr("aria-disabled",String(value));this._toggleClass(null,"ui-state-disabled",!!value);},focus:function(event,item){var nested,focused,activeParent;this.blur(event,event&&event.type==="focus");this._scrollIntoView(item);this.active=item.first();focused=this.active.children(".ui-menu-item-wrapper");this._addClass(focused,null,"ui-state-active");// Only update aria-activedescendant if there's a role
	// otherwise we assume focus is managed elsewhere
	if(this.options.role){this.element.attr("aria-activedescendant",focused.attr("id"));}// Highlight active parent menu item, if any
	activeParent=this.active.parent().closest(".ui-menu-item").children(".ui-menu-item-wrapper");this._addClass(activeParent,null,"ui-state-active");if(event&&event.type==="keydown"){this._close();}else {this.timer=this._delay(function(){this._close();},this.delay);}nested=item.children(".ui-menu");if(nested.length&&event&&/^mouse/.test(event.type)){this._startOpening(nested);}this.activeMenu=item.parent();this._trigger("focus",event,{item:item});},_scrollIntoView:function(item){var borderTop,paddingTop,offset,scroll,elementHeight,itemHeight;if(this._hasScroll()){borderTop=parseFloat($.css(this.activeMenu[0],"borderTopWidth"))||0;paddingTop=parseFloat($.css(this.activeMenu[0],"paddingTop"))||0;offset=item.offset().top-this.activeMenu.offset().top-borderTop-paddingTop;scroll=this.activeMenu.scrollTop();elementHeight=this.activeMenu.height();itemHeight=item.outerHeight();if(offset<0){this.activeMenu.scrollTop(scroll+offset);}else if(offset+itemHeight>elementHeight){this.activeMenu.scrollTop(scroll+offset-elementHeight+itemHeight);}}},blur:function(event,fromFocus){if(!fromFocus){clearTimeout(this.timer);}if(!this.active){return;}this._removeClass(this.active.children(".ui-menu-item-wrapper"),null,"ui-state-active");this._trigger("blur",event,{item:this.active});this.active=null;},_startOpening:function(submenu){clearTimeout(this.timer);// Don't open if already open fixes a Firefox bug that caused a .5 pixel
	// shift in the submenu position when mousing over the caret icon
	if(submenu.attr("aria-hidden")!=="true"){return;}this.timer=this._delay(function(){this._close();this._open(submenu);},this.delay);},_open:function(submenu){var position=$.extend({of:this.active},this.options.position);clearTimeout(this.timer);this.element.find(".ui-menu").not(submenu.parents(".ui-menu")).hide().attr("aria-hidden","true");submenu.show().removeAttr("aria-hidden").attr("aria-expanded","true").position(position);},collapseAll:function(event,all){clearTimeout(this.timer);this.timer=this._delay(function(){// If we were passed an event, look for the submenu that contains the event
	var currentMenu=all?this.element:$(event&&event.target).closest(this.element.find(".ui-menu"));// If we found no valid submenu ancestor, use the main menu to close all
	// sub menus anyway
	if(!currentMenu.length){currentMenu=this.element;}this._close(currentMenu);this.blur(event);// Work around active item staying active after menu is blurred
	this._removeClass(currentMenu.find(".ui-state-active"),null,"ui-state-active");this.activeMenu=currentMenu;},all?0:this.delay);},// With no arguments, closes the currently active menu - if nothing is active
	// it closes all menus.  If passed an argument, it will search for menus BELOW
	_close:function(startMenu){if(!startMenu){startMenu=this.active?this.active.parent():this.element;}startMenu.find(".ui-menu").hide().attr("aria-hidden","true").attr("aria-expanded","false");},_closeOnDocumentClick:function(event){return !$(event.target).closest(".ui-menu").length;},_isDivider:function(item){// Match hyphen, em dash, en dash
	return !/[^\-\u2014\u2013\s]/.test(item.text());},collapse:function(event){var newItem=this.active&&this.active.parent().closest(".ui-menu-item",this.element);if(newItem&&newItem.length){this._close();this.focus(event,newItem);}},expand:function(event){var newItem=this.active&&this._menuItems(this.active.children(".ui-menu")).first();if(newItem&&newItem.length){this._open(newItem.parent());// Delay so Firefox will not hide activedescendant change in expanding submenu from AT
	this._delay(function(){this.focus(event,newItem);});}},next:function(event){this._move("next","first",event);},previous:function(event){this._move("prev","last",event);},isFirstItem:function(){return this.active&&!this.active.prevAll(".ui-menu-item").length;},isLastItem:function(){return this.active&&!this.active.nextAll(".ui-menu-item").length;},_menuItems:function(menu){return (menu||this.element).find(this.options.items).filter(".ui-menu-item");},_move:function(direction,filter,event){var next;if(this.active){if(direction==="first"||direction==="last"){next=this.active[direction==="first"?"prevAll":"nextAll"](".ui-menu-item").last();}else {next=this.active[direction+"All"](".ui-menu-item").first();}}if(!next||!next.length||!this.active){next=this._menuItems(this.activeMenu)[filter]();}this.focus(event,next);},nextPage:function(event){var item,base,height;if(!this.active){this.next(event);return;}if(this.isLastItem()){return;}if(this._hasScroll()){base=this.active.offset().top;height=this.element.innerHeight();// jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.
	if($.fn.jquery.indexOf("3.2.")===0){height+=this.element[0].offsetHeight-this.element.outerHeight();}this.active.nextAll(".ui-menu-item").each(function(){item=$(this);return item.offset().top-base-height<0;});this.focus(event,item);}else {this.focus(event,this._menuItems(this.activeMenu)[!this.active?"first":"last"]());}},previousPage:function(event){var item,base,height;if(!this.active){this.next(event);return;}if(this.isFirstItem()){return;}if(this._hasScroll()){base=this.active.offset().top;height=this.element.innerHeight();// jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.
	if($.fn.jquery.indexOf("3.2.")===0){height+=this.element[0].offsetHeight-this.element.outerHeight();}this.active.prevAll(".ui-menu-item").each(function(){item=$(this);return item.offset().top-base+height>0;});this.focus(event,item);}else {this.focus(event,this._menuItems(this.activeMenu).first());}},_hasScroll:function(){return this.element.outerHeight()<this.element.prop("scrollHeight");},select:function(event){// TODO: It should never be possible to not have an active item at this
	// point, but the tests don't trigger mouseenter before click.
	this.active=this.active||$(event.target).closest(".ui-menu-item");var ui={item:this.active};if(!this.active.has(".ui-menu").length){this.collapseAll(event,true);}this._trigger("select",event,ui);},_filterMenuItems:function(character){var escapedCharacter=character.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&"),regex=new RegExp("^"+escapedCharacter,"i");return this.activeMenu.find(this.options.items)// Only match on items, not dividers or other content (#10571)
	.filter(".ui-menu-item").filter(function(){return regex.test(String.prototype.trim.call($(this).children(".ui-menu-item-wrapper").text()));});}});/*!
	 * jQuery UI Autocomplete 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Autocomplete
	//>>group: Widgets
	//>>description: Lists suggested words as the user is typing.
	//>>docs: https://api.jqueryui.com/autocomplete/
	//>>demos: https://jqueryui.com/autocomplete/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/autocomplete.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.autocomplete",{version:"1.13.3",defaultElement:"<input>",options:{appendTo:null,autoFocus:false,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,// Callbacks
	change:null,close:null,focus:null,open:null,response:null,search:null,select:null},requestIndex:0,pending:0,liveRegionTimer:null,_create:function(){// Some browsers only repeat keydown events, not keypress events,
	// so we use the suppressKeyPress flag to determine if we've already
	// handled the keydown event. #7269
	// Unfortunately the code for & in keypress is the same as the up arrow,
	// so we use the suppressKeyPressRepeat flag to avoid handling keypress
	// events when we know the keydown event was used to modify the
	// search term. #7799
	var suppressKeyPress,suppressKeyPressRepeat,suppressInput,nodeName=this.element[0].nodeName.toLowerCase(),isTextarea=nodeName==="textarea",isInput=nodeName==="input";// Textareas are always multi-line
	// Inputs are always single-line, even if inside a contentEditable element
	// IE also treats inputs as contentEditable
	// All other element types are determined by whether or not they're contentEditable
	this.isMultiLine=isTextarea||!isInput&&this._isContentEditable(this.element);this.valueMethod=this.element[isTextarea||isInput?"val":"text"];this.isNewMenu=true;this._addClass("ui-autocomplete-input");this.element.attr("autocomplete","off");this._on(this.element,{keydown:function(event){if(this.element.prop("readOnly")){suppressKeyPress=true;suppressInput=true;suppressKeyPressRepeat=true;return;}suppressKeyPress=false;suppressInput=false;suppressKeyPressRepeat=false;var keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.PAGE_UP:suppressKeyPress=true;this._move("previousPage",event);break;case keyCode.PAGE_DOWN:suppressKeyPress=true;this._move("nextPage",event);break;case keyCode.UP:suppressKeyPress=true;this._keyEvent("previous",event);break;case keyCode.DOWN:suppressKeyPress=true;this._keyEvent("next",event);break;case keyCode.ENTER:// when menu is open and has focus
	if(this.menu.active){// #6055 - Opera still allows the keypress to occur
	// which causes forms to submit
	suppressKeyPress=true;event.preventDefault();this.menu.select(event);}break;case keyCode.TAB:if(this.menu.active){this.menu.select(event);}break;case keyCode.ESCAPE:if(this.menu.element.is(":visible")){if(!this.isMultiLine){this._value(this.term);}this.close(event);// Different browsers have different default behavior for escape
	// Single press can mean undo or clear
	// Double press in IE means clear the whole form
	event.preventDefault();}break;default:suppressKeyPressRepeat=true;// search timeout should be triggered before the input value is changed
	this._searchTimeout(event);break;}},keypress:function(event){if(suppressKeyPress){suppressKeyPress=false;if(!this.isMultiLine||this.menu.element.is(":visible")){event.preventDefault();}return;}if(suppressKeyPressRepeat){return;}// Replicate some key handlers to allow them to repeat in Firefox and Opera
	var keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.PAGE_UP:this._move("previousPage",event);break;case keyCode.PAGE_DOWN:this._move("nextPage",event);break;case keyCode.UP:this._keyEvent("previous",event);break;case keyCode.DOWN:this._keyEvent("next",event);break;}},input:function(event){if(suppressInput){suppressInput=false;event.preventDefault();return;}this._searchTimeout(event);},focus:function(){this.selectedItem=null;this.previous=this._value();},blur:function(event){clearTimeout(this.searching);this.close(event);this._change(event);}});this._initSource();this.menu=$("<ul>").appendTo(this._appendTo()).menu({// disable ARIA support, the live region takes care of that
	role:null}).hide()// Support: IE 11 only, Edge <= 14
	// For other browsers, we preventDefault() on the mousedown event
	// to keep the dropdown from taking focus from the input. This doesn't
	// work for IE/Edge, causing problems with selection and scrolling (#9638)
	// Happily, IE and Edge support an "unselectable" attribute that
	// prevents an element from receiving focus, exactly what we want here.
	.attr({"unselectable":"on"}).menu("instance");this._addClass(this.menu.element,"ui-autocomplete","ui-front");this._on(this.menu.element,{mousedown:function(event){// Prevent moving focus out of the text field
	event.preventDefault();},menufocus:function(event,ui){var label,item;// support: Firefox
	// Prevent accidental activation of menu items in Firefox (#7024 #9118)
	if(this.isNewMenu){this.isNewMenu=false;if(event.originalEvent&&/^mouse/.test(event.originalEvent.type)){this.menu.blur();this.document.one("mousemove",function(){$(event.target).trigger(event.originalEvent);});return;}}item=ui.item.data("ui-autocomplete-item");if(false!==this._trigger("focus",event,{item:item})){// use value to match what will end up in the input, if it was a key event
	if(event.originalEvent&&/^key/.test(event.originalEvent.type)){this._value(item.value);}}// Announce the value in the liveRegion
	label=ui.item.attr("aria-label")||item.value;if(label&&String.prototype.trim.call(label).length){clearTimeout(this.liveRegionTimer);this.liveRegionTimer=this._delay(function(){this.liveRegion.html($("<div>").text(label));},100);}},menuselect:function(event,ui){var item=ui.item.data("ui-autocomplete-item"),previous=this.previous;// Only trigger when focus was lost (click on menu)
	if(this.element[0]!==$.ui.safeActiveElement(this.document[0])){this.element.trigger("focus");this.previous=previous;// #6109 - IE triggers two focus events and the second
	// is asynchronous, so we need to reset the previous
	// term synchronously and asynchronously :-(
	this._delay(function(){this.previous=previous;this.selectedItem=item;});}if(false!==this._trigger("select",event,{item:item})){this._value(item.value);}// reset the term after the select event
	// this allows custom select handling to work properly
	this.term=this._value();this.close(event);this.selectedItem=item;}});this.liveRegion=$("<div>",{role:"status","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body);this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible");// Turning off autocomplete prevents the browser from remembering the
	// value when navigating through history, so we re-enable autocomplete
	// if the page is unloaded before the widget is destroyed. #7790
	this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete");}});},_destroy:function(){clearTimeout(this.searching);this.element.removeAttr("autocomplete");this.menu.element.remove();this.liveRegion.remove();},_setOption:function(key,value){this._super(key,value);if(key==="source"){this._initSource();}if(key==="appendTo"){this.menu.element.appendTo(this._appendTo());}if(key==="disabled"&&value&&this.xhr){this.xhr.abort();}},_isEventTargetInWidget:function(event){var menuElement=this.menu.element[0];return event.target===this.element[0]||event.target===menuElement||$.contains(menuElement,event.target);},_closeOnClickOutside:function(event){if(!this._isEventTargetInWidget(event)){this.close();}},_appendTo:function(){var element=this.options.appendTo;if(element){element=element.jquery||element.nodeType?$(element):this.document.find(element).eq(0);}if(!element||!element[0]){element=this.element.closest(".ui-front, dialog");}if(!element.length){element=this.document[0].body;}return element;},_initSource:function(){var array,url,that=this;if(Array.isArray(this.options.source)){array=this.options.source;this.source=function(request,response){response($.ui.autocomplete.filter(array,request.term));};}else if(typeof this.options.source==="string"){url=this.options.source;this.source=function(request,response){if(that.xhr){that.xhr.abort();}that.xhr=$.ajax({url:url,data:request,dataType:"json",success:function(data){response(data);},error:function(){response([]);}});};}else {this.source=this.options.source;}},_searchTimeout:function(event){clearTimeout(this.searching);this.searching=this._delay(function(){// Search if the value has changed, or if the user retypes the same value (see #7434)
	var equalValues=this.term===this._value(),menuVisible=this.menu.element.is(":visible"),modifierKey=event.altKey||event.ctrlKey||event.metaKey||event.shiftKey;if(!equalValues||equalValues&&!menuVisible&&!modifierKey){this.selectedItem=null;this.search(null,event);}},this.options.delay);},search:function(value,event){value=value!=null?value:this._value();// Always save the actual value, not the one passed as an argument
	this.term=this._value();if(value.length<this.options.minLength){return this.close(event);}if(this._trigger("search",event)===false){return;}return this._search(value);},_search:function(value){this.pending++;this._addClass("ui-autocomplete-loading");this.cancelSearch=false;this.source({term:value},this._response());},_response:function(){var index=++this.requestIndex;return function(content){if(index===this.requestIndex){this.__response(content);}this.pending--;if(!this.pending){this._removeClass("ui-autocomplete-loading");}}.bind(this);},__response:function(content){if(content){content=this._normalize(content);}this._trigger("response",null,{content:content});if(!this.options.disabled&&content&&content.length&&!this.cancelSearch){this._suggest(content);this._trigger("open");}else {// use ._close() instead of .close() so we don't cancel future searches
	this._close();}},close:function(event){this.cancelSearch=true;this._close(event);},_close:function(event){// Remove the handler that closes the menu on outside clicks
	this._off(this.document,"mousedown");if(this.menu.element.is(":visible")){this.menu.element.hide();this.menu.blur();this.isNewMenu=true;this._trigger("close",event);}},_change:function(event){if(this.previous!==this._value()){this._trigger("change",event,{item:this.selectedItem});}},_normalize:function(items){// assume all items have the right format when the first item is complete
	if(items.length&&items[0].label&&items[0].value){return items;}return $.map(items,function(item){if(typeof item==="string"){return {label:item,value:item};}return $.extend({},item,{label:item.label||item.value,value:item.value||item.label});});},_suggest:function(items){var ul=this.menu.element.empty();this._renderMenu(ul,items);this.isNewMenu=true;this.menu.refresh();// Size and position menu
	ul.show();this._resizeMenu();ul.position($.extend({of:this.element},this.options.position));if(this.options.autoFocus){this.menu.next();}// Listen for interactions outside of the widget (#6642)
	this._on(this.document,{mousedown:"_closeOnClickOutside"});},_resizeMenu:function(){var ul=this.menu.element;ul.outerWidth(Math.max(// Firefox wraps long text (possibly a rounding bug)
	// so we add 1px to avoid the wrapping (#7513)
	ul.width("").outerWidth()+1,this.element.outerWidth()));},_renderMenu:function(ul,items){var that=this;$.each(items,function(index,item){that._renderItemData(ul,item);});},_renderItemData:function(ul,item){return this._renderItem(ul,item).data("ui-autocomplete-item",item);},_renderItem:function(ul,item){return $("<li>").append($("<div>").text(item.label)).appendTo(ul);},_move:function(direction,event){if(!this.menu.element.is(":visible")){this.search(null,event);return;}if(this.menu.isFirstItem()&&/^previous/.test(direction)||this.menu.isLastItem()&&/^next/.test(direction)){if(!this.isMultiLine){this._value(this.term);}this.menu.blur();return;}this.menu[direction](event);},widget:function(){return this.menu.element;},_value:function(){return this.valueMethod.apply(this.element,arguments);},_keyEvent:function(keyEvent,event){if(!this.isMultiLine||this.menu.element.is(":visible")){this._move(keyEvent,event);// Prevents moving cursor to beginning/end of the text field in some browsers
	event.preventDefault();}},// Support: Chrome <=50
	// We should be able to just use this.element.prop( "isContentEditable" )
	// but hidden elements always report false in Chrome.
	// https://code.google.com/p/chromium/issues/detail?id=313082
	_isContentEditable:function(element){if(!element.length){return false;}var editable=element.prop("contentEditable");if(editable==="inherit"){return this._isContentEditable(element.parent());}return editable==="true";}});$.extend($.ui.autocomplete,{escapeRegex:function(value){return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&");},filter:function(array,term){var matcher=new RegExp($.ui.autocomplete.escapeRegex(term),"i");return $.grep(array,function(value){return matcher.test(value.label||value.value||value);});}});// Live region extension, adding a `messages` option
	// NOTE: This is an experimental API. We are still investigating
	// a full solution for string manipulation and internationalization.
	$.widget("ui.autocomplete",$.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(amount){return amount+(amount>1?" results are":" result is")+" available, use up and down arrow keys to navigate.";}}},__response:function(content){var message;this._superApply(arguments);if(this.options.disabled||this.cancelSearch){return;}if(content&&content.length){message=this.options.messages.results(content.length);}else {message=this.options.messages.noResults;}clearTimeout(this.liveRegionTimer);this.liveRegionTimer=this._delay(function(){this.liveRegion.html($("<div>").text(message));},100);}});$.ui.autocomplete;/*!
	 * jQuery UI Controlgroup 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Controlgroup
	//>>group: Widgets
	//>>description: Visually groups form control widgets
	//>>docs: https://api.jqueryui.com/controlgroup/
	//>>demos: https://jqueryui.com/controlgroup/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/controlgroup.css
	//>>css.theme: ../../themes/base/theme.css
	var controlgroupCornerRegex=/ui-corner-([a-z]){2,6}/g;$.widget("ui.controlgroup",{version:"1.13.3",defaultElement:"<div>",options:{direction:"horizontal",disabled:null,onlyVisible:true,items:{"button":"input[type=button], input[type=submit], input[type=reset], button, a","controlgroupLabel":".ui-controlgroup-label","checkboxradio":"input[type='checkbox'], input[type='radio']","selectmenu":"select","spinner":".ui-spinner-input"}},_create:function(){this._enhance();},// To support the enhanced option in jQuery Mobile, we isolate DOM manipulation
	_enhance:function(){this.element.attr("role","toolbar");this.refresh();},_destroy:function(){this._callChildMethod("destroy");this.childWidgets.removeData("ui-controlgroup-data");this.element.removeAttr("role");if(this.options.items.controlgroupLabel){this.element.find(this.options.items.controlgroupLabel).find(".ui-controlgroup-label-contents").contents().unwrap();}},_initWidgets:function(){var that=this,childWidgets=[];// First we iterate over each of the items options
	$.each(this.options.items,function(widget,selector){var labels;var options={};// Make sure the widget has a selector set
	if(!selector){return;}if(widget==="controlgroupLabel"){labels=that.element.find(selector);labels.each(function(){var element=$(this);if(element.children(".ui-controlgroup-label-contents").length){return;}element.contents().wrapAll("<span class='ui-controlgroup-label-contents'></span>");});that._addClass(labels,null,"ui-widget ui-widget-content ui-state-default");childWidgets=childWidgets.concat(labels.get());return;}// Make sure the widget actually exists
	if(!$.fn[widget]){return;}// We assume everything is in the middle to start because we can't determine
	// first / last elements until all enhancments are done.
	if(that["_"+widget+"Options"]){options=that["_"+widget+"Options"]("middle");}else {options={classes:{}};}// Find instances of this widget inside controlgroup and init them
	that.element.find(selector).each(function(){var element=$(this);var instance=element[widget]("instance");// We need to clone the default options for this type of widget to avoid
	// polluting the variable options which has a wider scope than a single widget.
	var instanceOptions=$.widget.extend({},options);// If the button is the child of a spinner ignore it
	// TODO: Find a more generic solution
	if(widget==="button"&&element.parent(".ui-spinner").length){return;}// Create the widget if it doesn't exist
	if(!instance){instance=element[widget]()[widget]("instance");}if(instance){instanceOptions.classes=that._resolveClassesValues(instanceOptions.classes,instance);}element[widget](instanceOptions);// Store an instance of the controlgroup to be able to reference
	// from the outermost element for changing options and refresh
	var widgetElement=element[widget]("widget");$.data(widgetElement[0],"ui-controlgroup-data",instance?instance:element[widget]("instance"));childWidgets.push(widgetElement[0]);});});this.childWidgets=$($.uniqueSort(childWidgets));this._addClass(this.childWidgets,"ui-controlgroup-item");},_callChildMethod:function(method){this.childWidgets.each(function(){var element=$(this),data=element.data("ui-controlgroup-data");if(data&&data[method]){data[method]();}});},_updateCornerClass:function(element,position){var remove="ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all";var add=this._buildSimpleOptions(position,"label").classes.label;this._removeClass(element,null,remove);this._addClass(element,null,add);},_buildSimpleOptions:function(position,key){var direction=this.options.direction==="vertical";var result={classes:{}};result.classes[key]={"middle":"","first":"ui-corner-"+(direction?"top":"left"),"last":"ui-corner-"+(direction?"bottom":"right"),"only":"ui-corner-all"}[position];return result;},_spinnerOptions:function(position){var options=this._buildSimpleOptions(position,"ui-spinner");options.classes["ui-spinner-up"]="";options.classes["ui-spinner-down"]="";return options;},_buttonOptions:function(position){return this._buildSimpleOptions(position,"ui-button");},_checkboxradioOptions:function(position){return this._buildSimpleOptions(position,"ui-checkboxradio-label");},_selectmenuOptions:function(position){var direction=this.options.direction==="vertical";return {width:direction?"auto":false,classes:{middle:{"ui-selectmenu-button-open":"","ui-selectmenu-button-closed":""},first:{"ui-selectmenu-button-open":"ui-corner-"+(direction?"top":"tl"),"ui-selectmenu-button-closed":"ui-corner-"+(direction?"top":"left")},last:{"ui-selectmenu-button-open":direction?"":"ui-corner-tr","ui-selectmenu-button-closed":"ui-corner-"+(direction?"bottom":"right")},only:{"ui-selectmenu-button-open":"ui-corner-top","ui-selectmenu-button-closed":"ui-corner-all"}}[position]};},_resolveClassesValues:function(classes,instance){var result={};$.each(classes,function(key){var current=instance.options.classes[key]||"";current=String.prototype.trim.call(current.replace(controlgroupCornerRegex,""));result[key]=(current+" "+classes[key]).replace(/\s+/g," ");});return result;},_setOption:function(key,value){if(key==="direction"){this._removeClass("ui-controlgroup-"+this.options.direction);}this._super(key,value);if(key==="disabled"){this._callChildMethod(value?"disable":"enable");return;}this.refresh();},refresh:function(){var children,that=this;this._addClass("ui-controlgroup ui-controlgroup-"+this.options.direction);if(this.options.direction==="horizontal"){this._addClass(null,"ui-helper-clearfix");}this._initWidgets();children=this.childWidgets;// We filter here because we need to track all childWidgets not just the visible ones
	if(this.options.onlyVisible){children=children.filter(":visible");}if(children.length){// We do this last because we need to make sure all enhancment is done
	// before determining first and last
	$.each(["first","last"],function(index,value){var instance=children[value]().data("ui-controlgroup-data");if(instance&&that["_"+instance.widgetName+"Options"]){var options=that["_"+instance.widgetName+"Options"](children.length===1?"only":value);options.classes=that._resolveClassesValues(options.classes,instance);instance.element[instance.widgetName](options);}else {that._updateCornerClass(children[value](),value);}});// Finally call the refresh method on each of the child widgets.
	this._callChildMethod("refresh");}}});/*!
	 * jQuery UI Checkboxradio 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Checkboxradio
	//>>group: Widgets
	//>>description: Enhances a form with multiple themeable checkboxes or radio buttons.
	//>>docs: https://api.jqueryui.com/checkboxradio/
	//>>demos: https://jqueryui.com/checkboxradio/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/button.css
	//>>css.structure: ../../themes/base/checkboxradio.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.checkboxradio",[$.ui.formResetMixin,{version:"1.13.3",options:{disabled:null,label:null,icon:true,classes:{"ui-checkboxradio-label":"ui-corner-all","ui-checkboxradio-icon":"ui-corner-all"}},_getCreateOptions:function(){var disabled,labels,labelContents;var options=this._super()||{};// We read the type here, because it makes more sense to throw a element type error first,
	// rather then the error for lack of a label. Often if its the wrong type, it
	// won't have a label (e.g. calling on a div, btn, etc)
	this._readType();labels=this.element.labels();// If there are multiple labels, use the last one
	this.label=$(labels[labels.length-1]);if(!this.label.length){$.error("No label found for checkboxradio widget");}this.originalLabel="";// We need to get the label text but this may also need to make sure it does not contain the
	// input itself.
	// The label contents could be text, html, or a mix. We wrap all elements
	// and read the wrapper's `innerHTML` to get a string representation of
	// the label, without the input as part of it.
	labelContents=this.label.contents().not(this.element[0]);if(labelContents.length){this.originalLabel+=labelContents.clone().wrapAll("<div></div>").parent().html();}// Set the label option if we found label text
	if(this.originalLabel){options.label=this.originalLabel;}disabled=this.element[0].disabled;if(disabled!=null){options.disabled=disabled;}return options;},_create:function(){var checked=this.element[0].checked;this._bindFormResetHandler();if(this.options.disabled==null){this.options.disabled=this.element[0].disabled;}this._setOption("disabled",this.options.disabled);this._addClass("ui-checkboxradio","ui-helper-hidden-accessible");this._addClass(this.label,"ui-checkboxradio-label","ui-button ui-widget");if(this.type==="radio"){this._addClass(this.label,"ui-checkboxradio-radio-label");}if(this.options.label&&this.options.label!==this.originalLabel){this._updateLabel();}else if(this.originalLabel){this.options.label=this.originalLabel;}this._enhance();if(checked){this._addClass(this.label,"ui-checkboxradio-checked","ui-state-active");}this._on({change:"_toggleClasses",focus:function(){this._addClass(this.label,null,"ui-state-focus ui-visual-focus");},blur:function(){this._removeClass(this.label,null,"ui-state-focus ui-visual-focus");}});},_readType:function(){var nodeName=this.element[0].nodeName.toLowerCase();this.type=this.element[0].type;if(nodeName!=="input"||!/radio|checkbox/.test(this.type)){$.error("Can't create checkboxradio on element.nodeName="+nodeName+" and element.type="+this.type);}},// Support jQuery Mobile enhanced option
	_enhance:function(){this._updateIcon(this.element[0].checked);},widget:function(){return this.label;},_getRadioGroup:function(){var group;var name=this.element[0].name;var nameSelector="input[name='"+$.escapeSelector(name)+"']";if(!name){return $([]);}if(this.form.length){group=$(this.form[0].elements).filter(nameSelector);}else {// Not inside a form, check all inputs that also are not inside a form
	group=$(nameSelector).filter(function(){return $(this)._form().length===0;});}return group.not(this.element);},_toggleClasses:function(){var checked=this.element[0].checked;this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",checked);if(this.options.icon&&this.type==="checkbox"){this._toggleClass(this.icon,null,"ui-icon-check ui-state-checked",checked)._toggleClass(this.icon,null,"ui-icon-blank",!checked);}if(this.type==="radio"){this._getRadioGroup().each(function(){var instance=$(this).checkboxradio("instance");if(instance){instance._removeClass(instance.label,"ui-checkboxradio-checked","ui-state-active");}});}},_destroy:function(){this._unbindFormResetHandler();if(this.icon){this.icon.remove();this.iconSpace.remove();}},_setOption:function(key,value){// We don't allow the value to be set to nothing
	if(key==="label"&&!value){return;}this._super(key,value);if(key==="disabled"){this._toggleClass(this.label,null,"ui-state-disabled",value);this.element[0].disabled=value;// Don't refresh when setting disabled
	return;}this.refresh();},_updateIcon:function(checked){var toAdd="ui-icon ui-icon-background ";if(this.options.icon){if(!this.icon){this.icon=$("<span>");this.iconSpace=$("<span> </span>");this._addClass(this.iconSpace,"ui-checkboxradio-icon-space");}if(this.type==="checkbox"){toAdd+=checked?"ui-icon-check ui-state-checked":"ui-icon-blank";this._removeClass(this.icon,null,checked?"ui-icon-blank":"ui-icon-check");}else {toAdd+="ui-icon-blank";}this._addClass(this.icon,"ui-checkboxradio-icon",toAdd);if(!checked){this._removeClass(this.icon,null,"ui-icon-check ui-state-checked");}this.icon.prependTo(this.label).after(this.iconSpace);}else if(this.icon!==undefined){this.icon.remove();this.iconSpace.remove();delete this.icon;}},_updateLabel:function(){// Remove the contents of the label ( minus the icon, icon space, and input )
	var contents=this.label.contents().not(this.element[0]);if(this.icon){contents=contents.not(this.icon[0]);}if(this.iconSpace){contents=contents.not(this.iconSpace[0]);}contents.remove();this.label.append(this.options.label);},refresh:function(){var checked=this.element[0].checked,isDisabled=this.element[0].disabled;this._updateIcon(checked);this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",checked);if(this.options.label!==null){this._updateLabel();}if(isDisabled!==this.options.disabled){this._setOptions({"disabled":isDisabled});}}}]);$.ui.checkboxradio;/*!
	 * jQuery UI Button 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Button
	//>>group: Widgets
	//>>description: Enhances a form with themeable buttons.
	//>>docs: https://api.jqueryui.com/button/
	//>>demos: https://jqueryui.com/button/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/button.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.button",{version:"1.13.3",defaultElement:"<button>",options:{classes:{"ui-button":"ui-corner-all"},disabled:null,icon:null,iconPosition:"beginning",label:null,showLabel:true},_getCreateOptions:function(){var disabled,// This is to support cases like in jQuery Mobile where the base widget does have
	// an implementation of _getCreateOptions
	options=this._super()||{};this.isInput=this.element.is("input");disabled=this.element[0].disabled;if(disabled!=null){options.disabled=disabled;}this.originalLabel=this.isInput?this.element.val():this.element.html();if(this.originalLabel){options.label=this.originalLabel;}return options;},_create:function(){if(!this.option.showLabel&!this.options.icon){this.options.showLabel=true;}// We have to check the option again here even though we did in _getCreateOptions,
	// because null may have been passed on init which would override what was set in
	// _getCreateOptions
	if(this.options.disabled==null){this.options.disabled=this.element[0].disabled||false;}this.hasTitle=!!this.element.attr("title");// Check to see if the label needs to be set or if its already correct
	if(this.options.label&&this.options.label!==this.originalLabel){if(this.isInput){this.element.val(this.options.label);}else {this.element.html(this.options.label);}}this._addClass("ui-button","ui-widget");this._setOption("disabled",this.options.disabled);this._enhance();if(this.element.is("a")){this._on({"keyup":function(event){if(event.keyCode===$.ui.keyCode.SPACE){event.preventDefault();// Support: PhantomJS <= 1.9, IE 8 Only
	// If a native click is available use it so we actually cause navigation
	// otherwise just trigger a click event
	if(this.element[0].click){this.element[0].click();}else {this.element.trigger("click");}}}});}},_enhance:function(){if(!this.element.is("button")){this.element.attr("role","button");}if(this.options.icon){this._updateIcon("icon",this.options.icon);this._updateTooltip();}},_updateTooltip:function(){this.title=this.element.attr("title");if(!this.options.showLabel&&!this.title){this.element.attr("title",this.options.label);}},_updateIcon:function(option,value){var icon=option!=="iconPosition",position=icon?this.options.iconPosition:value,displayBlock=position==="top"||position==="bottom";// Create icon
	if(!this.icon){this.icon=$("<span>");this._addClass(this.icon,"ui-button-icon","ui-icon");if(!this.options.showLabel){this._addClass("ui-button-icon-only");}}else if(icon){// If we are updating the icon remove the old icon class
	this._removeClass(this.icon,null,this.options.icon);}// If we are updating the icon add the new icon class
	if(icon){this._addClass(this.icon,null,value);}this._attachIcon(position);// If the icon is on top or bottom we need to add the ui-widget-icon-block class and remove
	// the iconSpace if there is one.
	if(displayBlock){this._addClass(this.icon,null,"ui-widget-icon-block");if(this.iconSpace){this.iconSpace.remove();}}else {// Position is beginning or end so remove the ui-widget-icon-block class and add the
	// space if it does not exist
	if(!this.iconSpace){this.iconSpace=$("<span> </span>");this._addClass(this.iconSpace,"ui-button-icon-space");}this._removeClass(this.icon,null,"ui-wiget-icon-block");this._attachIconSpace(position);}},_destroy:function(){this.element.removeAttr("role");if(this.icon){this.icon.remove();}if(this.iconSpace){this.iconSpace.remove();}if(!this.hasTitle){this.element.removeAttr("title");}},_attachIconSpace:function(iconPosition){this.icon[/^(?:end|bottom)/.test(iconPosition)?"before":"after"](this.iconSpace);},_attachIcon:function(iconPosition){this.element[/^(?:end|bottom)/.test(iconPosition)?"append":"prepend"](this.icon);},_setOptions:function(options){var newShowLabel=options.showLabel===undefined?this.options.showLabel:options.showLabel,newIcon=options.icon===undefined?this.options.icon:options.icon;if(!newShowLabel&&!newIcon){options.showLabel=true;}this._super(options);},_setOption:function(key,value){if(key==="icon"){if(value){this._updateIcon(key,value);}else if(this.icon){this.icon.remove();if(this.iconSpace){this.iconSpace.remove();}}}if(key==="iconPosition"){this._updateIcon(key,value);}// Make sure we can't end up with a button that has neither text nor icon
	if(key==="showLabel"){this._toggleClass("ui-button-icon-only",null,!value);this._updateTooltip();}if(key==="label"){if(this.isInput){this.element.val(value);}else {// If there is an icon, append it, else nothing then append the value
	// this avoids removal of the icon when setting label text
	this.element.html(value);if(this.icon){this._attachIcon(this.options.iconPosition);this._attachIconSpace(this.options.iconPosition);}}}this._super(key,value);if(key==="disabled"){this._toggleClass(null,"ui-state-disabled",value);this.element[0].disabled=value;if(value){this.element.trigger("blur");}}},refresh:function(){// Make sure to only check disabled if its an element that supports this otherwise
	// check for the disabled class to determine state
	var isDisabled=this.element.is("input, button")?this.element[0].disabled:this.element.hasClass("ui-button-disabled");if(isDisabled!==this.options.disabled){this._setOptions({disabled:isDisabled});}this._updateTooltip();}});// DEPRECATED
	if($.uiBackCompat!==false){// Text and Icons options
	$.widget("ui.button",$.ui.button,{options:{text:true,icons:{primary:null,secondary:null}},_create:function(){if(this.options.showLabel&&!this.options.text){this.options.showLabel=this.options.text;}if(!this.options.showLabel&&this.options.text){this.options.text=this.options.showLabel;}if(!this.options.icon&&(this.options.icons.primary||this.options.icons.secondary)){if(this.options.icons.primary){this.options.icon=this.options.icons.primary;}else {this.options.icon=this.options.icons.secondary;this.options.iconPosition="end";}}else if(this.options.icon){this.options.icons.primary=this.options.icon;}this._super();},_setOption:function(key,value){if(key==="text"){this._super("showLabel",value);return;}if(key==="showLabel"){this.options.text=value;}if(key==="icon"){this.options.icons.primary=value;}if(key==="icons"){if(value.primary){this._super("icon",value.primary);this._super("iconPosition","beginning");}else if(value.secondary){this._super("icon",value.secondary);this._super("iconPosition","end");}}this._superApply(arguments);}});$.fn.button=function(orig){return function(options){var isMethodCall=typeof options==="string";var args=Array.prototype.slice.call(arguments,1);var returnValue=this;if(isMethodCall){// If this is an empty collection, we need to have the instance method
	// return undefined instead of the jQuery instance
	if(!this.length&&options==="instance"){returnValue=undefined;}else {this.each(function(){var methodValue;var type=$(this).attr("type");var name=type!=="checkbox"&&type!=="radio"?"button":"checkboxradio";var instance=$.data(this,"ui-"+name);if(options==="instance"){returnValue=instance;return false;}if(!instance){return $.error("cannot call methods on button"+" prior to initialization; "+"attempted to call method '"+options+"'");}if(typeof instance[options]!=="function"||options.charAt(0)==="_"){return $.error("no such method '"+options+"' for button"+" widget instance");}methodValue=instance[options].apply(instance,args);if(methodValue!==instance&&methodValue!==undefined){returnValue=methodValue&&methodValue.jquery?returnValue.pushStack(methodValue.get()):methodValue;return false;}});}}else {// Allow multiple hashes to be passed on init
	if(args.length){options=$.widget.extend.apply(null,[options].concat(args));}this.each(function(){var type=$(this).attr("type");var name=type!=="checkbox"&&type!=="radio"?"button":"checkboxradio";var instance=$.data(this,"ui-"+name);if(instance){instance.option(options||{});if(instance._init){instance._init();}}else {if(name==="button"){orig.call($(this),options);return;}$(this).checkboxradio($.extend({icon:false},options));}});}return returnValue;};}($.fn.button);$.fn.buttonset=function(){if(!$.ui.controlgroup){$.error("Controlgroup widget missing");}if(arguments[0]==="option"&&arguments[1]==="items"&&arguments[2]){return this.controlgroup.apply(this,[arguments[0],"items.button",arguments[2]]);}if(arguments[0]==="option"&&arguments[1]==="items"){return this.controlgroup.apply(this,[arguments[0],"items.button"]);}if(typeof arguments[0]==="object"&&arguments[0].items){arguments[0].items={button:arguments[0].items};}return this.controlgroup.apply(this,arguments);};}$.ui.button;/* eslint-disable max-len, camelcase *//*!
	 * jQuery UI Datepicker 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Datepicker
	//>>group: Widgets
	//>>description: Displays a calendar from an input or inline for selecting dates.
	//>>docs: https://api.jqueryui.com/datepicker/
	//>>demos: https://jqueryui.com/datepicker/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/datepicker.css
	//>>css.theme: ../../themes/base/theme.css
	$.extend($.ui,{datepicker:{version:"1.13.3"}});var datepicker_instActive;function datepicker_getZindex(elem){var position,value;while(elem.length&&elem[0]!==document){// Ignore z-index if position is set to a value where z-index is ignored by the browser
	// This makes behavior of this function consistent across browsers
	// WebKit always returns auto if the element is positioned
	position=elem.css("position");if(position==="absolute"||position==="relative"||position==="fixed"){// IE returns 0 when zIndex is not specified
	// other browsers return a string
	// we ignore the case of nested elements with an explicit value of 0
	// <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
	value=parseInt(elem.css("zIndex"),10);if(!isNaN(value)&&value!==0){return value;}}elem=elem.parent();}return 0;}/* Date picker manager.
	   Use the singleton instance of this class, $.datepicker, to interact with the date picker.
	   Settings for (groups of) date pickers are maintained in an instance object,
	   allowing multiple different settings on the same page. */function Datepicker(){this._curInst=null;// The current instance in use
	this._keyEvent=false;// If the last event was a key event
	this._disabledInputs=[];// List of date picker inputs that have been disabled
	this._datepickerShowing=false;// True if the popup picker is showing , false if not
	this._inDialog=false;// True if showing within a "dialog", false if not
	this._mainDivId="ui-datepicker-div";// The ID of the main datepicker division
	this._inlineClass="ui-datepicker-inline";// The name of the inline marker class
	this._appendClass="ui-datepicker-append";// The name of the append marker class
	this._triggerClass="ui-datepicker-trigger";// The name of the trigger marker class
	this._dialogClass="ui-datepicker-dialog";// The name of the dialog marker class
	this._disableClass="ui-datepicker-disabled";// The name of the disabled covering marker class
	this._unselectableClass="ui-datepicker-unselectable";// The name of the unselectable cell marker class
	this._currentClass="ui-datepicker-current-day";// The name of the current day marker class
	this._dayOverClass="ui-datepicker-days-cell-over";// The name of the day hover marker class
	this.regional=[];// Available regional settings, indexed by language code
	this.regional[""]={// Default regional settings
	closeText:"Done",// Display text for close link
	prevText:"Prev",// Display text for previous month link
	nextText:"Next",// Display text for next month link
	currentText:"Today",// Display text for current month link
	monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],// Names of months for drop-down and formatting
	monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],// For formatting
	dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],// For formatting
	dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],// For formatting
	dayNamesMin:["Su","Mo","Tu","We","Th","Fr","Sa"],// Column headings for days starting at Sunday
	weekHeader:"Wk",// Column header for week of the year
	dateFormat:"mm/dd/yy",// See format options on parseDate
	firstDay:0,// The first day of the week, Sun = 0, Mon = 1, ...
	isRTL:false,// True if right-to-left language, false if left-to-right
	showMonthAfterYear:false,// True if the year select precedes month, false for month then year
	yearSuffix:"",// Additional text to append to the year in the month headers,
	selectMonthLabel:"Select month",// Invisible label for month selector
	selectYearLabel:"Select year"// Invisible label for year selector
	};this._defaults={// Global defaults for all the date picker instances
	showOn:"focus",// "focus" for popup on focus,
	// "button" for trigger button, or "both" for either
	showAnim:"fadeIn",// Name of jQuery animation for popup
	showOptions:{},// Options for enhanced animations
	defaultDate:null,// Used when field is blank: actual date,
	// +/-number for offset from today, null for today
	appendText:"",// Display text following the input box, e.g. showing the format
	buttonText:"...",// Text for trigger button
	buttonImage:"",// URL for trigger button image
	buttonImageOnly:false,// True if the image appears alone, false if it appears on a button
	hideIfNoPrevNext:false,// True to hide next/previous month links
	// if not applicable, false to just disable them
	navigationAsDateFormat:false,// True if date formatting applied to prev/today/next links
	gotoCurrent:false,// True if today link goes back to current selection instead
	changeMonth:false,// True if month can be selected directly, false if only prev/next
	changeYear:false,// True if year can be selected directly, false if only prev/next
	yearRange:"c-10:c+10",// Range of years to display in drop-down,
	// either relative to today's year (-nn:+nn), relative to currently displayed year
	// (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)
	showOtherMonths:false,// True to show dates in other months, false to leave blank
	selectOtherMonths:false,// True to allow selection of dates in other months, false for unselectable
	showWeek:false,// True to show week of the year, false to not show it
	calculateWeek:this.iso8601Week,// How to calculate the week of the year,
	// takes a Date and returns the number of the week for it
	shortYearCutoff:"+10",// Short year values < this are in the current century,
	// > this are in the previous century,
	// string value starting with "+" for current year + value
	minDate:null,// The earliest selectable date, or null for no limit
	maxDate:null,// The latest selectable date, or null for no limit
	duration:"fast",// Duration of display/closure
	beforeShowDay:null,// Function that takes a date and returns an array with
	// [0] = true if selectable, false if not, [1] = custom CSS class name(s) or "",
	// [2] = cell title (optional), e.g. $.datepicker.noWeekends
	beforeShow:null,// Function that takes an input field and
	// returns a set of custom settings for the date picker
	onSelect:null,// Define a callback function when a date is selected
	onChangeMonthYear:null,// Define a callback function when the month or year is changed
	onClose:null,// Define a callback function when the datepicker is closed
	onUpdateDatepicker:null,// Define a callback function when the datepicker is updated
	numberOfMonths:1,// Number of months to show at a time
	showCurrentAtPos:0,// The position in multipe months at which to show the current month (starting at 0)
	stepMonths:1,// Number of months to step back/forward
	stepBigMonths:12,// Number of months to step back/forward for the big links
	altField:"",// Selector for an alternate field to store selected dates into
	altFormat:"",// The date format to use for the alternate field
	constrainInput:true,// The input is constrained by the current date format
	showButtonPanel:false,// True to show button panel, false to not show it
	autoSize:false,// True to size the input for the date format, false to leave as is
	disabled:false// The initial disabled state
	};$.extend(this._defaults,this.regional[""]);this.regional.en=$.extend(true,{},this.regional[""]);this.regional["en-US"]=$.extend(true,{},this.regional.en);this.dpDiv=datepicker_bindHover($("<div id='"+this._mainDivId+"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"));}$.extend(Datepicker.prototype,{/* Class name added to elements to indicate already configured with a date picker. */markerClassName:"hasDatepicker",//Keep track of the maximum number of rows displayed (see #7043)
	maxRows:4,// TODO rename to "widget" when switching to widget factory
	_widgetDatepicker:function(){return this.dpDiv;},/* Override the default settings for all instances of the date picker.
		 * @param  settings  object - the new settings to use as defaults (anonymous object)
		 * @return the manager object
		 */setDefaults:function(settings){datepicker_extendRemove(this._defaults,settings||{});return this;},/* Attach the date picker to a jQuery selection.
		 * @param  target	element - the target input field or division or span
		 * @param  settings  object - the new settings to use for this date picker instance (anonymous)
		 */_attachDatepicker:function(target,settings){var nodeName,inline,inst;nodeName=target.nodeName.toLowerCase();inline=nodeName==="div"||nodeName==="span";if(!target.id){this.uuid+=1;target.id="dp"+this.uuid;}inst=this._newInst($(target),inline);inst.settings=$.extend({},settings||{});if(nodeName==="input"){this._connectDatepicker(target,inst);}else if(inline){this._inlineDatepicker(target,inst);}},/* Create a new instance object. */_newInst:function(target,inline){var id=target[0].id.replace(/([^A-Za-z0-9_\-])/g,"\\\\$1");// escape jQuery meta chars
	return {id:id,input:target,// associated target
	selectedDay:0,selectedMonth:0,selectedYear:0,// current selection
	drawMonth:0,drawYear:0,// month being drawn
	inline:inline,// is datepicker inline or not
	dpDiv:!inline?this.dpDiv:// presentation div
	datepicker_bindHover($("<div class='"+this._inlineClass+" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"))};},/* Attach the date picker to an input field. */_connectDatepicker:function(target,inst){var input=$(target);inst.append=$([]);inst.trigger=$([]);if(input.hasClass(this.markerClassName)){return;}this._attachments(input,inst);input.addClass(this.markerClassName).on("keydown",this._doKeyDown).on("keypress",this._doKeyPress).on("keyup",this._doKeyUp);this._autoSize(inst);$.data(target,"datepicker",inst);//If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)
	if(inst.settings.disabled){this._disableDatepicker(target);}},/* Make attachments based on settings. */_attachments:function(input,inst){var showOn,buttonText,buttonImage,appendText=this._get(inst,"appendText"),isRTL=this._get(inst,"isRTL");if(inst.append){inst.append.remove();}if(appendText){inst.append=$("<span>").addClass(this._appendClass).text(appendText);input[isRTL?"before":"after"](inst.append);}input.off("focus",this._showDatepicker);if(inst.trigger){inst.trigger.remove();}showOn=this._get(inst,"showOn");if(showOn==="focus"||showOn==="both"){// pop-up date picker when in the marked field
	input.on("focus",this._showDatepicker);}if(showOn==="button"||showOn==="both"){// pop-up date picker when button clicked
	buttonText=this._get(inst,"buttonText");buttonImage=this._get(inst,"buttonImage");if(this._get(inst,"buttonImageOnly")){inst.trigger=$("<img>").addClass(this._triggerClass).attr({src:buttonImage,alt:buttonText,title:buttonText});}else {inst.trigger=$("<button type='button'>").addClass(this._triggerClass);if(buttonImage){inst.trigger.html($("<img>").attr({src:buttonImage,alt:buttonText,title:buttonText}));}else {inst.trigger.text(buttonText);}}input[isRTL?"before":"after"](inst.trigger);inst.trigger.on("click",function(){if($.datepicker._datepickerShowing&&$.datepicker._lastInput===input[0]){$.datepicker._hideDatepicker();}else if($.datepicker._datepickerShowing&&$.datepicker._lastInput!==input[0]){$.datepicker._hideDatepicker();$.datepicker._showDatepicker(input[0]);}else {$.datepicker._showDatepicker(input[0]);}return false;});}},/* Apply the maximum length for the date format. */_autoSize:function(inst){if(this._get(inst,"autoSize")&&!inst.inline){var findMax,max,maxI,i,date=new Date(2009,12-1,20),// Ensure double digits
	dateFormat=this._get(inst,"dateFormat");if(dateFormat.match(/[DM]/)){findMax=function(names){max=0;maxI=0;for(i=0;i<names.length;i++){if(names[i].length>max){max=names[i].length;maxI=i;}}return maxI;};date.setMonth(findMax(this._get(inst,dateFormat.match(/MM/)?"monthNames":"monthNamesShort")));date.setDate(findMax(this._get(inst,dateFormat.match(/DD/)?"dayNames":"dayNamesShort"))+20-date.getDay());}inst.input.attr("size",this._formatDate(inst,date).length);}},/* Attach an inline date picker to a div. */_inlineDatepicker:function(target,inst){var divSpan=$(target);if(divSpan.hasClass(this.markerClassName)){return;}divSpan.addClass(this.markerClassName).append(inst.dpDiv);$.data(target,"datepicker",inst);this._setDate(inst,this._getDefaultDate(inst),true);this._updateDatepicker(inst);this._updateAlternate(inst);//If disabled option is true, disable the datepicker before showing it (see ticket #5665)
	if(inst.settings.disabled){this._disableDatepicker(target);}// Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements
	// https://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height
	inst.dpDiv.css("display","block");},/* Pop-up the date picker in a "dialog" box.
		 * @param  input element - ignored
		 * @param  date	string or Date - the initial date to display
		 * @param  onSelect  function - the function to call when a date is selected
		 * @param  settings  object - update the dialog date picker instance's settings (anonymous object)
		 * @param  pos int[2] - coordinates for the dialog's position within the screen or
		 *					event - with x/y coordinates or
		 *					leave empty for default (screen centre)
		 * @return the manager object
		 */_dialogDatepicker:function(input,date,onSelect,settings,pos){var id,browserWidth,browserHeight,scrollX,scrollY,inst=this._dialogInst;// internal instance
	if(!inst){this.uuid+=1;id="dp"+this.uuid;this._dialogInput=$("<input type='text' id='"+id+"' style='position: absolute; top: -100px; width: 0px;'/>");this._dialogInput.on("keydown",this._doKeyDown);$("body").append(this._dialogInput);inst=this._dialogInst=this._newInst(this._dialogInput,false);inst.settings={};$.data(this._dialogInput[0],"datepicker",inst);}datepicker_extendRemove(inst.settings,settings||{});date=date&&date.constructor===Date?this._formatDate(inst,date):date;this._dialogInput.val(date);this._pos=pos?pos.length?pos:[pos.pageX,pos.pageY]:null;if(!this._pos){browserWidth=document.documentElement.clientWidth;browserHeight=document.documentElement.clientHeight;scrollX=document.documentElement.scrollLeft||document.body.scrollLeft;scrollY=document.documentElement.scrollTop||document.body.scrollTop;this._pos=// should use actual width/height below
	[browserWidth/2-100+scrollX,browserHeight/2-150+scrollY];}// Move input on screen for focus, but hidden behind dialog
	this._dialogInput.css("left",this._pos[0]+20+"px").css("top",this._pos[1]+"px");inst.settings.onSelect=onSelect;this._inDialog=true;this.dpDiv.addClass(this._dialogClass);this._showDatepicker(this._dialogInput[0]);if($.blockUI){$.blockUI(this.dpDiv);}$.data(this._dialogInput[0],"datepicker",inst);return this;},/* Detach a datepicker from its control.
		 * @param  target	element - the target input field or division or span
		 */_destroyDatepicker:function(target){var nodeName,$target=$(target),inst=$.data(target,"datepicker");if(!$target.hasClass(this.markerClassName)){return;}nodeName=target.nodeName.toLowerCase();$.removeData(target,"datepicker");if(nodeName==="input"){inst.append.remove();inst.trigger.remove();$target.removeClass(this.markerClassName).off("focus",this._showDatepicker).off("keydown",this._doKeyDown).off("keypress",this._doKeyPress).off("keyup",this._doKeyUp);}else if(nodeName==="div"||nodeName==="span"){$target.removeClass(this.markerClassName).empty();}if(datepicker_instActive===inst){datepicker_instActive=null;this._curInst=null;}},/* Enable the date picker to a jQuery selection.
		 * @param  target	element - the target input field or division or span
		 */_enableDatepicker:function(target){var nodeName,inline,$target=$(target),inst=$.data(target,"datepicker");if(!$target.hasClass(this.markerClassName)){return;}nodeName=target.nodeName.toLowerCase();if(nodeName==="input"){target.disabled=false;inst.trigger.filter("button").each(function(){this.disabled=false;}).end().filter("img").css({opacity:"1.0",cursor:""});}else if(nodeName==="div"||nodeName==="span"){inline=$target.children("."+this._inlineClass);inline.children().removeClass("ui-state-disabled");inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",false);}this._disabledInputs=$.map(this._disabledInputs,// Delete entry
	function(value){return value===target?null:value;});},/* Disable the date picker to a jQuery selection.
		 * @param  target	element - the target input field or division or span
		 */_disableDatepicker:function(target){var nodeName,inline,$target=$(target),inst=$.data(target,"datepicker");if(!$target.hasClass(this.markerClassName)){return;}nodeName=target.nodeName.toLowerCase();if(nodeName==="input"){target.disabled=true;inst.trigger.filter("button").each(function(){this.disabled=true;}).end().filter("img").css({opacity:"0.5",cursor:"default"});}else if(nodeName==="div"||nodeName==="span"){inline=$target.children("."+this._inlineClass);inline.children().addClass("ui-state-disabled");inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",true);}this._disabledInputs=$.map(this._disabledInputs,// Delete entry
	function(value){return value===target?null:value;});this._disabledInputs[this._disabledInputs.length]=target;},/* Is the first field in a jQuery collection disabled as a datepicker?
		 * @param  target	element - the target input field or division or span
		 * @return boolean - true if disabled, false if enabled
		 */_isDisabledDatepicker:function(target){if(!target){return false;}for(var i=0;i<this._disabledInputs.length;i++){if(this._disabledInputs[i]===target){return true;}}return false;},/* Retrieve the instance data for the target control.
		 * @param  target  element - the target input field or division or span
		 * @return  object - the associated instance data
		 * @throws  error if a jQuery problem getting data
		 */_getInst:function(target){try{return $.data(target,"datepicker");}catch(err){throw "Missing instance data for this datepicker";}},/* Update or retrieve the settings for a date picker attached to an input field or division.
		 * @param  target  element - the target input field or division or span
		 * @param  name	object - the new settings to update or
		 *				string - the name of the setting to change or retrieve,
		 *				when retrieving also "all" for all instance settings or
		 *				"defaults" for all global defaults
		 * @param  value   any - the new value for the setting
		 *				(omit if above is an object or to retrieve a value)
		 */_optionDatepicker:function(target,name,value){var settings,date,minDate,maxDate,inst=this._getInst(target);if(arguments.length===2&&typeof name==="string"){return name==="defaults"?$.extend({},$.datepicker._defaults):inst?name==="all"?$.extend({},inst.settings):this._get(inst,name):null;}settings=name||{};if(typeof name==="string"){settings={};settings[name]=value;}if(inst){if(this._curInst===inst){this._hideDatepicker();}date=this._getDateDatepicker(target,true);minDate=this._getMinMaxDate(inst,"min");maxDate=this._getMinMaxDate(inst,"max");datepicker_extendRemove(inst.settings,settings);// reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided
	if(minDate!==null&&settings.dateFormat!==undefined&&settings.minDate===undefined){inst.settings.minDate=this._formatDate(inst,minDate);}if(maxDate!==null&&settings.dateFormat!==undefined&&settings.maxDate===undefined){inst.settings.maxDate=this._formatDate(inst,maxDate);}if("disabled"in settings){if(settings.disabled){this._disableDatepicker(target);}else {this._enableDatepicker(target);}}this._attachments($(target),inst);this._autoSize(inst);this._setDate(inst,date);this._updateAlternate(inst);this._updateDatepicker(inst);}},// Change method deprecated
	_changeDatepicker:function(target,name,value){this._optionDatepicker(target,name,value);},/* Redraw the date picker attached to an input field or division.
		 * @param  target  element - the target input field or division or span
		 */_refreshDatepicker:function(target){var inst=this._getInst(target);if(inst){this._updateDatepicker(inst);}},/* Set the dates for a jQuery selection.
		 * @param  target element - the target input field or division or span
		 * @param  date	Date - the new date
		 */_setDateDatepicker:function(target,date){var inst=this._getInst(target);if(inst){this._setDate(inst,date);this._updateDatepicker(inst);this._updateAlternate(inst);}},/* Get the date(s) for the first entry in a jQuery selection.
		 * @param  target element - the target input field or division or span
		 * @param  noDefault boolean - true if no default date is to be used
		 * @return Date - the current date
		 */_getDateDatepicker:function(target,noDefault){var inst=this._getInst(target);if(inst&&!inst.inline){this._setDateFromField(inst,noDefault);}return inst?this._getDate(inst):null;},/* Handle keystrokes. */_doKeyDown:function(event){var onSelect,dateStr,sel,inst=$.datepicker._getInst(event.target),handled=true,isRTL=inst.dpDiv.is(".ui-datepicker-rtl");inst._keyEvent=true;if($.datepicker._datepickerShowing){switch(event.keyCode){case 9:$.datepicker._hideDatepicker();handled=false;break;// hide on tab out
	case 13:sel=$("td."+$.datepicker._dayOverClass+":not(."+$.datepicker._currentClass+")",inst.dpDiv);if(sel[0]){$.datepicker._selectDay(event.target,inst.selectedMonth,inst.selectedYear,sel[0]);}onSelect=$.datepicker._get(inst,"onSelect");if(onSelect){dateStr=$.datepicker._formatDate(inst);// Trigger custom callback
	onSelect.apply(inst.input?inst.input[0]:null,[dateStr,inst]);}else {$.datepicker._hideDatepicker();}return false;// don't submit the form
	case 27:$.datepicker._hideDatepicker();break;// hide on escape
	case 33:$.datepicker._adjustDate(event.target,event.ctrlKey?-$.datepicker._get(inst,"stepBigMonths"):-$.datepicker._get(inst,"stepMonths"),"M");break;// previous month/year on page up/+ ctrl
	case 34:$.datepicker._adjustDate(event.target,event.ctrlKey?+$.datepicker._get(inst,"stepBigMonths"):+$.datepicker._get(inst,"stepMonths"),"M");break;// next month/year on page down/+ ctrl
	case 35:if(event.ctrlKey||event.metaKey){$.datepicker._clearDate(event.target);}handled=event.ctrlKey||event.metaKey;break;// clear on ctrl or command +end
	case 36:if(event.ctrlKey||event.metaKey){$.datepicker._gotoToday(event.target);}handled=event.ctrlKey||event.metaKey;break;// current on ctrl or command +home
	case 37:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,isRTL?+1:-1,"D");}handled=event.ctrlKey||event.metaKey;// -1 day on ctrl or command +left
	if(event.originalEvent.altKey){$.datepicker._adjustDate(event.target,event.ctrlKey?-$.datepicker._get(inst,"stepBigMonths"):-$.datepicker._get(inst,"stepMonths"),"M");}// next month/year on alt +left on Mac
	break;case 38:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,-7,"D");}handled=event.ctrlKey||event.metaKey;break;// -1 week on ctrl or command +up
	case 39:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,isRTL?-1:+1,"D");}handled=event.ctrlKey||event.metaKey;// +1 day on ctrl or command +right
	if(event.originalEvent.altKey){$.datepicker._adjustDate(event.target,event.ctrlKey?+$.datepicker._get(inst,"stepBigMonths"):+$.datepicker._get(inst,"stepMonths"),"M");}// next month/year on alt +right
	break;case 40:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,+7,"D");}handled=event.ctrlKey||event.metaKey;break;// +1 week on ctrl or command +down
	default:handled=false;}}else if(event.keyCode===36&&event.ctrlKey){// display the date picker on ctrl+home
	$.datepicker._showDatepicker(this);}else {handled=false;}if(handled){event.preventDefault();event.stopPropagation();}},/* Filter entered characters - based on date format. */_doKeyPress:function(event){var chars,chr,inst=$.datepicker._getInst(event.target);if($.datepicker._get(inst,"constrainInput")){chars=$.datepicker._possibleChars($.datepicker._get(inst,"dateFormat"));chr=String.fromCharCode(event.charCode==null?event.keyCode:event.charCode);return event.ctrlKey||event.metaKey||chr<" "||!chars||chars.indexOf(chr)>-1;}},/* Synchronise manual entry and field/alternate field. */_doKeyUp:function(event){var date,inst=$.datepicker._getInst(event.target);if(inst.input.val()!==inst.lastVal){try{date=$.datepicker.parseDate($.datepicker._get(inst,"dateFormat"),inst.input?inst.input.val():null,$.datepicker._getFormatConfig(inst));if(date){// only if valid
	$.datepicker._setDateFromField(inst);$.datepicker._updateAlternate(inst);$.datepicker._updateDatepicker(inst);}}catch(err){}}return true;},/* Pop-up the date picker for a given input field.
		 * If false returned from beforeShow event handler do not show.
		 * @param  input  element - the input field attached to the date picker or
		 *					event - if triggered by focus
		 */_showDatepicker:function(input){input=input.target||input;if(input.nodeName.toLowerCase()!=="input"){// find from button/image trigger
	input=$("input",input.parentNode)[0];}if($.datepicker._isDisabledDatepicker(input)||$.datepicker._lastInput===input){// already here
	return;}var inst,beforeShow,beforeShowSettings,isFixed,offset,showAnim,duration;inst=$.datepicker._getInst(input);if($.datepicker._curInst&&$.datepicker._curInst!==inst){$.datepicker._curInst.dpDiv.stop(true,true);if(inst&&$.datepicker._datepickerShowing){$.datepicker._hideDatepicker($.datepicker._curInst.input[0]);}}beforeShow=$.datepicker._get(inst,"beforeShow");beforeShowSettings=beforeShow?beforeShow.apply(input,[input,inst]):{};if(beforeShowSettings===false){return;}datepicker_extendRemove(inst.settings,beforeShowSettings);inst.lastVal=null;$.datepicker._lastInput=input;$.datepicker._setDateFromField(inst);if($.datepicker._inDialog){// hide cursor
	input.value="";}if(!$.datepicker._pos){// position below input
	$.datepicker._pos=$.datepicker._findPos(input);$.datepicker._pos[1]+=input.offsetHeight;// add the height
	}isFixed=false;$(input).parents().each(function(){isFixed|=$(this).css("position")==="fixed";return !isFixed;});offset={left:$.datepicker._pos[0],top:$.datepicker._pos[1]};$.datepicker._pos=null;//to avoid flashes on Firefox
	inst.dpDiv.empty();// determine sizing offscreen
	inst.dpDiv.css({position:"absolute",display:"block",top:"-1000px"});$.datepicker._updateDatepicker(inst);// fix width for dynamic number of date pickers
	// and adjust position before showing
	offset=$.datepicker._checkOffset(inst,offset,isFixed);inst.dpDiv.css({position:$.datepicker._inDialog&&$.blockUI?"static":isFixed?"fixed":"absolute",display:"none",left:offset.left+"px",top:offset.top+"px"});if(!inst.inline){showAnim=$.datepicker._get(inst,"showAnim");duration=$.datepicker._get(inst,"duration");inst.dpDiv.css("z-index",datepicker_getZindex($(input))+1);$.datepicker._datepickerShowing=true;if($.effects&&$.effects.effect[showAnim]){inst.dpDiv.show(showAnim,$.datepicker._get(inst,"showOptions"),duration);}else {inst.dpDiv[showAnim||"show"](showAnim?duration:null);}if($.datepicker._shouldFocusInput(inst)){inst.input.trigger("focus");}$.datepicker._curInst=inst;}},/* Generate the date picker content. */_updateDatepicker:function(inst){this.maxRows=4;//Reset the max number of rows being displayed (see #7043)
	datepicker_instActive=inst;// for delegate hover events
	inst.dpDiv.empty().append(this._generateHTML(inst));this._attachHandlers(inst);var origyearshtml,numMonths=this._getNumberOfMonths(inst),cols=numMonths[1],width=17,activeCell=inst.dpDiv.find("."+this._dayOverClass+" a"),onUpdateDatepicker=$.datepicker._get(inst,"onUpdateDatepicker");if(activeCell.length>0){datepicker_handleMouseover.apply(activeCell.get(0));}inst.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width("");if(cols>1){inst.dpDiv.addClass("ui-datepicker-multi-"+cols).css("width",width*cols+"em");}inst.dpDiv[(numMonths[0]!==1||numMonths[1]!==1?"add":"remove")+"Class"]("ui-datepicker-multi");inst.dpDiv[(this._get(inst,"isRTL")?"add":"remove")+"Class"]("ui-datepicker-rtl");if(inst===$.datepicker._curInst&&$.datepicker._datepickerShowing&&$.datepicker._shouldFocusInput(inst)){inst.input.trigger("focus");}// Deffered render of the years select (to avoid flashes on Firefox)
	if(inst.yearshtml){origyearshtml=inst.yearshtml;setTimeout(function(){//assure that inst.yearshtml didn't change.
	if(origyearshtml===inst.yearshtml&&inst.yearshtml){inst.dpDiv.find("select.ui-datepicker-year").first().replaceWith(inst.yearshtml);}origyearshtml=inst.yearshtml=null;},0);}if(onUpdateDatepicker){onUpdateDatepicker.apply(inst.input?inst.input[0]:null,[inst]);}},// #6694 - don't focus the input if it's already focused
	// this breaks the change event in IE
	// Support: IE and jQuery <1.9
	_shouldFocusInput:function(inst){return inst.input&&inst.input.is(":visible")&&!inst.input.is(":disabled")&&!inst.input.is(":focus");},/* Check positioning to remain on screen. */_checkOffset:function(inst,offset,isFixed){var dpWidth=inst.dpDiv.outerWidth(),dpHeight=inst.dpDiv.outerHeight(),inputWidth=inst.input?inst.input.outerWidth():0,inputHeight=inst.input?inst.input.outerHeight():0,viewWidth=document.documentElement.clientWidth+(isFixed?0:$(document).scrollLeft()),viewHeight=document.documentElement.clientHeight+(isFixed?0:$(document).scrollTop());offset.left-=this._get(inst,"isRTL")?dpWidth-inputWidth:0;offset.left-=isFixed&&offset.left===inst.input.offset().left?$(document).scrollLeft():0;offset.top-=isFixed&&offset.top===inst.input.offset().top+inputHeight?$(document).scrollTop():0;// Now check if datepicker is showing outside window viewport - move to a better place if so.
	offset.left-=Math.min(offset.left,offset.left+dpWidth>viewWidth&&viewWidth>dpWidth?Math.abs(offset.left+dpWidth-viewWidth):0);offset.top-=Math.min(offset.top,offset.top+dpHeight>viewHeight&&viewHeight>dpHeight?Math.abs(dpHeight+inputHeight):0);return offset;},/* Find an object's position on the screen. */_findPos:function(obj){var position,inst=this._getInst(obj),isRTL=this._get(inst,"isRTL");while(obj&&(obj.type==="hidden"||obj.nodeType!==1||$.expr.pseudos.hidden(obj))){obj=obj[isRTL?"previousSibling":"nextSibling"];}position=$(obj).offset();return [position.left,position.top];},/* Hide the date picker from view.
		 * @param  input  element - the input field attached to the date picker
		 */_hideDatepicker:function(input){var showAnim,duration,postProcess,onClose,inst=this._curInst;if(!inst||input&&inst!==$.data(input,"datepicker")){return;}if(this._datepickerShowing){showAnim=this._get(inst,"showAnim");duration=this._get(inst,"duration");postProcess=function(){$.datepicker._tidyDialog(inst);};// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed
	if($.effects&&($.effects.effect[showAnim]||$.effects[showAnim])){inst.dpDiv.hide(showAnim,$.datepicker._get(inst,"showOptions"),duration,postProcess);}else {inst.dpDiv[showAnim==="slideDown"?"slideUp":showAnim==="fadeIn"?"fadeOut":"hide"](showAnim?duration:null,postProcess);}if(!showAnim){postProcess();}this._datepickerShowing=false;onClose=this._get(inst,"onClose");if(onClose){onClose.apply(inst.input?inst.input[0]:null,[inst.input?inst.input.val():"",inst]);}this._lastInput=null;if(this._inDialog){this._dialogInput.css({position:"absolute",left:"0",top:"-100px"});if($.blockUI){$.unblockUI();$("body").append(this.dpDiv);}}this._inDialog=false;}},/* Tidy up after a dialog display. */_tidyDialog:function(inst){inst.dpDiv.removeClass(this._dialogClass).off(".ui-datepicker-calendar");},/* Close date picker if clicked elsewhere. */_checkExternalClick:function(event){if(!$.datepicker._curInst){return;}var $target=$(event.target),inst=$.datepicker._getInst($target[0]);if($target[0].id!==$.datepicker._mainDivId&&$target.parents("#"+$.datepicker._mainDivId).length===0&&!$target.hasClass($.datepicker.markerClassName)&&!$target.closest("."+$.datepicker._triggerClass).length&&$.datepicker._datepickerShowing&&!($.datepicker._inDialog&&$.blockUI)||$target.hasClass($.datepicker.markerClassName)&&$.datepicker._curInst!==inst){$.datepicker._hideDatepicker();}},/* Adjust one of the date sub-fields. */_adjustDate:function(id,offset,period){var target=$(id),inst=this._getInst(target[0]);if(this._isDisabledDatepicker(target[0])){return;}this._adjustInstDate(inst,offset,period);this._updateDatepicker(inst);},/* Action for current link. */_gotoToday:function(id){var date,target=$(id),inst=this._getInst(target[0]);if(this._get(inst,"gotoCurrent")&&inst.currentDay){inst.selectedDay=inst.currentDay;inst.drawMonth=inst.selectedMonth=inst.currentMonth;inst.drawYear=inst.selectedYear=inst.currentYear;}else {date=new Date();inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();}this._notifyChange(inst);this._adjustDate(target);},/* Action for selecting a new month/year. */_selectMonthYear:function(id,select,period){var target=$(id),inst=this._getInst(target[0]);inst["selected"+(period==="M"?"Month":"Year")]=inst["draw"+(period==="M"?"Month":"Year")]=parseInt(select.options[select.selectedIndex].value,10);this._notifyChange(inst);this._adjustDate(target);},/* Action for selecting a day. */_selectDay:function(id,month,year,td){var inst,target=$(id);if($(td).hasClass(this._unselectableClass)||this._isDisabledDatepicker(target[0])){return;}inst=this._getInst(target[0]);inst.selectedDay=inst.currentDay=parseInt($("a",td).attr("data-date"));inst.selectedMonth=inst.currentMonth=month;inst.selectedYear=inst.currentYear=year;this._selectDate(id,this._formatDate(inst,inst.currentDay,inst.currentMonth,inst.currentYear));},/* Erase the input field and hide the date picker. */_clearDate:function(id){var target=$(id);this._selectDate(target,"");},/* Update the input field with the selected date. */_selectDate:function(id,dateStr){var onSelect,target=$(id),inst=this._getInst(target[0]);dateStr=dateStr!=null?dateStr:this._formatDate(inst);if(inst.input){inst.input.val(dateStr);}this._updateAlternate(inst);onSelect=this._get(inst,"onSelect");if(onSelect){onSelect.apply(inst.input?inst.input[0]:null,[dateStr,inst]);// trigger custom callback
	}else if(inst.input){inst.input.trigger("change");// fire the change event
	}if(inst.inline){this._updateDatepicker(inst);}else {this._hideDatepicker();this._lastInput=inst.input[0];if(typeof inst.input[0]!=="object"){inst.input.trigger("focus");// restore focus
	}this._lastInput=null;}},/* Update any alternate field to synchronise with the main field. */_updateAlternate:function(inst){var altFormat,date,dateStr,altField=this._get(inst,"altField");if(altField){// update alternate field too
	altFormat=this._get(inst,"altFormat")||this._get(inst,"dateFormat");date=this._getDate(inst);dateStr=this.formatDate(altFormat,date,this._getFormatConfig(inst));$(document).find(altField).val(dateStr);}},/* Set as beforeShowDay function to prevent selection of weekends.
		 * @param  date  Date - the date to customise
		 * @return [boolean, string] - is this date selectable?, what is its CSS class?
		 */noWeekends:function(date){var day=date.getDay();return [day>0&&day<6,""];},/* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.
		 * @param  date  Date - the date to get the week for
		 * @return  number - the number of the week within the year that contains this date
		 */iso8601Week:function(date){var time,checkDate=new Date(date.getTime());// Find Thursday of this week starting on Monday
	checkDate.setDate(checkDate.getDate()+4-(checkDate.getDay()||7));time=checkDate.getTime();checkDate.setMonth(0);// Compare with Jan 1
	checkDate.setDate(1);return Math.floor(Math.round((time-checkDate)/86400000)/7)+1;},/* Parse a string value into a date object.
		 * See formatDate below for the possible formats.
		 *
		 * @param  format string - the expected format of the date
		 * @param  value string - the date in the above format
		 * @param  settings Object - attributes include:
		 *					shortYearCutoff  number - the cutoff year for determining the century (optional)
		 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
		 *					dayNames		string[7] - names of the days from Sunday (optional)
		 *					monthNamesShort string[12] - abbreviated names of the months (optional)
		 *					monthNames		string[12] - names of the months (optional)
		 * @return  Date - the extracted date value or null if value is blank
		 */parseDate:function(format,value,settings){if(format==null||value==null){throw "Invalid arguments";}value=typeof value==="object"?value.toString():value+"";if(value===""){return null;}var iFormat,dim,extra,iValue=0,shortYearCutoffTemp=(settings?settings.shortYearCutoff:null)||this._defaults.shortYearCutoff,shortYearCutoff=typeof shortYearCutoffTemp!=="string"?shortYearCutoffTemp:new Date().getFullYear()%100+parseInt(shortYearCutoffTemp,10),dayNamesShort=(settings?settings.dayNamesShort:null)||this._defaults.dayNamesShort,dayNames=(settings?settings.dayNames:null)||this._defaults.dayNames,monthNamesShort=(settings?settings.monthNamesShort:null)||this._defaults.monthNamesShort,monthNames=(settings?settings.monthNames:null)||this._defaults.monthNames,year=-1,month=-1,day=-1,doy=-1,literal=false,date,// Check whether a format character is doubled
	lookAhead=function(match){var matches=iFormat+1<format.length&&format.charAt(iFormat+1)===match;if(matches){iFormat++;}return matches;},// Extract a number from the string value
	getNumber=function(match){var isDoubled=lookAhead(match),size=match==="@"?14:match==="!"?20:match==="y"&&isDoubled?4:match==="o"?3:2,minSize=match==="y"?size:1,digits=new RegExp("^\\d{"+minSize+","+size+"}"),num=value.substring(iValue).match(digits);if(!num){throw "Missing number at position "+iValue;}iValue+=num[0].length;return parseInt(num[0],10);},// Extract a name from the string value and convert to an index
	getName=function(match,shortNames,longNames){var index=-1,names=$.map(lookAhead(match)?longNames:shortNames,function(v,k){return [[k,v]];}).sort(function(a,b){return -(a[1].length-b[1].length);});$.each(names,function(i,pair){var name=pair[1];if(value.substr(iValue,name.length).toLowerCase()===name.toLowerCase()){index=pair[0];iValue+=name.length;return false;}});if(index!==-1){return index+1;}else {throw "Unknown name at position "+iValue;}},// Confirm that a literal character matches the string value
	checkLiteral=function(){if(value.charAt(iValue)!==format.charAt(iFormat)){throw "Unexpected literal at position "+iValue;}iValue++;};for(iFormat=0;iFormat<format.length;iFormat++){if(literal){if(format.charAt(iFormat)==="'"&&!lookAhead("'")){literal=false;}else {checkLiteral();}}else {switch(format.charAt(iFormat)){case"d":day=getNumber("d");break;case"D":getName("D",dayNamesShort,dayNames);break;case"o":doy=getNumber("o");break;case"m":month=getNumber("m");break;case"M":month=getName("M",monthNamesShort,monthNames);break;case"y":year=getNumber("y");break;case"@":date=new Date(getNumber("@"));year=date.getFullYear();month=date.getMonth()+1;day=date.getDate();break;case"!":date=new Date((getNumber("!")-this._ticksTo1970)/10000);year=date.getFullYear();month=date.getMonth()+1;day=date.getDate();break;case"'":if(lookAhead("'")){checkLiteral();}else {literal=true;}break;default:checkLiteral();}}}if(iValue<value.length){extra=value.substr(iValue);if(!/^\s+/.test(extra)){throw "Extra/unparsed characters found in date: "+extra;}}if(year===-1){year=new Date().getFullYear();}else if(year<100){year+=new Date().getFullYear()-new Date().getFullYear()%100+(year<=shortYearCutoff?0:-100);}if(doy>-1){month=1;day=doy;do{dim=this._getDaysInMonth(year,month-1);if(day<=dim){break;}month++;day-=dim;}while(true);}date=this._daylightSavingAdjust(new Date(year,month-1,day));if(date.getFullYear()!==year||date.getMonth()+1!==month||date.getDate()!==day){throw "Invalid date";// E.g. 31/02/00
	}return date;},/* Standard date formats. */ATOM:"yy-mm-dd",// RFC 3339 (ISO 8601)
	COOKIE:"D, dd M yy",ISO_8601:"yy-mm-dd",RFC_822:"D, d M y",RFC_850:"DD, dd-M-y",RFC_1036:"D, d M y",RFC_1123:"D, d M yy",RFC_2822:"D, d M yy",RSS:"D, d M y",// RFC 822
	TICKS:"!",TIMESTAMP:"@",W3C:"yy-mm-dd",// ISO 8601
	_ticksTo1970:((1970-1)*365+Math.floor(1970/4)-Math.floor(1970/100)+Math.floor(1970/400))*24*60*60*10000000,/* Format a date object into a string value.
		 * The format can be combinations of the following:
		 * d  - day of month (no leading zero)
		 * dd - day of month (two digit)
		 * o  - day of year (no leading zeros)
		 * oo - day of year (three digit)
		 * D  - day name short
		 * DD - day name long
		 * m  - month of year (no leading zero)
		 * mm - month of year (two digit)
		 * M  - month name short
		 * MM - month name long
		 * y  - year (two digit)
		 * yy - year (four digit)
		 * @ - Unix timestamp (ms since 01/01/1970)
		 * ! - Windows ticks (100ns since 01/01/0001)
		 * "..." - literal text
		 * '' - single quote
		 *
		 * @param  format string - the desired format of the date
		 * @param  date Date - the date value to format
		 * @param  settings Object - attributes include:
		 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
		 *					dayNames		string[7] - names of the days from Sunday (optional)
		 *					monthNamesShort string[12] - abbreviated names of the months (optional)
		 *					monthNames		string[12] - names of the months (optional)
		 * @return  string - the date in the above format
		 */formatDate:function(format,date,settings){if(!date){return "";}var iFormat,dayNamesShort=(settings?settings.dayNamesShort:null)||this._defaults.dayNamesShort,dayNames=(settings?settings.dayNames:null)||this._defaults.dayNames,monthNamesShort=(settings?settings.monthNamesShort:null)||this._defaults.monthNamesShort,monthNames=(settings?settings.monthNames:null)||this._defaults.monthNames,// Check whether a format character is doubled
	lookAhead=function(match){var matches=iFormat+1<format.length&&format.charAt(iFormat+1)===match;if(matches){iFormat++;}return matches;},// Format a number, with leading zero if necessary
	formatNumber=function(match,value,len){var num=""+value;if(lookAhead(match)){while(num.length<len){num="0"+num;}}return num;},// Format a name, short or long as requested
	formatName=function(match,value,shortNames,longNames){return lookAhead(match)?longNames[value]:shortNames[value];},output="",literal=false;if(date){for(iFormat=0;iFormat<format.length;iFormat++){if(literal){if(format.charAt(iFormat)==="'"&&!lookAhead("'")){literal=false;}else {output+=format.charAt(iFormat);}}else {switch(format.charAt(iFormat)){case"d":output+=formatNumber("d",date.getDate(),2);break;case"D":output+=formatName("D",date.getDay(),dayNamesShort,dayNames);break;case"o":output+=formatNumber("o",Math.round((new Date(date.getFullYear(),date.getMonth(),date.getDate()).getTime()-new Date(date.getFullYear(),0,0).getTime())/86400000),3);break;case"m":output+=formatNumber("m",date.getMonth()+1,2);break;case"M":output+=formatName("M",date.getMonth(),monthNamesShort,monthNames);break;case"y":output+=lookAhead("y")?date.getFullYear():(date.getFullYear()%100<10?"0":"")+date.getFullYear()%100;break;case"@":output+=date.getTime();break;case"!":output+=date.getTime()*10000+this._ticksTo1970;break;case"'":if(lookAhead("'")){output+="'";}else {literal=true;}break;default:output+=format.charAt(iFormat);}}}}return output;},/* Extract all possible characters from the date format. */_possibleChars:function(format){var iFormat,chars="",literal=false,// Check whether a format character is doubled
	lookAhead=function(match){var matches=iFormat+1<format.length&&format.charAt(iFormat+1)===match;if(matches){iFormat++;}return matches;};for(iFormat=0;iFormat<format.length;iFormat++){if(literal){if(format.charAt(iFormat)==="'"&&!lookAhead("'")){literal=false;}else {chars+=format.charAt(iFormat);}}else {switch(format.charAt(iFormat)){case"d":case"m":case"y":case"@":chars+="0123456789";break;case"D":case"M":return null;// Accept anything
	case"'":if(lookAhead("'")){chars+="'";}else {literal=true;}break;default:chars+=format.charAt(iFormat);}}}return chars;},/* Get a setting value, defaulting if necessary. */_get:function(inst,name){return inst.settings[name]!==undefined?inst.settings[name]:this._defaults[name];},/* Parse existing date and initialise date picker. */_setDateFromField:function(inst,noDefault){if(inst.input.val()===inst.lastVal){return;}var dateFormat=this._get(inst,"dateFormat"),dates=inst.lastVal=inst.input?inst.input.val():null,defaultDate=this._getDefaultDate(inst),date=defaultDate,settings=this._getFormatConfig(inst);try{date=this.parseDate(dateFormat,dates,settings)||defaultDate;}catch(event){dates=noDefault?"":dates;}inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();inst.currentDay=dates?date.getDate():0;inst.currentMonth=dates?date.getMonth():0;inst.currentYear=dates?date.getFullYear():0;this._adjustInstDate(inst);},/* Retrieve the default date shown on opening. */_getDefaultDate:function(inst){return this._restrictMinMax(inst,this._determineDate(inst,this._get(inst,"defaultDate"),new Date()));},/* A date may be specified as an exact value or a relative one. */_determineDate:function(inst,date,defaultDate){var offsetNumeric=function(offset){var date=new Date();date.setDate(date.getDate()+offset);return date;},offsetString=function(offset){try{return $.datepicker.parseDate($.datepicker._get(inst,"dateFormat"),offset,$.datepicker._getFormatConfig(inst));}catch(e){// Ignore
	}var date=(offset.toLowerCase().match(/^c/)?$.datepicker._getDate(inst):null)||new Date(),year=date.getFullYear(),month=date.getMonth(),day=date.getDate(),pattern=/([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,matches=pattern.exec(offset);while(matches){switch(matches[2]||"d"){case"d":case"D":day+=parseInt(matches[1],10);break;case"w":case"W":day+=parseInt(matches[1],10)*7;break;case"m":case"M":month+=parseInt(matches[1],10);day=Math.min(day,$.datepicker._getDaysInMonth(year,month));break;case"y":case"Y":year+=parseInt(matches[1],10);day=Math.min(day,$.datepicker._getDaysInMonth(year,month));break;}matches=pattern.exec(offset);}return new Date(year,month,day);},newDate=date==null||date===""?defaultDate:typeof date==="string"?offsetString(date):typeof date==="number"?isNaN(date)?defaultDate:offsetNumeric(date):new Date(date.getTime());newDate=newDate&&newDate.toString()==="Invalid Date"?defaultDate:newDate;if(newDate){newDate.setHours(0);newDate.setMinutes(0);newDate.setSeconds(0);newDate.setMilliseconds(0);}return this._daylightSavingAdjust(newDate);},/* Handle switch to/from daylight saving.
		 * Hours may be non-zero on daylight saving cut-over:
		 * > 12 when midnight changeover, but then cannot generate
		 * midnight datetime, so jump to 1AM, otherwise reset.
		 * @param  date  (Date) the date to check
		 * @return  (Date) the corrected date
		 */_daylightSavingAdjust:function(date){if(!date){return null;}date.setHours(date.getHours()>12?date.getHours()+2:0);return date;},/* Set the date(s) directly. */_setDate:function(inst,date,noChange){var clear=!date,origMonth=inst.selectedMonth,origYear=inst.selectedYear,newDate=this._restrictMinMax(inst,this._determineDate(inst,date,new Date()));inst.selectedDay=inst.currentDay=newDate.getDate();inst.drawMonth=inst.selectedMonth=inst.currentMonth=newDate.getMonth();inst.drawYear=inst.selectedYear=inst.currentYear=newDate.getFullYear();if((origMonth!==inst.selectedMonth||origYear!==inst.selectedYear)&&!noChange){this._notifyChange(inst);}this._adjustInstDate(inst);if(inst.input){inst.input.val(clear?"":this._formatDate(inst));}},/* Retrieve the date(s) directly. */_getDate:function(inst){var startDate=!inst.currentYear||inst.input&&inst.input.val()===""?null:this._daylightSavingAdjust(new Date(inst.currentYear,inst.currentMonth,inst.currentDay));return startDate;},/* Attach the onxxx handlers.  These are declared statically so
		 * they work with static code transformers like Caja.
		 */_attachHandlers:function(inst){var stepMonths=this._get(inst,"stepMonths"),id="#"+inst.id.replace(/\\\\/g,"\\");inst.dpDiv.find("[data-handler]").map(function(){var handler={prev:function(){$.datepicker._adjustDate(id,-stepMonths,"M");},next:function(){$.datepicker._adjustDate(id,+stepMonths,"M");},hide:function(){$.datepicker._hideDatepicker();},today:function(){$.datepicker._gotoToday(id);},selectDay:function(){$.datepicker._selectDay(id,+this.getAttribute("data-month"),+this.getAttribute("data-year"),this);return false;},selectMonth:function(){$.datepicker._selectMonthYear(id,this,"M");return false;},selectYear:function(){$.datepicker._selectMonthYear(id,this,"Y");return false;}};$(this).on(this.getAttribute("data-event"),handler[this.getAttribute("data-handler")]);});},/* Generate the HTML for the current state of the date picker. */_generateHTML:function(inst){var maxDraw,prevText,prev,nextText,next,currentText,gotoDate,controls,buttonPanel,firstDay,showWeek,dayNames,dayNamesMin,monthNames,monthNamesShort,beforeShowDay,showOtherMonths,selectOtherMonths,defaultDate,html,dow,row,group,col,selectedDate,cornerClass,calender,thead,day,daysInMonth,leadDays,curRows,numRows,printDate,dRow,tbody,daySettings,otherMonth,unselectable,tempDate=new Date(),today=this._daylightSavingAdjust(new Date(tempDate.getFullYear(),tempDate.getMonth(),tempDate.getDate())),// clear time
	isRTL=this._get(inst,"isRTL"),showButtonPanel=this._get(inst,"showButtonPanel"),hideIfNoPrevNext=this._get(inst,"hideIfNoPrevNext"),navigationAsDateFormat=this._get(inst,"navigationAsDateFormat"),numMonths=this._getNumberOfMonths(inst),showCurrentAtPos=this._get(inst,"showCurrentAtPos"),stepMonths=this._get(inst,"stepMonths"),isMultiMonth=numMonths[0]!==1||numMonths[1]!==1,currentDate=this._daylightSavingAdjust(!inst.currentDay?new Date(9999,9,9):new Date(inst.currentYear,inst.currentMonth,inst.currentDay)),minDate=this._getMinMaxDate(inst,"min"),maxDate=this._getMinMaxDate(inst,"max"),drawMonth=inst.drawMonth-showCurrentAtPos,drawYear=inst.drawYear;if(drawMonth<0){drawMonth+=12;drawYear--;}if(maxDate){maxDraw=this._daylightSavingAdjust(new Date(maxDate.getFullYear(),maxDate.getMonth()-numMonths[0]*numMonths[1]+1,maxDate.getDate()));maxDraw=minDate&&maxDraw<minDate?minDate:maxDraw;while(this._daylightSavingAdjust(new Date(drawYear,drawMonth,1))>maxDraw){drawMonth--;if(drawMonth<0){drawMonth=11;drawYear--;}}}inst.drawMonth=drawMonth;inst.drawYear=drawYear;prevText=this._get(inst,"prevText");prevText=!navigationAsDateFormat?prevText:this.formatDate(prevText,this._daylightSavingAdjust(new Date(drawYear,drawMonth-stepMonths,1)),this._getFormatConfig(inst));if(this._canAdjustMonth(inst,-1,drawYear,drawMonth)){prev=$("<a>").attr({"class":"ui-datepicker-prev ui-corner-all","data-handler":"prev","data-event":"click",title:prevText}).append($("<span>").addClass("ui-icon ui-icon-circle-triangle-"+(isRTL?"e":"w")).text(prevText))[0].outerHTML;}else if(hideIfNoPrevNext){prev="";}else {prev=$("<a>").attr({"class":"ui-datepicker-prev ui-corner-all ui-state-disabled",title:prevText}).append($("<span>").addClass("ui-icon ui-icon-circle-triangle-"+(isRTL?"e":"w")).text(prevText))[0].outerHTML;}nextText=this._get(inst,"nextText");nextText=!navigationAsDateFormat?nextText:this.formatDate(nextText,this._daylightSavingAdjust(new Date(drawYear,drawMonth+stepMonths,1)),this._getFormatConfig(inst));if(this._canAdjustMonth(inst,+1,drawYear,drawMonth)){next=$("<a>").attr({"class":"ui-datepicker-next ui-corner-all","data-handler":"next","data-event":"click",title:nextText}).append($("<span>").addClass("ui-icon ui-icon-circle-triangle-"+(isRTL?"w":"e")).text(nextText))[0].outerHTML;}else if(hideIfNoPrevNext){next="";}else {next=$("<a>").attr({"class":"ui-datepicker-next ui-corner-all ui-state-disabled",title:nextText}).append($("<span>").attr("class","ui-icon ui-icon-circle-triangle-"+(isRTL?"w":"e")).text(nextText))[0].outerHTML;}currentText=this._get(inst,"currentText");gotoDate=this._get(inst,"gotoCurrent")&&inst.currentDay?currentDate:today;currentText=!navigationAsDateFormat?currentText:this.formatDate(currentText,gotoDate,this._getFormatConfig(inst));controls="";if(!inst.inline){controls=$("<button>").attr({type:"button","class":"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all","data-handler":"hide","data-event":"click"}).text(this._get(inst,"closeText"))[0].outerHTML;}buttonPanel="";if(showButtonPanel){buttonPanel=$("<div class='ui-datepicker-buttonpane ui-widget-content'>").append(isRTL?controls:"").append(this._isInRange(inst,gotoDate)?$("<button>").attr({type:"button","class":"ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all","data-handler":"today","data-event":"click"}).text(currentText):"").append(isRTL?"":controls)[0].outerHTML;}firstDay=parseInt(this._get(inst,"firstDay"),10);firstDay=isNaN(firstDay)?0:firstDay;showWeek=this._get(inst,"showWeek");dayNames=this._get(inst,"dayNames");dayNamesMin=this._get(inst,"dayNamesMin");monthNames=this._get(inst,"monthNames");monthNamesShort=this._get(inst,"monthNamesShort");beforeShowDay=this._get(inst,"beforeShowDay");showOtherMonths=this._get(inst,"showOtherMonths");selectOtherMonths=this._get(inst,"selectOtherMonths");defaultDate=this._getDefaultDate(inst);html="";for(row=0;row<numMonths[0];row++){group="";this.maxRows=4;for(col=0;col<numMonths[1];col++){selectedDate=this._daylightSavingAdjust(new Date(drawYear,drawMonth,inst.selectedDay));cornerClass=" ui-corner-all";calender="";if(isMultiMonth){calender+="<div class='ui-datepicker-group";if(numMonths[1]>1){switch(col){case 0:calender+=" ui-datepicker-group-first";cornerClass=" ui-corner-"+(isRTL?"right":"left");break;case numMonths[1]-1:calender+=" ui-datepicker-group-last";cornerClass=" ui-corner-"+(isRTL?"left":"right");break;default:calender+=" ui-datepicker-group-middle";cornerClass="";break;}}calender+="'>";}calender+="<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix"+cornerClass+"'>"+(/all|left/.test(cornerClass)&&row===0?isRTL?next:prev:"")+(/all|right/.test(cornerClass)&&row===0?isRTL?prev:next:"")+this._generateMonthYearHeader(inst,drawMonth,drawYear,minDate,maxDate,row>0||col>0,monthNames,monthNamesShort)+// draw month headers
	"</div><table class='ui-datepicker-calendar'><thead>"+"<tr>";thead=showWeek?"<th class='ui-datepicker-week-col'>"+this._get(inst,"weekHeader")+"</th>":"";for(dow=0;dow<7;dow++){// days of the week
	day=(dow+firstDay)%7;thead+="<th scope='col'"+((dow+firstDay+6)%7>=5?" class='ui-datepicker-week-end'":"")+">"+"<span title='"+dayNames[day]+"'>"+dayNamesMin[day]+"</span></th>";}calender+=thead+"</tr></thead><tbody>";daysInMonth=this._getDaysInMonth(drawYear,drawMonth);if(drawYear===inst.selectedYear&&drawMonth===inst.selectedMonth){inst.selectedDay=Math.min(inst.selectedDay,daysInMonth);}leadDays=(this._getFirstDayOfMonth(drawYear,drawMonth)-firstDay+7)%7;curRows=Math.ceil((leadDays+daysInMonth)/7);// calculate the number of rows to generate
	numRows=isMultiMonth?this.maxRows>curRows?this.maxRows:curRows:curRows;//If multiple months, use the higher number of rows (see #7043)
	this.maxRows=numRows;printDate=this._daylightSavingAdjust(new Date(drawYear,drawMonth,1-leadDays));for(dRow=0;dRow<numRows;dRow++){// create date picker rows
	calender+="<tr>";tbody=!showWeek?"":"<td class='ui-datepicker-week-col'>"+this._get(inst,"calculateWeek")(printDate)+"</td>";for(dow=0;dow<7;dow++){// create date picker days
	daySettings=beforeShowDay?beforeShowDay.apply(inst.input?inst.input[0]:null,[printDate]):[true,""];otherMonth=printDate.getMonth()!==drawMonth;unselectable=otherMonth&&!selectOtherMonths||!daySettings[0]||minDate&&printDate<minDate||maxDate&&printDate>maxDate;tbody+="<td class='"+((dow+firstDay+6)%7>=5?" ui-datepicker-week-end":"")+(// highlight weekends
	otherMonth?" ui-datepicker-other-month":"")+(// highlight days from other months
	printDate.getTime()===selectedDate.getTime()&&drawMonth===inst.selectedMonth&&inst._keyEvent||// user pressed key
	defaultDate.getTime()===printDate.getTime()&&defaultDate.getTime()===selectedDate.getTime()?// or defaultDate is current printedDate and defaultDate is selectedDate
	" "+this._dayOverClass:"")+(// highlight selected day
	unselectable?" "+this._unselectableClass+" ui-state-disabled":"")+(// highlight unselectable days
	otherMonth&&!showOtherMonths?"":" "+daySettings[1]+(// highlight custom dates
	printDate.getTime()===currentDate.getTime()?" "+this._currentClass:"")+(// highlight selected day
	printDate.getTime()===today.getTime()?" ui-datepicker-today":""))+"'"+(// highlight today (if different)
	(!otherMonth||showOtherMonths)&&daySettings[2]?" title='"+daySettings[2].replace(/'/g,"&#39;")+"'":"")+(// cell title
	unselectable?"":" data-handler='selectDay' data-event='click' data-month='"+printDate.getMonth()+"' data-year='"+printDate.getFullYear()+"'")+">"+(// actions
	otherMonth&&!showOtherMonths?"&#xa0;":// display for other months
	unselectable?"<span class='ui-state-default'>"+printDate.getDate()+"</span>":"<a class='ui-state-default"+(printDate.getTime()===today.getTime()?" ui-state-highlight":"")+(printDate.getTime()===currentDate.getTime()?" ui-state-active":"")+(// highlight selected day
	otherMonth?" ui-priority-secondary":"")+// distinguish dates from other months
	"' href='#' aria-current='"+(printDate.getTime()===currentDate.getTime()?"true":"false")+// mark date as selected for screen reader
	"' data-date='"+printDate.getDate()+// store date as data
	"'>"+printDate.getDate()+"</a>")+"</td>";// display selectable date
	printDate.setDate(printDate.getDate()+1);printDate=this._daylightSavingAdjust(printDate);}calender+=tbody+"</tr>";}drawMonth++;if(drawMonth>11){drawMonth=0;drawYear++;}calender+="</tbody></table>"+(isMultiMonth?"</div>"+(numMonths[0]>0&&col===numMonths[1]-1?"<div class='ui-datepicker-row-break'></div>":""):"");group+=calender;}html+=group;}html+=buttonPanel;inst._keyEvent=false;return html;},/* Generate the month and year header. */_generateMonthYearHeader:function(inst,drawMonth,drawYear,minDate,maxDate,secondary,monthNames,monthNamesShort){var inMinYear,inMaxYear,month,years,thisYear,determineYear,year,endYear,changeMonth=this._get(inst,"changeMonth"),changeYear=this._get(inst,"changeYear"),showMonthAfterYear=this._get(inst,"showMonthAfterYear"),selectMonthLabel=this._get(inst,"selectMonthLabel"),selectYearLabel=this._get(inst,"selectYearLabel"),html="<div class='ui-datepicker-title'>",monthHtml="";// Month selection
	if(secondary||!changeMonth){monthHtml+="<span class='ui-datepicker-month'>"+monthNames[drawMonth]+"</span>";}else {inMinYear=minDate&&minDate.getFullYear()===drawYear;inMaxYear=maxDate&&maxDate.getFullYear()===drawYear;monthHtml+="<select class='ui-datepicker-month' aria-label='"+selectMonthLabel+"' data-handler='selectMonth' data-event='change'>";for(month=0;month<12;month++){if((!inMinYear||month>=minDate.getMonth())&&(!inMaxYear||month<=maxDate.getMonth())){monthHtml+="<option value='"+month+"'"+(month===drawMonth?" selected='selected'":"")+">"+monthNamesShort[month]+"</option>";}}monthHtml+="</select>";}if(!showMonthAfterYear){html+=monthHtml+(secondary||!(changeMonth&&changeYear)?"&#xa0;":"");}// Year selection
	if(!inst.yearshtml){inst.yearshtml="";if(secondary||!changeYear){html+="<span class='ui-datepicker-year'>"+drawYear+"</span>";}else {// determine range of years to display
	years=this._get(inst,"yearRange").split(":");thisYear=new Date().getFullYear();determineYear=function(value){var year=value.match(/c[+\-].*/)?drawYear+parseInt(value.substring(1),10):value.match(/[+\-].*/)?thisYear+parseInt(value,10):parseInt(value,10);return isNaN(year)?thisYear:year;};year=determineYear(years[0]);endYear=Math.max(year,determineYear(years[1]||""));year=minDate?Math.max(year,minDate.getFullYear()):year;endYear=maxDate?Math.min(endYear,maxDate.getFullYear()):endYear;inst.yearshtml+="<select class='ui-datepicker-year' aria-label='"+selectYearLabel+"' data-handler='selectYear' data-event='change'>";for(;year<=endYear;year++){inst.yearshtml+="<option value='"+year+"'"+(year===drawYear?" selected='selected'":"")+">"+year+"</option>";}inst.yearshtml+="</select>";html+=inst.yearshtml;inst.yearshtml=null;}}html+=this._get(inst,"yearSuffix");if(showMonthAfterYear){html+=(secondary||!(changeMonth&&changeYear)?"&#xa0;":"")+monthHtml;}html+="</div>";// Close datepicker_header
	return html;},/* Adjust one of the date sub-fields. */_adjustInstDate:function(inst,offset,period){var year=inst.selectedYear+(period==="Y"?offset:0),month=inst.selectedMonth+(period==="M"?offset:0),day=Math.min(inst.selectedDay,this._getDaysInMonth(year,month))+(period==="D"?offset:0),date=this._restrictMinMax(inst,this._daylightSavingAdjust(new Date(year,month,day)));inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();if(period==="M"||period==="Y"){this._notifyChange(inst);}},/* Ensure a date is within any min/max bounds. */_restrictMinMax:function(inst,date){var minDate=this._getMinMaxDate(inst,"min"),maxDate=this._getMinMaxDate(inst,"max"),newDate=minDate&&date<minDate?minDate:date;return maxDate&&newDate>maxDate?maxDate:newDate;},/* Notify change of month/year. */_notifyChange:function(inst){var onChange=this._get(inst,"onChangeMonthYear");if(onChange){onChange.apply(inst.input?inst.input[0]:null,[inst.selectedYear,inst.selectedMonth+1,inst]);}},/* Determine the number of months to show. */_getNumberOfMonths:function(inst){var numMonths=this._get(inst,"numberOfMonths");return numMonths==null?[1,1]:typeof numMonths==="number"?[1,numMonths]:numMonths;},/* Determine the current maximum date - ensure no time components are set. */_getMinMaxDate:function(inst,minMax){return this._determineDate(inst,this._get(inst,minMax+"Date"),null);},/* Find the number of days in a given month. */_getDaysInMonth:function(year,month){return 32-this._daylightSavingAdjust(new Date(year,month,32)).getDate();},/* Find the day of the week of the first of a month. */_getFirstDayOfMonth:function(year,month){return new Date(year,month,1).getDay();},/* Determines if we should allow a "next/prev" month display change. */_canAdjustMonth:function(inst,offset,curYear,curMonth){var numMonths=this._getNumberOfMonths(inst),date=this._daylightSavingAdjust(new Date(curYear,curMonth+(offset<0?offset:numMonths[0]*numMonths[1]),1));if(offset<0){date.setDate(this._getDaysInMonth(date.getFullYear(),date.getMonth()));}return this._isInRange(inst,date);},/* Is the given date in the accepted range? */_isInRange:function(inst,date){var yearSplit,currentYear,minDate=this._getMinMaxDate(inst,"min"),maxDate=this._getMinMaxDate(inst,"max"),minYear=null,maxYear=null,years=this._get(inst,"yearRange");if(years){yearSplit=years.split(":");currentYear=new Date().getFullYear();minYear=parseInt(yearSplit[0],10);maxYear=parseInt(yearSplit[1],10);if(yearSplit[0].match(/[+\-].*/)){minYear+=currentYear;}if(yearSplit[1].match(/[+\-].*/)){maxYear+=currentYear;}}return (!minDate||date.getTime()>=minDate.getTime())&&(!maxDate||date.getTime()<=maxDate.getTime())&&(!minYear||date.getFullYear()>=minYear)&&(!maxYear||date.getFullYear()<=maxYear);},/* Provide the configuration settings for formatting/parsing. */_getFormatConfig:function(inst){var shortYearCutoff=this._get(inst,"shortYearCutoff");shortYearCutoff=typeof shortYearCutoff!=="string"?shortYearCutoff:new Date().getFullYear()%100+parseInt(shortYearCutoff,10);return {shortYearCutoff:shortYearCutoff,dayNamesShort:this._get(inst,"dayNamesShort"),dayNames:this._get(inst,"dayNames"),monthNamesShort:this._get(inst,"monthNamesShort"),monthNames:this._get(inst,"monthNames")};},/* Format the given date for display. */_formatDate:function(inst,day,month,year){if(!day){inst.currentDay=inst.selectedDay;inst.currentMonth=inst.selectedMonth;inst.currentYear=inst.selectedYear;}var date=day?typeof day==="object"?day:this._daylightSavingAdjust(new Date(year,month,day)):this._daylightSavingAdjust(new Date(inst.currentYear,inst.currentMonth,inst.currentDay));return this.formatDate(this._get(inst,"dateFormat"),date,this._getFormatConfig(inst));}});/*
	 * Bind hover events for datepicker elements.
	 * Done via delegate so the binding only occurs once in the lifetime of the parent div.
	 * Global datepicker_instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.
	 */function datepicker_bindHover(dpDiv){var selector="button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";return dpDiv.on("mouseout",selector,function(){$(this).removeClass("ui-state-hover");if(this.className.indexOf("ui-datepicker-prev")!==-1){$(this).removeClass("ui-datepicker-prev-hover");}if(this.className.indexOf("ui-datepicker-next")!==-1){$(this).removeClass("ui-datepicker-next-hover");}}).on("mouseover",selector,datepicker_handleMouseover);}function datepicker_handleMouseover(){if(!$.datepicker._isDisabledDatepicker(datepicker_instActive.inline?datepicker_instActive.dpDiv.parent()[0]:datepicker_instActive.input[0])){$(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover");$(this).addClass("ui-state-hover");if(this.className.indexOf("ui-datepicker-prev")!==-1){$(this).addClass("ui-datepicker-prev-hover");}if(this.className.indexOf("ui-datepicker-next")!==-1){$(this).addClass("ui-datepicker-next-hover");}}}/* jQuery extend now ignores nulls! */function datepicker_extendRemove(target,props){$.extend(target,props);for(var name in props){if(props[name]==null){target[name]=props[name];}}return target;}/* Invoke the datepicker functionality.
	   @param  options  string - a command, optionally followed by additional parameters or
						Object - settings for attaching new datepicker functionality
	   @return  jQuery object */$.fn.datepicker=function(options){/* Verify an empty collection wasn't passed - Fixes #6976 */if(!this.length){return this;}/* Initialise the date picker. */if(!$.datepicker.initialized){$(document).on("mousedown",$.datepicker._checkExternalClick);$.datepicker.initialized=true;}/* Append datepicker main container to body if not exist. */if($("#"+$.datepicker._mainDivId).length===0){$("body").append($.datepicker.dpDiv);}var otherArgs=Array.prototype.slice.call(arguments,1);if(typeof options==="string"&&(options==="isDisabled"||options==="getDate"||options==="widget")){return $.datepicker["_"+options+"Datepicker"].apply($.datepicker,[this[0]].concat(otherArgs));}if(options==="option"&&arguments.length===2&&typeof arguments[1]==="string"){return $.datepicker["_"+options+"Datepicker"].apply($.datepicker,[this[0]].concat(otherArgs));}return this.each(function(){if(typeof options==="string"){$.datepicker["_"+options+"Datepicker"].apply($.datepicker,[this].concat(otherArgs));}else {$.datepicker._attachDatepicker(this,options);}});};$.datepicker=new Datepicker();// singleton instance
	$.datepicker.initialized=false;$.datepicker.uuid=new Date().getTime();$.datepicker.version="1.13.3";$.datepicker;// This file is deprecated
	$.ui.ie=!!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase());/*!
	 * jQuery UI Mouse 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Mouse
	//>>group: Widgets
	//>>description: Abstracts mouse-based interactions to assist in creating certain widgets.
	//>>docs: https://api.jqueryui.com/mouse/
	var mouseHandled=false;$(document).on("mouseup",function(){mouseHandled=false;});$.widget("ui.mouse",{version:"1.13.3",options:{cancel:"input, textarea, button, select, option",distance:1,delay:0},_mouseInit:function(){var that=this;this.element.on("mousedown."+this.widgetName,function(event){return that._mouseDown(event);}).on("click."+this.widgetName,function(event){if(true===$.data(event.target,that.widgetName+".preventClickEvent")){$.removeData(event.target,that.widgetName+".preventClickEvent");event.stopImmediatePropagation();return false;}});this.started=false;},// TODO: make sure destroying one instance of mouse doesn't mess with
	// other instances of mouse
	_mouseDestroy:function(){this.element.off("."+this.widgetName);if(this._mouseMoveDelegate){this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate);}},_mouseDown:function(event){// don't let more than one widget handle mouseStart
	if(mouseHandled){return;}this._mouseMoved=false;// We may have missed mouseup (out of window)
	if(this._mouseStarted){this._mouseUp(event);}this._mouseDownEvent=event;var that=this,btnIsLeft=event.which===1,// event.target.nodeName works around a bug in IE 8 with
	// disabled inputs (#7620)
	elIsCancel=typeof this.options.cancel==="string"&&event.target.nodeName?$(event.target).closest(this.options.cancel).length:false;if(!btnIsLeft||elIsCancel||!this._mouseCapture(event)){return true;}this.mouseDelayMet=!this.options.delay;if(!this.mouseDelayMet){this._mouseDelayTimer=setTimeout(function(){that.mouseDelayMet=true;},this.options.delay);}if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=this._mouseStart(event)!==false;if(!this._mouseStarted){event.preventDefault();return true;}}// Click event may never have fired (Gecko & Opera)
	if(true===$.data(event.target,this.widgetName+".preventClickEvent")){$.removeData(event.target,this.widgetName+".preventClickEvent");}// These delegates are required to keep context
	this._mouseMoveDelegate=function(event){return that._mouseMove(event);};this._mouseUpDelegate=function(event){return that._mouseUp(event);};this.document.on("mousemove."+this.widgetName,this._mouseMoveDelegate).on("mouseup."+this.widgetName,this._mouseUpDelegate);event.preventDefault();mouseHandled=true;return true;},_mouseMove:function(event){// Only check for mouseups outside the document if you've moved inside the document
	// at least once. This prevents the firing of mouseup in the case of IE<9, which will
	// fire a mousemove event if content is placed under the cursor. See #7778
	// Support: IE <9
	if(this._mouseMoved){// IE mouseup check - mouseup happened when mouse was out of window
	if($.ui.ie&&(!document.documentMode||document.documentMode<9)&&!event.button){return this._mouseUp(event);// Iframe mouseup check - mouseup occurred in another document
	}else if(!event.which){// Support: Safari <=8 - 9
	// Safari sets which to 0 if you press any of the following keys
	// during a drag (#14461)
	if(event.originalEvent.altKey||event.originalEvent.ctrlKey||event.originalEvent.metaKey||event.originalEvent.shiftKey){this.ignoreMissingWhich=true;}else if(!this.ignoreMissingWhich){return this._mouseUp(event);}}}if(event.which||event.button){this._mouseMoved=true;}if(this._mouseStarted){this._mouseDrag(event);return event.preventDefault();}if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=this._mouseStart(this._mouseDownEvent,event)!==false;if(this._mouseStarted){this._mouseDrag(event);}else {this._mouseUp(event);}}return !this._mouseStarted;},_mouseUp:function(event){this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate);if(this._mouseStarted){this._mouseStarted=false;if(event.target===this._mouseDownEvent.target){$.data(event.target,this.widgetName+".preventClickEvent",true);}this._mouseStop(event);}if(this._mouseDelayTimer){clearTimeout(this._mouseDelayTimer);delete this._mouseDelayTimer;}this.ignoreMissingWhich=false;mouseHandled=false;event.preventDefault();},_mouseDistanceMet:function(event){return Math.max(Math.abs(this._mouseDownEvent.pageX-event.pageX),Math.abs(this._mouseDownEvent.pageY-event.pageY))>=this.options.distance;},_mouseDelayMet:function/* event */(){return this.mouseDelayMet;},// These are placeholder methods, to be overriden by extending plugin
	_mouseStart:function/* event */(){},_mouseDrag:function/* event */(){},_mouseStop:function/* event */(){},_mouseCapture:function/* event */(){return true;}});// $.ui.plugin is deprecated. Use $.widget() extensions instead.
	$.ui.plugin={add:function(module,option,set){var i,proto=$.ui[module].prototype;for(i in set){proto.plugins[i]=proto.plugins[i]||[];proto.plugins[i].push([option,set[i]]);}},call:function(instance,name,args,allowDisconnected){var i,set=instance.plugins[name];if(!set){return;}if(!allowDisconnected&&(!instance.element[0].parentNode||instance.element[0].parentNode.nodeType===11)){return;}for(i=0;i<set.length;i++){if(instance.options[set[i][0]]){set[i][1].apply(instance.element,args);}}}};$.ui.safeBlur=function(element){// Support: IE9 - 10 only
	// If the <body> is blurred, IE will switch windows, see #9420
	if(element&&element.nodeName.toLowerCase()!=="body"){$(element).trigger("blur");}};/*!
	 * jQuery UI Draggable 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Draggable
	//>>group: Interactions
	//>>description: Enables dragging functionality for any element.
	//>>docs: https://api.jqueryui.com/draggable/
	//>>demos: https://jqueryui.com/draggable/
	//>>css.structure: ../../themes/base/draggable.css
	$.widget("ui.draggable",$.ui.mouse,{version:"1.13.3",widgetEventPrefix:"drag",options:{addClasses:true,appendTo:"parent",axis:false,connectToSortable:false,containment:false,cursor:"auto",cursorAt:false,grid:false,handle:false,helper:"original",iframeFix:false,opacity:false,refreshPositions:false,revert:false,revertDuration:500,scope:"default",scroll:true,scrollSensitivity:20,scrollSpeed:20,snap:false,snapMode:"both",snapTolerance:20,stack:false,zIndex:false,// Callbacks
	drag:null,start:null,stop:null},_create:function(){if(this.options.helper==="original"){this._setPositionRelative();}if(this.options.addClasses){this._addClass("ui-draggable");}this._setHandleClassName();this._mouseInit();},_setOption:function(key,value){this._super(key,value);if(key==="handle"){this._removeHandleClassName();this._setHandleClassName();}},_destroy:function(){if((this.helper||this.element).is(".ui-draggable-dragging")){this.destroyOnClear=true;return;}this._removeHandleClassName();this._mouseDestroy();},_mouseCapture:function(event){var o=this.options;// Among others, prevent a drag on a resizable-handle
	if(this.helper||o.disabled||$(event.target).closest(".ui-resizable-handle").length>0){return false;}//Quit if we're not on a valid handle
	this.handle=this._getHandle(event);if(!this.handle){return false;}this._blurActiveElement(event);this._blockFrames(o.iframeFix===true?"iframe":o.iframeFix);return true;},_blockFrames:function(selector){this.iframeBlocks=this.document.find(selector).map(function(){var iframe=$(this);return $("<div>").css("position","absolute").appendTo(iframe.parent()).outerWidth(iframe.outerWidth()).outerHeight(iframe.outerHeight()).offset(iframe.offset())[0];});},_unblockFrames:function(){if(this.iframeBlocks){this.iframeBlocks.remove();delete this.iframeBlocks;}},_blurActiveElement:function(event){var activeElement=$.ui.safeActiveElement(this.document[0]),target=$(event.target);// Don't blur if the event occurred on an element that is within
	// the currently focused element
	// See #10527, #12472
	if(target.closest(activeElement).length){return;}// Blur any element that currently has focus, see #4261
	$.ui.safeBlur(activeElement);},_mouseStart:function(event){var o=this.options;//Create and append the visible helper
	this.helper=this._createHelper(event);this._addClass(this.helper,"ui-draggable-dragging");//Cache the helper size
	this._cacheHelperProportions();//If ddmanager is used for droppables, set the global draggable
	if($.ui.ddmanager){$.ui.ddmanager.current=this;}/*
			 * - Position generation -
			 * This block generates everything position related - it's the core of draggables.
			 *///Cache the margins of the original element
	this._cacheMargins();//Store the helper's css position
	this.cssPosition=this.helper.css("position");this.scrollParent=this.helper.scrollParent(true);this.offsetParent=this.helper.offsetParent();this.hasFixedAncestor=this.helper.parents().filter(function(){return $(this).css("position")==="fixed";}).length>0;//The element's absolute position on the page minus margins
	this.positionAbs=this.element.offset();this._refreshOffsets(event);//Generate the original position
	this.originalPosition=this.position=this._generatePosition(event,false);this.originalPageX=event.pageX;this.originalPageY=event.pageY;//Adjust the mouse offset relative to the helper if "cursorAt" is supplied
	if(o.cursorAt){this._adjustOffsetFromHelper(o.cursorAt);}//Set a containment if given in the options
	this._setContainment();//Trigger event + callbacks
	if(this._trigger("start",event)===false){this._clear();return false;}//Recache the helper size
	this._cacheHelperProportions();//Prepare the droppable offsets
	if($.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(this,event);}// Execute the drag once - this causes the helper not to be visible before getting its
	// correct position
	this._mouseDrag(event,true);// If the ddmanager is used for droppables, inform the manager that dragging has started
	// (see #5003)
	if($.ui.ddmanager){$.ui.ddmanager.dragStart(this,event);}return true;},_refreshOffsets:function(event){this.offset={top:this.positionAbs.top-this.margins.top,left:this.positionAbs.left-this.margins.left,scroll:false,parent:this._getParentOffset(),relative:this._getRelativeOffset()};this.offset.click={left:event.pageX-this.offset.left,top:event.pageY-this.offset.top};},_mouseDrag:function(event,noPropagation){// reset any necessary cached properties (see #5009)
	if(this.hasFixedAncestor){this.offset.parent=this._getParentOffset();}//Compute the helpers position
	this.position=this._generatePosition(event,true);this.positionAbs=this._convertPositionTo("absolute");//Call plugins and callbacks and use the resulting position if something is returned
	if(!noPropagation){var ui=this._uiHash();if(this._trigger("drag",event,ui)===false){this._mouseUp(new $.Event("mouseup",event));return false;}this.position=ui.position;}this.helper[0].style.left=this.position.left+"px";this.helper[0].style.top=this.position.top+"px";if($.ui.ddmanager){$.ui.ddmanager.drag(this,event);}return false;},_mouseStop:function(event){//If we are using droppables, inform the manager about the drop
	var that=this,dropped=false;if($.ui.ddmanager&&!this.options.dropBehaviour){dropped=$.ui.ddmanager.drop(this,event);}//if a drop comes from outside (a sortable)
	if(this.dropped){dropped=this.dropped;this.dropped=false;}if(this.options.revert==="invalid"&&!dropped||this.options.revert==="valid"&&dropped||this.options.revert===true||typeof this.options.revert==="function"&&this.options.revert.call(this.element,dropped)){$(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){if(that._trigger("stop",event)!==false){that._clear();}});}else {if(this._trigger("stop",event)!==false){this._clear();}}return false;},_mouseUp:function(event){this._unblockFrames();// If the ddmanager is used for droppables, inform the manager that dragging has stopped
	// (see #5003)
	if($.ui.ddmanager){$.ui.ddmanager.dragStop(this,event);}// Only need to focus if the event occurred on the draggable itself, see #10527
	if(this.handleElement.is(event.target)){// The interaction is over; whether or not the click resulted in a drag,
	// focus the element
	this.element.trigger("focus");}return $.ui.mouse.prototype._mouseUp.call(this,event);},cancel:function(){if(this.helper.is(".ui-draggable-dragging")){this._mouseUp(new $.Event("mouseup",{target:this.element[0]}));}else {this._clear();}return this;},_getHandle:function(event){return this.options.handle?!!$(event.target).closest(this.element.find(this.options.handle)).length:true;},_setHandleClassName:function(){this.handleElement=this.options.handle?this.element.find(this.options.handle):this.element;this._addClass(this.handleElement,"ui-draggable-handle");},_removeHandleClassName:function(){this._removeClass(this.handleElement,"ui-draggable-handle");},_createHelper:function(event){var o=this.options,helperIsFunction=typeof o.helper==="function",helper=helperIsFunction?$(o.helper.apply(this.element[0],[event])):o.helper==="clone"?this.element.clone().removeAttr("id"):this.element;if(!helper.parents("body").length){helper.appendTo(o.appendTo==="parent"?this.element[0].parentNode:o.appendTo);}// https://bugs.jqueryui.com/ticket/9446
	// a helper function can return the original element
	// which wouldn't have been set to relative in _create
	if(helperIsFunction&&helper[0]===this.element[0]){this._setPositionRelative();}if(helper[0]!==this.element[0]&&!/(fixed|absolute)/.test(helper.css("position"))){helper.css("position","absolute");}return helper;},_setPositionRelative:function(){if(!/^(?:r|a|f)/.test(this.element.css("position"))){this.element[0].style.position="relative";}},_adjustOffsetFromHelper:function(obj){if(typeof obj==="string"){obj=obj.split(" ");}if(Array.isArray(obj)){obj={left:+obj[0],top:+obj[1]||0};}if("left"in obj){this.offset.click.left=obj.left+this.margins.left;}if("right"in obj){this.offset.click.left=this.helperProportions.width-obj.right+this.margins.left;}if("top"in obj){this.offset.click.top=obj.top+this.margins.top;}if("bottom"in obj){this.offset.click.top=this.helperProportions.height-obj.bottom+this.margins.top;}},_isRootNode:function(element){return /(html|body)/i.test(element.tagName)||element===this.document[0];},_getParentOffset:function(){//Get the offsetParent and cache its position
	var po=this.offsetParent.offset(),document=this.document[0];// This is a special case where we need to modify a offset calculated on start, since the
	// following happened:
	// 1. The position of the helper is absolute, so it's position is calculated based on the
	// next positioned parent
	// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't
	// the document, which means that the scroll is included in the initial calculation of the
	// offset of the parent, and never recalculated upon drag
	if(this.cssPosition==="absolute"&&this.scrollParent[0]!==document&&$.contains(this.scrollParent[0],this.offsetParent[0])){po.left+=this.scrollParent.scrollLeft();po.top+=this.scrollParent.scrollTop();}if(this._isRootNode(this.offsetParent[0])){po={top:0,left:0};}return {top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)};},_getRelativeOffset:function(){if(this.cssPosition!=="relative"){return {top:0,left:0};}var p=this.element.position(),scrollIsRootNode=this._isRootNode(this.scrollParent[0]);return {top:p.top-(parseInt(this.helper.css("top"),10)||0)+(!scrollIsRootNode?this.scrollParent.scrollTop():0),left:p.left-(parseInt(this.helper.css("left"),10)||0)+(!scrollIsRootNode?this.scrollParent.scrollLeft():0)};},_cacheMargins:function(){this.margins={left:parseInt(this.element.css("marginLeft"),10)||0,top:parseInt(this.element.css("marginTop"),10)||0,right:parseInt(this.element.css("marginRight"),10)||0,bottom:parseInt(this.element.css("marginBottom"),10)||0};},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};},_setContainment:function(){var isUserScrollable,c,ce,o=this.options,document=this.document[0];this.relativeContainer=null;if(!o.containment){this.containment=null;return;}if(o.containment==="window"){this.containment=[$(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,$(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,$(window).scrollLeft()+$(window).width()-this.helperProportions.width-this.margins.left,$(window).scrollTop()+($(window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];return;}if(o.containment==="document"){this.containment=[0,0,$(document).width()-this.helperProportions.width-this.margins.left,($(document).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];return;}if(o.containment.constructor===Array){this.containment=o.containment;return;}if(o.containment==="parent"){o.containment=this.helper[0].parentNode;}c=$(o.containment);ce=c[0];if(!ce){return;}isUserScrollable=/(scroll|auto)/.test(c.css("overflow"));this.containment=[(parseInt(c.css("borderLeftWidth"),10)||0)+(parseInt(c.css("paddingLeft"),10)||0),(parseInt(c.css("borderTopWidth"),10)||0)+(parseInt(c.css("paddingTop"),10)||0),(isUserScrollable?Math.max(ce.scrollWidth,ce.offsetWidth):ce.offsetWidth)-(parseInt(c.css("borderRightWidth"),10)||0)-(parseInt(c.css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(isUserScrollable?Math.max(ce.scrollHeight,ce.offsetHeight):ce.offsetHeight)-(parseInt(c.css("borderBottomWidth"),10)||0)-(parseInt(c.css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom];this.relativeContainer=c;},_convertPositionTo:function(d,pos){if(!pos){pos=this.position;}var mod=d==="absolute"?1:-1,scrollIsRootNode=this._isRootNode(this.scrollParent[0]);return {top:// The absolute mouse position
	pos.top+// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.top*mod+// The offsetParent's offset without borders (offset + border)
	this.offset.parent.top*mod-(this.cssPosition==="fixed"?-this.offset.scroll.top:scrollIsRootNode?0:this.offset.scroll.top)*mod,left:// The absolute mouse position
	pos.left+// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.left*mod+// The offsetParent's offset without borders (offset + border)
	this.offset.parent.left*mod-(this.cssPosition==="fixed"?-this.offset.scroll.left:scrollIsRootNode?0:this.offset.scroll.left)*mod};},_generatePosition:function(event,constrainPosition){var containment,co,top,left,o=this.options,scrollIsRootNode=this._isRootNode(this.scrollParent[0]),pageX=event.pageX,pageY=event.pageY;// Cache the scroll
	if(!scrollIsRootNode||!this.offset.scroll){this.offset.scroll={top:this.scrollParent.scrollTop(),left:this.scrollParent.scrollLeft()};}/*
			 * - Position constraining -
			 * Constrain the position to a mix of grid, containment.
			 */// If we are not dragging yet, we won't check for options
	if(constrainPosition){if(this.containment){if(this.relativeContainer){co=this.relativeContainer.offset();containment=[this.containment[0]+co.left,this.containment[1]+co.top,this.containment[2]+co.left,this.containment[3]+co.top];}else {containment=this.containment;}if(event.pageX-this.offset.click.left<containment[0]){pageX=containment[0]+this.offset.click.left;}if(event.pageY-this.offset.click.top<containment[1]){pageY=containment[1]+this.offset.click.top;}if(event.pageX-this.offset.click.left>containment[2]){pageX=containment[2]+this.offset.click.left;}if(event.pageY-this.offset.click.top>containment[3]){pageY=containment[3]+this.offset.click.top;}}if(o.grid){//Check for grid elements set to 0 to prevent divide by 0 error causing invalid
	// argument errors in IE (see ticket #6950)
	top=o.grid[1]?this.originalPageY+Math.round((pageY-this.originalPageY)/o.grid[1])*o.grid[1]:this.originalPageY;pageY=containment?top-this.offset.click.top>=containment[1]||top-this.offset.click.top>containment[3]?top:top-this.offset.click.top>=containment[1]?top-o.grid[1]:top+o.grid[1]:top;left=o.grid[0]?this.originalPageX+Math.round((pageX-this.originalPageX)/o.grid[0])*o.grid[0]:this.originalPageX;pageX=containment?left-this.offset.click.left>=containment[0]||left-this.offset.click.left>containment[2]?left:left-this.offset.click.left>=containment[0]?left-o.grid[0]:left+o.grid[0]:left;}if(o.axis==="y"){pageX=this.originalPageX;}if(o.axis==="x"){pageY=this.originalPageY;}}return {top:// The absolute mouse position
	pageY-// Click offset (relative to the element)
	this.offset.click.top-// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.top-// The offsetParent's offset without borders (offset + border)
	this.offset.parent.top+(this.cssPosition==="fixed"?-this.offset.scroll.top:scrollIsRootNode?0:this.offset.scroll.top),left:// The absolute mouse position
	pageX-// Click offset (relative to the element)
	this.offset.click.left-// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.left-// The offsetParent's offset without borders (offset + border)
	this.offset.parent.left+(this.cssPosition==="fixed"?-this.offset.scroll.left:scrollIsRootNode?0:this.offset.scroll.left)};},_clear:function(){this._removeClass(this.helper,"ui-draggable-dragging");if(this.helper[0]!==this.element[0]&&!this.cancelHelperRemoval){this.helper.remove();}this.helper=null;this.cancelHelperRemoval=false;if(this.destroyOnClear){this.destroy();}},// From now on bulk stuff - mainly helpers
	_trigger:function(type,event,ui){ui=ui||this._uiHash();$.ui.plugin.call(this,type,[event,ui,this],true);// Absolute position and offset (see #6884 ) have to be recalculated after plugins
	if(/^(drag|start|stop)/.test(type)){this.positionAbs=this._convertPositionTo("absolute");ui.offset=this.positionAbs;}return $.Widget.prototype._trigger.call(this,type,event,ui);},plugins:{},_uiHash:function(){return {helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs};}});$.ui.plugin.add("draggable","connectToSortable",{start:function(event,ui,draggable){var uiSortable=$.extend({},ui,{item:draggable.element});draggable.sortables=[];$(draggable.options.connectToSortable).each(function(){var sortable=$(this).sortable("instance");if(sortable&&!sortable.options.disabled){draggable.sortables.push(sortable);// RefreshPositions is called at drag start to refresh the containerCache
	// which is used in drag. This ensures it's initialized and synchronized
	// with any changes that might have happened on the page since initialization.
	sortable.refreshPositions();sortable._trigger("activate",event,uiSortable);}});},stop:function(event,ui,draggable){var uiSortable=$.extend({},ui,{item:draggable.element});draggable.cancelHelperRemoval=false;$.each(draggable.sortables,function(){var sortable=this;if(sortable.isOver){sortable.isOver=0;// Allow this sortable to handle removing the helper
	draggable.cancelHelperRemoval=true;sortable.cancelHelperRemoval=false;// Use _storedCSS To restore properties in the sortable,
	// as this also handles revert (#9675) since the draggable
	// may have modified them in unexpected ways (#8809)
	sortable._storedCSS={position:sortable.placeholder.css("position"),top:sortable.placeholder.css("top"),left:sortable.placeholder.css("left")};sortable._mouseStop(event);// Once drag has ended, the sortable should return to using
	// its original helper, not the shared helper from draggable
	sortable.options.helper=sortable.options._helper;}else {// Prevent this Sortable from removing the helper.
	// However, don't set the draggable to remove the helper
	// either as another connected Sortable may yet handle the removal.
	sortable.cancelHelperRemoval=true;sortable._trigger("deactivate",event,uiSortable);}});},drag:function(event,ui,draggable){$.each(draggable.sortables,function(){var innermostIntersecting=false,sortable=this;// Copy over variables that sortable's _intersectsWith uses
	sortable.positionAbs=draggable.positionAbs;sortable.helperProportions=draggable.helperProportions;sortable.offset.click=draggable.offset.click;if(sortable._intersectsWith(sortable.containerCache)){innermostIntersecting=true;$.each(draggable.sortables,function(){// Copy over variables that sortable's _intersectsWith uses
	this.positionAbs=draggable.positionAbs;this.helperProportions=draggable.helperProportions;this.offset.click=draggable.offset.click;if(this!==sortable&&this._intersectsWith(this.containerCache)&&$.contains(sortable.element[0],this.element[0])){innermostIntersecting=false;}return innermostIntersecting;});}if(innermostIntersecting){// If it intersects, we use a little isOver variable and set it once,
	// so that the move-in stuff gets fired only once.
	if(!sortable.isOver){sortable.isOver=1;// Store draggable's parent in case we need to reappend to it later.
	draggable._parent=ui.helper.parent();sortable.currentItem=ui.helper.appendTo(sortable.element).data("ui-sortable-item",true);// Store helper option to later restore it
	sortable.options._helper=sortable.options.helper;sortable.options.helper=function(){return ui.helper[0];};// Fire the start events of the sortable with our passed browser event,
	// and our own helper (so it doesn't create a new one)
	event.target=sortable.currentItem[0];sortable._mouseCapture(event,true);sortable._mouseStart(event,true,true);// Because the browser event is way off the new appended portlet,
	// modify necessary variables to reflect the changes
	sortable.offset.click.top=draggable.offset.click.top;sortable.offset.click.left=draggable.offset.click.left;sortable.offset.parent.left-=draggable.offset.parent.left-sortable.offset.parent.left;sortable.offset.parent.top-=draggable.offset.parent.top-sortable.offset.parent.top;draggable._trigger("toSortable",event);// Inform draggable that the helper is in a valid drop zone,
	// used solely in the revert option to handle "valid/invalid".
	draggable.dropped=sortable.element;// Need to refreshPositions of all sortables in the case that
	// adding to one sortable changes the location of the other sortables (#9675)
	$.each(draggable.sortables,function(){this.refreshPositions();});// Hack so receive/update callbacks work (mostly)
	draggable.currentItem=draggable.element;sortable.fromOutside=draggable;}if(sortable.currentItem){sortable._mouseDrag(event);// Copy the sortable's position because the draggable's can potentially reflect
	// a relative position, while sortable is always absolute, which the dragged
	// element has now become. (#8809)
	ui.position=sortable.position;}}else {// If it doesn't intersect with the sortable, and it intersected before,
	// we fake the drag stop of the sortable, but make sure it doesn't remove
	// the helper by using cancelHelperRemoval.
	if(sortable.isOver){sortable.isOver=0;sortable.cancelHelperRemoval=true;// Calling sortable's mouseStop would trigger a revert,
	// so revert must be temporarily false until after mouseStop is called.
	sortable.options._revert=sortable.options.revert;sortable.options.revert=false;sortable._trigger("out",event,sortable._uiHash(sortable));sortable._mouseStop(event,true);// Restore sortable behaviors that were modfied
	// when the draggable entered the sortable area (#9481)
	sortable.options.revert=sortable.options._revert;sortable.options.helper=sortable.options._helper;if(sortable.placeholder){sortable.placeholder.remove();}// Restore and recalculate the draggable's offset considering the sortable
	// may have modified them in unexpected ways. (#8809, #10669)
	ui.helper.appendTo(draggable._parent);draggable._refreshOffsets(event);ui.position=draggable._generatePosition(event,true);draggable._trigger("fromSortable",event);// Inform draggable that the helper is no longer in a valid drop zone
	draggable.dropped=false;// Need to refreshPositions of all sortables just in case removing
	// from one sortable changes the location of other sortables (#9675)
	$.each(draggable.sortables,function(){this.refreshPositions();});}}});}});$.ui.plugin.add("draggable","cursor",{start:function(event,ui,instance){var t=$("body"),o=instance.options;if(t.css("cursor")){o._cursor=t.css("cursor");}t.css("cursor",o.cursor);},stop:function(event,ui,instance){var o=instance.options;if(o._cursor){$("body").css("cursor",o._cursor);}}});$.ui.plugin.add("draggable","opacity",{start:function(event,ui,instance){var t=$(ui.helper),o=instance.options;if(t.css("opacity")){o._opacity=t.css("opacity");}t.css("opacity",o.opacity);},stop:function(event,ui,instance){var o=instance.options;if(o._opacity){$(ui.helper).css("opacity",o._opacity);}}});$.ui.plugin.add("draggable","scroll",{start:function(event,ui,i){if(!i.scrollParentNotHidden){i.scrollParentNotHidden=i.helper.scrollParent(false);}if(i.scrollParentNotHidden[0]!==i.document[0]&&i.scrollParentNotHidden[0].tagName!=="HTML"){i.overflowOffset=i.scrollParentNotHidden.offset();}},drag:function(event,ui,i){var o=i.options,scrolled=false,scrollParent=i.scrollParentNotHidden[0],document=i.document[0];if(scrollParent!==document&&scrollParent.tagName!=="HTML"){if(!o.axis||o.axis!=="x"){if(i.overflowOffset.top+scrollParent.offsetHeight-event.pageY<o.scrollSensitivity){scrollParent.scrollTop=scrolled=scrollParent.scrollTop+o.scrollSpeed;}else if(event.pageY-i.overflowOffset.top<o.scrollSensitivity){scrollParent.scrollTop=scrolled=scrollParent.scrollTop-o.scrollSpeed;}}if(!o.axis||o.axis!=="y"){if(i.overflowOffset.left+scrollParent.offsetWidth-event.pageX<o.scrollSensitivity){scrollParent.scrollLeft=scrolled=scrollParent.scrollLeft+o.scrollSpeed;}else if(event.pageX-i.overflowOffset.left<o.scrollSensitivity){scrollParent.scrollLeft=scrolled=scrollParent.scrollLeft-o.scrollSpeed;}}}else {if(!o.axis||o.axis!=="x"){if(event.pageY-$(document).scrollTop()<o.scrollSensitivity){scrolled=$(document).scrollTop($(document).scrollTop()-o.scrollSpeed);}else if($(window).height()-(event.pageY-$(document).scrollTop())<o.scrollSensitivity){scrolled=$(document).scrollTop($(document).scrollTop()+o.scrollSpeed);}}if(!o.axis||o.axis!=="y"){if(event.pageX-$(document).scrollLeft()<o.scrollSensitivity){scrolled=$(document).scrollLeft($(document).scrollLeft()-o.scrollSpeed);}else if($(window).width()-(event.pageX-$(document).scrollLeft())<o.scrollSensitivity){scrolled=$(document).scrollLeft($(document).scrollLeft()+o.scrollSpeed);}}}if(scrolled!==false&&$.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(i,event);}}});$.ui.plugin.add("draggable","snap",{start:function(event,ui,i){var o=i.options;i.snapElements=[];$(o.snap.constructor!==String?o.snap.items||":data(ui-draggable)":o.snap).each(function(){var $t=$(this),$o=$t.offset();if(this!==i.element[0]){i.snapElements.push({item:this,width:$t.outerWidth(),height:$t.outerHeight(),top:$o.top,left:$o.left});}});},drag:function(event,ui,inst){var ts,bs,ls,rs,l,r,t,b,i,first,o=inst.options,d=o.snapTolerance,x1=ui.offset.left,x2=x1+inst.helperProportions.width,y1=ui.offset.top,y2=y1+inst.helperProportions.height;for(i=inst.snapElements.length-1;i>=0;i--){l=inst.snapElements[i].left-inst.margins.left;r=l+inst.snapElements[i].width;t=inst.snapElements[i].top-inst.margins.top;b=t+inst.snapElements[i].height;if(x2<l-d||x1>r+d||y2<t-d||y1>b+d||!$.contains(inst.snapElements[i].item.ownerDocument,inst.snapElements[i].item)){if(inst.snapElements[i].snapping){if(inst.options.snap.release){inst.options.snap.release.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item}));}}inst.snapElements[i].snapping=false;continue;}if(o.snapMode!=="inner"){ts=Math.abs(t-y2)<=d;bs=Math.abs(b-y1)<=d;ls=Math.abs(l-x2)<=d;rs=Math.abs(r-x1)<=d;if(ts){ui.position.top=inst._convertPositionTo("relative",{top:t-inst.helperProportions.height,left:0}).top;}if(bs){ui.position.top=inst._convertPositionTo("relative",{top:b,left:0}).top;}if(ls){ui.position.left=inst._convertPositionTo("relative",{top:0,left:l-inst.helperProportions.width}).left;}if(rs){ui.position.left=inst._convertPositionTo("relative",{top:0,left:r}).left;}}first=ts||bs||ls||rs;if(o.snapMode!=="outer"){ts=Math.abs(t-y1)<=d;bs=Math.abs(b-y2)<=d;ls=Math.abs(l-x1)<=d;rs=Math.abs(r-x2)<=d;if(ts){ui.position.top=inst._convertPositionTo("relative",{top:t,left:0}).top;}if(bs){ui.position.top=inst._convertPositionTo("relative",{top:b-inst.helperProportions.height,left:0}).top;}if(ls){ui.position.left=inst._convertPositionTo("relative",{top:0,left:l}).left;}if(rs){ui.position.left=inst._convertPositionTo("relative",{top:0,left:r-inst.helperProportions.width}).left;}}if(!inst.snapElements[i].snapping&&(ts||bs||ls||rs||first)){if(inst.options.snap.snap){inst.options.snap.snap.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item}));}}inst.snapElements[i].snapping=ts||bs||ls||rs||first;}}});$.ui.plugin.add("draggable","stack",{start:function(event,ui,instance){var min,o=instance.options,group=$.makeArray($(o.stack)).sort(function(a,b){return (parseInt($(a).css("zIndex"),10)||0)-(parseInt($(b).css("zIndex"),10)||0);});if(!group.length){return;}min=parseInt($(group[0]).css("zIndex"),10)||0;$(group).each(function(i){$(this).css("zIndex",min+i);});this.css("zIndex",min+group.length);}});$.ui.plugin.add("draggable","zIndex",{start:function(event,ui,instance){var t=$(ui.helper),o=instance.options;if(t.css("zIndex")){o._zIndex=t.css("zIndex");}t.css("zIndex",o.zIndex);},stop:function(event,ui,instance){var o=instance.options;if(o._zIndex){$(ui.helper).css("zIndex",o._zIndex);}}});$.ui.draggable;/*!
	 * jQuery UI Resizable 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Resizable
	//>>group: Interactions
	//>>description: Enables resize functionality for any element.
	//>>docs: https://api.jqueryui.com/resizable/
	//>>demos: https://jqueryui.com/resizable/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/resizable.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.resizable",$.ui.mouse,{version:"1.13.3",widgetEventPrefix:"resize",options:{alsoResize:false,animate:false,animateDuration:"slow",animateEasing:"swing",aspectRatio:false,autoHide:false,classes:{"ui-resizable-se":"ui-icon ui-icon-gripsmall-diagonal-se"},containment:false,ghost:false,grid:false,handles:"e,s,se",helper:false,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,// See #7960
	zIndex:90,// Callbacks
	resize:null,start:null,stop:null},_num:function(value){return parseFloat(value)||0;},_isNumber:function(value){return !isNaN(parseFloat(value));},_hasScroll:function(el,a){if($(el).css("overflow")==="hidden"){return false;}var scroll=a&&a==="left"?"scrollLeft":"scrollTop",has=false;if(el[scroll]>0){return true;}// TODO: determine which cases actually cause this to happen
	// if the element doesn't have the scroll set, see if it's possible to
	// set the scroll
	try{el[scroll]=1;has=el[scroll]>0;el[scroll]=0;}catch(e){// `el` might be a string, then setting `scroll` will throw
	// an error in strict mode; ignore it.
	}return has;},_create:function(){var margins,o=this.options,that=this;this._addClass("ui-resizable");$.extend(this,{_aspectRatio:!!o.aspectRatio,aspectRatio:o.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:o.helper||o.ghost||o.animate?o.helper||"ui-resizable-helper":null});// Wrap the element if it cannot hold child nodes
	if(this.element[0].nodeName.match(/^(canvas|textarea|input|select|button|img)$/i)){this.element.wrap($("<div class='ui-wrapper'></div>").css({overflow:"hidden",position:this.element.css("position"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css("top"),left:this.element.css("left")}));this.element=this.element.parent().data("ui-resizable",this.element.resizable("instance"));this.elementIsWrapper=true;margins={marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom"),marginLeft:this.originalElement.css("marginLeft")};this.element.css(margins);this.originalElement.css("margin",0);// support: Safari
	// Prevent Safari textarea resize
	this.originalResizeStyle=this.originalElement.css("resize");this.originalElement.css("resize","none");this._proportionallyResizeElements.push(this.originalElement.css({position:"static",zoom:1,display:"block"}));// Support: IE9
	// avoid IE jump (hard set the margin)
	this.originalElement.css(margins);this._proportionallyResize();}this._setupHandles();if(o.autoHide){$(this.element).on("mouseenter",function(){if(o.disabled){return;}that._removeClass("ui-resizable-autohide");that._handles.show();}).on("mouseleave",function(){if(o.disabled){return;}if(!that.resizing){that._addClass("ui-resizable-autohide");that._handles.hide();}});}this._mouseInit();},_destroy:function(){this._mouseDestroy();this._addedHandles.remove();var wrapper,_destroy=function(exp){$(exp).removeData("resizable").removeData("ui-resizable").off(".resizable");};// TODO: Unwrap at same DOM position
	if(this.elementIsWrapper){_destroy(this.element);wrapper=this.element;this.originalElement.css({position:wrapper.css("position"),width:wrapper.outerWidth(),height:wrapper.outerHeight(),top:wrapper.css("top"),left:wrapper.css("left")}).insertAfter(wrapper);wrapper.remove();}this.originalElement.css("resize",this.originalResizeStyle);_destroy(this.originalElement);return this;},_setOption:function(key,value){this._super(key,value);switch(key){case"handles":this._removeHandles();this._setupHandles();break;case"aspectRatio":this._aspectRatio=!!value;break;}},_setupHandles:function(){var o=this.options,handle,i,n,hname,axis,that=this;this.handles=o.handles||(!$(".ui-resizable-handle",this.element).length?"e,s,se":{n:".ui-resizable-n",e:".ui-resizable-e",s:".ui-resizable-s",w:".ui-resizable-w",se:".ui-resizable-se",sw:".ui-resizable-sw",ne:".ui-resizable-ne",nw:".ui-resizable-nw"});this._handles=$();this._addedHandles=$();if(this.handles.constructor===String){if(this.handles==="all"){this.handles="n,e,s,w,se,sw,ne,nw";}n=this.handles.split(",");this.handles={};for(i=0;i<n.length;i++){handle=String.prototype.trim.call(n[i]);hname="ui-resizable-"+handle;axis=$("<div>");this._addClass(axis,"ui-resizable-handle "+hname);axis.css({zIndex:o.zIndex});this.handles[handle]=".ui-resizable-"+handle;if(!this.element.children(this.handles[handle]).length){this.element.append(axis);this._addedHandles=this._addedHandles.add(axis);}}}this._renderAxis=function(target){var i,axis,padPos,padWrapper;target=target||this.element;for(i in this.handles){if(this.handles[i].constructor===String){this.handles[i]=this.element.children(this.handles[i]).first().show();}else if(this.handles[i].jquery||this.handles[i].nodeType){this.handles[i]=$(this.handles[i]);this._on(this.handles[i],{"mousedown":that._mouseDown});}if(this.elementIsWrapper&&this.originalElement[0].nodeName.match(/^(textarea|input|select|button)$/i)){axis=$(this.handles[i],this.element);padWrapper=/sw|ne|nw|se|n|s/.test(i)?axis.outerHeight():axis.outerWidth();padPos=["padding",/ne|nw|n/.test(i)?"Top":/se|sw|s/.test(i)?"Bottom":/^e$/.test(i)?"Right":"Left"].join("");target.css(padPos,padWrapper);this._proportionallyResize();}this._handles=this._handles.add(this.handles[i]);}};// TODO: make renderAxis a prototype function
	this._renderAxis(this.element);this._handles=this._handles.add(this.element.find(".ui-resizable-handle"));this._handles.disableSelection();this._handles.on("mouseover",function(){if(!that.resizing){if(this.className){axis=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i);}that.axis=axis&&axis[1]?axis[1]:"se";}});if(o.autoHide){this._handles.hide();this._addClass("ui-resizable-autohide");}},_removeHandles:function(){this._addedHandles.remove();},_mouseCapture:function(event){var i,handle,capture=false;for(i in this.handles){handle=$(this.handles[i])[0];if(handle===event.target||$.contains(handle,event.target)){capture=true;}}return !this.options.disabled&&capture;},_mouseStart:function(event){var curleft,curtop,cursor,o=this.options,el=this.element;this.resizing=true;this._renderProxy();curleft=this._num(this.helper.css("left"));curtop=this._num(this.helper.css("top"));if(o.containment){curleft+=$(o.containment).scrollLeft()||0;curtop+=$(o.containment).scrollTop()||0;}this.offset=this.helper.offset();this.position={left:curleft,top:curtop};this.size=this._helper?{width:this.helper.width(),height:this.helper.height()}:{width:el.width(),height:el.height()};this.originalSize=this._helper?{width:el.outerWidth(),height:el.outerHeight()}:{width:el.width(),height:el.height()};this.sizeDiff={width:el.outerWidth()-el.width(),height:el.outerHeight()-el.height()};this.originalPosition={left:curleft,top:curtop};this.originalMousePosition={left:event.pageX,top:event.pageY};this.aspectRatio=typeof o.aspectRatio==="number"?o.aspectRatio:this.originalSize.width/this.originalSize.height||1;cursor=$(".ui-resizable-"+this.axis).css("cursor");$("body").css("cursor",cursor==="auto"?this.axis+"-resize":cursor);this._addClass("ui-resizable-resizing");this._propagate("start",event);return true;},_mouseDrag:function(event){var data,props,smp=this.originalMousePosition,a=this.axis,dx=event.pageX-smp.left||0,dy=event.pageY-smp.top||0,trigger=this._change[a];this._updatePrevProperties();if(!trigger){return false;}data=trigger.apply(this,[event,dx,dy]);this._updateVirtualBoundaries(event.shiftKey);if(this._aspectRatio||event.shiftKey){data=this._updateRatio(data,event);}data=this._respectSize(data,event);this._updateCache(data);this._propagate("resize",event);props=this._applyChanges();if(!this._helper&&this._proportionallyResizeElements.length){this._proportionallyResize();}if(!$.isEmptyObject(props)){this._updatePrevProperties();this._trigger("resize",event,this.ui());this._applyChanges();}return false;},_mouseStop:function(event){this.resizing=false;var pr,ista,soffseth,soffsetw,s,left,top,o=this.options,that=this;if(this._helper){pr=this._proportionallyResizeElements;ista=pr.length&&/textarea/i.test(pr[0].nodeName);soffseth=ista&&this._hasScroll(pr[0],"left")?0:that.sizeDiff.height;soffsetw=ista?0:that.sizeDiff.width;s={width:that.helper.width()-soffsetw,height:that.helper.height()-soffseth};left=parseFloat(that.element.css("left"))+(that.position.left-that.originalPosition.left)||null;top=parseFloat(that.element.css("top"))+(that.position.top-that.originalPosition.top)||null;if(!o.animate){this.element.css($.extend(s,{top:top,left:left}));}that.helper.height(that.size.height);that.helper.width(that.size.width);if(this._helper&&!o.animate){this._proportionallyResize();}}$("body").css("cursor","auto");this._removeClass("ui-resizable-resizing");this._propagate("stop",event);if(this._helper){this.helper.remove();}return false;},_updatePrevProperties:function(){this.prevPosition={top:this.position.top,left:this.position.left};this.prevSize={width:this.size.width,height:this.size.height};},_applyChanges:function(){var props={};if(this.position.top!==this.prevPosition.top){props.top=this.position.top+"px";}if(this.position.left!==this.prevPosition.left){props.left=this.position.left+"px";}this.helper.css(props);if(this.size.width!==this.prevSize.width){props.width=this.size.width+"px";this.helper.width(props.width);}if(this.size.height!==this.prevSize.height){props.height=this.size.height+"px";this.helper.height(props.height);}return props;},_updateVirtualBoundaries:function(forceAspectRatio){var pMinWidth,pMaxWidth,pMinHeight,pMaxHeight,b,o=this.options;b={minWidth:this._isNumber(o.minWidth)?o.minWidth:0,maxWidth:this._isNumber(o.maxWidth)?o.maxWidth:Infinity,minHeight:this._isNumber(o.minHeight)?o.minHeight:0,maxHeight:this._isNumber(o.maxHeight)?o.maxHeight:Infinity};if(this._aspectRatio||forceAspectRatio){pMinWidth=b.minHeight*this.aspectRatio;pMinHeight=b.minWidth/this.aspectRatio;pMaxWidth=b.maxHeight*this.aspectRatio;pMaxHeight=b.maxWidth/this.aspectRatio;if(pMinWidth>b.minWidth){b.minWidth=pMinWidth;}if(pMinHeight>b.minHeight){b.minHeight=pMinHeight;}if(pMaxWidth<b.maxWidth){b.maxWidth=pMaxWidth;}if(pMaxHeight<b.maxHeight){b.maxHeight=pMaxHeight;}}this._vBoundaries=b;},_updateCache:function(data){this.offset=this.helper.offset();if(this._isNumber(data.left)){this.position.left=data.left;}if(this._isNumber(data.top)){this.position.top=data.top;}if(this._isNumber(data.height)){this.size.height=data.height;}if(this._isNumber(data.width)){this.size.width=data.width;}},_updateRatio:function(data){var cpos=this.position,csize=this.size,a=this.axis;if(this._isNumber(data.height)){data.width=data.height*this.aspectRatio;}else if(this._isNumber(data.width)){data.height=data.width/this.aspectRatio;}if(a==="sw"){data.left=cpos.left+(csize.width-data.width);data.top=null;}if(a==="nw"){data.top=cpos.top+(csize.height-data.height);data.left=cpos.left+(csize.width-data.width);}return data;},_respectSize:function(data){var o=this._vBoundaries,a=this.axis,ismaxw=this._isNumber(data.width)&&o.maxWidth&&o.maxWidth<data.width,ismaxh=this._isNumber(data.height)&&o.maxHeight&&o.maxHeight<data.height,isminw=this._isNumber(data.width)&&o.minWidth&&o.minWidth>data.width,isminh=this._isNumber(data.height)&&o.minHeight&&o.minHeight>data.height,dw=this.originalPosition.left+this.originalSize.width,dh=this.originalPosition.top+this.originalSize.height,cw=/sw|nw|w/.test(a),ch=/nw|ne|n/.test(a);if(isminw){data.width=o.minWidth;}if(isminh){data.height=o.minHeight;}if(ismaxw){data.width=o.maxWidth;}if(ismaxh){data.height=o.maxHeight;}if(isminw&&cw){data.left=dw-o.minWidth;}if(ismaxw&&cw){data.left=dw-o.maxWidth;}if(isminh&&ch){data.top=dh-o.minHeight;}if(ismaxh&&ch){data.top=dh-o.maxHeight;}// Fixing jump error on top/left - bug #2330
	if(!data.width&&!data.height&&!data.left&&data.top){data.top=null;}else if(!data.width&&!data.height&&!data.top&&data.left){data.left=null;}return data;},_getPaddingPlusBorderDimensions:function(element){var i=0,widths=[],borders=[element.css("borderTopWidth"),element.css("borderRightWidth"),element.css("borderBottomWidth"),element.css("borderLeftWidth")],paddings=[element.css("paddingTop"),element.css("paddingRight"),element.css("paddingBottom"),element.css("paddingLeft")];for(;i<4;i++){widths[i]=parseFloat(borders[i])||0;widths[i]+=parseFloat(paddings[i])||0;}return {height:widths[0]+widths[2],width:widths[1]+widths[3]};},_proportionallyResize:function(){if(!this._proportionallyResizeElements.length){return;}var prel,i=0,element=this.helper||this.element;for(;i<this._proportionallyResizeElements.length;i++){prel=this._proportionallyResizeElements[i];// TODO: Seems like a bug to cache this.outerDimensions
	// considering that we are in a loop.
	if(!this.outerDimensions){this.outerDimensions=this._getPaddingPlusBorderDimensions(prel);}prel.css({height:element.height()-this.outerDimensions.height||0,width:element.width()-this.outerDimensions.width||0});}},_renderProxy:function(){var el=this.element,o=this.options;this.elementOffset=el.offset();if(this._helper){this.helper=this.helper||$("<div></div>").css({overflow:"hidden"});this._addClass(this.helper,this._helper);this.helper.css({width:this.element.outerWidth(),height:this.element.outerHeight(),position:"absolute",left:this.elementOffset.left+"px",top:this.elementOffset.top+"px",zIndex:++o.zIndex//TODO: Don't modify option
	});this.helper.appendTo("body").disableSelection();}else {this.helper=this.element;}},_change:{e:function(event,dx){return {width:this.originalSize.width+dx};},w:function(event,dx){var cs=this.originalSize,sp=this.originalPosition;return {left:sp.left+dx,width:cs.width-dx};},n:function(event,dx,dy){var cs=this.originalSize,sp=this.originalPosition;return {top:sp.top+dy,height:cs.height-dy};},s:function(event,dx,dy){return {height:this.originalSize.height+dy};},se:function(event,dx,dy){return $.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[event,dx,dy]));},sw:function(event,dx,dy){return $.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[event,dx,dy]));},ne:function(event,dx,dy){return $.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[event,dx,dy]));},nw:function(event,dx,dy){return $.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[event,dx,dy]));}},_propagate:function(n,event){$.ui.plugin.call(this,n,[event,this.ui()]);if(n!=="resize"){this._trigger(n,event,this.ui());}},plugins:{},ui:function(){return {originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition};}});/*
	 * Resizable Extensions
	 */$.ui.plugin.add("resizable","animate",{stop:function(event){var that=$(this).resizable("instance"),o=that.options,pr=that._proportionallyResizeElements,ista=pr.length&&/textarea/i.test(pr[0].nodeName),soffseth=ista&&that._hasScroll(pr[0],"left")?0:that.sizeDiff.height,soffsetw=ista?0:that.sizeDiff.width,style={width:that.size.width-soffsetw,height:that.size.height-soffseth},left=parseFloat(that.element.css("left"))+(that.position.left-that.originalPosition.left)||null,top=parseFloat(that.element.css("top"))+(that.position.top-that.originalPosition.top)||null;that.element.animate($.extend(style,top&&left?{top:top,left:left}:{}),{duration:o.animateDuration,easing:o.animateEasing,step:function(){var data={width:parseFloat(that.element.css("width")),height:parseFloat(that.element.css("height")),top:parseFloat(that.element.css("top")),left:parseFloat(that.element.css("left"))};if(pr&&pr.length){$(pr[0]).css({width:data.width,height:data.height});}// Propagating resize, and updating values for each animation step
	that._updateCache(data);that._propagate("resize",event);}});}});$.ui.plugin.add("resizable","containment",{start:function(){var element,p,co,ch,cw,width,height,that=$(this).resizable("instance"),o=that.options,el=that.element,oc=o.containment,ce=oc instanceof $?oc.get(0):/parent/.test(oc)?el.parent().get(0):oc;if(!ce){return;}that.containerElement=$(ce);if(/document/.test(oc)||oc===document){that.containerOffset={left:0,top:0};that.containerPosition={left:0,top:0};that.parentData={element:$(document),left:0,top:0,width:$(document).width(),height:$(document).height()||document.body.parentNode.scrollHeight};}else {element=$(ce);p=[];$(["Top","Right","Left","Bottom"]).each(function(i,name){p[i]=that._num(element.css("padding"+name));});that.containerOffset=element.offset();that.containerPosition=element.position();that.containerSize={height:element.innerHeight()-p[3],width:element.innerWidth()-p[1]};co=that.containerOffset;ch=that.containerSize.height;cw=that.containerSize.width;width=that._hasScroll(ce,"left")?ce.scrollWidth:cw;height=that._hasScroll(ce)?ce.scrollHeight:ch;that.parentData={element:ce,left:co.left,top:co.top,width:width,height:height};}},resize:function(event){var woset,hoset,isParent,isOffsetRelative,that=$(this).resizable("instance"),o=that.options,co=that.containerOffset,cp=that.position,pRatio=that._aspectRatio||event.shiftKey,cop={top:0,left:0},ce=that.containerElement,continueResize=true;if(ce[0]!==document&&/static/.test(ce.css("position"))){cop=co;}if(cp.left<(that._helper?co.left:0)){that.size.width=that.size.width+(that._helper?that.position.left-co.left:that.position.left-cop.left);if(pRatio){that.size.height=that.size.width/that.aspectRatio;continueResize=false;}that.position.left=o.helper?co.left:0;}if(cp.top<(that._helper?co.top:0)){that.size.height=that.size.height+(that._helper?that.position.top-co.top:that.position.top);if(pRatio){that.size.width=that.size.height*that.aspectRatio;continueResize=false;}that.position.top=that._helper?co.top:0;}isParent=that.containerElement.get(0)===that.element.parent().get(0);isOffsetRelative=/relative|absolute/.test(that.containerElement.css("position"));if(isParent&&isOffsetRelative){that.offset.left=that.parentData.left+that.position.left;that.offset.top=that.parentData.top+that.position.top;}else {that.offset.left=that.element.offset().left;that.offset.top=that.element.offset().top;}woset=Math.abs(that.sizeDiff.width+(that._helper?that.offset.left-cop.left:that.offset.left-co.left));hoset=Math.abs(that.sizeDiff.height+(that._helper?that.offset.top-cop.top:that.offset.top-co.top));if(woset+that.size.width>=that.parentData.width){that.size.width=that.parentData.width-woset;if(pRatio){that.size.height=that.size.width/that.aspectRatio;continueResize=false;}}if(hoset+that.size.height>=that.parentData.height){that.size.height=that.parentData.height-hoset;if(pRatio){that.size.width=that.size.height*that.aspectRatio;continueResize=false;}}if(!continueResize){that.position.left=that.prevPosition.left;that.position.top=that.prevPosition.top;that.size.width=that.prevSize.width;that.size.height=that.prevSize.height;}},stop:function(){var that=$(this).resizable("instance"),o=that.options,co=that.containerOffset,cop=that.containerPosition,ce=that.containerElement,helper=$(that.helper),ho=helper.offset(),w=helper.outerWidth()-that.sizeDiff.width,h=helper.outerHeight()-that.sizeDiff.height;if(that._helper&&!o.animate&&/relative/.test(ce.css("position"))){$(this).css({left:ho.left-cop.left-co.left,width:w,height:h});}if(that._helper&&!o.animate&&/static/.test(ce.css("position"))){$(this).css({left:ho.left-cop.left-co.left,width:w,height:h});}}});$.ui.plugin.add("resizable","alsoResize",{start:function(){var that=$(this).resizable("instance"),o=that.options;$(o.alsoResize).each(function(){var el=$(this);el.data("ui-resizable-alsoresize",{width:parseFloat(el.css("width")),height:parseFloat(el.css("height")),left:parseFloat(el.css("left")),top:parseFloat(el.css("top"))});});},resize:function(event,ui){var that=$(this).resizable("instance"),o=that.options,os=that.originalSize,op=that.originalPosition,delta={height:that.size.height-os.height||0,width:that.size.width-os.width||0,top:that.position.top-op.top||0,left:that.position.left-op.left||0};$(o.alsoResize).each(function(){var el=$(this),start=$(this).data("ui-resizable-alsoresize"),style={},css=el.parents(ui.originalElement[0]).length?["width","height"]:["width","height","top","left"];$.each(css,function(i,prop){var sum=(start[prop]||0)+(delta[prop]||0);if(sum&&sum>=0){style[prop]=sum||null;}});el.css(style);});},stop:function(){$(this).removeData("ui-resizable-alsoresize");}});$.ui.plugin.add("resizable","ghost",{start:function(){var that=$(this).resizable("instance"),cs=that.size;that.ghost=that.originalElement.clone();that.ghost.css({opacity:0.25,display:"block",position:"relative",height:cs.height,width:cs.width,margin:0,left:0,top:0});that._addClass(that.ghost,"ui-resizable-ghost");// DEPRECATED
	// TODO: remove after 1.12
	if($.uiBackCompat!==false&&typeof that.options.ghost==="string"){// Ghost option
	that.ghost.addClass(this.options.ghost);}that.ghost.appendTo(that.helper);},resize:function(){var that=$(this).resizable("instance");if(that.ghost){that.ghost.css({position:"relative",height:that.size.height,width:that.size.width});}},stop:function(){var that=$(this).resizable("instance");if(that.ghost&&that.helper){that.helper.get(0).removeChild(that.ghost.get(0));}}});$.ui.plugin.add("resizable","grid",{resize:function(){var outerDimensions,that=$(this).resizable("instance"),o=that.options,cs=that.size,os=that.originalSize,op=that.originalPosition,a=that.axis,grid=typeof o.grid==="number"?[o.grid,o.grid]:o.grid,gridX=grid[0]||1,gridY=grid[1]||1,ox=Math.round((cs.width-os.width)/gridX)*gridX,oy=Math.round((cs.height-os.height)/gridY)*gridY,newWidth=os.width+ox,newHeight=os.height+oy,isMaxWidth=o.maxWidth&&o.maxWidth<newWidth,isMaxHeight=o.maxHeight&&o.maxHeight<newHeight,isMinWidth=o.minWidth&&o.minWidth>newWidth,isMinHeight=o.minHeight&&o.minHeight>newHeight;o.grid=grid;if(isMinWidth){newWidth+=gridX;}if(isMinHeight){newHeight+=gridY;}if(isMaxWidth){newWidth-=gridX;}if(isMaxHeight){newHeight-=gridY;}if(/^(se|s|e)$/.test(a)){that.size.width=newWidth;that.size.height=newHeight;}else if(/^(ne)$/.test(a)){that.size.width=newWidth;that.size.height=newHeight;that.position.top=op.top-oy;}else if(/^(sw)$/.test(a)){that.size.width=newWidth;that.size.height=newHeight;that.position.left=op.left-ox;}else {if(newHeight-gridY<=0||newWidth-gridX<=0){outerDimensions=that._getPaddingPlusBorderDimensions(this);}if(newHeight-gridY>0){that.size.height=newHeight;that.position.top=op.top-oy;}else {newHeight=gridY-outerDimensions.height;that.size.height=newHeight;that.position.top=op.top+os.height-newHeight;}if(newWidth-gridX>0){that.size.width=newWidth;that.position.left=op.left-ox;}else {newWidth=gridX-outerDimensions.width;that.size.width=newWidth;that.position.left=op.left+os.width-newWidth;}}}});$.ui.resizable;/*!
	 * jQuery UI Dialog 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Dialog
	//>>group: Widgets
	//>>description: Displays customizable dialog windows.
	//>>docs: https://api.jqueryui.com/dialog/
	//>>demos: https://jqueryui.com/dialog/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/dialog.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.dialog",{version:"1.13.3",options:{appendTo:"body",autoOpen:true,buttons:[],classes:{"ui-dialog":"ui-corner-all","ui-dialog-titlebar":"ui-corner-all"},closeOnEscape:true,closeText:"Close",draggable:true,hide:null,height:"auto",maxHeight:null,maxWidth:null,minHeight:150,minWidth:150,modal:false,position:{my:"center",at:"center",of:window,collision:"fit",// Ensure the titlebar is always visible
	using:function(pos){var topOffset=$(this).css(pos).offset().top;if(topOffset<0){$(this).css("top",pos.top-topOffset);}}},resizable:true,show:null,title:null,width:300,// Callbacks
	beforeClose:null,close:null,drag:null,dragStart:null,dragStop:null,focus:null,open:null,resize:null,resizeStart:null,resizeStop:null},sizeRelatedOptions:{buttons:true,height:true,maxHeight:true,maxWidth:true,minHeight:true,minWidth:true,width:true},resizableRelatedOptions:{maxHeight:true,maxWidth:true,minHeight:true,minWidth:true},_create:function(){this.originalCss={display:this.element[0].style.display,width:this.element[0].style.width,minHeight:this.element[0].style.minHeight,maxHeight:this.element[0].style.maxHeight,height:this.element[0].style.height};this.originalPosition={parent:this.element.parent(),index:this.element.parent().children().index(this.element)};this.originalTitle=this.element.attr("title");if(this.options.title==null&&this.originalTitle!=null){this.options.title=this.originalTitle;}// Dialogs can't be disabled
	if(this.options.disabled){this.options.disabled=false;}this._createWrapper();this.element.show().removeAttr("title").appendTo(this.uiDialog);this._addClass("ui-dialog-content","ui-widget-content");this._createTitlebar();this._createButtonPane();if(this.options.draggable&&$.fn.draggable){this._makeDraggable();}if(this.options.resizable&&$.fn.resizable){this._makeResizable();}this._isOpen=false;this._trackFocus();},_init:function(){if(this.options.autoOpen){this.open();}},_appendTo:function(){var element=this.options.appendTo;if(element&&(element.jquery||element.nodeType)){return $(element);}return this.document.find(element||"body").eq(0);},_destroy:function(){var next,originalPosition=this.originalPosition;this._untrackInstance();this._destroyOverlay();this.element.removeUniqueId().css(this.originalCss)// Without detaching first, the following becomes really slow
	.detach();this.uiDialog.remove();if(this.originalTitle){this.element.attr("title",this.originalTitle);}next=originalPosition.parent.children().eq(originalPosition.index);// Don't try to place the dialog next to itself (#8613)
	if(next.length&&next[0]!==this.element[0]){next.before(this.element);}else {originalPosition.parent.append(this.element);}},widget:function(){return this.uiDialog;},disable:$.noop,enable:$.noop,close:function(event){var that=this;if(!this._isOpen||this._trigger("beforeClose",event)===false){return;}this._isOpen=false;this._focusedElement=null;this._destroyOverlay();this._untrackInstance();if(!this.opener.filter(":focusable").trigger("focus").length){// Hiding a focused element doesn't trigger blur in WebKit
	// so in case we have nothing to focus on, explicitly blur the active element
	// https://bugs.webkit.org/show_bug.cgi?id=47182
	$.ui.safeBlur($.ui.safeActiveElement(this.document[0]));}this._hide(this.uiDialog,this.options.hide,function(){that._trigger("close",event);});},isOpen:function(){return this._isOpen;},moveToTop:function(){this._moveToTop();},_moveToTop:function(event,silent){var moved=false,zIndices=this.uiDialog.siblings(".ui-front:visible").map(function(){return +$(this).css("z-index");}).get(),zIndexMax=Math.max.apply(null,zIndices);if(zIndexMax>=+this.uiDialog.css("z-index")){this.uiDialog.css("z-index",zIndexMax+1);moved=true;}if(moved&&!silent){this._trigger("focus",event);}return moved;},open:function(){var that=this;if(this._isOpen){if(this._moveToTop()){this._focusTabbable();}return;}this._isOpen=true;this.opener=$($.ui.safeActiveElement(this.document[0]));this._size();this._position();this._createOverlay();this._moveToTop(null,true);// Ensure the overlay is moved to the top with the dialog, but only when
	// opening. The overlay shouldn't move after the dialog is open so that
	// modeless dialogs opened after the modal dialog stack properly.
	if(this.overlay){this.overlay.css("z-index",this.uiDialog.css("z-index")-1);}this._show(this.uiDialog,this.options.show,function(){that._focusTabbable();that._trigger("focus");});// Track the dialog immediately upon opening in case a focus event
	// somehow occurs outside of the dialog before an element inside the
	// dialog is focused (#10152)
	this._makeFocusTarget();this._trigger("open");},_focusTabbable:function(){// Set focus to the first match:
	// 1. An element that was focused previously
	// 2. First element inside the dialog matching [autofocus]
	// 3. Tabbable element inside the content element
	// 4. Tabbable element inside the buttonpane
	// 5. The close button
	// 6. The dialog itself
	var hasFocus=this._focusedElement;if(!hasFocus){hasFocus=this.element.find("[autofocus]");}if(!hasFocus.length){hasFocus=this.element.find(":tabbable");}if(!hasFocus.length){hasFocus=this.uiDialogButtonPane.find(":tabbable");}if(!hasFocus.length){hasFocus=this.uiDialogTitlebarClose.filter(":tabbable");}if(!hasFocus.length){hasFocus=this.uiDialog;}hasFocus.eq(0).trigger("focus");},_restoreTabbableFocus:function(){var activeElement=$.ui.safeActiveElement(this.document[0]),isActive=this.uiDialog[0]===activeElement||$.contains(this.uiDialog[0],activeElement);if(!isActive){this._focusTabbable();}},_keepFocus:function(event){event.preventDefault();this._restoreTabbableFocus();// support: IE
	// IE <= 8 doesn't prevent moving focus even with event.preventDefault()
	// so we check again later
	this._delay(this._restoreTabbableFocus);},_createWrapper:function(){this.uiDialog=$("<div>").hide().attr({// Setting tabIndex makes the div focusable
	tabIndex:-1,role:"dialog"}).appendTo(this._appendTo());this._addClass(this.uiDialog,"ui-dialog","ui-widget ui-widget-content ui-front");this._on(this.uiDialog,{keydown:function(event){if(this.options.closeOnEscape&&!event.isDefaultPrevented()&&event.keyCode&&event.keyCode===$.ui.keyCode.ESCAPE){event.preventDefault();this.close(event);return;}// Prevent tabbing out of dialogs
	if(event.keyCode!==$.ui.keyCode.TAB||event.isDefaultPrevented()){return;}var tabbables=this.uiDialog.find(":tabbable"),first=tabbables.first(),last=tabbables.last();if((event.target===last[0]||event.target===this.uiDialog[0])&&!event.shiftKey){this._delay(function(){first.trigger("focus");});event.preventDefault();}else if((event.target===first[0]||event.target===this.uiDialog[0])&&event.shiftKey){this._delay(function(){last.trigger("focus");});event.preventDefault();}},mousedown:function(event){if(this._moveToTop(event)){this._focusTabbable();}}});// We assume that any existing aria-describedby attribute means
	// that the dialog content is marked up properly
	// otherwise we brute force the content as the description
	if(!this.element.find("[aria-describedby]").length){this.uiDialog.attr({"aria-describedby":this.element.uniqueId().attr("id")});}},_createTitlebar:function(){var uiDialogTitle;this.uiDialogTitlebar=$("<div>");this._addClass(this.uiDialogTitlebar,"ui-dialog-titlebar","ui-widget-header ui-helper-clearfix");this._on(this.uiDialogTitlebar,{mousedown:function(event){// Don't prevent click on close button (#8838)
	// Focusing a dialog that is partially scrolled out of view
	// causes the browser to scroll it into view, preventing the click event
	if(!$(event.target).closest(".ui-dialog-titlebar-close")){// Dialog isn't getting focus when dragging (#8063)
	this.uiDialog.trigger("focus");}}});// Support: IE
	// Use type="button" to prevent enter keypresses in textboxes from closing the
	// dialog in IE (#9312)
	this.uiDialogTitlebarClose=$("<button type='button'></button>").button({label:$("<a>").text(this.options.closeText).html(),icon:"ui-icon-closethick",showLabel:false}).appendTo(this.uiDialogTitlebar);this._addClass(this.uiDialogTitlebarClose,"ui-dialog-titlebar-close");this._on(this.uiDialogTitlebarClose,{click:function(event){event.preventDefault();this.close(event);}});uiDialogTitle=$("<span>").uniqueId().prependTo(this.uiDialogTitlebar);this._addClass(uiDialogTitle,"ui-dialog-title");this._title(uiDialogTitle);this.uiDialogTitlebar.prependTo(this.uiDialog);this.uiDialog.attr({"aria-labelledby":uiDialogTitle.attr("id")});},_title:function(title){if(this.options.title){title.text(this.options.title);}else {title.html("&#160;");}},_createButtonPane:function(){this.uiDialogButtonPane=$("<div>");this._addClass(this.uiDialogButtonPane,"ui-dialog-buttonpane","ui-widget-content ui-helper-clearfix");this.uiButtonSet=$("<div>").appendTo(this.uiDialogButtonPane);this._addClass(this.uiButtonSet,"ui-dialog-buttonset");this._createButtons();},_createButtons:function(){var that=this,buttons=this.options.buttons;// If we already have a button pane, remove it
	this.uiDialogButtonPane.remove();this.uiButtonSet.empty();if($.isEmptyObject(buttons)||Array.isArray(buttons)&&!buttons.length){this._removeClass(this.uiDialog,"ui-dialog-buttons");return;}$.each(buttons,function(name,props){var click,buttonOptions;props=typeof props==="function"?{click:props,text:name}:props;// Default to a non-submitting button
	props=$.extend({type:"button"},props);// Change the context for the click callback to be the main element
	click=props.click;buttonOptions={icon:props.icon,iconPosition:props.iconPosition,showLabel:props.showLabel,// Deprecated options
	icons:props.icons,text:props.text};delete props.click;delete props.icon;delete props.iconPosition;delete props.showLabel;// Deprecated options
	delete props.icons;if(typeof props.text==="boolean"){delete props.text;}$("<button></button>",props).button(buttonOptions).appendTo(that.uiButtonSet).on("click",function(){click.apply(that.element[0],arguments);});});this._addClass(this.uiDialog,"ui-dialog-buttons");this.uiDialogButtonPane.appendTo(this.uiDialog);},_makeDraggable:function(){var that=this,options=this.options;function filteredUi(ui){return {position:ui.position,offset:ui.offset};}this.uiDialog.draggable({cancel:".ui-dialog-content, .ui-dialog-titlebar-close",handle:".ui-dialog-titlebar",containment:"document",start:function(event,ui){that._addClass($(this),"ui-dialog-dragging");that._blockFrames();that._trigger("dragStart",event,filteredUi(ui));},drag:function(event,ui){that._trigger("drag",event,filteredUi(ui));},stop:function(event,ui){var left=ui.offset.left-that.document.scrollLeft(),top=ui.offset.top-that.document.scrollTop();options.position={my:"left top",at:"left"+(left>=0?"+":"")+left+" "+"top"+(top>=0?"+":"")+top,of:that.window};that._removeClass($(this),"ui-dialog-dragging");that._unblockFrames();that._trigger("dragStop",event,filteredUi(ui));}});},_makeResizable:function(){var that=this,options=this.options,handles=options.resizable,// .ui-resizable has position: relative defined in the stylesheet
	// but dialogs have to use absolute or fixed positioning
	position=this.uiDialog.css("position"),resizeHandles=typeof handles==="string"?handles:"n,e,s,w,se,sw,ne,nw";function filteredUi(ui){return {originalPosition:ui.originalPosition,originalSize:ui.originalSize,position:ui.position,size:ui.size};}this.uiDialog.resizable({cancel:".ui-dialog-content",containment:"document",alsoResize:this.element,maxWidth:options.maxWidth,maxHeight:options.maxHeight,minWidth:options.minWidth,minHeight:this._minHeight(),handles:resizeHandles,start:function(event,ui){that._addClass($(this),"ui-dialog-resizing");that._blockFrames();that._trigger("resizeStart",event,filteredUi(ui));},resize:function(event,ui){that._trigger("resize",event,filteredUi(ui));},stop:function(event,ui){var offset=that.uiDialog.offset(),left=offset.left-that.document.scrollLeft(),top=offset.top-that.document.scrollTop();options.height=that.uiDialog.height();options.width=that.uiDialog.width();options.position={my:"left top",at:"left"+(left>=0?"+":"")+left+" "+"top"+(top>=0?"+":"")+top,of:that.window};that._removeClass($(this),"ui-dialog-resizing");that._unblockFrames();that._trigger("resizeStop",event,filteredUi(ui));}}).css("position",position);},_trackFocus:function(){this._on(this.widget(),{focusin:function(event){this._makeFocusTarget();this._focusedElement=$(event.target);}});},_makeFocusTarget:function(){this._untrackInstance();this._trackingInstances().unshift(this);},_untrackInstance:function(){var instances=this._trackingInstances(),exists=$.inArray(this,instances);if(exists!==-1){instances.splice(exists,1);}},_trackingInstances:function(){var instances=this.document.data("ui-dialog-instances");if(!instances){instances=[];this.document.data("ui-dialog-instances",instances);}return instances;},_minHeight:function(){var options=this.options;return options.height==="auto"?options.minHeight:Math.min(options.minHeight,options.height);},_position:function(){// Need to show the dialog to get the actual offset in the position plugin
	var isVisible=this.uiDialog.is(":visible");if(!isVisible){this.uiDialog.show();}this.uiDialog.position(this.options.position);if(!isVisible){this.uiDialog.hide();}},_setOptions:function(options){var that=this,resize=false,resizableOptions={};$.each(options,function(key,value){that._setOption(key,value);if(key in that.sizeRelatedOptions){resize=true;}if(key in that.resizableRelatedOptions){resizableOptions[key]=value;}});if(resize){this._size();this._position();}if(this.uiDialog.is(":data(ui-resizable)")){this.uiDialog.resizable("option",resizableOptions);}},_setOption:function(key,value){var isDraggable,isResizable,uiDialog=this.uiDialog;if(key==="disabled"){return;}this._super(key,value);if(key==="appendTo"){this.uiDialog.appendTo(this._appendTo());}if(key==="buttons"){this._createButtons();}if(key==="closeText"){this.uiDialogTitlebarClose.button({// Ensure that we always pass a string
	label:$("<a>").text(""+this.options.closeText).html()});}if(key==="draggable"){isDraggable=uiDialog.is(":data(ui-draggable)");if(isDraggable&&!value){uiDialog.draggable("destroy");}if(!isDraggable&&value){this._makeDraggable();}}if(key==="position"){this._position();}if(key==="resizable"){// currently resizable, becoming non-resizable
	isResizable=uiDialog.is(":data(ui-resizable)");if(isResizable&&!value){uiDialog.resizable("destroy");}// Currently resizable, changing handles
	if(isResizable&&typeof value==="string"){uiDialog.resizable("option","handles",value);}// Currently non-resizable, becoming resizable
	if(!isResizable&&value!==false){this._makeResizable();}}if(key==="title"){this._title(this.uiDialogTitlebar.find(".ui-dialog-title"));}},_size:function(){// If the user has resized the dialog, the .ui-dialog and .ui-dialog-content
	// divs will both have width and height set, so we need to reset them
	var nonContentHeight,minContentHeight,maxContentHeight,options=this.options;// Reset content sizing
	this.element.show().css({width:"auto",minHeight:0,maxHeight:"none",height:0});if(options.minWidth>options.width){options.width=options.minWidth;}// Reset wrapper sizing
	// determine the height of all the non-content elements
	nonContentHeight=this.uiDialog.css({height:"auto",width:options.width}).outerHeight();minContentHeight=Math.max(0,options.minHeight-nonContentHeight);maxContentHeight=typeof options.maxHeight==="number"?Math.max(0,options.maxHeight-nonContentHeight):"none";if(options.height==="auto"){this.element.css({minHeight:minContentHeight,maxHeight:maxContentHeight,height:"auto"});}else {this.element.height(Math.max(0,options.height-nonContentHeight));}if(this.uiDialog.is(":data(ui-resizable)")){this.uiDialog.resizable("option","minHeight",this._minHeight());}},_blockFrames:function(){this.iframeBlocks=this.document.find("iframe").map(function(){var iframe=$(this);return $("<div>").css({position:"absolute",width:iframe.outerWidth(),height:iframe.outerHeight()}).appendTo(iframe.parent()).offset(iframe.offset())[0];});},_unblockFrames:function(){if(this.iframeBlocks){this.iframeBlocks.remove();delete this.iframeBlocks;}},_allowInteraction:function(event){if($(event.target).closest(".ui-dialog").length){return true;}// TODO: Remove hack when datepicker implements
	// the .ui-front logic (#8989)
	return !!$(event.target).closest(".ui-datepicker").length;},_createOverlay:function(){if(!this.options.modal){return;}var jqMinor=$.fn.jquery.substring(0,4);// We use a delay in case the overlay is created from an
	// event that we're going to be cancelling (#2804)
	var isOpening=true;this._delay(function(){isOpening=false;});if(!this.document.data("ui-dialog-overlays")){// Prevent use of anchors and inputs
	// This doesn't use `_on()` because it is a shared event handler
	// across all open modal dialogs.
	this.document.on("focusin.ui-dialog",function(event){if(isOpening){return;}var instance=this._trackingInstances()[0];if(!instance._allowInteraction(event)){event.preventDefault();instance._focusTabbable();// Support: jQuery >=3.4 <3.7 only
	// In jQuery 3.4-3.6, there are multiple issues with focus/blur
	// trigger chains or when triggering is done on a hidden element
	// at least once.
	// Trigger focus in a delay in addition if needed to avoid the issues.
	// See https://github.com/jquery/jquery/issues/4382
	// See https://github.com/jquery/jquery/issues/4856
	// See https://github.com/jquery/jquery/issues/4950
	if(jqMinor==="3.4."||jqMinor==="3.5."||jqMinor==="3.6."){instance._delay(instance._restoreTabbableFocus);}}}.bind(this));}this.overlay=$("<div>").appendTo(this._appendTo());this._addClass(this.overlay,null,"ui-widget-overlay ui-front");this._on(this.overlay,{mousedown:"_keepFocus"});this.document.data("ui-dialog-overlays",(this.document.data("ui-dialog-overlays")||0)+1);},_destroyOverlay:function(){if(!this.options.modal){return;}if(this.overlay){var overlays=this.document.data("ui-dialog-overlays")-1;if(!overlays){this.document.off("focusin.ui-dialog");this.document.removeData("ui-dialog-overlays");}else {this.document.data("ui-dialog-overlays",overlays);}this.overlay.remove();this.overlay=null;}}});// DEPRECATED
	// TODO: switch return back to widget declaration at top of file when this is removed
	if($.uiBackCompat!==false){// Backcompat for dialogClass option
	$.widget("ui.dialog",$.ui.dialog,{options:{dialogClass:""},_createWrapper:function(){this._super();this.uiDialog.addClass(this.options.dialogClass);},_setOption:function(key,value){if(key==="dialogClass"){this.uiDialog.removeClass(this.options.dialogClass).addClass(value);}this._superApply(arguments);}});}$.ui.dialog;/*!
	 * jQuery UI Droppable 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Droppable
	//>>group: Interactions
	//>>description: Enables drop targets for draggable elements.
	//>>docs: https://api.jqueryui.com/droppable/
	//>>demos: https://jqueryui.com/droppable/
	$.widget("ui.droppable",{version:"1.13.3",widgetEventPrefix:"drop",options:{accept:"*",addClasses:true,greedy:false,scope:"default",tolerance:"intersect",// Callbacks
	activate:null,deactivate:null,drop:null,out:null,over:null},_create:function(){var proportions,o=this.options,accept=o.accept;this.isover=false;this.isout=true;this.accept=typeof accept==="function"?accept:function(d){return d.is(accept);};this.proportions=function/* valueToWrite */(){if(arguments.length){// Store the droppable's proportions
	proportions=arguments[0];}else {// Retrieve or derive the droppable's proportions
	return proportions?proportions:proportions={width:this.element[0].offsetWidth,height:this.element[0].offsetHeight};}};this._addToManager(o.scope);if(o.addClasses){this._addClass("ui-droppable");}},_addToManager:function(scope){// Add the reference and positions to the manager
	$.ui.ddmanager.droppables[scope]=$.ui.ddmanager.droppables[scope]||[];$.ui.ddmanager.droppables[scope].push(this);},_splice:function(drop){var i=0;for(;i<drop.length;i++){if(drop[i]===this){drop.splice(i,1);}}},_destroy:function(){var drop=$.ui.ddmanager.droppables[this.options.scope];this._splice(drop);},_setOption:function(key,value){if(key==="accept"){this.accept=typeof value==="function"?value:function(d){return d.is(value);};}else if(key==="scope"){var drop=$.ui.ddmanager.droppables[this.options.scope];this._splice(drop);this._addToManager(value);}this._super(key,value);},_activate:function(event){var draggable=$.ui.ddmanager.current;this._addActiveClass();if(draggable){this._trigger("activate",event,this.ui(draggable));}},_deactivate:function(event){var draggable=$.ui.ddmanager.current;this._removeActiveClass();if(draggable){this._trigger("deactivate",event,this.ui(draggable));}},_over:function(event){var draggable=$.ui.ddmanager.current;// Bail if draggable and droppable are same element
	if(!draggable||(draggable.currentItem||draggable.element)[0]===this.element[0]){return;}if(this.accept.call(this.element[0],draggable.currentItem||draggable.element)){this._addHoverClass();this._trigger("over",event,this.ui(draggable));}},_out:function(event){var draggable=$.ui.ddmanager.current;// Bail if draggable and droppable are same element
	if(!draggable||(draggable.currentItem||draggable.element)[0]===this.element[0]){return;}if(this.accept.call(this.element[0],draggable.currentItem||draggable.element)){this._removeHoverClass();this._trigger("out",event,this.ui(draggable));}},_drop:function(event,custom){var draggable=custom||$.ui.ddmanager.current,childrenIntersection=false;// Bail if draggable and droppable are same element
	if(!draggable||(draggable.currentItem||draggable.element)[0]===this.element[0]){return false;}this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function(){var inst=$(this).droppable("instance");if(inst.options.greedy&&!inst.options.disabled&&inst.options.scope===draggable.options.scope&&inst.accept.call(inst.element[0],draggable.currentItem||draggable.element)&&$.ui.intersect(draggable,$.extend(inst,{offset:inst.element.offset()}),inst.options.tolerance,event)){childrenIntersection=true;return false;}});if(childrenIntersection){return false;}if(this.accept.call(this.element[0],draggable.currentItem||draggable.element)){this._removeActiveClass();this._removeHoverClass();this._trigger("drop",event,this.ui(draggable));return this.element;}return false;},ui:function(c){return {draggable:c.currentItem||c.element,helper:c.helper,position:c.position,offset:c.positionAbs};},// Extension points just to make backcompat sane and avoid duplicating logic
	// TODO: Remove in 1.14 along with call to it below
	_addHoverClass:function(){this._addClass("ui-droppable-hover");},_removeHoverClass:function(){this._removeClass("ui-droppable-hover");},_addActiveClass:function(){this._addClass("ui-droppable-active");},_removeActiveClass:function(){this._removeClass("ui-droppable-active");}});$.ui.intersect=function(){function isOverAxis(x,reference,size){return x>=reference&&x<reference+size;}return function(draggable,droppable,toleranceMode,event){if(!droppable.offset){return false;}var x1=(draggable.positionAbs||draggable.position.absolute).left+draggable.margins.left,y1=(draggable.positionAbs||draggable.position.absolute).top+draggable.margins.top,x2=x1+draggable.helperProportions.width,y2=y1+draggable.helperProportions.height,l=droppable.offset.left,t=droppable.offset.top,r=l+droppable.proportions().width,b=t+droppable.proportions().height;switch(toleranceMode){case"fit":return l<=x1&&x2<=r&&t<=y1&&y2<=b;case"intersect":return l<x1+draggable.helperProportions.width/2&&// Right Half
	x2-draggable.helperProportions.width/2<r&&// Left Half
	t<y1+draggable.helperProportions.height/2&&// Bottom Half
	y2-draggable.helperProportions.height/2<b;// Top Half
	case"pointer":return isOverAxis(event.pageY,t,droppable.proportions().height)&&isOverAxis(event.pageX,l,droppable.proportions().width);case"touch":return (y1>=t&&y1<=b||// Top edge touching
	y2>=t&&y2<=b||// Bottom edge touching
	y1<t&&y2>b// Surrounded vertically
	)&&(x1>=l&&x1<=r||// Left edge touching
	x2>=l&&x2<=r||// Right edge touching
	x1<l&&x2>r// Surrounded horizontally
	);default:return false;}};}();/*
		This manager tracks offsets of draggables and droppables
	*/$.ui.ddmanager={current:null,droppables:{"default":[]},prepareOffsets:function(t,event){var i,j,m=$.ui.ddmanager.droppables[t.options.scope]||[],type=event?event.type:null,// workaround for #2317
	list=(t.currentItem||t.element).find(":data(ui-droppable)").addBack();droppablesLoop:for(i=0;i<m.length;i++){// No disabled and non-accepted
	if(m[i].options.disabled||t&&!m[i].accept.call(m[i].element[0],t.currentItem||t.element)){continue;}// Filter out elements in the current dragged item
	for(j=0;j<list.length;j++){if(list[j]===m[i].element[0]){m[i].proportions().height=0;continue droppablesLoop;}}m[i].visible=m[i].element.css("display")!=="none";if(!m[i].visible){continue;}// Activate the droppable if used directly from draggables
	if(type==="mousedown"){m[i]._activate.call(m[i],event);}m[i].offset=m[i].element.offset();m[i].proportions({width:m[i].element[0].offsetWidth,height:m[i].element[0].offsetHeight});}},drop:function(draggable,event){var dropped=false;// Create a copy of the droppables in case the list changes during the drop (#9116)
	$.each(($.ui.ddmanager.droppables[draggable.options.scope]||[]).slice(),function(){if(!this.options){return;}if(!this.options.disabled&&this.visible&&$.ui.intersect(draggable,this,this.options.tolerance,event)){dropped=this._drop.call(this,event)||dropped;}if(!this.options.disabled&&this.visible&&this.accept.call(this.element[0],draggable.currentItem||draggable.element)){this.isout=true;this.isover=false;this._deactivate.call(this,event);}});return dropped;},dragStart:function(draggable,event){// Listen for scrolling so that if the dragging causes scrolling the position of the
	// droppables can be recalculated (see #5003)
	draggable.element.parentsUntil("body").on("scroll.droppable",function(){if(!draggable.options.refreshPositions){$.ui.ddmanager.prepareOffsets(draggable,event);}});},drag:function(draggable,event){// If you have a highly dynamic page, you might try this option. It renders positions
	// every time you move the mouse.
	if(draggable.options.refreshPositions){$.ui.ddmanager.prepareOffsets(draggable,event);}// Run through all droppables and check their positions based on specific tolerance options
	$.each($.ui.ddmanager.droppables[draggable.options.scope]||[],function(){if(this.options.disabled||this.greedyChild||!this.visible){return;}var parentInstance,scope,parent,intersects=$.ui.intersect(draggable,this,this.options.tolerance,event),c=!intersects&&this.isover?"isout":intersects&&!this.isover?"isover":null;if(!c){return;}if(this.options.greedy){// find droppable parents with same scope
	scope=this.options.scope;parent=this.element.parents(":data(ui-droppable)").filter(function(){return $(this).droppable("instance").options.scope===scope;});if(parent.length){parentInstance=$(parent[0]).droppable("instance");parentInstance.greedyChild=c==="isover";}}// We just moved into a greedy child
	if(parentInstance&&c==="isover"){parentInstance.isover=false;parentInstance.isout=true;parentInstance._out.call(parentInstance,event);}this[c]=true;this[c==="isout"?"isover":"isout"]=false;this[c==="isover"?"_over":"_out"].call(this,event);// We just moved out of a greedy child
	if(parentInstance&&c==="isout"){parentInstance.isout=false;parentInstance.isover=true;parentInstance._over.call(parentInstance,event);}});},dragStop:function(draggable,event){draggable.element.parentsUntil("body").off("scroll.droppable");// Call prepareOffsets one final time since IE does not fire return scroll events when
	// overflow was caused by drag (see #5003)
	if(!draggable.options.refreshPositions){$.ui.ddmanager.prepareOffsets(draggable,event);}}};// DEPRECATED
	// TODO: switch return back to widget declaration at top of file when this is removed
	if($.uiBackCompat!==false){// Backcompat for activeClass and hoverClass options
	$.widget("ui.droppable",$.ui.droppable,{options:{hoverClass:false,activeClass:false},_addActiveClass:function(){this._super();if(this.options.activeClass){this.element.addClass(this.options.activeClass);}},_removeActiveClass:function(){this._super();if(this.options.activeClass){this.element.removeClass(this.options.activeClass);}},_addHoverClass:function(){this._super();if(this.options.hoverClass){this.element.addClass(this.options.hoverClass);}},_removeHoverClass:function(){this._super();if(this.options.hoverClass){this.element.removeClass(this.options.hoverClass);}}});}$.ui.droppable;/*!
	 * jQuery UI Progressbar 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Progressbar
	//>>group: Widgets
	/* eslint-disable max-len *///>>description: Displays a status indicator for loading state, standard percentage, and other progress indicators.
	/* eslint-enable max-len *///>>docs: https://api.jqueryui.com/progressbar/
	//>>demos: https://jqueryui.com/progressbar/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/progressbar.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.progressbar",{version:"1.13.3",options:{classes:{"ui-progressbar":"ui-corner-all","ui-progressbar-value":"ui-corner-left","ui-progressbar-complete":"ui-corner-right"},max:100,value:0,change:null,complete:null},min:0,_create:function(){// Constrain initial value
	this.oldValue=this.options.value=this._constrainedValue();this.element.attr({// Only set static values; aria-valuenow and aria-valuemax are
	// set inside _refreshValue()
	role:"progressbar","aria-valuemin":this.min});this._addClass("ui-progressbar","ui-widget ui-widget-content");this.valueDiv=$("<div>").appendTo(this.element);this._addClass(this.valueDiv,"ui-progressbar-value","ui-widget-header");this._refreshValue();},_destroy:function(){this.element.removeAttr("role aria-valuemin aria-valuemax aria-valuenow");this.valueDiv.remove();},value:function(newValue){if(newValue===undefined){return this.options.value;}this.options.value=this._constrainedValue(newValue);this._refreshValue();},_constrainedValue:function(newValue){if(newValue===undefined){newValue=this.options.value;}this.indeterminate=newValue===false;// Sanitize value
	if(typeof newValue!=="number"){newValue=0;}return this.indeterminate?false:Math.min(this.options.max,Math.max(this.min,newValue));},_setOptions:function(options){// Ensure "value" option is set after other values (like max)
	var value=options.value;delete options.value;this._super(options);this.options.value=this._constrainedValue(value);this._refreshValue();},_setOption:function(key,value){if(key==="max"){// Don't allow a max less than min
	value=Math.max(this.min,value);}this._super(key,value);},_setOptionDisabled:function(value){this._super(value);this.element.attr("aria-disabled",value);this._toggleClass(null,"ui-state-disabled",!!value);},_percentage:function(){return this.indeterminate?100:100*(this.options.value-this.min)/(this.options.max-this.min);},_refreshValue:function(){var value=this.options.value,percentage=this._percentage();this.valueDiv.toggle(this.indeterminate||value>this.min).width(percentage.toFixed(0)+"%");this._toggleClass(this.valueDiv,"ui-progressbar-complete",null,value===this.options.max)._toggleClass("ui-progressbar-indeterminate",null,this.indeterminate);if(this.indeterminate){this.element.removeAttr("aria-valuenow");if(!this.overlayDiv){this.overlayDiv=$("<div>").appendTo(this.valueDiv);this._addClass(this.overlayDiv,"ui-progressbar-overlay");}}else {this.element.attr({"aria-valuemax":this.options.max,"aria-valuenow":value});if(this.overlayDiv){this.overlayDiv.remove();this.overlayDiv=null;}}if(this.oldValue!==value){this.oldValue=value;this._trigger("change");}if(value===this.options.max){this._trigger("complete");}}});/*!
	 * jQuery UI Selectable 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Selectable
	//>>group: Interactions
	//>>description: Allows groups of elements to be selected with the mouse.
	//>>docs: https://api.jqueryui.com/selectable/
	//>>demos: https://jqueryui.com/selectable/
	//>>css.structure: ../../themes/base/selectable.css
	$.widget("ui.selectable",$.ui.mouse,{version:"1.13.3",options:{appendTo:"body",autoRefresh:true,distance:0,filter:"*",tolerance:"touch",// Callbacks
	selected:null,selecting:null,start:null,stop:null,unselected:null,unselecting:null},_create:function(){var that=this;this._addClass("ui-selectable");this.dragged=false;// Cache selectee children based on filter
	this.refresh=function(){that.elementPos=$(that.element[0]).offset();that.selectees=$(that.options.filter,that.element[0]);that._addClass(that.selectees,"ui-selectee");that.selectees.each(function(){var $this=$(this),selecteeOffset=$this.offset(),pos={left:selecteeOffset.left-that.elementPos.left,top:selecteeOffset.top-that.elementPos.top};$.data(this,"selectable-item",{element:this,$element:$this,left:pos.left,top:pos.top,right:pos.left+$this.outerWidth(),bottom:pos.top+$this.outerHeight(),startselected:false,selected:$this.hasClass("ui-selected"),selecting:$this.hasClass("ui-selecting"),unselecting:$this.hasClass("ui-unselecting")});});};this.refresh();this._mouseInit();this.helper=$("<div>");this._addClass(this.helper,"ui-selectable-helper");},_destroy:function(){this.selectees.removeData("selectable-item");this._mouseDestroy();},_mouseStart:function(event){var that=this,options=this.options;this.opos=[event.pageX,event.pageY];this.elementPos=$(this.element[0]).offset();if(this.options.disabled){return;}this.selectees=$(options.filter,this.element[0]);this._trigger("start",event);$(options.appendTo).append(this.helper);// position helper (lasso)
	this.helper.css({"left":event.pageX,"top":event.pageY,"width":0,"height":0});if(options.autoRefresh){this.refresh();}this.selectees.filter(".ui-selected").each(function(){var selectee=$.data(this,"selectable-item");selectee.startselected=true;if(!event.metaKey&&!event.ctrlKey){that._removeClass(selectee.$element,"ui-selected");selectee.selected=false;that._addClass(selectee.$element,"ui-unselecting");selectee.unselecting=true;// selectable UNSELECTING callback
	that._trigger("unselecting",event,{unselecting:selectee.element});}});$(event.target).parents().addBack().each(function(){var doSelect,selectee=$.data(this,"selectable-item");if(selectee){doSelect=!event.metaKey&&!event.ctrlKey||!selectee.$element.hasClass("ui-selected");that._removeClass(selectee.$element,doSelect?"ui-unselecting":"ui-selected")._addClass(selectee.$element,doSelect?"ui-selecting":"ui-unselecting");selectee.unselecting=!doSelect;selectee.selecting=doSelect;selectee.selected=doSelect;// selectable (UN)SELECTING callback
	if(doSelect){that._trigger("selecting",event,{selecting:selectee.element});}else {that._trigger("unselecting",event,{unselecting:selectee.element});}return false;}});},_mouseDrag:function(event){this.dragged=true;if(this.options.disabled){return;}var tmp,that=this,options=this.options,x1=this.opos[0],y1=this.opos[1],x2=event.pageX,y2=event.pageY;if(x1>x2){tmp=x2;x2=x1;x1=tmp;}if(y1>y2){tmp=y2;y2=y1;y1=tmp;}this.helper.css({left:x1,top:y1,width:x2-x1,height:y2-y1});this.selectees.each(function(){var selectee=$.data(this,"selectable-item"),hit=false,offset={};//prevent helper from being selected if appendTo: selectable
	if(!selectee||selectee.element===that.element[0]){return;}offset.left=selectee.left+that.elementPos.left;offset.right=selectee.right+that.elementPos.left;offset.top=selectee.top+that.elementPos.top;offset.bottom=selectee.bottom+that.elementPos.top;if(options.tolerance==="touch"){hit=!(offset.left>x2||offset.right<x1||offset.top>y2||offset.bottom<y1);}else if(options.tolerance==="fit"){hit=offset.left>x1&&offset.right<x2&&offset.top>y1&&offset.bottom<y2;}if(hit){// SELECT
	if(selectee.selected){that._removeClass(selectee.$element,"ui-selected");selectee.selected=false;}if(selectee.unselecting){that._removeClass(selectee.$element,"ui-unselecting");selectee.unselecting=false;}if(!selectee.selecting){that._addClass(selectee.$element,"ui-selecting");selectee.selecting=true;// selectable SELECTING callback
	that._trigger("selecting",event,{selecting:selectee.element});}}else {// UNSELECT
	if(selectee.selecting){if((event.metaKey||event.ctrlKey)&&selectee.startselected){that._removeClass(selectee.$element,"ui-selecting");selectee.selecting=false;that._addClass(selectee.$element,"ui-selected");selectee.selected=true;}else {that._removeClass(selectee.$element,"ui-selecting");selectee.selecting=false;if(selectee.startselected){that._addClass(selectee.$element,"ui-unselecting");selectee.unselecting=true;}// selectable UNSELECTING callback
	that._trigger("unselecting",event,{unselecting:selectee.element});}}if(selectee.selected){if(!event.metaKey&&!event.ctrlKey&&!selectee.startselected){that._removeClass(selectee.$element,"ui-selected");selectee.selected=false;that._addClass(selectee.$element,"ui-unselecting");selectee.unselecting=true;// selectable UNSELECTING callback
	that._trigger("unselecting",event,{unselecting:selectee.element});}}}});return false;},_mouseStop:function(event){var that=this;this.dragged=false;$(".ui-unselecting",this.element[0]).each(function(){var selectee=$.data(this,"selectable-item");that._removeClass(selectee.$element,"ui-unselecting");selectee.unselecting=false;selectee.startselected=false;that._trigger("unselected",event,{unselected:selectee.element});});$(".ui-selecting",this.element[0]).each(function(){var selectee=$.data(this,"selectable-item");that._removeClass(selectee.$element,"ui-selecting")._addClass(selectee.$element,"ui-selected");selectee.selecting=false;selectee.selected=true;selectee.startselected=true;that._trigger("selected",event,{selected:selectee.element});});this._trigger("stop",event);this.helper.remove();return false;}});/*!
	 * jQuery UI Selectmenu 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Selectmenu
	//>>group: Widgets
	/* eslint-disable max-len *///>>description: Duplicates and extends the functionality of a native HTML select element, allowing it to be customizable in behavior and appearance far beyond the limitations of a native select.
	/* eslint-enable max-len *///>>docs: https://api.jqueryui.com/selectmenu/
	//>>demos: https://jqueryui.com/selectmenu/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/selectmenu.css, ../../themes/base/button.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.selectmenu",[$.ui.formResetMixin,{version:"1.13.3",defaultElement:"<select>",options:{appendTo:null,classes:{"ui-selectmenu-button-open":"ui-corner-top","ui-selectmenu-button-closed":"ui-corner-all"},disabled:null,icons:{button:"ui-icon-triangle-1-s"},position:{my:"left top",at:"left bottom",collision:"none"},width:false,// Callbacks
	change:null,close:null,focus:null,open:null,select:null},_create:function(){var selectmenuId=this.element.uniqueId().attr("id");this.ids={element:selectmenuId,button:selectmenuId+"-button",menu:selectmenuId+"-menu"};this._drawButton();this._drawMenu();this._bindFormResetHandler();this._rendered=false;this.menuItems=$();},_drawButton:function(){var icon,that=this,item=this._parseOption(this.element.find("option:selected"),this.element[0].selectedIndex);// Associate existing label with the new button
	this.labels=this.element.labels().attr("for",this.ids.button);this._on(this.labels,{click:function(event){this.button.trigger("focus");event.preventDefault();}});// Hide original select element
	this.element.hide();// Create button
	this.button=$("<span>",{tabindex:this.options.disabled?-1:0,id:this.ids.button,role:"combobox","aria-expanded":"false","aria-autocomplete":"list","aria-owns":this.ids.menu,"aria-haspopup":"true",title:this.element.attr("title")}).insertAfter(this.element);this._addClass(this.button,"ui-selectmenu-button ui-selectmenu-button-closed","ui-button ui-widget");icon=$("<span>").appendTo(this.button);this._addClass(icon,"ui-selectmenu-icon","ui-icon "+this.options.icons.button);this.buttonItem=this._renderButtonItem(item).appendTo(this.button);if(this.options.width!==false){this._resizeButton();}this._on(this.button,this._buttonEvents);this.button.one("focusin",function(){// Delay rendering the menu items until the button receives focus.
	// The menu may have already been rendered via a programmatic open.
	if(!that._rendered){that._refreshMenu();}});},_drawMenu:function(){var that=this;// Create menu
	this.menu=$("<ul>",{"aria-hidden":"true","aria-labelledby":this.ids.button,id:this.ids.menu});// Wrap menu
	this.menuWrap=$("<div>").append(this.menu);this._addClass(this.menuWrap,"ui-selectmenu-menu","ui-front");this.menuWrap.appendTo(this._appendTo());// Initialize menu widget
	this.menuInstance=this.menu.menu({classes:{"ui-menu":"ui-corner-bottom"},role:"listbox",select:function(event,ui){event.preventDefault();// Support: IE8
	// If the item was selected via a click, the text selection
	// will be destroyed in IE
	that._setSelection();that._select(ui.item.data("ui-selectmenu-item"),event);},focus:function(event,ui){var item=ui.item.data("ui-selectmenu-item");// Prevent inital focus from firing and check if its a newly focused item
	if(that.focusIndex!=null&&item.index!==that.focusIndex){that._trigger("focus",event,{item:item});if(!that.isOpen){that._select(item,event);}}that.focusIndex=item.index;that.button.attr("aria-activedescendant",that.menuItems.eq(item.index).attr("id"));}}).menu("instance");// Don't close the menu on mouseleave
	this.menuInstance._off(this.menu,"mouseleave");// Cancel the menu's collapseAll on document click
	this.menuInstance._closeOnDocumentClick=function(){return false;};// Selects often contain empty items, but never contain dividers
	this.menuInstance._isDivider=function(){return false;};},refresh:function(){this._refreshMenu();this.buttonItem.replaceWith(this.buttonItem=this._renderButtonItem(// Fall back to an empty object in case there are no options
	this._getSelectedItem().data("ui-selectmenu-item")||{}));if(this.options.width===null){this._resizeButton();}},_refreshMenu:function(){var item,options=this.element.find("option");this.menu.empty();this._parseOptions(options);this._renderMenu(this.menu,this.items);this.menuInstance.refresh();this.menuItems=this.menu.find("li").not(".ui-selectmenu-optgroup").find(".ui-menu-item-wrapper");this._rendered=true;if(!options.length){return;}item=this._getSelectedItem();// Update the menu to have the correct item focused
	this.menuInstance.focus(null,item);this._setAria(item.data("ui-selectmenu-item"));// Set disabled state
	this._setOption("disabled",this.element.prop("disabled"));},open:function(event){if(this.options.disabled){return;}// If this is the first time the menu is being opened, render the items
	if(!this._rendered){this._refreshMenu();}else {// Menu clears focus on close, reset focus to selected item
	this._removeClass(this.menu.find(".ui-state-active"),null,"ui-state-active");this.menuInstance.focus(null,this._getSelectedItem());}// If there are no options, don't open the menu
	if(!this.menuItems.length){return;}this.isOpen=true;this._toggleAttr();this._resizeMenu();this._position();this._on(this.document,this._documentClick);this._trigger("open",event);},_position:function(){this.menuWrap.position($.extend({of:this.button},this.options.position));},close:function(event){if(!this.isOpen){return;}this.isOpen=false;this._toggleAttr();this.range=null;this._off(this.document);this._trigger("close",event);},widget:function(){return this.button;},menuWidget:function(){return this.menu;},_renderButtonItem:function(item){var buttonItem=$("<span>");this._setText(buttonItem,item.label);this._addClass(buttonItem,"ui-selectmenu-text");return buttonItem;},_renderMenu:function(ul,items){var that=this,currentOptgroup="";$.each(items,function(index,item){var li;if(item.optgroup!==currentOptgroup){li=$("<li>",{text:item.optgroup});that._addClass(li,"ui-selectmenu-optgroup","ui-menu-divider"+(item.element.parent("optgroup").prop("disabled")?" ui-state-disabled":""));li.appendTo(ul);currentOptgroup=item.optgroup;}that._renderItemData(ul,item);});},_renderItemData:function(ul,item){return this._renderItem(ul,item).data("ui-selectmenu-item",item);},_renderItem:function(ul,item){var li=$("<li>"),wrapper=$("<div>",{title:item.element.attr("title")});if(item.disabled){this._addClass(li,null,"ui-state-disabled");}if(item.hidden){li.prop("hidden",true);}else {this._setText(wrapper,item.label);}return li.append(wrapper).appendTo(ul);},_setText:function(element,value){if(value){element.text(value);}else {element.html("&#160;");}},_move:function(direction,event){var item,next,filter=".ui-menu-item";if(this.isOpen){item=this.menuItems.eq(this.focusIndex).parent("li");}else {item=this.menuItems.eq(this.element[0].selectedIndex).parent("li");filter+=":not(.ui-state-disabled)";}if(direction==="first"||direction==="last"){next=item[direction==="first"?"prevAll":"nextAll"](filter).eq(-1);}else {next=item[direction+"All"](filter).eq(0);}if(next.length){this.menuInstance.focus(event,next);}},_getSelectedItem:function(){return this.menuItems.eq(this.element[0].selectedIndex).parent("li");},_toggle:function(event){this[this.isOpen?"close":"open"](event);},_setSelection:function(){var selection;if(!this.range){return;}if(window.getSelection){selection=window.getSelection();selection.removeAllRanges();selection.addRange(this.range);// Support: IE8
	}else {this.range.select();}// Support: IE
	// Setting the text selection kills the button focus in IE, but
	// restoring the focus doesn't kill the selection.
	this.button.trigger("focus");},_documentClick:{mousedown:function(event){if(!this.isOpen){return;}if(!$(event.target).closest(".ui-selectmenu-menu, #"+$.escapeSelector(this.ids.button)).length){this.close(event);}}},_buttonEvents:{// Prevent text selection from being reset when interacting with the selectmenu (#10144)
	mousedown:function(){var selection;if(window.getSelection){selection=window.getSelection();if(selection.rangeCount){this.range=selection.getRangeAt(0);}// Support: IE8
	}else {this.range=document.selection.createRange();}},click:function(event){this._setSelection();this._toggle(event);},keydown:function(event){var preventDefault=true;switch(event.keyCode){case $.ui.keyCode.TAB:case $.ui.keyCode.ESCAPE:this.close(event);preventDefault=false;break;case $.ui.keyCode.ENTER:if(this.isOpen){this._selectFocusedItem(event);}break;case $.ui.keyCode.UP:if(event.altKey){this._toggle(event);}else {this._move("prev",event);}break;case $.ui.keyCode.DOWN:if(event.altKey){this._toggle(event);}else {this._move("next",event);}break;case $.ui.keyCode.SPACE:if(this.isOpen){this._selectFocusedItem(event);}else {this._toggle(event);}break;case $.ui.keyCode.LEFT:this._move("prev",event);break;case $.ui.keyCode.RIGHT:this._move("next",event);break;case $.ui.keyCode.HOME:case $.ui.keyCode.PAGE_UP:this._move("first",event);break;case $.ui.keyCode.END:case $.ui.keyCode.PAGE_DOWN:this._move("last",event);break;default:this.menu.trigger(event);preventDefault=false;}if(preventDefault){event.preventDefault();}}},_selectFocusedItem:function(event){var item=this.menuItems.eq(this.focusIndex).parent("li");if(!item.hasClass("ui-state-disabled")){this._select(item.data("ui-selectmenu-item"),event);}},_select:function(item,event){var oldIndex=this.element[0].selectedIndex;// Change native select element
	this.element[0].selectedIndex=item.index;this.buttonItem.replaceWith(this.buttonItem=this._renderButtonItem(item));this._setAria(item);this._trigger("select",event,{item:item});if(item.index!==oldIndex){this._trigger("change",event,{item:item});}this.close(event);},_setAria:function(item){var id=this.menuItems.eq(item.index).attr("id");this.button.attr({"aria-labelledby":id,"aria-activedescendant":id});this.menu.attr("aria-activedescendant",id);},_setOption:function(key,value){if(key==="icons"){var icon=this.button.find("span.ui-icon");this._removeClass(icon,null,this.options.icons.button)._addClass(icon,null,value.button);}this._super(key,value);if(key==="appendTo"){this.menuWrap.appendTo(this._appendTo());}if(key==="width"){this._resizeButton();}},_setOptionDisabled:function(value){this._super(value);this.menuInstance.option("disabled",value);this.button.attr("aria-disabled",value);this._toggleClass(this.button,null,"ui-state-disabled",value);this.element.prop("disabled",value);if(value){this.button.attr("tabindex",-1);this.close();}else {this.button.attr("tabindex",0);}},_appendTo:function(){var element=this.options.appendTo;if(element){element=element.jquery||element.nodeType?$(element):this.document.find(element).eq(0);}if(!element||!element[0]){element=this.element.closest(".ui-front, dialog");}if(!element.length){element=this.document[0].body;}return element;},_toggleAttr:function(){this.button.attr("aria-expanded",this.isOpen);// We can't use two _toggleClass() calls here, because we need to make sure
	// we always remove classes first and add them second, otherwise if both classes have the
	// same theme class, it will be removed after we add it.
	this._removeClass(this.button,"ui-selectmenu-button-"+(this.isOpen?"closed":"open"))._addClass(this.button,"ui-selectmenu-button-"+(this.isOpen?"open":"closed"))._toggleClass(this.menuWrap,"ui-selectmenu-open",null,this.isOpen);this.menu.attr("aria-hidden",!this.isOpen);},_resizeButton:function(){var width=this.options.width;// For `width: false`, just remove inline style and stop
	if(width===false){this.button.css("width","");return;}// For `width: null`, match the width of the original element
	if(width===null){width=this.element.show().outerWidth();this.element.hide();}this.button.outerWidth(width);},_resizeMenu:function(){this.menu.outerWidth(Math.max(this.button.outerWidth(),// Support: IE10
	// IE10 wraps long text (possibly a rounding bug)
	// so we add 1px to avoid the wrapping
	this.menu.width("").outerWidth()+1));},_getCreateOptions:function(){var options=this._super();options.disabled=this.element.prop("disabled");return options;},_parseOptions:function(options){var that=this,data=[];options.each(function(index,item){data.push(that._parseOption($(item),index));});this.items=data;},_parseOption:function(option,index){var optgroup=option.parent("optgroup");return {element:option,index:index,value:option.val(),label:option.text(),hidden:optgroup.prop("hidden")||option.prop("hidden"),optgroup:optgroup.attr("label")||"",disabled:optgroup.prop("disabled")||option.prop("disabled")};},_destroy:function(){this._unbindFormResetHandler();this.menuWrap.remove();this.button.remove();this.element.show();this.element.removeUniqueId();this.labels.attr("for",this.ids.element);}}]);/*!
	 * jQuery UI Slider 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Slider
	//>>group: Widgets
	//>>description: Displays a flexible slider with ranges and accessibility via keyboard.
	//>>docs: https://api.jqueryui.com/slider/
	//>>demos: https://jqueryui.com/slider/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/slider.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.slider",$.ui.mouse,{version:"1.13.3",widgetEventPrefix:"slide",options:{animate:false,classes:{"ui-slider":"ui-corner-all","ui-slider-handle":"ui-corner-all",// Note: ui-widget-header isn't the most fittingly semantic framework class for this
	// element, but worked best visually with a variety of themes
	"ui-slider-range":"ui-corner-all ui-widget-header"},distance:0,max:100,min:0,orientation:"horizontal",range:false,step:1,value:0,values:null,// Callbacks
	change:null,slide:null,start:null,stop:null},// Number of pages in a slider
	// (how many times can you page up/down to go through the whole range)
	numPages:5,_create:function(){this._keySliding=false;this._mouseSliding=false;this._animateOff=true;this._handleIndex=null;this._detectOrientation();this._mouseInit();this._calculateNewMax();this._addClass("ui-slider ui-slider-"+this.orientation,"ui-widget ui-widget-content");this._refresh();this._animateOff=false;},_refresh:function(){this._createRange();this._createHandles();this._setupEvents();this._refreshValue();},_createHandles:function(){var i,handleCount,options=this.options,existingHandles=this.element.find(".ui-slider-handle"),handle="<span tabindex='0'></span>",handles=[];handleCount=options.values&&options.values.length||1;if(existingHandles.length>handleCount){existingHandles.slice(handleCount).remove();existingHandles=existingHandles.slice(0,handleCount);}for(i=existingHandles.length;i<handleCount;i++){handles.push(handle);}this.handles=existingHandles.add($(handles.join("")).appendTo(this.element));this._addClass(this.handles,"ui-slider-handle","ui-state-default");this.handle=this.handles.eq(0);this.handles.each(function(i){$(this).data("ui-slider-handle-index",i).attr("tabIndex",0);});},_createRange:function(){var options=this.options;if(options.range){if(options.range===true){if(!options.values){options.values=[this._valueMin(),this._valueMin()];}else if(options.values.length&&options.values.length!==2){options.values=[options.values[0],options.values[0]];}else if(Array.isArray(options.values)){options.values=options.values.slice(0);}}if(!this.range||!this.range.length){this.range=$("<div>").appendTo(this.element);this._addClass(this.range,"ui-slider-range");}else {this._removeClass(this.range,"ui-slider-range-min ui-slider-range-max");// Handle range switching from true to min/max
	this.range.css({"left":"","bottom":""});}if(options.range==="min"||options.range==="max"){this._addClass(this.range,"ui-slider-range-"+options.range);}}else {if(this.range){this.range.remove();}this.range=null;}},_setupEvents:function(){this._off(this.handles);this._on(this.handles,this._handleEvents);this._hoverable(this.handles);this._focusable(this.handles);},_destroy:function(){this.handles.remove();if(this.range){this.range.remove();}this._mouseDestroy();},_mouseCapture:function(event){var position,normValue,distance,closestHandle,index,allowed,offset,mouseOverHandle,that=this,o=this.options;if(o.disabled){return false;}this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()};this.elementOffset=this.element.offset();position={x:event.pageX,y:event.pageY};normValue=this._normValueFromMouse(position);distance=this._valueMax()-this._valueMin()+1;this.handles.each(function(i){var thisDistance=Math.abs(normValue-that.values(i));if(distance>thisDistance||distance===thisDistance&&(i===that._lastChangedValue||that.values(i)===o.min)){distance=thisDistance;closestHandle=$(this);index=i;}});allowed=this._start(event,index);if(allowed===false){return false;}this._mouseSliding=true;this._handleIndex=index;this._addClass(closestHandle,null,"ui-state-active");closestHandle.trigger("focus");offset=closestHandle.offset();mouseOverHandle=!$(event.target).parents().addBack().is(".ui-slider-handle");this._clickOffset=mouseOverHandle?{left:0,top:0}:{left:event.pageX-offset.left-closestHandle.width()/2,top:event.pageY-offset.top-closestHandle.height()/2-(parseInt(closestHandle.css("borderTopWidth"),10)||0)-(parseInt(closestHandle.css("borderBottomWidth"),10)||0)+(parseInt(closestHandle.css("marginTop"),10)||0)};if(!this.handles.hasClass("ui-state-hover")){this._slide(event,index,normValue);}this._animateOff=true;return true;},_mouseStart:function(){return true;},_mouseDrag:function(event){var position={x:event.pageX,y:event.pageY},normValue=this._normValueFromMouse(position);this._slide(event,this._handleIndex,normValue);return false;},_mouseStop:function(event){this._removeClass(this.handles,null,"ui-state-active");this._mouseSliding=false;this._stop(event,this._handleIndex);this._change(event,this._handleIndex);this._handleIndex=null;this._clickOffset=null;this._animateOff=false;return false;},_detectOrientation:function(){this.orientation=this.options.orientation==="vertical"?"vertical":"horizontal";},_normValueFromMouse:function(position){var pixelTotal,pixelMouse,percentMouse,valueTotal,valueMouse;if(this.orientation==="horizontal"){pixelTotal=this.elementSize.width;pixelMouse=position.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0);}else {pixelTotal=this.elementSize.height;pixelMouse=position.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0);}percentMouse=pixelMouse/pixelTotal;if(percentMouse>1){percentMouse=1;}if(percentMouse<0){percentMouse=0;}if(this.orientation==="vertical"){percentMouse=1-percentMouse;}valueTotal=this._valueMax()-this._valueMin();valueMouse=this._valueMin()+percentMouse*valueTotal;return this._trimAlignValue(valueMouse);},_uiHash:function(index,value,values){var uiHash={handle:this.handles[index],handleIndex:index,value:value!==undefined?value:this.value()};if(this._hasMultipleValues()){uiHash.value=value!==undefined?value:this.values(index);uiHash.values=values||this.values();}return uiHash;},_hasMultipleValues:function(){return this.options.values&&this.options.values.length;},_start:function(event,index){return this._trigger("start",event,this._uiHash(index));},_slide:function(event,index,newVal){var allowed,otherVal,currentValue=this.value(),newValues=this.values();if(this._hasMultipleValues()){otherVal=this.values(index?0:1);currentValue=this.values(index);if(this.options.values.length===2&&this.options.range===true){newVal=index===0?Math.min(otherVal,newVal):Math.max(otherVal,newVal);}newValues[index]=newVal;}if(newVal===currentValue){return;}allowed=this._trigger("slide",event,this._uiHash(index,newVal,newValues));// A slide can be canceled by returning false from the slide callback
	if(allowed===false){return;}if(this._hasMultipleValues()){this.values(index,newVal);}else {this.value(newVal);}},_stop:function(event,index){this._trigger("stop",event,this._uiHash(index));},_change:function(event,index){if(!this._keySliding&&!this._mouseSliding){//store the last changed value index for reference when handles overlap
	this._lastChangedValue=index;this._trigger("change",event,this._uiHash(index));}},value:function(newValue){if(arguments.length){this.options.value=this._trimAlignValue(newValue);this._refreshValue();this._change(null,0);return;}return this._value();},values:function(index,newValue){var vals,newValues,i;if(arguments.length>1){this.options.values[index]=this._trimAlignValue(newValue);this._refreshValue();this._change(null,index);return;}if(arguments.length){if(Array.isArray(arguments[0])){vals=this.options.values;newValues=arguments[0];for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(newValues[i]);this._change(null,i);}this._refreshValue();}else {if(this._hasMultipleValues()){return this._values(index);}else {return this.value();}}}else {return this._values();}},_setOption:function(key,value){var i,valsLength=0;if(key==="range"&&this.options.range===true){if(value==="min"){this.options.value=this._values(0);this.options.values=null;}else if(value==="max"){this.options.value=this._values(this.options.values.length-1);this.options.values=null;}}if(Array.isArray(this.options.values)){valsLength=this.options.values.length;}this._super(key,value);switch(key){case"orientation":this._detectOrientation();this._removeClass("ui-slider-horizontal ui-slider-vertical")._addClass("ui-slider-"+this.orientation);this._refreshValue();if(this.options.range){this._refreshRange(value);}// Reset positioning from previous orientation
	this.handles.css(value==="horizontal"?"bottom":"left","");break;case"value":this._animateOff=true;this._refreshValue();this._change(null,0);this._animateOff=false;break;case"values":this._animateOff=true;this._refreshValue();// Start from the last handle to prevent unreachable handles (#9046)
	for(i=valsLength-1;i>=0;i--){this._change(null,i);}this._animateOff=false;break;case"step":case"min":case"max":this._animateOff=true;this._calculateNewMax();this._refreshValue();this._animateOff=false;break;case"range":this._animateOff=true;this._refresh();this._animateOff=false;break;}},_setOptionDisabled:function(value){this._super(value);this._toggleClass(null,"ui-state-disabled",!!value);},//internal value getter
	// _value() returns value trimmed by min and max, aligned by step
	_value:function(){var val=this.options.value;val=this._trimAlignValue(val);return val;},//internal values getter
	// _values() returns array of values trimmed by min and max, aligned by step
	// _values( index ) returns single value trimmed by min and max, aligned by step
	_values:function(index){var val,vals,i;if(arguments.length){val=this.options.values[index];val=this._trimAlignValue(val);return val;}else if(this._hasMultipleValues()){// .slice() creates a copy of the array
	// this copy gets trimmed by min and max and then returned
	vals=this.options.values.slice();for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(vals[i]);}return vals;}else {return [];}},// Returns the step-aligned value that val is closest to, between (inclusive) min and max
	_trimAlignValue:function(val){if(val<=this._valueMin()){return this._valueMin();}if(val>=this._valueMax()){return this._valueMax();}var step=this.options.step>0?this.options.step:1,valModStep=(val-this._valueMin())%step,alignValue=val-valModStep;if(Math.abs(valModStep)*2>=step){alignValue+=valModStep>0?step:-step;}// Since JavaScript has problems with large floats, round
	// the final value to 5 digits after the decimal point (see #4124)
	return parseFloat(alignValue.toFixed(5));},_calculateNewMax:function(){var max=this.options.max,min=this._valueMin(),step=this.options.step,aboveMin=Math.round((max-min)/step)*step;max=aboveMin+min;if(max>this.options.max){//If max is not divisible by step, rounding off may increase its value
	max-=step;}this.max=parseFloat(max.toFixed(this._precision()));},_precision:function(){var precision=this._precisionOf(this.options.step);if(this.options.min!==null){precision=Math.max(precision,this._precisionOf(this.options.min));}return precision;},_precisionOf:function(num){var str=num.toString(),decimal=str.indexOf(".");return decimal===-1?0:str.length-decimal-1;},_valueMin:function(){return this.options.min;},_valueMax:function(){return this.max;},_refreshRange:function(orientation){if(orientation==="vertical"){this.range.css({"width":"","left":""});}if(orientation==="horizontal"){this.range.css({"height":"","bottom":""});}},_refreshValue:function(){var lastValPercent,valPercent,value,valueMin,valueMax,oRange=this.options.range,o=this.options,that=this,animate=!this._animateOff?o.animate:false,_set={};if(this._hasMultipleValues()){this.handles.each(function(i){valPercent=(that.values(i)-that._valueMin())/(that._valueMax()-that._valueMin())*100;_set[that.orientation==="horizontal"?"left":"bottom"]=valPercent+"%";$(this).stop(1,1)[animate?"animate":"css"](_set,o.animate);if(that.options.range===true){if(that.orientation==="horizontal"){if(i===0){that.range.stop(1,1)[animate?"animate":"css"]({left:valPercent+"%"},o.animate);}if(i===1){that.range[animate?"animate":"css"]({width:valPercent-lastValPercent+"%"},{queue:false,duration:o.animate});}}else {if(i===0){that.range.stop(1,1)[animate?"animate":"css"]({bottom:valPercent+"%"},o.animate);}if(i===1){that.range[animate?"animate":"css"]({height:valPercent-lastValPercent+"%"},{queue:false,duration:o.animate});}}}lastValPercent=valPercent;});}else {value=this.value();valueMin=this._valueMin();valueMax=this._valueMax();valPercent=valueMax!==valueMin?(value-valueMin)/(valueMax-valueMin)*100:0;_set[this.orientation==="horizontal"?"left":"bottom"]=valPercent+"%";this.handle.stop(1,1)[animate?"animate":"css"](_set,o.animate);if(oRange==="min"&&this.orientation==="horizontal"){this.range.stop(1,1)[animate?"animate":"css"]({width:valPercent+"%"},o.animate);}if(oRange==="max"&&this.orientation==="horizontal"){this.range.stop(1,1)[animate?"animate":"css"]({width:100-valPercent+"%"},o.animate);}if(oRange==="min"&&this.orientation==="vertical"){this.range.stop(1,1)[animate?"animate":"css"]({height:valPercent+"%"},o.animate);}if(oRange==="max"&&this.orientation==="vertical"){this.range.stop(1,1)[animate?"animate":"css"]({height:100-valPercent+"%"},o.animate);}}},_handleEvents:{keydown:function(event){var allowed,curVal,newVal,step,index=$(event.target).data("ui-slider-handle-index");switch(event.keyCode){case $.ui.keyCode.HOME:case $.ui.keyCode.END:case $.ui.keyCode.PAGE_UP:case $.ui.keyCode.PAGE_DOWN:case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:event.preventDefault();if(!this._keySliding){this._keySliding=true;this._addClass($(event.target),null,"ui-state-active");allowed=this._start(event,index);if(allowed===false){return;}}break;}step=this.options.step;if(this._hasMultipleValues()){curVal=newVal=this.values(index);}else {curVal=newVal=this.value();}switch(event.keyCode){case $.ui.keyCode.HOME:newVal=this._valueMin();break;case $.ui.keyCode.END:newVal=this._valueMax();break;case $.ui.keyCode.PAGE_UP:newVal=this._trimAlignValue(curVal+(this._valueMax()-this._valueMin())/this.numPages);break;case $.ui.keyCode.PAGE_DOWN:newVal=this._trimAlignValue(curVal-(this._valueMax()-this._valueMin())/this.numPages);break;case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:if(curVal===this._valueMax()){return;}newVal=this._trimAlignValue(curVal+step);break;case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:if(curVal===this._valueMin()){return;}newVal=this._trimAlignValue(curVal-step);break;}this._slide(event,index,newVal);},keyup:function(event){var index=$(event.target).data("ui-slider-handle-index");if(this._keySliding){this._keySliding=false;this._stop(event,index);this._change(event,index);this._removeClass($(event.target),null,"ui-state-active");}}}});/*!
	 * jQuery UI Sortable 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Sortable
	//>>group: Interactions
	//>>description: Enables items in a list to be sorted using the mouse.
	//>>docs: https://api.jqueryui.com/sortable/
	//>>demos: https://jqueryui.com/sortable/
	//>>css.structure: ../../themes/base/sortable.css
	$.widget("ui.sortable",$.ui.mouse,{version:"1.13.3",widgetEventPrefix:"sort",ready:false,options:{appendTo:"parent",axis:false,connectWith:false,containment:false,cursor:"auto",cursorAt:false,dropOnEmpty:true,forcePlaceholderSize:false,forceHelperSize:false,grid:false,handle:false,helper:"original",items:"> *",opacity:false,placeholder:false,revert:false,scroll:true,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1000,// Callbacks
	activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_isOverAxis:function(x,reference,size){return x>=reference&&x<reference+size;},_isFloating:function(item){return /left|right/.test(item.css("float"))||/inline|table-cell/.test(item.css("display"));},_create:function(){this.containerCache={};this._addClass("ui-sortable");//Get the items
	this.refresh();//Let's determine the parent's offset
	this.offset=this.element.offset();//Initialize mouse events for interaction
	this._mouseInit();this._setHandleClassName();//We're ready to go
	this.ready=true;},_setOption:function(key,value){this._super(key,value);if(key==="handle"){this._setHandleClassName();}},_setHandleClassName:function(){var that=this;this._removeClass(this.element.find(".ui-sortable-handle"),"ui-sortable-handle");$.each(this.items,function(){that._addClass(this.instance.options.handle?this.item.find(this.instance.options.handle):this.item,"ui-sortable-handle");});},_destroy:function(){this._mouseDestroy();for(var i=this.items.length-1;i>=0;i--){this.items[i].item.removeData(this.widgetName+"-item");}return this;},_mouseCapture:function(event,overrideHandle){var currentItem=null,validHandle=false,that=this;if(this.reverting){return false;}if(this.options.disabled||this.options.type==="static"){return false;}//We have to refresh the items data once first
	this._refreshItems(event);//Find out if the clicked node (or one of its parents) is a actual item in this.items
	$(event.target).parents().each(function(){if($.data(this,that.widgetName+"-item")===that){currentItem=$(this);return false;}});if($.data(event.target,that.widgetName+"-item")===that){currentItem=$(event.target);}if(!currentItem){return false;}if(this.options.handle&&!overrideHandle){$(this.options.handle,currentItem).find("*").addBack().each(function(){if(this===event.target){validHandle=true;}});if(!validHandle){return false;}}this.currentItem=currentItem;this._removeCurrentsFromItems();return true;},_mouseStart:function(event,overrideHandle,noActivation){var i,body,o=this.options;this.currentContainer=this;//We only need to call refreshPositions, because the refreshItems call has been moved to
	// mouseCapture
	this.refreshPositions();//Prepare the dragged items parent
	this.appendTo=$(o.appendTo!=="parent"?o.appendTo:this.currentItem.parent());//Create and append the visible helper
	this.helper=this._createHelper(event);//Cache the helper size
	this._cacheHelperProportions();/*
			 * - Position generation -
			 * This block generates everything position related - it's the core of draggables.
			 *///Cache the margins of the original element
	this._cacheMargins();//The element's absolute position on the page minus margins
	this.offset=this.currentItem.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};$.extend(this.offset,{click:{//Where the click happened, relative to the element
	left:event.pageX-this.offset.left,top:event.pageY-this.offset.top},// This is a relative to absolute position minus the actual position calculation -
	// only used for relative positioned helper
	relative:this._getRelativeOffset()});// After we get the helper offset, but before we get the parent offset we can
	// change the helper's position to absolute
	// TODO: Still need to figure out a way to make relative sorting possible
	this.helper.css("position","absolute");this.cssPosition=this.helper.css("position");//Adjust the mouse offset relative to the helper if "cursorAt" is supplied
	if(o.cursorAt){this._adjustOffsetFromHelper(o.cursorAt);}//Cache the former DOM position
	this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]};// If the helper is not the original, hide the original so it's not playing any role during
	// the drag, won't cause anything bad this way
	if(this.helper[0]!==this.currentItem[0]){this.currentItem.hide();}//Create the placeholder
	this._createPlaceholder();//Get the next scrolling parent
	this.scrollParent=this.placeholder.scrollParent();$.extend(this.offset,{parent:this._getParentOffset()});//Set a containment if given in the options
	if(o.containment){this._setContainment();}if(o.cursor&&o.cursor!=="auto"){// cursor option
	body=this.document.find("body");// Support: IE
	this.storedCursor=body.css("cursor");body.css("cursor",o.cursor);this.storedStylesheet=$("<style>*{ cursor: "+o.cursor+" !important; }</style>").appendTo(body);}// We need to make sure to grab the zIndex before setting the
	// opacity, because setting the opacity to anything lower than 1
	// causes the zIndex to change from "auto" to 0.
	if(o.zIndex){// zIndex option
	if(this.helper.css("zIndex")){this._storedZIndex=this.helper.css("zIndex");}this.helper.css("zIndex",o.zIndex);}if(o.opacity){// opacity option
	if(this.helper.css("opacity")){this._storedOpacity=this.helper.css("opacity");}this.helper.css("opacity",o.opacity);}//Prepare scrolling
	if(this.scrollParent[0]!==this.document[0]&&this.scrollParent[0].tagName!=="HTML"){this.overflowOffset=this.scrollParent.offset();}//Call callbacks
	this._trigger("start",event,this._uiHash());//Recache the helper size
	if(!this._preserveHelperProportions){this._cacheHelperProportions();}//Post "activate" events to possible containers
	if(!noActivation){for(i=this.containers.length-1;i>=0;i--){this.containers[i]._trigger("activate",event,this._uiHash(this));}}//Prepare possible droppables
	if($.ui.ddmanager){$.ui.ddmanager.current=this;}if($.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(this,event);}this.dragging=true;this._addClass(this.helper,"ui-sortable-helper");//Move the helper, if needed
	if(!this.helper.parent().is(this.appendTo)){this.helper.detach().appendTo(this.appendTo);//Update position
	this.offset.parent=this._getParentOffset();}//Generate the original position
	this.position=this.originalPosition=this._generatePosition(event);this.originalPageX=event.pageX;this.originalPageY=event.pageY;this.lastPositionAbs=this.positionAbs=this._convertPositionTo("absolute");this._mouseDrag(event);return true;},_scroll:function(event){var o=this.options,scrolled=false;if(this.scrollParent[0]!==this.document[0]&&this.scrollParent[0].tagName!=="HTML"){if(this.overflowOffset.top+this.scrollParent[0].offsetHeight-event.pageY<o.scrollSensitivity){this.scrollParent[0].scrollTop=scrolled=this.scrollParent[0].scrollTop+o.scrollSpeed;}else if(event.pageY-this.overflowOffset.top<o.scrollSensitivity){this.scrollParent[0].scrollTop=scrolled=this.scrollParent[0].scrollTop-o.scrollSpeed;}if(this.overflowOffset.left+this.scrollParent[0].offsetWidth-event.pageX<o.scrollSensitivity){this.scrollParent[0].scrollLeft=scrolled=this.scrollParent[0].scrollLeft+o.scrollSpeed;}else if(event.pageX-this.overflowOffset.left<o.scrollSensitivity){this.scrollParent[0].scrollLeft=scrolled=this.scrollParent[0].scrollLeft-o.scrollSpeed;}}else {if(event.pageY-this.document.scrollTop()<o.scrollSensitivity){scrolled=this.document.scrollTop(this.document.scrollTop()-o.scrollSpeed);}else if(this.window.height()-(event.pageY-this.document.scrollTop())<o.scrollSensitivity){scrolled=this.document.scrollTop(this.document.scrollTop()+o.scrollSpeed);}if(event.pageX-this.document.scrollLeft()<o.scrollSensitivity){scrolled=this.document.scrollLeft(this.document.scrollLeft()-o.scrollSpeed);}else if(this.window.width()-(event.pageX-this.document.scrollLeft())<o.scrollSensitivity){scrolled=this.document.scrollLeft(this.document.scrollLeft()+o.scrollSpeed);}}return scrolled;},_mouseDrag:function(event){var i,item,itemElement,intersection,o=this.options;//Compute the helpers position
	this.position=this._generatePosition(event);this.positionAbs=this._convertPositionTo("absolute");//Set the helper position
	if(!this.options.axis||this.options.axis!=="y"){this.helper[0].style.left=this.position.left+"px";}if(!this.options.axis||this.options.axis!=="x"){this.helper[0].style.top=this.position.top+"px";}//Do scrolling
	if(o.scroll){if(this._scroll(event)!==false){//Update item positions used in position checks
	this._refreshItemPositions(true);if($.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(this,event);}}}this.dragDirection={vertical:this._getDragVerticalDirection(),horizontal:this._getDragHorizontalDirection()};//Rearrange
	for(i=this.items.length-1;i>=0;i--){//Cache variables and intersection, continue if no intersection
	item=this.items[i];itemElement=item.item[0];intersection=this._intersectsWithPointer(item);if(!intersection){continue;}// Only put the placeholder inside the current Container, skip all
	// items from other containers. This works because when moving
	// an item from one container to another the
	// currentContainer is switched before the placeholder is moved.
	//
	// Without this, moving items in "sub-sortables" can cause
	// the placeholder to jitter between the outer and inner container.
	if(item.instance!==this.currentContainer){continue;}// Cannot intersect with itself
	// no useless actions that have been done before
	// no action if the item moved is the parent of the item checked
	if(itemElement!==this.currentItem[0]&&this.placeholder[intersection===1?"next":"prev"]()[0]!==itemElement&&!$.contains(this.placeholder[0],itemElement)&&(this.options.type==="semi-dynamic"?!$.contains(this.element[0],itemElement):true)){this.direction=intersection===1?"down":"up";if(this.options.tolerance==="pointer"||this._intersectsWithSides(item)){this._rearrange(event,item);}else {break;}this._trigger("change",event,this._uiHash());break;}}//Post events to containers
	this._contactContainers(event);//Interconnect with droppables
	if($.ui.ddmanager){$.ui.ddmanager.drag(this,event);}//Call callbacks
	this._trigger("sort",event,this._uiHash());this.lastPositionAbs=this.positionAbs;return false;},_mouseStop:function(event,noPropagation){if(!event){return;}//If we are using droppables, inform the manager about the drop
	if($.ui.ddmanager&&!this.options.dropBehaviour){$.ui.ddmanager.drop(this,event);}if(this.options.revert){var that=this,cur=this.placeholder.offset(),axis=this.options.axis,animation={};if(!axis||axis==="x"){animation.left=cur.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===this.document[0].body?0:this.offsetParent[0].scrollLeft);}if(!axis||axis==="y"){animation.top=cur.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===this.document[0].body?0:this.offsetParent[0].scrollTop);}this.reverting=true;$(this.helper).animate(animation,parseInt(this.options.revert,10)||500,function(){that._clear(event);});}else {this._clear(event,noPropagation);}return false;},cancel:function(){if(this.dragging){this._mouseUp(new $.Event("mouseup",{target:null}));if(this.options.helper==="original"){this.currentItem.css(this._storedCSS);this._removeClass(this.currentItem,"ui-sortable-helper");}else {this.currentItem.show();}//Post deactivating events to containers
	for(var i=this.containers.length-1;i>=0;i--){this.containers[i]._trigger("deactivate",null,this._uiHash(this));if(this.containers[i].containerCache.over){this.containers[i]._trigger("out",null,this._uiHash(this));this.containers[i].containerCache.over=0;}}}if(this.placeholder){//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,
	// it unbinds ALL events from the original node!
	if(this.placeholder[0].parentNode){this.placeholder[0].parentNode.removeChild(this.placeholder[0]);}if(this.options.helper!=="original"&&this.helper&&this.helper[0].parentNode){this.helper.remove();}$.extend(this,{helper:null,dragging:false,reverting:false,_noFinalSort:null});if(this.domPosition.prev){$(this.domPosition.prev).after(this.currentItem);}else {$(this.domPosition.parent).prepend(this.currentItem);}}return this;},serialize:function(o){var items=this._getItemsAsjQuery(o&&o.connected),str=[];o=o||{};$(items).each(function(){var res=($(o.item||this).attr(o.attribute||"id")||"").match(o.expression||/(.+)[\-=_](.+)/);if(res){str.push((o.key||res[1]+"[]")+"="+(o.key&&o.expression?res[1]:res[2]));}});if(!str.length&&o.key){str.push(o.key+"=");}return str.join("&");},toArray:function(o){var items=this._getItemsAsjQuery(o&&o.connected),ret=[];o=o||{};items.each(function(){ret.push($(o.item||this).attr(o.attribute||"id")||"");});return ret;},/* Be careful with the following core functions */_intersectsWith:function(item){var x1=this.positionAbs.left,x2=x1+this.helperProportions.width,y1=this.positionAbs.top,y2=y1+this.helperProportions.height,l=item.left,r=l+item.width,t=item.top,b=t+item.height,dyClick=this.offset.click.top,dxClick=this.offset.click.left,isOverElementHeight=this.options.axis==="x"||y1+dyClick>t&&y1+dyClick<b,isOverElementWidth=this.options.axis==="y"||x1+dxClick>l&&x1+dxClick<r,isOverElement=isOverElementHeight&&isOverElementWidth;if(this.options.tolerance==="pointer"||this.options.forcePointerForContainers||this.options.tolerance!=="pointer"&&this.helperProportions[this.floating?"width":"height"]>item[this.floating?"width":"height"]){return isOverElement;}else {return l<x1+this.helperProportions.width/2&&// Right Half
	x2-this.helperProportions.width/2<r&&// Left Half
	t<y1+this.helperProportions.height/2&&// Bottom Half
	y2-this.helperProportions.height/2<b;// Top Half
	}},_intersectsWithPointer:function(item){var verticalDirection,horizontalDirection,isOverElementHeight=this.options.axis==="x"||this._isOverAxis(this.positionAbs.top+this.offset.click.top,item.top,item.height),isOverElementWidth=this.options.axis==="y"||this._isOverAxis(this.positionAbs.left+this.offset.click.left,item.left,item.width),isOverElement=isOverElementHeight&&isOverElementWidth;if(!isOverElement){return false;}verticalDirection=this.dragDirection.vertical;horizontalDirection=this.dragDirection.horizontal;return this.floating?horizontalDirection==="right"||verticalDirection==="down"?2:1:verticalDirection&&(verticalDirection==="down"?2:1);},_intersectsWithSides:function(item){var isOverBottomHalf=this._isOverAxis(this.positionAbs.top+this.offset.click.top,item.top+item.height/2,item.height),isOverRightHalf=this._isOverAxis(this.positionAbs.left+this.offset.click.left,item.left+item.width/2,item.width),verticalDirection=this.dragDirection.vertical,horizontalDirection=this.dragDirection.horizontal;if(this.floating&&horizontalDirection){return horizontalDirection==="right"&&isOverRightHalf||horizontalDirection==="left"&&!isOverRightHalf;}else {return verticalDirection&&(verticalDirection==="down"&&isOverBottomHalf||verticalDirection==="up"&&!isOverBottomHalf);}},_getDragVerticalDirection:function(){var delta=this.positionAbs.top-this.lastPositionAbs.top;return delta!==0&&(delta>0?"down":"up");},_getDragHorizontalDirection:function(){var delta=this.positionAbs.left-this.lastPositionAbs.left;return delta!==0&&(delta>0?"right":"left");},refresh:function(event){this._refreshItems(event);this._setHandleClassName();this.refreshPositions();return this;},_connectWith:function(){var options=this.options;return options.connectWith.constructor===String?[options.connectWith]:options.connectWith;},_getItemsAsjQuery:function(connected){var i,j,cur,inst,items=[],queries=[],connectWith=this._connectWith();if(connectWith&&connected){for(i=connectWith.length-1;i>=0;i--){cur=$(connectWith[i],this.document[0]);for(j=cur.length-1;j>=0;j--){inst=$.data(cur[j],this.widgetFullName);if(inst&&inst!==this&&!inst.options.disabled){queries.push([typeof inst.options.items==="function"?inst.options.items.call(inst.element):$(inst.options.items,inst.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),inst]);}}}}queries.push([typeof this.options.items==="function"?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):$(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]);function addItems(){items.push(this);}for(i=queries.length-1;i>=0;i--){queries[i][0].each(addItems);}return $(items);},_removeCurrentsFromItems:function(){var list=this.currentItem.find(":data("+this.widgetName+"-item)");this.items=$.grep(this.items,function(item){for(var j=0;j<list.length;j++){if(list[j]===item.item[0]){return false;}}return true;});},_refreshItems:function(event){this.items=[];this.containers=[this];var i,j,cur,inst,targetData,_queries,item,queriesLength,items=this.items,queries=[[typeof this.options.items==="function"?this.options.items.call(this.element[0],event,{item:this.currentItem}):$(this.options.items,this.element),this]],connectWith=this._connectWith();//Shouldn't be run the first time through due to massive slow-down
	if(connectWith&&this.ready){for(i=connectWith.length-1;i>=0;i--){cur=$(connectWith[i],this.document[0]);for(j=cur.length-1;j>=0;j--){inst=$.data(cur[j],this.widgetFullName);if(inst&&inst!==this&&!inst.options.disabled){queries.push([typeof inst.options.items==="function"?inst.options.items.call(inst.element[0],event,{item:this.currentItem}):$(inst.options.items,inst.element),inst]);this.containers.push(inst);}}}}for(i=queries.length-1;i>=0;i--){targetData=queries[i][1];_queries=queries[i][0];for(j=0,queriesLength=_queries.length;j<queriesLength;j++){item=$(_queries[j]);// Data for target checking (mouse manager)
	item.data(this.widgetName+"-item",targetData);items.push({item:item,instance:targetData,width:0,height:0,left:0,top:0});}}},_refreshItemPositions:function(fast){var i,item,t,p;for(i=this.items.length-1;i>=0;i--){item=this.items[i];//We ignore calculating positions of all connected containers when we're not over them
	if(this.currentContainer&&item.instance!==this.currentContainer&&item.item[0]!==this.currentItem[0]){continue;}t=this.options.toleranceElement?$(this.options.toleranceElement,item.item):item.item;if(!fast){item.width=t.outerWidth();item.height=t.outerHeight();}p=t.offset();item.left=p.left;item.top=p.top;}},refreshPositions:function(fast){// Determine whether items are being displayed horizontally
	this.floating=this.items.length?this.options.axis==="x"||this._isFloating(this.items[0].item):false;// This has to be redone because due to the item being moved out/into the offsetParent,
	// the offsetParent's position will change
	if(this.offsetParent&&this.helper){this.offset.parent=this._getParentOffset();}this._refreshItemPositions(fast);var i,p;if(this.options.custom&&this.options.custom.refreshContainers){this.options.custom.refreshContainers.call(this);}else {for(i=this.containers.length-1;i>=0;i--){p=this.containers[i].element.offset();this.containers[i].containerCache.left=p.left;this.containers[i].containerCache.top=p.top;this.containers[i].containerCache.width=this.containers[i].element.outerWidth();this.containers[i].containerCache.height=this.containers[i].element.outerHeight();}}return this;},_createPlaceholder:function(that){that=that||this;var className,nodeName,o=that.options;if(!o.placeholder||o.placeholder.constructor===String){className=o.placeholder;nodeName=that.currentItem[0].nodeName.toLowerCase();o.placeholder={element:function(){var element=$("<"+nodeName+">",that.document[0]);that._addClass(element,"ui-sortable-placeholder",className||that.currentItem[0].className)._removeClass(element,"ui-sortable-helper");if(nodeName==="tbody"){that._createTrPlaceholder(that.currentItem.find("tr").eq(0),$("<tr>",that.document[0]).appendTo(element));}else if(nodeName==="tr"){that._createTrPlaceholder(that.currentItem,element);}else if(nodeName==="img"){element.attr("src",that.currentItem.attr("src"));}if(!className){element.css("visibility","hidden");}return element;},update:function(container,p){// 1. If a className is set as 'placeholder option, we don't force sizes -
	// the class is responsible for that
	// 2. The option 'forcePlaceholderSize can be enabled to force it even if a
	// class name is specified
	if(className&&!o.forcePlaceholderSize){return;}// If the element doesn't have a actual height or width by itself (without
	// styles coming from a stylesheet), it receives the inline height and width
	// from the dragged item. Or, if it's a tbody or tr, it's going to have a height
	// anyway since we're populating them with <td>s above, but they're unlikely to
	// be the correct height on their own if the row heights are dynamic, so we'll
	// always assign the height of the dragged item given forcePlaceholderSize
	// is true.
	if(!p.height()||o.forcePlaceholderSize&&(nodeName==="tbody"||nodeName==="tr")){p.height(that.currentItem.innerHeight()-parseInt(that.currentItem.css("paddingTop")||0,10)-parseInt(that.currentItem.css("paddingBottom")||0,10));}if(!p.width()){p.width(that.currentItem.innerWidth()-parseInt(that.currentItem.css("paddingLeft")||0,10)-parseInt(that.currentItem.css("paddingRight")||0,10));}}};}//Create the placeholder
	that.placeholder=$(o.placeholder.element.call(that.element,that.currentItem));//Append it after the actual current item
	that.currentItem.after(that.placeholder);//Update the size of the placeholder (TODO: Logic to fuzzy, see line 316/317)
	o.placeholder.update(that,that.placeholder);},_createTrPlaceholder:function(sourceTr,targetTr){var that=this;sourceTr.children().each(function(){$("<td>&#160;</td>",that.document[0]).attr("colspan",$(this).attr("colspan")||1).appendTo(targetTr);});},_contactContainers:function(event){var i,j,dist,itemWithLeastDistance,posProperty,sizeProperty,cur,nearBottom,floating,axis,innermostContainer=null,innermostIndex=null;// Get innermost container that intersects with item
	for(i=this.containers.length-1;i>=0;i--){// Never consider a container that's located within the item itself
	if($.contains(this.currentItem[0],this.containers[i].element[0])){continue;}if(this._intersectsWith(this.containers[i].containerCache)){// If we've already found a container and it's more "inner" than this, then continue
	if(innermostContainer&&$.contains(this.containers[i].element[0],innermostContainer.element[0])){continue;}innermostContainer=this.containers[i];innermostIndex=i;}else {// container doesn't intersect. trigger "out" event if necessary
	if(this.containers[i].containerCache.over){this.containers[i]._trigger("out",event,this._uiHash(this));this.containers[i].containerCache.over=0;}}}// If no intersecting containers found, return
	if(!innermostContainer){return;}// Move the item into the container if it's not there already
	if(this.containers.length===1){if(!this.containers[innermostIndex].containerCache.over){this.containers[innermostIndex]._trigger("over",event,this._uiHash(this));this.containers[innermostIndex].containerCache.over=1;}}else {// When entering a new container, we will find the item with the least distance and
	// append our item near it
	dist=10000;itemWithLeastDistance=null;floating=innermostContainer.floating||this._isFloating(this.currentItem);posProperty=floating?"left":"top";sizeProperty=floating?"width":"height";axis=floating?"pageX":"pageY";for(j=this.items.length-1;j>=0;j--){if(!$.contains(this.containers[innermostIndex].element[0],this.items[j].item[0])){continue;}if(this.items[j].item[0]===this.currentItem[0]){continue;}cur=this.items[j].item.offset()[posProperty];nearBottom=false;if(event[axis]-cur>this.items[j][sizeProperty]/2){nearBottom=true;}if(Math.abs(event[axis]-cur)<dist){dist=Math.abs(event[axis]-cur);itemWithLeastDistance=this.items[j];this.direction=nearBottom?"up":"down";}}//Check if dropOnEmpty is enabled
	if(!itemWithLeastDistance&&!this.options.dropOnEmpty){return;}if(this.currentContainer===this.containers[innermostIndex]){if(!this.currentContainer.containerCache.over){this.containers[innermostIndex]._trigger("over",event,this._uiHash());this.currentContainer.containerCache.over=1;}return;}if(itemWithLeastDistance){this._rearrange(event,itemWithLeastDistance,null,true);}else {this._rearrange(event,null,this.containers[innermostIndex].element,true);}this._trigger("change",event,this._uiHash());this.containers[innermostIndex]._trigger("change",event,this._uiHash(this));this.currentContainer=this.containers[innermostIndex];//Update the placeholder
	this.options.placeholder.update(this.currentContainer,this.placeholder);//Update scrollParent
	this.scrollParent=this.placeholder.scrollParent();//Update overflowOffset
	if(this.scrollParent[0]!==this.document[0]&&this.scrollParent[0].tagName!=="HTML"){this.overflowOffset=this.scrollParent.offset();}this.containers[innermostIndex]._trigger("over",event,this._uiHash(this));this.containers[innermostIndex].containerCache.over=1;}},_createHelper:function(event){var o=this.options,helper=typeof o.helper==="function"?$(o.helper.apply(this.element[0],[event,this.currentItem])):o.helper==="clone"?this.currentItem.clone():this.currentItem;//Add the helper to the DOM if that didn't happen already
	if(!helper.parents("body").length){this.appendTo[0].appendChild(helper[0]);}if(helper[0]===this.currentItem[0]){this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")};}if(!helper[0].style.width||o.forceHelperSize){helper.width(this.currentItem.width());}if(!helper[0].style.height||o.forceHelperSize){helper.height(this.currentItem.height());}return helper;},_adjustOffsetFromHelper:function(obj){if(typeof obj==="string"){obj=obj.split(" ");}if(Array.isArray(obj)){obj={left:+obj[0],top:+obj[1]||0};}if("left"in obj){this.offset.click.left=obj.left+this.margins.left;}if("right"in obj){this.offset.click.left=this.helperProportions.width-obj.right+this.margins.left;}if("top"in obj){this.offset.click.top=obj.top+this.margins.top;}if("bottom"in obj){this.offset.click.top=this.helperProportions.height-obj.bottom+this.margins.top;}},_getParentOffset:function(){//Get the offsetParent and cache its position
	this.offsetParent=this.helper.offsetParent();var po=this.offsetParent.offset();// This is a special case where we need to modify a offset calculated on start, since the
	// following happened:
	// 1. The position of the helper is absolute, so it's position is calculated based on the
	// next positioned parent
	// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't
	// the document, which means that the scroll is included in the initial calculation of the
	// offset of the parent, and never recalculated upon drag
	if(this.cssPosition==="absolute"&&this.scrollParent[0]!==this.document[0]&&$.contains(this.scrollParent[0],this.offsetParent[0])){po.left+=this.scrollParent.scrollLeft();po.top+=this.scrollParent.scrollTop();}// This needs to be actually done for all browsers, since pageX/pageY includes this
	// information with an ugly IE fix
	if(this.offsetParent[0]===this.document[0].body||this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()==="html"&&$.ui.ie){po={top:0,left:0};}return {top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)};},_getRelativeOffset:function(){if(this.cssPosition==="relative"){var p=this.currentItem.position();return {top:p.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:p.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()};}else {return {top:0,left:0};}},_cacheMargins:function(){this.margins={left:parseInt(this.currentItem.css("marginLeft"),10)||0,top:parseInt(this.currentItem.css("marginTop"),10)||0};},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};},_setContainment:function(){var ce,co,over,o=this.options;if(o.containment==="parent"){o.containment=this.helper[0].parentNode;}if(o.containment==="document"||o.containment==="window"){this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,o.containment==="document"?this.document.width():this.window.width()-this.helperProportions.width-this.margins.left,(o.containment==="document"?this.document.height()||document.body.parentNode.scrollHeight:this.window.height()||this.document[0].body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];}if(!/^(document|window|parent)$/.test(o.containment)){ce=$(o.containment)[0];co=$(o.containment).offset();over=$(ce).css("overflow")!=="hidden";this.containment=[co.left+(parseInt($(ce).css("borderLeftWidth"),10)||0)+(parseInt($(ce).css("paddingLeft"),10)||0)-this.margins.left,co.top+(parseInt($(ce).css("borderTopWidth"),10)||0)+(parseInt($(ce).css("paddingTop"),10)||0)-this.margins.top,co.left+(over?Math.max(ce.scrollWidth,ce.offsetWidth):ce.offsetWidth)-(parseInt($(ce).css("borderLeftWidth"),10)||0)-(parseInt($(ce).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,co.top+(over?Math.max(ce.scrollHeight,ce.offsetHeight):ce.offsetHeight)-(parseInt($(ce).css("borderTopWidth"),10)||0)-(parseInt($(ce).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top];}},_convertPositionTo:function(d,pos){if(!pos){pos=this.position;}var mod=d==="absolute"?1:-1,scroll=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==this.document[0]&&$.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=/(html|body)/i.test(scroll[0].tagName);return {top:// The absolute mouse position
	pos.top+// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.top*mod+// The offsetParent's offset without borders (offset + border)
	this.offset.parent.top*mod-(this.cssPosition==="fixed"?-this.scrollParent.scrollTop():scrollIsRootNode?0:scroll.scrollTop())*mod,left:// The absolute mouse position
	pos.left+// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.left*mod+// The offsetParent's offset without borders (offset + border)
	this.offset.parent.left*mod-(this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())*mod};},_generatePosition:function(event){var top,left,o=this.options,pageX=event.pageX,pageY=event.pageY,scroll=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==this.document[0]&&$.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=/(html|body)/i.test(scroll[0].tagName);// This is another very weird special case that only happens for relative elements:
	// 1. If the css position is relative
	// 2. and the scroll parent is the document or similar to the offset parent
	// we have to refresh the relative offset during the scroll so there are no jumps
	if(this.cssPosition==="relative"&&!(this.scrollParent[0]!==this.document[0]&&this.scrollParent[0]!==this.offsetParent[0])){this.offset.relative=this._getRelativeOffset();}/*
			 * - Position constraining -
			 * Constrain the position to a mix of grid, containment.
			 */if(this.originalPosition){//If we are not dragging yet, we won't check for options
	if(this.containment){if(event.pageX-this.offset.click.left<this.containment[0]){pageX=this.containment[0]+this.offset.click.left;}if(event.pageY-this.offset.click.top<this.containment[1]){pageY=this.containment[1]+this.offset.click.top;}if(event.pageX-this.offset.click.left>this.containment[2]){pageX=this.containment[2]+this.offset.click.left;}if(event.pageY-this.offset.click.top>this.containment[3]){pageY=this.containment[3]+this.offset.click.top;}}if(o.grid){top=this.originalPageY+Math.round((pageY-this.originalPageY)/o.grid[1])*o.grid[1];pageY=this.containment?top-this.offset.click.top>=this.containment[1]&&top-this.offset.click.top<=this.containment[3]?top:top-this.offset.click.top>=this.containment[1]?top-o.grid[1]:top+o.grid[1]:top;left=this.originalPageX+Math.round((pageX-this.originalPageX)/o.grid[0])*o.grid[0];pageX=this.containment?left-this.offset.click.left>=this.containment[0]&&left-this.offset.click.left<=this.containment[2]?left:left-this.offset.click.left>=this.containment[0]?left-o.grid[0]:left+o.grid[0]:left;}}return {top:// The absolute mouse position
	pageY-// Click offset (relative to the element)
	this.offset.click.top-// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.top-// The offsetParent's offset without borders (offset + border)
	this.offset.parent.top+(this.cssPosition==="fixed"?-this.scrollParent.scrollTop():scrollIsRootNode?0:scroll.scrollTop()),left:// The absolute mouse position
	pageX-// Click offset (relative to the element)
	this.offset.click.left-// Only for relative positioned nodes: Relative offset from element to offset parent
	this.offset.relative.left-// The offsetParent's offset without borders (offset + border)
	this.offset.parent.left+(this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())};},_rearrange:function(event,i,a,hardRefresh){if(a){a[0].appendChild(this.placeholder[0]);}else {i.item[0].parentNode.insertBefore(this.placeholder[0],this.direction==="down"?i.item[0]:i.item[0].nextSibling);}//Various things done here to improve the performance:
	// 1. we create a setTimeout, that calls refreshPositions
	// 2. on the instance, we have a counter variable, that get's higher after every append
	// 3. on the local scope, we copy the counter variable, and check in the timeout,
	// if it's still the same
	// 4. this lets only the last addition to the timeout stack through
	this.counter=this.counter?++this.counter:1;var counter=this.counter;this._delay(function(){if(counter===this.counter){//Precompute after each DOM insertion, NOT on mousemove
	this.refreshPositions(!hardRefresh);}});},_clear:function(event,noPropagation){this.reverting=false;// We delay all events that have to be triggered to after the point where the placeholder
	// has been removed and everything else normalized again
	var i,delayedTriggers=[];// We first have to update the dom position of the actual currentItem
	// Note: don't do it if the current item is already removed (by a user), or it gets
	// reappended (see #4088)
	if(!this._noFinalSort&&this.currentItem.parent().length){this.placeholder.before(this.currentItem);}this._noFinalSort=null;if(this.helper[0]===this.currentItem[0]){for(i in this._storedCSS){if(this._storedCSS[i]==="auto"||this._storedCSS[i]==="static"){this._storedCSS[i]="";}}this.currentItem.css(this._storedCSS);this._removeClass(this.currentItem,"ui-sortable-helper");}else {this.currentItem.show();}if(this.fromOutside&&!noPropagation){delayedTriggers.push(function(event){this._trigger("receive",event,this._uiHash(this.fromOutside));});}if((this.fromOutside||this.domPosition.prev!==this.currentItem.prev().not(".ui-sortable-helper")[0]||this.domPosition.parent!==this.currentItem.parent()[0])&&!noPropagation){// Trigger update callback if the DOM position has changed
	delayedTriggers.push(function(event){this._trigger("update",event,this._uiHash());});}// Check if the items Container has Changed and trigger appropriate
	// events.
	if(this!==this.currentContainer){if(!noPropagation){delayedTriggers.push(function(event){this._trigger("remove",event,this._uiHash());});delayedTriggers.push(function(c){return function(event){c._trigger("receive",event,this._uiHash(this));};}.call(this,this.currentContainer));delayedTriggers.push(function(c){return function(event){c._trigger("update",event,this._uiHash(this));};}.call(this,this.currentContainer));}}//Post events to containers
	function delayEvent(type,instance,container){return function(event){container._trigger(type,event,instance._uiHash(instance));};}for(i=this.containers.length-1;i>=0;i--){if(!noPropagation){delayedTriggers.push(delayEvent("deactivate",this,this.containers[i]));}if(this.containers[i].containerCache.over){delayedTriggers.push(delayEvent("out",this,this.containers[i]));this.containers[i].containerCache.over=0;}}//Do what was originally in plugins
	if(this.storedCursor){this.document.find("body").css("cursor",this.storedCursor);this.storedStylesheet.remove();}if(this._storedOpacity){this.helper.css("opacity",this._storedOpacity);}if(this._storedZIndex){this.helper.css("zIndex",this._storedZIndex==="auto"?"":this._storedZIndex);}this.dragging=false;if(!noPropagation){this._trigger("beforeStop",event,this._uiHash());}//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,
	// it unbinds ALL events from the original node!
	this.placeholder[0].parentNode.removeChild(this.placeholder[0]);if(!this.cancelHelperRemoval){if(this.helper[0]!==this.currentItem[0]){this.helper.remove();}this.helper=null;}if(!noPropagation){for(i=0;i<delayedTriggers.length;i++){// Trigger all delayed events
	delayedTriggers[i].call(this,event);}this._trigger("stop",event,this._uiHash());}this.fromOutside=false;return !this.cancelHelperRemoval;},_trigger:function(){if($.Widget.prototype._trigger.apply(this,arguments)===false){this.cancel();}},_uiHash:function(_inst){var inst=_inst||this;return {helper:inst.helper,placeholder:inst.placeholder||$([]),position:inst.position,originalPosition:inst.originalPosition,offset:inst.positionAbs,item:inst.currentItem,sender:_inst?_inst.element:null};}});/*!
	 * jQuery UI Spinner 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Spinner
	//>>group: Widgets
	//>>description: Displays buttons to easily input numbers via the keyboard or mouse.
	//>>docs: https://api.jqueryui.com/spinner/
	//>>demos: https://jqueryui.com/spinner/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/spinner.css
	//>>css.theme: ../../themes/base/theme.css
	function spinnerModifier(fn){return function(){var previous=this.element.val();fn.apply(this,arguments);this._refresh();if(previous!==this.element.val()){this._trigger("change");}};}$.widget("ui.spinner",{version:"1.13.3",defaultElement:"<input>",widgetEventPrefix:"spin",options:{classes:{"ui-spinner":"ui-corner-all","ui-spinner-down":"ui-corner-br","ui-spinner-up":"ui-corner-tr"},culture:null,icons:{down:"ui-icon-triangle-1-s",up:"ui-icon-triangle-1-n"},incremental:true,max:null,min:null,numberFormat:null,page:10,step:1,change:null,spin:null,start:null,stop:null},_create:function(){// handle string values that need to be parsed
	this._setOption("max",this.options.max);this._setOption("min",this.options.min);this._setOption("step",this.options.step);// Only format if there is a value, prevents the field from being marked
	// as invalid in Firefox, see #9573.
	if(this.value()!==""){// Format the value, but don't constrain.
	this._value(this.element.val(),true);}this._draw();this._on(this._events);this._refresh();// Turning off autocomplete prevents the browser from remembering the
	// value when navigating through history, so we re-enable autocomplete
	// if the page is unloaded before the widget is destroyed. #7790
	this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete");}});},_getCreateOptions:function(){var options=this._super();var element=this.element;$.each(["min","max","step"],function(i,option){var value=element.attr(option);if(value!=null&&value.length){options[option]=value;}});return options;},_events:{keydown:function(event){if(this._start(event)&&this._keydown(event)){event.preventDefault();}},keyup:"_stop",focus:function(){this.previous=this.element.val();},blur:function(event){if(this.cancelBlur){delete this.cancelBlur;return;}this._stop();this._refresh();if(this.previous!==this.element.val()){this._trigger("change",event);}},mousewheel:function(event,delta){var activeElement=$.ui.safeActiveElement(this.document[0]);var isActive=this.element[0]===activeElement;if(!isActive||!delta){return;}if(!this.spinning&&!this._start(event)){return false;}this._spin((delta>0?1:-1)*this.options.step,event);clearTimeout(this.mousewheelTimer);this.mousewheelTimer=this._delay(function(){if(this.spinning){this._stop(event);}},100);event.preventDefault();},"mousedown .ui-spinner-button":function(event){var previous;// We never want the buttons to have focus; whenever the user is
	// interacting with the spinner, the focus should be on the input.
	// If the input is focused then this.previous is properly set from
	// when the input first received focus. If the input is not focused
	// then we need to set this.previous based on the value before spinning.
	previous=this.element[0]===$.ui.safeActiveElement(this.document[0])?this.previous:this.element.val();function checkFocus(){var isActive=this.element[0]===$.ui.safeActiveElement(this.document[0]);if(!isActive){this.element.trigger("focus");this.previous=previous;// support: IE
	// IE sets focus asynchronously, so we need to check if focus
	// moved off of the input because the user clicked on the button.
	this._delay(function(){this.previous=previous;});}}// Ensure focus is on (or stays on) the text field
	event.preventDefault();checkFocus.call(this);// Support: IE
	// IE doesn't prevent moving focus even with event.preventDefault()
	// so we set a flag to know when we should ignore the blur event
	// and check (again) if focus moved off of the input.
	this.cancelBlur=true;this._delay(function(){delete this.cancelBlur;checkFocus.call(this);});if(this._start(event)===false){return;}this._repeat(null,$(event.currentTarget).hasClass("ui-spinner-up")?1:-1,event);},"mouseup .ui-spinner-button":"_stop","mouseenter .ui-spinner-button":function(event){// button will add ui-state-active if mouse was down while mouseleave and kept down
	if(!$(event.currentTarget).hasClass("ui-state-active")){return;}if(this._start(event)===false){return false;}this._repeat(null,$(event.currentTarget).hasClass("ui-spinner-up")?1:-1,event);},// TODO: do we really want to consider this a stop?
	// shouldn't we just stop the repeater and wait until mouseup before
	// we trigger the stop event?
	"mouseleave .ui-spinner-button":"_stop"},// Support mobile enhanced option and make backcompat more sane
	_enhance:function(){this.uiSpinner=this.element.attr("autocomplete","off").wrap("<span>").parent()// Add buttons
	.append("<a></a><a></a>");},_draw:function(){this._enhance();this._addClass(this.uiSpinner,"ui-spinner","ui-widget ui-widget-content");this._addClass("ui-spinner-input");this.element.attr("role","spinbutton");// Button bindings
	this.buttons=this.uiSpinner.children("a").attr("tabIndex",-1).attr("aria-hidden",true).button({classes:{"ui-button":""}});// TODO: Right now button does not support classes this is already updated in button PR
	this._removeClass(this.buttons,"ui-corner-all");this._addClass(this.buttons.first(),"ui-spinner-button ui-spinner-up");this._addClass(this.buttons.last(),"ui-spinner-button ui-spinner-down");this.buttons.first().button({"icon":this.options.icons.up,"showLabel":false});this.buttons.last().button({"icon":this.options.icons.down,"showLabel":false});// IE 6 doesn't understand height: 50% for the buttons
	// unless the wrapper has an explicit height
	if(this.buttons.height()>Math.ceil(this.uiSpinner.height()*0.5)&&this.uiSpinner.height()>0){this.uiSpinner.height(this.uiSpinner.height());}},_keydown:function(event){var options=this.options,keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.UP:this._repeat(null,1,event);return true;case keyCode.DOWN:this._repeat(null,-1,event);return true;case keyCode.PAGE_UP:this._repeat(null,options.page,event);return true;case keyCode.PAGE_DOWN:this._repeat(null,-options.page,event);return true;}return false;},_start:function(event){if(!this.spinning&&this._trigger("start",event)===false){return false;}if(!this.counter){this.counter=1;}this.spinning=true;return true;},_repeat:function(i,steps,event){i=i||500;clearTimeout(this.timer);this.timer=this._delay(function(){this._repeat(40,steps,event);},i);this._spin(steps*this.options.step,event);},_spin:function(step,event){var value=this.value()||0;if(!this.counter){this.counter=1;}value=this._adjustValue(value+step*this._increment(this.counter));if(!this.spinning||this._trigger("spin",event,{value:value})!==false){this._value(value);this.counter++;}},_increment:function(i){var incremental=this.options.incremental;if(incremental){return typeof incremental==="function"?incremental(i):Math.floor(i*i*i/50000-i*i/500+17*i/200+1);}return 1;},_precision:function(){var precision=this._precisionOf(this.options.step);if(this.options.min!==null){precision=Math.max(precision,this._precisionOf(this.options.min));}return precision;},_precisionOf:function(num){var str=num.toString(),decimal=str.indexOf(".");return decimal===-1?0:str.length-decimal-1;},_adjustValue:function(value){var base,aboveMin,options=this.options;// Make sure we're at a valid step
	// - find out where we are relative to the base (min or 0)
	base=options.min!==null?options.min:0;aboveMin=value-base;// - round to the nearest step
	aboveMin=Math.round(aboveMin/options.step)*options.step;// - rounding is based on 0, so adjust back to our base
	value=base+aboveMin;// Fix precision from bad JS floating point math
	value=parseFloat(value.toFixed(this._precision()));// Clamp the value
	if(options.max!==null&&value>options.max){return options.max;}if(options.min!==null&&value<options.min){return options.min;}return value;},_stop:function(event){if(!this.spinning){return;}clearTimeout(this.timer);clearTimeout(this.mousewheelTimer);this.counter=0;this.spinning=false;this._trigger("stop",event);},_setOption:function(key,value){var prevValue,first,last;if(key==="culture"||key==="numberFormat"){prevValue=this._parse(this.element.val());this.options[key]=value;this.element.val(this._format(prevValue));return;}if(key==="max"||key==="min"||key==="step"){if(typeof value==="string"){value=this._parse(value);}}if(key==="icons"){first=this.buttons.first().find(".ui-icon");this._removeClass(first,null,this.options.icons.up);this._addClass(first,null,value.up);last=this.buttons.last().find(".ui-icon");this._removeClass(last,null,this.options.icons.down);this._addClass(last,null,value.down);}this._super(key,value);},_setOptionDisabled:function(value){this._super(value);this._toggleClass(this.uiSpinner,null,"ui-state-disabled",!!value);this.element.prop("disabled",!!value);this.buttons.button(value?"disable":"enable");},_setOptions:spinnerModifier(function(options){this._super(options);}),_parse:function(val){if(typeof val==="string"&&val!==""){val=window.Globalize&&this.options.numberFormat?Globalize.parseFloat(val,10,this.options.culture):+val;}return val===""||isNaN(val)?null:val;},_format:function(value){if(value===""){return "";}return window.Globalize&&this.options.numberFormat?Globalize.format(value,this.options.numberFormat,this.options.culture):value;},_refresh:function(){this.element.attr({"aria-valuemin":this.options.min,"aria-valuemax":this.options.max,// TODO: what should we do with values that can't be parsed?
	"aria-valuenow":this._parse(this.element.val())});},isValid:function(){var value=this.value();// Null is invalid
	if(value===null){return false;}// If value gets adjusted, it's invalid
	return value===this._adjustValue(value);},// Update the value without triggering change
	_value:function(value,allowAny){var parsed;if(value!==""){parsed=this._parse(value);if(parsed!==null){if(!allowAny){parsed=this._adjustValue(parsed);}value=this._format(parsed);}}this.element.val(value);this._refresh();},_destroy:function(){this.element.prop("disabled",false).removeAttr("autocomplete role aria-valuemin aria-valuemax aria-valuenow");this.uiSpinner.replaceWith(this.element);},stepUp:spinnerModifier(function(steps){this._stepUp(steps);}),_stepUp:function(steps){if(this._start()){this._spin((steps||1)*this.options.step);this._stop();}},stepDown:spinnerModifier(function(steps){this._stepDown(steps);}),_stepDown:function(steps){if(this._start()){this._spin((steps||1)*-this.options.step);this._stop();}},pageUp:spinnerModifier(function(pages){this._stepUp((pages||1)*this.options.page);}),pageDown:spinnerModifier(function(pages){this._stepDown((pages||1)*this.options.page);}),value:function(newVal){if(!arguments.length){return this._parse(this.element.val());}spinnerModifier(this._value).call(this,newVal);},widget:function(){return this.uiSpinner;}});// DEPRECATED
	// TODO: switch return back to widget declaration at top of file when this is removed
	if($.uiBackCompat!==false){// Backcompat for spinner html extension points
	$.widget("ui.spinner",$.ui.spinner,{_enhance:function(){this.uiSpinner=this.element.attr("autocomplete","off").wrap(this._uiSpinnerHtml()).parent()// Add buttons
	.append(this._buttonHtml());},_uiSpinnerHtml:function(){return "<span>";},_buttonHtml:function(){return "<a></a><a></a>";}});}$.ui.spinner;/*!
	 * jQuery UI Tabs 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Tabs
	//>>group: Widgets
	//>>description: Transforms a set of container elements into a tab structure.
	//>>docs: https://api.jqueryui.com/tabs/
	//>>demos: https://jqueryui.com/tabs/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/tabs.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.tabs",{version:"1.13.3",delay:300,options:{active:null,classes:{"ui-tabs":"ui-corner-all","ui-tabs-nav":"ui-corner-all","ui-tabs-panel":"ui-corner-bottom","ui-tabs-tab":"ui-corner-top"},collapsible:false,event:"click",heightStyle:"content",hide:null,show:null,// Callbacks
	activate:null,beforeActivate:null,beforeLoad:null,load:null},_isLocal:function(){var rhash=/#.*$/;return function(anchor){var anchorUrl,locationUrl;anchorUrl=anchor.href.replace(rhash,"");locationUrl=location.href.replace(rhash,"");// Decoding may throw an error if the URL isn't UTF-8 (#9518)
	try{anchorUrl=decodeURIComponent(anchorUrl);}catch(error){}try{locationUrl=decodeURIComponent(locationUrl);}catch(error){}return anchor.hash.length>1&&anchorUrl===locationUrl;};}(),_create:function(){var that=this,options=this.options;this.running=false;this._addClass("ui-tabs","ui-widget ui-widget-content");this._toggleClass("ui-tabs-collapsible",null,options.collapsible);this._processTabs();options.active=this._initialActive();// Take disabling tabs via class attribute from HTML
	// into account and update option properly.
	if(Array.isArray(options.disabled)){options.disabled=$.uniqueSort(options.disabled.concat($.map(this.tabs.filter(".ui-state-disabled"),function(li){return that.tabs.index(li);}))).sort();}// Check for length avoids error when initializing empty list
	if(this.options.active!==false&&this.anchors.length){this.active=this._findActive(options.active);}else {this.active=$();}this._refresh();if(this.active.length){this.load(options.active);}},_initialActive:function(){var active=this.options.active,collapsible=this.options.collapsible,locationHash=location.hash.substring(1);if(active===null){// check the fragment identifier in the URL
	if(locationHash){this.tabs.each(function(i,tab){if($(tab).attr("aria-controls")===locationHash){active=i;return false;}});}// Check for a tab marked active via a class
	if(active===null){active=this.tabs.index(this.tabs.filter(".ui-tabs-active"));}// No active tab, set to false
	if(active===null||active===-1){active=this.tabs.length?0:false;}}// Handle numbers: negative, out of range
	if(active!==false){active=this.tabs.index(this.tabs.eq(active));if(active===-1){active=collapsible?false:0;}}// Don't allow collapsible: false and active: false
	if(!collapsible&&active===false&&this.anchors.length){active=0;}return active;},_getCreateEventData:function(){return {tab:this.active,panel:!this.active.length?$():this._getPanelForTab(this.active)};},_tabKeydown:function(event){var focusedTab=$($.ui.safeActiveElement(this.document[0])).closest("li"),selectedIndex=this.tabs.index(focusedTab),goingForward=true;if(this._handlePageNav(event)){return;}switch(event.keyCode){case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:selectedIndex++;break;case $.ui.keyCode.UP:case $.ui.keyCode.LEFT:goingForward=false;selectedIndex--;break;case $.ui.keyCode.END:selectedIndex=this.anchors.length-1;break;case $.ui.keyCode.HOME:selectedIndex=0;break;case $.ui.keyCode.SPACE:// Activate only, no collapsing
	event.preventDefault();clearTimeout(this.activating);this._activate(selectedIndex);return;case $.ui.keyCode.ENTER:// Toggle (cancel delayed activation, allow collapsing)
	event.preventDefault();clearTimeout(this.activating);// Determine if we should collapse or activate
	this._activate(selectedIndex===this.options.active?false:selectedIndex);return;default:return;}// Focus the appropriate tab, based on which key was pressed
	event.preventDefault();clearTimeout(this.activating);selectedIndex=this._focusNextTab(selectedIndex,goingForward);// Navigating with control/command key will prevent automatic activation
	if(!event.ctrlKey&&!event.metaKey){// Update aria-selected immediately so that AT think the tab is already selected.
	// Otherwise AT may confuse the user by stating that they need to activate the tab,
	// but the tab will already be activated by the time the announcement finishes.
	focusedTab.attr("aria-selected","false");this.tabs.eq(selectedIndex).attr("aria-selected","true");this.activating=this._delay(function(){this.option("active",selectedIndex);},this.delay);}},_panelKeydown:function(event){if(this._handlePageNav(event)){return;}// Ctrl+up moves focus to the current tab
	if(event.ctrlKey&&event.keyCode===$.ui.keyCode.UP){event.preventDefault();this.active.trigger("focus");}},// Alt+page up/down moves focus to the previous/next tab (and activates)
	_handlePageNav:function(event){if(event.altKey&&event.keyCode===$.ui.keyCode.PAGE_UP){this._activate(this._focusNextTab(this.options.active-1,false));return true;}if(event.altKey&&event.keyCode===$.ui.keyCode.PAGE_DOWN){this._activate(this._focusNextTab(this.options.active+1,true));return true;}},_findNextTab:function(index,goingForward){var lastTabIndex=this.tabs.length-1;function constrain(){if(index>lastTabIndex){index=0;}if(index<0){index=lastTabIndex;}return index;}while($.inArray(constrain(),this.options.disabled)!==-1){index=goingForward?index+1:index-1;}return index;},_focusNextTab:function(index,goingForward){index=this._findNextTab(index,goingForward);this.tabs.eq(index).trigger("focus");return index;},_setOption:function(key,value){if(key==="active"){// _activate() will handle invalid values and update this.options
	this._activate(value);return;}this._super(key,value);if(key==="collapsible"){this._toggleClass("ui-tabs-collapsible",null,value);// Setting collapsible: false while collapsed; open first panel
	if(!value&&this.options.active===false){this._activate(0);}}if(key==="event"){this._setupEvents(value);}if(key==="heightStyle"){this._setupHeightStyle(value);}},_sanitizeSelector:function(hash){return hash?hash.replace(/[!"$%&'()*+,.\/:;<=>?@\[\]\^`{|}~]/g,"\\$&"):"";},refresh:function(){var options=this.options,lis=this.tablist.children(":has(a[href])");// Get disabled tabs from class attribute from HTML
	// this will get converted to a boolean if needed in _refresh()
	options.disabled=$.map(lis.filter(".ui-state-disabled"),function(tab){return lis.index(tab);});this._processTabs();// Was collapsed or no tabs
	if(options.active===false||!this.anchors.length){options.active=false;this.active=$();// was active, but active tab is gone
	}else if(this.active.length&&!$.contains(this.tablist[0],this.active[0])){// all remaining tabs are disabled
	if(this.tabs.length===options.disabled.length){options.active=false;this.active=$();// activate previous tab
	}else {this._activate(this._findNextTab(Math.max(0,options.active-1),false));}// was active, active tab still exists
	}else {// make sure active index is correct
	options.active=this.tabs.index(this.active);}this._refresh();},_refresh:function(){this._setOptionDisabled(this.options.disabled);this._setupEvents(this.options.event);this._setupHeightStyle(this.options.heightStyle);this.tabs.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1});this.panels.not(this._getPanelForTab(this.active)).hide().attr({"aria-hidden":"true"});// Make sure one tab is in the tab order
	if(!this.active.length){this.tabs.eq(0).attr("tabIndex",0);}else {this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0});this._addClass(this.active,"ui-tabs-active","ui-state-active");this._getPanelForTab(this.active).show().attr({"aria-hidden":"false"});}},_processTabs:function(){var that=this,prevTabs=this.tabs,prevAnchors=this.anchors,prevPanels=this.panels;this.tablist=this._getList().attr("role","tablist");this._addClass(this.tablist,"ui-tabs-nav","ui-helper-reset ui-helper-clearfix ui-widget-header");// Prevent users from focusing disabled tabs via click
	this.tablist.on("mousedown"+this.eventNamespace,"> li",function(event){if($(this).is(".ui-state-disabled")){event.preventDefault();}})// Support: IE <9
	// Preventing the default action in mousedown doesn't prevent IE
	// from focusing the element, so if the anchor gets focused, blur.
	// We don't have to worry about focusing the previously focused
	// element since clicking on a non-focusable element should focus
	// the body anyway.
	.on("focus"+this.eventNamespace,".ui-tabs-anchor",function(){if($(this).closest("li").is(".ui-state-disabled")){this.blur();}});this.tabs=this.tablist.find("> li:has(a[href])").attr({role:"tab",tabIndex:-1});this._addClass(this.tabs,"ui-tabs-tab","ui-state-default");this.anchors=this.tabs.map(function(){return $("a",this)[0];}).attr({tabIndex:-1});this._addClass(this.anchors,"ui-tabs-anchor");this.panels=$();this.anchors.each(function(i,anchor){var selector,panel,panelId,anchorId=$(anchor).uniqueId().attr("id"),tab=$(anchor).closest("li"),originalAriaControls=tab.attr("aria-controls");// Inline tab
	if(that._isLocal(anchor)){selector=anchor.hash;panelId=selector.substring(1);panel=that.element.find(that._sanitizeSelector(selector));// remote tab
	}else {// If the tab doesn't already have aria-controls,
	// generate an id by using a throw-away element
	panelId=tab.attr("aria-controls")||$({}).uniqueId()[0].id;selector="#"+panelId;panel=that.element.find(selector);if(!panel.length){panel=that._createPanel(panelId);panel.insertAfter(that.panels[i-1]||that.tablist);}panel.attr("aria-live","polite");}if(panel.length){that.panels=that.panels.add(panel);}if(originalAriaControls){tab.data("ui-tabs-aria-controls",originalAriaControls);}tab.attr({"aria-controls":panelId,"aria-labelledby":anchorId});panel.attr("aria-labelledby",anchorId);});this.panels.attr("role","tabpanel");this._addClass(this.panels,"ui-tabs-panel","ui-widget-content");// Avoid memory leaks (#10056)
	if(prevTabs){this._off(prevTabs.not(this.tabs));this._off(prevAnchors.not(this.anchors));this._off(prevPanels.not(this.panels));}},// Allow overriding how to find the list for rare usage scenarios (#7715)
	_getList:function(){return this.tablist||this.element.find("ol, ul").eq(0);},_createPanel:function(id){return $("<div>").attr("id",id).data("ui-tabs-destroy",true);},_setOptionDisabled:function(disabled){var currentItem,li,i;if(Array.isArray(disabled)){if(!disabled.length){disabled=false;}else if(disabled.length===this.anchors.length){disabled=true;}}// Disable tabs
	for(i=0;li=this.tabs[i];i++){currentItem=$(li);if(disabled===true||$.inArray(i,disabled)!==-1){currentItem.attr("aria-disabled","true");this._addClass(currentItem,null,"ui-state-disabled");}else {currentItem.removeAttr("aria-disabled");this._removeClass(currentItem,null,"ui-state-disabled");}}this.options.disabled=disabled;this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,disabled===true);},_setupEvents:function(event){var events={};if(event){$.each(event.split(" "),function(index,eventName){events[eventName]="_eventHandler";});}this._off(this.anchors.add(this.tabs).add(this.panels));// Always prevent the default action, even when disabled
	this._on(true,this.anchors,{click:function(event){event.preventDefault();}});this._on(this.anchors,events);this._on(this.tabs,{keydown:"_tabKeydown"});this._on(this.panels,{keydown:"_panelKeydown"});this._focusable(this.tabs);this._hoverable(this.tabs);},_setupHeightStyle:function(heightStyle){var maxHeight,parent=this.element.parent();if(heightStyle==="fill"){maxHeight=parent.height();maxHeight-=this.element.outerHeight()-this.element.height();this.element.siblings(":visible").each(function(){var elem=$(this),position=elem.css("position");if(position==="absolute"||position==="fixed"){return;}maxHeight-=elem.outerHeight(true);});this.element.children().not(this.panels).each(function(){maxHeight-=$(this).outerHeight(true);});this.panels.each(function(){$(this).height(Math.max(0,maxHeight-$(this).innerHeight()+$(this).height()));}).css("overflow","auto");}else if(heightStyle==="auto"){maxHeight=0;this.panels.each(function(){maxHeight=Math.max(maxHeight,$(this).height("").height());}).height(maxHeight);}},_eventHandler:function(event){var options=this.options,active=this.active,anchor=$(event.currentTarget),tab=anchor.closest("li"),clickedIsActive=tab[0]===active[0],collapsing=clickedIsActive&&options.collapsible,toShow=collapsing?$():this._getPanelForTab(tab),toHide=!active.length?$():this._getPanelForTab(active),eventData={oldTab:active,oldPanel:toHide,newTab:collapsing?$():tab,newPanel:toShow};event.preventDefault();if(tab.hasClass("ui-state-disabled")||// tab is already loading
	tab.hasClass("ui-tabs-loading")||// can't switch durning an animation
	this.running||// click on active header, but not collapsible
	clickedIsActive&&!options.collapsible||// allow canceling activation
	this._trigger("beforeActivate",event,eventData)===false){return;}options.active=collapsing?false:this.tabs.index(tab);this.active=clickedIsActive?$():tab;if(this.xhr){this.xhr.abort();}if(!toHide.length&&!toShow.length){$.error("jQuery UI Tabs: Mismatching fragment identifier.");}if(toShow.length){this.load(this.tabs.index(tab),event);}this._toggle(event,eventData);},// Handles show/hide for selecting tabs
	_toggle:function(event,eventData){var that=this,toShow=eventData.newPanel,toHide=eventData.oldPanel;this.running=true;function complete(){that.running=false;that._trigger("activate",event,eventData);}function show(){that._addClass(eventData.newTab.closest("li"),"ui-tabs-active","ui-state-active");if(toShow.length&&that.options.show){that._show(toShow,that.options.show,complete);}else {toShow.show();complete();}}// Start out by hiding, then showing, then completing
	if(toHide.length&&this.options.hide){this._hide(toHide,this.options.hide,function(){that._removeClass(eventData.oldTab.closest("li"),"ui-tabs-active","ui-state-active");show();});}else {this._removeClass(eventData.oldTab.closest("li"),"ui-tabs-active","ui-state-active");toHide.hide();show();}toHide.attr("aria-hidden","true");eventData.oldTab.attr({"aria-selected":"false","aria-expanded":"false"});// If we're switching tabs, remove the old tab from the tab order.
	// If we're opening from collapsed state, remove the previous tab from the tab order.
	// If we're collapsing, then keep the collapsing tab in the tab order.
	if(toShow.length&&toHide.length){eventData.oldTab.attr("tabIndex",-1);}else if(toShow.length){this.tabs.filter(function(){return $(this).attr("tabIndex")===0;}).attr("tabIndex",-1);}toShow.attr("aria-hidden","false");eventData.newTab.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0});},_activate:function(index){var anchor,active=this._findActive(index);// Trying to activate the already active panel
	if(active[0]===this.active[0]){return;}// Trying to collapse, simulate a click on the current active header
	if(!active.length){active=this.active;}anchor=active.find(".ui-tabs-anchor")[0];this._eventHandler({target:anchor,currentTarget:anchor,preventDefault:$.noop});},_findActive:function(index){return index===false?$():this.tabs.eq(index);},_getIndex:function(index){// meta-function to give users option to provide a href string instead of a numerical index.
	if(typeof index==="string"){index=this.anchors.index(this.anchors.filter("[href$='"+$.escapeSelector(index)+"']"));}return index;},_destroy:function(){if(this.xhr){this.xhr.abort();}this.tablist.removeAttr("role").off(this.eventNamespace);this.anchors.removeAttr("role tabIndex").removeUniqueId();this.tabs.add(this.panels).each(function(){if($.data(this,"ui-tabs-destroy")){$(this).remove();}else {$(this).removeAttr("role tabIndex "+"aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded");}});this.tabs.each(function(){var li=$(this),prev=li.data("ui-tabs-aria-controls");if(prev){li.attr("aria-controls",prev).removeData("ui-tabs-aria-controls");}else {li.removeAttr("aria-controls");}});this.panels.show();if(this.options.heightStyle!=="content"){this.panels.css("height","");}},enable:function(index){var disabled=this.options.disabled;if(disabled===false){return;}if(index===undefined){disabled=false;}else {index=this._getIndex(index);if(Array.isArray(disabled)){disabled=$.map(disabled,function(num){return num!==index?num:null;});}else {disabled=$.map(this.tabs,function(li,num){return num!==index?num:null;});}}this._setOptionDisabled(disabled);},disable:function(index){var disabled=this.options.disabled;if(disabled===true){return;}if(index===undefined){disabled=true;}else {index=this._getIndex(index);if($.inArray(index,disabled)!==-1){return;}if(Array.isArray(disabled)){disabled=$.merge([index],disabled).sort();}else {disabled=[index];}}this._setOptionDisabled(disabled);},load:function(index,event){index=this._getIndex(index);var that=this,tab=this.tabs.eq(index),anchor=tab.find(".ui-tabs-anchor"),panel=this._getPanelForTab(tab),eventData={tab:tab,panel:panel},complete=function(jqXHR,status){if(status==="abort"){that.panels.stop(false,true);}that._removeClass(tab,"ui-tabs-loading");panel.removeAttr("aria-busy");if(jqXHR===that.xhr){delete that.xhr;}};// Not remote
	if(this._isLocal(anchor[0])){return;}this.xhr=$.ajax(this._ajaxSettings(anchor,event,eventData));// Support: jQuery <1.8
	// jQuery <1.8 returns false if the request is canceled in beforeSend,
	// but as of 1.8, $.ajax() always returns a jqXHR object.
	if(this.xhr&&this.xhr.statusText!=="canceled"){this._addClass(tab,"ui-tabs-loading");panel.attr("aria-busy","true");this.xhr.done(function(response,status,jqXHR){// support: jQuery <1.8
	// https://bugs.jquery.com/ticket/11778
	setTimeout(function(){panel.html(response);that._trigger("load",event,eventData);complete(jqXHR,status);},1);}).fail(function(jqXHR,status){// support: jQuery <1.8
	// https://bugs.jquery.com/ticket/11778
	setTimeout(function(){complete(jqXHR,status);},1);});}},_ajaxSettings:function(anchor,event,eventData){var that=this;return {// Support: IE <11 only
	// Strip any hash that exists to prevent errors with the Ajax request
	url:anchor.attr("href").replace(/#.*$/,""),beforeSend:function(jqXHR,settings){return that._trigger("beforeLoad",event,$.extend({jqXHR:jqXHR,ajaxSettings:settings},eventData));}};},_getPanelForTab:function(tab){var id=$(tab).attr("aria-controls");return this.element.find(this._sanitizeSelector("#"+id));}});// DEPRECATED
	// TODO: Switch return back to widget declaration at top of file when this is removed
	if($.uiBackCompat!==false){// Backcompat for ui-tab class (now ui-tabs-tab)
	$.widget("ui.tabs",$.ui.tabs,{_processTabs:function(){this._superApply(arguments);this._addClass(this.tabs,"ui-tab");}});}$.ui.tabs;/*!
	 * jQuery UI Tooltip 1.13.3
	 * https://jqueryui.com
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license.
	 * https://jquery.org/license
	 *///>>label: Tooltip
	//>>group: Widgets
	//>>description: Shows additional information for any element on hover or focus.
	//>>docs: https://api.jqueryui.com/tooltip/
	//>>demos: https://jqueryui.com/tooltip/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/tooltip.css
	//>>css.theme: ../../themes/base/theme.css
	$.widget("ui.tooltip",{version:"1.13.3",options:{classes:{"ui-tooltip":"ui-corner-all ui-widget-shadow"},content:function(){var title=$(this).attr("title");// Escape title, since we're going from an attribute to raw HTML
	return $("<a>").text(title).html();},hide:true,// Disabled elements have inconsistent behavior across browsers (#8661)
	items:"[title]:not([disabled])",position:{my:"left top+15",at:"left bottom",collision:"flipfit flip"},show:true,track:false,// Callbacks
	close:null,open:null},_addDescribedBy:function(elem,id){var describedby=(elem.attr("aria-describedby")||"").split(/\s+/);describedby.push(id);elem.data("ui-tooltip-id",id).attr("aria-describedby",String.prototype.trim.call(describedby.join(" ")));},_removeDescribedBy:function(elem){var id=elem.data("ui-tooltip-id"),describedby=(elem.attr("aria-describedby")||"").split(/\s+/),index=$.inArray(id,describedby);if(index!==-1){describedby.splice(index,1);}elem.removeData("ui-tooltip-id");describedby=String.prototype.trim.call(describedby.join(" "));if(describedby){elem.attr("aria-describedby",describedby);}else {elem.removeAttr("aria-describedby");}},_create:function(){this._on({mouseover:"open",focusin:"open"});// IDs of generated tooltips, needed for destroy
	this.tooltips={};// IDs of parent tooltips where we removed the title attribute
	this.parents={};// Append the aria-live region so tooltips announce correctly
	this.liveRegion=$("<div>").attr({role:"log","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body);this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible");this.disabledTitles=$([]);},_setOption:function(key,value){var that=this;this._super(key,value);if(key==="content"){$.each(this.tooltips,function(id,tooltipData){that._updateContent(tooltipData.element);});}},_setOptionDisabled:function(value){this[value?"_disable":"_enable"]();},_disable:function(){var that=this;// Close open tooltips
	$.each(this.tooltips,function(id,tooltipData){var event=$.Event("blur");event.target=event.currentTarget=tooltipData.element[0];that.close(event,true);});// Remove title attributes to prevent native tooltips
	this.disabledTitles=this.disabledTitles.add(this.element.find(this.options.items).addBack().filter(function(){var element=$(this);if(element.is("[title]")){return element.data("ui-tooltip-title",element.attr("title")).removeAttr("title");}}));},_enable:function(){// restore title attributes
	this.disabledTitles.each(function(){var element=$(this);if(element.data("ui-tooltip-title")){element.attr("title",element.data("ui-tooltip-title"));}});this.disabledTitles=$([]);},open:function(event){var that=this,target=$(event?event.target:this.element)// we need closest here due to mouseover bubbling,
	// but always pointing at the same event target
	.closest(this.options.items);// No element to show a tooltip for or the tooltip is already open
	if(!target.length||target.data("ui-tooltip-id")){return;}if(target.attr("title")){target.data("ui-tooltip-title",target.attr("title"));}target.data("ui-tooltip-open",true);// Kill parent tooltips, custom or native, for hover
	if(event&&event.type==="mouseover"){target.parents().each(function(){var parent=$(this),blurEvent;if(parent.data("ui-tooltip-open")){blurEvent=$.Event("blur");blurEvent.target=blurEvent.currentTarget=this;that.close(blurEvent,true);}if(parent.attr("title")){parent.uniqueId();that.parents[this.id]={element:this,title:parent.attr("title")};parent.attr("title","");}});}this._registerCloseHandlers(event,target);this._updateContent(target,event);},_updateContent:function(target,event){var content,contentOption=this.options.content,that=this,eventType=event?event.type:null;if(typeof contentOption==="string"||contentOption.nodeType||contentOption.jquery){return this._open(event,target,contentOption);}content=contentOption.call(target[0],function(response){// IE may instantly serve a cached response for ajax requests
	// delay this call to _open so the other call to _open runs first
	that._delay(function(){// Ignore async response if tooltip was closed already
	if(!target.data("ui-tooltip-open")){return;}// JQuery creates a special event for focusin when it doesn't
	// exist natively. To improve performance, the native event
	// object is reused and the type is changed. Therefore, we can't
	// rely on the type being correct after the event finished
	// bubbling, so we set it back to the previous value. (#8740)
	if(event){event.type=eventType;}this._open(event,target,response);});});if(content){this._open(event,target,content);}},_open:function(event,target,content){var tooltipData,tooltip,delayedShow,a11yContent,positionOption=$.extend({},this.options.position);if(!content){return;}// Content can be updated multiple times. If the tooltip already
	// exists, then just update the content and bail.
	tooltipData=this._find(target);if(tooltipData){tooltipData.tooltip.find(".ui-tooltip-content").html(content);return;}// If we have a title, clear it to prevent the native tooltip
	// we have to check first to avoid defining a title if none exists
	// (we don't want to cause an element to start matching [title])
	//
	// We use removeAttr only for key events, to allow IE to export the correct
	// accessible attributes. For mouse events, set to empty string to avoid
	// native tooltip showing up (happens only when removing inside mouseover).
	if(target.is("[title]")){if(event&&event.type==="mouseover"){target.attr("title","");}else {target.removeAttr("title");}}tooltipData=this._tooltip(target);tooltip=tooltipData.tooltip;this._addDescribedBy(target,tooltip.attr("id"));tooltip.find(".ui-tooltip-content").html(content);// Support: Voiceover on OS X, JAWS on IE <= 9
	// JAWS announces deletions even when aria-relevant="additions"
	// Voiceover will sometimes re-read the entire log region's contents from the beginning
	this.liveRegion.children().hide();a11yContent=$("<div>").html(tooltip.find(".ui-tooltip-content").html());a11yContent.removeAttr("name").find("[name]").removeAttr("name");a11yContent.removeAttr("id").find("[id]").removeAttr("id");a11yContent.appendTo(this.liveRegion);function position(event){positionOption.of=event;if(tooltip.is(":hidden")){return;}tooltip.position(positionOption);}if(this.options.track&&event&&/^mouse/.test(event.type)){this._on(this.document,{mousemove:position});// trigger once to override element-relative positioning
	position(event);}else {tooltip.position($.extend({of:target},this.options.position));}tooltip.hide();this._show(tooltip,this.options.show);// Handle tracking tooltips that are shown with a delay (#8644). As soon
	// as the tooltip is visible, position the tooltip using the most recent
	// event.
	// Adds the check to add the timers only when both delay and track options are set (#14682)
	if(this.options.track&&this.options.show&&this.options.show.delay){delayedShow=this.delayedShow=setInterval(function(){if(tooltip.is(":visible")){position(positionOption.of);clearInterval(delayedShow);}},13);}this._trigger("open",event,{tooltip:tooltip});},_registerCloseHandlers:function(event,target){var events={keyup:function(event){if(event.keyCode===$.ui.keyCode.ESCAPE){var fakeEvent=$.Event(event);fakeEvent.currentTarget=target[0];this.close(fakeEvent,true);}}};// Only bind remove handler for delegated targets. Non-delegated
	// tooltips will handle this in destroy.
	if(target[0]!==this.element[0]){events.remove=function(){var targetElement=this._find(target);if(targetElement){this._removeTooltip(targetElement.tooltip);}};}if(!event||event.type==="mouseover"){events.mouseleave="close";}if(!event||event.type==="focusin"){events.focusout="close";}this._on(true,target,events);},close:function(event){var tooltip,that=this,target=$(event?event.currentTarget:this.element),tooltipData=this._find(target);// The tooltip may already be closed
	if(!tooltipData){// We set ui-tooltip-open immediately upon open (in open()), but only set the
	// additional data once there's actually content to show (in _open()). So even if the
	// tooltip doesn't have full data, we always remove ui-tooltip-open in case we're in
	// the period between open() and _open().
	target.removeData("ui-tooltip-open");return;}tooltip=tooltipData.tooltip;// Disabling closes the tooltip, so we need to track when we're closing
	// to avoid an infinite loop in case the tooltip becomes disabled on close
	if(tooltipData.closing){return;}// Clear the interval for delayed tracking tooltips
	clearInterval(this.delayedShow);// Only set title if we had one before (see comment in _open())
	// If the title attribute has changed since open(), don't restore
	if(target.data("ui-tooltip-title")&&!target.attr("title")){target.attr("title",target.data("ui-tooltip-title"));}this._removeDescribedBy(target);tooltipData.hiding=true;tooltip.stop(true);this._hide(tooltip,this.options.hide,function(){that._removeTooltip($(this));});target.removeData("ui-tooltip-open");this._off(target,"mouseleave focusout keyup");// Remove 'remove' binding only on delegated targets
	if(target[0]!==this.element[0]){this._off(target,"remove");}this._off(this.document,"mousemove");if(event&&event.type==="mouseleave"){$.each(this.parents,function(id,parent){$(parent.element).attr("title",parent.title);delete that.parents[id];});}tooltipData.closing=true;this._trigger("close",event,{tooltip:tooltip});if(!tooltipData.hiding){tooltipData.closing=false;}},_tooltip:function(element){var tooltip=$("<div>").attr("role","tooltip"),content=$("<div>").appendTo(tooltip),id=tooltip.uniqueId().attr("id");this._addClass(content,"ui-tooltip-content");this._addClass(tooltip,"ui-tooltip","ui-widget ui-widget-content");tooltip.appendTo(this._appendTo(element));return this.tooltips[id]={element:element,tooltip:tooltip};},_find:function(target){var id=target.data("ui-tooltip-id");return id?this.tooltips[id]:null;},_removeTooltip:function(tooltip){// Clear the interval for delayed tracking tooltips
	clearInterval(this.delayedShow);tooltip.remove();delete this.tooltips[tooltip.attr("id")];},_appendTo:function(target){var element=target.closest(".ui-front, dialog");if(!element.length){element=this.document[0].body;}return element;},_destroy:function(){var that=this;// Close open tooltips
	$.each(this.tooltips,function(id,tooltipData){// Delegate to close method to handle common cleanup
	var event=$.Event("blur"),element=tooltipData.element;event.target=event.currentTarget=element[0];that.close(event,true);// Remove immediately; destroying an open tooltip doesn't use the
	// hide animation
	$("#"+id).remove();// Restore the title
	if(element.data("ui-tooltip-title")){// If the title attribute has changed since open(), don't restore
	if(!element.attr("title")){element.attr("title",element.data("ui-tooltip-title"));}element.removeData("ui-tooltip-title");}});this.liveRegion.remove();}});// DEPRECATED
	// TODO: Switch return back to widget declaration at top of file when this is removed
	if($.uiBackCompat!==false){// Backcompat for tooltipClass option
	$.widget("ui.tooltip",$.ui.tooltip,{options:{tooltipClass:null},_tooltip:function(){var tooltipData=this._superApply(arguments);if(this.options.tooltipClass){tooltipData.tooltip.addClass(this.options.tooltipClass);}return tooltipData;}});}$.ui.tooltip;});

	/* Javascript plotting library for jQuery, version 0.8.3.

	Copyright (c) 2007-2014 IOLA and Ole Laursen.
	Licensed under the MIT license.

	*/

	// first an inline dependency, jquery.colorhelpers.js, we inline it here
	// for convenience

	/* Plugin for jQuery for working with colors.
	 *
	 * Version 1.1.
	 *
	 * Inspiration from jQuery color animation plugin by John Resig.
	 *
	 * Released under the MIT license by Ole Laursen, October 2009.
	 *
	 * Examples:
	 *
	 *   $.color.parse("#fff").scale('rgb', 0.25).add('a', -0.5).toString()
	 *   var c = $.color.extract($("#mydiv"), 'background-color');
	 *   console.log(c.r, c.g, c.b, c.a);
	 *   $.color.make(100, 50, 25, 0.4).toString() // returns "rgba(100,50,25,0.4)"
	 *
	 * Note that .scale() and .add() return the same modified object
	 * instead of making a new one.
	 *
	 * V. 1.1: Fix error handling so e.g. parsing an empty string does
	 * produce a color rather than just crashing.
	 */
	(function ($) {
	  $.color = {};
	  $.color.make = function (r, g, b, a) {
	    var o = {};
	    o.r = r || 0;
	    o.g = g || 0;
	    o.b = b || 0;
	    o.a = a != null ? a : 1;
	    o.add = function (c, d) {
	      for (var i = 0; i < c.length; ++i) o[c.charAt(i)] += d;
	      return o.normalize();
	    };
	    o.scale = function (c, f) {
	      for (var i = 0; i < c.length; ++i) o[c.charAt(i)] *= f;
	      return o.normalize();
	    };
	    o.toString = function () {
	      if (o.a >= 1) {
	        return "rgb(" + [o.r, o.g, o.b].join(",") + ")";
	      } else {
	        return "rgba(" + [o.r, o.g, o.b, o.a].join(",") + ")";
	      }
	    };
	    o.normalize = function () {
	      function clamp(min, value, max) {
	        return value < min ? min : value > max ? max : value;
	      }
	      o.r = clamp(0, parseInt(o.r), 255);
	      o.g = clamp(0, parseInt(o.g), 255);
	      o.b = clamp(0, parseInt(o.b), 255);
	      o.a = clamp(0, o.a, 1);
	      return o;
	    };
	    o.clone = function () {
	      return $.color.make(o.r, o.b, o.g, o.a);
	    };
	    return o.normalize();
	  };
	  $.color.extract = function (elem, css) {
	    var c;
	    do {
	      c = elem.css(css).toLowerCase();
	      if (c != "" && c != "transparent") break;
	      elem = elem.parent();
	    } while (elem.length && !$.nodeName(elem.get(0), "body"));
	    if (c == "rgba(0, 0, 0, 0)") c = "transparent";
	    return $.color.parse(c);
	  };
	  $.color.parse = function (str) {
	    var res,
	      m = $.color.make;
	    if (res = /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(str)) return m(parseInt(res[1], 10), parseInt(res[2], 10), parseInt(res[3], 10));
	    if (res = /rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str)) return m(parseInt(res[1], 10), parseInt(res[2], 10), parseInt(res[3], 10), parseFloat(res[4]));
	    if (res = /rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(str)) return m(parseFloat(res[1]) * 2.55, parseFloat(res[2]) * 2.55, parseFloat(res[3]) * 2.55);
	    if (res = /rgba\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str)) return m(parseFloat(res[1]) * 2.55, parseFloat(res[2]) * 2.55, parseFloat(res[3]) * 2.55, parseFloat(res[4]));
	    if (res = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(str)) return m(parseInt(res[1], 16), parseInt(res[2], 16), parseInt(res[3], 16));
	    if (res = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(str)) return m(parseInt(res[1] + res[1], 16), parseInt(res[2] + res[2], 16), parseInt(res[3] + res[3], 16));
	    var name = $.trim(str).toLowerCase();
	    if (name == "transparent") return m(255, 255, 255, 0);else {
	      res = lookupColors[name] || [0, 0, 0];
	      return m(res[0], res[1], res[2]);
	    }
	  };
	  var lookupColors = {
	    aqua: [0, 255, 255],
	    azure: [240, 255, 255],
	    beige: [245, 245, 220],
	    black: [0, 0, 0],
	    blue: [0, 0, 255],
	    brown: [165, 42, 42],
	    cyan: [0, 255, 255],
	    darkblue: [0, 0, 139],
	    darkcyan: [0, 139, 139],
	    darkgrey: [169, 169, 169],
	    darkgreen: [0, 100, 0],
	    darkkhaki: [189, 183, 107],
	    darkmagenta: [139, 0, 139],
	    darkolivegreen: [85, 107, 47],
	    darkorange: [255, 140, 0],
	    darkorchid: [153, 50, 204],
	    darkred: [139, 0, 0],
	    darksalmon: [233, 150, 122],
	    darkviolet: [148, 0, 211],
	    fuchsia: [255, 0, 255],
	    gold: [255, 215, 0],
	    green: [0, 128, 0],
	    indigo: [75, 0, 130],
	    khaki: [240, 230, 140],
	    lightblue: [173, 216, 230],
	    lightcyan: [224, 255, 255],
	    lightgreen: [144, 238, 144],
	    lightgrey: [211, 211, 211],
	    lightpink: [255, 182, 193],
	    lightyellow: [255, 255, 224],
	    lime: [0, 255, 0],
	    magenta: [255, 0, 255],
	    maroon: [128, 0, 0],
	    navy: [0, 0, 128],
	    olive: [128, 128, 0],
	    orange: [255, 165, 0],
	    pink: [255, 192, 203],
	    purple: [128, 0, 128],
	    violet: [128, 0, 128],
	    red: [255, 0, 0],
	    silver: [192, 192, 192],
	    white: [255, 255, 255],
	    yellow: [255, 255, 0]
	  };
	})(jQuery);

	// the actual Flot code
	(function ($) {
	  // Cache the prototype hasOwnProperty for faster access

	  var hasOwnProperty = Object.prototype.hasOwnProperty;

	  // A shim to provide 'detach' to jQuery versions prior to 1.4.  Using a DOM
	  // operation produces the same effect as detach, i.e. removing the element
	  // without touching its jQuery data.

	  // Do not merge this into Flot 0.9, since it requires jQuery 1.4.4+.

	  if (!$.fn.detach) {
	    $.fn.detach = function () {
	      return this.each(function () {
	        if (this.parentNode) {
	          this.parentNode.removeChild(this);
	        }
	      });
	    };
	  }

	  ///////////////////////////////////////////////////////////////////////////
	  // The Canvas object is a wrapper around an HTML5 <canvas> tag.
	  //
	  // @constructor
	  // @param {string} cls List of classes to apply to the canvas.
	  // @param {element} container Element onto which to append the canvas.
	  //
	  // Requiring a container is a little iffy, but unfortunately canvas
	  // operations don't work unless the canvas is attached to the DOM.

	  function Canvas(cls, container) {
	    var element = container.children("." + cls)[0];
	    if (element == null) {
	      element = document.createElement("canvas");
	      element.className = cls;
	      $(element).css({
	        direction: "ltr",
	        position: "absolute",
	        left: 0,
	        top: 0
	      }).appendTo(container);

	      // If HTML5 Canvas isn't available, fall back to [Ex|Flash]canvas

	      if (!element.getContext) {
	        if (window.G_vmlCanvasManager) {
	          element = window.G_vmlCanvasManager.initElement(element);
	        } else {
	          throw new Error("Canvas is not available. If you're using IE with a fall-back such as Excanvas, then there's either a mistake in your conditional include, or the page has no DOCTYPE and is rendering in Quirks Mode.");
	        }
	      }
	    }
	    this.element = element;
	    var context = this.context = element.getContext("2d");

	    // Determine the screen's ratio of physical to device-independent
	    // pixels.  This is the ratio between the canvas width that the browser
	    // advertises and the number of pixels actually present in that space.

	    // The iPhone 4, for example, has a device-independent width of 320px,
	    // but its screen is actually 640px wide.  It therefore has a pixel
	    // ratio of 2, while most normal devices have a ratio of 1.

	    var devicePixelRatio = window.devicePixelRatio || 1,
	      backingStoreRatio = context.webkitBackingStorePixelRatio || context.mozBackingStorePixelRatio || context.msBackingStorePixelRatio || context.oBackingStorePixelRatio || context.backingStorePixelRatio || 1;
	    this.pixelRatio = devicePixelRatio / backingStoreRatio;

	    // Size the canvas to match the internal dimensions of its container

	    this.resize(container.width(), container.height());

	    // Collection of HTML div layers for text overlaid onto the canvas

	    this.textContainer = null;
	    this.text = {};

	    // Cache of text fragments and metrics, so we can avoid expensively
	    // re-calculating them when the plot is re-rendered in a loop.

	    this._textCache = {};
	  }

	  // Resizes the canvas to the given dimensions.
	  //
	  // @param {number} width New width of the canvas, in pixels.
	  // @param {number} width New height of the canvas, in pixels.

	  Canvas.prototype.resize = function (width, height) {
	    if (width <= 0 || height <= 0) {
	      throw new Error("Invalid dimensions for plot, width = " + width + ", height = " + height);
	    }
	    var element = this.element,
	      context = this.context,
	      pixelRatio = this.pixelRatio;

	    // Resize the canvas, increasing its density based on the display's
	    // pixel ratio; basically giving it more pixels without increasing the
	    // size of its element, to take advantage of the fact that retina
	    // displays have that many more pixels in the same advertised space.

	    // Resizing should reset the state (excanvas seems to be buggy though)

	    if (this.width != width) {
	      element.width = width * pixelRatio;
	      element.style.width = width + "px";
	      this.width = width;
	    }
	    if (this.height != height) {
	      element.height = height * pixelRatio;
	      element.style.height = height + "px";
	      this.height = height;
	    }

	    // Save the context, so we can reset in case we get replotted.  The
	    // restore ensure that we're really back at the initial state, and
	    // should be safe even if we haven't saved the initial state yet.

	    context.restore();
	    context.save();

	    // Scale the coordinate space to match the display density; so even though we
	    // may have twice as many pixels, we still want lines and other drawing to
	    // appear at the same size; the extra pixels will just make them crisper.

	    context.scale(pixelRatio, pixelRatio);
	  };

	  // Clears the entire canvas area, not including any overlaid HTML text

	  Canvas.prototype.clear = function () {
	    this.context.clearRect(0, 0, this.width, this.height);
	  };

	  // Finishes rendering the canvas, including managing the text overlay.

	  Canvas.prototype.render = function () {
	    var cache = this._textCache;

	    // For each text layer, add elements marked as active that haven't
	    // already been rendered, and remove those that are no longer active.

	    for (var layerKey in cache) {
	      if (hasOwnProperty.call(cache, layerKey)) {
	        var layer = this.getTextLayer(layerKey),
	          layerCache = cache[layerKey];
	        layer.hide();
	        for (var styleKey in layerCache) {
	          if (hasOwnProperty.call(layerCache, styleKey)) {
	            var styleCache = layerCache[styleKey];
	            for (var key in styleCache) {
	              if (hasOwnProperty.call(styleCache, key)) {
	                var positions = styleCache[key].positions;
	                for (var i = 0, position; position = positions[i]; i++) {
	                  if (position.active) {
	                    if (!position.rendered) {
	                      layer.append(position.element);
	                      position.rendered = true;
	                    }
	                  } else {
	                    positions.splice(i--, 1);
	                    if (position.rendered) {
	                      position.element.detach();
	                    }
	                  }
	                }
	                if (positions.length == 0) {
	                  delete styleCache[key];
	                }
	              }
	            }
	          }
	        }
	        layer.show();
	      }
	    }
	  };

	  // Creates (if necessary) and returns the text overlay container.
	  //
	  // @param {string} classes String of space-separated CSS classes used to
	  //     uniquely identify the text layer.
	  // @return {object} The jQuery-wrapped text-layer div.

	  Canvas.prototype.getTextLayer = function (classes) {
	    var layer = this.text[classes];

	    // Create the text layer if it doesn't exist

	    if (layer == null) {
	      // Create the text layer container, if it doesn't exist

	      if (this.textContainer == null) {
	        this.textContainer = $("<div class='flot-text'></div>").css({
	          position: "absolute",
	          top: 0,
	          left: 0,
	          bottom: 0,
	          right: 0,
	          'font-size': "smaller",
	          color: "#545454"
	        }).insertAfter(this.element);
	      }
	      layer = this.text[classes] = $("<div></div>").addClass(classes).css({
	        position: "absolute",
	        top: 0,
	        left: 0,
	        bottom: 0,
	        right: 0
	      }).appendTo(this.textContainer);
	    }
	    return layer;
	  };

	  // Creates (if necessary) and returns a text info object.
	  //
	  // The object looks like this:
	  //
	  // {
	  //     width: Width of the text's wrapper div.
	  //     height: Height of the text's wrapper div.
	  //     element: The jQuery-wrapped HTML div containing the text.
	  //     positions: Array of positions at which this text is drawn.
	  // }
	  //
	  // The positions array contains objects that look like this:
	  //
	  // {
	  //     active: Flag indicating whether the text should be visible.
	  //     rendered: Flag indicating whether the text is currently visible.
	  //     element: The jQuery-wrapped HTML div containing the text.
	  //     x: X coordinate at which to draw the text.
	  //     y: Y coordinate at which to draw the text.
	  // }
	  //
	  // Each position after the first receives a clone of the original element.
	  //
	  // The idea is that that the width, height, and general 'identity' of the
	  // text is constant no matter where it is placed; the placements are a
	  // secondary property.
	  //
	  // Canvas maintains a cache of recently-used text info objects; getTextInfo
	  // either returns the cached element or creates a new entry.
	  //
	  // @param {string} layer A string of space-separated CSS classes uniquely
	  //     identifying the layer containing this text.
	  // @param {string} text Text string to retrieve info for.
	  // @param {(string|object)=} font Either a string of space-separated CSS
	  //     classes or a font-spec object, defining the text's font and style.
	  // @param {number=} angle Angle at which to rotate the text, in degrees.
	  //     Angle is currently unused, it will be implemented in the future.
	  // @param {number=} width Maximum width of the text before it wraps.
	  // @return {object} a text info object.

	  Canvas.prototype.getTextInfo = function (layer, text, font, angle, width) {
	    var textStyle, layerCache, styleCache, info;

	    // Cast the value to a string, in case we were given a number or such

	    text = "" + text;

	    // If the font is a font-spec object, generate a CSS font definition

	    if (typeof font === "object") {
	      textStyle = font.style + " " + font.variant + " " + font.weight + " " + font.size + "px/" + font.lineHeight + "px " + font.family;
	    } else {
	      textStyle = font;
	    }

	    // Retrieve (or create) the cache for the text's layer and styles

	    layerCache = this._textCache[layer];
	    if (layerCache == null) {
	      layerCache = this._textCache[layer] = {};
	    }
	    styleCache = layerCache[textStyle];
	    if (styleCache == null) {
	      styleCache = layerCache[textStyle] = {};
	    }
	    info = styleCache[text];

	    // If we can't find a matching element in our cache, create a new one

	    if (info == null) {
	      var element = $("<div></div>").html(text).css({
	        position: "absolute",
	        'max-width': width,
	        top: -9999
	      }).appendTo(this.getTextLayer(layer));
	      if (typeof font === "object") {
	        element.css({
	          font: textStyle,
	          color: font.color
	        });
	      } else if (typeof font === "string") {
	        element.addClass(font);
	      }
	      info = styleCache[text] = {
	        width: element.outerWidth(true),
	        height: element.outerHeight(true),
	        element: element,
	        positions: []
	      };
	      element.detach();
	    }
	    return info;
	  };

	  // Adds a text string to the canvas text overlay.
	  //
	  // The text isn't drawn immediately; it is marked as rendering, which will
	  // result in its addition to the canvas on the next render pass.
	  //
	  // @param {string} layer A string of space-separated CSS classes uniquely
	  //     identifying the layer containing this text.
	  // @param {number} x X coordinate at which to draw the text.
	  // @param {number} y Y coordinate at which to draw the text.
	  // @param {string} text Text string to draw.
	  // @param {(string|object)=} font Either a string of space-separated CSS
	  //     classes or a font-spec object, defining the text's font and style.
	  // @param {number=} angle Angle at which to rotate the text, in degrees.
	  //     Angle is currently unused, it will be implemented in the future.
	  // @param {number=} width Maximum width of the text before it wraps.
	  // @param {string=} halign Horizontal alignment of the text; either "left",
	  //     "center" or "right".
	  // @param {string=} valign Vertical alignment of the text; either "top",
	  //     "middle" or "bottom".

	  Canvas.prototype.addText = function (layer, x, y, text, font, angle, width, halign, valign) {
	    var info = this.getTextInfo(layer, text, font, angle, width),
	      positions = info.positions;

	    // Tweak the div's position to match the text's alignment

	    if (halign == "center") {
	      x -= info.width / 2;
	    } else if (halign == "right") {
	      x -= info.width;
	    }
	    if (valign == "middle") {
	      y -= info.height / 2;
	    } else if (valign == "bottom") {
	      y -= info.height;
	    }

	    // Determine whether this text already exists at this position.
	    // If so, mark it for inclusion in the next render pass.

	    for (var i = 0, position; position = positions[i]; i++) {
	      if (position.x == x && position.y == y) {
	        position.active = true;
	        return;
	      }
	    }

	    // If the text doesn't exist at this position, create a new entry

	    // For the very first position we'll re-use the original element,
	    // while for subsequent ones we'll clone it.

	    position = {
	      active: true,
	      rendered: false,
	      element: positions.length ? info.element.clone() : info.element,
	      x: x,
	      y: y
	    };
	    positions.push(position);

	    // Move the element to its final position within the container

	    position.element.css({
	      top: Math.round(y),
	      left: Math.round(x),
	      'text-align': halign // In case the text wraps
	    });
	  };

	  // Removes one or more text strings from the canvas text overlay.
	  //
	  // If no parameters are given, all text within the layer is removed.
	  //
	  // Note that the text is not immediately removed; it is simply marked as
	  // inactive, which will result in its removal on the next render pass.
	  // This avoids the performance penalty for 'clear and redraw' behavior,
	  // where we potentially get rid of all text on a layer, but will likely
	  // add back most or all of it later, as when redrawing axes, for example.
	  //
	  // @param {string} layer A string of space-separated CSS classes uniquely
	  //     identifying the layer containing this text.
	  // @param {number=} x X coordinate of the text.
	  // @param {number=} y Y coordinate of the text.
	  // @param {string=} text Text string to remove.
	  // @param {(string|object)=} font Either a string of space-separated CSS
	  //     classes or a font-spec object, defining the text's font and style.
	  // @param {number=} angle Angle at which the text is rotated, in degrees.
	  //     Angle is currently unused, it will be implemented in the future.

	  Canvas.prototype.removeText = function (layer, x, y, text, font, angle) {
	    if (text == null) {
	      var layerCache = this._textCache[layer];
	      if (layerCache != null) {
	        for (var styleKey in layerCache) {
	          if (hasOwnProperty.call(layerCache, styleKey)) {
	            var styleCache = layerCache[styleKey];
	            for (var key in styleCache) {
	              if (hasOwnProperty.call(styleCache, key)) {
	                var positions = styleCache[key].positions;
	                for (var i = 0, position; position = positions[i]; i++) {
	                  position.active = false;
	                }
	              }
	            }
	          }
	        }
	      }
	    } else {
	      var positions = this.getTextInfo(layer, text, font, angle).positions;
	      for (var i = 0, position; position = positions[i]; i++) {
	        if (position.x == x && position.y == y) {
	          position.active = false;
	        }
	      }
	    }
	  };

	  ///////////////////////////////////////////////////////////////////////////
	  // The top-level container for the entire plot.

	  function Plot(placeholder, data_, options_, plugins) {
	    // data is on the form:
	    //   [ series1, series2 ... ]
	    // where series is either just the data as [ [x1, y1], [x2, y2], ... ]
	    // or { data: [ [x1, y1], [x2, y2], ... ], label: "some label", ... }

	    var series = [],
	      options = {
	        // the color theme used for graphs
	        colors: ["#edc240", "#afd8f8", "#cb4b4b", "#4da74d", "#9440ed"],
	        legend: {
	          show: true,
	          noColumns: 1,
	          // number of colums in legend table
	          labelFormatter: null,
	          // fn: string -> string
	          labelBoxBorderColor: "#ccc",
	          // border color for the little label boxes
	          container: null,
	          // container (as jQuery object) to put legend in, null means default on top of graph
	          position: "ne",
	          // position of default legend container within plot
	          margin: 5,
	          // distance from grid edge to default legend container within plot
	          backgroundColor: null,
	          // null means auto-detect
	          backgroundOpacity: 0.85,
	          // set to 0 to avoid background
	          sorted: null // default to no legend sorting
	        },
	        xaxis: {
	          show: null,
	          // null = auto-detect, true = always, false = never
	          position: "bottom",
	          // or "top"
	          mode: null,
	          // null or "time"
	          font: null,
	          // null (derived from CSS in placeholder) or object like { size: 11, lineHeight: 13, style: "italic", weight: "bold", family: "sans-serif", variant: "small-caps" }
	          color: null,
	          // base color, labels, ticks
	          tickColor: null,
	          // possibly different color of ticks, e.g. "rgba(0,0,0,0.15)"
	          transform: null,
	          // null or f: number -> number to transform axis
	          inverseTransform: null,
	          // if transform is set, this should be the inverse function
	          min: null,
	          // min. value to show, null means set automatically
	          max: null,
	          // max. value to show, null means set automatically
	          autoscaleMargin: null,
	          // margin in % to add if auto-setting min/max
	          ticks: null,
	          // either [1, 3] or [[1, "a"], 3] or (fn: axis info -> ticks) or app. number of ticks for auto-ticks
	          tickFormatter: null,
	          // fn: number -> string
	          labelWidth: null,
	          // size of tick labels in pixels
	          labelHeight: null,
	          reserveSpace: null,
	          // whether to reserve space even if axis isn't shown
	          tickLength: null,
	          // size in pixels of ticks, or "full" for whole line
	          alignTicksWithAxis: null,
	          // axis number or null for no sync
	          tickDecimals: null,
	          // no. of decimals, null means auto
	          tickSize: null,
	          // number or [number, "unit"]
	          minTickSize: null // number or [number, "unit"]
	        },
	        yaxis: {
	          autoscaleMargin: 0.02,
	          position: "left" // or "right"
	        },
	        xaxes: [],
	        yaxes: [],
	        series: {
	          points: {
	            show: false,
	            radius: 3,
	            lineWidth: 2,
	            // in pixels
	            fill: true,
	            fillColor: "#ffffff",
	            symbol: "circle" // or callback
	          },
	          lines: {
	            // we don't put in show: false so we can see
	            // whether lines were actively disabled
	            lineWidth: 2,
	            // in pixels
	            fill: false,
	            fillColor: null,
	            steps: false
	            // Omit 'zero', so we can later default its value to
	            // match that of the 'fill' option.
	          },
	          bars: {
	            show: false,
	            lineWidth: 2,
	            // in pixels
	            barWidth: 1,
	            // in units of the x axis
	            fill: true,
	            fillColor: null,
	            align: "left",
	            // "left", "right", or "center"
	            horizontal: false,
	            zero: true
	          },
	          shadowSize: 3,
	          highlightColor: null
	        },
	        grid: {
	          show: true,
	          aboveData: false,
	          color: "#545454",
	          // primary color used for outline and labels
	          backgroundColor: null,
	          // null for transparent, else color
	          borderColor: null,
	          // set if different from the grid color
	          tickColor: null,
	          // color for the ticks, e.g. "rgba(0,0,0,0.15)"
	          margin: 0,
	          // distance from the canvas edge to the grid
	          labelMargin: 5,
	          // in pixels
	          axisMargin: 8,
	          // in pixels
	          borderWidth: 2,
	          // in pixels
	          minBorderMargin: null,
	          // in pixels, null means taken from points radius
	          markings: null,
	          // array of ranges or fn: axes -> array of ranges
	          markingsColor: "#f4f4f4",
	          markingsLineWidth: 2,
	          // interactive stuff
	          clickable: false,
	          hoverable: false,
	          autoHighlight: true,
	          // highlight in case mouse is near
	          mouseActiveRadius: 10 // how far the mouse can be away to activate an item
	        },
	        interaction: {
	          redrawOverlayInterval: 1000 / 60 // time between updates, -1 means in same flow
	        },
	        hooks: {}
	      },
	      surface = null,
	      // the canvas for the plot itself
	      overlay = null,
	      // canvas for interactive stuff on top of plot
	      eventHolder = null,
	      // jQuery object that events should be bound to
	      ctx = null,
	      octx = null,
	      xaxes = [],
	      yaxes = [],
	      plotOffset = {
	        left: 0,
	        right: 0,
	        top: 0,
	        bottom: 0
	      },
	      plotWidth = 0,
	      plotHeight = 0,
	      hooks = {
	        processOptions: [],
	        processRawData: [],
	        processDatapoints: [],
	        processOffset: [],
	        drawBackground: [],
	        drawSeries: [],
	        draw: [],
	        bindEvents: [],
	        drawOverlay: [],
	        shutdown: []
	      },
	      plot = this;

	    // public functions
	    plot.setData = setData;
	    plot.setupGrid = setupGrid;
	    plot.draw = draw;
	    plot.getPlaceholder = function () {
	      return placeholder;
	    };
	    plot.getCanvas = function () {
	      return surface.element;
	    };
	    plot.getPlotOffset = function () {
	      return plotOffset;
	    };
	    plot.width = function () {
	      return plotWidth;
	    };
	    plot.height = function () {
	      return plotHeight;
	    };
	    plot.offset = function () {
	      var o = eventHolder.offset();
	      o.left += plotOffset.left;
	      o.top += plotOffset.top;
	      return o;
	    };
	    plot.getData = function () {
	      return series;
	    };
	    plot.getAxes = function () {
	      var res = {};
	      $.each(xaxes.concat(yaxes), function (_, axis) {
	        if (axis) res[axis.direction + (axis.n != 1 ? axis.n : "") + "axis"] = axis;
	      });
	      return res;
	    };
	    plot.getXAxes = function () {
	      return xaxes;
	    };
	    plot.getYAxes = function () {
	      return yaxes;
	    };
	    plot.c2p = canvasToAxisCoords;
	    plot.p2c = axisToCanvasCoords;
	    plot.getOptions = function () {
	      return options;
	    };
	    plot.highlight = highlight;
	    plot.unhighlight = unhighlight;
	    plot.triggerRedrawOverlay = triggerRedrawOverlay;
	    plot.pointOffset = function (point) {
	      return {
	        left: parseInt(xaxes[axisNumber(point, "x") - 1].p2c(+point.x) + plotOffset.left, 10),
	        top: parseInt(yaxes[axisNumber(point, "y") - 1].p2c(+point.y) + plotOffset.top, 10)
	      };
	    };
	    plot.shutdown = shutdown;
	    plot.destroy = function () {
	      shutdown();
	      placeholder.removeData("plot").empty();
	      series = [];
	      options = null;
	      surface = null;
	      overlay = null;
	      eventHolder = null;
	      ctx = null;
	      octx = null;
	      xaxes = [];
	      yaxes = [];
	      hooks = null;
	      highlights = [];
	      plot = null;
	    };
	    plot.resize = function () {
	      var width = placeholder.width(),
	        height = placeholder.height();
	      surface.resize(width, height);
	      overlay.resize(width, height);
	    };

	    // public attributes
	    plot.hooks = hooks;

	    // initialize
	    initPlugins();
	    parseOptions(options_);
	    setupCanvases();
	    setData(data_);
	    setupGrid();
	    draw();
	    bindEvents();
	    function executeHooks(hook, args) {
	      args = [plot].concat(args);
	      for (var i = 0; i < hook.length; ++i) hook[i].apply(this, args);
	    }
	    function initPlugins() {
	      // References to key classes, allowing plugins to modify them

	      var classes = {
	        Canvas: Canvas
	      };
	      for (var i = 0; i < plugins.length; ++i) {
	        var p = plugins[i];
	        p.init(plot, classes);
	        if (p.options) $.extend(true, options, p.options);
	      }
	    }
	    function parseOptions(opts) {
	      $.extend(true, options, opts);

	      // $.extend merges arrays, rather than replacing them.  When less
	      // colors are provided than the size of the default palette, we
	      // end up with those colors plus the remaining defaults, which is
	      // not expected behavior; avoid it by replacing them here.

	      if (opts && opts.colors) {
	        options.colors = opts.colors;
	      }
	      if (options.xaxis.color == null) options.xaxis.color = $.color.parse(options.grid.color).scale('a', 0.22).toString();
	      if (options.yaxis.color == null) options.yaxis.color = $.color.parse(options.grid.color).scale('a', 0.22).toString();
	      if (options.xaxis.tickColor == null)
	        // grid.tickColor for back-compatibility
	        options.xaxis.tickColor = options.grid.tickColor || options.xaxis.color;
	      if (options.yaxis.tickColor == null)
	        // grid.tickColor for back-compatibility
	        options.yaxis.tickColor = options.grid.tickColor || options.yaxis.color;
	      if (options.grid.borderColor == null) options.grid.borderColor = options.grid.color;
	      if (options.grid.tickColor == null) options.grid.tickColor = $.color.parse(options.grid.color).scale('a', 0.22).toString();

	      // Fill in defaults for axis options, including any unspecified
	      // font-spec fields, if a font-spec was provided.

	      // If no x/y axis options were provided, create one of each anyway,
	      // since the rest of the code assumes that they exist.

	      var i,
	        axisOptions,
	        axisCount,
	        fontSize = placeholder.css("font-size"),
	        fontSizeDefault = fontSize ? +fontSize.replace("px", "") : 13,
	        fontDefaults = {
	          style: placeholder.css("font-style"),
	          size: Math.round(0.8 * fontSizeDefault),
	          variant: placeholder.css("font-variant"),
	          weight: placeholder.css("font-weight"),
	          family: placeholder.css("font-family")
	        };
	      axisCount = options.xaxes.length || 1;
	      for (i = 0; i < axisCount; ++i) {
	        axisOptions = options.xaxes[i];
	        if (axisOptions && !axisOptions.tickColor) {
	          axisOptions.tickColor = axisOptions.color;
	        }
	        axisOptions = $.extend(true, {}, options.xaxis, axisOptions);
	        options.xaxes[i] = axisOptions;
	        if (axisOptions.font) {
	          axisOptions.font = $.extend({}, fontDefaults, axisOptions.font);
	          if (!axisOptions.font.color) {
	            axisOptions.font.color = axisOptions.color;
	          }
	          if (!axisOptions.font.lineHeight) {
	            axisOptions.font.lineHeight = Math.round(axisOptions.font.size * 1.15);
	          }
	        }
	      }
	      axisCount = options.yaxes.length || 1;
	      for (i = 0; i < axisCount; ++i) {
	        axisOptions = options.yaxes[i];
	        if (axisOptions && !axisOptions.tickColor) {
	          axisOptions.tickColor = axisOptions.color;
	        }
	        axisOptions = $.extend(true, {}, options.yaxis, axisOptions);
	        options.yaxes[i] = axisOptions;
	        if (axisOptions.font) {
	          axisOptions.font = $.extend({}, fontDefaults, axisOptions.font);
	          if (!axisOptions.font.color) {
	            axisOptions.font.color = axisOptions.color;
	          }
	          if (!axisOptions.font.lineHeight) {
	            axisOptions.font.lineHeight = Math.round(axisOptions.font.size * 1.15);
	          }
	        }
	      }

	      // backwards compatibility, to be removed in future
	      if (options.xaxis.noTicks && options.xaxis.ticks == null) options.xaxis.ticks = options.xaxis.noTicks;
	      if (options.yaxis.noTicks && options.yaxis.ticks == null) options.yaxis.ticks = options.yaxis.noTicks;
	      if (options.x2axis) {
	        options.xaxes[1] = $.extend(true, {}, options.xaxis, options.x2axis);
	        options.xaxes[1].position = "top";
	        // Override the inherit to allow the axis to auto-scale
	        if (options.x2axis.min == null) {
	          options.xaxes[1].min = null;
	        }
	        if (options.x2axis.max == null) {
	          options.xaxes[1].max = null;
	        }
	      }
	      if (options.y2axis) {
	        options.yaxes[1] = $.extend(true, {}, options.yaxis, options.y2axis);
	        options.yaxes[1].position = "right";
	        // Override the inherit to allow the axis to auto-scale
	        if (options.y2axis.min == null) {
	          options.yaxes[1].min = null;
	        }
	        if (options.y2axis.max == null) {
	          options.yaxes[1].max = null;
	        }
	      }
	      if (options.grid.coloredAreas) options.grid.markings = options.grid.coloredAreas;
	      if (options.grid.coloredAreasColor) options.grid.markingsColor = options.grid.coloredAreasColor;
	      if (options.lines) $.extend(true, options.series.lines, options.lines);
	      if (options.points) $.extend(true, options.series.points, options.points);
	      if (options.bars) $.extend(true, options.series.bars, options.bars);
	      if (options.shadowSize != null) options.series.shadowSize = options.shadowSize;
	      if (options.highlightColor != null) options.series.highlightColor = options.highlightColor;

	      // save options on axes for future reference
	      for (i = 0; i < options.xaxes.length; ++i) getOrCreateAxis(xaxes, i + 1).options = options.xaxes[i];
	      for (i = 0; i < options.yaxes.length; ++i) getOrCreateAxis(yaxes, i + 1).options = options.yaxes[i];

	      // add hooks from options
	      for (var n in hooks) if (options.hooks[n] && options.hooks[n].length) hooks[n] = hooks[n].concat(options.hooks[n]);
	      executeHooks(hooks.processOptions, [options]);
	    }
	    function setData(d) {
	      series = parseData(d);
	      fillInSeriesOptions();
	      processData();
	    }
	    function parseData(d) {
	      var res = [];
	      for (var i = 0; i < d.length; ++i) {
	        var s = $.extend(true, {}, options.series);
	        if (d[i].data != null) {
	          s.data = d[i].data; // move the data instead of deep-copy
	          delete d[i].data;
	          $.extend(true, s, d[i]);
	          d[i].data = s.data;
	        } else s.data = d[i];
	        res.push(s);
	      }
	      return res;
	    }
	    function axisNumber(obj, coord) {
	      var a = obj[coord + "axis"];
	      if (typeof a == "object")
	        // if we got a real axis, extract number
	        a = a.n;
	      if (typeof a != "number") a = 1; // default to first axis
	      return a;
	    }
	    function allAxes() {
	      // return flat array without annoying null entries
	      return $.grep(xaxes.concat(yaxes), function (a) {
	        return a;
	      });
	    }
	    function canvasToAxisCoords(pos) {
	      // return an object with x/y corresponding to all used axes
	      var res = {},
	        i,
	        axis;
	      for (i = 0; i < xaxes.length; ++i) {
	        axis = xaxes[i];
	        if (axis && axis.used) res["x" + axis.n] = axis.c2p(pos.left);
	      }
	      for (i = 0; i < yaxes.length; ++i) {
	        axis = yaxes[i];
	        if (axis && axis.used) res["y" + axis.n] = axis.c2p(pos.top);
	      }
	      if (res.x1 !== undefined) res.x = res.x1;
	      if (res.y1 !== undefined) res.y = res.y1;
	      return res;
	    }
	    function axisToCanvasCoords(pos) {
	      // get canvas coords from the first pair of x/y found in pos
	      var res = {},
	        i,
	        axis,
	        key;
	      for (i = 0; i < xaxes.length; ++i) {
	        axis = xaxes[i];
	        if (axis && axis.used) {
	          key = "x" + axis.n;
	          if (pos[key] == null && axis.n == 1) key = "x";
	          if (pos[key] != null) {
	            res.left = axis.p2c(pos[key]);
	            break;
	          }
	        }
	      }
	      for (i = 0; i < yaxes.length; ++i) {
	        axis = yaxes[i];
	        if (axis && axis.used) {
	          key = "y" + axis.n;
	          if (pos[key] == null && axis.n == 1) key = "y";
	          if (pos[key] != null) {
	            res.top = axis.p2c(pos[key]);
	            break;
	          }
	        }
	      }
	      return res;
	    }
	    function getOrCreateAxis(axes, number) {
	      if (!axes[number - 1]) axes[number - 1] = {
	        n: number,
	        // save the number for future reference
	        direction: axes == xaxes ? "x" : "y",
	        options: $.extend(true, {}, axes == xaxes ? options.xaxis : options.yaxis)
	      };
	      return axes[number - 1];
	    }
	    function fillInSeriesOptions() {
	      var neededColors = series.length,
	        maxIndex = -1,
	        i;

	      // Subtract the number of series that already have fixed colors or
	      // color indexes from the number that we still need to generate.

	      for (i = 0; i < series.length; ++i) {
	        var sc = series[i].color;
	        if (sc != null) {
	          neededColors--;
	          if (typeof sc == "number" && sc > maxIndex) {
	            maxIndex = sc;
	          }
	        }
	      }

	      // If any of the series have fixed color indexes, then we need to
	      // generate at least as many colors as the highest index.

	      if (neededColors <= maxIndex) {
	        neededColors = maxIndex + 1;
	      }

	      // Generate all the colors, using first the option colors and then
	      // variations on those colors once they're exhausted.

	      var c,
	        colors = [],
	        colorPool = options.colors,
	        colorPoolSize = colorPool.length,
	        variation = 0;
	      for (i = 0; i < neededColors; i++) {
	        c = $.color.parse(colorPool[i % colorPoolSize] || "#666");

	        // Each time we exhaust the colors in the pool we adjust
	        // a scaling factor used to produce more variations on
	        // those colors. The factor alternates negative/positive
	        // to produce lighter/darker colors.

	        // Reset the variation after every few cycles, or else
	        // it will end up producing only white or black colors.

	        if (i % colorPoolSize == 0 && i) {
	          if (variation >= 0) {
	            if (variation < 0.5) {
	              variation = -variation - 0.2;
	            } else variation = 0;
	          } else variation = -variation;
	        }
	        colors[i] = c.scale('rgb', 1 + variation);
	      }

	      // Finalize the series options, filling in their colors

	      var colori = 0,
	        s;
	      for (i = 0; i < series.length; ++i) {
	        s = series[i];

	        // assign colors
	        if (s.color == null) {
	          s.color = colors[colori].toString();
	          ++colori;
	        } else if (typeof s.color == "number") s.color = colors[s.color].toString();

	        // turn on lines automatically in case nothing is set
	        if (s.lines.show == null) {
	          var v,
	            show = true;
	          for (v in s) if (s[v] && s[v].show) {
	            show = false;
	            break;
	          }
	          if (show) s.lines.show = true;
	        }

	        // If nothing was provided for lines.zero, default it to match
	        // lines.fill, since areas by default should extend to zero.

	        if (s.lines.zero == null) {
	          s.lines.zero = !!s.lines.fill;
	        }

	        // setup axes
	        s.xaxis = getOrCreateAxis(xaxes, axisNumber(s, "x"));
	        s.yaxis = getOrCreateAxis(yaxes, axisNumber(s, "y"));
	      }
	    }
	    function processData() {
	      var topSentry = Number.POSITIVE_INFINITY,
	        bottomSentry = Number.NEGATIVE_INFINITY,
	        fakeInfinity = Number.MAX_VALUE,
	        i,
	        j,
	        k,
	        m,
	        s,
	        points,
	        ps,
	        val,
	        f,
	        p,
	        data,
	        format;
	      function updateAxis(axis, min, max) {
	        if (min < axis.datamin && min != -fakeInfinity) axis.datamin = min;
	        if (max > axis.datamax && max != fakeInfinity) axis.datamax = max;
	      }
	      $.each(allAxes(), function (_, axis) {
	        // init axis
	        axis.datamin = topSentry;
	        axis.datamax = bottomSentry;
	        axis.used = false;
	      });
	      for (i = 0; i < series.length; ++i) {
	        s = series[i];
	        s.datapoints = {
	          points: []
	        };
	        executeHooks(hooks.processRawData, [s, s.data, s.datapoints]);
	      }

	      // first pass: clean and copy data
	      for (i = 0; i < series.length; ++i) {
	        s = series[i];
	        data = s.data;
	        format = s.datapoints.format;
	        if (!format) {
	          format = [];
	          // find out how to copy
	          format.push({
	            x: true,
	            number: true,
	            required: true
	          });
	          format.push({
	            y: true,
	            number: true,
	            required: true
	          });
	          if (s.bars.show || s.lines.show && s.lines.fill) {
	            var autoscale = !!(s.bars.show && s.bars.zero || s.lines.show && s.lines.zero);
	            format.push({
	              y: true,
	              number: true,
	              required: false,
	              defaultValue: 0,
	              autoscale: autoscale
	            });
	            if (s.bars.horizontal) {
	              delete format[format.length - 1].y;
	              format[format.length - 1].x = true;
	            }
	          }
	          s.datapoints.format = format;
	        }
	        if (s.datapoints.pointsize != null) continue; // already filled in

	        s.datapoints.pointsize = format.length;
	        ps = s.datapoints.pointsize;
	        points = s.datapoints.points;
	        var insertSteps = s.lines.show && s.lines.steps;
	        s.xaxis.used = s.yaxis.used = true;
	        for (j = k = 0; j < data.length; ++j, k += ps) {
	          p = data[j];
	          var nullify = p == null;
	          if (!nullify) {
	            for (m = 0; m < ps; ++m) {
	              val = p[m];
	              f = format[m];
	              if (f) {
	                if (f.number && val != null) {
	                  val = +val; // convert to number
	                  if (isNaN(val)) val = null;else if (val == Infinity) val = fakeInfinity;else if (val == -Infinity) val = -fakeInfinity;
	                }
	                if (val == null) {
	                  if (f.required) nullify = true;
	                  if (f.defaultValue != null) val = f.defaultValue;
	                }
	              }
	              points[k + m] = val;
	            }
	          }
	          if (nullify) {
	            for (m = 0; m < ps; ++m) {
	              val = points[k + m];
	              if (val != null) {
	                f = format[m];
	                // extract min/max info
	                if (f.autoscale !== false) {
	                  if (f.x) {
	                    updateAxis(s.xaxis, val, val);
	                  }
	                  if (f.y) {
	                    updateAxis(s.yaxis, val, val);
	                  }
	                }
	              }
	              points[k + m] = null;
	            }
	          } else {
	            // a little bit of line specific stuff that
	            // perhaps shouldn't be here, but lacking
	            // better means...
	            if (insertSteps && k > 0 && points[k - ps] != null && points[k - ps] != points[k] && points[k - ps + 1] != points[k + 1]) {
	              // copy the point to make room for a middle point
	              for (m = 0; m < ps; ++m) points[k + ps + m] = points[k + m];

	              // middle point has same y
	              points[k + 1] = points[k - ps + 1];

	              // we've added a point, better reflect that
	              k += ps;
	            }
	          }
	        }
	      }

	      // give the hooks a chance to run
	      for (i = 0; i < series.length; ++i) {
	        s = series[i];
	        executeHooks(hooks.processDatapoints, [s, s.datapoints]);
	      }

	      // second pass: find datamax/datamin for auto-scaling
	      for (i = 0; i < series.length; ++i) {
	        s = series[i];
	        points = s.datapoints.points;
	        ps = s.datapoints.pointsize;
	        format = s.datapoints.format;
	        var xmin = topSentry,
	          ymin = topSentry,
	          xmax = bottomSentry,
	          ymax = bottomSentry;
	        for (j = 0; j < points.length; j += ps) {
	          if (points[j] == null) continue;
	          for (m = 0; m < ps; ++m) {
	            val = points[j + m];
	            f = format[m];
	            if (!f || f.autoscale === false || val == fakeInfinity || val == -fakeInfinity) continue;
	            if (f.x) {
	              if (val < xmin) xmin = val;
	              if (val > xmax) xmax = val;
	            }
	            if (f.y) {
	              if (val < ymin) ymin = val;
	              if (val > ymax) ymax = val;
	            }
	          }
	        }
	        if (s.bars.show) {
	          // make sure we got room for the bar on the dancing floor
	          var delta;
	          switch (s.bars.align) {
	            case "left":
	              delta = 0;
	              break;
	            case "right":
	              delta = -s.bars.barWidth;
	              break;
	            default:
	              delta = -s.bars.barWidth / 2;
	          }
	          if (s.bars.horizontal) {
	            ymin += delta;
	            ymax += delta + s.bars.barWidth;
	          } else {
	            xmin += delta;
	            xmax += delta + s.bars.barWidth;
	          }
	        }
	        updateAxis(s.xaxis, xmin, xmax);
	        updateAxis(s.yaxis, ymin, ymax);
	      }
	      $.each(allAxes(), function (_, axis) {
	        if (axis.datamin == topSentry) axis.datamin = null;
	        if (axis.datamax == bottomSentry) axis.datamax = null;
	      });
	    }
	    function setupCanvases() {
	      // Make sure the placeholder is clear of everything except canvases
	      // from a previous plot in this container that we'll try to re-use.

	      placeholder.css("padding", 0) // padding messes up the positioning
	      .children().filter(function () {
	        return !$(this).hasClass("flot-overlay") && !$(this).hasClass('flot-base');
	      }).remove();
	      if (placeholder.css("position") == 'static') placeholder.css("position", "relative"); // for positioning labels and overlay

	      surface = new Canvas("flot-base", placeholder);
	      overlay = new Canvas("flot-overlay", placeholder); // overlay canvas for interactive features

	      ctx = surface.context;
	      octx = overlay.context;

	      // define which element we're listening for events on
	      eventHolder = $(overlay.element).unbind();

	      // If we're re-using a plot object, shut down the old one

	      var existing = placeholder.data("plot");
	      if (existing) {
	        existing.shutdown();
	        overlay.clear();
	      }

	      // save in case we get replotted
	      placeholder.data("plot", plot);
	    }
	    function bindEvents() {
	      // bind events
	      if (options.grid.hoverable) {
	        eventHolder.mousemove(onMouseMove);

	        // Use bind, rather than .mouseleave, because we officially
	        // still support jQuery 1.2.6, which doesn't define a shortcut
	        // for mouseenter or mouseleave.  This was a bug/oversight that
	        // was fixed somewhere around 1.3.x.  We can return to using
	        // .mouseleave when we drop support for 1.2.6.

	        eventHolder.bind("mouseleave", onMouseLeave);
	      }
	      if (options.grid.clickable) eventHolder.click(onClick);
	      executeHooks(hooks.bindEvents, [eventHolder]);
	    }
	    function shutdown() {
	      if (redrawTimeout) clearTimeout(redrawTimeout);
	      eventHolder.unbind("mousemove", onMouseMove);
	      eventHolder.unbind("mouseleave", onMouseLeave);
	      eventHolder.unbind("click", onClick);
	      executeHooks(hooks.shutdown, [eventHolder]);
	    }
	    function setTransformationHelpers(axis) {
	      // set helper functions on the axis, assumes plot area
	      // has been computed already

	      function identity(x) {
	        return x;
	      }
	      var s,
	        m,
	        t = axis.options.transform || identity,
	        it = axis.options.inverseTransform;

	      // precompute how much the axis is scaling a point
	      // in canvas space
	      if (axis.direction == "x") {
	        s = axis.scale = plotWidth / Math.abs(t(axis.max) - t(axis.min));
	        m = Math.min(t(axis.max), t(axis.min));
	      } else {
	        s = axis.scale = plotHeight / Math.abs(t(axis.max) - t(axis.min));
	        s = -s;
	        m = Math.max(t(axis.max), t(axis.min));
	      }

	      // data point to canvas coordinate
	      if (t == identity)
	        // slight optimization
	        axis.p2c = function (p) {
	          return (p - m) * s;
	        };else axis.p2c = function (p) {
	        return (t(p) - m) * s;
	      };
	      // canvas coordinate to data point
	      if (!it) axis.c2p = function (c) {
	        return m + c / s;
	      };else axis.c2p = function (c) {
	        return it(m + c / s);
	      };
	    }
	    function measureTickLabels(axis) {
	      var opts = axis.options,
	        ticks = axis.ticks || [],
	        labelWidth = opts.labelWidth || 0,
	        labelHeight = opts.labelHeight || 0,
	        maxWidth = labelWidth || (axis.direction == "x" ? Math.floor(surface.width / (ticks.length || 1)) : null),
	        legacyStyles = axis.direction + "Axis " + axis.direction + axis.n + "Axis",
	        layer = "flot-" + axis.direction + "-axis flot-" + axis.direction + axis.n + "-axis " + legacyStyles,
	        font = opts.font || "flot-tick-label tickLabel";
	      for (var i = 0; i < ticks.length; ++i) {
	        var t = ticks[i];
	        if (!t.label) continue;
	        var info = surface.getTextInfo(layer, t.label, font, null, maxWidth);
	        labelWidth = Math.max(labelWidth, info.width);
	        labelHeight = Math.max(labelHeight, info.height);
	      }
	      axis.labelWidth = opts.labelWidth || labelWidth;
	      axis.labelHeight = opts.labelHeight || labelHeight;
	    }
	    function allocateAxisBoxFirstPhase(axis) {
	      // find the bounding box of the axis by looking at label
	      // widths/heights and ticks, make room by diminishing the
	      // plotOffset; this first phase only looks at one
	      // dimension per axis, the other dimension depends on the
	      // other axes so will have to wait

	      var lw = axis.labelWidth,
	        lh = axis.labelHeight,
	        pos = axis.options.position,
	        isXAxis = axis.direction === "x",
	        tickLength = axis.options.tickLength,
	        axisMargin = options.grid.axisMargin,
	        padding = options.grid.labelMargin,
	        innermost = true,
	        outermost = true,
	        first = true,
	        found = false;

	      // Determine the axis's position in its direction and on its side

	      $.each(isXAxis ? xaxes : yaxes, function (i, a) {
	        if (a && (a.show || a.reserveSpace)) {
	          if (a === axis) {
	            found = true;
	          } else if (a.options.position === pos) {
	            if (found) {
	              outermost = false;
	            } else {
	              innermost = false;
	            }
	          }
	          if (!found) {
	            first = false;
	          }
	        }
	      });

	      // The outermost axis on each side has no margin

	      if (outermost) {
	        axisMargin = 0;
	      }

	      // The ticks for the first axis in each direction stretch across

	      if (tickLength == null) {
	        tickLength = first ? "full" : 5;
	      }
	      if (!isNaN(+tickLength)) padding += +tickLength;
	      if (isXAxis) {
	        lh += padding;
	        if (pos == "bottom") {
	          plotOffset.bottom += lh + axisMargin;
	          axis.box = {
	            top: surface.height - plotOffset.bottom,
	            height: lh
	          };
	        } else {
	          axis.box = {
	            top: plotOffset.top + axisMargin,
	            height: lh
	          };
	          plotOffset.top += lh + axisMargin;
	        }
	      } else {
	        lw += padding;
	        if (pos == "left") {
	          axis.box = {
	            left: plotOffset.left + axisMargin,
	            width: lw
	          };
	          plotOffset.left += lw + axisMargin;
	        } else {
	          plotOffset.right += lw + axisMargin;
	          axis.box = {
	            left: surface.width - plotOffset.right,
	            width: lw
	          };
	        }
	      }

	      // save for future reference
	      axis.position = pos;
	      axis.tickLength = tickLength;
	      axis.box.padding = padding;
	      axis.innermost = innermost;
	    }
	    function allocateAxisBoxSecondPhase(axis) {
	      // now that all axis boxes have been placed in one
	      // dimension, we can set the remaining dimension coordinates
	      if (axis.direction == "x") {
	        axis.box.left = plotOffset.left - axis.labelWidth / 2;
	        axis.box.width = surface.width - plotOffset.left - plotOffset.right + axis.labelWidth;
	      } else {
	        axis.box.top = plotOffset.top - axis.labelHeight / 2;
	        axis.box.height = surface.height - plotOffset.bottom - plotOffset.top + axis.labelHeight;
	      }
	    }
	    function adjustLayoutForThingsStickingOut() {
	      // possibly adjust plot offset to ensure everything stays
	      // inside the canvas and isn't clipped off

	      var minMargin = options.grid.minBorderMargin,
	        i;

	      // check stuff from the plot (FIXME: this should just read
	      // a value from the series, otherwise it's impossible to
	      // customize)
	      if (minMargin == null) {
	        minMargin = 0;
	        for (i = 0; i < series.length; ++i) minMargin = Math.max(minMargin, 2 * (series[i].points.radius + series[i].points.lineWidth / 2));
	      }
	      var margins = {
	        left: minMargin,
	        right: minMargin,
	        top: minMargin,
	        bottom: minMargin
	      };

	      // check axis labels, note we don't check the actual
	      // labels but instead use the overall width/height to not
	      // jump as much around with replots
	      $.each(allAxes(), function (_, axis) {
	        if (axis.reserveSpace && axis.ticks && axis.ticks.length) {
	          if (axis.direction === "x") {
	            margins.left = Math.max(margins.left, axis.labelWidth / 2);
	            margins.right = Math.max(margins.right, axis.labelWidth / 2);
	          } else {
	            margins.bottom = Math.max(margins.bottom, axis.labelHeight / 2);
	            margins.top = Math.max(margins.top, axis.labelHeight / 2);
	          }
	        }
	      });
	      plotOffset.left = Math.ceil(Math.max(margins.left, plotOffset.left));
	      plotOffset.right = Math.ceil(Math.max(margins.right, plotOffset.right));
	      plotOffset.top = Math.ceil(Math.max(margins.top, plotOffset.top));
	      plotOffset.bottom = Math.ceil(Math.max(margins.bottom, plotOffset.bottom));
	    }
	    function setupGrid() {
	      var i,
	        axes = allAxes(),
	        showGrid = options.grid.show;

	      // Initialize the plot's offset from the edge of the canvas

	      for (var a in plotOffset) {
	        var margin = options.grid.margin || 0;
	        plotOffset[a] = typeof margin == "number" ? margin : margin[a] || 0;
	      }
	      executeHooks(hooks.processOffset, [plotOffset]);

	      // If the grid is visible, add its border width to the offset

	      for (var a in plotOffset) {
	        if (typeof options.grid.borderWidth == "object") {
	          plotOffset[a] += showGrid ? options.grid.borderWidth[a] : 0;
	        } else {
	          plotOffset[a] += showGrid ? options.grid.borderWidth : 0;
	        }
	      }
	      $.each(axes, function (_, axis) {
	        var axisOpts = axis.options;
	        axis.show = axisOpts.show == null ? axis.used : axisOpts.show;
	        axis.reserveSpace = axisOpts.reserveSpace == null ? axis.show : axisOpts.reserveSpace;
	        setRange(axis);
	      });
	      if (showGrid) {
	        var allocatedAxes = $.grep(axes, function (axis) {
	          return axis.show || axis.reserveSpace;
	        });
	        $.each(allocatedAxes, function (_, axis) {
	          // make the ticks
	          setupTickGeneration(axis);
	          setTicks(axis);
	          snapRangeToTicks(axis, axis.ticks);
	          // find labelWidth/Height for axis
	          measureTickLabels(axis);
	        });

	        // with all dimensions calculated, we can compute the
	        // axis bounding boxes, start from the outside
	        // (reverse order)
	        for (i = allocatedAxes.length - 1; i >= 0; --i) allocateAxisBoxFirstPhase(allocatedAxes[i]);

	        // make sure we've got enough space for things that
	        // might stick out
	        adjustLayoutForThingsStickingOut();
	        $.each(allocatedAxes, function (_, axis) {
	          allocateAxisBoxSecondPhase(axis);
	        });
	      }
	      plotWidth = surface.width - plotOffset.left - plotOffset.right;
	      plotHeight = surface.height - plotOffset.bottom - plotOffset.top;

	      // now we got the proper plot dimensions, we can compute the scaling
	      $.each(axes, function (_, axis) {
	        setTransformationHelpers(axis);
	      });
	      if (showGrid) {
	        drawAxisLabels();
	      }
	      insertLegend();
	    }
	    function setRange(axis) {
	      var opts = axis.options,
	        min = +(opts.min != null ? opts.min : axis.datamin),
	        max = +(opts.max != null ? opts.max : axis.datamax),
	        delta = max - min;
	      if (delta == 0.0) {
	        // degenerate case
	        var widen = max == 0 ? 1 : 0.01;
	        if (opts.min == null) min -= widen;
	        // always widen max if we couldn't widen min to ensure we
	        // don't fall into min == max which doesn't work
	        if (opts.max == null || opts.min != null) max += widen;
	      } else {
	        // consider autoscaling
	        var margin = opts.autoscaleMargin;
	        if (margin != null) {
	          if (opts.min == null) {
	            min -= delta * margin;
	            // make sure we don't go below zero if all values
	            // are positive
	            if (min < 0 && axis.datamin != null && axis.datamin >= 0) min = 0;
	          }
	          if (opts.max == null) {
	            max += delta * margin;
	            if (max > 0 && axis.datamax != null && axis.datamax <= 0) max = 0;
	          }
	        }
	      }
	      axis.min = min;
	      axis.max = max;
	    }
	    function setupTickGeneration(axis) {
	      var opts = axis.options;

	      // estimate number of ticks
	      var noTicks;
	      if (typeof opts.ticks == "number" && opts.ticks > 0) noTicks = opts.ticks;else
	        // heuristic based on the model a*sqrt(x) fitted to
	        // some data points that seemed reasonable
	        noTicks = 0.3 * Math.sqrt(axis.direction == "x" ? surface.width : surface.height);
	      var delta = (axis.max - axis.min) / noTicks,
	        dec = -Math.floor(Math.log(delta) / Math.LN10),
	        maxDec = opts.tickDecimals;
	      if (maxDec != null && dec > maxDec) {
	        dec = maxDec;
	      }
	      var magn = Math.pow(10, -dec),
	        norm = delta / magn,
	        // norm is between 1.0 and 10.0
	        size;
	      if (norm < 1.5) {
	        size = 1;
	      } else if (norm < 3) {
	        size = 2;
	        // special case for 2.5, requires an extra decimal
	        if (norm > 2.25 && (maxDec == null || dec + 1 <= maxDec)) {
	          size = 2.5;
	          ++dec;
	        }
	      } else if (norm < 7.5) {
	        size = 5;
	      } else {
	        size = 10;
	      }
	      size *= magn;
	      if (opts.minTickSize != null && size < opts.minTickSize) {
	        size = opts.minTickSize;
	      }
	      axis.delta = delta;
	      axis.tickDecimals = Math.max(0, maxDec != null ? maxDec : dec);
	      axis.tickSize = opts.tickSize || size;

	      // Time mode was moved to a plug-in in 0.8, and since so many people use it
	      // we'll add an especially friendly reminder to make sure they included it.

	      if (opts.mode == "time" && !axis.tickGenerator) {
	        throw new Error("Time mode requires the flot.time plugin.");
	      }

	      // Flot supports base-10 axes; any other mode else is handled by a plug-in,
	      // like flot.time.js.

	      if (!axis.tickGenerator) {
	        axis.tickGenerator = function (axis) {
	          var ticks = [],
	            start = floorInBase(axis.min, axis.tickSize),
	            i = 0,
	            v = Number.NaN,
	            prev;
	          do {
	            prev = v;
	            v = start + i * axis.tickSize;
	            ticks.push(v);
	            ++i;
	          } while (v < axis.max && v != prev);
	          return ticks;
	        };
	        axis.tickFormatter = function (value, axis) {
	          var factor = axis.tickDecimals ? Math.pow(10, axis.tickDecimals) : 1;
	          var formatted = "" + Math.round(value * factor) / factor;

	          // If tickDecimals was specified, ensure that we have exactly that
	          // much precision; otherwise default to the value's own precision.

	          if (axis.tickDecimals != null) {
	            var decimal = formatted.indexOf(".");
	            var precision = decimal == -1 ? 0 : formatted.length - decimal - 1;
	            if (precision < axis.tickDecimals) {
	              return (precision ? formatted : formatted + ".") + ("" + factor).substr(1, axis.tickDecimals - precision);
	            }
	          }
	          return formatted;
	        };
	      }
	      if ($.isFunction(opts.tickFormatter)) axis.tickFormatter = function (v, axis) {
	        return "" + opts.tickFormatter(v, axis);
	      };
	      if (opts.alignTicksWithAxis != null) {
	        var otherAxis = (axis.direction == "x" ? xaxes : yaxes)[opts.alignTicksWithAxis - 1];
	        if (otherAxis && otherAxis.used && otherAxis != axis) {
	          // consider snapping min/max to outermost nice ticks
	          var niceTicks = axis.tickGenerator(axis);
	          if (niceTicks.length > 0) {
	            if (opts.min == null) axis.min = Math.min(axis.min, niceTicks[0]);
	            if (opts.max == null && niceTicks.length > 1) axis.max = Math.max(axis.max, niceTicks[niceTicks.length - 1]);
	          }
	          axis.tickGenerator = function (axis) {
	            // copy ticks, scaled to this axis
	            var ticks = [],
	              v,
	              i;
	            for (i = 0; i < otherAxis.ticks.length; ++i) {
	              v = (otherAxis.ticks[i].v - otherAxis.min) / (otherAxis.max - otherAxis.min);
	              v = axis.min + v * (axis.max - axis.min);
	              ticks.push(v);
	            }
	            return ticks;
	          };

	          // we might need an extra decimal since forced
	          // ticks don't necessarily fit naturally
	          if (!axis.mode && opts.tickDecimals == null) {
	            var extraDec = Math.max(0, -Math.floor(Math.log(axis.delta) / Math.LN10) + 1),
	              ts = axis.tickGenerator(axis);

	            // only proceed if the tick interval rounded
	            // with an extra decimal doesn't give us a
	            // zero at end
	            if (!(ts.length > 1 && /\..*0$/.test((ts[1] - ts[0]).toFixed(extraDec)))) axis.tickDecimals = extraDec;
	          }
	        }
	      }
	    }
	    function setTicks(axis) {
	      var oticks = axis.options.ticks,
	        ticks = [];
	      if (oticks == null || typeof oticks == "number" && oticks > 0) ticks = axis.tickGenerator(axis);else if (oticks) {
	        if ($.isFunction(oticks))
	          // generate the ticks
	          ticks = oticks(axis);else ticks = oticks;
	      }

	      // clean up/labelify the supplied ticks, copy them over
	      var i, v;
	      axis.ticks = [];
	      for (i = 0; i < ticks.length; ++i) {
	        var label = null;
	        var t = ticks[i];
	        if (typeof t == "object") {
	          v = +t[0];
	          if (t.length > 1) label = t[1];
	        } else v = +t;
	        if (label == null) label = axis.tickFormatter(v, axis);
	        if (!isNaN(v)) axis.ticks.push({
	          v: v,
	          label: label
	        });
	      }
	    }
	    function snapRangeToTicks(axis, ticks) {
	      if (axis.options.autoscaleMargin && ticks.length > 0) {
	        // snap to ticks
	        if (axis.options.min == null) axis.min = Math.min(axis.min, ticks[0].v);
	        if (axis.options.max == null && ticks.length > 1) axis.max = Math.max(axis.max, ticks[ticks.length - 1].v);
	      }
	    }
	    function draw() {
	      surface.clear();
	      executeHooks(hooks.drawBackground, [ctx]);
	      var grid = options.grid;

	      // draw background, if any
	      if (grid.show && grid.backgroundColor) drawBackground();
	      if (grid.show && !grid.aboveData) {
	        drawGrid();
	      }
	      for (var i = 0; i < series.length; ++i) {
	        executeHooks(hooks.drawSeries, [ctx, series[i]]);
	        drawSeries(series[i]);
	      }
	      executeHooks(hooks.draw, [ctx]);
	      if (grid.show && grid.aboveData) {
	        drawGrid();
	      }
	      surface.render();

	      // A draw implies that either the axes or data have changed, so we
	      // should probably update the overlay highlights as well.

	      triggerRedrawOverlay();
	    }
	    function extractRange(ranges, coord) {
	      var axis,
	        from,
	        to,
	        key,
	        axes = allAxes();
	      for (var i = 0; i < axes.length; ++i) {
	        axis = axes[i];
	        if (axis.direction == coord) {
	          key = coord + axis.n + "axis";
	          if (!ranges[key] && axis.n == 1) key = coord + "axis"; // support x1axis as xaxis
	          if (ranges[key]) {
	            from = ranges[key].from;
	            to = ranges[key].to;
	            break;
	          }
	        }
	      }

	      // backwards-compat stuff - to be removed in future
	      if (!ranges[key]) {
	        axis = coord == "x" ? xaxes[0] : yaxes[0];
	        from = ranges[coord + "1"];
	        to = ranges[coord + "2"];
	      }

	      // auto-reverse as an added bonus
	      if (from != null && to != null && from > to) {
	        var tmp = from;
	        from = to;
	        to = tmp;
	      }
	      return {
	        from: from,
	        to: to,
	        axis: axis
	      };
	    }
	    function drawBackground() {
	      ctx.save();
	      ctx.translate(plotOffset.left, plotOffset.top);
	      ctx.fillStyle = getColorOrGradient(options.grid.backgroundColor, plotHeight, 0, "rgba(255, 255, 255, 0)");
	      ctx.fillRect(0, 0, plotWidth, plotHeight);
	      ctx.restore();
	    }
	    function drawGrid() {
	      var i, axes, bw, bc;
	      ctx.save();
	      ctx.translate(plotOffset.left, plotOffset.top);

	      // draw markings
	      var markings = options.grid.markings;
	      if (markings) {
	        if ($.isFunction(markings)) {
	          axes = plot.getAxes();
	          // xmin etc. is backwards compatibility, to be
	          // removed in the future
	          axes.xmin = axes.xaxis.min;
	          axes.xmax = axes.xaxis.max;
	          axes.ymin = axes.yaxis.min;
	          axes.ymax = axes.yaxis.max;
	          markings = markings(axes);
	        }
	        for (i = 0; i < markings.length; ++i) {
	          var m = markings[i],
	            xrange = extractRange(m, "x"),
	            yrange = extractRange(m, "y");

	          // fill in missing
	          if (xrange.from == null) xrange.from = xrange.axis.min;
	          if (xrange.to == null) xrange.to = xrange.axis.max;
	          if (yrange.from == null) yrange.from = yrange.axis.min;
	          if (yrange.to == null) yrange.to = yrange.axis.max;

	          // clip
	          if (xrange.to < xrange.axis.min || xrange.from > xrange.axis.max || yrange.to < yrange.axis.min || yrange.from > yrange.axis.max) continue;
	          xrange.from = Math.max(xrange.from, xrange.axis.min);
	          xrange.to = Math.min(xrange.to, xrange.axis.max);
	          yrange.from = Math.max(yrange.from, yrange.axis.min);
	          yrange.to = Math.min(yrange.to, yrange.axis.max);
	          var xequal = xrange.from === xrange.to,
	            yequal = yrange.from === yrange.to;
	          if (xequal && yequal) {
	            continue;
	          }

	          // then draw
	          xrange.from = Math.floor(xrange.axis.p2c(xrange.from));
	          xrange.to = Math.floor(xrange.axis.p2c(xrange.to));
	          yrange.from = Math.floor(yrange.axis.p2c(yrange.from));
	          yrange.to = Math.floor(yrange.axis.p2c(yrange.to));
	          if (xequal || yequal) {
	            var lineWidth = m.lineWidth || options.grid.markingsLineWidth,
	              subPixel = lineWidth % 2 ? 0.5 : 0;
	            ctx.beginPath();
	            ctx.strokeStyle = m.color || options.grid.markingsColor;
	            ctx.lineWidth = lineWidth;
	            if (xequal) {
	              ctx.moveTo(xrange.to + subPixel, yrange.from);
	              ctx.lineTo(xrange.to + subPixel, yrange.to);
	            } else {
	              ctx.moveTo(xrange.from, yrange.to + subPixel);
	              ctx.lineTo(xrange.to, yrange.to + subPixel);
	            }
	            ctx.stroke();
	          } else {
	            ctx.fillStyle = m.color || options.grid.markingsColor;
	            ctx.fillRect(xrange.from, yrange.to, xrange.to - xrange.from, yrange.from - yrange.to);
	          }
	        }
	      }

	      // draw the ticks
	      axes = allAxes();
	      bw = options.grid.borderWidth;
	      for (var j = 0; j < axes.length; ++j) {
	        var axis = axes[j],
	          box = axis.box,
	          t = axis.tickLength,
	          x,
	          y,
	          xoff,
	          yoff;
	        if (!axis.show || axis.ticks.length == 0) continue;
	        ctx.lineWidth = 1;

	        // find the edges
	        if (axis.direction == "x") {
	          x = 0;
	          if (t == "full") y = axis.position == "top" ? 0 : plotHeight;else y = box.top - plotOffset.top + (axis.position == "top" ? box.height : 0);
	        } else {
	          y = 0;
	          if (t == "full") x = axis.position == "left" ? 0 : plotWidth;else x = box.left - plotOffset.left + (axis.position == "left" ? box.width : 0);
	        }

	        // draw tick bar
	        if (!axis.innermost) {
	          ctx.strokeStyle = axis.options.color;
	          ctx.beginPath();
	          xoff = yoff = 0;
	          if (axis.direction == "x") xoff = plotWidth + 1;else yoff = plotHeight + 1;
	          if (ctx.lineWidth == 1) {
	            if (axis.direction == "x") {
	              y = Math.floor(y) + 0.5;
	            } else {
	              x = Math.floor(x) + 0.5;
	            }
	          }
	          ctx.moveTo(x, y);
	          ctx.lineTo(x + xoff, y + yoff);
	          ctx.stroke();
	        }

	        // draw ticks

	        ctx.strokeStyle = axis.options.tickColor;
	        ctx.beginPath();
	        for (i = 0; i < axis.ticks.length; ++i) {
	          var v = axis.ticks[i].v;
	          xoff = yoff = 0;
	          if (isNaN(v) || v < axis.min || v > axis.max
	          // skip those lying on the axes if we got a border
	          || t == "full" && (typeof bw == "object" && bw[axis.position] > 0 || bw > 0) && (v == axis.min || v == axis.max)) continue;
	          if (axis.direction == "x") {
	            x = axis.p2c(v);
	            yoff = t == "full" ? -plotHeight : t;
	            if (axis.position == "top") yoff = -yoff;
	          } else {
	            y = axis.p2c(v);
	            xoff = t == "full" ? -plotWidth : t;
	            if (axis.position == "left") xoff = -xoff;
	          }
	          if (ctx.lineWidth == 1) {
	            if (axis.direction == "x") x = Math.floor(x) + 0.5;else y = Math.floor(y) + 0.5;
	          }
	          ctx.moveTo(x, y);
	          ctx.lineTo(x + xoff, y + yoff);
	        }
	        ctx.stroke();
	      }

	      // draw border
	      if (bw) {
	        // If either borderWidth or borderColor is an object, then draw the border
	        // line by line instead of as one rectangle
	        bc = options.grid.borderColor;
	        if (typeof bw == "object" || typeof bc == "object") {
	          if (typeof bw !== "object") {
	            bw = {
	              top: bw,
	              right: bw,
	              bottom: bw,
	              left: bw
	            };
	          }
	          if (typeof bc !== "object") {
	            bc = {
	              top: bc,
	              right: bc,
	              bottom: bc,
	              left: bc
	            };
	          }
	          if (bw.top > 0) {
	            ctx.strokeStyle = bc.top;
	            ctx.lineWidth = bw.top;
	            ctx.beginPath();
	            ctx.moveTo(0 - bw.left, 0 - bw.top / 2);
	            ctx.lineTo(plotWidth, 0 - bw.top / 2);
	            ctx.stroke();
	          }
	          if (bw.right > 0) {
	            ctx.strokeStyle = bc.right;
	            ctx.lineWidth = bw.right;
	            ctx.beginPath();
	            ctx.moveTo(plotWidth + bw.right / 2, 0 - bw.top);
	            ctx.lineTo(plotWidth + bw.right / 2, plotHeight);
	            ctx.stroke();
	          }
	          if (bw.bottom > 0) {
	            ctx.strokeStyle = bc.bottom;
	            ctx.lineWidth = bw.bottom;
	            ctx.beginPath();
	            ctx.moveTo(plotWidth + bw.right, plotHeight + bw.bottom / 2);
	            ctx.lineTo(0, plotHeight + bw.bottom / 2);
	            ctx.stroke();
	          }
	          if (bw.left > 0) {
	            ctx.strokeStyle = bc.left;
	            ctx.lineWidth = bw.left;
	            ctx.beginPath();
	            ctx.moveTo(0 - bw.left / 2, plotHeight + bw.bottom);
	            ctx.lineTo(0 - bw.left / 2, 0);
	            ctx.stroke();
	          }
	        } else {
	          ctx.lineWidth = bw;
	          ctx.strokeStyle = options.grid.borderColor;
	          ctx.strokeRect(-bw / 2, -bw / 2, plotWidth + bw, plotHeight + bw);
	        }
	      }
	      ctx.restore();
	    }
	    function drawAxisLabels() {
	      $.each(allAxes(), function (_, axis) {
	        var box = axis.box,
	          legacyStyles = axis.direction + "Axis " + axis.direction + axis.n + "Axis",
	          layer = "flot-" + axis.direction + "-axis flot-" + axis.direction + axis.n + "-axis " + legacyStyles,
	          font = axis.options.font || "flot-tick-label tickLabel",
	          tick,
	          x,
	          y,
	          halign,
	          valign;

	        // Remove text before checking for axis.show and ticks.length;
	        // otherwise plugins, like flot-tickrotor, that draw their own
	        // tick labels will end up with both theirs and the defaults.

	        surface.removeText(layer);
	        if (!axis.show || axis.ticks.length == 0) return;
	        for (var i = 0; i < axis.ticks.length; ++i) {
	          tick = axis.ticks[i];
	          if (!tick.label || tick.v < axis.min || tick.v > axis.max) continue;
	          if (axis.direction == "x") {
	            halign = "center";
	            x = plotOffset.left + axis.p2c(tick.v);
	            if (axis.position == "bottom") {
	              y = box.top + box.padding;
	            } else {
	              y = box.top + box.height - box.padding;
	              valign = "bottom";
	            }
	          } else {
	            valign = "middle";
	            y = plotOffset.top + axis.p2c(tick.v);
	            if (axis.position == "left") {
	              x = box.left + box.width - box.padding;
	              halign = "right";
	            } else {
	              x = box.left + box.padding;
	            }
	          }
	          surface.addText(layer, x, y, tick.label, font, null, null, halign, valign);
	        }
	      });
	    }
	    function drawSeries(series) {
	      if (series.lines.show) drawSeriesLines(series);
	      if (series.bars.show) drawSeriesBars(series);
	      if (series.points.show) drawSeriesPoints(series);
	    }
	    function drawSeriesLines(series) {
	      function plotLine(datapoints, xoffset, yoffset, axisx, axisy) {
	        var points = datapoints.points,
	          ps = datapoints.pointsize,
	          prevx = null,
	          prevy = null;
	        ctx.beginPath();
	        for (var i = ps; i < points.length; i += ps) {
	          var x1 = points[i - ps],
	            y1 = points[i - ps + 1],
	            x2 = points[i],
	            y2 = points[i + 1];
	          if (x1 == null || x2 == null) continue;

	          // clip with ymin
	          if (y1 <= y2 && y1 < axisy.min) {
	            if (y2 < axisy.min) continue; // line segment is outside
	            // compute new intersection point
	            x1 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y1 = axisy.min;
	          } else if (y2 <= y1 && y2 < axisy.min) {
	            if (y1 < axisy.min) continue;
	            x2 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y2 = axisy.min;
	          }

	          // clip with ymax
	          if (y1 >= y2 && y1 > axisy.max) {
	            if (y2 > axisy.max) continue;
	            x1 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y1 = axisy.max;
	          } else if (y2 >= y1 && y2 > axisy.max) {
	            if (y1 > axisy.max) continue;
	            x2 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y2 = axisy.max;
	          }

	          // clip with xmin
	          if (x1 <= x2 && x1 < axisx.min) {
	            if (x2 < axisx.min) continue;
	            y1 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x1 = axisx.min;
	          } else if (x2 <= x1 && x2 < axisx.min) {
	            if (x1 < axisx.min) continue;
	            y2 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x2 = axisx.min;
	          }

	          // clip with xmax
	          if (x1 >= x2 && x1 > axisx.max) {
	            if (x2 > axisx.max) continue;
	            y1 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x1 = axisx.max;
	          } else if (x2 >= x1 && x2 > axisx.max) {
	            if (x1 > axisx.max) continue;
	            y2 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x2 = axisx.max;
	          }
	          if (x1 != prevx || y1 != prevy) ctx.moveTo(axisx.p2c(x1) + xoffset, axisy.p2c(y1) + yoffset);
	          prevx = x2;
	          prevy = y2;
	          ctx.lineTo(axisx.p2c(x2) + xoffset, axisy.p2c(y2) + yoffset);
	        }
	        ctx.stroke();
	      }
	      function plotLineArea(datapoints, axisx, axisy) {
	        var points = datapoints.points,
	          ps = datapoints.pointsize,
	          bottom = Math.min(Math.max(0, axisy.min), axisy.max),
	          i = 0,
	          areaOpen = false,
	          ypos = 1,
	          segmentStart = 0,
	          segmentEnd = 0;

	        // we process each segment in two turns, first forward
	        // direction to sketch out top, then once we hit the
	        // end we go backwards to sketch the bottom
	        while (true) {
	          if (ps > 0 && i > points.length + ps) break;
	          i += ps; // ps is negative if going backwards

	          var x1 = points[i - ps],
	            y1 = points[i - ps + ypos],
	            x2 = points[i],
	            y2 = points[i + ypos];
	          if (areaOpen) {
	            if (ps > 0 && x1 != null && x2 == null) {
	              // at turning point
	              segmentEnd = i;
	              ps = -ps;
	              ypos = 2;
	              continue;
	            }
	            if (ps < 0 && i == segmentStart + ps) {
	              // done with the reverse sweep
	              ctx.fill();
	              areaOpen = false;
	              ps = -ps;
	              ypos = 1;
	              i = segmentStart = segmentEnd + ps;
	              continue;
	            }
	          }
	          if (x1 == null || x2 == null) continue;

	          // clip x values

	          // clip with xmin
	          if (x1 <= x2 && x1 < axisx.min) {
	            if (x2 < axisx.min) continue;
	            y1 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x1 = axisx.min;
	          } else if (x2 <= x1 && x2 < axisx.min) {
	            if (x1 < axisx.min) continue;
	            y2 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x2 = axisx.min;
	          }

	          // clip with xmax
	          if (x1 >= x2 && x1 > axisx.max) {
	            if (x2 > axisx.max) continue;
	            y1 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x1 = axisx.max;
	          } else if (x2 >= x1 && x2 > axisx.max) {
	            if (x1 > axisx.max) continue;
	            y2 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1;
	            x2 = axisx.max;
	          }
	          if (!areaOpen) {
	            // open area
	            ctx.beginPath();
	            ctx.moveTo(axisx.p2c(x1), axisy.p2c(bottom));
	            areaOpen = true;
	          }

	          // now first check the case where both is outside
	          if (y1 >= axisy.max && y2 >= axisy.max) {
	            ctx.lineTo(axisx.p2c(x1), axisy.p2c(axisy.max));
	            ctx.lineTo(axisx.p2c(x2), axisy.p2c(axisy.max));
	            continue;
	          } else if (y1 <= axisy.min && y2 <= axisy.min) {
	            ctx.lineTo(axisx.p2c(x1), axisy.p2c(axisy.min));
	            ctx.lineTo(axisx.p2c(x2), axisy.p2c(axisy.min));
	            continue;
	          }

	          // else it's a bit more complicated, there might
	          // be a flat maxed out rectangle first, then a
	          // triangular cutout or reverse; to find these
	          // keep track of the current x values
	          var x1old = x1,
	            x2old = x2;

	          // clip the y values, without shortcutting, we
	          // go through all cases in turn

	          // clip with ymin
	          if (y1 <= y2 && y1 < axisy.min && y2 >= axisy.min) {
	            x1 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y1 = axisy.min;
	          } else if (y2 <= y1 && y2 < axisy.min && y1 >= axisy.min) {
	            x2 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y2 = axisy.min;
	          }

	          // clip with ymax
	          if (y1 >= y2 && y1 > axisy.max && y2 <= axisy.max) {
	            x1 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y1 = axisy.max;
	          } else if (y2 >= y1 && y2 > axisy.max && y1 <= axisy.max) {
	            x2 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1;
	            y2 = axisy.max;
	          }

	          // if the x value was changed we got a rectangle
	          // to fill
	          if (x1 != x1old) {
	            ctx.lineTo(axisx.p2c(x1old), axisy.p2c(y1));
	            // it goes to (x1, y1), but we fill that below
	          }

	          // fill triangular section, this sometimes result
	          // in redundant points if (x1, y1) hasn't changed
	          // from previous line to, but we just ignore that
	          ctx.lineTo(axisx.p2c(x1), axisy.p2c(y1));
	          ctx.lineTo(axisx.p2c(x2), axisy.p2c(y2));

	          // fill the other rectangle if it's there
	          if (x2 != x2old) {
	            ctx.lineTo(axisx.p2c(x2), axisy.p2c(y2));
	            ctx.lineTo(axisx.p2c(x2old), axisy.p2c(y2));
	          }
	        }
	      }
	      ctx.save();
	      ctx.translate(plotOffset.left, plotOffset.top);
	      ctx.lineJoin = "round";
	      var lw = series.lines.lineWidth,
	        sw = series.shadowSize;
	      // FIXME: consider another form of shadow when filling is turned on
	      if (lw > 0 && sw > 0) {
	        // draw shadow as a thick and thin line with transparency
	        ctx.lineWidth = sw;
	        ctx.strokeStyle = "rgba(0,0,0,0.1)";
	        // position shadow at angle from the mid of line
	        var angle = Math.PI / 18;
	        plotLine(series.datapoints, Math.sin(angle) * (lw / 2 + sw / 2), Math.cos(angle) * (lw / 2 + sw / 2), series.xaxis, series.yaxis);
	        ctx.lineWidth = sw / 2;
	        plotLine(series.datapoints, Math.sin(angle) * (lw / 2 + sw / 4), Math.cos(angle) * (lw / 2 + sw / 4), series.xaxis, series.yaxis);
	      }
	      ctx.lineWidth = lw;
	      ctx.strokeStyle = series.color;
	      var fillStyle = getFillStyle(series.lines, series.color, 0, plotHeight);
	      if (fillStyle) {
	        ctx.fillStyle = fillStyle;
	        plotLineArea(series.datapoints, series.xaxis, series.yaxis);
	      }
	      if (lw > 0) plotLine(series.datapoints, 0, 0, series.xaxis, series.yaxis);
	      ctx.restore();
	    }
	    function drawSeriesPoints(series) {
	      function plotPoints(datapoints, radius, fillStyle, offset, shadow, axisx, axisy, symbol) {
	        var points = datapoints.points,
	          ps = datapoints.pointsize;
	        for (var i = 0; i < points.length; i += ps) {
	          var x = points[i],
	            y = points[i + 1];
	          if (x == null || x < axisx.min || x > axisx.max || y < axisy.min || y > axisy.max) continue;
	          ctx.beginPath();
	          x = axisx.p2c(x);
	          y = axisy.p2c(y) + offset;
	          if (symbol == "circle") ctx.arc(x, y, radius, 0, shadow ? Math.PI : Math.PI * 2, false);else symbol(ctx, x, y, radius, shadow);
	          ctx.closePath();
	          if (fillStyle) {
	            ctx.fillStyle = fillStyle;
	            ctx.fill();
	          }
	          ctx.stroke();
	        }
	      }
	      ctx.save();
	      ctx.translate(plotOffset.left, plotOffset.top);
	      var lw = series.points.lineWidth,
	        sw = series.shadowSize,
	        radius = series.points.radius,
	        symbol = series.points.symbol;

	      // If the user sets the line width to 0, we change it to a very 
	      // small value. A line width of 0 seems to force the default of 1.
	      // Doing the conditional here allows the shadow setting to still be 
	      // optional even with a lineWidth of 0.

	      if (lw == 0) lw = 0.0001;
	      if (lw > 0 && sw > 0) {
	        // draw shadow in two steps
	        var w = sw / 2;
	        ctx.lineWidth = w;
	        ctx.strokeStyle = "rgba(0,0,0,0.1)";
	        plotPoints(series.datapoints, radius, null, w + w / 2, true, series.xaxis, series.yaxis, symbol);
	        ctx.strokeStyle = "rgba(0,0,0,0.2)";
	        plotPoints(series.datapoints, radius, null, w / 2, true, series.xaxis, series.yaxis, symbol);
	      }
	      ctx.lineWidth = lw;
	      ctx.strokeStyle = series.color;
	      plotPoints(series.datapoints, radius, getFillStyle(series.points, series.color), 0, false, series.xaxis, series.yaxis, symbol);
	      ctx.restore();
	    }
	    function drawBar(x, y, b, barLeft, barRight, fillStyleCallback, axisx, axisy, c, horizontal, lineWidth) {
	      var left, right, bottom, top, drawLeft, drawRight, drawTop, drawBottom, tmp;

	      // in horizontal mode, we start the bar from the left
	      // instead of from the bottom so it appears to be
	      // horizontal rather than vertical
	      if (horizontal) {
	        drawBottom = drawRight = drawTop = true;
	        drawLeft = false;
	        left = b;
	        right = x;
	        top = y + barLeft;
	        bottom = y + barRight;

	        // account for negative bars
	        if (right < left) {
	          tmp = right;
	          right = left;
	          left = tmp;
	          drawLeft = true;
	          drawRight = false;
	        }
	      } else {
	        drawLeft = drawRight = drawTop = true;
	        drawBottom = false;
	        left = x + barLeft;
	        right = x + barRight;
	        bottom = b;
	        top = y;

	        // account for negative bars
	        if (top < bottom) {
	          tmp = top;
	          top = bottom;
	          bottom = tmp;
	          drawBottom = true;
	          drawTop = false;
	        }
	      }

	      // clip
	      if (right < axisx.min || left > axisx.max || top < axisy.min || bottom > axisy.max) return;
	      if (left < axisx.min) {
	        left = axisx.min;
	        drawLeft = false;
	      }
	      if (right > axisx.max) {
	        right = axisx.max;
	        drawRight = false;
	      }
	      if (bottom < axisy.min) {
	        bottom = axisy.min;
	        drawBottom = false;
	      }
	      if (top > axisy.max) {
	        top = axisy.max;
	        drawTop = false;
	      }
	      left = axisx.p2c(left);
	      bottom = axisy.p2c(bottom);
	      right = axisx.p2c(right);
	      top = axisy.p2c(top);

	      // fill the bar
	      if (fillStyleCallback) {
	        c.fillStyle = fillStyleCallback(bottom, top);
	        c.fillRect(left, top, right - left, bottom - top);
	      }

	      // draw outline
	      if (lineWidth > 0 && (drawLeft || drawRight || drawTop || drawBottom)) {
	        c.beginPath();

	        // FIXME: inline moveTo is buggy with excanvas
	        c.moveTo(left, bottom);
	        if (drawLeft) c.lineTo(left, top);else c.moveTo(left, top);
	        if (drawTop) c.lineTo(right, top);else c.moveTo(right, top);
	        if (drawRight) c.lineTo(right, bottom);else c.moveTo(right, bottom);
	        if (drawBottom) c.lineTo(left, bottom);else c.moveTo(left, bottom);
	        c.stroke();
	      }
	    }
	    function drawSeriesBars(series) {
	      function plotBars(datapoints, barLeft, barRight, fillStyleCallback, axisx, axisy) {
	        var points = datapoints.points,
	          ps = datapoints.pointsize;
	        for (var i = 0; i < points.length; i += ps) {
	          if (points[i] == null) continue;
	          drawBar(points[i], points[i + 1], points[i + 2], barLeft, barRight, fillStyleCallback, axisx, axisy, ctx, series.bars.horizontal, series.bars.lineWidth);
	        }
	      }
	      ctx.save();
	      ctx.translate(plotOffset.left, plotOffset.top);

	      // FIXME: figure out a way to add shadows (for instance along the right edge)
	      ctx.lineWidth = series.bars.lineWidth;
	      ctx.strokeStyle = series.color;
	      var barLeft;
	      switch (series.bars.align) {
	        case "left":
	          barLeft = 0;
	          break;
	        case "right":
	          barLeft = -series.bars.barWidth;
	          break;
	        default:
	          barLeft = -series.bars.barWidth / 2;
	      }
	      var fillStyleCallback = series.bars.fill ? function (bottom, top) {
	        return getFillStyle(series.bars, series.color, bottom, top);
	      } : null;
	      plotBars(series.datapoints, barLeft, barLeft + series.bars.barWidth, fillStyleCallback, series.xaxis, series.yaxis);
	      ctx.restore();
	    }
	    function getFillStyle(filloptions, seriesColor, bottom, top) {
	      var fill = filloptions.fill;
	      if (!fill) return null;
	      if (filloptions.fillColor) return getColorOrGradient(filloptions.fillColor, bottom, top, seriesColor);
	      var c = $.color.parse(seriesColor);
	      c.a = typeof fill == "number" ? fill : 0.4;
	      c.normalize();
	      return c.toString();
	    }
	    function insertLegend() {
	      if (options.legend.container != null) {
	        $(options.legend.container).html("");
	      } else {
	        placeholder.find(".legend").remove();
	      }
	      if (!options.legend.show) {
	        return;
	      }
	      var fragments = [],
	        entries = [],
	        rowStarted = false,
	        lf = options.legend.labelFormatter,
	        s,
	        label;

	      // Build a list of legend entries, with each having a label and a color

	      for (var i = 0; i < series.length; ++i) {
	        s = series[i];
	        if (s.label) {
	          label = lf ? lf(s.label, s) : s.label;
	          if (label) {
	            entries.push({
	              label: label,
	              color: s.color
	            });
	          }
	        }
	      }

	      // Sort the legend using either the default or a custom comparator

	      if (options.legend.sorted) {
	        if ($.isFunction(options.legend.sorted)) {
	          entries.sort(options.legend.sorted);
	        } else if (options.legend.sorted == "reverse") {
	          entries.reverse();
	        } else {
	          var ascending = options.legend.sorted != "descending";
	          entries.sort(function (a, b) {
	            return a.label == b.label ? 0 : a.label < b.label != ascending ? 1 : -1 // Logical XOR
	            ;
	          });
	        }
	      }

	      // Generate markup for the list of entries, in their final order

	      for (var i = 0; i < entries.length; ++i) {
	        var entry = entries[i];
	        if (i % options.legend.noColumns == 0) {
	          if (rowStarted) fragments.push('</tr>');
	          fragments.push('<tr>');
	          rowStarted = true;
	        }
	        fragments.push('<td class="legendColorBox"><div style="border:1px solid ' + options.legend.labelBoxBorderColor + ';padding:1px"><div style="width:4px;height:0;border:5px solid ' + entry.color + ';overflow:hidden"></div></div></td>' + '<td class="legendLabel">' + entry.label + '</td>');
	      }
	      if (rowStarted) fragments.push('</tr>');
	      if (fragments.length == 0) return;
	      var table = '<table style="font-size:smaller;color:' + options.grid.color + '">' + fragments.join("") + '</table>';
	      if (options.legend.container != null) $(options.legend.container).html(table);else {
	        var pos = "",
	          p = options.legend.position,
	          m = options.legend.margin;
	        if (m[0] == null) m = [m, m];
	        if (p.charAt(0) == "n") pos += 'top:' + (m[1] + plotOffset.top) + 'px;';else if (p.charAt(0) == "s") pos += 'bottom:' + (m[1] + plotOffset.bottom) + 'px;';
	        if (p.charAt(1) == "e") pos += 'right:' + (m[0] + plotOffset.right) + 'px;';else if (p.charAt(1) == "w") pos += 'left:' + (m[0] + plotOffset.left) + 'px;';
	        var legend = $('<div class="legend">' + table.replace('style="', 'style="position:absolute;' + pos + ';') + '</div>').appendTo(placeholder);
	        if (options.legend.backgroundOpacity != 0.0) {
	          // put in the transparent background
	          // separately to avoid blended labels and
	          // label boxes
	          var c = options.legend.backgroundColor;
	          if (c == null) {
	            c = options.grid.backgroundColor;
	            if (c && typeof c == "string") c = $.color.parse(c);else c = $.color.extract(legend, 'background-color');
	            c.a = 1;
	            c = c.toString();
	          }
	          var div = legend.children();
	          $('<div style="position:absolute;width:' + div.width() + 'px;height:' + div.height() + 'px;' + pos + 'background-color:' + c + ';"> </div>').prependTo(legend).css('opacity', options.legend.backgroundOpacity);
	        }
	      }
	    }

	    // interactive features

	    var highlights = [],
	      redrawTimeout = null;

	    // returns the data item the mouse is over, or null if none is found
	    function findNearbyItem(mouseX, mouseY, seriesFilter) {
	      var maxDistance = options.grid.mouseActiveRadius,
	        smallestDistance = maxDistance * maxDistance + 1,
	        item = null,
	        i,
	        j,
	        ps;
	      for (i = series.length - 1; i >= 0; --i) {
	        if (!seriesFilter(series[i])) continue;
	        var s = series[i],
	          axisx = s.xaxis,
	          axisy = s.yaxis,
	          points = s.datapoints.points,
	          mx = axisx.c2p(mouseX),
	          // precompute some stuff to make the loop faster
	          my = axisy.c2p(mouseY),
	          maxx = maxDistance / axisx.scale,
	          maxy = maxDistance / axisy.scale;
	        ps = s.datapoints.pointsize;
	        // with inverse transforms, we can't use the maxx/maxy
	        // optimization, sadly
	        if (axisx.options.inverseTransform) maxx = Number.MAX_VALUE;
	        if (axisy.options.inverseTransform) maxy = Number.MAX_VALUE;
	        if (s.lines.show || s.points.show) {
	          for (j = 0; j < points.length; j += ps) {
	            var x = points[j],
	              y = points[j + 1];
	            if (x == null) continue;

	            // For points and lines, the cursor must be within a
	            // certain distance to the data point
	            if (x - mx > maxx || x - mx < -maxx || y - my > maxy || y - my < -maxy) continue;

	            // We have to calculate distances in pixels, not in
	            // data units, because the scales of the axes may be different
	            var dx = Math.abs(axisx.p2c(x) - mouseX),
	              dy = Math.abs(axisy.p2c(y) - mouseY),
	              dist = dx * dx + dy * dy; // we save the sqrt

	            // use <= to ensure last point takes precedence
	            // (last generally means on top of)
	            if (dist < smallestDistance) {
	              smallestDistance = dist;
	              item = [i, j / ps];
	            }
	          }
	        }
	        if (s.bars.show && !item) {
	          // no other point can be nearby

	          var barLeft, barRight;
	          switch (s.bars.align) {
	            case "left":
	              barLeft = 0;
	              break;
	            case "right":
	              barLeft = -s.bars.barWidth;
	              break;
	            default:
	              barLeft = -s.bars.barWidth / 2;
	          }
	          barRight = barLeft + s.bars.barWidth;
	          for (j = 0; j < points.length; j += ps) {
	            var x = points[j],
	              y = points[j + 1],
	              b = points[j + 2];
	            if (x == null) continue;

	            // for a bar graph, the cursor must be inside the bar
	            if (series[i].bars.horizontal ? mx <= Math.max(b, x) && mx >= Math.min(b, x) && my >= y + barLeft && my <= y + barRight : mx >= x + barLeft && mx <= x + barRight && my >= Math.min(b, y) && my <= Math.max(b, y)) item = [i, j / ps];
	          }
	        }
	      }
	      if (item) {
	        i = item[0];
	        j = item[1];
	        ps = series[i].datapoints.pointsize;
	        return {
	          datapoint: series[i].datapoints.points.slice(j * ps, (j + 1) * ps),
	          dataIndex: j,
	          series: series[i],
	          seriesIndex: i
	        };
	      }
	      return null;
	    }
	    function onMouseMove(e) {
	      if (options.grid.hoverable) triggerClickHoverEvent("plothover", e, function (s) {
	        return s["hoverable"] != false;
	      });
	    }
	    function onMouseLeave(e) {
	      if (options.grid.hoverable) triggerClickHoverEvent("plothover", e, function (s) {
	        return false;
	      });
	    }
	    function onClick(e) {
	      triggerClickHoverEvent("plotclick", e, function (s) {
	        return s["clickable"] != false;
	      });
	    }

	    // trigger click or hover event (they send the same parameters
	    // so we share their code)
	    function triggerClickHoverEvent(eventname, event, seriesFilter) {
	      var offset = eventHolder.offset(),
	        canvasX = event.pageX - offset.left - plotOffset.left,
	        canvasY = event.pageY - offset.top - plotOffset.top,
	        pos = canvasToAxisCoords({
	          left: canvasX,
	          top: canvasY
	        });
	      pos.pageX = event.pageX;
	      pos.pageY = event.pageY;
	      var item = findNearbyItem(canvasX, canvasY, seriesFilter);
	      if (item) {
	        // fill in mouse pos for any listeners out there
	        item.pageX = parseInt(item.series.xaxis.p2c(item.datapoint[0]) + offset.left + plotOffset.left, 10);
	        item.pageY = parseInt(item.series.yaxis.p2c(item.datapoint[1]) + offset.top + plotOffset.top, 10);
	      }
	      if (options.grid.autoHighlight) {
	        // clear auto-highlights
	        for (var i = 0; i < highlights.length; ++i) {
	          var h = highlights[i];
	          if (h.auto == eventname && !(item && h.series == item.series && h.point[0] == item.datapoint[0] && h.point[1] == item.datapoint[1])) unhighlight(h.series, h.point);
	        }
	        if (item) highlight(item.series, item.datapoint, eventname);
	      }
	      placeholder.trigger(eventname, [pos, item]);
	    }
	    function triggerRedrawOverlay() {
	      var t = options.interaction.redrawOverlayInterval;
	      if (t == -1) {
	        // skip event queue
	        drawOverlay();
	        return;
	      }
	      if (!redrawTimeout) redrawTimeout = setTimeout(drawOverlay, t);
	    }
	    function drawOverlay() {
	      redrawTimeout = null;

	      // draw highlights
	      octx.save();
	      overlay.clear();
	      octx.translate(plotOffset.left, plotOffset.top);
	      var i, hi;
	      for (i = 0; i < highlights.length; ++i) {
	        hi = highlights[i];
	        if (hi.series.bars.show) drawBarHighlight(hi.series, hi.point);else drawPointHighlight(hi.series, hi.point);
	      }
	      octx.restore();
	      executeHooks(hooks.drawOverlay, [octx]);
	    }
	    function highlight(s, point, auto) {
	      if (typeof s == "number") s = series[s];
	      if (typeof point == "number") {
	        var ps = s.datapoints.pointsize;
	        point = s.datapoints.points.slice(ps * point, ps * (point + 1));
	      }
	      var i = indexOfHighlight(s, point);
	      if (i == -1) {
	        highlights.push({
	          series: s,
	          point: point,
	          auto: auto
	        });
	        triggerRedrawOverlay();
	      } else if (!auto) highlights[i].auto = false;
	    }
	    function unhighlight(s, point) {
	      if (s == null && point == null) {
	        highlights = [];
	        triggerRedrawOverlay();
	        return;
	      }
	      if (typeof s == "number") s = series[s];
	      if (typeof point == "number") {
	        var ps = s.datapoints.pointsize;
	        point = s.datapoints.points.slice(ps * point, ps * (point + 1));
	      }
	      var i = indexOfHighlight(s, point);
	      if (i != -1) {
	        highlights.splice(i, 1);
	        triggerRedrawOverlay();
	      }
	    }
	    function indexOfHighlight(s, p) {
	      for (var i = 0; i < highlights.length; ++i) {
	        var h = highlights[i];
	        if (h.series == s && h.point[0] == p[0] && h.point[1] == p[1]) return i;
	      }
	      return -1;
	    }
	    function drawPointHighlight(series, point) {
	      var x = point[0],
	        y = point[1],
	        axisx = series.xaxis,
	        axisy = series.yaxis,
	        highlightColor = typeof series.highlightColor === "string" ? series.highlightColor : $.color.parse(series.color).scale('a', 0.5).toString();
	      if (x < axisx.min || x > axisx.max || y < axisy.min || y > axisy.max) return;
	      var pointRadius = series.points.radius + series.points.lineWidth / 2;
	      octx.lineWidth = pointRadius;
	      octx.strokeStyle = highlightColor;
	      var radius = 1.5 * pointRadius;
	      x = axisx.p2c(x);
	      y = axisy.p2c(y);
	      octx.beginPath();
	      if (series.points.symbol == "circle") octx.arc(x, y, radius, 0, 2 * Math.PI, false);else series.points.symbol(octx, x, y, radius, false);
	      octx.closePath();
	      octx.stroke();
	    }
	    function drawBarHighlight(series, point) {
	      var highlightColor = typeof series.highlightColor === "string" ? series.highlightColor : $.color.parse(series.color).scale('a', 0.5).toString(),
	        fillStyle = highlightColor,
	        barLeft;
	      switch (series.bars.align) {
	        case "left":
	          barLeft = 0;
	          break;
	        case "right":
	          barLeft = -series.bars.barWidth;
	          break;
	        default:
	          barLeft = -series.bars.barWidth / 2;
	      }
	      octx.lineWidth = series.bars.lineWidth;
	      octx.strokeStyle = highlightColor;
	      drawBar(point[0], point[1], point[2] || 0, barLeft, barLeft + series.bars.barWidth, function () {
	        return fillStyle;
	      }, series.xaxis, series.yaxis, octx, series.bars.horizontal, series.bars.lineWidth);
	    }
	    function getColorOrGradient(spec, bottom, top, defaultColor) {
	      if (typeof spec == "string") return spec;else {
	        // assume this is a gradient spec; IE currently only
	        // supports a simple vertical gradient properly, so that's
	        // what we support too
	        var gradient = ctx.createLinearGradient(0, top, 0, bottom);
	        for (var i = 0, l = spec.colors.length; i < l; ++i) {
	          var c = spec.colors[i];
	          if (typeof c != "string") {
	            var co = $.color.parse(defaultColor);
	            if (c.brightness != null) co = co.scale('rgb', c.brightness);
	            if (c.opacity != null) co.a *= c.opacity;
	            c = co.toString();
	          }
	          gradient.addColorStop(i / (l - 1), c);
	        }
	        return gradient;
	      }
	    }
	  }

	  // Add the plot function to the top level of the jQuery object

	  $.plot = function (placeholder, data, options) {
	    //var t0 = new Date();
	    var plot = new Plot($(placeholder), data, options, $.plot.plugins);
	    //(window.console ? console.log : alert)("time used (msecs): " + ((new Date()).getTime() - t0.getTime()));
	    return plot;
	  };
	  $.plot.version = "0.8.3";
	  $.plot.plugins = [];

	  // Also add the plot function as a chainable property

	  $.fn.plot = function (data, options) {
	    return this.each(function () {
	      $.plot(this, data, options);
	    });
	  };

	  // round to nearby lower multiple of base
	  function floorInBase(n, base) {
	    return base * Math.floor(n / base);
	  }
	})(jQuery);

	/* Flot plugin for rendering pie charts.

	Copyright (c) 2007-2014 IOLA and Ole Laursen.
	Licensed under the MIT license.

	The plugin assumes that each series has a single data value, and that each
	value is a positive integer or zero.  Negative numbers don't make sense for a
	pie chart, and have unpredictable results.  The values do NOT need to be
	passed in as percentages; the plugin will calculate the total and per-slice
	percentages internally.

	* Created by Brian Medendorp

	* Updated with contributions from btburnett3, Anthony Aragues and Xavi Ivars

	The plugin supports these options:

		series: {
			pie: {
				show: true/false
				radius: 0-1 for percentage of fullsize, or a specified pixel length, or 'auto'
				innerRadius: 0-1 for percentage of fullsize or a specified pixel length, for creating a donut effect
				startAngle: 0-2 factor of PI used for starting angle (in radians) i.e 3/2 starts at the top, 0 and 2 have the same result
				tilt: 0-1 for percentage to tilt the pie, where 1 is no tilt, and 0 is completely flat (nothing will show)
				offset: {
					top: integer value to move the pie up or down
					left: integer value to move the pie left or right, or 'auto'
				},
				stroke: {
					color: any hexidecimal color value (other formats may or may not work, so best to stick with something like '#FFF')
					width: integer pixel width of the stroke
				},
				label: {
					show: true/false, or 'auto'
					formatter:  a user-defined function that modifies the text/style of the label text
					radius: 0-1 for percentage of fullsize, or a specified pixel length
					background: {
						color: any hexidecimal color value (other formats may or may not work, so best to stick with something like '#000')
						opacity: 0-1
					},
					threshold: 0-1 for the percentage value at which to hide labels (if they're too small)
				},
				combine: {
					threshold: 0-1 for the percentage value at which to combine slices (if they're too small)
					color: any hexidecimal color value (other formats may or may not work, so best to stick with something like '#CCC'), if null, the plugin will automatically use the color of the first slice to be combined
					label: any text value of what the combined slice should be labeled
				}
				highlight: {
					opacity: 0-1
				}
			}
		}

	More detail and specific examples can be found in the included HTML file.

	*/

	(function ($) {
	  // Maximum redraw attempts when fitting labels within the plot

	  var REDRAW_ATTEMPTS = 10;

	  // Factor by which to shrink the pie when fitting labels within the plot

	  var REDRAW_SHRINK = 0.95;
	  function init(plot) {
	    var canvas = null,
	      target = null,
	      options = null,
	      maxRadius = null,
	      centerLeft = null,
	      centerTop = null,
	      processed = false,
	      ctx = null;

	    // interactive variables

	    var highlights = [];

	    // add hook to determine if pie plugin in enabled, and then perform necessary operations

	    plot.hooks.processOptions.push(function (plot, options) {
	      if (options.series.pie.show) {
	        options.grid.show = false;

	        // set labels.show

	        if (options.series.pie.label.show == "auto") {
	          if (options.legend.show) {
	            options.series.pie.label.show = false;
	          } else {
	            options.series.pie.label.show = true;
	          }
	        }

	        // set radius

	        if (options.series.pie.radius == "auto") {
	          if (options.series.pie.label.show) {
	            options.series.pie.radius = 3 / 4;
	          } else {
	            options.series.pie.radius = 1;
	          }
	        }

	        // ensure sane tilt

	        if (options.series.pie.tilt > 1) {
	          options.series.pie.tilt = 1;
	        } else if (options.series.pie.tilt < 0) {
	          options.series.pie.tilt = 0;
	        }
	      }
	    });
	    plot.hooks.bindEvents.push(function (plot, eventHolder) {
	      var options = plot.getOptions();
	      if (options.series.pie.show) {
	        if (options.grid.hoverable) {
	          eventHolder.unbind("mousemove").mousemove(onMouseMove);
	        }
	        if (options.grid.clickable) {
	          eventHolder.unbind("click").click(onClick);
	        }
	      }
	    });
	    plot.hooks.processDatapoints.push(function (plot, series, data, datapoints) {
	      var options = plot.getOptions();
	      if (options.series.pie.show) {
	        processDatapoints(plot);
	      }
	    });
	    plot.hooks.drawOverlay.push(function (plot, octx) {
	      var options = plot.getOptions();
	      if (options.series.pie.show) {
	        drawOverlay(plot, octx);
	      }
	    });
	    plot.hooks.draw.push(function (plot, newCtx) {
	      var options = plot.getOptions();
	      if (options.series.pie.show) {
	        draw(plot, newCtx);
	      }
	    });
	    function processDatapoints(plot, series, datapoints) {
	      if (!processed) {
	        processed = true;
	        canvas = plot.getCanvas();
	        target = $(canvas).parent();
	        options = plot.getOptions();
	        plot.setData(combine(plot.getData()));
	      }
	    }
	    function combine(data) {
	      var total = 0,
	        combined = 0,
	        numCombined = 0,
	        color = options.series.pie.combine.color,
	        newdata = [];

	      // Fix up the raw data from Flot, ensuring the data is numeric

	      for (var i = 0; i < data.length; ++i) {
	        var value = data[i].data;

	        // If the data is an array, we'll assume that it's a standard
	        // Flot x-y pair, and are concerned only with the second value.

	        // Note how we use the original array, rather than creating a
	        // new one; this is more efficient and preserves any extra data
	        // that the user may have stored in higher indexes.

	        if ($.isArray(value) && value.length == 1) {
	          value = value[0];
	        }
	        if ($.isArray(value)) {
	          // Equivalent to $.isNumeric() but compatible with jQuery < 1.7
	          if (!isNaN(parseFloat(value[1])) && isFinite(value[1])) {
	            value[1] = +value[1];
	          } else {
	            value[1] = 0;
	          }
	        } else if (!isNaN(parseFloat(value)) && isFinite(value)) {
	          value = [1, +value];
	        } else {
	          value = [1, 0];
	        }
	        data[i].data = [value];
	      }

	      // Sum up all the slices, so we can calculate percentages for each

	      for (var i = 0; i < data.length; ++i) {
	        total += data[i].data[0][1];
	      }

	      // Count the number of slices with percentages below the combine
	      // threshold; if it turns out to be just one, we won't combine.

	      for (var i = 0; i < data.length; ++i) {
	        var value = data[i].data[0][1];
	        if (value / total <= options.series.pie.combine.threshold) {
	          combined += value;
	          numCombined++;
	          if (!color) {
	            color = data[i].color;
	          }
	        }
	      }
	      for (var i = 0; i < data.length; ++i) {
	        var value = data[i].data[0][1];
	        if (numCombined < 2 || value / total > options.series.pie.combine.threshold) {
	          newdata.push($.extend(data[i], {
	            /* extend to allow keeping all other original data values
	               and using them e.g. in labelFormatter. */
	            data: [[1, value]],
	            color: data[i].color,
	            label: data[i].label,
	            angle: value * Math.PI * 2 / total,
	            percent: value / (total / 100)
	          }));
	        }
	      }
	      if (numCombined > 1) {
	        newdata.push({
	          data: [[1, combined]],
	          color: color,
	          label: options.series.pie.combine.label,
	          angle: combined * Math.PI * 2 / total,
	          percent: combined / (total / 100)
	        });
	      }
	      return newdata;
	    }
	    function draw(plot, newCtx) {
	      if (!target) {
	        return; // if no series were passed
	      }
	      var canvasWidth = plot.getPlaceholder().width(),
	        canvasHeight = plot.getPlaceholder().height(),
	        legendWidth = target.children().filter(".legend").children().width() || 0;
	      ctx = newCtx;

	      // WARNING: HACK! REWRITE THIS CODE AS SOON AS POSSIBLE!

	      // When combining smaller slices into an 'other' slice, we need to
	      // add a new series.  Since Flot gives plugins no way to modify the
	      // list of series, the pie plugin uses a hack where the first call
	      // to processDatapoints results in a call to setData with the new
	      // list of series, then subsequent processDatapoints do nothing.

	      // The plugin-global 'processed' flag is used to control this hack;
	      // it starts out false, and is set to true after the first call to
	      // processDatapoints.

	      // Unfortunately this turns future setData calls into no-ops; they
	      // call processDatapoints, the flag is true, and nothing happens.

	      // To fix this we'll set the flag back to false here in draw, when
	      // all series have been processed, so the next sequence of calls to
	      // processDatapoints once again starts out with a slice-combine.
	      // This is really a hack; in 0.9 we need to give plugins a proper
	      // way to modify series before any processing begins.

	      processed = false;

	      // calculate maximum radius and center point

	      maxRadius = Math.min(canvasWidth, canvasHeight / options.series.pie.tilt) / 2;
	      centerTop = canvasHeight / 2 + options.series.pie.offset.top;
	      centerLeft = canvasWidth / 2;
	      if (options.series.pie.offset.left == "auto") {
	        if (options.legend.position.match("w")) {
	          centerLeft += legendWidth / 2;
	        } else {
	          centerLeft -= legendWidth / 2;
	        }
	        if (centerLeft < maxRadius) {
	          centerLeft = maxRadius;
	        } else if (centerLeft > canvasWidth - maxRadius) {
	          centerLeft = canvasWidth - maxRadius;
	        }
	      } else {
	        centerLeft += options.series.pie.offset.left;
	      }
	      var slices = plot.getData(),
	        attempts = 0;

	      // Keep shrinking the pie's radius until drawPie returns true,
	      // indicating that all the labels fit, or we try too many times.

	      do {
	        if (attempts > 0) {
	          maxRadius *= REDRAW_SHRINK;
	        }
	        attempts += 1;
	        clear();
	        if (options.series.pie.tilt <= 0.8) {
	          drawShadow();
	        }
	      } while (!drawPie() && attempts < REDRAW_ATTEMPTS);
	      if (attempts >= REDRAW_ATTEMPTS) {
	        clear();
	        target.prepend("<div class='error'>Could not draw pie with labels contained inside canvas</div>");
	      }
	      if (plot.setSeries && plot.insertLegend) {
	        plot.setSeries(slices);
	        plot.insertLegend();
	      }

	      // we're actually done at this point, just defining internal functions at this point

	      function clear() {
	        ctx.clearRect(0, 0, canvasWidth, canvasHeight);
	        target.children().filter(".pieLabel, .pieLabelBackground").remove();
	      }
	      function drawShadow() {
	        var shadowLeft = options.series.pie.shadow.left;
	        var shadowTop = options.series.pie.shadow.top;
	        var edge = 10;
	        var alpha = options.series.pie.shadow.alpha;
	        var radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius;
	        if (radius >= canvasWidth / 2 - shadowLeft || radius * options.series.pie.tilt >= canvasHeight / 2 - shadowTop || radius <= edge) {
	          return; // shadow would be outside canvas, so don't draw it
	        }
	        ctx.save();
	        ctx.translate(shadowLeft, shadowTop);
	        ctx.globalAlpha = alpha;
	        ctx.fillStyle = "#000";

	        // center and rotate to starting position

	        ctx.translate(centerLeft, centerTop);
	        ctx.scale(1, options.series.pie.tilt);

	        //radius -= edge;

	        for (var i = 1; i <= edge; i++) {
	          ctx.beginPath();
	          ctx.arc(0, 0, radius, 0, Math.PI * 2, false);
	          ctx.fill();
	          radius -= i;
	        }
	        ctx.restore();
	      }
	      function drawPie() {
	        var startAngle = Math.PI * options.series.pie.startAngle;
	        var radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius;

	        // center and rotate to starting position

	        ctx.save();
	        ctx.translate(centerLeft, centerTop);
	        ctx.scale(1, options.series.pie.tilt);
	        //ctx.rotate(startAngle); // start at top; -- This doesn't work properly in Opera

	        // draw slices

	        ctx.save();
	        var currentAngle = startAngle;
	        for (var i = 0; i < slices.length; ++i) {
	          slices[i].startAngle = currentAngle;
	          drawSlice(slices[i].angle, slices[i].color, true);
	        }
	        ctx.restore();

	        // draw slice outlines

	        if (options.series.pie.stroke.width > 0) {
	          ctx.save();
	          ctx.lineWidth = options.series.pie.stroke.width;
	          currentAngle = startAngle;
	          for (var i = 0; i < slices.length; ++i) {
	            drawSlice(slices[i].angle, options.series.pie.stroke.color, false);
	          }
	          ctx.restore();
	        }

	        // draw donut hole

	        drawDonutHole(ctx);
	        ctx.restore();

	        // Draw the labels, returning true if they fit within the plot

	        if (options.series.pie.label.show) {
	          return drawLabels();
	        } else return true;
	        function drawSlice(angle, color, fill) {
	          if (angle <= 0 || isNaN(angle)) {
	            return;
	          }
	          if (fill) {
	            ctx.fillStyle = color;
	          } else {
	            ctx.strokeStyle = color;
	            ctx.lineJoin = "round";
	          }
	          ctx.beginPath();
	          if (Math.abs(angle - Math.PI * 2) > 0.000000001) {
	            ctx.moveTo(0, 0); // Center of the pie
	          }

	          //ctx.arc(0, 0, radius, 0, angle, false); // This doesn't work properly in Opera
	          ctx.arc(0, 0, radius, currentAngle, currentAngle + angle / 2, false);
	          ctx.arc(0, 0, radius, currentAngle + angle / 2, currentAngle + angle, false);
	          ctx.closePath();
	          //ctx.rotate(angle); // This doesn't work properly in Opera
	          currentAngle += angle;
	          if (fill) {
	            ctx.fill();
	          } else {
	            ctx.stroke();
	          }
	        }
	        function drawLabels() {
	          var currentAngle = startAngle;
	          var radius = options.series.pie.label.radius > 1 ? options.series.pie.label.radius : maxRadius * options.series.pie.label.radius;
	          for (var i = 0; i < slices.length; ++i) {
	            if (slices[i].percent >= options.series.pie.label.threshold * 100) {
	              if (!drawLabel(slices[i], currentAngle, i)) {
	                return false;
	              }
	            }
	            currentAngle += slices[i].angle;
	          }
	          return true;
	          function drawLabel(slice, startAngle, index) {
	            if (slice.data[0][1] == 0) {
	              return true;
	            }

	            // format label text

	            var lf = options.legend.labelFormatter,
	              text,
	              plf = options.series.pie.label.formatter;
	            if (lf) {
	              text = lf(slice.label, slice);
	            } else {
	              text = slice.label;
	            }
	            if (plf) {
	              text = plf(text, slice);
	            }
	            var halfAngle = (startAngle + slice.angle + startAngle) / 2;
	            var x = centerLeft + Math.round(Math.cos(halfAngle) * radius);
	            var y = centerTop + Math.round(Math.sin(halfAngle) * radius) * options.series.pie.tilt;
	            var html = "<span class='pieLabel' id='pieLabel" + index + "' style='position:absolute;top:" + y + "px;left:" + x + "px;'>" + text + "</span>";
	            target.append(html);
	            var label = target.children("#pieLabel" + index);
	            var labelTop = y - label.height() / 2;
	            var labelLeft = x - label.width() / 2;
	            label.css("top", labelTop);
	            label.css("left", labelLeft);

	            // check to make sure that the label is not outside the canvas

	            if (0 - labelTop > 0 || 0 - labelLeft > 0 || canvasHeight - (labelTop + label.height()) < 0 || canvasWidth - (labelLeft + label.width()) < 0) {
	              return false;
	            }
	            if (options.series.pie.label.background.opacity != 0) {
	              // put in the transparent background separately to avoid blended labels and label boxes

	              var c = options.series.pie.label.background.color;
	              if (c == null) {
	                c = slice.color;
	              }
	              var pos = "top:" + labelTop + "px;left:" + labelLeft + "px;";
	              $("<div class='pieLabelBackground' style='position:absolute;width:" + label.width() + "px;height:" + label.height() + "px;" + pos + "background-color:" + c + ";'></div>").css("opacity", options.series.pie.label.background.opacity).insertBefore(label);
	            }
	            return true;
	          } // end individual label function
	        } // end drawLabels function
	      } // end drawPie function
	    } // end draw function

	    // Placed here because it needs to be accessed from multiple locations

	    function drawDonutHole(layer) {
	      if (options.series.pie.innerRadius > 0) {
	        // subtract the center

	        layer.save();
	        var innerRadius = options.series.pie.innerRadius > 1 ? options.series.pie.innerRadius : maxRadius * options.series.pie.innerRadius;
	        layer.globalCompositeOperation = "destination-out"; // this does not work with excanvas, but it will fall back to using the stroke color
	        layer.beginPath();
	        layer.fillStyle = options.series.pie.stroke.color;
	        layer.arc(0, 0, innerRadius, 0, Math.PI * 2, false);
	        layer.fill();
	        layer.closePath();
	        layer.restore();

	        // add inner stroke

	        layer.save();
	        layer.beginPath();
	        layer.strokeStyle = options.series.pie.stroke.color;
	        layer.arc(0, 0, innerRadius, 0, Math.PI * 2, false);
	        layer.stroke();
	        layer.closePath();
	        layer.restore();

	        // TODO: add extra shadow inside hole (with a mask) if the pie is tilted.
	      }
	    }

	    //-- Additional Interactive related functions --

	    function isPointInPoly(poly, pt) {
	      for (var c = false, i = -1, l = poly.length, j = l - 1; ++i < l; j = i) (poly[i][1] <= pt[1] && pt[1] < poly[j][1] || poly[j][1] <= pt[1] && pt[1] < poly[i][1]) && pt[0] < (poly[j][0] - poly[i][0]) * (pt[1] - poly[i][1]) / (poly[j][1] - poly[i][1]) + poly[i][0] && (c = !c);
	      return c;
	    }
	    function findNearbySlice(mouseX, mouseY) {
	      var slices = plot.getData(),
	        options = plot.getOptions(),
	        radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius,
	        x,
	        y;
	      for (var i = 0; i < slices.length; ++i) {
	        var s = slices[i];
	        if (s.pie.show) {
	          ctx.save();
	          ctx.beginPath();
	          ctx.moveTo(0, 0); // Center of the pie
	          //ctx.scale(1, options.series.pie.tilt);	// this actually seems to break everything when here.
	          ctx.arc(0, 0, radius, s.startAngle, s.startAngle + s.angle / 2, false);
	          ctx.arc(0, 0, radius, s.startAngle + s.angle / 2, s.startAngle + s.angle, false);
	          ctx.closePath();
	          x = mouseX - centerLeft;
	          y = mouseY - centerTop;
	          if (ctx.isPointInPath) {
	            if (ctx.isPointInPath(mouseX - centerLeft, mouseY - centerTop)) {
	              ctx.restore();
	              return {
	                datapoint: [s.percent, s.data],
	                dataIndex: 0,
	                series: s,
	                seriesIndex: i
	              };
	            }
	          } else {
	            // excanvas for IE doesn;t support isPointInPath, this is a workaround.

	            var p1X = radius * Math.cos(s.startAngle),
	              p1Y = radius * Math.sin(s.startAngle),
	              p2X = radius * Math.cos(s.startAngle + s.angle / 4),
	              p2Y = radius * Math.sin(s.startAngle + s.angle / 4),
	              p3X = radius * Math.cos(s.startAngle + s.angle / 2),
	              p3Y = radius * Math.sin(s.startAngle + s.angle / 2),
	              p4X = radius * Math.cos(s.startAngle + s.angle / 1.5),
	              p4Y = radius * Math.sin(s.startAngle + s.angle / 1.5),
	              p5X = radius * Math.cos(s.startAngle + s.angle),
	              p5Y = radius * Math.sin(s.startAngle + s.angle),
	              arrPoly = [[0, 0], [p1X, p1Y], [p2X, p2Y], [p3X, p3Y], [p4X, p4Y], [p5X, p5Y]],
	              arrPoint = [x, y];

	            // TODO: perhaps do some mathmatical trickery here with the Y-coordinate to compensate for pie tilt?

	            if (isPointInPoly(arrPoly, arrPoint)) {
	              ctx.restore();
	              return {
	                datapoint: [s.percent, s.data],
	                dataIndex: 0,
	                series: s,
	                seriesIndex: i
	              };
	            }
	          }
	          ctx.restore();
	        }
	      }
	      return null;
	    }
	    function onMouseMove(e) {
	      triggerClickHoverEvent("plothover", e);
	    }
	    function onClick(e) {
	      triggerClickHoverEvent("plotclick", e);
	    }

	    // trigger click or hover event (they send the same parameters so we share their code)

	    function triggerClickHoverEvent(eventname, e) {
	      var offset = plot.offset();
	      var canvasX = parseInt(e.pageX - offset.left);
	      var canvasY = parseInt(e.pageY - offset.top);
	      var item = findNearbySlice(canvasX, canvasY);
	      if (options.grid.autoHighlight) {
	        // clear auto-highlights

	        for (var i = 0; i < highlights.length; ++i) {
	          var h = highlights[i];
	          if (h.auto == eventname && !(item && h.series == item.series)) {
	            unhighlight(h.series);
	          }
	        }
	      }

	      // highlight the slice

	      if (item) {
	        highlight(item.series, eventname);
	      }

	      // trigger any hover bind events

	      var pos = {
	        pageX: e.pageX,
	        pageY: e.pageY
	      };
	      target.trigger(eventname, [pos, item]);
	    }
	    function highlight(s, auto) {
	      //if (typeof s == "number") {
	      //	s = series[s];
	      //}

	      var i = indexOfHighlight(s);
	      if (i == -1) {
	        highlights.push({
	          series: s,
	          auto: auto
	        });
	        plot.triggerRedrawOverlay();
	      } else if (!auto) {
	        highlights[i].auto = false;
	      }
	    }
	    function unhighlight(s) {
	      if (s == null) {
	        highlights = [];
	        plot.triggerRedrawOverlay();
	      }

	      //if (typeof s == "number") {
	      //	s = series[s];
	      //}

	      var i = indexOfHighlight(s);
	      if (i != -1) {
	        highlights.splice(i, 1);
	        plot.triggerRedrawOverlay();
	      }
	    }
	    function indexOfHighlight(s) {
	      for (var i = 0; i < highlights.length; ++i) {
	        var h = highlights[i];
	        if (h.series == s) return i;
	      }
	      return -1;
	    }
	    function drawOverlay(plot, octx) {
	      var options = plot.getOptions();
	      var radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius;
	      octx.save();
	      octx.translate(centerLeft, centerTop);
	      octx.scale(1, options.series.pie.tilt);
	      for (var i = 0; i < highlights.length; ++i) {
	        drawHighlight(highlights[i].series);
	      }
	      drawDonutHole(octx);
	      octx.restore();
	      function drawHighlight(series) {
	        if (series.angle <= 0 || isNaN(series.angle)) {
	          return;
	        }

	        //octx.fillStyle = parseColor(options.series.pie.highlight.color).scale(null, null, null, options.series.pie.highlight.opacity).toString();
	        octx.fillStyle = "rgba(255, 255, 255, " + options.series.pie.highlight.opacity + ")"; // this is temporary until we have access to parseColor
	        octx.beginPath();
	        if (Math.abs(series.angle - Math.PI * 2) > 0.000000001) {
	          octx.moveTo(0, 0); // Center of the pie
	        }
	        octx.arc(0, 0, radius, series.startAngle, series.startAngle + series.angle / 2, false);
	        octx.arc(0, 0, radius, series.startAngle + series.angle / 2, series.startAngle + series.angle, false);
	        octx.closePath();
	        octx.fill();
	      }
	    }
	  } // end init (plugin body)

	  // define pie specific options and their default values

	  var options = {
	    series: {
	      pie: {
	        show: false,
	        radius: "auto",
	        // actual radius of the visible pie (based on full calculated radius if <=1, or hard pixel value)
	        innerRadius: 0,
	        /* for donut */
	        startAngle: 3 / 2,
	        tilt: 1,
	        shadow: {
	          left: 5,
	          // shadow left offset
	          top: 15,
	          // shadow top offset
	          alpha: 0.02 // shadow alpha
	        },
	        offset: {
	          top: 0,
	          left: "auto"
	        },
	        stroke: {
	          color: "#fff",
	          width: 1
	        },
	        label: {
	          show: "auto",
	          formatter: function (label, slice) {
	            return "<div style='font-size:x-small;text-align:center;padding:2px;color:" + slice.color + ";'>" + label + "<br/>" + Math.round(slice.percent) + "%</div>";
	          },
	          // formatter function
	          radius: 1,
	          // radius at which to place the labels (based on full calculated radius if <=1, or hard pixel value)
	          background: {
	            color: null,
	            opacity: 0
	          },
	          threshold: 0 // percentage at which to hide the label (i.e. the slice is too narrow)
	        },
	        combine: {
	          threshold: -1,
	          // percentage at which to combine little slices into one larger slice
	          color: null,
	          // color to give the new slice (auto-generated if null)
	          label: "Other" // label to give the new slice
	        },
	        highlight: {
	          //color: "#fff",		// will add this functionality once parseColor is available
	          opacity: 0.5
	        }
	      }
	    }
	  };
	  $.plot.plugins.push({
	    init: init,
	    options: options,
	    name: "pie",
	    version: "1.1"
	  });
	})(jQuery);

	/* Flot plugin for selecting regions of a plot.

	Copyright (c) 2007-2014 IOLA and Ole Laursen.
	Licensed under the MIT license.

	The plugin supports these options:

	selection: {
		mode: null or "x" or "y" or "xy",
		color: color,
		shape: "round" or "miter" or "bevel",
		minSize: number of pixels
	}

	Selection support is enabled by setting the mode to one of "x", "y" or "xy".
	In "x" mode, the user will only be able to specify the x range, similarly for
	"y" mode. For "xy", the selection becomes a rectangle where both ranges can be
	specified. "color" is color of the selection (if you need to change the color
	later on, you can get to it with plot.getOptions().selection.color). "shape"
	is the shape of the corners of the selection.

	"minSize" is the minimum size a selection can be in pixels. This value can
	be customized to determine the smallest size a selection can be and still
	have the selection rectangle be displayed. When customizing this value, the
	fact that it refers to pixels, not axis units must be taken into account.
	Thus, for example, if there is a bar graph in time mode with BarWidth set to 1
	minute, setting "minSize" to 1 will not make the minimum selection size 1
	minute, but rather 1 pixel. Note also that setting "minSize" to 0 will prevent
	"plotunselected" events from being fired when the user clicks the mouse without
	dragging.

	When selection support is enabled, a "plotselected" event will be emitted on
	the DOM element you passed into the plot function. The event handler gets a
	parameter with the ranges selected on the axes, like this:

		placeholder.bind( "plotselected", function( event, ranges ) {
			alert("You selected " + ranges.xaxis.from + " to " + ranges.xaxis.to)
			// similar for yaxis - with multiple axes, the extra ones are in
			// x2axis, x3axis, ...
		});

	The "plotselected" event is only fired when the user has finished making the
	selection. A "plotselecting" event is fired during the process with the same
	parameters as the "plotselected" event, in case you want to know what's
	happening while it's happening,

	A "plotunselected" event with no arguments is emitted when the user clicks the
	mouse to remove the selection. As stated above, setting "minSize" to 0 will
	destroy this behavior.

	The plugin allso adds the following methods to the plot object:

	- setSelection( ranges, preventEvent )

	  Set the selection rectangle. The passed in ranges is on the same form as
	  returned in the "plotselected" event. If the selection mode is "x", you
	  should put in either an xaxis range, if the mode is "y" you need to put in
	  an yaxis range and both xaxis and yaxis if the selection mode is "xy", like
	  this:

		setSelection({ xaxis: { from: 0, to: 10 }, yaxis: { from: 40, to: 60 } });

	  setSelection will trigger the "plotselected" event when called. If you don't
	  want that to happen, e.g. if you're inside a "plotselected" handler, pass
	  true as the second parameter. If you are using multiple axes, you can
	  specify the ranges on any of those, e.g. as x2axis/x3axis/... instead of
	  xaxis, the plugin picks the first one it sees.

	- clearSelection( preventEvent )

	  Clear the selection rectangle. Pass in true to avoid getting a
	  "plotunselected" event.

	- getSelection()

	  Returns the current selection in the same format as the "plotselected"
	  event. If there's currently no selection, the function returns null.

	*/

	(function ($) {
	  function init(plot) {
	    var selection = {
	      first: {
	        x: -1,
	        y: -1
	      },
	      second: {
	        x: -1,
	        y: -1
	      },
	      show: false,
	      active: false
	    };

	    // FIXME: The drag handling implemented here should be
	    // abstracted out, there's some similar code from a library in
	    // the navigation plugin, this should be massaged a bit to fit
	    // the Flot cases here better and reused. Doing this would
	    // make this plugin much slimmer.
	    var savedhandlers = {};
	    var mouseUpHandler = null;
	    function onMouseMove(e) {
	      if (selection.active) {
	        updateSelection(e);
	        plot.getPlaceholder().trigger("plotselecting", [getSelection()]);
	      }
	    }
	    function onMouseDown(e) {
	      if (e.which != 1)
	        // only accept left-click
	        return;

	      // cancel out any text selections
	      document.body.focus();

	      // prevent text selection and drag in old-school browsers
	      if (document.onselectstart !== undefined && savedhandlers.onselectstart == null) {
	        savedhandlers.onselectstart = document.onselectstart;
	        document.onselectstart = function () {
	          return false;
	        };
	      }
	      if (document.ondrag !== undefined && savedhandlers.ondrag == null) {
	        savedhandlers.ondrag = document.ondrag;
	        document.ondrag = function () {
	          return false;
	        };
	      }
	      setSelectionPos(selection.first, e);
	      selection.active = true;

	      // this is a bit silly, but we have to use a closure to be
	      // able to whack the same handler again
	      mouseUpHandler = function (e) {
	        onMouseUp(e);
	      };
	      $(document).one("mouseup", mouseUpHandler);
	    }
	    function onMouseUp(e) {
	      mouseUpHandler = null;

	      // revert drag stuff for old-school browsers
	      if (document.onselectstart !== undefined) document.onselectstart = savedhandlers.onselectstart;
	      if (document.ondrag !== undefined) document.ondrag = savedhandlers.ondrag;

	      // no more dragging
	      selection.active = false;
	      updateSelection(e);
	      if (selectionIsSane()) triggerSelectedEvent();else {
	        // this counts as a clear
	        plot.getPlaceholder().trigger("plotunselected", []);
	        plot.getPlaceholder().trigger("plotselecting", [null]);
	      }
	      return false;
	    }
	    function getSelection() {
	      if (!selectionIsSane()) return null;
	      if (!selection.show) return null;
	      var r = {},
	        c1 = selection.first,
	        c2 = selection.second;
	      $.each(plot.getAxes(), function (name, axis) {
	        if (axis.used) {
	          var p1 = axis.c2p(c1[axis.direction]),
	            p2 = axis.c2p(c2[axis.direction]);
	          r[name] = {
	            from: Math.min(p1, p2),
	            to: Math.max(p1, p2)
	          };
	        }
	      });
	      return r;
	    }
	    function triggerSelectedEvent() {
	      var r = getSelection();
	      plot.getPlaceholder().trigger("plotselected", [r]);

	      // backwards-compat stuff, to be removed in future
	      if (r.xaxis && r.yaxis) plot.getPlaceholder().trigger("selected", [{
	        x1: r.xaxis.from,
	        y1: r.yaxis.from,
	        x2: r.xaxis.to,
	        y2: r.yaxis.to
	      }]);
	    }
	    function clamp(min, value, max) {
	      return value < min ? min : value > max ? max : value;
	    }
	    function setSelectionPos(pos, e) {
	      var o = plot.getOptions();
	      var offset = plot.getPlaceholder().offset();
	      var plotOffset = plot.getPlotOffset();
	      pos.x = clamp(0, e.pageX - offset.left - plotOffset.left, plot.width());
	      pos.y = clamp(0, e.pageY - offset.top - plotOffset.top, plot.height());
	      if (o.selection.mode == "y") pos.x = pos == selection.first ? 0 : plot.width();
	      if (o.selection.mode == "x") pos.y = pos == selection.first ? 0 : plot.height();
	    }
	    function updateSelection(pos) {
	      if (pos.pageX == null) return;
	      setSelectionPos(selection.second, pos);
	      if (selectionIsSane()) {
	        selection.show = true;
	        plot.triggerRedrawOverlay();
	      } else clearSelection(true);
	    }
	    function clearSelection(preventEvent) {
	      if (selection.show) {
	        selection.show = false;
	        plot.triggerRedrawOverlay();
	        if (!preventEvent) plot.getPlaceholder().trigger("plotunselected", []);
	      }
	    }

	    // function taken from markings support in Flot
	    function extractRange(ranges, coord) {
	      var axis,
	        from,
	        to,
	        key,
	        axes = plot.getAxes();
	      for (var k in axes) {
	        axis = axes[k];
	        if (axis.direction == coord) {
	          key = coord + axis.n + "axis";
	          if (!ranges[key] && axis.n == 1) key = coord + "axis"; // support x1axis as xaxis
	          if (ranges[key]) {
	            from = ranges[key].from;
	            to = ranges[key].to;
	            break;
	          }
	        }
	      }

	      // backwards-compat stuff - to be removed in future
	      if (!ranges[key]) {
	        axis = coord == "x" ? plot.getXAxes()[0] : plot.getYAxes()[0];
	        from = ranges[coord + "1"];
	        to = ranges[coord + "2"];
	      }

	      // auto-reverse as an added bonus
	      if (from != null && to != null && from > to) {
	        var tmp = from;
	        from = to;
	        to = tmp;
	      }
	      return {
	        from: from,
	        to: to,
	        axis: axis
	      };
	    }
	    function setSelection(ranges, preventEvent) {
	      var range,
	        o = plot.getOptions();
	      if (o.selection.mode == "y") {
	        selection.first.x = 0;
	        selection.second.x = plot.width();
	      } else {
	        range = extractRange(ranges, "x");
	        selection.first.x = range.axis.p2c(range.from);
	        selection.second.x = range.axis.p2c(range.to);
	      }
	      if (o.selection.mode == "x") {
	        selection.first.y = 0;
	        selection.second.y = plot.height();
	      } else {
	        range = extractRange(ranges, "y");
	        selection.first.y = range.axis.p2c(range.from);
	        selection.second.y = range.axis.p2c(range.to);
	      }
	      selection.show = true;
	      plot.triggerRedrawOverlay();
	      if (!preventEvent && selectionIsSane()) triggerSelectedEvent();
	    }
	    function selectionIsSane() {
	      var minSize = plot.getOptions().selection.minSize;
	      return Math.abs(selection.second.x - selection.first.x) >= minSize && Math.abs(selection.second.y - selection.first.y) >= minSize;
	    }
	    plot.clearSelection = clearSelection;
	    plot.setSelection = setSelection;
	    plot.getSelection = getSelection;
	    plot.hooks.bindEvents.push(function (plot, eventHolder) {
	      var o = plot.getOptions();
	      if (o.selection.mode != null) {
	        eventHolder.mousemove(onMouseMove);
	        eventHolder.mousedown(onMouseDown);
	      }
	    });
	    plot.hooks.drawOverlay.push(function (plot, ctx) {
	      // draw selection
	      if (selection.show && selectionIsSane()) {
	        var plotOffset = plot.getPlotOffset();
	        var o = plot.getOptions();
	        ctx.save();
	        ctx.translate(plotOffset.left, plotOffset.top);
	        var c = $.color.parse(o.selection.color);
	        ctx.strokeStyle = c.scale('a', 0.8).toString();
	        ctx.lineWidth = 1;
	        ctx.lineJoin = o.selection.shape;
	        ctx.fillStyle = c.scale('a', 0.4).toString();
	        var x = Math.min(selection.first.x, selection.second.x) + 0.5,
	          y = Math.min(selection.first.y, selection.second.y) + 0.5,
	          w = Math.abs(selection.second.x - selection.first.x) - 1,
	          h = Math.abs(selection.second.y - selection.first.y) - 1;
	        ctx.fillRect(x, y, w, h);
	        ctx.strokeRect(x, y, w, h);
	        ctx.restore();
	      }
	    });
	    plot.hooks.shutdown.push(function (plot, eventHolder) {
	      eventHolder.unbind("mousemove", onMouseMove);
	      eventHolder.unbind("mousedown", onMouseDown);
	      if (mouseUpHandler) $(document).unbind("mouseup", mouseUpHandler);
	    });
	  }
	  $.plot.plugins.push({
	    init: init,
	    options: {
	      selection: {
	        mode: null,
	        // one of null, "x", "y" or "xy"
	        color: "#e8cfac",
	        shape: "round",
	        // one of "round", "miter", or "bevel"
	        minSize: 5 // minimum number of pixels
	      }
	    },
	    name: 'selection',
	    version: '1.1'
	  });
	})(jQuery);

	/* Pretty handling of time axes.

	Copyright (c) 2007-2014 IOLA and Ole Laursen.
	Licensed under the MIT license.

	Set axis.mode to "time" to enable. See the section "Time series data" in
	API.txt for details.

	*/

	(function ($) {
	  var options = {
	    xaxis: {
	      timezone: null,
	      // "browser" for local to the client or timezone for timezone-js
	      timeformat: null,
	      // format string to use
	      twelveHourClock: false,
	      // 12 or 24 time in time mode
	      monthNames: null // list of names of months
	    }
	  };

	  // round to nearby lower multiple of base

	  function floorInBase(n, base) {
	    return base * Math.floor(n / base);
	  }

	  // Returns a string with the date d formatted according to fmt.
	  // A subset of the Open Group's strftime format is supported.

	  function formatDate(d, fmt, monthNames, dayNames) {
	    if (typeof d.strftime == "function") {
	      return d.strftime(fmt);
	    }
	    var leftPad = function (n, pad) {
	      n = "" + n;
	      pad = "" + (pad == null ? "0" : pad);
	      return n.length == 1 ? pad + n : n;
	    };
	    var r = [];
	    var escape = false;
	    var hours = d.getHours();
	    var isAM = hours < 12;
	    if (monthNames == null) {
	      monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
	    }
	    if (dayNames == null) {
	      dayNames = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
	    }
	    var hours12;
	    if (hours > 12) {
	      hours12 = hours - 12;
	    } else if (hours == 0) {
	      hours12 = 12;
	    } else {
	      hours12 = hours;
	    }
	    for (var i = 0; i < fmt.length; ++i) {
	      var c = fmt.charAt(i);
	      if (escape) {
	        switch (c) {
	          case 'a':
	            c = "" + dayNames[d.getDay()];
	            break;
	          case 'b':
	            c = "" + monthNames[d.getMonth()];
	            break;
	          case 'd':
	            c = leftPad(d.getDate());
	            break;
	          case 'e':
	            c = leftPad(d.getDate(), " ");
	            break;
	          case 'h': // For back-compat with 0.7; remove in 1.0
	          case 'H':
	            c = leftPad(hours);
	            break;
	          case 'I':
	            c = leftPad(hours12);
	            break;
	          case 'l':
	            c = leftPad(hours12, " ");
	            break;
	          case 'm':
	            c = leftPad(d.getMonth() + 1);
	            break;
	          case 'M':
	            c = leftPad(d.getMinutes());
	            break;
	          // quarters not in Open Group's strftime specification
	          case 'q':
	            c = "" + (Math.floor(d.getMonth() / 3) + 1);
	            break;
	          case 'S':
	            c = leftPad(d.getSeconds());
	            break;
	          case 'y':
	            c = leftPad(d.getFullYear() % 100);
	            break;
	          case 'Y':
	            c = "" + d.getFullYear();
	            break;
	          case 'p':
	            c = isAM ? "" + "am" : "" + "pm";
	            break;
	          case 'P':
	            c = isAM ? "" + "AM" : "" + "PM";
	            break;
	          case 'w':
	            c = "" + d.getDay();
	            break;
	        }
	        r.push(c);
	        escape = false;
	      } else {
	        if (c == "%") {
	          escape = true;
	        } else {
	          r.push(c);
	        }
	      }
	    }
	    return r.join("");
	  }

	  // To have a consistent view of time-based data independent of which time
	  // zone the client happens to be in we need a date-like object independent
	  // of time zones.  This is done through a wrapper that only calls the UTC
	  // versions of the accessor methods.

	  function makeUtcWrapper(d) {
	    function addProxyMethod(sourceObj, sourceMethod, targetObj, targetMethod) {
	      sourceObj[sourceMethod] = function () {
	        return targetObj[targetMethod].apply(targetObj, arguments);
	      };
	    }
	    var utc = {
	      date: d
	    };

	    // support strftime, if found

	    if (d.strftime != undefined) {
	      addProxyMethod(utc, "strftime", d, "strftime");
	    }
	    addProxyMethod(utc, "getTime", d, "getTime");
	    addProxyMethod(utc, "setTime", d, "setTime");
	    var props = ["Date", "Day", "FullYear", "Hours", "Milliseconds", "Minutes", "Month", "Seconds"];
	    for (var p = 0; p < props.length; p++) {
	      addProxyMethod(utc, "get" + props[p], d, "getUTC" + props[p]);
	      addProxyMethod(utc, "set" + props[p], d, "setUTC" + props[p]);
	    }
	    return utc;
	  }

	  // select time zone strategy.  This returns a date-like object tied to the
	  // desired timezone

	  function dateGenerator(ts, opts) {
	    if (opts.timezone == "browser") {
	      return new Date(ts);
	    } else if (!opts.timezone || opts.timezone == "utc") {
	      return makeUtcWrapper(new Date(ts));
	    } else if (typeof timezoneJS != "undefined" && typeof timezoneJS.Date != "undefined") {
	      var d = new timezoneJS.Date();
	      // timezone-js is fickle, so be sure to set the time zone before
	      // setting the time.
	      d.setTimezone(opts.timezone);
	      d.setTime(ts);
	      return d;
	    } else {
	      return makeUtcWrapper(new Date(ts));
	    }
	  }

	  // map of app. size of time units in milliseconds

	  var timeUnitSize = {
	    "second": 1000,
	    "minute": 60 * 1000,
	    "hour": 60 * 60 * 1000,
	    "day": 24 * 60 * 60 * 1000,
	    "month": 30 * 24 * 60 * 60 * 1000,
	    "quarter": 3 * 30 * 24 * 60 * 60 * 1000,
	    "year": 365.2425 * 24 * 60 * 60 * 1000
	  };

	  // the allowed tick sizes, after 1 year we use
	  // an integer algorithm

	  var baseSpec = [[1, "second"], [2, "second"], [5, "second"], [10, "second"], [30, "second"], [1, "minute"], [2, "minute"], [5, "minute"], [10, "minute"], [30, "minute"], [1, "hour"], [2, "hour"], [4, "hour"], [8, "hour"], [12, "hour"], [1, "day"], [2, "day"], [3, "day"], [0.25, "month"], [0.5, "month"], [1, "month"], [2, "month"]];

	  // we don't know which variant(s) we'll need yet, but generating both is
	  // cheap

	  var specMonths = baseSpec.concat([[3, "month"], [6, "month"], [1, "year"]]);
	  var specQuarters = baseSpec.concat([[1, "quarter"], [2, "quarter"], [1, "year"]]);
	  function init(plot) {
	    plot.hooks.processOptions.push(function (plot, options) {
	      $.each(plot.getAxes(), function (axisName, axis) {
	        var opts = axis.options;
	        if (opts.mode == "time") {
	          axis.tickGenerator = function (axis) {
	            var ticks = [];
	            var d = dateGenerator(axis.min, opts);
	            var minSize = 0;

	            // make quarter use a possibility if quarters are
	            // mentioned in either of these options

	            var spec = opts.tickSize && opts.tickSize[1] === "quarter" || opts.minTickSize && opts.minTickSize[1] === "quarter" ? specQuarters : specMonths;
	            if (opts.minTickSize != null) {
	              if (typeof opts.tickSize == "number") {
	                minSize = opts.tickSize;
	              } else {
	                minSize = opts.minTickSize[0] * timeUnitSize[opts.minTickSize[1]];
	              }
	            }
	            for (var i = 0; i < spec.length - 1; ++i) {
	              if (axis.delta < (spec[i][0] * timeUnitSize[spec[i][1]] + spec[i + 1][0] * timeUnitSize[spec[i + 1][1]]) / 2 && spec[i][0] * timeUnitSize[spec[i][1]] >= minSize) {
	                break;
	              }
	            }
	            var size = spec[i][0];
	            var unit = spec[i][1];

	            // special-case the possibility of several years

	            if (unit == "year") {
	              // if given a minTickSize in years, just use it,
	              // ensuring that it's an integer

	              if (opts.minTickSize != null && opts.minTickSize[1] == "year") {
	                size = Math.floor(opts.minTickSize[0]);
	              } else {
	                var magn = Math.pow(10, Math.floor(Math.log(axis.delta / timeUnitSize.year) / Math.LN10));
	                var norm = axis.delta / timeUnitSize.year / magn;
	                if (norm < 1.5) {
	                  size = 1;
	                } else if (norm < 3) {
	                  size = 2;
	                } else if (norm < 7.5) {
	                  size = 5;
	                } else {
	                  size = 10;
	                }
	                size *= magn;
	              }

	              // minimum size for years is 1

	              if (size < 1) {
	                size = 1;
	              }
	            }
	            axis.tickSize = opts.tickSize || [size, unit];
	            var tickSize = axis.tickSize[0];
	            unit = axis.tickSize[1];
	            var step = tickSize * timeUnitSize[unit];
	            if (unit == "second") {
	              d.setSeconds(floorInBase(d.getSeconds(), tickSize));
	            } else if (unit == "minute") {
	              d.setMinutes(floorInBase(d.getMinutes(), tickSize));
	            } else if (unit == "hour") {
	              d.setHours(floorInBase(d.getHours(), tickSize));
	            } else if (unit == "month") {
	              d.setMonth(floorInBase(d.getMonth(), tickSize));
	            } else if (unit == "quarter") {
	              d.setMonth(3 * floorInBase(d.getMonth() / 3, tickSize));
	            } else if (unit == "year") {
	              d.setFullYear(floorInBase(d.getFullYear(), tickSize));
	            }

	            // reset smaller components

	            d.setMilliseconds(0);
	            if (step >= timeUnitSize.minute) {
	              d.setSeconds(0);
	            }
	            if (step >= timeUnitSize.hour) {
	              d.setMinutes(0);
	            }
	            if (step >= timeUnitSize.day) {
	              d.setHours(0);
	            }
	            if (step >= timeUnitSize.day * 4) {
	              d.setDate(1);
	            }
	            if (step >= timeUnitSize.month * 2) {
	              d.setMonth(floorInBase(d.getMonth(), 3));
	            }
	            if (step >= timeUnitSize.quarter * 2) {
	              d.setMonth(floorInBase(d.getMonth(), 6));
	            }
	            if (step >= timeUnitSize.year) {
	              d.setMonth(0);
	            }
	            var carry = 0;
	            var v = Number.NaN;
	            var prev;
	            do {
	              prev = v;
	              v = d.getTime();
	              ticks.push(v);
	              if (unit == "month" || unit == "quarter") {
	                if (tickSize < 1) {
	                  // a bit complicated - we'll divide the
	                  // month/quarter up but we need to take
	                  // care of fractions so we don't end up in
	                  // the middle of a day

	                  d.setDate(1);
	                  var start = d.getTime();
	                  d.setMonth(d.getMonth() + (unit == "quarter" ? 3 : 1));
	                  var end = d.getTime();
	                  d.setTime(v + carry * timeUnitSize.hour + (end - start) * tickSize);
	                  carry = d.getHours();
	                  d.setHours(0);
	                } else {
	                  d.setMonth(d.getMonth() + tickSize * (unit == "quarter" ? 3 : 1));
	                }
	              } else if (unit == "year") {
	                d.setFullYear(d.getFullYear() + tickSize);
	              } else {
	                d.setTime(v + step);
	              }
	            } while (v < axis.max && v != prev);
	            return ticks;
	          };
	          axis.tickFormatter = function (v, axis) {
	            var d = dateGenerator(v, axis.options);

	            // first check global format

	            if (opts.timeformat != null) {
	              return formatDate(d, opts.timeformat, opts.monthNames, opts.dayNames);
	            }

	            // possibly use quarters if quarters are mentioned in
	            // any of these places

	            var useQuarters = axis.options.tickSize && axis.options.tickSize[1] == "quarter" || axis.options.minTickSize && axis.options.minTickSize[1] == "quarter";
	            var t = axis.tickSize[0] * timeUnitSize[axis.tickSize[1]];
	            var span = axis.max - axis.min;
	            var suffix = opts.twelveHourClock ? " %p" : "";
	            var hourCode = opts.twelveHourClock ? "%I" : "%H";
	            var fmt;
	            if (t < timeUnitSize.minute) {
	              fmt = hourCode + ":%M:%S" + suffix;
	            } else if (t < timeUnitSize.day) {
	              if (span < 2 * timeUnitSize.day) {
	                fmt = hourCode + ":%M" + suffix;
	              } else {
	                fmt = "%b %d " + hourCode + ":%M" + suffix;
	              }
	            } else if (t < timeUnitSize.month) {
	              fmt = "%b %d";
	            } else if (useQuarters && t < timeUnitSize.quarter || !useQuarters && t < timeUnitSize.year) {
	              if (span < timeUnitSize.year) {
	                fmt = "%b";
	              } else {
	                fmt = "%b %Y";
	              }
	            } else if (useQuarters && t < timeUnitSize.year) {
	              if (span < timeUnitSize.year) {
	                fmt = "Q%q";
	              } else {
	                fmt = "Q%q %Y";
	              }
	            } else {
	              fmt = "%Y";
	            }
	            var rt = formatDate(d, fmt, opts.monthNames, opts.dayNames);
	            return rt;
	          };
	        }
	      });
	    });
	  }
	  $.plot.plugins.push({
	    init: init,
	    options: options,
	    name: 'time',
	    version: '1.0'
	  });

	  // Time-axis support used to be in Flot core, which exposed the
	  // formatDate function on the plot object.  Various plugins depend
	  // on the function, so we need to re-expose it here.

	  $.plot.formatDate = formatDate;
	  $.plot.dateGenerator = dateGenerator;
	})(jQuery);

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getAugmentedNamespace(n) {
	  if (n.__esModule) return n;
	  var f = n.default;
		if (typeof f == "function") {
			var a = function a () {
				if (this instanceof a) {
					var args = [null];
					args.push.apply(args, arguments);
					var Ctor = Function.bind.apply(f, args);
					return new Ctor();
				}
				return f.apply(this, arguments);
			};
			a.prototype = f.prototype;
	  } else a = {};
	  Object.defineProperty(a, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var jquery_form_minExports = {};
	var jquery_form_min = {
	  get exports(){ return jquery_form_minExports; },
	  set exports(v){ jquery_form_minExports = v; },
	};

	/*!
	 * jQuery Form Plugin
	 * version: 4.3.0
	 * Requires jQuery v1.7.2 or later
	 * Project repository: https://github.com/jquery-form/form

	 * Copyright 2017 Kevin Morris
	 * Copyright 2006 M. Alsup

	 * Dual licensed under the LGPL-2.1+ or MIT licenses
	 * https://github.com/jquery-form/form#license

	 * This library is free software; you can redistribute it and/or
	 * modify it under the terms of the GNU Lesser General Public
	 * License as published by the Free Software Foundation; either
	 * version 2.1 of the License, or (at your option) any later version.
	 * This library is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 * Lesser General Public License for more details.
	 */
	(function (module) {
	  !function (r) {
	    module.exports ? module.exports = function (e, t) {
	      return void 0 === t && (t = "undefined" != typeof window ? require$$0$1 : require$$0$1(e)), r(t), t;
	    } : r(jQuery);
	  }(function (q) {

	    var m = /\r?\n/g,
	      S = {};
	    S.fileapi = void 0 !== q('<input type="file">').get(0).files, S.formdata = void 0 !== window.FormData;
	    var _ = !!q.fn.prop;
	    function o(e) {
	      var t = e.data;
	      e.isDefaultPrevented() || (e.preventDefault(), q(e.target).closest("form").ajaxSubmit(t));
	    }
	    function i(e) {
	      var t = e.target,
	        r = q(t);
	      if (!r.is("[type=submit],[type=image]")) {
	        var a = r.closest("[type=submit]");
	        if (0 === a.length) return;
	        t = a[0];
	      }
	      var n,
	        o = t.form;
	      "image" === (o.clk = t).type && (void 0 !== e.offsetX ? (o.clk_x = e.offsetX, o.clk_y = e.offsetY) : "function" == typeof q.fn.offset ? (n = r.offset(), o.clk_x = e.pageX - n.left, o.clk_y = e.pageY - n.top) : (o.clk_x = e.pageX - t.offsetLeft, o.clk_y = e.pageY - t.offsetTop)), setTimeout(function () {
	        o.clk = o.clk_x = o.clk_y = null;
	      }, 100);
	    }
	    function N() {
	      var e;
	      q.fn.ajaxSubmit.debug && (e = "[jquery.form] " + Array.prototype.join.call(arguments, ""), window.console && window.console.log ? window.console.log(e) : window.opera && window.opera.postError && window.opera.postError(e));
	    }
	    q.fn.attr2 = function () {
	      if (!_) return this.attr.apply(this, arguments);
	      var e = this.prop.apply(this, arguments);
	      return e && e.jquery || "string" == typeof e ? e : this.attr.apply(this, arguments);
	    }, q.fn.ajaxSubmit = function (M, e, t, r) {
	      if (!this.length) return N("ajaxSubmit: skipping submit process - no element selected"), this;
	      var O,
	        a,
	        n,
	        o,
	        X = this;
	      "function" == typeof M ? M = {
	        success: M
	      } : "string" == typeof M || !1 === M && 0 < arguments.length ? (M = {
	        url: M,
	        data: e,
	        dataType: t
	      }, "function" == typeof r && (M.success = r)) : void 0 === M && (M = {}), O = M.method || M.type || this.attr2("method"), n = (n = (n = "string" == typeof (a = M.url || this.attr2("action")) ? q.trim(a) : "") || window.location.href || "") && (n.match(/^([^#]+)/) || [])[1], o = /(MSIE|Trident)/.test(navigator.userAgent || "") && /^https/i.test(window.location.href || "") ? "javascript:false" : "about:blank", M = q.extend(!0, {
	        url: n,
	        success: q.ajaxSettings.success,
	        type: O || q.ajaxSettings.type,
	        iframeSrc: o
	      }, M);
	      var i = {};
	      if (this.trigger("form-pre-serialize", [this, M, i]), i.veto) return N("ajaxSubmit: submit vetoed via form-pre-serialize trigger"), this;
	      if (M.beforeSerialize && !1 === M.beforeSerialize(this, M)) return N("ajaxSubmit: submit aborted via beforeSerialize callback"), this;
	      var s = M.traditional;
	      void 0 === s && (s = q.ajaxSettings.traditional);
	      var u,
	        c,
	        C = [],
	        l = this.formToArray(M.semantic, C, M.filtering);
	      if (M.data && (c = q.isFunction(M.data) ? M.data(l) : M.data, M.extraData = c, u = q.param(c, s)), M.beforeSubmit && !1 === M.beforeSubmit(l, this, M)) return N("ajaxSubmit: submit aborted via beforeSubmit callback"), this;
	      if (this.trigger("form-submit-validate", [l, this, M, i]), i.veto) return N("ajaxSubmit: submit vetoed via form-submit-validate trigger"), this;
	      var f = q.param(l, s);
	      u && (f = f ? f + "&" + u : u), "GET" === M.type.toUpperCase() ? (M.url += (0 <= M.url.indexOf("?") ? "&" : "?") + f, M.data = null) : M.data = f;
	      var d,
	        m,
	        p,
	        h = [];
	      M.resetForm && h.push(function () {
	        X.resetForm();
	      }), M.clearForm && h.push(function () {
	        X.clearForm(M.includeHidden);
	      }), !M.dataType && M.target ? (d = M.success || function () {}, h.push(function (e, t, r) {
	        var a = arguments,
	          n = M.replaceTarget ? "replaceWith" : "html";
	        q(M.target)[n](e).each(function () {
	          d.apply(this, a);
	        });
	      })) : M.success && (q.isArray(M.success) ? q.merge(h, M.success) : h.push(M.success)), M.success = function (e, t, r) {
	        for (var a = M.context || this, n = 0, o = h.length; n < o; n++) h[n].apply(a, [e, t, r || X, X]);
	      }, M.error && (m = M.error, M.error = function (e, t, r) {
	        var a = M.context || this;
	        m.apply(a, [e, t, r, X]);
	      }), M.complete && (p = M.complete, M.complete = function (e, t) {
	        var r = M.context || this;
	        p.apply(r, [e, t, X]);
	      });
	      var v = 0 < q("input[type=file]:enabled", this).filter(function () {
	          return "" !== q(this).val();
	        }).length,
	        g = "multipart/form-data",
	        x = X.attr("enctype") === g || X.attr("encoding") === g,
	        y = S.fileapi && S.formdata;
	      N("fileAPI :" + y);
	      var b,
	        T = (v || x) && !y;
	      !1 !== M.iframe && (M.iframe || T) ? M.closeKeepAlive ? q.get(M.closeKeepAlive, function () {
	        b = w(l);
	      }) : b = w(l) : b = (v || x) && y ? function (e) {
	        for (var r = new FormData(), t = 0; t < e.length; t++) r.append(e[t].name, e[t].value);
	        if (M.extraData) {
	          var a = function (e) {
	            var t,
	              r,
	              a = q.param(e, M.traditional).split("&"),
	              n = a.length,
	              o = [];
	            for (t = 0; t < n; t++) a[t] = a[t].replace(/\+/g, " "), r = a[t].split("="), o.push([decodeURIComponent(r[0]), decodeURIComponent(r[1])]);
	            return o;
	          }(M.extraData);
	          for (t = 0; t < a.length; t++) a[t] && r.append(a[t][0], a[t][1]);
	        }
	        M.data = null;
	        var n = q.extend(!0, {}, q.ajaxSettings, M, {
	          contentType: !1,
	          processData: !1,
	          cache: !1,
	          type: O || "POST"
	        });
	        M.uploadProgress && (n.xhr = function () {
	          var e = q.ajaxSettings.xhr();
	          return e.upload && e.upload.addEventListener("progress", function (e) {
	            var t = 0,
	              r = e.loaded || e.position,
	              a = e.total;
	            e.lengthComputable && (t = Math.ceil(r / a * 100)), M.uploadProgress(e, r, a, t);
	          }, !1), e;
	        });
	        n.data = null;
	        var o = n.beforeSend;
	        return n.beforeSend = function (e, t) {
	          M.formData ? t.data = M.formData : t.data = r, o && o.call(this, e, t);
	        }, q.ajax(n);
	      }(l) : q.ajax(M), X.removeData("jqxhr").data("jqxhr", b);
	      for (var j = 0; j < C.length; j++) C[j] = null;
	      return this.trigger("form-submit-notify", [this, M]), this;
	      function w(e) {
	        var t,
	          r,
	          l,
	          f,
	          o,
	          d,
	          m,
	          p,
	          a,
	          n,
	          h,
	          v,
	          i = X[0],
	          g = q.Deferred();
	        if (g.abort = function (e) {
	          p.abort(e);
	        }, e) for (r = 0; r < C.length; r++) t = q(C[r]), _ ? t.prop("disabled", !1) : t.removeAttr("disabled");
	        (l = q.extend(!0, {}, q.ajaxSettings, M)).context = l.context || l, o = "jqFormIO" + new Date().getTime();
	        var s = i.ownerDocument,
	          u = X.closest("body");
	        if (l.iframeTarget ? (n = (d = q(l.iframeTarget, s)).attr2("name")) ? o = n : d.attr2("name", o) : (d = q('<iframe name="' + o + '" src="' + l.iframeSrc + '" />', s)).css({
	          position: "absolute",
	          top: "-1000px",
	          left: "-1000px"
	        }), m = d[0], p = {
	          aborted: 0,
	          responseText: null,
	          responseXML: null,
	          status: 0,
	          statusText: "n/a",
	          getAllResponseHeaders: function () {},
	          getResponseHeader: function () {},
	          setRequestHeader: function () {},
	          abort: function (e) {
	            var t = "timeout" === e ? "timeout" : "aborted";
	            N("aborting upload... " + t), this.aborted = 1;
	            try {
	              m.contentWindow.document.execCommand && m.contentWindow.document.execCommand("Stop");
	            } catch (e) {}
	            d.attr("src", l.iframeSrc), p.error = t, l.error && l.error.call(l.context, p, t, e), f && q.event.trigger("ajaxError", [p, l, t]), l.complete && l.complete.call(l.context, p, t);
	          }
	        }, (f = l.global) && 0 == q.active++ && q.event.trigger("ajaxStart"), f && q.event.trigger("ajaxSend", [p, l]), l.beforeSend && !1 === l.beforeSend.call(l.context, p, l)) return l.global && q.active--, g.reject(), g;
	        if (p.aborted) return g.reject(), g;
	        (a = i.clk) && (n = a.name) && !a.disabled && (l.extraData = l.extraData || {}, l.extraData[n] = a.value, "image" === a.type && (l.extraData[n + ".x"] = i.clk_x, l.extraData[n + ".y"] = i.clk_y));
	        var x = 1,
	          y = 2;
	        function b(t) {
	          var r = null;
	          try {
	            t.contentWindow && (r = t.contentWindow.document);
	          } catch (e) {
	            N("cannot get iframe.contentWindow document: " + e);
	          }
	          if (r) return r;
	          try {
	            r = t.contentDocument ? t.contentDocument : t.document;
	          } catch (e) {
	            N("cannot get iframe.contentDocument: " + e), r = t.document;
	          }
	          return r;
	        }
	        var c = q("meta[name=csrf-token]").attr("content"),
	          T = q("meta[name=csrf-param]").attr("content");
	        function j() {
	          var e = X.attr2("target"),
	            t = X.attr2("action"),
	            r = X.attr("enctype") || X.attr("encoding") || "multipart/form-data";
	          i.setAttribute("target", o), O && !/post/i.test(O) || i.setAttribute("method", "POST"), t !== l.url && i.setAttribute("action", l.url), l.skipEncodingOverride || O && !/post/i.test(O) || X.attr({
	            encoding: "multipart/form-data",
	            enctype: "multipart/form-data"
	          }), l.timeout && (v = setTimeout(function () {
	            h = !0, A(x);
	          }, l.timeout));
	          var a = [];
	          try {
	            if (l.extraData) for (var n in l.extraData) l.extraData.hasOwnProperty(n) && (q.isPlainObject(l.extraData[n]) && l.extraData[n].hasOwnProperty("name") && l.extraData[n].hasOwnProperty("value") ? a.push(q('<input type="hidden" name="' + l.extraData[n].name + '">', s).val(l.extraData[n].value).appendTo(i)[0]) : a.push(q('<input type="hidden" name="' + n + '">', s).val(l.extraData[n]).appendTo(i)[0]));
	            l.iframeTarget || d.appendTo(u), m.attachEvent ? m.attachEvent("onload", A) : m.addEventListener("load", A, !1), setTimeout(function e() {
	              try {
	                var t = b(m).readyState;
	                N("state = " + t), t && "uninitialized" === t.toLowerCase() && setTimeout(e, 50);
	              } catch (e) {
	                N("Server abort: ", e, " (", e.name, ")"), A(y), v && clearTimeout(v), v = void 0;
	              }
	            }, 15);
	            try {
	              i.submit();
	            } catch (e) {
	              document.createElement("form").submit.apply(i);
	            }
	          } finally {
	            i.setAttribute("action", t), i.setAttribute("enctype", r), e ? i.setAttribute("target", e) : X.removeAttr("target"), q(a).remove();
	          }
	        }
	        T && c && (l.extraData = l.extraData || {}, l.extraData[T] = c), l.forceSync ? j() : setTimeout(j, 10);
	        var w,
	          S,
	          k,
	          D = 50;
	        function A(e) {
	          if (!p.aborted && !k) {
	            if ((S = b(m)) || (N("cannot access response document"), e = y), e === x && p) return p.abort("timeout"), void g.reject(p, "timeout");
	            if (e === y && p) return p.abort("server abort"), void g.reject(p, "error", "server abort");
	            if (S && S.location.href !== l.iframeSrc || h) {
	              m.detachEvent ? m.detachEvent("onload", A) : m.removeEventListener("load", A, !1);
	              var t,
	                r = "success";
	              try {
	                if (h) throw "timeout";
	                var a = "xml" === l.dataType || S.XMLDocument || q.isXMLDoc(S);
	                if (N("isXml=" + a), !a && window.opera && (null === S.body || !S.body.innerHTML) && --D) return N("requeing onLoad callback, DOM not available"), void setTimeout(A, 250);
	                var n = S.body ? S.body : S.documentElement;
	                p.responseText = n ? n.innerHTML : null, p.responseXML = S.XMLDocument ? S.XMLDocument : S, a && (l.dataType = "xml"), p.getResponseHeader = function (e) {
	                  return {
	                    "content-type": l.dataType
	                  }[e.toLowerCase()];
	                }, n && (p.status = Number(n.getAttribute("status")) || p.status, p.statusText = n.getAttribute("statusText") || p.statusText);
	                var o,
	                  i,
	                  s,
	                  u = (l.dataType || "").toLowerCase(),
	                  c = /(json|script|text)/.test(u);
	                c || l.textarea ? (o = S.getElementsByTagName("textarea")[0]) ? (p.responseText = o.value, p.status = Number(o.getAttribute("status")) || p.status, p.statusText = o.getAttribute("statusText") || p.statusText) : c && (i = S.getElementsByTagName("pre")[0], s = S.getElementsByTagName("body")[0], i ? p.responseText = i.textContent ? i.textContent : i.innerText : s && (p.responseText = s.textContent ? s.textContent : s.innerText)) : "xml" === u && !p.responseXML && p.responseText && (p.responseXML = F(p.responseText));
	                try {
	                  w = E(p, u, l);
	                } catch (e) {
	                  r = "parsererror", p.error = t = e || r;
	                }
	              } catch (e) {
	                N("error caught: ", e), r = "error", p.error = t = e || r;
	              }
	              p.aborted && (N("upload aborted"), r = null), p.status && (r = 200 <= p.status && p.status < 300 || 304 === p.status ? "success" : "error"), "success" === r ? (l.success && l.success.call(l.context, w, "success", p), g.resolve(p.responseText, "success", p), f && q.event.trigger("ajaxSuccess", [p, l])) : r && (void 0 === t && (t = p.statusText), l.error && l.error.call(l.context, p, r, t), g.reject(p, "error", t), f && q.event.trigger("ajaxError", [p, l, t])), f && q.event.trigger("ajaxComplete", [p, l]), f && ! --q.active && q.event.trigger("ajaxStop"), l.complete && l.complete.call(l.context, p, r), k = !0, l.timeout && clearTimeout(v), setTimeout(function () {
	                l.iframeTarget ? d.attr("src", l.iframeSrc) : d.remove(), p.responseXML = null;
	              }, 100);
	            }
	          }
	        }
	        var F = q.parseXML || function (e, t) {
	            return window.ActiveXObject ? ((t = new ActiveXObject("Microsoft.XMLDOM")).async = "false", t.loadXML(e)) : t = new DOMParser().parseFromString(e, "text/xml"), t && t.documentElement && "parsererror" !== t.documentElement.nodeName ? t : null;
	          },
	          L = q.parseJSON || function (e) {
	            return window.eval("(" + e + ")");
	          },
	          E = function (e, t, r) {
	            var a = e.getResponseHeader("content-type") || "",
	              n = ("xml" === t || !t) && 0 <= a.indexOf("xml"),
	              o = n ? e.responseXML : e.responseText;
	            return n && "parsererror" === o.documentElement.nodeName && q.error && q.error("parsererror"), r && r.dataFilter && (o = r.dataFilter(o, t)), "string" == typeof o && (("json" === t || !t) && 0 <= a.indexOf("json") ? o = L(o) : ("script" === t || !t) && 0 <= a.indexOf("javascript") && q.globalEval(o)), o;
	          };
	        return g;
	      }
	    }, q.fn.ajaxForm = function (e, t, r, a) {
	      if (("string" == typeof e || !1 === e && 0 < arguments.length) && (e = {
	        url: e,
	        data: t,
	        dataType: r
	      }, "function" == typeof a && (e.success = a)), (e = e || {}).delegation = e.delegation && q.isFunction(q.fn.on), e.delegation || 0 !== this.length) return e.delegation ? (q(document).off("submit.form-plugin", this.selector, o).off("click.form-plugin", this.selector, i).on("submit.form-plugin", this.selector, e, o).on("click.form-plugin", this.selector, e, i), this) : (e.beforeFormUnbind && e.beforeFormUnbind(this, e), this.ajaxFormUnbind().on("submit.form-plugin", e, o).on("click.form-plugin", e, i));
	      var n = {
	        s: this.selector,
	        c: this.context
	      };
	      return !q.isReady && n.s ? (N("DOM not ready, queuing ajaxForm"), q(function () {
	        q(n.s, n.c).ajaxForm(e);
	      })) : N("terminating; zero elements found by selector" + (q.isReady ? "" : " (DOM not ready)")), this;
	    }, q.fn.ajaxFormUnbind = function () {
	      return this.off("submit.form-plugin click.form-plugin");
	    }, q.fn.formToArray = function (e, t, r) {
	      var a = [];
	      if (0 === this.length) return a;
	      var n,
	        o,
	        i,
	        s,
	        u,
	        c,
	        l,
	        f,
	        d,
	        m,
	        p = this[0],
	        h = this.attr("id"),
	        v = (v = e || void 0 === p.elements ? p.getElementsByTagName("*") : p.elements) && q.makeArray(v);
	      if (h && (e || /(Edge|Trident)\//.test(navigator.userAgent)) && (n = q(':input[form="' + h + '"]').get()).length && (v = (v || []).concat(n)), !v || !v.length) return a;
	      for (q.isFunction(r) && (v = q.map(v, r)), o = 0, c = v.length; o < c; o++) if ((m = (u = v[o]).name) && !u.disabled) if (e && p.clk && "image" === u.type) p.clk === u && (a.push({
	        name: m,
	        value: q(u).val(),
	        type: u.type
	      }), a.push({
	        name: m + ".x",
	        value: p.clk_x
	      }, {
	        name: m + ".y",
	        value: p.clk_y
	      }));else if ((s = q.fieldValue(u, !0)) && s.constructor === Array) for (t && t.push(u), i = 0, l = s.length; i < l; i++) a.push({
	        name: m,
	        value: s[i]
	      });else if (S.fileapi && "file" === u.type) {
	        t && t.push(u);
	        var g = u.files;
	        if (g.length) for (i = 0; i < g.length; i++) a.push({
	          name: m,
	          value: g[i],
	          type: u.type
	        });else a.push({
	          name: m,
	          value: "",
	          type: u.type
	        });
	      } else null != s && (t && t.push(u), a.push({
	        name: m,
	        value: s,
	        type: u.type,
	        required: u.required
	      }));
	      return e || !p.clk || (m = (d = (f = q(p.clk))[0]).name) && !d.disabled && "image" === d.type && (a.push({
	        name: m,
	        value: f.val()
	      }), a.push({
	        name: m + ".x",
	        value: p.clk_x
	      }, {
	        name: m + ".y",
	        value: p.clk_y
	      })), a;
	    }, q.fn.formSerialize = function (e) {
	      return q.param(this.formToArray(e));
	    }, q.fn.fieldSerialize = function (n) {
	      var o = [];
	      return this.each(function () {
	        var e = this.name;
	        if (e) {
	          var t = q.fieldValue(this, n);
	          if (t && t.constructor === Array) for (var r = 0, a = t.length; r < a; r++) o.push({
	            name: e,
	            value: t[r]
	          });else null != t && o.push({
	            name: this.name,
	            value: t
	          });
	        }
	      }), q.param(o);
	    }, q.fn.fieldValue = function (e) {
	      for (var t = [], r = 0, a = this.length; r < a; r++) {
	        var n = this[r],
	          o = q.fieldValue(n, e);
	        null == o || o.constructor === Array && !o.length || (o.constructor === Array ? q.merge(t, o) : t.push(o));
	      }
	      return t;
	    }, q.fieldValue = function (e, t) {
	      var r = e.name,
	        a = e.type,
	        n = e.tagName.toLowerCase();
	      if (void 0 === t && (t = !0), t && (!r || e.disabled || "reset" === a || "button" === a || ("checkbox" === a || "radio" === a) && !e.checked || ("submit" === a || "image" === a) && e.form && e.form.clk !== e || "select" === n && -1 === e.selectedIndex)) return null;
	      if ("select" !== n) return q(e).val().replace(m, "\r\n");
	      var o = e.selectedIndex;
	      if (o < 0) return null;
	      for (var i = [], s = e.options, u = "select-one" === a, c = u ? o + 1 : s.length, l = u ? o : 0; l < c; l++) {
	        var f = s[l];
	        if (f.selected && !f.disabled) {
	          var d = (d = f.value) || (f.attributes && f.attributes.value && !f.attributes.value.specified ? f.text : f.value);
	          if (u) return d;
	          i.push(d);
	        }
	      }
	      return i;
	    }, q.fn.clearForm = function (e) {
	      return this.each(function () {
	        q("input,select,textarea", this).clearFields(e);
	      });
	    }, q.fn.clearFields = q.fn.clearInputs = function (r) {
	      var a = /^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;
	      return this.each(function () {
	        var e = this.type,
	          t = this.tagName.toLowerCase();
	        a.test(e) || "textarea" === t ? this.value = "" : "checkbox" === e || "radio" === e ? this.checked = !1 : "select" === t ? this.selectedIndex = -1 : "file" === e ? /MSIE/.test(navigator.userAgent) ? q(this).replaceWith(q(this).clone(!0)) : q(this).val("") : r && (!0 === r && /hidden/.test(e) || "string" == typeof r && q(this).is(r)) && (this.value = "");
	      });
	    }, q.fn.resetForm = function () {
	      return this.each(function () {
	        var t = q(this),
	          e = this.tagName.toLowerCase();
	        switch (e) {
	          case "input":
	            this.checked = this.defaultChecked;
	          case "textarea":
	            return this.value = this.defaultValue, !0;
	          case "option":
	          case "optgroup":
	            var r = t.parents("select");
	            return r.length && r[0].multiple ? "option" === e ? this.selected = this.defaultSelected : t.find("option").resetForm() : r.resetForm(), !0;
	          case "select":
	            return t.find("option").each(function (e) {
	              if (this.selected = this.defaultSelected, this.defaultSelected && !t[0].multiple) return t[0].selectedIndex = e, !1;
	            }), !0;
	          case "label":
	            var a = q(t.attr("for")),
	              n = t.find("input,select,textarea");
	            return a[0] && n.unshift(a[0]), n.resetForm(), !0;
	          case "form":
	            return "function" != typeof this.reset && ("object" != typeof this.reset || this.reset.nodeType) || this.reset(), !0;
	          default:
	            return t.find("form,input,label,select,textarea").resetForm(), !0;
	        }
	      });
	    }, q.fn.enable = function (e) {
	      return void 0 === e && (e = !0), this.each(function () {
	        this.disabled = !e;
	      });
	    }, q.fn.selected = function (r) {
	      return void 0 === r && (r = !0), this.each(function () {
	        var e,
	          t = this.type;
	        "checkbox" === t || "radio" === t ? this.checked = r : "option" === this.tagName.toLowerCase() && (e = q(this).parent("select"), r && e[0] && "select-one" === e[0].type && e.find("option").selected(!1), this.selected = r);
	      });
	    }, q.fn.ajaxSubmit.debug = !1;
	  });
	})(jquery_form_min);
	const setupJQueryForm = jquery_form_minExports;

	/*!
	 * jQuery Cookie Plugin v1.4.1
	 * https://github.com/carhartl/jquery-cookie
	 *
	 * Copyright 2013 Klaus Hartl
	 * Released under the MIT license
	 */
	(function (exports) {
	  (function (factory) {
	    {
	      // CommonJS
	      factory(require$$0$1);
	    }
	  })(function ($) {
	    var pluses = /\+/g;
	    function encode(s) {
	      return config.raw ? s : encodeURIComponent(s);
	    }
	    function decode(s) {
	      return config.raw ? s : decodeURIComponent(s);
	    }
	    function stringifyCookieValue(value) {
	      return encode(config.json ? JSON.stringify(value) : String(value));
	    }
	    function parseCookieValue(s) {
	      if (s.indexOf('"') === 0) {
	        // This is a quoted cookie as according to RFC2068, unescape...
	        s = s.slice(1, -1).replace(/\\"/g, '"').replace(/\\\\/g, '\\');
	      }
	      try {
	        // Replace server-side written pluses with spaces.
	        // If we can't decode the cookie, ignore it, it's unusable.
	        // If we can't parse the cookie, ignore it, it's unusable.
	        s = decodeURIComponent(s.replace(pluses, ' '));
	        return config.json ? JSON.parse(s) : s;
	      } catch (e) {}
	    }
	    function read(s, converter) {
	      var value = config.raw ? s : parseCookieValue(s);
	      return $.isFunction(converter) ? converter(value) : value;
	    }
	    var config = $.cookie = function (key, value, options) {
	      // Write

	      if (value !== undefined && !$.isFunction(value)) {
	        options = $.extend({}, config.defaults, options);
	        if (typeof options.expires === 'number') {
	          var days = options.expires,
	            t = options.expires = new Date();
	          t.setTime(+t + days * 864e+5);
	        }
	        return document.cookie = [encode(key), '=', stringifyCookieValue(value), options.expires ? '; expires=' + options.expires.toUTCString() : '',
	        // use expires attribute, max-age is not supported by IE
	        options.path ? '; path=' + options.path : '', options.domain ? '; domain=' + options.domain : '', options.secure ? '; secure' : ''].join('');
	      }

	      // Read

	      var result = key ? undefined : {};

	      // To prevent the for loop in the first place assign an empty array
	      // in case there are no cookies at all. Also prevents odd result when
	      // calling $.cookie().
	      var cookies = document.cookie ? document.cookie.split('; ') : [];
	      for (var i = 0, l = cookies.length; i < l; i++) {
	        var parts = cookies[i].split('=');
	        var name = decode(parts.shift());
	        var cookie = parts.join('=');
	        if (key && key === name) {
	          // If second argument (value) is a function it's a converter...
	          result = read(cookie, value);
	          break;
	        }

	        // Prevent storing a cookie that we couldn't decode.
	        if (!key && (cookie = read(cookie)) !== undefined) {
	          result[name] = cookie;
	        }
	      }
	      return result;
	    };
	    config.defaults = {};
	    $.removeCookie = function (key, options) {
	      if ($.cookie(key) === undefined) {
	        return false;
	      }

	      // Must not alter options, thus extending a fresh object...
	      $.cookie(key, '', $.extend({}, options, {
	        expires: -1
	      }));
	      return !$.cookie(key);
	    };
	  });
	})();

	/**
	 * timesince is a live-updating implementation of Django's timesince filter
	 * in jQuery.
	 *
	 * This will automatically keep the timestamps updated as the page
	 * is opened, instead of showing the time as it was when the page was rendered.
	 * This is a better user experience, and also helps with caching (both
	 * browser and server-side).
	 *
	 * This is based both on Django's timesince filter
	 * (http://www.djangoproject.com/), and parts of Ryan McGeary's timeago
	 * jQuery plugin (http://timeago.yarp.com/).
	 *
	 * See https://github.com/chipx86/jquery-timesince for the latest.
	 *
	 * @name timesince
	 * @version 0.1
	 * @requires jQuery v1.2.3+
	 * @author Christian Hammond
	 * @license MIT License - http://www.opensource.org/licenses/mit-license.php
	 *
	 * Copyright (c) 2012, Christian Hammond (chipx86@chipx86.com)
	 */
	(function ($) {
	  $.timesince = function (timestamp) {
	    if (timestamp instanceof Date) {
	      return timeSince(timestamp);
	    } else if (typeof timestamp === 'string') {
	      return timeSince($.timesince.parse(timestamp));
	    } else if (typeof timestamp === 'number') {
	      return timeSince(new Date(timestamp));
	    } else {
	      // It's an element.
	      return timeSince($.timesince.datetime($(timestamp)));
	    }
	  };
	  $.extend($.timesince, {
	    options: {
	      refreshMs: 60 * 1000,
	      // 1 minute
	      strings: {
	        prefixAgo: null,
	        prefixFromNow: null,
	        suffixAgo: "ago",
	        suffixFromNow: "from now",
	        minute: "minute",
	        minutes: "minutes",
	        hour: "hour",
	        hours: "hours",
	        day: "day",
	        days: "days",
	        week: "week",
	        weeks: "weeks",
	        month: "month",
	        months: "months",
	        year: "year",
	        years: "years"
	      }
	    },
	    chunks: [[60 * 60 * 24 * 365, "year", "years"], [60 * 60 * 24 * 30, "month", "months"], [60 * 60 * 24 * 7, "week", "weeks"], [60 * 60 * 24, "day", "days"], [60 * 60, "hour", "hours"], [60, "minute", "minutes"]],
	    timeSince: function (deltaMs) {
	      var strings = this.options.strings,
	        seconds = Math.abs(deltaMs) / 1000,
	        prefix,
	        suffix,
	        i;
	      if (deltaMs < 0) {
	        prefix = strings.prefixFromNow;
	        suffix = strings.suffixFromNow;
	      } else {
	        prefix = strings.prefixAgo;
	        suffix = strings.suffixAgo;
	      }
	      prefix = prefix ? prefix + " " : "";
	      suffix = suffix ? " " + suffix : "";
	      if (seconds < 60) {
	        return prefix + "0 " + strings.minutes + suffix;
	      }
	      for (i = 0; i < this.chunks.length; i++) {
	        var chunk = this.chunks[i],
	          chunkSecs = chunk[0],
	          count = Math.floor(seconds / chunkSecs);
	        if (count != 0) {
	          var s = prefix + this.getChunkText(chunk, count);
	          if (i + 1 < this.chunks.length) {
	            // Get the second item.
	            var chunk2 = this.chunks[i + 1],
	              count2 = Math.floor((seconds - chunkSecs * count) / chunk2[0]);
	            if (count2 != 0) {
	              s += ", " + this.getChunkText(chunk2, count2);
	            }
	          }
	          return s + suffix;
	        }
	      }

	      // We shouldn't have reached here.
	      return '';
	    },
	    getChunkText: function (chunk, n) {
	      var type = n === 1 ? chunk[1] : chunk[2];
	      return n + " " + this.options.strings[type];
	    },
	    parse: function (iso8601) {
	      var s = $.trim(iso8601);
	      s = s.replace(/\.\d\d\d+/, ""); // remove milliseconds
	      s = s.replace(/-/, "/").replace(/-/, "/");
	      s = s.replace(/T/, " ").replace(/Z/, " UTC");
	      s = s.replace(/([\+\-]\d\d)\:?(\d\d)/, " $1$2"); // -04:00 -> -0400
	      return new Date(s);
	    },
	    datetime: function (el) {
	      var iso8601 = this.isTime(el) ? el.attr("datetime") : el.attr("title");
	      return this.parse(iso8601);
	    },
	    isTime: function (el) {
	      // jQuery's `is()` doesn't play well with HTML5 in IE
	      return el[0].tagName.toLowerCase() === "time";
	    }
	  });
	  $.fn.timesince = function (options) {
	    var self = this,
	      timerCnx,
	      refreshMs;
	    options = $.extend(options, $.timesince.options);
	    refreshMs = options.refreshMs;
	    if (refreshMs > 0) {
	      timerCnx = setInterval(function () {
	        self.each(function () {
	          refresh($(this), timerCnx);
	        });
	      }, refreshMs);
	    }
	    return this.each(function () {
	      var el = $(this),
	        text = $.trim(el.text());
	      el.data('timesince', {
	        datetime: $.timesince.datetime(el)
	      });
	      if (text.length > 0 && (!$.timesince.isTime(el) || !el.attr("title"))) {
	        el.attr("title", text);
	      }
	      refresh(el);
	    });
	  };
	  function refresh(el, timerCnx) {
	    var data = el.data('timesince');
	    if (data) {
	      el.text($.timesince.timeSince(new Date().getTime() - data.datetime.getTime()));
	    } else {
	      clearInterval(timerCnx);
	    }
	    return el;
	  }

	  // IE6 doesn't understand the <time> tag, so create it.
	  document.createElement("time");
	})(jQuery);

	/*
	 * jQuery UI Autocomplete @VERSION
	 *
	 * Copyright (c) 2007, 2008 Dylan Verheul, Dan G. Switzer, Anjesh Tuladhar, Jörn Zaefferer
	 * Dual licensed under the MIT (MIT-LICENSE.txt)
	 * and GPL (GPL-LICENSE.txt) licenses.
	 * 
	 * http://docs.jquery.com/UI/Autocomplete
	 *
	 * Depends:
	 *    ui.core.js
	 */
	(function ($) {
	  $.widget("ui.rbautocomplete", {
	    options: {
	      inputClass: "ui-autocomplete-input",
	      resultsClass: "ui-autocomplete-results",
	      loadingClass: "ui-autocomplete-loading",
	      resultsParentEl: document.body,
	      minChars: 1,
	      ajaxDelay: 400,
	      localDelay: 10,
	      matchCase: false,
	      matchSubset: true,
	      matchContains: false,
	      cacheLength: 10,
	      scrollMax: 150,
	      noScrollMax: 10,
	      mustMatch: false,
	      extraParams: {},
	      selectFirst: true,
	      formatItem: function (row) {
	        return row[0];
	      },
	      formatMatch: null,
	      autoFill: false,
	      width: 0,
	      multiple: false,
	      multipleSeparator: ", ",
	      highlight: function (value, term) {
	        return value.replace(new RegExp("(?![^&;]+;)(?!<[^<>]*)(" + term.replace(/([\^\$\(\)\[\]\{\}\*\.\+\?\|\\])/gi, "\\$1") + ")(?![^<>]*>)(?![^&;]+;)", "gi"), "<strong>$1</strong>");
	      },
	      scroll: true,
	      clickToURL: false,
	      enterToURL: false,
	      scrollHeight: 180
	    },
	    _init: function () {
	      $.extend(this.options, {
	        delay: this.options.delay != undefined ? this.options.delay : this.options.url ? this.options.ajaxDelay : this.options.localDelay,
	        max: this.options.max != undefined ? this.options.max : this.options.scroll ? this.options.scrollMax : this.options.noScrollMax,
	        highlight: this.options.highlight || function (value) {
	          return value;
	        },
	        // if highlight is set to false, replace it with a do-nothing function
	        formatMatch: this.options.formatMatch || this.options.formatItem // if the formatMatch option is not specified, then use formatItem for backwards compatibility
	      });
	      var input = this.element[0],
	        options = this.options,
	        // Create $ object for input element
	        $input = $(input).attr("autocomplete", "off").addClass(options.inputClass),
	        KEY = $.ui.keyCode,
	        previousValue = "",
	        cache = $.ui.rbautocomplete.cache(options),
	        hasFocus = 0,
	        config = {
	          mouseDownOnSelect: false
	        },
	        timeout,
	        lastKeyPressCode,
	        select = $.ui.rbautocomplete.select(options, input, selectCurrent, config);
	      if (options.result) {
	        $input.bind('result.rbautocomplete', options.result);
	      }
	      $input.bind('keydown.rbautocomplete', function (event) {
	        // track last key pressed
	        lastKeyPressCode = event.keyCode;
	        switch (event.keyCode) {
	          case KEY.UP:
	            event.preventDefault();
	            if (select.visible()) {
	              select.prev();
	            } else {
	              onChange(0, true);
	            }
	            break;
	          case KEY.DOWN:
	            event.preventDefault();
	            if (select.visible()) {
	              select.next();
	            } else {
	              onChange(0, true);
	            }
	            break;
	          case KEY.PAGE_UP:
	            event.preventDefault();
	            if (select.visible()) {
	              select.pageUp();
	            } else {
	              onChange(0, true);
	            }
	            break;
	          case KEY.PAGE_DOWN:
	            event.preventDefault();
	            if (select.visible()) {
	              select.pageDown();
	            } else {
	              onChange(0, true);
	            }
	            break;

	          // matches also semicolon
	          case options.multiple && $.trim(options.multipleSeparator) == "," && KEY.COMMA:
	          case KEY.TAB:
	          case KEY.ENTER:
	            if (options.enterToURL && select.current()) {
	              select.current().click();
	            }
	            if (selectCurrent()) {
	              // stop default to prevent a form submit, Opera needs special handling
	              event.preventDefault();
	              return false;
	            }
	            break;
	          case KEY.ESCAPE:
	            select.hide();
	            break;
	          default:
	            clearTimeout(timeout);
	            timeout = setTimeout(onChange, options.delay);
	            break;
	        }
	      }).focus(function () {
	        // track whether the field has focus, we shouldn't process any
	        // results if the field no longer has focus
	        hasFocus++;
	      }).blur(function () {
	        hasFocus = 0;
	        if (!config.mouseDownOnSelect) {
	          hideResults();
	        }
	      }).click(function () {
	        // show select when clicking in a focused field
	        if (hasFocus++ > 1 && !select.visible()) {
	          onChange(0, true);
	        }
	      }).bind("search", function () {
	        // TODO why not just specifying both arguments?
	        var fn = arguments.length > 1 ? arguments[1] : null;
	        function findValueCallback(q, data) {
	          var result;
	          if (data && data.length) {
	            for (var i = 0; i < data.length; i++) {
	              if (data[i].result.toLowerCase() == q.toLowerCase()) {
	                result = data[i];
	                break;
	              }
	            }
	          }
	          if (typeof fn == "function") fn(result);else $input.trigger("result", result && [result.data, result.value]);
	        }
	        $.each(trimWords($input.val()), function (i, value) {
	          request(value, findValueCallback, findValueCallback);
	        });
	      }).bind("flushCache", function () {
	        cache.flush();
	      }).bind("setOptions", function () {
	        $.extend(options, arguments[1]);
	        // if we've updated the data, repopulate
	        if ("data" in arguments[1]) cache.populate();
	      }).bind("unautocomplete", function () {
	        select.unbind();
	        $input.unbind();
	        $(input.form).unbind(".rbautocomplete");
	      });

	      // Private methods
	      function selectCurrent() {
	        var selected = select.selected();
	        if (!selected || !matchCurrent(selected)) return false;
	        var v = selected.result;
	        previousValue = v;
	        if (options.multiple) {
	          var words = trimWords($input.val());
	          if (words.length > 1) {
	            v = words.slice(0, words.length - 1).join(options.multipleSeparator) + options.multipleSeparator + v;
	          }
	          v += options.multipleSeparator;
	        }
	        $input.val(v);
	        hideResultsNow();
	        $input.trigger("result", [selected.data, selected.value]);
	        return true;
	      }

	      // Check if the current user input matches the currently selected item.
	      function matchCurrent(selected) {
	        var toMatch = [selected.result];
	        if (selected.data.display_name) toMatch.push(selected.data.display_name);else if (selected.data.fullname) toMatch = toMatch.concat([selected.data.first_name, selected.data.last_name]);
	        var currentValue = lastWord($input.val());
	        var matched = false;
	        for (let i = 0; i < toMatch.length && !matched; i++) {
	          var match = toMatch[i];
	          if (!options.matchCase) {
	            match = match.toLowerCase();
	            currentValue = currentValue.toLowerCase();
	          }
	          if (options.matchContains) matched = match.indexOf(currentValue) >= 0;else
	            // check if prefix
	            matched = match.indexOf(currentValue) === 0;
	        }
	        return matched;
	      }
	      function onChange(crap, skipPrevCheck) {
	        var currentValue = $input.val();
	        if (!skipPrevCheck && currentValue == previousValue) return;
	        previousValue = currentValue;
	        currentValue = lastWord(currentValue);
	        if (currentValue.length >= options.minChars) {
	          $input.addClass(options.loadingClass);
	          if (!options.matchCase) currentValue = currentValue.toLowerCase();
	          request(currentValue, receiveData, hideResultsNow);
	        } else {
	          stopLoading();
	          select.hide();
	        }
	      }
	      function trimWords(value) {
	        if (!value) {
	          return [""];
	        }
	        if (!options.multiple) {
	          return [value];
	        }
	        var words = value.split(options.multipleSeparator);
	        var result = [];
	        $.each(words, function (i, value) {
	          result[i] = $.trim(value);
	        });
	        return result;
	      }
	      function lastWord(value) {
	        var words = trimWords(value);
	        return words[words.length - 1];
	      }

	      // fills in the input box w/the first match (assumed to be the best match)
	      // q: the term entered
	      // sValue: the first matching result
	      function autoFill(q, sValue) {
	        // autofill in the complete box w/the first match as long as the user hasn't entered in more data
	        // if the last user key pressed was backspace, don't autofill
	        if (options.autoFill && lastWord($input.val()).toLowerCase() == q.toLowerCase() && lastKeyPressCode != $.ui.keyCode.BACKSPACE) {
	          // fill in the value (keep the case the user has typed)
	          $input.val($input.val() + sValue.substring(lastWord(previousValue).length));
	          // select the portion of the value not typed by the user (so the next character will erase)
	          $.ui.rbautocomplete.selection(input, previousValue.length, previousValue.length + sValue.length);
	        }
	      }
	      function hideResults() {
	        clearTimeout(timeout);
	        timeout = setTimeout(hideResultsNow, 200);
	      }
	      function hideResultsNow() {
	        var wasVisible = select.visible();
	        select.hide();
	        clearTimeout(timeout);
	        stopLoading();
	        if (options.mustMatch) {
	          // call search and run callback
	          $input.rbautocomplete("search", function (result) {
	            // if no value found, clear the input box
	            if (!result) {
	              if (options.multiple) {
	                var words = trimWords($input.val()).slice(0, -1);
	                $input.val(words.join(options.multipleSeparator) + (words.length ? options.multipleSeparator : ""));
	              } else $input.val("");
	            }
	          });
	        }
	        if (wasVisible)
	          // position cursor at end of input field
	          $.ui.rbautocomplete.selection(input, input.value.length, input.value.length);
	      }
	      function receiveData(q, data) {
	        if (data && data.length && hasFocus) {
	          stopLoading();
	          select.display(data, q);
	          autoFill(q, data[0].value);
	          select.show();
	        } else {
	          hideResultsNow();
	        }
	      }
	      function request(term, success, failure) {
	        if (!options.matchCase) term = term.toLowerCase();
	        var data = cache.load(term);
	        // recieve the cached data
	        if (data && data.length) {
	          success(term, data);
	          // if an AJAX url has been supplied, try loading the data now
	        } else if (typeof options.url == "string" && options.url.length > 0) {
	          var extraParams = {
	            timestamp: +new Date()
	          };
	          $.each(options.extraParams, function (key, param) {
	            extraParams[key] = typeof param == "function" ? param(term) : param;
	          });
	          $.ajax({
	            // try to leverage ajaxQueue plugin to abort previous requests
	            mode: "abort",
	            // limit abortion to this input
	            port: "autocomplete" + input.name,
	            dataType: options.dataType,
	            url: options.url,
	            data: $.extend({
	              q: lastWord(term),
	              limit: options.max
	            }, extraParams),
	            success: function (data) {
	              var parsed = options.parse && options.parse(data) || parse(data);
	              cache.add(term, parsed);
	              success(term, parsed);
	            },
	            error: function (xhr, textStatus, errorThrown) {
	              if (options.error) {
	                options.error(xhr, textStatus, errorThrown);
	              }
	            }
	          });
	        } else if (options.source && typeof options.source == 'function') {
	          var resultData = options.source(term);
	          var parsed = options.parse ? options.parse(resultData) : resultData;
	          cache.add(term, parsed);
	          success(term, parsed);
	        } else {
	          // if we have a failure, we need to empty the list -- this prevents the the [TAB] key from selecting the last successful match
	          select.emptyList();
	          failure(term);
	        }
	      }
	      function parse(data) {
	        var parsed = [];
	        var rows = data.split("\n");
	        for (var i = 0; i < rows.length; i++) {
	          var row = $.trim(rows[i]);
	          if (row) {
	            row = row.split("|");
	            parsed[parsed.length] = {
	              data: row,
	              value: row[0],
	              result: options.formatResult && options.formatResult(row, row[0]) || row[0]
	            };
	          }
	        }
	        return parsed;
	      }
	      function stopLoading() {
	        $input.removeClass(options.loadingClass);
	      }
	    },
	    _propagate: function (n, event) {
	      $.ui.plugin.call(this, n, [event, this.ui()]);
	      return this.element.triggerHandler(n == 'autocomplete' ? n : 'autocomplete' + n, [event, this.ui()], this.options[n]);
	    },
	    // Public methods
	    ui: function (event) {
	      return {
	        options: this.options,
	        element: this.element
	      };
	    },
	    result: function (handler) {
	      return this.element.bind("result", handler);
	    },
	    search: function (handler) {
	      return this.element.trigger("search", [handler]);
	    },
	    flushCache: function () {
	      return this.element.trigger("flushCache");
	    },
	    setData: function (key, value) {
	      return this.element.trigger("setOptions", [{
	        key: value
	      }]);
	    },
	    destroy: function () {
	      this.element.removeAttr('disabled').removeClass('ui-autocomplete-input');
	      return this.element.trigger("unautocomplete");
	    },
	    enable: function () {
	      this.element.removeAttr('disabled').removeClass('ui-autocomplete-disabled');
	      this.disabled = false;
	    },
	    disable: function () {
	      this.element.attr('disabled', true).addClass('ui-autocomplete-disabled');
	      this.disabled = true;
	    }
	  });
	  $.ui.rbautocomplete.cache = function (options) {
	    var data = {};
	    var length = 0;
	    function matchSubset(s, sub) {
	      if (!options.matchCase) s = s.toLowerCase();
	      var i = s.indexOf(sub);
	      if (i == -1) return false;
	      return i == 0 || options.matchContains;
	    }
	    function add(q, value) {
	      if (length > options.cacheLength) {
	        flush();
	      }
	      if (!data[q]) {
	        length++;
	      }
	      data[q] = value;
	    }
	    function populate() {
	      if (!options.data) return false;
	      // track the matches
	      var stMatchSets = {},
	        nullData = 0;

	      // no url was specified, we need to adjust the cache length to make sure it fits the local data store
	      if (!options.url) options.cacheLength = 1;

	      // track all options for minChars = 0
	      stMatchSets[""] = [];

	      // loop through the array and create a lookup structure
	      for (var i = 0, ol = options.data.length; i < ol; i++) {
	        var rawValue = options.data[i];
	        // if rawValue is a string, make an array otherwise just reference the array
	        rawValue = typeof rawValue == "string" ? [rawValue] : rawValue;
	        var value = options.formatMatch(rawValue, i + 1, options.data.length);
	        if (value === false) continue;
	        var firstChar = value.charAt(0).toLowerCase();
	        // if no lookup array for this character exists, look it up now
	        if (!stMatchSets[firstChar]) stMatchSets[firstChar] = [];

	        // if the match is a string
	        var row = {
	          value: value,
	          data: rawValue,
	          result: options.formatResult && options.formatResult(rawValue) || value
	        };

	        // push the current match into the set list
	        stMatchSets[firstChar].push(row);

	        // keep track of minChars zero items
	        if (nullData++ < options.max) {
	          stMatchSets[""].push(row);
	        }
	      }

	      // add the data items to the cache
	      $.each(stMatchSets, function (i, value) {
	        // increase the cache size
	        options.cacheLength++;
	        // add to the cache
	        add(i, value);
	      });
	    }

	    // populate any existing data
	    setTimeout(populate, 25);
	    function flush() {
	      data = {};
	      length = 0;
	    }
	    return {
	      flush: flush,
	      add: add,
	      populate: populate,
	      load: function (q) {
	        if (!options.cacheLength || !length) return null;
	        /* 
	         * if dealing w/local data and matchContains than we must make sure
	         * to loop through all the data collections looking for matches
	         */
	        if (!options.url && options.matchContains) {
	          // track all matches
	          var csub = [];
	          // loop through all the data grids for matches
	          for (var k in data) {
	            // don't search through the stMatchSets[""] (minChars: 0) cache
	            // this prevents duplicates
	            if (k.length > 0) {
	              var c = data[k];
	              $.each(c, function (i, x) {
	                // if we've got a match, add it to the array
	                if (matchSubset(x.value, q)) {
	                  csub.push(x);
	                }
	              });
	            }
	          }
	          return csub;
	        } else
	          // if the exact item exists, use it
	          if (data[q]) {
	            return data[q];
	          } else if (options.matchSubset) {
	            for (var i = q.length - 1; i >= options.minChars; i--) {
	              var c = data[q.substr(0, i)];
	              if (c) {
	                var csub = [];
	                $.each(c, function (i, x) {
	                  if (matchSubset(x.value, q)) {
	                    csub[csub.length] = x;
	                  }
	                });
	                return csub;
	              }
	            }
	          }
	        return null;
	      }
	    };
	  };
	  $.ui.rbautocomplete.select = function (options, input, select, config) {
	    var CLASSES = {
	      ACTIVE: "ui-autocomplete-over"
	    };
	    var listItems,
	      active = -1,
	      data,
	      term = "",
	      needsInit = true,
	      element,
	      list;

	    // Create results
	    function init() {
	      if (!needsInit) return;
	      element = $("<div/>").hide().addClass(options.resultsClass).css("position", "absolute").appendTo(options.resultsParentEl);
	      list = $("<ul/>").appendTo(element).mouseover(function (event) {
	        if (target(event).nodeName && target(event).nodeName.toUpperCase() == 'LI') {
	          active = $("li", list).removeClass(CLASSES.ACTIVE).index(target(event));
	          $(target(event)).addClass(CLASSES.ACTIVE);
	        }
	      }).click(function (event) {
	        $(target(event)).addClass(CLASSES.ACTIVE);
	        select();
	        // TODO provide option to avoid setting focus again after selection? useful for cleanup-on-focus
	        input.focus();
	        return false;
	      }).mousedown(function () {
	        config.mouseDownOnSelect = true;
	      }).mouseup(function () {
	        config.mouseDownOnSelect = false;
	      });
	      if (options.width > 0) element.css("width", options.width);
	      needsInit = false;
	    }
	    function target(event) {
	      var element = event.target;
	      while (element && element.tagName != "LI") element = element.parentNode;
	      // more fun with IE, sometimes event.target is empty, just ignore it then
	      if (!element) return [];
	      return element;
	    }
	    function moveSelect(step) {
	      listItems.slice(active, active + 1).removeClass(CLASSES.ACTIVE);
	      movePosition(step);
	      var activeItem = listItems.slice(active, active + 1).addClass(CLASSES.ACTIVE);
	      if (options.scroll) {
	        var offset = 0;
	        listItems.slice(0, active).each(function () {
	          offset += this.offsetHeight;
	        });
	        if (offset + activeItem[0].offsetHeight - list.scrollTop() > list[0].clientHeight) {
	          list.scrollTop(offset + activeItem[0].offsetHeight - list.innerHeight());
	        } else if (offset < list.scrollTop()) {
	          list.scrollTop(offset);
	        }
	      }
	    }
	    function movePosition(step) {
	      active += step;
	      if (active < 0) {
	        active = listItems.size() - 1;
	      } else if (active >= listItems.size()) {
	        active = 0;
	      }
	    }
	    function limitNumberOfItems(available) {
	      return options.max && options.max < available ? options.max : available;
	    }
	    function makeItem(data) {
	      if (options.clickToURL === false) {
	        return $("<li/>");
	      } else {
	        // For Quick Search
	        return $("<li/>").click(function () {
	          window.open(data["url"]);
	        });
	      }
	    }
	    function fillList() {
	      if (options.cmp !== undefined) {
	        data.sort(function (a, b) {
	          return options.cmp(term, a, b);
	        });
	      }
	      list.empty();
	      var max = limitNumberOfItems(data.length);
	      for (var i = 0; i < max; i++) {
	        if (!data[i]) continue;
	        var formatted = options.formatItem(data[i].data, i + 1, max, data[i].value, term);
	        if (formatted === false) continue;
	        var li = makeItem(data[i].data).html(options.highlight(formatted, term)).addClass(i % 2 == 0 ? "ui-autocomplete-even" : "ui-autocomplete-odd").appendTo(list)[0];
	        $.data(li, "ui-autocomplete-data", data[i]);
	      }
	      listItems = list.find("li");
	      if (options.selectFirst) {
	        listItems.slice(0, 1).addClass(CLASSES.ACTIVE);
	        active = 0;
	      }
	      // apply bgiframe if available
	      if ($.fn.bgiframe) list.bgiframe();
	    }
	    return {
	      display: function (d, q) {
	        init();
	        data = d;
	        term = q;
	        fillList();
	      },
	      next: function () {
	        moveSelect(1);
	      },
	      prev: function () {
	        moveSelect(-1);
	      },
	      pageUp: function () {
	        if (active != 0 && active - 8 < 0) {
	          moveSelect(-active);
	        } else {
	          moveSelect(-8);
	        }
	      },
	      pageDown: function () {
	        if (active != listItems.size() - 1 && active + 8 > listItems.size()) {
	          moveSelect(listItems.size() - 1 - active);
	        } else {
	          moveSelect(8);
	        }
	      },
	      hide: function () {
	        element && element.hide();
	        listItems && listItems.removeClass(CLASSES.ACTIVE);
	        active = -1;
	        $(input).triggerHandler("autocompletehide", [{}, {
	          options: options
	        }], options["hide"]);
	      },
	      visible: function () {
	        return element && element.is(":visible");
	      },
	      current: function () {
	        return this.visible() && (listItems.filter("." + CLASSES.ACTIVE)[0] || options.selectFirst && listItems[0]);
	      },
	      show: function () {
	        var $input = $(input),
	          $window = $(window),
	          $document = $(document),
	          offset = $input.offset(),
	          inputWidth = input.offsetWidth,
	          inputHeight = input.offsetHeight,
	          windowRight,
	          windowBottom,
	          width,
	          height;
	        if (options.scroll) {
	          list.scrollTop(0);
	          list.css({
	            maxHeight: options.scrollHeight,
	            overflow: 'auto'
	          });
	        }
	        $(input).triggerHandler("autocompleteshow", [{}, {
	          options: options
	        }], options["show"]);
	        width = typeof options.width === "string" || options.width > 0 ? options.width : inputWidth;
	        height = element.outerHeight(true);
	        windowBottom = $window.height() + $document.scrollTop();
	        windowRight = $window.width() + $document.scrollLeft();
	        element.css({
	          width: width,
	          top: offset.top + inputHeight + height > windowBottom ? offset.top - height : offset.top + inputHeight,
	          left: offset.left + width > windowRight ? offset.left + inputWidth - width : offset.left
	        }).show();
	      },
	      selected: function () {
	        var selected = listItems && listItems.filter("." + CLASSES.ACTIVE).removeClass(CLASSES.ACTIVE);
	        return selected && selected.length && $.data(selected[0], "ui-autocomplete-data");
	      },
	      emptyList: function () {
	        list && list.empty();
	      },
	      unbind: function () {
	        element && element.remove();
	      }
	    };
	  };
	  $.ui.rbautocomplete.selection = function (field, start, end) {
	    if (field.createTextRange) {
	      var selRange = field.createTextRange();
	      selRange.collapse(true);
	      selRange.moveStart("character", start);
	      selRange.moveEnd("character", end);
	      selRange.select();
	    } else if (field.setSelectionRange) {
	      field.setSelectionRange(start, end);
	    } else {
	      if (field.selectionStart) {
	        field.selectionStart = start;
	        field.selectionEnd = end;
	      }
	    }
	    field.focus();
	  };
	})(jQuery);

	function commonjsRequire(path) {
		throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
	}

	var momentExports = {};
	var moment$1 = {
	  get exports(){ return momentExports; },
	  set exports(v){ momentExports = v; },
	};

	(function (module, exports) {
	  (function (global, factory) {
	    module.exports = factory() ;
	  })(commonjsGlobal, function () {

	    var hookCallback;
	    function hooks() {
	      return hookCallback.apply(null, arguments);
	    }

	    // This is done to register the method called with moment()
	    // without creating circular dependencies.
	    function setHookCallback(callback) {
	      hookCallback = callback;
	    }
	    function isArray(input) {
	      return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
	    }
	    function isObject(input) {
	      // IE8 will treat undefined and null as object if it wasn't for
	      // input != null
	      return input != null && Object.prototype.toString.call(input) === '[object Object]';
	    }
	    function hasOwnProp(a, b) {
	      return Object.prototype.hasOwnProperty.call(a, b);
	    }
	    function isObjectEmpty(obj) {
	      if (Object.getOwnPropertyNames) {
	        return Object.getOwnPropertyNames(obj).length === 0;
	      } else {
	        var k;
	        for (k in obj) {
	          if (hasOwnProp(obj, k)) {
	            return false;
	          }
	        }
	        return true;
	      }
	    }
	    function isUndefined(input) {
	      return input === void 0;
	    }
	    function isNumber(input) {
	      return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
	    }
	    function isDate(input) {
	      return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
	    }
	    function map(arr, fn) {
	      var res = [],
	        i,
	        arrLen = arr.length;
	      for (i = 0; i < arrLen; ++i) {
	        res.push(fn(arr[i], i));
	      }
	      return res;
	    }
	    function extend(a, b) {
	      for (var i in b) {
	        if (hasOwnProp(b, i)) {
	          a[i] = b[i];
	        }
	      }
	      if (hasOwnProp(b, 'toString')) {
	        a.toString = b.toString;
	      }
	      if (hasOwnProp(b, 'valueOf')) {
	        a.valueOf = b.valueOf;
	      }
	      return a;
	    }
	    function createUTC(input, format, locale, strict) {
	      return createLocalOrUTC(input, format, locale, strict, true).utc();
	    }
	    function defaultParsingFlags() {
	      // We need to deep clone this object.
	      return {
	        empty: false,
	        unusedTokens: [],
	        unusedInput: [],
	        overflow: -2,
	        charsLeftOver: 0,
	        nullInput: false,
	        invalidEra: null,
	        invalidMonth: null,
	        invalidFormat: false,
	        userInvalidated: false,
	        iso: false,
	        parsedDateParts: [],
	        era: null,
	        meridiem: null,
	        rfc2822: false,
	        weekdayMismatch: false
	      };
	    }
	    function getParsingFlags(m) {
	      if (m._pf == null) {
	        m._pf = defaultParsingFlags();
	      }
	      return m._pf;
	    }
	    var some;
	    if (Array.prototype.some) {
	      some = Array.prototype.some;
	    } else {
	      some = function (fun) {
	        var t = Object(this),
	          len = t.length >>> 0,
	          i;
	        for (i = 0; i < len; i++) {
	          if (i in t && fun.call(this, t[i], i, t)) {
	            return true;
	          }
	        }
	        return false;
	      };
	    }
	    function isValid(m) {
	      if (m._isValid == null) {
	        var flags = getParsingFlags(m),
	          parsedParts = some.call(flags.parsedDateParts, function (i) {
	            return i != null;
	          }),
	          isNowValid = !isNaN(m._d.getTime()) && flags.overflow < 0 && !flags.empty && !flags.invalidEra && !flags.invalidMonth && !flags.invalidWeekday && !flags.weekdayMismatch && !flags.nullInput && !flags.invalidFormat && !flags.userInvalidated && (!flags.meridiem || flags.meridiem && parsedParts);
	        if (m._strict) {
	          isNowValid = isNowValid && flags.charsLeftOver === 0 && flags.unusedTokens.length === 0 && flags.bigHour === undefined;
	        }
	        if (Object.isFrozen == null || !Object.isFrozen(m)) {
	          m._isValid = isNowValid;
	        } else {
	          return isNowValid;
	        }
	      }
	      return m._isValid;
	    }
	    function createInvalid(flags) {
	      var m = createUTC(NaN);
	      if (flags != null) {
	        extend(getParsingFlags(m), flags);
	      } else {
	        getParsingFlags(m).userInvalidated = true;
	      }
	      return m;
	    }

	    // Plugins that add properties should also add the key here (null value),
	    // so we can properly clone ourselves.
	    var momentProperties = hooks.momentProperties = [],
	      updateInProgress = false;
	    function copyConfig(to, from) {
	      var i,
	        prop,
	        val,
	        momentPropertiesLen = momentProperties.length;
	      if (!isUndefined(from._isAMomentObject)) {
	        to._isAMomentObject = from._isAMomentObject;
	      }
	      if (!isUndefined(from._i)) {
	        to._i = from._i;
	      }
	      if (!isUndefined(from._f)) {
	        to._f = from._f;
	      }
	      if (!isUndefined(from._l)) {
	        to._l = from._l;
	      }
	      if (!isUndefined(from._strict)) {
	        to._strict = from._strict;
	      }
	      if (!isUndefined(from._tzm)) {
	        to._tzm = from._tzm;
	      }
	      if (!isUndefined(from._isUTC)) {
	        to._isUTC = from._isUTC;
	      }
	      if (!isUndefined(from._offset)) {
	        to._offset = from._offset;
	      }
	      if (!isUndefined(from._pf)) {
	        to._pf = getParsingFlags(from);
	      }
	      if (!isUndefined(from._locale)) {
	        to._locale = from._locale;
	      }
	      if (momentPropertiesLen > 0) {
	        for (i = 0; i < momentPropertiesLen; i++) {
	          prop = momentProperties[i];
	          val = from[prop];
	          if (!isUndefined(val)) {
	            to[prop] = val;
	          }
	        }
	      }
	      return to;
	    }

	    // Moment prototype object
	    function Moment(config) {
	      copyConfig(this, config);
	      this._d = new Date(config._d != null ? config._d.getTime() : NaN);
	      if (!this.isValid()) {
	        this._d = new Date(NaN);
	      }
	      // Prevent infinite loop in case updateOffset creates new moment
	      // objects.
	      if (updateInProgress === false) {
	        updateInProgress = true;
	        hooks.updateOffset(this);
	        updateInProgress = false;
	      }
	    }
	    function isMoment(obj) {
	      return obj instanceof Moment || obj != null && obj._isAMomentObject != null;
	    }
	    function warn(msg) {
	      if (hooks.suppressDeprecationWarnings === false && typeof console !== 'undefined' && console.warn) {
	        console.warn('Deprecation warning: ' + msg);
	      }
	    }
	    function deprecate(msg, fn) {
	      var firstTime = true;
	      return extend(function () {
	        if (hooks.deprecationHandler != null) {
	          hooks.deprecationHandler(null, msg);
	        }
	        if (firstTime) {
	          var args = [],
	            arg,
	            i,
	            key,
	            argLen = arguments.length;
	          for (i = 0; i < argLen; i++) {
	            arg = '';
	            if (typeof arguments[i] === 'object') {
	              arg += '\n[' + i + '] ';
	              for (key in arguments[0]) {
	                if (hasOwnProp(arguments[0], key)) {
	                  arg += key + ': ' + arguments[0][key] + ', ';
	                }
	              }
	              arg = arg.slice(0, -2); // Remove trailing comma and space
	            } else {
	              arg = arguments[i];
	            }
	            args.push(arg);
	          }
	          warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + new Error().stack);
	          firstTime = false;
	        }
	        return fn.apply(this, arguments);
	      }, fn);
	    }
	    var deprecations = {};
	    function deprecateSimple(name, msg) {
	      if (hooks.deprecationHandler != null) {
	        hooks.deprecationHandler(name, msg);
	      }
	      if (!deprecations[name]) {
	        warn(msg);
	        deprecations[name] = true;
	      }
	    }
	    hooks.suppressDeprecationWarnings = false;
	    hooks.deprecationHandler = null;
	    function isFunction(input) {
	      return typeof Function !== 'undefined' && input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
	    }
	    function set(config) {
	      var prop, i;
	      for (i in config) {
	        if (hasOwnProp(config, i)) {
	          prop = config[i];
	          if (isFunction(prop)) {
	            this[i] = prop;
	          } else {
	            this['_' + i] = prop;
	          }
	        }
	      }
	      this._config = config;
	      // Lenient ordinal parsing accepts just a number in addition to
	      // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
	      // TODO: Remove "ordinalParse" fallback in next major release.
	      this._dayOfMonthOrdinalParseLenient = new RegExp((this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) + '|' + /\d{1,2}/.source);
	    }
	    function mergeConfigs(parentConfig, childConfig) {
	      var res = extend({}, parentConfig),
	        prop;
	      for (prop in childConfig) {
	        if (hasOwnProp(childConfig, prop)) {
	          if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
	            res[prop] = {};
	            extend(res[prop], parentConfig[prop]);
	            extend(res[prop], childConfig[prop]);
	          } else if (childConfig[prop] != null) {
	            res[prop] = childConfig[prop];
	          } else {
	            delete res[prop];
	          }
	        }
	      }
	      for (prop in parentConfig) {
	        if (hasOwnProp(parentConfig, prop) && !hasOwnProp(childConfig, prop) && isObject(parentConfig[prop])) {
	          // make sure changes to properties don't modify parent config
	          res[prop] = extend({}, res[prop]);
	        }
	      }
	      return res;
	    }
	    function Locale(config) {
	      if (config != null) {
	        this.set(config);
	      }
	    }
	    var keys;
	    if (Object.keys) {
	      keys = Object.keys;
	    } else {
	      keys = function (obj) {
	        var i,
	          res = [];
	        for (i in obj) {
	          if (hasOwnProp(obj, i)) {
	            res.push(i);
	          }
	        }
	        return res;
	      };
	    }
	    var defaultCalendar = {
	      sameDay: '[Today at] LT',
	      nextDay: '[Tomorrow at] LT',
	      nextWeek: 'dddd [at] LT',
	      lastDay: '[Yesterday at] LT',
	      lastWeek: '[Last] dddd [at] LT',
	      sameElse: 'L'
	    };
	    function calendar(key, mom, now) {
	      var output = this._calendar[key] || this._calendar['sameElse'];
	      return isFunction(output) ? output.call(mom, now) : output;
	    }
	    function zeroFill(number, targetLength, forceSign) {
	      var absNumber = '' + Math.abs(number),
	        zerosToFill = targetLength - absNumber.length,
	        sign = number >= 0;
	      return (sign ? forceSign ? '+' : '' : '-') + Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
	    }
	    var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,
	      localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,
	      formatFunctions = {},
	      formatTokenFunctions = {};

	    // token:    'M'
	    // padded:   ['MM', 2]
	    // ordinal:  'Mo'
	    // callback: function () { this.month() + 1 }
	    function addFormatToken(token, padded, ordinal, callback) {
	      var func = callback;
	      if (typeof callback === 'string') {
	        func = function () {
	          return this[callback]();
	        };
	      }
	      if (token) {
	        formatTokenFunctions[token] = func;
	      }
	      if (padded) {
	        formatTokenFunctions[padded[0]] = function () {
	          return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
	        };
	      }
	      if (ordinal) {
	        formatTokenFunctions[ordinal] = function () {
	          return this.localeData().ordinal(func.apply(this, arguments), token);
	        };
	      }
	    }
	    function removeFormattingTokens(input) {
	      if (input.match(/\[[\s\S]/)) {
	        return input.replace(/^\[|\]$/g, '');
	      }
	      return input.replace(/\\/g, '');
	    }
	    function makeFormatFunction(format) {
	      var array = format.match(formattingTokens),
	        i,
	        length;
	      for (i = 0, length = array.length; i < length; i++) {
	        if (formatTokenFunctions[array[i]]) {
	          array[i] = formatTokenFunctions[array[i]];
	        } else {
	          array[i] = removeFormattingTokens(array[i]);
	        }
	      }
	      return function (mom) {
	        var output = '',
	          i;
	        for (i = 0; i < length; i++) {
	          output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];
	        }
	        return output;
	      };
	    }

	    // format date using native date object
	    function formatMoment(m, format) {
	      if (!m.isValid()) {
	        return m.localeData().invalidDate();
	      }
	      format = expandFormat(format, m.localeData());
	      formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);
	      return formatFunctions[format](m);
	    }
	    function expandFormat(format, locale) {
	      var i = 5;
	      function replaceLongDateFormatTokens(input) {
	        return locale.longDateFormat(input) || input;
	      }
	      localFormattingTokens.lastIndex = 0;
	      while (i >= 0 && localFormattingTokens.test(format)) {
	        format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
	        localFormattingTokens.lastIndex = 0;
	        i -= 1;
	      }
	      return format;
	    }
	    var defaultLongDateFormat = {
	      LTS: 'h:mm:ss A',
	      LT: 'h:mm A',
	      L: 'MM/DD/YYYY',
	      LL: 'MMMM D, YYYY',
	      LLL: 'MMMM D, YYYY h:mm A',
	      LLLL: 'dddd, MMMM D, YYYY h:mm A'
	    };
	    function longDateFormat(key) {
	      var format = this._longDateFormat[key],
	        formatUpper = this._longDateFormat[key.toUpperCase()];
	      if (format || !formatUpper) {
	        return format;
	      }
	      this._longDateFormat[key] = formatUpper.match(formattingTokens).map(function (tok) {
	        if (tok === 'MMMM' || tok === 'MM' || tok === 'DD' || tok === 'dddd') {
	          return tok.slice(1);
	        }
	        return tok;
	      }).join('');
	      return this._longDateFormat[key];
	    }
	    var defaultInvalidDate = 'Invalid date';
	    function invalidDate() {
	      return this._invalidDate;
	    }
	    var defaultOrdinal = '%d',
	      defaultDayOfMonthOrdinalParse = /\d{1,2}/;
	    function ordinal(number) {
	      return this._ordinal.replace('%d', number);
	    }
	    var defaultRelativeTime = {
	      future: 'in %s',
	      past: '%s ago',
	      s: 'a few seconds',
	      ss: '%d seconds',
	      m: 'a minute',
	      mm: '%d minutes',
	      h: 'an hour',
	      hh: '%d hours',
	      d: 'a day',
	      dd: '%d days',
	      w: 'a week',
	      ww: '%d weeks',
	      M: 'a month',
	      MM: '%d months',
	      y: 'a year',
	      yy: '%d years'
	    };
	    function relativeTime(number, withoutSuffix, string, isFuture) {
	      var output = this._relativeTime[string];
	      return isFunction(output) ? output(number, withoutSuffix, string, isFuture) : output.replace(/%d/i, number);
	    }
	    function pastFuture(diff, output) {
	      var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
	      return isFunction(format) ? format(output) : format.replace(/%s/i, output);
	    }
	    var aliases = {};
	    function addUnitAlias(unit, shorthand) {
	      var lowerCase = unit.toLowerCase();
	      aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
	    }
	    function normalizeUnits(units) {
	      return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
	    }
	    function normalizeObjectUnits(inputObject) {
	      var normalizedInput = {},
	        normalizedProp,
	        prop;
	      for (prop in inputObject) {
	        if (hasOwnProp(inputObject, prop)) {
	          normalizedProp = normalizeUnits(prop);
	          if (normalizedProp) {
	            normalizedInput[normalizedProp] = inputObject[prop];
	          }
	        }
	      }
	      return normalizedInput;
	    }
	    var priorities = {};
	    function addUnitPriority(unit, priority) {
	      priorities[unit] = priority;
	    }
	    function getPrioritizedUnits(unitsObj) {
	      var units = [],
	        u;
	      for (u in unitsObj) {
	        if (hasOwnProp(unitsObj, u)) {
	          units.push({
	            unit: u,
	            priority: priorities[u]
	          });
	        }
	      }
	      units.sort(function (a, b) {
	        return a.priority - b.priority;
	      });
	      return units;
	    }
	    function isLeapYear(year) {
	      return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
	    }
	    function absFloor(number) {
	      if (number < 0) {
	        // -0 -> 0
	        return Math.ceil(number) || 0;
	      } else {
	        return Math.floor(number);
	      }
	    }
	    function toInt(argumentForCoercion) {
	      var coercedNumber = +argumentForCoercion,
	        value = 0;
	      if (coercedNumber !== 0 && isFinite(coercedNumber)) {
	        value = absFloor(coercedNumber);
	      }
	      return value;
	    }
	    function makeGetSet(unit, keepTime) {
	      return function (value) {
	        if (value != null) {
	          set$1(this, unit, value);
	          hooks.updateOffset(this, keepTime);
	          return this;
	        } else {
	          return get(this, unit);
	        }
	      };
	    }
	    function get(mom, unit) {
	      return mom.isValid() ? mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
	    }
	    function set$1(mom, unit, value) {
	      if (mom.isValid() && !isNaN(value)) {
	        if (unit === 'FullYear' && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
	          value = toInt(value);
	          mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value, mom.month(), daysInMonth(value, mom.month()));
	        } else {
	          mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
	        }
	      }
	    }

	    // MOMENTS

	    function stringGet(units) {
	      units = normalizeUnits(units);
	      if (isFunction(this[units])) {
	        return this[units]();
	      }
	      return this;
	    }
	    function stringSet(units, value) {
	      if (typeof units === 'object') {
	        units = normalizeObjectUnits(units);
	        var prioritized = getPrioritizedUnits(units),
	          i,
	          prioritizedLen = prioritized.length;
	        for (i = 0; i < prioritizedLen; i++) {
	          this[prioritized[i].unit](units[prioritized[i].unit]);
	        }
	      } else {
	        units = normalizeUnits(units);
	        if (isFunction(this[units])) {
	          return this[units](value);
	        }
	      }
	      return this;
	    }
	    var match1 = /\d/,
	      //       0 - 9
	      match2 = /\d\d/,
	      //      00 - 99
	      match3 = /\d{3}/,
	      //     000 - 999
	      match4 = /\d{4}/,
	      //    0000 - 9999
	      match6 = /[+-]?\d{6}/,
	      // -999999 - 999999
	      match1to2 = /\d\d?/,
	      //       0 - 99
	      match3to4 = /\d\d\d\d?/,
	      //     999 - 9999
	      match5to6 = /\d\d\d\d\d\d?/,
	      //   99999 - 999999
	      match1to3 = /\d{1,3}/,
	      //       0 - 999
	      match1to4 = /\d{1,4}/,
	      //       0 - 9999
	      match1to6 = /[+-]?\d{1,6}/,
	      // -999999 - 999999
	      matchUnsigned = /\d+/,
	      //       0 - inf
	      matchSigned = /[+-]?\d+/,
	      //    -inf - inf
	      matchOffset = /Z|[+-]\d\d:?\d\d/gi,
	      // +00:00 -00:00 +0000 -0000 or Z
	      matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi,
	      // +00 -00 +00:00 -00:00 +0000 -0000 or Z
	      matchTimestamp = /[+-]?\d+(\.\d{1,3})?/,
	      // 123456789 123456789.123
	      // any word (or two) characters or numbers including two/three word month in arabic.
	      // includes scottish gaelic two word and hyphenated months
	      matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,
	      regexes;
	    regexes = {};
	    function addRegexToken(token, regex, strictRegex) {
	      regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
	        return isStrict && strictRegex ? strictRegex : regex;
	      };
	    }
	    function getParseRegexForToken(token, config) {
	      if (!hasOwnProp(regexes, token)) {
	        return new RegExp(unescapeFormat(token));
	      }
	      return regexes[token](config._strict, config._locale);
	    }

	    // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
	    function unescapeFormat(s) {
	      return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
	        return p1 || p2 || p3 || p4;
	      }));
	    }
	    function regexEscape(s) {
	      return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
	    }
	    var tokens = {};
	    function addParseToken(token, callback) {
	      var i,
	        func = callback,
	        tokenLen;
	      if (typeof token === 'string') {
	        token = [token];
	      }
	      if (isNumber(callback)) {
	        func = function (input, array) {
	          array[callback] = toInt(input);
	        };
	      }
	      tokenLen = token.length;
	      for (i = 0; i < tokenLen; i++) {
	        tokens[token[i]] = func;
	      }
	    }
	    function addWeekParseToken(token, callback) {
	      addParseToken(token, function (input, array, config, token) {
	        config._w = config._w || {};
	        callback(input, config._w, config, token);
	      });
	    }
	    function addTimeToArrayFromToken(token, input, config) {
	      if (input != null && hasOwnProp(tokens, token)) {
	        tokens[token](input, config._a, config, token);
	      }
	    }
	    var YEAR = 0,
	      MONTH = 1,
	      DATE = 2,
	      HOUR = 3,
	      MINUTE = 4,
	      SECOND = 5,
	      MILLISECOND = 6,
	      WEEK = 7,
	      WEEKDAY = 8;
	    function mod(n, x) {
	      return (n % x + x) % x;
	    }
	    var indexOf;
	    if (Array.prototype.indexOf) {
	      indexOf = Array.prototype.indexOf;
	    } else {
	      indexOf = function (o) {
	        // I know
	        var i;
	        for (i = 0; i < this.length; ++i) {
	          if (this[i] === o) {
	            return i;
	          }
	        }
	        return -1;
	      };
	    }
	    function daysInMonth(year, month) {
	      if (isNaN(year) || isNaN(month)) {
	        return NaN;
	      }
	      var modMonth = mod(month, 12);
	      year += (month - modMonth) / 12;
	      return modMonth === 1 ? isLeapYear(year) ? 29 : 28 : 31 - modMonth % 7 % 2;
	    }

	    // FORMATTING

	    addFormatToken('M', ['MM', 2], 'Mo', function () {
	      return this.month() + 1;
	    });
	    addFormatToken('MMM', 0, 0, function (format) {
	      return this.localeData().monthsShort(this, format);
	    });
	    addFormatToken('MMMM', 0, 0, function (format) {
	      return this.localeData().months(this, format);
	    });

	    // ALIASES

	    addUnitAlias('month', 'M');

	    // PRIORITY

	    addUnitPriority('month', 8);

	    // PARSING

	    addRegexToken('M', match1to2);
	    addRegexToken('MM', match1to2, match2);
	    addRegexToken('MMM', function (isStrict, locale) {
	      return locale.monthsShortRegex(isStrict);
	    });
	    addRegexToken('MMMM', function (isStrict, locale) {
	      return locale.monthsRegex(isStrict);
	    });
	    addParseToken(['M', 'MM'], function (input, array) {
	      array[MONTH] = toInt(input) - 1;
	    });
	    addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
	      var month = config._locale.monthsParse(input, token, config._strict);
	      // if we didn't find a month name, mark the date as invalid.
	      if (month != null) {
	        array[MONTH] = month;
	      } else {
	        getParsingFlags(config).invalidMonth = input;
	      }
	    });

	    // LOCALES

	    var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
	      defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
	      MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,
	      defaultMonthsShortRegex = matchWord,
	      defaultMonthsRegex = matchWord;
	    function localeMonths(m, format) {
	      if (!m) {
	        return isArray(this._months) ? this._months : this._months['standalone'];
	      }
	      return isArray(this._months) ? this._months[m.month()] : this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
	    }
	    function localeMonthsShort(m, format) {
	      if (!m) {
	        return isArray(this._monthsShort) ? this._monthsShort : this._monthsShort['standalone'];
	      }
	      return isArray(this._monthsShort) ? this._monthsShort[m.month()] : this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
	    }
	    function handleStrictParse(monthName, format, strict) {
	      var i,
	        ii,
	        mom,
	        llc = monthName.toLocaleLowerCase();
	      if (!this._monthsParse) {
	        // this is not used
	        this._monthsParse = [];
	        this._longMonthsParse = [];
	        this._shortMonthsParse = [];
	        for (i = 0; i < 12; ++i) {
	          mom = createUTC([2000, i]);
	          this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
	          this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
	        }
	      }
	      if (strict) {
	        if (format === 'MMM') {
	          ii = indexOf.call(this._shortMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._longMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      } else {
	        if (format === 'MMM') {
	          ii = indexOf.call(this._shortMonthsParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._longMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._longMonthsParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._shortMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      }
	    }
	    function localeMonthsParse(monthName, format, strict) {
	      var i, mom, regex;
	      if (this._monthsParseExact) {
	        return handleStrictParse.call(this, monthName, format, strict);
	      }
	      if (!this._monthsParse) {
	        this._monthsParse = [];
	        this._longMonthsParse = [];
	        this._shortMonthsParse = [];
	      }

	      // TODO: add sorting
	      // Sorting makes sure if one month (or abbr) is a prefix of another
	      // see sorting in computeMonthsParse
	      for (i = 0; i < 12; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, i]);
	        if (strict && !this._longMonthsParse[i]) {
	          this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
	          this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
	        }
	        if (!strict && !this._monthsParse[i]) {
	          regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
	          this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
	        }
	        // test the regex
	        if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
	          return i;
	        } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
	          return i;
	        } else if (!strict && this._monthsParse[i].test(monthName)) {
	          return i;
	        }
	      }
	    }

	    // MOMENTS

	    function setMonth(mom, value) {
	      var dayOfMonth;
	      if (!mom.isValid()) {
	        // No op
	        return mom;
	      }
	      if (typeof value === 'string') {
	        if (/^\d+$/.test(value)) {
	          value = toInt(value);
	        } else {
	          value = mom.localeData().monthsParse(value);
	          // TODO: Another silent failure?
	          if (!isNumber(value)) {
	            return mom;
	          }
	        }
	      }
	      dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
	      mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
	      return mom;
	    }
	    function getSetMonth(value) {
	      if (value != null) {
	        setMonth(this, value);
	        hooks.updateOffset(this, true);
	        return this;
	      } else {
	        return get(this, 'Month');
	      }
	    }
	    function getDaysInMonth() {
	      return daysInMonth(this.year(), this.month());
	    }
	    function monthsShortRegex(isStrict) {
	      if (this._monthsParseExact) {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	          computeMonthsParse.call(this);
	        }
	        if (isStrict) {
	          return this._monthsShortStrictRegex;
	        } else {
	          return this._monthsShortRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_monthsShortRegex')) {
	          this._monthsShortRegex = defaultMonthsShortRegex;
	        }
	        return this._monthsShortStrictRegex && isStrict ? this._monthsShortStrictRegex : this._monthsShortRegex;
	      }
	    }
	    function monthsRegex(isStrict) {
	      if (this._monthsParseExact) {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	          computeMonthsParse.call(this);
	        }
	        if (isStrict) {
	          return this._monthsStrictRegex;
	        } else {
	          return this._monthsRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	          this._monthsRegex = defaultMonthsRegex;
	        }
	        return this._monthsStrictRegex && isStrict ? this._monthsStrictRegex : this._monthsRegex;
	      }
	    }
	    function computeMonthsParse() {
	      function cmpLenRev(a, b) {
	        return b.length - a.length;
	      }
	      var shortPieces = [],
	        longPieces = [],
	        mixedPieces = [],
	        i,
	        mom;
	      for (i = 0; i < 12; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, i]);
	        shortPieces.push(this.monthsShort(mom, ''));
	        longPieces.push(this.months(mom, ''));
	        mixedPieces.push(this.months(mom, ''));
	        mixedPieces.push(this.monthsShort(mom, ''));
	      }
	      // Sorting makes sure if one month (or abbr) is a prefix of another it
	      // will match the longer piece.
	      shortPieces.sort(cmpLenRev);
	      longPieces.sort(cmpLenRev);
	      mixedPieces.sort(cmpLenRev);
	      for (i = 0; i < 12; i++) {
	        shortPieces[i] = regexEscape(shortPieces[i]);
	        longPieces[i] = regexEscape(longPieces[i]);
	      }
	      for (i = 0; i < 24; i++) {
	        mixedPieces[i] = regexEscape(mixedPieces[i]);
	      }
	      this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	      this._monthsShortRegex = this._monthsRegex;
	      this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	      this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	    }

	    // FORMATTING

	    addFormatToken('Y', 0, 0, function () {
	      var y = this.year();
	      return y <= 9999 ? zeroFill(y, 4) : '+' + y;
	    });
	    addFormatToken(0, ['YY', 2], 0, function () {
	      return this.year() % 100;
	    });
	    addFormatToken(0, ['YYYY', 4], 0, 'year');
	    addFormatToken(0, ['YYYYY', 5], 0, 'year');
	    addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');

	    // ALIASES

	    addUnitAlias('year', 'y');

	    // PRIORITIES

	    addUnitPriority('year', 1);

	    // PARSING

	    addRegexToken('Y', matchSigned);
	    addRegexToken('YY', match1to2, match2);
	    addRegexToken('YYYY', match1to4, match4);
	    addRegexToken('YYYYY', match1to6, match6);
	    addRegexToken('YYYYYY', match1to6, match6);
	    addParseToken(['YYYYY', 'YYYYYY'], YEAR);
	    addParseToken('YYYY', function (input, array) {
	      array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
	    });
	    addParseToken('YY', function (input, array) {
	      array[YEAR] = hooks.parseTwoDigitYear(input);
	    });
	    addParseToken('Y', function (input, array) {
	      array[YEAR] = parseInt(input, 10);
	    });

	    // HELPERS

	    function daysInYear(year) {
	      return isLeapYear(year) ? 366 : 365;
	    }

	    // HOOKS

	    hooks.parseTwoDigitYear = function (input) {
	      return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
	    };

	    // MOMENTS

	    var getSetYear = makeGetSet('FullYear', true);
	    function getIsLeapYear() {
	      return isLeapYear(this.year());
	    }
	    function createDate(y, m, d, h, M, s, ms) {
	      // can't just apply() to create a date:
	      // https://stackoverflow.com/q/181348
	      var date;
	      // the date constructor remaps years 0-99 to 1900-1999
	      if (y < 100 && y >= 0) {
	        // preserve leap years using a full 400 year cycle, then reset
	        date = new Date(y + 400, m, d, h, M, s, ms);
	        if (isFinite(date.getFullYear())) {
	          date.setFullYear(y);
	        }
	      } else {
	        date = new Date(y, m, d, h, M, s, ms);
	      }
	      return date;
	    }
	    function createUTCDate(y) {
	      var date, args;
	      // the Date.UTC function remaps years 0-99 to 1900-1999
	      if (y < 100 && y >= 0) {
	        args = Array.prototype.slice.call(arguments);
	        // preserve leap years using a full 400 year cycle, then reset
	        args[0] = y + 400;
	        date = new Date(Date.UTC.apply(null, args));
	        if (isFinite(date.getUTCFullYear())) {
	          date.setUTCFullYear(y);
	        }
	      } else {
	        date = new Date(Date.UTC.apply(null, arguments));
	      }
	      return date;
	    }

	    // start-of-first-week - start-of-year
	    function firstWeekOffset(year, dow, doy) {
	      var
	        // first-week day -- which january is always in the first week (4 for iso, 1 for other)
	        fwd = 7 + dow - doy,
	        // first-week day local weekday -- which local weekday is fwd
	        fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;
	      return -fwdlw + fwd - 1;
	    }

	    // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
	    function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
	      var localWeekday = (7 + weekday - dow) % 7,
	        weekOffset = firstWeekOffset(year, dow, doy),
	        dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
	        resYear,
	        resDayOfYear;
	      if (dayOfYear <= 0) {
	        resYear = year - 1;
	        resDayOfYear = daysInYear(resYear) + dayOfYear;
	      } else if (dayOfYear > daysInYear(year)) {
	        resYear = year + 1;
	        resDayOfYear = dayOfYear - daysInYear(year);
	      } else {
	        resYear = year;
	        resDayOfYear = dayOfYear;
	      }
	      return {
	        year: resYear,
	        dayOfYear: resDayOfYear
	      };
	    }
	    function weekOfYear(mom, dow, doy) {
	      var weekOffset = firstWeekOffset(mom.year(), dow, doy),
	        week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
	        resWeek,
	        resYear;
	      if (week < 1) {
	        resYear = mom.year() - 1;
	        resWeek = week + weeksInYear(resYear, dow, doy);
	      } else if (week > weeksInYear(mom.year(), dow, doy)) {
	        resWeek = week - weeksInYear(mom.year(), dow, doy);
	        resYear = mom.year() + 1;
	      } else {
	        resYear = mom.year();
	        resWeek = week;
	      }
	      return {
	        week: resWeek,
	        year: resYear
	      };
	    }
	    function weeksInYear(year, dow, doy) {
	      var weekOffset = firstWeekOffset(year, dow, doy),
	        weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
	      return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
	    }

	    // FORMATTING

	    addFormatToken('w', ['ww', 2], 'wo', 'week');
	    addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

	    // ALIASES

	    addUnitAlias('week', 'w');
	    addUnitAlias('isoWeek', 'W');

	    // PRIORITIES

	    addUnitPriority('week', 5);
	    addUnitPriority('isoWeek', 5);

	    // PARSING

	    addRegexToken('w', match1to2);
	    addRegexToken('ww', match1to2, match2);
	    addRegexToken('W', match1to2);
	    addRegexToken('WW', match1to2, match2);
	    addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
	      week[token.substr(0, 1)] = toInt(input);
	    });

	    // HELPERS

	    // LOCALES

	    function localeWeek(mom) {
	      return weekOfYear(mom, this._week.dow, this._week.doy).week;
	    }
	    var defaultLocaleWeek = {
	      dow: 0,
	      // Sunday is the first day of the week.
	      doy: 6 // The week that contains Jan 6th is the first week of the year.
	    };
	    function localeFirstDayOfWeek() {
	      return this._week.dow;
	    }
	    function localeFirstDayOfYear() {
	      return this._week.doy;
	    }

	    // MOMENTS

	    function getSetWeek(input) {
	      var week = this.localeData().week(this);
	      return input == null ? week : this.add((input - week) * 7, 'd');
	    }
	    function getSetISOWeek(input) {
	      var week = weekOfYear(this, 1, 4).week;
	      return input == null ? week : this.add((input - week) * 7, 'd');
	    }

	    // FORMATTING

	    addFormatToken('d', 0, 'do', 'day');
	    addFormatToken('dd', 0, 0, function (format) {
	      return this.localeData().weekdaysMin(this, format);
	    });
	    addFormatToken('ddd', 0, 0, function (format) {
	      return this.localeData().weekdaysShort(this, format);
	    });
	    addFormatToken('dddd', 0, 0, function (format) {
	      return this.localeData().weekdays(this, format);
	    });
	    addFormatToken('e', 0, 0, 'weekday');
	    addFormatToken('E', 0, 0, 'isoWeekday');

	    // ALIASES

	    addUnitAlias('day', 'd');
	    addUnitAlias('weekday', 'e');
	    addUnitAlias('isoWeekday', 'E');

	    // PRIORITY
	    addUnitPriority('day', 11);
	    addUnitPriority('weekday', 11);
	    addUnitPriority('isoWeekday', 11);

	    // PARSING

	    addRegexToken('d', match1to2);
	    addRegexToken('e', match1to2);
	    addRegexToken('E', match1to2);
	    addRegexToken('dd', function (isStrict, locale) {
	      return locale.weekdaysMinRegex(isStrict);
	    });
	    addRegexToken('ddd', function (isStrict, locale) {
	      return locale.weekdaysShortRegex(isStrict);
	    });
	    addRegexToken('dddd', function (isStrict, locale) {
	      return locale.weekdaysRegex(isStrict);
	    });
	    addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
	      var weekday = config._locale.weekdaysParse(input, token, config._strict);
	      // if we didn't get a weekday name, mark the date as invalid
	      if (weekday != null) {
	        week.d = weekday;
	      } else {
	        getParsingFlags(config).invalidWeekday = input;
	      }
	    });
	    addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
	      week[token] = toInt(input);
	    });

	    // HELPERS

	    function parseWeekday(input, locale) {
	      if (typeof input !== 'string') {
	        return input;
	      }
	      if (!isNaN(input)) {
	        return parseInt(input, 10);
	      }
	      input = locale.weekdaysParse(input);
	      if (typeof input === 'number') {
	        return input;
	      }
	      return null;
	    }
	    function parseIsoWeekday(input, locale) {
	      if (typeof input === 'string') {
	        return locale.weekdaysParse(input) % 7 || 7;
	      }
	      return isNaN(input) ? null : input;
	    }

	    // LOCALES
	    function shiftWeekdays(ws, n) {
	      return ws.slice(n, 7).concat(ws.slice(0, n));
	    }
	    var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
	      defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
	      defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
	      defaultWeekdaysRegex = matchWord,
	      defaultWeekdaysShortRegex = matchWord,
	      defaultWeekdaysMinRegex = matchWord;
	    function localeWeekdays(m, format) {
	      var weekdays = isArray(this._weekdays) ? this._weekdays : this._weekdays[m && m !== true && this._weekdays.isFormat.test(format) ? 'format' : 'standalone'];
	      return m === true ? shiftWeekdays(weekdays, this._week.dow) : m ? weekdays[m.day()] : weekdays;
	    }
	    function localeWeekdaysShort(m) {
	      return m === true ? shiftWeekdays(this._weekdaysShort, this._week.dow) : m ? this._weekdaysShort[m.day()] : this._weekdaysShort;
	    }
	    function localeWeekdaysMin(m) {
	      return m === true ? shiftWeekdays(this._weekdaysMin, this._week.dow) : m ? this._weekdaysMin[m.day()] : this._weekdaysMin;
	    }
	    function handleStrictParse$1(weekdayName, format, strict) {
	      var i,
	        ii,
	        mom,
	        llc = weekdayName.toLocaleLowerCase();
	      if (!this._weekdaysParse) {
	        this._weekdaysParse = [];
	        this._shortWeekdaysParse = [];
	        this._minWeekdaysParse = [];
	        for (i = 0; i < 7; ++i) {
	          mom = createUTC([2000, 1]).day(i);
	          this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
	          this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
	          this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
	        }
	      }
	      if (strict) {
	        if (format === 'dddd') {
	          ii = indexOf.call(this._weekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else if (format === 'ddd') {
	          ii = indexOf.call(this._shortWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._minWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      } else {
	        if (format === 'dddd') {
	          ii = indexOf.call(this._weekdaysParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._shortWeekdaysParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._minWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else if (format === 'ddd') {
	          ii = indexOf.call(this._shortWeekdaysParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._weekdaysParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._minWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._minWeekdaysParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._weekdaysParse, llc);
	          if (ii !== -1) {
	            return ii;
	          }
	          ii = indexOf.call(this._shortWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      }
	    }
	    function localeWeekdaysParse(weekdayName, format, strict) {
	      var i, mom, regex;
	      if (this._weekdaysParseExact) {
	        return handleStrictParse$1.call(this, weekdayName, format, strict);
	      }
	      if (!this._weekdaysParse) {
	        this._weekdaysParse = [];
	        this._minWeekdaysParse = [];
	        this._shortWeekdaysParse = [];
	        this._fullWeekdaysParse = [];
	      }
	      for (i = 0; i < 7; i++) {
	        // make the regex if we don't have it already

	        mom = createUTC([2000, 1]).day(i);
	        if (strict && !this._fullWeekdaysParse[i]) {
	          this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\\.?') + '$', 'i');
	          this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$', 'i');
	          this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$', 'i');
	        }
	        if (!this._weekdaysParse[i]) {
	          regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
	          this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
	        }
	        // test the regex
	        if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
	          return i;
	        } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
	          return i;
	        } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
	          return i;
	        } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
	          return i;
	        }
	      }
	    }

	    // MOMENTS

	    function getSetDayOfWeek(input) {
	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      }
	      var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
	      if (input != null) {
	        input = parseWeekday(input, this.localeData());
	        return this.add(input - day, 'd');
	      } else {
	        return day;
	      }
	    }
	    function getSetLocaleDayOfWeek(input) {
	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      }
	      var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
	      return input == null ? weekday : this.add(input - weekday, 'd');
	    }
	    function getSetISODayOfWeek(input) {
	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      }

	      // behaves the same as moment#day except
	      // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
	      // as a setter, sunday should belong to the previous week.

	      if (input != null) {
	        var weekday = parseIsoWeekday(input, this.localeData());
	        return this.day(this.day() % 7 ? weekday : weekday - 7);
	      } else {
	        return this.day() || 7;
	      }
	    }
	    function weekdaysRegex(isStrict) {
	      if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          computeWeekdaysParse.call(this);
	        }
	        if (isStrict) {
	          return this._weekdaysStrictRegex;
	        } else {
	          return this._weekdaysRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          this._weekdaysRegex = defaultWeekdaysRegex;
	        }
	        return this._weekdaysStrictRegex && isStrict ? this._weekdaysStrictRegex : this._weekdaysRegex;
	      }
	    }
	    function weekdaysShortRegex(isStrict) {
	      if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          computeWeekdaysParse.call(this);
	        }
	        if (isStrict) {
	          return this._weekdaysShortStrictRegex;
	        } else {
	          return this._weekdaysShortRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_weekdaysShortRegex')) {
	          this._weekdaysShortRegex = defaultWeekdaysShortRegex;
	        }
	        return this._weekdaysShortStrictRegex && isStrict ? this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
	      }
	    }
	    function weekdaysMinRegex(isStrict) {
	      if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          computeWeekdaysParse.call(this);
	        }
	        if (isStrict) {
	          return this._weekdaysMinStrictRegex;
	        } else {
	          return this._weekdaysMinRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_weekdaysMinRegex')) {
	          this._weekdaysMinRegex = defaultWeekdaysMinRegex;
	        }
	        return this._weekdaysMinStrictRegex && isStrict ? this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
	      }
	    }
	    function computeWeekdaysParse() {
	      function cmpLenRev(a, b) {
	        return b.length - a.length;
	      }
	      var minPieces = [],
	        shortPieces = [],
	        longPieces = [],
	        mixedPieces = [],
	        i,
	        mom,
	        minp,
	        shortp,
	        longp;
	      for (i = 0; i < 7; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, 1]).day(i);
	        minp = regexEscape(this.weekdaysMin(mom, ''));
	        shortp = regexEscape(this.weekdaysShort(mom, ''));
	        longp = regexEscape(this.weekdays(mom, ''));
	        minPieces.push(minp);
	        shortPieces.push(shortp);
	        longPieces.push(longp);
	        mixedPieces.push(minp);
	        mixedPieces.push(shortp);
	        mixedPieces.push(longp);
	      }
	      // Sorting makes sure if one weekday (or abbr) is a prefix of another it
	      // will match the longer piece.
	      minPieces.sort(cmpLenRev);
	      shortPieces.sort(cmpLenRev);
	      longPieces.sort(cmpLenRev);
	      mixedPieces.sort(cmpLenRev);
	      this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	      this._weekdaysShortRegex = this._weekdaysRegex;
	      this._weekdaysMinRegex = this._weekdaysRegex;
	      this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	      this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	      this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
	    }

	    // FORMATTING

	    function hFormat() {
	      return this.hours() % 12 || 12;
	    }
	    function kFormat() {
	      return this.hours() || 24;
	    }
	    addFormatToken('H', ['HH', 2], 0, 'hour');
	    addFormatToken('h', ['hh', 2], 0, hFormat);
	    addFormatToken('k', ['kk', 2], 0, kFormat);
	    addFormatToken('hmm', 0, 0, function () {
	      return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
	    });
	    addFormatToken('hmmss', 0, 0, function () {
	      return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
	    });
	    addFormatToken('Hmm', 0, 0, function () {
	      return '' + this.hours() + zeroFill(this.minutes(), 2);
	    });
	    addFormatToken('Hmmss', 0, 0, function () {
	      return '' + this.hours() + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
	    });
	    function meridiem(token, lowercase) {
	      addFormatToken(token, 0, 0, function () {
	        return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
	      });
	    }
	    meridiem('a', true);
	    meridiem('A', false);

	    // ALIASES

	    addUnitAlias('hour', 'h');

	    // PRIORITY
	    addUnitPriority('hour', 13);

	    // PARSING

	    function matchMeridiem(isStrict, locale) {
	      return locale._meridiemParse;
	    }
	    addRegexToken('a', matchMeridiem);
	    addRegexToken('A', matchMeridiem);
	    addRegexToken('H', match1to2);
	    addRegexToken('h', match1to2);
	    addRegexToken('k', match1to2);
	    addRegexToken('HH', match1to2, match2);
	    addRegexToken('hh', match1to2, match2);
	    addRegexToken('kk', match1to2, match2);
	    addRegexToken('hmm', match3to4);
	    addRegexToken('hmmss', match5to6);
	    addRegexToken('Hmm', match3to4);
	    addRegexToken('Hmmss', match5to6);
	    addParseToken(['H', 'HH'], HOUR);
	    addParseToken(['k', 'kk'], function (input, array, config) {
	      var kInput = toInt(input);
	      array[HOUR] = kInput === 24 ? 0 : kInput;
	    });
	    addParseToken(['a', 'A'], function (input, array, config) {
	      config._isPm = config._locale.isPM(input);
	      config._meridiem = input;
	    });
	    addParseToken(['h', 'hh'], function (input, array, config) {
	      array[HOUR] = toInt(input);
	      getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('hmm', function (input, array, config) {
	      var pos = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos));
	      array[MINUTE] = toInt(input.substr(pos));
	      getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('hmmss', function (input, array, config) {
	      var pos1 = input.length - 4,
	        pos2 = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos1));
	      array[MINUTE] = toInt(input.substr(pos1, 2));
	      array[SECOND] = toInt(input.substr(pos2));
	      getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('Hmm', function (input, array, config) {
	      var pos = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos));
	      array[MINUTE] = toInt(input.substr(pos));
	    });
	    addParseToken('Hmmss', function (input, array, config) {
	      var pos1 = input.length - 4,
	        pos2 = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos1));
	      array[MINUTE] = toInt(input.substr(pos1, 2));
	      array[SECOND] = toInt(input.substr(pos2));
	    });

	    // LOCALES

	    function localeIsPM(input) {
	      // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
	      // Using charAt should be more compatible.
	      return (input + '').toLowerCase().charAt(0) === 'p';
	    }
	    var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i,
	      // Setting the hour should keep the time, because the user explicitly
	      // specified which hour they want. So trying to maintain the same hour (in
	      // a new timezone) makes sense. Adding/subtracting hours does not follow
	      // this rule.
	      getSetHour = makeGetSet('Hours', true);
	    function localeMeridiem(hours, minutes, isLower) {
	      if (hours > 11) {
	        return isLower ? 'pm' : 'PM';
	      } else {
	        return isLower ? 'am' : 'AM';
	      }
	    }
	    var baseConfig = {
	      calendar: defaultCalendar,
	      longDateFormat: defaultLongDateFormat,
	      invalidDate: defaultInvalidDate,
	      ordinal: defaultOrdinal,
	      dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
	      relativeTime: defaultRelativeTime,
	      months: defaultLocaleMonths,
	      monthsShort: defaultLocaleMonthsShort,
	      week: defaultLocaleWeek,
	      weekdays: defaultLocaleWeekdays,
	      weekdaysMin: defaultLocaleWeekdaysMin,
	      weekdaysShort: defaultLocaleWeekdaysShort,
	      meridiemParse: defaultLocaleMeridiemParse
	    };

	    // internal storage for locale config files
	    var locales = {},
	      localeFamilies = {},
	      globalLocale;
	    function commonPrefix(arr1, arr2) {
	      var i,
	        minl = Math.min(arr1.length, arr2.length);
	      for (i = 0; i < minl; i += 1) {
	        if (arr1[i] !== arr2[i]) {
	          return i;
	        }
	      }
	      return minl;
	    }
	    function normalizeLocale(key) {
	      return key ? key.toLowerCase().replace('_', '-') : key;
	    }

	    // pick the locale from the array
	    // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
	    // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
	    function chooseLocale(names) {
	      var i = 0,
	        j,
	        next,
	        locale,
	        split;
	      while (i < names.length) {
	        split = normalizeLocale(names[i]).split('-');
	        j = split.length;
	        next = normalizeLocale(names[i + 1]);
	        next = next ? next.split('-') : null;
	        while (j > 0) {
	          locale = loadLocale(split.slice(0, j).join('-'));
	          if (locale) {
	            return locale;
	          }
	          if (next && next.length >= j && commonPrefix(split, next) >= j - 1) {
	            //the next array item is better than a shallower substring of this one
	            break;
	          }
	          j--;
	        }
	        i++;
	      }
	      return globalLocale;
	    }
	    function isLocaleNameSane(name) {
	      // Prevent names that look like filesystem paths, i.e contain '/' or '\'
	      return name.match('^[^/\\\\]*$') != null;
	    }
	    function loadLocale(name) {
	      var oldLocale = null,
	        aliasedRequire;
	      // TODO: Find a better way to register and load all the locales in Node
	      if (locales[name] === undefined && 'object' !== 'undefined' && module && module.exports && isLocaleNameSane(name)) {
	        try {
	          oldLocale = globalLocale._abbr;
	          aliasedRequire = commonjsRequire;
	          aliasedRequire('./locale/' + name);
	          getSetGlobalLocale(oldLocale);
	        } catch (e) {
	          // mark as not found to avoid repeating expensive file require call causing high CPU
	          // when trying to find en-US, en_US, en-us for every format call
	          locales[name] = null; // null means not found
	        }
	      }
	      return locales[name];
	    }

	    // This function will load locale and then set the global locale.  If
	    // no arguments are passed in, it will simply return the current global
	    // locale key.
	    function getSetGlobalLocale(key, values) {
	      var data;
	      if (key) {
	        if (isUndefined(values)) {
	          data = getLocale(key);
	        } else {
	          data = defineLocale(key, values);
	        }
	        if (data) {
	          // moment.duration._locale = moment._locale = data;
	          globalLocale = data;
	        } else {
	          if (typeof console !== 'undefined' && console.warn) {
	            //warn user if arguments are passed but the locale could not be set
	            console.warn('Locale ' + key + ' not found. Did you forget to load it?');
	          }
	        }
	      }
	      return globalLocale._abbr;
	    }
	    function defineLocale(name, config) {
	      if (config !== null) {
	        var locale,
	          parentConfig = baseConfig;
	        config.abbr = name;
	        if (locales[name] != null) {
	          deprecateSimple('defineLocaleOverride', 'use moment.updateLocale(localeName, config) to change ' + 'an existing locale. moment.defineLocale(localeName, ' + 'config) should only be used for creating a new locale ' + 'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
	          parentConfig = locales[name]._config;
	        } else if (config.parentLocale != null) {
	          if (locales[config.parentLocale] != null) {
	            parentConfig = locales[config.parentLocale]._config;
	          } else {
	            locale = loadLocale(config.parentLocale);
	            if (locale != null) {
	              parentConfig = locale._config;
	            } else {
	              if (!localeFamilies[config.parentLocale]) {
	                localeFamilies[config.parentLocale] = [];
	              }
	              localeFamilies[config.parentLocale].push({
	                name: name,
	                config: config
	              });
	              return null;
	            }
	          }
	        }
	        locales[name] = new Locale(mergeConfigs(parentConfig, config));
	        if (localeFamilies[name]) {
	          localeFamilies[name].forEach(function (x) {
	            defineLocale(x.name, x.config);
	          });
	        }

	        // backwards compat for now: also set the locale
	        // make sure we set the locale AFTER all child locales have been
	        // created, so we won't end up with the child locale set.
	        getSetGlobalLocale(name);
	        return locales[name];
	      } else {
	        // useful for testing
	        delete locales[name];
	        return null;
	      }
	    }
	    function updateLocale(name, config) {
	      if (config != null) {
	        var locale,
	          tmpLocale,
	          parentConfig = baseConfig;
	        if (locales[name] != null && locales[name].parentLocale != null) {
	          // Update existing child locale in-place to avoid memory-leaks
	          locales[name].set(mergeConfigs(locales[name]._config, config));
	        } else {
	          // MERGE
	          tmpLocale = loadLocale(name);
	          if (tmpLocale != null) {
	            parentConfig = tmpLocale._config;
	          }
	          config = mergeConfigs(parentConfig, config);
	          if (tmpLocale == null) {
	            // updateLocale is called for creating a new locale
	            // Set abbr so it will have a name (getters return
	            // undefined otherwise).
	            config.abbr = name;
	          }
	          locale = new Locale(config);
	          locale.parentLocale = locales[name];
	          locales[name] = locale;
	        }

	        // backwards compat for now: also set the locale
	        getSetGlobalLocale(name);
	      } else {
	        // pass null for config to unupdate, useful for tests
	        if (locales[name] != null) {
	          if (locales[name].parentLocale != null) {
	            locales[name] = locales[name].parentLocale;
	            if (name === getSetGlobalLocale()) {
	              getSetGlobalLocale(name);
	            }
	          } else if (locales[name] != null) {
	            delete locales[name];
	          }
	        }
	      }
	      return locales[name];
	    }

	    // returns locale data
	    function getLocale(key) {
	      var locale;
	      if (key && key._locale && key._locale._abbr) {
	        key = key._locale._abbr;
	      }
	      if (!key) {
	        return globalLocale;
	      }
	      if (!isArray(key)) {
	        //short-circuit everything else
	        locale = loadLocale(key);
	        if (locale) {
	          return locale;
	        }
	        key = [key];
	      }
	      return chooseLocale(key);
	    }
	    function listLocales() {
	      return keys(locales);
	    }
	    function checkOverflow(m) {
	      var overflow,
	        a = m._a;
	      if (a && getParsingFlags(m).overflow === -2) {
	        overflow = a[MONTH] < 0 || a[MONTH] > 11 ? MONTH : a[DATE] < 1 || a[DATE] > daysInMonth(a[YEAR], a[MONTH]) ? DATE : a[HOUR] < 0 || a[HOUR] > 24 || a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0) ? HOUR : a[MINUTE] < 0 || a[MINUTE] > 59 ? MINUTE : a[SECOND] < 0 || a[SECOND] > 59 ? SECOND : a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND : -1;
	        if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
	          overflow = DATE;
	        }
	        if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
	          overflow = WEEK;
	        }
	        if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
	          overflow = WEEKDAY;
	        }
	        getParsingFlags(m).overflow = overflow;
	      }
	      return m;
	    }

	    // iso 8601 regex
	    // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
	    var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
	      basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
	      tzRegex = /Z|[+-]\d\d(?::?\d\d)?/,
	      isoDates = [['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/], ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/], ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/], ['GGGG-[W]WW', /\d{4}-W\d\d/, false], ['YYYY-DDD', /\d{4}-\d{3}/], ['YYYY-MM', /\d{4}-\d\d/, false], ['YYYYYYMMDD', /[+-]\d{10}/], ['YYYYMMDD', /\d{8}/], ['GGGG[W]WWE', /\d{4}W\d{3}/], ['GGGG[W]WW', /\d{4}W\d{2}/, false], ['YYYYDDD', /\d{7}/], ['YYYYMM', /\d{6}/, false], ['YYYY', /\d{4}/, false]],
	      // iso time formats and regexes
	      isoTimes = [['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/], ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/], ['HH:mm:ss', /\d\d:\d\d:\d\d/], ['HH:mm', /\d\d:\d\d/], ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/], ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/], ['HHmmss', /\d\d\d\d\d\d/], ['HHmm', /\d\d\d\d/], ['HH', /\d\d/]],
	      aspNetJsonRegex = /^\/?Date\((-?\d+)/i,
	      // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
	      rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,
	      obsOffsets = {
	        UT: 0,
	        GMT: 0,
	        EDT: -4 * 60,
	        EST: -5 * 60,
	        CDT: -5 * 60,
	        CST: -6 * 60,
	        MDT: -6 * 60,
	        MST: -7 * 60,
	        PDT: -7 * 60,
	        PST: -8 * 60
	      };

	    // date from iso format
	    function configFromISO(config) {
	      var i,
	        l,
	        string = config._i,
	        match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
	        allowTime,
	        dateFormat,
	        timeFormat,
	        tzFormat,
	        isoDatesLen = isoDates.length,
	        isoTimesLen = isoTimes.length;
	      if (match) {
	        getParsingFlags(config).iso = true;
	        for (i = 0, l = isoDatesLen; i < l; i++) {
	          if (isoDates[i][1].exec(match[1])) {
	            dateFormat = isoDates[i][0];
	            allowTime = isoDates[i][2] !== false;
	            break;
	          }
	        }
	        if (dateFormat == null) {
	          config._isValid = false;
	          return;
	        }
	        if (match[3]) {
	          for (i = 0, l = isoTimesLen; i < l; i++) {
	            if (isoTimes[i][1].exec(match[3])) {
	              // match[2] should be 'T' or space
	              timeFormat = (match[2] || ' ') + isoTimes[i][0];
	              break;
	            }
	          }
	          if (timeFormat == null) {
	            config._isValid = false;
	            return;
	          }
	        }
	        if (!allowTime && timeFormat != null) {
	          config._isValid = false;
	          return;
	        }
	        if (match[4]) {
	          if (tzRegex.exec(match[4])) {
	            tzFormat = 'Z';
	          } else {
	            config._isValid = false;
	            return;
	          }
	        }
	        config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
	        configFromStringAndFormat(config);
	      } else {
	        config._isValid = false;
	      }
	    }
	    function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
	      var result = [untruncateYear(yearStr), defaultLocaleMonthsShort.indexOf(monthStr), parseInt(dayStr, 10), parseInt(hourStr, 10), parseInt(minuteStr, 10)];
	      if (secondStr) {
	        result.push(parseInt(secondStr, 10));
	      }
	      return result;
	    }
	    function untruncateYear(yearStr) {
	      var year = parseInt(yearStr, 10);
	      if (year <= 49) {
	        return 2000 + year;
	      } else if (year <= 999) {
	        return 1900 + year;
	      }
	      return year;
	    }
	    function preprocessRFC2822(s) {
	      // Remove comments and folding whitespace and replace multiple-spaces with a single space
	      return s.replace(/\([^()]*\)|[\n\t]/g, ' ').replace(/(\s\s+)/g, ' ').replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	    }
	    function checkWeekday(weekdayStr, parsedInput, config) {
	      if (weekdayStr) {
	        // TODO: Replace the vanilla JS Date object with an independent day-of-week check.
	        var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr),
	          weekdayActual = new Date(parsedInput[0], parsedInput[1], parsedInput[2]).getDay();
	        if (weekdayProvided !== weekdayActual) {
	          getParsingFlags(config).weekdayMismatch = true;
	          config._isValid = false;
	          return false;
	        }
	      }
	      return true;
	    }
	    function calculateOffset(obsOffset, militaryOffset, numOffset) {
	      if (obsOffset) {
	        return obsOffsets[obsOffset];
	      } else if (militaryOffset) {
	        // the only allowed military tz is Z
	        return 0;
	      } else {
	        var hm = parseInt(numOffset, 10),
	          m = hm % 100,
	          h = (hm - m) / 100;
	        return h * 60 + m;
	      }
	    }

	    // date and time from ref 2822 format
	    function configFromRFC2822(config) {
	      var match = rfc2822.exec(preprocessRFC2822(config._i)),
	        parsedArray;
	      if (match) {
	        parsedArray = extractFromRFC2822Strings(match[4], match[3], match[2], match[5], match[6], match[7]);
	        if (!checkWeekday(match[1], parsedArray, config)) {
	          return;
	        }
	        config._a = parsedArray;
	        config._tzm = calculateOffset(match[8], match[9], match[10]);
	        config._d = createUTCDate.apply(null, config._a);
	        config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
	        getParsingFlags(config).rfc2822 = true;
	      } else {
	        config._isValid = false;
	      }
	    }

	    // date from 1) ASP.NET, 2) ISO, 3) RFC 2822 formats, or 4) optional fallback if parsing isn't strict
	    function configFromString(config) {
	      var matched = aspNetJsonRegex.exec(config._i);
	      if (matched !== null) {
	        config._d = new Date(+matched[1]);
	        return;
	      }
	      configFromISO(config);
	      if (config._isValid === false) {
	        delete config._isValid;
	      } else {
	        return;
	      }
	      configFromRFC2822(config);
	      if (config._isValid === false) {
	        delete config._isValid;
	      } else {
	        return;
	      }
	      if (config._strict) {
	        config._isValid = false;
	      } else {
	        // Final attempt, use Input Fallback
	        hooks.createFromInputFallback(config);
	      }
	    }
	    hooks.createFromInputFallback = deprecate('value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' + 'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' + 'discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.', function (config) {
	      config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
	    });

	    // Pick the first defined of two or three arguments.
	    function defaults(a, b, c) {
	      if (a != null) {
	        return a;
	      }
	      if (b != null) {
	        return b;
	      }
	      return c;
	    }
	    function currentDateArray(config) {
	      // hooks is actually the exported moment object
	      var nowValue = new Date(hooks.now());
	      if (config._useUTC) {
	        return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
	      }
	      return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
	    }

	    // convert an array to a date.
	    // the array should mirror the parameters below
	    // note: all values past the year are optional and will default to the lowest possible value.
	    // [year, month, day , hour, minute, second, millisecond]
	    function configFromArray(config) {
	      var i,
	        date,
	        input = [],
	        currentDate,
	        expectedWeekday,
	        yearToUse;
	      if (config._d) {
	        return;
	      }
	      currentDate = currentDateArray(config);

	      //compute day of the year from weeks and weekdays
	      if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
	        dayOfYearFromWeekInfo(config);
	      }

	      //if the day of the year is set, figure out what it is
	      if (config._dayOfYear != null) {
	        yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);
	        if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {
	          getParsingFlags(config)._overflowDayOfYear = true;
	        }
	        date = createUTCDate(yearToUse, 0, config._dayOfYear);
	        config._a[MONTH] = date.getUTCMonth();
	        config._a[DATE] = date.getUTCDate();
	      }

	      // Default to current date.
	      // * if no year, month, day of month are given, default to today
	      // * if day of month is given, default month and year
	      // * if month is given, default only year
	      // * if year is given, don't default anything
	      for (i = 0; i < 3 && config._a[i] == null; ++i) {
	        config._a[i] = input[i] = currentDate[i];
	      }

	      // Zero out whatever was not defaulted, including time
	      for (; i < 7; i++) {
	        config._a[i] = input[i] = config._a[i] == null ? i === 2 ? 1 : 0 : config._a[i];
	      }

	      // Check for 24:00:00.000
	      if (config._a[HOUR] === 24 && config._a[MINUTE] === 0 && config._a[SECOND] === 0 && config._a[MILLISECOND] === 0) {
	        config._nextDay = true;
	        config._a[HOUR] = 0;
	      }
	      config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
	      expectedWeekday = config._useUTC ? config._d.getUTCDay() : config._d.getDay();

	      // Apply timezone offset from input. The actual utcOffset can be changed
	      // with parseZone.
	      if (config._tzm != null) {
	        config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
	      }
	      if (config._nextDay) {
	        config._a[HOUR] = 24;
	      }

	      // check for mismatching day of week
	      if (config._w && typeof config._w.d !== 'undefined' && config._w.d !== expectedWeekday) {
	        getParsingFlags(config).weekdayMismatch = true;
	      }
	    }
	    function dayOfYearFromWeekInfo(config) {
	      var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow, curWeek;
	      w = config._w;
	      if (w.GG != null || w.W != null || w.E != null) {
	        dow = 1;
	        doy = 4;

	        // TODO: We need to take the current isoWeekYear, but that depends on
	        // how we interpret now (local, utc, fixed offset). So create
	        // a now version of current config (take local/utc/offset flags, and
	        // create now).
	        weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
	        week = defaults(w.W, 1);
	        weekday = defaults(w.E, 1);
	        if (weekday < 1 || weekday > 7) {
	          weekdayOverflow = true;
	        }
	      } else {
	        dow = config._locale._week.dow;
	        doy = config._locale._week.doy;
	        curWeek = weekOfYear(createLocal(), dow, doy);
	        weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);

	        // Default to current week.
	        week = defaults(w.w, curWeek.week);
	        if (w.d != null) {
	          // weekday -- low day numbers are considered next week
	          weekday = w.d;
	          if (weekday < 0 || weekday > 6) {
	            weekdayOverflow = true;
	          }
	        } else if (w.e != null) {
	          // local weekday -- counting starts from beginning of week
	          weekday = w.e + dow;
	          if (w.e < 0 || w.e > 6) {
	            weekdayOverflow = true;
	          }
	        } else {
	          // default to beginning of week
	          weekday = dow;
	        }
	      }
	      if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
	        getParsingFlags(config)._overflowWeeks = true;
	      } else if (weekdayOverflow != null) {
	        getParsingFlags(config)._overflowWeekday = true;
	      } else {
	        temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
	        config._a[YEAR] = temp.year;
	        config._dayOfYear = temp.dayOfYear;
	      }
	    }

	    // constant that refers to the ISO standard
	    hooks.ISO_8601 = function () {};

	    // constant that refers to the RFC 2822 form
	    hooks.RFC_2822 = function () {};

	    // date from string and format string
	    function configFromStringAndFormat(config) {
	      // TODO: Move this to another part of the creation flow to prevent circular deps
	      if (config._f === hooks.ISO_8601) {
	        configFromISO(config);
	        return;
	      }
	      if (config._f === hooks.RFC_2822) {
	        configFromRFC2822(config);
	        return;
	      }
	      config._a = [];
	      getParsingFlags(config).empty = true;

	      // This array is used to make a Date, either with `new Date` or `Date.UTC`
	      var string = '' + config._i,
	        i,
	        parsedInput,
	        tokens,
	        token,
	        skipped,
	        stringLength = string.length,
	        totalParsedInputLength = 0,
	        era,
	        tokenLen;
	      tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];
	      tokenLen = tokens.length;
	      for (i = 0; i < tokenLen; i++) {
	        token = tokens[i];
	        parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];
	        if (parsedInput) {
	          skipped = string.substr(0, string.indexOf(parsedInput));
	          if (skipped.length > 0) {
	            getParsingFlags(config).unusedInput.push(skipped);
	          }
	          string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
	          totalParsedInputLength += parsedInput.length;
	        }
	        // don't parse if it's not a known token
	        if (formatTokenFunctions[token]) {
	          if (parsedInput) {
	            getParsingFlags(config).empty = false;
	          } else {
	            getParsingFlags(config).unusedTokens.push(token);
	          }
	          addTimeToArrayFromToken(token, parsedInput, config);
	        } else if (config._strict && !parsedInput) {
	          getParsingFlags(config).unusedTokens.push(token);
	        }
	      }

	      // add remaining unparsed input length to the string
	      getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;
	      if (string.length > 0) {
	        getParsingFlags(config).unusedInput.push(string);
	      }

	      // clear _12h flag if hour is <= 12
	      if (config._a[HOUR] <= 12 && getParsingFlags(config).bigHour === true && config._a[HOUR] > 0) {
	        getParsingFlags(config).bigHour = undefined;
	      }
	      getParsingFlags(config).parsedDateParts = config._a.slice(0);
	      getParsingFlags(config).meridiem = config._meridiem;
	      // handle meridiem
	      config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);

	      // handle era
	      era = getParsingFlags(config).era;
	      if (era !== null) {
	        config._a[YEAR] = config._locale.erasConvertYear(era, config._a[YEAR]);
	      }
	      configFromArray(config);
	      checkOverflow(config);
	    }
	    function meridiemFixWrap(locale, hour, meridiem) {
	      var isPm;
	      if (meridiem == null) {
	        // nothing to do
	        return hour;
	      }
	      if (locale.meridiemHour != null) {
	        return locale.meridiemHour(hour, meridiem);
	      } else if (locale.isPM != null) {
	        // Fallback
	        isPm = locale.isPM(meridiem);
	        if (isPm && hour < 12) {
	          hour += 12;
	        }
	        if (!isPm && hour === 12) {
	          hour = 0;
	        }
	        return hour;
	      } else {
	        // this is not supposed to happen
	        return hour;
	      }
	    }

	    // date from string and array of format strings
	    function configFromStringAndArray(config) {
	      var tempConfig,
	        bestMoment,
	        scoreToBeat,
	        i,
	        currentScore,
	        validFormatFound,
	        bestFormatIsValid = false,
	        configfLen = config._f.length;
	      if (configfLen === 0) {
	        getParsingFlags(config).invalidFormat = true;
	        config._d = new Date(NaN);
	        return;
	      }
	      for (i = 0; i < configfLen; i++) {
	        currentScore = 0;
	        validFormatFound = false;
	        tempConfig = copyConfig({}, config);
	        if (config._useUTC != null) {
	          tempConfig._useUTC = config._useUTC;
	        }
	        tempConfig._f = config._f[i];
	        configFromStringAndFormat(tempConfig);
	        if (isValid(tempConfig)) {
	          validFormatFound = true;
	        }

	        // if there is any input that was not parsed add a penalty for that format
	        currentScore += getParsingFlags(tempConfig).charsLeftOver;

	        //or tokens
	        currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;
	        getParsingFlags(tempConfig).score = currentScore;
	        if (!bestFormatIsValid) {
	          if (scoreToBeat == null || currentScore < scoreToBeat || validFormatFound) {
	            scoreToBeat = currentScore;
	            bestMoment = tempConfig;
	            if (validFormatFound) {
	              bestFormatIsValid = true;
	            }
	          }
	        } else {
	          if (currentScore < scoreToBeat) {
	            scoreToBeat = currentScore;
	            bestMoment = tempConfig;
	          }
	        }
	      }
	      extend(config, bestMoment || tempConfig);
	    }
	    function configFromObject(config) {
	      if (config._d) {
	        return;
	      }
	      var i = normalizeObjectUnits(config._i),
	        dayOrDate = i.day === undefined ? i.date : i.day;
	      config._a = map([i.year, i.month, dayOrDate, i.hour, i.minute, i.second, i.millisecond], function (obj) {
	        return obj && parseInt(obj, 10);
	      });
	      configFromArray(config);
	    }
	    function createFromConfig(config) {
	      var res = new Moment(checkOverflow(prepareConfig(config)));
	      if (res._nextDay) {
	        // Adding is smart enough around DST
	        res.add(1, 'd');
	        res._nextDay = undefined;
	      }
	      return res;
	    }
	    function prepareConfig(config) {
	      var input = config._i,
	        format = config._f;
	      config._locale = config._locale || getLocale(config._l);
	      if (input === null || format === undefined && input === '') {
	        return createInvalid({
	          nullInput: true
	        });
	      }
	      if (typeof input === 'string') {
	        config._i = input = config._locale.preparse(input);
	      }
	      if (isMoment(input)) {
	        return new Moment(checkOverflow(input));
	      } else if (isDate(input)) {
	        config._d = input;
	      } else if (isArray(format)) {
	        configFromStringAndArray(config);
	      } else if (format) {
	        configFromStringAndFormat(config);
	      } else {
	        configFromInput(config);
	      }
	      if (!isValid(config)) {
	        config._d = null;
	      }
	      return config;
	    }
	    function configFromInput(config) {
	      var input = config._i;
	      if (isUndefined(input)) {
	        config._d = new Date(hooks.now());
	      } else if (isDate(input)) {
	        config._d = new Date(input.valueOf());
	      } else if (typeof input === 'string') {
	        configFromString(config);
	      } else if (isArray(input)) {
	        config._a = map(input.slice(0), function (obj) {
	          return parseInt(obj, 10);
	        });
	        configFromArray(config);
	      } else if (isObject(input)) {
	        configFromObject(config);
	      } else if (isNumber(input)) {
	        // from milliseconds
	        config._d = new Date(input);
	      } else {
	        hooks.createFromInputFallback(config);
	      }
	    }
	    function createLocalOrUTC(input, format, locale, strict, isUTC) {
	      var c = {};
	      if (format === true || format === false) {
	        strict = format;
	        format = undefined;
	      }
	      if (locale === true || locale === false) {
	        strict = locale;
	        locale = undefined;
	      }
	      if (isObject(input) && isObjectEmpty(input) || isArray(input) && input.length === 0) {
	        input = undefined;
	      }
	      // object construction must be done this way.
	      // https://github.com/moment/moment/issues/1423
	      c._isAMomentObject = true;
	      c._useUTC = c._isUTC = isUTC;
	      c._l = locale;
	      c._i = input;
	      c._f = format;
	      c._strict = strict;
	      return createFromConfig(c);
	    }
	    function createLocal(input, format, locale, strict) {
	      return createLocalOrUTC(input, format, locale, strict, false);
	    }
	    var prototypeMin = deprecate('moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/', function () {
	        var other = createLocal.apply(null, arguments);
	        if (this.isValid() && other.isValid()) {
	          return other < this ? this : other;
	        } else {
	          return createInvalid();
	        }
	      }),
	      prototypeMax = deprecate('moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/', function () {
	        var other = createLocal.apply(null, arguments);
	        if (this.isValid() && other.isValid()) {
	          return other > this ? this : other;
	        } else {
	          return createInvalid();
	        }
	      });

	    // Pick a moment m from moments so that m[fn](other) is true for all
	    // other. This relies on the function fn to be transitive.
	    //
	    // moments should either be an array of moment objects or an array, whose
	    // first element is an array of moment objects.
	    function pickBy(fn, moments) {
	      var res, i;
	      if (moments.length === 1 && isArray(moments[0])) {
	        moments = moments[0];
	      }
	      if (!moments.length) {
	        return createLocal();
	      }
	      res = moments[0];
	      for (i = 1; i < moments.length; ++i) {
	        if (!moments[i].isValid() || moments[i][fn](res)) {
	          res = moments[i];
	        }
	      }
	      return res;
	    }

	    // TODO: Use [].sort instead?
	    function min() {
	      var args = [].slice.call(arguments, 0);
	      return pickBy('isBefore', args);
	    }
	    function max() {
	      var args = [].slice.call(arguments, 0);
	      return pickBy('isAfter', args);
	    }
	    var now = function () {
	      return Date.now ? Date.now() : +new Date();
	    };
	    var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];
	    function isDurationValid(m) {
	      var key,
	        unitHasDecimal = false,
	        i,
	        orderLen = ordering.length;
	      for (key in m) {
	        if (hasOwnProp(m, key) && !(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
	          return false;
	        }
	      }
	      for (i = 0; i < orderLen; ++i) {
	        if (m[ordering[i]]) {
	          if (unitHasDecimal) {
	            return false; // only allow non-integers for smallest unit
	          }
	          if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
	            unitHasDecimal = true;
	          }
	        }
	      }
	      return true;
	    }
	    function isValid$1() {
	      return this._isValid;
	    }
	    function createInvalid$1() {
	      return createDuration(NaN);
	    }
	    function Duration(duration) {
	      var normalizedInput = normalizeObjectUnits(duration),
	        years = normalizedInput.year || 0,
	        quarters = normalizedInput.quarter || 0,
	        months = normalizedInput.month || 0,
	        weeks = normalizedInput.week || normalizedInput.isoWeek || 0,
	        days = normalizedInput.day || 0,
	        hours = normalizedInput.hour || 0,
	        minutes = normalizedInput.minute || 0,
	        seconds = normalizedInput.second || 0,
	        milliseconds = normalizedInput.millisecond || 0;
	      this._isValid = isDurationValid(normalizedInput);

	      // representation for dateAddRemove
	      this._milliseconds = +milliseconds + seconds * 1e3 +
	      // 1000
	      minutes * 6e4 +
	      // 1000 * 60
	      hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
	      // Because of dateAddRemove treats 24 hours as different from a
	      // day when working around DST, we need to store them separately
	      this._days = +days + weeks * 7;
	      // It is impossible to translate months into days without knowing
	      // which months you are are talking about, so we have to store
	      // it separately.
	      this._months = +months + quarters * 3 + years * 12;
	      this._data = {};
	      this._locale = getLocale();
	      this._bubble();
	    }
	    function isDuration(obj) {
	      return obj instanceof Duration;
	    }
	    function absRound(number) {
	      if (number < 0) {
	        return Math.round(-1 * number) * -1;
	      } else {
	        return Math.round(number);
	      }
	    }

	    // compare two arrays, return the number of differences
	    function compareArrays(array1, array2, dontConvert) {
	      var len = Math.min(array1.length, array2.length),
	        lengthDiff = Math.abs(array1.length - array2.length),
	        diffs = 0,
	        i;
	      for (i = 0; i < len; i++) {
	        if (dontConvert && array1[i] !== array2[i] || !dontConvert && toInt(array1[i]) !== toInt(array2[i])) {
	          diffs++;
	        }
	      }
	      return diffs + lengthDiff;
	    }

	    // FORMATTING

	    function offset(token, separator) {
	      addFormatToken(token, 0, 0, function () {
	        var offset = this.utcOffset(),
	          sign = '+';
	        if (offset < 0) {
	          offset = -offset;
	          sign = '-';
	        }
	        return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~offset % 60, 2);
	      });
	    }
	    offset('Z', ':');
	    offset('ZZ', '');

	    // PARSING

	    addRegexToken('Z', matchShortOffset);
	    addRegexToken('ZZ', matchShortOffset);
	    addParseToken(['Z', 'ZZ'], function (input, array, config) {
	      config._useUTC = true;
	      config._tzm = offsetFromString(matchShortOffset, input);
	    });

	    // HELPERS

	    // timezone chunker
	    // '+10:00' > ['10',  '00']
	    // '-1530'  > ['-15', '30']
	    var chunkOffset = /([\+\-]|\d\d)/gi;
	    function offsetFromString(matcher, string) {
	      var matches = (string || '').match(matcher),
	        chunk,
	        parts,
	        minutes;
	      if (matches === null) {
	        return null;
	      }
	      chunk = matches[matches.length - 1] || [];
	      parts = (chunk + '').match(chunkOffset) || ['-', 0, 0];
	      minutes = +(parts[1] * 60) + toInt(parts[2]);
	      return minutes === 0 ? 0 : parts[0] === '+' ? minutes : -minutes;
	    }

	    // Return a moment from input, that is local/utc/zone equivalent to model.
	    function cloneWithOffset(input, model) {
	      var res, diff;
	      if (model._isUTC) {
	        res = model.clone();
	        diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
	        // Use low-level api, because this fn is low-level api.
	        res._d.setTime(res._d.valueOf() + diff);
	        hooks.updateOffset(res, false);
	        return res;
	      } else {
	        return createLocal(input).local();
	      }
	    }
	    function getDateOffset(m) {
	      // On Firefox.24 Date#getTimezoneOffset returns a floating point.
	      // https://github.com/moment/moment/pull/1871
	      return -Math.round(m._d.getTimezoneOffset());
	    }

	    // HOOKS

	    // This function will be called whenever a moment is mutated.
	    // It is intended to keep the offset in sync with the timezone.
	    hooks.updateOffset = function () {};

	    // MOMENTS

	    // keepLocalTime = true means only change the timezone, without
	    // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
	    // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
	    // +0200, so we adjust the time as needed, to be valid.
	    //
	    // Keeping the time actually adds/subtracts (one hour)
	    // from the actual represented time. That is why we call updateOffset
	    // a second time. In case it wants us to change the offset again
	    // _changeInProgress == true case, then we have to adjust, because
	    // there is no such time in the given timezone.
	    function getSetOffset(input, keepLocalTime, keepMinutes) {
	      var offset = this._offset || 0,
	        localAdjust;
	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      }
	      if (input != null) {
	        if (typeof input === 'string') {
	          input = offsetFromString(matchShortOffset, input);
	          if (input === null) {
	            return this;
	          }
	        } else if (Math.abs(input) < 16 && !keepMinutes) {
	          input = input * 60;
	        }
	        if (!this._isUTC && keepLocalTime) {
	          localAdjust = getDateOffset(this);
	        }
	        this._offset = input;
	        this._isUTC = true;
	        if (localAdjust != null) {
	          this.add(localAdjust, 'm');
	        }
	        if (offset !== input) {
	          if (!keepLocalTime || this._changeInProgress) {
	            addSubtract(this, createDuration(input - offset, 'm'), 1, false);
	          } else if (!this._changeInProgress) {
	            this._changeInProgress = true;
	            hooks.updateOffset(this, true);
	            this._changeInProgress = null;
	          }
	        }
	        return this;
	      } else {
	        return this._isUTC ? offset : getDateOffset(this);
	      }
	    }
	    function getSetZone(input, keepLocalTime) {
	      if (input != null) {
	        if (typeof input !== 'string') {
	          input = -input;
	        }
	        this.utcOffset(input, keepLocalTime);
	        return this;
	      } else {
	        return -this.utcOffset();
	      }
	    }
	    function setOffsetToUTC(keepLocalTime) {
	      return this.utcOffset(0, keepLocalTime);
	    }
	    function setOffsetToLocal(keepLocalTime) {
	      if (this._isUTC) {
	        this.utcOffset(0, keepLocalTime);
	        this._isUTC = false;
	        if (keepLocalTime) {
	          this.subtract(getDateOffset(this), 'm');
	        }
	      }
	      return this;
	    }
	    function setOffsetToParsedOffset() {
	      if (this._tzm != null) {
	        this.utcOffset(this._tzm, false, true);
	      } else if (typeof this._i === 'string') {
	        var tZone = offsetFromString(matchOffset, this._i);
	        if (tZone != null) {
	          this.utcOffset(tZone);
	        } else {
	          this.utcOffset(0, true);
	        }
	      }
	      return this;
	    }
	    function hasAlignedHourOffset(input) {
	      if (!this.isValid()) {
	        return false;
	      }
	      input = input ? createLocal(input).utcOffset() : 0;
	      return (this.utcOffset() - input) % 60 === 0;
	    }
	    function isDaylightSavingTime() {
	      return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
	    }
	    function isDaylightSavingTimeShifted() {
	      if (!isUndefined(this._isDSTShifted)) {
	        return this._isDSTShifted;
	      }
	      var c = {},
	        other;
	      copyConfig(c, this);
	      c = prepareConfig(c);
	      if (c._a) {
	        other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
	        this._isDSTShifted = this.isValid() && compareArrays(c._a, other.toArray()) > 0;
	      } else {
	        this._isDSTShifted = false;
	      }
	      return this._isDSTShifted;
	    }
	    function isLocal() {
	      return this.isValid() ? !this._isUTC : false;
	    }
	    function isUtcOffset() {
	      return this.isValid() ? this._isUTC : false;
	    }
	    function isUtc() {
	      return this.isValid() ? this._isUTC && this._offset === 0 : false;
	    }

	    // ASP.NET json date format regex
	    var aspNetRegex = /^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,
	      // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
	      // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
	      // and further modified to allow for strings containing both week and day
	      isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;
	    function createDuration(input, key) {
	      var duration = input,
	        // matching against regexp is expensive, do it on demand
	        match = null,
	        sign,
	        ret,
	        diffRes;
	      if (isDuration(input)) {
	        duration = {
	          ms: input._milliseconds,
	          d: input._days,
	          M: input._months
	        };
	      } else if (isNumber(input) || !isNaN(+input)) {
	        duration = {};
	        if (key) {
	          duration[key] = +input;
	        } else {
	          duration.milliseconds = +input;
	        }
	      } else if (match = aspNetRegex.exec(input)) {
	        sign = match[1] === '-' ? -1 : 1;
	        duration = {
	          y: 0,
	          d: toInt(match[DATE]) * sign,
	          h: toInt(match[HOUR]) * sign,
	          m: toInt(match[MINUTE]) * sign,
	          s: toInt(match[SECOND]) * sign,
	          ms: toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match
	        };
	      } else if (match = isoRegex.exec(input)) {
	        sign = match[1] === '-' ? -1 : 1;
	        duration = {
	          y: parseIso(match[2], sign),
	          M: parseIso(match[3], sign),
	          w: parseIso(match[4], sign),
	          d: parseIso(match[5], sign),
	          h: parseIso(match[6], sign),
	          m: parseIso(match[7], sign),
	          s: parseIso(match[8], sign)
	        };
	      } else if (duration == null) {
	        // checks for null or undefined
	        duration = {};
	      } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
	        diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));
	        duration = {};
	        duration.ms = diffRes.milliseconds;
	        duration.M = diffRes.months;
	      }
	      ret = new Duration(duration);
	      if (isDuration(input) && hasOwnProp(input, '_locale')) {
	        ret._locale = input._locale;
	      }
	      if (isDuration(input) && hasOwnProp(input, '_isValid')) {
	        ret._isValid = input._isValid;
	      }
	      return ret;
	    }
	    createDuration.fn = Duration.prototype;
	    createDuration.invalid = createInvalid$1;
	    function parseIso(inp, sign) {
	      // We'd normally use ~~inp for this, but unfortunately it also
	      // converts floats to ints.
	      // inp may be undefined, so careful calling replace on it.
	      var res = inp && parseFloat(inp.replace(',', '.'));
	      // apply sign while we're at it
	      return (isNaN(res) ? 0 : res) * sign;
	    }
	    function positiveMomentsDifference(base, other) {
	      var res = {};
	      res.months = other.month() - base.month() + (other.year() - base.year()) * 12;
	      if (base.clone().add(res.months, 'M').isAfter(other)) {
	        --res.months;
	      }
	      res.milliseconds = +other - +base.clone().add(res.months, 'M');
	      return res;
	    }
	    function momentsDifference(base, other) {
	      var res;
	      if (!(base.isValid() && other.isValid())) {
	        return {
	          milliseconds: 0,
	          months: 0
	        };
	      }
	      other = cloneWithOffset(other, base);
	      if (base.isBefore(other)) {
	        res = positiveMomentsDifference(base, other);
	      } else {
	        res = positiveMomentsDifference(other, base);
	        res.milliseconds = -res.milliseconds;
	        res.months = -res.months;
	      }
	      return res;
	    }

	    // TODO: remove 'name' arg after deprecation is removed
	    function createAdder(direction, name) {
	      return function (val, period) {
	        var dur, tmp;
	        //invert the arguments, but complain about it
	        if (period !== null && !isNaN(+period)) {
	          deprecateSimple(name, 'moment().' + name + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' + 'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
	          tmp = val;
	          val = period;
	          period = tmp;
	        }
	        dur = createDuration(val, period);
	        addSubtract(this, dur, direction);
	        return this;
	      };
	    }
	    function addSubtract(mom, duration, isAdding, updateOffset) {
	      var milliseconds = duration._milliseconds,
	        days = absRound(duration._days),
	        months = absRound(duration._months);
	      if (!mom.isValid()) {
	        // No op
	        return;
	      }
	      updateOffset = updateOffset == null ? true : updateOffset;
	      if (months) {
	        setMonth(mom, get(mom, 'Month') + months * isAdding);
	      }
	      if (days) {
	        set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
	      }
	      if (milliseconds) {
	        mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
	      }
	      if (updateOffset) {
	        hooks.updateOffset(mom, days || months);
	      }
	    }
	    var add = createAdder(1, 'add'),
	      subtract = createAdder(-1, 'subtract');
	    function isString(input) {
	      return typeof input === 'string' || input instanceof String;
	    }

	    // type MomentInput = Moment | Date | string | number | (number | string)[] | MomentInputObject | void; // null | undefined
	    function isMomentInput(input) {
	      return isMoment(input) || isDate(input) || isString(input) || isNumber(input) || isNumberOrStringArray(input) || isMomentInputObject(input) || input === null || input === undefined;
	    }
	    function isMomentInputObject(input) {
	      var objectTest = isObject(input) && !isObjectEmpty(input),
	        propertyTest = false,
	        properties = ['years', 'year', 'y', 'months', 'month', 'M', 'days', 'day', 'd', 'dates', 'date', 'D', 'hours', 'hour', 'h', 'minutes', 'minute', 'm', 'seconds', 'second', 's', 'milliseconds', 'millisecond', 'ms'],
	        i,
	        property,
	        propertyLen = properties.length;
	      for (i = 0; i < propertyLen; i += 1) {
	        property = properties[i];
	        propertyTest = propertyTest || hasOwnProp(input, property);
	      }
	      return objectTest && propertyTest;
	    }
	    function isNumberOrStringArray(input) {
	      var arrayTest = isArray(input),
	        dataTypeTest = false;
	      if (arrayTest) {
	        dataTypeTest = input.filter(function (item) {
	          return !isNumber(item) && isString(input);
	        }).length === 0;
	      }
	      return arrayTest && dataTypeTest;
	    }
	    function isCalendarSpec(input) {
	      var objectTest = isObject(input) && !isObjectEmpty(input),
	        propertyTest = false,
	        properties = ['sameDay', 'nextDay', 'lastDay', 'nextWeek', 'lastWeek', 'sameElse'],
	        i,
	        property;
	      for (i = 0; i < properties.length; i += 1) {
	        property = properties[i];
	        propertyTest = propertyTest || hasOwnProp(input, property);
	      }
	      return objectTest && propertyTest;
	    }
	    function getCalendarFormat(myMoment, now) {
	      var diff = myMoment.diff(now, 'days', true);
	      return diff < -6 ? 'sameElse' : diff < -1 ? 'lastWeek' : diff < 0 ? 'lastDay' : diff < 1 ? 'sameDay' : diff < 2 ? 'nextDay' : diff < 7 ? 'nextWeek' : 'sameElse';
	    }
	    function calendar$1(time, formats) {
	      // Support for single parameter, formats only overload to the calendar function
	      if (arguments.length === 1) {
	        if (!arguments[0]) {
	          time = undefined;
	          formats = undefined;
	        } else if (isMomentInput(arguments[0])) {
	          time = arguments[0];
	          formats = undefined;
	        } else if (isCalendarSpec(arguments[0])) {
	          formats = arguments[0];
	          time = undefined;
	        }
	      }
	      // We want to compare the start of today, vs this.
	      // Getting start-of-today depends on whether we're local/utc/offset or not.
	      var now = time || createLocal(),
	        sod = cloneWithOffset(now, this).startOf('day'),
	        format = hooks.calendarFormat(this, sod) || 'sameElse',
	        output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);
	      return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
	    }
	    function clone() {
	      return new Moment(this);
	    }
	    function isAfter(input, units) {
	      var localInput = isMoment(input) ? input : createLocal(input);
	      if (!(this.isValid() && localInput.isValid())) {
	        return false;
	      }
	      units = normalizeUnits(units) || 'millisecond';
	      if (units === 'millisecond') {
	        return this.valueOf() > localInput.valueOf();
	      } else {
	        return localInput.valueOf() < this.clone().startOf(units).valueOf();
	      }
	    }
	    function isBefore(input, units) {
	      var localInput = isMoment(input) ? input : createLocal(input);
	      if (!(this.isValid() && localInput.isValid())) {
	        return false;
	      }
	      units = normalizeUnits(units) || 'millisecond';
	      if (units === 'millisecond') {
	        return this.valueOf() < localInput.valueOf();
	      } else {
	        return this.clone().endOf(units).valueOf() < localInput.valueOf();
	      }
	    }
	    function isBetween(from, to, units, inclusivity) {
	      var localFrom = isMoment(from) ? from : createLocal(from),
	        localTo = isMoment(to) ? to : createLocal(to);
	      if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
	        return false;
	      }
	      inclusivity = inclusivity || '()';
	      return (inclusivity[0] === '(' ? this.isAfter(localFrom, units) : !this.isBefore(localFrom, units)) && (inclusivity[1] === ')' ? this.isBefore(localTo, units) : !this.isAfter(localTo, units));
	    }
	    function isSame(input, units) {
	      var localInput = isMoment(input) ? input : createLocal(input),
	        inputMs;
	      if (!(this.isValid() && localInput.isValid())) {
	        return false;
	      }
	      units = normalizeUnits(units) || 'millisecond';
	      if (units === 'millisecond') {
	        return this.valueOf() === localInput.valueOf();
	      } else {
	        inputMs = localInput.valueOf();
	        return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
	      }
	    }
	    function isSameOrAfter(input, units) {
	      return this.isSame(input, units) || this.isAfter(input, units);
	    }
	    function isSameOrBefore(input, units) {
	      return this.isSame(input, units) || this.isBefore(input, units);
	    }
	    function diff(input, units, asFloat) {
	      var that, zoneDelta, output;
	      if (!this.isValid()) {
	        return NaN;
	      }
	      that = cloneWithOffset(input, this);
	      if (!that.isValid()) {
	        return NaN;
	      }
	      zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;
	      units = normalizeUnits(units);
	      switch (units) {
	        case 'year':
	          output = monthDiff(this, that) / 12;
	          break;
	        case 'month':
	          output = monthDiff(this, that);
	          break;
	        case 'quarter':
	          output = monthDiff(this, that) / 3;
	          break;
	        case 'second':
	          output = (this - that) / 1e3;
	          break;
	        // 1000
	        case 'minute':
	          output = (this - that) / 6e4;
	          break;
	        // 1000 * 60
	        case 'hour':
	          output = (this - that) / 36e5;
	          break;
	        // 1000 * 60 * 60
	        case 'day':
	          output = (this - that - zoneDelta) / 864e5;
	          break;
	        // 1000 * 60 * 60 * 24, negate dst
	        case 'week':
	          output = (this - that - zoneDelta) / 6048e5;
	          break;
	        // 1000 * 60 * 60 * 24 * 7, negate dst
	        default:
	          output = this - that;
	      }
	      return asFloat ? output : absFloor(output);
	    }
	    function monthDiff(a, b) {
	      if (a.date() < b.date()) {
	        // end-of-month calculations work correct when the start month has more
	        // days than the end month.
	        return -monthDiff(b, a);
	      }
	      // difference in months
	      var wholeMonthDiff = (b.year() - a.year()) * 12 + (b.month() - a.month()),
	        // b is in (anchor - 1 month, anchor + 1 month)
	        anchor = a.clone().add(wholeMonthDiff, 'months'),
	        anchor2,
	        adjust;
	      if (b - anchor < 0) {
	        anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
	        // linear across the month
	        adjust = (b - anchor) / (anchor - anchor2);
	      } else {
	        anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
	        // linear across the month
	        adjust = (b - anchor) / (anchor2 - anchor);
	      }

	      //check for negative zero, return zero if negative zero
	      return -(wholeMonthDiff + adjust) || 0;
	    }
	    hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
	    hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';
	    function toString() {
	      return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
	    }
	    function toISOString(keepOffset) {
	      if (!this.isValid()) {
	        return null;
	      }
	      var utc = keepOffset !== true,
	        m = utc ? this.clone().utc() : this;
	      if (m.year() < 0 || m.year() > 9999) {
	        return formatMoment(m, utc ? 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');
	      }
	      if (isFunction(Date.prototype.toISOString)) {
	        // native implementation is ~50x faster, use it when we can
	        if (utc) {
	          return this.toDate().toISOString();
	        } else {
	          return new Date(this.valueOf() + this.utcOffset() * 60 * 1000).toISOString().replace('Z', formatMoment(m, 'Z'));
	        }
	      }
	      return formatMoment(m, utc ? 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYY-MM-DD[T]HH:mm:ss.SSSZ');
	    }

	    /**
	     * Return a human readable representation of a moment that can
	     * also be evaluated to get a new moment which is the same
	     *
	     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
	     */
	    function inspect() {
	      if (!this.isValid()) {
	        return 'moment.invalid(/* ' + this._i + ' */)';
	      }
	      var func = 'moment',
	        zone = '',
	        prefix,
	        year,
	        datetime,
	        suffix;
	      if (!this.isLocal()) {
	        func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
	        zone = 'Z';
	      }
	      prefix = '[' + func + '("]';
	      year = 0 <= this.year() && this.year() <= 9999 ? 'YYYY' : 'YYYYYY';
	      datetime = '-MM-DD[T]HH:mm:ss.SSS';
	      suffix = zone + '[")]';
	      return this.format(prefix + year + datetime + suffix);
	    }
	    function format(inputString) {
	      if (!inputString) {
	        inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
	      }
	      var output = formatMoment(this, inputString);
	      return this.localeData().postformat(output);
	    }
	    function from(time, withoutSuffix) {
	      if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
	        return createDuration({
	          to: this,
	          from: time
	        }).locale(this.locale()).humanize(!withoutSuffix);
	      } else {
	        return this.localeData().invalidDate();
	      }
	    }
	    function fromNow(withoutSuffix) {
	      return this.from(createLocal(), withoutSuffix);
	    }
	    function to(time, withoutSuffix) {
	      if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
	        return createDuration({
	          from: this,
	          to: time
	        }).locale(this.locale()).humanize(!withoutSuffix);
	      } else {
	        return this.localeData().invalidDate();
	      }
	    }
	    function toNow(withoutSuffix) {
	      return this.to(createLocal(), withoutSuffix);
	    }

	    // If passed a locale key, it will set the locale for this
	    // instance.  Otherwise, it will return the locale configuration
	    // variables for this instance.
	    function locale(key) {
	      var newLocaleData;
	      if (key === undefined) {
	        return this._locale._abbr;
	      } else {
	        newLocaleData = getLocale(key);
	        if (newLocaleData != null) {
	          this._locale = newLocaleData;
	        }
	        return this;
	      }
	    }
	    var lang = deprecate('moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.', function (key) {
	      if (key === undefined) {
	        return this.localeData();
	      } else {
	        return this.locale(key);
	      }
	    });
	    function localeData() {
	      return this._locale;
	    }
	    var MS_PER_SECOND = 1000,
	      MS_PER_MINUTE = 60 * MS_PER_SECOND,
	      MS_PER_HOUR = 60 * MS_PER_MINUTE,
	      MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR;

	    // actual modulo - handles negative numbers (for dates before 1970):
	    function mod$1(dividend, divisor) {
	      return (dividend % divisor + divisor) % divisor;
	    }
	    function localStartOfDate(y, m, d) {
	      // the date constructor remaps years 0-99 to 1900-1999
	      if (y < 100 && y >= 0) {
	        // preserve leap years using a full 400 year cycle, then reset
	        return new Date(y + 400, m, d) - MS_PER_400_YEARS;
	      } else {
	        return new Date(y, m, d).valueOf();
	      }
	    }
	    function utcStartOfDate(y, m, d) {
	      // Date.UTC remaps years 0-99 to 1900-1999
	      if (y < 100 && y >= 0) {
	        // preserve leap years using a full 400 year cycle, then reset
	        return Date.UTC(y + 400, m, d) - MS_PER_400_YEARS;
	      } else {
	        return Date.UTC(y, m, d);
	      }
	    }
	    function startOf(units) {
	      var time, startOfDate;
	      units = normalizeUnits(units);
	      if (units === undefined || units === 'millisecond' || !this.isValid()) {
	        return this;
	      }
	      startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
	      switch (units) {
	        case 'year':
	          time = startOfDate(this.year(), 0, 1);
	          break;
	        case 'quarter':
	          time = startOfDate(this.year(), this.month() - this.month() % 3, 1);
	          break;
	        case 'month':
	          time = startOfDate(this.year(), this.month(), 1);
	          break;
	        case 'week':
	          time = startOfDate(this.year(), this.month(), this.date() - this.weekday());
	          break;
	        case 'isoWeek':
	          time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1));
	          break;
	        case 'day':
	        case 'date':
	          time = startOfDate(this.year(), this.month(), this.date());
	          break;
	        case 'hour':
	          time = this._d.valueOf();
	          time -= mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR);
	          break;
	        case 'minute':
	          time = this._d.valueOf();
	          time -= mod$1(time, MS_PER_MINUTE);
	          break;
	        case 'second':
	          time = this._d.valueOf();
	          time -= mod$1(time, MS_PER_SECOND);
	          break;
	      }
	      this._d.setTime(time);
	      hooks.updateOffset(this, true);
	      return this;
	    }
	    function endOf(units) {
	      var time, startOfDate;
	      units = normalizeUnits(units);
	      if (units === undefined || units === 'millisecond' || !this.isValid()) {
	        return this;
	      }
	      startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
	      switch (units) {
	        case 'year':
	          time = startOfDate(this.year() + 1, 0, 1) - 1;
	          break;
	        case 'quarter':
	          time = startOfDate(this.year(), this.month() - this.month() % 3 + 3, 1) - 1;
	          break;
	        case 'month':
	          time = startOfDate(this.year(), this.month() + 1, 1) - 1;
	          break;
	        case 'week':
	          time = startOfDate(this.year(), this.month(), this.date() - this.weekday() + 7) - 1;
	          break;
	        case 'isoWeek':
	          time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1) + 7) - 1;
	          break;
	        case 'day':
	        case 'date':
	          time = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
	          break;
	        case 'hour':
	          time = this._d.valueOf();
	          time += MS_PER_HOUR - mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR) - 1;
	          break;
	        case 'minute':
	          time = this._d.valueOf();
	          time += MS_PER_MINUTE - mod$1(time, MS_PER_MINUTE) - 1;
	          break;
	        case 'second':
	          time = this._d.valueOf();
	          time += MS_PER_SECOND - mod$1(time, MS_PER_SECOND) - 1;
	          break;
	      }
	      this._d.setTime(time);
	      hooks.updateOffset(this, true);
	      return this;
	    }
	    function valueOf() {
	      return this._d.valueOf() - (this._offset || 0) * 60000;
	    }
	    function unix() {
	      return Math.floor(this.valueOf() / 1000);
	    }
	    function toDate() {
	      return new Date(this.valueOf());
	    }
	    function toArray() {
	      var m = this;
	      return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
	    }
	    function toObject() {
	      var m = this;
	      return {
	        years: m.year(),
	        months: m.month(),
	        date: m.date(),
	        hours: m.hours(),
	        minutes: m.minutes(),
	        seconds: m.seconds(),
	        milliseconds: m.milliseconds()
	      };
	    }
	    function toJSON() {
	      // new Date(NaN).toJSON() === null
	      return this.isValid() ? this.toISOString() : null;
	    }
	    function isValid$2() {
	      return isValid(this);
	    }
	    function parsingFlags() {
	      return extend({}, getParsingFlags(this));
	    }
	    function invalidAt() {
	      return getParsingFlags(this).overflow;
	    }
	    function creationData() {
	      return {
	        input: this._i,
	        format: this._f,
	        locale: this._locale,
	        isUTC: this._isUTC,
	        strict: this._strict
	      };
	    }
	    addFormatToken('N', 0, 0, 'eraAbbr');
	    addFormatToken('NN', 0, 0, 'eraAbbr');
	    addFormatToken('NNN', 0, 0, 'eraAbbr');
	    addFormatToken('NNNN', 0, 0, 'eraName');
	    addFormatToken('NNNNN', 0, 0, 'eraNarrow');
	    addFormatToken('y', ['y', 1], 'yo', 'eraYear');
	    addFormatToken('y', ['yy', 2], 0, 'eraYear');
	    addFormatToken('y', ['yyy', 3], 0, 'eraYear');
	    addFormatToken('y', ['yyyy', 4], 0, 'eraYear');
	    addRegexToken('N', matchEraAbbr);
	    addRegexToken('NN', matchEraAbbr);
	    addRegexToken('NNN', matchEraAbbr);
	    addRegexToken('NNNN', matchEraName);
	    addRegexToken('NNNNN', matchEraNarrow);
	    addParseToken(['N', 'NN', 'NNN', 'NNNN', 'NNNNN'], function (input, array, config, token) {
	      var era = config._locale.erasParse(input, token, config._strict);
	      if (era) {
	        getParsingFlags(config).era = era;
	      } else {
	        getParsingFlags(config).invalidEra = input;
	      }
	    });
	    addRegexToken('y', matchUnsigned);
	    addRegexToken('yy', matchUnsigned);
	    addRegexToken('yyy', matchUnsigned);
	    addRegexToken('yyyy', matchUnsigned);
	    addRegexToken('yo', matchEraYearOrdinal);
	    addParseToken(['y', 'yy', 'yyy', 'yyyy'], YEAR);
	    addParseToken(['yo'], function (input, array, config, token) {
	      var match;
	      if (config._locale._eraYearOrdinalRegex) {
	        match = input.match(config._locale._eraYearOrdinalRegex);
	      }
	      if (config._locale.eraYearOrdinalParse) {
	        array[YEAR] = config._locale.eraYearOrdinalParse(input, match);
	      } else {
	        array[YEAR] = parseInt(input, 10);
	      }
	    });
	    function localeEras(m, format) {
	      var i,
	        l,
	        date,
	        eras = this._eras || getLocale('en')._eras;
	      for (i = 0, l = eras.length; i < l; ++i) {
	        switch (typeof eras[i].since) {
	          case 'string':
	            // truncate time
	            date = hooks(eras[i].since).startOf('day');
	            eras[i].since = date.valueOf();
	            break;
	        }
	        switch (typeof eras[i].until) {
	          case 'undefined':
	            eras[i].until = +Infinity;
	            break;
	          case 'string':
	            // truncate time
	            date = hooks(eras[i].until).startOf('day').valueOf();
	            eras[i].until = date.valueOf();
	            break;
	        }
	      }
	      return eras;
	    }
	    function localeErasParse(eraName, format, strict) {
	      var i,
	        l,
	        eras = this.eras(),
	        name,
	        abbr,
	        narrow;
	      eraName = eraName.toUpperCase();
	      for (i = 0, l = eras.length; i < l; ++i) {
	        name = eras[i].name.toUpperCase();
	        abbr = eras[i].abbr.toUpperCase();
	        narrow = eras[i].narrow.toUpperCase();
	        if (strict) {
	          switch (format) {
	            case 'N':
	            case 'NN':
	            case 'NNN':
	              if (abbr === eraName) {
	                return eras[i];
	              }
	              break;
	            case 'NNNN':
	              if (name === eraName) {
	                return eras[i];
	              }
	              break;
	            case 'NNNNN':
	              if (narrow === eraName) {
	                return eras[i];
	              }
	              break;
	          }
	        } else if ([name, abbr, narrow].indexOf(eraName) >= 0) {
	          return eras[i];
	        }
	      }
	    }
	    function localeErasConvertYear(era, year) {
	      var dir = era.since <= era.until ? +1 : -1;
	      if (year === undefined) {
	        return hooks(era.since).year();
	      } else {
	        return hooks(era.since).year() + (year - era.offset) * dir;
	      }
	    }
	    function getEraName() {
	      var i,
	        l,
	        val,
	        eras = this.localeData().eras();
	      for (i = 0, l = eras.length; i < l; ++i) {
	        // truncate time
	        val = this.clone().startOf('day').valueOf();
	        if (eras[i].since <= val && val <= eras[i].until) {
	          return eras[i].name;
	        }
	        if (eras[i].until <= val && val <= eras[i].since) {
	          return eras[i].name;
	        }
	      }
	      return '';
	    }
	    function getEraNarrow() {
	      var i,
	        l,
	        val,
	        eras = this.localeData().eras();
	      for (i = 0, l = eras.length; i < l; ++i) {
	        // truncate time
	        val = this.clone().startOf('day').valueOf();
	        if (eras[i].since <= val && val <= eras[i].until) {
	          return eras[i].narrow;
	        }
	        if (eras[i].until <= val && val <= eras[i].since) {
	          return eras[i].narrow;
	        }
	      }
	      return '';
	    }
	    function getEraAbbr() {
	      var i,
	        l,
	        val,
	        eras = this.localeData().eras();
	      for (i = 0, l = eras.length; i < l; ++i) {
	        // truncate time
	        val = this.clone().startOf('day').valueOf();
	        if (eras[i].since <= val && val <= eras[i].until) {
	          return eras[i].abbr;
	        }
	        if (eras[i].until <= val && val <= eras[i].since) {
	          return eras[i].abbr;
	        }
	      }
	      return '';
	    }
	    function getEraYear() {
	      var i,
	        l,
	        dir,
	        val,
	        eras = this.localeData().eras();
	      for (i = 0, l = eras.length; i < l; ++i) {
	        dir = eras[i].since <= eras[i].until ? +1 : -1;

	        // truncate time
	        val = this.clone().startOf('day').valueOf();
	        if (eras[i].since <= val && val <= eras[i].until || eras[i].until <= val && val <= eras[i].since) {
	          return (this.year() - hooks(eras[i].since).year()) * dir + eras[i].offset;
	        }
	      }
	      return this.year();
	    }
	    function erasNameRegex(isStrict) {
	      if (!hasOwnProp(this, '_erasNameRegex')) {
	        computeErasParse.call(this);
	      }
	      return isStrict ? this._erasNameRegex : this._erasRegex;
	    }
	    function erasAbbrRegex(isStrict) {
	      if (!hasOwnProp(this, '_erasAbbrRegex')) {
	        computeErasParse.call(this);
	      }
	      return isStrict ? this._erasAbbrRegex : this._erasRegex;
	    }
	    function erasNarrowRegex(isStrict) {
	      if (!hasOwnProp(this, '_erasNarrowRegex')) {
	        computeErasParse.call(this);
	      }
	      return isStrict ? this._erasNarrowRegex : this._erasRegex;
	    }
	    function matchEraAbbr(isStrict, locale) {
	      return locale.erasAbbrRegex(isStrict);
	    }
	    function matchEraName(isStrict, locale) {
	      return locale.erasNameRegex(isStrict);
	    }
	    function matchEraNarrow(isStrict, locale) {
	      return locale.erasNarrowRegex(isStrict);
	    }
	    function matchEraYearOrdinal(isStrict, locale) {
	      return locale._eraYearOrdinalRegex || matchUnsigned;
	    }
	    function computeErasParse() {
	      var abbrPieces = [],
	        namePieces = [],
	        narrowPieces = [],
	        mixedPieces = [],
	        i,
	        l,
	        eras = this.eras();
	      for (i = 0, l = eras.length; i < l; ++i) {
	        namePieces.push(regexEscape(eras[i].name));
	        abbrPieces.push(regexEscape(eras[i].abbr));
	        narrowPieces.push(regexEscape(eras[i].narrow));
	        mixedPieces.push(regexEscape(eras[i].name));
	        mixedPieces.push(regexEscape(eras[i].abbr));
	        mixedPieces.push(regexEscape(eras[i].narrow));
	      }
	      this._erasRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	      this._erasNameRegex = new RegExp('^(' + namePieces.join('|') + ')', 'i');
	      this._erasAbbrRegex = new RegExp('^(' + abbrPieces.join('|') + ')', 'i');
	      this._erasNarrowRegex = new RegExp('^(' + narrowPieces.join('|') + ')', 'i');
	    }

	    // FORMATTING

	    addFormatToken(0, ['gg', 2], 0, function () {
	      return this.weekYear() % 100;
	    });
	    addFormatToken(0, ['GG', 2], 0, function () {
	      return this.isoWeekYear() % 100;
	    });
	    function addWeekYearFormatToken(token, getter) {
	      addFormatToken(0, [token, token.length], 0, getter);
	    }
	    addWeekYearFormatToken('gggg', 'weekYear');
	    addWeekYearFormatToken('ggggg', 'weekYear');
	    addWeekYearFormatToken('GGGG', 'isoWeekYear');
	    addWeekYearFormatToken('GGGGG', 'isoWeekYear');

	    // ALIASES

	    addUnitAlias('weekYear', 'gg');
	    addUnitAlias('isoWeekYear', 'GG');

	    // PRIORITY

	    addUnitPriority('weekYear', 1);
	    addUnitPriority('isoWeekYear', 1);

	    // PARSING

	    addRegexToken('G', matchSigned);
	    addRegexToken('g', matchSigned);
	    addRegexToken('GG', match1to2, match2);
	    addRegexToken('gg', match1to2, match2);
	    addRegexToken('GGGG', match1to4, match4);
	    addRegexToken('gggg', match1to4, match4);
	    addRegexToken('GGGGG', match1to6, match6);
	    addRegexToken('ggggg', match1to6, match6);
	    addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
	      week[token.substr(0, 2)] = toInt(input);
	    });
	    addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
	      week[token] = hooks.parseTwoDigitYear(input);
	    });

	    // MOMENTS

	    function getSetWeekYear(input) {
	      return getSetWeekYearHelper.call(this, input, this.week(), this.weekday(), this.localeData()._week.dow, this.localeData()._week.doy);
	    }
	    function getSetISOWeekYear(input) {
	      return getSetWeekYearHelper.call(this, input, this.isoWeek(), this.isoWeekday(), 1, 4);
	    }
	    function getISOWeeksInYear() {
	      return weeksInYear(this.year(), 1, 4);
	    }
	    function getISOWeeksInISOWeekYear() {
	      return weeksInYear(this.isoWeekYear(), 1, 4);
	    }
	    function getWeeksInYear() {
	      var weekInfo = this.localeData()._week;
	      return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
	    }
	    function getWeeksInWeekYear() {
	      var weekInfo = this.localeData()._week;
	      return weeksInYear(this.weekYear(), weekInfo.dow, weekInfo.doy);
	    }
	    function getSetWeekYearHelper(input, week, weekday, dow, doy) {
	      var weeksTarget;
	      if (input == null) {
	        return weekOfYear(this, dow, doy).year;
	      } else {
	        weeksTarget = weeksInYear(input, dow, doy);
	        if (week > weeksTarget) {
	          week = weeksTarget;
	        }
	        return setWeekAll.call(this, input, week, weekday, dow, doy);
	      }
	    }
	    function setWeekAll(weekYear, week, weekday, dow, doy) {
	      var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
	        date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);
	      this.year(date.getUTCFullYear());
	      this.month(date.getUTCMonth());
	      this.date(date.getUTCDate());
	      return this;
	    }

	    // FORMATTING

	    addFormatToken('Q', 0, 'Qo', 'quarter');

	    // ALIASES

	    addUnitAlias('quarter', 'Q');

	    // PRIORITY

	    addUnitPriority('quarter', 7);

	    // PARSING

	    addRegexToken('Q', match1);
	    addParseToken('Q', function (input, array) {
	      array[MONTH] = (toInt(input) - 1) * 3;
	    });

	    // MOMENTS

	    function getSetQuarter(input) {
	      return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
	    }

	    // FORMATTING

	    addFormatToken('D', ['DD', 2], 'Do', 'date');

	    // ALIASES

	    addUnitAlias('date', 'D');

	    // PRIORITY
	    addUnitPriority('date', 9);

	    // PARSING

	    addRegexToken('D', match1to2);
	    addRegexToken('DD', match1to2, match2);
	    addRegexToken('Do', function (isStrict, locale) {
	      // TODO: Remove "ordinalParse" fallback in next major release.
	      return isStrict ? locale._dayOfMonthOrdinalParse || locale._ordinalParse : locale._dayOfMonthOrdinalParseLenient;
	    });
	    addParseToken(['D', 'DD'], DATE);
	    addParseToken('Do', function (input, array) {
	      array[DATE] = toInt(input.match(match1to2)[0]);
	    });

	    // MOMENTS

	    var getSetDayOfMonth = makeGetSet('Date', true);

	    // FORMATTING

	    addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

	    // ALIASES

	    addUnitAlias('dayOfYear', 'DDD');

	    // PRIORITY
	    addUnitPriority('dayOfYear', 4);

	    // PARSING

	    addRegexToken('DDD', match1to3);
	    addRegexToken('DDDD', match3);
	    addParseToken(['DDD', 'DDDD'], function (input, array, config) {
	      config._dayOfYear = toInt(input);
	    });

	    // HELPERS

	    // MOMENTS

	    function getSetDayOfYear(input) {
	      var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
	      return input == null ? dayOfYear : this.add(input - dayOfYear, 'd');
	    }

	    // FORMATTING

	    addFormatToken('m', ['mm', 2], 0, 'minute');

	    // ALIASES

	    addUnitAlias('minute', 'm');

	    // PRIORITY

	    addUnitPriority('minute', 14);

	    // PARSING

	    addRegexToken('m', match1to2);
	    addRegexToken('mm', match1to2, match2);
	    addParseToken(['m', 'mm'], MINUTE);

	    // MOMENTS

	    var getSetMinute = makeGetSet('Minutes', false);

	    // FORMATTING

	    addFormatToken('s', ['ss', 2], 0, 'second');

	    // ALIASES

	    addUnitAlias('second', 's');

	    // PRIORITY

	    addUnitPriority('second', 15);

	    // PARSING

	    addRegexToken('s', match1to2);
	    addRegexToken('ss', match1to2, match2);
	    addParseToken(['s', 'ss'], SECOND);

	    // MOMENTS

	    var getSetSecond = makeGetSet('Seconds', false);

	    // FORMATTING

	    addFormatToken('S', 0, 0, function () {
	      return ~~(this.millisecond() / 100);
	    });
	    addFormatToken(0, ['SS', 2], 0, function () {
	      return ~~(this.millisecond() / 10);
	    });
	    addFormatToken(0, ['SSS', 3], 0, 'millisecond');
	    addFormatToken(0, ['SSSS', 4], 0, function () {
	      return this.millisecond() * 10;
	    });
	    addFormatToken(0, ['SSSSS', 5], 0, function () {
	      return this.millisecond() * 100;
	    });
	    addFormatToken(0, ['SSSSSS', 6], 0, function () {
	      return this.millisecond() * 1000;
	    });
	    addFormatToken(0, ['SSSSSSS', 7], 0, function () {
	      return this.millisecond() * 10000;
	    });
	    addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
	      return this.millisecond() * 100000;
	    });
	    addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
	      return this.millisecond() * 1000000;
	    });

	    // ALIASES

	    addUnitAlias('millisecond', 'ms');

	    // PRIORITY

	    addUnitPriority('millisecond', 16);

	    // PARSING

	    addRegexToken('S', match1to3, match1);
	    addRegexToken('SS', match1to3, match2);
	    addRegexToken('SSS', match1to3, match3);
	    var token, getSetMillisecond;
	    for (token = 'SSSS'; token.length <= 9; token += 'S') {
	      addRegexToken(token, matchUnsigned);
	    }
	    function parseMs(input, array) {
	      array[MILLISECOND] = toInt(('0.' + input) * 1000);
	    }
	    for (token = 'S'; token.length <= 9; token += 'S') {
	      addParseToken(token, parseMs);
	    }
	    getSetMillisecond = makeGetSet('Milliseconds', false);

	    // FORMATTING

	    addFormatToken('z', 0, 0, 'zoneAbbr');
	    addFormatToken('zz', 0, 0, 'zoneName');

	    // MOMENTS

	    function getZoneAbbr() {
	      return this._isUTC ? 'UTC' : '';
	    }
	    function getZoneName() {
	      return this._isUTC ? 'Coordinated Universal Time' : '';
	    }
	    var proto = Moment.prototype;
	    proto.add = add;
	    proto.calendar = calendar$1;
	    proto.clone = clone;
	    proto.diff = diff;
	    proto.endOf = endOf;
	    proto.format = format;
	    proto.from = from;
	    proto.fromNow = fromNow;
	    proto.to = to;
	    proto.toNow = toNow;
	    proto.get = stringGet;
	    proto.invalidAt = invalidAt;
	    proto.isAfter = isAfter;
	    proto.isBefore = isBefore;
	    proto.isBetween = isBetween;
	    proto.isSame = isSame;
	    proto.isSameOrAfter = isSameOrAfter;
	    proto.isSameOrBefore = isSameOrBefore;
	    proto.isValid = isValid$2;
	    proto.lang = lang;
	    proto.locale = locale;
	    proto.localeData = localeData;
	    proto.max = prototypeMax;
	    proto.min = prototypeMin;
	    proto.parsingFlags = parsingFlags;
	    proto.set = stringSet;
	    proto.startOf = startOf;
	    proto.subtract = subtract;
	    proto.toArray = toArray;
	    proto.toObject = toObject;
	    proto.toDate = toDate;
	    proto.toISOString = toISOString;
	    proto.inspect = inspect;
	    if (typeof Symbol !== 'undefined' && Symbol.for != null) {
	      proto[Symbol.for('nodejs.util.inspect.custom')] = function () {
	        return 'Moment<' + this.format() + '>';
	      };
	    }
	    proto.toJSON = toJSON;
	    proto.toString = toString;
	    proto.unix = unix;
	    proto.valueOf = valueOf;
	    proto.creationData = creationData;
	    proto.eraName = getEraName;
	    proto.eraNarrow = getEraNarrow;
	    proto.eraAbbr = getEraAbbr;
	    proto.eraYear = getEraYear;
	    proto.year = getSetYear;
	    proto.isLeapYear = getIsLeapYear;
	    proto.weekYear = getSetWeekYear;
	    proto.isoWeekYear = getSetISOWeekYear;
	    proto.quarter = proto.quarters = getSetQuarter;
	    proto.month = getSetMonth;
	    proto.daysInMonth = getDaysInMonth;
	    proto.week = proto.weeks = getSetWeek;
	    proto.isoWeek = proto.isoWeeks = getSetISOWeek;
	    proto.weeksInYear = getWeeksInYear;
	    proto.weeksInWeekYear = getWeeksInWeekYear;
	    proto.isoWeeksInYear = getISOWeeksInYear;
	    proto.isoWeeksInISOWeekYear = getISOWeeksInISOWeekYear;
	    proto.date = getSetDayOfMonth;
	    proto.day = proto.days = getSetDayOfWeek;
	    proto.weekday = getSetLocaleDayOfWeek;
	    proto.isoWeekday = getSetISODayOfWeek;
	    proto.dayOfYear = getSetDayOfYear;
	    proto.hour = proto.hours = getSetHour;
	    proto.minute = proto.minutes = getSetMinute;
	    proto.second = proto.seconds = getSetSecond;
	    proto.millisecond = proto.milliseconds = getSetMillisecond;
	    proto.utcOffset = getSetOffset;
	    proto.utc = setOffsetToUTC;
	    proto.local = setOffsetToLocal;
	    proto.parseZone = setOffsetToParsedOffset;
	    proto.hasAlignedHourOffset = hasAlignedHourOffset;
	    proto.isDST = isDaylightSavingTime;
	    proto.isLocal = isLocal;
	    proto.isUtcOffset = isUtcOffset;
	    proto.isUtc = isUtc;
	    proto.isUTC = isUtc;
	    proto.zoneAbbr = getZoneAbbr;
	    proto.zoneName = getZoneName;
	    proto.dates = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
	    proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
	    proto.years = deprecate('years accessor is deprecated. Use year instead', getSetYear);
	    proto.zone = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
	    proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);
	    function createUnix(input) {
	      return createLocal(input * 1000);
	    }
	    function createInZone() {
	      return createLocal.apply(null, arguments).parseZone();
	    }
	    function preParsePostFormat(string) {
	      return string;
	    }
	    var proto$1 = Locale.prototype;
	    proto$1.calendar = calendar;
	    proto$1.longDateFormat = longDateFormat;
	    proto$1.invalidDate = invalidDate;
	    proto$1.ordinal = ordinal;
	    proto$1.preparse = preParsePostFormat;
	    proto$1.postformat = preParsePostFormat;
	    proto$1.relativeTime = relativeTime;
	    proto$1.pastFuture = pastFuture;
	    proto$1.set = set;
	    proto$1.eras = localeEras;
	    proto$1.erasParse = localeErasParse;
	    proto$1.erasConvertYear = localeErasConvertYear;
	    proto$1.erasAbbrRegex = erasAbbrRegex;
	    proto$1.erasNameRegex = erasNameRegex;
	    proto$1.erasNarrowRegex = erasNarrowRegex;
	    proto$1.months = localeMonths;
	    proto$1.monthsShort = localeMonthsShort;
	    proto$1.monthsParse = localeMonthsParse;
	    proto$1.monthsRegex = monthsRegex;
	    proto$1.monthsShortRegex = monthsShortRegex;
	    proto$1.week = localeWeek;
	    proto$1.firstDayOfYear = localeFirstDayOfYear;
	    proto$1.firstDayOfWeek = localeFirstDayOfWeek;
	    proto$1.weekdays = localeWeekdays;
	    proto$1.weekdaysMin = localeWeekdaysMin;
	    proto$1.weekdaysShort = localeWeekdaysShort;
	    proto$1.weekdaysParse = localeWeekdaysParse;
	    proto$1.weekdaysRegex = weekdaysRegex;
	    proto$1.weekdaysShortRegex = weekdaysShortRegex;
	    proto$1.weekdaysMinRegex = weekdaysMinRegex;
	    proto$1.isPM = localeIsPM;
	    proto$1.meridiem = localeMeridiem;
	    function get$1(format, index, field, setter) {
	      var locale = getLocale(),
	        utc = createUTC().set(setter, index);
	      return locale[field](utc, format);
	    }
	    function listMonthsImpl(format, index, field) {
	      if (isNumber(format)) {
	        index = format;
	        format = undefined;
	      }
	      format = format || '';
	      if (index != null) {
	        return get$1(format, index, field, 'month');
	      }
	      var i,
	        out = [];
	      for (i = 0; i < 12; i++) {
	        out[i] = get$1(format, i, field, 'month');
	      }
	      return out;
	    }

	    // ()
	    // (5)
	    // (fmt, 5)
	    // (fmt)
	    // (true)
	    // (true, 5)
	    // (true, fmt, 5)
	    // (true, fmt)
	    function listWeekdaysImpl(localeSorted, format, index, field) {
	      if (typeof localeSorted === 'boolean') {
	        if (isNumber(format)) {
	          index = format;
	          format = undefined;
	        }
	        format = format || '';
	      } else {
	        format = localeSorted;
	        index = format;
	        localeSorted = false;
	        if (isNumber(format)) {
	          index = format;
	          format = undefined;
	        }
	        format = format || '';
	      }
	      var locale = getLocale(),
	        shift = localeSorted ? locale._week.dow : 0,
	        i,
	        out = [];
	      if (index != null) {
	        return get$1(format, (index + shift) % 7, field, 'day');
	      }
	      for (i = 0; i < 7; i++) {
	        out[i] = get$1(format, (i + shift) % 7, field, 'day');
	      }
	      return out;
	    }
	    function listMonths(format, index) {
	      return listMonthsImpl(format, index, 'months');
	    }
	    function listMonthsShort(format, index) {
	      return listMonthsImpl(format, index, 'monthsShort');
	    }
	    function listWeekdays(localeSorted, format, index) {
	      return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
	    }
	    function listWeekdaysShort(localeSorted, format, index) {
	      return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
	    }
	    function listWeekdaysMin(localeSorted, format, index) {
	      return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
	    }
	    getSetGlobalLocale('en', {
	      eras: [{
	        since: '0001-01-01',
	        until: +Infinity,
	        offset: 1,
	        name: 'Anno Domini',
	        narrow: 'AD',
	        abbr: 'AD'
	      }, {
	        since: '0000-12-31',
	        until: -Infinity,
	        offset: 1,
	        name: 'Before Christ',
	        narrow: 'BC',
	        abbr: 'BC'
	      }],
	      dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
	      ordinal: function (number) {
	        var b = number % 10,
	          output = toInt(number % 100 / 10) === 1 ? 'th' : b === 1 ? 'st' : b === 2 ? 'nd' : b === 3 ? 'rd' : 'th';
	        return number + output;
	      }
	    });

	    // Side effect imports

	    hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
	    hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);
	    var mathAbs = Math.abs;
	    function abs() {
	      var data = this._data;
	      this._milliseconds = mathAbs(this._milliseconds);
	      this._days = mathAbs(this._days);
	      this._months = mathAbs(this._months);
	      data.milliseconds = mathAbs(data.milliseconds);
	      data.seconds = mathAbs(data.seconds);
	      data.minutes = mathAbs(data.minutes);
	      data.hours = mathAbs(data.hours);
	      data.months = mathAbs(data.months);
	      data.years = mathAbs(data.years);
	      return this;
	    }
	    function addSubtract$1(duration, input, value, direction) {
	      var other = createDuration(input, value);
	      duration._milliseconds += direction * other._milliseconds;
	      duration._days += direction * other._days;
	      duration._months += direction * other._months;
	      return duration._bubble();
	    }

	    // supports only 2.0-style add(1, 's') or add(duration)
	    function add$1(input, value) {
	      return addSubtract$1(this, input, value, 1);
	    }

	    // supports only 2.0-style subtract(1, 's') or subtract(duration)
	    function subtract$1(input, value) {
	      return addSubtract$1(this, input, value, -1);
	    }
	    function absCeil(number) {
	      if (number < 0) {
	        return Math.floor(number);
	      } else {
	        return Math.ceil(number);
	      }
	    }
	    function bubble() {
	      var milliseconds = this._milliseconds,
	        days = this._days,
	        months = this._months,
	        data = this._data,
	        seconds,
	        minutes,
	        hours,
	        years,
	        monthsFromDays;

	      // if we have a mix of positive and negative values, bubble down first
	      // check: https://github.com/moment/moment/issues/2166
	      if (!(milliseconds >= 0 && days >= 0 && months >= 0 || milliseconds <= 0 && days <= 0 && months <= 0)) {
	        milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
	        days = 0;
	        months = 0;
	      }

	      // The following code bubbles up values, see the tests for
	      // examples of what that means.
	      data.milliseconds = milliseconds % 1000;
	      seconds = absFloor(milliseconds / 1000);
	      data.seconds = seconds % 60;
	      minutes = absFloor(seconds / 60);
	      data.minutes = minutes % 60;
	      hours = absFloor(minutes / 60);
	      data.hours = hours % 24;
	      days += absFloor(hours / 24);

	      // convert days to months
	      monthsFromDays = absFloor(daysToMonths(days));
	      months += monthsFromDays;
	      days -= absCeil(monthsToDays(monthsFromDays));

	      // 12 months -> 1 year
	      years = absFloor(months / 12);
	      months %= 12;
	      data.days = days;
	      data.months = months;
	      data.years = years;
	      return this;
	    }
	    function daysToMonths(days) {
	      // 400 years have 146097 days (taking into account leap year rules)
	      // 400 years have 12 months === 4800
	      return days * 4800 / 146097;
	    }
	    function monthsToDays(months) {
	      // the reverse of daysToMonths
	      return months * 146097 / 4800;
	    }
	    function as(units) {
	      if (!this.isValid()) {
	        return NaN;
	      }
	      var days,
	        months,
	        milliseconds = this._milliseconds;
	      units = normalizeUnits(units);
	      if (units === 'month' || units === 'quarter' || units === 'year') {
	        days = this._days + milliseconds / 864e5;
	        months = this._months + daysToMonths(days);
	        switch (units) {
	          case 'month':
	            return months;
	          case 'quarter':
	            return months / 3;
	          case 'year':
	            return months / 12;
	        }
	      } else {
	        // handle milliseconds separately because of floating point math errors (issue #1867)
	        days = this._days + Math.round(monthsToDays(this._months));
	        switch (units) {
	          case 'week':
	            return days / 7 + milliseconds / 6048e5;
	          case 'day':
	            return days + milliseconds / 864e5;
	          case 'hour':
	            return days * 24 + milliseconds / 36e5;
	          case 'minute':
	            return days * 1440 + milliseconds / 6e4;
	          case 'second':
	            return days * 86400 + milliseconds / 1000;
	          // Math.floor prevents floating point math errors here
	          case 'millisecond':
	            return Math.floor(days * 864e5) + milliseconds;
	          default:
	            throw new Error('Unknown unit ' + units);
	        }
	      }
	    }

	    // TODO: Use this.as('ms')?
	    function valueOf$1() {
	      if (!this.isValid()) {
	        return NaN;
	      }
	      return this._milliseconds + this._days * 864e5 + this._months % 12 * 2592e6 + toInt(this._months / 12) * 31536e6;
	    }
	    function makeAs(alias) {
	      return function () {
	        return this.as(alias);
	      };
	    }
	    var asMilliseconds = makeAs('ms'),
	      asSeconds = makeAs('s'),
	      asMinutes = makeAs('m'),
	      asHours = makeAs('h'),
	      asDays = makeAs('d'),
	      asWeeks = makeAs('w'),
	      asMonths = makeAs('M'),
	      asQuarters = makeAs('Q'),
	      asYears = makeAs('y');
	    function clone$1() {
	      return createDuration(this);
	    }
	    function get$2(units) {
	      units = normalizeUnits(units);
	      return this.isValid() ? this[units + 's']() : NaN;
	    }
	    function makeGetter(name) {
	      return function () {
	        return this.isValid() ? this._data[name] : NaN;
	      };
	    }
	    var milliseconds = makeGetter('milliseconds'),
	      seconds = makeGetter('seconds'),
	      minutes = makeGetter('minutes'),
	      hours = makeGetter('hours'),
	      days = makeGetter('days'),
	      months = makeGetter('months'),
	      years = makeGetter('years');
	    function weeks() {
	      return absFloor(this.days() / 7);
	    }
	    var round = Math.round,
	      thresholds = {
	        ss: 44,
	        // a few seconds to seconds
	        s: 45,
	        // seconds to minute
	        m: 45,
	        // minutes to hour
	        h: 22,
	        // hours to day
	        d: 26,
	        // days to month/week
	        w: null,
	        // weeks to month
	        M: 11 // months to year
	      };

	    // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
	    function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
	      return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
	    }
	    function relativeTime$1(posNegDuration, withoutSuffix, thresholds, locale) {
	      var duration = createDuration(posNegDuration).abs(),
	        seconds = round(duration.as('s')),
	        minutes = round(duration.as('m')),
	        hours = round(duration.as('h')),
	        days = round(duration.as('d')),
	        months = round(duration.as('M')),
	        weeks = round(duration.as('w')),
	        years = round(duration.as('y')),
	        a = seconds <= thresholds.ss && ['s', seconds] || seconds < thresholds.s && ['ss', seconds] || minutes <= 1 && ['m'] || minutes < thresholds.m && ['mm', minutes] || hours <= 1 && ['h'] || hours < thresholds.h && ['hh', hours] || days <= 1 && ['d'] || days < thresholds.d && ['dd', days];
	      if (thresholds.w != null) {
	        a = a || weeks <= 1 && ['w'] || weeks < thresholds.w && ['ww', weeks];
	      }
	      a = a || months <= 1 && ['M'] || months < thresholds.M && ['MM', months] || years <= 1 && ['y'] || ['yy', years];
	      a[2] = withoutSuffix;
	      a[3] = +posNegDuration > 0;
	      a[4] = locale;
	      return substituteTimeAgo.apply(null, a);
	    }

	    // This function allows you to set the rounding function for relative time strings
	    function getSetRelativeTimeRounding(roundingFunction) {
	      if (roundingFunction === undefined) {
	        return round;
	      }
	      if (typeof roundingFunction === 'function') {
	        round = roundingFunction;
	        return true;
	      }
	      return false;
	    }

	    // This function allows you to set a threshold for relative time strings
	    function getSetRelativeTimeThreshold(threshold, limit) {
	      if (thresholds[threshold] === undefined) {
	        return false;
	      }
	      if (limit === undefined) {
	        return thresholds[threshold];
	      }
	      thresholds[threshold] = limit;
	      if (threshold === 's') {
	        thresholds.ss = limit - 1;
	      }
	      return true;
	    }
	    function humanize(argWithSuffix, argThresholds) {
	      if (!this.isValid()) {
	        return this.localeData().invalidDate();
	      }
	      var withSuffix = false,
	        th = thresholds,
	        locale,
	        output;
	      if (typeof argWithSuffix === 'object') {
	        argThresholds = argWithSuffix;
	        argWithSuffix = false;
	      }
	      if (typeof argWithSuffix === 'boolean') {
	        withSuffix = argWithSuffix;
	      }
	      if (typeof argThresholds === 'object') {
	        th = Object.assign({}, thresholds, argThresholds);
	        if (argThresholds.s != null && argThresholds.ss == null) {
	          th.ss = argThresholds.s - 1;
	        }
	      }
	      locale = this.localeData();
	      output = relativeTime$1(this, !withSuffix, th, locale);
	      if (withSuffix) {
	        output = locale.pastFuture(+this, output);
	      }
	      return locale.postformat(output);
	    }
	    var abs$1 = Math.abs;
	    function sign(x) {
	      return (x > 0) - (x < 0) || +x;
	    }
	    function toISOString$1() {
	      // for ISO strings we do not use the normal bubbling rules:
	      //  * milliseconds bubble up until they become hours
	      //  * days do not bubble at all
	      //  * months bubble up until they become years
	      // This is because there is no context-free conversion between hours and days
	      // (think of clock changes)
	      // and also not between days and months (28-31 days per month)
	      if (!this.isValid()) {
	        return this.localeData().invalidDate();
	      }
	      var seconds = abs$1(this._milliseconds) / 1000,
	        days = abs$1(this._days),
	        months = abs$1(this._months),
	        minutes,
	        hours,
	        years,
	        s,
	        total = this.asSeconds(),
	        totalSign,
	        ymSign,
	        daysSign,
	        hmsSign;
	      if (!total) {
	        // this is the same as C#'s (Noda) and python (isodate)...
	        // but not other JS (goog.date)
	        return 'P0D';
	      }

	      // 3600 seconds -> 60 minutes -> 1 hour
	      minutes = absFloor(seconds / 60);
	      hours = absFloor(minutes / 60);
	      seconds %= 60;
	      minutes %= 60;

	      // 12 months -> 1 year
	      years = absFloor(months / 12);
	      months %= 12;

	      // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
	      s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, '') : '';
	      totalSign = total < 0 ? '-' : '';
	      ymSign = sign(this._months) !== sign(total) ? '-' : '';
	      daysSign = sign(this._days) !== sign(total) ? '-' : '';
	      hmsSign = sign(this._milliseconds) !== sign(total) ? '-' : '';
	      return totalSign + 'P' + (years ? ymSign + years + 'Y' : '') + (months ? ymSign + months + 'M' : '') + (days ? daysSign + days + 'D' : '') + (hours || minutes || seconds ? 'T' : '') + (hours ? hmsSign + hours + 'H' : '') + (minutes ? hmsSign + minutes + 'M' : '') + (seconds ? hmsSign + s + 'S' : '');
	    }
	    var proto$2 = Duration.prototype;
	    proto$2.isValid = isValid$1;
	    proto$2.abs = abs;
	    proto$2.add = add$1;
	    proto$2.subtract = subtract$1;
	    proto$2.as = as;
	    proto$2.asMilliseconds = asMilliseconds;
	    proto$2.asSeconds = asSeconds;
	    proto$2.asMinutes = asMinutes;
	    proto$2.asHours = asHours;
	    proto$2.asDays = asDays;
	    proto$2.asWeeks = asWeeks;
	    proto$2.asMonths = asMonths;
	    proto$2.asQuarters = asQuarters;
	    proto$2.asYears = asYears;
	    proto$2.valueOf = valueOf$1;
	    proto$2._bubble = bubble;
	    proto$2.clone = clone$1;
	    proto$2.get = get$2;
	    proto$2.milliseconds = milliseconds;
	    proto$2.seconds = seconds;
	    proto$2.minutes = minutes;
	    proto$2.hours = hours;
	    proto$2.days = days;
	    proto$2.weeks = weeks;
	    proto$2.months = months;
	    proto$2.years = years;
	    proto$2.humanize = humanize;
	    proto$2.toISOString = toISOString$1;
	    proto$2.toString = toISOString$1;
	    proto$2.toJSON = toISOString$1;
	    proto$2.locale = locale;
	    proto$2.localeData = localeData;
	    proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
	    proto$2.lang = lang;

	    // FORMATTING

	    addFormatToken('X', 0, 0, 'unix');
	    addFormatToken('x', 0, 0, 'valueOf');

	    // PARSING

	    addRegexToken('x', matchSigned);
	    addRegexToken('X', matchTimestamp);
	    addParseToken('X', function (input, array, config) {
	      config._d = new Date(parseFloat(input) * 1000);
	    });
	    addParseToken('x', function (input, array, config) {
	      config._d = new Date(toInt(input));
	    });

	    //! moment.js

	    hooks.version = '2.29.4';
	    setHookCallback(createLocal);
	    hooks.fn = proto;
	    hooks.min = min;
	    hooks.max = max;
	    hooks.now = now;
	    hooks.utc = createUTC;
	    hooks.unix = createUnix;
	    hooks.months = listMonths;
	    hooks.isDate = isDate;
	    hooks.locale = getSetGlobalLocale;
	    hooks.invalid = createInvalid;
	    hooks.duration = createDuration;
	    hooks.isMoment = isMoment;
	    hooks.weekdays = listWeekdays;
	    hooks.parseZone = createInZone;
	    hooks.localeData = getLocale;
	    hooks.isDuration = isDuration;
	    hooks.monthsShort = listMonthsShort;
	    hooks.weekdaysMin = listWeekdaysMin;
	    hooks.defineLocale = defineLocale;
	    hooks.updateLocale = updateLocale;
	    hooks.locales = listLocales;
	    hooks.weekdaysShort = listWeekdaysShort;
	    hooks.normalizeUnits = normalizeUnits;
	    hooks.relativeTimeRounding = getSetRelativeTimeRounding;
	    hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
	    hooks.calendarFormat = getCalendarFormat;
	    hooks.prototype = proto;

	    // currently HTML5 input type only supports 24-hour formats
	    hooks.HTML5_FMT = {
	      DATETIME_LOCAL: 'YYYY-MM-DDTHH:mm',
	      // <input type="datetime-local" />
	      DATETIME_LOCAL_SECONDS: 'YYYY-MM-DDTHH:mm:ss',
	      // <input type="datetime-local" step="1" />
	      DATETIME_LOCAL_MS: 'YYYY-MM-DDTHH:mm:ss.SSS',
	      // <input type="datetime-local" step="0.001" />
	      DATE: 'YYYY-MM-DD',
	      // <input type="date" />
	      TIME: 'HH:mm',
	      // <input type="time" />
	      TIME_SECONDS: 'HH:mm:ss',
	      // <input type="time" step="1" />
	      TIME_MS: 'HH:mm:ss.SSS',
	      // <input type="time" step="0.001" />
	      WEEK: 'GGGG-[W]WW',
	      // <input type="week" />
	      MONTH: 'YYYY-MM' // <input type="month" />
	    };
	    return hooks;
	  });
	})(moment$1);
	const moment = momentExports;

	var momentTimezoneWithData10YearRangeExports = {};
	var momentTimezoneWithData10YearRange = {
	  get exports(){ return momentTimezoneWithData10YearRangeExports; },
	  set exports(v){ momentTimezoneWithData10YearRangeExports = v; },
	};

	(function (module) {
	  //! moment-timezone.js
	  //! version : 0.5.40
	  //! Copyright (c) JS Foundation and other contributors
	  //! license : MIT
	  //! github.com/moment/moment-timezone

	  (function (root, factory) {

	    /*global define*/
	    if (module.exports) {
	      module.exports = factory(momentExports); // Node
	    } else {
	      factory(root.moment); // Browser
	    }
	  })(commonjsGlobal, function (moment) {

	    // Resolves es6 module loading issue
	    if (moment.version === undefined && moment.default) {
	      moment = moment.default;
	    }

	    // Do not load moment-timezone a second time.
	    // if (moment.tz !== undefined) {
	    // 	logError('Moment Timezone ' + moment.tz.version + ' was already loaded ' + (moment.tz.dataVersion ? 'with data from ' : 'without any data') + moment.tz.dataVersion);
	    // 	return moment;
	    // }

	    var VERSION = "0.5.40",
	      zones = {},
	      links = {},
	      countries = {},
	      names = {},
	      guesses = {},
	      cachedGuess;
	    if (!moment || typeof moment.version !== 'string') {
	      logError('Moment Timezone requires Moment.js. See https://momentjs.com/timezone/docs/#/use-it/browser/');
	    }
	    var momentVersion = moment.version.split('.'),
	      major = +momentVersion[0],
	      minor = +momentVersion[1];

	    // Moment.js version check
	    if (major < 2 || major === 2 && minor < 6) {
	      logError('Moment Timezone requires Moment.js >= 2.6.0. You are using Moment.js ' + moment.version + '. See momentjs.com');
	    }

	    /************************************
	    	Unpacking
	    ************************************/

	    function charCodeToInt(charCode) {
	      if (charCode > 96) {
	        return charCode - 87;
	      } else if (charCode > 64) {
	        return charCode - 29;
	      }
	      return charCode - 48;
	    }
	    function unpackBase60(string) {
	      var i = 0,
	        parts = string.split('.'),
	        whole = parts[0],
	        fractional = parts[1] || '',
	        multiplier = 1,
	        num,
	        out = 0,
	        sign = 1;

	      // handle negative numbers
	      if (string.charCodeAt(0) === 45) {
	        i = 1;
	        sign = -1;
	      }

	      // handle digits before the decimal
	      for (i; i < whole.length; i++) {
	        num = charCodeToInt(whole.charCodeAt(i));
	        out = 60 * out + num;
	      }

	      // handle digits after the decimal
	      for (i = 0; i < fractional.length; i++) {
	        multiplier = multiplier / 60;
	        num = charCodeToInt(fractional.charCodeAt(i));
	        out += num * multiplier;
	      }
	      return out * sign;
	    }
	    function arrayToInt(array) {
	      for (var i = 0; i < array.length; i++) {
	        array[i] = unpackBase60(array[i]);
	      }
	    }
	    function intToUntil(array, length) {
	      for (var i = 0; i < length; i++) {
	        array[i] = Math.round((array[i - 1] || 0) + array[i] * 60000); // minutes to milliseconds
	      }
	      array[length - 1] = Infinity;
	    }
	    function mapIndices(source, indices) {
	      var out = [],
	        i;
	      for (i = 0; i < indices.length; i++) {
	        out[i] = source[indices[i]];
	      }
	      return out;
	    }
	    function unpack(string) {
	      var data = string.split('|'),
	        offsets = data[2].split(' '),
	        indices = data[3].split(''),
	        untils = data[4].split(' ');
	      arrayToInt(offsets);
	      arrayToInt(indices);
	      arrayToInt(untils);
	      intToUntil(untils, indices.length);
	      return {
	        name: data[0],
	        abbrs: mapIndices(data[1].split(' '), indices),
	        offsets: mapIndices(offsets, indices),
	        untils: untils,
	        population: data[5] | 0
	      };
	    }

	    /************************************
	    	Zone object
	    ************************************/

	    function Zone(packedString) {
	      if (packedString) {
	        this._set(unpack(packedString));
	      }
	    }
	    Zone.prototype = {
	      _set: function (unpacked) {
	        this.name = unpacked.name;
	        this.abbrs = unpacked.abbrs;
	        this.untils = unpacked.untils;
	        this.offsets = unpacked.offsets;
	        this.population = unpacked.population;
	      },
	      _index: function (timestamp) {
	        var target = +timestamp,
	          untils = this.untils,
	          i;
	        for (i = 0; i < untils.length; i++) {
	          if (target < untils[i]) {
	            return i;
	          }
	        }
	      },
	      countries: function () {
	        var zone_name = this.name;
	        return Object.keys(countries).filter(function (country_code) {
	          return countries[country_code].zones.indexOf(zone_name) !== -1;
	        });
	      },
	      parse: function (timestamp) {
	        var target = +timestamp,
	          offsets = this.offsets,
	          untils = this.untils,
	          max = untils.length - 1,
	          offset,
	          offsetNext,
	          offsetPrev,
	          i;
	        for (i = 0; i < max; i++) {
	          offset = offsets[i];
	          offsetNext = offsets[i + 1];
	          offsetPrev = offsets[i ? i - 1 : i];
	          if (offset < offsetNext && tz.moveAmbiguousForward) {
	            offset = offsetNext;
	          } else if (offset > offsetPrev && tz.moveInvalidForward) {
	            offset = offsetPrev;
	          }
	          if (target < untils[i] - offset * 60000) {
	            return offsets[i];
	          }
	        }
	        return offsets[max];
	      },
	      abbr: function (mom) {
	        return this.abbrs[this._index(mom)];
	      },
	      offset: function (mom) {
	        logError("zone.offset has been deprecated in favor of zone.utcOffset");
	        return this.offsets[this._index(mom)];
	      },
	      utcOffset: function (mom) {
	        return this.offsets[this._index(mom)];
	      }
	    };

	    /************************************
	    	Country object
	    ************************************/

	    function Country(country_name, zone_names) {
	      this.name = country_name;
	      this.zones = zone_names;
	    }

	    /************************************
	    	Current Timezone
	    ************************************/

	    function OffsetAt(at) {
	      var timeString = at.toTimeString();
	      var abbr = timeString.match(/\([a-z ]+\)/i);
	      if (abbr && abbr[0]) {
	        // 17:56:31 GMT-0600 (CST)
	        // 17:56:31 GMT-0600 (Central Standard Time)
	        abbr = abbr[0].match(/[A-Z]/g);
	        abbr = abbr ? abbr.join('') : undefined;
	      } else {
	        // 17:56:31 CST
	        // 17:56:31 GMT+0800 (台北標準時間)
	        abbr = timeString.match(/[A-Z]{3,5}/g);
	        abbr = abbr ? abbr[0] : undefined;
	      }
	      if (abbr === 'GMT') {
	        abbr = undefined;
	      }
	      this.at = +at;
	      this.abbr = abbr;
	      this.offset = at.getTimezoneOffset();
	    }
	    function ZoneScore(zone) {
	      this.zone = zone;
	      this.offsetScore = 0;
	      this.abbrScore = 0;
	    }
	    ZoneScore.prototype.scoreOffsetAt = function (offsetAt) {
	      this.offsetScore += Math.abs(this.zone.utcOffset(offsetAt.at) - offsetAt.offset);
	      if (this.zone.abbr(offsetAt.at).replace(/[^A-Z]/g, '') !== offsetAt.abbr) {
	        this.abbrScore++;
	      }
	    };
	    function findChange(low, high) {
	      var mid, diff;
	      while (diff = ((high.at - low.at) / 12e4 | 0) * 6e4) {
	        mid = new OffsetAt(new Date(low.at + diff));
	        if (mid.offset === low.offset) {
	          low = mid;
	        } else {
	          high = mid;
	        }
	      }
	      return low;
	    }
	    function userOffsets() {
	      var startYear = new Date().getFullYear() - 2,
	        last = new OffsetAt(new Date(startYear, 0, 1)),
	        offsets = [last],
	        change,
	        next,
	        i;
	      for (i = 1; i < 48; i++) {
	        next = new OffsetAt(new Date(startYear, i, 1));
	        if (next.offset !== last.offset) {
	          change = findChange(last, next);
	          offsets.push(change);
	          offsets.push(new OffsetAt(new Date(change.at + 6e4)));
	        }
	        last = next;
	      }
	      for (i = 0; i < 4; i++) {
	        offsets.push(new OffsetAt(new Date(startYear + i, 0, 1)));
	        offsets.push(new OffsetAt(new Date(startYear + i, 6, 1)));
	      }
	      return offsets;
	    }
	    function sortZoneScores(a, b) {
	      if (a.offsetScore !== b.offsetScore) {
	        return a.offsetScore - b.offsetScore;
	      }
	      if (a.abbrScore !== b.abbrScore) {
	        return a.abbrScore - b.abbrScore;
	      }
	      if (a.zone.population !== b.zone.population) {
	        return b.zone.population - a.zone.population;
	      }
	      return b.zone.name.localeCompare(a.zone.name);
	    }
	    function addToGuesses(name, offsets) {
	      var i, offset;
	      arrayToInt(offsets);
	      for (i = 0; i < offsets.length; i++) {
	        offset = offsets[i];
	        guesses[offset] = guesses[offset] || {};
	        guesses[offset][name] = true;
	      }
	    }
	    function guessesForUserOffsets(offsets) {
	      var offsetsLength = offsets.length,
	        filteredGuesses = {},
	        out = [],
	        i,
	        j,
	        guessesOffset;
	      for (i = 0; i < offsetsLength; i++) {
	        guessesOffset = guesses[offsets[i].offset] || {};
	        for (j in guessesOffset) {
	          if (guessesOffset.hasOwnProperty(j)) {
	            filteredGuesses[j] = true;
	          }
	        }
	      }
	      for (i in filteredGuesses) {
	        if (filteredGuesses.hasOwnProperty(i)) {
	          out.push(names[i]);
	        }
	      }
	      return out;
	    }
	    function rebuildGuess() {
	      // use Intl API when available and returning valid time zone
	      try {
	        var intlName = Intl.DateTimeFormat().resolvedOptions().timeZone;
	        if (intlName && intlName.length > 3) {
	          var name = names[normalizeName(intlName)];
	          if (name) {
	            return name;
	          }
	          logError("Moment Timezone found " + intlName + " from the Intl api, but did not have that data loaded.");
	        }
	      } catch (e) {
	        // Intl unavailable, fall back to manual guessing.
	      }
	      var offsets = userOffsets(),
	        offsetsLength = offsets.length,
	        guesses = guessesForUserOffsets(offsets),
	        zoneScores = [],
	        zoneScore,
	        i,
	        j;
	      for (i = 0; i < guesses.length; i++) {
	        zoneScore = new ZoneScore(getZone(guesses[i]));
	        for (j = 0; j < offsetsLength; j++) {
	          zoneScore.scoreOffsetAt(offsets[j]);
	        }
	        zoneScores.push(zoneScore);
	      }
	      zoneScores.sort(sortZoneScores);
	      return zoneScores.length > 0 ? zoneScores[0].zone.name : undefined;
	    }
	    function guess(ignoreCache) {
	      if (!cachedGuess || ignoreCache) {
	        cachedGuess = rebuildGuess();
	      }
	      return cachedGuess;
	    }

	    /************************************
	    	Global Methods
	    ************************************/

	    function normalizeName(name) {
	      return (name || '').toLowerCase().replace(/\//g, '_');
	    }
	    function addZone(packed) {
	      var i, name, split, normalized;
	      if (typeof packed === "string") {
	        packed = [packed];
	      }
	      for (i = 0; i < packed.length; i++) {
	        split = packed[i].split('|');
	        name = split[0];
	        normalized = normalizeName(name);
	        zones[normalized] = packed[i];
	        names[normalized] = name;
	        addToGuesses(normalized, split[2].split(' '));
	      }
	    }
	    function getZone(name, caller) {
	      name = normalizeName(name);
	      var zone = zones[name];
	      var link;
	      if (zone instanceof Zone) {
	        return zone;
	      }
	      if (typeof zone === 'string') {
	        zone = new Zone(zone);
	        zones[name] = zone;
	        return zone;
	      }

	      // Pass getZone to prevent recursion more than 1 level deep
	      if (links[name] && caller !== getZone && (link = getZone(links[name], getZone))) {
	        zone = zones[name] = new Zone();
	        zone._set(link);
	        zone.name = names[name];
	        return zone;
	      }
	      return null;
	    }
	    function getNames() {
	      var i,
	        out = [];
	      for (i in names) {
	        if (names.hasOwnProperty(i) && (zones[i] || zones[links[i]]) && names[i]) {
	          out.push(names[i]);
	        }
	      }
	      return out.sort();
	    }
	    function getCountryNames() {
	      return Object.keys(countries);
	    }
	    function addLink(aliases) {
	      var i, alias, normal0, normal1;
	      if (typeof aliases === "string") {
	        aliases = [aliases];
	      }
	      for (i = 0; i < aliases.length; i++) {
	        alias = aliases[i].split('|');
	        normal0 = normalizeName(alias[0]);
	        normal1 = normalizeName(alias[1]);
	        links[normal0] = normal1;
	        names[normal0] = alias[0];
	        links[normal1] = normal0;
	        names[normal1] = alias[1];
	      }
	    }
	    function addCountries(data) {
	      var i, country_code, country_zones, split;
	      if (!data || !data.length) return;
	      for (i = 0; i < data.length; i++) {
	        split = data[i].split('|');
	        country_code = split[0].toUpperCase();
	        country_zones = split[1].split(' ');
	        countries[country_code] = new Country(country_code, country_zones);
	      }
	    }
	    function getCountry(name) {
	      name = name.toUpperCase();
	      return countries[name] || null;
	    }
	    function zonesForCountry(country, with_offset) {
	      country = getCountry(country);
	      if (!country) return null;
	      var zones = country.zones.sort();
	      if (with_offset) {
	        return zones.map(function (zone_name) {
	          var zone = getZone(zone_name);
	          return {
	            name: zone_name,
	            offset: zone.utcOffset(new Date())
	          };
	        });
	      }
	      return zones;
	    }
	    function loadData(data) {
	      addZone(data.zones);
	      addLink(data.links);
	      addCountries(data.countries);
	      tz.dataVersion = data.version;
	    }
	    function zoneExists(name) {
	      if (!zoneExists.didShowError) {
	        zoneExists.didShowError = true;
	        logError("moment.tz.zoneExists('" + name + "') has been deprecated in favor of !moment.tz.zone('" + name + "')");
	      }
	      return !!getZone(name);
	    }
	    function needsOffset(m) {
	      var isUnixTimestamp = m._f === 'X' || m._f === 'x';
	      return !!(m._a && m._tzm === undefined && !isUnixTimestamp);
	    }
	    function logError(message) {
	      if (typeof console !== 'undefined' && typeof console.error === 'function') {
	        console.error(message);
	      }
	    }

	    /************************************
	    	moment.tz namespace
	    ************************************/

	    function tz(input) {
	      var args = Array.prototype.slice.call(arguments, 0, -1),
	        name = arguments[arguments.length - 1],
	        zone = getZone(name),
	        out = moment.utc.apply(null, args);
	      if (zone && !moment.isMoment(input) && needsOffset(out)) {
	        out.add(zone.parse(out), 'minutes');
	      }
	      out.tz(name);
	      return out;
	    }
	    tz.version = VERSION;
	    tz.dataVersion = '';
	    tz._zones = zones;
	    tz._links = links;
	    tz._names = names;
	    tz._countries = countries;
	    tz.add = addZone;
	    tz.link = addLink;
	    tz.load = loadData;
	    tz.zone = getZone;
	    tz.zoneExists = zoneExists; // deprecated in 0.1.0
	    tz.guess = guess;
	    tz.names = getNames;
	    tz.Zone = Zone;
	    tz.unpack = unpack;
	    tz.unpackBase60 = unpackBase60;
	    tz.needsOffset = needsOffset;
	    tz.moveInvalidForward = true;
	    tz.moveAmbiguousForward = false;
	    tz.countries = getCountryNames;
	    tz.zonesForCountry = zonesForCountry;

	    /************************************
	    	Interface with Moment.js
	    ************************************/

	    var fn = moment.fn;
	    moment.tz = tz;
	    moment.defaultZone = null;
	    moment.updateOffset = function (mom, keepTime) {
	      var zone = moment.defaultZone,
	        offset;
	      if (mom._z === undefined) {
	        if (zone && needsOffset(mom) && !mom._isUTC) {
	          mom._d = moment.utc(mom._a)._d;
	          mom.utc().add(zone.parse(mom), 'minutes');
	        }
	        mom._z = zone;
	      }
	      if (mom._z) {
	        offset = mom._z.utcOffset(mom);
	        if (Math.abs(offset) < 16) {
	          offset = offset / 60;
	        }
	        if (mom.utcOffset !== undefined) {
	          var z = mom._z;
	          mom.utcOffset(-offset, keepTime);
	          mom._z = z;
	        } else {
	          mom.zone(offset, keepTime);
	        }
	      }
	    };
	    fn.tz = function (name, keepTime) {
	      if (name) {
	        if (typeof name !== 'string') {
	          throw new Error('Time zone name must be a string, got ' + name + ' [' + typeof name + ']');
	        }
	        this._z = getZone(name);
	        if (this._z) {
	          moment.updateOffset(this, keepTime);
	        } else {
	          logError("Moment Timezone has no data for " + name + ". See http://momentjs.com/timezone/docs/#/data-loading/.");
	        }
	        return this;
	      }
	      if (this._z) {
	        return this._z.name;
	      }
	    };
	    function abbrWrap(old) {
	      return function () {
	        if (this._z) {
	          return this._z.abbr(this);
	        }
	        return old.call(this);
	      };
	    }
	    function resetZoneWrap(old) {
	      return function () {
	        this._z = null;
	        return old.apply(this, arguments);
	      };
	    }
	    function resetZoneWrap2(old) {
	      return function () {
	        if (arguments.length > 0) this._z = null;
	        return old.apply(this, arguments);
	      };
	    }
	    fn.zoneName = abbrWrap(fn.zoneName);
	    fn.zoneAbbr = abbrWrap(fn.zoneAbbr);
	    fn.utc = resetZoneWrap(fn.utc);
	    fn.local = resetZoneWrap(fn.local);
	    fn.utcOffset = resetZoneWrap2(fn.utcOffset);
	    moment.tz.setDefault = function (name) {
	      if (major < 2 || major === 2 && minor < 9) {
	        logError('Moment Timezone setDefault() requires Moment.js >= 2.9.0. You are using Moment.js ' + moment.version + '.');
	      }
	      moment.defaultZone = name ? getZone(name) : null;
	      return moment;
	    };

	    // Cloning a moment should include the _z property.
	    var momentProperties = moment.momentProperties;
	    if (Object.prototype.toString.call(momentProperties) === '[object Array]') {
	      // moment 2.8.1+
	      momentProperties.push('_z');
	      momentProperties.push('_a');
	    } else if (momentProperties) {
	      // moment 2.7.0
	      momentProperties._z = null;
	    }
	    loadData({
	      "version": "2022g",
	      "zones": ["Africa/Abidjan|GMT|0|0||48e5", "Africa/Nairobi|EAT|-30|0||47e5", "Africa/Algiers|CET|-10|0||26e5", "Africa/Lagos|WAT|-10|0||17e6", "Africa/Maputo|CAT|-20|0||26e5", "Africa/Cairo|EET|-20|0||15e6", "Africa/Casablanca|+00 +01|0 -10|01010101010101010101010101|1T0q0 mo0 gM0 LA0 WM0 jA0 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600 gM0 2600 e00 2600 gM0 2600 e00 28M0 e00|32e5", "Europe/Paris|CET CEST|-10 -20|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|11e6", "Africa/Johannesburg|SAST|-20|0||84e5", "Africa/Juba|EAT CAT|-30 -20|01|24nx0|", "Africa/Khartoum|EAT CAT|-30 -20|01|1Usl0|51e5", "Africa/Sao_Tome|GMT WAT|0 -10|010|1UQN0 2q00|", "Africa/Windhoek|CAT WAT|-20 -10|010|1T3c0 11B0|32e4", "America/Adak|HST HDT|a0 90|01010101010101010101010|1ST00 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|326", "America/Anchorage|AKST AKDT|90 80|01010101010101010101010|1SSX0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|30e4", "America/Santo_Domingo|AST|40|0||29e5", "America/Fortaleza|-03|30|0||34e5", "America/Asuncion|-03 -04|30 40|01010101010101010101010|1T0r0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0|28e5", "America/Panama|EST|50|0||15e5", "America/Mexico_City|CST CDT|60 50|0101010101010|1T3k0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|20e6", "America/Managua|CST|60|0||22e5", "America/Caracas|-04|40|0||29e5", "America/Lima|-05|50|0||11e6", "America/Denver|MST MDT|70 60|01010101010101010101010|1SSV0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|26e5", "America/Campo_Grande|-03 -04|30 40|010101|1SKr0 1zd0 On0 1HB0 FX0|77e4", "America/Chicago|CST CDT|60 50|01010101010101010101010|1SSU0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|92e5", "America/Chihuahua|MST MDT CST|70 60 60|0101010101012|1T3l0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|81e4", "America/Ciudad_Juarez|MST MDT CST|70 60 60|010101010101201010101010|1SSV0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1wn0 cm0 EP0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|", "America/Phoenix|MST|70|0||42e5", "America/Whitehorse|PST PDT MST|80 70 70|010101012|1SSW0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1z90|23e3", "America/New_York|EST EDT|50 40|01010101010101010101010|1SST0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|21e6", "America/Los_Angeles|PST PDT|80 70|01010101010101010101010|1SSW0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|15e6", "America/Halifax|AST ADT|40 30|01010101010101010101010|1SSS0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|39e4", "America/Godthab|-03 -02|30 20|01010101010101|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0|17e3", "America/Grand_Turk|AST EDT EST|40 40 50|012121212121212121212|1Vkv0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|37e2", "America/Havana|CST CDT|50 40|01010101010101010101010|1SSR0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0|21e5", "America/Mazatlan|MST MDT|70 60|0101010101010|1T3l0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|44e4", "America/Metlakatla|AKST AKDT PST|90 80 80|010120101010101010101010|1SSX0 1zb0 Op0 1zb0 uM0 jB0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|14e2", "America/Miquelon|-03 -02|30 20|01010101010101010101010|1SSR0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|61e2", "America/Noronha|-02|20|0||30e2", "America/Ojinaga|MST MDT CST CDT|70 60 60 50|01010101010123232323232|1SSV0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1wn0 Rc0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|23e3", "America/Santiago|-03 -04|30 40|01010101010101010101010|1Tk30 Ap0 1Nb0 Ap0 1zb0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0|62e5", "America/Sao_Paulo|-02 -03|20 30|010101|1SKq0 1zd0 On0 1HB0 FX0|20e6", "Atlantic/Azores|-01 +00|10 0|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|25e4", "America/St_Johns|NST NDT|3u 2u|01010101010101010101010|1SSRu 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0|11e4", "Antarctica/Casey|+11 +08|-b0 -80|0101010|1Vkh0 1o30 14k0 1kr0 12l0 1o01|10", "Asia/Bangkok|+07|-70|0||15e6", "Asia/Vladivostok|+10|-a0|0||60e4", "Australia/Sydney|AEDT AEST|-b0 -a0|01010101010101010101010|1T340 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0|40e5", "Asia/Tashkent|+05|-50|0||23e5", "Pacific/Auckland|NZDT NZST|-d0 -c0|01010101010101010101010|1T320 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00|14e5", "Europe/Istanbul|+03|-30|0||13e6", "Antarctica/Troll|+00 +02|0 -20|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|40", "Asia/Dhaka|+06|-60|0||16e6", "Asia/Amman|EET EEST +03|-20 -30 -30|0101010101012|1T2m0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 LA0 1C00|25e5", "Asia/Kamchatka|+12|-c0|0||18e4", "Asia/Dubai|+04|-40|0||39e5", "Asia/Beirut|EET EEST|-20 -30|01010101010101010101010|1T0m0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0|22e5", "Asia/Kuala_Lumpur|+08|-80|0||71e5", "Asia/Kolkata|IST|-5u|0||15e6", "Asia/Chita|+09|-90|0||33e4", "Asia/Shanghai|CST|-80|0||23e6", "Asia/Colombo|+0530|-5u|0||22e5", "Asia/Damascus|EET EEST +03|-20 -30 -30|0101010101012|1T2m0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0|26e5", "Asia/Famagusta|+03 EET EEST|-30 -20 -30|0121212121212121212121|1Urd0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|", "Asia/Gaza|EET EEST|-20 -30|01010101010101010101010|1SXX0 1qL0 WN0 1qL0 11c0 1on0 11B0 1o00 11A0 1qo0 XA0 1qp0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0|18e5", "Asia/Hong_Kong|HKT|-80|0||73e5", "Asia/Jakarta|WIB|-70|0||31e6", "Asia/Jayapura|WIT|-90|0||26e4", "Asia/Jerusalem|IST IDT|-20 -30|01010101010101010101010|1SXA0 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0|81e4", "Asia/Kabul|+0430|-4u|0||46e5", "Asia/Karachi|PKT|-50|0||24e6", "Asia/Kathmandu|+0545|-5J|0||12e5", "Asia/Sakhalin|+11|-b0|0||58e4", "Asia/Makassar|WITA|-80|0||15e5", "Asia/Manila|PST|-80|0||24e6", "Europe/Athens|EET EEST|-20 -30|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|35e5", "Asia/Pyongyang|KST KST|-8u -90|01|1VGf0|29e5", "Asia/Qyzylorda|+06 +05|-60 -50|01|1Xei0|73e4", "Asia/Rangoon|+0630|-6u|0||48e5", "Asia/Seoul|KST|-90|0||23e6", "Asia/Tehran|+0330 +0430|-3u -4u|0101010101010|1SWIu 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0|14e6", "Asia/Tokyo|JST|-90|0||38e6", "Europe/Lisbon|WET WEST|0 -10|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|27e5", "Atlantic/Cape_Verde|-01|10|0||50e4", "Australia/Adelaide|ACDT ACST|-au -9u|01010101010101010101010|1T34u 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0|11e5", "Australia/Brisbane|AEST|-a0|0||20e5", "Australia/Darwin|ACST|-9u|0||12e4", "Australia/Eucla|+0845|-8J|0||368", "Australia/Lord_Howe|+11 +1030|-b0 -au|01010101010101010101010|1T330 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1fzu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu|347", "Australia/Perth|AWST|-80|0||18e5", "Pacific/Easter|-05 -06|50 60|01010101010101010101010|1Tk30 Ap0 1Nb0 Ap0 1zb0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0|30e2", "Europe/Dublin|GMT IST|0 -10|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|12e5", "Etc/GMT-1|+01|-10|0||", "Pacific/Fakaofo|+13|-d0|0||483", "Pacific/Kiritimati|+14|-e0|0||51e2", "Etc/GMT-2|+02|-20|0||", "Pacific/Tahiti|-10|a0|0||18e4", "Pacific/Niue|-11|b0|0||12e2", "Etc/GMT+12|-12|c0|0||", "Pacific/Galapagos|-06|60|0||25e3", "Etc/GMT+7|-07|70|0||", "Pacific/Pitcairn|-08|80|0||56", "Pacific/Gambier|-09|90|0||125", "Etc/UTC|UTC|0|0||", "Europe/London|GMT BST|0 -10|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|10e6", "Europe/Chisinau|EET EEST|-20 -30|01010101010101010101010|1T0o0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|67e4", "Europe/Moscow|MSK|-30|0||16e6", "Europe/Volgograd|+03 +04|-30 -40|010|1WQL0 5gn0|10e5", "Pacific/Honolulu|HST|a0|0||37e4", "MET|MET MEST|-10 -20|01010101010101010101010|1T0p0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0|", "Pacific/Chatham|+1345 +1245|-dJ -cJ|01010101010101010101010|1T320 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00|600", "Pacific/Apia|+14 +13|-e0 -d0|0101010101|1T320 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0|37e3", "Pacific/Fiji|+13 +12|-d0 -c0|0101010101|1Swe0 1VA0 s00 1VA0 s00 20o0 pc0 2hc0 bc0|88e4", "Pacific/Guam|ChST|-a0|0||17e4", "Pacific/Marquesas|-0930|9u|0||86e2", "Pacific/Pago_Pago|SST|b0|0||37e2", "Pacific/Norfolk|+11 +12|-b0 -c0|010101010101010101|219P0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0|25e4", "Pacific/Tongatapu|+14 +13|-e0 -d0|01|1Swd0|75e3"],
	      "links": ["Africa/Abidjan|Africa/Accra", "Africa/Abidjan|Africa/Bamako", "Africa/Abidjan|Africa/Banjul", "Africa/Abidjan|Africa/Bissau", "Africa/Abidjan|Africa/Conakry", "Africa/Abidjan|Africa/Dakar", "Africa/Abidjan|Africa/Freetown", "Africa/Abidjan|Africa/Lome", "Africa/Abidjan|Africa/Monrovia", "Africa/Abidjan|Africa/Nouakchott", "Africa/Abidjan|Africa/Ouagadougou", "Africa/Abidjan|Africa/Timbuktu", "Africa/Abidjan|America/Danmarkshavn", "Africa/Abidjan|Atlantic/Reykjavik", "Africa/Abidjan|Atlantic/St_Helena", "Africa/Abidjan|Etc/GMT", "Africa/Abidjan|Etc/GMT+0", "Africa/Abidjan|Etc/GMT-0", "Africa/Abidjan|Etc/GMT0", "Africa/Abidjan|Etc/Greenwich", "Africa/Abidjan|GMT", "Africa/Abidjan|GMT+0", "Africa/Abidjan|GMT-0", "Africa/Abidjan|GMT0", "Africa/Abidjan|Greenwich", "Africa/Abidjan|Iceland", "Africa/Algiers|Africa/Tunis", "Africa/Cairo|Africa/Tripoli", "Africa/Cairo|Egypt", "Africa/Cairo|Europe/Kaliningrad", "Africa/Cairo|Libya", "Africa/Casablanca|Africa/El_Aaiun", "Africa/Johannesburg|Africa/Maseru", "Africa/Johannesburg|Africa/Mbabane", "Africa/Lagos|Africa/Bangui", "Africa/Lagos|Africa/Brazzaville", "Africa/Lagos|Africa/Douala", "Africa/Lagos|Africa/Kinshasa", "Africa/Lagos|Africa/Libreville", "Africa/Lagos|Africa/Luanda", "Africa/Lagos|Africa/Malabo", "Africa/Lagos|Africa/Ndjamena", "Africa/Lagos|Africa/Niamey", "Africa/Lagos|Africa/Porto-Novo", "Africa/Maputo|Africa/Blantyre", "Africa/Maputo|Africa/Bujumbura", "Africa/Maputo|Africa/Gaborone", "Africa/Maputo|Africa/Harare", "Africa/Maputo|Africa/Kigali", "Africa/Maputo|Africa/Lubumbashi", "Africa/Maputo|Africa/Lusaka", "Africa/Nairobi|Africa/Addis_Ababa", "Africa/Nairobi|Africa/Asmara", "Africa/Nairobi|Africa/Asmera", "Africa/Nairobi|Africa/Dar_es_Salaam", "Africa/Nairobi|Africa/Djibouti", "Africa/Nairobi|Africa/Kampala", "Africa/Nairobi|Africa/Mogadishu", "Africa/Nairobi|Indian/Antananarivo", "Africa/Nairobi|Indian/Comoro", "Africa/Nairobi|Indian/Mayotte", "America/Adak|America/Atka", "America/Adak|US/Aleutian", "America/Anchorage|America/Juneau", "America/Anchorage|America/Nome", "America/Anchorage|America/Sitka", "America/Anchorage|America/Yakutat", "America/Anchorage|US/Alaska", "America/Campo_Grande|America/Cuiaba", "America/Caracas|America/Boa_Vista", "America/Caracas|America/Guyana", "America/Caracas|America/La_Paz", "America/Caracas|America/Manaus", "America/Caracas|America/Porto_Velho", "America/Caracas|Brazil/West", "America/Caracas|Etc/GMT+4", "America/Chicago|America/Indiana/Knox", "America/Chicago|America/Indiana/Tell_City", "America/Chicago|America/Knox_IN", "America/Chicago|America/Matamoros", "America/Chicago|America/Menominee", "America/Chicago|America/North_Dakota/Beulah", "America/Chicago|America/North_Dakota/Center", "America/Chicago|America/North_Dakota/New_Salem", "America/Chicago|America/Rainy_River", "America/Chicago|America/Rankin_Inlet", "America/Chicago|America/Resolute", "America/Chicago|America/Winnipeg", "America/Chicago|CST6CDT", "America/Chicago|Canada/Central", "America/Chicago|US/Central", "America/Chicago|US/Indiana-Starke", "America/Denver|America/Boise", "America/Denver|America/Cambridge_Bay", "America/Denver|America/Edmonton", "America/Denver|America/Inuvik", "America/Denver|America/Shiprock", "America/Denver|America/Yellowknife", "America/Denver|Canada/Mountain", "America/Denver|MST7MDT", "America/Denver|Navajo", "America/Denver|US/Mountain", "America/Fortaleza|America/Araguaina", "America/Fortaleza|America/Argentina/Buenos_Aires", "America/Fortaleza|America/Argentina/Catamarca", "America/Fortaleza|America/Argentina/ComodRivadavia", "America/Fortaleza|America/Argentina/Cordoba", "America/Fortaleza|America/Argentina/Jujuy", "America/Fortaleza|America/Argentina/La_Rioja", "America/Fortaleza|America/Argentina/Mendoza", "America/Fortaleza|America/Argentina/Rio_Gallegos", "America/Fortaleza|America/Argentina/Salta", "America/Fortaleza|America/Argentina/San_Juan", "America/Fortaleza|America/Argentina/San_Luis", "America/Fortaleza|America/Argentina/Tucuman", "America/Fortaleza|America/Argentina/Ushuaia", "America/Fortaleza|America/Bahia", "America/Fortaleza|America/Belem", "America/Fortaleza|America/Buenos_Aires", "America/Fortaleza|America/Catamarca", "America/Fortaleza|America/Cayenne", "America/Fortaleza|America/Cordoba", "America/Fortaleza|America/Jujuy", "America/Fortaleza|America/Maceio", "America/Fortaleza|America/Mendoza", "America/Fortaleza|America/Montevideo", "America/Fortaleza|America/Paramaribo", "America/Fortaleza|America/Punta_Arenas", "America/Fortaleza|America/Recife", "America/Fortaleza|America/Rosario", "America/Fortaleza|America/Santarem", "America/Fortaleza|Antarctica/Palmer", "America/Fortaleza|Antarctica/Rothera", "America/Fortaleza|Atlantic/Stanley", "America/Fortaleza|Etc/GMT+3", "America/Godthab|America/Nuuk", "America/Halifax|America/Glace_Bay", "America/Halifax|America/Goose_Bay", "America/Halifax|America/Moncton", "America/Halifax|America/Thule", "America/Halifax|Atlantic/Bermuda", "America/Halifax|Canada/Atlantic", "America/Havana|Cuba", "America/Lima|America/Bogota", "America/Lima|America/Eirunepe", "America/Lima|America/Guayaquil", "America/Lima|America/Porto_Acre", "America/Lima|America/Rio_Branco", "America/Lima|Brazil/Acre", "America/Lima|Etc/GMT+5", "America/Los_Angeles|America/Ensenada", "America/Los_Angeles|America/Santa_Isabel", "America/Los_Angeles|America/Tijuana", "America/Los_Angeles|America/Vancouver", "America/Los_Angeles|Canada/Pacific", "America/Los_Angeles|Mexico/BajaNorte", "America/Los_Angeles|PST8PDT", "America/Los_Angeles|US/Pacific", "America/Managua|America/Belize", "America/Managua|America/Costa_Rica", "America/Managua|America/El_Salvador", "America/Managua|America/Guatemala", "America/Managua|America/Regina", "America/Managua|America/Swift_Current", "America/Managua|America/Tegucigalpa", "America/Managua|Canada/Saskatchewan", "America/Mazatlan|Mexico/BajaSur", "America/Mexico_City|America/Bahia_Banderas", "America/Mexico_City|America/Merida", "America/Mexico_City|America/Monterrey", "America/Mexico_City|Mexico/General", "America/New_York|America/Detroit", "America/New_York|America/Fort_Wayne", "America/New_York|America/Indiana/Indianapolis", "America/New_York|America/Indiana/Marengo", "America/New_York|America/Indiana/Petersburg", "America/New_York|America/Indiana/Vevay", "America/New_York|America/Indiana/Vincennes", "America/New_York|America/Indiana/Winamac", "America/New_York|America/Indianapolis", "America/New_York|America/Iqaluit", "America/New_York|America/Kentucky/Louisville", "America/New_York|America/Kentucky/Monticello", "America/New_York|America/Louisville", "America/New_York|America/Montreal", "America/New_York|America/Nassau", "America/New_York|America/Nipigon", "America/New_York|America/Pangnirtung", "America/New_York|America/Port-au-Prince", "America/New_York|America/Thunder_Bay", "America/New_York|America/Toronto", "America/New_York|Canada/Eastern", "America/New_York|EST5EDT", "America/New_York|US/East-Indiana", "America/New_York|US/Eastern", "America/New_York|US/Michigan", "America/Noronha|Atlantic/South_Georgia", "America/Noronha|Brazil/DeNoronha", "America/Noronha|Etc/GMT+2", "America/Panama|America/Atikokan", "America/Panama|America/Cancun", "America/Panama|America/Cayman", "America/Panama|America/Coral_Harbour", "America/Panama|America/Jamaica", "America/Panama|EST", "America/Panama|Jamaica", "America/Phoenix|America/Creston", "America/Phoenix|America/Dawson_Creek", "America/Phoenix|America/Fort_Nelson", "America/Phoenix|America/Hermosillo", "America/Phoenix|MST", "America/Phoenix|US/Arizona", "America/Santiago|Chile/Continental", "America/Santo_Domingo|America/Anguilla", "America/Santo_Domingo|America/Antigua", "America/Santo_Domingo|America/Aruba", "America/Santo_Domingo|America/Barbados", "America/Santo_Domingo|America/Blanc-Sablon", "America/Santo_Domingo|America/Curacao", "America/Santo_Domingo|America/Dominica", "America/Santo_Domingo|America/Grenada", "America/Santo_Domingo|America/Guadeloupe", "America/Santo_Domingo|America/Kralendijk", "America/Santo_Domingo|America/Lower_Princes", "America/Santo_Domingo|America/Marigot", "America/Santo_Domingo|America/Martinique", "America/Santo_Domingo|America/Montserrat", "America/Santo_Domingo|America/Port_of_Spain", "America/Santo_Domingo|America/Puerto_Rico", "America/Santo_Domingo|America/St_Barthelemy", "America/Santo_Domingo|America/St_Kitts", "America/Santo_Domingo|America/St_Lucia", "America/Santo_Domingo|America/St_Thomas", "America/Santo_Domingo|America/St_Vincent", "America/Santo_Domingo|America/Tortola", "America/Santo_Domingo|America/Virgin", "America/Sao_Paulo|Brazil/East", "America/St_Johns|Canada/Newfoundland", "America/Whitehorse|America/Dawson", "America/Whitehorse|Canada/Yukon", "Asia/Bangkok|Antarctica/Davis", "Asia/Bangkok|Asia/Barnaul", "Asia/Bangkok|Asia/Ho_Chi_Minh", "Asia/Bangkok|Asia/Hovd", "Asia/Bangkok|Asia/Krasnoyarsk", "Asia/Bangkok|Asia/Novokuznetsk", "Asia/Bangkok|Asia/Novosibirsk", "Asia/Bangkok|Asia/Phnom_Penh", "Asia/Bangkok|Asia/Saigon", "Asia/Bangkok|Asia/Tomsk", "Asia/Bangkok|Asia/Vientiane", "Asia/Bangkok|Etc/GMT-7", "Asia/Bangkok|Indian/Christmas", "Asia/Chita|Asia/Dili", "Asia/Chita|Asia/Khandyga", "Asia/Chita|Asia/Yakutsk", "Asia/Chita|Etc/GMT-9", "Asia/Chita|Pacific/Palau", "Asia/Dhaka|Antarctica/Vostok", "Asia/Dhaka|Asia/Almaty", "Asia/Dhaka|Asia/Bishkek", "Asia/Dhaka|Asia/Dacca", "Asia/Dhaka|Asia/Kashgar", "Asia/Dhaka|Asia/Omsk", "Asia/Dhaka|Asia/Qostanay", "Asia/Dhaka|Asia/Thimbu", "Asia/Dhaka|Asia/Thimphu", "Asia/Dhaka|Asia/Urumqi", "Asia/Dhaka|Etc/GMT-6", "Asia/Dhaka|Indian/Chagos", "Asia/Dubai|Asia/Baku", "Asia/Dubai|Asia/Muscat", "Asia/Dubai|Asia/Tbilisi", "Asia/Dubai|Asia/Yerevan", "Asia/Dubai|Etc/GMT-4", "Asia/Dubai|Europe/Astrakhan", "Asia/Dubai|Europe/Samara", "Asia/Dubai|Europe/Saratov", "Asia/Dubai|Europe/Ulyanovsk", "Asia/Dubai|Indian/Mahe", "Asia/Dubai|Indian/Mauritius", "Asia/Dubai|Indian/Reunion", "Asia/Gaza|Asia/Hebron", "Asia/Hong_Kong|Hongkong", "Asia/Jakarta|Asia/Pontianak", "Asia/Jerusalem|Asia/Tel_Aviv", "Asia/Jerusalem|Israel", "Asia/Kamchatka|Asia/Anadyr", "Asia/Kamchatka|Etc/GMT-12", "Asia/Kamchatka|Kwajalein", "Asia/Kamchatka|Pacific/Funafuti", "Asia/Kamchatka|Pacific/Kwajalein", "Asia/Kamchatka|Pacific/Majuro", "Asia/Kamchatka|Pacific/Nauru", "Asia/Kamchatka|Pacific/Tarawa", "Asia/Kamchatka|Pacific/Wake", "Asia/Kamchatka|Pacific/Wallis", "Asia/Kathmandu|Asia/Katmandu", "Asia/Kolkata|Asia/Calcutta", "Asia/Kuala_Lumpur|Asia/Brunei", "Asia/Kuala_Lumpur|Asia/Choibalsan", "Asia/Kuala_Lumpur|Asia/Irkutsk", "Asia/Kuala_Lumpur|Asia/Kuching", "Asia/Kuala_Lumpur|Asia/Singapore", "Asia/Kuala_Lumpur|Asia/Ulaanbaatar", "Asia/Kuala_Lumpur|Asia/Ulan_Bator", "Asia/Kuala_Lumpur|Etc/GMT-8", "Asia/Kuala_Lumpur|Singapore", "Asia/Makassar|Asia/Ujung_Pandang", "Asia/Rangoon|Asia/Yangon", "Asia/Rangoon|Indian/Cocos", "Asia/Sakhalin|Asia/Magadan", "Asia/Sakhalin|Asia/Srednekolymsk", "Asia/Sakhalin|Etc/GMT-11", "Asia/Sakhalin|Pacific/Bougainville", "Asia/Sakhalin|Pacific/Efate", "Asia/Sakhalin|Pacific/Guadalcanal", "Asia/Sakhalin|Pacific/Kosrae", "Asia/Sakhalin|Pacific/Noumea", "Asia/Sakhalin|Pacific/Pohnpei", "Asia/Sakhalin|Pacific/Ponape", "Asia/Seoul|ROK", "Asia/Shanghai|Asia/Chongqing", "Asia/Shanghai|Asia/Chungking", "Asia/Shanghai|Asia/Harbin", "Asia/Shanghai|Asia/Macao", "Asia/Shanghai|Asia/Macau", "Asia/Shanghai|Asia/Taipei", "Asia/Shanghai|PRC", "Asia/Shanghai|ROC", "Asia/Tashkent|Antarctica/Mawson", "Asia/Tashkent|Asia/Aqtau", "Asia/Tashkent|Asia/Aqtobe", "Asia/Tashkent|Asia/Ashgabat", "Asia/Tashkent|Asia/Ashkhabad", "Asia/Tashkent|Asia/Atyrau", "Asia/Tashkent|Asia/Dushanbe", "Asia/Tashkent|Asia/Oral", "Asia/Tashkent|Asia/Samarkand", "Asia/Tashkent|Asia/Yekaterinburg", "Asia/Tashkent|Etc/GMT-5", "Asia/Tashkent|Indian/Kerguelen", "Asia/Tashkent|Indian/Maldives", "Asia/Tehran|Iran", "Asia/Tokyo|Japan", "Asia/Vladivostok|Antarctica/DumontDUrville", "Asia/Vladivostok|Asia/Ust-Nera", "Asia/Vladivostok|Etc/GMT-10", "Asia/Vladivostok|Pacific/Chuuk", "Asia/Vladivostok|Pacific/Port_Moresby", "Asia/Vladivostok|Pacific/Truk", "Asia/Vladivostok|Pacific/Yap", "Atlantic/Azores|America/Scoresbysund", "Atlantic/Cape_Verde|Etc/GMT+1", "Australia/Adelaide|Australia/Broken_Hill", "Australia/Adelaide|Australia/South", "Australia/Adelaide|Australia/Yancowinna", "Australia/Brisbane|Australia/Lindeman", "Australia/Brisbane|Australia/Queensland", "Australia/Darwin|Australia/North", "Australia/Lord_Howe|Australia/LHI", "Australia/Perth|Australia/West", "Australia/Sydney|Antarctica/Macquarie", "Australia/Sydney|Australia/ACT", "Australia/Sydney|Australia/Canberra", "Australia/Sydney|Australia/Currie", "Australia/Sydney|Australia/Hobart", "Australia/Sydney|Australia/Melbourne", "Australia/Sydney|Australia/NSW", "Australia/Sydney|Australia/Tasmania", "Australia/Sydney|Australia/Victoria", "Etc/UTC|Etc/UCT", "Etc/UTC|Etc/Universal", "Etc/UTC|Etc/Zulu", "Etc/UTC|UCT", "Etc/UTC|UTC", "Etc/UTC|Universal", "Etc/UTC|Zulu", "Europe/Athens|Asia/Nicosia", "Europe/Athens|EET", "Europe/Athens|Europe/Bucharest", "Europe/Athens|Europe/Helsinki", "Europe/Athens|Europe/Kiev", "Europe/Athens|Europe/Kyiv", "Europe/Athens|Europe/Mariehamn", "Europe/Athens|Europe/Nicosia", "Europe/Athens|Europe/Riga", "Europe/Athens|Europe/Sofia", "Europe/Athens|Europe/Tallinn", "Europe/Athens|Europe/Uzhgorod", "Europe/Athens|Europe/Vilnius", "Europe/Athens|Europe/Zaporozhye", "Europe/Chisinau|Europe/Tiraspol", "Europe/Dublin|Eire", "Europe/Istanbul|Antarctica/Syowa", "Europe/Istanbul|Asia/Aden", "Europe/Istanbul|Asia/Baghdad", "Europe/Istanbul|Asia/Bahrain", "Europe/Istanbul|Asia/Istanbul", "Europe/Istanbul|Asia/Kuwait", "Europe/Istanbul|Asia/Qatar", "Europe/Istanbul|Asia/Riyadh", "Europe/Istanbul|Etc/GMT-3", "Europe/Istanbul|Europe/Kirov", "Europe/Istanbul|Europe/Minsk", "Europe/Istanbul|Turkey", "Europe/Lisbon|Atlantic/Canary", "Europe/Lisbon|Atlantic/Faeroe", "Europe/Lisbon|Atlantic/Faroe", "Europe/Lisbon|Atlantic/Madeira", "Europe/Lisbon|Portugal", "Europe/Lisbon|WET", "Europe/London|Europe/Belfast", "Europe/London|Europe/Guernsey", "Europe/London|Europe/Isle_of_Man", "Europe/London|Europe/Jersey", "Europe/London|GB", "Europe/London|GB-Eire", "Europe/Moscow|Europe/Simferopol", "Europe/Moscow|W-SU", "Europe/Paris|Africa/Ceuta", "Europe/Paris|Arctic/Longyearbyen", "Europe/Paris|Atlantic/Jan_Mayen", "Europe/Paris|CET", "Europe/Paris|Europe/Amsterdam", "Europe/Paris|Europe/Andorra", "Europe/Paris|Europe/Belgrade", "Europe/Paris|Europe/Berlin", "Europe/Paris|Europe/Bratislava", "Europe/Paris|Europe/Brussels", "Europe/Paris|Europe/Budapest", "Europe/Paris|Europe/Busingen", "Europe/Paris|Europe/Copenhagen", "Europe/Paris|Europe/Gibraltar", "Europe/Paris|Europe/Ljubljana", "Europe/Paris|Europe/Luxembourg", "Europe/Paris|Europe/Madrid", "Europe/Paris|Europe/Malta", "Europe/Paris|Europe/Monaco", "Europe/Paris|Europe/Oslo", "Europe/Paris|Europe/Podgorica", "Europe/Paris|Europe/Prague", "Europe/Paris|Europe/Rome", "Europe/Paris|Europe/San_Marino", "Europe/Paris|Europe/Sarajevo", "Europe/Paris|Europe/Skopje", "Europe/Paris|Europe/Stockholm", "Europe/Paris|Europe/Tirane", "Europe/Paris|Europe/Vaduz", "Europe/Paris|Europe/Vatican", "Europe/Paris|Europe/Vienna", "Europe/Paris|Europe/Warsaw", "Europe/Paris|Europe/Zagreb", "Europe/Paris|Europe/Zurich", "Europe/Paris|Poland", "Pacific/Auckland|Antarctica/McMurdo", "Pacific/Auckland|Antarctica/South_Pole", "Pacific/Auckland|NZ", "Pacific/Chatham|NZ-CHAT", "Pacific/Easter|Chile/EasterIsland", "Pacific/Fakaofo|Etc/GMT-13", "Pacific/Fakaofo|Pacific/Enderbury", "Pacific/Fakaofo|Pacific/Kanton", "Pacific/Galapagos|Etc/GMT+6", "Pacific/Gambier|Etc/GMT+9", "Pacific/Guam|Pacific/Saipan", "Pacific/Honolulu|HST", "Pacific/Honolulu|Pacific/Johnston", "Pacific/Honolulu|US/Hawaii", "Pacific/Kiritimati|Etc/GMT-14", "Pacific/Niue|Etc/GMT+11", "Pacific/Pago_Pago|Pacific/Midway", "Pacific/Pago_Pago|Pacific/Samoa", "Pacific/Pago_Pago|US/Samoa", "Pacific/Pitcairn|Etc/GMT+8", "Pacific/Tahiti|Etc/GMT+10", "Pacific/Tahiti|Pacific/Rarotonga"],
	      "countries": ["AD|Europe/Andorra", "AE|Asia/Dubai", "AF|Asia/Kabul", "AG|America/Puerto_Rico America/Antigua", "AI|America/Puerto_Rico America/Anguilla", "AL|Europe/Tirane", "AM|Asia/Yerevan", "AO|Africa/Lagos Africa/Luanda", "AQ|Antarctica/Casey Antarctica/Davis Antarctica/Mawson Antarctica/Palmer Antarctica/Rothera Antarctica/Troll Asia/Urumqi Pacific/Auckland Pacific/Port_Moresby Asia/Riyadh Antarctica/McMurdo Antarctica/DumontDUrville Antarctica/Syowa Antarctica/Vostok", "AR|America/Argentina/Buenos_Aires America/Argentina/Cordoba America/Argentina/Salta America/Argentina/Jujuy America/Argentina/Tucuman America/Argentina/Catamarca America/Argentina/La_Rioja America/Argentina/San_Juan America/Argentina/Mendoza America/Argentina/San_Luis America/Argentina/Rio_Gallegos America/Argentina/Ushuaia", "AS|Pacific/Pago_Pago", "AT|Europe/Vienna", "AU|Australia/Lord_Howe Antarctica/Macquarie Australia/Hobart Australia/Melbourne Australia/Sydney Australia/Broken_Hill Australia/Brisbane Australia/Lindeman Australia/Adelaide Australia/Darwin Australia/Perth Australia/Eucla", "AW|America/Puerto_Rico America/Aruba", "AX|Europe/Helsinki Europe/Mariehamn", "AZ|Asia/Baku", "BA|Europe/Belgrade Europe/Sarajevo", "BB|America/Barbados", "BD|Asia/Dhaka", "BE|Europe/Brussels", "BF|Africa/Abidjan Africa/Ouagadougou", "BG|Europe/Sofia", "BH|Asia/Qatar Asia/Bahrain", "BI|Africa/Maputo Africa/Bujumbura", "BJ|Africa/Lagos Africa/Porto-Novo", "BL|America/Puerto_Rico America/St_Barthelemy", "BM|Atlantic/Bermuda", "BN|Asia/Kuching Asia/Brunei", "BO|America/La_Paz", "BQ|America/Puerto_Rico America/Kralendijk", "BR|America/Noronha America/Belem America/Fortaleza America/Recife America/Araguaina America/Maceio America/Bahia America/Sao_Paulo America/Campo_Grande America/Cuiaba America/Santarem America/Porto_Velho America/Boa_Vista America/Manaus America/Eirunepe America/Rio_Branco", "BS|America/Toronto America/Nassau", "BT|Asia/Thimphu", "BW|Africa/Maputo Africa/Gaborone", "BY|Europe/Minsk", "BZ|America/Belize", "CA|America/St_Johns America/Halifax America/Glace_Bay America/Moncton America/Goose_Bay America/Toronto America/Iqaluit America/Winnipeg America/Resolute America/Rankin_Inlet America/Regina America/Swift_Current America/Edmonton America/Cambridge_Bay America/Yellowknife America/Inuvik America/Dawson_Creek America/Fort_Nelson America/Whitehorse America/Dawson America/Vancouver America/Panama America/Puerto_Rico America/Phoenix America/Blanc-Sablon America/Atikokan America/Creston", "CC|Asia/Yangon Indian/Cocos", "CD|Africa/Maputo Africa/Lagos Africa/Kinshasa Africa/Lubumbashi", "CF|Africa/Lagos Africa/Bangui", "CG|Africa/Lagos Africa/Brazzaville", "CH|Europe/Zurich", "CI|Africa/Abidjan", "CK|Pacific/Rarotonga", "CL|America/Santiago America/Punta_Arenas Pacific/Easter", "CM|Africa/Lagos Africa/Douala", "CN|Asia/Shanghai Asia/Urumqi", "CO|America/Bogota", "CR|America/Costa_Rica", "CU|America/Havana", "CV|Atlantic/Cape_Verde", "CW|America/Puerto_Rico America/Curacao", "CX|Asia/Bangkok Indian/Christmas", "CY|Asia/Nicosia Asia/Famagusta", "CZ|Europe/Prague", "DE|Europe/Zurich Europe/Berlin Europe/Busingen", "DJ|Africa/Nairobi Africa/Djibouti", "DK|Europe/Berlin Europe/Copenhagen", "DM|America/Puerto_Rico America/Dominica", "DO|America/Santo_Domingo", "DZ|Africa/Algiers", "EC|America/Guayaquil Pacific/Galapagos", "EE|Europe/Tallinn", "EG|Africa/Cairo", "EH|Africa/El_Aaiun", "ER|Africa/Nairobi Africa/Asmara", "ES|Europe/Madrid Africa/Ceuta Atlantic/Canary", "ET|Africa/Nairobi Africa/Addis_Ababa", "FI|Europe/Helsinki", "FJ|Pacific/Fiji", "FK|Atlantic/Stanley", "FM|Pacific/Kosrae Pacific/Port_Moresby Pacific/Guadalcanal Pacific/Chuuk Pacific/Pohnpei", "FO|Atlantic/Faroe", "FR|Europe/Paris", "GA|Africa/Lagos Africa/Libreville", "GB|Europe/London", "GD|America/Puerto_Rico America/Grenada", "GE|Asia/Tbilisi", "GF|America/Cayenne", "GG|Europe/London Europe/Guernsey", "GH|Africa/Abidjan Africa/Accra", "GI|Europe/Gibraltar", "GL|America/Nuuk America/Danmarkshavn America/Scoresbysund America/Thule", "GM|Africa/Abidjan Africa/Banjul", "GN|Africa/Abidjan Africa/Conakry", "GP|America/Puerto_Rico America/Guadeloupe", "GQ|Africa/Lagos Africa/Malabo", "GR|Europe/Athens", "GS|Atlantic/South_Georgia", "GT|America/Guatemala", "GU|Pacific/Guam", "GW|Africa/Bissau", "GY|America/Guyana", "HK|Asia/Hong_Kong", "HN|America/Tegucigalpa", "HR|Europe/Belgrade Europe/Zagreb", "HT|America/Port-au-Prince", "HU|Europe/Budapest", "ID|Asia/Jakarta Asia/Pontianak Asia/Makassar Asia/Jayapura", "IE|Europe/Dublin", "IL|Asia/Jerusalem", "IM|Europe/London Europe/Isle_of_Man", "IN|Asia/Kolkata", "IO|Indian/Chagos", "IQ|Asia/Baghdad", "IR|Asia/Tehran", "IS|Africa/Abidjan Atlantic/Reykjavik", "IT|Europe/Rome", "JE|Europe/London Europe/Jersey", "JM|America/Jamaica", "JO|Asia/Amman", "JP|Asia/Tokyo", "KE|Africa/Nairobi", "KG|Asia/Bishkek", "KH|Asia/Bangkok Asia/Phnom_Penh", "KI|Pacific/Tarawa Pacific/Kanton Pacific/Kiritimati", "KM|Africa/Nairobi Indian/Comoro", "KN|America/Puerto_Rico America/St_Kitts", "KP|Asia/Pyongyang", "KR|Asia/Seoul", "KW|Asia/Riyadh Asia/Kuwait", "KY|America/Panama America/Cayman", "KZ|Asia/Almaty Asia/Qyzylorda Asia/Qostanay Asia/Aqtobe Asia/Aqtau Asia/Atyrau Asia/Oral", "LA|Asia/Bangkok Asia/Vientiane", "LB|Asia/Beirut", "LC|America/Puerto_Rico America/St_Lucia", "LI|Europe/Zurich Europe/Vaduz", "LK|Asia/Colombo", "LR|Africa/Monrovia", "LS|Africa/Johannesburg Africa/Maseru", "LT|Europe/Vilnius", "LU|Europe/Brussels Europe/Luxembourg", "LV|Europe/Riga", "LY|Africa/Tripoli", "MA|Africa/Casablanca", "MC|Europe/Paris Europe/Monaco", "MD|Europe/Chisinau", "ME|Europe/Belgrade Europe/Podgorica", "MF|America/Puerto_Rico America/Marigot", "MG|Africa/Nairobi Indian/Antananarivo", "MH|Pacific/Tarawa Pacific/Kwajalein Pacific/Majuro", "MK|Europe/Belgrade Europe/Skopje", "ML|Africa/Abidjan Africa/Bamako", "MM|Asia/Yangon", "MN|Asia/Ulaanbaatar Asia/Hovd Asia/Choibalsan", "MO|Asia/Macau", "MP|Pacific/Guam Pacific/Saipan", "MQ|America/Martinique", "MR|Africa/Abidjan Africa/Nouakchott", "MS|America/Puerto_Rico America/Montserrat", "MT|Europe/Malta", "MU|Indian/Mauritius", "MV|Indian/Maldives", "MW|Africa/Maputo Africa/Blantyre", "MX|America/Mexico_City America/Cancun America/Merida America/Monterrey America/Matamoros America/Chihuahua America/Ciudad_Juarez America/Ojinaga America/Mazatlan America/Bahia_Banderas America/Hermosillo America/Tijuana", "MY|Asia/Kuching Asia/Singapore Asia/Kuala_Lumpur", "MZ|Africa/Maputo", "NA|Africa/Windhoek", "NC|Pacific/Noumea", "NE|Africa/Lagos Africa/Niamey", "NF|Pacific/Norfolk", "NG|Africa/Lagos", "NI|America/Managua", "NL|Europe/Brussels Europe/Amsterdam", "NO|Europe/Berlin Europe/Oslo", "NP|Asia/Kathmandu", "NR|Pacific/Nauru", "NU|Pacific/Niue", "NZ|Pacific/Auckland Pacific/Chatham", "OM|Asia/Dubai Asia/Muscat", "PA|America/Panama", "PE|America/Lima", "PF|Pacific/Tahiti Pacific/Marquesas Pacific/Gambier", "PG|Pacific/Port_Moresby Pacific/Bougainville", "PH|Asia/Manila", "PK|Asia/Karachi", "PL|Europe/Warsaw", "PM|America/Miquelon", "PN|Pacific/Pitcairn", "PR|America/Puerto_Rico", "PS|Asia/Gaza Asia/Hebron", "PT|Europe/Lisbon Atlantic/Madeira Atlantic/Azores", "PW|Pacific/Palau", "PY|America/Asuncion", "QA|Asia/Qatar", "RE|Asia/Dubai Indian/Reunion", "RO|Europe/Bucharest", "RS|Europe/Belgrade", "RU|Europe/Kaliningrad Europe/Moscow Europe/Simferopol Europe/Kirov Europe/Volgograd Europe/Astrakhan Europe/Saratov Europe/Ulyanovsk Europe/Samara Asia/Yekaterinburg Asia/Omsk Asia/Novosibirsk Asia/Barnaul Asia/Tomsk Asia/Novokuznetsk Asia/Krasnoyarsk Asia/Irkutsk Asia/Chita Asia/Yakutsk Asia/Khandyga Asia/Vladivostok Asia/Ust-Nera Asia/Magadan Asia/Sakhalin Asia/Srednekolymsk Asia/Kamchatka Asia/Anadyr", "RW|Africa/Maputo Africa/Kigali", "SA|Asia/Riyadh", "SB|Pacific/Guadalcanal", "SC|Asia/Dubai Indian/Mahe", "SD|Africa/Khartoum", "SE|Europe/Berlin Europe/Stockholm", "SG|Asia/Singapore", "SH|Africa/Abidjan Atlantic/St_Helena", "SI|Europe/Belgrade Europe/Ljubljana", "SJ|Europe/Berlin Arctic/Longyearbyen", "SK|Europe/Prague Europe/Bratislava", "SL|Africa/Abidjan Africa/Freetown", "SM|Europe/Rome Europe/San_Marino", "SN|Africa/Abidjan Africa/Dakar", "SO|Africa/Nairobi Africa/Mogadishu", "SR|America/Paramaribo", "SS|Africa/Juba", "ST|Africa/Sao_Tome", "SV|America/El_Salvador", "SX|America/Puerto_Rico America/Lower_Princes", "SY|Asia/Damascus", "SZ|Africa/Johannesburg Africa/Mbabane", "TC|America/Grand_Turk", "TD|Africa/Ndjamena", "TF|Asia/Dubai Indian/Maldives Indian/Kerguelen", "TG|Africa/Abidjan Africa/Lome", "TH|Asia/Bangkok", "TJ|Asia/Dushanbe", "TK|Pacific/Fakaofo", "TL|Asia/Dili", "TM|Asia/Ashgabat", "TN|Africa/Tunis", "TO|Pacific/Tongatapu", "TR|Europe/Istanbul", "TT|America/Puerto_Rico America/Port_of_Spain", "TV|Pacific/Tarawa Pacific/Funafuti", "TW|Asia/Taipei", "TZ|Africa/Nairobi Africa/Dar_es_Salaam", "UA|Europe/Simferopol Europe/Kyiv", "UG|Africa/Nairobi Africa/Kampala", "UM|Pacific/Pago_Pago Pacific/Tarawa Pacific/Honolulu Pacific/Midway Pacific/Wake", "US|America/New_York America/Detroit America/Kentucky/Louisville America/Kentucky/Monticello America/Indiana/Indianapolis America/Indiana/Vincennes America/Indiana/Winamac America/Indiana/Marengo America/Indiana/Petersburg America/Indiana/Vevay America/Chicago America/Indiana/Tell_City America/Indiana/Knox America/Menominee America/North_Dakota/Center America/North_Dakota/New_Salem America/North_Dakota/Beulah America/Denver America/Boise America/Phoenix America/Los_Angeles America/Anchorage America/Juneau America/Sitka America/Metlakatla America/Yakutat America/Nome America/Adak Pacific/Honolulu", "UY|America/Montevideo", "UZ|Asia/Samarkand Asia/Tashkent", "VA|Europe/Rome Europe/Vatican", "VC|America/Puerto_Rico America/St_Vincent", "VE|America/Caracas", "VG|America/Puerto_Rico America/Tortola", "VI|America/Puerto_Rico America/St_Thomas", "VN|Asia/Bangkok Asia/Ho_Chi_Minh", "VU|Pacific/Efate", "WF|Pacific/Tarawa Pacific/Wallis", "WS|Pacific/Apia", "YE|Asia/Riyadh Asia/Aden", "YT|Africa/Nairobi Indian/Mayotte", "ZA|Africa/Johannesburg", "ZM|Africa/Maputo Africa/Lusaka", "ZW|Africa/Maputo Africa/Harare"]
	    });
	    return moment;
	  });
	})(momentTimezoneWithData10YearRange);

	var codemirrorExports = {};
	var codemirror = {
	  get exports(){ return codemirrorExports; },
	  set exports(v){ codemirrorExports = v; },
	};

	(function (module, exports) {
	  // CodeMirror, copyright (c) by Marijn Haverbeke and others
	  // Distributed under an MIT license: https://codemirror.net/5/LICENSE

	  // This is CodeMirror (https://codemirror.net/5), a code editor
	  // implemented in JavaScript on top of the browser's DOM.
	  //
	  // You can find some technical background for some of the code below
	  // at http://marijnhaverbeke.nl/blog/#cm-internals .

	  (function (global, factory) {
	    module.exports = factory() ;
	  })(commonjsGlobal, function () {

	    // Kludges for bugs and behavior differences that can't be feature
	    // detected are enabled based on userAgent etc sniffing.
	    var userAgent = navigator.userAgent;
	    var platform = navigator.platform;
	    var gecko = /gecko\/\d/i.test(userAgent);
	    var ie_upto10 = /MSIE \d/.test(userAgent);
	    var ie_11up = /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(userAgent);
	    var edge = /Edge\/(\d+)/.exec(userAgent);
	    var ie = ie_upto10 || ie_11up || edge;
	    var ie_version = ie && (ie_upto10 ? document.documentMode || 6 : +(edge || ie_11up)[1]);
	    var webkit = !edge && /WebKit\//.test(userAgent);
	    var qtwebkit = webkit && /Qt\/\d+\.\d+/.test(userAgent);
	    var chrome = !edge && /Chrome\/(\d+)/.exec(userAgent);
	    var chrome_version = chrome && +chrome[1];
	    var presto = /Opera\//.test(userAgent);
	    var safari = /Apple Computer/.test(navigator.vendor);
	    var mac_geMountainLion = /Mac OS X 1\d\D([8-9]|\d\d)\D/.test(userAgent);
	    var phantom = /PhantomJS/.test(userAgent);
	    var ios = safari && (/Mobile\/\w+/.test(userAgent) || navigator.maxTouchPoints > 2);
	    var android = /Android/.test(userAgent);
	    // This is woefully incomplete. Suggestions for alternative methods welcome.
	    var mobile = ios || android || /webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(userAgent);
	    var mac = ios || /Mac/.test(platform);
	    var chromeOS = /\bCrOS\b/.test(userAgent);
	    var windows = /win/i.test(platform);
	    var presto_version = presto && userAgent.match(/Version\/(\d*\.\d*)/);
	    if (presto_version) {
	      presto_version = Number(presto_version[1]);
	    }
	    if (presto_version && presto_version >= 15) {
	      presto = false;
	      webkit = true;
	    }
	    // Some browsers use the wrong event properties to signal cmd/ctrl on OS X
	    var flipCtrlCmd = mac && (qtwebkit || presto && (presto_version == null || presto_version < 12.11));
	    var captureRightClick = gecko || ie && ie_version >= 9;
	    function classTest(cls) {
	      return new RegExp("(^|\\s)" + cls + "(?:$|\\s)\\s*");
	    }
	    var rmClass = function (node, cls) {
	      var current = node.className;
	      var match = classTest(cls).exec(current);
	      if (match) {
	        var after = current.slice(match.index + match[0].length);
	        node.className = current.slice(0, match.index) + (after ? match[1] + after : "");
	      }
	    };
	    function removeChildren(e) {
	      for (var count = e.childNodes.length; count > 0; --count) {
	        e.removeChild(e.firstChild);
	      }
	      return e;
	    }
	    function removeChildrenAndAdd(parent, e) {
	      return removeChildren(parent).appendChild(e);
	    }
	    function elt(tag, content, className, style) {
	      var e = document.createElement(tag);
	      if (className) {
	        e.className = className;
	      }
	      if (style) {
	        e.style.cssText = style;
	      }
	      if (typeof content == "string") {
	        e.appendChild(document.createTextNode(content));
	      } else if (content) {
	        for (var i = 0; i < content.length; ++i) {
	          e.appendChild(content[i]);
	        }
	      }
	      return e;
	    }
	    // wrapper for elt, which removes the elt from the accessibility tree
	    function eltP(tag, content, className, style) {
	      var e = elt(tag, content, className, style);
	      e.setAttribute("role", "presentation");
	      return e;
	    }
	    var range;
	    if (document.createRange) {
	      range = function (node, start, end, endNode) {
	        var r = document.createRange();
	        r.setEnd(endNode || node, end);
	        r.setStart(node, start);
	        return r;
	      };
	    } else {
	      range = function (node, start, end) {
	        var r = document.body.createTextRange();
	        try {
	          r.moveToElementText(node.parentNode);
	        } catch (e) {
	          return r;
	        }
	        r.collapse(true);
	        r.moveEnd("character", end);
	        r.moveStart("character", start);
	        return r;
	      };
	    }
	    function contains(parent, child) {
	      if (child.nodeType == 3)
	        // Android browser always returns false when child is a textnode
	        {
	          child = child.parentNode;
	        }
	      if (parent.contains) {
	        return parent.contains(child);
	      }
	      do {
	        if (child.nodeType == 11) {
	          child = child.host;
	        }
	        if (child == parent) {
	          return true;
	        }
	      } while (child = child.parentNode);
	    }
	    function activeElt(doc) {
	      // IE and Edge may throw an "Unspecified Error" when accessing document.activeElement.
	      // IE < 10 will throw when accessed while the page is loading or in an iframe.
	      // IE > 9 and Edge will throw when accessed in an iframe if document.body is unavailable.
	      var activeElement;
	      try {
	        activeElement = doc.activeElement;
	      } catch (e) {
	        activeElement = doc.body || null;
	      }
	      while (activeElement && activeElement.shadowRoot && activeElement.shadowRoot.activeElement) {
	        activeElement = activeElement.shadowRoot.activeElement;
	      }
	      return activeElement;
	    }
	    function addClass(node, cls) {
	      var current = node.className;
	      if (!classTest(cls).test(current)) {
	        node.className += (current ? " " : "") + cls;
	      }
	    }
	    function joinClasses(a, b) {
	      var as = a.split(" ");
	      for (var i = 0; i < as.length; i++) {
	        if (as[i] && !classTest(as[i]).test(b)) {
	          b += " " + as[i];
	        }
	      }
	      return b;
	    }
	    var selectInput = function (node) {
	      node.select();
	    };
	    if (ios)
	      // Mobile Safari apparently has a bug where select() is broken.
	      {
	        selectInput = function (node) {
	          node.selectionStart = 0;
	          node.selectionEnd = node.value.length;
	        };
	      } else if (ie)
	      // Suppress mysterious IE10 errors
	      {
	        selectInput = function (node) {
	          try {
	            node.select();
	          } catch (_e) {}
	        };
	      }
	    function doc(cm) {
	      return cm.display.wrapper.ownerDocument;
	    }
	    function win(cm) {
	      return doc(cm).defaultView;
	    }
	    function bind(f) {
	      var args = Array.prototype.slice.call(arguments, 1);
	      return function () {
	        return f.apply(null, args);
	      };
	    }
	    function copyObj(obj, target, overwrite) {
	      if (!target) {
	        target = {};
	      }
	      for (var prop in obj) {
	        if (obj.hasOwnProperty(prop) && (overwrite !== false || !target.hasOwnProperty(prop))) {
	          target[prop] = obj[prop];
	        }
	      }
	      return target;
	    }

	    // Counts the column offset in a string, taking tabs into account.
	    // Used mostly to find indentation.
	    function countColumn(string, end, tabSize, startIndex, startValue) {
	      if (end == null) {
	        end = string.search(/[^\s\u00a0]/);
	        if (end == -1) {
	          end = string.length;
	        }
	      }
	      for (var i = startIndex || 0, n = startValue || 0;;) {
	        var nextTab = string.indexOf("\t", i);
	        if (nextTab < 0 || nextTab >= end) {
	          return n + (end - i);
	        }
	        n += nextTab - i;
	        n += tabSize - n % tabSize;
	        i = nextTab + 1;
	      }
	    }
	    var Delayed = function () {
	      this.id = null;
	      this.f = null;
	      this.time = 0;
	      this.handler = bind(this.onTimeout, this);
	    };
	    Delayed.prototype.onTimeout = function (self) {
	      self.id = 0;
	      if (self.time <= +new Date()) {
	        self.f();
	      } else {
	        setTimeout(self.handler, self.time - +new Date());
	      }
	    };
	    Delayed.prototype.set = function (ms, f) {
	      this.f = f;
	      var time = +new Date() + ms;
	      if (!this.id || time < this.time) {
	        clearTimeout(this.id);
	        this.id = setTimeout(this.handler, ms);
	        this.time = time;
	      }
	    };
	    function indexOf(array, elt) {
	      for (var i = 0; i < array.length; ++i) {
	        if (array[i] == elt) {
	          return i;
	        }
	      }
	      return -1;
	    }

	    // Number of pixels added to scroller and sizer to hide scrollbar
	    var scrollerGap = 50;

	    // Returned or thrown by various protocols to signal 'I'm not
	    // handling this'.
	    var Pass = {
	      toString: function () {
	        return "CodeMirror.Pass";
	      }
	    };

	    // Reused option objects for setSelection & friends
	    var sel_dontScroll = {
	        scroll: false
	      },
	      sel_mouse = {
	        origin: "*mouse"
	      },
	      sel_move = {
	        origin: "+move"
	      };

	    // The inverse of countColumn -- find the offset that corresponds to
	    // a particular column.
	    function findColumn(string, goal, tabSize) {
	      for (var pos = 0, col = 0;;) {
	        var nextTab = string.indexOf("\t", pos);
	        if (nextTab == -1) {
	          nextTab = string.length;
	        }
	        var skipped = nextTab - pos;
	        if (nextTab == string.length || col + skipped >= goal) {
	          return pos + Math.min(skipped, goal - col);
	        }
	        col += nextTab - pos;
	        col += tabSize - col % tabSize;
	        pos = nextTab + 1;
	        if (col >= goal) {
	          return pos;
	        }
	      }
	    }
	    var spaceStrs = [""];
	    function spaceStr(n) {
	      while (spaceStrs.length <= n) {
	        spaceStrs.push(lst(spaceStrs) + " ");
	      }
	      return spaceStrs[n];
	    }
	    function lst(arr) {
	      return arr[arr.length - 1];
	    }
	    function map(array, f) {
	      var out = [];
	      for (var i = 0; i < array.length; i++) {
	        out[i] = f(array[i], i);
	      }
	      return out;
	    }
	    function insertSorted(array, value, score) {
	      var pos = 0,
	        priority = score(value);
	      while (pos < array.length && score(array[pos]) <= priority) {
	        pos++;
	      }
	      array.splice(pos, 0, value);
	    }
	    function nothing() {}
	    function createObj(base, props) {
	      var inst;
	      if (Object.create) {
	        inst = Object.create(base);
	      } else {
	        nothing.prototype = base;
	        inst = new nothing();
	      }
	      if (props) {
	        copyObj(props, inst);
	      }
	      return inst;
	    }
	    var nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
	    function isWordCharBasic(ch) {
	      return /\w/.test(ch) || ch > "\x80" && (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch));
	    }
	    function isWordChar(ch, helper) {
	      if (!helper) {
	        return isWordCharBasic(ch);
	      }
	      if (helper.source.indexOf("\\w") > -1 && isWordCharBasic(ch)) {
	        return true;
	      }
	      return helper.test(ch);
	    }
	    function isEmpty(obj) {
	      for (var n in obj) {
	        if (obj.hasOwnProperty(n) && obj[n]) {
	          return false;
	        }
	      }
	      return true;
	    }

	    // Extending unicode characters. A series of a non-extending char +
	    // any number of extending chars is treated as a single unit as far
	    // as editing and measuring is concerned. This is not fully correct,
	    // since some scripts/fonts/browsers also treat other configurations
	    // of code points as a group.
	    var extendingChars = /[\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u065e\u0670\u06d6-\u06dc\u06de-\u06e4\u06e7\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0900-\u0902\u093c\u0941-\u0948\u094d\u0951-\u0955\u0962\u0963\u0981\u09bc\u09be\u09c1-\u09c4\u09cd\u09d7\u09e2\u09e3\u0a01\u0a02\u0a3c\u0a41\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a70\u0a71\u0a75\u0a81\u0a82\u0abc\u0ac1-\u0ac5\u0ac7\u0ac8\u0acd\u0ae2\u0ae3\u0b01\u0b3c\u0b3e\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b57\u0b62\u0b63\u0b82\u0bbe\u0bc0\u0bcd\u0bd7\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0cbc\u0cbf\u0cc2\u0cc6\u0ccc\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0d3e\u0d41-\u0d44\u0d4d\u0d57\u0d62\u0d63\u0dca\u0dcf\u0dd2-\u0dd4\u0dd6\u0ddf\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0f18\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86\u0f87\u0f90-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039\u103a\u103d\u103e\u1058\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085\u1086\u108d\u109d\u135f\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193b\u1a17\u1a18\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80\u1b81\u1ba2-\u1ba5\u1ba8\u1ba9\u1c2c-\u1c33\u1c36\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1dc0-\u1de6\u1dfd-\u1dff\u200c\u200d\u20d0-\u20f0\u2cef-\u2cf1\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua66f-\ua672\ua67c\ua67d\ua6f0\ua6f1\ua802\ua806\ua80b\ua825\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\uaa29-\uaa2e\uaa31\uaa32\uaa35\uaa36\uaa43\uaa4c\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uabe5\uabe8\uabed\udc00-\udfff\ufb1e\ufe00-\ufe0f\ufe20-\ufe26\uff9e\uff9f]/;
	    function isExtendingChar(ch) {
	      return ch.charCodeAt(0) >= 768 && extendingChars.test(ch);
	    }

	    // Returns a number from the range [`0`; `str.length`] unless `pos` is outside that range.
	    function skipExtendingChars(str, pos, dir) {
	      while ((dir < 0 ? pos > 0 : pos < str.length) && isExtendingChar(str.charAt(pos))) {
	        pos += dir;
	      }
	      return pos;
	    }

	    // Returns the value from the range [`from`; `to`] that satisfies
	    // `pred` and is closest to `from`. Assumes that at least `to`
	    // satisfies `pred`. Supports `from` being greater than `to`.
	    function findFirst(pred, from, to) {
	      // At any point we are certain `to` satisfies `pred`, don't know
	      // whether `from` does.
	      var dir = from > to ? -1 : 1;
	      for (;;) {
	        if (from == to) {
	          return from;
	        }
	        var midF = (from + to) / 2,
	          mid = dir < 0 ? Math.ceil(midF) : Math.floor(midF);
	        if (mid == from) {
	          return pred(mid) ? from : to;
	        }
	        if (pred(mid)) {
	          to = mid;
	        } else {
	          from = mid + dir;
	        }
	      }
	    }

	    // BIDI HELPERS

	    function iterateBidiSections(order, from, to, f) {
	      if (!order) {
	        return f(from, to, "ltr", 0);
	      }
	      var found = false;
	      for (var i = 0; i < order.length; ++i) {
	        var part = order[i];
	        if (part.from < to && part.to > from || from == to && part.to == from) {
	          f(Math.max(part.from, from), Math.min(part.to, to), part.level == 1 ? "rtl" : "ltr", i);
	          found = true;
	        }
	      }
	      if (!found) {
	        f(from, to, "ltr");
	      }
	    }
	    var bidiOther = null;
	    function getBidiPartAt(order, ch, sticky) {
	      var found;
	      bidiOther = null;
	      for (var i = 0; i < order.length; ++i) {
	        var cur = order[i];
	        if (cur.from < ch && cur.to > ch) {
	          return i;
	        }
	        if (cur.to == ch) {
	          if (cur.from != cur.to && sticky == "before") {
	            found = i;
	          } else {
	            bidiOther = i;
	          }
	        }
	        if (cur.from == ch) {
	          if (cur.from != cur.to && sticky != "before") {
	            found = i;
	          } else {
	            bidiOther = i;
	          }
	        }
	      }
	      return found != null ? found : bidiOther;
	    }

	    // Bidirectional ordering algorithm
	    // See http://unicode.org/reports/tr9/tr9-13.html for the algorithm
	    // that this (partially) implements.

	    // One-char codes used for character types:
	    // L (L):   Left-to-Right
	    // R (R):   Right-to-Left
	    // r (AL):  Right-to-Left Arabic
	    // 1 (EN):  European Number
	    // + (ES):  European Number Separator
	    // % (ET):  European Number Terminator
	    // n (AN):  Arabic Number
	    // , (CS):  Common Number Separator
	    // m (NSM): Non-Spacing Mark
	    // b (BN):  Boundary Neutral
	    // s (B):   Paragraph Separator
	    // t (S):   Segment Separator
	    // w (WS):  Whitespace
	    // N (ON):  Other Neutrals

	    // Returns null if characters are ordered as they appear
	    // (left-to-right), or an array of sections ({from, to, level}
	    // objects) in the order in which they occur visually.
	    var bidiOrdering = function () {
	      // Character types for codepoints 0 to 0xff
	      var lowTypes = "bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN";
	      // Character types for codepoints 0x600 to 0x6f9
	      var arabicTypes = "nnnnnnNNr%%r,rNNmmmmmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmmmnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmnNmmmmmmrrmmNmmmmrr1111111111";
	      function charType(code) {
	        if (code <= 0xf7) {
	          return lowTypes.charAt(code);
	        } else if (0x590 <= code && code <= 0x5f4) {
	          return "R";
	        } else if (0x600 <= code && code <= 0x6f9) {
	          return arabicTypes.charAt(code - 0x600);
	        } else if (0x6ee <= code && code <= 0x8ac) {
	          return "r";
	        } else if (0x2000 <= code && code <= 0x200b) {
	          return "w";
	        } else if (code == 0x200c) {
	          return "b";
	        } else {
	          return "L";
	        }
	      }
	      var bidiRE = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/;
	      var isNeutral = /[stwN]/,
	        isStrong = /[LRr]/,
	        countsAsLeft = /[Lb1n]/,
	        countsAsNum = /[1n]/;
	      function BidiSpan(level, from, to) {
	        this.level = level;
	        this.from = from;
	        this.to = to;
	      }
	      return function (str, direction) {
	        var outerType = direction == "ltr" ? "L" : "R";
	        if (str.length == 0 || direction == "ltr" && !bidiRE.test(str)) {
	          return false;
	        }
	        var len = str.length,
	          types = [];
	        for (var i = 0; i < len; ++i) {
	          types.push(charType(str.charCodeAt(i)));
	        }

	        // W1. Examine each non-spacing mark (NSM) in the level run, and
	        // change the type of the NSM to the type of the previous
	        // character. If the NSM is at the start of the level run, it will
	        // get the type of sor.
	        for (var i$1 = 0, prev = outerType; i$1 < len; ++i$1) {
	          var type = types[i$1];
	          if (type == "m") {
	            types[i$1] = prev;
	          } else {
	            prev = type;
	          }
	        }

	        // W2. Search backwards from each instance of a European number
	        // until the first strong type (R, L, AL, or sor) is found. If an
	        // AL is found, change the type of the European number to Arabic
	        // number.
	        // W3. Change all ALs to R.
	        for (var i$2 = 0, cur = outerType; i$2 < len; ++i$2) {
	          var type$1 = types[i$2];
	          if (type$1 == "1" && cur == "r") {
	            types[i$2] = "n";
	          } else if (isStrong.test(type$1)) {
	            cur = type$1;
	            if (type$1 == "r") {
	              types[i$2] = "R";
	            }
	          }
	        }

	        // W4. A single European separator between two European numbers
	        // changes to a European number. A single common separator between
	        // two numbers of the same type changes to that type.
	        for (var i$3 = 1, prev$1 = types[0]; i$3 < len - 1; ++i$3) {
	          var type$2 = types[i$3];
	          if (type$2 == "+" && prev$1 == "1" && types[i$3 + 1] == "1") {
	            types[i$3] = "1";
	          } else if (type$2 == "," && prev$1 == types[i$3 + 1] && (prev$1 == "1" || prev$1 == "n")) {
	            types[i$3] = prev$1;
	          }
	          prev$1 = type$2;
	        }

	        // W5. A sequence of European terminators adjacent to European
	        // numbers changes to all European numbers.
	        // W6. Otherwise, separators and terminators change to Other
	        // Neutral.
	        for (var i$4 = 0; i$4 < len; ++i$4) {
	          var type$3 = types[i$4];
	          if (type$3 == ",") {
	            types[i$4] = "N";
	          } else if (type$3 == "%") {
	            var end = void 0;
	            for (end = i$4 + 1; end < len && types[end] == "%"; ++end) {}
	            var replace = i$4 && types[i$4 - 1] == "!" || end < len && types[end] == "1" ? "1" : "N";
	            for (var j = i$4; j < end; ++j) {
	              types[j] = replace;
	            }
	            i$4 = end - 1;
	          }
	        }

	        // W7. Search backwards from each instance of a European number
	        // until the first strong type (R, L, or sor) is found. If an L is
	        // found, then change the type of the European number to L.
	        for (var i$5 = 0, cur$1 = outerType; i$5 < len; ++i$5) {
	          var type$4 = types[i$5];
	          if (cur$1 == "L" && type$4 == "1") {
	            types[i$5] = "L";
	          } else if (isStrong.test(type$4)) {
	            cur$1 = type$4;
	          }
	        }

	        // N1. A sequence of neutrals takes the direction of the
	        // surrounding strong text if the text on both sides has the same
	        // direction. European and Arabic numbers act as if they were R in
	        // terms of their influence on neutrals. Start-of-level-run (sor)
	        // and end-of-level-run (eor) are used at level run boundaries.
	        // N2. Any remaining neutrals take the embedding direction.
	        for (var i$6 = 0; i$6 < len; ++i$6) {
	          if (isNeutral.test(types[i$6])) {
	            var end$1 = void 0;
	            for (end$1 = i$6 + 1; end$1 < len && isNeutral.test(types[end$1]); ++end$1) {}
	            var before = (i$6 ? types[i$6 - 1] : outerType) == "L";
	            var after = (end$1 < len ? types[end$1] : outerType) == "L";
	            var replace$1 = before == after ? before ? "L" : "R" : outerType;
	            for (var j$1 = i$6; j$1 < end$1; ++j$1) {
	              types[j$1] = replace$1;
	            }
	            i$6 = end$1 - 1;
	          }
	        }

	        // Here we depart from the documented algorithm, in order to avoid
	        // building up an actual levels array. Since there are only three
	        // levels (0, 1, 2) in an implementation that doesn't take
	        // explicit embedding into account, we can build up the order on
	        // the fly, without following the level-based algorithm.
	        var order = [],
	          m;
	        for (var i$7 = 0; i$7 < len;) {
	          if (countsAsLeft.test(types[i$7])) {
	            var start = i$7;
	            for (++i$7; i$7 < len && countsAsLeft.test(types[i$7]); ++i$7) {}
	            order.push(new BidiSpan(0, start, i$7));
	          } else {
	            var pos = i$7,
	              at = order.length,
	              isRTL = direction == "rtl" ? 1 : 0;
	            for (++i$7; i$7 < len && types[i$7] != "L"; ++i$7) {}
	            for (var j$2 = pos; j$2 < i$7;) {
	              if (countsAsNum.test(types[j$2])) {
	                if (pos < j$2) {
	                  order.splice(at, 0, new BidiSpan(1, pos, j$2));
	                  at += isRTL;
	                }
	                var nstart = j$2;
	                for (++j$2; j$2 < i$7 && countsAsNum.test(types[j$2]); ++j$2) {}
	                order.splice(at, 0, new BidiSpan(2, nstart, j$2));
	                at += isRTL;
	                pos = j$2;
	              } else {
	                ++j$2;
	              }
	            }
	            if (pos < i$7) {
	              order.splice(at, 0, new BidiSpan(1, pos, i$7));
	            }
	          }
	        }
	        if (direction == "ltr") {
	          if (order[0].level == 1 && (m = str.match(/^\s+/))) {
	            order[0].from = m[0].length;
	            order.unshift(new BidiSpan(0, 0, m[0].length));
	          }
	          if (lst(order).level == 1 && (m = str.match(/\s+$/))) {
	            lst(order).to -= m[0].length;
	            order.push(new BidiSpan(0, len - m[0].length, len));
	          }
	        }
	        return direction == "rtl" ? order.reverse() : order;
	      };
	    }();

	    // Get the bidi ordering for the given line (and cache it). Returns
	    // false for lines that are fully left-to-right, and an array of
	    // BidiSpan objects otherwise.
	    function getOrder(line, direction) {
	      var order = line.order;
	      if (order == null) {
	        order = line.order = bidiOrdering(line.text, direction);
	      }
	      return order;
	    }

	    // EVENT HANDLING

	    // Lightweight event framework. on/off also work on DOM nodes,
	    // registering native DOM handlers.

	    var noHandlers = [];
	    var on = function (emitter, type, f) {
	      if (emitter.addEventListener) {
	        emitter.addEventListener(type, f, false);
	      } else if (emitter.attachEvent) {
	        emitter.attachEvent("on" + type, f);
	      } else {
	        var map = emitter._handlers || (emitter._handlers = {});
	        map[type] = (map[type] || noHandlers).concat(f);
	      }
	    };
	    function getHandlers(emitter, type) {
	      return emitter._handlers && emitter._handlers[type] || noHandlers;
	    }
	    function off(emitter, type, f) {
	      if (emitter.removeEventListener) {
	        emitter.removeEventListener(type, f, false);
	      } else if (emitter.detachEvent) {
	        emitter.detachEvent("on" + type, f);
	      } else {
	        var map = emitter._handlers,
	          arr = map && map[type];
	        if (arr) {
	          var index = indexOf(arr, f);
	          if (index > -1) {
	            map[type] = arr.slice(0, index).concat(arr.slice(index + 1));
	          }
	        }
	      }
	    }
	    function signal(emitter, type /*, values...*/) {
	      var handlers = getHandlers(emitter, type);
	      if (!handlers.length) {
	        return;
	      }
	      var args = Array.prototype.slice.call(arguments, 2);
	      for (var i = 0; i < handlers.length; ++i) {
	        handlers[i].apply(null, args);
	      }
	    }

	    // The DOM events that CodeMirror handles can be overridden by
	    // registering a (non-DOM) handler on the editor for the event name,
	    // and preventDefault-ing the event in that handler.
	    function signalDOMEvent(cm, e, override) {
	      if (typeof e == "string") {
	        e = {
	          type: e,
	          preventDefault: function () {
	            this.defaultPrevented = true;
	          }
	        };
	      }
	      signal(cm, override || e.type, cm, e);
	      return e_defaultPrevented(e) || e.codemirrorIgnore;
	    }
	    function signalCursorActivity(cm) {
	      var arr = cm._handlers && cm._handlers.cursorActivity;
	      if (!arr) {
	        return;
	      }
	      var set = cm.curOp.cursorActivityHandlers || (cm.curOp.cursorActivityHandlers = []);
	      for (var i = 0; i < arr.length; ++i) {
	        if (indexOf(set, arr[i]) == -1) {
	          set.push(arr[i]);
	        }
	      }
	    }
	    function hasHandler(emitter, type) {
	      return getHandlers(emitter, type).length > 0;
	    }

	    // Add on and off methods to a constructor's prototype, to make
	    // registering events on such objects more convenient.
	    function eventMixin(ctor) {
	      ctor.prototype.on = function (type, f) {
	        on(this, type, f);
	      };
	      ctor.prototype.off = function (type, f) {
	        off(this, type, f);
	      };
	    }

	    // Due to the fact that we still support jurassic IE versions, some
	    // compatibility wrappers are needed.

	    function e_preventDefault(e) {
	      if (e.preventDefault) {
	        e.preventDefault();
	      } else {
	        e.returnValue = false;
	      }
	    }
	    function e_stopPropagation(e) {
	      if (e.stopPropagation) {
	        e.stopPropagation();
	      } else {
	        e.cancelBubble = true;
	      }
	    }
	    function e_defaultPrevented(e) {
	      return e.defaultPrevented != null ? e.defaultPrevented : e.returnValue == false;
	    }
	    function e_stop(e) {
	      e_preventDefault(e);
	      e_stopPropagation(e);
	    }
	    function e_target(e) {
	      return e.target || e.srcElement;
	    }
	    function e_button(e) {
	      var b = e.which;
	      if (b == null) {
	        if (e.button & 1) {
	          b = 1;
	        } else if (e.button & 2) {
	          b = 3;
	        } else if (e.button & 4) {
	          b = 2;
	        }
	      }
	      if (mac && e.ctrlKey && b == 1) {
	        b = 3;
	      }
	      return b;
	    }

	    // Detect drag-and-drop
	    var dragAndDrop = function () {
	      // There is *some* kind of drag-and-drop support in IE6-8, but I
	      // couldn't get it to work yet.
	      if (ie && ie_version < 9) {
	        return false;
	      }
	      var div = elt('div');
	      return "draggable" in div || "dragDrop" in div;
	    }();
	    var zwspSupported;
	    function zeroWidthElement(measure) {
	      if (zwspSupported == null) {
	        var test = elt("span", "\u200b");
	        removeChildrenAndAdd(measure, elt("span", [test, document.createTextNode("x")]));
	        if (measure.firstChild.offsetHeight != 0) {
	          zwspSupported = test.offsetWidth <= 1 && test.offsetHeight > 2 && !(ie && ie_version < 8);
	        }
	      }
	      var node = zwspSupported ? elt("span", "\u200b") : elt("span", "\u00a0", null, "display: inline-block; width: 1px; margin-right: -1px");
	      node.setAttribute("cm-text", "");
	      return node;
	    }

	    // Feature-detect IE's crummy client rect reporting for bidi text
	    var badBidiRects;
	    function hasBadBidiRects(measure) {
	      if (badBidiRects != null) {
	        return badBidiRects;
	      }
	      var txt = removeChildrenAndAdd(measure, document.createTextNode("A\u062eA"));
	      var r0 = range(txt, 0, 1).getBoundingClientRect();
	      var r1 = range(txt, 1, 2).getBoundingClientRect();
	      removeChildren(measure);
	      if (!r0 || r0.left == r0.right) {
	        return false;
	      } // Safari returns null in some cases (#2780)
	      return badBidiRects = r1.right - r0.right < 3;
	    }

	    // See if "".split is the broken IE version, if so, provide an
	    // alternative way to split lines.
	    var splitLinesAuto = "\n\nb".split(/\n/).length != 3 ? function (string) {
	      var pos = 0,
	        result = [],
	        l = string.length;
	      while (pos <= l) {
	        var nl = string.indexOf("\n", pos);
	        if (nl == -1) {
	          nl = string.length;
	        }
	        var line = string.slice(pos, string.charAt(nl - 1) == "\r" ? nl - 1 : nl);
	        var rt = line.indexOf("\r");
	        if (rt != -1) {
	          result.push(line.slice(0, rt));
	          pos += rt + 1;
	        } else {
	          result.push(line);
	          pos = nl + 1;
	        }
	      }
	      return result;
	    } : function (string) {
	      return string.split(/\r\n?|\n/);
	    };
	    var hasSelection = window.getSelection ? function (te) {
	      try {
	        return te.selectionStart != te.selectionEnd;
	      } catch (e) {
	        return false;
	      }
	    } : function (te) {
	      var range;
	      try {
	        range = te.ownerDocument.selection.createRange();
	      } catch (e) {}
	      if (!range || range.parentElement() != te) {
	        return false;
	      }
	      return range.compareEndPoints("StartToEnd", range) != 0;
	    };
	    var hasCopyEvent = function () {
	      var e = elt("div");
	      if ("oncopy" in e) {
	        return true;
	      }
	      e.setAttribute("oncopy", "return;");
	      return typeof e.oncopy == "function";
	    }();
	    var badZoomedRects = null;
	    function hasBadZoomedRects(measure) {
	      if (badZoomedRects != null) {
	        return badZoomedRects;
	      }
	      var node = removeChildrenAndAdd(measure, elt("span", "x"));
	      var normal = node.getBoundingClientRect();
	      var fromRange = range(node, 0, 1).getBoundingClientRect();
	      return badZoomedRects = Math.abs(normal.left - fromRange.left) > 1;
	    }

	    // Known modes, by name and by MIME
	    var modes = {},
	      mimeModes = {};

	    // Extra arguments are stored as the mode's dependencies, which is
	    // used by (legacy) mechanisms like loadmode.js to automatically
	    // load a mode. (Preferred mechanism is the require/define calls.)
	    function defineMode(name, mode) {
	      if (arguments.length > 2) {
	        mode.dependencies = Array.prototype.slice.call(arguments, 2);
	      }
	      modes[name] = mode;
	    }
	    function defineMIME(mime, spec) {
	      mimeModes[mime] = spec;
	    }

	    // Given a MIME type, a {name, ...options} config object, or a name
	    // string, return a mode config object.
	    function resolveMode(spec) {
	      if (typeof spec == "string" && mimeModes.hasOwnProperty(spec)) {
	        spec = mimeModes[spec];
	      } else if (spec && typeof spec.name == "string" && mimeModes.hasOwnProperty(spec.name)) {
	        var found = mimeModes[spec.name];
	        if (typeof found == "string") {
	          found = {
	            name: found
	          };
	        }
	        spec = createObj(found, spec);
	        spec.name = found.name;
	      } else if (typeof spec == "string" && /^[\w\-]+\/[\w\-]+\+xml$/.test(spec)) {
	        return resolveMode("application/xml");
	      } else if (typeof spec == "string" && /^[\w\-]+\/[\w\-]+\+json$/.test(spec)) {
	        return resolveMode("application/json");
	      }
	      if (typeof spec == "string") {
	        return {
	          name: spec
	        };
	      } else {
	        return spec || {
	          name: "null"
	        };
	      }
	    }

	    // Given a mode spec (anything that resolveMode accepts), find and
	    // initialize an actual mode object.
	    function getMode(options, spec) {
	      spec = resolveMode(spec);
	      var mfactory = modes[spec.name];
	      if (!mfactory) {
	        return getMode(options, "text/plain");
	      }
	      var modeObj = mfactory(options, spec);
	      if (modeExtensions.hasOwnProperty(spec.name)) {
	        var exts = modeExtensions[spec.name];
	        for (var prop in exts) {
	          if (!exts.hasOwnProperty(prop)) {
	            continue;
	          }
	          if (modeObj.hasOwnProperty(prop)) {
	            modeObj["_" + prop] = modeObj[prop];
	          }
	          modeObj[prop] = exts[prop];
	        }
	      }
	      modeObj.name = spec.name;
	      if (spec.helperType) {
	        modeObj.helperType = spec.helperType;
	      }
	      if (spec.modeProps) {
	        for (var prop$1 in spec.modeProps) {
	          modeObj[prop$1] = spec.modeProps[prop$1];
	        }
	      }
	      return modeObj;
	    }

	    // This can be used to attach properties to mode objects from
	    // outside the actual mode definition.
	    var modeExtensions = {};
	    function extendMode(mode, properties) {
	      var exts = modeExtensions.hasOwnProperty(mode) ? modeExtensions[mode] : modeExtensions[mode] = {};
	      copyObj(properties, exts);
	    }
	    function copyState(mode, state) {
	      if (state === true) {
	        return state;
	      }
	      if (mode.copyState) {
	        return mode.copyState(state);
	      }
	      var nstate = {};
	      for (var n in state) {
	        var val = state[n];
	        if (val instanceof Array) {
	          val = val.concat([]);
	        }
	        nstate[n] = val;
	      }
	      return nstate;
	    }

	    // Given a mode and a state (for that mode), find the inner mode and
	    // state at the position that the state refers to.
	    function innerMode(mode, state) {
	      var info;
	      while (mode.innerMode) {
	        info = mode.innerMode(state);
	        if (!info || info.mode == mode) {
	          break;
	        }
	        state = info.state;
	        mode = info.mode;
	      }
	      return info || {
	        mode: mode,
	        state: state
	      };
	    }
	    function startState(mode, a1, a2) {
	      return mode.startState ? mode.startState(a1, a2) : true;
	    }

	    // STRING STREAM

	    // Fed to the mode parsers, provides helper functions to make
	    // parsers more succinct.

	    var StringStream = function (string, tabSize, lineOracle) {
	      this.pos = this.start = 0;
	      this.string = string;
	      this.tabSize = tabSize || 8;
	      this.lastColumnPos = this.lastColumnValue = 0;
	      this.lineStart = 0;
	      this.lineOracle = lineOracle;
	    };
	    StringStream.prototype.eol = function () {
	      return this.pos >= this.string.length;
	    };
	    StringStream.prototype.sol = function () {
	      return this.pos == this.lineStart;
	    };
	    StringStream.prototype.peek = function () {
	      return this.string.charAt(this.pos) || undefined;
	    };
	    StringStream.prototype.next = function () {
	      if (this.pos < this.string.length) {
	        return this.string.charAt(this.pos++);
	      }
	    };
	    StringStream.prototype.eat = function (match) {
	      var ch = this.string.charAt(this.pos);
	      var ok;
	      if (typeof match == "string") {
	        ok = ch == match;
	      } else {
	        ok = ch && (match.test ? match.test(ch) : match(ch));
	      }
	      if (ok) {
	        ++this.pos;
	        return ch;
	      }
	    };
	    StringStream.prototype.eatWhile = function (match) {
	      var start = this.pos;
	      while (this.eat(match)) {}
	      return this.pos > start;
	    };
	    StringStream.prototype.eatSpace = function () {
	      var start = this.pos;
	      while (/[\s\u00a0]/.test(this.string.charAt(this.pos))) {
	        ++this.pos;
	      }
	      return this.pos > start;
	    };
	    StringStream.prototype.skipToEnd = function () {
	      this.pos = this.string.length;
	    };
	    StringStream.prototype.skipTo = function (ch) {
	      var found = this.string.indexOf(ch, this.pos);
	      if (found > -1) {
	        this.pos = found;
	        return true;
	      }
	    };
	    StringStream.prototype.backUp = function (n) {
	      this.pos -= n;
	    };
	    StringStream.prototype.column = function () {
	      if (this.lastColumnPos < this.start) {
	        this.lastColumnValue = countColumn(this.string, this.start, this.tabSize, this.lastColumnPos, this.lastColumnValue);
	        this.lastColumnPos = this.start;
	      }
	      return this.lastColumnValue - (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0);
	    };
	    StringStream.prototype.indentation = function () {
	      return countColumn(this.string, null, this.tabSize) - (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0);
	    };
	    StringStream.prototype.match = function (pattern, consume, caseInsensitive) {
	      if (typeof pattern == "string") {
	        var cased = function (str) {
	          return caseInsensitive ? str.toLowerCase() : str;
	        };
	        var substr = this.string.substr(this.pos, pattern.length);
	        if (cased(substr) == cased(pattern)) {
	          if (consume !== false) {
	            this.pos += pattern.length;
	          }
	          return true;
	        }
	      } else {
	        var match = this.string.slice(this.pos).match(pattern);
	        if (match && match.index > 0) {
	          return null;
	        }
	        if (match && consume !== false) {
	          this.pos += match[0].length;
	        }
	        return match;
	      }
	    };
	    StringStream.prototype.current = function () {
	      return this.string.slice(this.start, this.pos);
	    };
	    StringStream.prototype.hideFirstChars = function (n, inner) {
	      this.lineStart += n;
	      try {
	        return inner();
	      } finally {
	        this.lineStart -= n;
	      }
	    };
	    StringStream.prototype.lookAhead = function (n) {
	      var oracle = this.lineOracle;
	      return oracle && oracle.lookAhead(n);
	    };
	    StringStream.prototype.baseToken = function () {
	      var oracle = this.lineOracle;
	      return oracle && oracle.baseToken(this.pos);
	    };

	    // Find the line object corresponding to the given line number.
	    function getLine(doc, n) {
	      n -= doc.first;
	      if (n < 0 || n >= doc.size) {
	        throw new Error("There is no line " + (n + doc.first) + " in the document.");
	      }
	      var chunk = doc;
	      while (!chunk.lines) {
	        for (var i = 0;; ++i) {
	          var child = chunk.children[i],
	            sz = child.chunkSize();
	          if (n < sz) {
	            chunk = child;
	            break;
	          }
	          n -= sz;
	        }
	      }
	      return chunk.lines[n];
	    }

	    // Get the part of a document between two positions, as an array of
	    // strings.
	    function getBetween(doc, start, end) {
	      var out = [],
	        n = start.line;
	      doc.iter(start.line, end.line + 1, function (line) {
	        var text = line.text;
	        if (n == end.line) {
	          text = text.slice(0, end.ch);
	        }
	        if (n == start.line) {
	          text = text.slice(start.ch);
	        }
	        out.push(text);
	        ++n;
	      });
	      return out;
	    }
	    // Get the lines between from and to, as array of strings.
	    function getLines(doc, from, to) {
	      var out = [];
	      doc.iter(from, to, function (line) {
	        out.push(line.text);
	      }); // iter aborts when callback returns truthy value
	      return out;
	    }

	    // Update the height of a line, propagating the height change
	    // upwards to parent nodes.
	    function updateLineHeight(line, height) {
	      var diff = height - line.height;
	      if (diff) {
	        for (var n = line; n; n = n.parent) {
	          n.height += diff;
	        }
	      }
	    }

	    // Given a line object, find its line number by walking up through
	    // its parent links.
	    function lineNo(line) {
	      if (line.parent == null) {
	        return null;
	      }
	      var cur = line.parent,
	        no = indexOf(cur.lines, line);
	      for (var chunk = cur.parent; chunk; cur = chunk, chunk = chunk.parent) {
	        for (var i = 0;; ++i) {
	          if (chunk.children[i] == cur) {
	            break;
	          }
	          no += chunk.children[i].chunkSize();
	        }
	      }
	      return no + cur.first;
	    }

	    // Find the line at the given vertical position, using the height
	    // information in the document tree.
	    function lineAtHeight(chunk, h) {
	      var n = chunk.first;
	      outer: do {
	        for (var i$1 = 0; i$1 < chunk.children.length; ++i$1) {
	          var child = chunk.children[i$1],
	            ch = child.height;
	          if (h < ch) {
	            chunk = child;
	            continue outer;
	          }
	          h -= ch;
	          n += child.chunkSize();
	        }
	        return n;
	      } while (!chunk.lines);
	      var i = 0;
	      for (; i < chunk.lines.length; ++i) {
	        var line = chunk.lines[i],
	          lh = line.height;
	        if (h < lh) {
	          break;
	        }
	        h -= lh;
	      }
	      return n + i;
	    }
	    function isLine(doc, l) {
	      return l >= doc.first && l < doc.first + doc.size;
	    }
	    function lineNumberFor(options, i) {
	      return String(options.lineNumberFormatter(i + options.firstLineNumber));
	    }

	    // A Pos instance represents a position within the text.
	    function Pos(line, ch, sticky) {
	      if (sticky === void 0) sticky = null;
	      if (!(this instanceof Pos)) {
	        return new Pos(line, ch, sticky);
	      }
	      this.line = line;
	      this.ch = ch;
	      this.sticky = sticky;
	    }

	    // Compare two positions, return 0 if they are the same, a negative
	    // number when a is less, and a positive number otherwise.
	    function cmp(a, b) {
	      return a.line - b.line || a.ch - b.ch;
	    }
	    function equalCursorPos(a, b) {
	      return a.sticky == b.sticky && cmp(a, b) == 0;
	    }
	    function copyPos(x) {
	      return Pos(x.line, x.ch);
	    }
	    function maxPos(a, b) {
	      return cmp(a, b) < 0 ? b : a;
	    }
	    function minPos(a, b) {
	      return cmp(a, b) < 0 ? a : b;
	    }

	    // Most of the external API clips given positions to make sure they
	    // actually exist within the document.
	    function clipLine(doc, n) {
	      return Math.max(doc.first, Math.min(n, doc.first + doc.size - 1));
	    }
	    function clipPos(doc, pos) {
	      if (pos.line < doc.first) {
	        return Pos(doc.first, 0);
	      }
	      var last = doc.first + doc.size - 1;
	      if (pos.line > last) {
	        return Pos(last, getLine(doc, last).text.length);
	      }
	      return clipToLen(pos, getLine(doc, pos.line).text.length);
	    }
	    function clipToLen(pos, linelen) {
	      var ch = pos.ch;
	      if (ch == null || ch > linelen) {
	        return Pos(pos.line, linelen);
	      } else if (ch < 0) {
	        return Pos(pos.line, 0);
	      } else {
	        return pos;
	      }
	    }
	    function clipPosArray(doc, array) {
	      var out = [];
	      for (var i = 0; i < array.length; i++) {
	        out[i] = clipPos(doc, array[i]);
	      }
	      return out;
	    }
	    var SavedContext = function (state, lookAhead) {
	      this.state = state;
	      this.lookAhead = lookAhead;
	    };
	    var Context = function (doc, state, line, lookAhead) {
	      this.state = state;
	      this.doc = doc;
	      this.line = line;
	      this.maxLookAhead = lookAhead || 0;
	      this.baseTokens = null;
	      this.baseTokenPos = 1;
	    };
	    Context.prototype.lookAhead = function (n) {
	      var line = this.doc.getLine(this.line + n);
	      if (line != null && n > this.maxLookAhead) {
	        this.maxLookAhead = n;
	      }
	      return line;
	    };
	    Context.prototype.baseToken = function (n) {
	      if (!this.baseTokens) {
	        return null;
	      }
	      while (this.baseTokens[this.baseTokenPos] <= n) {
	        this.baseTokenPos += 2;
	      }
	      var type = this.baseTokens[this.baseTokenPos + 1];
	      return {
	        type: type && type.replace(/( |^)overlay .*/, ""),
	        size: this.baseTokens[this.baseTokenPos] - n
	      };
	    };
	    Context.prototype.nextLine = function () {
	      this.line++;
	      if (this.maxLookAhead > 0) {
	        this.maxLookAhead--;
	      }
	    };
	    Context.fromSaved = function (doc, saved, line) {
	      if (saved instanceof SavedContext) {
	        return new Context(doc, copyState(doc.mode, saved.state), line, saved.lookAhead);
	      } else {
	        return new Context(doc, copyState(doc.mode, saved), line);
	      }
	    };
	    Context.prototype.save = function (copy) {
	      var state = copy !== false ? copyState(this.doc.mode, this.state) : this.state;
	      return this.maxLookAhead > 0 ? new SavedContext(state, this.maxLookAhead) : state;
	    };

	    // Compute a style array (an array starting with a mode generation
	    // -- for invalidation -- followed by pairs of end positions and
	    // style strings), which is used to highlight the tokens on the
	    // line.
	    function highlightLine(cm, line, context, forceToEnd) {
	      // A styles array always starts with a number identifying the
	      // mode/overlays that it is based on (for easy invalidation).
	      var st = [cm.state.modeGen],
	        lineClasses = {};
	      // Compute the base array of styles
	      runMode(cm, line.text, cm.doc.mode, context, function (end, style) {
	        return st.push(end, style);
	      }, lineClasses, forceToEnd);
	      var state = context.state;

	      // Run overlays, adjust style array.
	      var loop = function (o) {
	        context.baseTokens = st;
	        var overlay = cm.state.overlays[o],
	          i = 1,
	          at = 0;
	        context.state = true;
	        runMode(cm, line.text, overlay.mode, context, function (end, style) {
	          var start = i;
	          // Ensure there's a token end at the current position, and that i points at it
	          while (at < end) {
	            var i_end = st[i];
	            if (i_end > end) {
	              st.splice(i, 1, end, st[i + 1], i_end);
	            }
	            i += 2;
	            at = Math.min(end, i_end);
	          }
	          if (!style) {
	            return;
	          }
	          if (overlay.opaque) {
	            st.splice(start, i - start, end, "overlay " + style);
	            i = start + 2;
	          } else {
	            for (; start < i; start += 2) {
	              var cur = st[start + 1];
	              st[start + 1] = (cur ? cur + " " : "") + "overlay " + style;
	            }
	          }
	        }, lineClasses);
	        context.state = state;
	        context.baseTokens = null;
	        context.baseTokenPos = 1;
	      };
	      for (var o = 0; o < cm.state.overlays.length; ++o) loop(o);
	      return {
	        styles: st,
	        classes: lineClasses.bgClass || lineClasses.textClass ? lineClasses : null
	      };
	    }
	    function getLineStyles(cm, line, updateFrontier) {
	      if (!line.styles || line.styles[0] != cm.state.modeGen) {
	        var context = getContextBefore(cm, lineNo(line));
	        var resetState = line.text.length > cm.options.maxHighlightLength && copyState(cm.doc.mode, context.state);
	        var result = highlightLine(cm, line, context);
	        if (resetState) {
	          context.state = resetState;
	        }
	        line.stateAfter = context.save(!resetState);
	        line.styles = result.styles;
	        if (result.classes) {
	          line.styleClasses = result.classes;
	        } else if (line.styleClasses) {
	          line.styleClasses = null;
	        }
	        if (updateFrontier === cm.doc.highlightFrontier) {
	          cm.doc.modeFrontier = Math.max(cm.doc.modeFrontier, ++cm.doc.highlightFrontier);
	        }
	      }
	      return line.styles;
	    }
	    function getContextBefore(cm, n, precise) {
	      var doc = cm.doc,
	        display = cm.display;
	      if (!doc.mode.startState) {
	        return new Context(doc, true, n);
	      }
	      var start = findStartLine(cm, n, precise);
	      var saved = start > doc.first && getLine(doc, start - 1).stateAfter;
	      var context = saved ? Context.fromSaved(doc, saved, start) : new Context(doc, startState(doc.mode), start);
	      doc.iter(start, n, function (line) {
	        processLine(cm, line.text, context);
	        var pos = context.line;
	        line.stateAfter = pos == n - 1 || pos % 5 == 0 || pos >= display.viewFrom && pos < display.viewTo ? context.save() : null;
	        context.nextLine();
	      });
	      if (precise) {
	        doc.modeFrontier = context.line;
	      }
	      return context;
	    }

	    // Lightweight form of highlight -- proceed over this line and
	    // update state, but don't save a style array. Used for lines that
	    // aren't currently visible.
	    function processLine(cm, text, context, startAt) {
	      var mode = cm.doc.mode;
	      var stream = new StringStream(text, cm.options.tabSize, context);
	      stream.start = stream.pos = startAt || 0;
	      if (text == "") {
	        callBlankLine(mode, context.state);
	      }
	      while (!stream.eol()) {
	        readToken(mode, stream, context.state);
	        stream.start = stream.pos;
	      }
	    }
	    function callBlankLine(mode, state) {
	      if (mode.blankLine) {
	        return mode.blankLine(state);
	      }
	      if (!mode.innerMode) {
	        return;
	      }
	      var inner = innerMode(mode, state);
	      if (inner.mode.blankLine) {
	        return inner.mode.blankLine(inner.state);
	      }
	    }
	    function readToken(mode, stream, state, inner) {
	      for (var i = 0; i < 10; i++) {
	        if (inner) {
	          inner[0] = innerMode(mode, state).mode;
	        }
	        var style = mode.token(stream, state);
	        if (stream.pos > stream.start) {
	          return style;
	        }
	      }
	      throw new Error("Mode " + mode.name + " failed to advance stream.");
	    }
	    var Token = function (stream, type, state) {
	      this.start = stream.start;
	      this.end = stream.pos;
	      this.string = stream.current();
	      this.type = type || null;
	      this.state = state;
	    };

	    // Utility for getTokenAt and getLineTokens
	    function takeToken(cm, pos, precise, asArray) {
	      var doc = cm.doc,
	        mode = doc.mode,
	        style;
	      pos = clipPos(doc, pos);
	      var line = getLine(doc, pos.line),
	        context = getContextBefore(cm, pos.line, precise);
	      var stream = new StringStream(line.text, cm.options.tabSize, context),
	        tokens;
	      if (asArray) {
	        tokens = [];
	      }
	      while ((asArray || stream.pos < pos.ch) && !stream.eol()) {
	        stream.start = stream.pos;
	        style = readToken(mode, stream, context.state);
	        if (asArray) {
	          tokens.push(new Token(stream, style, copyState(doc.mode, context.state)));
	        }
	      }
	      return asArray ? tokens : new Token(stream, style, context.state);
	    }
	    function extractLineClasses(type, output) {
	      if (type) {
	        for (;;) {
	          var lineClass = type.match(/(?:^|\s+)line-(background-)?(\S+)/);
	          if (!lineClass) {
	            break;
	          }
	          type = type.slice(0, lineClass.index) + type.slice(lineClass.index + lineClass[0].length);
	          var prop = lineClass[1] ? "bgClass" : "textClass";
	          if (output[prop] == null) {
	            output[prop] = lineClass[2];
	          } else if (!new RegExp("(?:^|\\s)" + lineClass[2] + "(?:$|\\s)").test(output[prop])) {
	            output[prop] += " " + lineClass[2];
	          }
	        }
	      }
	      return type;
	    }

	    // Run the given mode's parser over a line, calling f for each token.
	    function runMode(cm, text, mode, context, f, lineClasses, forceToEnd) {
	      var flattenSpans = mode.flattenSpans;
	      if (flattenSpans == null) {
	        flattenSpans = cm.options.flattenSpans;
	      }
	      var curStart = 0,
	        curStyle = null;
	      var stream = new StringStream(text, cm.options.tabSize, context),
	        style;
	      var inner = cm.options.addModeClass && [null];
	      if (text == "") {
	        extractLineClasses(callBlankLine(mode, context.state), lineClasses);
	      }
	      while (!stream.eol()) {
	        if (stream.pos > cm.options.maxHighlightLength) {
	          flattenSpans = false;
	          if (forceToEnd) {
	            processLine(cm, text, context, stream.pos);
	          }
	          stream.pos = text.length;
	          style = null;
	        } else {
	          style = extractLineClasses(readToken(mode, stream, context.state, inner), lineClasses);
	        }
	        if (inner) {
	          var mName = inner[0].name;
	          if (mName) {
	            style = "m-" + (style ? mName + " " + style : mName);
	          }
	        }
	        if (!flattenSpans || curStyle != style) {
	          while (curStart < stream.start) {
	            curStart = Math.min(stream.start, curStart + 5000);
	            f(curStart, curStyle);
	          }
	          curStyle = style;
	        }
	        stream.start = stream.pos;
	      }
	      while (curStart < stream.pos) {
	        // Webkit seems to refuse to render text nodes longer than 57444
	        // characters, and returns inaccurate measurements in nodes
	        // starting around 5000 chars.
	        var pos = Math.min(stream.pos, curStart + 5000);
	        f(pos, curStyle);
	        curStart = pos;
	      }
	    }

	    // Finds the line to start with when starting a parse. Tries to
	    // find a line with a stateAfter, so that it can start with a
	    // valid state. If that fails, it returns the line with the
	    // smallest indentation, which tends to need the least context to
	    // parse correctly.
	    function findStartLine(cm, n, precise) {
	      var minindent,
	        minline,
	        doc = cm.doc;
	      var lim = precise ? -1 : n - (cm.doc.mode.innerMode ? 1000 : 100);
	      for (var search = n; search > lim; --search) {
	        if (search <= doc.first) {
	          return doc.first;
	        }
	        var line = getLine(doc, search - 1),
	          after = line.stateAfter;
	        if (after && (!precise || search + (after instanceof SavedContext ? after.lookAhead : 0) <= doc.modeFrontier)) {
	          return search;
	        }
	        var indented = countColumn(line.text, null, cm.options.tabSize);
	        if (minline == null || minindent > indented) {
	          minline = search - 1;
	          minindent = indented;
	        }
	      }
	      return minline;
	    }
	    function retreatFrontier(doc, n) {
	      doc.modeFrontier = Math.min(doc.modeFrontier, n);
	      if (doc.highlightFrontier < n - 10) {
	        return;
	      }
	      var start = doc.first;
	      for (var line = n - 1; line > start; line--) {
	        var saved = getLine(doc, line).stateAfter;
	        // change is on 3
	        // state on line 1 looked ahead 2 -- so saw 3
	        // test 1 + 2 < 3 should cover this
	        if (saved && (!(saved instanceof SavedContext) || line + saved.lookAhead < n)) {
	          start = line + 1;
	          break;
	        }
	      }
	      doc.highlightFrontier = Math.min(doc.highlightFrontier, start);
	    }

	    // Optimize some code when these features are not used.
	    var sawReadOnlySpans = false,
	      sawCollapsedSpans = false;
	    function seeReadOnlySpans() {
	      sawReadOnlySpans = true;
	    }
	    function seeCollapsedSpans() {
	      sawCollapsedSpans = true;
	    }

	    // TEXTMARKER SPANS

	    function MarkedSpan(marker, from, to) {
	      this.marker = marker;
	      this.from = from;
	      this.to = to;
	    }

	    // Search an array of spans for a span matching the given marker.
	    function getMarkedSpanFor(spans, marker) {
	      if (spans) {
	        for (var i = 0; i < spans.length; ++i) {
	          var span = spans[i];
	          if (span.marker == marker) {
	            return span;
	          }
	        }
	      }
	    }

	    // Remove a span from an array, returning undefined if no spans are
	    // left (we don't store arrays for lines without spans).
	    function removeMarkedSpan(spans, span) {
	      var r;
	      for (var i = 0; i < spans.length; ++i) {
	        if (spans[i] != span) {
	          (r || (r = [])).push(spans[i]);
	        }
	      }
	      return r;
	    }

	    // Add a span to a line.
	    function addMarkedSpan(line, span, op) {
	      var inThisOp = op && window.WeakSet && (op.markedSpans || (op.markedSpans = new WeakSet()));
	      if (inThisOp && line.markedSpans && inThisOp.has(line.markedSpans)) {
	        line.markedSpans.push(span);
	      } else {
	        line.markedSpans = line.markedSpans ? line.markedSpans.concat([span]) : [span];
	        if (inThisOp) {
	          inThisOp.add(line.markedSpans);
	        }
	      }
	      span.marker.attachLine(line);
	    }

	    // Used for the algorithm that adjusts markers for a change in the
	    // document. These functions cut an array of spans at a given
	    // character position, returning an array of remaining chunks (or
	    // undefined if nothing remains).
	    function markedSpansBefore(old, startCh, isInsert) {
	      var nw;
	      if (old) {
	        for (var i = 0; i < old.length; ++i) {
	          var span = old[i],
	            marker = span.marker;
	          var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= startCh : span.from < startCh);
	          if (startsBefore || span.from == startCh && marker.type == "bookmark" && (!isInsert || !span.marker.insertLeft)) {
	            var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= startCh : span.to > startCh);
	            (nw || (nw = [])).push(new MarkedSpan(marker, span.from, endsAfter ? null : span.to));
	          }
	        }
	      }
	      return nw;
	    }
	    function markedSpansAfter(old, endCh, isInsert) {
	      var nw;
	      if (old) {
	        for (var i = 0; i < old.length; ++i) {
	          var span = old[i],
	            marker = span.marker;
	          var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= endCh : span.to > endCh);
	          if (endsAfter || span.from == endCh && marker.type == "bookmark" && (!isInsert || span.marker.insertLeft)) {
	            var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= endCh : span.from < endCh);
	            (nw || (nw = [])).push(new MarkedSpan(marker, startsBefore ? null : span.from - endCh, span.to == null ? null : span.to - endCh));
	          }
	        }
	      }
	      return nw;
	    }

	    // Given a change object, compute the new set of marker spans that
	    // cover the line in which the change took place. Removes spans
	    // entirely within the change, reconnects spans belonging to the
	    // same marker that appear on both sides of the change, and cuts off
	    // spans partially within the change. Returns an array of span
	    // arrays with one element for each line in (after) the change.
	    function stretchSpansOverChange(doc, change) {
	      if (change.full) {
	        return null;
	      }
	      var oldFirst = isLine(doc, change.from.line) && getLine(doc, change.from.line).markedSpans;
	      var oldLast = isLine(doc, change.to.line) && getLine(doc, change.to.line).markedSpans;
	      if (!oldFirst && !oldLast) {
	        return null;
	      }
	      var startCh = change.from.ch,
	        endCh = change.to.ch,
	        isInsert = cmp(change.from, change.to) == 0;
	      // Get the spans that 'stick out' on both sides
	      var first = markedSpansBefore(oldFirst, startCh, isInsert);
	      var last = markedSpansAfter(oldLast, endCh, isInsert);

	      // Next, merge those two ends
	      var sameLine = change.text.length == 1,
	        offset = lst(change.text).length + (sameLine ? startCh : 0);
	      if (first) {
	        // Fix up .to properties of first
	        for (var i = 0; i < first.length; ++i) {
	          var span = first[i];
	          if (span.to == null) {
	            var found = getMarkedSpanFor(last, span.marker);
	            if (!found) {
	              span.to = startCh;
	            } else if (sameLine) {
	              span.to = found.to == null ? null : found.to + offset;
	            }
	          }
	        }
	      }
	      if (last) {
	        // Fix up .from in last (or move them into first in case of sameLine)
	        for (var i$1 = 0; i$1 < last.length; ++i$1) {
	          var span$1 = last[i$1];
	          if (span$1.to != null) {
	            span$1.to += offset;
	          }
	          if (span$1.from == null) {
	            var found$1 = getMarkedSpanFor(first, span$1.marker);
	            if (!found$1) {
	              span$1.from = offset;
	              if (sameLine) {
	                (first || (first = [])).push(span$1);
	              }
	            }
	          } else {
	            span$1.from += offset;
	            if (sameLine) {
	              (first || (first = [])).push(span$1);
	            }
	          }
	        }
	      }
	      // Make sure we didn't create any zero-length spans
	      if (first) {
	        first = clearEmptySpans(first);
	      }
	      if (last && last != first) {
	        last = clearEmptySpans(last);
	      }
	      var newMarkers = [first];
	      if (!sameLine) {
	        // Fill gap with whole-line-spans
	        var gap = change.text.length - 2,
	          gapMarkers;
	        if (gap > 0 && first) {
	          for (var i$2 = 0; i$2 < first.length; ++i$2) {
	            if (first[i$2].to == null) {
	              (gapMarkers || (gapMarkers = [])).push(new MarkedSpan(first[i$2].marker, null, null));
	            }
	          }
	        }
	        for (var i$3 = 0; i$3 < gap; ++i$3) {
	          newMarkers.push(gapMarkers);
	        }
	        newMarkers.push(last);
	      }
	      return newMarkers;
	    }

	    // Remove spans that are empty and don't have a clearWhenEmpty
	    // option of false.
	    function clearEmptySpans(spans) {
	      for (var i = 0; i < spans.length; ++i) {
	        var span = spans[i];
	        if (span.from != null && span.from == span.to && span.marker.clearWhenEmpty !== false) {
	          spans.splice(i--, 1);
	        }
	      }
	      if (!spans.length) {
	        return null;
	      }
	      return spans;
	    }

	    // Used to 'clip' out readOnly ranges when making a change.
	    function removeReadOnlyRanges(doc, from, to) {
	      var markers = null;
	      doc.iter(from.line, to.line + 1, function (line) {
	        if (line.markedSpans) {
	          for (var i = 0; i < line.markedSpans.length; ++i) {
	            var mark = line.markedSpans[i].marker;
	            if (mark.readOnly && (!markers || indexOf(markers, mark) == -1)) {
	              (markers || (markers = [])).push(mark);
	            }
	          }
	        }
	      });
	      if (!markers) {
	        return null;
	      }
	      var parts = [{
	        from: from,
	        to: to
	      }];
	      for (var i = 0; i < markers.length; ++i) {
	        var mk = markers[i],
	          m = mk.find(0);
	        for (var j = 0; j < parts.length; ++j) {
	          var p = parts[j];
	          if (cmp(p.to, m.from) < 0 || cmp(p.from, m.to) > 0) {
	            continue;
	          }
	          var newParts = [j, 1],
	            dfrom = cmp(p.from, m.from),
	            dto = cmp(p.to, m.to);
	          if (dfrom < 0 || !mk.inclusiveLeft && !dfrom) {
	            newParts.push({
	              from: p.from,
	              to: m.from
	            });
	          }
	          if (dto > 0 || !mk.inclusiveRight && !dto) {
	            newParts.push({
	              from: m.to,
	              to: p.to
	            });
	          }
	          parts.splice.apply(parts, newParts);
	          j += newParts.length - 3;
	        }
	      }
	      return parts;
	    }

	    // Connect or disconnect spans from a line.
	    function detachMarkedSpans(line) {
	      var spans = line.markedSpans;
	      if (!spans) {
	        return;
	      }
	      for (var i = 0; i < spans.length; ++i) {
	        spans[i].marker.detachLine(line);
	      }
	      line.markedSpans = null;
	    }
	    function attachMarkedSpans(line, spans) {
	      if (!spans) {
	        return;
	      }
	      for (var i = 0; i < spans.length; ++i) {
	        spans[i].marker.attachLine(line);
	      }
	      line.markedSpans = spans;
	    }

	    // Helpers used when computing which overlapping collapsed span
	    // counts as the larger one.
	    function extraLeft(marker) {
	      return marker.inclusiveLeft ? -1 : 0;
	    }
	    function extraRight(marker) {
	      return marker.inclusiveRight ? 1 : 0;
	    }

	    // Returns a number indicating which of two overlapping collapsed
	    // spans is larger (and thus includes the other). Falls back to
	    // comparing ids when the spans cover exactly the same range.
	    function compareCollapsedMarkers(a, b) {
	      var lenDiff = a.lines.length - b.lines.length;
	      if (lenDiff != 0) {
	        return lenDiff;
	      }
	      var aPos = a.find(),
	        bPos = b.find();
	      var fromCmp = cmp(aPos.from, bPos.from) || extraLeft(a) - extraLeft(b);
	      if (fromCmp) {
	        return -fromCmp;
	      }
	      var toCmp = cmp(aPos.to, bPos.to) || extraRight(a) - extraRight(b);
	      if (toCmp) {
	        return toCmp;
	      }
	      return b.id - a.id;
	    }

	    // Find out whether a line ends or starts in a collapsed span. If
	    // so, return the marker for that span.
	    function collapsedSpanAtSide(line, start) {
	      var sps = sawCollapsedSpans && line.markedSpans,
	        found;
	      if (sps) {
	        for (var sp = void 0, i = 0; i < sps.length; ++i) {
	          sp = sps[i];
	          if (sp.marker.collapsed && (start ? sp.from : sp.to) == null && (!found || compareCollapsedMarkers(found, sp.marker) < 0)) {
	            found = sp.marker;
	          }
	        }
	      }
	      return found;
	    }
	    function collapsedSpanAtStart(line) {
	      return collapsedSpanAtSide(line, true);
	    }
	    function collapsedSpanAtEnd(line) {
	      return collapsedSpanAtSide(line, false);
	    }
	    function collapsedSpanAround(line, ch) {
	      var sps = sawCollapsedSpans && line.markedSpans,
	        found;
	      if (sps) {
	        for (var i = 0; i < sps.length; ++i) {
	          var sp = sps[i];
	          if (sp.marker.collapsed && (sp.from == null || sp.from < ch) && (sp.to == null || sp.to > ch) && (!found || compareCollapsedMarkers(found, sp.marker) < 0)) {
	            found = sp.marker;
	          }
	        }
	      }
	      return found;
	    }

	    // Test whether there exists a collapsed span that partially
	    // overlaps (covers the start or end, but not both) of a new span.
	    // Such overlap is not allowed.
	    function conflictingCollapsedRange(doc, lineNo, from, to, marker) {
	      var line = getLine(doc, lineNo);
	      var sps = sawCollapsedSpans && line.markedSpans;
	      if (sps) {
	        for (var i = 0; i < sps.length; ++i) {
	          var sp = sps[i];
	          if (!sp.marker.collapsed) {
	            continue;
	          }
	          var found = sp.marker.find(0);
	          var fromCmp = cmp(found.from, from) || extraLeft(sp.marker) - extraLeft(marker);
	          var toCmp = cmp(found.to, to) || extraRight(sp.marker) - extraRight(marker);
	          if (fromCmp >= 0 && toCmp <= 0 || fromCmp <= 0 && toCmp >= 0) {
	            continue;
	          }
	          if (fromCmp <= 0 && (sp.marker.inclusiveRight && marker.inclusiveLeft ? cmp(found.to, from) >= 0 : cmp(found.to, from) > 0) || fromCmp >= 0 && (sp.marker.inclusiveRight && marker.inclusiveLeft ? cmp(found.from, to) <= 0 : cmp(found.from, to) < 0)) {
	            return true;
	          }
	        }
	      }
	    }

	    // A visual line is a line as drawn on the screen. Folding, for
	    // example, can cause multiple logical lines to appear on the same
	    // visual line. This finds the start of the visual line that the
	    // given line is part of (usually that is the line itself).
	    function visualLine(line) {
	      var merged;
	      while (merged = collapsedSpanAtStart(line)) {
	        line = merged.find(-1, true).line;
	      }
	      return line;
	    }
	    function visualLineEnd(line) {
	      var merged;
	      while (merged = collapsedSpanAtEnd(line)) {
	        line = merged.find(1, true).line;
	      }
	      return line;
	    }

	    // Returns an array of logical lines that continue the visual line
	    // started by the argument, or undefined if there are no such lines.
	    function visualLineContinued(line) {
	      var merged, lines;
	      while (merged = collapsedSpanAtEnd(line)) {
	        line = merged.find(1, true).line;
	        (lines || (lines = [])).push(line);
	      }
	      return lines;
	    }

	    // Get the line number of the start of the visual line that the
	    // given line number is part of.
	    function visualLineNo(doc, lineN) {
	      var line = getLine(doc, lineN),
	        vis = visualLine(line);
	      if (line == vis) {
	        return lineN;
	      }
	      return lineNo(vis);
	    }

	    // Get the line number of the start of the next visual line after
	    // the given line.
	    function visualLineEndNo(doc, lineN) {
	      if (lineN > doc.lastLine()) {
	        return lineN;
	      }
	      var line = getLine(doc, lineN),
	        merged;
	      if (!lineIsHidden(doc, line)) {
	        return lineN;
	      }
	      while (merged = collapsedSpanAtEnd(line)) {
	        line = merged.find(1, true).line;
	      }
	      return lineNo(line) + 1;
	    }

	    // Compute whether a line is hidden. Lines count as hidden when they
	    // are part of a visual line that starts with another line, or when
	    // they are entirely covered by collapsed, non-widget span.
	    function lineIsHidden(doc, line) {
	      var sps = sawCollapsedSpans && line.markedSpans;
	      if (sps) {
	        for (var sp = void 0, i = 0; i < sps.length; ++i) {
	          sp = sps[i];
	          if (!sp.marker.collapsed) {
	            continue;
	          }
	          if (sp.from == null) {
	            return true;
	          }
	          if (sp.marker.widgetNode) {
	            continue;
	          }
	          if (sp.from == 0 && sp.marker.inclusiveLeft && lineIsHiddenInner(doc, line, sp)) {
	            return true;
	          }
	        }
	      }
	    }
	    function lineIsHiddenInner(doc, line, span) {
	      if (span.to == null) {
	        var end = span.marker.find(1, true);
	        return lineIsHiddenInner(doc, end.line, getMarkedSpanFor(end.line.markedSpans, span.marker));
	      }
	      if (span.marker.inclusiveRight && span.to == line.text.length) {
	        return true;
	      }
	      for (var sp = void 0, i = 0; i < line.markedSpans.length; ++i) {
	        sp = line.markedSpans[i];
	        if (sp.marker.collapsed && !sp.marker.widgetNode && sp.from == span.to && (sp.to == null || sp.to != span.from) && (sp.marker.inclusiveLeft || span.marker.inclusiveRight) && lineIsHiddenInner(doc, line, sp)) {
	          return true;
	        }
	      }
	    }

	    // Find the height above the given line.
	    function heightAtLine(lineObj) {
	      lineObj = visualLine(lineObj);
	      var h = 0,
	        chunk = lineObj.parent;
	      for (var i = 0; i < chunk.lines.length; ++i) {
	        var line = chunk.lines[i];
	        if (line == lineObj) {
	          break;
	        } else {
	          h += line.height;
	        }
	      }
	      for (var p = chunk.parent; p; chunk = p, p = chunk.parent) {
	        for (var i$1 = 0; i$1 < p.children.length; ++i$1) {
	          var cur = p.children[i$1];
	          if (cur == chunk) {
	            break;
	          } else {
	            h += cur.height;
	          }
	        }
	      }
	      return h;
	    }

	    // Compute the character length of a line, taking into account
	    // collapsed ranges (see markText) that might hide parts, and join
	    // other lines onto it.
	    function lineLength(line) {
	      if (line.height == 0) {
	        return 0;
	      }
	      var len = line.text.length,
	        merged,
	        cur = line;
	      while (merged = collapsedSpanAtStart(cur)) {
	        var found = merged.find(0, true);
	        cur = found.from.line;
	        len += found.from.ch - found.to.ch;
	      }
	      cur = line;
	      while (merged = collapsedSpanAtEnd(cur)) {
	        var found$1 = merged.find(0, true);
	        len -= cur.text.length - found$1.from.ch;
	        cur = found$1.to.line;
	        len += cur.text.length - found$1.to.ch;
	      }
	      return len;
	    }

	    // Find the longest line in the document.
	    function findMaxLine(cm) {
	      var d = cm.display,
	        doc = cm.doc;
	      d.maxLine = getLine(doc, doc.first);
	      d.maxLineLength = lineLength(d.maxLine);
	      d.maxLineChanged = true;
	      doc.iter(function (line) {
	        var len = lineLength(line);
	        if (len > d.maxLineLength) {
	          d.maxLineLength = len;
	          d.maxLine = line;
	        }
	      });
	    }

	    // LINE DATA STRUCTURE

	    // Line objects. These hold state related to a line, including
	    // highlighting info (the styles array).
	    var Line = function (text, markedSpans, estimateHeight) {
	      this.text = text;
	      attachMarkedSpans(this, markedSpans);
	      this.height = estimateHeight ? estimateHeight(this) : 1;
	    };
	    Line.prototype.lineNo = function () {
	      return lineNo(this);
	    };
	    eventMixin(Line);

	    // Change the content (text, markers) of a line. Automatically
	    // invalidates cached information and tries to re-estimate the
	    // line's height.
	    function updateLine(line, text, markedSpans, estimateHeight) {
	      line.text = text;
	      if (line.stateAfter) {
	        line.stateAfter = null;
	      }
	      if (line.styles) {
	        line.styles = null;
	      }
	      if (line.order != null) {
	        line.order = null;
	      }
	      detachMarkedSpans(line);
	      attachMarkedSpans(line, markedSpans);
	      var estHeight = estimateHeight ? estimateHeight(line) : 1;
	      if (estHeight != line.height) {
	        updateLineHeight(line, estHeight);
	      }
	    }

	    // Detach a line from the document tree and its markers.
	    function cleanUpLine(line) {
	      line.parent = null;
	      detachMarkedSpans(line);
	    }

	    // Convert a style as returned by a mode (either null, or a string
	    // containing one or more styles) to a CSS style. This is cached,
	    // and also looks for line-wide styles.
	    var styleToClassCache = {},
	      styleToClassCacheWithMode = {};
	    function interpretTokenStyle(style, options) {
	      if (!style || /^\s*$/.test(style)) {
	        return null;
	      }
	      var cache = options.addModeClass ? styleToClassCacheWithMode : styleToClassCache;
	      return cache[style] || (cache[style] = style.replace(/\S+/g, "cm-$&"));
	    }

	    // Render the DOM representation of the text of a line. Also builds
	    // up a 'line map', which points at the DOM nodes that represent
	    // specific stretches of text, and is used by the measuring code.
	    // The returned object contains the DOM node, this map, and
	    // information about line-wide styles that were set by the mode.
	    function buildLineContent(cm, lineView) {
	      // The padding-right forces the element to have a 'border', which
	      // is needed on Webkit to be able to get line-level bounding
	      // rectangles for it (in measureChar).
	      var content = eltP("span", null, null, webkit ? "padding-right: .1px" : null);
	      var builder = {
	        pre: eltP("pre", [content], "CodeMirror-line"),
	        content: content,
	        col: 0,
	        pos: 0,
	        cm: cm,
	        trailingSpace: false,
	        splitSpaces: cm.getOption("lineWrapping")
	      };
	      lineView.measure = {};

	      // Iterate over the logical lines that make up this visual line.
	      for (var i = 0; i <= (lineView.rest ? lineView.rest.length : 0); i++) {
	        var line = i ? lineView.rest[i - 1] : lineView.line,
	          order = void 0;
	        builder.pos = 0;
	        builder.addToken = buildToken;
	        // Optionally wire in some hacks into the token-rendering
	        // algorithm, to deal with browser quirks.
	        if (hasBadBidiRects(cm.display.measure) && (order = getOrder(line, cm.doc.direction))) {
	          builder.addToken = buildTokenBadBidi(builder.addToken, order);
	        }
	        builder.map = [];
	        var allowFrontierUpdate = lineView != cm.display.externalMeasured && lineNo(line);
	        insertLineContent(line, builder, getLineStyles(cm, line, allowFrontierUpdate));
	        if (line.styleClasses) {
	          if (line.styleClasses.bgClass) {
	            builder.bgClass = joinClasses(line.styleClasses.bgClass, builder.bgClass || "");
	          }
	          if (line.styleClasses.textClass) {
	            builder.textClass = joinClasses(line.styleClasses.textClass, builder.textClass || "");
	          }
	        }

	        // Ensure at least a single node is present, for measuring.
	        if (builder.map.length == 0) {
	          builder.map.push(0, 0, builder.content.appendChild(zeroWidthElement(cm.display.measure)));
	        }

	        // Store the map and a cache object for the current logical line
	        if (i == 0) {
	          lineView.measure.map = builder.map;
	          lineView.measure.cache = {};
	        } else {
	          (lineView.measure.maps || (lineView.measure.maps = [])).push(builder.map);
	          (lineView.measure.caches || (lineView.measure.caches = [])).push({});
	        }
	      }

	      // See issue #2901
	      if (webkit) {
	        var last = builder.content.lastChild;
	        if (/\bcm-tab\b/.test(last.className) || last.querySelector && last.querySelector(".cm-tab")) {
	          builder.content.className = "cm-tab-wrap-hack";
	        }
	      }
	      signal(cm, "renderLine", cm, lineView.line, builder.pre);
	      if (builder.pre.className) {
	        builder.textClass = joinClasses(builder.pre.className, builder.textClass || "");
	      }
	      return builder;
	    }
	    function defaultSpecialCharPlaceholder(ch) {
	      var token = elt("span", "\u2022", "cm-invalidchar");
	      token.title = "\\u" + ch.charCodeAt(0).toString(16);
	      token.setAttribute("aria-label", token.title);
	      return token;
	    }

	    // Build up the DOM representation for a single token, and add it to
	    // the line map. Takes care to render special characters separately.
	    function buildToken(builder, text, style, startStyle, endStyle, css, attributes) {
	      if (!text) {
	        return;
	      }
	      var displayText = builder.splitSpaces ? splitSpaces(text, builder.trailingSpace) : text;
	      var special = builder.cm.state.specialChars,
	        mustWrap = false;
	      var content;
	      if (!special.test(text)) {
	        builder.col += text.length;
	        content = document.createTextNode(displayText);
	        builder.map.push(builder.pos, builder.pos + text.length, content);
	        if (ie && ie_version < 9) {
	          mustWrap = true;
	        }
	        builder.pos += text.length;
	      } else {
	        content = document.createDocumentFragment();
	        var pos = 0;
	        while (true) {
	          special.lastIndex = pos;
	          var m = special.exec(text);
	          var skipped = m ? m.index - pos : text.length - pos;
	          if (skipped) {
	            var txt = document.createTextNode(displayText.slice(pos, pos + skipped));
	            if (ie && ie_version < 9) {
	              content.appendChild(elt("span", [txt]));
	            } else {
	              content.appendChild(txt);
	            }
	            builder.map.push(builder.pos, builder.pos + skipped, txt);
	            builder.col += skipped;
	            builder.pos += skipped;
	          }
	          if (!m) {
	            break;
	          }
	          pos += skipped + 1;
	          var txt$1 = void 0;
	          if (m[0] == "\t") {
	            var tabSize = builder.cm.options.tabSize,
	              tabWidth = tabSize - builder.col % tabSize;
	            txt$1 = content.appendChild(elt("span", spaceStr(tabWidth), "cm-tab"));
	            txt$1.setAttribute("role", "presentation");
	            txt$1.setAttribute("cm-text", "\t");
	            builder.col += tabWidth;
	          } else if (m[0] == "\r" || m[0] == "\n") {
	            txt$1 = content.appendChild(elt("span", m[0] == "\r" ? "\u240d" : "\u2424", "cm-invalidchar"));
	            txt$1.setAttribute("cm-text", m[0]);
	            builder.col += 1;
	          } else {
	            txt$1 = builder.cm.options.specialCharPlaceholder(m[0]);
	            txt$1.setAttribute("cm-text", m[0]);
	            if (ie && ie_version < 9) {
	              content.appendChild(elt("span", [txt$1]));
	            } else {
	              content.appendChild(txt$1);
	            }
	            builder.col += 1;
	          }
	          builder.map.push(builder.pos, builder.pos + 1, txt$1);
	          builder.pos++;
	        }
	      }
	      builder.trailingSpace = displayText.charCodeAt(text.length - 1) == 32;
	      if (style || startStyle || endStyle || mustWrap || css || attributes) {
	        var fullStyle = style || "";
	        if (startStyle) {
	          fullStyle += startStyle;
	        }
	        if (endStyle) {
	          fullStyle += endStyle;
	        }
	        var token = elt("span", [content], fullStyle, css);
	        if (attributes) {
	          for (var attr in attributes) {
	            if (attributes.hasOwnProperty(attr) && attr != "style" && attr != "class") {
	              token.setAttribute(attr, attributes[attr]);
	            }
	          }
	        }
	        return builder.content.appendChild(token);
	      }
	      builder.content.appendChild(content);
	    }

	    // Change some spaces to NBSP to prevent the browser from collapsing
	    // trailing spaces at the end of a line when rendering text (issue #1362).
	    function splitSpaces(text, trailingBefore) {
	      if (text.length > 1 && !/  /.test(text)) {
	        return text;
	      }
	      var spaceBefore = trailingBefore,
	        result = "";
	      for (var i = 0; i < text.length; i++) {
	        var ch = text.charAt(i);
	        if (ch == " " && spaceBefore && (i == text.length - 1 || text.charCodeAt(i + 1) == 32)) {
	          ch = "\u00a0";
	        }
	        result += ch;
	        spaceBefore = ch == " ";
	      }
	      return result;
	    }

	    // Work around nonsense dimensions being reported for stretches of
	    // right-to-left text.
	    function buildTokenBadBidi(inner, order) {
	      return function (builder, text, style, startStyle, endStyle, css, attributes) {
	        style = style ? style + " cm-force-border" : "cm-force-border";
	        var start = builder.pos,
	          end = start + text.length;
	        for (;;) {
	          // Find the part that overlaps with the start of this text
	          var part = void 0;
	          for (var i = 0; i < order.length; i++) {
	            part = order[i];
	            if (part.to > start && part.from <= start) {
	              break;
	            }
	          }
	          if (part.to >= end) {
	            return inner(builder, text, style, startStyle, endStyle, css, attributes);
	          }
	          inner(builder, text.slice(0, part.to - start), style, startStyle, null, css, attributes);
	          startStyle = null;
	          text = text.slice(part.to - start);
	          start = part.to;
	        }
	      };
	    }
	    function buildCollapsedSpan(builder, size, marker, ignoreWidget) {
	      var widget = !ignoreWidget && marker.widgetNode;
	      if (widget) {
	        builder.map.push(builder.pos, builder.pos + size, widget);
	      }
	      if (!ignoreWidget && builder.cm.display.input.needsContentAttribute) {
	        if (!widget) {
	          widget = builder.content.appendChild(document.createElement("span"));
	        }
	        widget.setAttribute("cm-marker", marker.id);
	      }
	      if (widget) {
	        builder.cm.display.input.setUneditable(widget);
	        builder.content.appendChild(widget);
	      }
	      builder.pos += size;
	      builder.trailingSpace = false;
	    }

	    // Outputs a number of spans to make up a line, taking highlighting
	    // and marked text into account.
	    function insertLineContent(line, builder, styles) {
	      var spans = line.markedSpans,
	        allText = line.text,
	        at = 0;
	      if (!spans) {
	        for (var i$1 = 1; i$1 < styles.length; i$1 += 2) {
	          builder.addToken(builder, allText.slice(at, at = styles[i$1]), interpretTokenStyle(styles[i$1 + 1], builder.cm.options));
	        }
	        return;
	      }
	      var len = allText.length,
	        pos = 0,
	        i = 1,
	        text = "",
	        style,
	        css;
	      var nextChange = 0,
	        spanStyle,
	        spanEndStyle,
	        spanStartStyle,
	        collapsed,
	        attributes;
	      for (;;) {
	        if (nextChange == pos) {
	          // Update current marker set
	          spanStyle = spanEndStyle = spanStartStyle = css = "";
	          attributes = null;
	          collapsed = null;
	          nextChange = Infinity;
	          var foundBookmarks = [],
	            endStyles = void 0;
	          for (var j = 0; j < spans.length; ++j) {
	            var sp = spans[j],
	              m = sp.marker;
	            if (m.type == "bookmark" && sp.from == pos && m.widgetNode) {
	              foundBookmarks.push(m);
	            } else if (sp.from <= pos && (sp.to == null || sp.to > pos || m.collapsed && sp.to == pos && sp.from == pos)) {
	              if (sp.to != null && sp.to != pos && nextChange > sp.to) {
	                nextChange = sp.to;
	                spanEndStyle = "";
	              }
	              if (m.className) {
	                spanStyle += " " + m.className;
	              }
	              if (m.css) {
	                css = (css ? css + ";" : "") + m.css;
	              }
	              if (m.startStyle && sp.from == pos) {
	                spanStartStyle += " " + m.startStyle;
	              }
	              if (m.endStyle && sp.to == nextChange) {
	                (endStyles || (endStyles = [])).push(m.endStyle, sp.to);
	              }
	              // support for the old title property
	              // https://github.com/codemirror/CodeMirror/pull/5673
	              if (m.title) {
	                (attributes || (attributes = {})).title = m.title;
	              }
	              if (m.attributes) {
	                for (var attr in m.attributes) {
	                  (attributes || (attributes = {}))[attr] = m.attributes[attr];
	                }
	              }
	              if (m.collapsed && (!collapsed || compareCollapsedMarkers(collapsed.marker, m) < 0)) {
	                collapsed = sp;
	              }
	            } else if (sp.from > pos && nextChange > sp.from) {
	              nextChange = sp.from;
	            }
	          }
	          if (endStyles) {
	            for (var j$1 = 0; j$1 < endStyles.length; j$1 += 2) {
	              if (endStyles[j$1 + 1] == nextChange) {
	                spanEndStyle += " " + endStyles[j$1];
	              }
	            }
	          }
	          if (!collapsed || collapsed.from == pos) {
	            for (var j$2 = 0; j$2 < foundBookmarks.length; ++j$2) {
	              buildCollapsedSpan(builder, 0, foundBookmarks[j$2]);
	            }
	          }
	          if (collapsed && (collapsed.from || 0) == pos) {
	            buildCollapsedSpan(builder, (collapsed.to == null ? len + 1 : collapsed.to) - pos, collapsed.marker, collapsed.from == null);
	            if (collapsed.to == null) {
	              return;
	            }
	            if (collapsed.to == pos) {
	              collapsed = false;
	            }
	          }
	        }
	        if (pos >= len) {
	          break;
	        }
	        var upto = Math.min(len, nextChange);
	        while (true) {
	          if (text) {
	            var end = pos + text.length;
	            if (!collapsed) {
	              var tokenText = end > upto ? text.slice(0, upto - pos) : text;
	              builder.addToken(builder, tokenText, style ? style + spanStyle : spanStyle, spanStartStyle, pos + tokenText.length == nextChange ? spanEndStyle : "", css, attributes);
	            }
	            if (end >= upto) {
	              text = text.slice(upto - pos);
	              pos = upto;
	              break;
	            }
	            pos = end;
	            spanStartStyle = "";
	          }
	          text = allText.slice(at, at = styles[i++]);
	          style = interpretTokenStyle(styles[i++], builder.cm.options);
	        }
	      }
	    }

	    // These objects are used to represent the visible (currently drawn)
	    // part of the document. A LineView may correspond to multiple
	    // logical lines, if those are connected by collapsed ranges.
	    function LineView(doc, line, lineN) {
	      // The starting line
	      this.line = line;
	      // Continuing lines, if any
	      this.rest = visualLineContinued(line);
	      // Number of logical lines in this visual line
	      this.size = this.rest ? lineNo(lst(this.rest)) - lineN + 1 : 1;
	      this.node = this.text = null;
	      this.hidden = lineIsHidden(doc, line);
	    }

	    // Create a range of LineView objects for the given lines.
	    function buildViewArray(cm, from, to) {
	      var array = [],
	        nextPos;
	      for (var pos = from; pos < to; pos = nextPos) {
	        var view = new LineView(cm.doc, getLine(cm.doc, pos), pos);
	        nextPos = pos + view.size;
	        array.push(view);
	      }
	      return array;
	    }
	    var operationGroup = null;
	    function pushOperation(op) {
	      if (operationGroup) {
	        operationGroup.ops.push(op);
	      } else {
	        op.ownsGroup = operationGroup = {
	          ops: [op],
	          delayedCallbacks: []
	        };
	      }
	    }
	    function fireCallbacksForOps(group) {
	      // Calls delayed callbacks and cursorActivity handlers until no
	      // new ones appear
	      var callbacks = group.delayedCallbacks,
	        i = 0;
	      do {
	        for (; i < callbacks.length; i++) {
	          callbacks[i].call(null);
	        }
	        for (var j = 0; j < group.ops.length; j++) {
	          var op = group.ops[j];
	          if (op.cursorActivityHandlers) {
	            while (op.cursorActivityCalled < op.cursorActivityHandlers.length) {
	              op.cursorActivityHandlers[op.cursorActivityCalled++].call(null, op.cm);
	            }
	          }
	        }
	      } while (i < callbacks.length);
	    }
	    function finishOperation(op, endCb) {
	      var group = op.ownsGroup;
	      if (!group) {
	        return;
	      }
	      try {
	        fireCallbacksForOps(group);
	      } finally {
	        operationGroup = null;
	        endCb(group);
	      }
	    }
	    var orphanDelayedCallbacks = null;

	    // Often, we want to signal events at a point where we are in the
	    // middle of some work, but don't want the handler to start calling
	    // other methods on the editor, which might be in an inconsistent
	    // state or simply not expect any other events to happen.
	    // signalLater looks whether there are any handlers, and schedules
	    // them to be executed when the last operation ends, or, if no
	    // operation is active, when a timeout fires.
	    function signalLater(emitter, type /*, values...*/) {
	      var arr = getHandlers(emitter, type);
	      if (!arr.length) {
	        return;
	      }
	      var args = Array.prototype.slice.call(arguments, 2),
	        list;
	      if (operationGroup) {
	        list = operationGroup.delayedCallbacks;
	      } else if (orphanDelayedCallbacks) {
	        list = orphanDelayedCallbacks;
	      } else {
	        list = orphanDelayedCallbacks = [];
	        setTimeout(fireOrphanDelayed, 0);
	      }
	      var loop = function (i) {
	        list.push(function () {
	          return arr[i].apply(null, args);
	        });
	      };
	      for (var i = 0; i < arr.length; ++i) loop(i);
	    }
	    function fireOrphanDelayed() {
	      var delayed = orphanDelayedCallbacks;
	      orphanDelayedCallbacks = null;
	      for (var i = 0; i < delayed.length; ++i) {
	        delayed[i]();
	      }
	    }

	    // When an aspect of a line changes, a string is added to
	    // lineView.changes. This updates the relevant part of the line's
	    // DOM structure.
	    function updateLineForChanges(cm, lineView, lineN, dims) {
	      for (var j = 0; j < lineView.changes.length; j++) {
	        var type = lineView.changes[j];
	        if (type == "text") {
	          updateLineText(cm, lineView);
	        } else if (type == "gutter") {
	          updateLineGutter(cm, lineView, lineN, dims);
	        } else if (type == "class") {
	          updateLineClasses(cm, lineView);
	        } else if (type == "widget") {
	          updateLineWidgets(cm, lineView, dims);
	        }
	      }
	      lineView.changes = null;
	    }

	    // Lines with gutter elements, widgets or a background class need to
	    // be wrapped, and have the extra elements added to the wrapper div
	    function ensureLineWrapped(lineView) {
	      if (lineView.node == lineView.text) {
	        lineView.node = elt("div", null, null, "position: relative");
	        if (lineView.text.parentNode) {
	          lineView.text.parentNode.replaceChild(lineView.node, lineView.text);
	        }
	        lineView.node.appendChild(lineView.text);
	        if (ie && ie_version < 8) {
	          lineView.node.style.zIndex = 2;
	        }
	      }
	      return lineView.node;
	    }
	    function updateLineBackground(cm, lineView) {
	      var cls = lineView.bgClass ? lineView.bgClass + " " + (lineView.line.bgClass || "") : lineView.line.bgClass;
	      if (cls) {
	        cls += " CodeMirror-linebackground";
	      }
	      if (lineView.background) {
	        if (cls) {
	          lineView.background.className = cls;
	        } else {
	          lineView.background.parentNode.removeChild(lineView.background);
	          lineView.background = null;
	        }
	      } else if (cls) {
	        var wrap = ensureLineWrapped(lineView);
	        lineView.background = wrap.insertBefore(elt("div", null, cls), wrap.firstChild);
	        cm.display.input.setUneditable(lineView.background);
	      }
	    }

	    // Wrapper around buildLineContent which will reuse the structure
	    // in display.externalMeasured when possible.
	    function getLineContent(cm, lineView) {
	      var ext = cm.display.externalMeasured;
	      if (ext && ext.line == lineView.line) {
	        cm.display.externalMeasured = null;
	        lineView.measure = ext.measure;
	        return ext.built;
	      }
	      return buildLineContent(cm, lineView);
	    }

	    // Redraw the line's text. Interacts with the background and text
	    // classes because the mode may output tokens that influence these
	    // classes.
	    function updateLineText(cm, lineView) {
	      var cls = lineView.text.className;
	      var built = getLineContent(cm, lineView);
	      if (lineView.text == lineView.node) {
	        lineView.node = built.pre;
	      }
	      lineView.text.parentNode.replaceChild(built.pre, lineView.text);
	      lineView.text = built.pre;
	      if (built.bgClass != lineView.bgClass || built.textClass != lineView.textClass) {
	        lineView.bgClass = built.bgClass;
	        lineView.textClass = built.textClass;
	        updateLineClasses(cm, lineView);
	      } else if (cls) {
	        lineView.text.className = cls;
	      }
	    }
	    function updateLineClasses(cm, lineView) {
	      updateLineBackground(cm, lineView);
	      if (lineView.line.wrapClass) {
	        ensureLineWrapped(lineView).className = lineView.line.wrapClass;
	      } else if (lineView.node != lineView.text) {
	        lineView.node.className = "";
	      }
	      var textClass = lineView.textClass ? lineView.textClass + " " + (lineView.line.textClass || "") : lineView.line.textClass;
	      lineView.text.className = textClass || "";
	    }
	    function updateLineGutter(cm, lineView, lineN, dims) {
	      if (lineView.gutter) {
	        lineView.node.removeChild(lineView.gutter);
	        lineView.gutter = null;
	      }
	      if (lineView.gutterBackground) {
	        lineView.node.removeChild(lineView.gutterBackground);
	        lineView.gutterBackground = null;
	      }
	      if (lineView.line.gutterClass) {
	        var wrap = ensureLineWrapped(lineView);
	        lineView.gutterBackground = elt("div", null, "CodeMirror-gutter-background " + lineView.line.gutterClass, "left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px; width: " + dims.gutterTotalWidth + "px");
	        cm.display.input.setUneditable(lineView.gutterBackground);
	        wrap.insertBefore(lineView.gutterBackground, lineView.text);
	      }
	      var markers = lineView.line.gutterMarkers;
	      if (cm.options.lineNumbers || markers) {
	        var wrap$1 = ensureLineWrapped(lineView);
	        var gutterWrap = lineView.gutter = elt("div", null, "CodeMirror-gutter-wrapper", "left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px");
	        gutterWrap.setAttribute("aria-hidden", "true");
	        cm.display.input.setUneditable(gutterWrap);
	        wrap$1.insertBefore(gutterWrap, lineView.text);
	        if (lineView.line.gutterClass) {
	          gutterWrap.className += " " + lineView.line.gutterClass;
	        }
	        if (cm.options.lineNumbers && (!markers || !markers["CodeMirror-linenumbers"])) {
	          lineView.lineNumber = gutterWrap.appendChild(elt("div", lineNumberFor(cm.options, lineN), "CodeMirror-linenumber CodeMirror-gutter-elt", "left: " + dims.gutterLeft["CodeMirror-linenumbers"] + "px; width: " + cm.display.lineNumInnerWidth + "px"));
	        }
	        if (markers) {
	          for (var k = 0; k < cm.display.gutterSpecs.length; ++k) {
	            var id = cm.display.gutterSpecs[k].className,
	              found = markers.hasOwnProperty(id) && markers[id];
	            if (found) {
	              gutterWrap.appendChild(elt("div", [found], "CodeMirror-gutter-elt", "left: " + dims.gutterLeft[id] + "px; width: " + dims.gutterWidth[id] + "px"));
	            }
	          }
	        }
	      }
	    }
	    function updateLineWidgets(cm, lineView, dims) {
	      if (lineView.alignable) {
	        lineView.alignable = null;
	      }
	      var isWidget = classTest("CodeMirror-linewidget");
	      for (var node = lineView.node.firstChild, next = void 0; node; node = next) {
	        next = node.nextSibling;
	        if (isWidget.test(node.className)) {
	          lineView.node.removeChild(node);
	        }
	      }
	      insertLineWidgets(cm, lineView, dims);
	    }

	    // Build a line's DOM representation from scratch
	    function buildLineElement(cm, lineView, lineN, dims) {
	      var built = getLineContent(cm, lineView);
	      lineView.text = lineView.node = built.pre;
	      if (built.bgClass) {
	        lineView.bgClass = built.bgClass;
	      }
	      if (built.textClass) {
	        lineView.textClass = built.textClass;
	      }
	      updateLineClasses(cm, lineView);
	      updateLineGutter(cm, lineView, lineN, dims);
	      insertLineWidgets(cm, lineView, dims);
	      return lineView.node;
	    }

	    // A lineView may contain multiple logical lines (when merged by
	    // collapsed spans). The widgets for all of them need to be drawn.
	    function insertLineWidgets(cm, lineView, dims) {
	      insertLineWidgetsFor(cm, lineView.line, lineView, dims, true);
	      if (lineView.rest) {
	        for (var i = 0; i < lineView.rest.length; i++) {
	          insertLineWidgetsFor(cm, lineView.rest[i], lineView, dims, false);
	        }
	      }
	    }
	    function insertLineWidgetsFor(cm, line, lineView, dims, allowAbove) {
	      if (!line.widgets) {
	        return;
	      }
	      var wrap = ensureLineWrapped(lineView);
	      for (var i = 0, ws = line.widgets; i < ws.length; ++i) {
	        var widget = ws[i],
	          node = elt("div", [widget.node], "CodeMirror-linewidget" + (widget.className ? " " + widget.className : ""));
	        if (!widget.handleMouseEvents) {
	          node.setAttribute("cm-ignore-events", "true");
	        }
	        positionLineWidget(widget, node, lineView, dims);
	        cm.display.input.setUneditable(node);
	        if (allowAbove && widget.above) {
	          wrap.insertBefore(node, lineView.gutter || lineView.text);
	        } else {
	          wrap.appendChild(node);
	        }
	        signalLater(widget, "redraw");
	      }
	    }
	    function positionLineWidget(widget, node, lineView, dims) {
	      if (widget.noHScroll) {
	        (lineView.alignable || (lineView.alignable = [])).push(node);
	        var width = dims.wrapperWidth;
	        node.style.left = dims.fixedPos + "px";
	        if (!widget.coverGutter) {
	          width -= dims.gutterTotalWidth;
	          node.style.paddingLeft = dims.gutterTotalWidth + "px";
	        }
	        node.style.width = width + "px";
	      }
	      if (widget.coverGutter) {
	        node.style.zIndex = 5;
	        node.style.position = "relative";
	        if (!widget.noHScroll) {
	          node.style.marginLeft = -dims.gutterTotalWidth + "px";
	        }
	      }
	    }
	    function widgetHeight(widget) {
	      if (widget.height != null) {
	        return widget.height;
	      }
	      var cm = widget.doc.cm;
	      if (!cm) {
	        return 0;
	      }
	      if (!contains(document.body, widget.node)) {
	        var parentStyle = "position: relative;";
	        if (widget.coverGutter) {
	          parentStyle += "margin-left: -" + cm.display.gutters.offsetWidth + "px;";
	        }
	        if (widget.noHScroll) {
	          parentStyle += "width: " + cm.display.wrapper.clientWidth + "px;";
	        }
	        removeChildrenAndAdd(cm.display.measure, elt("div", [widget.node], null, parentStyle));
	      }
	      return widget.height = widget.node.parentNode.offsetHeight;
	    }

	    // Return true when the given mouse event happened in a widget
	    function eventInWidget(display, e) {
	      for (var n = e_target(e); n != display.wrapper; n = n.parentNode) {
	        if (!n || n.nodeType == 1 && n.getAttribute("cm-ignore-events") == "true" || n.parentNode == display.sizer && n != display.mover) {
	          return true;
	        }
	      }
	    }

	    // POSITION MEASUREMENT

	    function paddingTop(display) {
	      return display.lineSpace.offsetTop;
	    }
	    function paddingVert(display) {
	      return display.mover.offsetHeight - display.lineSpace.offsetHeight;
	    }
	    function paddingH(display) {
	      if (display.cachedPaddingH) {
	        return display.cachedPaddingH;
	      }
	      var e = removeChildrenAndAdd(display.measure, elt("pre", "x", "CodeMirror-line-like"));
	      var style = window.getComputedStyle ? window.getComputedStyle(e) : e.currentStyle;
	      var data = {
	        left: parseInt(style.paddingLeft),
	        right: parseInt(style.paddingRight)
	      };
	      if (!isNaN(data.left) && !isNaN(data.right)) {
	        display.cachedPaddingH = data;
	      }
	      return data;
	    }
	    function scrollGap(cm) {
	      return scrollerGap - cm.display.nativeBarWidth;
	    }
	    function displayWidth(cm) {
	      return cm.display.scroller.clientWidth - scrollGap(cm) - cm.display.barWidth;
	    }
	    function displayHeight(cm) {
	      return cm.display.scroller.clientHeight - scrollGap(cm) - cm.display.barHeight;
	    }

	    // Ensure the lineView.wrapping.heights array is populated. This is
	    // an array of bottom offsets for the lines that make up a drawn
	    // line. When lineWrapping is on, there might be more than one
	    // height.
	    function ensureLineHeights(cm, lineView, rect) {
	      var wrapping = cm.options.lineWrapping;
	      var curWidth = wrapping && displayWidth(cm);
	      if (!lineView.measure.heights || wrapping && lineView.measure.width != curWidth) {
	        var heights = lineView.measure.heights = [];
	        if (wrapping) {
	          lineView.measure.width = curWidth;
	          var rects = lineView.text.firstChild.getClientRects();
	          for (var i = 0; i < rects.length - 1; i++) {
	            var cur = rects[i],
	              next = rects[i + 1];
	            if (Math.abs(cur.bottom - next.bottom) > 2) {
	              heights.push((cur.bottom + next.top) / 2 - rect.top);
	            }
	          }
	        }
	        heights.push(rect.bottom - rect.top);
	      }
	    }

	    // Find a line map (mapping character offsets to text nodes) and a
	    // measurement cache for the given line number. (A line view might
	    // contain multiple lines when collapsed ranges are present.)
	    function mapFromLineView(lineView, line, lineN) {
	      if (lineView.line == line) {
	        return {
	          map: lineView.measure.map,
	          cache: lineView.measure.cache
	        };
	      }
	      if (lineView.rest) {
	        for (var i = 0; i < lineView.rest.length; i++) {
	          if (lineView.rest[i] == line) {
	            return {
	              map: lineView.measure.maps[i],
	              cache: lineView.measure.caches[i]
	            };
	          }
	        }
	        for (var i$1 = 0; i$1 < lineView.rest.length; i$1++) {
	          if (lineNo(lineView.rest[i$1]) > lineN) {
	            return {
	              map: lineView.measure.maps[i$1],
	              cache: lineView.measure.caches[i$1],
	              before: true
	            };
	          }
	        }
	      }
	    }

	    // Render a line into the hidden node display.externalMeasured. Used
	    // when measurement is needed for a line that's not in the viewport.
	    function updateExternalMeasurement(cm, line) {
	      line = visualLine(line);
	      var lineN = lineNo(line);
	      var view = cm.display.externalMeasured = new LineView(cm.doc, line, lineN);
	      view.lineN = lineN;
	      var built = view.built = buildLineContent(cm, view);
	      view.text = built.pre;
	      removeChildrenAndAdd(cm.display.lineMeasure, built.pre);
	      return view;
	    }

	    // Get a {top, bottom, left, right} box (in line-local coordinates)
	    // for a given character.
	    function measureChar(cm, line, ch, bias) {
	      return measureCharPrepared(cm, prepareMeasureForLine(cm, line), ch, bias);
	    }

	    // Find a line view that corresponds to the given line number.
	    function findViewForLine(cm, lineN) {
	      if (lineN >= cm.display.viewFrom && lineN < cm.display.viewTo) {
	        return cm.display.view[findViewIndex(cm, lineN)];
	      }
	      var ext = cm.display.externalMeasured;
	      if (ext && lineN >= ext.lineN && lineN < ext.lineN + ext.size) {
	        return ext;
	      }
	    }

	    // Measurement can be split in two steps, the set-up work that
	    // applies to the whole line, and the measurement of the actual
	    // character. Functions like coordsChar, that need to do a lot of
	    // measurements in a row, can thus ensure that the set-up work is
	    // only done once.
	    function prepareMeasureForLine(cm, line) {
	      var lineN = lineNo(line);
	      var view = findViewForLine(cm, lineN);
	      if (view && !view.text) {
	        view = null;
	      } else if (view && view.changes) {
	        updateLineForChanges(cm, view, lineN, getDimensions(cm));
	        cm.curOp.forceUpdate = true;
	      }
	      if (!view) {
	        view = updateExternalMeasurement(cm, line);
	      }
	      var info = mapFromLineView(view, line, lineN);
	      return {
	        line: line,
	        view: view,
	        rect: null,
	        map: info.map,
	        cache: info.cache,
	        before: info.before,
	        hasHeights: false
	      };
	    }

	    // Given a prepared measurement object, measures the position of an
	    // actual character (or fetches it from the cache).
	    function measureCharPrepared(cm, prepared, ch, bias, varHeight) {
	      if (prepared.before) {
	        ch = -1;
	      }
	      var key = ch + (bias || ""),
	        found;
	      if (prepared.cache.hasOwnProperty(key)) {
	        found = prepared.cache[key];
	      } else {
	        if (!prepared.rect) {
	          prepared.rect = prepared.view.text.getBoundingClientRect();
	        }
	        if (!prepared.hasHeights) {
	          ensureLineHeights(cm, prepared.view, prepared.rect);
	          prepared.hasHeights = true;
	        }
	        found = measureCharInner(cm, prepared, ch, bias);
	        if (!found.bogus) {
	          prepared.cache[key] = found;
	        }
	      }
	      return {
	        left: found.left,
	        right: found.right,
	        top: varHeight ? found.rtop : found.top,
	        bottom: varHeight ? found.rbottom : found.bottom
	      };
	    }
	    var nullRect = {
	      left: 0,
	      right: 0,
	      top: 0,
	      bottom: 0
	    };
	    function nodeAndOffsetInLineMap(map, ch, bias) {
	      var node, start, end, collapse, mStart, mEnd;
	      // First, search the line map for the text node corresponding to,
	      // or closest to, the target character.
	      for (var i = 0; i < map.length; i += 3) {
	        mStart = map[i];
	        mEnd = map[i + 1];
	        if (ch < mStart) {
	          start = 0;
	          end = 1;
	          collapse = "left";
	        } else if (ch < mEnd) {
	          start = ch - mStart;
	          end = start + 1;
	        } else if (i == map.length - 3 || ch == mEnd && map[i + 3] > ch) {
	          end = mEnd - mStart;
	          start = end - 1;
	          if (ch >= mEnd) {
	            collapse = "right";
	          }
	        }
	        if (start != null) {
	          node = map[i + 2];
	          if (mStart == mEnd && bias == (node.insertLeft ? "left" : "right")) {
	            collapse = bias;
	          }
	          if (bias == "left" && start == 0) {
	            while (i && map[i - 2] == map[i - 3] && map[i - 1].insertLeft) {
	              node = map[(i -= 3) + 2];
	              collapse = "left";
	            }
	          }
	          if (bias == "right" && start == mEnd - mStart) {
	            while (i < map.length - 3 && map[i + 3] == map[i + 4] && !map[i + 5].insertLeft) {
	              node = map[(i += 3) + 2];
	              collapse = "right";
	            }
	          }
	          break;
	        }
	      }
	      return {
	        node: node,
	        start: start,
	        end: end,
	        collapse: collapse,
	        coverStart: mStart,
	        coverEnd: mEnd
	      };
	    }
	    function getUsefulRect(rects, bias) {
	      var rect = nullRect;
	      if (bias == "left") {
	        for (var i = 0; i < rects.length; i++) {
	          if ((rect = rects[i]).left != rect.right) {
	            break;
	          }
	        }
	      } else {
	        for (var i$1 = rects.length - 1; i$1 >= 0; i$1--) {
	          if ((rect = rects[i$1]).left != rect.right) {
	            break;
	          }
	        }
	      }
	      return rect;
	    }
	    function measureCharInner(cm, prepared, ch, bias) {
	      var place = nodeAndOffsetInLineMap(prepared.map, ch, bias);
	      var node = place.node,
	        start = place.start,
	        end = place.end,
	        collapse = place.collapse;
	      var rect;
	      if (node.nodeType == 3) {
	        // If it is a text node, use a range to retrieve the coordinates.
	        for (var i$1 = 0; i$1 < 4; i$1++) {
	          // Retry a maximum of 4 times when nonsense rectangles are returned
	          while (start && isExtendingChar(prepared.line.text.charAt(place.coverStart + start))) {
	            --start;
	          }
	          while (place.coverStart + end < place.coverEnd && isExtendingChar(prepared.line.text.charAt(place.coverStart + end))) {
	            ++end;
	          }
	          if (ie && ie_version < 9 && start == 0 && end == place.coverEnd - place.coverStart) {
	            rect = node.parentNode.getBoundingClientRect();
	          } else {
	            rect = getUsefulRect(range(node, start, end).getClientRects(), bias);
	          }
	          if (rect.left || rect.right || start == 0) {
	            break;
	          }
	          end = start;
	          start = start - 1;
	          collapse = "right";
	        }
	        if (ie && ie_version < 11) {
	          rect = maybeUpdateRectForZooming(cm.display.measure, rect);
	        }
	      } else {
	        // If it is a widget, simply get the box for the whole widget.
	        if (start > 0) {
	          collapse = bias = "right";
	        }
	        var rects;
	        if (cm.options.lineWrapping && (rects = node.getClientRects()).length > 1) {
	          rect = rects[bias == "right" ? rects.length - 1 : 0];
	        } else {
	          rect = node.getBoundingClientRect();
	        }
	      }
	      if (ie && ie_version < 9 && !start && (!rect || !rect.left && !rect.right)) {
	        var rSpan = node.parentNode.getClientRects()[0];
	        if (rSpan) {
	          rect = {
	            left: rSpan.left,
	            right: rSpan.left + charWidth(cm.display),
	            top: rSpan.top,
	            bottom: rSpan.bottom
	          };
	        } else {
	          rect = nullRect;
	        }
	      }
	      var rtop = rect.top - prepared.rect.top,
	        rbot = rect.bottom - prepared.rect.top;
	      var mid = (rtop + rbot) / 2;
	      var heights = prepared.view.measure.heights;
	      var i = 0;
	      for (; i < heights.length - 1; i++) {
	        if (mid < heights[i]) {
	          break;
	        }
	      }
	      var top = i ? heights[i - 1] : 0,
	        bot = heights[i];
	      var result = {
	        left: (collapse == "right" ? rect.right : rect.left) - prepared.rect.left,
	        right: (collapse == "left" ? rect.left : rect.right) - prepared.rect.left,
	        top: top,
	        bottom: bot
	      };
	      if (!rect.left && !rect.right) {
	        result.bogus = true;
	      }
	      if (!cm.options.singleCursorHeightPerLine) {
	        result.rtop = rtop;
	        result.rbottom = rbot;
	      }
	      return result;
	    }

	    // Work around problem with bounding client rects on ranges being
	    // returned incorrectly when zoomed on IE10 and below.
	    function maybeUpdateRectForZooming(measure, rect) {
	      if (!window.screen || screen.logicalXDPI == null || screen.logicalXDPI == screen.deviceXDPI || !hasBadZoomedRects(measure)) {
	        return rect;
	      }
	      var scaleX = screen.logicalXDPI / screen.deviceXDPI;
	      var scaleY = screen.logicalYDPI / screen.deviceYDPI;
	      return {
	        left: rect.left * scaleX,
	        right: rect.right * scaleX,
	        top: rect.top * scaleY,
	        bottom: rect.bottom * scaleY
	      };
	    }
	    function clearLineMeasurementCacheFor(lineView) {
	      if (lineView.measure) {
	        lineView.measure.cache = {};
	        lineView.measure.heights = null;
	        if (lineView.rest) {
	          for (var i = 0; i < lineView.rest.length; i++) {
	            lineView.measure.caches[i] = {};
	          }
	        }
	      }
	    }
	    function clearLineMeasurementCache(cm) {
	      cm.display.externalMeasure = null;
	      removeChildren(cm.display.lineMeasure);
	      for (var i = 0; i < cm.display.view.length; i++) {
	        clearLineMeasurementCacheFor(cm.display.view[i]);
	      }
	    }
	    function clearCaches(cm) {
	      clearLineMeasurementCache(cm);
	      cm.display.cachedCharWidth = cm.display.cachedTextHeight = cm.display.cachedPaddingH = null;
	      if (!cm.options.lineWrapping) {
	        cm.display.maxLineChanged = true;
	      }
	      cm.display.lineNumChars = null;
	    }
	    function pageScrollX(doc) {
	      // Work around https://bugs.chromium.org/p/chromium/issues/detail?id=489206
	      // which causes page_Offset and bounding client rects to use
	      // different reference viewports and invalidate our calculations.
	      if (chrome && android) {
	        return -(doc.body.getBoundingClientRect().left - parseInt(getComputedStyle(doc.body).marginLeft));
	      }
	      return doc.defaultView.pageXOffset || (doc.documentElement || doc.body).scrollLeft;
	    }
	    function pageScrollY(doc) {
	      if (chrome && android) {
	        return -(doc.body.getBoundingClientRect().top - parseInt(getComputedStyle(doc.body).marginTop));
	      }
	      return doc.defaultView.pageYOffset || (doc.documentElement || doc.body).scrollTop;
	    }
	    function widgetTopHeight(lineObj) {
	      var ref = visualLine(lineObj);
	      var widgets = ref.widgets;
	      var height = 0;
	      if (widgets) {
	        for (var i = 0; i < widgets.length; ++i) {
	          if (widgets[i].above) {
	            height += widgetHeight(widgets[i]);
	          }
	        }
	      }
	      return height;
	    }

	    // Converts a {top, bottom, left, right} box from line-local
	    // coordinates into another coordinate system. Context may be one of
	    // "line", "div" (display.lineDiv), "local"./null (editor), "window",
	    // or "page".
	    function intoCoordSystem(cm, lineObj, rect, context, includeWidgets) {
	      if (!includeWidgets) {
	        var height = widgetTopHeight(lineObj);
	        rect.top += height;
	        rect.bottom += height;
	      }
	      if (context == "line") {
	        return rect;
	      }
	      if (!context) {
	        context = "local";
	      }
	      var yOff = heightAtLine(lineObj);
	      if (context == "local") {
	        yOff += paddingTop(cm.display);
	      } else {
	        yOff -= cm.display.viewOffset;
	      }
	      if (context == "page" || context == "window") {
	        var lOff = cm.display.lineSpace.getBoundingClientRect();
	        yOff += lOff.top + (context == "window" ? 0 : pageScrollY(doc(cm)));
	        var xOff = lOff.left + (context == "window" ? 0 : pageScrollX(doc(cm)));
	        rect.left += xOff;
	        rect.right += xOff;
	      }
	      rect.top += yOff;
	      rect.bottom += yOff;
	      return rect;
	    }

	    // Coverts a box from "div" coords to another coordinate system.
	    // Context may be "window", "page", "div", or "local"./null.
	    function fromCoordSystem(cm, coords, context) {
	      if (context == "div") {
	        return coords;
	      }
	      var left = coords.left,
	        top = coords.top;
	      // First move into "page" coordinate system
	      if (context == "page") {
	        left -= pageScrollX(doc(cm));
	        top -= pageScrollY(doc(cm));
	      } else if (context == "local" || !context) {
	        var localBox = cm.display.sizer.getBoundingClientRect();
	        left += localBox.left;
	        top += localBox.top;
	      }
	      var lineSpaceBox = cm.display.lineSpace.getBoundingClientRect();
	      return {
	        left: left - lineSpaceBox.left,
	        top: top - lineSpaceBox.top
	      };
	    }
	    function charCoords(cm, pos, context, lineObj, bias) {
	      if (!lineObj) {
	        lineObj = getLine(cm.doc, pos.line);
	      }
	      return intoCoordSystem(cm, lineObj, measureChar(cm, lineObj, pos.ch, bias), context);
	    }

	    // Returns a box for a given cursor position, which may have an
	    // 'other' property containing the position of the secondary cursor
	    // on a bidi boundary.
	    // A cursor Pos(line, char, "before") is on the same visual line as `char - 1`
	    // and after `char - 1` in writing order of `char - 1`
	    // A cursor Pos(line, char, "after") is on the same visual line as `char`
	    // and before `char` in writing order of `char`
	    // Examples (upper-case letters are RTL, lower-case are LTR):
	    //     Pos(0, 1, ...)
	    //     before   after
	    // ab     a|b     a|b
	    // aB     a|B     aB|
	    // Ab     |Ab     A|b
	    // AB     B|A     B|A
	    // Every position after the last character on a line is considered to stick
	    // to the last character on the line.
	    function cursorCoords(cm, pos, context, lineObj, preparedMeasure, varHeight) {
	      lineObj = lineObj || getLine(cm.doc, pos.line);
	      if (!preparedMeasure) {
	        preparedMeasure = prepareMeasureForLine(cm, lineObj);
	      }
	      function get(ch, right) {
	        var m = measureCharPrepared(cm, preparedMeasure, ch, right ? "right" : "left", varHeight);
	        if (right) {
	          m.left = m.right;
	        } else {
	          m.right = m.left;
	        }
	        return intoCoordSystem(cm, lineObj, m, context);
	      }
	      var order = getOrder(lineObj, cm.doc.direction),
	        ch = pos.ch,
	        sticky = pos.sticky;
	      if (ch >= lineObj.text.length) {
	        ch = lineObj.text.length;
	        sticky = "before";
	      } else if (ch <= 0) {
	        ch = 0;
	        sticky = "after";
	      }
	      if (!order) {
	        return get(sticky == "before" ? ch - 1 : ch, sticky == "before");
	      }
	      function getBidi(ch, partPos, invert) {
	        var part = order[partPos],
	          right = part.level == 1;
	        return get(invert ? ch - 1 : ch, right != invert);
	      }
	      var partPos = getBidiPartAt(order, ch, sticky);
	      var other = bidiOther;
	      var val = getBidi(ch, partPos, sticky == "before");
	      if (other != null) {
	        val.other = getBidi(ch, other, sticky != "before");
	      }
	      return val;
	    }

	    // Used to cheaply estimate the coordinates for a position. Used for
	    // intermediate scroll updates.
	    function estimateCoords(cm, pos) {
	      var left = 0;
	      pos = clipPos(cm.doc, pos);
	      if (!cm.options.lineWrapping) {
	        left = charWidth(cm.display) * pos.ch;
	      }
	      var lineObj = getLine(cm.doc, pos.line);
	      var top = heightAtLine(lineObj) + paddingTop(cm.display);
	      return {
	        left: left,
	        right: left,
	        top: top,
	        bottom: top + lineObj.height
	      };
	    }

	    // Positions returned by coordsChar contain some extra information.
	    // xRel is the relative x position of the input coordinates compared
	    // to the found position (so xRel > 0 means the coordinates are to
	    // the right of the character position, for example). When outside
	    // is true, that means the coordinates lie outside the line's
	    // vertical range.
	    function PosWithInfo(line, ch, sticky, outside, xRel) {
	      var pos = Pos(line, ch, sticky);
	      pos.xRel = xRel;
	      if (outside) {
	        pos.outside = outside;
	      }
	      return pos;
	    }

	    // Compute the character position closest to the given coordinates.
	    // Input must be lineSpace-local ("div" coordinate system).
	    function coordsChar(cm, x, y) {
	      var doc = cm.doc;
	      y += cm.display.viewOffset;
	      if (y < 0) {
	        return PosWithInfo(doc.first, 0, null, -1, -1);
	      }
	      var lineN = lineAtHeight(doc, y),
	        last = doc.first + doc.size - 1;
	      if (lineN > last) {
	        return PosWithInfo(doc.first + doc.size - 1, getLine(doc, last).text.length, null, 1, 1);
	      }
	      if (x < 0) {
	        x = 0;
	      }
	      var lineObj = getLine(doc, lineN);
	      for (;;) {
	        var found = coordsCharInner(cm, lineObj, lineN, x, y);
	        var collapsed = collapsedSpanAround(lineObj, found.ch + (found.xRel > 0 || found.outside > 0 ? 1 : 0));
	        if (!collapsed) {
	          return found;
	        }
	        var rangeEnd = collapsed.find(1);
	        if (rangeEnd.line == lineN) {
	          return rangeEnd;
	        }
	        lineObj = getLine(doc, lineN = rangeEnd.line);
	      }
	    }
	    function wrappedLineExtent(cm, lineObj, preparedMeasure, y) {
	      y -= widgetTopHeight(lineObj);
	      var end = lineObj.text.length;
	      var begin = findFirst(function (ch) {
	        return measureCharPrepared(cm, preparedMeasure, ch - 1).bottom <= y;
	      }, end, 0);
	      end = findFirst(function (ch) {
	        return measureCharPrepared(cm, preparedMeasure, ch).top > y;
	      }, begin, end);
	      return {
	        begin: begin,
	        end: end
	      };
	    }
	    function wrappedLineExtentChar(cm, lineObj, preparedMeasure, target) {
	      if (!preparedMeasure) {
	        preparedMeasure = prepareMeasureForLine(cm, lineObj);
	      }
	      var targetTop = intoCoordSystem(cm, lineObj, measureCharPrepared(cm, preparedMeasure, target), "line").top;
	      return wrappedLineExtent(cm, lineObj, preparedMeasure, targetTop);
	    }

	    // Returns true if the given side of a box is after the given
	    // coordinates, in top-to-bottom, left-to-right order.
	    function boxIsAfter(box, x, y, left) {
	      return box.bottom <= y ? false : box.top > y ? true : (left ? box.left : box.right) > x;
	    }
	    function coordsCharInner(cm, lineObj, lineNo, x, y) {
	      // Move y into line-local coordinate space
	      y -= heightAtLine(lineObj);
	      var preparedMeasure = prepareMeasureForLine(cm, lineObj);
	      // When directly calling `measureCharPrepared`, we have to adjust
	      // for the widgets at this line.
	      var widgetHeight = widgetTopHeight(lineObj);
	      var begin = 0,
	        end = lineObj.text.length,
	        ltr = true;
	      var order = getOrder(lineObj, cm.doc.direction);
	      // If the line isn't plain left-to-right text, first figure out
	      // which bidi section the coordinates fall into.
	      if (order) {
	        var part = (cm.options.lineWrapping ? coordsBidiPartWrapped : coordsBidiPart)(cm, lineObj, lineNo, preparedMeasure, order, x, y);
	        ltr = part.level != 1;
	        // The awkward -1 offsets are needed because findFirst (called
	        // on these below) will treat its first bound as inclusive,
	        // second as exclusive, but we want to actually address the
	        // characters in the part's range
	        begin = ltr ? part.from : part.to - 1;
	        end = ltr ? part.to : part.from - 1;
	      }

	      // A binary search to find the first character whose bounding box
	      // starts after the coordinates. If we run across any whose box wrap
	      // the coordinates, store that.
	      var chAround = null,
	        boxAround = null;
	      var ch = findFirst(function (ch) {
	        var box = measureCharPrepared(cm, preparedMeasure, ch);
	        box.top += widgetHeight;
	        box.bottom += widgetHeight;
	        if (!boxIsAfter(box, x, y, false)) {
	          return false;
	        }
	        if (box.top <= y && box.left <= x) {
	          chAround = ch;
	          boxAround = box;
	        }
	        return true;
	      }, begin, end);
	      var baseX,
	        sticky,
	        outside = false;
	      // If a box around the coordinates was found, use that
	      if (boxAround) {
	        // Distinguish coordinates nearer to the left or right side of the box
	        var atLeft = x - boxAround.left < boxAround.right - x,
	          atStart = atLeft == ltr;
	        ch = chAround + (atStart ? 0 : 1);
	        sticky = atStart ? "after" : "before";
	        baseX = atLeft ? boxAround.left : boxAround.right;
	      } else {
	        // (Adjust for extended bound, if necessary.)
	        if (!ltr && (ch == end || ch == begin)) {
	          ch++;
	        }
	        // To determine which side to associate with, get the box to the
	        // left of the character and compare it's vertical position to the
	        // coordinates
	        sticky = ch == 0 ? "after" : ch == lineObj.text.length ? "before" : measureCharPrepared(cm, preparedMeasure, ch - (ltr ? 1 : 0)).bottom + widgetHeight <= y == ltr ? "after" : "before";
	        // Now get accurate coordinates for this place, in order to get a
	        // base X position
	        var coords = cursorCoords(cm, Pos(lineNo, ch, sticky), "line", lineObj, preparedMeasure);
	        baseX = coords.left;
	        outside = y < coords.top ? -1 : y >= coords.bottom ? 1 : 0;
	      }
	      ch = skipExtendingChars(lineObj.text, ch, 1);
	      return PosWithInfo(lineNo, ch, sticky, outside, x - baseX);
	    }
	    function coordsBidiPart(cm, lineObj, lineNo, preparedMeasure, order, x, y) {
	      // Bidi parts are sorted left-to-right, and in a non-line-wrapping
	      // situation, we can take this ordering to correspond to the visual
	      // ordering. This finds the first part whose end is after the given
	      // coordinates.
	      var index = findFirst(function (i) {
	        var part = order[i],
	          ltr = part.level != 1;
	        return boxIsAfter(cursorCoords(cm, Pos(lineNo, ltr ? part.to : part.from, ltr ? "before" : "after"), "line", lineObj, preparedMeasure), x, y, true);
	      }, 0, order.length - 1);
	      var part = order[index];
	      // If this isn't the first part, the part's start is also after
	      // the coordinates, and the coordinates aren't on the same line as
	      // that start, move one part back.
	      if (index > 0) {
	        var ltr = part.level != 1;
	        var start = cursorCoords(cm, Pos(lineNo, ltr ? part.from : part.to, ltr ? "after" : "before"), "line", lineObj, preparedMeasure);
	        if (boxIsAfter(start, x, y, true) && start.top > y) {
	          part = order[index - 1];
	        }
	      }
	      return part;
	    }
	    function coordsBidiPartWrapped(cm, lineObj, _lineNo, preparedMeasure, order, x, y) {
	      // In a wrapped line, rtl text on wrapping boundaries can do things
	      // that don't correspond to the ordering in our `order` array at
	      // all, so a binary search doesn't work, and we want to return a
	      // part that only spans one line so that the binary search in
	      // coordsCharInner is safe. As such, we first find the extent of the
	      // wrapped line, and then do a flat search in which we discard any
	      // spans that aren't on the line.
	      var ref = wrappedLineExtent(cm, lineObj, preparedMeasure, y);
	      var begin = ref.begin;
	      var end = ref.end;
	      if (/\s/.test(lineObj.text.charAt(end - 1))) {
	        end--;
	      }
	      var part = null,
	        closestDist = null;
	      for (var i = 0; i < order.length; i++) {
	        var p = order[i];
	        if (p.from >= end || p.to <= begin) {
	          continue;
	        }
	        var ltr = p.level != 1;
	        var endX = measureCharPrepared(cm, preparedMeasure, ltr ? Math.min(end, p.to) - 1 : Math.max(begin, p.from)).right;
	        // Weigh against spans ending before this, so that they are only
	        // picked if nothing ends after
	        var dist = endX < x ? x - endX + 1e9 : endX - x;
	        if (!part || closestDist > dist) {
	          part = p;
	          closestDist = dist;
	        }
	      }
	      if (!part) {
	        part = order[order.length - 1];
	      }
	      // Clip the part to the wrapped line.
	      if (part.from < begin) {
	        part = {
	          from: begin,
	          to: part.to,
	          level: part.level
	        };
	      }
	      if (part.to > end) {
	        part = {
	          from: part.from,
	          to: end,
	          level: part.level
	        };
	      }
	      return part;
	    }
	    var measureText;
	    // Compute the default text height.
	    function textHeight(display) {
	      if (display.cachedTextHeight != null) {
	        return display.cachedTextHeight;
	      }
	      if (measureText == null) {
	        measureText = elt("pre", null, "CodeMirror-line-like");
	        // Measure a bunch of lines, for browsers that compute
	        // fractional heights.
	        for (var i = 0; i < 49; ++i) {
	          measureText.appendChild(document.createTextNode("x"));
	          measureText.appendChild(elt("br"));
	        }
	        measureText.appendChild(document.createTextNode("x"));
	      }
	      removeChildrenAndAdd(display.measure, measureText);
	      var height = measureText.offsetHeight / 50;
	      if (height > 3) {
	        display.cachedTextHeight = height;
	      }
	      removeChildren(display.measure);
	      return height || 1;
	    }

	    // Compute the default character width.
	    function charWidth(display) {
	      if (display.cachedCharWidth != null) {
	        return display.cachedCharWidth;
	      }
	      var anchor = elt("span", "xxxxxxxxxx");
	      var pre = elt("pre", [anchor], "CodeMirror-line-like");
	      removeChildrenAndAdd(display.measure, pre);
	      var rect = anchor.getBoundingClientRect(),
	        width = (rect.right - rect.left) / 10;
	      if (width > 2) {
	        display.cachedCharWidth = width;
	      }
	      return width || 10;
	    }

	    // Do a bulk-read of the DOM positions and sizes needed to draw the
	    // view, so that we don't interleave reading and writing to the DOM.
	    function getDimensions(cm) {
	      var d = cm.display,
	        left = {},
	        width = {};
	      var gutterLeft = d.gutters.clientLeft;
	      for (var n = d.gutters.firstChild, i = 0; n; n = n.nextSibling, ++i) {
	        var id = cm.display.gutterSpecs[i].className;
	        left[id] = n.offsetLeft + n.clientLeft + gutterLeft;
	        width[id] = n.clientWidth;
	      }
	      return {
	        fixedPos: compensateForHScroll(d),
	        gutterTotalWidth: d.gutters.offsetWidth,
	        gutterLeft: left,
	        gutterWidth: width,
	        wrapperWidth: d.wrapper.clientWidth
	      };
	    }

	    // Computes display.scroller.scrollLeft + display.gutters.offsetWidth,
	    // but using getBoundingClientRect to get a sub-pixel-accurate
	    // result.
	    function compensateForHScroll(display) {
	      return display.scroller.getBoundingClientRect().left - display.sizer.getBoundingClientRect().left;
	    }

	    // Returns a function that estimates the height of a line, to use as
	    // first approximation until the line becomes visible (and is thus