!function(){var e,t;e=this,t=function(e,w,n){"use strict";e.suite("rb/models/CommChannel",()=>{let t;w.beforeEach(()=>{t=new RB.ClientCommChannel}),w.afterEach(()=>{t.close()}),w.describe("reload handler",()=>{let a;w.beforeEach(()=>{var e=$("<div>").appendTo($testsScratch),t=$("<div>").appendTo(e),i=$("<div>").appendTo(e),n=$("<div>").appendTo(i),o=$("<div>").appendTo(e);a=new RB.PageView({$body:e,$headerBar:t,$pageContainer:i,$pageContent:n,$pageSidebar:o}),w.spyOn(RB.PageManager,"getPage").and.returnValue(a)}),w.it("With matching reload data",()=>{w.spyOn(a,"getReloadData").and.returnValue({test:1});let e=!1;t.on("reload",()=>{e=!0}),t._onReload({data:{test:1},event:"reload"}),w.expect(a.getReloadData).toHaveBeenCalled(),w.expect(e).toBe(!0)}),w.it("Without matching reload data",()=>{w.spyOn(a,"getReloadData").and.returnValue({test:2}),t.on("reload",()=>{w.fail()}),t._onReload({data:{test:1},event:"reload"}),w.expect(a.getReloadData).toHaveBeenCalled()})})}),e.suite("rb/models/ExtraData",function(){let i;w.describe("With Backbone.Model.extend",function(){w.beforeEach(function(){var e=Backbone.Model.extend(_.defaults({defaults(){return{extraData:{}}},initialize(){this._setupExtraData()}},RB.ExtraDataMixin));i=new e}),w.it("change events fired",function(){var e={change:function(){},"change:extraData":function(){}};w.spyOn(e,"change"),w.spyOn(e,"change:extraData"),i.on("change",e.change),i.on("change:extraData",e["change:extraData"]),i.setExtraData("foo",1),w.expect(e.change).toHaveBeenCalled(),w.expect(e["change:extraData"]).toHaveBeenCalled()}),w.it("attributes updated",function(){var e=i.attributes.extraData;w.expect(i.extraData.attributes).toBe(e),i.set({extraData:{foo:1}}),w.expect(i.attributes.extraData).toEqual({foo:1}),w.expect(i.extraData.attributes).toEqual({foo:1}),w.expect(i.extraData.attributes).not.toBe(e),w.expect(i.attributes.extraData).not.toBe(e),w.expect(i.extraData.attributes).toBe(i.attributes.extraData)})}),w.describe("With spina BaseModel",function(){w.beforeEach(function(){var e;let t=n.spina({mixins:[RB.ExtraDataMixin]})(e=class extends n.BaseModel{static defaults(){return{extraData:{}}}initialize(){this._setupExtraData()}})||e;i=new t}),w.it("change events fired",function(){var e={change:function(){},"change:extraData":function(){}};w.spyOn(e,"change"),w.spyOn(e,"change:extraData"),i.on("change",e.change),i.on("change:extraData",e["change:extraData"]),i.setExtraData("foo",1),w.expect(e.change).toHaveBeenCalled(),w.expect(e["change:extraData"]).toHaveBeenCalled()}),w.it("attributes updated",function(){var e=i.attributes.extraData;w.expect(i.extraData.attributes).toBe(e),i.set({extraData:{foo:1}}),w.expect(i.attributes.extraData).toEqual({foo:1}),w.expect(i.extraData.attributes).toEqual({foo:1}),w.expect(i.extraData.attributes).not.toBe(e),w.expect(i.attributes.extraData).not.toBe(e),w.expect(i.extraData.attributes).toBe(i.attributes.extraData)})})}),e.suite("rb/models/UserSession",function(){w.describe("create",function(){w.it("Instance is set",function(){RB.UserSession.instance=null;var e=RB.UserSession.create({username:"testuser"});w.expect(e).toBe(RB.UserSession.instance)}),w.it("Second attempt fails",function(){RB.UserSession.instance=null,RB.UserSession.create({username:"testuser"}),w.expect(console.assert).toHaveBeenCalled(),w.expect(console.assert.calls.argsFor(0)[0]).toBeTruthy(),w.expect(()=>RB.UserSession.create({username:"foo"})).toThrow(),w.expect(console.assert).toHaveBeenCalled(),w.expect(console.assert.calls.argsFor(1)[0]).toBeFalsy()})}),w.describe("Attributes",function(){let e;w.beforeEach(function(){e=RB.UserSession.instance}),w.describe("diffsShowExtraWhitespace",function(){w.describe("Loads from cookie",function(){w.it('When "true"',function(){w.spyOn($,"cookie").and.returnValue("true"),RB.UserSession.instance=null,e=RB.UserSession.create({username:"testuser"}),w.expect($.cookie).toHaveBeenCalledWith("show_ew"),w.expect(e.get("diffsShowExtraWhitespace")).toBe(!0)}),w.it('When "false"',function(){w.spyOn($,"cookie").and.returnValue("false"),RB.UserSession.instance=null,e=RB.UserSession.create({username:"testuser"}),w.expect($.cookie).toHaveBeenCalledWith("show_ew"),w.expect(e.get("diffsShowExtraWhitespace")).toBe(!1)})}),w.describe("Sets cookie",function(){w.beforeEach(function(){w.spyOn($,"cookie")}),w.it("When true",function(){e.attributes.diffsShowExtraWhitespace=!1,e.set("diffsShowExtraWhitespace",!0),w.expect($.cookie).toHaveBeenCalledWith("show_ew","true",{path:SITE_ROOT})}),w.it("When false",function(){e.attributes.diffsShowExtraWhitespace=!0,e.set("diffsShowExtraWhitespace",!1),w.expect($.cookie).toHaveBeenCalledWith("show_ew","false",{path:SITE_ROOT})})})})})}),e.suite("rb/resources/collections/ResourceCollection",function(){let i,t;w.beforeEach(function(){t=new RB.ReviewRequest({id:123,links:{reviews:{href:"/api/review-requests/123/reviews/"}},loaded:!0}),w.spyOn(t,"ready").and.resolveTo(),i=new RB.ResourceCollection([],{model:RB.Review,parentResource:t})}),w.describe("Methods",function(){w.describe("fetch",function(){w.it("Populates collection",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.url).toBe("/api/review-requests/123/reviews/"),w.expect(e.type).toBe("GET"),e.success({links:{next:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"},self:{href:"/api/review-requests/123/reviews/",method:"GET"}},reviews:[{id:1,links:{}},{id:2,links:{}}],stat:"ok",total_results:2})}),await i.fetch(),w.expect($.ajax).toHaveBeenCalled(),w.expect(i.length).toBe(2),w.expect(i.at(0).id).toBe(1),w.expect(i.at(1).id).toBe(2),w.expect(i.hasPrev).toBe(!1),w.expect(i.hasNext).toBe(!0)}),w.it("With start=",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.url).toBe("/api/review-requests/123/reviews/"),w.expect(e.data).not.toBe(void 0),w.expect(e.data.start).toBe(100),e.success({})}),await i.fetch({start:100});var e=$.ajax.calls.argsFor(0)[0];w.expect(e.type).toBe("GET"),w.expect(e.url).toBe("/api/review-requests/123/reviews/"),w.expect(e.start).toBe(100),w.expect(e.data).toEqual({api_format:"json",start:100})}),w.describe("With parentResource",function(){w.it("Calls parentResource.ready",async function(){w.spyOn(RB.BaseCollection.prototype,"fetch").and.resolveTo(),await i.fetch(),w.expect(t.ready).toHaveBeenCalled(),w.expect(RB.BaseCollection.prototype.fetch).toHaveBeenCalled()})}),w.it("Using callbacks",function(e){w.spyOn(RB.BaseCollection.prototype,"fetch").and.resolveTo(),w.spyOn(console,"warn"),i.fetch({error:()=>e.fail(),success:()=>{w.expect(t.ready).toHaveBeenCalled(),w.expect(RB.BaseCollection.prototype.fetch).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("fetchAll",function(){w.it("Spanning pages",async function(){let t=0;w.spyOn($,"ajax").and.callFake(e=>{console.assert(t<2),w.expect(e.type).toBe("GET"),1===++t?(w.expect(e.url).toBe("/api/review-requests/123/reviews/"),e.success({links:{next:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"},self:{href:"/api/review-requests/123/reviews/",method:"GET"}},reviews:[{id:1,links:{}},{id:2,links:{}}],stat:"ok",total_results:4})):2===t&&(w.expect(e.url).toBe("/api/review-requests/123/reviews/?start=25"),e.success({links:{prev:{href:"/api/review-requests/123/reviews/?start=0",method:"GET"},self:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"}},reviews:[{id:3,links:{}},{id:4,links:{}}],stat:"ok",total_results:4}))}),await i.fetchAll(),w.expect($.ajax).toHaveBeenCalled(),w.expect(t).toBe(2),w.expect(i.hasPrev).toBe(!1),w.expect(i.hasNext).toBe(!1),w.expect(i.totalResults).toBe(4),w.expect(i.currentPage).toBe(0),w.expect(i.length).toBe(4),w.expect(i.at(0).id).toBe(1),w.expect(i.at(1).id).toBe(2),w.expect(i.at(2).id).toBe(3),w.expect(i.at(3).id).toBe(4)}),w.it("With callbacks",function(e){let t=0;w.spyOn($,"ajax").and.callFake(e=>{console.assert(t<2),w.expect(e.type).toBe("GET"),1===++t?(w.expect(e.url).toBe("/api/review-requests/123/reviews/"),e.success({links:{next:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"},self:{href:"/api/review-requests/123/reviews/",method:"GET"}},reviews:[{id:1,links:{}},{id:2,links:{}}],stat:"ok",total_results:4})):2===t&&(w.expect(e.url).toBe("/api/review-requests/123/reviews/?start=25"),e.success({links:{prev:{href:"/api/review-requests/123/reviews/?start=0",method:"GET"},self:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"}},reviews:[{id:3,links:{}},{id:4,links:{}}],stat:"ok",total_results:4}))}),w.spyOn(console,"warn"),i.fetchAll({error:()=>e.fail(),success:()=>{w.expect($.ajax).toHaveBeenCalled(),w.expect(t).toBe(2),w.expect(i.hasPrev).toBe(!1),w.expect(i.hasNext).toBe(!1),w.expect(i.totalResults).toBe(4),w.expect(i.currentPage).toBe(0),w.expect(i.length).toBe(4),w.expect(i.at(0).id).toBe(1),w.expect(i.at(1).id).toBe(2),w.expect(i.at(2).id).toBe(3),w.expect(i.at(3).id).toBe(4),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("fetchNext",function(){w.it("With hasNext == false",async function(){i.hasNext=!1,w.spyOn(i,"fetch"),await i.fetchNext(),w.expect(i.fetch).not.toHaveBeenCalled()}),w.it("With hasNext == true",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.url).toBe("/api/review-requests/123/reviews/?start=25"),w.expect(e.type).toBe("GET"),e.success({links:{next:{href:"/api/review-requests/123/reviews/?start=50",method:"GET"},prev:{href:"/api/review-requests/123/reviews/?start=0",method:"GET"},self:{href:"/api/review-requests/123/reviews/",method:"GET"}},reviews:[{id:1,links:{}},{id:2,links:{}}],stat:"ok",total_results:2})}),i.hasNext=!0,i.currentPage=2,i._links={next:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"}},w.spyOn(i,"fetch").and.callThrough(),await i.fetchNext(),w.expect(i.fetch).toHaveBeenCalled(),w.expect(i.hasPrev).toBe(!0),w.expect(i.hasNext).toBe(!0),w.expect(i.currentPage).toBe(3),w.expect(i.models.length).toBe(2)}),w.it("With callbacks",function(e){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.url).toBe("/api/review-requests/123/reviews/?start=25"),w.expect(e.type).toBe("GET"),e.success({links:{next:{href:"/api/review-requests/123/reviews/?start=50",method:"GET"},prev:{href:"/api/review-requests/123/reviews/?start=0",method:"GET"},self:{href:"/api/review-requests/123/reviews/",method:"GET"}},reviews:[{id:1,links:{}},{id:2,links:{}}],stat:"ok",total_results:2})}),i.hasNext=!0,i.currentPage=2,i._links={next:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"}},w.spyOn(i,"fetch").and.callThrough(),w.spyOn(console,"warn"),i.fetchNext({error:()=>e.fail(),success:()=>{w.expect(i.fetch).toHaveBeenCalled(),w.expect(i.hasPrev).toBe(!0),w.expect(i.hasNext).toBe(!0),w.expect(i.currentPage).toBe(3),w.expect(i.models.length).toBe(2),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("fetchPrev",function(){w.it("With hasPrev == false",async function(){i.hasPrev=!1,w.spyOn(i,"fetch"),await i.fetchPrev(),w.expect(i.fetch).not.toHaveBeenCalled()}),w.it("With hasPrev == true",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.url).toBe("/api/review-requests/123/reviews/?start=25"),w.expect(e.type).toBe("GET"),e.success({links:{next:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"},prev:{href:"/api/review-requests/123/reviews/?start=0",method:"GET"},self:{href:"/api/review-requests/123/reviews/",method:"GET"}},reviews:[{id:1,links:{}},{id:2,links:{}}],stat:"ok",total_results:2})}),i.hasPrev=!0,i.currentPage=2,i._links={prev:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"}},w.spyOn(i,"fetch").and.callThrough(),await i.fetchPrev(),w.expect(i.fetch).toHaveBeenCalled(),w.expect(i.hasPrev).toBe(!0),w.expect(i.hasNext).toBe(!0),w.expect(i.currentPage).toBe(1),w.expect(i.models.length).toBe(2)}),w.it("With callbacks",function(e){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.url).toBe("/api/review-requests/123/reviews/?start=25"),w.expect(e.type).toBe("GET"),e.success({links:{next:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"},prev:{href:"/api/review-requests/123/reviews/?start=0",method:"GET"},self:{href:"/api/review-requests/123/reviews/",method:"GET"}},reviews:[{id:1,links:{}},{id:2,links:{}}],stat:"ok",total_results:2})}),i.hasPrev=!0,i.currentPage=2,i._links={prev:{href:"/api/review-requests/123/reviews/?start=25",method:"GET"}},w.spyOn(i,"fetch").and.callThrough(),w.spyOn(console,"warn"),i.fetchPrev({error:()=>e.fail(),success:()=>{w.expect(i.fetch).toHaveBeenCalled(),w.expect(i.hasPrev).toBe(!0),w.expect(i.hasNext).toBe(!0),w.expect(i.currentPage).toBe(1),w.expect(i.models.length).toBe(2),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("parse",function(){let t;w.beforeEach(function(){t={links:{},reviews:[],total_results:5}}),w.it("Resources returned",function(){t.reviews=[{id:1},{id:2},{id:3}];var e=i.parse(t);w.expect(e.length).toBe(3),w.expect(e[0].id).toBe(1),w.expect(e[1].id).toBe(2),w.expect(e[2].id).toBe(3)}),w.it("totalResults set",function(){i.parse(t),w.expect(i.totalResults).toBe(5)}),w.describe("With fetchingAll",function(){const e={fetchingAll:!0};w.it("currentPage = 0",function(){i.parse(t,e),w.expect(i.currentPage).toBe(0)}),w.it("hasPrev disabled",function(){i.parse(t,e),w.expect(i.hasPrev).toBe(!1)}),w.it("hasNext disabled",function(){i.parse(t,e),w.expect(i.hasNext).toBe(!1)})}),w.describe("Without fetchingAll",function(){w.describe("currentPage",function(){w.it("undefined when not options.page",function(){i.parse(t),w.expect(i.currentPage).toBe(void 0)}),w.it("Set when options.page",function(){i.parse(t,{page:4}),w.expect(i.currentPage).toBe(4)})}),w.describe("hasPrev",function(){w.it("true with rsp.links.prev",function(){t.links={prev:{href:"blah"}},i.parse(t),w.expect(i.hasPrev).toBe(!0)}),w.it("false without rsp.links.prev",function(){i.parse(t),w.expect(i.hasPrev).toBe(!1)})}),w.describe("hasNext",function(){w.it("true with rsp.links.next",function(){t.links={next:{href:"blah"}},i.parse(t),w.expect(i.hasNext).toBe(!0)}),w.it("false without rsp.links.next",function(){i.parse(t),w.expect(i.hasNext).toBe(!1)})})})}),w.describe("url",function(){w.it("With parentResource",function(){w.expect(i.url()).toBe("/api/review-requests/123/reviews/")}),w.it("With _fetchURL",function(){i._fetchURL="/api/foo/",w.expect(i.url()).toBe("/api/foo/")}),w.it("Without _fetchURL or parentResource",function(){i.parentResource=null,w.expect(i.url()).toBe(null)})})})}),e.suite("rb/resources/models/BaseComment",function(){const e=RB.BaseComment.strings;let t,i;w.beforeEach(function(){t=new RB.BaseResource({public:!0}),i=new RB.BaseComment({parentObject:t}),w.expect(i.validate(i.attributes)).toBe(void 0)}),w.describe("State values",function(){w.it("STATE_DROPPED",function(){w.expect(RB.BaseComment.STATE_DROPPED).toBe("dropped"),w.expect(RB.BaseComment.STATE_DROPPED).toBe(RB.CommentIssueStatusType.DROPPED)}),w.it("STATE_OPEN",function(){w.expect(RB.BaseComment.STATE_OPEN).toBe("open"),w.expect(RB.BaseComment.STATE_OPEN).toBe(RB.CommentIssueStatusType.OPEN)}),w.it("STATE_RESOLVED",function(){w.expect(RB.BaseComment.STATE_RESOLVED).toBe("resolved"),w.expect(RB.BaseComment.STATE_RESOLVED).toBe(RB.CommentIssueStatusType.RESOLVED)}),w.it("STATE_VERIFYING_DROPPED",function(){w.expect(RB.BaseComment.STATE_VERIFYING_DROPPED).toBe("verifying-dropped"),w.expect(RB.BaseComment.STATE_VERIFYING_DROPPED).toBe(RB.CommentIssueStatusType.VERIFYING_DROPPED)}),w.it("STATE_VERIFYING_RESOLVED",function(){w.expect(RB.BaseComment.STATE_VERIFYING_RESOLVED).toBe("verifying-resolved"),w.expect(RB.BaseComment.STATE_VERIFYING_RESOLVED).toBe(RB.CommentIssueStatusType.VERIFYING_RESOLVED)})}),w.describe("destroyIfEmpty",function(){w.beforeEach(function(){w.spyOn(i,"destroy")}),w.it("Destroying when text is empty",function(){i.set("text",""),i.destroyIfEmpty(),w.expect(i.destroy).toHaveBeenCalled()}),w.it("Not destroying when text is not empty",function(){i.set("text","foo"),i.destroyIfEmpty(),w.expect(i.destroy).not.toHaveBeenCalled()})}),w.describe("parse",function(){w.beforeEach(function(){i.rspNamespace="my_comment"}),w.it("API payloads",function(){var e=i.parse({my_comment:{id:42,issue_opened:!0,issue_status:"resolved",text:"foo"},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.id).toBe(42),w.expect(e.issueOpened).toBe(!0),w.expect(e.issueStatus).toBe(RB.CommentIssueStatusType.RESOLVED),w.expect(e.text).toBe("foo")})}),w.describe("toJSON",function(){w.describe("force_text_type field",function(){w.it("With value",function(){i.set("forceTextType","html");var e=i.toJSON();w.expect(e.force_text_type).toBe("html")}),w.it("Without value",function(){var e=i.toJSON();w.expect(e.force_text_type).toBe(void 0)})}),w.describe("include_text_types field",function(){w.it("With value",function(){i.set("includeTextTypes","html");var e=i.toJSON();w.expect(e.include_text_types).toBe("html")}),w.it("Without value",function(){var e=i.toJSON();w.expect(e.include_text_types).toBe(void 0)})}),w.describe("issue_opened field",function(){w.it("Default",function(){var e=i.toJSON();w.expect(e.issue_opened).toBe(null)}),w.it("With value",function(){i.set("issueOpened",!1);var e=i.toJSON();w.expect(e.issue_opened).toBe(!1),i.set("issueOpened",!0),e=i.toJSON(),w.expect(e.issue_opened).toBe(!0)})}),w.describe("issue_status field",function(){w.it("When not loaded",function(){i.set("issueStatus",RB.CommentIssueStatusType.DROPPED);var e=i.toJSON();w.expect(e.issue_status).toBe(void 0)}),w.it("When loaded and parent is not public",function(){t.set("public",!1),i.set({issueStatus:RB.CommentIssueStatusType.DROPPED,loaded:!0,parentObject:t});var e=i.toJSON();w.expect(e.issue_status).toBe(void 0)}),w.it("When loaded and parent is public",function(){t.set("public",!0),i.set({issueStatus:RB.CommentIssueStatusType.DROPPED,loaded:!0,parentObject:t});var e=i.toJSON();w.expect(e.issue_status).toBe(RB.CommentIssueStatusType.DROPPED)})}),w.describe("richText field",function(){w.it("With true",function(){i.set("richText",!0);var e=i.toJSON();w.expect(e.text_type).toBe("markdown")}),w.it("With false",function(){i.set("richText",!1);var e=i.toJSON();w.expect(e.text_type).toBe("plain")})}),w.describe("text field",function(){w.it("With value",function(){i.set("text","foo");var e=i.toJSON();w.expect(e.text).toBe("foo")})})}),w.describe("validate",function(){w.describe("issueState",function(){w.it("DROPPED",function(){w.expect(i.validate({issueStatus:RB.CommentIssueStatusType.DROPPED})).toBe(void 0)}),w.it("OPEN",function(){w.expect(i.validate({issueStatus:RB.CommentIssueStatusType.OPEN})).toBe(void 0)}),w.it("RESOLVED",function(){w.expect(i.validate({issueStatus:RB.CommentIssueStatusType.RESOLVED})).toBe(void 0)}),w.it("VERIFYING_DROPPED",function(){w.expect(i.validate({issueStatus:RB.CommentIssueStatusType.VERIFYING_DROPPED})).toBe(void 0)}),w.it("VERIFYING_RESOLVED",function(){w.expect(i.validate({issueStatus:RB.CommentIssueStatusType.VERIFYING_RESOLVED})).toBe(void 0)}),w.it("Unset",function(){w.expect(i.validate({issueStatus:""})).toBe(void 0),w.expect(i.validate({issueStatus:void 0})).toBe(void 0),w.expect(i.validate({issueStatus:null})).toBe(void 0)}),w.it("Invalid values",function(){w.expect(i.validate({issueStatus:"foobar"})).toBe(e.INVALID_ISSUE_STATUS)})}),w.describe("parentObject",function(){w.it("With value",function(){w.expect(i.validate({parentObject:t})).toBe(void 0)}),w.it("Unset",function(){w.expect(i.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})}),e.suite("rb/resources/models/BaseResource",function(){let i,n;w.beforeEach(function(){(i=new RB.BaseResource).rspNamespace="foo",n=new RB.BaseResource({links:{foos:{href:"/api/foos/"}}})}),w.describe("ensureCreated",function(){w.beforeEach(function(){w.spyOn(i,"save").and.resolveTo(),w.spyOn(i,"fetch").and.resolveTo(),w.spyOn(i,"ready").and.callThrough()}),w.it("With loaded=true",async function(){i.set("loaded",!0),await i.ensureCreated(),w.expect(i.ready).toHaveBeenCalled(),w.expect(i.fetch).not.toHaveBeenCalled(),w.expect(i.save).not.toHaveBeenCalled()}),w.it("With loaded=false, isNew=true",async function(){i.set("loaded",!1),await i.ensureCreated(),w.expect(i.ready).toHaveBeenCalled(),w.expect(i.fetch).not.toHaveBeenCalled(),w.expect(i.save).toHaveBeenCalled()}),w.it("With loaded=false, isNew=false",async function(){i.set({id:1,loaded:!1}),await i.ensureCreated(),w.expect(i.ready).toHaveBeenCalled(),w.expect(i.fetch).toHaveBeenCalled(),w.expect(i.save).toHaveBeenCalled()}),w.it("With callbacks",function(e){i.set({id:1,loaded:!1}),w.spyOn(console,"warn"),i.ensureCreated({error:()=>e.fail(),success:()=>{w.expect(i.ready).toHaveBeenCalled(),w.expect(i.fetch).toHaveBeenCalled(),w.expect(i.save).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("fetch",function(){w.describe("Basic functionality",function(){w.beforeEach(function(){w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{e&&_.isFunction(e.success)&&e.success()})}),w.it("With isNew=true",async function(){w.expect(i.isNew()).toBe(!0),await w.expectAsync(i.fetch()).toBeRejectedWith(Error("fetch cannot be used on a resource without an ID")),w.expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()}),w.it("With isNew=false and no parentObject",async function(){i.set("id",123),await i.fetch(),w.expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()}),w.it("With isNew=false and parentObject",async function(){i.set({id:123,parentObject:n}),w.spyOn(n,"ready").and.resolveTo(),await i.fetch(),w.expect(n.ready).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()}),w.it("With isNew=false and parentObject with error",async function(){i.set({id:123,parentObject:n}),w.spyOn(n,"ready").and.rejectWith(new BackboneError(n,{errorText:"Oh nosers."},{})),await w.expectAsync(i.fetch()).toBeRejectedWith(Error("Oh nosers.")),w.expect(n.ready).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()}),w.it("With callbacks",function(e){i.set({id:123,parentObject:n}),w.spyOn(n,"ready").and.resolveTo(),w.spyOn(console,"warn"),i.fetch({error:()=>e.fail(),success:()=>{w.expect(n.ready).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.fetch).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("Response handling",function(){w.beforeEach(function(){i.set({id:123,links:{self:{href:"/api/foo/"}}})}),w.it("Custom response parsing",async function(){w.spyOn(i,"parse").and.callFake(e=>({a:e.a+1,b:e.b,c:!0})),w.spyOn($,"ajax").and.callFake(e=>{e.success({a:10,b:20,d:30})}),await i.fetch(),w.expect(i.get("a")).toBe(11),w.expect(i.get("b")).toBe(20),w.expect(i.get("c")).toBe(!0),w.expect(i.get("d")).toBe(void 0)}),w.it("Default response parsing",async function(){w.spyOn(i,"parse").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{e.success({foo:{a:20,id:42,links:{foo:{href:"bar"}}},stat:"ok"})}),await i.fetch(),w.expect(i.get("a")).toBe(void 0),w.expect(i.id).toBe(42),w.expect(i.get("links").foo).not.toBe(void 0),w.expect(i.get("loaded")).toBe(!0)})}),w.describe("Request payload",function(){w.beforeEach(function(){i.set({id:123,links:{self:{href:"/api/foo/"}}})}),w.describe("GET",function(){w.it("No contentType sent",async function(){w.spyOn(Backbone,"sync").and.callFake((e,t,i)=>{w.expect(i.contentType).toBe(void 0),i.success.call(t,{})}),await i.fetch(),w.expect(Backbone.sync).toHaveBeenCalled()}),w.it("No model data sent",async function(){w.spyOn(Backbone,"sync").and.callFake((e,t,i)=>{w.expect(_.isEmpty(i.data)).toBe(!0),i.success.call(t,{})}),i.toJSON=()=>({a:1,b:2}),await i.fetch(),w.expect(Backbone.sync).toHaveBeenCalled()}),w.it("Query attributes sent",async function(){w.spyOn(Backbone,"sync").and.callFake((e,t,i)=>{w.expect(_.isEmpty(i.data)).toBe(!1),w.expect(i.data.foo).toBe("bar"),i.success.call(t,{})}),i.toJSON=()=>({a:1,b:2}),await i.fetch({data:{foo:"bar"}}),w.expect(Backbone.sync).toHaveBeenCalled()})})})}),w.describe("ready",function(){w.beforeEach(function(){w.spyOn(i,"fetch").and.resolveTo()}),w.it("With loaded=true",async function(){i.set("loaded",!0),await i.ready(),w.expect(i.fetch).not.toHaveBeenCalled()}),w.it("With loaded=false and isNew=true",async function(){i.set("loaded",!1),w.expect(i.isNew()).toBe(!0),await i.ready(),w.expect(i.fetch).not.toHaveBeenCalled()}),w.it("With loaded=false and isNew=false",async function(){i.set({id:123,loaded:!1}),w.expect(i.isNew()).toBe(!1),await i.ready(),w.expect(i.fetch).toHaveBeenCalled()}),w.it("With callbacks",function(e){i.set({id:123,loaded:!1}),w.expect(i.isNew()).toBe(!1),w.spyOn(console,"warn"),i.ready({error:()=>e.fail(),success:()=>{w.expect(i.fetch).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("save",function(){w.beforeEach(function(){w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{e&&_.isFunction(e.success)&&e.success()}),w.spyOn(i,"trigger")}),w.it("With isNew=true and parentObject",async function(){const t={foo:{},stat:"ok"};w.spyOn(n,"ensureCreated").and.resolveTo(),w.spyOn(n,"ready").and.resolveTo(),w.spyOn(Backbone.Model.prototype,"save").and.callThrough(),i.set("parentObject",n),w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),e.success(t)}),await i.save(),w.expect(Backbone.Model.prototype.save).toHaveBeenCalled(),w.expect(n.ensureCreated).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled(),w.expect(i.trigger).toHaveBeenCalledWith("saved",{})}),w.it("With isNew=true and no parentObject",async function(){w.spyOn(Backbone.Model.prototype,"save").and.callThrough(),w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax");try{throw await i.save(),new Error}catch(e){w.expect(Backbone.Model.prototype.save).not.toHaveBeenCalled(),w.expect(RB.apiCall).not.toHaveBeenCalled(),w.expect($.ajax).not.toHaveBeenCalled(),w.expect(e.message).toBe("The object must either be loaded from the server or have a parent object before it can be saved"),w.expect(i.trigger).not.toHaveBeenCalledWith("saved",{})}}),w.it("With isNew=false and no parentObject",async function(){i.set("id",123),i.url="/api/foos/1/",w.spyOn(Backbone.Model.prototype,"save").and.callFake((e,t)=>{t&&_.isFunction(t.success)&&t.success()}),await i.save(),w.expect(Backbone.Model.prototype.save).toHaveBeenCalled(),w.expect(i.trigger).toHaveBeenCalledWith("saved",{})}),w.it("With isNew=false and parentObject",async function(){w.spyOn(n,"ensureCreated").and.resolveTo(),w.spyOn(Backbone.Model.prototype,"save").and.callThrough(),i.set({id:123,parentObject:n}),w.spyOn(n,"ready").and.resolveTo(),w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("PUT"),e.success({foo:{},stat:"ok"})}),await i.save(),w.expect(n.ready).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.save).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled(),w.expect(i.trigger).toHaveBeenCalledWith("saved",{})}),w.it("With isNew=false and parentObject with error",async function(){i.set({id:123,parentObject:n}),w.spyOn(n,"ready").and.rejectWith(new BackboneError(n,{errorText:"Oh nosers."},{})),w.spyOn(Backbone.Model.prototype,"save").and.callFake((e,t)=>{t&&_.isFunction(t.success)&&t.success()}),await w.expectAsync(i.save()).toBeRejectedWith(Error("Oh nosers.")),w.expect(n.ready).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.save).not.toHaveBeenCalled(),w.expect(i.trigger).not.toHaveBeenCalledWith("saved")}),w.it("With callbacks",function(e){const t={foo:{},stat:"ok"};w.spyOn(n,"ensureCreated").and.resolveTo(),w.spyOn(n,"ready").and.resolveTo(),w.spyOn(Backbone.Model.prototype,"save").and.callThrough(),i.set("parentObject",n),w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),e.success(t)}),w.spyOn(console,"warn"),i.save({error:()=>e.fail(),success:()=>{w.expect(Backbone.Model.prototype.save).toHaveBeenCalled(),w.expect(n.ensureCreated).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled(),w.expect(i.trigger).toHaveBeenCalledWith("saved",{}),w.expect(console.warn).toHaveBeenCalled(),e()}})}),w.describe("Request payload",function(){w.it("Saved data",async function(){i.set("id",1),i.url="/api/foos/",w.expect(i.isNew()).toBe(!1),w.spyOn(i,"toJSON").and.callFake(()=>({a:10,b:20,c:30})),w.spyOn(i,"ready").and.resolveTo(),w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.url).toBe(i.url),w.expect(e.contentType).toBe("application/x-www-form-urlencoded"),w.expect(e.processData).toBe(!0),w.expect(e.data.a).toBe(10),w.expect(e.data.b).toBe(20),w.expect(e.data.c).toBe(30),e.success({foo:{a:10,b:20,c:30,id:1,links:{}},stat:"ok"})}),await i.save(),w.expect(i.toJSON).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()})}),w.describe("With file upload support",function(){w.beforeEach(function(){i.payloadFileKeys=["file"],i.url="/api/foos/",i.toJSON=function(){return{file:this.get("file"),myfield:"myvalue"}},w.spyOn(Backbone.Model.prototype,"save").and.callThrough(),w.spyOn(RB,"apiCall").and.callThrough()}),w.it("With file",async function(){const n="-----multipartformboundary";var e=new File(["Hello world!"],"myfile",{type:"text/plain"});w.spyOn($,"ajax").and.callFake(e=>{var t=new FileReader;w.expect(e.type).toBe("POST"),w.expect(e.processData).toBe(!1),w.expect(e.contentType.indexOf("multipart/form-data; boundary=")).toBe(0),t.onload=function(){var t=new Uint8Array(this.result),i=[];for(let e=0;e<t.length;e++)i.push(String.fromCharCode(t[e]));w.expect(i.join("")).toBe("--"+n+'\r\nContent-Disposition: form-data; name="file"; filename="myfile"\r\nContent-Type: text/plain\r\n\r\nHello world!\r\n--'+n+'\r\nContent-Disposition: form-data; name="myfield"\r\n\r\nmyvalue\r\n--'+n+"--\r\n\r\n"),e.success({foo:{id:42},stat:"ok"})},t.readAsArrayBuffer(e.data)}),i.set("file",e),await i.save({boundary:n}),w.expect(Backbone.Model.prototype.save).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("With multiple files",async function(){const n="-----multipartformboundary";var e=new File(["Hello world!"],"myfile1",{type:"text/plain"}),t=new File(["Goodbye world!"],"myfile2",{type:"text/plain"});i.payloadFileKeys=["file1","file2"],i.toJSON=function(){return{file1:this.get("file1"),file2:this.get("file2"),myfield:"myvalue"}},w.spyOn($,"ajax").and.callFake(e=>{var t=new FileReader;w.expect(e.type).toBe("POST"),w.expect(e.processData).toBe(!1),w.expect(e.contentType.indexOf("multipart/form-data; boundary=")).toBe(0),t.onload=function(){var t=new Uint8Array(this.result),i=[];for(let e=0;e<t.length;e++)i.push(String.fromCharCode(t[e]));w.expect(i.join("")).toBe("--"+n+'\r\nContent-Disposition: form-data; name="file1"; filename="myfile1"\r\nContent-Type: text/plain\r\n\r\nHello world!\r\n--'+n+'\r\nContent-Disposition: form-data; name="file2"; filename="myfile2"\r\nContent-Type: text/plain\r\n\r\nGoodbye world!\r\n--'+n+'\r\nContent-Disposition: form-data; name="myfield"\r\n\r\nmyvalue\r\n--'+n+"--\r\n\r\n"),e.success({foo:{id:42},stat:"ok"})},t.readAsArrayBuffer(e.data)}),i.set("file1",e),i.set("file2",t),await i.save({boundary:n}),w.expect(Backbone.Model.prototype.save).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("Without file",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),w.expect(e.processData).toBe(!0),w.expect(e.contentType).toBe("application/x-www-form-urlencoded"),e.success({foo:{id:42},stat:"ok"})}),await i.save(),w.expect(Backbone.Model.prototype.save).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()})}),w.describe("With form upload support",function(){w.beforeEach(function(){i.url="/api/foos/"}),w.it("Overriding toJSON attributes",async function(){var e=$("<form>").append($('<input name="foo">'));i.toJSON=()=>({myfield:"myvalue"}),w.spyOn(Backbone,"sync").and.callThrough(),w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax"),w.spyOn(e,"ajaxSubmit").and.callFake(e=>e.success({})),await i.save({form:e}),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect(e.ajaxSubmit).toHaveBeenCalled(),w.expect($.ajax).not.toHaveBeenCalled(),w.expect(Backbone.sync.calls.argsFor(0)[2].data).toBe(null),w.expect(RB.apiCall.calls.argsFor(0)[0].data).toBe(null)}),w.it("Overriding file attributes",async function(){var e=$("<form>").append($('<input name="foo">'));i.payloadFileKey="file",i.toJSON=function(){return{file:this.get("file")}},w.spyOn(i,"_saveWithFiles").and.callThrough(),w.spyOn(Backbone,"sync").and.callThrough(),w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax"),w.spyOn(e,"ajaxSubmit").and.callFake(e=>e.success({})),await i.save({form:e}),w.expect(i._saveWithFiles).not.toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect(e.ajaxSubmit).toHaveBeenCalled(),w.expect($.ajax).not.toHaveBeenCalled(),w.expect(Backbone.sync.calls.argsFor(0)[2].data).toBe(null),w.expect(RB.apiCall.calls.argsFor(0)[0].data).toBe(null)})})}),w.describe("url",function(){w.it("With self link",function(){var e="/api/base-resource/";i.set("links",{self:{href:e}}),w.expect(i.url()).toBe(e)}),w.it("With parentObject and model ID",function(){i.set({id:123,parentObject:n}),w.expect(i.url()).toBe("/api/foos/123/")}),w.it("With parentObject, no links",function(){i.set("parentObject",n),w.expect(i.url()).toBe("/api/foos/")}),w.it("With no parentObject, no links",function(){w.expect(i.url()).toBe(null)})})}),e.suite("rb/resources/models/DefaultReviewer",function(){let t;w.beforeEach(function(){t=new RB.DefaultReviewer}),w.describe("parse",function(){w.it("API payloads",function(){var e=t.parse({default_reviewer:{file_regex:"/foo/.*",id:42,name:"my-default-reviewer"},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.id).toBe(42),w.expect(e.name).toBe("my-default-reviewer"),w.expect(e.fileRegex).toBe("/foo/.*")})}),w.describe("toJSON",function(){w.describe("name field",function(){w.it("With value",function(){t.set("name","foo");var e=t.toJSON();w.expect(e.name).toBe("foo")})}),w.describe("fileRegex field",function(){w.it("With value",function(){t.set("fileRegex","/foo/.*");var e=t.toJSON();w.expect(e.file_regex).toBe("/foo/.*")})})})}),e.suite("rb/resources/models/DraftReview",function(){let t,i;w.beforeEach(function(){i=new RB.BaseResource({links:{reviews:{href:"/api/foos/"}}}),(t=new RB.DraftReview({parentObject:i})).rspNamespace="foo"}),w.describe("Methods",function(){w.describe("ready",function(){w.beforeEach(function(){w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{e&&_.isFunction(e.success)&&e.success()}),w.spyOn(i,"ready").and.resolveTo(),w.spyOn(t,"_retrieveDraft").and.resolveTo()}),w.it("With isNew=true",async function(){w.expect(t.isNew()).toBe(!0),w.expect(t.get("loaded")).toBe(!1),await t.ready(),w.expect(i.ready).toHaveBeenCalled(),w.expect(t._retrieveDraft).toHaveBeenCalled()}),w.it("With isNew=false",async function(){t.set({id:123}),await t.ready(),w.expect(i.ready).toHaveBeenCalled(),w.expect(t._retrieveDraft).not.toHaveBeenCalled()}),w.it("With callbacks",function(e){w.expect(t.isNew()).toBe(!0),w.expect(t.get("loaded")).toBe(!1),w.spyOn(console,"warn"),t.ready({error:()=>e.fail(),success:()=>{w.expect(i.ready).toHaveBeenCalled(),w.expect(t._retrieveDraft).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("publish",function(){w.beforeEach(function(){w.spyOn(t,"save").and.resolveTo(),w.spyOn(t,"ready").and.resolveTo()}),w.it('Triggers "publishing" event before publish',async function(){w.spyOn(t,"trigger"),await t.publish(),w.expect(t.trigger).toHaveBeenCalledWith("publishing")}),w.it('Triggers "published" event after publish',async function(){w.spyOn(t,"trigger"),await t.publish(),w.expect(t.trigger).toHaveBeenCalledWith("published")}),w.it('Sets "public" to true',async function(){w.expect(t.get("public")).toBe(!1),await t.publish(),w.expect(t.get("public")).toBe(!0)})})})}),e.suite("rb/resources/models/FileAttachment",function(){let t,e;w.beforeEach(function(){e=new RB.BaseResource({public:!0}),t=new RB.FileAttachment({parentObject:e})}),w.describe("toJSON",function(){w.describe("caption field",function(){w.it("With value",function(){t.set("caption","foo");var e=t.toJSON();w.expect(e.caption).toBe("foo")})}),w.describe("file field",function(){w.it("With new file attachment",function(){w.expect(t.isNew()).toBe(!0),t.set("file","abc");var e=t.toJSON();w.expect(e.path).toBe("abc")}),w.it("With existing file attachment",function(){t.id=123,t.attributes.id=123,w.expect(t.isNew()).toBe(!1),t.set("file","abc");var e=t.toJSON();w.expect(e.path).toBe(void 0)})})}),w.describe("parse",function(){w.it("API payloads",function(){var e=t.parse({stat:"ok",file_attachment:{attachment_history_id:1,caption:"caption",filename:"filename",id:42,review_url:"reviewURL",revision:123,state:"Published",thumbnail:"thumbnailHTML",url:"downloadURL"}});w.expect(e).not.toBe(void 0),w.expect(e.attachmentHistoryID).toBe(1),w.expect(e.caption).toBe("caption"),w.expect(e.downloadURL).toBe("downloadURL"),w.expect(e.filename).toBe("filename"),w.expect(e.id).toBe(42),w.expect(e.reviewURL).toBe("reviewURL"),w.expect(e.revision).toBe(123),w.expect(e.state).toBe("Published"),w.expect(e.thumbnailHTML).toBe("thumbnailHTML")})})}),e.suite("rb/resources/models/ReviewGroup",function(){w.describe("setStarred",function(){const t="/api/users/testuser/watched/groups/";let i,n;w.beforeEach(function(){RB.UserSession.instance=null,n=RB.UserSession.create({username:"testuser",watchedReviewGroupsURL:t}),i=new RB.ReviewGroup({id:1}),w.spyOn(n.watchedGroups,"addImmediately").and.callThrough(),w.spyOn(n.watchedGroups,"removeImmediately").and.callThrough(),w.spyOn(RB,"apiCall").and.callThrough()}),w.it("true",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),w.expect(e.url).toBe(t),e.success({stat:"ok"})}),await i.setStarred(!0),w.expect(n.watchedGroups.addImmediately).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("false",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("DELETE"),w.expect(e.url).toBe(t+"1/"),e.success({stat:"ok"})}),await i.setStarred(!1),w.expect(n.watchedGroups.removeImmediately).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("With callbacks",function(e){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),w.expect(e.url).toBe(t),e.success({stat:"ok"})}),w.spyOn(console,"warn"),i.setStarred(!0,{error:()=>e.fail(),success:()=>{w.expect(n.watchedGroups.addImmediately).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("addUser",function(){let t;w.beforeEach(function(){t=new RB.ReviewGroup({id:1,name:"test-group"}),w.spyOn(RB,"apiCall").and.callThrough()}),w.it("Loaded group",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),w.expect(e.data.username).toBe("my-user"),e.success({stat:"ok"})}),await t.addUser("my-user"),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("With callbacks",function(e){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),w.expect(e.data.username).toBe("my-user"),e.success({stat:"ok"})}),w.spyOn(console,"warn"),t.addUser("my-user",{error:()=>e.fail(),success:()=>{w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})}),w.it("Unloaded group",async function(){w.spyOn($,"ajax"),t.set("id",null),w.expect(t.isNew()).toBe(!0),await expectAsync(t.addUser("my-user")).toBeRejectedWith(Error("Unable to add to the group.")),w.expect(RB.apiCall).not.toHaveBeenCalled(),w.expect($.ajax).not.toHaveBeenCalled()})}),w.describe("removeUser",function(){let t;w.beforeEach(function(){t=new RB.ReviewGroup({id:1,name:"test-group"}),w.spyOn(RB,"apiCall").and.callThrough()}),w.it("Loaded group",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("DELETE"),e.success()}),await t.removeUser("my-user"),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("With callbacks",function(e){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("DELETE"),e.success()}),w.spyOn(console,"warn"),t.removeUser("my-user",{error:()=>e.fail(),success:()=>{w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})}),w.it("Unloaded group",async function(){w.spyOn($,"ajax"),t.set("id",null),w.expect(t.isNew()).toBe(!0),await expectAsync(t.removeUser("my-user")).toBeRejectedWith(Error("Unable to remove from the group.")),w.expect(RB.apiCall).not.toHaveBeenCalled(),w.expect($.ajax).not.toHaveBeenCalled()})})}),e.suite("rb/resources/models/Review",function(){let i;w.beforeEach(function(){i=new RB.Review({parentObject:new RB.ReviewRequest})}),w.describe("createReply",function(){w.it("Returns cached draft reply",function(){w.expect(i.get("draftReply")).toBe(null);var e=i.createReply(),t=(w.expect(i.get("draftReply")).toBe(e),i.createReply());w.expect(e).toBe(t)}),w.it("Cached draft reply resets on publish",function(){var e=i.createReply();w.expect(i.get("draftReply")).toBe(e),e.trigger("published"),w.expect(i.get("draftReply")).toBe(null)})}),w.describe("parse",function(){w.beforeEach(function(){i.rspNamespace="my_review"}),w.it("Common API payloads",function(){var e=i.parse({my_review:{body_bottom:"my body bottom",body_bottom_text_type:"plain",body_top:"my body top",body_top_text_type:"markdown",id:42,public:!1,ship_it:!1},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.id).toBe(42),w.expect(e.bodyTop).toBe("my body top"),w.expect(e.bodyBottom).toBe("my body bottom"),w.expect(e.public).toBe(!1),w.expect(e.bodyTopRichText).toBe(!0),w.expect(e.bodyBottomRichText).toBe(!1),w.expect(e.shipIt).toBe(!1)}),w.it("With raw_text_fields",function(){var e=i.parse({my_review:{body_bottom:"my body bottom",body_bottom_text_type:"plain",body_top:"my body top",body_top_text_type:"markdown",raw_text_fields:{body_bottom:"raw body bottom",body_bottom_text_type:"raw",body_top:"raw body top",body_top_text_type:"raw"}},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.bodyTop).toBe("my body top"),w.expect(e.bodyBottom).toBe("my body bottom"),w.expect(e.bodyTopRichText).toBe(!1),w.expect(e.bodyBottomRichText).toBe(!1),w.expect(e.rawTextFields).toBeTruthy(),w.expect(e.rawTextFields.bodyTop).toBe("raw body top"),w.expect(e.rawTextFields.bodyBottom).toBe("raw body bottom")}),w.it("With markdown_text_fields",function(){var e=i.parse({my_review:{body_bottom:"my body bottom",body_bottom_text_type:"plain",body_top:"my body top",body_top_text_type:"markdown",markdown_text_fields:{body_bottom:"Markdown body bottom",body_bottom_text_type:"markdown",body_top:"Markdown body top",body_top_text_type:"markdown"}},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.bodyTop).toBe("my body top"),w.expect(e.bodyBottom).toBe("my body bottom"),w.expect(e.bodyTopRichText).toBe(!0),w.expect(e.bodyBottomRichText).toBe(!1),w.expect(e.markdownTextFields).toBeTruthy(),w.expect(e.markdownTextFields.bodyTop).toBe("Markdown body top"),w.expect(e.markdownTextFields.bodyBottom).toBe("Markdown body bottom")}),w.it("With html_text_fields",function(){var e=i.parse({my_review:{body_bottom:"my body bottom",body_bottom_text_type:"plain",body_top:"my body top",body_top_text_type:"markdown",html_text_fields:{body_bottom:"HTML body bottom",body_bottom_text_type:"html",body_top:"HTML body top",body_top_text_type:"html"}},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.bodyTop).toBe("my body top"),w.expect(e.bodyBottom).toBe("my body bottom"),w.expect(e.bodyTopRichText).toBe(!0),w.expect(e.bodyBottomRichText).toBe(!1),w.expect(e.htmlTextFields).toBeTruthy(),w.expect(e.htmlTextFields.bodyTop).toBe("HTML body top"),w.expect(e.htmlTextFields.bodyBottom).toBe("HTML body bottom")})}),w.describe("toJSON",function(){w.describe("bodyTop field",function(){w.it("With value",function(){i.set("bodyTop","foo");var e=i.toJSON();w.expect(e.body_top).toBe("foo")})}),w.describe("bodyBottom field",function(){w.it("With value",function(){i.set("bodyBottom","foo");var e=i.toJSON();w.expect(e.body_bottom).toBe("foo")})}),w.describe("force_text_type field",function(){w.it("With value",function(){i.set("forceTextType","html");var e=i.toJSON();w.expect(e.force_text_type).toBe("html")}),w.it("Without value",function(){var e=i.toJSON();w.expect(e.force_text_type).toBe(void 0)})}),w.describe("include_text_types field",function(){w.it("With value",function(){i.set("includeTextTypes","html");var e=i.toJSON();w.expect(e.include_text_types).toBe("html")}),w.it("Without value",function(){var e=i.toJSON();w.expect(e.include_text_types).toBe(void 0)})}),w.describe("public field",function(){w.it("With value",function(){i.set("public",!0);var e=i.toJSON();w.expect(e.public).toBe(1)}),w.it("Without value",function(){var e=i.toJSON();w.expect(e.public).toBe(void 0)})}),w.describe("bodyTopRichText field",function(){w.it("With true",function(){i.set("bodyTopRichText",!0);var e=i.toJSON();w.expect(e.body_top_text_type).toBe("markdown")}),w.it("With false",function(){i.set("bodyTopRichText",!1);var e=i.toJSON();w.expect(e.body_top_text_type).toBe("plain")})}),w.describe("bodyBottomRichText field",function(){w.it("With true",function(){i.set("bodyBottomRichText",!0);var e=i.toJSON();w.expect(e.body_bottom_text_type).toBe("markdown")}),w.it("With false",function(){i.set("bodyBottomRichText",!1);var e=i.toJSON();w.expect(e.body_bottom_text_type).toBe("plain")})}),w.describe("shipIt field",function(){w.it("With value",function(){i.set("shipIt",!0);var e=i.toJSON();w.expect(e.ship_it).toBe(!0)})})})}),e.suite("rb/resources/models/ReviewReply",function(){let t,a;w.beforeEach(function(){t=new RB.BaseResource({links:{replies:{href:"/api/foos/replies/"}},public:!0}),a=new RB.ReviewReply({parentObject:t})}),w.describe("destroy",function(){w.beforeEach(function(){w.spyOn(Backbone.Model.prototype,"destroy").and.callFake(e=>e.success()),w.spyOn(a,"_retrieveDraft").and.callThrough(),w.spyOn(t,"ready").and.resolveTo()}),w.it("With isNew=true",async function(){w.expect(a.isNew()).toBe(!0),w.expect(a.get("loaded")).toBe(!1),w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{e&&_.isFunction(e.success)&&e.error(a,{status:404})}),await a.destroy(),w.expect(a.isNew()).toBe(!0),w.expect(a.get("loaded")).toBe(!1),w.expect(t.ready).toHaveBeenCalled(),w.expect(a._retrieveDraft).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.fetch).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()}),w.it("With isNew=false",async function(){a.set({id:123,loaded:!0}),w.spyOn(Backbone.Model.prototype,"fetch"),await a.destroy(),w.expect(t.ready).toHaveBeenCalled(),w.expect(a._retrieveDraft).not.toHaveBeenCalled(),w.expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled(),w.expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()})}),w.describe("discardIfEmpty",function(){w.beforeEach(function(){w.spyOn(a,"destroy").and.resolveTo(),w.spyOn(t,"ready").and.resolveTo(),w.spyOn(a,"ready").and.resolveTo()}),w.it("With isNew=true",async function(){w.expect(a.isNew()).toBe(!0),w.expect(a.get("loaded")).toBe(!1);var e=await a.discardIfEmpty();w.expect(a.destroy).not.toHaveBeenCalled(),w.expect(e).toBe(!1)}),w.describe("With isNew=false",function(){let o;w.beforeEach(function(){o={},a.set({id:123,links:{diff_comments:{href:"/api/diff-comments/"},file_attachment_comments:{href:"/api/file-attachment-comments/"},general_comments:{href:"/api/general-comments/"},screenshot_comments:{href:"/api/screenshot-comments/"},self:{href:"/api/foos/replies/123/"}},loaded:!0}),w.spyOn(RB,"apiCall").and.callFake(t=>{const i=a.get("links");var e={},n=_.find(RB.ReviewReply.COMMENT_LINK_NAMES,e=>t.url===i[e].href);n?(e[n]=o[n]||[],t.success(e)):t.error({status:404})}),w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{e&&_.isFunction(e.success)&&e.success()})}),w.it("With no comments or body replies",async function(){var e=await a.discardIfEmpty();w.expect(e).toBe(!0),w.expect(a.destroy).toHaveBeenCalled()}),w.it("With bodyTop",async function(){a.set({bodyTop:"hi"});var e=await a.discardIfEmpty();w.expect(e).toBe(!1),w.expect(a.destroy).not.toHaveBeenCalled()}),w.it("With bodyBottom",async function(){a.set({bodyBottom:"hi"});var e=await a.discardIfEmpty();w.expect(e).toBe(!1),w.expect(a.destroy).not.toHaveBeenCalled()}),w.it("With diff comment",async function(){o.diff_comments=[{id:1}];var e=await a.discardIfEmpty();w.expect(e).toBe(!1),w.expect(a.destroy).not.toHaveBeenCalled()}),w.it("With screenshot comment",async function(){o.screenshot_comments=[{id:1}];var e=await a.discardIfEmpty();w.expect(e).toBe(!1),w.expect(a.destroy).not.toHaveBeenCalled()}),w.it("With file attachment comment",async function(){o.file_attachment_comments=[{id:1}];var e=await a.discardIfEmpty();w.expect(e).toBe(!1),w.expect(a.destroy).not.toHaveBeenCalled()}),w.it("With general comment",async function(){o.general_comments=[{id:1}];var e=await a.discardIfEmpty();w.expect(e).toBe(!1),w.expect(a.destroy).not.toHaveBeenCalled()}),w.it("With callbacks",function(t){w.spyOn(console,"warn"),a.discardIfEmpty({error:()=>t.fail(),success:e=>{w.expect(e).toBe(!0),w.expect(a.destroy).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),t()}})})})}),w.describe("ready",function(){w.beforeEach(function(){w.spyOn(t,"ready").and.resolveTo()}),w.it("With isNew=true",async function(){w.expect(a.isNew()).toBe(!0),w.expect(a.get("loaded")).toBe(!1),w.spyOn(Backbone.Model.prototype,"fetch").and.resolveTo(),w.spyOn(a,"_retrieveDraft").and.resolveTo(),await a.ready(),w.expect(t.ready).toHaveBeenCalled(),w.expect(a._retrieveDraft).toHaveBeenCalled()}),w.it("With isNew=false",async function(){a.set({id:123}),w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{e&&_.isFunction(e.success)&&e.success()}),w.spyOn(a,"_retrieveDraft").and.resolveTo(),await a.ready(),w.expect(t.ready).toHaveBeenCalled(),w.expect(a._retrieveDraft).not.toHaveBeenCalled()}),w.it("After destruction",async function(){w.spyOn(a,"_retrieveDraft").and.callThrough(),w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{a.set({id:123,links:{self:{href:"/api/foos/replies/123/"}},loaded:!0}),e.success()}),w.spyOn(Backbone.Model.prototype,"destroy").and.callFake(e=>e.success()),w.expect(a.isNew()).toBe(!0),w.expect(a.get("loaded")).toBe(!1),w.expect(a._needDraft).toBe(void 0),await a.ready(),w.expect(t.ready).toHaveBeenCalled(),w.expect(a._retrieveDraft).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.fetch).toHaveBeenCalled(),w.expect(a.isNew()).toBe(!1),w.expect(a.get("loaded")).toBe(!0),w.expect(a._needDraft).toBe(!1),await a.destroy(),w.expect(a.isNew()).toBe(!0),w.expect(a.get("loaded")).toBe(!1),w.expect(a._needDraft).toBe(!0),t.ready.calls.reset(),a._retrieveDraft.calls.reset(),await a.ready(),w.expect(a._retrieveDraft).toHaveBeenCalled(),w.expect(Backbone.Model.prototype.fetch).toHaveBeenCalled(),w.expect(a._needDraft).toBe(!1)}),w.it("With callbacks",function(e){w.expect(a.isNew()).toBe(!0),w.expect(a.get("loaded")).toBe(!1),w.spyOn(Backbone.Model.prototype,"fetch").and.callFake(e=>{e&&_.isFunction(e.success)&&e.success()}),w.spyOn(a,"_retrieveDraft").and.resolveTo(),w.spyOn(console,"warn"),a.ready({error:()=>e.fail(),success:()=>{w.expect(t.ready).toHaveBeenCalled(),w.expect(a._retrieveDraft).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()}})})}),w.describe("parse",function(){w.beforeEach(function(){a.rspNamespace="my_reply"}),w.it("API payloads",function(){var e=a.parse({my_reply:{body_bottom:"bar",body_bottom_text_type:"plain",body_top:"foo",body_top_text_type:"markdown",id:42,public:!1},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.id).toBe(42),w.expect(e.bodyTop).toBe("foo"),w.expect(e.bodyBottom).toBe("bar"),w.expect(e.public).toBe(!1),w.expect(e.bodyTopRichText).toBe(!0),w.expect(e.bodyBottomRichText).toBe(!1)})}),w.describe("toJSON",function(){w.describe("bodyTop field",function(){w.it("With value",function(){a.set("bodyTop","foo");var e=a.toJSON();w.expect(e.body_top).toBe("foo")})}),w.describe("bodyBottom field",function(){w.it("With value",function(){a.set("bodyBottom","foo");var e=a.toJSON();w.expect(e.body_bottom).toBe("foo")})}),w.describe("bodyTopRichText field",function(){w.it("With true",function(){a.set("bodyTopRichText",!0);var e=a.toJSON();w.expect(e.body_top_text_type).toBe("markdown")}),w.it("With false",function(){a.set("bodyTopRichText",!1);var e=a.toJSON();w.expect(e.body_top_text_type).toBe("plain")})}),w.describe("bodyBottomRichText field",function(){w.it("With true",function(){a.set("bodyBottomRichText",!0);var e=a.toJSON();w.expect(e.body_bottom_text_type).toBe("markdown")}),w.it("With false",function(){a.set("bodyBottomRichText",!1);var e=a.toJSON();w.expect(e.body_bottom_text_type).toBe("plain")})}),w.describe("force_text_type field",function(){w.it("With value",function(){a.set("forceTextType","html");var e=a.toJSON();w.expect(e.force_text_type).toBe("html")}),w.it("Without value",function(){var e=a.toJSON();w.expect(e.force_text_type).toBe(void 0)})}),w.describe("include_text_types field",function(){w.it("With value",function(){a.set("includeTextTypes","html");var e=a.toJSON();w.expect(e.include_text_types).toBe("html")}),w.it("Without value",function(){var e=a.toJSON();w.expect(e.include_text_types).toBe(void 0)})}),w.describe("public field",function(){w.it("With value",function(){a.set("public",!0);var e=a.toJSON();w.expect(e.public).toBe(!0)})})})}),e.suite("rb/resources/models/ReviewRequest",function(){let i;w.describe("Create from commit ID",function(){w.beforeEach(function(){i=new RB.ReviewRequest,w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.data.commit_id).toBe("test"),w.expect(e.data.create_from_commit_id).toBe(!0),e.success({})})}),w.it("With promises",async function(){await i.createFromCommit("test")})}),w.describe("Existing instance",function(){w.beforeEach(function(){i=new RB.ReviewRequest({id:1}),w.spyOn(i,"ready").and.resolveTo()}),w.it("createDiff",function(){var e=i.createDiff();w.expect(e.get("parentObject")).toBe(i)}),w.it("createScreenshot",function(){var e=i.createScreenshot(42);w.expect(e.get("parentObject")).toBe(i),w.expect(e.id).toBe(42)}),w.it("createFileAttachment",function(){var e=i.createFileAttachment({id:42});w.expect(e.get("parentObject")).toBe(i),w.expect(e.id).toBe(42)}),w.it("parse",function(){var e=i.parse({review_request:{branch:"branch",bugs_closed:"bugsClosed",close_description:"closeDescription",close_description_text_type:"markdown",description:"description",description_text_type:"markdown",id:1,last_updated:"lastUpdated",public:"public",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain"},stat:"ok"});w.expect(e).not.toBe(void 0),w.expect(e.id).toBe(1),w.expect(e.branch).toBe("branch"),w.expect(e.bugsClosed).toBe("bugsClosed"),w.expect(e.closeDescription).toBe("closeDescription"),w.expect(e.closeDescriptionRichText).toBe(!0),w.expect(e.description).toBe("description"),w.expect(e.descriptionRichText).toBe(!0),w.expect(e.lastUpdated).toBe("lastUpdated"),w.expect(e.public).toBe("public"),w.expect(e.summary).toBe("summary"),w.expect(e.targetGroups).toBe("targetGroups"),w.expect(e.targetPeople).toBe("targetPeople"),w.expect(e.testingDone).toBe("testingDone"),w.expect(e.testingDoneRichText).toBe(!1)}),w.describe("reopen",function(){w.it("With promises",async function(){w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("PUT"),w.expect(e.data.status).toBe("pending"),e.success({review_request:{id:1,links:{}},stat:"ok"})}),await i.reopen(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()})}),w.describe("createReview",function(){w.it("With review ID",function(){var e=i.createReview(42);w.expect(e.get("parentObject")).toBe(i),w.expect(e.get("id")).toBe(42),w.expect(i.get("draftReview")).toBe(null),w.expect(i.reviews.length).toBe(1),w.expect(i.reviews.get(42)).toBe(e)}),w.it("Without review ID",function(){var e=i.createReview(),t=i.createReview();w.expect(e.get("parentObject")).toBe(i),w.expect(e.id).toBeFalsy(),w.expect(i.get("draftReview")).toBe(e),w.expect(e).toBe(t),w.expect(i.reviews.length).toBe(0)})}),w.describe("setStarred",function(){const t="/api/users/testuser/watched/review-requests/";let e;w.beforeEach(function(){RB.UserSession.instance=null,e=RB.UserSession.create({username:"testuser",watchedReviewRequestsURL:t}),w.spyOn(e.watchedReviewRequests,"addImmediately").and.callThrough(),w.spyOn(e.watchedReviewRequests,"removeImmediately").and.callThrough(),w.spyOn(RB,"apiCall").and.callThrough()}),w.it("true",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("POST"),w.expect(e.url).toBe(t),e.success({stat:"ok"})}),await i.setStarred(!0),w.expect(e.watchedReviewRequests.addImmediately).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("false",async function(){w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("DELETE"),w.expect(e.url).toBe(t+"1/"),e.success({stat:"ok"})}),await i.setStarred(!1),w.expect(e.watchedReviewRequests.removeImmediately).toHaveBeenCalled(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()})}),w.describe("close",function(){w.it("With type=CLOSE_DISCARDED",async function(){w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("PUT"),w.expect(e.data.status).toBe("discarded"),w.expect(e.data.description).toBe(void 0),e.success({review_request:{id:1,links:{}},stat:"ok"})}),await i.close({type:RB.ReviewRequest.CLOSE_DISCARDED}),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("With type=CLOSE_SUBMITTED",async function(){w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("PUT"),w.expect(e.data.status).toBe("submitted"),w.expect(e.data.description).toBe(void 0),e.success({review_request:{id:1,links:{}},stat:"ok"})}),await i.close({type:RB.ReviewRequest.CLOSE_SUBMITTED}),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("With invalid type",async function(){w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax"),await w.expectAsync(i.close({type:"foo"})).toBeRejectedWith(Error("Invalid close type")),w.expect(RB.apiCall).not.toHaveBeenCalled(),w.expect($.ajax).not.toHaveBeenCalled()}),w.it("With description",async function(){w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("PUT"),w.expect(e.data.status).toBe("submitted"),w.expect(e.data.close_description).toBe("test"),e.success({review_request:{id:1,links:{}},stat:"ok"})}),await i.close({description:"test",type:RB.ReviewRequest.CLOSE_SUBMITTED}),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled()}),w.it("With callbacks",function(e){w.spyOn(RB,"apiCall").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("PUT"),w.expect(e.data.status).toBe("discarded"),w.expect(e.data.description).toBe(void 0),e.success({review_request:{id:1,links:{}},stat:"ok"})}),w.spyOn(console,"warn"),i.close({error:()=>e.fail(),success:()=>{w.expect(RB.apiCall).toHaveBeenCalled(),w.expect($.ajax).toHaveBeenCalled(),w.expect(console.warn).toHaveBeenCalled(),e()},type:RB.ReviewRequest.CLOSE_DISCARDED})})})})}),e.suite("rb/pages/views/PageView",function(){let t,e,i,n,o,a;w.beforeEach(function(){t=$("<body>").appendTo($testsScratch),e=$("<div>").appendTo(t),n=$('<div id="page-container">').css("padding",0).appendTo(t),o=$("<div>").appendTo(n),i=$(`<div class="rb-c-page-sidebar test-page-sidebar">
 <div class="rb-c-page-sidebar__panes">
  <div class="rb-c-page-sidebar__pane -is-shown"
       id="page-sidebar-main-pane">
   <div class="rb-c-page-sidebar__pane-content"></div>
  </div>
 </div>
</div>`).appendTo(t),w.spyOn(RB.HeaderView.prototype,"_ensureSingleton"),a=new RB.PageView({$body:t,$headerBar:e,$pageContainer:n,$pageContent:o,$pageSidebar:i})}),w.afterEach(function(){a.remove()}),w.describe("Rendering",function(){w.it("Default state",function(){w.expect(a.rendered).toBe(!1),a.render(),w.expect(a.hasSidebar).toBe(!1),w.expect(a.isFullPage).toBe(!1),w.expect(a.rendered).toBe(!0),w.expect(a.inMobileMode).toBe(!1),w.expect(a.headerView).not.toBe(null),w.expect(a.$mainSidebar.length).toBe(1),w.expect(a.$pageContainer.length).toBe(1),w.expect(a.$pageContent.length).toBe(1),w.expect(a._$pageSidebar.length).toBe(1),w.expect(a._$pageSidebarPanes.length).toBe(1),w.expect(a._$mainSidebarPane.length).toBe(1)}),w.describe("With full-page-content",function(){let e;w.beforeEach(()=>{e=i.find("#page-sidebar-main-pane"),w.expect(e.length).toBe(1),document.body.classList.remove("-is-loaded")}),w.afterEach(()=>{document.body.classList.add("-is-loaded")}),w.it("Using body.-is-content-full-page",function(){t.addClass("-is-content-full-page"),a.render(),t.removeClass("-is-loaded"),w.expect(a.isFullPage).toBe(!0),w.expect(e.css("display")).toBe("block"),w.expect(n.css("display")).toBe("block"),w.expect(e.css("visibility")).toBe("hidden"),w.expect(n.css("visibility")).toBe("hidden")}),w.it("Using legacy body.full-page-content",function(){t.addClass("full-page-content"),a.render(),t.removeClass("-is-loaded"),w.expect(a.isFullPage).toBe(!0),w.expect(e.css("display")).toBe("block"),w.expect(n.css("display")).toBe("block"),w.expect(e.css("visibility")).toBe("hidden"),w.expect(n.css("visibility")).toBe("hidden")}),w.it("Using body.-is-content-full-page and -is-loaded",function(){t.addClass("-is-content-full-page"),a.render(),w.expect(t[0]).toHaveClass("-is-loaded"),w.expect(a.isFullPage).toBe(!0),w.expect(e.css("display")).toBe("block"),w.expect(n.css("display")).toBe("block"),w.expect(e.css("visibility")).toBe("visible"),w.expect(n.css("visibility")).toBe("visible")})}),w.describe("With sidebar",function(){w.it("Using body.-has-sidebar",function(){t.addClass("-has-sidebar"),a.render(),w.expect(a.hasSidebar).toBe(!0)}),w.it("Using legacy body.has-sidebar",function(){t.addClass("has-sidebar"),a.render(),w.expect(a.hasSidebar).toBe(!0)})})}),w.describe("Drawers",function(){w.beforeEach(function(){t.addClass("-has-sidebar")}),w.describe("Setting drawer",function(){w.it("In mobile mode",function(){a.render(),a.inMobileMode=!0,a.setDrawer(new RB.DrawerView),w.expect(t.children(".rb-c-drawer").length).toBe(1)}),w.it("In desktop mode",function(){a.render(),a.inMobileMode=!1,a.setDrawer(new RB.DrawerView);var e=i.children(".rb-c-page-sidebar__panes");w.expect(e.children(".rb-c-drawer").length).toBe(1)})}),w.describe("State changes",function(){let e;w.beforeEach(function(){e=new RB.DrawerView,a.render(),w.spyOn(a,"_updateSize"),a.setDrawer(e),w.expect(a._updateSize).not.toHaveBeenCalled()}),w.it("Showing",function(){e.show(),w.expect(a._updateSize).toHaveBeenCalled()}),w.it("Hiding",function(){e.show(),w.expect(a._updateSize).toHaveBeenCalled()})})}),w.describe("Events",function(){w.describe("mobileModeChanged",function(){let e;w.beforeEach(function(){e=w.jasmine.createSpy("handler"),a.render(),a.on("inMobileModeChanged",e),w.spyOn(a,"_updateSize"),w.spyOn(a,"onMobileModeChanged")}),w.it("To mobile mode",function(){a.inMobileMode=!1,a.headerView.trigger("mobileModeChanged",!0),w.expect(a.inMobileMode).toBe(!0),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(a.onMobileModeChanged).toHaveBeenCalledWith(!0),w.expect(e).toHaveBeenCalledWith(!0)}),w.it("To desktop mode",function(){a.inMobileMode=!0,a.headerView.trigger("mobileModeChanged",!1),w.expect(a.inMobileMode).toBe(!1),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(a.onMobileModeChanged).toHaveBeenCalledWith(!1),w.expect(e).toHaveBeenCalledWith(!1)})}),w.describe("resize",function(){w.beforeEach(function(){a.render(),w.spyOn(a,"_updateSize").and.callThrough(),w.spyOn(a,"onResize"),n.css("height","auto"),i.css("height","auto"),w.spyOn(a.$window,"height").and.callFake(()=>1e3),w.spyOn(n,"offset").and.callFake(()=>({left:0,top:20})),w.spyOn(i,"offset").and.callFake(()=>({left:0,top:10}))}),w.describe("In mobile mode",function(){w.beforeEach(function(){a.inMobileMode=!0}),w.it("Default state",function(){a.$window.triggerHandler("resize"),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(n[0].style.height).toBe(""),w.expect(i[0].style.height).toBe(""),w.expect(a.onResize).toHaveBeenCalled()}),w.describe("In full-page content mode",function(){let e;w.beforeEach(function(){a.isFullPage=!0,t.addClass("-is-loaded"),(e=new RB.DrawerView).$el.outerHeight(300)}),w.it("Without drawer",function(){a.$window.triggerHandler("resize"),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(n[0].style.height).toBe("980px"),w.expect(i[0].style.height).toBe(""),w.expect(a.onResize).toHaveBeenCalled()}),w.it("With open drawer",function(){a.hasSidebar=!0,a.setDrawer(e),e.show(),a.$window.triggerHandler("resize"),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(n[0].style.height).toBe("680px"),w.expect(i[0].style.height).toBe(""),w.expect(a.onResize).toHaveBeenCalled()}),w.it("With closed drawer",function(){a.hasSidebar=!0,a.setDrawer(e),a.$window.triggerHandler("resize"),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(n[0].style.height).toBe("980px"),w.expect(i[0].style.height).toBe(""),w.expect(a.onResize).toHaveBeenCalled()})})}),w.describe("In desktop mode",function(){w.beforeEach(function(){a.inMobileMode=!1}),w.it("Default state",function(){a.$window.triggerHandler("resize"),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(n[0].style.height).toBe(""),w.expect(i[0].style.height).toBe(""),w.expect(a.onResize).toHaveBeenCalled()}),w.it("In full-page content mode",function(){a.isFullPage=!0,a.$window.triggerHandler("resize"),w.expect(a._updateSize).toHaveBeenCalled(),w.expect(n[0].style.height).toBe("980px"),w.expect(i[0].style.height).toBe("990px"),w.expect(a.onResize).toHaveBeenCalled()})})})})}),e.suite("rb/diffviewer/collections/DiffReviewableCollection",function(){w.describe("Construction",function(){w.it("Sets reviewRequest",function(){var e=new RB.ReviewRequest,t=new RB.DiffReviewableCollection([],{reviewRequest:e});w.expect(t.reviewRequest).toBe(e)})}),w.describe("watchFiles",function(){let t,i;w.beforeEach(function(){t=new RB.DiffReviewableCollection([],{reviewRequest:new RB.ReviewRequest}),i=new RB.DiffFileCollection}),w.it("Initially populates",function(){w.spyOn(t,"_populateFromFiles"),t.watchFiles(i),w.expect(t._populateFromFiles).toHaveBeenCalled()}),w.it("Populates on files.reset",function(){w.spyOn(t,"trigger"),w.spyOn(t,"reset"),t.watchFiles(i),i.reset([new RB.DiffFile({filediff:{id:300,revision:1},id:100,index:1}),new RB.DiffFile({filediff:{id:301,revision:1},id:101,index:2,interfilediff:{id:400,revision:2},serializedCommentBlocks:{"2-2":[{comment_id:1,issue_opened:!1,line:2,localdraft:!1,num_lines:2,review_id:1,text:"Comment",user:{name:"testuser"}}]}}),new RB.DiffFile({baseFileDiffID:123,filediff:{id:302,revision:2},forceInterdiff:!0,forceInterdiffRevision:1,id:102,index:3})]),w.expect(t.reset).toHaveBeenCalled(),w.expect(t.trigger).toHaveBeenCalledWith("populating"),w.expect(t.trigger).toHaveBeenCalledWith("populated"),w.expect(t.length).toBe(3);let e=t.at(0);w.expect(e.get("baseFileDiffID")).toBe(null),w.expect(e.get("file").id).toBe(100),w.expect(e.get("reviewRequest")).toBe(t.reviewRequest),w.expect(e.get("fileDiffID")).toBe(300),w.expect(e.get("interFileDiffID")).toBe(null),w.expect(e.get("revision")).toBe(1),w.expect(e.get("interdiffRevision")).toBe(null),e=t.at(1),w.expect(e.get("baseFileDiffID")).toBe(null),w.expect(e.get("file").id).toBe(101),w.expect(e.get("reviewRequest")).toBe(t.reviewRequest),w.expect(e.get("fileDiffID")).toBe(301),w.expect(e.get("interFileDiffID")).toBe(400),w.expect(e.get("revision")).toBe(1),w.expect(e.get("interdiffRevision")).toBe(2),w.expect(e.get("serializedCommentBlocks")).toEqual({"2-2":[{comment_id:1,issue_opened:!1,line:2,localdraft:!1,num_lines:2,review_id:1,text:"Comment",user:{name:"testuser"}}]}),e=t.at(2),w.expect(e.get("baseFileDiffID")).toBe(123),w.expect(e.get("file").id).toBe(102),w.expect(e.get("reviewRequest")).toBe(t.reviewRequest),w.expect(e.get("fileDiffID")).toBe(302),w.expect(e.get("interFileDiffID")).toBe(null),w.expect(e.get("revision")).toBe(2),w.expect(e.get("interdiffRevision")).toBe(1)})})}),e.suite("rb/models/CommentEditor",function(){let n,e,t;function o(){return new RB.BaseComment({parentObject:new RB.BaseResource({public:!0})})}w.beforeEach(function(){e=new RB.ReviewRequest,n=new RB.CommentEditor({canEdit:!0,reviewRequest:e})}),w.describe("Attribute defaults",function(){w.describe("canEdit",function(){w.it("When logged in and hasDraft=false",function(){RB.UserSession.instance.set("authenticated",!0),n=new RB.CommentEditor({reviewRequest:e}),w.expect(n.get("canEdit")).toBe(!0)}),w.it("When logged in and hasDraft=true",function(){RB.UserSession.instance.set("authenticated",!0),e.set("hasDraft",!0),n=new RB.CommentEditor({reviewRequest:e}),w.expect(n.get("canEdit")).toBe(!0)}),w.it("When logged out",function(){RB.UserSession.instance.set("authenticated",!1),n=new RB.CommentEditor({reviewRequest:e}),w.expect(n.get("canEdit")).toBe(!1)}),w.it("With explicitly set value",function(){RB.UserSession.instance.set("authenticated",!1),n=new RB.CommentEditor({canEdit:!0,reviewRequest:e}),w.expect(n.get("canEdit")).toBe(!0)})}),w.describe("openIssue",function(){w.it("When user preference is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",!0),n=new RB.CommentEditor({reviewRequest:e}),w.expect(n.get("openIssue")).toBe(!0)}),w.it("When user preference is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",!1),n=new RB.CommentEditor({reviewRequest:e}),w.expect(n.get("openIssue")).toBe(!1)}),w.it("With explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",!1),n=new RB.CommentEditor({openIssue:!0,reviewRequest:e}),w.expect(n.get("openIssue")).toBe(!0)}),w.it("When reloading the page with explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",!0),(t=o()).set({issueOpened:!1,loaded:!1}),n=new RB.CommentEditor({comment:t,reviewRequest:e}),w.expect(n.get("openIssue")).toBe(!1)})}),w.describe("richText",function(){w.it("When user preference is true",function(){RB.UserSession.instance.set("defaultUseRichText",!0),n=new RB.CommentEditor({reviewRequest:e}),w.expect(n.get("richText")).toBe(!0)}),w.it("When user preference is false",function(){RB.UserSession.instance.set("defaultUseRichText",!1),n=new RB.CommentEditor({reviewRequest:e}),w.expect(n.get("richText")).toBe(!1)}),w.it("With explicitly set value",function(){RB.UserSession.instance.set("defaultUseRichText",!1),n=new RB.CommentEditor({reviewRequest:e,richText:!0}),w.expect(n.get("richText")).toBe(!0)})})}),w.describe("Loading comment",function(){w.describe("With comment richText=true",function(){let e;w.beforeEach(function(){(e=o()).set({id:123,loaded:!0,markdownTextFields:{text:"this \\_is\\_ a _test_"},rawTextFields:{text:"this \\_is\\_ a _test_"},richText:!0,text:"<p>this _is_ a <em>test</em></p>"})}),w.it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",!0),n.set("comment",e),n.beginEdit(),w.expect(n.get("dirty")).toBe(!1),w.expect(n.get("richText")).toBe(!0),w.expect(n.get("text")).toBe("this \\_is\\_ a _test_")}),w.it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",!1),n.set("comment",e),n.beginEdit(),w.expect(n.get("dirty")).toBe(!1),w.expect(n.get("richText")).toBe(!0),w.expect(n.get("text")).toBe("this \\_is\\_ a _test_")})}),w.describe("With comment richText=false",function(){let e;w.beforeEach(function(){(e=o()).set({id:123,loaded:!0,markdownTextFields:{text:"this \\_is\\_ a \\_test\\_"},rawTextFields:{text:"this _is_ a _test_"},richText:!1,text:"<p>this _is_ a test</p>"})}),w.it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",!0),n.set("comment",e),n.beginEdit(),w.expect(n.get("dirty")).toBe(!1),w.expect(n.get("richText")).toBe(!0),w.expect(n.get("text")).toBe("this \\_is\\_ a \\_test\\_")}),w.it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",!1),n.set("comment",e),n.beginEdit(),w.expect(n.get("dirty")).toBe(!1),w.expect(n.get("richText")).toBe(!1),w.expect(n.get("text")).toBe("this _is_ a _test_")})})}),w.describe("Capability states",function(){w.describe("canDelete",function(){w.it("When not editing",function(){w.expect(n.get("editing")).toBe(!1),w.expect(n.get("canDelete")).toBe(!1)}),w.it("When editing new comment",function(){n.set("comment",o()),n.beginEdit(),w.expect(n.get("canDelete")).toBe(!1)}),w.it("When editing existing comment",function(){var e=o();e.set({id:123,loaded:!0}),n.set("comment",e),n.beginEdit(),w.expect(n.get("canDelete")).toBe(!0)}),w.it("When editing existing comment with canEdit=false",function(){var e=o();e.set({id:123,loaded:!0}),n.set({canEdit:!1,comment:e}),w.expect(()=>n.beginEdit()).toThrow(),w.expect(console.assert).toHaveBeenCalled(),w.expect(n.get("canDelete")).toBe(!1)})}),w.describe("canSave",function(){w.it("When not editing",function(){w.expect(n.get("editing")).toBe(!1),w.expect(n.get("canSave")).toBe(!1)}),w.it("When editing comment with text",function(){var e=o();n.set("comment",e),n.beginEdit(),n.set("text","Foo"),w.expect(n.get("canSave")).toBe(!0)}),w.it("When editing comment with initial state",function(){var e=o();n.set("comment",e),n.beginEdit(),w.expect(n.get("canSave")).toBe(!1)}),w.it("When editing comment without text",function(){var e=o();n.set("comment",e),n.beginEdit(),n.set("text",""),w.expect(n.get("canSave")).toBe(!1)})})}),w.describe("States",function(){w.describe("dirty",function(){w.it("Initial state",function(){w.expect(n.get("dirty")).toBe(!1)}),w.it("After new comment",function(){var e=o();n.set("dirty",!0),n.set("comment",e),w.expect(n.get("dirty")).toBe(!1)}),w.it("After text change",function(){n.set("comment",o()),n.beginEdit(),n.set("text","abc"),w.expect(n.get("dirty")).toBe(!0)}),w.it("After toggling Open Issue",function(){n.set("comment",o()),n.beginEdit(),n.set("openIssue","true"),w.expect(n.get("dirty")).toBe(!0)}),w.it("After saving",async function(){var e=o();n.set("comment",e),n.beginEdit(),n.set("text","abc"),w.expect(n.get("dirty")).toBe(!0),w.spyOn(e,"save").and.resolveTo(),await n.save(),w.expect(n.get("dirty")).toBe(!1)}),w.it("After deleting",async function(){var e=o();e.set({id:123,loaded:!0}),n.set("comment",e),n.beginEdit(),n.set("text","abc"),w.expect(n.get("dirty")).toBe(!0),w.spyOn(e,"destroy").and.resolveTo(),await n.deleteComment(),w.expect(n.get("dirty")).toBe(!1)})})}),w.describe("Operations",function(){w.it("setExtraData",function(){n.setExtraData("key1","strvalue"),n.setExtraData("key2",42),w.expect(n.get("extraData")).toEqual({key1:"strvalue",key2:42})}),w.it("getExtraData",function(){n.set("extraData",{mykey:"value"}),w.expect(n.getExtraData("mykey")).toBe("value")}),w.describe("beginEdit",function(){w.it("With canEdit=true",function(){n.set({canEdit:!0,comment:o()}),n.beginEdit(),w.expect(console.assert.calls.argsFor(0)[0]).toBeTruthy()}),w.it("With canEdit=false",function(){n.set({canEdit:!1,comment:o()}),w.expect(function(){n.beginEdit()}).toThrow(),w.expect(console.assert.calls.argsFor(0)[0]).toBeFalsy()}),w.it("With no comment",function(){w.expect(function(){n.beginEdit()}).toThrow(),w.expect(console.assert.calls.argsFor(0)[0]).toBeTruthy(),w.expect(console.assert.calls.argsFor(1)[0]).toBeFalsy()})}),w.describe("cancel",function(){w.beforeEach(function(){w.spyOn(n,"close"),w.spyOn(n,"trigger")}),w.it("With comment",function(){var e=o();w.spyOn(e,"destroyIfEmpty"),n.set("comment",e),n.cancel(),w.expect(e.destroyIfEmpty).toHaveBeenCalled(),w.expect(n.trigger).toHaveBeenCalledWith("canceled"),w.expect(n.close).toHaveBeenCalled()}),w.it("Without comment",function(){n.cancel(),w.expect(n.trigger).not.toHaveBeenCalledWith("canceled"),w.expect(n.close).toHaveBeenCalled()})}),w.describe("destroy",function(){let e;w.beforeEach(function(){e=o(),w.spyOn(e,"destroy").and.resolveTo(),w.spyOn(n,"close"),w.spyOn(n,"trigger")}),w.it("With canDelete=false",async function(){n.set("comment",e),n.set("canDelete",!1),await expectAsync(n.deleteComment()).toBeRejectedWith(Error("deleteComment() called when canDelete is false.")),w.expect(console.assert.calls.argsFor(0)[0]).toBeFalsy(),w.expect(e.destroy).not.toHaveBeenCalled(),w.expect(n.trigger).not.toHaveBeenCalledWith("deleted"),w.expect(n.close).not.toHaveBeenCalled()}),w.it("With canDelete=true",async function(){n.set("comment",e),n.set("canDelete",!0),await n.deleteComment(),w.expect(console.assert.calls.argsFor(0)[0]).toBeTruthy(),w.expect(e.destroy).toHaveBeenCalled(),w.expect(n.trigger).toHaveBeenCalledWith("deleted"),w.expect(n.close).toHaveBeenCalled()})}),w.describe("save",function(){let i;w.beforeEach(function(){i=o(),w.spyOn(i,"save").and.resolveTo(),w.spyOn(n,"trigger")}),w.it("With canSave=false",async function(){n.set("comment",i),n.set("canSave",!1),await expectAsync(n.save()).toBeRejectedWith(Error("save() called when canSave is false.")),w.expect(console.assert.calls.argsFor(0)[0]).toBeFalsy(),w.expect(i.save).not.toHaveBeenCalled(),w.expect(n.trigger).not.toHaveBeenCalledWith("saved")}),w.it("With canSave=true",async function(){var e="My text";i.set("issueOpened",!1),n.set("comment",i),n.set({canSave:!0,issue_opened:!0,richText:!0,text:e}),n.setExtraData("mykey","myvalue"),await n.save(),w.expect(console.assert.calls.argsFor(0)[0]).toBeTruthy(),w.expect(i.save).toHaveBeenCalled(),w.expect(i.get("text")).toBe(e),w.expect(i.get("issueOpened")).toBe(!0),w.expect(i.get("richText")).toBe(!0),w.expect(i.get("extraData")).toEqual({mykey:"myvalue",require_verification:!1}),w.expect(n.get("dirty")).toBe(!1),w.expect(n.trigger).toHaveBeenCalledWith("saved")}),w.it("With callbacks",function(e){const t="My text";i.set("issueOpened",!1),n.set("comment",i),n.set({canSave:!0,issue_opened:!0,richText:!0,text:t}),n.setExtraData("mykey","myvalue"),w.spyOn(console,"warn"),n.save({error:()=>e.fail(),success:()=>{w.expect(console.assert.calls.argsFor(0)[0]).toBeTruthy(),w.expect(i.save).toHaveBeenCalled(),w.expect(i.get("text")).toBe(t),w.expect(i.get("issueOpened")).toBe(!0),w.expect(i.get("richText")).toBe(!0),w.expect(i.get("extraData")).toEqual({mykey:"myvalue",require_verification:!1}),w.expect(n.get("dirty")).toBe(!1),w.expect(n.trigger).toHaveBeenCalledWith("saved"),w.expect(console.warn).toHaveBeenCalled(),e()}})})})})}),e.suite("rb/reviews/models/CommentIssueManager",()=>{let a,e,s;w.beforeEach(()=>{e=new RB.ReviewRequest,a=new RB.CommentIssueManager({reviewRequest:e}),s=e.createReview(123),w.spyOn(e,"ready").and.resolveTo(),w.spyOn(s,"ready").and.resolveTo(),w.spyOn(e,"createReview").and.callFake(()=>s)}),w.describe("Methods",()=>{w.describe("getOrCreateComment",()=>{w.it("Caches results",()=>{var e=a.getOrCreateComment({commentID:123,commentType:RB.CommentIssueManagerCommentType.DIFF,reviewID:456}),t=a.getOrCreateComment({commentID:123,commentType:RB.CommentIssueManagerCommentType.DIFF,reviewID:456}),t=(w.expect(e).toBe(t),w.expect(e.cid).toBe(t.cid),a.getOrCreateComment({commentID:456,commentType:RB.CommentIssueManagerCommentType.DIFF,reviewID:456})),t=(w.expect(e).not.toBe(t),w.expect(e.cid).not.toBe(t.cid),a.getOrCreateComment({commentID:123,commentType:RB.CommentIssueManagerCommentType.GENERAL,reviewID:456}));w.expect(e).not.toBe(t),w.expect(e.cid).not.toBe(t.cid)}),w.it("With diff comments",()=>{var e=a.getOrCreateComment({commentID:123,commentType:RB.CommentIssueManagerCommentType.DIFF,reviewID:456});w.expect(e).toBeInstanceOf(RB.DiffComment)})}),w.describe("setCommentIssueStatus",()=>{w.it("With diff comment",async()=>{var e=jasmine.createSpy("onAnyUpdated"),t=jasmine.createSpy("onCommentUpdated"),i=jasmine.createSpy("onOtherUpdated"),n=jasmine.createSpy("onLegacyUpdated");a.on({anyIssueStatusUpdated:e,"issueStatusUpdated:diff_comments:456":t,"issueStatusUpdated:diff_comments:789":i,issueStatusUpdated:n});const o=s.createDiffComment({beginLineNum:1,endLineNum:2,fileDiffID:42,id:456});o.set("issueStatus",RB.CommentIssueStatusType.OPEN),w.spyOn(o,"ready").and.resolveTo(),w.spyOn(o,"save").and.resolveTo({diff_comment:{timestamp:"2024-04-08T01:20:01Z"}}),w.spyOn(s,"createDiffComment").and.callFake(()=>o),await a.setCommentIssueStatus({commentID:456,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,reviewID:123}),w.expect(o.get("issueStatus")).toBe(RB.CommentIssueStatusType.RESOLVED),w.expect(o.save).toHaveBeenCalledWith({attrs:["issueStatus"]}),w.expect(e).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(t).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(n).toHaveBeenCalledWith(o,RB.CommentIssueStatusType.OPEN,"2024-04-08T01:20:01Z",RB.CommentIssueManagerCommentType.DIFF),w.expect(i).not.toHaveBeenCalled()}),w.it("With file attachment comment",async()=>{var e=jasmine.createSpy("onAnyUpdated"),t=jasmine.createSpy("onCommentUpdated"),i=jasmine.createSpy("onOtherUpdated"),n=jasmine.createSpy("onLegacyUpdated");a.on({anyIssueStatusUpdated:e,"issueStatusUpdated:file_attachment_comments:456":t,"issueStatusUpdated:file_attachment_comments:789":i,issueStatusUpdated:n});const o=s.createFileAttachmentComment(456);o.set("issueStatus",RB.CommentIssueStatusType.OPEN),w.spyOn(o,"ready").and.resolveTo(),w.spyOn(o,"save").and.resolveTo({file_attachment_comment:{timestamp:"2024-04-08T01:20:01Z"}}),w.spyOn(s,"createFileAttachmentComment").and.callFake(()=>o),await a.setCommentIssueStatus({commentID:456,commentType:RB.CommentIssueManagerCommentType.FILE_ATTACHMENT,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,reviewID:123}),w.expect(o.get("issueStatus")).toBe(RB.CommentIssueStatusType.RESOLVED),w.expect(o.save).toHaveBeenCalledWith({attrs:["issueStatus"]}),w.expect(e).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.FILE_ATTACHMENT,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(t).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.FILE_ATTACHMENT,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(n).toHaveBeenCalledWith(o,RB.CommentIssueStatusType.OPEN,"2024-04-08T01:20:01Z",RB.CommentIssueManagerCommentType.FILE_ATTACHMENT),w.expect(i).not.toHaveBeenCalled()}),w.it("With general comment",async()=>{var e=jasmine.createSpy("onAnyUpdated"),t=jasmine.createSpy("onCommentUpdated"),i=jasmine.createSpy("onOtherUpdated"),n=jasmine.createSpy("onLegacyUpdated");a.on({anyIssueStatusUpdated:e,"issueStatusUpdated:general_comments:456":t,"issueStatusUpdated:general_comments:789":i,issueStatusUpdated:n});const o=s.createGeneralComment(456);o.set("issueStatus",RB.CommentIssueStatusType.OPEN),w.spyOn(o,"ready").and.resolveTo(),w.spyOn(o,"save").and.resolveTo({general_comment:{timestamp:"2024-04-08T01:20:01Z"}}),w.spyOn(s,"createGeneralComment").and.callFake(()=>o),await a.setCommentIssueStatus({commentID:456,commentType:RB.CommentIssueManagerCommentType.GENERAL,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,reviewID:123}),w.expect(o.get("issueStatus")).toBe(RB.CommentIssueStatusType.RESOLVED),w.expect(o.save).toHaveBeenCalledWith({attrs:["issueStatus"]}),w.expect(e).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.GENERAL,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(t).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.GENERAL,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(n).toHaveBeenCalledWith(o,RB.CommentIssueStatusType.OPEN,"2024-04-08T01:20:01Z",RB.CommentIssueManagerCommentType.GENERAL),w.expect(i).not.toHaveBeenCalled()}),w.it("With screenshot comment",async()=>{var e=jasmine.createSpy("onAnyUpdated"),t=jasmine.createSpy("onCommentUpdated"),i=jasmine.createSpy("onOtherUpdated"),n=jasmine.createSpy("onLegacyUpdated");a.on({anyIssueStatusUpdated:e,"issueStatusUpdated:screenshot_comments:456":t,"issueStatusUpdated:screenshot_comments:789":i,issueStatusUpdated:n});const o=s.createScreenshotComment(456,42,0,0,100,100);o.set("issueStatus",RB.CommentIssueStatusType.OPEN),w.spyOn(o,"ready").and.resolveTo(),w.spyOn(o,"save").and.resolveTo({screenshot_comment:{timestamp:"2024-04-08T01:20:01Z"}}),w.spyOn(s,"createScreenshotComment").and.callFake(()=>o),await a.setCommentIssueStatus({commentID:456,commentType:RB.CommentIssueManagerCommentType.SCREENSHOT,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,reviewID:123}),w.expect(o.get("issueStatus")).toBe(RB.CommentIssueStatusType.RESOLVED),w.expect(o.save).toHaveBeenCalledWith({attrs:["issueStatus"]}),w.expect(e).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.SCREENSHOT,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(t).toHaveBeenCalledWith({comment:o,commentType:RB.CommentIssueManagerCommentType.SCREENSHOT,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,oldIssueStatus:RB.CommentIssueStatusType.OPEN,timestampStr:"2024-04-08T01:20:01Z"}),w.expect(n).toHaveBeenCalledWith(o,RB.CommentIssueStatusType.OPEN,"2024-04-08T01:20:01Z",RB.CommentIssueManagerCommentType.SCREENSHOT),w.expect(i).not.toHaveBeenCalled()})}),w.describe("makeCommentEventID",()=>{w.it("With diff comment",()=>{var e=new RB.DiffComment({id:456});w.expect(a.makeCommentEventID(e)).toBe("diff_comments:456")}),w.it("With file attachment comment",()=>{var e=new RB.FileAttachmentComment({id:456});w.expect(a.makeCommentEventID(e)).toBe("file_attachment_comments:456")}),w.it("With general comment",()=>{var e=new RB.GeneralComment({id:456});w.expect(a.makeCommentEventID(e)).toBe("general_comments:456")}),w.it("With screenshot comment",()=>{var e=new RB.ScreenshotComment({id:456});w.expect(a.makeCommentEventID(e)).toBe("screenshot_comments:456")})})})}),e.suite("rb/diffviewer/models/DiffFile",function(){w.describe("parse",function(){w.it("API payloads",function(){var e=new RB.DiffFile({base_filediff_id:12,binary:!1,deleted:!0,filediff:{id:38,revision:2},id:28,index:3,interfilediff:{id:23,revision:4},modified_filename:"bar",modified_revision:"4",newfile:!0,orig_filename:"foo",orig_revision:"3",serialized_comment_blocks:{"4-2":[{comment_id:1,issue_opened:!1,line:4,localdraft:!1,num_lines:2,review_id:1,text:"Comment",user:{name:"testuser"}}]}},{parse:!0}).attributes;w.expect(e).not.toBe(void 0),w.expect(e.baseFileDiffID).toBe(12),w.expect(e.binary).toBe(!1),w.expect(e.serializedCommentBlocks).toEqual({"4-2":[{comment_id:1,issue_opened:!1,line:4,localdraft:!1,num_lines:2,review_id:1,text:"Comment",user:{name:"testuser"}}]}),w.expect(e.deleted).toBe(!0),w.expect(e.filediff).not.toBe(void 0),w.expect(e.filediff.id).toBe(38),w.expect(e.filediff.revision).toBe(2),w.expect(e.id).toBe(28),w.expect(e.index).toBe(3),w.expect(e.interfilediff).not.toBe(void 0),w.expect(e.interfilediff.id).toBe(23),w.expect(e.interfilediff.revision).toBe(4),w.expect(e.modifiedFilename).toBe("bar"),w.expect(e.modifiedRevision).toBe("4"),w.expect(e.newfile).toBe(!0),w.expect(e.origFilename).toBe("foo"),w.expect(e.origRevision).toBe("3")})})}),e.suite("rb/diffviewer/models/DiffReviewable",function(){let t;w.beforeEach(function(){t=new RB.ReviewRequest({reviewURL:"/r/1/"})}),w.describe("getRenderedDiff",function(){w.it("Without interdiffs",async function(){var e=new RB.DiffReviewable({file:new RB.DiffFile({index:4}),fileDiffID:3,reviewRequest:t,revision:2}),e=(w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("GET"),w.expect(e.url).toBe("/r/1/diff/2/fragment/3/?index=4&_="+TEMPLATE_SERIAL),e.complete({responseText:"abc"})}),await e.getRenderedDiff());w.expect($.ajax).toHaveBeenCalled(),w.expect(e).toEqual("abc")}),w.it("With interdiffs",async function(){var e=new RB.DiffReviewable({file:new RB.DiffFile({index:4}),fileDiffID:3,interdiffRevision:3,reviewRequest:t,revision:2}),e=(w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("GET"),w.expect(e.url).toBe("/r/1/diff/2-3/fragment/3/?index=4&_="+TEMPLATE_SERIAL),e.complete({responseText:"abc"})}),await e.getRenderedDiff());w.expect($.ajax).toHaveBeenCalled(),w.expect(e).toEqual("abc")}),w.it("With base FileDiff",async function(){var e=new RB.DiffReviewable({baseFileDiffID:1,file:new RB.DiffFile({index:4}),fileDiffID:3,reviewRequest:t,revision:2}),e=(w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("GET"),w.expect(e.url).toBe("/r/1/diff/2/fragment/3/?base-filediff-id=1&index=4&_="+TEMPLATE_SERIAL),e.complete({responseText:"abc"})}),await e.getRenderedDiff());w.expect(e).toEqual("abc")})}),w.describe("getRenderedDiffFragment",function(){w.it("Without interdiffs",async function(){var e=new RB.DiffReviewable({file:new RB.DiffFile({index:5}),fileDiffID:3,reviewRequest:t,revision:2}),e=(w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("GET"),w.expect(e.url).toBe("/r/1/diff/2/fragment/3/chunk/4/?index=5&lines-of-context=6&_="+TEMPLATE_SERIAL),e.complete({responseText:"abc"})}),await e.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6}));w.expect($.ajax).toHaveBeenCalled(),w.expect(e).toEqual("abc")}),w.it("With interdiffs",async function(){var e=new RB.DiffReviewable({file:new RB.DiffFile({index:5}),fileDiffID:3,interFileDiffID:4,interdiffRevision:3,reviewRequest:t,revision:2}),e=(w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("GET"),w.expect(e.url).toBe("/r/1/diff/2-3/fragment/3-4/chunk/4/?index=5&lines-of-context=6&_="+TEMPLATE_SERIAL),e.complete({responseText:"abc"})}),await e.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6}));w.expect($.ajax).toHaveBeenCalled(),w.expect(e).toEqual("abc")}),w.it("With base filediff ID",async function(){var e=new RB.DiffReviewable({baseFileDiffID:123,file:new RB.DiffFile({index:5}),fileDiffID:3,interFileDiffID:4,interdiffRevision:3,reviewRequest:t,revision:2}),e=(w.spyOn($,"ajax").and.callFake(e=>{w.expect(e.type).toBe("GET"),w.expect(e.url).toBe("/r/1/diff/2-3/fragment/3-4/chunk/4/?base-filediff-id=123&index=5&lines-of-context=6&_="+TEMPLATE_SERIAL),e.complete({responseText:"abc"})}),await e.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6}));w.expect($.ajax).toHaveBeenCalled(),w.expect(e).toEqual("abc")})})}),e.suite("rb/pages/models/DiffViewerPage",function(){w.describe("parse",function(){w.it("{}",function(){var e=new RB.DiffViewerPage({},{parse:!0});w.expect(e.get("allChunksCollapsed")).toBeFalse(),w.expect(e.get("canDownloadDiff")).toBeFalse(),w.expect(e.get("canToggleExtraWhitespace")).toBeFalse(),w.expect(e.get("reviewRequest")).toBeTruthy(),w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("lastActivityTimestamp")).toBe(null),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("checkUpdatesType")).toBe(null),w.expect(e.get("numDiffs")).toBe(0),w.expect(e.commentsHint).not.toBe(null),w.expect(e.files).not.toBe(null),w.expect(e.pagination).not.toBe(null),w.expect(e.revision).not.toBe(null),w.expect(e.get("editorData")).toBe(void 0),w.expect(e.get("reviewRequestData")).toBe(void 0)}),w.it("Diff view options",function(){var e=new RB.DiffViewerPage({allChunksCollapsed:!0,canToggleExtraWhitespace:!0},{parse:!0});w.expect(e.get("allChunksCollapsed")).toBeTrue(),w.expect(e.get("canToggleExtraWhitespace")).toBeTrue()}),w.it("reviewRequestData",function(){var e=new RB.DiffViewerPage({reviewRequestData:{branch:"my-branch",bugTrackerURL:"http://bugs.example.com/--bug_id--/",bugsClosed:[101,102,103],closeDescription:"This is closed",closeDescriptionRichText:!0,description:"This is a description",descriptionRichText:!0,hasDraft:!0,id:123,lastUpdatedTimestamp:"2017-08-23T15:10:20Z",localSitePrefix:"s/foo/",public:!0,repository:{id:200,name:"My repo",requiresBasedir:!0,requiresChangeNumber:!0,scmtoolName:"My Tool",supportsPostCommit:!0},reviewURL:"/s/foo/r/123/",state:"CLOSE_SUBMITTED",summary:"This is a summary",targetGroups:[{name:"Some group",url:"/s/foo/groups/some-group/"}],targetPeople:[{url:"/s/foo/users/some-user/",username:"some-user"}],testingDone:"This is testing done",testingDoneRichText:!0,visibility:"ARCHIVED"}},{parse:!0}),e=(w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("reviewRequestData")).toBe(void 0),e.get("reviewRequest")),e=(w.expect(e).toBeTruthy(),w.expect(e.id).toBe(123),w.expect(e.url()).toBe("/s/foo/api/review-requests/123/"),w.expect(e.get("bugTrackerURL")).toBe("http://bugs.example.com/--bug_id--/"),w.expect(e.get("localSitePrefix")).toBe("s/foo/"),w.expect(e.get("branch")).toBe("my-branch"),w.expect(e.get("bugsClosed")).toEqual([101,102,103]),w.expect(e.get("closeDescription")).toBe("This is closed"),w.expect(e.get("closeDescriptionRichText")).toBe(!0),w.expect(e.get("description")).toBe("This is a description"),w.expect(e.get("descriptionRichText")).toBe(!0),w.expect(e.get("hasDraft")).toBe(!0),w.expect(e.get("lastUpdatedTimestamp")).toBe("2017-08-23T15:10:20Z"),w.expect(e.get("public")).toBe(!0),w.expect(e.get("reviewURL")).toBe("/s/foo/r/123/"),w.expect(e.get("state")).toBe(RB.ReviewRequest.CLOSE_SUBMITTED),w.expect(e.get("summary")).toBe("This is a summary"),w.expect(e.get("targetGroups")).toEqual([{name:"Some group",url:"/s/foo/groups/some-group/"}]),w.expect(e.get("targetPeople")).toEqual([{url:"/s/foo/users/some-user/",username:"some-user"}]),w.expect(e.get("testingDone")).toBe("This is testing done"),w.expect(e.get("testingDoneRichText")).toBe(!0),w.expect(e.get("visibility")).toBe(RB.ReviewRequest.VISIBILITY_ARCHIVED),e.get("repository"));w.expect(e.id).toBe(200),w.expect(e.get("name")).toBe("My repo"),w.expect(e.get("requiresBasedir")).toBe(!0),w.expect(e.get("requiresChangeNumber")).toBe(!0),w.expect(e.get("scmtoolName")).toBe("My Tool"),w.expect(e.get("supportsPostCommit")).toBe(!0)}),w.it("extraReviewRequestDraftData",function(){var e=new RB.DiffViewerPage({extraReviewRequestDraftData:{changeDescription:"Draft change description",changeDescriptionRichText:!0,interdiffLink:"/s/foo/r/123/diff/1-2/"}},{parse:!0}),e=(w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("reviewRequestData")).toBe(void 0),e.get("reviewRequest").draft);w.expect(e.get("changeDescription")).toBe("Draft change description"),w.expect(e.get("changeDescriptionRichText")).toBe(!0),w.expect(e.get("interdiffLink")).toBe("/s/foo/r/123/diff/1-2/")}),w.it("editorData",function(){var e=new RB.DiffViewerPage({editorData:{changeDescriptionRenderedText:"Change description",closeDescriptionRenderedText:"This is closed",hasDraft:!0,mutableByUser:!0,showSendEmail:!0,statusMutableByUser:!0}},{parse:!0}),e=(w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("editorData")).toBe(void 0),e.reviewRequestEditor);w.expect(e.get("changeDescriptionRenderedText")).toBe("Change description"),w.expect(e.get("closeDescriptionRenderedText")).toBe("This is closed"),w.expect(e.get("hasDraft")).toBe(!0),w.expect(e.get("mutableByUser")).toBe(!0),w.expect(e.get("showSendEmail")).toBe(!0),w.expect(e.get("statusMutableByUser")).toBe(!0)}),w.it("lastActivityTimestamp",function(){var e=new RB.DiffViewerPage({checkUpdatesType:"diff",lastActivityTimestamp:"2017-08-22T18:20:30Z"},{parse:!0});w.expect(e.get("lastActivityTimestamp")).toBe("2017-08-22T18:20:30Z")}),w.it("checkUpdatesType",function(){var e=new RB.DiffViewerPage({checkUpdatesType:"diff"},{parse:!0});w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkUpdatesType")).toBe("diff")}),w.it("comments_hint",function(){var e=new RB.DiffViewerPage({comments_hint:{commits_with_comments:[{base_commit_id:"18375be",base_commit_pk:34,is_current:!1,revision:1,tip_commit_id:"efd582c",tip_commit_pk:39}],diffsets_with_comments:[{is_current:!1,revision:1}],has_other_comments:!0,interdiffs_with_comments:[{is_current:!0,new_revision:2,old_revision:1}]}},{parse:!0}).commentsHint;w.expect(e.get("hasOtherComments")).toBe(!0),w.expect(e.get("commitsWithComments")).toEqual([{baseCommitID:"18375be",baseCommitPK:34,isCurrent:!1,revision:1,tipCommitID:"efd582c",tipCommitPK:39}]),w.expect(e.get("diffsetsWithComments")).toEqual([{isCurrent:!1,revision:1}]),w.expect(e.get("interdiffsWithComments")).toEqual([{isCurrent:!0,newRevision:2,oldRevision:1}])})}),w.describe("loadDiffRevision",function(){let e;w.beforeEach(function(){e=new RB.DiffViewerPage({reviewRequestData:{id:123}},{parse:!0}),w.spyOn($,"ajax").and.callFake(e=>{const t={};var i=e.split("?")[1].split("&");for(let e=0;e<i.length;e++){var n=i[e].split("=");t[decodeURIComponent(n[0])]=decodeURIComponent(n[1])}return{done:e=>e({diff_context:{revision:{interdiff_revision:t["interdiff-revision"]||null,revision:t.revision}}})}})}),w.describe("Generates URL for",function(){w.it("First page, normal diffs",function(){e.loadDiffRevision({page:1,revision:1}),w.expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/?revision=1")}),w.it("Other page, normal diffs",function(){e.loadDiffRevision({page:2,revision:1}),w.expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/?revision=1&page=2")}),w.it("First page, interdiffs",function(){e.loadDiffRevision({interdiffRevision:2,page:1,revision:1}),w.expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/?revision=1&interdiff-revision=2")}),w.it("Other page, interdiffs",function(){e.loadDiffRevision({interdiffRevision:2,page:2,revision:1}),w.expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/?revision=1&interdiff-revision=2&page=2")}),w.it("Filename patterns",function(){e.loadDiffRevision({filenamePatterns:"*.txt,src/*",page:2,revision:1}),w.expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/?revision=1&page=2&filenames=*.txt%2Csrc%2F*")})}),w.describe("Sets canDownloadDiff to",function(){w.it("true for normal diffs",function(){e.loadDiffRevision({revision:1}),w.expect(e.get("canDownloadDiff")).toBe(!0)}),w.it("false for interdiffs",function(){e.loadDiffRevision({interdiffRevision:2,revision:1}),w.expect(e.get("canDownloadDiff")).toBe(!1)})})})}),e.suite("rb/models/ReviewRequestEditor",function(){let i,n;w.beforeEach(function(){i=new RB.ReviewRequest({id:1}),n=new RB.ReviewRequestEditor({reviewRequest:i})}),w.describe("Methods",function(){w.describe("createFileAttachment",function(){w.it("With new FileAttachment",function(){var e=n.get("fileAttachments"),t=(w.expect(e.length).toBe(0),n.createFileAttachment());w.expect(e.length).toBe(1),w.expect(e.at(0)).toBe(t)})}),w.describe("decr",function(){w.it("With integer attribute",function(){n.set("myint",1),n.decr("myint"),w.expect(n.get("myint")).toBe(0)}),w.it("With non-integer attribute",function(){n.set("foo","abc"),w.expect(()=>n.decr("foo")).toThrow(),w.expect(console.assert).toHaveBeenCalled(),w.expect(console.assert.calls.mostRecent().args[0]).toBe(!1),w.expect(n.get("foo")).toBe("abc")}),w.describe("editCount",function(){w.it("When > 0",function(){n.set("editCount",1),n.decr("editCount"),w.expect(n.get("editCount")).toBe(0),w.expect(n.validationError).toBe(null)}),w.it("When 0",function(){n.set("editCount",0),n.decr("editCount"),w.expect(n.get("editCount")).toBe(0),w.expect(n.validationError).toBe(RB.ReviewRequestEditor.strings.UNBALANCED_EDIT_COUNT)})})}),w.describe("incr",function(){w.it("With integer attribute",function(){n.set("myint",0),n.incr("myint"),w.expect(n.get("myint")).toBe(1)}),w.it("With non-integer attribute",function(){n.set("foo","abc"),w.expect(()=>n.incr("foo")).toThrow(),w.expect(console.assert).toHaveBeenCalled(),w.expect(console.assert.calls.mostRecent().args[0]).toBe(!1),w.expect(n.get("foo")).toBe("abc")})}),w.describe("getDraftField",function(){w.it("For closeDescription",function(){i.set("closeDescription","Test");var e=n.getDraftField("closeDescription");w.expect(e).toBe("Test")}),w.it("For closeDescriptionRichText",function(){i.set("closeDescriptionRichText",!0);var e=n.getDraftField("closeDescriptionRichText");w.expect(e).toBe(!0)}),w.it("For draft fields",function(){i.draft.set("description","Test");var e=n.getDraftField("description");w.expect(e).toBe("Test")}),w.it("With useExtraData",function(){i.draft.get("extraData").foo="**Test**";var e=n.getDraftField("foo",{useExtraData:!0});w.expect(e).toBe("**Test**")}),w.describe("With useExtraData and useRawTextValue",function(){w.it("With field in rawTextFields",function(){var e=i.draft,e=(i.draft.get("extraData").foo="<b>Test</b>",e.set("rawTextFields",{extra_data:{foo:"**Test**"}}),n.getDraftField("foo",{useExtraData:!0,useRawTextValue:!0}));w.expect(e).toBe("**Test**")}),w.it("With field not in rawTextFields",function(){i.draft.get("extraData").foo="<b>Test</b>";var e=n.getDraftField("foo",{useExtraData:!0,useRawTextValue:!0});w.expect(e).toBe("<b>Test</b>")})})}),w.describe("setDraftField",function(){let e;w.beforeEach(function(){e=n.get("reviewRequest").draft}),w.describe("Rich text fields",function(){w.describe("changeDescription",function(){w.describe("Draft description",function(){async function e(e,t){w.spyOn(i,"close"),w.spyOn(i.draft,"save").and.resolveTo(),await n.setDraftField("changeDescription","My description",{allowMarkdown:!0,fieldID:"changedescription",jsonFieldName:"changedescription",jsonTextTypeFieldName:"changedescription_text_type",richText:e}),w.expect(i.close).not.toHaveBeenCalled(),w.expect(i.draft.save).toHaveBeenCalled(),w.expect(i.draft.save.calls.argsFor(0)[0].data).toEqual({changedescription:"My description",changedescription_text_type:t,force_text_type:"html",include_text_types:"raw"})}w.it("For Markdown",async function(){await e(!0,"markdown")}),w.it("For plain text",async function(){await e(!1,"plain")})})})}),w.describe("Special list fields",function(){w.describe("targetGroups",function(){w.it("Empty",async function(){w.spyOn(e,"save").and.resolveTo(),await n.setDraftField("targetGroups","",{jsonFieldName:"target_groups"}),w.expect(e.save).toHaveBeenCalled()}),w.it("With values",async function(){w.spyOn(e,"save").and.resolveTo(),await n.setDraftField("targetGroups","group1, group2",{jsonFieldName:"target_groups"}),w.expect(e.save).toHaveBeenCalled()}),w.it("With invalid groups",async function(){w.spyOn(e,"save").and.rejectWith(new BackboneError(e,{errorPayload:{fields:{target_groups:["group1","group2"]}}},{})),await w.expectAsync(n.setDraftField("targetGroups","group1, group2",{jsonFieldName:"target_groups"})).toBeRejectedWith(Error('Groups "group1" and "group2" do not exist.'))})}),w.describe("targetPeople",function(){w.it("Empty",async function(){w.spyOn(e,"save").and.resolveTo(),await n.setDraftField("targetPeople","",{jsonFieldName:"target_people"}),w.expect(e.save).toHaveBeenCalled()}),w.it("With values",async function(){w.spyOn(e,"save").and.resolveTo(),await n.setDraftField("targetPeople","user1, user2",{jsonFieldName:"target_people"}),w.expect(e.save).toHaveBeenCalled()}),w.it("With invalid users",async function(){w.spyOn(e,"save").and.rejectWith(new BackboneError(e,{errorPayload:{fields:{target_people:["user1","user2"]}}},{})),await w.expectAsync(n.setDraftField("targetPeople","user1, user2",{jsonFieldName:"target_people"})).toBeRejectedWith(Error('Users "user1" and "user2" do not exist.'))})}),w.describe("submitter",function(){w.it("Empty",async function(){w.spyOn(e,"save").and.resolveTo(),await n.setDraftField("submitter","",{jsonFieldName:"submitter"}),w.expect(e.save).toHaveBeenCalled()}),w.it("With value",async function(){w.spyOn(e,"save").and.resolveTo(),await n.setDraftField("submitter","user1",{jsonFieldName:"submitter"}),w.expect(e.save).toHaveBeenCalled()}),w.it("With invalid user",async function(){w.spyOn(e,"save").and.rejectWith(new BackboneError(e,{errorPayload:{fields:{submitter:["user1"]}}},{})),await w.expectAsync(n.setDraftField("submitter","user1",{jsonFieldName:"submitter"})).toBeRejectedWith(Error('User "user1" does not exist.'))})})}),w.describe("Custom fields",function(){w.describe("Rich text fields",function(){async function e(e,t){w.spyOn(i.draft,"save").and.resolveTo(),await n.setDraftField("myField","Test text.",{allowMarkdown:!0,fieldID:"myfield",jsonFieldName:"myfield",jsonTextTypeFieldName:"myfield_text_type",richText:e,useExtraData:!0}),w.expect(i.draft.save).toHaveBeenCalled(),w.expect(i.draft.save.calls.argsFor(0)[0].data).toEqual({"extra_data.myfield":"Test text.","extra_data.myfield_text_type":t,force_text_type:"html",include_text_types:"raw"})}w.it("For Markdown",async function(){await e(!0,"markdown")}),w.it("For plain text",async function(){await e(!1,"plain")})})})})}),w.describe("Reviewed objects",function(){w.describe("File attachments",function(){w.it("Removed when destroyed",async function(){var e=n.get("fileAttachments"),t=n.createFileAttachment(),i=n.get("reviewRequest").draft;w.spyOn(i,"ensureCreated").and.resolveTo(),w.expect(e.at(0)).toBe(t),await t.destroy(),w.expect(e.length).toBe(0)})}),w.describe("Screenshots",function(){w.it("Removed when destroyed",async function(){var e=n.get("screenshots"),t=i.createScreenshot();e.add(t),w.expect(e.at(0)).toBe(t),await t.destroy(),w.expect(e.length).toBe(0)})})}),w.describe("Events",function(){w.describe("saved",function(){w.it("When new file attachment saved",function(){var e=n.createFileAttachment();w.spyOn(n,"trigger"),e.trigger("saved"),w.expect(n.trigger).toHaveBeenCalledWith("saved")}),w.it("When new file attachment destroyed",async function(){var e=n.createFileAttachment(),t=n.get("reviewRequest").draft;w.spyOn(t,"ensureCreated").and.resolveTo(),w.spyOn(n,"trigger"),await e.destroy(),w.expect(n.trigger).toHaveBeenCalledWith("saved")}),w.it("When existing file attachment saved",function(){var e=i.draft.createFileAttachment();n=new RB.ReviewRequestEditor({fileAttachments:new Backbone.Collection([e]),reviewRequest:i}),w.spyOn(n,"trigger"),e.trigger("saved"),w.expect(n.trigger).toHaveBeenCalledWith("saved")}),w.it("When existing file attachment destroyed",async function(){var e=i.draft.createFileAttachment();n=new RB.ReviewRequestEditor({fileAttachments:new Backbone.Collection([e]),reviewRequest:i}),w.spyOn(i.draft,"ensureCreated").and.resolveTo(),w.spyOn(n,"trigger"),await e.destroy(),w.expect(n.trigger).toHaveBeenCalledWith("saved")}),w.it("When existing screenshot saved",function(){var e=i.createScreenshot();n=new RB.ReviewRequestEditor({reviewRequest:i,screenshots:new Backbone.Collection([e])}),w.spyOn(n,"trigger"),e.trigger("saved"),w.expect(n.trigger).toHaveBeenCalledWith("saved")}),w.it("When existing screenshot destroyed",async function(){var e=i.createScreenshot();n=new RB.ReviewRequestEditor({reviewRequest:i,screenshots:new Backbone.Collection([e])}),w.spyOn(i.draft,"ensureCreated").and.resolveTo(),w.spyOn(n,"trigger"),await e.destroy(),w.expect(n.trigger).toHaveBeenCalledWith("saved")})}),w.describe("saving",function(){w.it("When new file attachment saving",function(){var e=n.createFileAttachment();w.spyOn(n,"trigger"),e.trigger("saving"),w.expect(n.trigger).toHaveBeenCalledWith("saving")}),w.it("When existing file attachment saving",function(){var e=i.draft.createFileAttachment();n=new RB.ReviewRequestEditor({fileAttachments:new Backbone.Collection([e]),reviewRequest:i}),w.spyOn(n,"trigger"),e.trigger("saving"),w.expect(n.trigger).toHaveBeenCalledWith("saving")}),w.it("When screenshot saving",function(){var e=i.createScreenshot();n=new RB.ReviewRequestEditor({reviewRequest:i,screenshots:new Backbone.Collection([e])}),w.spyOn(n,"trigger"),e.trigger("saving"),w.expect(n.trigger).toHaveBeenCalledWith("saving")})})})}),e.suite("rb/pages/models/ReviewablePage",function(){w.describe("Construction",function(){w.it("Child objects created",function(){var e=new RB.ReviewRequest,t=new RB.ReviewablePage({editorData:{hasDraft:!0,showSendEmail:!1},pendingReview:new RB.Review,reviewRequest:e});w.expect(t.commentIssueManager).toBeTruthy(),w.expect(t.commentIssueManager.get("reviewRequest")).toBe(e),w.expect(t.reviewRequestEditor.get("commentIssueManager")).toBe(t.commentIssueManager),w.expect(t.reviewRequestEditor.get("reviewRequest")).toBe(e),w.expect(t.reviewRequestEditor.get("showSendEmail")).toBe(!1),w.expect(t.reviewRequestEditor.get("hasDraft")).toBe(!0)})}),w.describe("parse",function(){w.it("{}",function(){var e=new RB.ReviewablePage({},{parse:!0});w.expect(e.get("reviewRequest")).toBeTruthy(),w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("lastActivityTimestamp")).toBe(null),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("checkUpdatesType")).toBe(null),w.expect(e.get("editorData")).toBe(void 0),w.expect(e.get("reviewRequestData")).toBe(void 0)}),w.it("reviewRequestData",function(){var e=new RB.ReviewablePage({reviewRequestData:{branch:"my-branch",bugTrackerURL:"http://bugs.example.com/--bug_id--/",bugsClosed:[101,102,103],closeDescription:"This is closed",closeDescriptionRichText:!0,description:"This is a description",descriptionRichText:!0,hasDraft:!0,id:123,lastUpdatedTimestamp:"2017-08-23T15:10:20Z",localSitePrefix:"s/foo/",public:!0,repository:{id:200,name:"My repo",requiresBasedir:!0,requiresChangeNumber:!0,scmtoolName:"My Tool",supportsPostCommit:!0},reviewURL:"/s/foo/r/123/",state:"CLOSE_SUBMITTED",summary:"This is a summary",targetGroups:[{name:"Some group",url:"/s/foo/groups/some-group/"}],targetPeople:[{url:"/s/foo/users/some-user/",username:"some-user"}],testingDone:"This is testing done",testingDoneRichText:!0,visibility:"ARCHIVED"}},{parse:!0}),e=(w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("reviewRequestData")).toBe(void 0),e.get("reviewRequest")),e=(w.expect(e).toBeTruthy(),w.expect(e.id).toBe(123),w.expect(e.url()).toBe("/s/foo/api/review-requests/123/"),w.expect(e.get("bugTrackerURL")).toBe("http://bugs.example.com/--bug_id--/"),w.expect(e.get("localSitePrefix")).toBe("s/foo/"),w.expect(e.get("branch")).toBe("my-branch"),w.expect(e.get("bugsClosed")).toEqual([101,102,103]),w.expect(e.get("closeDescription")).toBe("This is closed"),w.expect(e.get("closeDescriptionRichText")).toBe(!0),w.expect(e.get("description")).toBe("This is a description"),w.expect(e.get("descriptionRichText")).toBe(!0),w.expect(e.get("hasDraft")).toBe(!0),w.expect(e.get("lastUpdatedTimestamp")).toBe("2017-08-23T15:10:20Z"),w.expect(e.get("public")).toBe(!0),w.expect(e.get("reviewURL")).toBe("/s/foo/r/123/"),w.expect(e.get("state")).toBe(RB.ReviewRequest.CLOSE_SUBMITTED),w.expect(e.get("summary")).toBe("This is a summary"),w.expect(e.get("targetGroups")).toEqual([{name:"Some group",url:"/s/foo/groups/some-group/"}]),w.expect(e.get("targetPeople")).toEqual([{url:"/s/foo/users/some-user/",username:"some-user"}]),w.expect(e.get("testingDone")).toBe("This is testing done"),w.expect(e.get("testingDoneRichText")).toBe(!0),w.expect(e.get("visibility")).toBe(RB.ReviewRequest.VISIBILITY_ARCHIVED),e.get("repository"));w.expect(e.id).toBe(200),w.expect(e.get("name")).toBe("My repo"),w.expect(e.get("requiresBasedir")).toBe(!0),w.expect(e.get("requiresChangeNumber")).toBe(!0),w.expect(e.get("scmtoolName")).toBe("My Tool"),w.expect(e.get("supportsPostCommit")).toBe(!0)}),w.it("extraReviewRequestDraftData",function(){var e=new RB.ReviewablePage({extraReviewRequestDraftData:{changeDescription:"Draft change description",changeDescriptionRichText:!0,interdiffLink:"/s/foo/r/123/diff/1-2/"}},{parse:!0}),e=(w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("reviewRequestData")).toBe(void 0),e.get("reviewRequest").draft);w.expect(e.get("changeDescription")).toBe("Draft change description"),w.expect(e.get("changeDescriptionRichText")).toBe(!0),w.expect(e.get("interdiffLink")).toBe("/s/foo/r/123/diff/1-2/")}),w.it("editorData",function(){var e=new RB.ReviewablePage({editorData:{changeDescriptionRenderedText:"Change description",closeDescriptionRenderedText:"This is closed",hasDraft:!0,mutableByUser:!0,showSendEmail:!0,statusMutableByUser:!0}},{parse:!0}),e=(w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkForUpdates")).toBe(!1),w.expect(e.get("editorData")).toBe(void 0),e.reviewRequestEditor);w.expect(e.get("changeDescriptionRenderedText")).toBe("Change description"),w.expect(e.get("closeDescriptionRenderedText")).toBe("This is closed"),w.expect(e.get("hasDraft")).toBe(!0),w.expect(e.get("mutableByUser")).toBe(!0),w.expect(e.get("showSendEmail")).toBe(!0),w.expect(e.get("statusMutableByUser")).toBe(!0)}),w.it("lastActivityTimestamp",function(){var e=new RB.ReviewablePage({lastActivityTimestamp:"2017-08-22T18:20:30Z",checkUpdatesType:"diff"},{parse:!0});w.expect(e.get("lastActivityTimestamp")).toBe("2017-08-22T18:20:30Z")}),w.it("checkUpdatesType",function(){var e=new RB.ReviewablePage({checkUpdatesType:"diff"},{parse:!0});w.expect(e.get("pendingReview")).toBeTruthy(),w.expect(e.get("checkUpdatesType")).toBe("diff")})}),w.describe("Actions",function(){w.it("markShipIt",async function(){var e=new RB.ReviewablePage({},{parse:!0}),t=e.get("pendingReview");w.spyOn(t,"ready").and.resolveTo(),w.spyOn(t,"publish"),await e.markShipIt(),w.expect(t.publish).toHaveBeenCalled(),w.expect(t.get("shipIt")).toBe(!0),w.expect(t.get("bodyTop")).toBe("Ship It!")})})}),e.suite("rb/views/CommentDialogView",function(){let t,i;w.beforeEach(function(){RB.DnDUploader.create(),t=new RB.ReviewRequest,i=new RB.ReviewRequestEditor({reviewRequest:t})}),w.afterEach(function(){RB.DnDUploader.instance=null}),w.describe("Class methods",function(){w.describe("create",function(){w.it("Without a comment",function(){w.expect(()=>RB.CommentDialogView.create({animate:!1,comment:void 0,container:$testsScratch,reviewRequestEditor:i})).toThrow(),w.expect(RB.CommentDialogView._instance).toBeFalsy(),w.expect($testsScratch.children().length).toBe(0)}),w.it("With a comment",function(){var e=RB.CommentDialogView.create({animate:!1,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:i});w.expect(e).toBeTruthy(),w.expect(RB.CommentDialogView._instance).toBe(e),w.expect($testsScratch.children().length).toBe(1)}),w.it("Replacing an open dialog",function(){var e=RB.CommentDialogView.create({animate:!1,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:i}),t=(w.expect(e).toBeTruthy(),RB.CommentDialogView.create({animate:!1,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:i}));w.expect(t).toBeTruthy(),w.expect(t).not.toBe(e),w.expect(e.$el.parents().length).toBe(0),w.expect(RB.CommentDialogView._instance).toBe(t),w.expect($testsScratch.children().length).toBe(1)})})}),w.describe("Instances",function(){let c,r;w.beforeEach(function(){c=new RB.CommentEditor({canEdit:!0,comment:new RB.DiffComment,publishedCommentsType:"diff_comments",reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,commentIssueManager:new RB.CommentIssueManager,model:c})).on("closed",()=>{r=null}),r.render().$el.appendTo($testsScratch)}),w.afterEach(function(){r&&r.close()}),w.describe("Buttons",function(){w.beforeEach(function(){r.open()}),w.describe("Cancel",function(){let e;w.beforeEach(function(){e=r.$el.find(".btn-cancel")}),w.it("Enabled",function(){w.expect(e.is(":disabled")).toBe(!1)}),w.it("Cancels editor when clicked",function(){w.spyOn(c,"cancel"),e.click(),w.expect(c.cancel).toHaveBeenCalled()}),w.it("Closes dialog when clicked",function(){w.spyOn(c,"cancel"),w.spyOn(r,"close"),e.click(),w.expect(r.close).toHaveBeenCalled()}),w.it("Confirms before cancelling unsaved comment",function(){w.spyOn(c,"cancel"),w.spyOn(r,"close"),w.spyOn(window,"confirm").and.returnValue(!0),c.set("dirty",!0),e.click(),w.expect(r.close).toHaveBeenCalled()}),w.it("Cancel close when unsaved comment",function(){w.spyOn(c,"cancel"),w.spyOn(r,"close"),w.spyOn(window,"confirm").and.returnValue(!1),c.set("dirty",!0),e.click(),w.expect(r.close).not.toHaveBeenCalled()}),w.describe("Visibility",function(){w.it("Shown when canEdit=true",function(){c.set("canEdit",!0),w.expect(e.is(":visible")).toBe(!0)}),w.it("Hidden when canEdit=false",function(){c.set("canEdit",!1),w.expect(e.is(":visible")).toBe(!1)})})}),w.describe("Close",function(){let e;w.beforeEach(function(){e=r.$el.find(".btn-close")}),w.it("Cancels editor when clicked",function(){w.spyOn(c,"cancel"),e.click(),w.expect(c.cancel).toHaveBeenCalled()}),w.it("Closes dialog when clicked",function(){w.spyOn(c,"cancel"),w.spyOn(r,"close"),e.click(),w.expect(r.close).toHaveBeenCalled()}),w.describe("Visibility",function(){w.it("Shown when canEdit=false",function(){c.set("canEdit",!1),w.expect(e.is(":visible")).toBe(!0)}),w.it("Hidden when canEdit=true",function(){c.set("canEdit",!0),w.expect(e.is(":visible")).toBe(!1)})})}),w.describe("Delete",function(){let e;w.beforeEach(function(){e=r.$el.find(".btn-delete")}),w.it("Cancels editor when clicked",function(){c.set("canDelete",!0),w.spyOn(c,"deleteComment"),e.click(),w.expect(c.deleteComment).toHaveBeenCalled()}),w.it("Closes dialog when clicked",function(){c.set("canDelete",!0),w.spyOn(c,"deleteComment"),w.spyOn(r,"close"),e.click(),w.expect(r.close).toHaveBeenCalled()}),w.describe("Enabled state",function(){w.it("Enabled when editor.canDelete=true",function(){c.set("canDelete",!0),w.expect(e.is(":disabled")).toBe(!1)}),w.it("Disabled when editor.canDelete=false",function(){c.set("canDelete",!1),w.expect(e.is(":disabled")).toBe(!0)})}),w.describe("Visibility",function(){w.it("Shown when canDelete=true",function(){c.set("canDelete",!0),w.expect(e.is(":visible")).toBe(!0)}),w.it("Hidden when caDelete=false",function(){c.set("canDelete",!1),w.expect(e.is(":visible")).toBe(!1)})})}),w.describe("Save",function(){let e;w.beforeEach(function(){e=r.$el.find(".btn-save")}),w.it("Cancels editor when clicked",function(){c.set("canSave",!0),w.spyOn(c,"save").and.resolveTo(),e.click(),w.expect(c.save).toHaveBeenCalled()}),w.it("Closes dialog when clicked",function(){c.set("canSave",!0),w.spyOn(c,"save").and.resolveTo(),w.spyOn(r,"close"),e.click(),w.expect(r.close).toHaveBeenCalled()}),w.describe("Enabled state",function(){w.it("Enabled when editor.canSave=true",function(){c.set("canSave",!0),w.expect(e.is(":disabled")).toBe(!1)}),w.it("Disabled when editor.canSave=false",function(){c.set("canSave",!1),w.expect(e.is(":disabled")).toBe(!0)})}),w.describe("Visibility",function(){w.it("Shown when canEdit=true",function(){c.set("canEdit",!0),w.expect(e.is(":visible")).toBe(!0)}),w.it("Hidden when canEdit=false",function(){c.set("canEdit",!1),w.expect(e.is(":visible")).toBe(!1)})})})}),w.describe("Fields",function(){w.beforeEach(function(){r.open()}),w.describe("Open an Issue checkbox",function(){w.describe("Visibility",function(){w.it("Shown when canEdit=true",function(){c.set("canEdit",!0),w.expect(r._$issueOptions.is(":visible")).toBe(!0)}),w.it("Hidden when canEdit=false",function(){c.set("canEdit",!1),w.expect(r._$issueOptions.is(":visible")).toBe(!1)})})}),w.describe("Textbox",function(){w.describe("Visibility",function(){w.it("Shown when canEdit=true",function(){c.set("canEdit",!0),w.expect(r._textEditor.$el.is(":visible")).toBe(!0)}),w.it("Hidden when canEdit=false",function(){c.set("canEdit",!1),w.expect(r._textEditor.$el.is(":visible")).toBe(!1)})})})}),w.describe("Height",function(){w.beforeEach(function(){c=new RB.CommentEditor({comment:new RB.DiffComment,reviewRequest:t,reviewRequestEditor:i}),r=new RB.CommentDialogView({animate:!1,model:c})}),w.it("When canEdit=true",function(){c.set("canEdit",!0),r.render(),r.open(),w.expect(r.$el.height()).toBe(RB.CommentDialogView.DIALOG_TOTAL_HEIGHT)}),w.it("When canEdit=false",function(){c.set("canEdit",!1),r.render(),r.open(),w.expect(r.$el.height()).toBe(RB.CommentDialogView.DIALOG_NON_EDITABLE_HEIGHT)})}),w.describe("Other published comments list",function(){let o,e;w.beforeEach(function(){e=r.$el.find(".other-comments"),o=e.children("ul"),w.expect(o.length).toBe(1)}),w.describe("Empty list",function(){w.it("Hidden pane",function(){w.expect(e.is(":visible")).toBe(!1)})}),w.describe("Populated list",function(){let t,i,n;w.beforeEach(function(){(t=new RB.DiffComment).user={name:"Test User"},t.url="http://example.com/",t.comment_id=1,t.text="Sample comment.",t.issue_opened=!1,n="/?reply_id="+t.comment_id,(i=new RB.DiffComment).user={name:"Test User"},i.url="http://example.com/",i.comment_id=2,i.text="Sample comment.",i.issue_opened=!1,i.reply_to_id=1}),w.describe("Visible pane",function(){w.it("Setting list before opening dialog",function(){c.set("publishedComments",[t]),r.open(),w.expect(e.is(":visible")).toBe(!0)}),w.it("Setting list after opening dialog",function(){r.open(),c.set("publishedComments",[t]),w.expect(e.is(":visible")).toBe(!0)})}),w.it("List items added",function(){r.open(),c.set("publishedComments",[t]),w.expect(o.children().length).toBe(1)}),w.it("Parent comment reply link links to itself",function(){c.set("publishedComments",[t]),r.open();var e=o.find(".comment-list-reply-action");w.expect(e[0].href).toContain(n)}),w.it("Both parent and reply comment reply links link to parent comment",function(){c.set("publishedComments",[t,i]),r.open();var e=o.find(".comment-list-reply-action");w.expect(e.length).toEqual(2),w.expect(e[0].href).toContain(n),w.expect(e[1].href).toContain(n)})}),w.describe("Issue bar buttons",function(){let t;w.beforeEach(function(){(t=new RB.DiffComment).user={name:"Test User"},t.url="http://example.com/",t.comment_id=1,t.review_id=1,t.text="Sample comment.",t.issue_opened=!0,t.issue_status="open"}),w.it("When interactive",function(){i.set("editable",!0),c.set("publishedComments",[t]),(r=new RB.CommentDialogView({animate:!1,commentIssueManager:new RB.CommentIssueManager,model:c})).render().$el.appendTo($testsScratch),r.open();var e=r.$el.find(".rb-c-issue-bar__actions button");w.expect(e.length).toBe(2),w.expect(e.is(":visible")).toBe(!0)}),w.it("When not interactive",function(){i.set("editable",!1),c.set("publishedComments",[t]),(r=new RB.CommentDialogView({animate:!1,commentIssueManager:new RB.CommentIssueManager,model:c})).render().$el.appendTo($testsScratch),r.open();var e=r.$el.find(".rb-c-issue-bar__actions button");w.expect(e.length).toBe(0)})})}),w.describe("Methods",function(){w.describe("close",function(){w.it("Editor state",function(){r.open(),w.expect(c.get("editing")).toBe(!0),r.close(),w.expect(c.get("editing")).toBe(!1)}),w.it("Dialog removed",function(){r.open(),w.spyOn(r,"trigger"),r.close(),w.expect(r.trigger).toHaveBeenCalledWith("closed"),w.expect(r.$el.parents().length).toBe(0),w.expect($testsScratch.children().length).toBe(0)})}),w.describe("open",function(){w.it("Editor state",function(){w.expect(c.get("editing")).toBe(!1),r.open(),w.expect(c.get("editing")).toBe(!0)}),w.it("Visibility",function(){w.expect(r.$el.is(":visible")).toBe(!1),r.open(),w.expect(r.$el.is(":visible")).toBe(!0)}),w.it("Default focus",function(){var e=r.$el.find("textarea");w.expect(e.is(":focus")).toBe(!1),w.spyOn(e[0],"focus"),r.open(),w.expect(e[0].focus).toHaveBeenCalled()})})}),w.describe("Special keys",function(){let a;function o(t,i,n,o){a.focus(),["keydown","keypress","keyup"].forEach(e=>{e=$.Event(e);e.key=t,e.altKey=i,e.ctrlKey=n,e.metaKey=o,a.trigger(e)})}function s(e,t=!1){c.set("richText",e),c.set("canSave",!!t),a=r.$("textarea")}w.beforeEach(function(){r.open(),a=r.$("textarea")}),w.describe("Control-Enter to save",function(){w.beforeEach(function(){w.spyOn(c,"save").and.resolveTo(),w.spyOn(r,"close")}),w.describe("With editor.canSave=true",function(){w.it("If Markdown",function(){s(!0,!0),o("Enter",!1,!0),w.expect(c.save).toHaveBeenCalled(),w.expect(r.close).toHaveBeenCalled()}),w.it("If plain text",function(){s(!1,!0),o("Enter",!1,!0),w.expect(c.save).toHaveBeenCalled(),w.expect(r.close).toHaveBeenCalled()})}),w.describe("With editor.canSave=false",function(){w.beforeEach(function(){c.set("canSave",!1)}),w.it("If Markdown",function(){s(!0),o("Enter",!1,!0),w.expect(c.save).not.toHaveBeenCalled(),w.expect(r.close).not.toHaveBeenCalled()}),w.it("If plain text",function(){s(!1),o("Enter",!1,!0),w.expect(c.save).not.toHaveBeenCalled(),w.expect(r.close).not.toHaveBeenCalled()})})}),w.describe("Command-Enter to save",function(){w.beforeEach(function(){w.spyOn(c,"save").and.resolveTo(),w.spyOn(r,"close")}),w.describe("With editor.canSave=true",function(){w.it("If Markdown",function(){s(!0,!0),o("Enter",!1,!1,!0),w.expect(c.save).toHaveBeenCalled(),w.expect(r.close).toHaveBeenCalled()}),w.it("If plain text",function(){s(!1,!0),o("Enter",!1,!1,!0),w.expect(c.save).toHaveBeenCalled(),w.expect(r.close).toHaveBeenCalled()})}),w.describe("With editor.canSave=false",function(){w.beforeEach(function(){c.set("canSave",!1)}),w.it("If Markdown",function(){s(!0),o("Enter",!1,!1,!0),w.expect(c.save).not.toHaveBeenCalled(),w.expect(r.close).not.toHaveBeenCalled()}),w.it("If plain text",function(){s(!1),o("Enter",!1,!1,!0),w.expect(c.save).not.toHaveBeenCalled(),w.expect(r.close).not.toHaveBeenCalled()})})}),w.describe("Escape to cancel",function(){w.describe("Pressing escape in text area",function(){w.beforeEach(function(){w.spyOn(c,"cancel"),w.spyOn(r,"close")}),w.it("If Markdown",function(){w.spyOn(window,"confirm").and.returnValue(!0),s(!0),o("Escape",!1,!1),w.expect(c.cancel).toHaveBeenCalled(),w.expect(window.confirm).toHaveBeenCalled(),w.expect(r.close).toHaveBeenCalled()}),w.it("If plain text",function(){s(!1),o("Escape",!1,!1),w.expect(c.cancel).toHaveBeenCalled(),w.expect(r.close).toHaveBeenCalled()}),w.it("If unsaved comment",function(){w.spyOn(window,"confirm").and.returnValue(!0),c.set("dirty",!0),o("Escape",!1,!1),w.expect(c.cancel).toHaveBeenCalled(),w.expect(window.confirm).toHaveBeenCalled(),w.expect(r.close).toHaveBeenCalled()}),w.it("If unsaved comment, do not close",function(){w.spyOn(window,"confirm").and.returnValue(!1),c.set("dirty",!0),o("Escape",!1,!1),w.expect(c.cancel).not.toHaveBeenCalled(),w.expect(window.confirm).toHaveBeenCalled(),w.expect(r.close).not.toHaveBeenCalled()})})}),w.describe("Toggle open issue",function(){let n;function e(e,t,i){s(e),n.prop("checked",t),c.set("openIssue",t),o(i,!0,!1),w.expect(n.prop("checked")).toBe(!t),w.expect(c.get("openIssue")).toBe(!t),w.expect(a.val()).toBe("")}w.beforeEach(function(){n=r.$el.find("input[type=checkbox]")}),w.describe("Alt-I",function(){w.describe("Checked to unchecked",function(){w.it("If Markdown",function(){e(!0,!0,"i")}),w.it("If plain text",function(){e(!1,!0,"i")})}),w.describe("Unchecked to checked",function(){w.it("If Markdown",function(){e(!0,!1,"i")}),w.it("If plain text",function(){e(!1,!1,"i")})})}),w.describe("Alt-i",function(){w.describe("Checked to unchecked",function(){w.it("If Markdown",function(){e(!0,!0,"i")}),w.it("If plain text",function(){e(!1,!0,"i")})}),w.describe("Unchecked to checked",function(){w.it("If Markdown",function(){e(!0,!1,"i")}),w.it("If plain text",function(){e(!1,!1,"i")})})})})}),w.describe("Title text",function(){let e;w.beforeEach(function(){r.open(),e=r.$el.find("form .title")}),w.it("Default state",function(){w.expect(e.text()).toBe("Your comment")}),w.it("Setting dirty=true",function(){c.set("dirty",!0),w.expect(e.text()).toBe("Your comment (unsaved)")}),w.it("Setting dirty=false",function(){c.set("dirty",!0),c.set("dirty",!1),w.expect(e.text()).toBe("Your comment")})}),w.describe("State synchronization",function(){w.describe("Comment text",function(){let o;w.beforeEach(function(){r.open(),o=$(r._textEditor.$("textarea"))}),w.describe("Dialog to editor",function(){const n="foo";w.beforeEach(function(e){o.focus();for(let t=0;t<n.length;t++){var i=n.charCodeAt(t);let e=$.Event("keydown");e.which=i,o.trigger(e),(e=$.Event("keypress")).which=i,o.trigger(e),r._textEditor.setText(r._textEditor.getText()+n[t]),(e=$.Event("keyup")).which=i,o.trigger(e)}const t=setInterval(()=>{r._textEditor.getText()===n&&(clearInterval(t),e())},100)}),w.it("",function(){w.expect(c.get("text")).toEqual(n)})}),w.it("Editor to dialog",function(){c.set("text","bar"),w.expect(r._textEditor.getText()).toEqual("bar")})}),w.describe("Open Issue checkbox",function(){let e;w.beforeEach(function(){r.open(),(e=r.$("#comment_issue")).prop("checked",!1),c.set("openIssue",!1)}),w.it("Dialog to editor",function(){e.click(),w.expect(c.get("openIssue")).toBe(!0)}),w.it("Editor to dialog",function(){c.set("openIssue",!0),w.expect(e.prop("checked")).toBe(!0)})}),w.describe("Enable Markdown checkbox",function(){let e;w.beforeEach(function(){r.open(),(e=r.$("#enable_markdown")).prop("checked",!1),c.set("richText",!1),w.expect(r._textEditor.richText).toBe(!1)}),w.it("Dialog to editor",function(){e.click(),w.expect(c.get("richText")).toBe(!0),w.expect(r._textEditor.richText).toBe(!0)}),w.it("Editor to dialog",function(){c.set("richText",!0),w.expect(e.prop("checked")).toBe(!0),w.expect(r._textEditor.richText).toBe(!0)})})}),w.describe("User preference defaults",function(){w.describe("Open Issue checkbox",function(){w.it("When commentsOpenAnIssue is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",!0),c=new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#comment_issue");w.expect(c.get("openIssue")).toBe(!0),w.expect(e.prop("checked")).toBe(!0)}),w.it("When commentsOpenAnIssue is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",!1),c=new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#comment_issue");w.expect(c.get("openIssue")).toBe(!1),w.expect(e.prop("checked")).toBe(!1)})}),w.describe("Enable Markdown checkbox",function(){w.describe("When defaultUseRichText is true",function(){w.beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",!0)}),w.it("New comment",function(){c=new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#enable_markdown");w.expect(c.get("richText")).toBe(!0),w.expect(e.prop("checked")).toBe(!0),w.expect(r._textEditor.richText).toBe(!0)}),w.it("Existing comment with richText=true",function(){c=new RB.CommentEditor({comment:new RB.DiffComment({richText:!0}),reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#enable_markdown");w.expect(c.get("richText")).toBe(!0),w.expect(e.prop("checked")).toBe(!0),w.expect(r._textEditor.richText).toBe(!0)}),w.it("Existing comment with richText=false",function(){c=new RB.CommentEditor({comment:new RB.DiffComment({richText:!1}),reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#enable_markdown");w.expect(c.get("richText")).toBe(!0),w.expect(e.prop("checked")).toBe(!0),w.expect(r._textEditor.richText).toBe(!0)})}),w.describe("When defaultUseRichText is false",function(){w.beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",!1)}),w.it("New comment",function(){c=new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#enable_markdown");w.expect(c.get("richText")).toBe(!1),w.expect(e.prop("checked")).toBe(!1),w.expect(r._textEditor.richText).toBe(!1)}),w.it("Existing comment with richText=true",function(){c=new RB.CommentEditor({comment:new RB.DiffComment({richText:!0}),reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#enable_markdown");w.expect(c.get("richText")).toBe(!0),w.expect(e.prop("checked")).toBe(!0),w.expect(r._textEditor.richText).toBe(!0)}),w.it("Existing comment with richText=false",function(){c=new RB.CommentEditor({comment:new RB.DiffComment({richText:!1}),reviewRequest:t,reviewRequestEditor:i}),(r=new RB.CommentDialogView({animate:!1,model:c})).render();var e=r.$("#enable_markdown");w.expect(c.get("richText")).toBe(!1),w.expect(e.prop("checked")).toBe(!1),w.expect(r._textEditor.richText).toBe(!1)})})})}),w.describe("Logged Out indicator",function(){w.it("When logged in",function(){RB.UserSession.instance.set("authenticated",!0),(r=new RB.CommentDialogView({animate:!1,model:new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i})})).render(),w.expect(r.$el.find('p[class="login-text"]').length).toBe(0)}),w.it("When logged out",function(){RB.UserSession.instance.set("authenticated",!1),(r=new RB.CommentDialogView({animate:!1,model:new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i})})).render(),w.expect(r.$el.find('p[class="login-text"]').length).toBe(1)})}),w.describe("Deleted indicator",function(){w.it("Shown when deletedWarning != null",function(){var e=new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i});(r=new RB.CommentDialogView({animate:!1,deletedWarning:"warning",model:e})).render(),w.expect(r.$el.find('p[class="deleted-warning"]').length).toBe(1),w.expect(e.get("canEdit")).toBe(!1)}),w.it("Hidden when deletedWarning == null",function(){var e=new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i});(r=new RB.CommentDialogView({animate:!1,model:e})).render(),w.expect(r.$el.find('p[class="deleted-warning"]').length).toBe(0),w.expect(e.get("canEdit")).toBe(!0)})}),w.describe("Draft indicator",function(){w.it("Shown when draftWarning != null",function(){(r=new RB.CommentDialogView({animate:!1,draftWarning:"warning",model:new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i})})).render(),w.expect(r.$el.find('p[class="draft-warning"]').length).toBe(1)}),w.it("Hidden when draftWarning == null",function(){(r=new RB.CommentDialogView({animate:!1,draftWarning:null,model:new RB.CommentEditor({reviewRequest:t,reviewRequestEditor:i})})).render(),w.expect(r.$el.find('p[class="draft-warning"]').length).toBe(0)})})})}),e.suite("rb/reviews/views/CommentIssueBarView",()=>{let o,a,i;function n(e,t){t=new e.CommentCls(t),w.spyOn(t,"ready").and.resolveTo(),w.spyOn(t,"save").and.resolveTo({[e.rspNamespace]:{timestamp:"2022-07-05T01:02:03"}}),e=e.createCommentFunc;(jasmine.isSpy(i[e])?i[e]:w.spyOn(i,e)).and.returnValue(t)}function s(e){e=a.el.querySelector(`.ink-c-button[data-action="${e}"]`);return w.expect(e).toBeTruthy(),e}function c(e){return(a=new RB.CommentIssueBarView(Object.assign({canVerify:!0,commentID:2,commentIssueManager:o,commentType:RB.CommentIssueManagerCommentType.DIFF,interactive:!0,issueStatus:RB.CommentIssueStatusType.OPEN,reviewID:1},e))).render(),a}w.afterEach(()=>{a.remove(),a=null,o=null,i=null}),beforeEach(function(){var e=new RB.ReviewRequest;o=new RB.CommentIssueManager({reviewRequest:e}),i=e.createReview(1),w.spyOn(e,"ready").and.resolveTo(),w.spyOn(e,"createReview").and.callFake(()=>i),w.spyOn(i,"ready").and.resolveTo()}),w.describe("Actions",()=>{let e;beforeEach(()=>{e=o.getOrCreateComment({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,reviewID:1}),w.spyOn(e,"ready").and.resolveTo(),w.spyOn(e,"getAuthorUsername").and.returnValue("doc")}),w.it("Resolving as fixed",t=>{a=c();const i=s("resolve"),n=s("drop");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(i.getAttribute("aria-busy")).toBe("true"),w.expect(i.disabled).toBeFalse(),w.expect(n.getAttribute("aria-busy")).toBeNull(),w.expect(n.disabled).toBeTrue(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,reviewID:1}),t()}),i.click()}),w.it("Dropping",t=>{a=c();const i=s("resolve"),n=s("drop");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(i.getAttribute("aria-busy")).toBeNull(),w.expect(i.disabled).toBeTrue(),w.expect(n.getAttribute("aria-busy")).toBe("true"),w.expect(n.disabled).toBeFalse(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.DROPPED,reviewID:1}),t()}),n.click()}),w.it("Re-opening from resolved",t=>{e.set("issueStatus",RB.CommentIssueStatusType.RESOLVED),a=c({issueStatus:RB.CommentIssueStatusType.RESOLVED});const i=s("reopen");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(i.getAttribute("aria-busy")).toBe("true"),w.expect(i.disabled).toBeFalse(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.OPEN,reviewID:1}),t()}),i.click()}),w.it("Re-opening from dropped",t=>{e.set("issueStatus",RB.CommentIssueStatusType.DROPPED),a=c({issueStatus:RB.CommentIssueStatusType.DROPPED});const i=s("reopen");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(i.getAttribute("aria-busy")).toBe("true"),w.expect(i.disabled).toBeFalse(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.OPEN,reviewID:1}),t()}),i.click()}),w.it("Re-opening from verify-resolved",t=>{e.set("issueStatus",RB.CommentIssueStatusType.VERIFYING_RESOLVED),a=c({issueStatus:RB.CommentIssueStatusType.VERIFYING_RESOLVED});const i=s("reopen");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(i.getAttribute("aria-busy")).toBe("true"),w.expect(i.disabled).toBeFalse(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.OPEN,reviewID:1}),t()}),i.click()}),w.it("Re-opening from verify-dropped",t=>{e.set("issueStatus",RB.CommentIssueStatusType.VERIFYING_DROPPED),a=c({issueStatus:RB.CommentIssueStatusType.VERIFYING_DROPPED});const i=s("reopen");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(i.getAttribute("aria-busy")).toBe("true"),w.expect(i.disabled).toBeFalse(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.OPEN,reviewID:1}),t()}),i.click()}),w.it("Verifying resolved",t=>{e.set("issueStatus",RB.CommentIssueStatusType.VERIFYING_RESOLVED),e.get("extraData").require_verification=!0,a=c({issueStatus:RB.CommentIssueStatusType.VERIFYING_RESOLVED});const i=s("reopen"),n=s("verify-resolved");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(n.getAttribute("aria-busy")).toBe("true"),w.expect(n.disabled).toBeFalse(),w.expect(i.getAttribute("aria-busy")).toBeNull(),w.expect(i.disabled).toBeTrue(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.RESOLVED,reviewID:1}),t()}),n.click()}),w.it("Verifying dropped",t=>{e.set("issueStatus",RB.CommentIssueStatusType.VERIFYING_DROPPED),e.get("extraData").require_verification=!0,a=c({issueStatus:RB.CommentIssueStatusType.VERIFYING_DROPPED});const i=s("reopen"),n=s("verify-dropped");w.spyOn(o,"setCommentIssueStatus").and.callFake(e=>{w.expect(n.getAttribute("aria-busy")).toBe("true"),w.expect(n.disabled).toBeFalse(),w.expect(i.getAttribute("aria-busy")).toBeNull(),w.expect(i.disabled).toBeTrue(),w.expect(e).toEqual({commentID:2,commentType:RB.CommentIssueManagerCommentType.DIFF,newIssueStatus:RB.CommentIssueStatusType.DROPPED,reviewID:1}),t()}),n.click()})}),w.describe("Event handling",()=>{w.describe("CommentIssueManager.issueStatusUpdated",()=>{function e(e,t){beforeEach(()=>{a=c({commentType:e.commentType}),n(e,{id:2,issueStatus:RB.CommentIssueStatusType.RESOLVED})}),w.it("When comment updated",async()=>{await o.setCommentIssueStatus({commentID:2,commentType:e.commentType,reviewID:1,newIssueStatus:RB.CommentIssueStatusType.RESOLVED}),w.expect(a.el.dataset.issueStatus).toBe("resolved")}),w.describe("When different comment updated",()=>{w.it("With same ID, different type",async()=>{n(t,{id:2,issueStatus:RB.CommentIssueStatusType.RESOLVED}),await o.setCommentIssueStatus({commentID:2,commentType:t.commentType,reviewID:1,newIssueStatus:RB.CommentIssueStatusType.RESOLVED}),w.expect(a.el.dataset.issueStatus).toBe("open")}),w.it("With different ID, same type",async()=>{n(e,{id:3,issueStatus:RB.CommentIssueStatusType.RESOLVED}),await o.setCommentIssueStatus({commentID:3,commentType:e.commentType,reviewID:1,newIssueStatus:RB.CommentIssueStatusType.RESOLVED}),w.expect(a.el.dataset.issueStatus).toBe("open")})})}RB.CommentIssueStatusType.OPEN,w.describe("For diff comments",()=>{e({commentType:RB.CommentIssueManagerCommentType.DIFF,CommentCls:RB.DiffComment,rspNamespace:"diff_comment",createCommentFunc:"createDiffComment"},{commentType:RB.CommentIssueManagerCommentType.GENERAL,CommentCls:RB.GeneralComment,rspNamespace:"general_comment",createCommentFunc:"createGeneralComment"})}),w.describe("For general comments",()=>{e({commentType:RB.CommentIssueManagerCommentType.GENERAL,CommentCls:RB.GeneralComment,rspNamespace:"general_comment",createCommentFunc:"createGeneralComment"},{commentType:RB.CommentIssueManagerCommentType.DIFF,CommentCls:RB.DiffComment,rspNamespace:"diff_comment",createCommentFunc:"createDiffComment"})}),w.describe("For file attachment comments",()=>{e({commentType:RB.CommentIssueManagerCommentType.FILE_ATTACHMENT,CommentCls:RB.FileAttachmentComment,rspNamespace:"file_attachment_comment",createCommentFunc:"createFileAttachmentComment"},{commentType:RB.CommentIssueManagerCommentType.GENERAL,CommentCls:RB.GeneralComment,rspNamespace:"general_comment",createCommentFunc:"createGeneralComment"})}),w.describe("For screenshot comments",()=>{e({commentType:RB.CommentIssueManagerCommentType.SCREENSHOT,CommentCls:RB.ScreenshotComment,rspNamespace:"screenshot_comment",createCommentFunc:"createScreenshotComment"},{commentType:RB.CommentIssueManagerCommentType.GENERAL,CommentCls:RB.GeneralComment,rspNamespace:"general_comment",createCommentFunc:"createGeneralComment"})})})}),w.describe("Issue statuses",()=>{function e(e){var t=e.issueStatus,i=(a=c({canVerify:!!e.canVerify,interactive:e.interactive,issueStatus:t})).el,n=(w.expect(Array.from(i.querySelectorAll(".ink-c-button")).map(e=>e.dataset.action)).toEqual(e.expectedActions),i.querySelector(".rb-c-issue-bar__message"));w.expect(n.textContent).toBe(e.expectedMessage),w.expect(i.dataset.issueStatus).toBe(t)}w.describe("Open",()=>{w.it("When interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.OPEN,interactive:!0,expectedActions:["resolve","drop"],expectedMessage:"An issue was opened."})}),w.it("When not interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.OPEN,interactive:!1,expectedActions:[],expectedMessage:"An issue was opened."})})}),w.describe("Dropped",()=>{w.it("When interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.DROPPED,interactive:!0,expectedActions:["reopen"],expectedMessage:"The issue has been dropped."})}),w.it("When not interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.DROPPED,interactive:!1,expectedActions:[],expectedMessage:"The issue has been dropped."})})}),w.describe("Fixed",()=>{w.it("When interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.RESOLVED,interactive:!0,expectedActions:["reopen"],expectedMessage:"The issue has been resolved."})}),w.it("When not interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.RESOLVED,interactive:!1,expectedActions:[],expectedMessage:"The issue has been resolved."})})}),w.describe("Verifying Dropped",()=>{w.describe("When interactive",()=>{w.it("When can verify",()=>{e({canVerify:!0,issueStatus:RB.CommentIssueStatusType.VERIFYING_DROPPED,interactive:!0,expectedActions:["reopen","verify-dropped"],expectedMessage:"Waiting for verification before dropping..."})}),w.it("When cannot verify",()=>{e({canVerify:!1,issueStatus:RB.CommentIssueStatusType.VERIFYING_DROPPED,interactive:!0,expectedActions:["reopen"],expectedMessage:"Waiting for verification before dropping..."})})}),w.it("When not interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.VERIFYING_DROPPED,interactive:!1,expectedActions:[],expectedMessage:"Waiting for verification before dropping..."})})}),w.describe("Verifying Fixed",()=>{w.describe("When interactive",()=>{w.it("When can verify",()=>{e({canVerify:!0,issueStatus:RB.CommentIssueStatusType.VERIFYING_RESOLVED,interactive:!0,expectedActions:["reopen","verify-resolved"],expectedMessage:"Waiting for verification before resolving..."})}),w.it("When cannot verify",()=>{e({canVerify:!1,issueStatus:RB.CommentIssueStatusType.VERIFYING_RESOLVED,interactive:!0,expectedActions:["reopen"],expectedMessage:"Waiting for verification before resolving..."})})}),w.it("When not interactive",()=>{e({issueStatus:RB.CommentIssueStatusType.VERIFYING_RESOLVED,interactive:!1,expectedActions:[],expectedMessage:"Waiting for verification before resolving..."})})})})}),e.suite("rb/diffviewer/views/DiffReviewableView",function(){const r=_.template(`<table class="sidebyside">
 <thead>
  <tr>
   <th colspan="2">
    <a name="1" class="file-anchor"></a> my-file.txt
   </th>
  </tr>
  <tr>
   <th class="rev">Revision 1</th>
   <th class="rev">Revision 2</th>
  </tr>
 </thead>
 <% _.each(chunks, function(chunk, index) { %>
  <% if (chunk.type === "collapsed") { %>
   <tbody class="diff-header">
    <tr>
     <th>
      <a href="#" class="diff-expand-btn tests-expand-above"
         data-chunk-index="<%= index %>"
         data-lines-of-context="20,0"><img></a>
     </th>
     <th colspan="3">
      <a href="#" class="diff-expand-btn tests-expand-chunk"
         data-chunk-index="<%= index %>"><img> Expand</a>
     </th>
    </tr>
    <tr>
     <th>
      <a href="#" class="diff-expand-btn tests-expand-below"
         data-chunk-index="<%= index %>"
         data-lines-of-context="0,20"><img></a>
     </th>
     <th colspan="3">
      <a href="#" class="diff-expand-btn tests-expand-header"
         data-chunk-index="<%= index %>"
         data-lines-of-context="0,<%= chunk.expandHeaderLines %>">
       <img> <code>Some Function</code>
      </a>
     </th>
    </tr>
   </tbody>
  <% } else { %>
   <tbody class="<%= chunk.type %>
                 <% if (chunk.expanded) { %>loaded<% } %>
                 <%= chunk.extraClass || "" %>"
          id="chunk0.<%= index %>">
    <% for (var i = 0; i < chunk.numRows; i++) { %>
     <tr line="<%= i + chunk.startRow %>">
      <th></th>
      <td>
       <% if (chunk.expanded && i === 0) { %>
        <div class="collapse-floater">
         <div class="rb-c-diff-collapse-button"
              data-chunk-index="<%= index %>"
              data-lines-of-context="0"></div>
        </div>
       <% } %>
      </td>
      <th></th>
      <td></td>
     </tr>
    <% } %>
   </tbody>
  <% } %>
 <% }); %>
</table>`),i=_.template(`<tbody class="rb-c-diff-file-notice">
 <tr>
  <td colspan="4">
   <div class="rb-c-alert -is-warning">
    <div class="rb-c-alert__content">
     <%= contentHTML %>
    </div>
   </div>
  </td>
 </tr>
</tbody>`);let l,d,p;w.beforeEach(function(){d=$("<div>").appendTo($testsScratch),l=new RB.ReviewRequest}),w.afterEach(function(){p.remove()}),w.describe("CommentRowSelector",function(){let a,s;w.beforeEach(function(){(p=new RB.DiffReviewableView({el:$(r({chunks:[{numRows:5,startRow:1,type:"equal"},{numRows:10,startRow:6,type:"delete"}]})),model:new RB.DiffReviewable({reviewRequest:l})})).render().$el.appendTo(d),a=p._selector,s=p.$el.find("tbody tr")}),w.describe("Selecting range",function(){let i,n;w.beforeEach(function(){i=s.eq(4),n=i[0].cells[0]}),w.it("Beginning selection",function(){a._onMouseOver({target:n}),a._onMouseDown({target:n}),w.expect(i.hasClass("selected")).toBe(!0),w.expect(a._$begin[0]).toBe(i[0]),w.expect(a._$end[0]).toBe(i[0]),w.expect(a._beginLineNum).toBe(5),w.expect(a._endLineNum).toBe(5),w.expect(a._lastSeenIndex).toBe(i[0].rowIndex)}),w.describe("Adding rows to selection",function(){w.it("Above",function(){var e=s.eq(3);a._onMouseOver({target:n}),a._onMouseDown({target:n}),a._onMouseOver({target:e[0].cells[0]}),w.expect(i.hasClass("selected")).toBe(!0),w.expect(e.hasClass("selected")).toBe(!0),w.expect(a._$begin[0]).toBe(e[0]),w.expect(a._$end[0]).toBe(i[0]),w.expect(a._beginLineNum).toBe(4),w.expect(a._endLineNum).toBe(5),w.expect(a._lastSeenIndex).toBe(e[0].rowIndex)}),w.it("Below",function(){var e=s.eq(5);a._onMouseOver({target:n}),a._onMouseDown({target:n}),a._onMouseOver({target:e[0].cells[0]}),w.expect(i.hasClass("selected")).toBe(!0),w.expect(e.hasClass("selected")).toBe(!0),w.expect(a._$begin[0]).toBe(i[0]),w.expect(a._$end[0]).toBe(e[0]),w.expect(a._beginLineNum).toBe(5),w.expect(a._endLineNum).toBe(6),w.expect(a._lastSeenIndex).toBe(e[0].rowIndex)}),w.it("Rows inbetween two events",function(){var e=s.eq(7);a._onMouseOver({target:n}),a._onMouseDown({target:n}),a._onMouseOver({target:e[0].cells[0]}),w.expect($(s[4]).hasClass("selected")).toBe(!0),w.expect($(s[5]).hasClass("selected")).toBe(!0),w.expect($(s[6]).hasClass("selected")).toBe(!0),w.expect($(s[7]).hasClass("selected")).toBe(!0),w.expect(a._$begin[0]).toBe(i[0]),w.expect(a._$end[0]).toBe(e[0]),w.expect(a._beginLineNum).toBe(5),w.expect(a._endLineNum).toBe(8),w.expect(a._lastSeenIndex).toBe(e[0].rowIndex)})}),w.describe("Removing rows from selection",function(){w.it("Above",function(){var e=s.eq(3),t=e[0].cells[0];a._onMouseOver({target:n}),a._onMouseDown({target:n}),a._onMouseOver({target:t}),a._onMouseOut({relatedTarget:n,target:t}),a._onMouseOver({target:n}),w.expect(i.hasClass("selected")).toBe(!0),w.expect(e.hasClass("selected")).toBe(!1),w.expect(a._$begin[0]).toBe(i[0]),w.expect(a._$end[0]).toBe(i[0]),w.expect(a._beginLineNum).toBe(5),w.expect(a._endLineNum).toBe(5),w.expect(a._lastSeenIndex).toBe(i[0].rowIndex)}),w.it("Below",function(){var e=s.eq(5),t=e[0].cells[0];a._onMouseOver({target:n}),a._onMouseDown({target:n}),a._onMouseOver({target:t}),a._onMouseOut({relatedTarget:n,target:t}),a._onMouseOver({target:n}),w.expect(i.hasClass("selected")).toBe(!0),w.expect(e.hasClass("selected")).toBe(!1),w.expect(a._$begin[0]).toBe(i[0]),w.expect(a._$end[0]).toBe(i[0]),w.expect(a._beginLineNum).toBe(5),w.expect(a._endLineNum).toBe(5),w.expect(a._lastSeenIndex).toBe(i[0].rowIndex)})}),w.describe("Finishing selection",function(){w.beforeEach(function(){w.spyOn(p,"createAndEditCommentBlock")}),w.describe("With single line",function(){let t,i;w.beforeEach(function(){t=$(s[4]),i=t[0].cells[0]}),w.it("And existing comment",function(){var e=w.jasmine.createSpy("onClick");$('<a class="commentflag">').click(e).appendTo(i),a._onMouseOver({target:i}),a._onMouseDown({target:i}),a._onMouseUp({preventDefault:function(){},stopImmediatePropagation:function(){},target:i}),w.expect(p.createAndEditCommentBlock).not.toHaveBeenCalled(),w.expect(e).toHaveBeenCalled(),w.expect(t.hasClass("selected")).toBe(!1),w.expect(a._$begin).toBe(null),w.expect(a._$end).toBe(null),w.expect(a._beginLineNum).toBe(0),w.expect(a._endLineNum).toBe(0),w.expect(a._lastSeenIndex).toBe(0)}),w.it("And no existing comment",function(){a._onMouseOver({target:i}),a._onMouseDown({target:i}),a._onMouseUp({target:i,preventDefault:function(){},stopImmediatePropagation:function(){}}),w.expect(p.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:t,$endRow:t,beginLineNum:5,endLineNum:5}),w.expect(t.hasClass("selected")).toBe(!1),w.expect(a._$begin).toBe(null),w.expect(a._$end).toBe(null),w.expect(a._beginLineNum).toBe(0),w.expect(a._endLineNum).toBe(0),w.expect(a._lastSeenIndex).toBe(0)})}),w.describe("With multiple lines",function(){let t,i,n,o;w.beforeEach(function(){t=s.eq(4),i=s.eq(5),n=t[0].cells[0],o=i[0].cells[0]}),w.xit("And existing comment",function(){var e=w.jasmine.createSpy("onClick");$('<a class="commentflag">').click(e).appendTo(n),a._onMouseOver({target:n}),a._onMouseDown({target:n}),a._onMouseOver({target:o}),w.expect(a._$begin[0]).toBe(t[0]),w.expect(a._$end[0]).toBe(i[0]),t=a._$begin,i=a._$end,a._onMouseUp({target:o,preventDefault:function(){},stopImmediatePropagation:function(){}}),w.expect(p.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:t,$endRow:i,beginLineNum:5,endLineNum:6}),w.expect(e).not.toHaveBeenCalled(),w.expect(t.hasClass("selected")).toBe(!1),w.expect(i.hasClass("selected")).toBe(!1),w.expect(a._$begin).toBe(null),w.expect(a._$end).toBe(null),w.expect(a._beginLineNum).toBe(0),w.expect(a._endLineNum).toBe(0),w.expect(a._lastSeenIndex).toBe(0)}),w.it("And no existing comment",function(){a._onMouseOver({target:n}),a._onMouseDown({target:n}),a._onMouseOver({target:o}),w.expect(a._$begin[0]).toBe(t[0]),w.expect(a._$end[0]).toBe(i[0]),t=a._$begin,i=a._$end,a._onMouseUp({target:o,preventDefault:function(){},stopImmediatePropagation:function(){}}),w.expect(p.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:t,$endRow:i,beginLineNum:5,endLineNum:6}),w.expect(t.hasClass("selected")).toBe(!1),w.expect(i.hasClass("selected")).toBe(!1),w.expect(a._$begin).toBe(null),w.expect(a._$end).toBe(null),w.expect(a._beginLineNum).toBe(0),w.expect(a._endLineNum).toBe(0),w.expect(a._lastSeenIndex).toBe(0)})})})}),w.describe("Hovering",function(){w.describe("Over line",function(){let e,t;w.beforeEach(function(){e=s.eq(4)}),w.it("Contents cell",function(){t=e[0].cells[1],a._onMouseOver({target:t}),w.expect(e.hasClass("selected")).toBe(!1),w.expect(a._$ghostCommentFlag.css("display")).toBe("none")}),w.describe("Line number cell",function(){w.beforeEach(function(){t=e[0].cells[0]}),w.it("With existing comment on row",function(){$(t).append('<a class="commentflag">'),a._onMouseOver({target:t}),w.expect(e.hasClass("selected")).toBe(!0),w.expect(a._$ghostCommentFlag.css("display")).toBe("none")}),w.it("With no column flag",function(){a._onMouseOver({target:t}),w.expect(e.hasClass("selected")).toBe(!0),w.expect(a._$ghostCommentFlag.css("display")).not.toBe("none")})})}),w.describe("Out of line",function(){w.it("Contents cell",function(){var e=s.eq(0);a._onMouseOver({target:e[0].cells[0]}),w.expect(a._$ghostCommentFlag.css("display")).not.toBe("none"),a._onMouseOut({target:e[0].cells[0]}),w.expect(a._$ghostCommentFlag.css("display")).toBe("none")}),w.it("Line number cell",function(){var e=s.eq(0);a._onMouseOver({target:e[0].cells[0]}),w.expect(a._$ghostCommentFlag.css("display")).not.toBe("none"),w.expect(e.hasClass("selected")).toBe(!0),a._onMouseOut({target:e[0].cells[0]}),w.expect(a._$ghostCommentFlag.css("display")).toBe("none"),w.expect(e.hasClass("selected")).toBe(!1)})})})}),w.describe("Incremental expansion",function(){let n;w.beforeEach(function(){n=new RB.DiffReviewable({file:new RB.DiffFile({index:1}),fileDiffID:10,reviewRequest:l,revision:1})}),w.describe("Expanding",function(){w.beforeEach(function(){(p=new RB.DiffReviewableView({el:$(r({chunks:[{numRows:5,startRow:1,type:"equal"},{expandHeaderLines:7,type:"collapsed"},{numRows:5,startRow:10,type:"delete"}]})),model:n})).render().$el.appendTo(d)}),w.describe("Fetching fragment",function(){w.beforeEach(function(){w.spyOn(n,"getRenderedDiffFragment").and.resolveTo("abc")}),w.it("Full chunk",function(){p.$(".tests-expand-chunk").click(),w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=n.getRenderedDiffFragment.calls.argsFor(0)[0];w.expect(e.chunkIndex).toBe(1),w.expect(e.linesOfContext).toBe(void 0)}),w.it("+20 above",function(){p.$(".tests-expand-above").click(),w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=n.getRenderedDiffFragment.calls.argsFor(0)[0];w.expect(e.chunkIndex).toBe(1),w.expect(e.linesOfContext).toBe("20,0")}),w.it("+20 below",function(){p.$(".tests-expand-below").click(),w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=n.getRenderedDiffFragment.calls.argsFor(0)[0];w.expect(e.chunkIndex).toBe(1),w.expect(e.linesOfContext).toBe("0,20")}),w.it("Function/class",function(){p.$(".tests-expand-header").click(),w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=n.getRenderedDiffFragment.calls.argsFor(0)[0];w.expect(e.chunkIndex).toBe(1),w.expect(e.linesOfContext).toBe("0,7")})}),w.describe("Injecting HTML",function(){w.it("Whole chunk",function(t){w.spyOn(n,"getRenderedDiffFragment").and.resolveTo(`<tbody class="equal tests-new-chunk">
 <tr line="6">
  <th></th>
  <td>
   <div class="collapse-floater">
    <div class="rb-c-diff-collapse-button"
         data-chunk-index="1"
         data-lines-of-context="0"></div>
   </div>
  </td>
  <th></th>
  <td></td>
 </tr>
</tbody>`),p.on("chunkExpansionChanged",()=>{w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=p.$("tbody");w.expect(e.length).toBe(3),w.expect($(e[0]).hasClass("equal")).toBe(!0),w.expect($(e[1]).hasClass("equal")).toBe(!0),w.expect($(e[1]).hasClass("tests-new-chunk")).toBe(!0),w.expect($(e[2]).hasClass("delete")).toBe(!0),w.expect(p._centered._elements.size).toBe(1),t()}),p.$(".tests-expand-chunk").click()}),w.it("Merging adjacent expanded chunks",function(t){w.spyOn(n,"getRenderedDiffFragment").and.resolveTo(`<tbody class="equal tests-new-chunk">
 <tr line="6">
  <th></th>
  <td>
   <div class="collapse-floater">
    <div class="rb-c-diff-collapse-button"
         data-chunk-index="1"
         data-lines-of-context="0"></div>
   </div>
  </td>
  <th></th>
  <td></td>
 </tr>
</tbody>`),p.on("chunkExpansionChanged",()=>{w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=p.$("tbody");w.expect(e.length).toBe(3),w.expect($(e[0]).hasClass("equal")).toBe(!0),w.expect($(e[1]).hasClass("equal")).toBe(!0),w.expect($(e[1]).hasClass("tests-new-chunk")).toBe(!0),w.expect($(e[2]).hasClass("delete")).toBe(!0),w.expect(p._centered._elements.size).toBe(1),t()}),$('<tbody class="equal loaded">').append($('<div class="rb-c-diff-collapse-button">')).insertAfter(p.$("tbody")[1]).clone().insertBefore(p.$("tbody")[1]),w.expect(p.$("tbody").length).toBe(5),p.$(".tests-expand-chunk").click()})})}),w.describe("Collapsing",function(){let i;w.beforeEach(function(){(p=new RB.DiffReviewableView({el:$(r({chunks:[{numRows:5,startRow:1,type:"equal"},{expanded:!0,numRows:2,startRow:6,type:"equal"},{numRows:5,startRow:10,type:"delete"}]})),model:n})).render().$el.appendTo(d),i=p.$(".rb-c-diff-collapse-button")}),w.it("Fetching fragment",function(t){w.spyOn(n,"getRenderedDiffFragment").and.resolveTo("abc"),p.on("chunkExpansionChanged",()=>{w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=n.getRenderedDiffFragment.calls.argsFor(0)[0];w.expect(e.chunkIndex).toBe(1),w.expect(e.linesOfContext).toBe(0),t()}),i.click()}),w.describe("Injecting HTML",function(){w.it("Single expanded chunk",function(t){w.spyOn(n,"getRenderedDiffFragment").and.resolveTo(`<tbody class="equal tests-new-chunk">
 <tr line="6">
  <th></th>
  <td></td>
  <th></th>
  <td></td>
 </tr>
</tbody>`),p.on("chunkExpansionChanged",()=>{w.expect(n.getRenderedDiffFragment).toHaveBeenCalled();var e=p.$("tbody");w.expect(e.length).toBe(3),w.expect($(e[0]).hasClass("equal")).toBe(!0),w.expect($(e[1]).hasClass("equal")).toBe(!0),w.expect($(e[1]).hasClass("tests-new-chunk")).toBe(!0),w.expect($(e[2]).hasClass("delete")).toBe(!0),w.expect(p._centered._elements.size).toBe(0),t()}),i.click()}),w.it("Merging adjacent expanded chunks",function(e){let t;w.spyOn(n,"getRenderedDiffFragment").and.resolveTo(`<tbody class="equal tests-new-chunk">
 <tr line="6">
  <th></th>
  <td></td>
  <th></th>
  <td></td>
 </tr>
</tbody>`),p.on("chunkExpansionChanged",()=>{w.expect(n.getRenderedDiffFragment).toHaveBeenCalled(),t=p.$("tbody"),w.expect(t.length).toBe(3),w.expect($(t[0]).hasClass("equal")).toBe(!0),w.expect($(t[1]).hasClass("equal")).toBe(!0),w.expect($(t[1]).hasClass("tests-new-chunk")).toBe(!0),w.expect($(t[2]).hasClass("delete")).toBe(!0),w.expect(p._centered._elements.size).toBe(0),e()}),$('<tbody class="equal loaded">').append($('<div class="rb-c-diff-collapse-button">')).insertAfter(p.$("tbody")[1]).clone().insertBefore(p.$("tbody")[1]),i.click()})})})}),w.describe("Comment flags",function(){w.describe("Placing visible comments",function(){const n=`<tbody class="equal tests-new-chunk">
 <tr line="11">
  <th></th>
  <td>
   <div class="collapse-floater">
    <div class="rb-c-diff-collapse-button"
         data-chunk-index="1"
         data-lines-of-context="0"></div>
   </div>
  </td>
  <th></th>
  <td></td>
 </tr>
</tbody>`;let o,a,s,c;w.beforeEach(function(){(p=new RB.DiffReviewableView({el:$(r({chunks:[{numRows:10,startRow:1,type:"insert"},{expandHeaderLines:7,type:"collapsed"}]})),model:new RB.DiffReviewable({reviewRequest:l,serializedCommentBlocks:{"11-1":[{comment_id:1,issue_opened:!1,line:11,localdraft:!1,num_lines:1,review_id:1,text:"Comment 4",user:{name:"testuser",username:"testuser"}}],"2-2":[{comment_id:1,issue_opened:!1,line:2,localdraft:!1,num_lines:2,review_id:1,text:"Comment 1",user:{name:"testuser",username:"testuser"}}],"4-1":[{comment_id:1,issue_opened:!1,line:4,localdraft:!1,num_lines:1,review_id:1,text:"Comment 2",user:{name:"testuser"}},{comment_id:1,issue_opened:!1,line:4,localdraft:!1,num_lines:1,review_id:1,text:"Comment 3",user:{name:"testuser",username:"testuser"}}]}})})).render().$el.appendTo(d),c=n,w.spyOn(p.model,"getRenderedDiffFragment").and.callFake(()=>Promise.resolve(c)),a=p.$(".commentflag"),s=p.$el.find("tbody tr")}),w.it("On initial render",function(){w.expect(a.length).toBe(2),w.expect($(a[0]).find(".commentflag-count").text()).toBe("1"),w.expect($(a[1]).find(".commentflag-count").text()).toBe("2"),o=$(s[1]).find(".commentflag"),w.expect(o.length).toBe(1),w.expect(o[0]).toBe(a[0]),w.expect(o.parents("tr").attr("line")).toBe("2"),o=$(s[3]).find(".commentflag"),w.expect(o.length).toBe(1),w.expect(o[0]).toBe(a[1]),w.expect(o.parents("tr").attr("line")).toBe("4")}),w.it("On chunk expand",function(e){w.expect(a.length).toBe(2),p.on("chunkExpansionChanged",()=>{a=p.$(".commentflag"),s=p.$el.find("tbody tr"),w.expect(a.length).toBe(3),w.expect($(a[2]).find(".commentflag-count").text()).toBe("1"),o=$(s[10]).find(".commentflag"),w.expect(o.length).toBe(1),w.expect(o[0]).toBe(a[2]),w.expect(o.parents("tr").attr("line")).toBe("11"),e()}),p.$(".tests-expand-chunk").click()}),w.it("On chunk re-expand (after collapsing)",function(e){const t=['<tbody class="diff-header">',$(p.$("tbody")[1]).html(),"</tbody>"].join("");w.expect(a.length).toBe(2);let i=0;p.on("chunkExpansionChanged",()=>{1===++i?(w.expect(p.$(".commentflag").length).toBe(3),c=t,p.$(".rb-c-diff-collapse-button").click()):2===i?(w.expect(p.$(".commentflag").length).toBe(2),c=n,p.$(".tests-expand-chunk").click()):3===i?(w.expect(p.$(".commentflag").length).toBe(3),a=p.$(".commentflag"),s=p.$el.find("tbody tr"),w.expect(a.length).toBe(3),w.expect($(a[2]).find(".commentflag-count").text()).toBe("1"),o=$(s[10]).find(".commentflag"),w.expect(o.length).toBe(1),w.expect(o[0]).toBe(a[2]),w.expect(o.parents("tr").attr("line")).toBe("11"),e()):e.fail()}),p.$(".tests-expand-chunk").click()})})}),w.describe("Events",function(){w.describe("Toggle Displayed Unicode Characters",function(){let t;w.beforeEach(function(){var e=(p=new RB.DiffReviewableView({el:$(r({chunks:[{extraClass:"whitespace-chunk",numRows:5,startRow:1,type:"replace"}],fileAlertHTML:""})),model:new RB.DiffReviewable({reviewRequest:l})})).render().$el;$(i({contentHTML:`<button class="rb-o-toggle-ducs"
        data-hide-chars-label="Hide chars"
        data-show-chars-label="Show chars">
</button>`})).insertBefore(e[0].tHead),e.appendTo(d),t=p.$(".rb-o-toggle-ducs"),w.expect(t.length).toBe(1)}),w.it("Show Displayed Unicode Characters",function(){t.text("Hide chars").click(),w.expect(p.el).toHaveClass("-hide-ducs"),w.expect(t.text()).toBe("Show chars")}),w.it("Hide Displayed Unicode Characters",function(){p.$el.addClass("-hide-ducs"),t.text("Show chars").click(),w.expect(p.el).not.toHaveClass("-hide-ducs"),w.expect(t.text()).toBe("Hide chars")})})}),w.describe("Methods",function(){w.describe("toggleWhitespaceOnlyChunks",function(){w.beforeEach(function(){(p=new RB.DiffReviewableView({el:$(r({chunks:[{extraClass:"whitespace-chunk",numRows:5,startRow:1,type:"replace"}]})),model:new RB.DiffReviewable({reviewRequest:l})})).render().$el.appendTo(d)}),w.describe("Toggle on",function(){w.it("Chunk classes",function(){p.toggleWhitespaceOnlyChunks();var e=p.$("tbody"),e=$(e[0]),t=e.children();w.expect(e.hasClass("replace")).toBe(!1),w.expect($(t[0]).hasClass("first")).toBe(!0),w.expect($(t[t.length-1]).hasClass("last")).toBe(!0)}),w.it("chunkDimmed event triggered",function(){w.spyOn(p,"trigger"),p.toggleWhitespaceOnlyChunks(),w.expect(p.trigger).toHaveBeenCalledWith("chunkDimmed","0.0")}),w.it("Whitespace-only file classes",function(){var e=p.$el.children("tbody"),t=$("<tbody>").addClass("whitespace-file").hide().html("<tr><td></td></tr>").appendTo(p.$el);w.expect(t.is(":visible")).toBe(!1),w.expect(e.is(":visible")).toBe(!0),p.toggleWhitespaceOnlyChunks(),w.expect(t.is(":visible")).toBe(!0),w.expect(e.is(":visible")).toBe(!1)})}),w.describe("Toggle off",function(){w.it("Chunk classes",function(){p.toggleWhitespaceOnlyChunks(),p.toggleWhitespaceOnlyChunks();var e=p.$("tbody"),e=$(e[0]),t=e.children();w.expect(e.hasClass("replace")).toBe(!0),w.expect($(t[0]).hasClass("first")).toBe(!1),w.expect($(t[t.length-1]).hasClass("last")).toBe(!1)}),w.it("chunkDimmed event triggered",function(){p.toggleWhitespaceOnlyChunks(),w.spyOn(p,"trigger"),p.toggleWhitespaceOnlyChunks(),w.expect(p.trigger).toHaveBeenCalledWith("chunkUndimmed","0.0")}),w.it("Whitespace-only file classes",function(){var e=p.$el.children("tbody"),t=$("<tbody>").addClass("whitespace-file").html("<tr><td></td></tr>").hide().appendTo(p.$el);w.expect(t.is(":visible")).toBe(!1),w.expect(e.is(":visible")).toBe(!0),p.toggleWhitespaceOnlyChunks(),p.toggleWhitespaceOnlyChunks(),w.expect(t.is(":visible")).toBe(!1),w.expect(e.is(":visible")).toBe(!0)})})})})}),e.suite("rb/pages/views/DiffViewerPageView",function(){function n(e,t){return function(e){return w.expect(e).toBe(e),{done(e){e(t)}}}}const e=_.template(`<div class="diff-container">
 <table class="sidebyside">
  <thead>
   <tr class="filename-row">
    <th colspan="4">
     <a name="<%- fileID %>" class="file-anchor"></a>
    </th>
   </tr>
  </thead>
  <% _.each(chunks, function(chunk) { %>
   <tbody class="<%- chunk.type %>">
    <% _.each(chunk.lines, function(line, i) { %>
     <tr line="<%- line.vNumber %>">
      <th>
       <% if (i === 0 && chunk.type !== "equal") { %>
        <a name="<%- chunk.id %>" class="chunk-anchor"></a>
       <% } %>
       <%- line.leftNumber || "" %>
      </th>
      <td class="l"></td>
      <th><%- line.rightNumber || "" %></th>
      <td class="r"></td>
     </tr>
    <% }); %>
   </tbody>
  <% }); %>
 </table>
</div>`),t=`<div>
 <div id="review-banner">
  <div class="banner">
   <h1>You have a pending review.</h1>
   <input id="review-banner-edit" type="button"
          value="Edit Review">
   <div id="review-banner-publish-container"></div>
   <input id="review-banner-discard" type="button"
          value="Discard">
  </div>
 </div>
 <div id="unified-banner">
  <div class="rb-c-unified-banner__mode-selector"></div>
  <div class="rb-c-unified-banner__dock"></div>
 </div>
 <div id="diff_commit_list">
  <div class="commit-list-container"></div>
 </div>
 <div id="view_controls"></div>
 <div id="diffs"></div>
</div>`;let o,a,i;function s(e={}){e=(o=new RB.DiffViewerPage(_.extend({checkForUpdates:!1,editorData:{mutableByUser:!0,statusMutableByUser:!0},pagination:{current_page:1},reviewRequestData:{id:123,loaded:!0,state:RB.ReviewRequest.PENDING},revision:{interdiff_revision:null,is_interdiff:!1,revision:1}},e),{parse:!0})).get("reviewRequest");w.spyOn(e,"ready").and.resolveTo(),w.spyOn(e.draft,"ready").and.resolveTo(),w.spyOn(o.get("pendingReview"),"ready").and.resolveTo(),(a=new RB.DiffViewerPageView({el:$(t).appendTo($testsScratch),model:o})).render()}w.beforeEach(function(){w.spyOn(window.history,"pushState"),w.spyOn(window.history,"replaceState"),w.spyOn(RB.HeaderView.prototype,"_ensureSingleton"),w.spyOn(RB,"navigateTo"),w.spyOn($,"cookie"),RB.UserSession.instance.set("canToggleExtraWhitespace",!1),RB.UserSession.instance.set("diffsShowExtraWhitespace",!0)}),w.afterEach(function(){RB.DnDUploader.instance=null,RB.EnabledFeatures.unifiedBanner&&RB.UnifiedBannerView.resetInstance(),a&&(a.remove(),a=null),Backbone.history.stop()}),w.describe("Diff view buttons",function(){w.describe("Initial state",function(){w.it("Defaults",function(){s(),w.expect(o.get("allChunksCollapsed")).toBeFalse(),w.expect(o.get("canToggleExtraWhitespace")).toBeFalse();var e=a.$("#view_controls button");w.expect(e.length).toBe(2);let t=e.eq(0);w.expect(t.attr("id")).toBe("action-diff-toggle-collapse-changes"),w.expect(t.text().trim()).toBe("Collapse changes"),w.expect(t.attr("title")).toBe("All lines of the files are being shown. Toggle to collapse down to only modified sections instead."),t=e.eq(1),w.expect(t.attr("id")).toBe("action-diff-toggle-whitespace-only"),w.expect(t.text().trim()).toBe("Hide whitespace-only changes"),w.expect(t.attr("title")).toBe("Sections of the diff containing only whitespace changes are being shown. Toggle to hide those instead.")}),w.it("With allChunksCollapsed=true",function(){s({allChunksCollapsed:!0}),w.expect(o.get("allChunksCollapsed")).toBeTrue(),w.expect(o.get("canToggleExtraWhitespace")).toBeFalse();var e=a.$("#view_controls button");w.expect(e.length).toBe(2);let t=e.eq(0);w.expect(t.attr("id")).toBe("action-diff-toggle-collapse-changes"),w.expect(t.text().trim()).toBe("Expand changes"),w.expect(t.attr("title")).toBe("Only modified sections of the files are being shown. Toggle to show all lines instead."),t=e.eq(1),w.expect(t.attr("id")).toBe("action-diff-toggle-whitespace-only"),w.expect(t.text().trim()).toBe("Hide whitespace-only changes"),w.expect(t.attr("title")).toBe("Sections of the diff containing only whitespace changes are being shown. Toggle to hide those instead.")}),w.it("With canToggleExtraWhitespace=true",function(){s({canToggleExtraWhitespace:!0}),w.expect(o.get("allChunksCollapsed")).toBeFalse(),w.expect(o.get("canToggleExtraWhitespace")).toBeTrue();var e=a.$("#view_controls button");w.expect(e.length).toBe(3);let t=e.eq(0);w.expect(t.attr("id")).toBe("action-diff-toggle-collapse-changes"),w.expect(t.text().trim()).toBe("Collapse changes"),w.expect(t.attr("title")).toBe("All lines of the files are being shown. Toggle to collapse down to only modified sections instead."),t=e.eq(1),w.expect(t.attr("id")).toBe("action-diff-toggle-extra-whitespace"),w.expect(t.text().trim()).toBe("Hide extra whitespace"),w.expect(t.attr("title")).toBe("Mismatched indentation and trailing whitespace are being shown. Toggle to hide instead."),t=e.eq(2),w.expect(t.attr("id")).toBe("action-diff-toggle-whitespace-only"),w.expect(t.text().trim()).toBe("Hide whitespace-only changes"),w.expect(t.attr("title")).toBe("Sections of the diff containing only whitespace changes are being shown. Toggle to hide those instead.")}),w.it("With canToggleExtraWhitespace=true and diffsShowExtraWhitespace=true",function(){RB.UserSession.instance.set("diffsShowExtraWhitespace",!0),s({canToggleExtraWhitespace:!0}),w.expect(o.get("allChunksCollapsed")).toBeFalse(),w.expect(o.get("canToggleExtraWhitespace")).toBeTrue();var e=a.$("#view_controls button");w.expect(e.length).toBe(3);let t=e.eq(0);w.expect(t.attr("id")).toBe("action-diff-toggle-collapse-changes"),w.expect(t.text().trim()).toBe("Collapse changes"),w.expect(t.attr("title")).toBe("All lines of the files are being shown. Toggle to collapse down to only modified sections instead."),t=e.eq(1),w.expect(t.attr("id")).toBe("action-diff-toggle-extra-whitespace"),w.expect(t.text().trim()).toBe("Hide extra whitespace"),w.expect(t.attr("title")).toBe("Mismatched indentation and trailing whitespace are being shown. Toggle to hide instead."),t=e.eq(2),w.expect(t.attr("id")).toBe("action-diff-toggle-whitespace-only"),w.expect(t.text().trim()).toBe("Hide whitespace-only changes"),w.expect(t.attr("title")).toBe("Sections of the diff containing only whitespace changes are being shown. Toggle to hide those instead.")})}),w.describe("Actions",function(){w.it("Collapse changes",function(){s({allChunksCollapsed:!1});var e=a.$("#action-diff-toggle-collapse-changes");w.expect(e.length).toBe(1),w.expect(e.text().trim()).toBe("Collapse changes"),e.click(),w.expect(RB.navigateTo).toHaveBeenCalledWith(".?collapse=1"),w.expect(e.text().trim()).toBe("Expand changes")}),w.it("Expand changes",function(){s({allChunksCollapsed:!0});var e=a.$("#action-diff-toggle-collapse-changes");w.expect(e.length).toBe(1),w.expect(e.text().trim()).toBe("Expand changes"),e.click(),w.expect(RB.navigateTo).toHaveBeenCalledWith(".?expand=1"),w.expect(e.text().trim()).toBe("Collapse changes")}),w.it("Show extra whitespace",function(){RB.UserSession.instance.set("diffsShowExtraWhitespace",!1),s({canToggleExtraWhitespace:!0});var e=a.$("#action-diff-toggle-extra-whitespace");w.expect(e.length).toBe(1),w.expect(e.text().trim()).toBe("Show extra whitespace"),e.click(),w.expect(RB.UserSession.instance.get("diffsShowExtraWhitespace")).toBeTrue(),w.expect(e.text().trim()).toBe("Hide extra whitespace")}),w.it("Hide extra whitespace",function(){RB.UserSession.instance.set("diffsShowExtraWhitespace",!0),s({canToggleExtraWhitespace:!0});var e=a.$("#action-diff-toggle-extra-whitespace");w.expect(e.length).toBe(1),w.expect(e.text().trim()).toBe("Hide extra whitespace"),e.click(),w.expect(RB.UserSession.instance.get("diffsShowExtraWhitespace")).toBeFalse(),w.expect(e.text().trim()).toBe("Show extra whitespace")}),w.it("Show whitespace-only changes",function(){s();var e=new RB.DiffReviewableView,t=(w.spyOn(e,"toggleWhitespaceOnlyChunks"),a._diffReviewableViews=[e],a.$("#action-diff-toggle-whitespace-only"));w.expect(t.length).toBe(1),w.expect(t.text().trim()).toBe("Hide whitespace-only changes"),t.click(),w.expect(e.toggleWhitespaceOnlyChunks).toHaveBeenCalled(),w.expect(t.text().trim()).toBe("Show whitespace-only changes"),t.click(),w.expect(e.toggleWhitespaceOnlyChunks).toHaveBeenCalled(),w.expect(t.text().trim()).toBe("Hide whitespace-only changes")}),w.it("Hide whitespace-only changes",function(){s();var e=new RB.DiffReviewableView,t=(w.spyOn(e,"toggleWhitespaceOnlyChunks"),a._diffReviewableViews=[e],a.$("#action-diff-toggle-whitespace-only"));w.expect(t.length).toBe(1),w.expect(t.text().trim()).toBe("Hide whitespace-only changes"),t.click(),w.expect(e.toggleWhitespaceOnlyChunks).toHaveBeenCalled(),w.expect(t.text().trim()).toBe("Show whitespace-only changes")})})}),w.describe("Without commits",function(){w.beforeEach(function(){s({canToggleExtraWhitespace:!0}),i=a.$el.children("#diffs")}),w.describe("Anchors",function(){w.it("Tracks all types",function(){i.html(e({chunks:[{id:"1.1",lines:[{leftNumber:100,rightNumber:101,type:"insert",vNumber:100}]},{id:"1.2",lines:[{leftNumber:101,rightNumber:101,type:"equal",vNumber:101}]},{id:"1.3",lines:[{leftNumber:102,rightNumber:101,type:"delete",vNumber:102}]}],fileID:"file1"})),a._updateAnchors(a.$el.find("table").eq(0)),w.expect(a._$anchors.length).toBe(4),w.expect(a._$anchors[0].name).toBe("file1"),w.expect(a._$anchors[1].name).toBe("1.1"),w.expect(a._$anchors[2].name).toBe("1.2"),w.expect(a._$anchors[3].name).toBe("1.3"),w.expect(a._selectedAnchorIndex).toBe(0)}),w.describe("Navigation",function(){w.beforeEach(function(){i.html([e({chunks:[{id:"1.1",lines:[{leftNumber:100,rightNumber:101,type:"insert",vNumber:100}]},{id:"1.2",lines:[{leftNumber:101,rightNumber:101,type:"equal",vNumber:101}]}],fileID:"file1"}),e({chunks:[],fileID:"file2"}),e({chunks:[{id:"2.1",lines:[{leftNumber:100,rightNumber:101,type:"insert",vNumber:100}]},{id:"2.2",lines:[{leftNumber:101,rightNumber:101,type:"equal",vNumber:101}]}],fileID:"file3"})]),a.$el.find("table").each(function(){a._updateAnchors($(this))})}),w.describe("Previous file",function(){w.it("From file",function(){a.selectAnchorByName("file2"),w.expect(a._selectedAnchorIndex).toBe(3),a._selectPreviousFile(),w.expect(a._selectedAnchorIndex).toBe(0)}),w.it("From chunk",function(){a.selectAnchorByName("2.2"),w.expect(a._selectedAnchorIndex).toBe(6),a._selectPreviousFile(),w.expect(a._selectedAnchorIndex).toBe(4)}),w.it("On first file",function(){a.selectAnchorByName("file1"),w.expect(a._selectedAnchorIndex).toBe(0),a._selectPreviousFile(),w.expect(a._selectedAnchorIndex).toBe(0)})}),w.describe("Next file",function(){w.it("From file",function(){a.selectAnchorByName("file1"),w.expect(a._selectedAnchorIndex).toBe(0),a._selectNextFile(),w.expect(a._selectedAnchorIndex).toBe(3)}),w.it("From chunk",function(){a.selectAnchorByName("1.1"),w.expect(a._selectedAnchorIndex).toBe(1),a._selectNextFile(),w.expect(a._selectedAnchorIndex).toBe(3)}),w.it("On last file",function(){a.selectAnchorByName("file3"),w.expect(a._selectedAnchorIndex).toBe(4),a._selectNextFile(),w.expect(a._selectedAnchorIndex).toBe(4)})}),w.describe("Previous anchor",function(){w.it("From file to file",function(){a.selectAnchorByName("file3"),w.expect(a._selectedAnchorIndex).toBe(4),a._selectPreviousDiff(),w.expect(a._selectedAnchorIndex).toBe(3)}),w.it("From file to chunk",function(){a.selectAnchorByName("file2"),w.expect(a._selectedAnchorIndex).toBe(3),a._selectPreviousDiff(),w.expect(a._selectedAnchorIndex).toBe(2)}),w.it("From chunk to file",function(){a.selectAnchorByName("2.1"),w.expect(a._selectedAnchorIndex).toBe(5),a._selectPreviousDiff(),w.expect(a._selectedAnchorIndex).toBe(4)}),w.it("From chunk to chunk",function(){a.selectAnchorByName("2.2"),w.expect(a._selectedAnchorIndex).toBe(6),a._selectPreviousDiff(),w.expect(a._selectedAnchorIndex).toBe(5)}),w.it("On first file",function(){a.selectAnchorByName("file1"),w.expect(a._selectedAnchorIndex).toBe(0),a._selectPreviousDiff(),w.expect(a._selectedAnchorIndex).toBe(0)})}),w.describe("Next anchor",function(){w.it("From file to file",function(){a.selectAnchorByName("file2"),w.expect(a._selectedAnchorIndex).toBe(3),a._selectNextDiff(),w.expect(a._selectedAnchorIndex).toBe(4)}),w.it("From file to chunk",function(){a.selectAnchorByName("file1"),w.expect(a._selectedAnchorIndex).toBe(0),a._selectNextDiff(),w.expect(a._selectedAnchorIndex).toBe(1)}),w.it("From chunk to file",function(){a.selectAnchorByName("1.2"),w.expect(a._selectedAnchorIndex).toBe(2),a._selectNextDiff(),w.expect(a._selectedAnchorIndex).toBe(3)}),w.it("From chunk to chunk",function(){a.selectAnchorByName("2.1"),w.expect(a._selectedAnchorIndex).toBe(5),a._selectNextDiff(),w.expect(a._selectedAnchorIndex).toBe(6)}),w.it("On last chunk",function(){a.selectAnchorByName("2.2"),w.expect(a._selectedAnchorIndex).toBe(6),a._selectNextDiff(),w.expect(a._selectedAnchorIndex).toBe(6)})})})}),w.describe("Key bindings",function(){function e(e,n,t){w.describe(e,function(){t.forEach(e=>{let t,i;i=2===e.length?(t=e[0],e[1]):(t="'"+e+"'",e),w.it(t,function(){var e,t;w.spyOn(a,n),e=i,(t=$.Event("keypress")).which=e.charCodeAt(0),a.$el.trigger(t),w.expect(a[n]).toHaveBeenCalled()})})})}e("Previous file","_selectPreviousFile",["a","A","K","P","<","m"]),e("Next file","_selectNextFile",["f","F","J","N",">"]),e("Previous anchor","_selectPreviousDiff",["s","S","k","p",","]),e("Next anchor","_selectNextDiff",["d","D","j","n","."]),e("Previous comment","_selectPreviousComment",["[","x"]),e("Next comment","_selectNextComment",["]","c"]),e("Recenter selected","_recenterSelected",[["Enter","\r"]]),e("Create comment","_createComment",["r","R"])}),w.describe("Reviewable Management",function(){w.beforeEach(function(){w.spyOn(a,"queueLoadDiff")}),w.it("File added",function(){w.expect(i.find(".diff-container").length).toBe(0),w.expect(a.queueLoadDiff.calls.count()).toBe(0),o.files.reset([new RB.DiffFile({filediff:{id:200,revision:1},id:100})]),w.expect(i.find(".diff-container").length).toBe(1),w.expect(a.queueLoadDiff.calls.count()).toBe(1)}),w.it("Files reset",function(){w.expect(i.find(".diff-container").length).toBe(0),w.expect(a.queueLoadDiff.calls.count()).toBe(0),o.files.reset([new RB.DiffFile({filediff:{id:200,revision:1},id:100})]),w.expect(i.find(".diff-container").length).toBe(1),w.expect(a.queueLoadDiff.calls.count()).toBe(1),o.files.reset([new RB.DiffFile({filediff:{id:201,revision:2},id:101})]);var e=i.find(".diff-container");w.expect(e.length).toBe(1),w.expect(e.find(".sidebyside")[0].id).toBe("file_container_101"),w.expect(a.queueLoadDiff.calls.count()).toBe(2)})}),w.describe("Page view/URL state",function(){let t;w.beforeEach(function(){w.spyOn(o,"loadDiffRevision"),w.spyOn(Backbone.history,"matchRoot").and.returnValue(!0),t=a.router,w.spyOn(t,"navigate").and.callFake((e,t)=>{t&&!1===t.trigger||Backbone.history.loadUrl(e)})}),w.describe("Initial URL",function(){w.it("Initial default load",function(){a._setInitialURL("","index_header"),w.expect(t.navigate).toHaveBeenCalledWith("1/#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()}),w.it("Initial load of first page explicit",function(){a._setInitialURL("?page=1","index_header"),w.expect(t.navigate).toHaveBeenCalledWith("1/?page=1#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()}),w.it("Initial load of page > 1",function(){a._setInitialURL("?page=2","index_header"),w.expect(t.navigate).toHaveBeenCalledWith("1/?page=2#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()}),w.it("Initial load of interdiff",function(){o.revision.set("revision",2),o.revision.set("interdiffRevision",3),a._setInitialURL("?page=2","index_header"),w.expect(t.navigate).toHaveBeenCalledWith("2-3/?page=2#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()}),w.it("Initial load with filename patterns",function(){a._setInitialURL("?filenames=*.js,src/*","index_header"),w.expect(t.navigate).toHaveBeenCalledWith("1/?filenames=*.js,src/*#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()})}),w.describe("_navigate",function(){w.beforeEach(function(){o.set("filenamePatterns","*.js,src/*")}),w.it("With page == 1",function(){a._navigate({page:1}),w.expect(t.navigate).toHaveBeenCalledWith("1/?filenames=*.js%2Csrc%2F*",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:1,revision:1,tipCommitID:null})}),w.it("With page > 1",function(){a._navigate({page:2}),w.expect(t.navigate).toHaveBeenCalledWith("1/?page=2&filenames=*.js%2Csrc%2F*",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:2,revision:1,tipCommitID:null})}),w.it("New revision on page > 1",function(){o.pagination.set("currentPage",2),a._onRevisionSelected([0,2]),w.expect(t.navigate).toHaveBeenCalledWith("2/?filenames=*.js%2Csrc%2F*",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:1,revision:2,tipCommitID:null})}),w.it("Same revision on page > 1",function(){o.pagination.set("currentPage",2),a._navigate({revision:1}),w.expect(t.navigate).toHaveBeenCalledWith("1/?page=2&filenames=*.js%2Csrc%2F*",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:2,revision:1,tipCommitID:null})}),w.it("With updateURLOnly",function(){o.pagination.set("currentPage",2),a._navigate({interdiffRevision:3,revision:2,updateURLOnly:!0}),w.expect(t.navigate).toHaveBeenCalledWith("2-3/?filenames=*.js%2Csrc%2F*",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()}),w.it("With anchor",function(){a._navigate({anchor:"test"}),w.expect(t.navigate).toHaveBeenCalledWith("1/?filenames=*.js%2Csrc%2F*#test",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:1,revision:1,tipCommitID:null})})}),w.describe("Revision selector",function(){w.describe("New diff revision selected",function(){w.it("From single revision",function(){a._onRevisionSelected([0,2]),w.expect(t.navigate).toHaveBeenCalledWith("2/",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:2,tipCommitID:null})}),w.it("From interdiff revision",function(){o.revision.set("interdiffRevision",2),a._onRevisionSelected([0,2]),w.expect(t.navigate).toHaveBeenCalledWith("2/",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:2,tipCommitID:null})})}),w.it("New interdiff revision selected",function(){a._onRevisionSelected([2,5]),w.expect(t.navigate).toHaveBeenCalledWith("2-5/",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:5,page:1,revision:2,tipCommitID:null})})}),w.describe("Page selector",function(){w.it("With page == 1",function(){a._onPageSelected(!0,1),w.expect(t.navigate).toHaveBeenCalledWith("1/",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null})}),w.it("With page > 1",function(){a._onPageSelected(!0,2),w.expect(t.navigate).toHaveBeenCalledWith("1/?page=2",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:2,revision:1,tipCommitID:null})}),w.it("With commit range",()=>{o.revision.set("baseCommitID",1),o.revision.set("tipCommitID",3),a._onPageSelected(!0,2),w.expect(t.navigate).toHaveBeenCalledWith("1/?page=2&base-commit-id=1&tip-commit-id=3",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:1,filenamePatterns:null,interdiffRevision:null,page:2,revision:1,tipCommitID:3})})}),w.it("Anchor selection",function(){var e=$('<a name="test">');a.selectAnchor(e),w.expect(t.navigate).toHaveBeenCalledWith("1/#test",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()})})}),w.describe("With commits",function(){let i;w.beforeEach(function(){o=new RB.DiffViewerPage({checkForUpdates:!1,commits:[{author_name:"Author Name",commit_id:"r123",commit_message:"Commit message 1",id:1,parent_id:"r122"},{author_name:"Author Name",commit_id:"r124",commit_message:"Commit message 2",id:2,parent_id:"r123"},{author_name:"Author Name",commit_id:"r125",commit_message:"Commit message 3",id:3,parent_id:"r124"}],editorData:{mutableByUser:!0,statusMutableByUser:!0},pagination:{current_page:1},reviewRequestData:{id:123,loaded:!0,state:RB.ReviewRequest.PENDING},revision:{interdiff_revision:null,is_interdiff:!1,revision:1}},{parse:!0}),a=new RB.DiffViewerPageView({el:$(t).appendTo($testsScratch),model:o}),i=$testsScratch.find("#diff_commit_list");var e=o.get("reviewRequest");w.spyOn(e,"ready").and.resolveTo(),w.spyOn(e.draft,"ready").and.resolveTo(),w.spyOn(o.get("pendingReview"),"ready").and.resolveTo()}),w.describe("Render",function(){w.it("Initial render (without interdiff)",function(){a.render();var e=i.find("table");w.expect(e.length).toBe(1),w.expect(e.find("tbody tr").length).toBe(3)}),w.it("Initial render (with interdiff)",function(){o.revision.set("interdiffRevision",456),o.commitHistoryDiff.reset([{entry_type:RB.CommitHistoryDiffEntry.REMOVED,old_commit_id:1},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:2},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:3}],{parse:!0}),a.render();var e=i.find("table");w.expect(e.length).toBe(1),w.expect(e.find("tbody tr").length).toBe(3)}),w.it("Subsequent render (without interdiff)",function(){a.render(),w.spyOn($,"ajax").and.callFake(n(0,{diff_context:{commits:[{author_name:"Author Name",commit_id:"r125",commit_message:"Commit message",id:4,parent_id:"r124"}],revision:{interdiff_revision:null,is_interdiff:!1,revision:2}}})),o.loadDiffRevision({revision:2}),w.expect($.ajax).toHaveBeenCalled();var e=i.find("table");w.expect(e.length).toBe(1),w.expect(e.find("tbody tr").length).toBe(1)}),w.it("Subsequent render (with interdiff)",function(){a.render();var e={diff_context:{commit_history_diff:[{entry_type:RB.CommitHistoryDiffEntry.REMOVED,old_commit_id:1},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:2}],commits:[{author_name:"Author Name",commit_id:"r124",commit_message:"Commit message",id:1},{author_name:"Author Name",commit_id:"r125",commit_message:"Commit message",id:2}],revision:{interdiff_revision:3,is_interdiff:!0,revision:2}}},e=(w.spyOn($,"ajax").and.callFake(n(0,e)),o.loadDiffRevision({interdiffRevision:3,revision:2}),w.expect($.ajax).toHaveBeenCalled(),i.find("table"));w.expect(e.length).toBe(1),w.expect(e.find("tbody tr").length).toBe(2)}),w.it("Initial render with base commit ID",function(){o.revision.set("baseCommitID",1),a.render();var e=a._commitListView.model;w.expect(e.get("baseCommitID")).toBe(1),w.expect(e.get("tipCommitID")).toBe(null)}),w.it("Initial render with tip commit ID",function(){o.revision.set("tipCommitID",2),a.render();var e=a._commitListView.model;w.expect(e.get("baseCommitID")).toBe(null),w.expect(e.get("tipCommitID")).toBe(2)}),w.it("Initial render with base commit ID and tip commit ID",function(){o.revision.set({baseCommitID:1,tipCommitID:2}),a.render();var e=a._commitListView.model;w.expect(e.get("baseCommitID")).toBe(1),w.expect(e.get("tipCommitID")).toBe(2)})}),w.describe("Page view/URL state",function(){w.beforeEach(function(){w.spyOn(o,"loadDiffRevision").and.callThrough(),w.spyOn(Backbone.history,"matchRoot").and.returnValue(!0),w.spyOn(a.router,"navigate").and.callFake((e,t)=>{t&&!1===t.trigger||Backbone.history.loadUrl(e)})}),w.describe("Initial URL",function(){w.it("With base-commit-id",function(){a._setInitialURL("?base-commit-id=2","index_header"),w.expect(a.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=2#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()}),w.it("With tip-commit-id",function(){a._setInitialURL("?tip-commit-id=2","index_header"),w.expect(a.router.navigate).toHaveBeenCalledWith("1/?tip-commit-id=2#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()}),w.it("With base-commit-id and tip-commit-id",function(){a._setInitialURL("?base-commit-id=1&tip-commit-id=2","index_header"),w.expect(a.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=1&tip-commit-id=2#index_header",{replace:!0,trigger:!1}),w.expect(o.loadDiffRevision).not.toHaveBeenCalled()})}),w.describe("Commit range controls",function(){w.it("Selecting initial base commit ID",function(){a.render();var e=i.find("table"),t=e.find("tbody tr"),e=(w.expect(e.length).toBe(1),w.expect(t.length).toBe(3),w.spyOn($,"ajax").and.callFake(n(0,{diff_context:{revision:{base_commit_id:1,interdiff_revision:null,is_interdiff:!1,revision:1,tip_commit_id:null}}})),t.eq(1).find(".base-commit-selector").click(),w.expect(a.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=1",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:1,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null}),w.expect(o.revision.get("baseCommitID")).toBe(1),w.expect(o.revision.get("tipCommitID")).toBe(null),a._commitListView.model);w.expect(e.get("baseCommitID")).toBe(1),w.expect(e.get("tipCommitID")).toBe(null)}),w.it("Selecting initial tip commit ID",function(){a.render();var e=i.find("table"),t=e.find("tbody tr"),e=(w.expect(e.length).toBe(1),w.expect(t.length).toBe(3),w.spyOn($,"ajax").and.callFake(n(0,{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:!1,revision:1,tip_commit_id:2}}})),t.eq(1).find(".tip-commit-selector").click(),w.expect(a.router.navigate).toHaveBeenCalledWith("1/?tip-commit-id=2",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:2}),w.expect(o.revision.get("baseCommitID")).toBe(null),w.expect(o.revision.get("tipCommitID")).toBe(2),a._commitListView.model);w.expect(e.get("baseCommitID")).toBe(null),w.expect(e.get("tipCommitID")).toBe(2)}),w.it("Selecting new base commit ID",function(){o.revision.set("baseCommitID",3),a.render();var e=i.find("table"),t=e.find("tbody tr"),e=(w.expect(e.length).toBe(1),w.expect(t.length).toBe(3),w.spyOn($,"ajax").and.callFake(n(0,{diff_context:{revision:{base_commit_id:1,interdiff_revision:null,is_interdiff:!1,revision:1,tip_commit_id:null}}})),t.eq(1).find(".base-commit-selector").click(),w.expect(a.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=1",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:1,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null}),w.expect(o.revision.get("baseCommitID")).toBe(1),w.expect(o.revision.get("tipCommitID")).toBe(null),a._commitListView.model);w.expect(e.get("baseCommitID")).toBe(1),w.expect(e.get("tipCommitID")).toBe(null)}),w.it("Selecting new tip commit ID",function(){o.revision.set("tipCommitID",2),a.render();var e=i.find("table"),t=e.find("tbody tr"),e=(w.expect(e.length).toBe(1),w.expect(t.length).toBe(3),w.spyOn($,"ajax").and.callFake(n(0,{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:!1,revision:1,tip_commit_id:1}}})),t.eq(0).find(".tip-commit-selector").click(),w.expect(a.router.navigate).toHaveBeenCalledWith("1/?tip-commit-id=1",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:1}),w.expect(o.revision.get("baseCommitID")).toBe(null),w.expect(o.revision.get("tipCommitID")).toBe(1),a._commitListView.model);w.expect(e.get("baseCommitID")).toBe(null),w.expect(e.get("tipCommitID")).toBe(1)}),w.it("Selecting blank base commit ID",function(){o.revision.set("baseCommitID",2),a.render();var e=i.find("table"),t=e.find("tbody tr"),e=(w.expect(e.length).toBe(1),w.expect(t.length).toBe(3),w.spyOn($,"ajax").and.callFake(n(0,{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:!1,revision:1,tip_commit_id:null}}})),t.eq(0).find(".base-commit-selector").click(),w.expect(a.router.navigate).toHaveBeenCalledWith("1/",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null}),w.expect(o.revision.get("baseCommitID")).toBe(null),w.expect(o.revision.get("tipCommitID")).toBe(null),a._commitListView.model);w.expect(e.get("baseCommitID")).toBe(null),w.expect(e.get("tipCommitID")).toBe(null)}),w.it("Selecting blank tip commit ID",function(){o.revision.set("tipCommitID",2),a.render();var e=i.find("table"),t=e.find("tbody tr"),e=(w.expect(e.length).toBe(1),w.expect(t.length).toBe(3),w.spyOn($,"ajax").and.callFake(n(0,{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:!1,revision:1,tip_commit_id:null}}})),t.eq(2).find(".tip-commit-selector").click(),w.expect(a.router.navigate).toHaveBeenCalledWith("1/",{trigger:!0}),w.expect(o.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null}),w.expect(o.revision.get("baseCommitID")).toBe(null),w.expect(o.revision.get("tipCommitID")).toBe(null),a._commitListView.model);w.expect(e.get("baseCommitID")).toBe(null),w.expect(e.get("tipCommitID")).toBe(null)})})})})}),e.suite("rb/views/FileAttachmentThumbnailView",function(){let a,s,c,r,l;w.beforeEach(function(){a=new RB.ReviewRequest,s=new RB.FileAttachment({downloadURL:"http://example.com/file.png",filename:"file.png"}),r=new RB.ReviewRequestEditor({reviewRequest:a}),l=new RB.ReviewRequestEditorView({model:r}),w.spyOn(s,"trigger").and.callThrough()}),w.describe("Rendering",function(){function t(){w.expect(c.$("a.edit").length).toBe(1),w.expect(c.$(".file-caption").length).toBe(1),w.expect(c.$(".file-actions").length).toBe(1),w.expect(c.$(".file-state-container").length).toBe(1),s.get("state")===RB.FileAttachmentStates.PENDING_DELETION?(w.expect(c.$(".file-undo-delete").length).toBe(c.options.canEdit&&s.get("loaded")?1:0),w.expect(c.$(".file-update").length).toBe(0)):(w.expect(c.$(".file-delete").length).toBe(c.options.canEdit&&s.get("loaded")?1:0),w.expect(c.$(".file-update").length).toBe(c.options.canEdit&&s.get("loaded")?1:0))}function e(){w.expect(c.$(".file-download").attr("href")).toBe(s.get("downloadURL")),w.expect(c.$(".file-caption .edit").text()).toBe(s.get("caption"))}w.it("Using existing elements",function(){var e=$("<div>").addClass(RB.FileAttachmentThumbnailView.prototype.className).html(RB.FileAttachmentThumbnailView.prototype.template(_.defaults({caption:"No caption",captionClass:"edit empty-caption"},s.attributes)));s.set("loaded",!0),c=new RB.FileAttachmentThumbnailView({el:e,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),t(),w.expect(c.$(".file-actions").is(":visible")).toBe(!0),w.expect(c.$(".djblets-o-spinner").length).toBe(0),w.expect(c.$(".file-state-container").html()).toEqual("")}),w.it("Rendered thumbnail with unloaded model",function(){c=new RB.FileAttachmentThumbnailView({model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),t(),w.expect(c.$(".file-actions").children().length).toBe(0),w.expect(c.$(".djblets-o-spinner").length).toBe(1),w.expect(c.$(".file-state-container").html()).toEqual("")}),w.describe("Rendered thumbnail with loaded model",function(){w.beforeEach(function(){s.id=123,s.attributes.id=123,s.set("attachmentHistoryID",1),s.set("caption","My Caption"),s.set("loaded",!0),s.url="/api/file-attachments/123/"}),w.it("With review UI",function(){s.set("reviewURL","/review/"),c=new RB.FileAttachmentThumbnailView({model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),t(),e(),w.expect(c.$(".file-actions").children().length).toBe(2),w.expect(c.$(".djblets-o-spinner").length).toBe(0),w.expect(c.$(".file-review").length).toBe(1),w.expect(c.$(".file-add-comment").length).toBe(0),w.expect(c.$(".file-state-container").html()).toEqual("")}),w.it("No review UI",function(){c=new RB.FileAttachmentThumbnailView({model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),t(),e(),w.expect(c.$(".file-actions").children().length).toBe(2),w.expect(c.$(".djblets-o-spinner").length).toBe(0),w.expect(c.$(".file-review").length).toBe(0),w.expect(c.$(".file-add-comment").length).toBe(1),w.expect(c.$(".file-state-container").html()).toEqual("")}),w.describe("With being able to edit",function(){w.it("With a published attachment",function(){s.set("state",RB.FileAttachmentStates.PUBLISHED),s.set("publishedCaption",s.get("caption")),c=new RB.FileAttachmentThumbnailView({canEdit:!0,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),t(),e(),w.expect(c.$(".file-actions").children().length).toBe(4),w.expect(c.$(".fa-spinner").length).toBe(0),w.expect(c.$(".file-review").length).toBe(0),w.expect(c.$(".file-add-comment").length).toBe(1),w.expect(c.$(".file-state-container").html()).toEqual(""),w.expect(c._captionEditorView).not.toBe(void 0),w.expect(c.$(".file-delete").text().trim()).toEqual("Delete")}),w.it("With a draft attachment",function(){s.set("state",RB.FileAttachmentStates.DRAFT),c=new RB.FileAttachmentThumbnailView({canEdit:!0,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),t(),e(),w.expect(c.$(".file-actions").children().length).toBe(4),w.expect(c.$(".fa-spinner").length).toBe(0),w.expect(c.$(".file-review").length).toBe(0),w.expect(c.$(".file-add-comment").length).toBe(1),w.expect(c.$(".file-state-container").html()).not.toEqual(""),w.expect(c._captionEditorView).not.toBe(void 0),w.expect(c.$(".file-delete").text().trim()).toEqual("Delete Draft")}),w.it("With an attachment pending deletion",function(){s.set("state",RB.FileAttachmentStates.PENDING_DELETION),c=new RB.FileAttachmentThumbnailView({canEdit:!0,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),t(),e(),w.expect(c.$(".file-actions").children().length).toBe(3),w.expect(c.$(".fa-spinner").length).toBe(0),w.expect(c.$(".file-review").length).toBe(0),w.expect(c.$(".file-add-comment").length).toBe(1),w.expect(c.$(".file-state-container").html()).not.toEqual(""),w.expect(c.$(".file-delete").length).toBe(0),w.expect(c.$(".file-undo-delete").length).toBe(1),w.expect(c._captionEditorView).toBe(void 0)})})})}),w.describe("Actions",function(){w.beforeEach(function(){s.id=123,s.attributes.id=123,s.set("loaded",!0),s.url="/api/file-attachments/123/",c=new RB.FileAttachmentThumbnailView({canEdit:!0,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),w.spyOn(c,"trigger").and.callThrough()}),w.it("Begin caption editing",function(){c._captionEditorView.startEdit(),w.expect(c.trigger).toHaveBeenCalledWith("beginEdit")}),w.it("Cancel caption editing",function(){c._captionEditorView.startEdit(),w.expect(c.trigger).toHaveBeenCalledWith("beginEdit"),c._captionEditorView.cancel(),w.expect(c.trigger).toHaveBeenCalledWith("endEdit")}),w.it("Save caption",function(e){w.spyOn(s,"save").and.callFake(()=>{w.expect(c.trigger).toHaveBeenCalledWith("endEdit"),w.expect(s.get("caption")).toBe("Foo"),w.expect(s.save).toHaveBeenCalled(),e()}),c._captionEditorView.startEdit(),w.expect(c.trigger).toHaveBeenCalledWith("beginEdit"),c.$("input").val("Foo").triggerHandler("keyup"),c._captionEditorView.submit()}),w.it("Save empty caption",function(e){w.spyOn(s,"save").and.callFake(()=>{w.expect(c.trigger).toHaveBeenCalledWith("endEdit"),w.expect(s.get("caption")).toBe(""),w.expect(s.save).toHaveBeenCalled(),e()}),c._captionEditorView.startEdit(),w.expect(c.trigger).toHaveBeenCalledWith("beginEdit"),c.$("input").val("").triggerHandler("keyup"),c._captionEditorView.submit()}),w.it("Delete",function(e){w.spyOn(s,"destroy").and.callThrough(),w.spyOn($,"ajax").and.callFake(e=>e.success()),w.spyOn(c.$el,"fadeOut").and.callFake(e=>e()),w.spyOn(c,"remove").and.callFake(()=>{w.expect($.ajax).toHaveBeenCalled(),w.expect(s.destroy).toHaveBeenCalled(),w.expect(s.trigger.calls.argsFor(2)[0]).toBe("destroying"),w.expect(c.$el.fadeOut).toHaveBeenCalled(),e()}),c.$(".file-delete").click()}),w.it("Delete a draft",function(){s.set("caption","New caption"),s.set("publishedCaption","Old Caption"),s.set("state",RB.FileAttachmentStates.DRAFT),c=new RB.FileAttachmentThumbnailView({canEdit:!0,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),w.spyOn(s,"destroy").and.callThrough(),w.spyOn(c,"_saveCaption").and.callFake(e=>(w.expect(e).toBe("Old Caption"),Promise.resolve())),w.spyOn($,"ajax").and.callFake(e=>e.success()),w.spyOn(c.$el,"fadeOut").and.callFake(e=>e()),w.spyOn(c,"_onDeleteClicked").and.callThrough(),c.$(".file-delete").click(),w.expect($.ajax).not.toHaveBeenCalled(),w.expect(s.destroy).not.toHaveBeenCalled(),w.expect(c.$el.fadeOut).not.toHaveBeenCalled()}),w.it("Undo a pending delete",function(){s.set("state",RB.FileAttachmentStates.PENDING_DELETION),c=new RB.FileAttachmentThumbnailView({canEdit:!0,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render(),w.spyOn(s,"url").and.callFake(()=>"/test-file-attachment/"),w.spyOn(RB,"apiCall").and.callFake(e=>e.success()),w.spyOn(c,"_onUndoDeleteClicked").and.callThrough(),c.$(".file-undo-delete").click(),w.expect(RB.apiCall).toHaveBeenCalled(),w.expect(s.get("state")).toBe(RB.FileAttachmentStates.PUBLISHED)})}),w.describe("addAction",function(){w.beforeEach(function(){s.id=123,s.attributes.id=123,s.set("loaded",!0),s.url="/api/file-attachments/123/",c=new RB.FileAttachmentThumbnailView({canEdit:!0,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),$testsScratch.append(c.$el),c.render()}),w.it("After the download action",function(){var e=c._$actions.children().length,t=(c.addAction("file-download","new-action",'<a href="#">New Action</a>'),c.$("li.new-action"));w.expect(t.length).toBe(1),w.expect(t.find("a").attr("href")).toBe("#"),w.expect(t.find("a").text()).toBe("New Action"),w.expect(t.parent().attr("class")).toEqual(c._$actions.attr("class")),w.expect(c._$actions.children().length).toBe(e+1),w.expect(t.prev().find("a").attr("class")).toEqual("file-download")}),w.it("After the delete action",function(){var e=c._$actions.children().length,t=(c.addAction("file-delete","new-action",'<a href="#">New Action</a>'),c.$("li.new-action"));w.expect(t.length).toBe(1),w.expect(t.find("a").attr("href")).toBe("#"),w.expect(t.find("a").text()).toBe("New Action"),w.expect(t.parent().attr("class")).toEqual(c._$actions.attr("class")),w.expect(c._$actions.children().length).toBe(e+1),w.expect(t.prev().attr("class")).toEqual("file-delete")}),w.it("After one that does not exist",function(){var e=c._$actions.children().length,t=(c.addAction("non-existing-action","new-action",'<a href="#">New Action</a>'),c.$("li.new-action"));w.expect(t.length).toBe(0),w.expect(c._$actions.children().length).toBe(e)}),w.it("With one that already exists",function(){var e=c._$actions.children().length;c.addAction("file-delete","new-action",'<a href="#">New Action</a>');let t=c.$("li.new-action");w.expect(t.length).toBe(1),w.expect(t.find("a").attr("href")).toBe("#"),w.expect(t.find("a").text()).toBe("New Action"),w.expect(t.parent().attr("class")).toEqual(c._$actions.attr("class")),w.expect(c._$actions.children().length).toBe(e+1),w.expect(t.prev().attr("class")).toEqual("file-delete"),c.addAction("file-delete","new-action",'<a href="link">Changed Action</a>'),t=c.$("li.new-action"),w.expect(t.length).toBe(1),w.expect(t.find("a").attr("href")).toBe("link"),w.expect(t.find("a").text()).toBe("Changed Action"),w.expect(t.parent().attr("class")).toEqual(c._$actions.attr("class")),w.expect(c._$actions.children().length).toBe(e+1),w.expect(t.prev().attr("class")).toEqual("file-delete")}),w.it("When another thumbnail for the same file exists",function(){var e=new RB.FileAttachmentThumbnailView({canEdit:!1,model:s,renderThumbnail:!0,reviewRequest:a,reviewRequestEditor:r,reviewRequestEditorView:l}),t=($testsScratch.append(e.$el),e.render(),c._$actions.children().length),i=e._$actions.children().length,n=(c.addAction("file-delete","new-action",'<a href="#">New Action</a>'),c.$("li.new-action")),o=e.$("li.new-action");w.expect(n.length).toBe(1),w.expect(n.find("a").attr("href")).toBe("#"),w.expect(n.find("a").text()).toBe("New Action"),w.expect(n.parent().attr("class")).toEqual(c._$actions.attr("class")),w.expect(c._$actions.children().length).toBe(t+1),w.expect(n.prev().attr("class")).toEqual("file-delete"),w.expect(o.length).toBe(0),w.expect(e._$actions.children().length).toBe(i)})})}),e.suite("rb/views/ReviewDialogView",function(){var e={links:{},stat:"ok",total_results:0};const l=_.defaults({diff_comments:[]},e),d=_.defaults({file_attachment_comments:[]},e),p=_.defaults({general_comments:[]},e),u=_.defaults({screenshot_comments:[]},e);e={id:1,issue_opened:!0,issue_status:"opened",text:"My comment"};const f=_.defaults({filediff:{dest_file:"my-file",id:1,source_file:"my-file",source_revision:"1"},first_line:10,interfilediff:{dest_file:"my-file",id:2,source_file:"my-file",source_revision:"2"},num_lines:5},e),m=_.defaults({extra_data:{},file_attachment:{filename:"file.txt",icon_url:"data:image/gif;base64,",id:10},link_text:"my-link-text",review_url:"/review-ui/",thumbnail_html:"<blink>Boo</blink>"},e),x=e,h=_.defaults({h:40,screenshot:{caption:"My caption",filename:"image.png",id:10,review_url:"/review-ui/"},thumbnail_url:"data:image/gif;base64,",w:30,x:10,y:20},e),t=RB.EnabledFeatures.generalComments;let B,g,v;async function b(){const t=RB.ReviewDialogView.create({container:$testsScratch,review:g,reviewRequestEditor:B});return new Promise(e=>{t.once("loadCommentsDone",()=>{e(t)})})}w.beforeEach(function(){const n=$.fn.move;var e=new RB.ReviewRequest({summary:"My Review Request"});RB.DnDUploader.create(),B=new RB.ReviewRequestEditor({reviewRequest:e}),g=new RB.Review({parentObject:e}),w.spyOn(g,"ready").and.resolveTo(),w.spyOn($.fn,"move").and.callFake(function(e,t,i){return"fixed"===i&&(i="absolute"),n.call(this,e,t,i)}),w.spyOn(RB.DiffFragmentQueueView.prototype,"queueLoad"),w.spyOn(RB.DiffFragmentQueueView.prototype,"loadFragments"),RB.EnabledFeatures.generalComments=!0}),w.afterEach(function(){RB.DnDUploader.instance=null,RB.ReviewDialogView.instance=null,RB.EnabledFeatures.generalComments=t}),w.describe("Class methods",function(){w.describe("create",function(){w.it("Without a review",function(){w.expect(()=>RB.ReviewDialogView.create({container:$testsScratch,reviewRequestEditor:B})).toThrow(),w.expect(RB.ReviewDialogView.instance).toBeFalsy(),w.expect($testsScratch.children().length).toBe(0)}),w.it("With a review",async function(){v=await b(),w.expect(v).toBeTruthy(),w.expect(RB.ReviewDialogView.instance).toBe(v),w.expect($testsScratch.children().length).toBe(2)}),w.it("With existing instance",async function(){v=await b();try{await b(),w.fail("Expected createReviewDialog to throw")}catch{}w.expect(RB.ReviewDialogView.instance).toBe(v),w.expect($testsScratch.children().length).toBe(2)})})}),w.describe("Instances",function(){w.describe("Methods",function(){w.it("close",async function(){v=await b(),w.expect($testsScratch.children().length).toBe(2),v.close(),w.expect($testsScratch.children().length).toBe(0),w.expect(RB.ReviewDialogView.instance).toBe(null)})}),w.describe("Loading",function(){w.it("With new review",async function(){w.expect(g.isNew()).toBe(!0),v=await b(),w.expect(v._bodyTopView.$editor.text()).toBe(""),w.expect(v._bodyBottomView.$editor.text()).toBe(""),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!1),w.expect(v._$shipIt.prop("checked")).toBe(!1),w.expect(v._$spinner).toBe(null)}),w.describe("With body and top text",function(){const e="My body bottom";w.beforeEach(function(){g.set({bodyBottom:e,bodyTop:"My body top",loaded:!0})}),w.it("Clearing body bottom hides footer",async function(){v=await b(),w.expect(v._bodyBottomView.$editor.text()).toBe(e),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!0),g.set("bodyBottom",""),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!1)})}),w.describe("With existing review",function(){const t="My body top",i="My body bottom";let n,o,a,s,c,r;w.beforeEach(function(){g.set({bodyBottom:i,bodyTop:t,id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},general_comments:{href:"/general-comments/"},screenshot_comments:{href:"/screenshot-comments/"},self:{href:"/reviews/42/"}},loaded:!0,shipIt:!0}),a=_.clone(l),s=_.clone(u),n=_.clone(d),o=_.clone(p),w.spyOn($,"ajax").and.callFake(e=>{"DELETE"===e.type?e.success({}):"/file-attachment-comments/"===e.url?e.success(n):"/diff-comments/"===e.url?e.success(a):"/screenshot-comments/"===e.url?e.success(s):"/general-comments/"===e.url&&e.success(o)})}),w.describe("Review properties",function(){function e(){return new Promise(e=>{(v=RB.ReviewDialogView.create({container:$testsScratch,review:g,reviewRequestEditor:B})).on("loadCommentsDone",()=>{w.expect(v._bodyTopView.$editor.text()).toBe(t),w.expect(v._bodyBottomView.$editor.text()).toBe(i),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!0),w.expect(v._$shipIt.prop("checked")).toBe(!0),w.expect(v.$(".review-comments .draft").length).toBe(2),w.expect(v._$spinner).toBe(null),e()})})}w.it("With defaultUseRichText=true",async function(){RB.UserSession.instance.set("defaultUseRichText",!0),await e(),w.expect(g.ready.calls.argsFor(0)[0].data).toEqual({"force-text-type":"html","include-text-types":"raw,markdown"})}),w.it("With defaultUseRichText=false",async function(){RB.UserSession.instance.set("defaultUseRichText",!1),await e(),w.expect(g.ready.calls.argsFor(0)[0].data).toEqual({"force-text-type":"html","include-text-types":"raw"})})}),w.describe("General comments",function(){w.it("Disabled",async function(){RB.EnabledFeatures.generalComments=!1;var e=(v=await b())._$buttons.find('input[value="Add General Comment"]');w.expect(e.length).toBe(0),w.expect($.ajax).toHaveBeenCalled(),w.expect($.ajax.calls.argsFor(0)[0].url).not.toBe("/general-comments/"),w.expect(v._commentViews.length).toBe(0)}),w.describe("Enabled",function(){async function t(){o.total_results=1,o.general_comments=[x];var e=(v=await b())._$buttons.find("button:first");w.expect(e.length).toBe(1),w.expect(e.text()).toBe("Add General Comment"),w.expect($.ajax).toHaveBeenCalled(),w.expect($.ajax.calls.argsFor(0)[0].url).toBe("/general-comments/"),r=$.ajax.calls.argsFor(0)[0].data,w.expect(v._commentViews.length).toBe(1),c=v._commentViews[0],w.expect(c.$editor.text()).toBe(x.text),w.expect(c.$issueOpened.prop("checked")).toBe(x.issue_opened),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!0),w.expect(v._$spinner).toBe(null)}w.it("With defaultUseRichText=true",async function(){RB.UserSession.instance.set("defaultUseRichText",!0),await t(),w.expect(r).toEqual({api_format:"json","force-text-type":"html","include-text-types":"raw,markdown","max-results":50})}),w.it("With defaultUseRichText=false",async function(){RB.UserSession.instance.set("defaultUseRichText",!1),await t(),w.expect(r).toEqual({api_format:"json","force-text-type":"html","include-text-types":"raw","max-results":50})}),w.it("Deleting comment",async function(){w.spyOn(window,"confirm").and.returnValue(!0),await t(),w.expect(v._generalCommentsCollection.length).toBe(1),w.spyOn(v._commentViews[0].$el,"fadeOut").and.callFake(e=>e.complete());var e=new Promise(e=>{v._generalCommentsCollection.at(0).once("destroyed",()=>e())});v.$(".delete-comment").click(),await e,w.expect(v._generalCommentsCollection.length).toBe(0)}),w.it("Deleting comment and cancelling",async function(){w.spyOn(window,"confirm").and.returnValue(!1),await t(),w.expect(v._generalCommentsCollection.length).toBe(1),v.$(".delete-comment").click(),w.expect(v._generalCommentsCollection.length).toBe(1)})})}),w.describe("Diff comments",function(){async function t(){var e=RB.DiffFragmentQueueView.prototype;a.total_results=1,a.diff_comments=[f],v=await b(),w.expect($.ajax).toHaveBeenCalled(),w.expect($.ajax.calls.argsFor(3)[0].url).toBe("/diff-comments/"),r=$.ajax.calls.argsFor(3)[0].data,w.expect(e.queueLoad.calls.count()).toBe(1),w.expect(e.loadFragments).toHaveBeenCalled(),w.expect(v._commentViews.length).toBe(1),c=v._commentViews[0],w.expect(c.$editor.text()).toBe(f.text),w.expect(c.$issueOpened.prop("checked")).toBe(f.issue_opened),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!0),w.expect(v._$spinner).toBe(null)}w.it("With defaultUseRichText=true",async function(){RB.UserSession.instance.set("defaultUseRichText",!0),await t(),w.expect(r).toEqual({api_format:"json",expand:"filediff,interfilediff","force-text-type":"html","include-text-types":"raw,markdown","max-results":50,"order-by":"filediff,first_line"})}),w.it("With defaultUseRichText=false",async function(){RB.UserSession.instance.set("defaultUseRichText",!1),await t(),w.expect(r).toEqual({api_format:"json",expand:"filediff,interfilediff","force-text-type":"html","include-text-types":"raw","max-results":50,"order-by":"filediff,first_line"})}),w.it("Deleting comment",async function(){w.spyOn(window,"confirm").and.returnValue(!0),await t(),w.expect(v._diffCommentsCollection.length).toBe(1),w.spyOn(v._commentViews[0].$el,"fadeOut").and.callFake(e=>e.complete());var e=new Promise(e=>{v._diffCommentsCollection.at(0).once("destroyed",()=>e())});v.$(".delete-comment").click(),await e,w.expect(v._diffCommentsCollection.length).toBe(0)}),w.it("Deleting comment and cancelling",async function(){w.spyOn(window,"confirm").and.returnValue(!1),await t(),w.expect(v._diffCommentsCollection.length).toBe(1),v.$(".delete-comment").click(),w.expect(v._diffCommentsCollection.length).toBe(1)})}),w.describe("File attachment comments",function(){async function t(){n.total_results=1,n.file_attachment_comments=[m],v=await b(),w.expect($.ajax).toHaveBeenCalled(),w.expect($.ajax.calls.argsFor(2)[0].url).toBe("/file-attachment-comments/"),r=$.ajax.calls.argsFor(2)[0].data,w.expect(v._commentViews.length).toBe(1),c=v._commentViews[0],w.expect(c.$editor.text()).toBe(m.text),w.expect(c.$issueOpened.prop("checked")).toBe(m.issue_opened),w.expect(c.$(".rb-c-review-comment-thumbnail__header").attr("href")).toBe(m.review_url),w.expect(c.$(".rb-c-review-comment-thumbnail__name").text()).toBe(m.link_text),w.expect(c.$(".rb-c-review-comment-thumbnail__content").html()).toBe(m.thumbnail_html),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!0),w.expect(v._$spinner).toBe(null)}w.it("With defaultUseRichText=true",async function(){RB.UserSession.instance.set("defaultUseRichText",!0),await t(),w.expect(r).toEqual({api_format:"json",expand:"diff_against_file_attachment,file_attachment","force-text-type":"html","include-text-types":"raw,markdown","max-results":50})}),w.it("With defaultUseRichText=false",async function(){RB.UserSession.instance.set("defaultUseRichText",!1),await t(),w.expect(r).toEqual({api_format:"json",expand:"diff_against_file_attachment,file_attachment","force-text-type":"html","include-text-types":"raw","max-results":50})}),w.it("Deleting comment",async function(){w.spyOn(window,"confirm").and.returnValue(!0),await t(),w.expect(v._fileAttachmentCommentsCollection.length).toBe(1),w.spyOn(v._commentViews[0].$el,"fadeOut").and.callFake(e=>e.complete());var e=new Promise(e=>{v._fileAttachmentCommentsCollection.at(0).once("destroyed",()=>e())});v.$(".delete-comment").click(),await e,w.expect(v._fileAttachmentCommentsCollection.length).toBe(0)}),w.it("Deleting comment and cancelling",async function(){w.spyOn(window,"confirm").and.returnValue(!1),await t(),w.expect(v._fileAttachmentCommentsCollection.length).toBe(1),v.$(".delete-comment").click(),w.expect(v._fileAttachmentCommentsCollection.length).toBe(1)})}),w.describe("Screenshot comments",function(){async function t(){s.total_results=1,s.screenshot_comments=[h],v=await b(),w.expect($.ajax).toHaveBeenCalled(),w.expect($.ajax.calls.argsFor(1)[0].url).toBe("/screenshot-comments/"),r=$.ajax.calls.argsFor(1)[0].data,w.expect(v._commentViews.length).toBe(1),c=v._commentViews[0],w.expect(c.$editor.text()).toBe(h.text),w.expect(c.$issueOpened.prop("checked")).toBe(h.issue_opened);var e=c.$("img");w.expect(e.attr("src")).toBe(h.thumbnail_url),w.expect(e.attr("width")).toBe(h.w.toString()),w.expect(e.attr("height")).toBe(h.h.toString()),w.expect(e.attr("alt")).toBe(h.screenshot.caption),w.expect(c.$(".rb-c-review-comment-thumbnail__header").attr("href")).toBe(h.screenshot.review_url),w.expect(c.$(".rb-c-review-comment-thumbnail__name").text()).toBe(h.screenshot.caption),w.expect(v._bodyBottomView.$el.is(":visible")).toBe(!0),w.expect(v._$spinner).toBe(null)}w.it("With defaultUseRichText=true",async function(){RB.UserSession.instance.set("defaultUseRichText",!0),await t(),w.expect(r).toEqual({api_format:"json",expand:"screenshot","force-text-type":"html","include-text-types":"raw,markdown","max-results":50})}),w.it("With defaultUseRichText=false",async function(){RB.UserSession.instance.set("defaultUseRichText",!1),await t(),w.expect(r).toEqual({api_format:"json",expand:"screenshot","force-text-type":"html","include-text-types":"raw","max-results":50})}),w.it("Deleting comment",async function(){w.spyOn(window,"confirm").and.returnValue(!0),await t(),w.expect(v._screenshotCommentsCollection.length).toBe(1),w.spyOn(v._commentViews[0].$el,"fadeOut").and.callFake(e=>e.complete());var e=new Promise(e=>{v._screenshotCommentsCollection.at(0).once("destroyed",()=>e())});v.$(".delete-comment").click(),await e,w.expect(v._screenshotCommentsCollection.length).toBe(0)}),w.it("Deleting comment and cancelling",async function(){w.spyOn(window,"confirm").and.returnValue(!1),await t(),w.expect(v._screenshotCommentsCollection.length).toBe(1),v.$(".delete-comment").click(),w.expect(v._screenshotCommentsCollection.length).toBe(1)})})})}),w.describe("Saving",function(){let t,i,n,o,a,s;async function e(e){var t="New comment text";v=await b(),w.expect(v._commentViews.length).toBe(1),a=v._commentViews[0],s=a.model,w.spyOn(s,"save").and.callFake(()=>(s.trigger("sync"),Promise.resolve())),a.inlineEditorView.startEdit(),a.inlineEditorView.setValue(t),a.textEditor.setRichText(e),await a.save(),w.expect(s.save).toHaveBeenCalled(),w.expect(s.get("text")).toBe(t),w.expect(s.get("richText")).toBe(e)}async function c(){var e='"><script>window.rbTestFoundXSS = true;<\/script>';delete window.rbTestFoundXSS,v=await b(),w.expect(v._commentViews.length).toBe(1),a=v._commentViews[0],s=a.model,w.spyOn(s,"save").and.callFake(()=>(s.trigger("sync"),Promise.resolve())),a.inlineEditorView.startEdit(),a.inlineEditorView.setValue(e),a.textEditor.setRichText(!0),await a.save(),w.expect(s.save).toHaveBeenCalled(),w.expect(s.get("text")).toBe(e),w.expect(window.rbTestFoundXSS).toBe(void 0)}w.beforeEach(function(){g.set({id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},general_comments:{href:"/general-comments/"},screenshot_comments:{href:"/screenshot-comments/"}},loaded:!0}),n=_.clone(l),o=_.clone(u),t=_.clone(d),i=_.clone(p),w.spyOn(g,"save").and.resolveTo(),w.spyOn($,"ajax").and.callFake(e=>{"/file-attachment-comments/"===e.url?e.success(t):"/diff-comments/"===e.url?e.success(n):"/screenshot-comments/"===e.url?e.success(o):"/general-comments/"===e.url&&e.success(i)})}),w.describe("Review properties",function(){function t(e,t){var i='"><script>window.rbTestFoundXSS = true;<\/script>',n=e.textEditor;delete window.rbTestFoundXSS,e.openEditor(),n.setText(i),n.setRichText(!0),e.save(),w.expect(n.getText()).toBe(i),w.expect(g.save).toHaveBeenCalled(),w.expect(g.get(t)).toBe(i),w.expect(window.rbTestFoundXSS).toBe(void 0)}w.beforeEach(async function(){v=await b()}),w.describe("Body Top",function(){function e(e){var t="My new text",i=v._bodyTopView.textEditor;v._bodyTopView.openEditor(),i.setText(t),i.setRichText(e),v._bodyTopView.save(),w.expect(i.getText()).toBe(t),w.expect(g.save).toHaveBeenCalled(),w.expect(g.get("bodyTop")).toBe(t),w.expect(g.get("bodyTopRichText")).toBe(e)}w.it("For Markdown",function(){e(!0)}),w.it("For plain text",function(){e(!1)}),w.it("Prevents Self-XSS",function(){t(v._bodyTopView,"bodyTop")})}),w.describe("Body Bottom",function(){function e(e){var t="My new text",i=v._bodyBottomView.textEditor;v._bodyBottomView.openEditor(),i.setText(t),i.setRichText(e),v._bodyBottomView.save(),w.expect(i.getText()).toBe(t),w.expect(g.save).toHaveBeenCalled(),w.expect(g.get("bodyBottom")).toBe(t),w.expect(g.get("bodyBottomRichText")).toBe(e)}w.it("For Markdown",function(){e(!0)}),w.it("For plain text",function(){e(!1)}),w.it("Prevents Self-XSS",function(){t(v._bodyBottomView,"bodyBottom")})}),w.describe("Ship It",function(){async function e(e){v._$shipIt.prop("checked",e),w.spyOn(RB,"navigateTo"),await v._saveReview(),w.expect(v._$shipIt.prop("checked")).toBe(e)}w.it("Checked",async function(){await e(!0)}),w.it("Unchecked",async function(){await e(!1)})})}),w.describe("Diff comments",function(){w.beforeEach(function(){n.total_results=1,n.diff_comments=[f]}),w.it("For Markdown",async function(){await e(!0)}),w.it("For plain text",async function(){await e(!1)}),w.it("Prevents Self-XSS",async function(){await c()})}),w.describe("File attachment comments",function(){w.beforeEach(function(){t.total_results=1,t.file_attachment_comments=[m]}),w.it("For Markdown",async function(){await e(!0)}),w.it("For plain text",async function(){await e(!1)}),w.it("Prevents Self-XSS",async function(){await c()})}),w.describe("General comments",function(){w.beforeEach(function(){i.total_results=1,i.general_comments=[x]}),w.it("For Markdown",async function(){await e(!0)}),w.it("For plain text",async function(){await e(!1)})}),w.describe("Screenshot comments",function(){w.beforeEach(function(){o.total_results=1,o.screenshot_comments=[h]}),w.it("For Markdown",async function(){await e(!0)}),w.it("For plain text",async function(){await e(!1)}),w.it("Prevents Self-XSS",async function(){await c()})})})})}),e.suite("rb/views/ReviewRequestEditorView",function(){const o=_.template(`<div class="screenshot-container" data-screenshot-id="<%= id %>">
 <div class="screenshot-caption">
  <a class="edit"></a>
 </div>
 <a class="delete">X</a>
'</div>`);let v,b,y,a,s;w.beforeEach(function(){RB.DnDUploader.create(),v=new RB.ReviewRequest({id:123,public:!0,state:RB.ReviewRequest.PENDING}),b=new RB.ReviewRequestEditor({commentIssueManager:new RB.CommentIssueManager,mutableByUser:!0,reviewRequest:v,statusMutableByUser:!0});var e,t=$(`<div>
 <div class="rb-c-unified-banner" id="unified-banner">
  <div class="rb-c-unified-banner__mode-selector"></div>
  <pre id="field_change_description" class="field field-text-area"
       data-field-id="field_change_description"></pre>
 </div>
 <div id="review-request-banners"></div>
 <div id="review-request-warning"></div>
 <div class="actions">
  <a href="#" id="discard-review-request-action"></a>
  <a href="#" id="submit-review-request-action"></a>
  <a href="#" id="delete-review-request-action"></a>
 </div>
 <div class="review-request">
  <div class="review-request-section review-request-summary">
   <div class="rb-c-review-request-fieldset">
    <div class="rb-c-review-request-field">
     <label class="rb-c-review-request-field__label">Summary</label>
     <div class="rb-c-review-request-field__value">
      <span id="field_summary"
            data-field-id="summary"
            class="field editable"></span>
     </div>
    </div>
   </div>
  </div>

  <div id="review-request-details">
   <div class="rb-c-review-request-fieldset">
    <div class="rb-c-review-request-field">
     <div class="rb-c-review-request-field__value">
      <span id="field_branch"
            data-field-id="branch"
            class="field editable"></span>
     </div>
     <div class="rb-c-review-request-field__value">
      <span id="field_submitter"
            data-field-id="submitter"
            class="field editable"></span>
     </div>
     <div class="rb-c-review-request-field__value">
      <span id="field_bugs_closed"
            data-field-id="bugs_closed"
            class="field editable comma-editable"></span>
     </div>
     <div class="rb-c-review-request-field__value">
      <span id="field_depends_on"
            data-field-id="depends_on"
            class="field editable comma-editable"></span>
     </div>
     <div class="rb-c-review-request-field__value">
      <span id="field_target_groups"
            data-field-id="target_groups"
            class="field editable comma-editable"></span>
     </div>
     <div class="rb-c-review-request-field__value">
      <span id="field_target_people"
            data-field-id="target_people"
            class="field editable"></span>
     </div>
    </div>
   </div>
  </div>

  <div id="review-request-main">
   <div class="rb-c-review-request-fieldset">
    <div class="review-request-section">
     <div class="rb-c-review-request-field">
      <div class="rb-c-review-request-field__value">
       <pre id="field_description"
            data-field-id="description"
            class="field field-text-area editable"></pre>
      </div>
     </div>
    </div>
    <div class="review-request-section">
     <div class="rb-c-review-request-field">
      <div class="rb-c-review-request-field__value">
       <pre id="field_testing_done"
            data-field-id="testing_done"
            class="field field-text-area editable"></pre>
      </div>
     </div>
    </div>
    <div class="review-request-section">
     <div class="rb-c-review-request-field">
      <div class="rb-c-review-request-field__value">
       <pre id="field_my_custom"
            data-field-id="my_custom"
            class="field editable"></pre>
       <pre id="field_my_rich_text_custom"
            data-field-id="my_rich_text_custom"
            class="field field-text-area editable rich-text"
            data-allow-markdown="True"></pre>
       <pre id="field_text"
            data-field-id="text"
            class="field field-text-area editable"
            data-allow-markdown="True"></pre>
       <input id="field_checkbox"
              data-field-id="checkbox"
              class="field"
              type="checkbox">
      </div>
     </div>
    </div>
   </div>
  </div>
  <div id="review-request-extra">
   <div>
    <div id="file-list"><br></div>
   </div>
   <div>
    <div id="screenshot-thumbnails"><br></div>
   </div>
  </div>
 </div>
</div>`).appendTo($testsScratch);(y=new RB.ReviewRequestEditorView({el:t,model:b})).addFieldView(new RB.ReviewRequestFields.SummaryFieldView({el:t.find("#field_summary"),fieldID:"summary",model:b})),y.addFieldView(new RB.ReviewRequestFields.BranchFieldView({el:t.find("#field_branch"),fieldID:"branch",model:b})),y.addFieldView(new RB.ReviewRequestFields.OwnerFieldView({el:t.find("#field_submitter"),fieldID:"submitter",model:b})),y.addFieldView(new RB.ReviewRequestFields.BugsFieldView({el:t.find("#field_bugs_closed"),fieldID:"bugs_closed",model:b})),y.addFieldView(new RB.ReviewRequestFields.DependsOnFieldView({el:t.find("#field_depends_on"),fieldID:"depends_on",model:b})),y.addFieldView(new RB.ReviewRequestFields.TargetGroupsFieldView({el:t.find("#field_target_groups"),fieldID:"target_groups",model:b})),y.addFieldView(new RB.ReviewRequestFields.TargetPeopleFieldView({el:t.find("#field_target_people"),fieldID:"target_people",model:b})),y.addFieldView(new RB.ReviewRequestFields.DescriptionFieldView({el:t.find("#field_description"),fieldID:"description",model:b})),y.addFieldView(new RB.ReviewRequestFields.TestingDoneFieldView({el:t.find("#field_testing_done"),fieldID:"testing_done",model:b})),y.addFieldView(new RB.ReviewRequestFields.TextFieldView({el:t.find("#field_my_custom"),fieldID:"my_custom",model:b})),y.addFieldView(new RB.ReviewRequestFields.MultilineTextFieldView({el:t.find("#field_my_rich_text_custom"),fieldID:"my_rich_text_custom",model:b})),y.addFieldView(new RB.ReviewRequestFields.MultilineTextFieldView({el:t.find("#field_text"),fieldID:"text",model:b})),y.addFieldView(new RB.ReviewRequestFields.CheckboxFieldView({el:t.find("#field_checkbox"),fieldID:"checkbox",model:b})),w.spyOn(v.draft,"ready").and.resolveTo(),RB.EnabledFeatures.unifiedBanner&&(e=v.createReview(),w.spyOn(e,"ready").and.resolveTo(),w.spyOn(v,"ready").and.resolveTo(),new RB.UnifiedBannerView({el:t.find("#unified-banner"),model:new RB.UnifiedBanner({pendingReview:e,reviewRequest:v,reviewRequestEditor:b}),reviewRequestEditorView:y}).render()),a=$testsScratch.find("#file-list"),s=$testsScratch.find("#screenshot-thumbnails"),w.spyOn(RB,"navigateTo")}),w.afterEach(function(){RB.DnDUploader.instance=null,RB.EnabledFeatures.unifiedBanner&&RB.UnifiedBannerView.resetInstance()}),w.describe("Actions bar",function(){w.it("ReviewRequestActionHooks",function(){var e=new(RB.Extension.extend({initialize:function(){RB.Extension.prototype.initialize.call(this),new RB.ReviewRequestActionHook({callbacks:{"#my-action":_.bind(function(){this.actionClicked=!0},this)},extension:this})}})),t=$('<a href="#" id="my-action">').appendTo(y.$(".actions"));y.render(),t.click(),w.expect(e.actionClicked).toBe(!0)})}),w.describe("Banners",function(){w.beforeEach(function(){y.render()}),w.describe("Draft banner",function(){w.beforeEach(()=>{RB.EnabledFeatures.unifiedBanner&&w.pending()}),w.describe("Visibility",function(){w.it("Hidden when saving",function(){w.expect(y.banner).toBe(null),b.trigger("saving"),w.expect(y.banner).toBe(null)}),w.it("Show when saved",function(e){var t=y.getFieldView("summary"),i=t.inlineEditorView;w.expect(y.banner).toBe(null),w.spyOn(v.draft,"ensureCreated").and.resolveTo(),w.spyOn(v.draft,"save").and.resolveTo(),t.on("fieldSaved",()=>{w.expect(y.banner).not.toBe(null),w.expect(y.banner.$el.is(":visible")).toBe(!0),e()}),i.startEdit(),i.setValue("New summary"),i.save()})}),w.describe("Buttons actions",function(){w.beforeEach(function(){v.set({links:{submitter:{title:"submitter"}}})}),w.it("Discard Draft",function(){y.model.set("hasDraft",!0),y.showBanner(),w.spyOn(v.draft,"destroy").and.resolveTo(),$("#btn-draft-discard").click(),w.expect(v.draft.destroy).toHaveBeenCalled()}),w.it("Discard Review Request",function(){v.set("public",!1),y.model.set("hasDraft",!0),y.showBanner(),w.spyOn(v,"close").and.callFake(e=>(w.expect(e.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED),Promise.resolve())),$("#btn-review-request-discard").click(),w.expect(v.close).toHaveBeenCalled()}),w.describe("Publish",function(){w.beforeEach(function(){y.model.set("hasDraft",!0),w.spyOn(b,"publishDraft").and.callThrough(),w.spyOn(v.draft,"ensureCreated").and.resolveTo(),w.spyOn(v.draft,"publish").and.resolveTo(),v.draft.set({description:"foo",links:{submitter:{title:"submitter"}},summary:"foo",targetGroups:[{name:"foo",url:"/groups/foo"}]})}),w.it("Basic publishing",async function(){y.showBanner(),v.draft.publish.and.callFake(()=>{w.expect(b.get("publishing")).toBe(!0),w.expect(b.publishDraft).toHaveBeenCalled()}),await y.banner._onPublishDraftClicked()}),w.it("With submitter changed",async function(){v.draft.set({links:{submitter:{title:"submitter2"}}}),y.showBanner(),w.spyOn(window,"confirm").and.returnValue(!0),v.draft.publish.and.callFake(()=>{w.expect(b.get("publishing")).toBe(!0),w.expect(b.publishDraft).toHaveBeenCalled(),w.expect(window.confirm).toHaveBeenCalled()}),await y.banner._onPublishDraftClicked()}),w.it("With Send E-Mail turned on",async function(){y.model.set("showSendEmail",!0),y.showBanner(),v.draft.publish.and.callFake(e=>{w.expect(b.get("publishing")).toBe(!0),w.expect(b.publishDraft).toHaveBeenCalled(),w.expect(e.trivial).toBe(0)}),await y.banner._onPublishDraftClicked()}),w.it("With Send E-Mail turned off",async function(){y.model.set("showSendEmail",!0),y.showBanner(),$(".send-email").prop("checked",!1),v.draft.publish.and.callFake(e=>{w.expect(b.get("publishing")).toBe(!0),w.expect(b.publishDraft).toHaveBeenCalled(),w.expect(e.trivial).toBe(1)}),await y.banner._onPublishDraftClicked()})})}),w.describe("Button states",function(){let e;w.beforeEach(function(){y.model.set("hasDraft",!0),y.showBanner(),e=y.banner.$buttons}),w.it("Enabled by default",function(){w.expect(e.prop("disabled")).toBe(!1)}),w.it("Disabled when saving",function(){w.expect(e.prop("disabled")).toBe(!1),b.trigger("saving"),w.expect(e.prop("disabled")).toBe(!0)}),w.it("Enabled when saved",function(){w.expect(e.prop("disabled")).toBe(!1),b.trigger("saving"),w.expect(e.prop("disabled")).toBe(!0),b.trigger("saved"),w.expect(e.prop("disabled")).toBe(!1)})})}),w.describe("Discarded banner",function(){w.beforeEach(function(){v.set("state",RB.ReviewRequest.CLOSE_DISCARDED)}),w.it("Visibility",function(){w.expect(y.banner).toBe(null),y.showBanner(),w.expect(y.banner).not.toBe(null),w.expect(y.banner.el.id).toBe("discard-banner"),w.expect(y.banner.$el.is(":visible")).toBe(!0)}),w.describe("Buttons actions",function(){w.beforeEach(function(){w.expect(y.banner).toBe(null),y.showBanner()}),w.it("Reopen",function(){w.spyOn(v,"reopen").and.resolveTo(),$("#btn-review-request-reopen").click(),w.expect(v.reopen).toHaveBeenCalled()})}),w.describe("Close description",function(){let o,a;function e(e,n){w.it(e,function(e){o.startEdit();var t=o.textEditor;t.setText("My description"),t.setRichText(n),a.triggerHandler("keyup");const i=setInterval(()=>{o.isDirty()&&(clearInterval(i),w.spyOn(v,"close").and.callFake(e=>(w.expect(e.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED),w.expect(e.description).toBe("My description"),w.expect(e.richText).toBe(n),Promise.resolve())),o.submit(),w.expect(v.close).toHaveBeenCalled(),e())},100)})}w.beforeEach(function(){y.showBanner(),o=y.banner.field.inlineEditorView,a=o.$field}),w.describe("Saves",function(){e("For Markdown",!0),e("For plain text",!1)})})}),w.describe("Submitted banner",function(){w.beforeEach(function(){v.set("state",RB.ReviewRequest.CLOSE_SUBMITTED)}),w.it("Visibility",function(){w.expect(y.banner).toBe(null),y.showBanner(),w.expect(y.banner).not.toBe(null),w.expect(y.banner.el.id).toBe("submitted-banner"),w.expect(y.banner.$el.is(":visible")).toBe(!0)}),w.describe("Buttons actions",function(){w.beforeEach(function(){w.expect(y.banner).toBe(null),v.set("state",RB.ReviewRequest.CLOSE_SUBMITTED),y.showBanner()}),w.it("Reopen",function(){w.spyOn(v,"reopen").and.resolveTo(),$("#btn-review-request-reopen").click(),w.expect(v.reopen).toHaveBeenCalled()})}),w.describe("Close description",function(){let o,a;function e(e,n){w.it(e,function(e){o.startEdit();var t=o.textEditor;t.setText("My description"),t.setRichText(n),a.triggerHandler("keyup");const i=setInterval(function(){o.isDirty()&&(clearInterval(i),w.spyOn(v,"close").and.callFake(e=>(w.expect(e.type).toBe(RB.ReviewRequest.CLOSE_SUBMITTED),w.expect(e.description).toBe("My description"),w.expect(e.richText).toBe(n),Promise.resolve())),o.submit(),w.expect(v.close).toHaveBeenCalled(),e())},100)})}w.beforeEach(function(){y.showBanner(),o=y.banner.field.inlineEditorView,a=o.$field}),w.describe("Saves",function(){e("For Markdown",!0),e("For plain text",!1)})})})}),w.describe("Fields",function(){let e,i,a,s,c,r,t,l,d,p;function n(e){w.beforeEach(function(){i=e.fieldName,a=e.jsonFieldName,s="text"===a?"text_type":a+"_text_type",c=!!e.supportsRichText,r=e.useExtraData,t=y.getFieldView(e.fieldID||e.jsonFieldName),l=t.inlineEditorView,d=y.$(e.selector),p=l.$field})}function o(){w.it("Has auto-complete",function(){w.expect(p.data("uiRbautocomplete")).not.toBe(void 0)})}function u(){w.it("Has editor",function(){w.expect(l).not.toBe(void 0)})}function f(n,i,o){w.beforeEach(function(e){var t;w.expect(c).toBe(o),l.startEdit(),c?(w.expect(d.hasClass("field-text-area")).toBe(!0),(t=l.textEditor).setText("My Value"),t.setRichText(n)):p.val("My Value"),p.triggerHandler("keyup"),w.expect(l.getValue()).toBe("My Value");const i=setInterval(()=>{l.isDirty()&&(clearInterval(i),e())},100)}),w.it("",function(){var e={},t=r?"extra_data.":"";e[t+a]="My Value",c&&(e[t+s]=i,e.force_text_type="html",e.include_text_types="raw"),w.expect(l.isDirty()).toBe(!0),l.submit(),w.expect(v.draft.save).toHaveBeenCalled(),w.expect(v.draft.save.calls.argsFor(0)[0].data).toEqual(e)})}function m(){w.describe("Saves",function(){f(void 0,void 0,!1)})}function x(){w.describe("Saves (rich text)",function(){w.describe("For Markdown",function(){f(!0,"markdown",!0)}),w.describe("For plain text",function(){f(!1,"plain",!0)})})}function h(){w.it("Propagates resizes",function(){w.spyOn(t,"trigger").and.callThrough(),t.inlineEditorView.textEditor.$el.triggerHandler("resize"),w.expect(t.trigger).toHaveBeenCalledWith("resize")})}function B(){w.describe("Edit counts",function(){w.it("When opened",function(){w.expect(b.get("editCount")).toBe(0),l.startEdit(),w.expect(b.get("editCount")).toBe(1)}),w.it("When canceled",function(){l.startEdit(),l.cancel(),w.expect(b.get("editCount")).toBe(0)}),w.it("When submitted",function(){l.startEdit(),p.val("My Value").triggerHandler("keyup"),l.submit(),w.expect(b.get("editCount")).toBe(0)})})}function g(t={}){t.supportsRichText&&w.describe("Security measures",function(){w.it("No self-XSS when draft field changes",function(){let e;delete window.rbTestFoundXSS,(e=t.fieldOnReviewRequest?v:v.draft).set(i,'"><script>window.rbTestFoundXSS = true;<\/script>'),e.trigger("change:"+i),e.trigger("fieldChange:"+i),w.expect(window.rbTestFoundXSS).toBe(void 0)})})}w.beforeEach(function(){e=e||(e=>(w.expect(e.data[a]).toBe("My Value"),Promise.resolve())),w.spyOn(v.draft,"save").and.callFake(e),y.render()}),w.describe("Branch",function(){n({fieldName:"branch",jsonFieldName:"branch",selector:"#field_branch"}),u(),m(),B(),g()}),w.describe("Bugs Closed",function(){n({fieldName:"bugsClosed",jsonFieldName:"bugs_closed",selector:"#field_bugs_closed"}),u(),m(),w.describe("Formatting",function(){w.it("With bugTrackerURL",function(){v.set("bugTrackerURL","http://issues/?id=--bug_id--"),v.draft.set("bugsClosed",[1,2,3]),b.trigger("fieldChanged:bugsClosed"),w.expect(d.text()).toBe("1, 2, 3");var e=d.children("a");w.expect(e.length).toBe(3);let t=e.eq(0);w.expect(t.hasClass("bug")).toBe(!0),w.expect(t.text()).toBe("1"),w.expect(t.attr("href")).toBe("http://issues/?id=1"),t=e.eq(1),w.expect(t.hasClass("bug")).toBe(!0),w.expect(t.text()).toBe("2"),w.expect(t.attr("href")).toBe("http://issues/?id=2"),t=e.eq(2),w.expect(t.hasClass("bug")).toBe(!0),w.expect(t.text()).toBe("3"),w.expect(t.attr("href")).toBe("http://issues/?id=3")}),w.it("Without bugTrackerURL",function(){v.set("bugTrackerURL",""),v.draft.set("bugsClosed",[1,2,3]),b.trigger("fieldChanged:bugsClosed"),w.expect(d.html()).toBe("1, 2, 3")})}),B(),g()}),w.describe("Depends On",function(){n({fieldName:"dependsOn",jsonFieldName:"depends_on",selector:"#field_depends_on"}),o(),u(),m(),w.it("Formatting",function(){v.draft.set("dependsOn",[{id:"123",url:"/r/123/"},{id:"124",url:"/r/124/"}]),b.trigger("fieldChanged:dependsOn");var e=d.children();w.expect(d.text()).toBe("123, 124"),w.expect(e.eq(0).attr("href")).toBe("/r/123/"),w.expect(e.eq(1).attr("href")).toBe("/r/124/")}),B(),g()}),w.describe("Change Descriptions",function(){function e(o){w.beforeEach(function(){v.set("state",o.closeType),y.showBanner(),w.spyOn(v,"close").and.callThrough(),w.spyOn(v,"save").and.resolveTo()}),n({fieldName:"closeDescription",jsonFieldName:"close_description",selector:o.bannerSel+" #field_close_description"}),u(),w.it("Starts closed",function(){w.expect(p.is(":visible")).toBe(!1)}),w.describe("Saves",function(){function e(e,t,i){var n={force_text_type:"html",include_text_types:"raw",status:o.jsonCloseType},t=(n[o.jsonTextTypeFieldName]=t,n[o.jsonFieldName]="My Value",l.startEdit(),l.textEditor);t.setText("My Value"),!1!==i&&t.setRichText(e),p.triggerHandler("keyup"),l.submit(),w.expect(v.close).toHaveBeenCalled(),w.expect(v.save).toHaveBeenCalled(),w.expect(v.save.calls.argsFor(0)[0].data).toEqual(n)}w.it("For Markdown",function(){e(!0,"markdown",!0)}),w.it("For plain text",function(){e(!1,"plain",!0)})}),w.describe("State when statusEditable",function(){w.it("Disabled when false",function(){b.set("statusEditable",!1),w.expect(l.options.enabled).toBe(!1)}),w.it("Enabled when true",function(){b.set("statusEditable",!0),w.expect(l.options.enabled).toBe(!0)})}),w.describe("Formatting",function(){w.it("Links",function(){v.set("closeDescription","Testing /r/123"),b.trigger("fieldChanged:closeDescription"),w.expect(d.text()).toBe("Testing /r/123"),w.expect(d.find("a").attr("href")).toBe("/r/123/")})}),h(),B(),g({fieldOnReviewRequest:!0,supportsRichText:!0})}w.describe("Discarded review requests",function(){e({bannerSel:"#discard-banner",closeType:RB.ReviewRequest.CLOSE_DISCARDED,jsonCloseType:"discarded",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})}),w.describe("Draft review requests",function(){w.beforeEach(function(){y.model.set("hasDraft",!0),RB.EnabledFeatures.unifiedBanner||y.showBanner()}),n({fieldID:"change_description",fieldName:"changeDescription",jsonFieldName:"changedescription",selector:RB.EnabledFeatures.unifiedBanner?"#unified-banner #field_change_description":"#draft-banner #field_change_description",supportsRichText:!0}),u(),x(),B(),g({fieldOnReviewRequest:!0,supportsRichText:!0})}),w.describe("Submitted review requests",function(){e({bannerSel:"#submitted-banner",closeType:RB.ReviewRequest.CLOSE_SUBMITTED,jsonCloseType:"submitted",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})})}),w.describe("Description",function(){n({fieldName:"description",jsonFieldName:"description",selector:"#field_description",supportsRichText:!0}),u(),x(),w.describe("Formatting",function(){w.it("Links",function(){v.draft.set("description","Testing /r/123"),b.trigger("fieldChanged:description"),w.expect(d.text()).toBe("Testing /r/123"),w.expect(d.find("a").attr("href")).toBe("/r/123/")})}),h(),B(),g({supportsRichText:!0})}),w.describe("Summary",function(){n({fieldName:"summary",jsonFieldName:"summary",selector:"#field_summary"}),u(),m(),B(),g()}),w.describe("Testing Done",function(){n({fieldName:"testingDone",jsonFieldName:"testing_done",selector:"#field_testing_done",supportsRichText:!0}),u(),x(),w.describe("Formatting",function(){w.it("Links",function(){v.draft.set("testingDone","Testing /r/123"),b.trigger("fieldChanged:testingDone"),w.expect(d.text()).toBe("Testing /r/123"),w.expect(d.find("a").attr("href")).toBe("/r/123/")})}),h(),B(),g({supportsRichText:!0})}),w.describe("Reviewers",function(){w.describe("Groups",function(){n({fieldName:"targetGroups",jsonFieldName:"target_groups",selector:"#field_target_groups"}),o(),u(),m(),w.it("Formatting",function(){v.draft.set("targetGroups",[{name:"group1",url:"/groups/group1/"},{name:"group2",url:"/groups/group2/"}]),b.trigger("fieldChanged:targetGroups"),w.expect(d.html()).toBe('<a href="/groups/group1/">group1</a>, <a href="/groups/group2/">group2</a>')}),B(),g()}),w.describe("People",function(){n({fieldName:"targetPeople",jsonFieldName:"target_people",selector:"#field_target_people"}),o(),u(),m(),w.it("Formatting",function(){v.draft.set("targetPeople",[{url:"/users/user1/",username:"user1"},{url:"/users/user2/",username:"user2"}]),b.trigger("fieldChanged:targetPeople"),w.expect(d.text()).toBe("user1, user2"),w.expect($(d.children()[0]).attr("href")).toBe("/users/user1/"),w.expect($(d.children()[1]).attr("href")).toBe("/users/user2/")}),B(),g()})}),w.describe("Owner",function(){n({jsonFieldName:"submitter",selector:"#field_submitter"}),o(),u(),m(),w.it("Formatting",function(){v.draft.set("submitter",{href:"/users/user1/",title:"user1"}),b.trigger("fieldChanged:submitter"),w.expect(d.text()).toBe("user1"),w.expect(d.children().attr("href")).toBe("/users/user1/")}),B()}),w.describe("Custom fields",function(){w.beforeEach(function(){e=e=>(w.expect(e.data["extra_data."+a]).toBe("My Value"),Promise.resolve())}),n({fieldID:"my_custom",jsonFieldName:"my_custom",selector:"#field_my_custom",useExtraData:!0}),u(),m(),B(),g()}),w.describe("Custom rich-text field",function(){w.beforeEach(function(){e=e=>(w.expect(e.data["extra_data."+a]).toBe("My Value"),Promise.resolve())}),n({fieldID:"my_rich_text_custom",jsonFieldName:"my_rich_text_custom",selector:"#field_my_rich_text_custom",supportsRichText:!0,useExtraData:!0}),w.it("Initial rich text state",function(){w.expect(l.textEditor.richText).toBe(!0)}),u(),x(),h(),B(),g()}),w.describe("Custom rich-text field with special name",function(){w.beforeEach(function(){e=e=>(w.expect(e.data["extra_data."+a]).toBe("My Value"),Promise.resolve())}),n({fieldID:"text",jsonFieldName:"text",selector:"#field_text",supportsRichText:!0,useExtraData:!0}),u(),x(),h(),B(),g()}),w.describe("Custom checkbox field",function(){w.beforeEach(function(){d=y.$("#field_checkbox"),e=e=>(w.expect(e.data["extra_data.checkbox"]).toBe(!0),Promise.resolve()),v.draft.save.and.callFake(e)}),w.it("Saves",function(){d.click(),w.expect(v.draft.save).toHaveBeenCalled(),w.expect(v.draft.save.calls.argsFor(0)[0].data).toEqual({"extra_data.checkbox":!0})})})}),w.describe("File attachments",function(){w.it("Rendering when added",function(){w.spyOn(RB.FileAttachmentThumbnailView.prototype,"render").and.callThrough(),w.expect(a.find(".file-container").length).toBe(0),y.render(),b.createFileAttachment(),w.expect(RB.FileAttachmentThumbnailView.prototype.render).toHaveBeenCalled(),w.expect(a.find(".file-container").length).toBe(1)}),w.describe("Events",function(){let i,n;w.beforeEach(function(){y.render(),i=b.createFileAttachment(),n=$(a.find(".file-container")[0]),w.expect(n.length).toBe(1)}),w.describe("beginEdit",function(){w.it("Increment edit count",function(){w.expect(b.get("editCount")).toBe(0),n.find(".file-caption .edit").data("inline-editor").startEdit(),w.expect(b.get("editCount")).toBe(1)})}),w.describe("endEdit",function(){w.describe("Decrement edit count",function(){let e,t;w.beforeEach(function(){w.expect(b.get("editCount")).toBe(0),e=n.find(".file-caption .edit"),(t=e.data("inline-editor")).startEdit()}),w.it("On cancel",function(){t.cancel(),w.expect(b.get("editCount")).toBe(0)}),w.it("On submit",function(e){w.spyOn(i,"ready").and.resolveTo(),w.spyOn(i,"save").and.resolveTo(),n.find("input").val("Foo").triggerHandler("keyup"),t.submit(),_.defer(()=>{w.expect(b.get("editCount")).toBe(0),e()})})})})})}),w.describe("Methods",function(){w.describe("getFieldView",function(){w.it("Correct field is returned",function(){var e=y.getFieldView("target_groups");w.expect(e).not.toBe(void 0),w.expect(e.fieldID).toBe("target_groups"),w.expect(y.getFieldView("some_random_id")).toBe(void 0)})})}),w.describe("Screenshots",function(){w.describe("Importing on render",function(){w.it("No screenshots",function(){y.render(),w.expect(b.get("screenshots").length).toBe(0)}),w.it("With screenshots",function(){var e=b.get("screenshots");s.append(o({id:42})),w.spyOn(RB.ScreenshotThumbnail.prototype,"render").and.callThrough(),y.render(),w.expect(RB.ScreenshotThumbnail.prototype.render).toHaveBeenCalled(),w.expect(e.length).toBe(1),w.expect(e.at(0).id).toBe(42)})}),w.describe("Events",function(){let t,i,e,n;w.beforeEach(function(){t=$(o({id:42})).appendTo(s),w.spyOn(RB.ScreenshotThumbnail.prototype,"render").and.callThrough(),y.render(),i=b.get("screenshots").at(0),e=RB.ScreenshotThumbnail.prototype.render.calls.thisFor(0),n=e._captionEditorView}),w.describe("beginEdit",function(){w.it("Increment edit count",function(){w.expect(b.get("editCount")).toBe(0),n.startEdit(),w.expect(b.get("editCount")).toBe(1)})}),w.describe("endEdit",function(){w.describe("Decrement edit count",function(){w.beforeEach(function(){w.expect(b.get("editCount")).toBe(0),n.startEdit()}),w.it("On cancel",function(){n.cancel(),w.expect(b.get("editCount")).toBe(0)}),w.it("On submit",function(e){w.spyOn(i,"ready").and.resolveTo(),w.spyOn(i,"save").and.resolveTo(),t.find("input").val("Foo").triggerHandler("keyup"),n.submit(),_.defer(()=>{w.expect(b.get("editCount")).toBe(0),e()})})})})})}),w.describe("beforeUnload event handler",function(){w.describe("editable=true",function(){w.beforeEach(function(){b.set("statusEditable",!0),b.set("editable",!0),w.expect(b.get("statusEditable")).toBe(!0),w.expect(b.get("editable")).toBe(!0),w.expect(b.get("editCount")).toBe(0)}),w.it("Warn user beforeUnload when editing",function(){y.model.incr("editCount"),w.expect(b.get("editCount")).toBe(1),w.expect(y._onBeforeUnload($.Event("beforeunload"))).toBeDefined()}),w.it("Don't warn user beforeUnload when not editing",function(){w.expect(y._onBeforeUnload($.Event("beforeunload"))).toBeUndefined()})}),w.describe("editable=false",function(){w.beforeEach(function(){b.set("statusEditable",!1),b.set("editable",!1),w.expect(b.get("statusEditable")).toBe(!1),w.expect(b.get("editable")).toBe(!1),w.expect(b.get("editCount")).toBe(0)}),w.it("Warn user beforeUnload when editing",function(){y.model.incr("editCount"),w.expect(b.get("editCount")).toBe(1),w.expect(y._onBeforeUnload($.Event("beforeunload"))).toBeDefined()}),w.it("Don't warn user beforeUnload when not editing",function(){w.expect(y._onBeforeUnload($.Event("beforeunload"))).toBeUndefined()})})})});const{BaseFieldView:c,MultilineTextFieldView:r,TextFieldView:l}=RB.ReviewRequestFields;e.suite("rb/views/reviewRequestFieldViews",function(){let e,i,t,n,o,a,s;w.beforeEach(function(){e=new RB.ReviewRequest({id:1}),i=e.draft,t=i.get("extraData"),n={extra_data:{}},i.set("rawTextFields",n),o=new RB.ReviewRequestEditor({reviewRequest:e}),a=new RB.ReviewRequestEditorView({model:o}),w.spyOn(i,"save").and.resolveTo(),w.spyOn(i,"ready").and.resolveTo()}),w.describe("BaseFieldView",function(){w.beforeEach(function(){s=new c({fieldID:"my_field",model:o})}),w.describe("Initialization",function(){w.it("Default behavior",function(){w.expect(s.$el.data("field-id")).toBe("my_field"),w.expect(s.jsonFieldName).toBe("my_field")}),w.it("With custom jsonFieldName",function(){var e=new c({fieldID:"my_field",jsonFieldName:"my_custom_name",model:o});w.expect(e.$el.data("field-id")).toBe("my_field"),w.expect(e.jsonFieldName).toBe("my_custom_name")})}),w.describe("Properties",function(){w.it("fieldName",function(){w.expect(s.fieldName()).toBe("myField")})}),w.describe("Methods",function(){w.describe("_loadValue",function(){w.it("Built-in field",function(){s.useExtraData=!1,i.set("myField","this is a test"),w.expect(s._loadValue()).toBe("this is a test")}),w.it("Custom field",function(){t.my_field="this is a test",w.expect(s._loadValue()).toBe("this is a test")}),w.it("Custom field and custom jsonFieldName",function(){var e=new c({fieldID:"my_field",jsonFieldName:"foo",model:o});t.foo="this is a test",w.expect(e._loadValue()).toBe("this is a test")})}),w.describe("_saveValue",function(){w.it("Built-in field",function(t){s.useExtraData=!1,s._saveValue("test").then(()=>{w.expect(i.save.calls.argsFor(0)[0].data).toEqual({my_field:"test"}),t()}).catch(e=>t.fail(e))}),w.it("Custom field",function(t){s._saveValue("this is a test").then(()=>{w.expect(i.save.calls.argsFor(0)[0].data).toEqual({"extra_data.my_field":"this is a test"}),t()}).catch(e=>t.fail(e))}),w.it("Custom field and custom jsonFieldName",function(t){new c({fieldID:"my_field",jsonFieldName:"foo",model:o})._saveValue("this is a test").then(()=>{w.expect(i.save.calls.argsFor(0)[0].data).toEqual({"extra_data.foo":"this is a test"}),t()}).catch(e=>t.fail(e))})})})}),w.describe("TextFieldView",function(){w.beforeEach(function(){s=new l({fieldID:"my_field",model:o}),a.addFieldView(s)}),w.describe("Properties",function(){w.describe("jsonTextTypeFieldName",function(){w.it('With fieldID != "text"',function(){w.expect(s.jsonTextTypeFieldName).toBe("my_field_text_type")}),w.it('With fieldID = "text"',function(){s=new l({fieldID:"text",model:o}),w.expect(s.jsonTextTypeFieldName).toBe("text_type")})}),w.describe("richTextAttr",function(){w.it("With allowRichText=true",function(){s.allowRichText=!0,w.expect(s.richTextAttr()).toBe("myFieldRichText")}),w.it("With allowRichText=false",function(){s.allowRichText=!1,w.expect(s.richTextAttr()).toBe(null)})})}),w.describe("Methods",function(){w.describe("render",function(){w.beforeEach(function(){s.$el.addClass("editable"),n.extra_data={my_field:"**Hello world**",my_field_text_type:"markdown"}}),w.describe("With allowRichText=true",function(){w.beforeEach(function(){s.allowRichText=!0}),w.it("With richText=true",function(){n.extra_data.my_field_text_type="markdown",s.render(),w.expect(s.inlineEditorView.textEditor.richText).toBe(!0),w.expect(s.inlineEditorView.options.rawValue).toBe("**Hello world**")}),w.it("With richText=false",function(){n.extra_data.my_field_text_type="plain",s.render(),w.expect(s.inlineEditorView.textEditor.richText).toBe(!1),w.expect(s.inlineEditorView.options.rawValue).toBe("**Hello world**")})})}),w.describe("_formatField",function(){w.it("With built-in field",function(){s.useExtraData=!1,i.set("myField","Hello world"),s._formatField(),w.expect(s.$el.text()).toBe("Hello world")}),w.it("With custom field",function(){a.addFieldView(s),t.my_field="Hello world",s._formatField(),w.expect(s.$el.text()).toBe("Hello world")}),w.it("With formatValue as function",function(){s.formatValue=function(e){this.$el.text(`[${e}]`)},t.my_field="Hello world",s._formatField(),w.expect(s.$el.text()).toBe("[Hello world]")})}),w.describe("_getInlineEditorClass",function(){w.it("With allowRichText=true",function(){s.allowRichText=!0,w.expect(s._getInlineEditorClass()).toBe(RB.RichTextInlineEditorView)}),w.it("With allowRichText=false",function(){s.allowRichText=!1,w.expect(s._getInlineEditorClass()).toBe(RB.InlineEditorView)})}),w.describe("_loadRichTextValue",function(){w.beforeEach(function(){s.allowRichText=!0}),w.describe("With built-in field",function(){w.beforeEach(function(){s.useExtraData=!1}),w.it("With value=undefined",function(){i.set("myFieldRichText",void 0),w.expect(s._loadRichTextValue()).toBe(void 0)}),w.it("With value=false",function(){i.set("myFieldRichText",!1),w.expect(s._loadRichTextValue()).toBe(!1)}),w.it("With value=true",function(){i.set("myFieldRichText",!0),w.expect(s._loadRichTextValue()).toBe(!0)})}),w.describe("With custom field",function(){w.it("With textType=undefined",function(){w.expect(s._loadRichTextValue()).toBe(void 0)}),w.it("With textType=plain",function(){n.extra_data.my_field_text_type="plain",w.expect(s._loadRichTextValue()).toBe(!1)}),w.it("With textType=markdown",function(){n.extra_data.my_field_text_type="markdown",w.expect(s._loadRichTextValue()).toBe(!0)}),w.it("With textType=invalid value",function(){n.extra_data.my_field_text_type="html";try{s._loadRichTextValue()}catch(e){}w.expect(console.assert).toHaveBeenCalledWith(!1,'Text type "html" in field "my_field_text_type" not supported.')})})})})}),w.describe("MultilineTextFieldView",function(){w.describe("Initialization from DOM",function(){let e;w.beforeEach(function(){e=$('<span data-allow-markdown="true">').text("DOM text value")}),w.describe("allowRichText",function(){w.it("allow-markdown=true",function(){s=new r({el:e,fieldID:"my_field",jsonFieldName:"foo",model:o}),w.expect(s.allowRichText).toBe(!0)}),w.it("allow-markdown=false",function(){s=new r({el:e.attr("data-allow-markdown","false"),fieldID:"my_field",jsonFieldName:"foo",model:o}),w.expect(s.allowRichText).toBe(!1)}),w.it("allow-markdown unset",function(){s=new r({el:e.removeAttr("data-allow-markdown"),fieldID:"my_field",jsonFieldName:"foo",model:o}),w.expect(s.allowRichText).toBe(void 0)})}),w.describe("Text value",function(){w.it("raw-value set",function(){s=new r({el:e.attr("data-raw-value","attr text value"),fieldID:"my_field",jsonFieldName:"foo",model:o}),w.expect(t.foo).toBe("attr text value"),w.expect(e.attr("data-raw-value")).toBe(void 0)}),w.it("raw-value unset",function(){s=new r({el:e,fieldID:"my_field",jsonFieldName:"foo",model:o}),w.expect(t.foo).toBe("DOM text value")})}),w.describe("Text type value",function(){w.it("rich-text class present",function(){s=new r({el:e.addClass("rich-text"),fieldID:"my_field",jsonFieldName:"foo",model:o}),w.expect(t.foo_text_type).toBe("markdown")}),w.it("rich-text class not present",function(){s=new r({el:e,fieldID:"my_field",jsonFieldName:"foo",model:o}),w.expect(t.foo_text_type).toBe("plain")})})})})}),e.suite("rb/pages/views/ReviewablePageView",function(){let t,n,o;w.beforeEach(function(){var e=$("<div>").html(`<div id="review-banner"></div>
<div id="unified-banner">
 <div class="rb-c-unified-banner__mode-selector"></div>
</div>
<a href="#" id="action-legacy-edit-review">Edit Review</a>
<a href="#" id="action-legacy-ship-it">Ship It</a>`).appendTo($testsScratch),e=(RB.DnDUploader.instance=null,t=e.find("#action-legacy-edit-review"),n=new RB.ReviewablePage({checkForUpdates:!1,editorData:{mutableByUser:!0,statusMutableByUser:!0},reviewRequestData:{id:123,loaded:!0,state:RB.ReviewRequest.PENDING}},{parse:!0}),w.spyOn(RB.HeaderView.prototype,"_ensureSingleton"),o=new RB.ReviewablePageView({el:e,model:n}),n.get("reviewRequest"));w.spyOn(e,"ready").and.resolveTo(),w.spyOn(e.draft,"ready").and.resolveTo(),w.spyOn(n.get("pendingReview"),"ready").and.resolveTo(),w.spyOn(RB,"navigateTo"),o.render()}),w.afterEach(function(){RB.DnDUploader.instance=null,RB.EnabledFeatures.unifiedBanner&&RB.UnifiedBannerView.resetInstance(),o.remove()}),w.describe("Public objects",function(){w.it("reviewRequest",function(){w.expect(n.get("reviewRequest")).not.toBe(void 0)}),w.it("pendingReview",function(){var e=n.get("pendingReview");w.expect(e).not.toBe(void 0),w.expect(e.get("parentObject")).toBe(n.get("reviewRequest"))}),w.it("commentIssueManager",function(){w.expect(n.commentIssueManager).not.toBe(void 0),w.expect(n.commentIssueManager.get("reviewRequest")).toBe(n.get("reviewRequest"))}),w.it("reviewRequestEditor",function(){var e=n.reviewRequestEditor;w.expect(e).not.toBe(void 0),w.expect(e.get("reviewRequest")).toBe(n.get("reviewRequest")),w.expect(e.get("commentIssueManager")).toBe(n.commentIssueManager),w.expect(e.get("editable")).toBe(!0)}),w.it("reviewRequestEditorView",function(){w.expect(o.reviewRequestEditorView).not.toBe(void 0),w.expect(o.reviewRequestEditorView.model).toBe(n.reviewRequestEditor)})}),w.describe("Actions",function(){w.it("Edit Review",function(){var e;RB.EnabledFeatures.unifiedBanner?w.pending():(w.spyOn(RB.ReviewDialogView,"create"),t.click(),w.expect(RB.ReviewDialogView.create).toHaveBeenCalled(),e=RB.ReviewDialogView.create.calls.argsFor(0)[0],w.expect(e.review).toBe(n.get("pendingReview")),w.expect(e.reviewRequestEditor).toBe(n.reviewRequestEditor))}),w.describe("Ship It",function(){let e;w.beforeEach(function(){e=n.get("pendingReview")}),w.it("Confirmed",async function(){RB.EnabledFeatures.unifiedBanner?w.pending():(w.spyOn(window,"confirm").and.returnValue(!0),w.spyOn(e,"save").and.resolveTo(),w.spyOn(e,"publish").and.callThrough(),RB.EnabledFeatures.unifiedBanner||w.spyOn(o.draftReviewBanner,"hideAndReload").and.callFake(()=>{w.expect(window.confirm).toHaveBeenCalled(),w.expect(e.ready).toHaveBeenCalled(),w.expect(e.publish).toHaveBeenCalled(),w.expect(e.save).toHaveBeenCalled(),w.expect(e.get("shipIt")).toBe(!0),w.expect(e.get("bodyTop")).toBe("Ship It!")}),await o.shipIt())}),w.it("Canceled",async function(){RB.EnabledFeatures.unifiedBanner?w.pending():(w.spyOn(window,"confirm").and.returnValue(!1),await o.shipIt(),w.expect(window.confirm).toHaveBeenCalled(),w.expect(e.ready).not.toHaveBeenCalled())})})}),w.describe("Update bubble",()=>{const e={fullname:"Mr. User",url:"/users/foo/",username:"user"};let t,i;w.beforeEach(()=>{n.get("reviewRequest").trigger("updated",{summary:"My summary",user:e}),t=$("#updates-bubble"),i=o._updatesBubble}),w.it("Displays",()=>{w.expect(t.length).toBe(1),w.expect(i.$el[0]).toBe(t[0]),w.expect(t.is(":visible")).toBe(!0),w.expect(t.find(".rb-c-page-updates-bubble__message").html()).toBe('My summary by <a href="/users/foo/">Mr. User</a>')}),w.describe("Actions",()=>{w.it("Ignore",e=>{w.spyOn(i,"close").and.callThrough(),w.spyOn(i,"trigger").and.callThrough(),w.spyOn(i,"remove").and.callThrough(),t.find('[data-action="ignore"]').click(),_.defer(()=>{w.expect(i.close).toHaveBeenCalled(),w.expect(i.remove).toHaveBeenCalled(),w.expect(i.trigger).toHaveBeenCalledWith("closed"),e()})}),w.it("Update Page displays Updates Bubble",()=>{w.spyOn(i,"trigger"),t.find('[data-action="update"]').click(),w.expect(i.trigger).toHaveBeenCalledWith("updatePage")}),w.it("Update Page calls notify if shouldNotify",()=>{RB.NotificationManager.instance._canNotify=!0,w.spyOn(RB.NotificationManager.instance,"notify"),w.spyOn(RB.NotificationManager.instance,"_haveNotificationPermissions").and.returnValue(!0),w.spyOn(o,"_showUpdatesBubble"),o._onReviewRequestUpdated({user:{fullname:"Hello"}}),w.expect(RB.NotificationManager.instance.notify).toHaveBeenCalled(),w.expect(o._showUpdatesBubble).toHaveBeenCalled()})})})}),e.suite("rb/views/TextBasedReviewableView",function(){let e,t,i,n;w.beforeEach(function(){e=$(`<div id="container">
 <div class="text-review-ui-views">
  <ul class="rb-c-tabs">
   <li class="rb-c-tabs__tab -is-active" data-view-mode="rendered">
    <a href="#rendered">Rendered</a>
   </li>
   <li class="rb-c-tabs__tab" data-view-mode="source">
    <a href="#source">Source</a>
   </li>
  </ul>
 </div>
 <table class="text-review-ui-rendered-table"></table>
 <table class="text-review-ui-text-table"></table>
</div>`).appendTo($testsScratch),t=new RB.ReviewRequest({reviewURL:"/r/123/"}),i=new RB.TextBasedReviewable({fileAttachmentID:456,hasRenderedView:!0,reviewRequest:t,viewMode:"rendered"}),n=new RB.TextBasedReviewableView({el:e,model:i}),w.spyOn(window.history,"pushState"),w.spyOn(window.history,"replaceState"),w.spyOn(Backbone.history,"matchRoot").and.returnValue(!0),w.spyOn(n.router,"trigger").and.callThrough(),w.spyOn(n.router,"navigate").and.callFake((e,t)=>{t&&!1===t.trigger||Backbone.history.loadUrl(e)}),n.render()}),w.afterEach(function(){n.remove(),e.remove(),Backbone.history.stop()}),w.it("Router switches view modes",function(){n.router.navigate("#rendered"),w.expect(n.router.trigger).toHaveBeenCalledWith("route:viewMode","rendered",null,null),w.expect(e.find(".-is-active").attr("data-view-mode")).toBe("rendered"),w.expect(i.get("viewMode")).toBe("rendered"),n.router.navigate("#source"),w.expect(n.router.trigger).toHaveBeenCalledWith("route:viewMode","source",null,null),w.expect(e.find(".-is-active").attr("data-view-mode")).toBe("source"),w.expect(i.get("viewMode")).toBe("source"),n.router.navigate("#rendered"),w.expect(n.router.trigger).toHaveBeenCalledWith("route:viewMode","rendered",null,null),w.expect(e.find(".-is-active").attr("data-view-mode")).toBe("rendered"),w.expect(i.get("viewMode")).toBe("rendered")})}),e.suite("rb/ui/models/ContentViewport",()=>{let t,e,i;async function n(){await new Promise(e=>{t.once("handledResize",()=>setTimeout(e,0))})}w.beforeEach(()=>{t=new RB.ContentViewport,(e=document.createElement("div")).style.width="200px",e.style.height="100px",$testsScratch.append(e),(i=document.createElement("div")).style.width="75px",i.style.height="50px",$testsScratch.append(i)}),w.afterEach(()=>{t.clearTracking()}),w.afterAll(()=>{t=null,e=null,i=null}),w.describe("Methods",()=>{w.describe("trackElement",()=>{w.it("On top",()=>{t.trackElement({el:e,side:"top"}),w.expect(t.attributes).toEqual({bottom:0,left:0,right:0,top:100}),t.trackElement({el:i,side:"top"}),w.expect(t.attributes).toEqual({bottom:0,left:0,right:0,top:150})}),w.it("On bottom",()=>{t.trackElement({el:e,side:"bottom"}),w.expect(t.attributes).toEqual({bottom:100,left:0,right:0,top:0}),t.trackElement({el:i,side:"bottom"}),w.expect(t.attributes).toEqual({bottom:150,left:0,right:0,top:0})}),w.it("On left",()=>{t.trackElement({el:e,side:"left"}),w.expect(t.attributes).toEqual({bottom:0,left:200,right:0,top:0}),t.trackElement({el:i,side:"left"}),w.expect(t.attributes).toEqual({bottom:0,left:275,right:0,top:0})}),w.it("On right",()=>{t.trackElement({el:e,side:"right"}),w.expect(t.attributes).toEqual({bottom:0,left:0,right:200,top:0}),t.trackElement({el:i,side:"right"}),w.expect(t.attributes).toEqual({bottom:0,left:0,right:275,top:0})})}),w.it("untrackElement",async()=>{t.trackElement({el:e,side:"bottom"}),t.trackElement({el:i,side:"bottom"}),t.untrackElement(e),w.expect(t.attributes).toEqual({bottom:50,left:0,right:0,top:0}),t.untrackElement(i),w.expect(t.attributes).toEqual({bottom:0,left:0,right:0,top:0}),e.style.width="1000px",i.style.height="1000px",await new Promise(e=>setTimeout(e,50)),w.expect(t.attributes).toEqual({bottom:0,left:0,right:0,top:0})})}),w.describe("Events",()=>{w.describe("Element resize",()=>{w.it("On top",async()=>{t.trackElement({el:e,side:"top"}),t.trackElement({el:i,side:"top"}),w.expect(t.attributes).toEqual({bottom:0,left:0,right:0,top:150}),e.style.height="113px",await n(),w.expect(t.attributes).toEqual({bottom:0,left:0,right:0,top:163}),i.style.height="23px",await n(),w.expect(t.attributes).toEqual({bottom:0,left:0,right:0,top:136})}),w.it("On bottom",async()=>{t.trackElement({el:e,side:"bottom"}),t.trackElement({el:i,side:"bottom"}),w.expect(t.attributes).toEqual({bottom:150,left:0,right:0,top:0}),e.style.height="113px",await n(),w.expect(t.attributes).toEqual({bottom:163,left:0,right:0,top:0}),i.style.height="23px",await n(),w.expect(t.attributes).toEqual({bottom:136,left:0,right:0,top:0})}),w.it("On left",async()=>{t.trackElement({el:e,side:"left"}),t.trackElement({el:i,side:"left"}),w.expect(t.attributes).toEqual({bottom:0,left:275,right:0,top:0}),e.style.width="209px",await n(),w.expect(t.attributes).toEqual({bottom:0,left:284,right:0,top:0}),i.style.width="72px",await n(),w.expect(t.attributes).toEqual({bottom:0,left:281,right:0,top:0})}),w.it("On right",async()=>{t.trackElement({el:e,side:"right"}),t.trackElement({el:i,side:"right"}),w.expect(t.attributes).toEqual({bottom:0,left:0,right:275,top:0}),e.style.width="209px",await n(),w.expect(t.attributes).toEqual({bottom:0,left:0,right:284,top:0}),i.style.width="72px",await n(),w.expect(t.attributes).toEqual({bottom:0,left:0,right:281,top:0})})})})}),e.suite("rb/ui/views/DateInlineEditorView",function(){const t="2022-09-16";let i,n;w.beforeEach(function(){n=$("<div>").appendTo($testsScratch)}),w.describe("Construction",function(){w.it("Default",function(){(i=new RB.DateInlineEditorView({el:n})).render(),w.expect(i.options.descriptorText).toBe(null),w.expect(i.options.minDate).toBe(null),w.expect(i.options.maxDate).toBe(null),w.expect(i.options.rawValue).toBe(null),w.expect(i.$buttons.length).toBe(1),w.expect(i.$field.length).toBe(1);var e=i.$field[0];w.expect(e.children.length).toBe(1),w.expect(e.firstElementChild.outerHTML).toBe('<input type="date">')}),w.it("With options provided",function(){(i=new RB.DateInlineEditorView({descriptorText:"Test",el:n,maxDate:"2030-10-10",minDate:"2020-10-10",rawValue:t})).render(),w.expect(i.options.descriptorText).toBe("Test"),w.expect(i.options.minDate).toBe("2020-10-10"),w.expect(i.options.maxDate).toBe("2030-10-10"),w.expect(i.options.rawValue).toBe(t),w.expect(i.$buttons.length).toBe(1),w.expect(i.$field.length).toBe(1);var e=i.$field[0];w.expect(e.firstChild.textContent).toBe("Test"),w.expect(e.firstElementChild.outerHTML).toBe('<input type="date" max="2030-10-10" min="2020-10-10">')})}),w.describe("Operations",function(){w.afterEach(function(){i.hideEditor()}),w.describe("startEdit",function(){w.it("With an initial date",function(){(i=new RB.DateInlineEditorView({el:n,rawValue:t})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe(t)}),w.it("With no initial date",function(){(i=new RB.DateInlineEditorView({el:n})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe("")}),w.it("With a descriptor text",function(){(i=new RB.DateInlineEditorView({descriptorText:"Test",el:n})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe(void 0),w.expect(e.firstChild.textContent).toBe("Test"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe("")}),w.it("With a descriptor text and initial date",function(){(i=new RB.DateInlineEditorView({descriptorText:"Test",el:n,rawValue:t})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe(void 0),w.expect(e.firstChild.textContent).toBe("Test"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe(t)})}),w.describe("save",function(){w.it("With a new date",function(){(i=new RB.DateInlineEditorView({el:n})).render(),i.startEdit(),i.setValue(t),i.save(),w.expect(i.options.rawValue).toBe(t),w.expect(i.$el[0].innerHTML).toBe(t)}),w.it("With an empty value",function(){(i=new RB.DateInlineEditorView({el:n,rawValue:t})).render(),i.startEdit(),i.setValue(""),i.save(),w.expect(i.options.rawValue).toBe(""),w.expect(i.$el[0].innerHTML).toBe("")}),w.it("Without any changes made",function(){(i=new RB.DateInlineEditorView({el:n,rawValue:t})).render(),i.startEdit(),i.save(),w.expect(i.options.rawValue).toBe(t),w.expect(i.$el[0].innerHTML).toBe("")})})}),w.describe("Events",function(){w.it("On change",function(){i=new RB.DateInlineEditorView({el:n}),w.spyOn(i,"_scheduleUpdateDirtyState"),i.render(),i.$field.trigger("change"),w.expect(i._scheduleUpdateDirtyState).toHaveBeenCalled()})})}),e.suite("rb/ui/views/DateTimeInlineEditorView",function(){const t="2022-09-16T03:45";let i,n;w.beforeEach(function(){n=$("<div>").appendTo($testsScratch)}),w.describe("Construction",function(){w.it("Default",function(){(i=new RB.DateTimeInlineEditorView({el:n})).render(),w.expect(i.$buttons.length).toBe(1),w.expect(i.$field.length).toBe(1);var e=i.$field[0];w.expect(e.children.length).toBe(1),w.expect(e.firstElementChild.outerHTML).toBe('<input type="datetime-local">')}),w.it("With options provided",function(){(i=new RB.DateTimeInlineEditorView({el:n,maxDate:"2030-11-12T:06:30",minDate:"2020-10-10T15:20",rawValue:t})).render(),w.expect(i.options.minDate).toBe("2020-10-10T15:20"),w.expect(i.options.maxDate).toBe("2030-11-12T:06:30"),w.expect(i.options.rawValue).toBe(t),w.expect(i.$buttons.length).toBe(1),w.expect(i.$field.length).toBe(1);var e=i.$field[0];w.expect(e.firstElementChild.outerHTML).toBe('<input type="datetime-local" max="2030-11-12T:06:30" min="2020-10-10T15:20">')})}),w.describe("Operations",function(){w.afterEach(function(){i.hideEditor()}),w.describe("startEdit",function(){w.it("With an initial date",function(){(i=new RB.DateTimeInlineEditorView({el:n,rawValue:t})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe(t)}),w.it("With no initial date",function(){(i=new RB.DateTimeInlineEditorView({el:n})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe("")}),w.it("With a descriptor text",function(){(i=new RB.DateTimeInlineEditorView({descriptorText:"Test",el:n})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe(void 0),w.expect(e.firstChild.textContent).toBe("Test"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe("")}),w.it("With a descriptor text and initial datetime",function(){(i=new RB.DateTimeInlineEditorView({descriptorText:"Test",el:n,rawValue:t})).render(),i.startEdit();var e=i.$field[0];w.expect(e.firstChild.tagName).toBe(void 0),w.expect(e.firstChild.textContent).toBe("Test"),w.expect(e.firstElementChild.tagName).toBe("INPUT"),w.expect(e.firstElementChild.value).toBe(t)})}),w.describe("save",function(){w.it("With a new date",function(){(i=new RB.DateTimeInlineEditorView({el:n})).render(),i.startEdit(),i.setValue(t),i.save(),w.expect(i.options.rawValue).toBe(t),w.expect(i.$el[0].innerHTML).toBe(t)}),w.it("With an empty value",function(){(i=new RB.DateTimeInlineEditorView({el:n,rawValue:t})).render(),i.startEdit(),i.setValue(""),i.save(),w.expect(i.options.rawValue).toBe(""),w.expect(i.$el[0].innerHTML).toBe("")}),w.it("Without any changes made",function(){(i=new RB.DateTimeInlineEditorView({el:n,rawValue:t})).render(),i.startEdit(),i.save(),w.expect(i.options.rawValue).toBe(t),w.expect(i.$el[0].innerHTML).toBe("")})})}),w.describe("Events",function(){w.it("On change",function(){i=new RB.DateTimeInlineEditorView({el:n}),w.spyOn(i,"_scheduleUpdateDirtyState"),i.render(),i.$field.trigger("change"),w.expect(i._scheduleUpdateDirtyState).toHaveBeenCalled()})})}),e.suite("rb/ui/views/InlineEditorView",()=>{let n,o;w.beforeEach(()=>{o=$("<div>").appendTo($testsScratch)}),w.describe("Construction",()=>{w.it("Default",()=>{(n=new RB.InlineEditorView({el:o})).render(),w.expect(n.options.showEditIcon).toBe(!0),w.expect(n.$buttons.length).toBe(1),w.expect(n.$field.length).toBe(1)}),w.it("With options",()=>{(n=new RB.InlineEditorView({el:o,formClass:"test-form",showEditIcon:!1})).render(),w.expect(n.options.showEditIcon).toBe(!1),w.expect(n.$buttons.length).toBe(1),w.expect(n.$field.length).toBe(1);var e=n.$field[0];w.expect(e.form.classList.contains("test-form")).toBe(!0),w.expect(e.outerHTML).toBe('<input type="text">')})}),w.describe("Operations",()=>{w.afterEach(()=>{n.hideEditor()}),w.describe("startEdit",()=>{w.it("With an initial value",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0,rawValue:"test"})).render(),n.startEdit();var e=n.$field[0];w.expect(e.tagName).toBe("INPUT"),w.expect(e.value).toBe("test")}),w.it("With no initial value",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0})).render(),n.startEdit();var e=n.$field[0];w.expect(e.tagName).toBe("INPUT"),w.expect(e.value).toBe("")})}),w.describe("save",()=>{w.it("With a new value",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0,rawValue:"initial"})).render(),n.startEdit();let i=!1;n.once("complete",(e,t)=>{w.expect(e).toBe("test"),w.expect(t).toBe("initial"),i=!0}),n.once("cancel",()=>{w.fail()}),n.setValue("test"),n.save(),w.expect(i).toBe(!0)}),w.it("With an empty value",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0,rawValue:"initial"})).render(),n.startEdit();let i=!1;n.once("complete",(e,t)=>{w.expect(e).toBe(""),w.expect(t).toBe("initial"),i=!0}),n.once("cancel",()=>{w.fail()}),n.setValue(""),n.save(),w.expect(i).toBe(!0)}),w.it("Without any changes made",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0,rawValue:"initial"})).render(),n.startEdit();let t=!1;n.once("complete",()=>{w.fail()}),n.once("cancel",e=>{w.expect(e).toBe("initial"),t=!0}),n.save(),w.expect(t).toBe(!0)}),w.it("With notifyUnchangedCompletion",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0,notifyUnchangedCompletion:!0,rawValue:"initial"})).render(),n.startEdit();let i=!1;n.once("complete",(e,t)=>{w.expect(e).toBe("initial"),w.expect(t).toBe("initial"),i=!0}),n.once("cancel",()=>{w.fail()}),n.save(),w.expect(i).toBe(!0)}),w.it("With preventEvents",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0,rawValue:"initial"})).render(),n.startEdit(),n.once("complete",()=>{w.fail()}),n.setValue("value");var e=n.save({preventEvents:!0});w.expect(e).toBe("value")}),w.it("With preventEvents and no change",()=>{(n=new RB.InlineEditorView({el:o,hasRawValue:!0,rawValue:"initial"})).render(),n.startEdit(),n.once("complete",()=>{w.fail()});var e=n.save({preventEvents:!0});w.expect(e).toBe(void 0)})})}),w.describe("Events",()=>{w.it("On keydown enter",()=>{n=new RB.InlineEditorView({el:o}),w.spyOn(n,"submit"),n.render(),n.$field[0].dispatchEvent(new KeyboardEvent("keydown",{key:"Enter"})),w.expect(n.submit).toHaveBeenCalled()}),w.it("On keydown enter with multiline",()=>{n=new RB.InlineEditorView({el:o,multiline:!0}),w.spyOn(n,"submit"),n.render(),n.$field[0].dispatchEvent(new KeyboardEvent("keydown",{key:"Enter"})),w.expect(n.submit).not.toHaveBeenCalled()}),w.it("On keydown ctrl+enter with multiline",()=>{n=new RB.InlineEditorView({el:o,multiline:!0}),w.spyOn(n,"submit"),n.render(),n.$field[0].dispatchEvent(new KeyboardEvent("keydown",{ctrlKey:!0,key:"Enter"})),w.expect(n.submit).toHaveBeenCalled()}),w.it("On keyup",()=>{n=new RB.InlineEditorView({el:o}),w.spyOn(n,"_scheduleUpdateDirtyState"),n.render(),n.$field[0].dispatchEvent(new KeyboardEvent("keyup",{key:"A"})),w.expect(n._scheduleUpdateDirtyState).toHaveBeenCalled()}),w.it("On cut",()=>{n=new RB.InlineEditorView({el:o}),w.spyOn(n,"_scheduleUpdateDirtyState"),n.render(),n.$field[0].dispatchEvent(new ClipboardEvent("cut")),w.expect(n._scheduleUpdateDirtyState).toHaveBeenCalled()}),w.it("On paste",()=>{n=new RB.InlineEditorView({el:o}),w.spyOn(n,"_scheduleUpdateDirtyState"),n.render(),n.$field[0].dispatchEvent(new ClipboardEvent("paste")),w.expect(n._scheduleUpdateDirtyState).toHaveBeenCalled()})})}),e.suite("rb/ui/views/TextEditorView",function(){let i;w.beforeEach(function(){RB.DnDUploader.create()}),w.afterEach(function(){RB.DnDUploader.instance=null}),w.describe("Construction",function(){w.it("Initial text",function(){(i=new RB.TextEditorView({text:"Test"})).render(),w.expect(i.getText()).toBe("Test")}),w.describe("Text field wrapper",function(){w.it("If plain text",function(){(i=new RB.TextEditorView({richText:!1})).render(),i.show(),w.expect(i.richText).toBe(!1),w.expect(i.$el.children("textarea").length).toBe(1),w.expect(i.$el.children(".CodeMirror").length).toBe(0)}),w.it("If Markdown",function(){(i=new RB.TextEditorView({richText:!0})).render(),i.show(),w.expect(i.richText).toBe(!0),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(1)})}),w.describe("Default richText",function(){w.describe("If user default is true",function(){w.beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",!0)}),w.it("And richText unset",function(){(i=new RB.TextEditorView).render(),i.show(),w.expect(i.richText).toBe(!0),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(1)}),w.it("And richText=true",function(){(i=new RB.TextEditorView({richText:!0})).render(),i.show(),w.expect(i.richText).toBe(!0),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(1)}),w.it("And richText=false",function(){(i=new RB.TextEditorView({richText:!1})).render(),i.show(),w.expect(i.richText).toBe(!0),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(1)})}),w.describe("If user default is false",function(){w.beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",!1)}),w.it("And richText unset",function(){(i=new RB.TextEditorView).render(),i.show(),w.expect(i.richText).toBe(!1),w.expect(i.$el.children("textarea").length).toBe(1),w.expect(i.$el.children(".CodeMirror").length).toBe(0)}),w.it("And richText=true",function(){(i=new RB.TextEditorView({richText:!0})).render(),i.show(),w.expect(i.richText).toBe(!0),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(1)}),w.it("And richText=false",function(){(i=new RB.TextEditorView({richText:!1})).render(),i.show(),w.expect(i.richText).toBe(!1),w.expect(i.$el.children("textarea").length).toBe(1),w.expect(i.$el.children(".CodeMirror").length).toBe(0)})})})}),w.describe("Operations",function(){w.describe("bindRichTextAttr",function(){let e;w.beforeEach(function(){e=new Backbone.Model({richText:!1}),i=new RB.TextEditorView}),w.it("Updates on change",function(){i.bindRichTextAttr(e,"richText"),w.expect(i.richText).toBe(!1),e.set("richText",!0),w.expect(i.richText).toBe(!0)}),w.describe("Initial richText value",function(){w.it("true",function(){e.set("richText",!0),i.bindRichTextAttr(e,"richText"),w.expect(i.richText).toBe(!0)}),w.it("false",function(){e.set("richText",!1),i.bindRichTextAttr(e,"richText"),w.expect(i.richText).toBe(!1)})})}),w.describe("bindRichTextCheckbox",function(){let e;w.beforeEach(function(){e=$('<input type="checkbox">'),(i=new RB.TextEditorView).setRichText(!1)}),w.it("Checkbox reflects richText",function(){i.bindRichTextCheckbox(e),w.expect(e.prop("checked")).toBe(!1),i.setRichText(!0),w.expect(e.prop("checked")).toBe(!0)}),w.describe("richText reflects checkbox",function(){w.it("Checked",function(){i.setRichText(!1),i.bindRichTextCheckbox(e),e.prop("checked",!0).triggerHandler("change"),w.expect(i.richText).toBe(!0)}),w.it("Unchecked",function(){i.setRichText(!0),i.bindRichTextCheckbox(e),e.prop("checked",!1).triggerHandler("change"),w.expect(i.richText).toBe(!1)})}),w.describe("Initial checked state",function(){w.it("richText=true",function(){i.setRichText(!0),i.bindRichTextCheckbox(e),w.expect(e.prop("checked")).toBe(!0)}),w.it("richText=false",function(){i.setRichText(!1),i.bindRichTextCheckbox(e),w.expect(e.prop("checked")).toBe(!1)})})}),w.describe("bindRichTextVisibility",function(){let t;w.beforeEach(function(){t=$("<div>"),(i=new RB.TextEditorView).setRichText(!1)}),w.describe("Initial visibility",function(){w.it("richText=true",function(){t.hide(),i.setRichText(!0),i.bindRichTextVisibility(t);var e=t.css("display");w.expect("block"===e||""===e).toBe(!0)}),w.it("richText=false",function(){i.bindRichTextVisibility(t),w.expect(t.css("display")).toBe("none")})}),w.describe("Toggles visibility on change",function(){w.it("richText=true",function(){t.hide(),i.bindRichTextVisibility(t),w.expect(t.css("display")).toBe("none"),i.setRichText(!0);var e=t.css("display");w.expect("block"===e||""===e).toBe(!0)}),w.it("richText=false",function(){i.setRichText(!0),i.bindRichTextVisibility(t);var e=t.css("display");w.expect("block"===e||""===e).toBe(!0),i.setRichText(!1),w.expect(t.css("display")).toBe("none")})})}),w.describe("setRichText",function(){w.it("Emits change:richText",function(){let e=!1;i.on("change:richText",function(){e=!0}),i.show(),i.richText=!1,i.setRichText(!0),w.expect(e).toBe(!0)}),w.it("Emits change",function(){let e=!1;i.on("change",function(){e=!0}),i.show(),i.richText=!1,i.setRichText(!0),w.expect(e).toBe(!0)}),w.it("Marks dirty",function(){i.show(),i.richText=!1,w.expect(i.isDirty()).toBe(!1),i.setRichText(!0),w.expect(i.isDirty()).toBe(!0)}),w.describe("Markdown to Text",function(){w.beforeEach(function(){(i=new RB.TextEditorView({richText:!0})).render()}),w.it("If shown",function(){i.show(),i.setRichText(!1),w.expect(i.richText).toBe(!1),w.expect(i.$el.children("textarea").length).toBe(1),w.expect(i.$el.children(".CodeMirror").length).toBe(0)}),w.it("If hidden",function(){i.setRichText(!1),w.expect(i.richText).toBe(!1),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(0)})}),w.describe("Text to Markdown",function(){w.beforeEach(function(){(i=new RB.TextEditorView({richText:!1})).render()}),w.it("If shown",function(){i.show(),i.setRichText(!0),w.expect(i.richText).toBe(!0),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(1)}),w.it("If hidden",function(){i.setRichText(!0),w.expect(i.richText).toBe(!0),w.expect(i.$el.children("textarea").length).toBe(0),w.expect(i.$el.children(".CodeMirror").length).toBe(0)})})}),w.describe("setText",function(){w.describe("If shown",function(){w.it("If plain text",function(){(i=new RB.TextEditorView({richText:!1})).show(),i.setText("Test"),w.expect(i.$("textarea").val()).toBe("Test")}),w.it("If Markdown",function(){(i=new RB.TextEditorView({richText:!0})).show(),i.setText("Test"),w.expect(i._editor._codeMirror.getValue()).toBe("Test")})}),w.it("If hidden",function(){(i=new RB.TextEditorView).setText("Test"),w.expect(i.getText()).toBe("Test")})}),w.describe("getText",function(){w.it("If plain text",function(){(i=new RB.TextEditorView({richText:!1})).show(),i.setText("Test"),w.expect(i.getText()).toBe("Test")}),w.it("If Markdown",function(){(i=new RB.TextEditorView({richText:!0})).show(),i.setText("Test"),w.expect(i.getText()).toBe("Test")})}),w.describe("insertLine",function(){w.it("If plain text",function(){(i=new RB.TextEditorView({richText:!1})).show(),i.setText("Test"),i.insertLine("Test"),w.expect(i.getText()).toBe("Test\nTest")}),w.it("If Markdown",function(){(i=new RB.TextEditorView({richText:!0})).show(),i.setText("Test"),i.insertLine("Test"),w.expect(i.getText()).toBe("Test\nTest")})}),w.describe("show",function(){w.it("registers drop target if rich text",function(){w.spyOn(RB.DnDUploader.instance,"registerDropTarget"),(i=new RB.TextEditorView({richText:!0})).show(),w.expect(RB.DnDUploader.instance.registerDropTarget).toHaveBeenCalled()}),w.it("does not register drop target if plain text",function(){w.spyOn(RB.DnDUploader.instance,"registerDropTarget"),(i=new RB.TextEditorView({richText:!1})).show(),w.expect(RB.DnDUploader.instance.registerDropTarget).not.toHaveBeenCalled()})}),w.describe("hide",function(){w.it("disables drop target",function(){w.spyOn(RB.DnDUploader.instance,"unregisterDropTarget"),(i=new RB.TextEditorView({richText:!0})).show(),i.hide(),w.expect(RB.DnDUploader.instance.unregisterDropTarget).toHaveBeenCalled()})})}),w.describe("Drag and Drop",function(){w.beforeEach(function(){i=new RB.TextEditorView({richText:!0})}),w.describe("_isImage",function(){w.it("correctly checks mimetype",function(){w.expect(i._isImage({name:"testimage.jpg",type:"image/jpeg"})).toBe(!0)}),w.it("checks filename extension",function(){w.expect(i._isImage({name:"testimage.jpg"})).toBe(!0)}),w.it("returns false when given invalid type",function(){w.expect(i._isImage({name:"testimage.jps",type:"application/json"})).toBe(!1)})})}),w.describe("Markdown formatting toolbar",()=>{w.describe("Rich text",()=>{w.it("Enabled",()=>{(i=new RB.TextEditorView({richText:!0})).show(),w.expect(i.$(".rb-c-formatting-toolbar").length).toBe(1)}),w.it("Disabled",()=>{(i=new RB.TextEditorView({richText:!1})).show(),w.expect(i.$(".rb-c-formatting-toolbar").length).toBe(0)})}),w.describe("Buttons",()=>{let e;w.beforeEach(()=>{(i=new RB.TextEditorView({richText:!0})).show(),e=i._editor._codeMirror}),w.describe("Bold",()=>{w.it("Empty selection with no text toggles syntax",()=>{w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-bold").click(),w.expect(i.getText()).toBe("****"),w.expect(e.getCursor().ch).toBe(2),i.$(".rb-c-formatting-toolbar__btn-bold").click(),w.expect(i.getText()).toBe(""),w.expect(e.getCursor().ch).toBe(0)}),w.it("Empty selection with cursor in unformatted text inserts syntax around text",()=>{i.setText("Test"),w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-bold").click(),w.expect(i.getText()).toBe("**Test**"),w.expect(e.getCursor().ch).toBe(6)}),w.it("Empty selection with cursor in formatted text removes syntax around text",()=>{i.setText("**Test**"),e.setSelection({ch:2,line:0},{ch:6,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-bold").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Unformatted text selection inserts syntax around text",()=>{i.setText("Test"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-bold").click(),w.expect(i.getText()).toBe("**Test**"),w.expect(e.getCursor().ch).toBe(8)}),w.it("Formatted text selection with only text removes syntax",()=>{i.setText("**Test**"),e.setSelection({ch:2,line:0},{ch:6,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-bold").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection including formatting removes syntax",()=>{i.setText("**Test**"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("**Test**"),i.$(".rb-c-formatting-toolbar__btn-bold").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)})}),w.describe("Italic",()=>{w.it("Empty selection with no text toggles syntax",()=>{w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-italic").click(),w.expect(i.getText()).toBe("__"),w.expect(e.getCursor().ch).toBe(1),i.$(".rb-c-formatting-toolbar__btn-italic").click(),w.expect(i.getText()).toBe(""),w.expect(e.getCursor().ch).toBe(0)}),w.it("Empty selection with cursor in unformatted text inserts syntax around text",()=>{i.setText("Test"),w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-italic").click(),w.expect(i.getText()).toBe("_Test_"),w.expect(e.getCursor().ch).toBe(5)}),w.it("Empty selection with cursor in formatted text removes syntax around text",()=>{i.setText("_Test_"),e.setSelection({ch:1,line:0},{ch:5,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-italic").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Unformatted text selection inserts syntax around text",()=>{i.setText("Test"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-italic").click(),w.expect(i.getText()).toBe("_Test_"),w.expect(e.getCursor().ch).toBe(6)}),w.it("Formatted text selection with only text removes syntax",()=>{i.setText("_Test_"),e.setSelection({ch:1,line:0},{ch:5,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-italic").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection including formatting removes syntax",()=>{i.setText("_Test_"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("_Test_"),i.$(".rb-c-formatting-toolbar__btn-italic").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)})}),w.describe("Strikethrough",()=>{w.it("Empty selection with no text toggles syntax",()=>{w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-strikethrough").click(),w.expect(i.getText()).toBe("~~~~"),w.expect(e.getCursor().ch).toBe(2),i.$(".rb-c-formatting-toolbar__btn-strikethrough").click(),w.expect(i.getText()).toBe(""),w.expect(e.getCursor().ch).toBe(0)}),w.it("Empty selection with cursor in unformatted text inserts syntax around text",()=>{i.setText("Test"),w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-strikethrough").click(),w.expect(i.getText()).toBe("~~Test~~"),w.expect(e.getCursor().ch).toBe(6)}),w.it("Empty selection with cursor in formatted text removes syntax around text",()=>{i.setText("~~Test~~"),e.setSelection({ch:2,line:0},{ch:6,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-strikethrough").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Unformatted text selection inserts syntax around text",()=>{i.setText("Test"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-strikethrough").click(),w.expect(i.getText()).toBe("~~Test~~"),w.expect(e.getCursor().ch).toBe(8)}),w.it("Formatted text selection with only text removes syntax",()=>{i.setText("~~Test~~"),e.setSelection({ch:2,line:0},{ch:6,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-strikethrough").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection including formatting removes syntax",()=>{i.setText("~~Test~~"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("~~Test~~"),i.$(".rb-c-formatting-toolbar__btn-strikethrough").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)})}),w.describe("Code",()=>{w.it("Empty selection with no text toggles syntax",()=>{w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-code").click(),w.expect(i.getText()).toBe("``"),w.expect(e.getCursor().ch).toBe(1),i.$(".rb-c-formatting-toolbar__btn-code").click(),w.expect(i.getText()).toBe(""),w.expect(e.getCursor().ch).toBe(0)}),w.it("Empty selection with cursor in unformatted text inserts syntax around text",()=>{i.setText("Test"),w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-code").click(),w.expect(i.getText()).toBe("`Test`"),w.expect(e.getCursor().ch).toBe(5)}),w.it("Empty selection with cursor in formatted text removes syntax around text",()=>{i.setText("`Test`"),e.setSelection({ch:1,line:0},{ch:5,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-code").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Unformatted text selection inserts syntax around text",()=>{i.setText("Test"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-code").click(),w.expect(i.getText()).toBe("`Test`"),w.expect(e.getCursor().ch).toBe(6)}),w.it("Formatted text selection with only text removes syntax",()=>{i.setText("`Test`"),e.setSelection({ch:1,line:0},{ch:5,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-code").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection including formatting removes syntax",()=>{i.setText("`Test`"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("`Test`"),i.$(".rb-c-formatting-toolbar__btn-code").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)})}),w.describe("Unordered list",()=>{w.it("Empty selection with no text toggles syntax",()=>{w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("- "),w.expect(e.getCursor().ch).toBe(2),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe(""),w.expect(e.getCursor().ch).toBe(0)}),w.it("Empty selection with cursor in text toggles syntax",()=>{i.setText("Test"),e.setCursor({ch:2,line:0}),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("- Test"),w.expect(e.getCursor().ch).toBe(4),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(2)}),w.it("Unformatted text selection toggles syntax",()=>{i.setText("Test"),e.execCommand("selectAll"),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("- Test"),w.expect(e.getCursor().ch).toBe(6),e.execCommand("selectAll"),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection with only text removes syntax",()=>{i.setText("- Test"),e.setSelection({ch:2,line:0},{ch:6,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection including formatting removes syntax",()=>{i.setText("- Test"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("- Test"),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getSelection()).toBe("Test")}),w.it("Lines with multiple text groups get syntax added to beginning of the line",()=>{i.setText("Test more text"),e.setCursor({ch:6,line:0}),i.$(".rb-c-formatting-toolbar__btn-list-ul").click(),w.expect(i.getText()).toBe("- Test more text"),w.expect(e.getCursor().ch).toBe(8)})}),w.describe("Ordered list",()=>{w.it("Empty selection with no text toggles syntax",()=>{w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("1. "),w.expect(e.getCursor().ch).toBe(3),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe(""),w.expect(e.getCursor().ch).toBe(0)}),w.it("Empty selection with cursor in text toggles syntax",()=>{i.setText("Test"),e.setCursor({ch:2,line:0}),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("1. Test"),w.expect(e.getCursor().ch).toBe(5),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(2)}),w.it("Unformatted text selection toggles syntax",()=>{i.setText("Test"),e.execCommand("selectAll"),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("1. Test"),w.expect(e.getCursor().ch).toBe(7),e.execCommand("selectAll"),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection with only text removes syntax",()=>{i.setText("1. Test"),e.setSelection({ch:3,line:0},{ch:7,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection including formatting removes syntax",()=>{i.setText("1. Test"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("1. Test"),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getSelection()).toBe("Test")}),w.it("Lines with multiple text groups get syntax added to beginning of the line",()=>{i.setText("Test more text"),e.setCursor({ch:6,line:0}),i.$(".rb-c-formatting-toolbar__btn-list-ol").click(),w.expect(i.getText()).toBe("1. Test more text"),w.expect(e.getCursor().ch).toBe(9)})}),w.describe("Link",()=>{w.it("Empty selection with no text toggles syntax",()=>{w.expect(e.getSelection()).toBe(""),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe("[](url)"),w.expect(e.getCursor().ch).toBe(1),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe(""),w.expect(e.getCursor().ch).toBe(0)}),w.it("Empty selection with cursor in text toggles syntax",()=>{i.setText("Test"),e.setCursor({ch:2,line:0}),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe("[Test](url)"),w.expect(e.getSelection()).toBe("url"),w.expect(e.getCursor().ch).toBe(10),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getSelection()).toBe(""),w.expect(e.getCursor().ch).toBe(4)}),w.it("Unformatted text selection toggles syntax",()=>{i.setText("Test"),e.execCommand("selectAll"),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe("[Test](url)"),w.expect(e.getSelection()).toBe("url"),w.expect(e.getCursor().ch).toBe(10),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getSelection()).toBe(""),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection with only text removes syntax",()=>{i.setText("[Test](example.com)"),e.setSelection({ch:1,line:0},{ch:5,line:0}),w.expect(e.getSelection()).toBe("Test"),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getSelection()).toBe(""),w.expect(e.getCursor().ch).toBe(4)}),w.it("Formatted text selection including formatting removes syntax",()=>{i.setText("[Test](example.com)"),e.execCommand("selectAll"),w.expect(e.getSelection()).toBe("[Test](example.com)"),i.$(".rb-c-formatting-toolbar__btn-link").click(),w.expect(i.getText()).toBe("Test"),w.expect(e.getSelection()).toBe(""),w.expect(e.getCursor().ch).toBe(4)})})})})})},"object"==typeof exports&&"undefined"!=typeof module?t(require("@beanbag/jasmine-suites"),require("jasmine-core"),require("@beanbag/spina")):"function"==typeof define&&define.amd?define(["@beanbag/jasmine-suites","jasmine-core","@beanbag/spina"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).window,e.window,e.Spina),suite("rb/admin/views/relatedGroupSelectorView",function(){describe("Rendering",function(){it("when empty",function(){var e=new RB.RelatedGroupSelectorView({$input:$('<input id="id_groups" type="hidden">'),initialOptions:[],multivalued:!0,inviteOnly:!1});expect(e.options.multivalued).toBe(!0),expect(e.options.inviteOnly).toBe(!1),e.render(),expect(e.$el.find(".related-object-selected li").length).toBe(0)})}),describe("Rendering",function(){it("with initial options",function(){var e=new RB.RelatedGroupSelectorView({$input:$('<input id="id_groups" type="hidden">'),initialOptions:[{id:1,display_name:"Test Repository 1",name:"test_repo_1",invite_only:!1},{id:2,display_name:"Test Repository 2",name:"test_repo_2",invite_only:!0}],multivalued:!0,inviteOnly:!0});e.render(),expect(e.options.multivalued).toBe(!0),expect(e.options.inviteOnly).toBe(!0),expect(e.$el.find(".related-object-selected li").length).toBe(2),expect(e.$el.siblings("#id_groups").val()).toBe(""),expect(e._selectedIDs.size).toBe(2)})}),describe("Select item",function(){let t;beforeEach(function(e){$testsScratch.append('<input id="id_groups" type="hidden">'),(t=new RB.RelatedGroupSelectorView({$input:$("#id_groups"),initialOptions:[],multivalued:!0})).render(),spyOn(t,"loadOptions").and.callFake(function(e,t){t([{id:1,display_name:"Test Repository 1",name:"test_repo_1",invite_only:!1},{id:2,display_name:"Test Repository 2",name:"test_repo_2",invite_only:!0}])}),$("select")[0].selectize.focus(),setTimeout(function(){$testsScratch.find("div .selectize-input.items.not-full input").click(),e()},4e3)}),it("from dropdown",function(e){expect(t.loadOptions).toHaveBeenCalled(),$("div[data-value='test_repo_1']").click(),$("div[data-value='test_repo_2']").click(),expect(t.$el.siblings("#id_groups").val()).toBe("1,2"),e()})})}),suite("rb/admin/views/relatedRepoSelectorView",function(){describe("Rendering",function(){it("when empty",function(){var e=new RB.RelatedRepoSelectorView({$input:$('<input id="id_repos" type="hidden">'),initialOptions:[],multivalued:!0});expect(e.options.multivalued).toBe(!0),e.render(),expect(e.$el.find(".related-object-selected li").length).toBe(0)})}),describe("Rendering",function(){it("with initial options",function(){var e=new RB.RelatedRepoSelectorView({$input:$('<input id="id_repos" type="hidden">'),initialOptions:[{id:1,name:"Test Repository 1"},{id:2,name:"Test Repository 2"}],multivalued:!0});e.render(),expect(e.options.multivalued).toBe(!0),expect(e.$el.find(".related-object-selected li").length).toBe(2),expect(e.$el.siblings("#id_repos").val()).toBe(""),expect(e._selectedIDs.size).toBe(2)})}),describe("Select item",function(){let t;beforeEach(function(e){$testsScratch.append('<input id="id_repos" type="hidden">'),(t=new RB.RelatedRepoSelectorView({$input:$("#id_repos"),initialOptions:[],multivalued:!0})).render(),spyOn(t,"loadOptions").and.callFake(function(e,t){t([{id:1,name:"Test Repository 1"},{id:2,name:"Test Repository 2"}])}),$("select")[0].selectize.focus(),setTimeout(function(){$testsScratch.find("div .selectize-input.items.not-full input").click(),e()},4e3)}),it("from dropdown",function(e){expect(t.loadOptions).toHaveBeenCalled(),$("div[data-value='Test Repository 1']").click(),$("div[data-value='Test Repository 2']").click(),expect(t.$el.siblings("#id_repos").val()).toBe("1,2"),e()})})}),suite("rb/admin/views/relatedUserSelectorView",function(){describe("Rendering",function(){it("when empty",function(){var e=new RB.RelatedUserSelectorView({$input:$('<input id="id_people" type="hidden">'),initialOptions:[],useAvatars:!0,multivalued:!0});expect(e.options.useAvatars).toBe(!0),expect(e.options.multivalued).toBe(!0),e.render(),expect(e.$el.find(".related-object-selected li").length).toBe(0)})}),describe("Rendering",function(){it("with initial options",function(){var e=new RB.RelatedUserSelectorView({$input:$('<input id="id_people" type="hidden">'),initialOptions:[{username:"admin",fullname:"Admin User",id:1,avatarHTML:{20:'<div class="avatar" alt="Admin User"></div>'}},{username:"doc",fullname:"Doc Dwarf",id:2,avatarHTML:{20:'<div class="avatar" alt="Doc Dwarf"></div>'}},{username:"dopey",fullname:"Dopey Dwarf",id:3,avatarHTML:{20:'<div class="avatar" alt="Dopey Dwarf"></div>'}}],useAvatars:!0,multivalued:!0});e.render(),expect(e.options.useAvatars).toBe(!0),expect(e.options.multivalued).toBe(!0),expect(e.$el.find(".related-object-selected tr").length).toBe(3),expect(e.$el.siblings("#id_people").val()).toBe(""),expect(e._selectedIDs.size).toBe(3)})}),describe("Select item",function(){let t;beforeEach(function(e){$testsScratch.append('<input id="id_people" type="hidden">'),(t=new RB.RelatedUserSelectorView({$input:$("#id_people"),initialOptions:[],useAvatars:!0,multivalued:!0})).render(),spyOn(t,"loadOptions").and.callFake(function(e,t){t([{avatarHTML:{20:'<div class="avatar" alt="Admin User"></div>'},fullname:"Admin User",id:1,username:"admin"},{avatarHTML:{20:'<div class="avatar" alt="Doc Dwarf"></div>'},fullname:"Doc Dwarf",id:2,username:"doc"}])}),$("select")[0].selectize.focus(),setTimeout(function(){$testsScratch.find("div .selectize-input.items.not-full input").click(),e()},4e3)}),it("from dropdown",function(e){expect(t.loadOptions).toHaveBeenCalled(),$("div[data-value='admin']").click(),$("div[data-value='doc']").click(),expect(t.$el.siblings("#id_people").val()).toBe("1,2"),e()})})}),suite("rb/admin/models/DashboardPage",function(){let n;beforeEach(function(){n=new RB.Admin.DashboardPage}),describe("Widgets",function(){it("Loading",function(){n.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget",modelAttrs:{myAttr:1},viewOptions:{myOption:!0}},{id:"widget-2",domID:"widget-2",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget",modelAttrs:{myAttr:2},viewOptions:{myOption:!1}}]);var e=jasmine.createSpy(),t=(n.loadWidgets(e),expect(n.widgets.length).toBe(2),n.widgets.at(0)),i=n.widgets.at(1);expect(t).toBeInstanceOf(RB.Admin.Widget),expect(t.get("myAttr")).toBe(1),expect(i).toBeInstanceOf(RB.Admin.Widget),expect(i.get("myAttr")).toBe(2),expect(e).toHaveBeenCalledTimes(2),expect(e).toHaveBeenCalledWith({domID:"widget-1",ViewType:RB.Admin.WidgetView,viewOptions:{myOption:!0},widgetModel:t}),expect(e).toHaveBeenCalledWith({domID:"widget-2",ViewType:RB.Admin.WidgetView,viewOptions:{myOption:!1},widgetModel:i})}),it("Loading errors sandboxed",function(){spyOn(console,"error"),n.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"BadViewClass",modelClass:"BadModelClass"},{id:"widget-2",domID:"widget-2",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget",modelAttrs:{myAttr:2},viewOptions:{myOption:!1}}]);var e=jasmine.createSpy(),t=(n.loadWidgets(e),expect(n.widgets.length).toBe(1),n.widgets.at(0)),e=(expect(t).toBeInstanceOf(RB.Admin.Widget),expect(e).toHaveBeenCalledTimes(1),expect(e).toHaveBeenCalledWith({domID:"widget-2",ViewType:RB.Admin.WidgetView,viewOptions:{myOption:!1},widgetModel:t}),expect(console.error).toHaveBeenCalled(),console.error.calls.argsFor(0));expect(e[0]).toBe('Unable to render administration widget "%s": %s'),expect(e[1]).toBe("widget-1")})})}),suite("rb/admin/models/InlineFormGroup",function(){let e;beforeEach(function(){e=new RB.Admin.InlineFormGroup}),describe("Methods",function(){describe("canAddInline",function(){it("With no limit",function(){e.set("maxInlines",null),expect(e.canAddInline()).toBeTrue()}),it("With limit not reached",function(){e.set("maxInlines",2),e.inlines.add({}),expect(e.canAddInline()).toBeTrue()}),it("With limit reached",function(){e.set("maxInlines",2),e.inlines.add([{},{}]),expect(e.canAddInline()).toBeFalse()})})})}),suite("rb/admin/models/NewsWidget",function(){let i;beforeEach(function(){i=new RB.Admin.NewsWidget({rssURL:"http://example.com/news/rss"})}),describe("Methods",function(){describe("loadNews",function(){it("Success",function(){var e=jasmine.createSpy(),e=(spyOn($,"ajax").and.callFake(function(e,t){expect(e).toBe("http://example.com/news/rss"),e=new DOMParser,t.success(e.parseFromString(`<?xml version="1.0" encoding="utf-8"?>

<rss xmlns:atom="http://www.w3.org/2005/Atom"
     version="2.0">
 <channel>
  <title>Channel Name</title>
  <link>http://example.com/news/</link>
  <description>Channel description...</description>
  <atom:link href="http://example.com/news/rss"
             rel="self"></atom:link>
  <language>en-us</language>
  <lastBuildDate>Sun, 20 Oct 2019 17:26:32 -0700</lastBuildDate>
  <item>
   <title>Headline 6</title>
   <pubDate>Sun, 20 Oct 2019 17:26:32 -0700</pubDate>
   <link>http://example.com/news/post6</link>
   <description>Brief summary of 6</description>
   <author>user1@example.com</author>
   <guid>http://example.com/news/post6</guid>
  </item>
  <item>
   <title>Headline 5</title>
   <pubDate>Tue, 01 Oct 2019 13:29:00 -0700</pubDate>
   <link>http://example.com/news/post5</link>
   <description>Brief summary of 5</description>
   <author>user2@example.com</author>
   <guid>http://example.com/news/post5</guid>
  </item>
  <item>
   <title>Headline 4</title>
   <pubDate>Thu, 26 Sep 2019 19:29:33 -0700</pubDate>
   <link>http://example.com/news/post4</link>
   <description>Brief summary of 4</description>
   <author>user1@example.com</author>
   <guid>http://example.com/news/post4</guid>
  </item>
  <item>
   <title>Headline 3</title>
   <pubDate>Sun, 08 Sep 2019 11:27:05 -0700</pubDate>
   <link>http://example.com/news/post3</link>
   <description>Brief summary of 3</description>
   <author>user2@example.com</author>
   <guid>http://example.com/news/post3</guid>
  </item>
  <item>
   <title>Headline 2</title>
   <pubDate>Fri, 30 Aug 2019 23:15:01 -0700</pubDate>
   <link>http://example.com/news/post2</link>
   <description>Brief summary of 2</description>
   <author>user1@example.com</author>
   <guid>http://example.com/news/post2</guid>
  </item>
  <item>
   <title>Headline 1</title>
   <pubDate>Thu, 29 Aug 2019 14:30:00 -0700</pubDate>
   <link>http://example.com/news/post1</link>
   <description>Brief summary of 1</description>
   <author>user2@example.com</author>
   <guid>http://example.com/news/post1</guid>
  </item>
 </channel>
</rss>`,"application/xml"))}),i.on("loadingNews",e),i.loadNews(),expect(e).toHaveBeenCalled(),expect($.ajax).toHaveBeenCalled(),i.get("newsItems"));expect(e.length).toBe(5);let t=e[0];expect(t.date.isSame(Date.UTC(2019,9,21,0,26,32))).toBeTrue(),expect(t.title).toBe("Headline 6"),expect(t.url).toBe("http://example.com/news/post6"),t=e[1],expect(t.date.isSame(Date.UTC(2019,9,1,20,29,0))).toBeTrue(),expect(t.title).toBe("Headline 5"),expect(t.url).toBe("http://example.com/news/post5"),t=e[2],expect(t.date.isSame(Date.UTC(2019,8,27,2,29,33))).toBeTrue(),expect(t.title).toBe("Headline 4"),expect(t.url).toBe("http://example.com/news/post4"),t=e[3],expect(t.date.isSame(Date.UTC(2019,8,8,18,27,5))).toBeTrue(),expect(t.title).toBe("Headline 3"),expect(t.url).toBe("http://example.com/news/post3"),t=e[4],expect(t.date.isSame(Date.UTC(2019,7,31,6,15,1))).toBeTrue(),expect(t.title).toBe("Headline 2"),expect(t.url).toBe("http://example.com/news/post2")}),it("Error loading feed",function(){var e=jasmine.createSpy(),e=(spyOn($,"ajax").and.callFake(function(e,t){expect(e).toBe("http://example.com/news/rss"),t.error()}),i.on("loadingNews",e),i.loadNews(),expect(e).toHaveBeenCalled(),expect($.ajax).toHaveBeenCalled(),i.get("newsItems"));expect(e.length).toBe(0)})})})}),suite("rb/admin/views/DashboardPageView",function(){const i=_.template(`<div class="rb-c-admin-widget <%- cssClasses %>" id="<%- domID %>"
 <header class="rb-c-admin-widget__header">
  <h1><%- name %></h1>
  <ul class="rb-c-admin-widget__actions"></ul>
 </header>
 <div class="rb-c-admin-widget__content"></div>
 <footer class="rb-c-admin-widget__footer">
  <ul class="rb-c-admin-widget__actions"></ul>
 </footer>
</div>`);let n,o;beforeEach(function(){spyOn(RB.HeaderView.prototype,"_ensureSingleton"),n=new RB.Admin.DashboardPage,o=new RB.Admin.DashboardPageView({el:$(`<div>
 <div id="admin-dashboard" style="visibility: hidden">
  <div class="rb-c-admin-widgets">
   <div class="rb-c-admin-widgets__sizer-gutter"></div>
   <div class="rb-c-admin-widgets__sizer-column"></div>
   <div class="rb-c-admin-widgets__main"></div>
  </div>
 </div>
</div>`).appendTo($testsScratch),model:n})}),describe("Widgets",function(){it("Loading",function(){o.$(".rb-c-admin-widgets__main").append(i({domID:"widget-1",name:"Widget 1",cssClasses:"-is-small"}),i({domID:"widget-2",name:"Widget 2",cssClasses:""}),i({domID:"widget-3",name:"Widget 3",cssClasses:"-is-large"}),i({domID:"widget-4",name:"Widget 4",cssClasses:"-is-small"}),i({domID:"widget-5",name:"Widget 5",cssClasses:""}),i({domID:"widget-6",name:"Widget 6",cssClasses:"-is-full-size"})),n.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-2",domID:"widget-2",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-3",domID:"widget-3",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-4",domID:"widget-4",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-5",domID:"widget-5",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-6",domID:"widget-6",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"}]),o.render();var e=o._$widgets,t=(expect(e.length).toBe(6),expect(e[0].id).toBe("widget-1"),expect(e[1].id).toBe("widget-2"),expect(e[2].id).toBe("widget-3"),expect(e[3].id).toBe("widget-4"),expect(e[4].id).toBe("widget-5"),expect(e[5].id).toBe("widget-6"),expect(e[0]).toHaveClass("js-masonry-item"),expect(e[1]).toHaveClass("js-masonry-item"),expect(e[2]).toHaveClass("js-masonry-item"),expect(e[3]).toHaveClass("js-masonry-item"),expect(e[4]).toHaveClass("js-masonry-item"),expect(e[5]).toHaveClass("js-masonry-item"),o._masonry.items);expect(t.length).toBe(6),expect(t[0].element).toBe(e[5]),expect(t[1].element).toBe(e[2]),expect(t[2].element).toBe(e[1]),expect(t[3].element).toBe(e[4]),expect(t[4].element).toBe(e[0]),expect(t[5].element).toBe(e[3]),expect(o.$el.css("visibility")).toBe("visible")}),describe("sizeChanged event",function(){let t;beforeEach(function(){o.$(".rb-c-admin-widgets__main").append(i({domID:"widget-1",name:"Widget 1",cssClasses:""})),n.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"}]),o.render(),t=o._widgetViews["widget-1"],expect(t).not.toBeUndefined(),spyOn(o._masonry,"layout")}),it("Causes re-layout on element size change",function(){var e=t.$el;e.width(e.width()+100),t.trigger("sizeChanged"),expect(o._masonry.layout).toHaveBeenCalled()}),it("Ignored when element size does not change",function(){o._widgetWidths["widget-1"]=t.$el.width(),t.trigger("sizeChanged"),expect(o._masonry.layout).not.toHaveBeenCalled()})})})}),suite("rb/admin/views/NewsWidgetView",function(){let i,n;beforeEach(function(){i=new RB.Admin.NewsWidget({newsURL:"http://example.com/news/"}),n=new RB.Admin.NewsWidgetView({el:$(`<div class="rb-c-admin-widget rb-c-news-admin-widget">
 <header class="rb-c-admin-widget__header">
  <ul class="rb-c-admin-widget__actions"></ul>
 </header>
 <div class="rb-c-admin-widget__content"></div>
 <footer class="rb-c-admin-widget__footer">
  <ul class="rb-c-admin-widget__actions"></ul>
 </footer>
</div>`),model:i}),spyOn(i,"loadNews")}),describe("Rendering",function(){describe("Actions",function(){it("More News",function(){n.render();var e=n.$footerActions.children(),e=(expect(e.length).toBe(1),e.eq(0));expect(e.hasClass("js-action-more-news")).toBeTrue(),expect(e.children("a").attr("href")).toBe("http://example.com/news/")}),it("Subscribe",function(){i.set("subscribeURL","http://example.com/news/subscribe/"),n.render();var e=n.$footerActions.children(),e=(expect(e.length).toBe(2),e.eq(1));expect(e.hasClass("js-action-subscribe")).toBeTrue(),expect(e.children("a").attr("href")).toBe("http://example.com/news/subscribe/")}),describe("Reload",function(){it("On loadingNews event",function(){n.render();var e=n.$headerActions.children(".js-action-reload");expect(e.hasClass("fa-spin")).toBeFalse(),i.trigger("loadingNews"),expect(e.hasClass("fa-spin")).toBeTrue()}),it("On change:newsItems event",function(){n.render();var e=n.$headerActions.children(".js-action-reload");n.setReloading(!0),expect(e.hasClass("fa-spin")).toBeTrue(),i.set("newsItems",[]),expect(e.hasClass("fa-spin")).toBeFalse()})})}),it("News items",function(){n.render(),i.set("newsItems",[{date:moment(Date.UTC(2019,9,21,0,26,32)),title:"Headline 6",url:"http://example.com/news/post6"},{date:moment(Date.UTC(2019,9,1,20,29,0)),title:"Headline 5",url:"http://example.com/news/post5"},{date:moment(Date.UTC(2019,8,27,2,29,33)),title:"Headline 4",url:"http://example.com/news/post4"}]);var e=n.$content.children();expect(e.length).toBe(3);let t=e.eq(0);expect(t.attr("href")).toBe("http://example.com/news/post6"),expect(t.find(".rb-c-admin-news-widget__item-date").text().trim()).toBe("Oct 20"),expect(t.find(".rb-c-admin-news-widget__item-title").text().trim()).toBe("Headline 6"),t=e.eq(1),expect(t.attr("href")).toBe("http://example.com/news/post5"),expect(t.find(".rb-c-admin-news-widget__item-date").text().trim()).toBe("Oct 01"),expect(t.find(".rb-c-admin-news-widget__item-title").text().trim()).toBe("Headline 5"),t=e.eq(2),expect(t.attr("href")).toBe("http://example.com/news/post4"),expect(t.find(".rb-c-admin-news-widget__item-date").text().trim()).toBe("Sep 26"),expect(t.find(".rb-c-admin-news-widget__item-title").text().trim()).toBe("Headline 4")}),it("Load errors",function(){n.render(),i.set("newsItems",[]);var e=n.$content.children(),e=(expect(e.length).toBe(1),e.eq(0));expect(e.hasClass("rb-c-admin-news-widget__error")).toBeTrue(),expect(e.html().trim()).toBe('There was an error loading the news. Please <a href="http://example.com/news/">visit the news page</a> directly, or try again later.')})})}),suite("rb/admin/views/InlineFormGroupView",function(){const t=_.template(`<div class="rb-c-admin-form-inline <%- classes || '' %>">
 <h3 class="rb-c-admin-form-inline__title">
  <span class="rb-c-admin-form-inline__title-prefix"></span>
  <span class="rb-c-admin-form-inline__title-object"></span>
  <span class="rb-c-admin-form-inline__title-index"></span>
  <span class="rb-c-admin-form-inline__actions">
   <span class="rb-c-admin-form-inline__delete-action"></span>
  </span>
 </h3>
 <fieldset>
  <div>
   <label for="myprefix-<%- index %>-foo"></label>
   <input id="myprefix-<%- index %>-foo"
          name="myprefix-<%- index %>-foo">
  </div>
  <div>
   <label for="myprefix-<%- index %>-bar"></label>
   <input id="myprefix-<%- index %>-bar"
          name="myprefix-<%- index %>-bar">
  </div>
 </fieldset>
</div>`),i=_.template(`<div class="rb-c-admin-form-inline-group">
 <h2 class="rb-c-admin-form-inline-group__title"></h2>
 <div class="rb-c-admin-form-inline-group__inlines">
  <input type="hidden"
         id="id_myprefix-TOTAL_FORMS"
         name="myprefix-TOTAL_FORMS"
         value="<%- totalForms %>">
  <input type="hidden"
         id="id_myprefix-INITIAL_FORMS"
         name="myprefix-INITIAL_FORMS"
         value="<%- initialForms %>">
  <input type="hidden"
         id="id_myprefix-MIN_NUM_FORMS"
         name="myprefix-MIN_NUM_FORMS"
         value="<%- minNumForms %>">
  <input type="hidden"
         id="id_myprefix-MAX_NUM_FORMS"
         name="myprefix-MAX_NUM_FORMS"
         value="<%- maxNumForms %>">

  <% for (let i = 0; i < numInlines; i++) { %>
   <%= inlineTemplate({
       classes: '',
       index: i
   }) %>
  <% } %>
  <%= inlineTemplate({
      classes: '-is-template',
      index: '__prefix__'
  }) %>
 </div>
 <div class="rb-c-admin-form-inline-group__actions">
  <a href="#" class="rb-c-admin-form-inline-group__add-action"></a>
 </div>
</div>`);let n,o,a;function s(e){n=$(i(_.extend({initialForms:0,inlineTemplate:t,maxNumForms:"",minNumForms:0,numInlines:0,totalForms:0},e))).appendTo($testsScratch),(a=new RB.Admin.InlineFormGroupView({el:n,model:o})).render()}beforeEach(function(){o=new RB.Admin.InlineFormGroup({prefix:"myprefix"})}),describe("State",function(){it("Populated on render",function(){s({numInlines:2,initialForms:2,minNumForms:1,maxNumForms:5,totalForms:2}),expect(n.find(".rb-c-admin-form-inline").length).toBe(2),expect(a._$inlineTemplate.length).toBe(1),expect(a._$inlineTemplate.hasClass("-is-template")).toBeFalse(),expect(o.get("initialInlines")).toBe(2),expect(o.get("maxInlines")).toBe(5),expect(o.get("minInlines")).toBe(1),expect(o.inlines.length).toBe(2),expect(a._inlineViews.length).toBe(2);let e=o.inlines.at(0);expect(e.get("index")).toBe(0),expect(e.get("isInitial")).toBeTrue(),expect(a._inlineViews[0].model).toBe(e),e=o.inlines.at(1),expect(e.get("index")).toBe(1),expect(e.get("isInitial")).toBeTrue(),expect(a._inlineViews[1].model).toBe(e)}),it("Updated when inlines added",function(){s({numInlines:1,initialForms:1,totalForms:1});var e=n.find("#id_myprefix-TOTAL_FORMS"),t=n.find(".rb-c-admin-form-inline-group__add-action");expect(n.find(".rb-c-admin-form-inline").length).toBe(1),expect(e.val()).toBe("1"),t.click(),expect(n.find(".rb-c-admin-form-inline").length).toBe(2),expect(e.val()).toBe("2"),t.click(),expect(n.find(".rb-c-admin-form-inline").length).toBe(3),expect(e.val()).toBe("3")}),it("Updated when inlines added",function(){s({numInlines:2,initialForms:2,totalForms:2});var e=n.find("#id_myprefix-TOTAL_FORMS"),t=(expect(o.inlines.length).toBe(2),expect(e.val()).toBe("2"),o.inlines.at(0).destroy(),n.find(".rb-c-admin-form-inline"));expect(t.length).toBe(1),expect(o.inlines.length).toBe(1),expect(e.val()).toBe("1"),expect(t[0].id).toBe("myprefix-0")})}),describe("UI",function(){describe("Add Button",function(){let e;beforeEach(function(){s({numInlines:1,initialForms:1,minNumForms:0,maxNumForms:3,totalForms:1}),e=n.find(".rb-c-admin-form-inline-group__add-action"),expect(e.length).toBe(1)}),it("When under limit",function(){expect(e.is(":visible")).toBeTrue(),a.addInlineForm(),expect(e.is(":visible")).toBeTrue()}),it("When limit hit",function(){expect(e.is(":visible")).toBeTrue(),a.addInlineForm(),a.addInlineForm(),expect(e.is(":visible")).toBeFalse()})})})}),suite("rb/admin/views/InlineFormView",function(){const e=_.template(`<div class="rb-c-admin-form-inline">
 <h3 class="rb-c-admin-form-inline__title">
  <span class="rb-c-admin-form-inline__title-prefix"></span>
  <span class="rb-c-admin-form-inline__title-object"></span>
  <span class="rb-c-admin-form-inline__title-index"></span>
  <span class="rb-c-admin-form-inline__actions">
   <span class="rb-c-admin-form-inline__delete-action"></span>
  </span>
 </h3>
 <fieldset>
  <div>
   <label for="id_myprefix-<%- index %>-foo"></label>
   <input id="id_myprefix-<%- index %>-foo"
          name="myprefix-<%- index %>-foo">
  </div>
  <div>
   <label for="id_myprefix-<%- index %>-bar"></label>
   <input id="id_myprefix-<%- index %>-bar"
          name="myprefix-<%- index %>-bar">
  </div>
 </fieldset>
</div>`);let o,a,t;beforeEach(function(){o=$(e({index:"__prefix__"})),a=new RB.Admin.InlineForm({prefix:"myprefix"}),(t=new RB.Admin.InlineFormView({el:o,model:a})).render()}),describe("Events",function(){describe("Delete clicked",function(){let e;beforeEach(function(){spyOn(window,"confirm").and.returnValue(!0),spyOn(a,"destroy"),e=o.find(".rb-c-admin-form-inline__delete-action")}),it("With isInitial=true",function(){a.set("isInitial",!0),e.click(),expect(window.confirm).not.toHaveBeenCalled(),expect(a.destroy).not.toHaveBeenCalled()}),it("With isInitial=false",function(){a.set("isInitial",!1),e.click(),expect(window.confirm).toHaveBeenCalled(),expect(a.destroy).toHaveBeenCalled()})}),describe("Index changed",function(){let t,i,n;beforeEach(function(){t=o.find("label"),i=o.find("input"),n=o.find(".rb-c-admin-form-inline__title-index"),expect(t.length).toBe(2),expect(i.length).toBe(2),expect(n.length).toBe(1)}),it("From __prefix__ to index",function(){a.set("index",0),expect(o[0].id).toBe("myprefix-0"),expect(n.text()).toBe("#1"),expect(t[0].htmlFor).toBe("id_myprefix-0-foo"),expect(t[1].htmlFor).toBe("id_myprefix-0-bar");var e=i[0];expect(e.id).toBe("id_myprefix-0-foo"),expect(e.name).toBe("myprefix-0-foo"),e=i[1],expect(e.id).toBe("id_myprefix-0-bar"),expect(e.name).toBe("myprefix-0-bar")}),it("From index to index",function(){a.set("index",0),a.set("index",1),expect(o[0].id).toBe("myprefix-1"),expect(n.text()).toBe("#2"),expect(t[0].htmlFor).toBe("id_myprefix-1-foo"),expect(t[1].htmlFor).toBe("id_myprefix-1-bar");var e=i[0];expect(e.id).toBe("id_myprefix-1-foo"),expect(e.name).toBe("myprefix-1-foo"),e=i[1],expect(e.id).toBe("id_myprefix-1-bar"),expect(e.name).toBe("myprefix-1-bar")})})})}),suite("rb/collections/FilteredCollection",function(){let t;beforeEach(function(){t=new Backbone.Collection([{id:1,label:"One",bool:!0},{id:2,label:"Two",bool:!1},{id:3,label:"Three",bool:!0}])}),describe("Initialization",function(){it("Defaults to full contents",function(){var e=new RB.FilteredCollection(null,{collection:t});expect(e.length).toBe(t.length)}),it("Respects provided filter",function(){var e=new RB.FilteredCollection(null,{collection:t,filters:{label:"T"}});expect(e.length).toBe(2),expect(e.at(0).id).toBe(2),expect(e.at(1).id).toBe(3)})}),describe("Methods",function(){let e;beforeEach(function(){e=new RB.FilteredCollection(null,{collection:t,filters:{label:"T"}}),expect(e.length).toBe(2)}),describe("setFilters",function(){it("With new filter",function(){e.setFilters({label:"O"}),expect(e.length).toBe(1),expect(e.at(0).id).toBe(1)}),it("With multiple filters",function(){e.setFilters({label:"T",bool:!1}),expect(e.length).toBe(1),expect(e.at(0).id).toBe(2)}),it("{}",function(){e.setFilters({}),expect(e.length).toBe(3)}),it("null",function(){e.setFilters(null),expect(e.length).toBe(3)}),it("undefined",function(){e.setFilters(),expect(e.length).toBe(3)})})}),describe("Main collection events",function(){describe("With filters",function(){let e;beforeEach(function(){e=new RB.FilteredCollection(null,{collection:t,filters:{label:"T"}}),expect(e.length).toBe(2)}),it("reset",function(){t.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]),expect(e.length).toBe(1),expect(e.at(0).id).toBe(11)}),describe("add",function(){it("Matching filter",function(){t.add({id:4,label:"Test"}),expect(e.length).toBe(3),expect(e.at(2).id).toBe(4)}),it("Not matching filter",function(){t.add({id:4,label:"Four"}),expect(e.length).toBe(2)})}),describe("remove",function(){it("Matching filter",function(){t.remove(t.get(2)),expect(e.length).toBe(1)}),it("Not matching filter",function(){t.remove(t.get(0)),expect(e.length).toBe(2)})})}),describe("Without filters",function(){let e;beforeEach(function(){e=new RB.FilteredCollection(null,{collection:t}),expect(e.length).toBe(3)}),it("reset",function(){t.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]),expect(e.length).toBe(2)}),it("add",function(){t.add({id:4,label:"Four"}),expect(e.length).toBe(4),expect(e.at(3).id).toBe(4)}),it("remove",function(){t.remove(t.get(1)),expect(e.length).toBe(2)})})})}),suite("rb/configForms/models/ResourceListItem",function(){const t=RB.Config.ResourceListItem.extend({syncAttrs:["name","fileRegex"],createResource:e=>new RB.DefaultReviewer(e)});let i;beforeEach(function(){i=new RB.DefaultReviewer({name:"my-name",fileRegex:".*"})}),describe("Synchronizing attributes",function(){it("On resource attribute change",function(){var e=new t({resource:i});i.set("name","foo"),expect(e.get("name")).toBe("foo")}),describe("On creation",function(){it("With existing resource",function(){var e=new t({resource:i,name:"dummy",fileRegex:"/foo/.*"});expect(e.get("name")).toBe("my-name"),expect(e.get("fileRegex")).toBe(".*")}),it("With created resource",function(){var e=new t({id:123,name:"new-name",fileRegex:"/foo/.*"});expect(e.get("name")).toBe("new-name"),expect(e.get("fileRegex")).toBe("/foo/.*"),i=e.get("resource"),expect(i.id).toBe(123),expect(i.get("name")).toBe("new-name"),expect(i.get("fileRegex")).toBe("/foo/.*")})})}),describe("Event mirroring",function(){let e;beforeEach(function(){e=new t({resource:i}),spyOn(e,"trigger")}),it("destroy",function(){i.trigger("destroy"),expect(e.trigger).toHaveBeenCalledWith("destroy",e,void 0,{})}),it("request",function(){i.trigger("request"),expect(e.trigger).toHaveBeenCalledWith("request")}),it("sync",function(){i.trigger("sync"),expect(e.trigger).toHaveBeenCalledWith("sync")})})}),suite("rb/diffviewer/models/DiffCommit",function(){describe("parse",function(){it("Short commit message",function(){var e=new RB.DiffCommit({author_name:"Author Name",commit_id:"r123",commit_message:"A commit message.\n",id:1,parent_id:"r122"},{parse:!0});expect(e).toBeTruthy(),expect(e.attributes).not.toBe(void 0),expect(e.attributes).toEqual({authorName:"Author Name",commitID:"r123",commitMessage:"A commit message.",commitMessageBody:null,id:1,parentID:"r122",summary:"A commit message."}),expect(e.hasSummary()).toBe(!1)}),it("Long commit message",function(){var e=new RB.DiffCommit({author_name:"Author Name",commit_id:"r123",commit_message:`This is a long commit message.

It spans several lines.
It has trailing newlines as well.

`,id:2,parent_id:"r122"},{parse:!0});expect(e).toBeTruthy(),expect(e.attributes).not.toBe(void 0),expect(e.attributes).toEqual({authorName:"Author Name",commitID:"r123",commitMessage:"This is a long commit message.\n\nIt spans several lines.\nIt has trailing newlines as well.",commitMessageBody:"It spans several lines.\nIt has trailing newlines as well.",id:2,parentID:"r122",summary:"This is a long commit message."}),expect(e.hasSummary()).toBe(!0)}),it("Commit message with overlong first line",function(){var e="abcd".repeat(100),t=e.substr(0,77)+"...",i=new RB.DiffCommit({author_name:"Author Name",commit_id:"r234",commit_message:e,id:3,parent_id:"r233"},{parse:!0});expect(i).toBeTruthy(),expect(i.attributes).not.toBe(void 0),expect(i.attributes).toEqual({authorName:"Author Name",commitID:"r234",commitMessage:e,commitMessageBody:null,id:3,parentID:"r233",summary:t}),expect(i.hasSummary()).toBe(!0)})})}),suite("rb/diffviewer/models/DiffRevision",function(){describe("parse",function(){it("API payloads",function(){var e=RB.DiffRevision.prototype.parse.call(void 0,{revision:2,latest_revision:3,interdiff_revision:4,is_interdiff:!0,is_draft_diff:!0});expect(e).not.toBe(void 0),expect(e.revision).toBe(2),expect(e.latestRevision).toBe(3),expect(e.interdiffRevision).toBe(4),expect(e.isInterdiff).toBe(!0),expect(e.isDraftDiff).toBe(!0),expect(e.baseCommitID).toBe(null),expect(e.tipCommitID).toBe(null)}),it("API payloads with base/tip commit IDs",function(){var e=RB.DiffRevision.prototype.parse.call(void 0,{revision:4,latest_revision:7,interdiff_revision:null,is_interdiff:!1,is_draft_diff:!1,base_commit_id:3,tip_commit_id:4});expect(e).not.toBe(void 0),expect(e.revision).toBe(4),expect(e.latestRevision).toBe(7),expect(e.interdiffRevision).toBe(null),expect(e.isInterdiff).toBe(!1),expect(e.isDraftDiff).toBe(!1),expect(e.baseCommitID).toBe(3),expect(e.tipCommitID).toBe(4)})})}),suite("rb/diffviewer/models/Pagination",function(){let t;beforeEach(function(){t=new RB.Pagination}),describe("parse",function(){it("API payloads",function(){var e=t.parse({is_paginated:!0,pages:4,has_previous:!0,has_next:!0,page_numbers:[1,2,3,4],previous_page:1,next_page:3,current_page:2});expect(e).not.toBe(void 0),expect(e.isPaginated).toBe(!0),expect(e.pages).toBe(4),expect(e.pageNumbers).toEqual([1,2,3,4]),expect(e.hasPrevious).toBe(!0),expect(e.hasNext).toBe(!0),expect(e.previousPage).toBe(1),expect(e.nextPage).toBe(3),expect(e.currentPage).toBe(2)})})}),suite("rb/diffviewer/views/DiffCommitListView",function(){function n(t,i){expect(t.length).toEqual(i.rowOptions.length);var n=(i.haveHistory?1:0)+(i.haveInterCommitDiffControls?2:0);for(let e=0;e<t.length;e++){var o=t.eq(e),a=o.find("td"),s=i.rowOptions[e],c=s.values;expect(a.length).toEqual(c.length+n),i.haveHistory&&expect(o[0]).toHaveClass(s.op),i.haveInterCommitDiffControls&&(o=a.eq(0).find("input"),expect(o.length).toEqual(1),expect(o.attr("value")).toEqual((e+1).toString()),expect(o.prop("checked")).toEqual(!!s.baseSelected),expect(o.prop("disabled")).toEqual(!!s.baseDisabled),o=a.eq(1).find("input"),expect(o.length).toEqual(1),expect(o.attr("value")).toEqual((e+1).toString()),expect(o.prop("checked")).toEqual(!!s.tipSelected),expect(o.prop("disabled")).toEqual(!!s.tipDisabled));for(let e=0;e<c;e++)expect(a.eq(n+e).text().trim()).toEqual(c[e])}}let o,a;beforeEach(function(){a=$('<div class="diff-commit-list">').appendTo($testsScratch)}),afterEach(function(){o.remove(),o=null,a=null}),describe("Render",function(){let i;beforeEach(function(){var e=new RB.DiffCommitCollection([{id:1,commit_id:"r1",parent_id:"r0",author_name:"Example Author",commit_message:"Commit message 1"},{id:2,commit_id:"r2",parent_id:"r1",author_name:"Example Author",commit_message:"Commit message 2"}],{parse:!0});i=new RB.DiffCommitList({commits:e,historyDiff:new RB.CommitHistoryDiffEntryCollection,isInterdiff:!1,baseCommitID:null,tipCommitID:null})}),it("Updates when collection reset",function(){(o=new RB.DiffCommitListView({model:i,el:a})).render();let e=a.find("table"),t=e.find("thead th");expect(t.length).toEqual(3),expect(t.eq(0).text().trim()).toEqual(gettext("Summary")),expect(t.eq(1).text().trim()).toEqual(gettext("ID")),expect(t.eq(2).text().trim()).toEqual(gettext("Author")),n(e.find("tbody tr"),{rowOptions:[{values:["Commit message 1","r1","Example Author"]},{values:["Commit message 2","r2","Example Author"]}]}),i.get("commits").reset([{commit_id:"r4",author_name:"Example Author",commit_message:"Commit message 4\n\nIt is very long"}],{parse:!0}),e=a.find("table"),t=e.find("thead th"),expect(t.length).toEqual(3),expect(t.eq(0).text().trim()).toEqual(gettext("Summary")),expect(t.eq(1).text().trim()).toEqual(gettext("ID")),expect(t.eq(2).text().trim()).toEqual(gettext("Author")),n(e.find("tbody tr"),{rowOptions:[{expanded:!1,values:["Commit message 4","r4","Example Author"]}]})}),it("Interdiff",function(){i.get("historyDiff").reset([{entry_type:RB.CommitHistoryDiffEntry.REMOVED,old_commit_id:1},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:2}],{parse:!0}),(o=new RB.DiffCommitListView({model:i,el:a})).render();var e=a.find("table"),t=e.find("thead th");expect(t.length).toEqual(4),expect(t.eq(0).text().trim()).toEqual(""),expect(t.eq(1).text().trim()).toEqual(gettext("Summary")),expect(t.eq(2).text().trim()).toEqual(gettext("ID")),expect(t.eq(3).text().trim()).toEqual(gettext("Author")),n(e.find("tbody tr"),{haveHistory:!0,rowOptions:[{op:"-is-removed",values:["Commit message 1","r1","Example Author"]},{op:"-is-added",values:["Commit message 2","r2","Example Author"]}]})}),it("With Inter-Commit Diff Controls",function(){(o=new RB.DiffCommitListView({el:a,model:i,showInterCommitDiffControls:!0})).render();var e=a.find("table"),t=e.find("thead th");expect(t.length).toEqual(5),expect(t.eq(0).text().trim()).toEqual(gettext("First")),expect(t.eq(1).text().trim()).toEqual(gettext("Last")),expect(t.eq(2).text().trim()).toEqual(gettext("Summary")),expect(t.eq(3).text().trim()).toEqual(gettext("ID")),expect(t.eq(4).text().trim()).toEqual(gettext("Author")),n(e.find("tbody tr"),{haveInterCommitDiffControls:!0,rowOptions:[{baseSelected:!0,values:["Commit message 1","r1","Example Author"]},{tipSelected:!0,values:["Commit message 2","r2","Example Author"]}]})}),it("With Inter-Commit Diff and Expand/Collapse Controls",function(){i.get("commits").get(1).set({commitMessage:"Long commit message\n\nThis is a long message.\n",summary:"Long commit message"}),(o=new RB.DiffCommitListView({el:a,model:i,showInterCommitDiffControls:!0})).render();var e=a.find("table"),t=e.find("thead th");expect(t.length).toEqual(5),expect(t.eq(0).text().trim()).toEqual(gettext("First")),expect(t.eq(1).text().trim()).toEqual(gettext("Last")),expect(t.eq(2).text().trim()).toEqual(gettext("Summary")),expect(t.eq(3).text().trim()).toEqual(gettext("ID")),expect(t.eq(4).text().trim()).toEqual(gettext("Author")),n(e.find("tbody tr"),{haveInterCommitDiffControls:!0,rowOptions:[{baseSelected:!0,haveExpandCollapse:!0,values:["Long commit message","r1","Example Author"]},{tipSelected:!0,values:["Commit message 2","r2","Example Author"]}]})}),it("With base and tip commit IDs set",function(){var e=i.get("commits"),e=(e.add([{id:3,commit_id:"r3",parent_id:"r2",author_name:"Example Author",commit_message:"Commit message 3"},{id:4,commit_id:"r4",parent_id:"r3",author_name:"Example Author",commit_message:"Commit message 4"}],{parse:!0}),i.set({baseCommitID:e.findWhere({commitID:"r2"}).id,tipCommitID:e.findWhere({commitID:"r3"}).id}),(o=new RB.DiffCommitListView({el:a,model:i,showInterCommitDiffControls:!0})).render(),a.find("table")),t=e.find("thead th");expect(t.length).toEqual(5),expect(t.eq(0).text().trim()).toEqual(gettext("First")),expect(t.eq(1).text().trim()).toEqual(gettext("Last")),expect(t.eq(2).text().trim()).toEqual(gettext("Summary")),expect(t.eq(3).text().trim()).toEqual(gettext("ID")),expect(t.eq(4).text().trim()).toEqual(gettext("Author")),n(e.find("tbody tr"),{haveInterCommitDiffControls:!0,rowOptions:[{tipDisabled:!0,values:["Long commit message","r1","Example Author"]},{tipDisabled:!0,values:["Commit message 2","r2","Example Author"]},{baseSelected:!0,tipSelected:!0,values:["Commit message 3","r3","Example Author"]},{baseDisabled:!0,values:["Commit message 4","r4","Example Author"]}]})})}),describe("Event handlers",function(){let n;beforeEach(function(){var e=new RB.DiffCommitCollection([{id:1,commit_id:"r1",parent_id:"r0",author_name:"Example Author",commit_message:"Long commit message\n\nThis is a long message.\n"},{id:2,commit_id:"r2",parent_id:"r1",author_name:"Example Author",commit_message:"Super long\n\nSo very long."}],{parse:!0});n=new RB.DiffCommitList({commits:e,isInterdiff:!1})}),it("Select base/tip",function(){n.get("commits").add([{id:3,commit_id:"r3",parent_id:"r2",author_name:"Example Author",commit_message:"Commit message 3"},{id:4,commit_id:"r4",parent_id:"r3",author_name:"Example Author",commit_message:"Commit message 4"}],{parse:!0}),(o=new RB.DiffCommitListView({el:a,showInterCommitDiffControls:!0,model:n})).render();var t=a.find(".base-commit-selector"),i=a.find(".tip-commit-selector");expect(t.length).toEqual(4),expect(i.length).toEqual(4),t.eq(3).click(),expect(t.eq(0).prop("disabled")).toEqual(!1),expect(t.eq(1).prop("disabled")).toEqual(!1),expect(t.eq(2).prop("disabled")).toEqual(!1),expect(t.eq(3).prop("disabled")).toEqual(!1),expect(i.eq(0).prop("disabled")).toEqual(!0),expect(i.eq(1).prop("disabled")).toEqual(!0),expect(i.eq(2).prop("disabled")).toEqual(!0),expect(i.eq(3).prop("disabled")).toEqual(!1),expect(n.get("baseCommitID")).toEqual(3),expect(n.get("tipCommitID")).toEqual(null),t.eq(0).click();for(let e=0;e<4;e++)expect(t.eq(e).prop("disabled")).toEqual(!1),expect(i.eq(e).prop("disabled")).toEqual(!1);expect(n.get("baseCommitID")).toEqual(null),expect(n.get("tipCommitID")).toEqual(null),i.eq(0).click(),expect(t.eq(0).prop("disabled")).toEqual(!1),expect(t.eq(1).prop("disabled")).toEqual(!0),expect(t.eq(2).prop("disabled")).toEqual(!0),expect(t.eq(3).prop("disabled")).toEqual(!0),expect(i.eq(0).prop("disabled")).toEqual(!1),expect(i.eq(1).prop("disabled")).toEqual(!1),expect(i.eq(2).prop("disabled")).toEqual(!1),expect(i.eq(3).prop("disabled")).toEqual(!1),expect(n.get("baseCommitID")).toEqual(null),expect(n.get("tipCommitID")).toEqual(1),i.eq(2).click(),t.eq(2).click(),expect(t.eq(0).prop("disabled")).toEqual(!1),expect(t.eq(1).prop("disabled")).toEqual(!1),expect(t.eq(2).prop("disabled")).toEqual(!1),expect(t.eq(3).prop("disabled")).toEqual(!0),expect(i.eq(0).prop("disabled")).toEqual(!0),expect(i.eq(1).prop("disabled")).toEqual(!0),expect(i.eq(2).prop("disabled")).toEqual(!1),expect(i.eq(2).prop("disabled")).toEqual(!1),expect(n.get("baseCommitID")).toEqual(2),expect(n.get("tipCommitID")).toEqual(3)})})}),suite("rb/models/uploadDiffModel",function(){let e,t;beforeEach(function(){e=new RB.ReviewRequest({id:123}),t=new RB.UpdateDiffView({model:new RB.UploadDiffModel({changeNumber:e.get("commitID"),repository:e.get("repository"),reviewRequest:e}),el:$("#scratch")})}),describe("Updating Review Requests",function(){it('"Start Over" doesn\'t change reviewRequest attribute',function(){spyOn(t.model,"startOver").and.callThrough(),t.model.startOver(),expect(t.model.attributes.reviewRequest).toBe(e)})})}),suite("rb/newReviewRequest/views/BranchesView",function(){let e,t;beforeEach(function(){e=new RB.RepositoryBranches([{name:"master",commit:"8088295174d8d46af7700ddf4522e3a703724106",isDefault:!0},{name:"release-1.7.x",commit:"5e6707050f7cb29ed50fafd3b92bffb1e15df19f",isDefault:!1},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",isDefault:!1}]),t=new RB.BranchesView({collection:e})}),describe("Rendering",function(){it("With items",function(){t.render(),expect(t.$el.html()).toBe('<option selected="selected">master</option><option>release-1.7.x</option><option>release-1.6.x</option>')})}),describe("Selected event",function(){it("When clicked",function(){t.render(),t.on("selected",e=>{expect(e.get("name")).toBe("release-1.7.x")});var e=t.$el.children();$(e[0]).attr("selected",!1),$(e[1]).attr("selected",!0),t.$el.change(),expect(t.$el.html()).toBe('<option>master</option><option selected="selected">release-1.7.x</option><option>release-1.6.x</option>')})})}),suite("rb/newReviewRequest/views/PostCommitView",function(){let e,n,t,o;beforeEach(function(){e=new RB.Repository({name:"Repo",supportsPostCommit:!0}),spyOn(e.branches,"sync").and.callFake((e,t,i)=>{i.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",default:!0},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15",default:!1},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",default:!1}]})}),spyOn(e,"getCommits").and.callFake(e=>(n=new RB.RepositoryCommits([],{urlBase:_.result(this,"url")+"commits/",start:e.start,branch:e.branch}),spyOn(n,"sync").and.callFake((e,t,i)=>{i.success({stat:"ok",commits:[{authorName:"Author 1",date:"2013-07-22T03:51:50Z",id:"3",message:"Summary 1\n\nMessage 1",parent:"2"},{authorName:"Author 2",date:"2013-07-22T03:50:46Z",id:"2",message:"Summary 2\n\nMessage 2",parent:"1"},{authorName:"Author 3",date:"2013-07-21T08:05:45Z",id:"1",message:"Summary 3\n\nMessage 3",parent:""}]})}),n)),t=new RB.PostCommitModel({repository:e}),o=new RB.PostCommitView({model:t,$scrollContainer:$("<div>")}),spyOn(RB.PostCommitView.prototype,"_onCreateReviewRequest").and.callThrough(),expect(e.branches.sync).toHaveBeenCalled()}),it("Render",function(){o.render(),expect(n.sync).toHaveBeenCalled(),expect(o._branchesView.$el.children().length).toBe(3),expect(o._commitsView.$el.children().length).toBe(3)}),it("Create",function(t){o.render();let i;spyOn(RB.ReviewRequest.prototype,"save").and.resolveTo(),spyOn(RB,"navigateTo").and.callFake(()=>{expect(RB.PostCommitView.prototype._onCreateReviewRequest).toHaveBeenCalled(),expect(RB.ReviewRequest.prototype.save).toHaveBeenCalled(),expect(RB.ReviewRequest.prototype.save.calls.count()).toBe(1);var e=RB.ReviewRequest.prototype.save.calls.mostRecent();expect(e.object.get("commitID")).toBe(i.get("id")),t()}),(i=n.models[1]).trigger("create",i)}),describe("Error handling",function(){describe("Branches",function(){let i;beforeEach(async function(){spyOn(e.branches,"fetch").and.callFake(()=>i?Promise.reject(new BackboneError(t,{errorText:"Oh no"},{})):Promise.resolve()),i=!0,spyOn(RB.PostCommitView.prototype,"_showLoadError").and.callThrough(),await o._loadBranches()}),it("UI state",function(){expect(e.branches.fetch).toHaveBeenCalled(),expect(o._showLoadError).toHaveBeenCalled(),expect(o._showLoadError.calls.argsFor(0)[1]).toBe("Oh no"),expect(o._branchesView.$el.css("display")).toBe("none"),expect(o._errorView).toBeTruthy(),expect(o._commitsView).toBeFalsy(),expect(o._errorView.$el.find(".error-text").text().trim()).toBe("Oh no")}),it("Reloading",function(e){spyOn(o,"_onReloadBranchesClicked").and.callFake(()=>{o._loadBranches().finally(()=>{expect(o._errorView).toBe(null),expect(o._branchesView.$el.css("display")).not.toBe("none"),e()})}),o.delegateEvents(),i=!1,expect(o._errorView).toBeTruthy();var t=o._errorView.$el.find(".ink-c-button");expect(t.length).toBe(1),t.click()})}),describe("Commits",function(){let i;beforeEach(async function(){o.render(),spyOn(RB.RepositoryCommits.prototype,"fetch").and.callFake(()=>i?Promise.reject(new BackboneError(t,{errorText:"Oh no"},{})):Promise.resolve()),i=!0,spyOn(RB.PostCommitView.prototype,"_showLoadError").and.callThrough(),await o._loadCommits()}),it("UI state",function(){expect(o._commitsCollection.fetch).toHaveBeenCalled(),expect(o._showLoadError).toHaveBeenCalled(),expect(o._showLoadError.calls.argsFor(0)[1]).toBe("Oh no"),expect(o._commitsView.$el.css("display")).toBe("none"),expect(o._errorView).toBeTruthy(),expect(o._commitsView).toBeTruthy(),expect(o._commitsView.$el.css("display")).toBe("none"),expect(o._errorView.$el.find(".error-text").text().trim()).toBe("Oh no")}),it("Reloading",function(t){spyOn(o,"_onReloadCommitsClicked").and.callFake(()=>{o._loadCommits().finally(()=>{expect(o._errorView).toBe(null);var e=o._commitsView.$el.css("display");expect("block"===e||""===e).toBe(!0),t()})}),o.delegateEvents(),i=!1,expect(o._errorView).toBeTruthy();var e=o._errorView.$el.find(".ink-c-button");expect(e.length).toBe(1),e.click()})})})}),suite("rb/newReviewRequest/views/RepositorySelectionView",function(){let n,o;beforeEach(function(){n=new Backbone.Collection([{name:"Bitbucket Test"},{name:"GitHub Test"},{name:"GitLab Test"},{name:"Local Git Test"}],{model:RB.Repository}),o=new RB.RepositorySelectionView({collection:n})}),describe("Rendering",function(){it("With items",function(){o.render();var t=o.$el.find(".repository");expect(t.length).toBe(n.models.length);for(let e=0;e<t.length;e++){var i=n.models[e].get("name");expect($(t[e]).text().trim()).toBe(i)}})}),describe("Selected event",function(){it("When clicked",function(){let t=!1;o.render(),o.on("selected",e=>{expect(e.get("name")).toBe("GitHub Test"),t=!0});var e=o.$el.find(".repository");$(e[1]).click(),expect(t).toBe(!0)})})}),suite("rb/pages/models/PageManager",function(){let i,n;beforeEach(function(){i=new RB.PageManager,n=new Backbone.View,spyOn(n,"render")}),describe("Instance",function(){let e,t;beforeEach(function(){t=!1,e={cb:e=>{expect(e).toBe(n),expect(i.get("rendered")).toBe(!1)}},spyOn(e,"cb")}),describe("Methods",function(){describe("beforeReady",function(){it("Without page set",function(){i.beforeRender(e.cb),expect(e.cb).not.toHaveBeenCalled(),i.set("page",n),expect(e.cb).toHaveBeenCalled()}),it("With page set, not rendered",function(){i.set("page",n),i.set("rendered",!1),i.beforeRender(e.cb),expect(e.cb).toHaveBeenCalled()}),it("With page set, rendered",function(){i.set({page:n,rendered:!0}),expect(()=>i.beforeRender(e.cb)).toThrow(),expect(e.cb).not.toHaveBeenCalled()})}),describe("ready",function(){it("Without page set",function(){i.ready(e.cb),expect(e.cb).not.toHaveBeenCalled(),i.set("page",n),expect(i.get("rendered")).toBe(!0),expect(n.render).toHaveBeenCalled(),expect(e.cb).toHaveBeenCalled()}),it("With page set, not rendered",function(){spyOn(i,"_renderPage"),i.set("page",n),expect(i.get("rendered")).toBe(!1),expect(n.render).not.toHaveBeenCalled(),i.ready(e.cb),expect(e.cb).not.toHaveBeenCalled()}),it("With page set, rendered",function(){i.set("page",n),expect(i.get("rendered")).toBe(!0),expect(n.render).toHaveBeenCalled(),i.ready(e.cb),expect(e.cb).toHaveBeenCalled()})})})}),describe("Class methods",function(){let e;beforeEach(function(){e=RB.PageManager.instance,RB.PageManager.instance=i}),afterEach(function(){RB.PageManager.instance=e}),it("beforeRender",function(){spyOn(RB.PageManager.instance,"beforeRender"),RB.PageManager.beforeRender(1,2),expect(RB.PageManager.instance.beforeRender).toHaveBeenCalledWith(1,2)}),it("ready",function(){spyOn(RB.PageManager.instance,"ready"),RB.PageManager.ready(1,2),expect(RB.PageManager.instance.ready).toHaveBeenCalledWith(1,2)}),it("setPage",function(){var e=new Backbone.View;RB.PageManager.setPage(e),expect(i.get("page")).toBe(e)}),it("getPage",function(){var e=new Backbone.View;i.set("page",e),expect(RB.PageManager.getPage()).toBe(e)})})}),suite("rb/resources/collections/RepositoryBranches",function(){let e;beforeEach(function(){(e=new RB.RepositoryBranches).url="/api/repositories/123/branches/"}),describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").and.callFake(e=>{expect(e.url).toBe("/api/repositories/123/branches/"),expect(e.type).toBe("GET"),e.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",default:!0},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15",default:!1},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",default:!1}]})}),e.fetch(),expect($.ajax).toHaveBeenCalled(),expect(e.length).toBe(3),expect(e.at(0).get("name")).toBe("master"),expect(e.at(1).get("commit")).toBe("92463764015ef463b4b6d1a1825fee7aeec8cb15"),expect(e.at(2).get("isDefault")).toBe(!1),expect(e.reduce((e,t)=>e+t.get("isDefault")?1:0,0)).toBe(1)})})}),suite("rb/resources/collections/RepositoryCommits",function(){const t="/api/repositories/123/commits/",i="859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817";let e;beforeEach(function(){e=new RB.RepositoryCommits([],{urlBase:t,start:i})}),describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").and.callFake(e=>{expect(e.url).toBe(t+"?start="+i),expect(e.type).toBe("GET"),e.success({stat:"ok",commits:[{author_name:"Christian Hammond",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Merge branch 'release-1.7.x'",parent:"92463764015ef463b4b6d1a1825fee7aeec8cb15",review_request_url:""},{author_name:"Christian Hammond",date:"2013-06-25T23:30:59Z",id:"92463764015ef463b4b6d1a1825fee7aeec8cb15",message:"Fixed the bug number for the blacktriangledown bug.",parent:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",review_request_url:"http://example.com/r/18274/"},{author_name:"Christian Hammond",date:"2013-06-25T22:53:32Z",id:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",message:["Don't expose child resources in ","ValidateDiffResource.\n\nFor convenience, ","ValidateDiffResource inherited from ","DiffResource.\nThis brought along the child ","resources, which weren't valid to have.\n","That ended up breaking docs, which tried ","to traverse them."].join(""),parent:"",review_request_url:""}]})}),e.fetch(),expect($.ajax).toHaveBeenCalled(),expect(e.length).toBe(3),expect(e.at(0).get("authorName")).toBe("Christian Hammond"),expect(e.at(1).get("date").getUTCHours()).toBe(23),expect(e.at(2).get("summary")).toBe("Don't expose child resources in ValidateDiffResource."),expect(e.at(1).get("reviewRequestURL")).toBe("http://example.com/r/18274/")}),it("url",function(){expect(_.result(e,"url")).toBe(t+"?start="+i)})})}),suite("rb/resources/models/BaseCommentReply",function(){let e,t;beforeEach(function(){e=new RB.BaseResource({public:!0}),t=new RB.BaseCommentReply({parentObject:e}),expect(t.validate(t.attributes)).toBe(void 0)}),describe("destroyIfEmpty",function(){beforeEach(function(){spyOn(t,"destroy")}),it("Destroying when text is empty",function(){t.set("text",""),t.destroyIfEmpty(),expect(t.destroy).toHaveBeenCalled()}),it("Not destroying when text is not empty",function(){t.set("text","foo"),t.destroyIfEmpty(),expect(t.destroy).not.toHaveBeenCalled()})}),describe("parse",function(){beforeEach(function(){t.rspNamespace="my_comment"}),it("API payloads",function(){var e=t.parse({stat:"ok",my_comment:{id:42,text:"foo",text_type:"markdown"}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.text).toBe("foo"),expect(e.richText).toBe(!0)})}),describe("toJSON",function(){describe("force_text_type field",function(){it("With value",function(){t.set("forceTextType","html");var e=t.toJSON();expect(e.force_text_type).toBe("html")}),it("Without value",function(){var e=t.toJSON();expect(e.force_text_type).toBe(void 0)})}),describe("include_text_types field",function(){it("With value",function(){t.set("includeTextTypes","html");var e=t.toJSON();expect(e.include_text_types).toBe("html")}),it("Without value",function(){var e=t.toJSON();expect(e.include_text_types).toBe(void 0)})}),describe("reply_to_id field",function(){it("When loaded",function(){t.set({replyToID:10,loaded:!0});var e=t.toJSON();expect(e.reply_to_id).toBe(void 0)}),it("When not loaded",function(){t.set({replyToID:10,loaded:!1});var e=t.toJSON();expect(e.reply_to_id).toBe(10)})}),describe("richText field",function(){it("With true",function(){t.set("richText",!0);var e=t.toJSON();expect(e.text_type).toBe("markdown")}),it("With false",function(){t.set("richText",!1);var e=t.toJSON();expect(e.text_type).toBe("plain")})}),describe("text field",function(){it("With value",function(){t.set("text","foo");var e=t.toJSON();expect(e.text).toBe("foo")})})}),describe("validate",function(){describe("parentObject",function(){it("With value",function(){expect(t.validate({parentObject:e})).toBe(void 0)}),it("Unset",function(){expect(t.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})}),suite("rb/resources/models/DiffComment",function(){let t;beforeEach(function(){t=new RB.DiffComment({fileDiffID:16,parentObject:new RB.BaseResource({public:!0})})}),it("getNumLines",function(){t.set({beginLineNum:5,endLineNum:10}),expect(t.getNumLines()).toBe(6)}),describe("parse",function(){it("API payloads",function(){var e=t.parse({stat:"ok",diff_comment:{id:42,issue_opened:!0,issue_status:"resolved",text_type:"markdown",text:"foo",first_line:10,num_lines:5,filediff:{id:1,source_file:"my-file"},interfilediff:{id:2,source_file:"my-file"}}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.issueOpened).toBe(!0),expect(e.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED),expect(e.richText).toBe(!0),expect(e.text).toBe("foo"),expect(e.beginLineNum).toBe(10),expect(e.endLineNum).toBe(14),expect(e.fileDiff).not.toBe(void 0),expect(e.fileDiff.id).toBe(1),expect(e.fileDiff.get("sourceFilename")).toBe("my-file"),expect(e.interFileDiff).not.toBe(void 0),expect(e.interFileDiff.id).toBe(2),expect(e.interFileDiff.get("sourceFilename")).toBe("my-file")})}),describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough(),t.toJSON(),expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()}),it("first_line field",function(){t.set({beginLineNum:100,endLineNum:100});var e=t.toJSON();expect(e.first_line).toBe(100)}),it("num_lines field",function(){t.set({beginLineNum:100,endLineNum:105});var e=t.toJSON();expect(e.num_lines).toBe(6)}),describe("force_text_type field",function(){it("With value",function(){t.set("forceTextType","html");var e=t.toJSON();expect(e.force_text_type).toBe("html")}),it("Without value",function(){var e=t.toJSON();expect(e.force_text_type).toBe(void 0)})}),describe("include_text_types field",function(){it("With value",function(){t.set("includeTextTypes","html");var e=t.toJSON();expect(e.include_text_types).toBe("html")}),it("Without value",function(){var e=t.toJSON();expect(e.include_text_types).toBe(void 0)})}),describe("filediff_id field",function(){it("When loaded",function(){t.set("loaded",!0);var e=t.toJSON();expect(e.filediff_id).toBe(void 0)}),it("When not loaded",function(){var e=t.toJSON();expect(e.filediff_id).toBe(16)})}),describe("interfilediff_id field",function(){it("When loaded",function(){t.set("loaded",!0);var e=t.toJSON();expect(e.interfilediff_id).toBe(void 0)}),it("When not loaded",function(){t.set("interFileDiffID",50);var e=t.toJSON();expect(e.interfilediff_id).toBe(50)}),it("When not loaded and unset",function(){var e=t.toJSON();expect(e.interfilediff_id).toBe(void 0)})})}),describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate"),t.validate({}),expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()}),describe("beginLineNum/endLineNum",function(){describe("Valid values",function(){it("beginLineNum == 0, endLineNum == 0",function(){expect(t.validate({beginLineNum:0,endLineNum:0})).toBe(void 0)}),it("beginLineNum > 0, endLineNum == beginLineNum",function(){expect(t.validate({beginLineNum:10,endLineNum:10})).toBe(void 0)}),it("beginLineNum > 0, endLineNum > 0",function(){expect(t.validate({beginLineNum:10,endLineNum:11})).toBe(void 0)})}),describe("Invalid values",function(){it("beginLineNum < 0",function(){expect(t.validate({beginLineNum:-1})).toBe(RB.DiffComment.strings.BEGINLINENUM_GTE_0)}),it("endLineNum < 0",function(){expect(t.validate({endLineNum:-1})).toBe(RB.DiffComment.strings.ENDLINENUM_GTE_0)}),it("endLineNum < beginLineNum",function(){expect(t.validate({beginLineNum:20,endLineNum:10})).toBe(RB.DiffComment.strings.BEGINLINENUM_LTE_ENDLINENUM)})})}),describe("fileDiffID",function(){it("With value",function(){expect(t.validate({fileDiffID:42})).toBe(void 0)}),it("Unset",function(){expect(t.validate({fileDiffID:null})).toBe(RB.DiffComment.strings.INVALID_FILEDIFF_ID)})})})}),suite("rb/resources/models/DraftReviewRequest",function(){let t;beforeEach(function(){var e=new RB.ReviewRequest({id:1,links:{draft:{href:"/api/review-requests/123/draft/"}}});t=e.draft,spyOn(e,"ready").and.resolveTo(),spyOn(e,"ensureCreated").and.resolveTo(),spyOn(t,"ready").and.resolveTo()}),it("url",function(){expect(t.url()).toBe("/api/review-requests/123/draft/")}),describe("publish",function(){it("With promises",async function(){spyOn(RB,"apiCall").and.callThrough(),spyOn($,"ajax").and.callFake(e=>{expect(e.data.public).toBe(1),e.success({stat:"ok",draft:{id:1,links:{}}})}),t.set({targetGroups:[{name:"mygroup",url:"/groups/mygroup"}],summary:"My summary",description:"My description"}),await t.publish(),expect(RB.apiCall).toHaveBeenCalled(),expect($.ajax).toHaveBeenCalled()}),it("With callbacks",function(e){spyOn(RB,"apiCall").and.callThrough(),spyOn($,"ajax").and.callFake(e=>{expect(e.data.public).toBe(1),e.success({stat:"ok",draft:{id:1,links:{}}})}),spyOn(console,"warn"),t.set({targetGroups:[{name:"mygroup",url:"/groups/mygroup"}],summary:"My summary",description:"My description"}),t.publish({success:()=>{expect(RB.apiCall).toHaveBeenCalled(),expect($.ajax).toHaveBeenCalled(),expect(console.warn).toHaveBeenCalled(),e()},error:()=>e.fail()})})}),it("parse",function(){var e=t.parse({stat:"ok",draft:{id:1,branch:"branch",bugs_closed:"bugsClosed",changedescription:"changeDescription",changedescription_text_type:"markdown",description:"description",public:"public",description_text_type:"markdown",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain",links:{submitter:"submitter"}}});expect(e).not.toBe(void 0),expect(e.id).toBe(1),expect(e.branch).toBe("branch"),expect(e.bugsClosed).toBe("bugsClosed"),expect(e.changeDescription).toBe("changeDescription"),expect(e.changeDescriptionRichText).toBe(!0),expect(e.description).toBe("description"),expect(e.descriptionRichText).toBe(!0),expect(e.public).toBe("public"),expect(e.summary).toBe("summary"),expect(e.submitter).toBe("submitter"),expect(e.targetGroups).toBe("targetGroups"),expect(e.targetPeople).toBe("targetPeople"),expect(e.testingDone).toBe("testingDone"),expect(e.testingDoneRichText).toBe(!1)})}),suite("rb/resources/models/FileAttachmentComment",function(){const t=RB.BaseResource.strings;let i;beforeEach(function(){i=new RB.FileAttachmentComment({fileAttachmentID:16,parentObject:new RB.BaseResource({public:!0})})}),describe("parse",function(){it("API payloads",function(){var e=i.parse({stat:"ok",file_attachment_comment:{id:42,issue_opened:!0,issue_status:"resolved",text_type:"markdown",text:"foo",extra_data:{my_int:123,my_bool:!0,my_str:"strvalue",my_null:null},link_text:"my-link-text",thumbnail_html:"<blink>Boo</blink>",review_url:"/review-ui/",file_attachment:{id:10,filename:"file.txt"}}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.issueOpened).toBe(!0),expect(e.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED),expect(e.richText).toBe(!0),expect(e.text).toBe("foo"),expect(e.extraData).not.toBe(void 0),expect(e.extraData.my_int).toBe(123),expect(e.extraData.my_bool).toBe(!0),expect(e.extraData.my_str).toBe("strvalue"),expect(e.extraData.my_null).toBe(null),expect(e.linkText).toBe("my-link-text"),expect(e.thumbnailHTML).toBe("<blink>Boo</blink>"),expect(e.reviewURL).toBe("/review-ui/"),expect(e.fileAttachment).not.toBe(void 0),expect(e.fileAttachment.id).toBe(10),expect(e.fileAttachment.get("filename")).toBe("file.txt"),expect(e.fileAttachmentID).toBe(10)})}),describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough(),i.toJSON(),expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()}),describe("diff_against_file_attachment_id field",function(){it("When loaded",function(){i.set({loaded:!0,diffAgainstFileAttachmentID:123});var e=i.toJSON();expect(e.diff_against_file_attachment_id).toBe(void 0)}),describe("When not loaded",function(){it("With value",function(){i.set("diffAgainstFileAttachmentID",123);var e=i.toJSON();expect(e.diff_against_file_attachment_id).toBe(123)}),it("Without value",function(){var e=i.toJSON();expect(e.diff_against_file_attachment_id).toBe(void 0)})})}),describe("file_attachment_id field",function(){it("When loaded",function(){i.set({loaded:!0,fileAttachmentID:123});var e=i.toJSON();expect(e.file_attachment_id).toBe(void 0)}),it("When not loaded",function(){i.set("fileAttachmentID",123);var e=i.toJSON();expect(e.file_attachment_id).toBe(123)})}),describe("force_text_type field",function(){it("With value",function(){i.set("forceTextType","html");var e=i.toJSON();expect(e.force_text_type).toBe("html")}),it("Without value",function(){var e=i.toJSON();expect(e.force_text_type).toBe(void 0)})}),describe("include_text_types field",function(){it("With value",function(){i.set("includeTextTypes","html");var e=i.toJSON();expect(e.include_text_types).toBe("html")}),it("Without value",function(){var e=i.toJSON();expect(e.include_text_types).toBe(void 0)})}),it("extra_data field",function(){i.set({extraData:{my_int:123,my_bool:!0,my_str:"strvalue",my_null:null}});var e=i.toJSON();expect(e["extra_data.my_int"]).toBe(123),expect(e["extra_data.my_bool"]).toBe(!0),expect(e["extra_data.my_str"]).toBe("strvalue"),expect(e["extra_data.my_null"]).toBe(null)})}),describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate"),i.validate({}),expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()}),describe("extraData",function(){describe("Valid values",function(){it("Empty object",function(){expect(i.validate({extraData:{}})).toBe(void 0)}),it("Populated object",function(){expect(i.validate({extraData:{a:42}})).toBe(void 0)}),it("Undefined",function(){expect(i.validate({extraData:void 0})).toBe(void 0)})}),describe("Invalid values",function(){const e=t.INVALID_EXTRADATA_TYPE;it("Array",function(){expect(i.validate({extraData:""})).toBe(e)}),it("Boolean",function(){expect(i.validate({extraData:!1})).toBe(e)}),it("Integer",function(){expect(i.validate({extraData:0})).toBe(e)}),it("Null",function(){expect(i.validate({extraData:null})).toBe(e)}),it("String",function(){expect(i.validate({extraData:""})).toBe(e)})})}),describe("extraData entries",function(){describe("Valid values",function(){it("Booleans",function(){expect(i.validate({extraData:{value:!0}})).toBe(void 0)}),it("Integers",function(){expect(i.validate({extraData:{value:42}})).toBe(void 0)}),it("Null",function(){expect(i.validate({extraData:{value:null}})).toBe(void 0)}),it("Strings",function(){expect(i.validate({extraData:{value:"foo"}})).toBe(void 0)})}),describe("Invalid values",function(){const e=t.INVALID_EXTRADATA_VALUE_TYPE.replace("{key}","value");it("Arrays",function(){expect(i.validate({extraData:{value:[1,2,3]}})).toBe(e)}),it("NaN",function(){expect(i.validate({extraData:{value:NaN}})).toBe(e)}),it("Objects",function(){expect(i.validate({extraData:{value:{a:1}}})).toBe(e)}),it("Undefined",function(){expect(i.validate({extraData:{value:void 0}})).toBe(e)})})})})}),suite("rb/resources/models/FileDiff",function(){let t;beforeEach(function(){t=new RB.FileDiff({destFilename:"dest-file",sourceFilename:"source-file",sourceRevision:"source-revision"})}),describe("parse",function(){it("API payloads",function(){var e=t.parse({stat:"ok",filediff:{id:42,dest_file:"my-dest-file",source_file:"my-source-file",source_revision:"my-source-revision"}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.destFilename).toBe("my-dest-file"),expect(e.sourceFilename).toBe("my-source-file"),expect(e.sourceRevision).toBe("my-source-revision")})})}),suite("rb/resources/models/GeneralComment",function(){let t;beforeEach(function(){t=new RB.GeneralComment({parentObject:new RB.BaseResource({public:!0})})}),describe("parse",function(){it("API payloads",function(){var e=t.parse({stat:"ok",general_comment:{id:42,issue_opened:!0,issue_status:"resolved",text_type:"markdown",text:"foo"}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.issueOpened).toBe(!0),expect(e.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED),expect(e.richText).toBe(!0),expect(e.text).toBe("foo")})}),describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough(),t.toJSON(),expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()})}),describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate"),t.validate({}),expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()})})}),suite("rb/resources/models/Screenshot",function(){let t;beforeEach(function(){t=new RB.Screenshot({parentObject:new RB.BaseResource({public:!0})})}),describe("getDisplayName",function(){it("With caption",function(){t.set("caption","My Caption"),expect(t.getDisplayName()).toBe("My Caption")}),it("With filename",function(){t.set("filename","myfile.png"),expect(t.getDisplayName()).toBe("myfile.png")}),it("With caption and filename",function(){t.set({caption:"My Caption",filename:"myfile.png"}),expect(t.getDisplayName()).toBe("My Caption")})}),describe("parse",function(){it("API payloads",function(){var e=t.parse({stat:"ok",screenshot:{id:42,caption:"my-caption",filename:"my-filename",review_url:"/review-ui/"}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.caption).toBe("my-caption"),expect(e.filename).toBe("my-filename"),expect(e.reviewURL).toBe("/review-ui/")})}),describe("toJSON",function(){describe("caption field",function(){it("With value",function(){t.set("caption","foo");var e=t.toJSON();expect(e.caption).toBe("foo")})})})}),suite("rb/resources/models/ScreenshotComment",function(){const e=RB.ScreenshotComment.strings;let t;beforeEach(function(){t=new RB.ScreenshotComment({screenshotID:16,parentObject:new RB.BaseResource({public:!0}),x:0,y:0,width:1,height:1})}),describe("parse",function(){it("API payloads",function(){var e=t.parse({stat:"ok",screenshot_comment:{id:42,issue_opened:!0,issue_status:"resolved",text_type:"markdown",text:"foo",x:10,y:20,w:30,h:40,thumbnail_url:"/thumbnail.png",screenshot:{id:10,filename:"image.png"}}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.issueOpened).toBe(!0),expect(e.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED),expect(e.richText).toBe(!0),expect(e.text).toBe("foo"),expect(e.x).toBe(10),expect(e.y).toBe(20),expect(e.width).toBe(30),expect(e.height).toBe(40),expect(e.thumbnailURL).toBe("/thumbnail.png"),expect(e.screenshot).not.toBe(void 0),expect(e.screenshot.id).toBe(10),expect(e.screenshot.get("filename")).toBe("image.png"),expect(e.screenshotID).toBe(10)})}),describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough(),t.toJSON(),expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()}),it("x field",function(){t.set("x",10);var e=t.toJSON();expect(e.x).toBe(10)}),it("y field",function(){t.set("y",10);var e=t.toJSON();expect(e.y).toBe(10)}),it("w field",function(){t.set("width",10);var e=t.toJSON();expect(e.w).toBe(10)}),it("h field",function(){t.set("height",10);var e=t.toJSON();expect(e.h).toBe(10)}),describe("force_text_type field",function(){it("With value",function(){t.set("forceTextType","html");var e=t.toJSON();expect(e.force_text_type).toBe("html")}),it("Without value",function(){var e=t.toJSON();expect(e.force_text_type).toBe(void 0)})}),describe("include_text_types field",function(){it("With value",function(){t.set("includeTextTypes","html");var e=t.toJSON();expect(e.include_text_types).toBe("html")}),it("Without value",function(){var e=t.toJSON();expect(e.include_text_types).toBe(void 0)})})}),describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate"),t.validate({}),expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()}),describe("x",function(){describe("Valid values",function(){it("0",function(){expect(t.validate({x:0})).toBe(void 0)}),it("> 0",function(){expect(t.validate({x:10})).toBe(void 0)})}),describe("Invalid values",function(){it("< 0",function(){expect(t.validate({x:-1})).toBe(e.INVALID_X)})})}),describe("y",function(){describe("Valid values",function(){it("0",function(){expect(t.validate({y:0})).toBe(void 0)}),it("> 0",function(){expect(t.validate({y:10})).toBe(void 0)})}),describe("Invalid values",function(){it("< 0",function(){expect(t.validate({y:-1})).toBe(e.INVALID_Y)})})}),describe("width",function(){describe("Valid values",function(){it("> 0",function(){expect(t.validate({width:10})).toBe(void 0)})}),describe("Invalid values",function(){it("0",function(){expect(t.validate({width:0})).toBe(e.INVALID_WIDTH)}),it("< 0",function(){expect(t.validate({width:-1})).toBe(e.INVALID_WIDTH)})})}),describe("height",function(){describe("Valid values",function(){it("> 0",function(){expect(t.validate({height:10})).toBe(void 0)})}),describe("Invalid values",function(){it("0",function(){expect(t.validate({height:0})).toBe(e.INVALID_HEIGHT)}),it("< 0",function(){expect(t.validate({height:-1})).toBe(e.INVALID_HEIGHT)})})})})}),suite("rb/resources/models/RepositoryBranch",function(){let t;beforeEach(function(){t=new RB.RepositoryBranch}),describe("parse",function(){it("API payloads",function(){var e=t.parse({name:"master",commit:"c8ffef025488802a77f499d7f0d24579d858b07e",default:!0});expect(e).not.toBe(void 0),expect(e.name).toBe("master"),expect(e.commit).toBe("c8ffef025488802a77f499d7f0d24579d858b07e"),expect(e.isDefault).toBe(!0)})})}),suite("rb/resources/models/RepositoryCommit",function(){let t;beforeEach(function(){t=new RB.RepositoryCommit}),describe("parse",function(){it("API payloads",function(){var e=t.parse({author_name:"Sneezy",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Here's a commit message\n\nWith a description",review_request_url:"http://example.com/r/12/"});expect(e).not.toBe(void 0),expect(e.authorName).toBe("Sneezy"),expect(e.id).toBe("859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817"),expect(e.date.getUTCFullYear()).toBe(2013),expect(e.date.getUTCDate()).toBe(25),expect(e.message).toBe("Here's a commit message\n\nWith a description"),expect(e.summary).toBe("Here's a commit message"),expect(e.reviewRequestURL).toBe("http://example.com/r/12/")})})}),suite("rb/resources/models/UserFileAttachment",function(){let t;beforeEach(function(){t=new RB.UserFileAttachment}),describe("toJSON",function(){describe("caption field",function(){it("With value",function(){t.set("caption","foo");var e=t.toJSON();expect(e.caption).toBe("foo")})}),describe("file field",function(){it("With no file attachment",function(){t.id=123,t.attributes.id=123,expect(t.isNew()).toBe(!1);var e=t.toJSON();expect(e.path).toBe(void 0)}),it("With file attachment",function(){t.id=123,t.attributes.id=123,expect(t.isNew()).toBe(!1),t.set("file","abc");var e=t.toJSON();expect(e.path).toBe("abc")})})}),describe("parse",function(){it("API payloads",function(){var e=t.parse({stat:"ok",user_file_attachment:{id:42,caption:"caption",absolute_url:"downloadURL",filename:"filename"}});expect(e).not.toBe(void 0),expect(e.id).toBe(42),expect(e.caption).toBe("caption"),expect(e.downloadURL).toBe("downloadURL"),expect(e.filename).toBe("filename")})})}),suite("rb/resources/models/ValidateDiffModel",function(){let t;beforeEach(function(){t=new RB.ValidateDiffModel}),describe("methods",function(){describe("url",function(){it("Without local site",function(){expect(_.result(t,"url")).toBe("/api/validation/diffs/")}),it("With local site",function(){t.set("localSitePrefix","s/test-site/"),expect(_.result(t,"url")).toBe("/s/test-site/api/validation/diffs/")}),it("With a null local site",function(){t.set("localSitePrefix",null),expect(_.result(t,"url")).toBe("/api/validation/diffs/")})})}),describe("toJSON",function(){it("repository field",function(){t.set("repository",123);var e=t.toJSON();expect(e.repository).toBe(123)})})}),suite("rb/reviewRequestPage/models/ChangeEntry",function(){it("parse",function(){var e=[["1","100"],["2","100-101"]],t=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest}),i=new RB.ReviewRequestPage.ChangeEntry({diffCommentsData:e,id:"100",typeID:"changedesc",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",pendingStatusUpdates:!0,reviewsData:[{id:123,bodyTop:"My body top",bodyBottom:"My body bottom",public:!0,shipIt:!1}],reviewRequestEditor:t,ignoredAttr:"ignored"},{parse:!0}),e=(expect(i.id).toBe("100"),expect(i.get("diffCommentsData")).toBe(e),expect(i.get("reviewRequestEditor")).toBe(t),expect(i.get("typeID")).toBe("changedesc"),expect(i.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25))),expect(i.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0))),expect(i.get("pendingStatusUpdates")).toBe(!0),expect(i.get("ignoredAttr")).toBe(void 0),i.get("reviews")),t=(expect(e.length).toBe(1),e[0]);expect(t.get("id")).toBe(123),expect(t.get("bodyTop")).toBe("My body top"),expect(t.get("bodyBottom")).toBe("My body bottom"),expect(t.get("public")).toBe(!0),expect(t.get("shipIt")).toBe(!1)})}),suite("rb/reviewRequestPage/models/Entry",function(){let e,t;beforeEach(function(){e=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest}),t=new RB.ReviewRequestPage.Entry({reviewRequestEditor:e,id:"123",typeID:"some_type",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",ignoredAttr:"ignored"},{parse:!0})}),it("parse",function(){expect(t.id).toBe("123"),expect(t.get("reviewRequestEditor")).toBe(e),expect(t.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25))),expect(t.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0))),expect(t.get("typeID")).toBe("some_type")}),describe("isUpdated",function(){it("With newer updateTimestamp only",function(){expect(t.isUpdated({updatedTimestamp:"2017-08-20T23:10:12Z"})).toBe(!0)}),it("With older updateTimestamp only",function(){expect(t.isUpdated({updatedTimestamp:"2017-08-18T12:10:12Z"})).toBe(!1)}),it("With changed etag",function(){expect(t.isUpdated({etag:"new-etag",updatedTimestamp:"2017-08-18T16:20:00Z"})).toBe(!0)}),it("With same updateTimestamp and etag",function(){t.set("etag","old-etag");expect(t.isUpdated({etag:"old-etag",updatedTimestamp:"2017-08-18T16:20:00Z"})).toBe(!1)})})}),suite("rb/reviewRequestPage/models/ReviewEntry",function(){it("parse",function(){var e=[["1","100"],["2","100-101"]],t=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest}),i=new RB.ReviewRequestPage.ReviewEntry({diffCommentsData:e,id:"100",typeID:"review",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",reviewData:{id:123,bodyTop:"My body top",bodyBottom:"My body bottom",public:!0,shipIt:!1},reviewRequestEditor:t,ignoredAttr:"ignored"},{parse:!0}),e=(expect(i.id).toBe("100"),expect(i.get("diffCommentsData")).toBe(e),expect(i.get("reviewRequestEditor")).toBe(t),expect(i.get("typeID")).toBe("review"),expect(i.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25))),expect(i.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0))),expect(i.get("ignoredAttr")).toBe(void 0),i.get("review"));expect(e).toBeTruthy(),expect(e.get("id")).toBe(123),expect(e.get("bodyTop")).toBe("My body top"),expect(e.get("bodyBottom")).toBe("My body bottom"),expect(e.get("public")).toBe(!0),expect(e.get("shipIt")).toBe(!1)})}),suite("rb/reviewRequestPage/models/ReviewReplyEditor",function(){let o,a,s;beforeEach(function(){a=new RB.Review({loaded:!0,links:{replies:{href:"/api/review/123/replies/"}}}),o=a.createReply(),spyOn(a,"ready").and.resolveTo(),spyOn(o,"ensureCreated").and.resolveTo(),spyOn(o,"ready").and.resolveTo()}),describe("Event handling",function(){describe("reviewReply changes",function(){beforeEach(function(){s=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"body_top",review:a,reviewReply:o,text:"My Text"})}),it("Sets up events on new reviewReply",function(){spyOn(s,"listenTo").and.callThrough();var e=new RB.ReviewReply;s.set("reviewReply",e),expect(s.listenTo.calls.count()).toEqual(2),expect(s.listenTo.calls.argsFor(0)[1]).toEqual("destroyed"),expect(s.listenTo.calls.argsFor(1)[1]).toEqual("published")}),it("Removes events from old reviewReply",function(){s.set("reviewReply",new RB.ReviewReply),expect(s._listeningTo.hasOwnProperty(o._listenId)).toBe(!1)})})}),describe("Methods",function(){describe("save",function(){function i(e,t){s=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:e.contextType,review:a,reviewReply:o,richText:e.richText,text:"My Text"}),spyOn(s,"trigger"),spyOn(o,"save").and.resolveTo(),s.save().then(()=>{expect(s.get("replyObject")).toBe(o),expect(s.get("hasDraft")).toBe(!0),expect(s.get("text")).toBe("My Text"),expect(s.get("richText")).toBe(!0),expect(o.get(e.textAttr)).toBe("My Text"),expect(o.get(e.richTextAttr)).toBe(e.richText),expect(o.ready).toHaveBeenCalled(),expect(o.save).toHaveBeenCalled(),expect(s.trigger).toHaveBeenCalledWith("saving"),expect(s.trigger).toHaveBeenCalledWith("saved"),t()}).catch(e=>t.fail(e))}function n(t,i){s=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:t.contextType,hasDraft:!1,review:a,reviewReply:o,richText:t.richText,text:"My Text"}),spyOn(s,"trigger"),spyOn(t.model.prototype,"ready").and.resolveTo(),spyOn(t.model.prototype,"save").and.resolveTo(),s.save().then(()=>{var e=s.get("replyObject");expect(s.get("hasDraft")).toBe(!0),expect(s.get("text")).toBe("My Text"),expect(s.get("richText")).toBe(!0),expect(e instanceof t.model).toBe(!0),expect(e.get("text")).toBe("My Text"),expect(e.get("richText")).toBe(t.richText),expect(t.model.prototype.ready).toHaveBeenCalled(),expect(t.model.prototype.save).toHaveBeenCalled(),expect(s.trigger).toHaveBeenCalledWith("saving"),expect(s.trigger).toHaveBeenCalledWith("saved"),i()}).catch(e=>i.fail(e))}it("With existing reply object",function(t){const e=new RB.DiffCommentReply;s=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",hasDraft:!1,replyObject:e,review:a,reviewReply:o,text:"My Text"}),spyOn(s,"trigger"),spyOn(e,"ready").and.resolveTo(),spyOn(e,"save").and.resolveTo(),s.save().then(()=>{expect(s.get("hasDraft")).toBe(!0),expect(s.get("replyObject")).toBe(e),expect(e.get("text")).toBe("My Text"),expect(e.ready).toHaveBeenCalled(),expect(e.save).toHaveBeenCalled(),expect(s.trigger).toHaveBeenCalledWith("saving"),expect(s.trigger).toHaveBeenCalledWith("saved"),t()}).catch(e=>t.fail(e))}),it("With empty text",function(t){const e=new RB.DiffCommentReply({text:"Orig Text"});s=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",review:a,reviewReply:o}),spyOn(s,"trigger"),spyOn(s,"resetStateIfEmpty").and.resolveTo(),spyOn(e,"ready").and.resolveTo(),spyOn(e,"save"),s.set({hasDraft:!1,replyObject:e,text:""}),s.save().then(()=>{expect(s.get("hasDraft")).toBe(!1),expect(s.get("replyObject")).toBe(e),expect(e.get("text")).toBe("Orig Text"),expect(e.ready).toHaveBeenCalled(),expect(e.save).not.toHaveBeenCalled(),expect(s.resetStateIfEmpty).toHaveBeenCalled(),expect(s.trigger).toHaveBeenCalledWith("saving"),t()}).catch(e=>t.fail(e))}),describe("With body_top",function(){function t(e,t){i({contextType:"body_top",textAttr:"bodyTop",richTextAttr:"bodyTopRichText",richText:e},t)}it("richText=true",function(e){t(!0,e)}),it("richText=false",function(e){t(!1,e)})}),describe("With body_bottom",function(){function t(e,t){i({contextType:"body_bottom",textAttr:"bodyBottom",richTextAttr:"bodyBottomRichText",richText:e},t)}it("richText=true",function(e){t(!0,e)}),it("richText=false",function(e){t(!1,e)})}),describe("With diff comments",function(){function t(e,t){n({contextType:"diff_comments",model:RB.DiffCommentReply,richText:e},t)}it("richText=true",function(e){t(!0,e)}),it("richText=false",function(e){t(!1,e)})}),describe("With file attachment comments",function(){function t(e,t){n({contextType:"file_attachment_comments",model:RB.FileAttachmentCommentReply,richText:e},t)}it("richText=true",function(e){t(!0,e)}),it("richText=false",function(e){t(!1,e)})}),describe("With general comments",function(){function t(e,t){n({contextType:"general_comments",model:RB.GeneralCommentReply,richText:e},t)}it("richText=true",function(e){t(!0,e)}),it("richText=false",function(e){t(!1,e)})}),describe("With screenshot comments",function(){function t(e,t){n({contextType:"screenshot_comments",model:RB.ScreenshotCommentReply,richText:e},t)}it("richText=true",function(e){t(!0,e)}),it("richText=false",function(e){t(!1,e)})})}),describe("resetStateIfEmpty",function(){let e;beforeEach(function(){e=new RB.DiffCommentReply,s=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",hasDraft:!0,replyObject:e,review:a,reviewReply:o}),spyOn(s,"trigger"),spyOn(e,"destroy").and.resolveTo(),spyOn(o,"discardIfEmpty").and.resolveTo(!0)}),it("Without empty text",async function(){s.set("text","My Text"),await s.resetStateIfEmpty(),expect(e.destroy).not.toHaveBeenCalled(),expect(s.get("hasDraft")).toBe(!0),expect(s.trigger).not.toHaveBeenCalledWith("resetState")}),describe("With empty text",function(){it("With no reply object",async function(){s.set("replyObject",null),await s.resetStateIfEmpty(),expect(s.trigger).toHaveBeenCalledWith("resetState"),expect(e.destroy).not.toHaveBeenCalled(),expect(s.get("hasDraft")).toBe(!1)}),it("With new reply object",async function(){e.set("id",null),await s.resetStateIfEmpty(),expect(s.trigger).toHaveBeenCalledWith("resetState"),expect(e.destroy).not.toHaveBeenCalled(),expect(s.get("hasDraft")).toBe(!1)}),it("With existing reply object",async function(){e.set("id",123),await s.resetStateIfEmpty(),expect(e.destroy).toHaveBeenCalled(),expect(s.get("hasDraft")).toBe(!1),expect(s.trigger).toHaveBeenCalledWith("resetState")}),describe("With context type",function(){beforeEach(function(){e.set("id",123),spyOn(s,"_resetState").and.resolveTo()}),it("body_top",async function(){s.set("contextType","body_top"),await s.resetStateIfEmpty(),expect(e.destroy).not.toHaveBeenCalled(),expect(s._resetState).toHaveBeenCalledWith(!0)}),it("body_bottom",async function(){s.set("contextType","body_bottom"),await s.resetStateIfEmpty(),expect(e.destroy).not.toHaveBeenCalled(),expect(s._resetState).toHaveBeenCalledWith(!0)}),it("diff_comments",async function(){s.set("contextType","diff_comments"),await s.resetStateIfEmpty(),expect(e.destroy).toHaveBeenCalled(),expect(s._resetState).toHaveBeenCalledWith()}),it("file_attachment_comments",async function(){s.set("contextType","file_attachment_comments"),await s.resetStateIfEmpty(),expect(e.destroy).toHaveBeenCalled(),expect(s._resetState).toHaveBeenCalledWith()}),it("general_comments",async function(){s.set("contextType","general_comments"),await s.resetStateIfEmpty(),expect(e.destroy).toHaveBeenCalled(),expect(s._resetState).toHaveBeenCalledWith()}),it("screenshot_comments",async function(){s.set("contextType","screenshot_comments"),await s.resetStateIfEmpty(),expect(e.destroy).toHaveBeenCalled(),expect(s._resetState).toHaveBeenCalledWith()})})})})})}),suite("rb/reviewRequestPage/models/ReviewRequestPage",function(){let a;beforeEach(function(){a=new RB.ReviewRequestPage.ReviewRequestPage({updatesURL:"/r/123/_updates/",checkForUpdates:!1,reviewRequestData:{},editorData:{fileAttachments:[],mutableByUser:!0,showSendEmail:!1}},{parse:!0})}),describe("Methods",function(){it("addEntry",function(){var e=new RB.ReviewRequestPage.Entry;a.addEntry(e),expect(e.get("page")).toBe(a),expect(a.entries.at(0)).toBe(e)}),describe("parse",function(){it("Parent called",function(){var e=a.parse({reviewRequestData:{summary:"Test summary"}});expect(e.reviewRequest).toBeTruthy(),expect(e.reviewRequest.get("summary")).toBe("Test summary")}),it("updatesURL",function(){var e=a.parse({updatesURL:"https://example.com/"});expect(e.updatesURL).toBe("https://example.com/")})}),describe("watchEntryUpdates",function(){let e;beforeEach(function(){spyOn(a,"_scheduleCheckUpdates"),e=new RB.ReviewRequestPage.Entry({id:"my-entry"})}),it("First call",function(){a.watchEntryUpdates(e,1e3),expect(a._watchedUpdatesPeriodMS).toBe(1e3),expect(a._watchedEntries[e.id]).toEqual({entry:e,periodMS:1e3}),expect(a._scheduleCheckUpdates).toHaveBeenCalled()}),it("Shorter watch periods take precedent",function(){a._watchedUpdatesPeriodMS=5e3,a.watchEntryUpdates(e,1e3),expect(a._watchedUpdatesPeriodMS).toBe(1e3),expect(a._watchedEntries[e.id]).toEqual({entry:e,periodMS:1e3}),expect(a._scheduleCheckUpdates).toHaveBeenCalled()}),it("Subsequent call with longer watch period",function(){a._watchedUpdatesPeriodMS=1e3,a.watchEntryUpdates(e,5e3),expect(a._watchedUpdatesPeriodMS).toBe(1e3),expect(a._watchedEntries[e.id]).toEqual({entry:e,periodMS:5e3}),expect(a._scheduleCheckUpdates).toHaveBeenCalled()})}),describe("stopWatchingEntryUpdates",function(){beforeEach(function(){spyOn(a,"_scheduleCheckUpdates")}),it("Switches to next-shortest update period",function(){var e=new RB.ReviewRequestPage.Entry({id:"1"}),t=new RB.ReviewRequestPage.Entry({id:"2"});a.watchEntryUpdates(e,2e3),a.watchEntryUpdates(t,1e3),expect(a._watchedUpdatesPeriodMS).toBe(1e3),a.stopWatchingEntryUpdates(t),expect(a._watchedUpdatesPeriodMS).toBe(2e3)}),it("Last entry being watched",function(){var e=new RB.ReviewRequestPage.Entry({id:"1"});a.watchEntryUpdates(e,1e3),a.stopWatchingEntryUpdates(e),expect(_.isEmpty(a._watchedEntries)).toBe(!0),expect(a._watchedUpdatesTimeout).toBe(null),expect(a._watchedUpdatesPeriodMS).toBe(null),expect(a._watchedUpdatesLastScheduleTime).toBe(null)})})}),describe("Dynamic updating",function(){it("Scheduled check for update",function(){let i=null;spyOn(a,"_scheduleCheckUpdates").and.callThrough(),spyOn(window,"setTimeout").and.callFake((e,t)=>(i=e,"dummy value")),spyOn(a,"_loadUpdates").and.callThrough(),spyOn(Backbone,"sync");var e=new RB.ReviewRequestPage.Entry({typeID:"my-entry",id:"100"}),t=new RB.ReviewRequestPage.Entry({typeID:"my-entry",id:"200"}),n=new RB.ReviewRequestPage.Entry({typeID:"another-entry",id:"foo"}),e=(a.watchEntryUpdates(e,2e3),a.watchEntryUpdates(t,1e3),a.watchEntryUpdates(n,2e3),expect(i).not.toBe(null),expect(a._scheduleCheckUpdates).toHaveBeenCalled(),expect(a._watchedUpdatesLastScheduleTime).not.toBe(null),expect(a._watchedUpdatesTimeout).not.toBe(null),i(),expect(a._watchedUpdatesLastScheduleTime).not.toBe(null),expect(a._watchedUpdatesTimeout).toBe(null),expect(a._loadUpdates.calls.count()).toBe(1),expect(a._loadUpdates.calls.mostRecent().args[0].entries).toEqual([e,t,n]),expect(Backbone.sync.calls.count()).toBe(1),Backbone.sync.calls.mostRecent().args[2]);expect(e.url).toBe("/r/123/_updates/?entries=my-entry:100,200;another-entry:foo"),expect(e.noActivityIndicator).toBe(!0),expect(e.dataType).toBe("arraybuffer")}),describe("Response parsing",function(){const e=RB.ReviewRequestPage.Entry.extend({parse(e){return _.extend({myAttr:e.myAttr},RB.ReviewRequestPage.Entry.prototype.parse.call(this,e))}});let n,o;beforeEach(function(){spyOn(a,"trigger").and.callThrough(),n=new e({typeID:"my-entry",id:"1",addedTimestamp:new Date(Date.UTC(2017,7,1,0,0,0)),updatedTimestamp:new Date(Date.UTC(2017,7,1,12,0,0))}),o=new e({typeID:"my-entry",id:"2",addedTimestamp:new Date(Date.UTC(2017,7,1,0,0,0)),updatedTimestamp:new Date(Date.UTC(2017,7,1,12,0,0))}),a.addEntry(n),a.addEntry(o)}),it("Updates to outdated entries using timestamps",function(i){spyOn(n,"beforeApplyUpdate"),spyOn(n,"afterApplyUpdate"),spyOn(o,"beforeApplyUpdate"),spyOn(o,"afterApplyUpdate"),spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer"),expect(e.url).toBe("/r/123/_updates/");var t=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-04T14:30:20", ','"modelData": {"myAttr": "value1"}}']),i=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-03T14:30:20", ','"modelData": {"myAttr": "value2"}}']),n=new Blob(["<p>My HTML!</p>"]),o=new Blob(["<p>Oh hi!</p>"]),t=RB.DataUtils.buildBlob([[{type:"uint32",values:[177]}],t,[{type:"uint32",values:[15]}],n,[{type:"uint32",values:[177]}],i,[{type:"uint32",values:[13]}],o]);RB.DataUtils.readBlobAsArrayBuffer(t,e.success)}),a._loadUpdates({onDone:()=>{var e={type:"entry",entryType:"my-entry",entryID:"1",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-04T14:30:20",modelData:{myAttr:"value1"}},t="<p>My HTML!</p>",e=(expect(n.get("myAttr")).toBe("value1"),expect(n.get("etag")).toBe(null),expect(n.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,4,14,30,20))),expect(n.beforeApplyUpdate).toHaveBeenCalledWith(e),expect(n.afterApplyUpdate).toHaveBeenCalledWith(e),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry",e,t),{type:"entry",entryType:"my-entry",entryID:"2",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-03T14:30:20",modelData:{myAttr:"value2"}}),t="<p>Oh hi!</p>";expect(o.get("myAttr")).toBe("value2"),expect(o.get("etag")).toBe(null),expect(o.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,3,14,30,20))),expect(o.beforeApplyUpdate).toHaveBeenCalledWith(e),expect(o.afterApplyUpdate).toHaveBeenCalledWith(e),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("updatesProcessed"),i()}})}),it("Updates to outdated entries using etags",function(i){n.set("etag","old-etag"),o.set("etag","old-etag"),spyOn(n,"beforeApplyUpdate"),spyOn(n,"afterApplyUpdate"),spyOn(o,"beforeApplyUpdate"),spyOn(o,"afterApplyUpdate"),spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer"),expect(e.url).toBe("/r/123/_updates/");var t=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"etag": "new-etag", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-07-01T12:00:00", ','"modelData": {"myAttr": "value1"}}']),i=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"etag": "new-etag", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-07-01T12:00:00", ','"modelData": {"myAttr": "value2"}}']),n=new Blob(["<p>My HTML!</p>"]),o=new Blob(["<p>Oh hi!</p>"]),t=RB.DataUtils.buildBlob([[{type:"uint32",values:[197]}],t,[{type:"uint32",values:[15]}],n,[{type:"uint32",values:[197]}],i,[{type:"uint32",values:[13]}],o]);RB.DataUtils.readBlobAsArrayBuffer(t,e.success)}),a._loadUpdates({onDone:()=>{var e={type:"entry",entryType:"my-entry",entryID:"1",etag:"new-etag",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-07-01T12:00:00",modelData:{myAttr:"value1"}},t="<p>My HTML!</p>",e=(expect(n.get("myAttr")).toBe("value1"),expect(n.get("etag")).toBe("new-etag"),expect(n.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,6,1,12,0,0))),expect(n.beforeApplyUpdate).toHaveBeenCalledWith(e),expect(n.afterApplyUpdate).toHaveBeenCalledWith(e),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry",e,t),{type:"entry",entryType:"my-entry",entryID:"2",etag:"new-etag",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-07-01T12:00:00",modelData:{myAttr:"value2"}}),t="<p>Oh hi!</p>";expect(o.get("myAttr")).toBe("value2"),expect(o.get("etag")).toBe("new-etag"),expect(o.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,6,1,12,0,0))),expect(o.beforeApplyUpdate).toHaveBeenCalledWith(e),expect(o.afterApplyUpdate).toHaveBeenCalledWith(e),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("updatesProcessed"),i()}})}),it("Updates to up-to-date entries",function(i){n.set({etag:"old-etag",myAttr:"existing-value"}),spyOn(n,"beforeApplyUpdate"),spyOn(n,"afterApplyUpdate"),spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer"),expect(e.url).toBe("/r/123/_updates/");var t=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"etag": "old-etag", ','"addedTimestamp": "2016-09-04T14:30:20", ','"updatedTimestamp": "2016-12-10T12:24:14", ','"modelData": {"myAttr": "value1"}}']),i=new Blob(["<p>My HTML!</p>"]),t=RB.DataUtils.buildBlob([[{type:"uint32",values:[t.size]}],t,[{type:"uint32",values:[i.size]}],i]);RB.DataUtils.readBlobAsArrayBuffer(t,e.success)}),a._loadUpdates({onDone:()=>{var e={type:"entry",entryType:"my-entry",entryID:"1",etag:"old-etag",addedTimestamp:"2016-09-04T14:30:20",updatedTimestamp:"2016-09-04T14:30:20",modelData:{myAttr:"value1"}},t="<p>My HTML!</p>";expect(n.get("myAttr")).toBe("existing-value"),expect(n.get("etag")).toBe("old-etag"),expect(n.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,1,12,0,0))),expect(n.beforeApplyUpdate).not.toHaveBeenCalled(),expect(n.afterApplyUpdate).not.toHaveBeenCalled(),expect(a.trigger).not.toHaveBeenCalledWith("applyingUpdate:entry",e,t),expect(a.trigger).not.toHaveBeenCalledWith("applyingUpdate:entry:1",e,t),expect(a.trigger).not.toHaveBeenCalledWith("appliedModelUpdate:entry:1",e,t),expect(a.trigger).not.toHaveBeenCalledWith("appliedUpdate:entry:1",e,t),expect(a.trigger).not.toHaveBeenCalledWith("appliedUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("updatesProcessed"),i()}})}),it("Updates to non-entries",function(i){spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer"),expect(e.url).toBe("/r/123/_updates/");var t=new Blob(['{"type": "something", "foo": "bar"}']),i=new Blob(["<div>Something</div>"]),t=RB.DataUtils.buildBlob([[{type:"uint32",values:[t.size]}],t,[{type:"uint32",values:[i.size]}],i]);RB.DataUtils.readBlobAsArrayBuffer(t,e.success)}),a._loadUpdates({onDone:()=>{var e={type:"something",foo:"bar"},t="<div>Something</div>";expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:something",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:something",e,t),expect(a.trigger).toHaveBeenCalledWith("updatesProcessed"),i()}})}),it("Updates containing Unicode in HTML",function(i){spyOn(n,"beforeApplyUpdate"),spyOn(n,"afterApplyUpdate"),spyOn(o,"beforeApplyUpdate"),spyOn(o,"afterApplyUpdate"),spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer"),expect(e.url).toBe("/r/123/_updates/");var t=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-04T14:30:20", ','"modelData": {"myAttr": "value1"}}']),i=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-03T14:30:20", ','"modelData": {"myAttr": "value2"}}']),n=[60,115,112,97,110,62,195,161,195,169,195,173,195,179,195,186,32,240,159,148,165,60,47,115,112,97,110,62],o=[60,115,112,97,110,62,195,132,195,139,195,143,195,150,195,156,197,184,32,240,159,152,177,60,47,115,112,97,110,62],t=(expect(n.length).toBe(28),expect(o.length).toBe(30),RB.DataUtils.buildBlob([[{type:"uint32",values:[t.size]}],t,[{type:"uint32",values:[n.length]},{type:"uint8",values:n},{type:"uint32",values:[i.size]}],i,[{type:"uint32",values:[o.length]},{type:"uint8",values:o}]]));RB.DataUtils.readBlobAsArrayBuffer(t,e.success)}),a._loadUpdates({onDone:()=>{var e={type:"entry",entryType:"my-entry",entryID:"1",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-04T14:30:20",modelData:{myAttr:"value1"}},t="<span>áéíóú 🔥</span>",e=(expect(n.get("myAttr")).toBe("value1"),expect(n.get("etag")).toBe(null),expect(n.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,4,14,30,20))),expect(n.beforeApplyUpdate).toHaveBeenCalledWith(e),expect(n.afterApplyUpdate).toHaveBeenCalledWith(e),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry",e,t),{type:"entry",entryType:"my-entry",entryID:"2",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-03T14:30:20",modelData:{myAttr:"value2"}}),t="<span>ÄËÏÖÜŸ 😱</span>";expect(o.get("myAttr")).toBe("value2"),expect(o.get("etag")).toBe(null),expect(o.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,3,14,30,20))),expect(o.beforeApplyUpdate).toHaveBeenCalledWith(e),expect(o.afterApplyUpdate).toHaveBeenCalledWith(e),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",e,t),expect(a.trigger).toHaveBeenCalledWith("appliedUpdate:entry",e,t),expect(a.trigger).toHaveBeenCalledWith("updatesProcessed"),i()}})})})})}),suite("rb/reviewRequestPage/models/StatusUpdatesEntry",function(){it("parse",function(){var e=[["1","100"],["2","100-101"]],t=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest({id:5})}),i=new RB.ReviewRequestPage.StatusUpdatesEntry({diffCommentsData:e,id:"0",typeID:"initial_status_updates",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",pendingStatusUpdates:!0,reviewsData:[{id:123,bodyTop:"My body top",bodyBottom:"My body bottom",public:!0,shipIt:!1}],reviewRequestEditor:t,ignoredAttr:"ignored"},{parse:!0}),e=(expect(i.id).toBe("0"),expect(i.get("diffCommentsData")).toBe(e),expect(i.get("reviewRequestEditor")).toBe(t),expect(i.get("typeID")).toBe("initial_status_updates"),expect(i.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25))),expect(i.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0))),expect(i.get("pendingStatusUpdates")).toBe(!0),expect(i.get("ignoredAttr")).toBe(void 0),expect(i.get("reviewRequestId")).toBe(5),i.get("reviews")),t=(expect(e.length).toBe(1),e[0]);expect(t.get("id")).toBe(123),expect(t.get("bodyTop")).toBe("My body top"),expect(t.get("bodyBottom")).toBe("My body bottom"),expect(t.get("public")).toBe(!0),expect(t.get("shipIt")).toBe(!1)})}),suite("rb/reviewRequestPage/views/BaseStatusUpdatesEntryView",function(){const i=Backbone.View.extend({stopWatchingEntryUpdates(){},watchEntryUpdates(){},queueLoadDiff(){}});let n,o,a;beforeEach(function(){var e=new RB.ReviewRequest({id:5}),t=new RB.ReviewRequestEditor({reviewRequest:e}),e=(a=new RB.ReviewRequestPage.StatusUpdatesEntry({reviews:[e.createReview(100,{loaded:!0,links:{replies:{href:"/api/review/100/replies/"}}}),e.createReview(101,{loaded:!0,links:{replies:{href:"/api/review/101/replies/"}}})],localSitePrefix:null,reviewRequest:e,reviewRequestEditor:t,reviewRequestId:5,id:"0",typeID:"initial_status_updates",addedTimestamp:new Date(Date.UTC(2017,7,18,13,40,25)),updatedTimestamp:new Date(Date.UTC(2017,7,18,16,20,0)),pendingStatusUpdates:!0,diffCommentsData:[["1","100"],["2","100-101"]]}),$(`<div id="initial_status_updates"
     class="review-request-page-entry status-updates">
 <a name="initial_status_updates"></a>
 <div class="review-request-page-entry-contents">
  <div class="header status-update-state-pending">
   <div class="collapse-button btn">
    <div class="rb-icon rb-icon-collapse-review"></div>
   </div>
   <div class="header-details">
    <div class="summary">
     <span class="review-request-page-entry-title">
      Checks run (1 waiting to run)
     </span>
    </div>
    <a href="#initial_status_updates" class="timestamp">
     <time class="timesince"
           datetime="2018-11-27T00:18:43.664524+00:00"
           title="Nov. 27, 2018, 12:18 a.m.">0 minutes ago</time>
    </a>
   </div>
  </div>
  <div class="banners"></div>
  <div class="body">
   <section class="status-update-summary">
    <div class="status-update-summary-entry
     status-update-state-not-yet-run">
     <span class="summary">nyc</span>
     Waiting to run
     <input type="button" value="Run" class="status-update-request-run"
            data-status-update-id="1">
    </div>
   </section>
  </div>
 </div>
</div>`).appendTo($testsScratch));n=new RB.ReviewRequestPage.BaseStatusUpdatesEntryView({el:e,model:a}),(o=new i).diffFragmentQueue=new RB.DiffFragmentQueueView({containerPrefix:"comment"}),a.set("page",o),RB.PageManager.setPage(o)}),afterEach(function(){RB.PageManager.setPage(null)}),describe("Dynamic Updating",function(){describe("Update checking",function(){it("Enabled when pendingStatusUpdates=true",function(){spyOn(a,"watchUpdates"),a.set("pendingStatusUpdates",!0),n.render(),expect(a.watchUpdates).toHaveBeenCalled()}),it("Disabled when pendingStatusUpdates=false",function(){spyOn(a,"watchUpdates"),a.set("pendingStatusUpdates",!1),n.render(),expect(a.watchUpdates).not.toHaveBeenCalled()})}),it("Saves fragments on beforeApplyUpdate",function(){spyOn(o.diffFragmentQueue,"saveFragment"),spyOn(o,"stopWatchingEntryUpdates"),n.beforeApplyUpdate(),expect(o.diffFragmentQueue.saveFragment.calls.count()).toBe(2),expect(o.diffFragmentQueue.saveFragment.calls.argsFor(0)).toEqual(["1"]),expect(o.diffFragmentQueue.saveFragment.calls.argsFor(1)).toEqual(["2"]),expect(o.stopWatchingEntryUpdates).toHaveBeenCalled()})}),describe("render",function(){it("Creates ReviewViews",function(){n.render(),expect(n._reviewViews.length).toBe(2)})}),describe("Run status update",function(){it("Runs and checks for updates when button is clicked",function(){spyOn(n.model,"stopWatchingUpdates"),spyOn(n.model,"watchUpdates"),spyOn(RB,"apiCall").and.callThrough(),spyOn($,"ajax").and.callFake(e=>{expect(e.type).toBe("PUT"),expect(e.url).toBe("/api/review-requests/5/status-updates/1/"),e.success()}),n.$el.find(".status-update-request-run").first().click(),expect(RB.apiCall).toHaveBeenCalled(),expect($.ajax).toHaveBeenCalled(),expect(n.model.stopWatchingUpdates).toHaveBeenCalled(),expect(n.model.watchUpdates).toHaveBeenCalled()})})}),suite("rb/reviewRequestPage/views/IssueSummaryTable",function(){const t=_.template(`<div>
 <div class="rb-c-review-request-field-tabular
             rb-c-issue-summary-table">
  <header class="rb-c-review-request-field-tabular__header">
   <div class="rb-c-review-request-field-tabular__filters">
    <select class="rb-c-issue-summary-table__reviewer-filter">
     <option value="all"></option>
    </select>
   </div>
   <ul class="rb-c-tabs">
    <li class="rb-c-tabs__tab -is-active" data-issue-state="open">
     <label class="rb-c-tabs__tab-label">
      <span id="open-counter"
            class="rb-c-issue-summary-table__counter">2</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="verifying">
     <label class="rb-c-tabs__tab-label">
      <span id="verifying-counter"
            class="rb-c-issue-summary-table__counter">3</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="resolved">
     <label class="rb-c-tabs__tab-label">
      <span id="resolved-counter"
            class="rb-c-issue-summary-table__counter">3</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="dropped">
     <label class="rb-c-tabs__tab-label">
      <span id="dropped-counter"
            class="rb-c-issue-summary-table__counter">1</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="all">
     <label class="rb-c-tabs__tab-label">
      <span id="total-counter"
            class="rb-c-issue-summary-table__counter">6</span>
     </label>
    </li>
   </ul>
  </header>
  <table class="rb-c-review-request-field-tabular__data">
   <thead>
    <tr>
     <th class="-is-sortable"></th>
     <th class="-is-sortable"></th>
     <th class="-is-sortable"></th>
    </tr>
   </thead>
   <tbody>
    <tr class="-is-resolved -is-hidden"
        data-issue-id="1"
        data-reviewer="user1"
        data-comment-type="diff"
        data-comment-href="#comment1">
     <td>
      <span class="rb-icon rb-icon-issue-resolved"></span>
      <p>Resolved comment 1</p>
     </td>
     <td>user1</td>
     <td>
      <time class="timesince" datetime="2017-02-01T20:30:00-07:00">
       February 1, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-resolved -is-hidden"
        data-issue-id="2"
        data-reviewer="user2"
        data-comment-type="diff"
        data-comment-href="#comment2">
     <td>
      <span class="rb-icon rb-icon-issue-resolved"></span>
      <p>Resolved comment 2</p>
     </td>
     <td>user2</td>
     <td>
      <time class="timesince" datetime="2017-02-02T20:30:00-07:00">
       February 2, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-resolved -is-hidden"
        data-issue-id="3"
        data-reviewer="user3"
        data-comment-type="diff"
        data-comment-href="#comment3">
     <td>
      <span class="rb-icon rb-icon-issue-resolved"></span>
      <p>Resolved comment 3</p>
     </td>
     <td>user3</td>
     <td>
      <time class="timesince" datetime="2017-02-03T20:30:00-07:00">
       February 3, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-open"
        data-issue-id="4"
        data-reviewer="user1"
        data-comment-type="diff"
        data-comment-href="#comment4">
     <td>
      <span class="rb-icon rb-icon-issue-open"></span>
      <p>Open comment 4</p>
     </td>
     <td>user1</td>
     <td>
      <time class="timesince" datetime="2017-02-01T20:30:00-07:00">
       February 1, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-open"
        data-issue-id="5"
        data-reviewer="user2"
        data-comment-type="diff"
        data-comment-href="#comment5">
     <td>
      <span class="rb-icon rb-icon-issue-open"></span>
      <p>Open comment 5</p>
     </td>
     <td>user2</td>
     <td>
      <time class="timesince" datetime="2017-02-02T20:30:00-07:00">
       February 2, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-dropped -is-hidden"
        data-issue-id="6"
        data-reviewer="user1"
        data-comment-type="diff"
        data-comment-href="#comment6">
     <td>
      <span class="rb-icon rb-icon-issue-dropped"></span>
      <p>Dropped comment 6</p>
     </td>
     <td>user1</td>
     <td>
      <time class="timesince" datetime="2017-02-01T20:30:00-07:00">
       February 1, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-verifying-dropped -is-hidden"
        data-issue-id="7"
        data-reviewer="user3"
        data-comment-type="diff"
        data-comment-href="#comment7">
     <td>
      <span class="rb-icon rb-icon-issue-dropped"></span>
      <p>Verifying comment 7</p>
     </td>
     <td>user3</td>
     <td>
      <time class="timesince" datetime="2017-02-03T18:30:00-07:00">
       February 3, 2017, 6:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-verifying-resolved -is-hidden"
        data-issue-id="8"
        data-reviewer="user2"
        data-comment-type="diff"
        data-comment-href="#comment8">
     <td>
      <span class="rb-icon rb-icon-issue-dropped"></span>
      <p>Verifying comment 8 - resolved</p>
     </td>
     <td>user2</td>
     <td>
      <time class="timesince" datetime="2017-02-04T20:30:00-07:00">
       February 4, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
   </tbody>
  </table>
 </div>
</div>`),i=".rb-c-tabs__tab",a=".rb-c-issue-summary-table__no-issues",s=`tbody tr:not(${a})`,n="th:nth-child(1)",o="th:nth-child(2)",c="th:nth-child(3)";let r;function l(e){return r.$(i+`[data-issue-state="${e}"]`)}beforeEach(function(){(r=new RB.ReviewRequestPage.IssueSummaryTableView({el:$(t()),model:new RB.CommentIssueManager})).$el.appendTo($testsScratch)}),describe("render",function(){it("Initial state",function(){r.render(),expect(r.statusFilterState).toBe("open"),expect(r.reviewerFilterState).toBe("all"),expect(r.reviewerToSelectorMap).toEqual({all:"",user1:'[data-reviewer="user1"]',user2:'[data-reviewer="user2"]',user3:'[data-reviewer="user3"]'});var e=r._$reviewerFilter.children();expect(e.length).toBe(4),expect(e.eq(0).val()).toBe("all"),expect(e.eq(1).val()).toBe("user1"),expect(e.eq(2).val()).toBe("user2"),expect(e.eq(3).val()).toBe("user3")}),it("With existing state",function(){r.render(),r.statusFilterState="dropped",r.reviewerFilterState="user1";var e=r.$el,e=(r.setElement($(t())),e.replaceWith(r.$el),r.render(),expect(r.statusFilterState).toBe("dropped"),expect(r.reviewerFilterState).toBe("user1"),expect(r.reviewerToSelectorMap).toEqual({all:"",user1:'[data-reviewer="user1"]',user2:'[data-reviewer="user2"]',user3:'[data-reviewer="user3"]'}),r.$(".rb-c-tabs__tab.-is-active")),e=(expect(e.length).toBe(1),expect(e.data("issue-state")).toBe("dropped"),expect(e[0]).toBe(r._$currentTab[0]),r.$(".rb-c-issue-summary-table__reviewer-filter")),e=(expect(e.length).toBe(1),expect(e[0]).toBe(r._$reviewerFilter[0]),expect(e.val()).toBe("user1"),r.$el.find(s).not(".-is-hidden")),e=(expect(e.length).toBe(1),e.eq(0));expect(e.hasClass("-is-dropped")).toBe(!0),expect(e.data("reviewer")).toBe("user1")})}),describe("Filters",function(){describe("Reviewer filter",function(){describe("To all",function(){it("With issues",function(){r.render(),r._$reviewerFilter.val("user1"),r._$reviewerFilter.trigger("change"),r._$reviewerFilter.val("all"),r._$reviewerFilter.trigger("change");var e=r.$el.find(s).not(".-is-hidden");expect(e.length).toBe(2),expect(e.eq(0).data("issue-id")).toBe(4),expect(e.eq(1).data("issue-id")).toBe(5)}),it("Without issues",function(){r.$el.find(s).remove(),r.render(),r._$reviewerFilter.val("user1"),r._$reviewerFilter.trigger("change"),r._$reviewerFilter.val("all"),r._$reviewerFilter.trigger("change"),expect(r.$el.find(s).not(".-is-hidden").length).toBe(0);var e=r.$(a);expect(e.length).toBe(1)})}),describe("To user",function(){it("With issues",function(){r.render(),r._$reviewerFilter.val("user1"),r._$reviewerFilter.trigger("change");var e=r.$el.find(s).not(".-is-hidden");expect(e.length).toBe(1),expect(e.eq(0).data("issue-id")).toBe(4)}),describe("Without issues",function(){function e(t){it(`And filtered by ${t} issues`,function(){r.$el.find(s+".-is-"+t+'[data-reviewer="user1"]').remove(),r.render(),r._$reviewerFilter.val("user1"),r._$reviewerFilter.trigger("change");l(t).click(),expect(r.$el.find(s).not(".-is-hidden").length).toBe(0);var e=r.$(a);expect(e.length).toBe(1),expect(e.text().trim()).toBe(`There are no ${t} issues from user1`)})}e("open"),e("resolved"),e("dropped")})})}),describe("Status filters",function(){function e(n){const o=n.state;describe(n.description,function(){it("With issues",function(){var t=n.expectedIDs,e=(r.render(),l(o)),e=(e.click(),expect(e.hasClass("-is-active")).toBe(!0),r.$el.find(s)),i=e.not(".-is-hidden");expect(r.$el.find(s+".-is-hidden").length).toBe(e.length-t.length),expect(i.length).toBe(t.length),expect(r.$(a).length).toBe(0);for(let e=0;e<t.length;e++)expect(i.eq(e).data("issue-id")).toBe(t[e])}),it("Without issues",function(){var e=r.stateToSelectorMap[o],e=(r.$el.find(s+e).remove(),r.render(),l(o)),e=(e.click(),expect(e.hasClass("-is-active")).toBe(!0),expect(r.$el.find(s).not(".-is-hidden").length).toBe(0),r.$(a));expect(e.length).toBe(1),expect(e.text().trim()).toBe(n.noIssuesText)})})}e({description:"All",state:"all",expectedIDs:[1,2,3,4,5,6,7,8],noIssuesText:""}),e({description:"Verifying",state:"verifying",expectedIDs:[7,8],noIssuesText:"There are no issues waiting for verification"}),e({description:"Open",state:"open",expectedIDs:[4,5],noIssuesText:"There are no open issues"}),e({description:"Resolved",state:"resolved",expectedIDs:[1,2,3],noIssuesText:"There are no resolved issues"}),e({description:"Dropped",state:"dropped",expectedIDs:[6],noIssuesText:"There are no dropped issues"})})}),describe("Events",function(){it('"No Issues" row clicked',function(){var e=jasmine.createSpy();r.$el.find(s).remove(),r.render(),r.on("issueClicked",e),r._$reviewerFilter.val("user1"),r._$reviewerFilter.trigger("change"),r.$(a).click(),expect(e).not.toHaveBeenCalled()}),it("Issue clicked",function(){var e=jasmine.createSpy();r.render(),r.on("issueClicked",e),r.commentIDToRowMap[4].click(),expect(e).toHaveBeenCalledWith({commentType:"diff",commentID:4,commentURL:"#comment4"})}),describe("Issue status updated",function(){const e=new Date(2017,7,6,1,4,30);let t,i,n;beforeEach(function(){n=new RB.DiffComment({id:4}),r.render(),expect(r.$("#resolved-counter").text()).toBe("3"),expect(r.$("#open-counter").text()).toBe("2"),expect(r.$("#dropped-counter").text()).toBe("1"),expect(r.$("#total-counter").text()).toBe("6"),t=r.commentIDToRowMap[4],i=t.find(".rb-icon")}),it("To dropped",function(){n.set("issueStatus","dropped"),r.model.trigger("issueStatusUpdated",n,"open",e),expect(r.$("#open-counter").text()).toBe("1"),expect(r.$("#dropped-counter").text()).toBe("2"),expect(r.$("#total-counter").text()).toBe("6"),expect(i.hasClass("rb-icon-issue-open")).toBe(!1),expect(i.hasClass("rb-icon-issue-dropped")).toBe(!0)}),it("To resolved",function(){n.set("issueStatus","resolved"),r.model.trigger("issueStatusUpdated",n,"open",e),expect(r.$("#resolved-counter").text()).toBe("4"),expect(r.$("#open-counter").text()).toBe("1"),expect(r.$("#total-counter").text()).toBe("6"),expect(i.hasClass("rb-icon-issue-open")).toBe(!1),expect(i.hasClass("rb-icon-issue-resolved")).toBe(!0)}),it("To open",function(){n.set({issueStatus:"open",id:1}),r.model.trigger("issueStatusUpdated",n,"resolved",e),t=r.commentIDToRowMap[1],i=t.find(".rb-icon"),expect(r.$("#resolved-counter").text()).toBe("2"),expect(r.$("#open-counter").text()).toBe("3"),expect(r.$("#total-counter").text()).toBe("6"),expect(i.hasClass("rb-icon-issue-resolved")).toBe(!1),expect(i.hasClass("rb-icon-issue-open")).toBe(!0)}),it("After re-renders",function(){r.render(),r.render(),n.set("issueStatus","resolved"),r.model.trigger("issueStatusUpdated",n,"open",e),expect(r.$("#resolved-counter").text()).toBe("4"),expect(r.$("#open-counter").text()).toBe("1"),expect(r.$("#total-counter").text()).toBe("6"),expect(i.hasClass("rb-icon-issue-open")).toBe(!1),expect(i.hasClass("rb-icon-issue-resolved")).toBe(!0)}),afterEach(function(){expect(t.find("td:nth-child(3) time").attr("datetime")).toBe(e.toISOString())})}),describe("Header clicked",function(){function e(o){it(o.description,function(){r.render();var e=$.Event("click"),t=(e.shiftKey=!!o.shiftKey,r.$(o.headerSel)),i=(console.assert(1===t.length),t.trigger(e),r.$(s)),n=(expect(i.length).toBe(8),[]);for(let e=0;e<i.length;e++)n.push(i.eq(e).data("issue-id"));expect(n).toEqual(o.expectedIDs)})}describe("Ascending",function(){e({description:"Description",headerSel:n,expectedIDs:[6,4,5,1,2,3,7,8]}),e({description:"From",headerSel:o,expectedIDs:[1,4,6,2,5,8,3,7]}),e({description:"Last Updated",headerSel:c,expectedIDs:[8,3,7,2,5,1,4,6]})}),describe("Descending",function(){e({description:"Description",headerSel:n,expectedIDs:[8,7,3,2,1,5,4,6],shiftKey:!0}),e({description:"From",headerSel:o,expectedIDs:[3,7,2,5,8,1,4,6],shiftKey:!0}),e({description:"Last Updated",headerSel:c,expectedIDs:[1,4,6,2,5,7,3,8],shiftKey:!0})})})})}),suite("rb/reviewRequestPage/views/ReviewEntryView",function(){let n,o,a;beforeEach(function(){var e=new RB.ReviewRequest,t=new RB.ReviewRequestEditor({reviewRequest:e}),i=e.createReview({loaded:!0,links:{replies:{href:"/api/review/123/replies/"}}}),e=new RB.ReviewRequestPage.ReviewEntry({review:i,reviewRequest:e,reviewRequestEditor:t}),t=$(`<div class="review review-request-page-entry">
 <div class="review-request-page-entry-contents">
  <div class="collapse-button"></div>
  <div class="banners">
   <input type="button" value="Publish">
   <input type="button" value="Discard">
  </div>
  <div class="comment-section" data-context-type="body_top">
   <a class="add_comment_link"></a>
   <ul class="reply-comments">
    <li class="draft" data-comment-id="456">
     <pre class="reviewtext"></pre>
    </li>
   </ul>
  </div>
  <div class="comment-section" data-context-id="123"
       data-context-type="diff_comments">
   <a class="add_comment_link"></a>
   <ul class="reply-comments"></ul>
  </div>
  <div class="comment-section" data-context-type="body_bottom">
   <a class="add_comment_link"></a>
   <ul class="reply-comments"></ul>
  </div>
 </div>
</div>`).appendTo($testsScratch);a=i.createReply(),(n=new RB.ReviewRequestPage.ReviewEntryView({el:t,model:e})).render(),o=n._reviewView,spyOn(o,"_showReplyDraftBanner"),spyOn(o,"trigger").and.callThrough(),o._setupNewReply(a)}),describe("Actions",function(){it("Toggle collapse",function(){var e=n.$(".review-request-page-entry-contents"),t=n.$(".collapse-button");t.click(),expect(e.hasClass("collapsed")).toBe(!0),t.click(),expect(e.hasClass("collapsed")).toBe(!1)})}),describe("Draft banner",function(){describe("Visibility",function(){it("Shown on hasDraft",function(){var e=o._replyEditorViews[1].model;o._showReplyDraftBanner.calls.reset(),expect(e.get("hasDraft")).toBe(!1),expect(o._showReplyDraftBanner).not.toHaveBeenCalled(),e.set("hasDraft",!0),expect(o._showReplyDraftBanner).toHaveBeenCalled()})})}),describe("Methods",function(){it("collapse",function(){n.collapse(),expect(n.$(".review-request-page-entry-contents").hasClass("collapsed")).toBe(!0)}),it("expand",function(){var e=n.$(".review-request-page-entry-contents").addClass("collapsed");n.expand(),expect(e.hasClass("collapsed")).toBe(!1)}),describe("getReviewReplyEditorView",function(){it("With body_top",function(){var e=n.getReviewReplyEditorView("body_top");expect(e).not.toBe(void 0),expect(e).toBe(o._replyEditorViews[0])}),it("With body_bottom",function(){var e=n.getReviewReplyEditorView("body_bottom");expect(e).not.toBe(void 0),expect(e).toBe(o._replyEditorViews[2])}),it("With comments",function(){var e=n.getReviewReplyEditorView("diff_comments",123);expect(e).not.toBe(void 0),expect(e).toBe(o._replyEditorViews[1])})})})}),suite("rb/reviewRequestPage/views/ReviewReplyDraftBannerView",function(){let t,i;beforeEach(function(){t=new RB.ReviewReply,(i=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:t,$floatContainer:$testsScratch,reviewRequestEditor:new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest})})).render().$el.appendTo($testsScratch)}),describe("Actions",function(){it("Discard",function(){spyOn(t,"destroy"),i.$(".discard-button").click(),expect(t.destroy).toHaveBeenCalled()}),it("Publish",function(){spyOn(t,"publish"),i.$(".publish-button").click(),expect(t.publish).toHaveBeenCalled()})}),describe("Event Handling",function(){describe("Buttons",function(){let e;beforeEach(function(){e=i.$("input")}),describe("Disabled",function(){it("When saving",function(){expect(e.prop("disabled")).toBe(!1),t.trigger("saving"),expect(e.prop("disabled")).toBe(!0)}),it("When destroying",function(){expect(e.prop("disabled")).toBe(!1),t.trigger("destroying"),expect(e.prop("disabled")).toBe(!0)})}),describe("Enabled",function(){it("When saved",function(){e.prop("disabled",!0),t.trigger("saved"),expect(e.prop("disabled")).toBe(!1)})})})}),describe("Publish",function(){beforeEach(function(){spyOn(t,"ensureCreated").and.resolveTo(),spyOn(t,"publish")}),describe("With Send E-Mail shown",function(){beforeEach(function(){i.remove(),(i=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:t,$floatContainer:$testsScratch,reviewRequestEditor:new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest,showSendEmail:!0})})).render().$el.appendTo($testsScratch)}),it("Send E-Mail true",function(){$(".send-email").prop("checked",!0),$(".publish-button").click(),expect(t.publish).toHaveBeenCalled(),expect(t.publish.calls.argsFor(0)[0].trivial).toBe(!1)}),it("Send E-Mail false",function(){$(".send-email").prop("checked",!1),$(".publish-button").click(),expect(t.publish).toHaveBeenCalled(),expect(t.publish.calls.argsFor(0)[0].trivial).toBe(!0)})}),it("Without Send E-Mail shown",function(){$(".publish-button").click(),expect($(".send-email").length).toEqual(0),expect(t.publish).toHaveBeenCalled(),expect(t.publish.calls.argsFor(0)[0].trivial).toBe(!1)})})}),suite("rb/reviewRequestPage/views/ReviewReplyEditorView",function(){let i,n,o;beforeEach(function(){var e=$("<div>").appendTo($testsScratch);i=new RB.ReviewReply({id:121}),spyOn(i,"discardIfEmpty").and.resolveTo(!0),n=new RB.ReviewRequestPage.ReviewReplyEditor({anchorPrefix:"header-reply",replyObject:i,review:new RB.Review({id:42,parentObject:new RB.ReviewRequest}),reviewReply:i,contextType:"rcbt",contextID:"100"}),(o=new RB.ReviewRequestPage.ReviewReplyEditorView({model:n,el:$testsScratch}))._$commentsList=$('<ul class="reply-comments">'),e.append(o._$commentsList).append($('<a href="#" class="add_comment_link">New Comment</a>'))}),describe("Construction",function(){it("Populate from draft comment",function(){var e="Test comment",t=moment(),i=o._makeCommentElement({commentID:16,now:t,text:e});o.render(),expect(n.get("commentID")).toBe(16),expect(n.get("text")).toBe(e),expect(n.get("hasDraft")).toBe(!0),expect(n.get("timestamp").valueOf()).toBe(t.milliseconds(0).valueOf()),expect(o._$draftComment[0]).toBe(i[0]),expect(o._$addCommentLink.is(":visible")).toBe(!1)})}),describe("Actions",function(){it("Add comment link",function(){o.render(),expect(o._$addCommentLink.is(":visible")).toBe(!0),o._$addCommentLink.click(),expect(o._$addCommentLink.is(":visible")).toBe(!1),expect(o._$draftComment).not.toBe(null),expect(o._$draftComment.hasClass("draft")).toBe(!0)})}),describe("Event handling",function(){it("Comment discarded",function(e){o._makeCommentElement({text:"Test comment"}),o.render();let t=o.$(".reply-comments li");expect(t.length).toBe(1),n.on("discarded-finished",()=>{t=o.$(".reply-comments li"),expect(t.length).toBe(0),expect(o._$draftComment).toBe(null),e()}),i.trigger("destroyed")}),it("Comment published",function(){var e=o._makeCommentElement({commentID:16}),t=(spyOn($.fn,"user_infobox").and.callThrough(),spyOn($.fn,"timesince").and.callThrough(),o.render(),n.set("text","Test **comment**"),i.trigger("published"),o.$(".reply-comments li")),e=(expect(t.length).toBe(1),expect(e).not.toBe(t),expect(t.hasClass("draft")).toBe(!1),expect(t.data("comment-id")).toBe(16),expect(o._$draftComment).toBe(null),expect($.fn.user_infobox).toHaveBeenCalled(),expect($.fn.timesince).toHaveBeenCalled(),t.children(".comment-anchor")),e=(expect(e.length).toBe(1),expect(e.attr("name")).toBe("header-reply121"),t.find("> .floating-anchor > a"));expect(e.length).toBe(1),expect(e.attr("href")).toBe("#header-reply121"),expect(e.hasClass("fa fa-link fa-flip-horizontal")).toBe(!0)})}),describe("Methods",function(){it("openCommentEditor",function(){o.render(),expect(o._$addCommentLink.is(":visible")).toBe(!0),expect(o._$draftComment).toBe(null),o.openCommentEditor(),expect(o._$addCommentLink.is(":visible")).toBe(!1),expect(o._$draftComment).not.toBe(null),expect(o._$draftComment.hasClass("draft")).toBe(!0)})}),describe("Text rendering",function(){function e(e,t){o.render();var i=o._makeCommentElement({text:"<p><strong>Test</strong> &amp;lt;</p>",richText:e}).find(".reviewtext");expect(i.length).toBe(1),expect(i.hasClass("rich-text")).toBe(e),expect(i.html()).toBe(t)}it("richText=true",function(){e(!0,"<p><strong>Test</strong> &amp;lt;</p>")}),it("richText=false",function(){e(!1,"&lt;p&gt;&lt;strong&gt;Test&lt;/strong&gt; &amp;amp;lt;&lt;/p&gt;")})})}),suite("rb/reviewRequestPage/views/ReviewRequestPageView",function(){let i,n,o,a;beforeEach(function(){var e=$("<div>").html(`<div id="review-banner"></div>
<div id="unified-banner">
 <div class="rb-c-unified-banner__mode-selector"></div>
</div>
<a id="collapse-all"></a>
<a id="expand-all"></a>
<div>
 <div class="review review-request-page-entry" id="review123">
  <div class="review-request-page-entry-contents">
   <div class="body">
    <pre class="body_top">Body Top</pre>
    <div class="comment-section" data-context-type="body_top">
    </div>
    <div class="comment-section" data-context-id="123"
         data-context-type="diff_comments">
    </div>
    <pre class="body_bottom">Body Bottom</pre>
    <div class="comment-section" data-context-type="body_bottom">
    </div>
   </div>
 </div>
 <div class="review review-request-page-entry" id="review124">
  <div class="review-request-page-entry-contents">
   <div class="body">
    <pre class="body_top">Body Top</pre>
    <div class="comment-section" data-context-type="body_top">
    </div>
    <pre class="body_bottom">Body Bottom</pre>
    <div class="comment-section" data-context-type="body_bottom">
    </div>
   </div>
  </div>
 </div>
</div>`).appendTo($testsScratch),t=(RB.DnDUploader.instance=null,spyOn(RB.HeaderView.prototype,"_ensureSingleton"),i=new RB.ReviewRequestPage.ReviewRequestPage({checkForUpdates:!1,reviewRequestData:{},editorData:{fileAttachments:[],mutableByUser:!0,showSendEmail:!1}},{parse:!0}),n=new RB.ReviewRequestPage.ReviewRequestPageView({el:e,model:i}),spyOn(RB.ReviewRequestPage.IssueSummaryTableView.prototype,"render"),i.get("reviewRequest"));n.addEntryView(new RB.ReviewRequestPage.ReviewEntryView({model:new RB.ReviewRequestPage.ReviewEntry({review:t.createReview(123,{shipIt:!0,public:!0,bodyTop:"Body Top",bodyBottom:"Body Bottom"}),reviewRequestEditor:n.reviewRequestEditor}),el:e.find("#review123")})),n.addEntryView(new RB.ReviewRequestPage.ReviewEntryView({model:new RB.ReviewRequestPage.ReviewEntry({review:t.createReview(124,{shipIt:!1,public:!0,bodyTop:"Body Top",bodyBottom:"Body Bottom"}),reviewRequestEditor:n.reviewRequestEditor}),el:e.find("#review124")})),spyOn(t,"ready").and.resolveTo(),spyOn(t.draft,"ready").and.resolveTo(),spyOn(i.get("pendingReview"),"ready").and.resolveTo(),n.render(),expect(n._entryViews.length).toBe(2),o=n._entryViews[0],a=n._entryViews[1]}),afterEach(function(){RB.DnDUploader.instance=null,RB.EnabledFeatures.unifiedBanner&&RB.UnifiedBannerView.resetInstance()}),describe("Actions",function(){it("Collapse all",function(){var e=o.$el.find(".review-request-page-entry-contents"),t=a.$el.find(".review-request-page-entry-contents");expect(e.hasClass("collapsed")).toBe(!1),expect(t.hasClass("collapsed")).toBe(!1),n.$("#collapse-all").click(),expect(e.hasClass("collapsed")).toBe(!0),expect(t.hasClass("collapsed")).toBe(!0)}),it("Expand all",function(){var e=o.$el.find(".review-request-page-entry-contents"),t=a.$el.find(".review-request-page-entry-contents");e.addClass("collapsed"),t.addClass("collapsed"),n.$("#expand-all").click(),expect(e.hasClass("collapsed")).toBe(!1),expect(t.hasClass("collapsed")).toBe(!1)})}),describe("Methods",function(){describe("openCommentEditor",function(){beforeEach(function(){spyOn(RB.ReviewRequestPage.ReviewReplyEditorView.prototype,"openCommentEditor"),spyOn(o,"getReviewReplyEditorView").and.callThrough(),spyOn(a,"getReviewReplyEditorView").and.callThrough()}),it("With body_top",function(){n.openCommentEditor("body_top"),expect(o.getReviewReplyEditorView).toHaveBeenCalled(),expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled(),expect(a.getReviewReplyEditorView).not.toHaveBeenCalled()}),it("With body_bottom",function(){n.openCommentEditor("body_bottom"),expect(o.getReviewReplyEditorView).toHaveBeenCalled(),expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled(),expect(a.getReviewReplyEditorView).not.toHaveBeenCalled()}),it("With comments",function(){n.openCommentEditor("diff_comments",123),expect(o.getReviewReplyEditorView).toHaveBeenCalled(),expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled(),expect(a.getReviewReplyEditorView).not.toHaveBeenCalled()})})})}),suite("rb/reviewRequestPage/views/ReviewView",function(){const n=_.template(`<div class="review review-request-page-entry">
 <div class="review-request-page-entry-contents">
  <div class="collapse-button"></div>
  <div class="banners">
   <input type="button" value="Publish">
   <input type="button" value="Discard">
  </div>
  <div class="body">
   <ol class="review-comments">
    <li>
     <div class="review-comment-details">
      <div class="review-comment">
       <pre class="reviewtext body_top"></pre>
      </div>
     </div>
     <div class="review-comment-thread">
      <div class="comment-section"
           data-context-type="body_top"
           data-reply-anchor-prefix="header-reply">
       <a class="add_comment_link"></a>
       <ul class="reply-comments">
        <li class="draft" data-comment-id="456">
         <pre class="reviewtext"></pre>
        </li>
       </ul>
      </div>
     </div>
    </li>
    <li>
     <div class="review-comment-thread">
      <div class="comment-section" data-context-id="123"
           data-context-type="diff_comments"
           data-reply-anchor-prefix="comment">
       <a class="add_comment_link"></a>
       <ul class="reply-comments"></ul>
      </div>
     </div>
    </li>
    <li>
     <div class="review-comment-details">
      <div class="review-comment">
       <pre class="reviewtext body_bottom"></pre>
      </div>
     </div>
     <div class="review-comment-thread">
      <div class="comment-section"
           data-context-type="body_bottom"
           data-reply-anchor-prefix="footer-reply">
       <a class="add_comment_link"></a>
       <ul class="reply-comments"></ul>
      </div>
     </div>
    </div>
   </li>
  </ol>
 </div>
</div>`);let o,a,s;beforeEach(function(){var e=new RB.ReviewRequest,t=new RB.ReviewRequestEditor({reviewRequest:e}),i=(a=e.createReview({loaded:!0,links:{replies:{href:"/api/review/123/replies/"}}}),$(n()).appendTo($testsScratch));s=a.createReply(),(o=new RB.ReviewRequestPage.ReviewView({el:i,model:a,entryModel:new RB.ReviewRequestPage.ReviewEntry({review:a,reviewRequest:e,reviewRequestEditor:t})}))._setupNewReply(s),spyOn(o,"trigger").and.callThrough(),o.render()}),describe("Model events",function(){it("bodyTop changed",function(){a.set({bodyTop:"new **body** top",htmlTextFields:{bodyTop:"<p>new <strong>body</strong> top</p>"}}),expect(o._$bodyTop.html()).toBe("<p>new <strong>body</strong> top</p>")}),it("bodyBottom changed",function(){a.set({bodyBottom:"new **body** bottom",htmlTextFields:{bodyBottom:"<p>new <strong>body</strong> bottom</p>"}}),expect(o._$bodyBottom.html()).toBe("<p>new <strong>body</strong> bottom</p>")}),describe("bodyTopRichText changed",function(){it("To true",function(){expect(o._$bodyTop.hasClass("rich-text")).toBe(!1),a.set("bodyTopRichText",!0),expect(o._$bodyTop.hasClass("rich-text")).toBe(!0)}),it("To false",function(){a.attributes.bodyTopRichText=!0,o._$bodyTop.addClass("rich-text"),a.set("bodyTopRichText",!1),expect(o._$bodyTop.hasClass("rich-text")).toBe(!1)})}),describe("bodyBottomRichText changed",function(){it("To true",function(){expect(o._$bodyBottom.hasClass("rich-text")).toBe(!1),a.set("bodyBottomRichText",!0),expect(o._$bodyBottom.hasClass("rich-text")).toBe(!0)}),it("To false",function(){a.attributes.bodyBottomRichText=!0,o._$bodyBottom.addClass("rich-text"),a.set("bodyBottomRichText",!1),expect(o._$bodyBottom.hasClass("rich-text")).toBe(!1)})})}),describe("Reply editors",function(){it("Views created",function(){expect(o._replyEditorViews.length).toBe(3)}),it("Initial state populated",function(){let e=o._replyEditorViews[0].model;expect(e.get("anchorPrefix")).toBe("header-reply"),expect(e.get("contextID")).toBe(null),expect(e.get("contextType")).toBe("body_top"),expect(e.get("hasDraft")).toBe(!0),e=o._replyEditorViews[1].model,expect(e.get("anchorPrefix")).toBe("comment"),expect(e.get("contextID")).toBe(123),expect(e.get("contextType")).toBe("diff_comments"),expect(e.get("hasDraft")).toBe(!1),e=o._replyEditorViews[2].model,expect(e.get("anchorPrefix")).toBe("footer-reply"),expect(e.get("contextID")).toBe(null),expect(e.get("contextType")).toBe("body_bottom"),expect(e.get("hasDraft")).toBe(!1),expect(o._replyDraftsCount).toBe(1)}),it("Draft banner when draft comment exists",function(){expect(o.trigger).toHaveBeenCalledWith("hasDraftChanged",!0)}),describe("reviewReply changes on",function(){it("Discard",function(){spyOn(o,"_setupNewReply"),spyOn(s,"discardIfEmpty").and.resolveTo(!0),s.trigger("destroyed"),expect(o._setupNewReply).toHaveBeenCalled()})}),describe("When draft deleted",function(){describe("With last one",function(){it("Draft banner hidden",function(){var e=o._replyEditors[0];expect(e.get("hasDraft")).toBe(!0),expect(o._replyDraftsCount).toBe(1),expect(o._draftBannerShown).toBe(!0),e.set("hasDraft",!1),expect(o._replyDraftsCount).toBe(0),expect(o._draftBannerShown).toBe(!1)})}),describe("With more remaining",function(){it("Draft banner stays visible",function(){o._replyEditors[1].set("hasDraft",!0);var e=o._replyEditors[0];expect(e.get("hasDraft")).toBe(!0),expect(o._replyDraftsCount).toBe(2),expect(o._draftBannerShown).toBe(!0),e.set("hasDraft",!1),expect(o._replyDraftsCount).toBe(1),expect(o._draftBannerShown).toBe(!0)})})}),describe("When reviewReply changes",function(){it("Signals connected",function(){spyOn(o,"listenTo").and.callThrough(),o._setupNewReply(new RB.ReviewReply),expect(o.listenTo.calls.argsFor(0)[1]).toBe("destroyed published")}),it("Signals disconnected from old reviewReply",function(){spyOn(o,"stopListening").and.callThrough(),o._setupNewReply(),expect(o.stopListening).toHaveBeenCalledWith(s)}),it("Hide draft banner signal emitted",function(){o._setupNewReply(),expect(o.trigger).toHaveBeenCalledWith("hasDraftChanged",!1)}),it("Editors updated",function(){o._setupNewReply(),o._replyEditors.forEach(e=>expect(e.get("reviewReply")).toBe(o._reviewReply))})})})}),suite("rb/ui/views/DialogView",function(){describe("Buttons",function(){describe("Settings",function(){it("Default",function(){var e=new RB.DialogView({buttons:[{label:"Test",id:"testid"}]}),e=(e._makeButtons(),e.$buttonsMap),t=e.testid;expect(Object.keys(e).length).toBe(1),expect(t.text()).toBe("Test"),expect(t.prop("id")).toBe("testid"),expect(t.prop("disabled")).toBe(!1),expect(t.hasClass("-is-primary")).toBe(!1),expect(t.hasClass("-is-danger")).toBe(!1)}),it("Primary",function(){var e=new RB.DialogView({buttons:[{label:"Test",id:"testid",primary:!0}]}),e=(e._makeButtons(),e.$buttonsMap),t=e.testid;expect(Object.keys(e).length).toBe(1),expect(t.text()).toBe("Test"),expect(t.prop("id")).toBe("testid"),expect(t.prop("disabled")).toBe(!1),expect(t.hasClass("-is-primary")).toBe(!0),expect(t.hasClass("-is-danger")).toBe(!1)}),it("Disabled",function(){var e=new RB.DialogView({buttons:[{label:"Test",id:"testid",disabled:!0}]}),e=(e._makeButtons(),e.$buttonsMap),t=e.testid;expect(Object.keys(e).length).toBe(1),expect(t.text()).toBe("Test"),expect(t.prop("id")).toBe("testid"),expect(t.prop("disabled")).toBe(!0),expect(t.hasClass("-is-primary")).toBe(!1),expect(t.hasClass("-is-danger")).toBe(!1)}),it("Danger",function(){var e=new RB.DialogView({buttons:[{label:"Test",id:"testid",danger:!0}]}),e=(e._makeButtons(),e.$buttonsMap),t=e.testid;expect(Object.keys(e).length).toBe(1),expect(t.text()).toBe("Test"),expect(t.prop("id")).toBe("testid"),expect(t.prop("disabled")).toBe(!1),expect(t.hasClass("-is-primary")).toBe(!1),expect(t.hasClass("-is-danger")).toBe(!0)})}),describe("Events",function(){describe("Click",function(){it("When function",function(){var e=jasmine.createSpy("cb"),t=new RB.DialogView({buttons:[{label:"Test",id:"testid",onClick:e}]}),t=(t._makeButtons(),t.$buttonsMap),i=t.testid;expect(Object.keys(t).length).toBe(1),expect(i.text()).toBe("Test"),i.click(),expect(e).toHaveBeenCalled()}),it("When string on subclass",function(){var e=new(RB.DialogView.extend({buttons:[{label:"Test",id:"testid",onClick:"_onClicked"}],_onClicked:jasmine.createSpy("cb")})),t=(e._makeButtons(),e.$buttonsMap),i=t.testid;expect(Object.keys(t).length).toBe(1),expect(i.text()).toBe("Test"),i.click(),expect(e._onClicked).toHaveBeenCalled()}),describe("Keydown",function(){it("Esc key",function(){var e=new RB.DialogView({buttons:[{id:"testid",label:"Test"}]}),t=(e.show(),jasmine.createSpy("hide")),i=(e.hide=t,e.$buttonsMap);expect(Object.keys(i).length).toBe(1),expect(i.testid.text()).toBe("Test"),e.$el.trigger($.Event("keydown",{which:$.ui.keyCode.ESCAPE})),expect(t).toHaveBeenCalled(),e.remove()})}),describe("Submit",function(){it("with primary button enabled",function(){var e=jasmine.createSpy("cb"),t=new RB.DialogView({buttons:[{id:"testid",label:"Test",onClick:e,disabled:!1,primary:!0}],body:_.template(`<form>
 <input value="test">
</form>`)}),i=(t.show(),t.$buttonsMap),n=i.testid,o=t.$el.find("form");expect(Object.keys(i).length).toBe(1),expect(n.text()).toBe("Test"),expect(n.prop("disabled")).toBe(!1),expect(n.hasClass("-is-primary")).toBe(!0),o.trigger($.Event("submit")),expect(e).toHaveBeenCalled(),t.remove()}),it("with primary button disabled",function(){var e=jasmine.createSpy("cb"),t=new RB.DialogView({buttons:[{id:"testid",label:"Test",onClick:e,disabled:!0,primary:!0}],body:_.template(`<form>
 <input value="test">
</form>`)}),i=(t.show(),t.$buttonsMap),n=i.testid,o=t.$el.find("form");expect(Object.keys(i).length).toBe(1),expect(n.text()).toBe("Test"),expect(n.prop("disabled")).toBe(!0),expect(n.hasClass("-is-primary")).toBe(!0),o.trigger($.Event("submit")),expect(e).not.toHaveBeenCalled(),t.remove()}),it("with explicit action",function(){var e=jasmine.createSpy("cb1"),t=jasmine.createSpy("cb2").and.returnValue(!1),i=new RB.DialogView({buttons:[{id:"testid",label:"Test",onClick:e,disabled:!1,primary:!0}],body:_.template(`<form action=".">
 <input value="test">
</form>`)}),n=(i.show(),i.$buttonsMap),o=n.testid,a=i.$el.find("form");a.submit(t),expect(Object.keys(n).length).toBe(1),expect(o.text()).toBe("Test"),expect(o.prop("disabled")).toBe(!1),expect(o.hasClass("-is-primary")).toBe(!0),a.trigger($.Event("submit")),expect(e).not.toHaveBeenCalled(),expect(t).toHaveBeenCalled(),i.remove()})})})})})}),suite("rb/ui/views/DrawerView",function(){let t,i;beforeEach(function(){t=$(document.body),(i=new RB.DrawerView).render()}),afterEach(function(){t.removeClass("js-rb-c-drawer-is-shown")}),describe("Operations",function(){it("show",function(){var e=jasmine.createSpy("onVisibilityChanged");i.on("visibilityChanged",e),i.show(),expect(i.isVisible).toBe(!0),expect(t.hasClass("js-rb-c-drawer-is-shown")).toBe(!0),expect(e).toHaveBeenCalledWith(!0)}),it("hide",function(){var e=jasmine.createSpy("onVisibilityChanged");t.addClass("js-rb-c-drawer-is-shown"),i.on("visibilityChanged",e),i.hide(),expect(i.isVisible).toBe(!1),expect(t.hasClass("js-rb-c-drawer-is-shown")).toBe(!1),expect(e).toHaveBeenCalledWith(!1)})})}),suite("rb/ui/views/FormView",function(){let t,i;function e(e,t){e=i.eq(e);expect(e.prop("disabled")).toBe(!t),expect(e.prop("hidden")).toBe(!t)}beforeEach(function(){(t=new RB.FormView({el:$(`<form class="rb-c-form">
 <select id="subform1-selector"
         data-subform-group="group1">
  <option value="subform1">subform1</option>
  <option value="subform2">subform2</option>
 </select>

 <fieldset class="rb-c-form-fieldset">
  <legend class="rb-c-form-fieldset__name">
   Title
   <a href="#" class="rb-c-form-fieldset__toggle">(Hide)</a>
  </legend>
  <div class="rb-c-form-fieldset__content"></div>
 </fieldset>
 <fieldset class="rb-c-form-fieldset -is-collapsed">
  <legend class="rb-c-form-fieldset__name">
   Title
   <a href="#" class="rb-c-form-fieldset__toggle">(Show)</a>
  </legend>
  <div class="rb-c-form-fieldset__content"></div>
 </fieldset>

 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-controller="subform1-selector"
           data-subform-id="subform1">
 </fieldset>
 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-controller="subform1-selector"
           data-subform-id="subform2">
 </fieldset>

 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-group="group2"
           data-subform-id="subform3">
 </fieldset>
 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-group="group2"
           data-subform-id="subform4"
           disabled hidden>
 </fieldset>
</form>`)})).render().$el.appendTo($testsScratch),i=t._$subforms}),describe("Fieldsets",function(){it("Collapsing",function(){var e=t.$(".rb-c-form-fieldset").eq(0);expect(e.hasClass("-is-collapsed")).toBe(!1),e.find(".rb-c-form-fieldset__toggle").click(),expect(e.hasClass("-is-collapsed")).toBe(!0),expect(e.find(".rb-c-form-fieldset__toggle").text()).toBe("(Show)")}),it("Expanding",function(){var e=t.$(".rb-c-form-fieldset").eq(1);expect(e.hasClass("-is-collapsed")).toBe(!0),e.find(".rb-c-form-fieldset__toggle").click(),expect(e.hasClass("-is-collapsed")).toBe(!1),expect(e.find(".rb-c-form-fieldset__toggle").text()).toBe("(Hide)")})}),describe("Subforms",function(){it("Loaded state",function(){expect(i.length).toBe(4),expect(_.keys(t._subformsByGroup)).toEqual(["group1","group2"]),expect(_.keys(t._subformsByGroup.group1)).toEqual(["subform1","subform2"]),expect(_.keys(t._subformsByGroup.group2)).toEqual(["subform3","subform4"]),expect(t._subformsByGroup.group1.subform1[0]).toBe(i[0]),expect(t._subformsByGroup.group1.subform2[0]).toBe(i[1]),expect(t._subformsByGroup.group2.subform3[0]).toBe(i[2]),expect(t._subformsByGroup.group2.subform4[0]).toBe(i[3]),e(0,!0),e(1,!1),e(2,!0),e(3,!1)}),it("Controller value changed",function(){t.$el.children("select").val("subform2").triggerHandler("change"),e(0,!1),e(1,!0),e(2,!0),e(3,!1)})}),describe("Methods",function(){describe("setSubformVisibility",function(){it("With group",function(){t.setSubformVisibility({group:"group2"}),e(2,!1),e(3,!1)}),it("With group, visible",function(){t.setSubformVisibility({group:"group2",visible:!0}),e(2,!0),e(3,!0),t.setSubformVisibility({group:"group2",visible:!1}),e(2,!1),e(3,!1)}),it("With group, subformID, visible",function(){e(2,!0),t.setSubformVisibility({group:"group2",subformID:"subform3",visible:!1}),e(2,!1),e(3,!1),t.setSubformVisibility({group:"group2",subformID:"subform4",visible:!0}),e(3,!0)}),it("With group, subformID, visible, hideOthers",function(){t.setSubformVisibility({group:"group1",subformID:"subform2",visible:!0,hideOthers:!0}),e(0,!1),e(1,!0),t.setSubformVisibility({group:"group1",subformID:"subform1",visible:!0,hideOthers:!0}),e(0,!0),e(1,!1)})})})}),suite("rb/ui/views/InfoboxManagerView",function(){const n=RB.BaseInfoboxView.extend({infoboxID:"dummy-infobox"});let o;beforeEach(function(){o=RB.InfoboxManagerView.getInstance(),spyOn(o,"_fetchInfoboxContents").and.callFake((e,t)=>{expect(e).toBe("/foo/infobox/"),t("<strong>Hi!</strong>")})}),afterEach(function(){o.remove(),RB.InfoboxManagerView._instance=null}),describe("addTargets",function(){let e,t,i;beforeEach(function(){e=$("<div>"),t=$("<div>"),i=$([e[0],t[0]])}),it("Registers new targets",function(){o.addTargets(n,i),expect(e.data("has-infobox")).toBe(!0),expect(t.data("has-infobox")).toBe(!0)}),it("Registers event handlers",function(){spyOn(o,"_onTargetMouseEnter"),spyOn(o,"_onMouseLeave"),o.addTargets(n,i),e.triggerHandler("mouseenter"),expect(o._onTargetMouseEnter).toHaveBeenCalled(),e.triggerHandler("mouseleave"),expect(o._onMouseLeave).toHaveBeenCalled()}),it("Skips already-registered targets",function(){spyOn(o,"_onTargetMouseEnter"),o.addTargets(n,i),o.addTargets(n,i),e.triggerHandler("mouseenter"),expect(o._onTargetMouseEnter.calls.count()).toBe(1)})}),describe("getOrCreateInfobox",function(){it("Caches infobox views",function(){var e=o.getOrCreateInfobox(n),t=o.getOrCreateInfobox(n);expect(e.cid).toBe(t.cid)}),it("Starts infobox hidden",function(){var e=o.getOrCreateInfobox(n);expect(e.$el.is(":visible")).toBe(!1)}),it("Registers events",function(){spyOn(o,"_onInfoboxMouseEnter"),spyOn(o,"_onMouseLeave");var e=o.getOrCreateInfobox(n);e.$el.triggerHandler("mouseenter"),expect(o._onInfoboxMouseEnter).toHaveBeenCalled(),e.$el.triggerHandler("mouseleave"),expect(o._onMouseLeave).toHaveBeenCalled()})}),describe("setPositioning",function(){it("Overrides default position",function(){o.setPositioning(n,{side:"b",foo:"bar"});var e=o.getOrCreateInfobox(n);expect(e.positioning).toEqual({side:"b",foo:"bar"})})}),describe("Target Events",function(){let t;beforeEach(function(){spyOn(window,"setTimeout").and.callFake(e=>e()),t=$('<a href="/foo/">'),o.addTargets(n,t)}),describe("mouseenter",function(){it("First time for target",function(){t.triggerHandler("mouseenter");var e=o.getOrCreateInfobox(n);expect(e.$el.html()).toBe("<strong>Hi!</strong>"),expect(e.$el.is(":visible")).toBe(!0)}),it("Subsequent time for target (cached data)",function(){var e=o.getOrCreateInfobox(n);spyOn(e,"setContents").and.callThrough(),spyOn(o,"_showInfobox").and.callThrough(),o._cache["/foo/infobox/"]="Old HTML",t.triggerHandler("mouseenter"),expect(e.$el.html()).toBe("<strong>Hi!</strong>"),expect(e.$el.is(":visible")).toBe(!0),expect(o._showInfobox.calls.count()).toBe(1),expect(e.setContents.calls.count()).toBe(2)})}),describe("mouseleave",function(){beforeEach(function(){t.triggerHandler("mouseenter")}),it("Cancels showing infobox",function(){o._showTimeout=123,t.triggerHandler("mouseleave"),expect(o._showTimeout).toBe(null)}),it("Hides infobox",function(){var e=o.getOrCreateInfobox(n);o._showTimeout=123,expect(e.$el.is(":visible")).toBe(!0),expect(o._activeInfoboxView).not.toBe(null),t.triggerHandler("mouseleave"),expect(e.$el.is(":visible")).toBe(!1),expect(o._activeInfoboxView).toBe(null),expect(o._showTimeout).toBe(null)})})}),describe("Infobox Events",function(){let t;beforeEach(function(){spyOn(window,"setTimeout").and.callFake(e=>e()),t=$('<a href="/foo/">'),o.addTargets(n,t)}),describe("mouseenter",function(){it("Preserves infobox after leaving target",function(){var e=o.getOrCreateInfobox(n);t.triggerHandler("mouseenter"),expect(o._activeInfoboxView).toBe(e),window.setTimeout.and.callThrough(),t.triggerHandler("mouseleave"),expect(o._hideTimeout).not.toBe(null),expect(o._showTimeout).toBe(null),e.$el.triggerHandler("mouseenter"),expect(e.$el.is(":visible")).toBe(!0),expect(o._showTimeout).toBe(null),expect(o._hideTimeout).toBe(null)})}),describe("mouseleave",function(){it("Hides infobox",function(){var e=o.getOrCreateInfobox(n);o._showInfobox(e,t),expect(e.$el.is(":visible")).toBe(!0),expect(o._activeInfoboxView).toBe(e),e.$el.triggerHandler("mouseleave"),expect(e.$el.is(":visible")).toBe(!1),expect(o._activeInfoboxView).toBe(null),expect(o._showTimeout).toBe(null)})})})}),suite("rb/ui/views/MenuButtonView",function(){describe("Rendering",function(){it("With primary button",function(){var e=new RB.MenuButtonView({ariaMenuLabel:"Test ARIA label",menuItems:[{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],onPrimaryButtonClick:()=>{},text:"Button label"}),t=(e.render(),expect(e.el).toHaveClass("rb-c-menu-button"),expect(e.$el.attr("role")).toBe("group"),expect(e.$primaryButton.length).toBe(1),e.$(".rb-c-menu-button__primary")),t=(expect(t.length).toBe(1),e.$(".rb-c-menu-button__toggle"));expect(t.length).toBe(1),expect(t[0].id).toBe(e.menu.$el.attr("aria-labelledby")),expect(t.attr("aria-label")).toBe("Test ARIA label"),expect(t.children()[0]).toHaveClass("rb-icon-dropdown-arrow"),expect(e.menu.el.children.length).toBe(3)}),it("Without primary button",function(){var e=new RB.MenuButtonView({ariaMenuLabel:"Test ARIA label",menuItems:[{text:"Item 1"},{text:"Item 2"}],text:"Button label"}),t=(e.render(),expect(e.el).toHaveClass("rb-c-menu-button"),expect(e.$el.attr("role")).toBe("group"),expect(e.$primaryButton).toBeNull(),e.$(".rb-c-menu-button__primary")),t=(expect(t.length).toBe(0),e.$(".rb-c-menu-button__toggle"));expect(t.length).toBe(1),expect(t[0].id).toBe(e.menu.$el.attr("aria-labelledby")),expect(t.attr("aria-label")).toBeUndefined(),expect(t.text().trim()).toBe("Button label"),expect(t.children()[0]).toHaveClass("rb-icon-dropdown-arrow"),expect(e.menu.el.children.length).toBe(2)})}),describe("Events",function(){let i;function t(e,t){e=$.Event(e,t);return i.$(".rb-c-menu-button__toggle").trigger(e),e}function n(e){t("keydown",{key:e})}beforeEach(function(){(i=new RB.MenuButtonView({text:"Text"})).render(),spyOn(i,"updateMenuPosition")}),describe("keydown",function(){function e(e){it("With openDirection=up",function(){i.openDirection="up",spyOn(i.menu,"focusLastItem"),n(e),expect(i.menu.isOpen).toBeTrue(),expect(i.menu.focusLastItem).toHaveBeenCalled()}),it("With openDirection=down",function(){i.openDirection="down",spyOn(i.menu,"focusFirstItem"),n(e),expect(i.menu.isOpen).toBeTrue(),expect(i.menu.focusFirstItem).toHaveBeenCalled()})}describe("Return key opens menu",function(){e("Enter")}),describe("Space key opens menu",function(){e(" ")}),describe("Down key opens menu",function(){e("ArrowDown")}),describe("Up key opens menu",function(){e("ArrowUp")}),it("Escape key closes menu",function(){i.menu.open({animate:!1}),expect(i.menu.isOpen).toBeTrue(),n("Escape"),expect(i.menu.isOpen).toBeFalse()})}),it("focusout closes menu",function(){i.menu.open({animate:!1}),expect(i.menu.isOpen).toBeTrue(),t("focusout",{relatedTarget:$testsScratch[0]}),expect(i.menu.isOpen).toBeFalse()}),it("clicking the toggle stops event propagation",function(){var e=t("click");expect(e.isPropagationStopped()).toBeTrue()})})}),suite("rb/ui/views/MenuView",function(){describe("Rendering",function(){it("Standard menus",function(){var e=new RB.MenuView;e.render().$el.appendTo($testsScratch),expect(e.el.id).toBe(e.id),expect(e.el.id).toMatch(/^__rb-menu\d+/),expect(e.el).toHaveClass("rb-c-menu"),expect(e.el).not.toHaveClass("rb-c-button-group"),expect(e.el).not.toHaveClass("-is-vertical"),expect(e.el.tabIndex).toBe(-1),expect(e.$el.attr("role")).toBe("menu"),expect(e.$el.css("display")).toBe("none"),expect(e.$el.css("visibility")).toBe("hidden"),expect(e.$el.css("opacity")).toBe("0")}),it("Button menus",function(){var e=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU});e.render().$el.appendTo($testsScratch),expect(e.el.id).toBe(e.id),expect(e.el.id).toMatch(/^__rb-menu\d+/),expect(e.el).toHaveClass("rb-c-menu"),expect(e.el).toHaveClass("rb-c-button-group"),expect(e.el).toHaveClass("-is-vertical"),expect(e.el.tabIndex).toBe(-1),expect(e.$el.attr("role")).toBe("menu"),expect(e.$el.css("display")).toBe("none"),expect(e.$el.css("visibility")).toBe("hidden"),expect(e.$el.css("opacity")).toBe("0")}),it("With ariaLabelledBy",function(){var e=new RB.MenuView({ariaLabel:"unused label",ariaLabelledBy:"abc123",type:RB.MenuView.TYPE_BUTTON_MENU});e.render().$el.appendTo($testsScratch),expect(e.$el.attr("aria-label")).toBeUndefined(),expect(e.$el.attr("aria-labelledby")).toBe("abc123")}),it("With ariaLabel",function(){var e=new RB.MenuView({ariaLabel:"ARIA label",type:RB.MenuView.TYPE_BUTTON_MENU});e.render(),expect(e.$el.attr("aria-label")).toBe("ARIA label"),expect(e.$el.attr("aria-labelledby")).toBeUndefined()}),it("With $controller",function(){var e=$("<div>"),t=new RB.MenuView({$controller:e,type:RB.MenuView.TYPE_BUTTON_MENU});t.render(),expect(t.el.id).toBe(t.id),expect(t.el.id).toMatch(/^__rb-menu\d+/),expect(e.attr("aria-controls")).toBe(t.el.id),expect(e.attr("aria-expanded")).toBe("false"),expect(e.attr("aria-haspopup")).toBe("true")})}),describe("Methods",function(){describe("addItem",function(){it("For standard menus",function(){var e=new RB.MenuView,t=(e.render(),e.addItem()),i=t[0],t=(expect(i.tagName).toBe("DIV"),expect(i.tabIndex).toBe(-1),expect(i).toHaveClass("rb-c-menu__item"),expect(i).not.toHaveClass("rb-c-button"),expect(t.attr("role")).toBe("menuitem"),e.$el.children());expect(t.length).toBe(1),expect(t[0]).toBe(i)}),it("For button menus",function(){var e=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU}),t=(e.render(),e.addItem()),i=t[0],t=(expect(i.tagName).toBe("BUTTON"),expect(i.tabIndex).toBe(-1),expect(i).toHaveClass("rb-c-menu__item"),expect(i).toHaveClass("rb-c-button"),expect(t.attr("type")).toBe("button"),expect(t.attr("role")).toBe("menuitem"),e.$el.children());expect(t.length).toBe(1),expect(t[0]).toBe(i)}),it("With text",function(){var e=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU}),e=(e.render(),e.addItem({text:"This is a test"}));expect(e.text()).toBe("This is a test")})}),describe("open",function(){let t,i;beforeEach(function(){t=$("<div>").appendTo($testsScratch),(i=new RB.MenuView({$controller:t})).render().$el.appendTo($testsScratch),expect(i.$el.css("display")).toBe("none"),expect(i.$el.css("visibility")).toBe("hidden"),expect(i.$el.css("opacity")).toBe("0"),spyOn(i,"trigger").and.callThrough()}),it("Default behavior",function(e){i.open(),_.delay(()=>{expect(i.isOpen).toBeTrue(),expect(i.el).toHaveClass("-is-open"),expect(i.el).not.toHaveClass("js-no-animation"),expect(i.$el.css("display")).toBe("block"),expect(i.$el.css("visibility")).toBe("visible"),expect(i.$el.css("opacity")).toBe("1"),expect(t.attr("aria-expanded")).toBe("true"),e()},300)}),it("With animate=false",function(e){i.open({animate:!1}),expect(i.isOpen).toBeTrue(),expect(i.el).toHaveClass("-is-open"),expect(i.el).toHaveClass("js-no-animation"),expect(i.$el.css("display")).toBe("block"),expect(i.$el.css("visibility")).toBe("visible"),expect(i.$el.css("opacity")).toBe("1"),expect(i.trigger).toHaveBeenCalledWith("opening"),expect(i.trigger).toHaveBeenCalledWith("opened"),expect(t.attr("aria-expanded")).toBe("true"),_.defer(()=>{expect(i.el).not.toHaveClass("js-no-animation"),e()})})}),describe("close",function(){let t,i;beforeEach(function(){t=$('<div aria-expanded="true">').appendTo($testsScratch),(i=new RB.MenuView({$controller:t})).render().$el.appendTo($testsScratch),i.isOpen=!0,i.$el.addClass("-is-open"),expect(i.$el.css("display")).toBe("block"),expect(i.$el.css("visibility")).toBe("visible"),expect(i.$el.css("opacity")).toBe("1"),spyOn(i,"trigger").and.callThrough()}),it("Default behavior",function(e){i.close(),_.delay(()=>{expect(i.isOpen).toBeFalse(),expect(i.el).not.toHaveClass("-is-open"),expect(i.el).not.toHaveClass("js-no-animation"),expect(i.$el.css("display")).toBe("none"),expect(i.$el.css("visibility")).toBe("hidden"),expect(i.$el.css("opacity")).toBe("0"),expect(t.attr("aria-expanded")).toBe("false"),e()},300)}),it("With animate=false",function(e){i.close({animate:!1}),expect(i.isOpen).toBeFalse(),expect(i.el).toHaveClass("js-no-animation"),expect(i.el).not.toHaveClass("-is-open"),expect(i.$el.css("display")).toBe("none"),expect(i.$el.css("visibility")).toBe("hidden"),expect(i.$el.css("opacity")).toBe("0"),expect(i.trigger).toHaveBeenCalledWith("closing"),expect(i.trigger).toHaveBeenCalledWith("closed"),expect(t.attr("aria-expanded")).toBe("false"),_.defer(()=>{expect(i.el).not.toHaveClass("js-no-animation"),e()})})}),it("focusFirstItem",function(){var e=new RB.MenuView,t=(e.render().$el.appendTo($testsScratch),e.open({animate:!1}),e.addItem()[0]);e.addItem(),e.addItem(),spyOn(t,"focus"),e.focusFirstItem(),expect(t.focus).toHaveBeenCalled(),expect(e._activeItemIndex).toBe(0)}),it("focusLastItem",function(){var e=new RB.MenuView,t=(e.render().$el.appendTo($testsScratch),e.open({animate:!1}),e.addItem(),e.addItem(),e.addItem()[0]);spyOn(t,"focus"),e.focusLastItem(),expect(t.focus).toHaveBeenCalled(),expect(e._activeItemIndex).toBe(2)})}),describe("Keyboard Accessibility",function(){let e,t,i,n,o;function a(e){o.$el.trigger($.Event("keydown",{key:e}))}beforeEach(function(){e=$("<div>").appendTo($testsScratch),(o=new RB.MenuView({$controller:e})).render().$el.appendTo($testsScratch),t=o.addItem(),i=o.addItem(),n=o.addItem(),o.open({animate:!1}),o.focusItem(1),spyOn(o,"trigger").and.callThrough()}),it("Enter key activates item",function(){var e=jasmine.createSpy();i.on("click",e),a("Enter"),expect(e).toHaveBeenCalled()}),it("Escape key closes menu",function(){spyOn(e[0],"focus"),a("Escape"),expect(o.el).not.toHaveClass("-is-open"),expect(e[0].focus).toHaveBeenCalled()}),it("Tab key closes menu",function(){spyOn(e[0],"focus"),a("Tab"),expect(o.el).not.toHaveClass("-is-open"),expect(e[0].focus).toHaveBeenCalled()}),it("Up key moves focus up",function(){spyOn(o,"focusItem").and.callThrough(),a("ArrowUp"),expect(o.focusItem).toHaveBeenCalledWith(0),a("ArrowUp"),expect(o.focusItem).toHaveBeenCalledWith(2)}),it("Down key moves focus up",function(){spyOn(o,"focusItem").and.callThrough(),a("ArrowDown"),expect(o.focusItem).toHaveBeenCalledWith(2),a("ArrowDown"),expect(o.focusItem).toHaveBeenCalledWith(0)}),it("Home key moves focus to top",function(){spyOn(o,"focusItem").and.callThrough(),a("Home"),expect(o.focusItem).toHaveBeenCalledWith(0)}),it("Page Up key moves focus to top",function(){spyOn(o,"focusItem").and.callThrough(),a("PageUp"),expect(o.focusItem).toHaveBeenCalledWith(0)}),it("End key moves focus to bottom",function(){spyOn(o,"focusItem").and.callThrough(),a("End"),expect(o.focusItem).toHaveBeenCalledWith(2)}),it("Page Down key moves focus to bottom",function(){spyOn(o,"focusItem").and.callThrough(),a("PageDown"),expect(o.focusItem).toHaveBeenCalledWith(2)})})}),suite("rb/ui/managers/NotificationManagerModel",function(){const t=RB.NotificationManager.instance;let e;function i(e,t){this.title=e,this.options=t,this.close=function(){}}i.requestPermission=function(){i.permission="granted"},beforeEach(function(){e=RB.NotificationManager.Notification,RB.NotificationManager.Notification=i,RB.UserSession.instance.set("enableDesktopNotifications",!0),t.setup(),expect(i.permission).toBe("granted")}),afterEach(function(){RB.NotificationManager.Notification=e}),describe("Notification Manager",function(){it("Calls external API",function(){t.notify({title:"Test",body:"This is a test"});var e=t._notification;expect(e).not.toBe(null),expect(e.title).toBe("Test"),expect(e.options.body).toBe("This is a test")}),it("Should notify",function(){t._canNotify=!0,spyOn(t,"_haveNotificationPermissions").and.returnValue(!0),expect(t.shouldNotify()).toBe(!0)}),it("Should not notify due to user permissions",function(){t._canNotify=!1,spyOn(t,"_haveNotificationPermissions").and.returnValue(!0),expect(t.shouldNotify()).toBe(!1)}),it("Should not notify due to browser permissions",function(){t._canNotify=!0,spyOn(t,"_haveNotificationPermissions").and.returnValue(!1),expect(t.shouldNotify()).toBe(!1)})})}),suite("rb/ui/views/ScrollManagerView",function(){function n(e={}){var t=$testsScratch.offset();return $("<div>").css({position:"absolute",left:-t.left+(e.left||0),top:-t.top+(e.top||0),width:e.width||20,height:e.height||20}).appendTo($testsScratch)}let o;beforeEach(function(){(o=new RB.ScrollManagerView).window={pageXOffset:0,pageYOffset:0,scrollTo(e,t){this.pageXOffset=e,this.pageYOffset=t},requestAnimationFrame(e){e()}}}),describe("scrollToPosition",function(){it("Without scroll offset",function(){o.scrollToPosition(100),expect(Math.round(o.window.pageYOffset)).toBe(100)}),it("With scroll offset",function(){o.scrollYOffset=40,o.scrollToPosition(100),expect(Math.round(o.window.pageYOffset)).toBe(60)})}),describe("scrollToElement",function(){let e;beforeEach(function(){e=n({top:50})}),it("Without scroll offset",function(){o.scrollToElement(e),expect(Math.round(o.window.pageYOffset)).toBe(50)}),it("With scroll offset",function(){o.scrollYOffset=40,o.scrollToElement(e),expect(Math.round(o.window.pageYOffset)).toBe(10)})}),describe("markUpdated",function(){let t;beforeEach(function(){t=n({top:50})}),it("First in a batch",function(){o.window.pageYOffset=100,expect(o._oldScrollY).toBe(null),o.markForUpdate(t);var e=o._pendingElements.get(t[0]);expect(Math.round(e.oldHeight)).toEqual(20),expect(Math.round(e.oldOffset.top)).toEqual(50),expect(Math.round(e.oldOffset.left)).toEqual(0),expect(o._oldScrollY).toBe(100)}),it("Subsequent entries",function(){o._oldScrollY=100,o.window.pageYOffset=200,o.markForUpdate(t);var e=o._pendingElements.get(t[0]);expect(Math.round(e.oldHeight)).toEqual(20),expect(Math.round(e.oldOffset.top)).toEqual(50),expect(Math.round(e.oldOffset.left)).toEqual(0),expect(o._oldScrollY).toBe(100)})}),describe("markUpdated",function(){let t;beforeEach(function(){t=n({top:50})}),it("Stores correct state",function(){spyOn(o.window,"requestAnimationFrame"),o.markForUpdate(t),t.height(40),t.css("top",parseInt(t.css("top"),10)-10),o.markUpdated(t);var e=t[0],e=(expect(o._pendingElements.get(e)).toBe(void 0),o._elements.get(e));expect(Math.round(e.oldHeight)).toEqual(20),expect(Math.round(e.oldOffset.top)).toEqual(50),expect(Math.round(e.oldOffset.left)).toEqual(0),expect(Math.round(e.newHeight)).toEqual(40),expect(Math.round(e.newOffset.top)).toEqual(40),expect(Math.round(e.newOffset.left)).toEqual(0),expect(o.window.requestAnimationFrame).toHaveBeenCalled()})}),describe("Scroll updates",function(){beforeEach(function(){spyOn(o.window,"requestAnimationFrame"),o.window.pageYOffset=200}),it("Includes updates before scroll position",function(){var e=n({top:10}),t=n({top:60}),i=n({top:70});o.markForUpdate(e),e.height(70),o.markUpdated(e),o.markForUpdate(t),t.height(10),o.markUpdated(t),o.markForUpdate(i),i.css("top",parseInt(i.css("top"),10)-5),o.markUpdated(i),o._updateScrollPos(),expect(Math.round(o.window.pageYOffset)).toBe(235)}),it("Ignores updates after scroll position",function(){var e=n({top:10}),t=n({top:o.window.pageYOffset}),i=n({top:500});o.markForUpdate(e),e.height(30),o.markUpdated(e),o.markForUpdate(t),t.height(90),o.markUpdated(t),o.markForUpdate(i),i.height(1e3),o.markUpdated(i),o._updateScrollPos(),expect(o.window.pageYOffset).toBe(210)})})}),suite("rb/utils/apiUtils",function(){const l={200:"OK",400:"Bad Request",404:"Not Found",500:"Internal Server Error"};let e,t;beforeEach(function(){e=RB.ajaxOptions.enableQueuing,t=RB.ajaxOptions.enableIndicator,RB.ajaxOptions.enableQueuing=!0,RB.ajaxOptions.enableIndicator=!0}),afterEach(function(){RB.ajaxOptions.enableQueuing=e,RB.ajaxOptions.enableIndicator=t}),describe("apiCall",function(){function o(n,o){const i=$("<button>"),a=$('<div><span class="indicator-text"></span></div>').css("display","none").appendTo($testsScratch);let s;var c;function r(){expect(s.complete).not.toHaveBeenCalled(),expect(i.attr("disabled")).toBe("disabled"),expect(a.hasClass("error")).toBe(!1),expect(a.find(".indicator-text").text()).toBe("GET"===o.method?"Loading...":"Saving...")}c=o,spyOn($,"ajax").and.callFake(e=>{expect(e.type).toBe(c.method||"POST");var t=c.rsp,i=c.statusCode||200,n={_isXHR:!0,status:i,statusText:l[i]};n.responseText=void 0!==t?JSON.stringify(t):c.responseText||"";let o;o=204===i||"HEAD"===e.type?"nocontent":304===i?"notmodified":200<=i&&i<300?"success":"error",200<=i&&i<300||304===i?void 0!==e.success&&e.success(void 0!==t?t:c.responseText,o,n):e.error(n,o,n.statusText),e.complete(n,o)}),!(s={path:"info/",type:o.method,buttons:i,_$activityIndicator:a,_activityIndicatorHideImmediately:!0,complete:function(e,t){expect(e._isXHR).toBeTrue(),expect(t).toBe(o.expectedStatusText),o.expectSuccess?void 0!==s.success&&expect(s.success).toHaveBeenCalled():void 0!==s.error&&expect(s.error).toHaveBeenCalled(),expect(i.attr("disabled")).toBeUndefined();e=a.hasClass("error"),t=a.css("display");o.expectActivityIndicatorError?(expect(e).toBeTrue(),expect(t).toBe("block")):(expect(e).toBeFalse(),expect(t).toBe("none")),"GET"===o.method?n():$.funcQueue("rbapicall").add(function(){$.funcQueue("rbapicall").clear(),n()})}})!==o.addSuccessHandler&&(s.success=function(e,t,i){o.expectSuccess?(r(),o.expectAPIErrorSuccess?(expect(arguments.length).toBe(2),expect(t).toBe(o.statusCode)):(expect(arguments.length).toBe(3),expect(t).toBe(o.expectedStatusText),expect(i._isXHR).toBeTrue()),expect(e).toEqual(o.rsp)):n.fail("API call unexpectedly returned success.")}),!1!==o.addErrorHandler&&(s.error=function(e,t,i){o.expectSuccess?n.fail("API call unexpectedly returned error."):(r(),expect(t).toBe(o.expectedStatusText),expect(e._isXHR).toBeTrue(),expect(i).toBe(l[e.status]),expect(e.statusText).toBe(i))}),spyOn(s,"complete").and.callThrough(),void 0!==s.success&&spyOn(s,"success").and.callThrough(),void 0!==s.error&&spyOn(s,"error").and.callThrough(),RB.apiCall(s)}function t(t,i,n){describe("HTTP "+t,function(){describe("With success",function(){it("And success handler",function(e){o(e,{method:t,rsp:{stat:"ok"},expectSuccess:!0,expectedStatusText:i})}),it("And no success handler",function(e){o(e,{method:t,rsp:{stat:"ok"},addSuccessHandler:!1,expectSuccess:!0,expectedStatusText:i})})}),describe("With HTTP 204",function(){it("And success handler",function(e){o(e,{method:t,statusCode:204,expectSuccess:!0,expectedStatusText:"nocontent"})}),it("And no success handler",function(e){o(e,{method:t,statusCode:204,addSuccessHandler:!1,expectSuccess:!0,expectedStatusText:"nocontent"})})}),describe("With API error",function(){it("And error handler",function(e){o(e,{method:t,rsp:{stat:"fail"},statusCode:404,expectSuccess:!1,expectedStatusText:n})}),it("And no error handler",function(e){o(e,{method:t,rsp:{stat:"fail"},statusCode:404,addErrorHandler:!1,expectSuccess:!0,expectAPIErrorSuccess:!0,expectedStatusText:n})})}),describe("With unexpected error",function(){it("With error handler",function(e){o(e,{method:t,responseText:"oh no it broke",statusCode:500,expectSuccess:!1,expectedStatusText:n})}),it("Without error handler",function(e){o(e,{method:t,responseText:"oh no it broke",statusCode:500,addErrorHandler:!1,expectSuccess:!1,expectedStatusText:n,expectActivityIndicatorError:!0})})})})}["DELETE","GET","POST","PATCH","PUT"].forEach(e=>t(e,"success","error")),t("HEAD","nocontent","nocontent")})}),suite("rb/utils/dataUtils",function(){it("readBlobAsArrayBuffer",function(e){var t=new Blob(["abc123"]);RB.DataUtils.readBlobAsArrayBuffer(t,t=>{expect(t.byteLength).toBe(6);var i=new DataView(t);for(let e=0;e<t.byteLength;e++)expect(i.getUint8(e)).toBe("abc123".charCodeAt(e));e()})}),it("readBlobAsString",function(t){var e=new Blob(["This is a test."]);RB.DataUtils.readBlobAsString(e,e=>{expect(typeof e).toBe("string"),expect(e).toBe("This is a test."),t()})}),it("readManyBlobsAsArrayBuffers",function(e){var t=new Blob(["abc123"]),i=new Blob(["foo"]);RB.DataUtils.readManyBlobsAsArrayBuffers([t,i],(t,i)=>{expect(t.byteLength).toBe(6),expect(i.byteLength).toBe(3);var n=new DataView(t);for(let e=0;e<t.byteLength;e++)expect(n.getUint8(e)).toBe("abc123".charCodeAt(e));var o=new DataView(i);for(let e=0;e<i.byteLength;e++)expect(o.getUint8(e)).toBe("foo".charCodeAt(e));e()})}),it("readManyBlobsAsStrings",function(i){var e=new Blob(["This is a test."]),t=new Blob(["hello world"]);RB.DataUtils.readManyBlobsAsStrings([e,t],(e,t)=>{expect(typeof e).toBe("string"),expect(typeof t).toBe("string"),expect(e).toBe("This is a test."),expect(t).toBe("hello world"),i()})}),describe("buildArrayBuffer",function(){it("With int8",function(){var t=[-1,0,1],e=RB.DataUtils.buildArrayBuffer([{type:"int8",values:t}]),i=(expect(e.byteLength).toBe(3),new DataView(e));for(let e=0;e<t.length;e++)expect(i.getInt8(e)).toBe(t[e])}),it("With uint8",function(){var t=[1,2,3],e=RB.DataUtils.buildArrayBuffer([{type:"uint8",values:t}]),i=(expect(e.byteLength).toBe(3),new DataView(e));for(let e=0;e<t.length;e++)expect(i.getUint8(e)).toBe(t[e])}),describe("With int16",function(){const i=[-1,0,1];it("Little endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"int16",values:i}]),t=(expect(e.byteLength).toBe(6),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getInt16(2*e,!0)).toBe(i[e])}),it("Big endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"int16",values:i,bigEndian:!0}]),t=(expect(e.byteLength).toBe(6),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getInt16(2*e)).toBe(i[e])})}),describe("With uint16",function(){const i=[1,2,3];it("Little endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"uint16",values:i}]),t=(expect(e.byteLength).toBe(6),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getUint16(2*e,!0)).toBe(i[e])}),it("Big endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"uint16",values:i,bigEndian:!0}]),t=(expect(e.byteLength).toBe(6),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getUint16(2*e)).toBe(i[e])})}),describe("With int32",function(){const i=[-1,0,1];it("Little endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"int32",values:i}]),t=(expect(e.byteLength).toBe(12),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getInt32(4*e,!0)).toBe(i[e])}),it("Big endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"int32",values:i,bigEndian:!0}]),t=(expect(e.byteLength).toBe(12),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getInt32(4*e)).toBe(i[e])})}),describe("With uint32",function(){const i=[1,2,3];it("Little endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:i}]),t=(expect(e.byteLength).toBe(12),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getUint32(4*e,!0)).toBe(i[e])}),it("Big endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:i,bigEndian:!0}]),t=(expect(e.byteLength).toBe(12),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getUint32(4*e)).toBe(i[e])})}),describe("With float32",function(){const i=[1,2,3];it("Little endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"float32",values:i}]),t=(expect(e.byteLength).toBe(12),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getFloat32(4*e,!0)).toBe(i[e])}),it("Big endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"float32",values:i,bigEndian:!0}]),t=(expect(e.byteLength).toBe(12),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getFloat32(4*e)).toBe(i[e])})}),describe("With float64",function(){const i=[1,2,3];it("Little endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"float64",values:i}]),t=(expect(e.byteLength).toBe(24),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getFloat64(8*e,!0)).toBe(i[e])}),it("Big endian",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"float64",values:i,bigEndian:!0}]),t=(expect(e.byteLength).toBe(24),new DataView(e));for(let e=0;e<i.length;e++)expect(t.getFloat64(8*e)).toBe(i[e])})}),it("With complex schema",function(){var e=RB.DataUtils.buildArrayBuffer([{type:"int32",values:[10,20],bigEndian:!0},{type:"uint8",values:[100]},{type:"uint16",values:[64]},{type:"float64",values:[1.234]}]),e=(expect(e.byteLength).toBe(19),new DataView(e));expect(e.getInt32(0)).toBe(10),expect(e.getInt32(4)).toBe(20),expect(e.getUint8(8)).toBe(100),expect(e.getUint16(9,!0)).toBe(64),expect(e.getFloat64(11,!0)).toEqual(1.234)})}),it("buildBlob",function(t){var e=RB.DataUtils.buildBlob(["abc",[{type:"uint8",values:[1,2]},{type:"uint32",values:[100]}],new Blob(["def"])]);RB.DataUtils.readBlobAsArrayBuffer(e,e=>{expect(e.byteLength).toBe(12);e=new DataView(e);expect(e.getUint8(0)).toBe("a".charCodeAt(0)),expect(e.getUint8(1)).toBe("b".charCodeAt(0)),expect(e.getUint8(2)).toBe("c".charCodeAt(0)),expect(e.getUint8(3)).toBe(1),expect(e.getUint8(4)).toBe(2),expect(e.getUint32(5,!0)).toBe(100),expect(e.getUint8(9)).toBe("d".charCodeAt(0)),expect(e.getUint8(10)).toBe("e".charCodeAt(0)),expect(e.getUint8(11)).toBe("f".charCodeAt(0)),t()})})}),suite("rb/utils/keyBindingUtils",function(){describe("KeyBindingsMixin",function(){function t(e,t,i){var n=jQuery.Event("keypress");n.which=t.charCodeAt(0),e.trigger(n),expect(n.isDefaultPrevented()).toBe(i),expect(n.isPropagationStopped()).toBe(i)}it("Registered on create",function(){var e=Backbone.View.extend({keyBindings:{}});_.extend(e.prototype,RB.KeyBindingsMixin),spyOn(e.prototype,"delegateKeyBindings"),this._view=new e,expect(e.prototype.delegateKeyBindings).toHaveBeenCalled()}),it("Unregistered on undelegateEvents",function(){var e=Backbone.View.extend({keyBindings:{}}),t=(_.extend(e.prototype,RB.KeyBindingsMixin),new e);spyOn(e.prototype,"undelegateKeyBindings"),t.undelegateEvents(),expect(e.prototype.undelegateKeyBindings).toHaveBeenCalled()}),it("Keys to function name",function(){var e=Backbone.View.extend({keyBindings:{abc:"myFunc1",def:"myFunc2"},myFunc1:function(){},myFunc2:function(){}}),e=(_.extend(e.prototype,RB.KeyBindingsMixin),new e);e.render().$el.appendTo($testsScratch),spyOn(e,"myFunc1"),spyOn(e,"myFunc2"),t(e.$el,"e",!0),expect(e.myFunc1).not.toHaveBeenCalled(),expect(e.myFunc2).toHaveBeenCalled()}),it("Keys to function",function(){var e=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}}),e=(_.extend(e.prototype,RB.KeyBindingsMixin),new e);e.render().$el.appendTo($testsScratch),spyOn(e.keyBindings,"abc"),spyOn(e.keyBindings,"def"),t(e.$el,"b",!0),expect(e.keyBindings.abc).toHaveBeenCalled(),expect(e.keyBindings.def).not.toHaveBeenCalled()}),it("Unmatched keys",function(){var e=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}}),e=(_.extend(e.prototype,RB.KeyBindingsMixin),new e);e.render().$el.appendTo($testsScratch),spyOn(e.keyBindings,"abc"),spyOn(e.keyBindings,"def"),t(e.$el,"!",!1),expect(e.keyBindings.abc).not.toHaveBeenCalled(),expect(e.keyBindings.def).not.toHaveBeenCalled()})})}),suite("rb/utils/linkifyUtils",function(){var t="http://issues/?id=--bug_id--";describe("linkifyChildren",function(){it("URLs",function(){var e=$("<p><span>http://example.com</span></p>"),e=(RB.LinkifyUtils.linkifyChildren(e[0]),e.children("span")),e=(expect(e.length).toBe(1),e.children("a"));expect(e.length).toBe(1),expect(e.attr("target")).toBe("_blank"),expect(e.attr("href")).toBe("http://example.com"),expect(e.text()).toBe("http://example.com")}),it("Bugs",function(){var e=$("<p><span>Bug #123</span></p>"),e=(RB.LinkifyUtils.linkifyChildren(e[0],t),e.children("span")),e=(expect(e.length).toBe(1),e.children("a"));expect(e.length).toBe(1),expect(e.attr("target")).toBe("_blank"),expect(e.attr("href")).toBe("http://issues/?id=123"),expect(e.text()).toBe("Bug #123")}),it("/r/ paths",function(){var e=$("<p><span>/r/123/</span></p>"),e=(RB.LinkifyUtils.linkifyChildren(e[0]),e.children("span")),e=(expect(e.length).toBe(1),e.children("a"));expect(e.length).toBe(1),expect(e.attr("target")).toBe("_blank"),expect(e.attr("href")).toBe("/r/123/"),expect(e.attr("class")).toBe("review-request-link"),expect(e.text()).toBe("/r/123/")}),it("Skips <a> elements",function(){var e=$('<p><span><a href="http://example.com">/r/123</a></span></p>'),e=(RB.LinkifyUtils.linkifyChildren(e[0]),e.children("span")),e=(expect(e.length).toBe(1),e.children("a"));expect(e.length).toBe(1),expect(e.attr("target")).toBe(void 0),expect(e.attr("href")).toBe("http://example.com"),expect(e.text()).toBe("/r/123")}),it("Skips <pre> elements",function(){var e=$("<div><pre>/r/123</pre></div>");RB.LinkifyUtils.linkifyChildren(e[0]),expect(e.html()).toBe("<pre>/r/123</pre>")})}),describe("linkifyText",function(){describe("URLs",function(){const e=RB.LinkifyUtils.linkifyText;it("http://",function(){expect(e("http://example.com")).toBe('<a target="_blank" href="http://example.com">http://example.com</a>')}),it("https://",function(){expect(e("https://example.com")).toBe('<a target="_blank" href="https://example.com">https://example.com</a>')}),it("ftp://",function(){expect(e("ftp://example.com")).toBe('<a target="_blank" href="ftp://example.com">ftp://example.com</a>')}),it("ftps://",function(){expect(e("ftps://example.com")).toBe('<a target="_blank" href="ftps://example.com">ftps://example.com</a>')}),it("gopher://",function(){expect(e("gopher://example.com")).toBe('<a target="_blank" href="gopher://example.com">gopher://example.com</a>')}),it("mailto:",function(){expect(e("mailto:user@example.com")).toBe('<a target="_blank" href="mailto:user@example.com">mailto:user@example.com</a>')}),it("news:",function(){expect(e("news:example.com")).toBe('<a target="_blank" href="news:example.com">news:example.com</a>')}),it("sms:",function(){expect(e("sms:example.com")).toBe('<a target="_blank" href="sms:example.com">sms:example.com</a>')}),it("javascript: (unlinked)",function(){expect(e("javascript:test")).toBe("javascript:test")}),it("javascript:// (unlinked)",function(){expect(e("javascript://test")).toBe("javascript://test")}),it("Trailing slashes",function(){expect(e("http://example.com/foo/")).toBe('<a target="_blank" href="http://example.com/foo/">http://example.com/foo/</a>')}),it("Anchors",function(){expect(e("http://example.com/#my-anchor")).toBe('<a target="_blank" href="http://example.com/#my-anchor">http://example.com/#my-anchor</a>')}),it("Query strings",function(){expect(e("http://example.com/?a=b&c=d")).toBe('<a target="_blank" href="http://example.com/?a=b&amp;c=d">http://example.com/?a=b&amp;c=d</a>')}),describe("Surrounded by",function(){it("(...)",function(){expect(e("(http://example.com/)")).toBe('(<a target="_blank" href="http://example.com/">http://example.com/</a>)')}),it("[...]",function(){expect(e("[http://example.com/]")).toBe('[<a target="_blank" href="http://example.com/">http://example.com/</a>]')}),it("{...}",function(){expect(e("{http://example.com/}")).toBe('{<a target="_blank" href="http://example.com/">http://example.com/</a>}')}),it("<...>",function(){expect(e("<http://example.com/>")).toBe('&lt;<a target="_blank" href="http://example.com/">http://example.com/</a>&gt;')})})}),describe("/r/ paths",function(){describe("Review requests",function(){it("/r/123",function(){expect(RB.LinkifyUtils.linkifyText("/r/123")).toBe('<a target="_blank" href="/r/123/" class="review-request-link">/r/123</a>')}),it("/r/123/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/")).toBe('<a target="_blank" href="/r/123/" class="review-request-link">/r/123/</a>')})}),describe("Diffs",function(){it("/r/123/diff",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff")).toBe('<a target="_blank" href="/r/123/diff/" class="review-request-link">/r/123/diff</a>')}),it("/r/123/diff/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff/")).toBe('<a target="_blank" href="/r/123/diff/" class="review-request-link">/r/123/diff/</a>')})})}),describe("Surrounded by",function(){it("(...)",function(){expect(RB.LinkifyUtils.linkifyText("(/r/123/)")).toBe('(<a target="_blank" href="/r/123/" class="review-request-link">/r/123/</a>)')}),it("[...]",function(){expect(RB.LinkifyUtils.linkifyText("[/r/123/]")).toBe('[<a target="_blank" href="/r/123/" class="review-request-link">/r/123/</a>]')}),it("{...}",function(){expect(RB.LinkifyUtils.linkifyText("{/r/123/}")).toBe('{<a target="_blank" href="/r/123/" class="review-request-link">/r/123/</a>}')}),it("<...>",function(){expect(RB.LinkifyUtils.linkifyText("</r/123/>")).toBe('&lt;<a target="_blank" href="/r/123/" class="review-request-link">/r/123/</a>&gt;')}),it("text",function(){expect(RB.LinkifyUtils.linkifyText("foo/r/123/bar")).toBe("foo/r/123/bar")})})}),describe("Bug References",function(){describe("With bugTrackerURL",function(){function e(e){return RB.LinkifyUtils.linkifyText(e,t)}it("bug 123",function(){expect(e("bug 123")).toBe('<a target="_blank" href="http://issues/?id=123">bug 123</a>')}),it("bug #123",function(){expect(e("bug #123")).toBe('<a target="_blank" href="http://issues/?id=123">bug #123</a>')}),it("issue 123",function(){expect(e("issue 123")).toBe('<a target="_blank" href="http://issues/?id=123">issue 123</a>')}),it("issue #123",function(){expect(e("issue #123")).toBe('<a target="_blank" href="http://issues/?id=123">issue #123</a>')}),it("bug #abc",function(){expect(e("bug #abc")).toBe('<a target="_blank" href="http://issues/?id=abc">bug #abc</a>')}),it("issue #abc",function(){expect(e("issue #abc")).toBe('<a target="_blank" href="http://issues/?id=abc">issue #abc</a>')}),it("issue #abc, issue 2",function(){expect(e("issue #abc, issue 2")).toBe('<a target="_blank" href="http://issues/?id=abc">issue #abc</a>, <a target="_blank" href="http://issues/?id=2">issue 2</a>')}),it("(issue #abc-123) [bug #cba-321]",function(){expect(e("(issue #abc-123) [bug #cba-321]")).toBe('(<a target="_blank" href="http://issues/?id=abc-123">issue #abc-123</a>) [<a target="_blank" href="http://issues/?id=cba-321">bug #cba-321</a>]')})}),describe("Without bugTrackerURL",function(){const e=RB.LinkifyUtils.linkifyText;it("bug 123",function(){expect(e("bug 123")).toBe("bug 123")}),it("issue 123",function(){expect(e("issue 123")).toBe("issue 123")})})})}),suite("rb/utils/urlUtils",function(){describe("getLocationHash",function(){beforeEach(function(){window.xss=function(){}}),afterEach(function(){window.hasOwnProperty("xss")&&delete window.xss}),it("Prevents XSS injection",function(e){spyOn(window,"xss");var t=RB.getLocationHash("http://www.example.com/#<img/src/onerror=window.xss()>");$(`a[name="${t}"]`),_.delay(function(){expect(window.xss).not.toHaveBeenCalled(),e()})})})}),suite("rb/views/ClientLoginView",function(){let t;const i=`<div id="auth_container">
 <div class="auth-header">
 </div>
</div>`;beforeEach(function(){t=new RB.ClientLoginView({el:$(i),clientName:"Client",clientURL:"http%3A//localhost%3A1234",payload:{api_token:"token"},redirectTo:"",username:"User"})}),describe("Rendering",function(){it("With failing to connect to the client server",async function(){spyOn(window,"fetch").and.throwError("Test Error"),await t.render(),expect(t.$("h1").text()).toBe("Failed to log in for Client"),expect(t.$("p").text()).toBe(["Could not connect to Client. Please contact your ","administrator."].join("")),expect(t.$("#redirect-counter").text()).toBe("")}),it("With successfully sending data to the client",async function(){var e=new Response(JSON.stringify({}),{status:200});spyOn(window,"fetch").and.resolveTo(e),await t.render(),expect(t.$("h1").text()).toBe("Logged in to Client"),expect(t.$("p").text()).toBe(["You have successfully logged in to Client as User. ","You can now close this page."].join("")),expect(t.$("#redirect-counter").text()).toBe("")}),it("With sending data to the client and a redirect",async function(){t=new RB.ClientLoginView({el:$(i),clientName:"Client",clientURL:"http%3A//localhost%3A1234",payload:{api_token:"token"},redirectTo:"http%3A//localhost%3A1234/test/",username:"User"});var e=new Response(JSON.stringify({}),{status:200});spyOn(window,"fetch").and.resolveTo(e),spyOn(window,"setInterval"),await t.render(),expect(t.$("h1").text()).toBe("Logged in to Client"),expect(t.$("p").text()).toBe(["You have successfully logged in to Client as User. ","Redirecting in 3..."].join("")),expect(t.$("#redirect-counter").text()).toBe(" 3..."),expect(setInterval).toHaveBeenCalled()}),it("With failing to send data to the client",async function(){var e=new Response(JSON.stringify({}),{status:400});spyOn(window,"fetch").and.resolveTo(e),await t.render(),expect(t.$("h1").text()).toBe("Failed to log in for Client"),expect(t.$("p").text()).toBe(["Failed to log in for Client as User. Please contact ","your administrator."].join("")),expect(t.$("#redirect-counter").text()).toBe("")})}),describe("_redirectCountDown",function(){beforeEach(function(){t=new RB.ClientLoginView({el:$('<div><span id="redirect-counter"></span></div>'),clientName:"Client",clientURL:"http%3A//localhost%3A1234",payload:{api_token:"token"},redirectTo:"http%3A//localhost%3A1234/test/",username:"User"})}),it("With a counter greater than 1",function(){t._$counter=t.$("#redirect-counter"),expect(t._redirectCounter).toBe(3),t._redirectCountdown(),expect(t._redirectCounter).toBe(2),expect(t._$counter.text()).toBe(" 2...")}),it("With a counter at 1",function(){t._$counter=t.$("#redirect-counter"),t._redirectCounter=1,spyOn(RB,"navigateTo"),spyOn(window,"clearInterval"),t._redirectCountdown(),expect(t._redirectCounter).toBe(0),expect(t._$counter.text()).toBe(" 0..."),expect(RB.navigateTo).toHaveBeenCalledWith("http://localhost:1234/test/")})})}),suite("rb/views/CollectionView",function(){let n,o;const a=Backbone.Model.extend({defaults:_.defaults({data:""})}),e=Backbone.Collection.extend({model:a});var t=Backbone.View.extend({className:"test-class",render(){return this.$el.text(this.model.get("data")),this}});const i=RB.CollectionView.extend({itemViewType:t});beforeEach(function(){n=new e,o=new i({collection:n})}),describe("Rendering",function(){it("When empty",function(){o.render(),expect(o.$el.children().length).toBe(0)}),it("With items",function(){n.add([{data:"Item 1"},{data:"Item 2"}]),o.render();var e=o.$el.children();expect(e.length).toBe(2),expect(e[0].innerHTML).toBe("Item 1"),expect(e[1].innerHTML).toBe("Item 2")}),it("Item model type",function(){n.add([{data:"Item 1"}]),o.render(),expect(o.$el.children().hasClass("test-class")).toBe(!0)}),it("With custom element container",function(){var e=$('<div class="rb-test-main-container">').appendTo(o.$el),e=(o.$container=e,n.add([{data:"Item 1"},{data:"Item 2"}]),o.render(),o.$el.children()),e=(expect(e.length).toBe(1),expect(e[0].className).toBe("rb-test-main-container"),e.eq(0).children());expect(e.length).toBe(2),expect(e[0].innerHTML).toBe("Item 1"),expect(e[1].innerHTML).toBe("Item 2")})}),describe("Live updating",function(){it("Adding items after rendering",function(){n.add([{data:"Item 1"}]),o.render(),expect(o.$el.children().length).toBe(1),n.add([{data:"Item 2"},{data:"Item 3"}]);var e=o.$el.children();expect(e.length).toBe(3),expect(e[2].innerHTML).toBe("Item 3")}),it("Removing items after rendering",function(){var e=new a({data:"Item 1"}),t=new a({data:"Item 2"}),i=new a({data:"Item 3"}),t=(n.add([e,t,i]),o.render(),expect(o.$el.children().length).toBe(3),n.remove([e,i]),o.$el.children());expect(t.length).toBe(1),expect(t[0].innerHTML).toBe("Item 2")}),it("When reset",function(){n.add([{data:"Item 1"},{data:"Item 2"}]),o.render();var e=o.$el.children();expect(e.length).toBe(2),expect(e[0].innerHTML).toBe("Item 1"),expect(e[1].innerHTML).toBe("Item 2"),n.reset([{data:"Item 3"},{data:"Item 4"},{data:"Item 5"}]),e=o.$el.children(),expect(e.length).toBe(3),expect(e[0].innerHTML).toBe("Item 3"),expect(e[1].innerHTML).toBe("Item 4"),expect(e[2].innerHTML).toBe("Item 5")}),describe("Sorting",function(){it("With order changed",function(){n.add([{data:"Item 2"},{data:"Item 3"},{data:"Item 1"}]),o.render();var e=o.$el.children();expect(e.length).toBe(3),expect(e[0].innerHTML).toBe("Item 2"),expect(e[1].innerHTML).toBe("Item 3"),expect(e[2].innerHTML).toBe("Item 1"),self.spyOn(o,"_addCollectionViews").and.callThrough(),n.comparator="data",n.sort(),e=o.$el.children(),expect(e[0].innerHTML).toBe("Item 1"),expect(e[1].innerHTML).toBe("Item 2"),expect(e[2].innerHTML).toBe("Item 3"),expect(o._addCollectionViews).toHaveBeenCalled()}),it("With order unchanged",function(){n.add([{data:"Item 1"},{data:"Item 2"},{data:"Item 3"}]),o.render();var e=o.$el.children();expect(e.length).toBe(3),expect(e[0].innerHTML).toBe("Item 1"),expect(e[1].innerHTML).toBe("Item 2"),expect(e[2].innerHTML).toBe("Item 3"),n.comparator="data",n.sort(),self.spyOn(o,"_addCollectionViews").and.callThrough(),e=o.$el.children(),expect(e[0].innerHTML).toBe("Item 1"),expect(e[1].innerHTML).toBe("Item 2"),expect(e[2].innerHTML).toBe("Item 3"),expect(o._addCollectionViews).not.toHaveBeenCalled()})})})}),suite("rb/views/DiffFragmentQueueView",function(){const r="/r/123/_fragments/diff-comments/";let l;beforeEach(function(){l=new RB.DiffFragmentQueueView({containerPrefix:"container1",reviewRequestPath:"/r/123/",queueName:"diff_fragments"})}),describe("Diff fragment loading",function(){let o,a,s,c;beforeEach(function(){o=$('<div id="container1_123">').appendTo(window.$testsScratch),a=$('<div id="container1_124">').appendTo(window.$testsScratch),s=$('<div id="container1_125">').appendTo(window.$testsScratch),c=$('<div id="container1_126">').appendTo(window.$testsScratch),l.queueLoad("123","key1"),l.queueLoad("124","key1"),l.queueLoad("125","key1"),l.queueLoad("126","key2")}),it("Fragment queueing",function(){var e=l._queue;expect(e.length).not.toBe(0),expect(e.key1.length).toBe(3),expect(e.key1).toContain({commentID:"123",onFragmentRendered:null}),expect(e.key1).toContain({commentID:"124",onFragmentRendered:null}),expect(e.key1).toContain({commentID:"125",onFragmentRendered:null}),expect(e.key2.length).toBe(1),expect(e.key2).toContain({commentID:"126",onFragmentRendered:null})}),it("Batch loading",function(e){spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer");var t=e.url;let i;if(t===r+"123,124,125/"){var n=new Blob(["<span>Comment one</span>"]),o=new Blob(["<span>Comment two</span>"]),a=new Blob(["<span>Comment three</span>"]);i=RB.DataUtils.buildBlob([[{type:"uint32",values:[123,n.size]}],n,[{type:"uint32",values:[124,o.size]}],o,[{type:"uint32",values:[125,a.size]}],a])}else{if(t!==r+"126/")return void fail("Unexpected URL "+t);n=new Blob(["<span>Comment 4</span>"]);i=RB.DataUtils.buildBlob([[{type:"uint32",values:[126,n.size]}],n])}RB.DataUtils.readBlobAsArrayBuffer(i,e.success)}),l.loadFragments(()=>{expect($.ajax.calls.count()).toBe(2),expect(o.data("diff-fragment-view")).toBeTruthy(),expect(o.html()).toBe("<span>Comment one</span>"),expect(a.data("diff-fragment-view")).toBeTruthy(),expect(a.html()).toBe("<span>Comment two</span>"),expect(s.data("diff-fragment-view")).toBeTruthy(),expect(s.html()).toBe("<span>Comment three</span>"),expect(c.data("diff-fragment-view")).toBeTruthy(),expect(c.html()).toBe("<span>Comment 4</span>"),e()})}),it("With Unicode content",function(e){spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer");var t=e.url;let i;if(t===r+"123,124,125/"){var n=[60,115,112,97,110,62,195,161,195,169,195,173,195,179,195,186,32,240,159,148,165,60,47,115,112,97,110,62],o=[60,115,112,97,110,62,195,132,195,139,195,143,195,150,195,156,197,184,32,240,159,152,177,60,47,115,112,97,110,62],a=[60,115,112,97,110,62,240,159,148,165,240,159,152,177,60,47,115,112,97,110,62];expect(n.length).toBe(28),expect(o.length).toBe(30),expect(a.length).toBe(21),i=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:[123,n.length]},{type:"uint8",values:n},{type:"uint32",values:[124,o.length]},{type:"uint8",values:o},{type:"uint32",values:[125,a.length]},{type:"uint8",values:a}])}else{if(t!==r+"126/")return void fail("Unexpected URL "+t);n=[60,115,112,97,110,62,196,128,196,146,196,170,197,140,32,240,159,145,191,60,47,115,112,97,110,62];expect(n.length).toBe(26),i=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:[126,n.length]},{type:"uint8",values:n}])}e.success(i)}),l.loadFragments(()=>{expect($.ajax.calls.count()).toBe(2),expect(o.data("diff-fragment-view")).toBeTruthy(),expect(o.html()).toBe("<span>áéíóú 🔥</span>"),expect(a.data("diff-fragment-view")).toBeTruthy(),expect(a.html()).toBe("<span>ÄËÏÖÜŸ 😱</span>"),expect(s.data("diff-fragment-view")).toBeTruthy(),expect(s.html()).toBe("<span>🔥😱</span>"),expect(c.data("diff-fragment-view")).toBeTruthy(),expect(c.html()).toBe("<span>ĀĒĪŌ 👿</span>"),e()})}),it("With saved fragments",function(e){spyOn($,"ajax").and.callFake(function(e){expect(e.dataType).toBe("arraybuffer");var t=e.url;let i;if(t===r+"124/"){var n=new Blob(["<span>New comment 2</span>"]);i=RB.DataUtils.buildBlob([[{type:"uint32",values:[124,n.size]}],n])}else{if(t!==r+"126/")return void fail("Unexpected URL "+t);n=new Blob(["<span>New comment 4</span>"]);i=RB.DataUtils.buildBlob([[{type:"uint32",values:[126,n.size]}],n])}RB.DataUtils.readBlobAsArrayBuffer(i,e.success)});const t=new RB.DiffFragmentView,i=(o.html("<span>Comment 1</span>").data("diff-fragment-view",t),new RB.DiffFragmentView),n=(a.html("<span>Comment 2</span>").data("diff-fragment-view",i),new RB.DiffFragmentView);s.html("<span>Comment 3</span>").data("diff-fragment-view",n),l.saveFragment("123"),l.saveFragment("125"),l.saveFragment("126"),s.removeData("diff-fragment-view"),l.loadFragments(()=>{expect($.ajax.calls.count()).toBe(2),expect(o.data("diff-fragment-view")).toBe(t),expect(o.html()).toBe("<span>Comment 1</span>"),expect(a.data("diff-fragment-view")).toBe(i),expect(a.html()).toBe("<span>New comment 2</span>"),expect(s.data("diff-fragment-view")).toBeTruthy(),expect(s.data("diff-fragment-view")).not.toBe(n),expect(s.html()).toBe("<span>Comment 3</span>"),expect(c.data("diff-fragment-view")).toBeTruthy(),expect(c.html()).toBe("<span>New comment 4</span>"),expect(l._saved).toEqual({}),e()})})})}),suite("rb/views/DiffFragmentView",function(){const e=_.template(`<table>
 <thead>
 </thead>
 <tbody class="diff-header diff-header-above">
  <tr>
   <td>
    <div>
     <a href="#" class="diff-expand-btn"
        data-lines-of-context="20,0"></a>
    </div>
   </td>
  </tr>
 </tbody>
 <tbody class="insert"></tbody>
 <tbody class="insert">
  <tr>
   <td>
    <div class="rb-c-diff-collapse-button" role="button" tabindex="0"
         data-lines-of-context="0,0"></div>
   </td>
  </tr>
 </tbody>
 <tbody class="diff-header diff-header-below">
  <tr>
   <td>
    <div>
     <a href="#" class="diff-expand-btn"
        data-lines-of-context="0,20"></a>
    </div>
   </td>
  </tr>
 </tbody>
</table>`);let i,t;beforeEach(function(){t=jasmine.createSpy("loadDiff"),(i=new RB.DiffFragmentView({loadDiff:t,collapsible:!0})).$el.html(e()),$testsScratch.append(i.$el),spyOn(_,"defer").and.callFake(e=>e()),spyOn(_,"delay").and.callFake(e=>e())}),describe("render",function(){it("With visible and collapsible === true",function(){i.render(),expect(i.$el.hasClass("allow-transitions")).toBe(!0),expect(i._$table.hasClass("expanded")).toBe(!1),expect(i._$table.hasClass("collapsed")).toBe(!0),expect(i._$thead.css("transform")).not.toBe("none"),_.each(i._$diffHeaders,e=>{expect($(e).css("transform")).not.toBe("none")})}),it("With hidden and collapsible === true",function(){i.$el.hide(),i.render(),expect(i.$el.hasClass("allow-transitions")).toBe(!0),expect(i._$table.hasClass("expanded")).toBe(!0),expect(i._$table.hasClass("collapsed")).toBe(!1),expect(i._$thead.css("transform")).toBe("none"),_.each(i._$diffHeaders,e=>{expect($(e).css("transform")).toBe("none")})}),it("With collapsible === false",function(){i._collapsible=!1,i.render(),expect(i.$el.hasClass("allow-transitions")).toBe(!1),expect(i._$table.hasClass("expanded")).toBe(!0),expect(i._$table.hasClass("collapsed")).toBe(!1),expect(i._$thead.css("transform")).toBe("none"),_.each(i._$diffHeaders,e=>{expect($(e).css("transform")).toBe("none")})})}),describe("Events",function(){it("click expansion button",function(){i.render(),i.$(".diff-expand-btn").eq(0).click(),expect(t).toHaveBeenCalled(),expect(t.calls.mostRecent().args[0].linesOfContext).toBe("20,0")}),it("click collapse button",function(){i.render(),i.$(".rb-c-diff-collapse-button").eq(0).click(),expect(t).toHaveBeenCalled(),expect(t.calls.mostRecent().args[0].linesOfContext).toBe("0,0")}),describe("mouseenter",function(){it("With collapsible === true",function(){i.render(),spyOn(i.$el,"is").and.callFake(e=>(expect(e).toBe(":hover"),!0)),i.$el.trigger("mouseenter"),expect(i._$table.hasClass("collapsed")).toBe(!1),expect(i._$table.hasClass("expanded")).toBe(!0),expect(i._$thead.css("transform")).toBe("none"),_.each(i._$diffHeaders,e=>{expect($(e).css("transform")).toBe("none")})}),it("With collapsible === false",function(){i._collapsible=!1,i.render(),spyOn(i.$el,"is").and.callFake(e=>(expect(e).toBe(":hover"),!0)),i.$el.trigger("mouseenter"),expect(i._$table.hasClass("collapsed")).toBe(!1),expect(i._$table.hasClass("expanded")).toBe(!0),expect(i._$thead.css("transform")).toBe("none"),_.each(i._$diffHeaders,e=>{expect($(e).css("transform")).toBe("none")})})}),describe("mouseleave",function(){it("With collapsible === true",function(){let t=!0;i.render(),spyOn(i.$el,"is").and.callFake(e=>(expect(e).toBe(":hover"),t)),i.$el.trigger("mouseenter"),t=!1,i.$el.trigger("mouseleave"),expect(i._$table.hasClass("collapsed")).toBe(!0),expect(i._$table.hasClass("expanded")).toBe(!1),expect(i._$thead.css("transform")).not.toBe("none"),_.each(i._$diffHeaders,e=>{expect($(e).css("transform")).not.toBe("none")})}),it("With collapsible === false",function(){let t=!0;i._collapsible=!1,i.render(),spyOn(i.$el,"is").and.callFake(e=>(expect(e).toBe(":hover"),t)),i.$el.trigger("mouseenter"),t=!1,i.$el.trigger("mouseleave"),expect(i._$table.hasClass("collapsed")).toBe(!1),expect(i._$table.hasClass("expanded")).toBe(!0),expect(i._$thead.css("transform")).toBe("none"),_.each(i._$diffHeaders,e=>{expect($(e).css("transform")).toBe("none")})})})})}),suite("rb/views/DraftReviewBannerView",function(){let i,n;beforeEach(function(){var e=$(`<div id="review-banner" hidden class="hidden">
 <div class="banner">
  <h1>You have a pending review.</h1>
  <input id="review-banner-edit" type="button"
         value="Edit Review">
  <div id="review-banner-publish-container"></div>
  <input id="review-banner-discard" type="button"
         value="Discard">
 </div>
</div>'`).appendTo($testsScratch);i=new RB.DraftReview,(n=new RB.DraftReviewBannerView({el:e,model:i})).render()}),afterEach(function(){n.remove()}),describe("Button states",function(){let e;beforeEach(function(){e=n.$("input")}),describe("Enabled",function(){it("Default",function(){expect(e.prop("disabled")).toBe(!1)}),it("When saved",function(){e.prop("disabled",!0),i.trigger("saved"),expect(e.prop("disabled")).toBe(!1)}),it("When destroyed",function(){e.prop("disabled",!0),i.trigger("destroyed"),expect(e.prop("disabled")).toBe(!1)})}),describe("Disabled",function(){it("When saving",function(){i.trigger("saving"),expect(e.prop("disabled")).toBe(!0)}),it("When destroying",function(){i.trigger("destroying"),expect(e.prop("disabled")).toBe(!0)})})}),describe("Button events",function(){it("Edit Review",function(){spyOn(RB.ReviewDialogView,"create"),n.$("#review-banner-edit").click(),expect(RB.ReviewDialogView.create).toHaveBeenCalled(),expect(RB.ReviewDialogView.create.calls.argsFor(0)[0].review).toBe(i)}),it("Publish",function(){spyOn(i,"publish"),n.$(".rb-c-menu-button__primary").click(),expect(i.publish).toHaveBeenCalled()}),it("Publish to Submitter Only",function(){spyOn(i,"publish"),$("#review-banner-publish-submitter-only").click(),expect(i.publish).toHaveBeenCalled()}),it("Publish and Archive",function(){spyOn(i,"publish"),spyOn(n,"_onPublishClicked").and.callThrough(),$("#review-banner-publish-and-archive").click(),expect(i.publish).toHaveBeenCalled(),expect(n._onPublishClicked).toHaveBeenCalledWith({publishAndArchive:!0})}),it("Discard",function(){let t=$();spyOn(i,"destroy"),spyOn($.fn,"modalBox").and.callFake(e=>(e.buttons.forEach(e=>{t=t.add(e)}),{modalBox:e=>(expect(e).toBe("buttons"),t)})),n.$("#review-banner-discard").click(),expect($.fn.modalBox).toHaveBeenCalled(),t.filter('input[value="Discard"]').click(),expect(i.destroy).toHaveBeenCalled()})}),describe("Methods",function(){it("show",function(){expect(n.$el.hasClass("hidden")).toBe(!0),expect(n.$el.prop("hidden")).toBe(!0),n.show(),expect(n.$el.hasClass("hidden")).toBe(!1),expect(n.$el.prop("hidden")).toBe(!1)}),it("hide",function(){n.$el.addClass("hidden").prop("hidden",!0),n.hide(),expect(n.$el.hasClass("hidden")).toBe(!0),expect(n.$el.prop("hidden")).toBe(!0)})})}),suite("rb/views/ScreenshotThumbnail",function(){let t,i;beforeEach(function(){(t=new RB.Screenshot).url="/screenshots/123/",t.id=123,t.attributes.id=123,t.set("loaded",!0);(i=new RB.ScreenshotThumbnail({el:$('<div><a class="edit"></a><a class="delete">X</a></div>').appendTo($testsScratch),model:t})).render(),spyOn(t,"trigger").and.callThrough(),spyOn(i,"trigger").and.callThrough()}),describe("Actions",function(){it("Begin caption editing",function(){i._captionEditorView.startEdit(),expect(i.trigger).toHaveBeenCalledWith("beginEdit")}),it("Cancel caption editing",function(){i._captionEditorView.startEdit(),expect(i.trigger).toHaveBeenCalledWith("beginEdit"),i._captionEditorView.cancel(),expect(i.trigger).toHaveBeenCalledWith("endEdit")}),it("Save caption",function(e){spyOn(t,"save"),i._captionEditorView.startEdit(),expect(i.trigger).toHaveBeenCalledWith("beginEdit"),i.$el.find("input").val("Foo").triggerHandler("keyup"),i._captionEditorView.submit(),_.defer(()=>{expect(i.trigger).toHaveBeenCalledWith("endEdit"),expect(t.get("caption")).toBe("Foo"),expect(t.save).toHaveBeenCalled(),e()})}),it("Delete",function(e){spyOn(t,"destroy").and.callThrough(),spyOn($,"ajax").and.callFake(e=>e.success()),spyOn(i.$el,"fadeOut").and.callFake(e=>e()),spyOn(i,"remove").and.callFake(()=>{expect($.ajax).toHaveBeenCalled(),expect(t.destroy).toHaveBeenCalled(),expect(t.trigger.calls.argsFor(0)[0]).toBe("destroying"),expect(i.$el.fadeOut).toHaveBeenCalled(),e()}),i.$el.find("a.delete").click()})})}),suite("rb/views/UploadAttachmentView",function(){let n;beforeEach(function(){n=new RB.ReviewRequest({summary:"My Review Request",reviewURL:"/r/1/"})}),describe("Instances",function(){let i;afterEach(function(){i&&(i.hide(),i=null)}),describe("Buttons",function(){beforeEach(function(){i=new RB.UploadAttachmentView({reviewRequest:n})}),describe("Cancel",function(){let e;beforeEach(function(){i.show(),e=i.$buttonsMap.cancel,expect(e.length).toBe(1)}),it("Enabled by default",function(){expect(e.is(":disabled")).toBe(!1)}),it("Closes dialog when clicked",function(){spyOn($.fn,"modalBox").and.callThrough(),i.delegateEvents(),e.click(),expect($.fn.modalBox).toHaveBeenCalledWith("destroy")})}),describe("Upload",function(){let e,t;beforeEach(function(){spyOn(i,"send"),i.show(),e=i.$buttonsMap.upload,(t=i._$path).attr("type","text"),spyOn(i,"updateUploadButtonEnabledState").and.callThrough(),i.delegateEvents(),expect(e.length).toBe(1)}),it("Disabled by default until a file is uploaded",function(){expect(e.is(":disabled")).toBe(!0)}),it("Enabled when a file is uploaded",function(){expect(e.is(":disabled")).toBe(!0),t.val("fakefile").trigger("change"),expect(i.updateUploadButtonEnabledState).toHaveBeenCalledTimes(1),expect(e.is(":disabled")).toBe(!1)}),it("Disabled when an uploaded file is removed",function(){t.val("fakefile").trigger("change").val("").trigger("change"),expect(i.updateUploadButtonEnabledState).toHaveBeenCalledTimes(2),expect(e.is(":disabled")).toBe(!0)}),it("Uploads the file attachment",function(){expect(e.is(":disabled")).toBe(!0),t.val("fakefile").trigger("change"),expect(i.updateUploadButtonEnabledState).toHaveBeenCalled(),expect(e.is(":disabled")).toBe(!1),e.click(),expect(i.send).toHaveBeenCalled()})})}),it("Dialog for updating an existing file attachment",function(){(i=new RB.UploadAttachmentView({attachmentHistoryID:14,presetCaption:"fakecaption",reviewRequest:n})).show();var e=i.$('[name="caption"]'),t=i.$('[name="attachment_history"]');expect(e.length).toBe(1),expect(e.val()).toBe("fakecaption"),expect(t.length).toBe(1),expect(t.val()).toBe("14")})})})}.call(this);
