from datetime import datetime
from pyshop.base import BaseClient

class Collections(BaseClient):
    collection_path = "/collection"

    def __init__(self, *args, **kwargs):
        super(Collections, self).__init__(*args, **kwargs)

    def list_collections(self):
        count_path = self.collection_path + ".json"
        return self._get(path=count_path)

    def get_collection(self, item_id: str = "any"):
        item_path = self.collection_path + f"/{item_id}.json"
        return self._get(path=item_path)

    def get_collection_orders(self):
        item_level = self.collection_path + f".json"
        return self._get(path=item_level)

    def count_collections(self):
        raise NotImplementedError("Collections Adjustment Not Implemented.")

    def search_collection(self):
        raise NotImplementedError("Set Collections Level Not Implemented.")

    # Addresses
    def list_collection_addresses(self):
        raise NotImplementedError("Set Collections Level Not Implemented.")

    def get_collection_address(self):
        raise NotImplementedError("Set Collections Level Not Implemented.")

    def set_collection_address(self):
        raise NotImplementedError("Set Collections Level Not Implemented.")

    def set_collection_default_address(self):
        raise NotImplementedError("Set Collections Level Not Implemented.")

    def delete_collection_address(self):
        raise NotImplementedError("Set Collections Level Not Implemented.")

