/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.dbspec.basic.DbFunctionPackage;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbIndex;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbObject;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSchema
extends DbObject<DbObject<?>> {
    private final DbSpec _spec;
    private final List<DbTable> _tables = new ArrayList<DbTable>();
    private final List<DbIndex> _indexes = new ArrayList<DbIndex>();
    private final List<DbFunctionPackage> _functionPackages = new ArrayList<DbFunctionPackage>();

    public DbSchema(DbSpec spec, String name) {
        super(null, name);
        this._spec = spec;
    }

    @Override
    public DbSpec getSpec() {
        return this._spec;
    }

    public List<DbTable> getTables() {
        return this._tables;
    }

    public List<DbIndex> getIndexs() {
        return this._indexes;
    }

    public List<DbFunctionPackage> getFunctionPackages() {
        return this._functionPackages;
    }

    public DbTable findTable(String name) {
        return DbSchema.findObject(this._tables, name);
    }

    public DbTable addTable(String name) {
        DbTable table = this.getSpec().createTable(this, name);
        return this.addTable(table);
    }

    public <T extends DbTable> T addTable(T table) {
        this._tables.add(this.checkOwnership(table));
        return table;
    }

    public DbIndex findIndex(String name) {
        return DbSchema.findObject(this._indexes, name);
    }

    public DbIndex addIndex(String name, String tableName, String ... colNames) {
        DbIndex index = this.getSpec().createIndex(this.findTable(tableName), name, colNames);
        return this.addIndex(index);
    }

    public <T extends DbIndex> T addIndex(T index) {
        this._indexes.add(this.checkOwnership(index));
        return index;
    }

    public DbFunctionPackage getDefaultFunctionPackage() {
        return this.findFunctionPackage(null);
    }

    public DbFunctionPackage findFunctionPackage(String name) {
        return DbObject.findObject(this._functionPackages, name);
    }

    public DbFunctionPackage addDefaultFunctionPackage() {
        return this.addFunctionPackage((String)null);
    }

    public DbFunctionPackage addFunctionPackage(String name) {
        DbFunctionPackage functionPackage = this.getSpec().createFunctionPackage(this, name);
        return this.addFunctionPackage(functionPackage);
    }

    public <T extends DbFunctionPackage> T addFunctionPackage(T functionPackage) {
        this._functionPackages.add(this.checkOwnership(functionPackage));
        return functionPackage;
    }
}

