/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference.mpe;

import java.util.List;
import java.util.Set;
import org.linqs.psl.application.inference.mpe.MPEInference;
import org.linqs.psl.application.learning.weight.TrainingMap;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.atom.LazyAtomManager;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.evaluation.statistics.Evaluator;
import org.linqs.psl.grounding.Grounding;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyMPEInference
extends MPEInference {
    private static final Logger log = LoggerFactory.getLogger(LazyMPEInference.class);
    protected final int maxRounds = Options.LAZY_INFERENCE_MAX_ROUNDS.getInt();

    public LazyMPEInference(List<Rule> rules, Database db) {
        super(rules, db);
    }

    @Override
    protected void completeInitialize() {
        log.debug("Initial grounding.");
        Grounding.groundAll(this.rules, (AtomManager)this.atomManager, this.groundRuleStore);
        log.debug("Initial grounding complete.");
    }

    @Override
    protected PersistedAtomManager createAtomManager(Database db) {
        return new LazyAtomManager(db);
    }

    @Override
    protected double internalInference(List<Evaluator> evaluators, TrainingMap trainingMap, Set<StandardPredicate> evaluationPredicates) {
        LazyAtomManager lazyAtomManager = (LazyAtomManager)this.atomManager;
        int rounds = 0;
        int numActivated = 0;
        double objective = 0.0;
        do {
            log.debug("Starting round {} of inference.", (Object)(++rounds));
            this.termStore.clear();
            log.debug("Initializing objective terms for {} ground rules.", (Object)this.groundRuleStore.size());
            this.termStore.ensureVariableCapacity(lazyAtomManager.getCachedRVACount());
            long termCount = this.termGenerator.generateTerms(this.groundRuleStore, this.termStore);
            log.debug("Generated {} objective terms from {} ground rules.", (Object)termCount, (Object)this.groundRuleStore.size());
            log.info("Beginning inference round {}.", (Object)rounds);
            objective = this.reasoner.optimize(this.termStore, evaluators, trainingMap, evaluationPredicates);
            log.info("Inference round {} complete.", (Object)rounds);
            numActivated = lazyAtomManager.activateAtoms(this.rules, this.groundRuleStore);
            log.debug("Completed round {} and activated {} atoms.", (Object)rounds, (Object)numActivated);
        } while (numActivated > 0 && rounds < this.maxRounds);
        return objective;
    }
}

