/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference.online;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.linqs.psl.application.inference.online.messages.OnlineMessage;
import org.linqs.psl.application.inference.online.messages.actions.controls.Exit;
import org.linqs.psl.application.inference.online.messages.actions.controls.Stop;
import org.linqs.psl.application.inference.online.messages.responses.ActionStatus;
import org.linqs.psl.application.inference.online.messages.responses.OnlineResponse;
import org.linqs.psl.config.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineServer {
    private static final Logger log = LoggerFactory.getLogger(OnlineServer.class);
    private boolean listening = false;
    private ServerConnectionThread serverThread = new ServerConnectionThread();
    private Set<ClientConnectionThread> clientConnectionThreads;
    private BlockingQueue<OnlineMessage> queue = new LinkedBlockingQueue<OnlineMessage>();
    private ConcurrentMap<UUID, ClientConnectionThread> messageIDConnectionMap = new ConcurrentHashMap<UUID, ClientConnectionThread>();

    public OnlineServer() {
        this.clientConnectionThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public void start() {
        this.listening = true;
        this.serverThread.start();
        this.serverThread.blockUntilReady();
    }

    public OnlineMessage getAction() {
        OnlineMessage nextAction = null;
        do {
            try {
                nextAction = this.queue.take();
            }
            catch (InterruptedException ex) {
                log.warn("Interrupted while taking an online action from the queue.", ex);
                return null;
            }
            if (!(nextAction instanceof Exit)) continue;
            this.onActionExecution(nextAction, new ActionStatus(nextAction, true, "Session Closed."));
            nextAction = null;
        } while (nextAction == null);
        return nextAction;
    }

    public void onActionExecution(OnlineMessage action, OnlineResponse onlineResponse) {
        ClientConnectionThread clientConnectionThread = (ClientConnectionThread)this.messageIDConnectionMap.get(action.getIdentifier());
        ObjectOutputStream outputStream = clientConnectionThread.outputStream;
        try {
            outputStream.writeObject(onlineResponse);
        }
        catch (IOException ex) {
            log.warn(String.format("Failed to send client onlineResponse: %s", onlineResponse), ex);
        }
        if (action instanceof Exit || action instanceof Stop) {
            this.closeClient(clientConnectionThread);
        }
        if (onlineResponse instanceof ActionStatus) {
            this.messageIDConnectionMap.remove(action.getIdentifier());
        }
    }

    public void closeClient(ClientConnectionThread clientConnectionThread) {
        clientConnectionThread.close();
        this.clientConnectionThreads.remove(clientConnectionThread);
    }

    public void addClient(ClientConnectionThread clientConnectionThread) {
        this.clientConnectionThreads.add(clientConnectionThread);
    }

    public void close() {
        this.listening = false;
        if (this.serverThread != null) {
            this.serverThread.close();
            this.serverThread = null;
        }
        if (this.clientConnectionThreads != null) {
            for (ClientConnectionThread clientConnection : this.clientConnectionThreads) {
                this.closeClient(clientConnection);
            }
            this.clientConnectionThreads = null;
        }
        if (this.queue != null) {
            this.queue.clear();
            this.queue = null;
        }
    }

    private class ClientConnectionExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ClientConnectionExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            if (!(thread instanceof ClientConnectionThread)) {
                throw new RuntimeException("ClientConnectionExceptionHandler can only be used by ClientConnectionThreads.", ex);
            }
            log.warn(String.format("Uncaught exception in ClientConnectionThread.  Exception message: %s", ex.getMessage()));
            ClientConnectionThread clientConnectionThread = (ClientConnectionThread)thread;
            OnlineServer.this.closeClient(clientConnectionThread);
        }
    }

    private class ClientConnectionThread
    extends Thread {
        public Socket socket;
        public ObjectInputStream inputStream;
        public ObjectOutputStream outputStream;

        public ClientConnectionThread(Socket socket) {
            this.socket = socket;
            this.setUncaughtExceptionHandler(new ClientConnectionExceptionHandler());
        }

        private void initializeConnection() {
            try {
                this.inputStream = new ObjectInputStream(this.socket.getInputStream());
                this.outputStream = new ObjectOutputStream(this.socket.getOutputStream());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            OnlineMessage newAction = null;
            this.initializeConnection();
            while (true) {
                try {
                    newAction = (OnlineMessage)this.inputStream.readObject();
                    log.trace(String.format("Server received action from client: %s", newAction));
                }
                catch (EOFException ex) {
                    throw new RuntimeException("Client closed socket without Exit or Stop action.", ex);
                }
                catch (IOException ex) {
                    if (this.socket.isClosed()) return;
                    throw new RuntimeException(ex);
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Failed to deserialized last OnlineMessage from client.");
                    continue;
                }
                try {
                    OnlineServer.this.messageIDConnectionMap.put(newAction.getIdentifier(), this);
                    OnlineServer.this.queue.put(newAction);
                }
                catch (InterruptedException ex) {
                    continue;
                }
                if (newAction instanceof Exit || newAction instanceof Stop) return;
            }
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ServerConnectionThread
    extends Thread {
        private int port = Options.ONLINE_PORT_NUMBER.getInt();
        private ServerSocket socket = null;
        private Semaphore readyLock = new Semaphore(1);

        public ServerConnectionThread() {
            try {
                this.readyLock.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unable to acquire a new lock.", ex);
            }
        }

        private void openListenSocket() {
            try {
                this.socket = new ServerSocket(this.port);
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("Could not establish socket on port %s.", this.port));
            }
        }

        public void blockUntilReady() {
            try {
                this.readyLock.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unable to acquire ready lock.", ex);
            }
            this.readyLock.release();
        }

        @Override
        public void run() {
            Socket client = null;
            ClientConnectionThread connectionThread = null;
            this.openListenSocket();
            this.readyLock.release();
            log.info(String.format("Online server started on port %s.", this.port));
            while (OnlineServer.this.listening) {
                try {
                    client = this.socket.accept();
                }
                catch (IOException ex) {
                    if (this.socket.isClosed()) continue;
                    throw new RuntimeException(ex);
                }
                connectionThread = new ClientConnectionThread(client);
                OnlineServer.this.addClient(connectionThread);
                connectionThread.start();
            }
        }

        public void close() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

