/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.search.grid;

import java.util.Iterator;
import java.util.List;
import org.linqs.psl.application.learning.weight.search.grid.BaseGridSearch;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.MathUtils;
import org.linqs.psl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankSearch
extends BaseGridSearch {
    private static final Logger log = LoggerFactory.getLogger(RankSearch.class);
    public static final String DELIM = ":";
    private Iterator<int[]> permutationIterator;
    private int[] scaleFactors = StringUtils.splitInt(Options.WLA_RS_SCALING_FACTORS.getString(), ":");
    private int scaleIndex;

    public RankSearch(Model model, Database rvDB, Database observedDB) {
        this(model.getRules(), rvDB, observedDB);
    }

    public RankSearch(List<Rule> rules, Database rvDB, Database observedDB) {
        super(rules, rvDB, observedDB);
        if (this.scaleFactors.length == 0) {
            throw new IllegalArgumentException("No scaling factors provided.");
        }
        this.scaleIndex = 0;
        this.numLocations = this.maxNumLocations = MathUtils.smallFactorial(this.mutableRules.size()) * this.scaleFactors.length;
        this.permutationIterator = IteratorUtils.permutations(this.mutableRules.size());
    }

    @Override
    protected void getWeights(float[] weights) {
        int[] ranks = StringUtils.splitInt(this.currentLocation, DELIM);
        assert (ranks.length == this.mutableRules.size() + 1);
        int scale = ranks[0];
        for (int i = 0; i < this.mutableRules.size(); ++i) {
            weights[i] = (float)scale * (1.0f + (float)ranks[i + 1]);
        }
    }

    @Override
    protected boolean chooseNextLocation() {
        if (!this.permutationIterator.hasNext()) {
            if (this.scaleIndex == this.scaleFactors.length - 1) {
                return false;
            }
            ++this.scaleIndex;
            this.permutationIterator = IteratorUtils.permutations(this.mutableRules.size());
        }
        int[] indexes = this.permutationIterator.next();
        this.currentLocation = "" + this.scaleIndex + DELIM + StringUtils.join(DELIM, indexes);
        return true;
    }
}

