/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.atom;

import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.reasoner.InitialValue;

public class OnlineAtomManager
extends PersistedAtomManager {
    private Set<GroundAtom> newObservedAtoms;
    private Set<GroundAtom> newRandomVariableAtoms;
    private InitialValue initialValue;
    private int onlineReadPartition;

    public OnlineAtomManager(Database database, InitialValue initialValue) {
        super(database);
        if (!(database instanceof RDBMSDatabase)) {
            throw new IllegalArgumentException("OnlineAtomManagers require RDBMSDatabase.");
        }
        this.newObservedAtoms = new HashSet<GroundAtom>();
        this.newRandomVariableAtoms = new HashSet<GroundAtom>();
        this.onlineReadPartition = Options.ONLINE_READ_PARTITION.getInt();
        if (this.onlineReadPartition < 0) {
            this.onlineReadPartition = database.getReadPartitions().get(0).getID();
        }
        this.initialValue = initialValue;
    }

    public ObservedAtom addObservedAtom(StandardPredicate predicate, float value, Constant ... arguments) {
        ObservedAtom atom = this.db.getCache().instantiateObservedAtom(predicate, arguments, value);
        this.newObservedAtoms.add(atom);
        return atom;
    }

    public RandomVariableAtom addRandomVariableAtom(StandardPredicate predicate, float value, Constant ... arguments) {
        RandomVariableAtom atom = this.db.getCache().instantiateRandomVariableAtom(predicate, arguments, value);
        atom.setValue(this.initialValue.getVariableValue(atom));
        this.addToPersistedCache(atom);
        this.newRandomVariableAtoms.add(atom);
        return atom;
    }

    public boolean hasAtom(StandardPredicate predicate, Constant ... arguments) {
        return this.db.hasAtom(predicate, arguments);
    }

    public GroundAtom deleteAtom(StandardPredicate predicate, Constant ... arguments) {
        GroundAtom atom = null;
        if (this.db.hasAtom(predicate, arguments)) {
            atom = this.db.getAtom((Predicate)predicate, arguments);
            ((RDBMSDatabase)this.db).deleteAtomAllPartitions(atom);
            if (atom instanceof RandomVariableAtom) {
                --this.persistedAtomCount;
                this.newRandomVariableAtoms.remove(atom);
            } else {
                this.newObservedAtoms.remove(atom);
            }
        }
        return atom;
    }

    @Override
    public GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        GroundAtom atom = super.getAtom(predicate, arguments);
        if (atom instanceof RandomVariableAtom && !this.db.hasAtom(((RandomVariableAtom)atom).getPredicate(), atom.getArguments())) {
            atom = null;
        }
        return atom;
    }

    @Override
    public void reportAccessException(RuntimeException ex, GroundAtom offendingAtom) {
        if (offendingAtom instanceof RandomVariableAtom) {
            this.deleteAtom(((RandomVariableAtom)offendingAtom).getPredicate(), offendingAtom.getArguments());
        }
    }

    public int getOnlineReadPartition() {
        return this.onlineReadPartition;
    }

    public synchronized Boolean hasNewAtoms() {
        return this.newRandomVariableAtoms.size() > 0 || this.newObservedAtoms.size() > 0;
    }

    public Set<GroundAtom> flushNewObservedAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>(this.newObservedAtoms);
        this.newObservedAtoms.clear();
        return atoms;
    }

    public Set<GroundAtom> flushNewRandomVariableAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>(this.newRandomVariableAtoms);
        this.newRandomVariableAtoms.clear();
        return atoms;
    }
}

