/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.rdbms.QueryRewriter;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.Parallel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grounding {
    private static final Logger log = LoggerFactory.getLogger(Grounding.class);

    private Grounding() {
    }

    public static long groundAll(Model model, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        return Grounding.groundAll(model.getRules(), atomManager, groundRuleStore);
    }

    public static long groundAllSerial(List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        long groundCount = 0L;
        for (Rule rule : rules) {
            groundCount += rule.groundAll(atomManager, groundRuleStore);
        }
        return groundCount;
    }

    public static long groundAll(List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        boolean rewrite = Options.GROUNDING_REWRITE_QUERY.getBoolean();
        boolean serial = Options.GROUNDING_SERIAL.getBoolean();
        HashMap queries = new HashMap();
        ArrayList<Rule> bypassRules = new ArrayList<Rule>();
        DataStore dataStore = atomManager.getDatabase().getDataStore();
        if (rewrite && !(dataStore instanceof RDBMSDataStore)) {
            log.warn("Cannot rewrite queries with a non-RDBMS DataStore. Queries will not be rewritten.");
            rewrite = false;
        }
        QueryRewriter rewriter = null;
        if (rewrite) {
            rewriter = new QueryRewriter();
        }
        for (Rule rule : rules) {
            if (!rule.supportsGroundingQueryRewriting()) {
                bypassRules.add(rule);
                continue;
            }
            Formula query = rule.getRewritableGroundingFormula();
            if (rewrite) {
                query = rewriter.rewrite(query, (RDBMSDataStore)dataStore);
            }
            if (!queries.containsKey(query)) {
                queries.put(query, new ArrayList());
            }
            ((List)queries.get(query)).add(rule);
        }
        long initialSize = groundRuleStore.size();
        for (Map.Entry entry : queries.entrySet()) {
            if (!serial) {
                Grounding.groundParallel((Formula)entry.getKey(), (List)entry.getValue(), atomManager, groundRuleStore);
                continue;
            }
            for (Rule rule : (List)entry.getValue()) {
                ArrayList<Rule> tempRules = new ArrayList<Rule>();
                tempRules.add(rule);
                Grounding.groundParallel((Formula)entry.getKey(), tempRules, atomManager, groundRuleStore);
            }
        }
        Grounding.groundAllSerial(bypassRules, atomManager, groundRuleStore);
        return groundRuleStore.size() - initialSize;
    }

    private static long groundParallel(Formula query, List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        log.debug("Grounding {} rule(s) with query: [{}].", (Object)rules.size(), (Object)query);
        for (Rule rule : rules) {
            log.debug("    " + rule);
        }
        boolean oldAccessExceptionState = atomManager.enableAccessExceptions(false);
        long initialCount = groundRuleStore.size();
        QueryResultIterable queryResults = atomManager.executeGroundingQuery(query);
        Parallel.RunTimings timings = Parallel.foreach(queryResults, new GroundWorker(atomManager, groundRuleStore, queryResults.getVariableMap(), rules));
        long groundCount = groundRuleStore.size() - initialCount;
        atomManager.enableAccessExceptions(oldAccessExceptionState);
        log.debug("Generated {} ground rules from {} query results.", (Object)groundCount, (Object)timings.iterations);
        return groundCount;
    }

    private static class GroundWorker
    extends Parallel.Worker<Constant[]> {
        private AtomManager atomManager;
        private GroundRuleStore groundRuleStore;
        private Map<Variable, Integer> variableMap;
        private List<Rule> rules;
        private List<GroundRule> groundRules;

        public GroundWorker(AtomManager atomManager, GroundRuleStore groundRuleStore, Map<Variable, Integer> variableMap, List<Rule> rules) {
            this.atomManager = atomManager;
            this.groundRuleStore = groundRuleStore;
            this.variableMap = variableMap;
            this.rules = rules;
            this.groundRules = new ArrayList<GroundRule>();
        }

        public Object clone() {
            return new GroundWorker(this.atomManager, this.groundRuleStore, this.variableMap, this.rules);
        }

        @Override
        public void work(long index, Constant[] row) {
            for (Rule rule : this.rules) {
                rule.ground(row, this.variableMap, this.atomManager, this.groundRules);
                for (GroundRule groundRule : this.groundRules) {
                    if (groundRule == null) continue;
                    this.groundRuleStore.addGroundRule(groundRule);
                }
                this.groundRules.clear();
            }
        }
    }
}

