/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SupportingModel {
    private static final Logger log = LoggerFactory.getLogger(SupportingModel.class);
    protected static final String DELIM = "\t";
    protected static final String CONFIG_FEATURES = "features";
    protected static final String CONFIG_LABELS = "labels";
    protected static final String CONFIG_MODEL = "model";
    protected static final String CONFIG_OBSERVATIONS = "observations";
    protected int[] entityArgumentIndexes;
    protected int[] labelArgumentIndexes;
    protected Map<String, Integer> entityIndexMapping = null;
    protected Map<String, Integer> labelIndexMapping = null;
    private int numFeatures = -1;
    protected float[][] manualLabels = null;
    protected Map<Integer, float[]> observedLabels = new HashMap<Integer, float[]>();

    public void close() {
        if (this.entityIndexMapping != null) {
            this.entityIndexMapping.clear();
            this.entityIndexMapping = null;
        }
        if (this.labelIndexMapping != null) {
            this.labelIndexMapping.clear();
            this.labelIndexMapping = null;
        }
        if (this.observedLabels != null) {
            this.observedLabels.clear();
            this.observedLabels = null;
        }
        this.entityArgumentIndexes = null;
        this.labelArgumentIndexes = null;
        this.numFeatures = -1;
        this.manualLabels = null;
    }

    public SupportingModel() {
        this.entityArgumentIndexes = StringUtils.splitInt(Options.MODEL_PREDICATE_ENTITY_ARGS.getString(), ",");
        this.labelArgumentIndexes = StringUtils.splitInt(Options.MODEL_PREDICATE_LABEL_ARGS.getString(), ",");
    }

    public abstract void load(Map<String, String> var1, String var2);

    public abstract float getValue(RandomVariableAtom var1, int var2, int var3);

    public abstract void run();

    public abstract void fit();

    public abstract void initialFit();

    public int numFeatures() {
        return this.numFeatures;
    }

    public int numLabels() {
        return this.labelIndexMapping.size();
    }

    public float getValue(RandomVariableAtom atom) {
        AtomIndexes indexes = this.getAtomIndexes(atom);
        if (indexes == null) {
            return 0.0f;
        }
        return this.getValue(atom, indexes.entityIndex, indexes.labelIndex);
    }

    public void resetLabels() {
        for (int i = 0; i < this.manualLabels.length; ++i) {
            if (this.observedLabels.containsKey(i)) {
                float[] labels = this.observedLabels.get(i);
                for (int j = 0; j < labels.length; ++j) {
                    this.manualLabels[i][j] = labels[j];
                }
                continue;
            }
            for (int j = 0; j < this.manualLabels[i].length; ++j) {
                this.manualLabels[i][j] = 0.0f;
            }
        }
    }

    public float getLabel(RandomVariableAtom atom) {
        AtomIndexes indexes = this.getAtomIndexes(atom);
        if (indexes == null) {
            return 0.0f;
        }
        return this.manualLabels[indexes.entityIndex][indexes.labelIndex];
    }

    public void setLabel(RandomVariableAtom atom, float labelValue) {
        AtomIndexes indexes = this.getAtomIndexes(atom);
        if (indexes == null) {
            return;
        }
        this.manualLabels[indexes.entityIndex][indexes.labelIndex] = labelValue;
    }

    protected void loadLabels(String path) {
        log.debug("Loading labels for {} from {}", (Object)this, (Object)path);
        this.labelIndexMapping = new HashMap<String, Integer>();
        try (BufferedReader reader = FileUtils.getBufferedReader(path);){
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(DELIM);
                if (parts.length != this.labelArgumentIndexes.length) {
                    throw new RuntimeException(String.format("Incorrectly sized label line (%d). Expected: %d values, found: %d", lineNumber, this.labelArgumentIndexes.length, parts.length));
                }
                this.labelIndexMapping.put(line, this.numLabels());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse labels file: " + path, ex);
        }
    }

    protected float[][] loadFeatures(String path) {
        log.debug("Loading features for {} from {}", (Object)this, (Object)path);
        this.entityIndexMapping = new HashMap<String, Integer>();
        int width = -1;
        ArrayList<float[]> rawFeatures = new ArrayList<float[]>();
        try (BufferedReader reader = FileUtils.getBufferedReader(path);){
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(DELIM);
                if (width == -1) {
                    width = parts.length;
                    this.numFeatures = width - this.entityArgumentIndexes.length;
                    if (this.numFeatures <= 0) {
                        throw new RuntimeException(String.format("Line too short (%d). Expected at least %d values, found %d.", lineNumber, this.entityArgumentIndexes.length + 1, width));
                    }
                } else if (parts.length != width) {
                    throw new RuntimeException(String.format("Incorrectly sized line (%d). Expected: %d values, found: %d.", lineNumber, width, parts.length));
                }
                float[] features = new float[this.numFeatures];
                for (int i = 0; i < this.numFeatures; ++i) {
                    features[i] = Float.parseFloat(parts[i + this.entityArgumentIndexes.length]);
                }
                rawFeatures.add(features);
                this.entityIndexMapping.put(this.getAtomIdentifier(parts, this.entityArgumentIndexes), this.entityIndexMapping.size());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse features file: " + path, ex);
        }
        float[][] arrayFeatures = new float[rawFeatures.size()][this.numFeatures];
        for (int i = 0; i < rawFeatures.size(); ++i) {
            for (int j = 0; j < this.numFeatures; ++j) {
                arrayFeatures[i][j] = ((float[])rawFeatures.get(i))[j];
            }
        }
        log.debug("Loaded features for {} [{} x {}]", this, arrayFeatures.length, this.numFeatures);
        return arrayFeatures;
    }

    protected void loadObservations(String path) {
        log.debug("Loading observations for {} from {}", (Object)this, (Object)path);
        int minWidth = this.entityArgumentIndexes.length + this.labelArgumentIndexes.length;
        try (BufferedReader reader = FileUtils.getBufferedReader(path);){
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(DELIM);
                if (parts.length < minWidth || parts.length > minWidth + 1) {
                    throw new RuntimeException(String.format("Incorrectly sized observation line (%d). Expected: %d (or %d) values, found: %d", lineNumber, minWidth, minWidth + 1, parts.length));
                }
                Integer entityIndex = this.entityIndexMapping.get(this.getAtomIdentifier(parts, this.entityArgumentIndexes));
                if (entityIndex == null) {
                    throw new RuntimeException(String.format("Unknown entity seen in observations. Line: %d, File: %s.", lineNumber, path));
                }
                Integer labelIndex = this.labelIndexMapping.get(this.getAtomIdentifier(parts, this.labelArgumentIndexes));
                if (labelIndex == null) {
                    throw new RuntimeException(String.format("Unknown label seen in observations. Line: %d, File: %s.", lineNumber, path));
                }
                float value = 1.0f;
                if (parts.length == minWidth + 1) {
                    value = Float.parseFloat(parts[minWidth]);
                }
                if (!this.observedLabels.containsKey(entityIndex)) {
                    this.observedLabels.put(entityIndex, new float[this.numLabels()]);
                }
                this.observedLabels.get((Object)entityIndex)[labelIndex.intValue()] = value;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse observations file: " + path, ex);
        }
    }

    protected AtomIndexes getAtomIndexes(RandomVariableAtom atom) {
        int entityIndex = this.getEntityIndex(atom);
        if (entityIndex < 0) {
            log.warn("Could not locate entity for atom: {}", (Object)atom);
            return null;
        }
        int labelIndex = this.getLabelIndex(atom);
        if (labelIndex < 0) {
            log.warn("Could not locate label for atom: {}", (Object)atom);
            return null;
        }
        return new AtomIndexes(entityIndex, labelIndex);
    }

    protected int getEntityIndex(RandomVariableAtom atom) {
        String key = this.getAtomIdentifier(atom, this.entityArgumentIndexes);
        Integer index = this.entityIndexMapping.get(key);
        if (index == null) {
            return -1;
        }
        return index;
    }

    protected int getLabelIndex(RandomVariableAtom atom) {
        String key = this.getAtomIdentifier(atom, this.labelArgumentIndexes);
        Integer index = this.labelIndexMapping.get(key);
        if (index == null) {
            return -1;
        }
        return index;
    }

    protected String getAtomIdentifier(String[] stringArgs, int[] argumentIndexes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < argumentIndexes.length; ++i) {
            if (i != 0) {
                builder.append(DELIM);
            }
            builder.append(stringArgs[argumentIndexes[i]]);
        }
        return builder.toString();
    }

    protected String getAtomIdentifier(RandomVariableAtom atom, int[] argumentIndexes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < argumentIndexes.length; ++i) {
            if (i != 0) {
                builder.append(DELIM);
            }
            builder.append(atom.getArguments()[argumentIndexes[i]].rawToString());
        }
        return builder.toString();
    }

    protected static String makePath(String relativeDir, String basePath) {
        if (basePath == null) {
            return null;
        }
        if (Paths.get(basePath, new String[0]).isAbsolute()) {
            return basePath;
        }
        return Paths.get(relativeDir, basePath).toString();
    }

    protected static final class AtomIndexes {
        public int entityIndex;
        public int labelIndex;

        public AtomIndexes(int entityIndex, int labelIndex) {
            this.entityIndex = entityIndex;
            this.labelIndex = labelIndex;
        }
    }
}

