/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.rdbms.Formula2SQL;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.database.rdbms.RawQuery;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.AbstractRule;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.AbstractGroundArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.UnweightedArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.WeightedArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.expression.ArithmeticRuleExpression;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtom;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtomOrAtom;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariableOrTerm;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Coefficient;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.util.Parallel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArithmeticRule
extends AbstractRule {
    private static final Logger log = LoggerFactory.getLogger(AbstractArithmeticRule.class);
    protected final ArithmeticRuleExpression expression;
    protected final Map<SummationVariable, Formula> filters;
    private final String groundingResourcesKey;
    private volatile boolean validatedByAtomManager;

    public AbstractArithmeticRule(ArithmeticRuleExpression expression, Map<SummationVariable, Formula> filterClauses, String name) {
        super(name);
        this.expression = expression;
        this.filters = filterClauses;
        this.groundingResourcesKey = AbstractArithmeticRule.class.getName() + ";" + System.identityHashCode(this) + ";GroundingResources";
        for (Map.Entry<SummationVariable, Formula> entry : this.filters.entrySet()) {
            entry.setValue(entry.getValue().getDNF());
        }
        this.validatedByAtomManager = false;
        this.validateRule();
    }

    public boolean hasSummation() {
        return this.expression.getSummationVariables().size() > 0;
    }

    public ArithmeticRuleExpression getExpression() {
        return this.expression;
    }

    @Override
    public boolean requiresSplit() {
        for (Formula filter : this.filters.values()) {
            if (!(filter instanceof Disjunction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Rule> split() {
        ArrayList<Rule> splitRules = new ArrayList<Rule>();
        if (!this.requiresSplit()) {
            splitRules.add(this);
            return splitRules;
        }
        ArrayList splitFilters = new ArrayList();
        splitFilters.add(new HashMap());
        for (Map.Entry<SummationVariable, Formula> entry : this.filters.entrySet()) {
            if (!(entry.getValue() instanceof Disjunction)) {
                for (Map map : splitFilters) {
                    map.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            Disjunction disjunction = (Disjunction)entry.getValue();
            ArrayList arrayList = new ArrayList();
            for (Map map : splitFilters) {
                for (int i = 0; i < disjunction.length(); ++i) {
                    HashMap<SummationVariable, Formula> newFilter = new HashMap<SummationVariable, Formula>(map);
                    newFilter.put(entry.getKey(), disjunction.get(i));
                    arrayList.add(newFilter);
                }
            }
            splitFilters = arrayList;
        }
        for (int i = 0; i < splitFilters.size(); ++i) {
            String newName = String.format("_%s_%03d", this.name, i);
            if (this.getClass() == WeightedArithmeticRule.class) {
                WeightedArithmeticRule weightedRule = (WeightedArithmeticRule)this;
                splitRules.add(new WeightedArithmeticRule(this.expression, (Map)splitFilters.get(i), weightedRule.getWeight(), weightedRule.isSquared(), newName));
                continue;
            }
            if (this.getClass() == UnweightedArithmeticRule.class) {
                splitRules.add(new UnweightedArithmeticRule(this.expression, (Map)splitFilters.get(i), newName));
                continue;
            }
            throw new IllegalStateException("Unknown arithmetic rule class: " + this.getClass());
        }
        return splitRules;
    }

    public Set<Predicate> getBodyPredicates() {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        for (SummationAtomOrAtom atom : this.expression.getAtoms()) {
            if (atom instanceof SummationAtom) {
                predicates.add(((SummationAtom)atom).getPredicate());
                continue;
            }
            predicates.add(((Atom)atom).getPredicate());
        }
        return predicates;
    }

    @Override
    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof AbstractArithmeticRule)) {
            return false;
        }
        AbstractArithmeticRule otherRule = (AbstractArithmeticRule)other;
        return this.filters.equals(otherRule.filters) && this.expression.equals(otherRule.expression);
    }

    protected abstract AbstractGroundArithmeticRule makeGroundRule(float[] var1, GroundAtom[] var2, FunctionComparator var3, float var4);

    protected abstract AbstractGroundArithmeticRule makeGroundRule(List<Float> var1, List<GroundAtom> var2, FunctionComparator var3, float var4);

    @Override
    public boolean supportsGroundingQueryRewriting() {
        return !this.hasSummation();
    }

    @Override
    public Formula getRewritableGroundingFormula() {
        if (!this.hasSummation()) {
            return this.expression.getQueryFormula();
        }
        throw new UnsupportedOperationException("Rule does not support query rewriting: " + this);
    }

    @Override
    public boolean supportsIndividualGrounding() {
        return true;
    }

    @Override
    public RawQuery getGroundingQuery(AtomManager atomManager) {
        if (!(atomManager.getDatabase() instanceof RDBMSDatabase)) {
            throw new IllegalArgumentException("Can only ground arithmetic rules with a relational database.");
        }
        RDBMSDatabase database = (RDBMSDatabase)atomManager.getDatabase();
        if (!this.hasSummation()) {
            return new RawQuery(database, this.expression.getQueryFormula());
        }
        return this.getSummationRawQuery(database);
    }

    @Override
    public void ground(Constant[] constants, Map<Variable, Integer> variableMap, AtomManager atomManager, List<GroundRule> results) {
        if (!this.validatedByAtomManager) {
            this.validateForGrounding(atomManager);
        }
        if (!this.hasSummation()) {
            this.groundForNonSummation(constants, variableMap, atomManager, results);
        } else {
            this.groundForSummation(constants, variableMap, atomManager, results);
        }
    }

    private void groundForNonSummation(Constant[] constants, Map<Variable, Integer> variableMap, AtomManager atomManager, List<GroundRule> results) {
        GroundingResources resources = this.getGroundingResources(this.expression);
        this.groundSingleNonSummationRule(constants, variableMap, atomManager, resources);
        results.addAll(resources.groundRules);
        resources.groundRules.clear();
        resources.accessExceptionAtoms.clear();
    }

    private void groundForSummation(Constant[] constants, Map<Variable, Integer> variableMap, AtomManager atomManager, List<GroundRule> results) {
        if (!(atomManager.getDatabase() instanceof RDBMSDatabase)) {
            throw new IllegalArgumentException("Can only ground summation arithmetic rules with a relational database.");
        }
        RDBMSDatabase database = (RDBMSDatabase)atomManager.getDatabase();
        GroundingResources resources = this.prepSummationGroundingResources(database);
        if (resources.flatExpression == null) {
            return;
        }
        this.groundSingleSummationRule(constants, variableMap, atomManager, resources);
        results.addAll(resources.groundRules);
        resources.groundRules.clear();
        resources.accessExceptionAtoms.clear();
    }

    @Override
    public long groundAll(AtomManager atomManager, GroundRuleStore groundRuleStore) {
        if (!this.validatedByAtomManager) {
            this.validateForGrounding(atomManager);
        }
        long groundCount = 0L;
        groundCount = !this.hasSummation() ? this.groundAllNonSummationRule(atomManager, groundRuleStore) : this.groundAllSummationRule(atomManager, groundRuleStore);
        log.debug("Grounded {} instances of rule {}", (Object)groundCount, (Object)this);
        return groundCount;
    }

    private long groundAllNonSummationRule(AtomManager atomManager, GroundRuleStore groundRuleStore) {
        GroundingResources resources = this.getGroundingResources(this.expression);
        ResultList results = atomManager.executeQuery(new DatabaseQuery(this.expression.getQueryFormula(), false));
        Map<Variable, Integer> variableMap = results.getVariableMap();
        int groundingIndex = 0;
        while ((long)groundingIndex < results.size()) {
            this.groundSingleNonSummationRule(results.get(groundingIndex), variableMap, atomManager, resources);
            ++groundingIndex;
        }
        long count = resources.groundRules.size();
        for (GroundRule groundRule : resources.groundRules) {
            groundRuleStore.addGroundRule(groundRule);
        }
        resources.groundRules.clear();
        resources.accessExceptionAtoms.clear();
        return count;
    }

    private void groundSingleNonSummationRule(Constant[] queryRow, Map<Variable, Integer> variableMap, AtomManager atomManager, GroundingResources resources) {
        for (int atomIndex = 0; atomIndex < resources.groundAtoms.length; ++atomIndex) {
            GroundAtom atom = resources.queryAtoms.get(atomIndex).ground(atomManager, queryRow, variableMap, resources.argumentBuffer[atomIndex]);
            if (atom == null) {
                return;
            }
            resources.groundAtoms[atomIndex] = atom;
            if (!(atom instanceof RandomVariableAtom) || !((RandomVariableAtom)atom).getAccessException()) continue;
            resources.accessExceptionAtoms.add(resources.groundAtoms[atomIndex]);
        }
        AbstractGroundArithmeticRule groundRule = null;
        if (this.isWeighted() && FunctionComparator.EQ.equals((Object)this.expression.getComparator())) {
            groundRule = this.makeGroundRule(resources.coefficients, resources.groundAtoms, FunctionComparator.GTE, resources.finalCoefficient);
            if (this.verifyGroundRule(groundRule, atomManager, resources)) {
                resources.groundRules.add(groundRule);
            }
            if (this.verifyGroundRule(groundRule = this.makeGroundRule(resources.coefficients, resources.groundAtoms, FunctionComparator.LTE, resources.finalCoefficient), atomManager, resources)) {
                resources.groundRules.add(groundRule);
            }
        } else {
            groundRule = this.makeGroundRule(resources.coefficients, resources.groundAtoms, this.expression.getComparator(), resources.finalCoefficient);
            if (this.verifyGroundRule(groundRule, atomManager, resources)) {
                resources.groundRules.add(groundRule);
            }
        }
    }

    private long groundAllSummationRule(AtomManager atomManager, GroundRuleStore groundRuleStore) {
        if (!(atomManager.getDatabase() instanceof RDBMSDatabase)) {
            throw new IllegalArgumentException("Can only ground summation arithmetic rules with a relational database.");
        }
        RDBMSDatabase database = (RDBMSDatabase)atomManager.getDatabase();
        GroundingResources resources = this.prepSummationGroundingResources(database);
        if (resources.flatExpression == null) {
            return 0L;
        }
        RawQuery rawQuery = this.getSummationRawQuery(database);
        ResultList results = database.executeQuery(rawQuery);
        Map<Variable, Integer> variableMap = results.getVariableMap();
        int groundingIndex = 0;
        while ((long)groundingIndex < results.size()) {
            this.groundSingleSummationRule(results.get(groundingIndex), variableMap, atomManager, resources);
            ++groundingIndex;
        }
        long count = resources.groundRules.size();
        for (GroundRule groundRule : resources.groundRules) {
            groundRuleStore.addGroundRule(groundRule);
        }
        resources.groundRules.clear();
        resources.accessExceptionAtoms.clear();
        return count;
    }

    private void groundSingleSummationRule(Constant[] queryRow, Map<Variable, Integer> variableMap, AtomManager atomManager, GroundingResources resources) {
        for (Map.Entry<SummationVariable, Integer> entry : resources.totalSummationCounts.entrySet()) {
            resources.summationCounts.put(entry.getKey(), entry.getValue());
        }
        int skippedAtoms = 0;
        for (int atomIndex = 0; atomIndex < resources.groundAtoms.length; ++atomIndex) {
            resources.groundAtoms[atomIndex] = null;
            boolean checkDatabase = resources.flatSummationAtoms[atomIndex] && !atomManager.isClosed((StandardPredicate)resources.queryAtoms.get(atomIndex).getPredicate());
            boolean skip = false;
            SummationVariable[] variables = resources.flatSummationVariables.get(atomIndex);
            GroundAtom groundAtom = resources.queryAtoms.get(atomIndex).ground(atomManager, queryRow, variableMap, resources.argumentBuffer[atomIndex], checkDatabase);
            if (groundAtom == null) {
                skip = true;
            }
            if (!skip) {
                for (int variableIndex = 0; variableIndex < variables.length; ++variableIndex) {
                    SummationVariable variable = variables[variableIndex];
                    if (variable == null || !this.filters.containsKey(variable) || this.evalFilter(this.filters.get(variable), variable, groundAtom.getArguments()[variableIndex], atomManager, queryRow, variableMap)) continue;
                    skip = true;
                    break;
                }
            }
            if (!skip) {
                resources.groundAtoms[atomIndex] = groundAtom;
                continue;
            }
            ++skippedAtoms;
            if (!resources.flatSummationAtoms[atomIndex]) continue;
            for (SummationVariable variable : variables) {
                if (variable == null) continue;
                resources.summationCounts.put(variable, resources.summationCounts.get(variable) - 1);
            }
        }
        if (skippedAtoms >= resources.groundAtoms.length) {
            return;
        }
        for (int i = 0; i < resources.coefficients.length; ++i) {
            resources.coefficients[i] = resources.flatExpression.getAtomCoefficients().get(i).getValue(resources.summationCounts);
        }
        resources.finalCoefficient = resources.flatExpression.getFinalCoefficient().getValue(resources.summationCounts);
        AbstractGroundArithmeticRule groundRule = null;
        if (this.isWeighted() && FunctionComparator.EQ.equals((Object)resources.flatExpression.getComparator())) {
            groundRule = this.makeGroundRule(resources.coefficients, resources.groundAtoms, FunctionComparator.GTE, resources.finalCoefficient);
            if (this.verifyGroundRule(groundRule, atomManager, resources)) {
                resources.groundRules.add(groundRule);
            }
            if (this.verifyGroundRule(groundRule = this.makeGroundRule(resources.coefficients, resources.groundAtoms, FunctionComparator.LTE, resources.finalCoefficient), atomManager, resources)) {
                resources.groundRules.add(groundRule);
            }
        } else {
            groundRule = this.makeGroundRule(resources.coefficients, resources.groundAtoms, resources.flatExpression.getComparator(), resources.finalCoefficient);
            if (this.verifyGroundRule(groundRule, atomManager, resources)) {
                resources.groundRules.add(groundRule);
            }
        }
    }

    private boolean evalFilter(Formula filter, SummationVariable summationVariable, Constant variableValue, AtomManager atomManager, Constant[] queryRow, Map<Variable, Integer> variableMap) {
        if (filter instanceof Atom) {
            GroundAtom groundAtom;
            QueryAtom atom = (QueryAtom)filter;
            Term[] arguments = atom.getArguments();
            Term[] newArguments = null;
            for (int i = 0; i < arguments.length; ++i) {
                if (!arguments[i].equals(summationVariable.getVariable())) continue;
                if (newArguments == null) {
                    newArguments = Arrays.copyOf(arguments, arguments.length);
                }
                newArguments[i] = variableValue;
            }
            if (newArguments != null) {
                atom = new QueryAtom(atom.getPredicate(), newArguments);
            }
            if ((groundAtom = atom.ground(atomManager, queryRow, variableMap)) == null) {
                return false;
            }
            return groundAtom.getValue() > 0.0f;
        }
        if (filter instanceof Negation) {
            return !this.evalFilter(((Negation)filter).getFormula(), summationVariable, variableValue, atomManager, queryRow, variableMap);
        }
        if (filter instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)filter;
            for (int i = 0; i < conjunction.length(); ++i) {
                boolean value = this.evalFilter(conjunction.get(i), summationVariable, variableValue, atomManager, queryRow, variableMap);
                if (value) continue;
                return false;
            }
            return true;
        }
        throw new IllegalStateException("Unexpected filter formula: " + filter);
    }

    private boolean verifyGroundRule(GroundRule baseRule, AtomManager atomManager, GroundingResources resources) {
        AbstractGroundArithmeticRule rule = (AbstractGroundArithmeticRule)baseRule;
        if (rule.getOrderedAtoms().length == 1) {
            if (FunctionComparator.GTE.equals((Object)rule.getComparator())) {
                float constantMax = 0.0f;
                if (rule.getCoefficients()[0] < 0.0f) {
                    constantMax = -1.0f;
                }
                if (rule.getConstant() <= constantMax) {
                    return false;
                }
            } else if (FunctionComparator.LTE.equals((Object)rule.getComparator())) {
                float constantMin = 1.0f;
                if (rule.getCoefficients()[0] < 0.0f) {
                    constantMin = 0.0f;
                }
                if (rule.getConstant() >= constantMin) {
                    return false;
                }
            }
        }
        boolean hasRVA = false;
        for (int i = 0; i < rule.getOrderedAtoms().length; ++i) {
            if (!(rule.getOrderedAtoms()[i] instanceof RandomVariableAtom)) continue;
            hasRVA = true;
        }
        if (!hasRVA) {
            return false;
        }
        if (resources.accessExceptionAtoms.size() != 0) {
            RuntimeException ex = new RuntimeException(String.format("Found one or more RandomVariableAtoms (target ground atom) that were not explicitly specified in the targets. Offending atom(s): %s. This typically means that your specified target set is insufficient. This was encountered during the grounding of the rule: [%s].", resources.accessExceptionAtoms, this));
            atomManager.reportAccessException(ex, resources.accessExceptionAtoms.iterator().next());
        }
        return true;
    }

    private void validateRule() {
        for (SummationVariable filterArg : this.filters.keySet()) {
            if (this.expression.getSummationVariables().contains(filterArg)) continue;
            throw new IllegalArgumentException(String.format("Unknown variable (%s) used as filter argument. All filter arguments must appear as summation variables in associated arithmetic expression.", filterArg.getVariable().getName()));
        }
        HashSet<String> expressionVariableNames = new HashSet<String>();
        for (Variable variable : this.expression.getVariables()) {
            expressionVariableNames.add(variable.getName());
        }
        for (Map.Entry entry : this.filters.entrySet()) {
            VariableTypeMap filterVars = new VariableTypeMap();
            ((Formula)entry.getValue()).collectVariables(filterVars);
            for (Variable var : filterVars.keySet()) {
                if (((SummationVariable)entry.getKey()).getVariable().getName().equals(var.getName()) || expressionVariableNames.contains(var.getName())) continue;
                throw new IllegalArgumentException(String.format("Unknown variable (%s) used in filter. All filter variables must either be the filter argument or appear in the associated arithmetic expression.", var.getName()));
            }
        }
    }

    private synchronized void validateForGrounding(AtomManager atomManager) {
        if (this.validatedByAtomManager) {
            return;
        }
        if (this.requiresSplit()) {
            throw new IllegalStateException("This rule should be split() before attemting grounding.");
        }
        HashSet<Atom> filterAtoms = new HashSet<Atom>();
        for (Formula filter : this.filters.values()) {
            filter.getAtoms(filterAtoms);
        }
        for (Atom filterAtom : filterAtoms) {
            if (!(filterAtom.getPredicate() instanceof StandardPredicate) || atomManager.isClosed((StandardPredicate)filterAtom.getPredicate())) continue;
            throw new IllegalArgumentException(String.format("Open predicate (%s) not allowed in filter. Only closed predicates may appear in filters.", filterAtom.getPredicate().getName()));
        }
        this.validatedByAtomManager = true;
    }

    private RawQuery getSummationRawQuery(RDBMSDatabase database) {
        Formula queryFormula = this.expression.getQueryFormula();
        Formula2SQL sqler = new Formula2SQL(this.expression.getVariables(), database, true);
        SelectQuery query = sqler.getQuery(queryFormula);
        VariableTypeMap variableTypes = new VariableTypeMap();
        queryFormula.collectVariables(variableTypes);
        Map<Variable, Integer> projectionMap = sqler.getProjectionMap();
        if (projectionMap.size() == 0) {
            query.setFetchNext(1);
        }
        return new RawQuery(((SelectQuery)query.validate()).toString(), projectionMap, variableTypes);
    }

    private GroundingResources prepSummationGroundingResources(RDBMSDatabase database) {
        GroundingResources resources = this.getGroundingResources(null);
        if (resources.summationDataLoaded) {
            return resources;
        }
        ArrayList<SummationAtomOrAtom> flatAtoms = new ArrayList<SummationAtomOrAtom>();
        ArrayList<Coefficient> flatCoefficients = new ArrayList<Coefficient>();
        ArrayList<SummationVariable[]> flatSummationVariables = new ArrayList<SummationVariable[]>();
        this.flattenAtoms(database, flatAtoms, flatCoefficients, flatSummationVariables);
        if (flatAtoms.size() == 0) {
            resources.summationDataLoaded = true;
            return resources;
        }
        HashMap<SummationVariable, Integer> summationCounts = new HashMap<SummationVariable, Integer>();
        for (SummationVariable variable : this.expression.getSummationMapping().keySet()) {
            summationCounts.put(variable, 0);
        }
        Iterator<SummationVariable> iterator = flatSummationVariables.iterator();
        while (iterator.hasNext()) {
            SummationVariable[] variables;
            for (SummationVariable variable : variables = (SummationVariable[])iterator.next()) {
                if (variable == null) continue;
                summationCounts.put(variable, (Integer)summationCounts.get(variable) + 1);
            }
        }
        boolean[] flatSummationAtoms = new boolean[flatSummationVariables.size()];
        for (int i = 0; i < flatSummationVariables.size(); ++i) {
            for (SummationVariable variable : (SummationVariable[])flatSummationVariables.get(i)) {
                if (variable == null) continue;
                flatSummationAtoms[i] = true;
            }
        }
        ArithmeticRuleExpression flatExpression = new ArithmeticRuleExpression(flatCoefficients, flatAtoms, this.expression.getComparator(), this.expression.getFinalCoefficient(), true);
        resources.parseExpression(flatExpression, false);
        resources.summationDataLoaded = true;
        resources.flatExpression = flatExpression;
        resources.totalSummationCounts = summationCounts;
        resources.summationCounts = new HashMap<SummationVariable, Integer>(summationCounts);
        resources.flatSummationVariables = flatSummationVariables;
        resources.flatSummationAtoms = flatSummationAtoms;
        return resources;
    }

    private Map<SummationVariable, ResultList> fetchSummationConstants(Map<SummationVariable, SummationAtom> summationMapping, RDBMSDatabase database) {
        HashMap<SummationVariable, ResultList> summationConstants = new HashMap<SummationVariable, ResultList>();
        for (Map.Entry<SummationVariable, SummationAtom> entry : summationMapping.entrySet()) {
            ResultList results = this.fetchSummationValues(database, entry.getKey(), entry.getValue());
            summationConstants.put(entry.getKey(), results);
        }
        return summationConstants;
    }

    private void flattenAtoms(RDBMSDatabase database, List<SummationAtomOrAtom> flatAtoms, List<Coefficient> flatCoefficients, List<SummationVariable[]> flatSummationVariables) {
        Map<SummationVariable, ResultList> summationConstants = this.fetchSummationConstants(this.expression.getSummationMapping(), database);
        flatAtoms.clear();
        flatCoefficients.clear();
        flatSummationVariables.clear();
        flatAtoms.addAll(this.expression.getAtoms());
        flatCoefficients.addAll(this.expression.getAtomCoefficients());
        for (SummationAtomOrAtom atom : flatAtoms) {
            SummationVariable[] variables = new SummationVariable[atom.getArity()];
            if (atom instanceof SummationAtom) {
                SummationAtom summationAtom = (SummationAtom)atom;
                for (int i = 0; i < summationAtom.getArity(); ++i) {
                    if (!(summationAtom.getArguments()[i] instanceof SummationVariable)) continue;
                    variables[i] = (SummationVariable)summationAtom.getArguments()[i];
                }
            }
            flatSummationVariables.add(variables);
        }
        boolean done = false;
        while (!done) {
            done = true;
            block3: for (int atomIndex = flatAtoms.size() - 1; atomIndex >= 0; --atomIndex) {
                if (!(flatAtoms.get(atomIndex) instanceof SummationAtom)) continue;
                done = false;
                SummationAtom atom = (SummationAtom)flatAtoms.remove(atomIndex);
                Coefficient coefficient = flatCoefficients.remove(atomIndex);
                SummationVariable[] variables = flatSummationVariables.remove(atomIndex);
                boolean convertToQueryAtom = atom.getNumSummationVariables() == 1;
                for (int argumentIndex = 0; argumentIndex < atom.getArity(); ++argumentIndex) {
                    SummationVariableOrTerm argument = atom.getArguments()[argumentIndex];
                    if (!(argument instanceof SummationVariable)) continue;
                    ResultList replacements = summationConstants.get((SummationVariable)argument);
                    int resultIndex = 0;
                    while ((long)resultIndex < replacements.size()) {
                        SummationVariableOrTerm[] newArgs;
                        flatCoefficients.add(coefficient);
                        flatSummationVariables.add(variables);
                        if (convertToQueryAtom) {
                            newArgs = new Term[atom.getArity()];
                            for (int i = 0; i < atom.getArity(); ++i) {
                                newArgs[i] = i == argumentIndex ? replacements.get(resultIndex)[0] : (Term)atom.getArguments()[i];
                            }
                            flatAtoms.add(new QueryAtom(atom.getPredicate(), (Term[])newArgs));
                        } else {
                            newArgs = Arrays.copyOf(atom.getArguments(), atom.getArity());
                            newArgs[argumentIndex] = replacements.get(resultIndex)[0];
                            flatAtoms.add(new SummationAtom(atom.getPredicate(), newArgs));
                        }
                        ++resultIndex;
                    }
                    continue block3;
                }
            }
        }
    }

    private ResultList fetchSummationValues(RDBMSDatabase database, SummationVariable variable, SummationAtom atom) {
        QueryAtom queryAtom = atom.getQueryAtom();
        VariableTypeMap variableTypes = new VariableTypeMap();
        queryAtom.collectVariables(variableTypes);
        HashSet<Variable> projectionSet = new HashSet<Variable>();
        projectionSet.add(variable.getVariable());
        Formula2SQL sqler = new Formula2SQL(projectionSet, database, true);
        SelectQuery query = sqler.getQuery(queryAtom);
        Map<Variable, Integer> projectionMap = sqler.getProjectionMap();
        return database.executeQuery(projectionMap, variableTypes, ((SelectQuery)query.validate()).toString());
    }

    private GroundingResources getGroundingResources(ArithmeticRuleExpression expression) {
        GroundingResources resources = null;
        if (!Parallel.hasThreadObject(this.groundingResourcesKey)) {
            resources = new GroundingResources();
            if (expression != null) {
                resources.parseExpression(expression, !this.hasSummation());
            }
            Parallel.putThreadObject(this.groundingResourcesKey, resources);
        } else {
            resources = (GroundingResources)Parallel.getThreadObject(this.groundingResourcesKey);
        }
        return resources;
    }

    private static class GroundingResources {
        public List<GroundRule> groundRules = new ArrayList<GroundRule>();
        public Set<GroundAtom> accessExceptionAtoms = new HashSet<GroundAtom>(4);
        public List<QueryAtom> queryAtoms;
        public GroundAtom[] groundAtoms;
        public Constant[][] argumentBuffer;
        public float[] coefficients;
        public float finalCoefficient;
        public boolean summationDataLoaded;
        public ArithmeticRuleExpression flatExpression;
        public Map<SummationVariable, Integer> totalSummationCounts;
        public Map<SummationVariable, Integer> summationCounts;
        public List<SummationVariable[]> flatSummationVariables;
        boolean[] flatSummationAtoms;

        public void parseExpression(ArithmeticRuleExpression expression, boolean computeCoefficients) {
            int i;
            this.queryAtoms = new ArrayList<QueryAtom>();
            for (SummationAtomOrAtom atom : expression.getAtoms()) {
                this.queryAtoms.add((QueryAtom)atom);
            }
            this.groundAtoms = new GroundAtom[this.queryAtoms.size()];
            this.argumentBuffer = new Constant[this.queryAtoms.size()][];
            for (i = 0; i < this.queryAtoms.size(); ++i) {
                this.argumentBuffer[i] = new Constant[this.queryAtoms.get(i).getArity()];
            }
            this.coefficients = new float[this.queryAtoms.size()];
            this.finalCoefficient = 0.0f;
            if (computeCoefficients) {
                for (i = 0; i < this.coefficients.length; ++i) {
                    this.coefficients[i] = expression.getAtomCoefficients().get(i).getValue(null);
                }
                this.finalCoefficient = expression.getFinalCoefficient().getValue(null);
            }
        }
    }
}

