/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.GroundingOnlyPredicate;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.UnweightedRule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.AbstractGroundArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.UnweightedArithmeticRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.GeneralFunction;

public class UnweightedGroundArithmeticRule
extends AbstractGroundArithmeticRule
implements UnweightedGroundRule {
    protected UnweightedGroundArithmeticRule(UnweightedArithmeticRule rule, List<Float> coefficients, List<GroundAtom> atoms, FunctionComparator comparator, float constant) {
        super((AbstractArithmeticRule)rule, coefficients, atoms, comparator, constant);
    }

    protected UnweightedGroundArithmeticRule(UnweightedArithmeticRule rule, float[] coefficients, GroundAtom[] atoms, FunctionComparator comparator, float constant) {
        super((AbstractArithmeticRule)rule, coefficients, atoms, comparator, constant);
    }

    @Override
    public UnweightedRule getRule() {
        return (UnweightedRule)((Object)this.rule);
    }

    @Override
    public float getInfeasibility() {
        float sum = 0.0f;
        for (int i = 0; i < this.coefficients.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof GroundingOnlyPredicate) continue;
            sum += this.coefficients[i] * this.atoms[i].getValue();
        }
        switch (this.comparator) {
            case EQ: {
                return Math.abs(sum - this.constant);
            }
            case GTE: {
                return -1.0f * Math.min(sum - this.constant, 0.0f);
            }
            case LTE: {
                return Math.max(sum - this.constant, 0.0f);
            }
        }
        throw new IllegalStateException("Unrecognized comparator: " + (Object)((Object)this.comparator));
    }

    @Override
    public ConstraintTerm getConstraintDefinition(boolean mergeConstants) {
        GeneralFunction sum = new GeneralFunction(false, false, this.coefficients.length, mergeConstants);
        for (int i = 0; i < this.coefficients.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof GroundingOnlyPredicate) continue;
            sum.add(this.coefficients[i], this.atoms[i]);
        }
        return new ConstraintTerm(sum, this.comparator, this.constant);
    }

    @Override
    public String toString() {
        return super.toString() + " .";
    }
}

