/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.online;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.atom.OnlineAtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTermStore;
import org.linqs.psl.util.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OnlineTermStore<T extends ReasonerTerm>
extends StreamingTermStore<T> {
    private static final Logger log = LoggerFactory.getLogger(OnlineTermStore.class);
    protected List<Integer> activeTermPages = new ArrayList<Integer>();
    protected List<Integer> activeVolatilePages = new ArrayList<Integer>();
    protected Integer nextTermPageIndex = 0;
    protected Integer nextVolatilePageIndex = 0;

    public OnlineTermStore(List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, GroundAtom> termGenerator) {
        super(rules, atomManager, termGenerator);
    }

    @Override
    public boolean isLoaded() {
        return !this.initialRound && ((OnlineAtomManager)this.atomManager).hasNewAtoms() == false;
    }

    @Override
    protected int estimateVariableCapacity() {
        return this.atomManager.getCachedRVACount() + this.atomManager.getCachedObsCount();
    }

    public synchronized void deleteLocalVariable(GroundAtom atom) {
        int index = this.getVariableIndex(atom);
        if (index == -1) {
            return;
        }
        this.variables.remove(atom);
        this.variableValues[index] = -1.0f;
        this.variableAtoms[index] = null;
        if (atom instanceof RandomVariableAtom) {
            --this.numRandomVariableAtoms;
        } else {
            --this.numObservedAtoms;
        }
    }

    public abstract StreamingIterator<T> getGroundingIterator(List<Rule> var1);

    @Override
    public double syncAtoms() {
        double movement = 0.0;
        for (int i = 0; i < this.totalVariableCount; ++i) {
            if (this.variableAtoms[i] == null) continue;
            if (this.variableAtoms[i] instanceof RandomVariableAtom) {
                movement += Math.pow(this.variableAtoms[i].getValue() - this.variableValues[i], 2.0);
                ((RandomVariableAtom)this.variableAtoms[i]).setValue(this.variableValues[i]);
                continue;
            }
            ((ObservedAtom)this.variableAtoms[i])._assumeValue(this.variableValues[i]);
        }
        return Math.sqrt(movement);
    }

    @Override
    public String getTermPagePath(int index) {
        for (int i = this.activeTermPages.size(); i <= index; ++i) {
            this.termPagePaths.add(Paths.get(this.pageDir, String.format("%08d_term.page", this.nextTermPageIndex)).toString());
            this.activeTermPages.add(this.nextTermPageIndex);
            Integer n = this.nextTermPageIndex;
            Integer n2 = this.nextTermPageIndex = Integer.valueOf(this.nextTermPageIndex + 1);
        }
        return (String)this.termPagePaths.get(this.activeTermPages.get(index));
    }

    @Override
    public String getVolatilePagePath(int index) {
        for (int i = this.activeVolatilePages.size(); i <= index; ++i) {
            this.volatilePagePaths.add(Paths.get(this.pageDir, String.format("%08d_volatile.page", this.nextVolatilePageIndex)).toString());
            this.activeVolatilePages.add(this.nextVolatilePageIndex);
            Integer n = this.nextVolatilePageIndex;
            Integer n2 = this.nextVolatilePageIndex = Integer.valueOf(this.nextVolatilePageIndex + 1);
        }
        return (String)this.volatilePagePaths.get(this.activeVolatilePages.get(index));
    }

    @Override
    protected StreamingIterator<T> streamingIterator() {
        this.activeIterator = super.streamingIterator();
        if (!this.initialRound && ((OnlineAtomManager)this.atomManager).hasNewAtoms().booleanValue()) {
            this.activeIterator = new StreamingJoinIterator(IteratorUtils.join(this.activeIterator, this.getGroundingIterator()));
        }
        return this.activeIterator;
    }

    private static class StreamingJoinIterator<E extends ReasonerTerm>
    implements StreamingIterator<E> {
        private Iterator<E> iterator;

        public StreamingJoinIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return (E)((ReasonerTerm)this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
        }
    }
}

