/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.Timer;
import java.util.TimerTask;
import org.linqs.psl.config.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeStats {
    private static final Logger log = LoggerFactory.getLogger(RuntimeStats.class);
    private static MeanStats totalMemory = new MeanStats();
    private static MeanStats freeMemory = new MeanStats();
    private static MeanStats usedMemory = new MeanStats();
    private static MeanStats maxMemory = new MeanStats();
    private static AccumulatingStats reads = new AccumulatingStats();
    private static AccumulatingStats writes = new AccumulatingStats();
    private static Runtime runtime = null;
    private static Timer collectionTimer = null;

    private RuntimeStats() {
    }

    private static synchronized void init() {
        if (runtime != null) {
            return;
        }
        runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new ShutdownHook());
    }

    public static synchronized void collect() {
        if (collectionTimer != null) {
            return;
        }
        Object property = Options.RUNTIME_STATS_COLLECT.getUnlogged();
        if (property == null || !Boolean.parseBoolean((String)property)) {
            return;
        }
        RuntimeStats.init();
        long period = Options.RUNTIME_COLLECTION_PERIOD.getLong();
        collectionTimer = new Timer(RuntimeStats.class.getName(), true);
        collectionTimer.schedule((TimerTask)new CollectionTask(), 0L, period);
    }

    public static synchronized void stopCollection() {
        if (collectionTimer == null) {
            return;
        }
        collectionTimer.purge();
        collectionTimer.cancel();
        collectionTimer = null;
    }

    public static synchronized void logDiskRead(long bytes) {
        reads.add(bytes);
    }

    public static synchronized void logDiskWrite(long bytes) {
        writes.add(bytes);
    }

    public static void outputStats() {
        if (runtime == null) {
            return;
        }
        log.info("Total Memory (bytes) -- " + totalMemory);
        log.info("Free Memory (bytes)  -- " + freeMemory);
        log.info("Used Memory (bytes)  -- " + usedMemory);
        log.info("Max Memory (bytes)   -- " + maxMemory);
        log.info("IO Reads (bytes)     -- " + reads);
        log.info("IO Writes (bytes)    -- " + writes);
    }

    private static class AccumulatingStats
    extends MeanStats {
        private long total = 0L;

        @Override
        public void add(long value) {
            super.add(value);
            this.total += value;
        }

        @Override
        public String toString() {
            return String.format("%s, Total: %12d", super.toString(), this.total);
        }
    }

    private static class MeanStats {
        private long min = 0L;
        private long max = 0L;
        private long mean = 0L;
        private long count = 0L;

        public void add(long value) {
            if (this.count == 0L || value < this.min) {
                this.min = value;
            }
            if (this.count == 0L || value > this.max) {
                this.max = value;
            }
            this.mean = (this.mean * this.count + value) / (this.count + 1L);
            ++this.count;
        }

        public String toString() {
            return String.format("Min: %12d, Max: %12d, Mean: %12d, Count: %12d", this.min, this.max, this.mean, this.count);
        }
    }

    private static class CollectionTask
    extends TimerTask {
        private CollectionTask() {
        }

        @Override
        public void run() {
            long totalMemoryValue = runtime.totalMemory();
            long freeMemoryValue = runtime.freeMemory();
            long usedMemoryValue = Math.max(0L, totalMemoryValue - freeMemoryValue);
            long maxMemoryValue = runtime.maxMemory();
            totalMemory.add(totalMemoryValue);
            freeMemory.add(freeMemoryValue);
            usedMemory.add(usedMemoryValue);
            maxMemory.add(maxMemoryValue);
        }
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            RuntimeStats.outputStats();
        }
    }
}

