# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: persistent.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ... import client as __client__

if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ReadReqNackAction(betterproto.Enum):
    Unknown = 0
    Park = 1
    Retry = 2
    Skip = 3
    Stop = 4


class CreateReqConsumerStrategy(betterproto.Enum):
    DispatchToSingle = 0
    RoundRobin = 1
    Pinned = 2


class UpdateReqConsumerStrategy(betterproto.Enum):
    DispatchToSingle = 0
    RoundRobin = 1
    Pinned = 2


@dataclass(eq=False, repr=False)
class ReadReq(betterproto.Message):
    options: "ReadReqOptions" = betterproto.message_field(1, group="content")
    ack: "ReadReqAck" = betterproto.message_field(2, group="content")
    nack: "ReadReqNack" = betterproto.message_field(3, group="content")


@dataclass(eq=False, repr=False)
class ReadReqOptions(betterproto.Message):
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(
        1, group="stream_option"
    )
    all: "__client__.Empty" = betterproto.message_field(5, group="stream_option")
    group_name: str = betterproto.string_field(2)
    buffer_size: int = betterproto.int32_field(3)
    uuid_option: "ReadReqOptionsUuidOption" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ReadReqOptionsUuidOption(betterproto.Message):
    structured: "__client__.Empty" = betterproto.message_field(1, group="content")
    string: "__client__.Empty" = betterproto.message_field(2, group="content")


@dataclass(eq=False, repr=False)
class ReadReqAck(betterproto.Message):
    id: bytes = betterproto.bytes_field(1)
    ids: List["__client__.Uuid"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ReadReqNack(betterproto.Message):
    id: bytes = betterproto.bytes_field(1)
    ids: List["__client__.Uuid"] = betterproto.message_field(2)
    action: "ReadReqNackAction" = betterproto.enum_field(3)
    reason: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ReadResp(betterproto.Message):
    event: "ReadRespReadEvent" = betterproto.message_field(1, group="content")
    subscription_confirmation: "ReadRespSubscriptionConfirmation" = (
        betterproto.message_field(2, group="content")
    )


@dataclass(eq=False, repr=False)
class ReadRespReadEvent(betterproto.Message):
    event: "ReadRespReadEventRecordedEvent" = betterproto.message_field(1)
    link: "ReadRespReadEventRecordedEvent" = betterproto.message_field(2)
    commit_position: int = betterproto.uint64_field(3, group="position")
    no_position: "__client__.Empty" = betterproto.message_field(4, group="position")
    retry_count: int = betterproto.int32_field(5, group="count")
    no_retry_count: "__client__.Empty" = betterproto.message_field(6, group="count")


@dataclass(eq=False, repr=False)
class ReadRespReadEventRecordedEvent(betterproto.Message):
    id: "__client__.Uuid" = betterproto.message_field(1)
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(2)
    stream_revision: int = betterproto.uint64_field(3)
    prepare_position: int = betterproto.uint64_field(4)
    commit_position: int = betterproto.uint64_field(5)
    metadata: Dict[str, str] = betterproto.map_field(
        6, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    custom_metadata: bytes = betterproto.bytes_field(7)
    data: bytes = betterproto.bytes_field(8)


@dataclass(eq=False, repr=False)
class ReadRespSubscriptionConfirmation(betterproto.Message):
    subscription_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CreateReq(betterproto.Message):
    options: "CreateReqOptions" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateReqOptions(betterproto.Message):
    stream: "CreateReqStreamOptions" = betterproto.message_field(
        4, group="stream_option"
    )
    all: "CreateReqAllOptions" = betterproto.message_field(5, group="stream_option")
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(1)
    group_name: str = betterproto.string_field(2)
    settings: "CreateReqSettings" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("stream_identifier"):
            warnings.warn(
                "CreateReqOptions.stream_identifier is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class CreateReqStreamOptions(betterproto.Message):
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(1)
    revision: int = betterproto.uint64_field(2, group="revision_option")
    start: "__client__.Empty" = betterproto.message_field(3, group="revision_option")
    end: "__client__.Empty" = betterproto.message_field(4, group="revision_option")


@dataclass(eq=False, repr=False)
class CreateReqAllOptions(betterproto.Message):
    position: "CreateReqPosition" = betterproto.message_field(1, group="all_option")
    start: "__client__.Empty" = betterproto.message_field(2, group="all_option")
    end: "__client__.Empty" = betterproto.message_field(3, group="all_option")
    filter: "CreateReqAllOptionsFilterOptions" = betterproto.message_field(
        4, group="filter_option"
    )
    no_filter: "__client__.Empty" = betterproto.message_field(5, group="filter_option")


@dataclass(eq=False, repr=False)
class CreateReqAllOptionsFilterOptions(betterproto.Message):
    stream_identifier: "CreateReqAllOptionsFilterOptionsExpression" = (
        betterproto.message_field(1, group="filter")
    )
    event_type: "CreateReqAllOptionsFilterOptionsExpression" = (
        betterproto.message_field(2, group="filter")
    )
    max: int = betterproto.uint32_field(3, group="window")
    count: "__client__.Empty" = betterproto.message_field(4, group="window")
    checkpoint_interval_multiplier: int = betterproto.uint32_field(5)


@dataclass(eq=False, repr=False)
class CreateReqAllOptionsFilterOptionsExpression(betterproto.Message):
    regex: str = betterproto.string_field(1)
    prefix: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class CreateReqPosition(betterproto.Message):
    commit_position: int = betterproto.uint64_field(1)
    prepare_position: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class CreateReqSettings(betterproto.Message):
    resolve_links: bool = betterproto.bool_field(1)
    revision: int = betterproto.uint64_field(2)
    extra_statistics: bool = betterproto.bool_field(3)
    max_retry_count: int = betterproto.int32_field(5)
    min_checkpoint_count: int = betterproto.int32_field(7)
    max_checkpoint_count: int = betterproto.int32_field(8)
    max_subscriber_count: int = betterproto.int32_field(9)
    live_buffer_size: int = betterproto.int32_field(10)
    read_batch_size: int = betterproto.int32_field(11)
    history_buffer_size: int = betterproto.int32_field(12)
    named_consumer_strategy: "CreateReqConsumerStrategy" = betterproto.enum_field(13)
    message_timeout_ticks: int = betterproto.int64_field(4, group="message_timeout")
    message_timeout_ms: int = betterproto.int32_field(14, group="message_timeout")
    checkpoint_after_ticks: int = betterproto.int64_field(6, group="checkpoint_after")
    checkpoint_after_ms: int = betterproto.int32_field(15, group="checkpoint_after")
    consumer_strategy: str = betterproto.string_field(16)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("revision"):
            warnings.warn(
                "CreateReqSettings.revision is deprecated", DeprecationWarning
            )
        if self.is_set("named_consumer_strategy"):
            warnings.warn(
                "CreateReqSettings.named_consumer_strategy is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class CreateResp(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UpdateReq(betterproto.Message):
    options: "UpdateReqOptions" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateReqOptions(betterproto.Message):
    stream: "UpdateReqStreamOptions" = betterproto.message_field(
        4, group="stream_option"
    )
    all: "UpdateReqAllOptions" = betterproto.message_field(5, group="stream_option")
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(1)
    group_name: str = betterproto.string_field(2)
    settings: "UpdateReqSettings" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("stream_identifier"):
            warnings.warn(
                "UpdateReqOptions.stream_identifier is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class UpdateReqStreamOptions(betterproto.Message):
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(1)
    revision: int = betterproto.uint64_field(2, group="revision_option")
    start: "__client__.Empty" = betterproto.message_field(3, group="revision_option")
    end: "__client__.Empty" = betterproto.message_field(4, group="revision_option")


@dataclass(eq=False, repr=False)
class UpdateReqAllOptions(betterproto.Message):
    position: "UpdateReqPosition" = betterproto.message_field(1, group="all_option")
    start: "__client__.Empty" = betterproto.message_field(2, group="all_option")
    end: "__client__.Empty" = betterproto.message_field(3, group="all_option")


@dataclass(eq=False, repr=False)
class UpdateReqPosition(betterproto.Message):
    commit_position: int = betterproto.uint64_field(1)
    prepare_position: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class UpdateReqSettings(betterproto.Message):
    resolve_links: bool = betterproto.bool_field(1)
    revision: int = betterproto.uint64_field(2)
    extra_statistics: bool = betterproto.bool_field(3)
    max_retry_count: int = betterproto.int32_field(5)
    min_checkpoint_count: int = betterproto.int32_field(7)
    max_checkpoint_count: int = betterproto.int32_field(8)
    max_subscriber_count: int = betterproto.int32_field(9)
    live_buffer_size: int = betterproto.int32_field(10)
    read_batch_size: int = betterproto.int32_field(11)
    history_buffer_size: int = betterproto.int32_field(12)
    named_consumer_strategy: "UpdateReqConsumerStrategy" = betterproto.enum_field(13)
    message_timeout_ticks: int = betterproto.int64_field(4, group="message_timeout")
    message_timeout_ms: int = betterproto.int32_field(14, group="message_timeout")
    checkpoint_after_ticks: int = betterproto.int64_field(6, group="checkpoint_after")
    checkpoint_after_ms: int = betterproto.int32_field(15, group="checkpoint_after")

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("revision"):
            warnings.warn(
                "UpdateReqSettings.revision is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class UpdateResp(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteReq(betterproto.Message):
    options: "DeleteReqOptions" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeleteReqOptions(betterproto.Message):
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(
        1, group="stream_option"
    )
    all: "__client__.Empty" = betterproto.message_field(3, group="stream_option")
    group_name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteResp(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetInfoReq(betterproto.Message):
    options: "GetInfoReqOptions" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetInfoReqOptions(betterproto.Message):
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(
        1, group="stream_option"
    )
    all: "__client__.Empty" = betterproto.message_field(2, group="stream_option")
    group_name: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class GetInfoResp(betterproto.Message):
    subscription_info: "SubscriptionInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SubscriptionInfo(betterproto.Message):
    event_source: str = betterproto.string_field(1)
    group_name: str = betterproto.string_field(2)
    status: str = betterproto.string_field(3)
    connections: List["SubscriptionInfoConnectionInfo"] = betterproto.message_field(4)
    average_per_second: int = betterproto.int32_field(5)
    total_items: int = betterproto.int64_field(6)
    count_since_last_measurement: int = betterproto.int64_field(7)
    last_checkpointed_event_position: str = betterproto.string_field(8)
    last_known_event_position: str = betterproto.string_field(9)
    resolve_link_tos: bool = betterproto.bool_field(10)
    start_from: str = betterproto.string_field(11)
    message_timeout_milliseconds: int = betterproto.int32_field(12)
    extra_statistics: bool = betterproto.bool_field(13)
    max_retry_count: int = betterproto.int32_field(14)
    live_buffer_size: int = betterproto.int32_field(15)
    buffer_size: int = betterproto.int32_field(16)
    read_batch_size: int = betterproto.int32_field(17)
    check_point_after_milliseconds: int = betterproto.int32_field(18)
    min_check_point_count: int = betterproto.int32_field(19)
    max_check_point_count: int = betterproto.int32_field(20)
    read_buffer_count: int = betterproto.int32_field(21)
    live_buffer_count: int = betterproto.int64_field(22)
    retry_buffer_count: int = betterproto.int32_field(23)
    total_in_flight_messages: int = betterproto.int32_field(24)
    outstanding_messages_count: int = betterproto.int32_field(25)
    named_consumer_strategy: str = betterproto.string_field(26)
    max_subscriber_count: int = betterproto.int32_field(27)
    parked_message_count: int = betterproto.int64_field(28)


@dataclass(eq=False, repr=False)
class SubscriptionInfoConnectionInfo(betterproto.Message):
    from_: str = betterproto.string_field(1)
    username: str = betterproto.string_field(2)
    average_items_per_second: int = betterproto.int32_field(3)
    total_items: int = betterproto.int64_field(4)
    count_since_last_measurement: int = betterproto.int64_field(5)
    observed_measurements: List[
        "SubscriptionInfoMeasurement"
    ] = betterproto.message_field(6)
    available_slots: int = betterproto.int32_field(7)
    in_flight_messages: int = betterproto.int32_field(8)
    connection_name: str = betterproto.string_field(9)


@dataclass(eq=False, repr=False)
class SubscriptionInfoMeasurement(betterproto.Message):
    key: str = betterproto.string_field(1)
    value: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class ReplayParkedReq(betterproto.Message):
    options: "ReplayParkedReqOptions" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ReplayParkedReqOptions(betterproto.Message):
    group_name: str = betterproto.string_field(1)
    stream_identifier: "__client__.StreamIdentifier" = betterproto.message_field(
        2, group="stream_option"
    )
    all: "__client__.Empty" = betterproto.message_field(3, group="stream_option")
    stop_at: int = betterproto.int64_field(4, group="stop_at_option")
    no_limit: "__client__.Empty" = betterproto.message_field(5, group="stop_at_option")


@dataclass(eq=False, repr=False)
class ReplayParkedResp(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListReq(betterproto.Message):
    options: "ListReqOptions" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListReqOptions(betterproto.Message):
    list_all_subscriptions: "__client__.Empty" = betterproto.message_field(
        1, group="list_option"
    )
    list_for_stream: "ListReqStreamOption" = betterproto.message_field(
        2, group="list_option"
    )


@dataclass(eq=False, repr=False)
class ListReqStreamOption(betterproto.Message):
    stream: "__client__.StreamIdentifier" = betterproto.message_field(
        1, group="stream_option"
    )
    all: "__client__.Empty" = betterproto.message_field(2, group="stream_option")


@dataclass(eq=False, repr=False)
class ListResp(betterproto.Message):
    subscriptions: List["SubscriptionInfo"] = betterproto.message_field(1)


class PersistentSubscriptionsStub(betterproto.ServiceStub):
    async def create(
        self,
        create_req: "CreateReq",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "CreateResp":
        return await self._unary_unary(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Create",
            create_req,
            CreateResp,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update(
        self,
        update_req: "UpdateReq",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "UpdateResp":
        return await self._unary_unary(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Update",
            update_req,
            UpdateResp,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete(
        self,
        delete_req: "DeleteReq",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "DeleteResp":
        return await self._unary_unary(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Delete",
            delete_req,
            DeleteResp,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def read(
        self,
        read_req_iterator: Union[AsyncIterable["ReadReq"], Iterable["ReadReq"]],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> AsyncIterator["ReadResp"]:
        async for response in self._stream_stream(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Read",
            read_req_iterator,
            ReadReq,
            ReadResp,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def get_info(
        self,
        get_info_req: "GetInfoReq",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetInfoResp":
        return await self._unary_unary(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/GetInfo",
            get_info_req,
            GetInfoResp,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def replay_parked(
        self,
        replay_parked_req: "ReplayParkedReq",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "ReplayParkedResp":
        return await self._unary_unary(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/ReplayParked",
            replay_parked_req,
            ReplayParkedResp,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list(
        self,
        list_req: "ListReq",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "ListResp":
        return await self._unary_unary(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/List",
            list_req,
            ListResp,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def restart_subsystem(
        self,
        client_empty: "__client__.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "__client__.Empty":
        return await self._unary_unary(
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/RestartSubsystem",
            client_empty,
            __client__.Empty,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class PersistentSubscriptionsBase(ServiceBase):
    async def create(self, create_req: "CreateReq") -> "CreateResp":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update(self, update_req: "UpdateReq") -> "UpdateResp":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete(self, delete_req: "DeleteReq") -> "DeleteResp":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def read(
        self, read_req_iterator: AsyncIterator["ReadReq"]
    ) -> AsyncIterator["ReadResp"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_info(self, get_info_req: "GetInfoReq") -> "GetInfoResp":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def replay_parked(
        self, replay_parked_req: "ReplayParkedReq"
    ) -> "ReplayParkedResp":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list(self, list_req: "ListReq") -> "ListResp":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def restart_subsystem(
        self, client_empty: "__client__.Empty"
    ) -> "__client__.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create(
        self, stream: "grpclib.server.Stream[CreateReq, CreateResp]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create(request)
        await stream.send_message(response)

    async def __rpc_update(
        self, stream: "grpclib.server.Stream[UpdateReq, UpdateResp]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update(request)
        await stream.send_message(response)

    async def __rpc_delete(
        self, stream: "grpclib.server.Stream[DeleteReq, DeleteResp]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete(request)
        await stream.send_message(response)

    async def __rpc_read(
        self, stream: "grpclib.server.Stream[ReadReq, ReadResp]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.read,
            stream,
            request,
        )

    async def __rpc_get_info(
        self, stream: "grpclib.server.Stream[GetInfoReq, GetInfoResp]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_info(request)
        await stream.send_message(response)

    async def __rpc_replay_parked(
        self, stream: "grpclib.server.Stream[ReplayParkedReq, ReplayParkedResp]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.replay_parked(request)
        await stream.send_message(response)

    async def __rpc_list(
        self, stream: "grpclib.server.Stream[ListReq, ListResp]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.list(request)
        await stream.send_message(response)

    async def __rpc_restart_subsystem(
        self, stream: "grpclib.server.Stream[__client__.Empty, __client__.Empty]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.restart_subsystem(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Create": grpclib.const.Handler(
                self.__rpc_create,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateReq,
                CreateResp,
            ),
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Update": grpclib.const.Handler(
                self.__rpc_update,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateReq,
                UpdateResp,
            ),
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Delete": grpclib.const.Handler(
                self.__rpc_delete,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteReq,
                DeleteResp,
            ),
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/Read": grpclib.const.Handler(
                self.__rpc_read,
                grpclib.const.Cardinality.STREAM_STREAM,
                ReadReq,
                ReadResp,
            ),
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/GetInfo": grpclib.const.Handler(
                self.__rpc_get_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetInfoReq,
                GetInfoResp,
            ),
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/ReplayParked": grpclib.const.Handler(
                self.__rpc_replay_parked,
                grpclib.const.Cardinality.UNARY_UNARY,
                ReplayParkedReq,
                ReplayParkedResp,
            ),
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/List": grpclib.const.Handler(
                self.__rpc_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListReq,
                ListResp,
            ),
            "/event_store.client.persistent_subscriptions.PersistentSubscriptions/RestartSubsystem": grpclib.const.Handler(
                self.__rpc_restart_subsystem,
                grpclib.const.Cardinality.UNARY_UNARY,
                __client__.Empty,
                __client__.Empty,
            ),
        }
