from hestia_earth.schema import IndicatorStatsDefinition

from hestia_earth.models.log import logRequirements
from hestia_earth.models.utils import sum_values
from hestia_earth.models.utils.indicator import _new_indicator
from hestia_earth.models.utils.impact_assessment import impact_lookup_value
from hestia_earth.models.utils.pesticideAI import impact_lookup_value as pesticides_lookup_value
from . import MODEL

REQUIREMENTS = {
    "ImpactAssessment": {
        "emissionsResourceUse": [{"@type": "Indicator", "value": "", "term.termType": "emission"}],
        "cycle": {
            "@type": "Cycle",
            "dataCompleteness.pesticidesAntibiotics": "True",
            "inputs": [{"@type": "Input", "value": "", "term.termType": "pesticideAI"}]
        }
    }
}
RETURNS = {
    "Indicator": {
        "value": "",
        "statsDefinition": "modelled"
    }
}
LOOKUPS = {
    "emission": "cfc11EqIndividualistStratosphericOzoneDepletionReCiPe2016",
    "pesticideAI": "cfc11EqIndividualistStratosphericOzoneDepletionReCiPe2016"
}
TERM_ID = 'ozoneDepletionPotential'


def _indicator(value: float):
    indicator = _new_indicator(TERM_ID, MODEL)
    indicator['value'] = value
    indicator['statsDefinition'] = IndicatorStatsDefinition.MODELLED.value
    return indicator


def run(impact_assessment: dict):
    emissions_value = impact_lookup_value(MODEL, TERM_ID, impact_assessment, LOOKUPS['emission'])
    logRequirements(impact_assessment, model=MODEL, term=TERM_ID,
                    emissions_value=emissions_value)

    pesticides_value = pesticides_lookup_value(MODEL, TERM_ID, impact_assessment, LOOKUPS['pesticideAI'])

    value = sum_values([emissions_value, pesticides_value])
    return None if value is None else _indicator(value)
