from typing import Any, ClassVar, Iterable, Iterator, List, Optional, Tuple, Union

from typing import overload
import os

from . import (
    script as script,
    kernel as kernel,
    model as model,
    nwn1 as nwn1
)

OBJECT_INVALID: ObjectID


class Appearance:
    body_parts: BodyParts
    hair: int
    id: int
    phenotype: int
    portrait_id: int
    skin: int
    tail: int
    tattoo1: int
    tattoo2: int
    wings: int
    def __init__(self) -> None: ...


class Area(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    comments: str
    creator_id: int
    flags: AreaFlags
    height: int
    id: int
    listen_check_mod: int
    loadscreen: int
    name: LocString
    no_rest: int
    pvp: int
    shadow_opacity: int
    skybox: int
    spot_check_mod: int
    tileset: Resref
    version: int
    weather: AreaWeather
    width: int
    def __init__(self) -> None: ...
    @property
    def creatures(self) -> CreatureVector: ...
    @property
    def doors(self) -> DoorVector: ...
    @property
    def encounters(self) -> EncounterVector: ...
    @property
    def items(self) -> ItemVector: ...
    @property
    def placeables(self) -> PlaceableVector: ...
    @property
    def scripts(self) -> AreaScripts: ...
    @property
    def sounds(self) -> SoundVector: ...
    @property
    def stores(self) -> StoreVector: ...
    @property
    def tiles(self) -> TileVector: ...
    @property
    def triggers(self) -> TriggerVector: ...
    @property
    def waypoints(self) -> WaypointVector: ...


class AreaFlags:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    interior: ClassVar[AreaFlags] = ...
    natural: ClassVar[AreaFlags] = ...
    none: ClassVar[AreaFlags] = ...
    underground: ClassVar[AreaFlags] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class AreaScripts:
    on_enter: Resref
    on_exit: Resref
    on_heartbeat: Resref
    on_user_defined: Resref
    def __init__(self) -> None: ...


class AreaVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: AreaVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: AreaVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: AreaVector) -> bool: ...
    def __getitem__(self, s: slice) -> AreaVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: AreaVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: AreaVector) -> None: ...


class AreaWeather:
    chance_lightning: int
    chance_rain: int
    chance_snow: int
    color_moon_ambient: int
    color_moon_diffuse: int
    color_moon_fog: int
    color_sun_ambient: int
    color_sun_diffuse: int
    color_sun_fog: int
    day_night_cycle: int
    fog_clip_distance: float
    fog_moon_amount: int
    fog_sun_amount: int
    is_night: int
    lighting_scheme: int
    moon_shadows: int
    sun_shadows: int
    wind_power: int
    def __init__(self) -> None: ...


class AttackData:
    armor_class: int
    attack_bonus: int
    attack_roll: int
    attacker: Creature
    concealment: int
    is_ranged_attack: bool
    iteration_penalty: int
    multiplier: int
    nth_attack: int
    result: AttackResult
    target: ObjectBase
    target_is_creature: bool
    target_state: Any
    threat_range: int
    type: AttackType
    def __init__(self, *args, **kwargs) -> None: ...


class AttackResult:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    hit_by_auto_success: ClassVar[AttackResult] = ...
    hit_by_critical: ClassVar[AttackResult] = ...
    hit_by_roll: ClassVar[AttackResult] = ...
    miss_by_auto_fail: ClassVar[AttackResult] = ...
    miss_by_concealment: ClassVar[AttackResult] = ...
    miss_by_miss_chance: ClassVar[AttackResult] = ...
    miss_by_roll: ClassVar[AttackResult] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class BodyParts:
    belt: int
    bicep_left: int
    bicep_right: int
    foot_left: int
    foot_right: int
    forearm_left: int
    forearm_right: int
    hand_left: int
    hand_right: int
    head: int
    neck: int
    pelvis: int
    shin_left: int
    shin_right: int
    shoulder_left: int
    shoulder_right: int
    thigh_left: int
    thigh_right: int
    def __init__(self) -> None: ...


class ClassEntry:
    id: Class
    level: int
    spells: Any
    def __init__(self, *args, **kwargs) -> None: ...


class ClassEntryVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ClassEntryVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: ClassEntryVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> ClassEntryVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: ClassEntryVector) -> None: ...


class CombatInfo:
    ac_armor_base: int
    ac_natural_bonus: int
    ac_shield_base: int
    combat_mode: Any
    size_ab_modifier: int
    size_ac_modifier: int
    target_state: Any
    def __init__(self, *args, **kwargs) -> None: ...


class Common:
    comment: str
    locals: Any
    location: Any
    name: LocString
    palette_id: int
    resref: Resref
    tag: str
    def __init__(self, *args, **kwargs) -> None: ...


class Container:
    def __init__(self, *args, **kwargs) -> None: ...
    def all(self) -> List[ResourceDescriptor]: ...
    @overload
    def contains(self, arg0: Resource) -> bool: ...
    @overload
    def contains(self, arg0: str) -> bool: ...
    @overload
    def demand(self, arg0: Resource) -> ByteArray: ...
    @overload
    def demand(self, arg0: str) -> ByteArray: ...
    def extract(self, arg0: str, arg1: os.PathLike) -> int: ...
    def extract_by_glob(self, arg0: str, arg1: os.PathLike) -> int: ...
    def name(self) -> str: ...
    def path(self) -> str: ...
    def size(self) -> int: ...
    def stat(self, arg0: Resource) -> ResourceDescriptor: ...
    def valid(self) -> bool: ...


class Creature(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    appearance: Appearance
    bodybag: int
    chunk_death: int
    common: Common
    conversation: Resref
    cr: float
    cr_adjust: int
    decay_time: int
    deity: str
    description: LocString
    disarmable: int
    faction_id: int
    gender: int
    good_evil: int
    hp: int
    hp_current: int
    hp_max: int
    immortal: int
    interruptable: int
    lawful_chaotic: int
    levels: LevelStats
    lootable: int
    name_first: LocString
    name_last: LocString
    pc: int
    perception_range: int
    plot: bool
    race: Race
    scripts: CreatureScripts
    soundset: int
    starting_package: int
    subrace: str
    walkrate: int
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def handle(self) -> ObjectHandle: ...
    def to_dict(self, arg0) -> json: ...
    @property
    def equipment(self) -> Equips: ...
    @property
    def history(self) -> LevelHistory: ...
    @property
    def inventory(self) -> Inventory: ...
    @property
    def stats(self) -> CreatureStats: ...


class CreatureScripts:
    on_attacked: Resref
    on_blocked: Resref
    on_conversation: Resref
    on_damaged: Resref
    on_death: Resref
    on_disturbed: Resref
    on_endround: Resref
    on_heartbeat: Resref
    on_perceived: Resref
    on_rested: Resref
    on_spawn: Resref
    on_spell_cast_at: Resref
    on_user_defined: Resref
    def __init__(self, *args, **kwargs) -> None: ...


class CreatureStats:
    def __init__(self, *args, **kwargs) -> None: ...
    def add_feat(self, arg0: Feat) -> bool: ...
    def get_ability_score(self, arg0: Ability) -> int: ...
    def get_skill_rank(self, arg0: Skill) -> int: ...
    def has_feat(self, arg0: Feat) -> bool: ...
    def set_ability_score(self, arg0: Ability, arg1: int) -> bool: ...
    def set_skill_rank(self, arg0: Skill, arg1: int) -> bool: ...
    @property
    def save_bonus(self) -> Any: ...


class CreatureVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CreatureVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: CreatureVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: CreatureVector) -> bool: ...
    def __getitem__(self, s: slice) -> CreatureVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: CreatureVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: CreatureVector) -> None: ...


class DiceRoll:
    bonus: int
    dice: int
    sides: int
    def __init__(self, *args, **kwargs) -> None: ...


class Directory(Container):
    def __init__(self, arg0: os.PathLike) -> None: ...


class Door(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    animation_state: DoorAnimationState
    appearance: int
    common: Common
    conversation: Resref
    description: LocString
    faction: int
    generic_type: int
    hardness: int
    hp: int
    hp_current: int
    interruptable: bool
    linked_to: str
    linked_to_flags: int
    loadscreen: int
    lock: Lock
    plot: bool
    portrait_id: int
    saves: Saves
    scripts: DoorScripts
    trap: Trap
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> json: ...


class DoorAnimationState:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    closed: ClassVar[DoorAnimationState] = ...
    opened1: ClassVar[DoorAnimationState] = ...
    opened2: ClassVar[DoorAnimationState] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class DoorScripts:
    on_click: Resref
    on_closed: Resref
    on_damaged: Resref
    on_death: Resref
    on_disarm: Resref
    on_heartbeat: Resref
    on_lock: Resref
    on_melee_attacked: Resref
    on_open: Resref
    on_open_failure: Resref
    on_spell_cast_at: Resref
    on_trap_triggered: Resref
    on_unlock: Resref
    on_user_defined: Resref
    def __init__(self, *args, **kwargs) -> None: ...


class DoorVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: DoorVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: DoorVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: DoorVector) -> bool: ...
    def __getitem__(self, s: slice) -> DoorVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: DoorVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: DoorVector) -> None: ...


class Effect:
    category: EffectCategory
    creator: ObjectHandle
    duration: float
    expire_day: int
    expire_time: int
    spell_id: Spell
    subtype: int
    type: EffectType
    def __init__(self, *args, **kwargs) -> None: ...
    def clear(self) -> None: ...
    def get_float(self, arg0: int) -> float: ...
    def get_int(self, arg0: int) -> int: ...
    def get_string(self, arg0: int) -> str: ...
    def handle(self) -> EffectHandle: ...
    def id(self) -> EffectID: ...
    def set_float(self, arg0: int, arg1: float) -> None: ...
    def set_int(self, arg0: int, arg1: int) -> None: ...
    def set_string(self, arg0: int, arg1: str) -> None: ...
    def set_versus(self, arg0) -> None: ...
    def versus(self, *args, **kwargs) -> Any: ...


class EffectCategory:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    extraordinary: ClassVar[EffectCategory] = ...
    innate: ClassVar[EffectCategory] = ...
    item: ClassVar[EffectCategory] = ...
    magical: ClassVar[EffectCategory] = ...
    supernatural: ClassVar[EffectCategory] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class EffectHandle:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def category(self) -> EffectCategory: ...
    @property
    def creator(self) -> ObjectHandle: ...
    @property
    def effect(self) -> Any: ...
    @property
    def spell_id(self) -> Spell: ...
    @property
    def subtype(self) -> int: ...
    @property
    def type(self) -> EffectType: ...


class EffectID:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def index(self) -> int: ...
    @property
    def version(self) -> int: ...


class Encounter(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    active: bool
    common: Common
    creatures: List[SpawnCreature]
    creatures_max: int
    creatures_recommended: int
    difficulty: int
    difficulty_index: int
    faction: int
    geometry: Vec3Vector
    player_only: bool
    reset: bool
    reset_time: int
    respawns: int
    spawn_option: int
    spawn_points: List[SpawnPoint]
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> json: ...
    @property
    def scripts(self) -> EncounterScripts: ...


class EncounterScripts:
    on_entered: Resref
    on_exhausted: Resref
    on_exit: Resref
    on_heartbeat: Resref
    on_user_defined: Resref
    def __init__(self, *args, **kwargs) -> None: ...


class EncounterVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: EncounterVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: EncounterVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: EncounterVector) -> bool: ...
    def __getitem__(self, s: slice) -> EncounterVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: EncounterVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: EncounterVector) -> None: ...


class EquipIndex:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    arms: ClassVar[EquipIndex] = ...
    arrows: ClassVar[EquipIndex] = ...
    belt: ClassVar[EquipIndex] = ...
    bolts: ClassVar[EquipIndex] = ...
    boots: ClassVar[EquipIndex] = ...
    bullets: ClassVar[EquipIndex] = ...
    chest: ClassVar[EquipIndex] = ...
    cloak: ClassVar[EquipIndex] = ...
    creature_bite: ClassVar[EquipIndex] = ...
    creature_left: ClassVar[EquipIndex] = ...
    creature_right: ClassVar[EquipIndex] = ...
    creature_skin: ClassVar[EquipIndex] = ...
    head: ClassVar[EquipIndex] = ...
    invalid: ClassVar[EquipIndex] = ...
    lefthand: ClassVar[EquipIndex] = ...
    leftring: ClassVar[EquipIndex] = ...
    neck: ClassVar[EquipIndex] = ...
    righthand: ClassVar[EquipIndex] = ...
    rightring: ClassVar[EquipIndex] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class EquipSlot:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    arms: ClassVar[EquipSlot] = ...
    arrows: ClassVar[EquipSlot] = ...
    belt: ClassVar[EquipSlot] = ...
    bolts: ClassVar[EquipSlot] = ...
    boots: ClassVar[EquipSlot] = ...
    bullets: ClassVar[EquipSlot] = ...
    chest: ClassVar[EquipSlot] = ...
    cloak: ClassVar[EquipSlot] = ...
    creature_bite: ClassVar[EquipSlot] = ...
    creature_left: ClassVar[EquipSlot] = ...
    creature_right: ClassVar[EquipSlot] = ...
    creature_skin: ClassVar[EquipSlot] = ...
    head: ClassVar[EquipSlot] = ...
    lefthand: ClassVar[EquipSlot] = ...
    leftring: ClassVar[EquipSlot] = ...
    neck: ClassVar[EquipSlot] = ...
    righthand: ClassVar[EquipSlot] = ...
    rightring: ClassVar[EquipSlot] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Equips:
    def __init__(self, *args, **kwargs) -> None: ...
    def instantiate(self) -> bool: ...
    @property
    def equips(self) -> Any: ...


class Erf(Container):
    description: LocString
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: os.PathLike) -> None: ...
    def add(self, arg0: os.PathLike) -> bool: ...
    def erase(self, arg0: Resource) -> int: ...
    def merge(self, arg0: Container) -> bool: ...
    def reload(self) -> bool: ...
    def save(self) -> bool: ...
    def save_as(self, arg0: os.PathLike) -> bool: ...


class GameVersion:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    invalid: ClassVar[GameVersion] = ...
    v1_69: ClassVar[GameVersion] = ...
    vEE: ClassVar[GameVersion] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Image:
    def __init__(self, arg0: Path) -> None: ...
    def channels(self) -> int: ...
    def data(self) -> int: ...
    def height(self) -> int: ...
    def valid(self) -> bool: ...
    def width(self) -> int: ...
    def write_to(self, arg0: Path) -> bool: ...


class Ini:
    def __init__(self, arg0: Path) -> None: ...
    def get_float(self, arg0: str) -> Optional[float]: ...
    def get_int(self, arg0: str) -> Optional[int]: ...
    def get_str(self, arg0: str) -> Optional[str]: ...
    def valid(self) -> bool: ...


class InstallInfo:
    install: Path
    user: Path
    version: GameVersion
    def __init__(self, *args, **kwargs) -> None: ...


class Int16Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Int16Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: Int16Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: Int16Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> Int16Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: Int16Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: Int16Vector) -> None: ...


class Int32Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Int32Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: Int32Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: Int32Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> Int32Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: Int32Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: Int32Vector) -> None: ...


class Int64Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Int64Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: Int64Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: Int64Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> Int64Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: Int64Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: Int64Vector) -> None: ...


class Int8Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Int8Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: Int8Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: Int8Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> Int8Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: Int8Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: Int8Vector) -> None: ...


class Inventory:
    owner: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def instantiate(self) -> bool: ...
    @property
    def items(self) -> InventoryItemVector: ...


class InventoryItem:
    infinite: bool
    item: Any
    x: int
    y: int
    def __init__(self, *args, **kwargs) -> None: ...


class InventoryItemVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: InventoryItemVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: InventoryItemVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> InventoryItemVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: InventoryItemVector) -> None: ...


class Item(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    additional_cost: int
    baseitem: Any
    charges: int
    common: Common
    cost: int
    cursed: bool
    description: LocString
    description_id: LocString
    identified: bool
    model_colors: List[int[6]]
    model_parts: List[int[19]]
    model_type: ItemModelType
    plot: bool
    properties: List[ItemProperty]
    stacksize: int
    stolen: bool
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def handle(self) -> ObjectHandle: ...
    def to_dict(self, arg0) -> json: ...
    @property
    def inventory(self) -> Inventory: ...


class ItemColors:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    cloth1: ClassVar[ItemColors] = ...
    cloth2: ClassVar[ItemColors] = ...
    leather1: ClassVar[ItemColors] = ...
    leather2: ClassVar[ItemColors] = ...
    metal1: ClassVar[ItemColors] = ...
    metal2: ClassVar[ItemColors] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ItemModelParts:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    armor_belt: ClassVar[ItemModelParts] = ...
    armor_lbicep: ClassVar[ItemModelParts] = ...
    armor_lfarm: ClassVar[ItemModelParts] = ...
    armor_lfoot: ClassVar[ItemModelParts] = ...
    armor_lhand: ClassVar[ItemModelParts] = ...
    armor_lshin: ClassVar[ItemModelParts] = ...
    armor_lshoul: ClassVar[ItemModelParts] = ...
    armor_lthigh: ClassVar[ItemModelParts] = ...
    armor_neck: ClassVar[ItemModelParts] = ...
    armor_pelvis: ClassVar[ItemModelParts] = ...
    armor_rbicep: ClassVar[ItemModelParts] = ...
    armor_rfarm: ClassVar[ItemModelParts] = ...
    armor_rfoot: ClassVar[ItemModelParts] = ...
    armor_rhand: ClassVar[ItemModelParts] = ...
    armor_robe: ClassVar[ItemModelParts] = ...
    armor_rshin: ClassVar[ItemModelParts] = ...
    armor_rshoul: ClassVar[ItemModelParts] = ...
    armor_rthigh: ClassVar[ItemModelParts] = ...
    armor_torso: ClassVar[ItemModelParts] = ...
    model1: ClassVar[ItemModelParts] = ...
    model2: ClassVar[ItemModelParts] = ...
    model3: ClassVar[ItemModelParts] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ItemModelType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    armor: ClassVar[ItemModelType] = ...
    composite: ClassVar[ItemModelType] = ...
    layered: ClassVar[ItemModelType] = ...
    simple: ClassVar[ItemModelType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ItemProperty:
    cost_table: int
    cost_value: int
    param_table: int
    param_value: int
    subtype: int
    type: int
    def __init__(self, *args, **kwargs) -> None: ...


class ItemVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ItemVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: ItemVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: ItemVector) -> bool: ...
    def __getitem__(self, s: slice) -> ItemVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: ItemVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: ItemVector) -> None: ...


class Key(Container):
    def __init__(self, arg0: os.PathLike) -> None: ...


class Language:
    def __init__(self, *args, **kwargs) -> None: ...
    def encoding(self, *args, **kwargs) -> Any: ...
    def from_string(self, *args, **kwargs) -> Any: ...
    def has_feminine(self, *args, **kwargs) -> Any: ...
    def to_base_id(self, *args, **kwargs) -> Any: ...
    def to_runtime_id(self, *args, **kwargs) -> Any: ...
    def to_string(self, *args, **kwargs) -> Any: ...


class LanguageID:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    chinese_simplified: ClassVar[LanguageID] = ...
    chinese_traditional: ClassVar[LanguageID] = ...
    english: ClassVar[LanguageID] = ...
    french: ClassVar[LanguageID] = ...
    german: ClassVar[LanguageID] = ...
    italian: ClassVar[LanguageID] = ...
    japanese: ClassVar[LanguageID] = ...
    korean: ClassVar[LanguageID] = ...
    polish: ClassVar[LanguageID] = ...
    spanish: ClassVar[LanguageID] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class LevelHistory:
    entries: LevelUpVector
    def __init__(self, *args, **kwargs) -> None: ...


class LevelStats:
    def __init__(self, *args, **kwargs) -> None: ...
    def level(self) -> int: ...
    def level_by_class(self, arg0: Class) -> int: ...
    @property
    def entries(self) -> List[ClassEntry[8]]: ...


class LevelUp:
    ability: Ability
    class_: Class
    epic: bool
    feats: List[Feat]
    hitpoints: int
    known_spells: List[Tuple[int, Spell]]
    skillpoints: int
    skills: Int32Vector
    def __init__(self, *args, **kwargs) -> None: ...


class LevelUpVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: LevelUpVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: LevelUpVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> LevelUpVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: LevelUpVector) -> None: ...


class LocString:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def add(self, language: LanguageID, string: str,
            feminine: bool = ...) -> bool: ...

    def from_dict(self, *args, **kwargs) -> Any: ...
    def get(self, language: LanguageID, feminine: bool = ...) -> str: ...
    def remove(self, language: LanguageID, feminine: bool = ...) -> None: ...
    def size(self) -> int: ...
    def strref(self) -> int: ...
    def to_dict(self) -> json: ...
    def __getitem__(self, arg0: LanguageID) -> str: ...


class LocalData:
    def __init__(self) -> None: ...
    def delete_float(self, arg0: str) -> None: ...
    def delete_int(self, arg0: str) -> None: ...
    def delete_location(self, arg0: str) -> None: ...
    def delete_object(self, arg0: str) -> None: ...
    def delete_string(self, arg0: str) -> None: ...
    def get_float(self, arg0: str) -> float: ...
    def get_int(self, arg0: str) -> int: ...
    def get_location(self, *args, **kwargs) -> Any: ...
    def get_object(self, *args, **kwargs) -> Any: ...
    def get_string(self, arg0: str) -> str: ...
    def set_float(self, arg0: str, arg1: float) -> None: ...
    def set_int(self, arg0: str, arg1: int) -> None: ...
    def set_location(self, arg0: str, arg1) -> None: ...
    def set_object(self, arg0: str, arg1) -> None: ...
    def set_string(self, arg0: str, arg1: str) -> None: ...
    def size(self) -> int: ...


class Location:
    area: Any
    orientation: Any
    position: Any
    def __init__(self) -> None: ...


class Lock:
    key_name: str
    key_required: bool
    lock_dc: int
    lockable: bool
    locked: bool
    remove_key: bool
    unlock_dc: int
    def __init__(self, *args, **kwargs) -> None: ...


class Matrix4:
    m00: float
    m01: float
    m02: float
    m03: float
    m10: float
    m11: float
    m12: float
    m13: float
    m20: float
    m21: float
    m22: float
    m23: float
    m30: float
    m31: float
    m32: float
    m33: float
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float, arg7: float,
                 arg8: float, arg9: float, arg10: float, arg11: float, arg12: float, arg13: float, arg14: float, arg15: float) -> None: ...

    def copy(self) -> Matrix4: ...
    def from_orthographic(self, *args, **kwargs) -> Any: ...
    def from_perspective(self, *args, **kwargs) -> Any: ...
    def inverse(self) -> Matrix4: ...
    def mul_scalar(self, arg0: float) -> Matrix4: ...
    def project_point(self, arg0: Vector3) -> Vector3: ...
    def to_transform(self) -> Transform: ...
    def transform_point(self, arg0: Vector3) -> Vector3: ...
    def transform_vector(self, arg0: Vector3) -> Vector3: ...
    def transpose(self) -> Matrix4: ...
    def __add__(self, arg0: Matrix4) -> Matrix4: ...
    def __copy__(self) -> Matrix4: ...
    def __iadd__(self, arg0: Matrix4) -> None: ...
    def __isub__(self, arg0: Matrix4) -> None: ...
    def __mul__(self, arg0: Matrix4) -> Matrix4: ...
    def __sub__(self, arg0: Matrix4) -> Matrix4: ...


class Module(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    creator: int
    dawn_hour: int
    description: LocString
    dusk_hour: int
    entry_area: Resref
    entry_orientation: Any
    entry_position: Any
    expansion_pack: int
    haks: StringVector
    id: ByteArray
    is_save_game: bool
    locals: LocalData
    min_game_version: str
    minutes_per_hour: int
    name: LocString
    scripts: ModuleScripts
    start_day: int
    start_hour: int
    start_month: int
    start_movie: Resref
    start_year: int
    tag: str
    tlk: str
    version: int
    xpscale: int
    def __init__(self) -> None: ...
    def area_count(self) -> int: ...
    def get_area(self, arg0: int) -> Area: ...
    def to_dict(self) -> json: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...


class ModuleScripts:
    on_client_enter: Resref
    on_client_leave: Resref
    on_cutsnabort: Resref
    on_heartbeat: Resref
    on_item_acquire: Resref
    on_item_activate: Resref
    on_item_unaquire: Resref
    on_load: Resref
    on_player_chat: Resref
    on_player_death: Resref
    on_player_dying: Resref
    on_player_equip: Resref
    on_player_level_up: Resref
    on_player_rest: Resref
    on_player_uneqiup: Resref
    on_spawnbtndn: Resref
    on_start: Resref
    on_user_defined: Resref
    def __init__(self, *args, **kwargs) -> None: ...


class NWSync:
    def __init__(self, arg0: os.PathLike) -> None: ...
    def get(self, *args, **kwargs) -> Any: ...
    def is_loaded(self) -> bool: ...
    def manifests(self) -> List[str]: ...
    def shard_count(self) -> int: ...


class NWSyncManifest(Container):
    def __init__(self, *args, **kwargs) -> None: ...


class ObjectBase:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def as_common(self) -> Common: ...
    @overload
    def as_common(self) -> Common: ...
    def as_creature(self, *args, **kwargs) -> Any: ...
    def as_door(self, *args, **kwargs) -> Any: ...
    def as_encounter(self, *args, **kwargs) -> Any: ...
    def as_item(self, *args, **kwargs) -> Any: ...
    def as_module(self, *args, **kwargs) -> Any: ...
    def as_placeable(self, *args, **kwargs) -> Any: ...
    def as_sound(self, *args, **kwargs) -> Any: ...
    def as_trigger(self, *args, **kwargs) -> Any: ...
    def as_waypoint(self, *args, **kwargs) -> Any: ...
    def handle(self) -> ObjectHandle: ...
    def instantiate(self) -> bool: ...


class ObjectHandle:
    def __init__(self) -> None: ...
    def valid(self) -> bool: ...
    @property
    def id(self) -> ObjectID: ...
    @property
    def type(self) -> ObjectType: ...
    @property
    def version(self) -> int: ...


class ObjectID:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ObjectType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    area: ClassVar[ObjectType] = ...
    areaofeffect: ClassVar[ObjectType] = ...
    creature: ClassVar[ObjectType] = ...
    door: ClassVar[ObjectType] = ...
    encounter: ClassVar[ObjectType] = ...
    gui: ClassVar[ObjectType] = ...
    invalid: ClassVar[ObjectType] = ...
    item: ClassVar[ObjectType] = ...
    module: ClassVar[ObjectType] = ...
    placeable: ClassVar[ObjectType] = ...
    portal: ClassVar[ObjectType] = ...
    projectile: ClassVar[ObjectType] = ...
    sound: ClassVar[ObjectType] = ...
    store: ClassVar[ObjectType] = ...
    tile: ClassVar[ObjectType] = ...
    trigger: ClassVar[ObjectType] = ...
    waypoint: ClassVar[ObjectType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Path:
    def __init__(self, arg0: str) -> None: ...


class PathAlias:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    ambient: ClassVar[PathAlias] = ...
    cache: ClassVar[PathAlias] = ...
    currentgame: ClassVar[PathAlias] = ...
    database: ClassVar[PathAlias] = ...
    development: ClassVar[PathAlias] = ...
    dmvault: ClassVar[PathAlias] = ...
    hak: ClassVar[PathAlias] = ...
    hd0: ClassVar[PathAlias] = ...
    localvault: ClassVar[PathAlias] = ...
    logs: ClassVar[PathAlias] = ...
    modelcompiler: ClassVar[PathAlias] = ...
    modules: ClassVar[PathAlias] = ...
    movies: ClassVar[PathAlias] = ...
    music: ClassVar[PathAlias] = ...
    nwsync: ClassVar[PathAlias] = ...
    oldservervault: ClassVar[PathAlias] = ...
    override: ClassVar[PathAlias] = ...
    patch: ClassVar[PathAlias] = ...
    portraits: ClassVar[PathAlias] = ...
    saves: ClassVar[PathAlias] = ...
    screenshots: ClassVar[PathAlias] = ...
    servervault: ClassVar[PathAlias] = ...
    temp: ClassVar[PathAlias] = ...
    tempclient: ClassVar[PathAlias] = ...
    tlk: ClassVar[PathAlias] = ...
    user: ClassVar[PathAlias] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Placeable(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    animation_state: PlaceableAnimationState
    appearance: int
    bodybag: int
    common: Common
    conversation: Resref
    description: LocString
    faction: int
    hardness: int
    has_inventory: bool
    hp: int
    hp_current: int
    interruptable: bool
    lock: Lock
    plot: bool
    portrait_id: int
    saves: Saves
    scripts: PlaceableScripts
    static: bool
    trap: Trap
    useable: bool
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> json: ...
    @property
    def inventory(self) -> Inventory: ...


class PlaceableAnimationState:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    activated: ClassVar[PlaceableAnimationState] = ...
    closed: ClassVar[PlaceableAnimationState] = ...
    deactivated: ClassVar[PlaceableAnimationState] = ...
    destroyed: ClassVar[PlaceableAnimationState] = ...
    none: ClassVar[PlaceableAnimationState] = ...
    open: ClassVar[PlaceableAnimationState] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class PlaceableScripts:
    on_click: Resref
    on_closed: Resref
    on_damaged: Resref
    on_death: Resref
    on_disarm: Resref
    on_heartbeat: Resref
    on_inventory_disturbed: Resref
    on_lock: Resref
    on_melee_attacked: Resref
    on_open: Resref
    on_spell_cast_at: Resref
    on_trap_triggered: Resref
    on_unlock: Resref
    on_used: Resref
    on_user_defined: Resref
    def __init__(self, *args, **kwargs) -> None: ...


class PlaceableVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: PlaceableVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: PlaceableVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: PlaceableVector) -> bool: ...
    def __getitem__(self, s: slice) -> PlaceableVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: PlaceableVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: PlaceableVector) -> None: ...


class Player(Creature):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    def __init__(self, *args, **kwargs) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...


class Plt:
    def __init__(self, arg0: Path) -> None: ...
    def height(self) -> int: ...
    def pixels(self) -> PltPixel: ...
    def valid(self) -> bool: ...
    def width(self) -> int: ...


class PltColors:
    def __init__(self) -> None: ...
    @property
    def colors(self) -> List[int[10]]: ...


class PltLayer:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    cloth1: ClassVar[PltLayer] = ...
    cloth2: ClassVar[PltLayer] = ...
    hair: ClassVar[PltLayer] = ...
    leather1: ClassVar[PltLayer] = ...
    leather2: ClassVar[PltLayer] = ...
    metal1: ClassVar[PltLayer] = ...
    metal2: ClassVar[PltLayer] = ...
    skin: ClassVar[PltLayer] = ...
    tattoo1: ClassVar[PltLayer] = ...
    tattoo2: ClassVar[PltLayer] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class PltPixel:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def color(self) -> int: ...
    @property
    def layer(self) -> PltLayer: ...


class Quaternion:
    w: float
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: float, arg1: float,
                 arg2: float, arg3: float) -> None: ...

    def angle_axis(self) -> Tuple[float, Vector3]: ...
    def conjugate(self) -> Quaternion: ...
    def copy(self) -> Quaternion: ...
    def euler_angles(self) -> Vector3: ...
    def from_angle_axis(self, *args, **kwargs) -> Any: ...
    def from_euler_angles(self, *args, **kwargs) -> Any: ...
    def from_from_to_rotation(self, *args, **kwargs) -> Any: ...
    def from_look_rotation(self, *args, **kwargs) -> Any: ...
    def from_matrix3(self, *args, **kwargs) -> Any: ...
    def inverse(self) -> Quaternion: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Quaternion: ...
    def normalize_self(self) -> None: ...
    def slerp(self, arg0: Quaternion, arg1: float) -> Quaternion: ...
    def to_matrix3(self) -> List[Vector3]: ...
    def to_matrix4(self, *args, **kwargs) -> Any: ...
    def transform_point(self, arg0: Vector3) -> Vector3: ...
    def transform_vector(self, arg0: Vector3) -> Vector3: ...
    def __copy__(self) -> Quaternion: ...
    def __imul__(self, arg0: Quaternion) -> Quaternion: ...
    def __mul__(self, arg0: Quaternion) -> Quaternion: ...


class Ray:
    direction: Vector3
    position: Vector3
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Vector3, arg1: Vector3) -> None: ...
    def copy(self) -> Ray: ...
    def __copy__(self) -> Ray: ...


class Resource:
    resref: Resref
    type: ResourceType
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: ResourceType) -> None: ...
    def filename(self) -> str: ...
    def from_filename(self, *args, **kwargs) -> Any: ...
    def valid(self) -> bool: ...


class ResourceDescriptor:
    mtime: int
    name: Resource
    parent: Any
    size: int
    def __init__(self, *args, **kwargs) -> None: ...


class ResourceDescriptorVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ResourceDescriptorVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: ResourceDescriptorVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> ResourceDescriptorVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...

    @overload
    def __setitem__(self, arg0: slice,
                    arg1: ResourceDescriptorVector) -> None: ...


class ResourceType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    are: ClassVar[ResourceType] = ...
    bak: ClassVar[ResourceType] = ...
    bic: ClassVar[ResourceType] = ...
    bif: ClassVar[ResourceType] = ...
    bik: ClassVar[ResourceType] = ...
    bmp: ClassVar[ResourceType] = ...
    bmu: ClassVar[ResourceType] = ...
    btc: ClassVar[ResourceType] = ...
    btd: ClassVar[ResourceType] = ...
    bte: ClassVar[ResourceType] = ...
    btg: ClassVar[ResourceType] = ...
    bti: ClassVar[ResourceType] = ...
    btm: ClassVar[ResourceType] = ...
    btp: ClassVar[ResourceType] = ...
    bts: ClassVar[ResourceType] = ...
    btt: ClassVar[ResourceType] = ...
    caf: ClassVar[ResourceType] = ...
    ccs: ClassVar[ResourceType] = ...
    css: ClassVar[ResourceType] = ...
    dat: ClassVar[ResourceType] = ...
    dds: ClassVar[ResourceType] = ...
    dft: ClassVar[ResourceType] = ...
    dlg: ClassVar[ResourceType] = ...
    dwk: ClassVar[ResourceType] = ...
    erf: ClassVar[ResourceType] = ...
    fac: ClassVar[ResourceType] = ...
    fnt: ClassVar[ResourceType] = ...
    fourpc: ClassVar[ResourceType] = ...
    gff: ClassVar[ResourceType] = ...
    gic: ClassVar[ResourceType] = ...
    gif: ClassVar[ResourceType] = ...
    git: ClassVar[ResourceType] = ...
    gui: ClassVar[ResourceType] = ...
    hak: ClassVar[ResourceType] = ...
    ids: ClassVar[ResourceType] = ...
    ifo: ClassVar[ResourceType] = ...
    ini: ClassVar[ResourceType] = ...
    invalid: ClassVar[ResourceType] = ...
    itp: ClassVar[ResourceType] = ...
    jpg: ClassVar[ResourceType] = ...
    jrl: ClassVar[ResourceType] = ...
    key: ClassVar[ResourceType] = ...
    ktx: ClassVar[ResourceType] = ...
    lod: ClassVar[ResourceType] = ...
    ltr: ClassVar[ResourceType] = ...
    lua: ClassVar[ResourceType] = ...
    mdl: ClassVar[ResourceType] = ...
    mod: ClassVar[ResourceType] = ...
    mpg: ClassVar[ResourceType] = ...
    mtr: ClassVar[ResourceType] = ...
    mve: ClassVar[ResourceType] = ...
    ncs: ClassVar[ResourceType] = ...
    ndb: ClassVar[ResourceType] = ...
    nss: ClassVar[ResourceType] = ...
    nwm: ClassVar[ResourceType] = ...
    plh: ClassVar[ResourceType] = ...
    plt: ClassVar[ResourceType] = ...
    png: ClassVar[ResourceType] = ...
    ptm: ClassVar[ResourceType] = ...
    ptt: ClassVar[ResourceType] = ...
    pwk: ClassVar[ResourceType] = ...
    sav: ClassVar[ResourceType] = ...
    set: ClassVar[ResourceType] = ...
    shd: ClassVar[ResourceType] = ...
    slt: ClassVar[ResourceType] = ...
    sq3: ClassVar[ResourceType] = ...
    sql: ClassVar[ResourceType] = ...
    ssf: ClassVar[ResourceType] = ...
    tex: ClassVar[ResourceType] = ...
    tga: ClassVar[ResourceType] = ...
    thg: ClassVar[ResourceType] = ...
    tlk: ClassVar[ResourceType] = ...
    tml: ClassVar[ResourceType] = ...
    ttf: ClassVar[ResourceType] = ...
    twoda: ClassVar[ResourceType] = ...
    txi: ClassVar[ResourceType] = ...
    txt: ClassVar[ResourceType] = ...
    utc: ClassVar[ResourceType] = ...
    utd: ClassVar[ResourceType] = ...
    ute: ClassVar[ResourceType] = ...
    utg: ClassVar[ResourceType] = ...
    uti: ClassVar[ResourceType] = ...
    utm: ClassVar[ResourceType] = ...
    utp: ClassVar[ResourceType] = ...
    uts: ClassVar[ResourceType] = ...
    utt: ClassVar[ResourceType] = ...
    utw: ClassVar[ResourceType] = ...
    wav: ClassVar[ResourceType] = ...
    wbm: ClassVar[ResourceType] = ...
    wok: ClassVar[ResourceType] = ...
    xbc: ClassVar[ResourceType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ResourceVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ResourceVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: ResourceVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: ResourceVector) -> bool: ...
    def __getitem__(self, s: slice) -> ResourceVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: ResourceVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: ResourceVector) -> None: ...


class ResrefVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ResrefVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: ResrefVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: ResrefVector) -> bool: ...
    def __getitem__(self, s: slice) -> ResrefVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: ResrefVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: ResrefVector) -> None: ...


class Saves:
    fort: int
    reflex: int
    will: int
    def __init__(self, *args, **kwargs) -> None: ...


class SerializationProfile:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    any: ClassVar[SerializationProfile] = ...
    blueprint: ClassVar[SerializationProfile] = ...
    instance: ClassVar[SerializationProfile] = ...
    savegame: ClassVar[SerializationProfile] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Sound(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    active: bool
    common: Common
    continuous: bool
    distance_max: float
    distance_min: float
    elevation: float
    generated_type: int
    hours: int
    interval: int
    interval_variation: int
    looping: bool
    pitch_variation: float
    positional: bool
    priority: int
    random: bool
    random_position: bool
    random_x: float
    random_y: float
    sounds: ResrefVector
    times: int
    volume: int
    volume_variation: int
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> json: ...


class SoundVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: SoundVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: SoundVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: SoundVector) -> bool: ...
    def __getitem__(self, s: slice) -> SoundVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: SoundVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: SoundVector) -> None: ...


class SpawnCreature:
    appearance: int
    cr: float
    resref: Resref
    single_spawn: bool
    def __init__(self, *args, **kwargs) -> None: ...


class SpawnPoint:
    orientation: float
    position: Any
    def __init__(self, *args, **kwargs) -> None: ...


class SpecialAbility:
    flags: Any
    level: int
    spell: int
    def __init__(self, *args, **kwargs) -> None: ...


class SpellBook:
    def __init__(self, *args, **kwargs) -> None: ...
    def add_known_spell(self, arg0: int, arg1: SpellEntry) -> bool: ...
    def add_memorized_spell(self, arg0: int, arg1: SpellEntry) -> bool: ...
    def get_known_spell(self, arg0: int, arg1: int) -> SpellEntry: ...
    def get_known_spell_count(self, arg0: int) -> int: ...
    def get_memorized_spell(self, arg0: int, arg1: int) -> SpellEntry: ...
    def get_memorized_spell_count(self, arg0: int) -> int: ...
    def remove_known_spell(self, arg0: int, arg1: SpellEntry) -> None: ...
    def remove_memorized_spell(self, arg0: int, arg1: SpellEntry) -> None: ...


class SpellEntry:
    flags: SpellFlags
    meta: SpellMetaMagic
    spell: Spell
    def __init__(self, *args, **kwargs) -> None: ...


class SpellFlags:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    none: ClassVar[SpellFlags] = ...
    readied: ClassVar[SpellFlags] = ...
    spontaneous: ClassVar[SpellFlags] = ...
    unlimited: ClassVar[SpellFlags] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class SpellMetaMagic:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    empower: ClassVar[SpellMetaMagic] = ...
    extend: ClassVar[SpellMetaMagic] = ...
    maximize: ClassVar[SpellMetaMagic] = ...
    none: ClassVar[SpellMetaMagic] = ...
    quicken: ClassVar[SpellMetaMagic] = ...
    silent: ClassVar[SpellMetaMagic] = ...
    still: ClassVar[SpellMetaMagic] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Store(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    blackmarket: bool
    blackmarket_markdown: int
    common: Common
    gold: int
    identify_price: int
    markdown: int
    markup: int
    max_price: int
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> json: ...
    @property
    def armor(self) -> Inventory: ...
    @property
    def miscellaneous(self) -> Inventory: ...
    @property
    def potions(self) -> Inventory: ...
    @property
    def rings(self) -> Inventory: ...
    @property
    def scripts(self) -> StoreScripts: ...
    @property
    def weapons(self) -> Inventory: ...


class StoreScripts:
    on_closed: Resref
    on_opened: Resref
    def __init__(self, *args, **kwargs) -> None: ...


class StoreVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: StoreVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: StoreVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: StoreVector) -> bool: ...
    def __getitem__(self, s: slice) -> StoreVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: StoreVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: StoreVector) -> None: ...


class StringVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: StringVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: str) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: str) -> int: ...
    @overload
    def extend(self, L: StringVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: str) -> None: ...
    @overload
    def pop(self) -> str: ...
    @overload
    def pop(self, i: int) -> str: ...
    def remove(self, x: str) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: str) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: StringVector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> StringVector: ...
    @overload
    def __getitem__(self, arg0: int) -> str: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: StringVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: str) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: StringVector) -> None: ...


class Tile:
    animloop1: int
    animloop2: int
    animloop3: int
    height: int
    id: int
    mainlight1: int
    mainlight2: int
    orientation: int
    srclight1: int
    srclight2: int
    def __init__(self) -> None: ...


class TileVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TileVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: TileVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> TileVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: TileVector) -> None: ...


class Tlk:
    @overload
    def __init__(self, arg0: Path) -> None: ...
    @overload
    def __init__(self, arg0: LanguageID) -> None: ...
    def get(self, arg0: int) -> str: ...
    def language_id(self) -> LanguageID: ...
    def modified(self) -> bool: ...
    def save(self) -> None: ...
    def save_as(self, arg0: Path) -> None: ...
    def set(self, arg0: int, arg1: str) -> None: ...
    def size(self) -> int: ...
    def valid(self) -> bool: ...
    def __getitem__(self, arg0: int) -> str: ...
    def __len__(self) -> int: ...
    def __setitem__(self, arg0: int, arg1: str) -> None: ...


class Transform:
    rotation: Quaternion
    scale: Vector3
    translation: Vector3
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: Vector3, arg1: Quaternion,
                 arg2: Vector3) -> None: ...

    def copy(self) -> Transform: ...
    def inverse(self) -> Transform: ...
    def to_matrix4(self) -> Matrix4: ...
    def transform_point(self, arg0: Vector3) -> Vector3: ...
    def transform_vector(self, arg0: Vector3) -> Vector3: ...
    def __copy__(self) -> Transform: ...
    def __mul__(self, arg0: Transform) -> Transform: ...


class Trap:
    detect_dc: int
    detectable: bool
    disarm_dc: int
    disarmable: bool
    is_trapped: bool
    one_shot: bool
    type: int
    def __init__(self) -> None: ...


class Trigger(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    common: Common
    cursor: int
    faction: int
    geometry: Vec3Vector
    highlight_height: float
    linked_to: str
    linked_to_flags: int
    loadscreen: int
    portrait: int
    scripts: TriggerScripts
    trap: Trap
    type: int
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> json: ...


class TriggerScripts:
    on_click: Resref
    on_disarm: Resref
    on_enter: Resref
    on_exit: Resref
    on_heartbeat: Resref
    on_trap_triggered: Resref
    on_user_defined: Resref
    def __init__(self, *args, **kwargs) -> None: ...


class TriggerVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TriggerVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: TriggerVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: TriggerVector) -> bool: ...
    def __getitem__(self, s: slice) -> TriggerVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: TriggerVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: TriggerVector) -> None: ...


class TwoDA:
    def __init__(self, arg0: Path) -> None: ...
    def column_index(self, arg0: str) -> int: ...
    def columns(self) -> int: ...
    @overload
    def get(self, arg0: int, arg1: int) -> Union[int, float, str]: ...
    @overload
    def get(self, arg0: int, arg1: str) -> Union[int, float, str]: ...
    def pad(self, arg0: int) -> None: ...
    def row(self, arg0: int) -> TwoDARowView: ...
    def rows(self) -> int: ...

    @overload
    def set(self, arg0: int, arg1: str,
            arg2: Union[int, float, str]) -> None: ...

    @overload
    def set(self, arg0: int, arg1: int,
            arg2: Union[int, float, str]) -> None: ...

    def valid(self) -> bool: ...
    def __getitem__(self, arg0: int) -> TwoDARowView: ...


class TwoDARowView:
    def __init__(self, *args, **kwargs) -> None: ...
    def size(self) -> int: ...
    @overload
    def __getitem__(self, arg0: int) -> Union[int, float, str]: ...
    @overload
    def __getitem__(self, arg0: str) -> Union[int, float, str]: ...


class UInt16Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UInt16Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: UInt16Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: UInt16Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> UInt16Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: UInt16Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: UInt16Vector) -> None: ...


class UInt32Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UInt32Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: UInt32Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: UInt32Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> UInt32Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: UInt32Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: UInt32Vector) -> None: ...


class UInt64Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UInt64Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: UInt64Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: UInt64Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> UInt64Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: UInt64Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: UInt64Vector) -> None: ...


class UInt8Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UInt8Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: UInt8Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: UInt8Vector) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> UInt8Vector: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: UInt8Vector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: UInt8Vector) -> None: ...


class Vec3Vector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Vec3Vector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, *args, **kwargs) -> Any: ...
    def clear(self) -> None: ...
    def count(self, *args, **kwargs) -> Any: ...
    @overload
    def extend(self, L: Vec3Vector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, *args, **kwargs) -> Any: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, other) -> Any: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: Vec3Vector) -> bool: ...
    def __getitem__(self, s: slice) -> Vec3Vector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: Vec3Vector) -> bool: ...
    def __setitem__(self, arg0: slice, arg1: Vec3Vector) -> None: ...


class Vector2:
    __hash__: ClassVar[None] = ...
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    def copy(self) -> Vector2: ...
    def dot(self, arg0: Vector2) -> float: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Vector2: ...
    def normalize_self(self) -> None: ...
    def __add__(self, arg0: Vector2) -> Vector2: ...
    def __copy__(self) -> Vector2: ...
    def __eq__(self, arg0: Vector2) -> bool: ...
    def __iadd__(self, arg0: Vector2) -> Vector2: ...
    def __imul__(self, arg0: float) -> Vector2: ...
    def __isub__(self, arg0: Vector2) -> Vector2: ...
    def __mul__(self, arg0: float) -> Vector2: ...
    def __neg__(self) -> Vector2: ...
    def __rmul__(self, arg0: float) -> Vector2: ...
    def __sub__(self, arg0: Vector2) -> Vector2: ...


class Vector3:
    __hash__: ClassVar[None] = ...
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    def copy(self) -> Vector3: ...
    def cross(self, arg0: Vector3) -> Vector3: ...
    def dot(self, arg0: Vector3) -> float: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Vector3: ...
    def normalize_self(self) -> None: ...
    def __add__(self, arg0: Vector3) -> Vector3: ...
    def __copy__(self) -> Vector3: ...
    def __eq__(self, arg0: Vector3) -> bool: ...
    def __iadd__(self, arg0: Vector3) -> Vector3: ...
    def __imul__(self, arg0: float) -> Vector3: ...
    def __isub__(self, arg0: Vector3) -> Vector3: ...
    def __mul__(self, arg0: float) -> Vector3: ...
    def __neg__(self) -> Vector3: ...
    def __rmul__(self, arg0: float) -> Vector3: ...
    def __sub__(self, arg0: Vector3) -> Vector3: ...


class Vector4:
    __hash__: ClassVar[None] = ...
    w: float
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: float, arg1: float,
                 arg2: float, arg3: float) -> None: ...

    def copy(self) -> Vector4: ...
    def dot(self, arg0: Vector4) -> float: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Vector4: ...
    def normalize_self(self) -> None: ...
    def __add__(self, arg0: Vector4) -> Vector4: ...
    def __copy__(self) -> Vector4: ...
    def __eq__(self, arg0: Vector4) -> bool: ...
    def __iadd__(self, arg0: Vector4) -> Vector4: ...
    def __imul__(self, arg0: float) -> Vector4: ...
    def __isub__(self, arg0: Vector4) -> Vector4: ...
    def __mul__(self, arg0: float) -> Vector4: ...
    def __neg__(self) -> Vector4: ...
    def __rmul__(self, arg0: float) -> Vector4: ...
    def __sub__(self, arg0: Vector4) -> Vector4: ...


class VertexVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VertexVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: VertexVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> VertexVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VertexVector) -> None: ...


class Waypoint(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    appearance: int
    common: Common
    description: LocString
    has_map_note: bool
    linked_to: str
    map_note: LocString
    map_note_enabled: bool
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> json: ...


class WaypointVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: WaypointVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: WaypointVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: WaypointVector) -> bool: ...
    def __getitem__(self, s: slice) -> WaypointVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: WaypointVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: WaypointVector) -> None: ...


class Zip(Container):
    def __init__(self, arg0: os.PathLike) -> None: ...


def decode_plt_color(arg0: Plt, arg1: PltColors, arg2: int,
                     arg3: int) -> List[int[4]]: ...


def probe_nwn_install(only: GameVersion = ...) -> InstallInfo: ...
def resmatch(arg0, arg1: str) -> bool: ...
def resource_type_to_string(arg0) -> str: ...
