class ADTColumnDescription:
    """
    This class contains a descriptor of the format of a dataset in ADT
    It allows the description of each column and how it should be considered during a transformation
    - fixed : means that the data is a non changing value that stay constant through time,
      or can be used as an initialization
    - change : represent a change over time which means it needs a timestep for when it takes effect,
      and the new value for the subsequent time steps
    - event : represent a ponctual event over time, the change is not permanent and on subsequent timestep
      without other values nothing happens
    """

    format = {
        "Stock": {
            "fixed": [
                "id",
                "Label",
                "PlantName",
                "Step",
                "PartId",
                "MinimalStock",
                "MaximalStock",
                "InitialStock",
                "InitialValue",
                "IsInfinite",
                "BacklogWeight",
                "MaximizationWeight",
                "StockPolicy",
                "SourcingPolicy",
                "DispatchPolicy",
                "ReviewPeriod",
                "FirstReview",
                "Advance",
                "Latitude",
                "Longitude",
                "IgnoreDownstreamRequiredQuantities",
                "SourcingLimit",
                "InitialBacklog",
                "CoverageHorizon",
                "CoverageOffset",
                "CoverageRate",
                "OrderForEndOfTimeStep",
                "subdataset",
            ],
            "change": [
                "StorageUnitCosts",
                "OrderPoints",
                "OrderQuantities",
                "OrderUpToLevels",
                "SafetyQuantities",
                "PurchasingUnitCosts",
                "CO2UnitEmissions",
                "UnitIncomes",
                "RetainProportions",
            ],
            "event": {
                "Demands": [
                    "Demands",
                    "DemandWeights",
                ],
                "SalesForecasts": [
                    "SalesForecasts",
                ],
            },
            "quantity": {
                "PurchasingCosts": [
                    "VariablePurchasingUnitCosts"
                ],
            },
        },
        "Transport": {
            "fixed": [
                "Label",  # TODO to be replaced by RelationshipId when available from azure-digital-twins-simulator-connector
                "source",
                "target",
                "Duration",
                "Priority",
                "Mode",
                "subdataset",
            ],
            "change": [
                "CustomFees",
                "TransportUnitCosts",
                "CO2UnitEmissions",
                "ActualDurations",
                "MinimumOrderQuantities",
                "MultipleOrderQuantities",
                "SourcingProportions",
                "DispatchProportions",
            ],
            "event": {
                "InitialTransports": [
                    "InitialTransportedQuantities",
                    "InitialTransportedValues",
                ]
            },
            "quantity": {},
        },
        "Configuration": {
            "fixed": [
                "ActivateUncertainties",
                "ActivateVariableMachineOpeningRate",
                "BatchSize",
                "EmptyObsoleteStocks",
                "EnforceProductionPlan",
                "InventoryCapitalCost",
                "ManageBacklogQuantities",
                "OptimizationObjective",
                "SimulatedCycles",
                "StartingDate",
                "StepsPerCycle",
                "TimeStepDuration",
                "IntermediaryStockDispatchPolicy",
                "ActualizeShipments",
                "CarbonTax",
                "Kpi",
                "OptimizationMode",
                "Statistic",
                "TargetedValue",
                "DecisionVariable",
                "DecisionVariableMin",
                "DecisionVariableMax",
                "OptimizationMaximalDuration",
                "OptimizationAlgorithm",
                "OptimizationBatchSize",
                "SampleSizeUncertaintyAnalysis",
                "FinalSampleSizeUncertaintyAnalysis",
                "MaxIterationsForOptim",
                "AutomaticParallelizationConfig",
                "MaxNumberOfSimInParallel",
                "ServeDemandBeforeBacklog",
                "SelectedTimeStep",
                "SelectedTag",
                "InventoryQuantityForCostComputation",
                "ConstraintHandling",
                "OptimizationParallelization",
                "UncertaintyAnalysisParallelization",
                "UncertaintyAnalysisSeedForOptimization",
                "UncertaintyAnalysisSeed",
                "OptimizationSeed",
                "UncertaintyAnalysisOutputData",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "Uncertainties": {
            "fixed": [
                "id",
                "Entity",
                "Attribute",
                "TimeStep",
                "UncertaintyMode",
                "UncertaintyModel",
                "Parameters",
                "subdataset",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "OptimizationConstraints": {
            "fixed": [
                "id",
                "ConstrainedKpi",
                "Statistic",
                "ConstraintType",
                "ConstraintValue",
                "PenaltyCoefficient",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "OptimizationDecisionVariables": {
            "fixed": [
                "id",
                "SelectedEntity",
                "SelectedTag",
                "Attribute",
                "AttributeMinimumValue",
                "AttributeMaximumValue",
                "subdataset",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "OptDecisionVariableGroups": {
            "fixed": [
                "id",
                "GroupTag",
                "Attribute",
                "GroupBehaviorMode",
                "DecisionVariableMinimum",
                "DecisionVariableMaximum",
                "DecisionVariableStartingPoint",
                "subdataset",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "contains": {
            "fixed": [
                "source",
                "target",
                "subdataset",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "output": {
            "fixed": [
                "source",
                "target",
                "subdataset",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "input": {
            "fixed": [
                "source",
                "target",
                "InputQuantity",
                "subdataset",
            ],
            "change": [
                "DispatchProportions",
            ],
            "event": {},
            "quantity": {},
        },
        "ProductionResource": {
            "fixed": [
                "id",
                "Label",
                "PlantName",
                "ProductionStep",
                "ProductionPolicy",
                "Latitude",
                "Longitude",
                "subdataset",
            ],
            "change": [
                "FixedProductionCosts",
                "OpeningTimes",
                "OpeningRates",
            ],
            "event": {},
            "quantity": {},
        },
        "ProductionOperation": {
            "fixed": [
                "id",
                "Label",
                "PlantName",
                "IsContractor",
                "InvestmentCost",
                "Priority",
                "Duration",
                "subdataset",
            ],
            "change": [
                "QuantitiesToProduce",
                "OperatingPerformances",
                "CycleTimes",
                "RejectRates",
                "ProductionUnitCosts",
                "CO2UnitEmissions",
                "MinimumOrderQuantities",
                "MultipleOrderQuantities",
                "SourcingProportions",
                "ProductionProportions",
            ],
            "event": {},
            "quantity": {},
        },
        "Tags": {
            "fixed": [
                "id",
                "TagType",
                "subdataset",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
        "TagGroups": {
            "fixed": [
                "source",
                "target",
                "subdataset",
            ],
            "change": [],
            "event": {},
            "quantity": {},
        },
    }
