// Verner's explicit "most efficient" RKF56
// http://people.math.sfu.ca/~jverner/
#define RKF56 1
#if RK == 1     // only load if required
#define RKF56_stages 9       // Must be compile time constant in array allocation and manual loop unrolling, hence the #define instead of constant
constant int RKF56_order = 5;        // order of lower order solution
constant real RKF56_a[]  = {
    0.6e-1,

    0.1923996296296296296296296296296296296296e-1,
    0.7669337037037037037037037037037037037037e-1,

    0.35975e-1,
    0.0,
    0.107925,

    1.318683415233148260919747276431735612861,
    0.0,
    -5.042058063628562225427761634715637693344,
    4.220674648395413964508014358283902080483,

    -41.87259166432751461803757780644346812905,
    0.0,
    159.4325621631374917700365669070346830453,
    -122.1192135650100309202516203389242140663,
    5.531743066200053768252631238332999150076,

    -54.43015693531650433250642051294142461271,
    0.0,
    207.0672513650184644273657173866509835987,
    -158.6108137845899991828742424365058599469,
    6.991816585950242321992597280791793907096,
    -0.1859723106220323397765171799549294623692e-1,

    -54.66374178728197680241215648050386959351,
    0.0,
    207.9528062553893734515824816699834244238,
    -159.2889574744995071508959805871426654216,
    7.018743740796944434698170760964252490817,
    -0.1833878590504572306472782005141738268361e-1,
    -0.5119484997882099077875432497245168395840e-3,

    0.3438957868357036009278820124728322386520e-1,
    0.0,
    0.0,
    0.2582624555633503404659558098586120858767,
    0.4209371189673537150642551514069801967032,
    4.405396469669310170148836816197095664891,
    -176.4831190242986576151740942499002125029,
    172.3641334014150730294022582711902413315
}; // butcher table omitting upper and diagonal zeros
constant real RKF56_b1[] = {
    0.3438957868357036009278820124728322386520e-1,
    0.0,
    0.0,
    0.2582624555633503404659558098586120858767,
    0.4209371189673537150642551514069801967032,
    4.405396469669310170148836816197095664891,
    -176.4831190242986576151740942499002125029,
    172.3641334014150730294022582711902413315,
    0.0
}; // higher order solution
//constant real RKF56_b2[] = {
//    0.4909967648382489730906854927971225836479e-1,
//    0.0,
//    0.0,
//    0.2251112229516524153401395320539875329485,
//    0.4694682253029562039431948525047387412553,
//    0.8065792249988867707634161808995217981443,
//    0.0,
//    -0.6071194891777959797672951465256217122488,
//    0.5686113944047569241147603178766138153594e-1
//}; // lower order solution
constant real RKF56_d[]  = {
    -1.471009780025453721628034803242903449959e-2,
    0.0,
    0.0,
    3.31512326116979251258162778046245529282e-2,
    -4.85311063356024888789397010977585445521e-2,
    3.598817244670423399385420635297573866746,
    -176.4831190242986576151740942499002125029,
    1.729712528905928690091695534177158630437e2,
    -0.5686113944047569241147603178766138153594e-1
}; // difference b1-b2
constant real RKF56_c[]  = {
    0.0,
    0.6e-1,
    0.9593333333333333333333333333333333333333e-1,
    0.1439,
    0.4973,
    0.9725,
    0.9995,
    1.0,
    1.0
}; // time step factors
#endif
#undef RKF56
