// Verner's explicit "most efficient" RKF67
// http://people.math.sfu.ca/~jverner/
#define RKF67 1
#if RK == 1     // only load if required
#define RKF67_stages 10       // Must be compile time constant in array allocation and manual loop unrolling, hence the #define instead of constant
constant int RKF67_order = 6;        // order of lower order solution
constant real RKF67_a[]  = {
    0.5000000000000000000000000000000000000000e-2,

    -1.076790123456790123456790123456790123457,
    1.185679012345679012345679012345679012346,

    0.4083333333333333333333333333333333333333e-1,
    0.0,
    0.1225000000000000000000000000000000000000,

    0.6389139236255726780508121615993336109954,
    0.0,
    -2.455672638223656809662640566430653894211,
    2.272258714598084131611828404831320283215,

    -2.661577375018757131119259297861818119279,
    0.0,
    10.80451388645613769565396655365532838482,
    -8.353914657396199411968048547819291691541,
    0.8204875949566569791420417341743839209619,

    6.067741434696770992718360183877276714679,
    0.0,
    -24.71127363591108579734203485290746001803,
    20.42751793078889394045773111748346612697,
    -1.906157978816647150624096784352757010879,
    1.006172249242068014790040335899474187268,

    12.05467007625320299509109452892778311648,
    0.0,
    -49.75478495046898932807257615331444758322,
    41.14288863860467663259698416710157354209,
    -4.461760149974004185641911603484815375051,
    2.042334822239174959821717077708608543738,
    -0.9834843665406107379530801693870224403537e-1,

    10.13814652288180787641845141981689030769,
    0.0,
    -42.64113603171750214622846006736635730625,
    35.76384003992257007135021178023160054034,
    -4.348022840392907653340370296908245943710,
    2.009862268377035895441943593011827554771,
    0.3487490460338272405953822853053145879140,
    -0.2714390051048312842371587140910297407572,

    -45.03007203429867712435322405073769635151,
    0.0,
    187.3272437654588840752418206154201997384,
    -154.0288236935018690596728621034510402582,
    18.56465306347536233859492332958439136765,
    -7.141809679295078854925420496823551192821,
    1.308808578161378625114762706007696696508,
    0.0,
    0.0
}; // butcher table omitting upper and diagonal zeros
constant real RKF67_b1[] = {
    0.4715561848627222170431765108838175679569e-1,
    0.0,
    0.0,
    0.2575056429843415189596436101037687580986,
    0.2621665397741262047713863095764527711129,
    0.1521609265673855740323133199165117535523,
    0.4939969170032484246907175893227876844296,
    -0.2943031171403250441557244744092703429139,
    0.8131747232495109999734599440136761892478e-1,
    0.0
}; // higher order solution
//constant real RKF67_b2[] = {
//    0.4460860660634117628731817597479197781432e-1,
//    0.0,
//    0.0,
//    0.2671640378571372680509102260943837899738,
//    0.2201018300177293019979715776650753096323,
//    0.2188431703143156830983120833512893824578,
//    0.2289871705411202883378173889763552365362,
//    0.0,
//    0.0,
//    0.2029518466335628222767054793810430358554e-1
//}; // lower order solution
constant real RKF67_d[]  = {
    2.54701187993104541699947511358977898137e-3,
    0.0,
    0.0,
    -9.6583948727957490912666159906150318752e-3,
    4.20647097563969027734147319113774614806e-2,
    -6.66822437469301090659987634347776289055e-2,
    2.650097464621281363529002003464324478934e-1,
    -0.2943031171403250441557244744092703429139,
    0.8131747232495109999734599440136761892478e-1,
    -0.2029518466335628222767054793810430358554e-1
}; // difference b1-b2
constant real RKF67_c[]  = {
    0.0,
    0.5000000000000000000000000000000000000000e-2,
    0.1088888888888888888888888888888888888889,
    0.1633333333333333333333333333333333333333,
    0.4555000000000000000000000000000000000000,
    0.6095094489978381317087004421486024949638,
    0.8840000000000000000000000000000000000000,
    0.9250000000000000000000000000000000000000,
    1.0,
    1.0
}; // time step factors
#endif
#undef RKF67
