// Verner's explicit "most efficient" RKF78
// http://people.math.sfu.ca/~jverner/
#define RKF78 1
#if RK == 1     // only load if required
#define RKF78_stages 13       // Must be compile time constant in array allocation and manual loop unrolling, hence the #define instead of constant
constant int RKF78_order = 7;        // order of lower order solution
constant real RKF78_a[]  = {
    0.5000000000000000000000000000000000000000e-1,

    -0.6993164062500000000000000000000000000000e-2,
    0.1135556640625000000000000000000000000000,

    0.3996093750000000000000000000000000000000e-1,
    0.0,
    0.1198828125000000000000000000000000000000,

    0.3613975628004575124052940721184028345129,
    0.0,
    -1.341524066700492771819987788202715834917,
    1.370126503900035259414693716084313000404,

    0.4904720279720279720279720279720279720280e-1,
    0.0,
    0.0,
    0.2350972042214404739862988335493427143122,
    0.1808555929813567288109039636534544884850,

    0.6169289044289044289044289044289044289044e-1,
    0.0,
    0.0,
    0.1123656831464027662262557035130015442303,
    -0.3885046071451366767049048108111244567456e-1,
    0.1979188712522045855379188712522045855379e-1,

    -1.767630240222326875735597119572145586714,
    0.0,
    0.0,
    -62.50000000000000000000000000000000000000,
    -6.061889377376669100821361459659331999758,
    5.650823198222763138561298030600840174201,
    65.62169641937623283799566054863063741227,

    -1.180945066554970799825116282628297957882,
    0.0,
    0.0,
    -41.50473441114320841606641502701994225874,
    -4.434438319103725011225169229846100211776,
    4.260408188586133024812193710744693240761,
    43.75364022446171584987676829438379303004,
    0.7871425489912310687446475044226307550860e-2,

    -1.281405999441488405459510291182054246266,
    0.0,
    0.0,
    -45.04713996013986630220754257136007322267,
    -4.731362069449576477311464265491282810943,
    4.514967016593807841185851584597240996214,
    47.44909557172985134869022392235929015114,
    0.1059228297111661135687393955516542875228e-1,
    -0.5746842263844616254432318478286296232021e-2,

    -1.724470134262485191756709817484481861731,
    0.0,
    0.0,
    -60.92349008483054016518434619253765246063,
    -5.951518376222392455202832767061854868290,
    5.556523730698456235979791650843592496839,
    63.98301198033305336837536378635995939281,
    0.1464202825041496159275921391759452676003e-1,
    0.6460408772358203603621865144977650714892e-1,
    -0.7930323169008878984024452548693373291447e-1,

    -3.301622667747079016353994789790983625569,
    0.0,
    0.0,
    -118.0112723597525085666923303957898868510,
    -10.14142238845611248642783916034510897595,
    9.139311332232057923544012273556827000619,
    123.3759428284042683684847180986501894364,
    4.623244378874580474839807625067630924792,
    -3.383277738068201923652550971536811240814,
    4.527592100324618189451265339351129035325,
    -5.828495485811622963193088019162985703755,

    -3.039515033766309030040102851821200251056,
    0.0,
    0.0,
    -109.2608680894176254686444192322164623352,
    -9.290642497400293449717665542656897549158,
    8.430504981764911142134299253836167803454,
    114.2010010378331313557424041095523427476,
    -0.9637271342145479358162375658987901652762,
    -5.034884088802189791198680336183332323118,
    5.958130824002923177540402165388172072794,
    0.0,
    0.0
}; // butcher table omitting upper and diagonal zeros
constant real RKF78_b1[] = {
    0.4427989419007951074716746668098518862111e-1,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3541049391724448744815552028733568354121,
    0.2479692154956437828667629415370663023884,
    -15.69420203883808405099207034271191213468,
    25.08406496555856261343930031237186278518,
    -31.73836778626027646833156112007297739997,
    22.93828327398878395231483560344797018313,
    -0.2361324633071542145259900641263517600737,
    0.0
}; // higher order solution
//constant real RKF78_b2[] = {
//    0.4431261522908979212486436510209029764893e-1,
//    0.0,
//    0.0,
//    0.0,
//    0.0,
//    0.3546095642343226447863179350895055038855,
//    0.2478480431366653069619986721504458660016,
//    4.448134732475784492725128317159648871312,
//    19.84688636611873369930932399297687935291,
//    -23.58162337746561841969517960870394965085,
//    0.0,
//    0.0,
//    -0.3601679437289775162124536737746202409110
//}; // lower order solution
constant real RKF78_d[]  = {
    -3.272103901028137769689842110510902782e-5,
    0.0,
    0.0,
    0.0,
    0.0,
    -5.046250618777703047627322161486684734e-4,
    1.211723589784759047642693866204363868e-4,
    -2.014233677131386854371719865987156100599e1,
    5.23717859943982891412997631939498343227,
    -8.15674440879465804863638151136902774912,
    22.93828327398878395231483560344797018313,
    -0.2361324633071542145259900641263517600737,
    0.3601679437289775162124536737746202409110
}; // difference b1-b2
constant real RKF78_c[]  = {
    0.0,
    0.5000000000000000000000000000000000000000e-1,
    0.1065625000000000000000000000000000000000,
    0.1598437500000000000000000000000000000000,
    0.3900000000000000000000000000000000000000,
    0.4650000000000000000000000000000000000000,
    0.1550000000000000000000000000000000000000,
    0.9430000000000000000000000000000000000000,
    0.9018020417358569582597079406783721499560,
    0.9090000000000000000000000000000000000000,
    0.9400000000000000000000000000000000000000,
    1.0,
    1.0
}; // time step factors
#endif
#undef RKF78
