"""
constants.py

此模块定义了农历计算中使用的各种常量，包括月份名称、日期名称、天干地支等。
"""

# 月份名称列表
YUEFEN = ["正月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]

# 农历日期名称列表
NLRQ = ["初一", "初二", "初三", "初四", "初五", "初六", "初七", "初八", "初九", "初十", "十一", "十二", "十三", "十四",
        "十五", "十六", "十七", "十八", "十九", "二十", "廿一", "廿二", "廿三", "廿四", "廿五", "廿六", "廿七", "廿八",
        "廿九", "三十"]

# 天干列表
TIANGAN = ["甲", "乙", "丙", "丁", "戊", "己", "庚", "辛", "壬", "癸"]

# 地支列表
DIZHI = ["子", "丑", "寅", "卯", "辰", "巳", "午", "未", "申", "酉", "戌", "亥"]

# 六十甲子表
GANZHI_CYCLE = [''] * 60
for i in range(60):
    GANZHI_CYCLE[i] = TIANGAN[i % 10] + DIZHI[i % 12]
