/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.measures.continuous.TransferEntropyCommon;
import infodynamics.measures.continuous.kernel.KernelEstimatorTransferEntropy;
import infodynamics.measures.continuous.kernel.TransferEntropyKernelCounts;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class TransferEntropyCalculatorKernel
extends TransferEntropyCommon
implements TransferEntropyCalculator {
    protected KernelEstimatorTransferEntropy teKernelEstimator = new KernelEstimatorTransferEntropy();
    protected double[][] destPastVectors;
    protected double[] destNextValues;
    protected double[] sourceValues;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    private boolean dynCorrExcl = false;
    private int dynCorrExclTime = 0;
    public static final String DYN_CORR_EXCL_TIME_NAME = "DYN_CORR_EXCL";
    private boolean forceCompareToAll = false;
    public static final String FORCE_KERNEL_COMPARE_TO_ALL = "FORCE_KERNEL_COMPARE_TO_ALL";
    public static final double DEFAULT_KERNEL_WIDTH = 0.25;
    private double kernelWidth = 0.25;
    public static final String KERNEL_WIDTH_PROP_NAME = "KERNEL_WIDTH";
    public static final String EPSILON_PROP_NAME = "EPSILON";

    public TransferEntropyCalculatorKernel() {
        this.teKernelEstimator.setNormalise(this.normalise);
    }

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.kernelWidth);
    }

    public void initialise(int n, double d) throws Exception {
        this.kernelWidth = d;
        super.initialise(n);
    }

    @Override
    public void initialise() {
        this.teKernelEstimator.initialise(this.k, this.kernelWidth);
        this.destPastVectors = null;
        this.destNextValues = null;
        this.sourceValues = null;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.kernelWidth = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            this.teKernelEstimator.setNormalise(this.normalise);
        } else if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            boolean bl2 = this.dynCorrExcl = this.dynCorrExclTime > 0;
            if (this.dynCorrExcl) {
                this.teKernelEstimator.setDynamicCorrelationExclusion(this.dynCorrExclTime);
            } else {
                this.teKernelEstimator.clearDynamicCorrelationExclusion();
            }
        } else if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            this.forceCompareToAll = Boolean.parseBoolean(string2);
            this.teKernelEstimator.setForceCompareToAll(this.forceCompareToAll);
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) {
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            return Double.toString(this.kernelWidth);
        }
        if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            return Boolean.toString(this.normalise);
        }
        if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            return Integer.toString(this.dynCorrExclTime);
        }
        if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            return Boolean.toString(this.forceCompareToAll);
        }
        return super.getProperty(string);
    }

    @Override
    public void finaliseAddObservations() {
        Object object2;
        this.totalObservations = 0;
        for (Object object2 : this.vectorOfDestinationObservations) {
            this.totalObservations += ((double[])object2).length - this.k;
        }
        this.destPastVectors = new double[this.totalObservations][this.k];
        this.destNextValues = new double[this.totalObservations];
        this.sourceValues = new double[this.totalObservations];
        int n = 0;
        object2 = this.vectorOfDestinationObservations.iterator();
        for (double[] dArray : this.vectorOfSourceObservations) {
            double[] dArray2 = (double[])object2.next();
            double[][] dArray3 = this.makeJointVectorForPast(dArray2);
            MatrixUtils.arrayCopy(dArray3, 0, 0, this.destPastVectors, n, 0, dArray3.length, this.k);
            System.arraycopy(dArray2, this.k, this.destNextValues, n, dArray2.length - this.k);
            System.arraycopy(dArray, this.k - 1, this.sourceValues, n, dArray.length - this.k);
            n += dArray2.length - this.k;
        }
        this.teKernelEstimator.setObservations(this.destPastVectors, this.destNextValues, this.sourceValues);
        boolean bl = this.addedMoreThanOneObservationSet = this.vectorOfDestinationObservations.size() > 1;
        if (this.addedMoreThanOneObservationSet && this.dynCorrExcl) {
            throw new RuntimeException("Addition of multiple observation sets is not currently supported with property DYN_CORR_EXCL set");
        }
        this.vectorOfSourceObservations = null;
        this.vectorOfDestinationObservations = null;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        double d = 0.0;
        if (this.debug) {
            MatrixUtils.printMatrix(System.out, this.destPastVectors);
        }
        for (int i = 0; i < this.totalObservations; ++i) {
            TransferEntropyKernelCounts transferEntropyKernelCounts = this.teKernelEstimator.getCount(this.destPastVectors[i], this.destNextValues[i], this.sourceValues[i], i);
            double d2 = 0.0;
            double d3 = 0.0;
            if (transferEntropyKernelCounts.countNextPastSource > 0) {
                d2 = (double)transferEntropyKernelCounts.countNextPastSource / (double)transferEntropyKernelCounts.countPastSource / ((double)transferEntropyKernelCounts.countNextPast / (double)transferEntropyKernelCounts.countPast);
                d3 = Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + this.destPastVectors[i][0] + " (" + transferEntropyKernelCounts.countNextPastSource + " / " + transferEntropyKernelCounts.countPastSource + ") / (" + transferEntropyKernelCounts.countNextPast + " / " + transferEntropyKernelCounts.countPast + ") = " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservationsWithCorrection() throws Exception {
        double d = 0.0;
        int n = 0;
        double d2 = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            TransferEntropyKernelCounts transferEntropyKernelCounts = this.teKernelEstimator.getCount(this.destPastVectors[i], this.destNextValues[i], this.sourceValues[i], i);
            double d3 = 0.0;
            if (transferEntropyKernelCounts.countPastSource > 0) {
                d3 -= MathsUtils.digamma(transferEntropyKernelCounts.countPastSource);
            }
            if (transferEntropyKernelCounts.countNextPast > 0) {
                d3 -= MathsUtils.digamma(transferEntropyKernelCounts.countNextPast);
            }
            if (transferEntropyKernelCounts.countPast > 0) {
                d3 += MathsUtils.digamma(transferEntropyKernelCounts.countPast);
            }
            if (transferEntropyKernelCounts.countNextPastSource > 0) {
                d3 += MathsUtils.digamma(transferEntropyKernelCounts.countNextPastSource);
            } else {
                d2 += d3;
                ++n;
            }
            d += d3;
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        if (this.debug) {
            System.out.printf("TE=%.4f, with %d contributions from 0 neighbour sets being %.4f\n", this.lastAverage, n, d2 / (double)this.totalObservations / Math.log(2.0));
        }
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(null, null, true);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, false);
    }

    private double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2, boolean bl) throws Exception {
        double[] dArray3;
        double[] dArray4;
        double[] dArray5;
        double[][] dArray6;
        if (bl) {
            dArray6 = this.destPastVectors;
            dArray5 = this.destNextValues;
            dArray4 = this.sourceValues;
        } else {
            dArray6 = this.makeJointVectorForPast(dArray2);
            dArray5 = MatrixUtils.select(dArray2, this.k, dArray2.length - this.k);
            dArray4 = MatrixUtils.select(dArray, this.k - 1, dArray.length - this.k);
        }
        double d = 0.0;
        int n = dArray6.length;
        int n2 = 0;
        if (bl && this.addedMoreThanOneObservationSet) {
            dArray3 = new double[n];
            n2 = 0;
        } else {
            dArray3 = new double[n + this.k];
            n2 = this.k;
        }
        for (int i = 0; i < n; ++i) {
            TransferEntropyKernelCounts transferEntropyKernelCounts = bl ? this.teKernelEstimator.getCount(dArray6[i], dArray5[i], dArray4[i], i) : this.teKernelEstimator.getCount(dArray6[i], dArray5[i], dArray4[i], -1);
            double d2 = 0.0;
            double d3 = 0.0;
            if (transferEntropyKernelCounts.countNextPastSource > 0) {
                d2 = (double)transferEntropyKernelCounts.countNextPastSource / (double)transferEntropyKernelCounts.countPastSource / ((double)transferEntropyKernelCounts.countNextPast / (double)transferEntropyKernelCounts.countPast);
                d3 = Math.log(d2);
            }
            dArray3[n2 + i] = d3;
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)n / Math.log(2.0);
        return dArray3;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.totalObservations, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        int n = nArray.length;
        double d = this.computeAverageLocalOfObservations();
        double[] dArray = this.sourceValues;
        int n2 = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        for (int i = 0; i < n; ++i) {
            double d2;
            this.sourceValues = MatrixUtils.extractSelectedTimePoints(dArray, nArray[i]);
            this.teKernelEstimator.initialise(this.k, this.kernelWidth);
            this.teKernelEstimator.setObservations(this.destPastVectors, this.destNextValues, this.sourceValues);
            empiricalMeasurementDistribution.distribution[i] = d2 = this.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n2;
        }
        this.lastAverage = d;
        this.sourceValues = dArray;
        this.teKernelEstimator.initialise(this.k, this.kernelWidth);
        this.teKernelEstimator.setObservations(this.destPastVectors, this.destNextValues, this.sourceValues);
        empiricalMeasurementDistribution.pValue = (double)n2 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    @Override
    public void setDebug(boolean bl) {
        super.setDebug(bl);
        this.teKernelEstimator.setDebug(bl);
    }
}

