/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.EntropyCalculatorDiscrete;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;

public class BlockEntropyCalculatorDiscrete
extends EntropyCalculatorDiscrete {
    protected int blocksize = 0;
    protected int[] maxShiftedValue = null;
    protected int base_power_blocksize = 0;

    public static EntropyCalculatorDiscrete newInstance(int n, int n2) {
        return new BlockEntropyCalculatorDiscrete(n, n2);
    }

    public BlockEntropyCalculatorDiscrete(int n, int n2) {
        super(n2);
        this.blocksize = n;
        this.base_power_blocksize = MathsUtils.power(n2, n);
        if (n <= 1) {
            throw new RuntimeException("Blocksize " + n + " is not > 1 for Block Entropy Calculator");
        }
        if ((double)n > Math.log(2.147483647E9) / this.log_base) {
            throw new RuntimeException("Base and blocksize combination too large");
        }
        this.stateCount = new int[MathsUtils.power(n2, n)];
        this.maxShiftedValue = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.maxShiftedValue[i] = i * MathsUtils.power(n2, n - 1);
        }
    }

    @Override
    public void initialise() {
        super.initialise();
        MatrixUtils.fill(this.stateCount, 0);
    }

    @Override
    public void addObservations(int[] nArray) {
        int n;
        int n2 = nArray.length;
        this.observations += n2 - this.blocksize + 1;
        int n3 = 0;
        for (n = 0; n < this.blocksize - 1; ++n) {
            n3 += nArray[n];
            n3 *= this.base;
        }
        for (n = this.blocksize - 1; n < n2; ++n) {
            int n4 = n3 += nArray[n];
            this.stateCount[n4] = this.stateCount[n4] + 1;
            n3 -= this.maxShiftedValue[nArray[n - this.blocksize + 1]];
            n3 *= this.base;
        }
    }

    @Override
    public void addObservations(int[][] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        this.observations += (n3 - this.blocksize + 1) * n4;
        int[] nArray2 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray2[n2] = 0;
            for (n = 0; n < this.blocksize - 1; ++n) {
                int n5 = n2;
                nArray2[n5] = nArray2[n5] + nArray[n][n2];
                int n6 = n2;
                nArray2[n6] = nArray2[n6] * this.base;
            }
        }
        for (n2 = this.blocksize - 1; n2 < n3; ++n2) {
            n = 0;
            while (n < n4) {
                int n7 = n;
                nArray2[n7] = nArray2[n7] + nArray[n2][n];
                int n8 = nArray2[n];
                this.stateCount[n8] = this.stateCount[n8] + 1;
                int n9 = n;
                nArray2[n9] = nArray2[n9] - this.maxShiftedValue[nArray[n2 - this.blocksize + 1][n]];
                int n10 = n++;
                nArray2[n10] = nArray2[n10] * this.base;
            }
        }
    }

    @Override
    public void addObservations(int[][][] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = nArray.length;
        if (n4 == 0) {
            return;
        }
        int n5 = nArray[0].length;
        if (n5 == 0) {
            return;
        }
        int n6 = nArray[0][0].length;
        this.observations += (n4 - this.blocksize + 1) * n5 * n6;
        int[][] nArray2 = new int[n5][n6];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                nArray2[n3][n2] = 0;
                for (n = 0; n < this.blocksize - 1; ++n) {
                    int[] nArray3 = nArray2[n3];
                    int n7 = n2;
                    nArray3[n7] = nArray3[n7] + nArray[n][n3][n2];
                    int[] nArray4 = nArray2[n3];
                    int n8 = n2;
                    nArray4[n8] = nArray4[n8] * this.base;
                }
            }
        }
        for (n3 = this.blocksize - 1; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                n = 0;
                while (n < n6) {
                    int[] nArray5 = nArray2[n2];
                    int n9 = n;
                    nArray5[n9] = nArray5[n9] + nArray[n3][n2][n];
                    int n10 = nArray2[n2][n];
                    this.stateCount[n10] = this.stateCount[n10] + 1;
                    int[] nArray6 = nArray2[n2];
                    int n11 = n;
                    nArray6[n11] = nArray6[n11] - this.maxShiftedValue[nArray[n3 - this.blocksize + 1][n2][n]];
                    int[] nArray7 = nArray2[n2];
                    int n12 = n++;
                    nArray7[n12] = nArray7[n12] * this.base;
                }
            }
        }
    }

    @Override
    public void addObservations(int[][] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        this.observations += n3 - this.blocksize + 1;
        int n4 = 0;
        for (n2 = 0; n2 < this.blocksize - 1; ++n2) {
            n4 += nArray[n2][n];
            n4 *= this.base;
        }
        for (n2 = this.blocksize - 1; n2 < n3; ++n2) {
            int n5 = n4 += nArray[n2][n];
            this.stateCount[n5] = this.stateCount[n5] + 1;
            n4 -= this.maxShiftedValue[nArray[n2 - this.blocksize + 1][n]];
            n4 *= this.base;
        }
    }

    @Override
    public void addObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4 = nArray.length;
        this.observations += n4 - this.blocksize + 1;
        int n5 = 0;
        for (n3 = 0; n3 < this.blocksize - 1; ++n3) {
            n5 += nArray[n3][n][n2];
            n5 *= this.base;
        }
        for (n3 = this.blocksize - 1; n3 < n4; ++n3) {
            int n6 = n5 += nArray[n3][n][n2];
            this.stateCount[n6] = this.stateCount[n6] + 1;
            n5 -= this.maxShiftedValue[nArray[n3 - this.blocksize + 1][n][n2]];
            n5 *= this.base;
        }
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < this.base_power_blocksize; ++i) {
            double d3 = (double)this.stateCount[i] / (double)this.observations;
            if (d3 > 0.0) {
                double d4 = -Math.log(d3) / this.log_2;
                d2 = d3 * d4;
                if (d4 > this.max) {
                    this.max = d4;
                } else if (d4 < this.min) {
                    this.min = d4;
                }
            } else {
                d2 = 0.0;
            }
            d += d2;
        }
        this.average = d;
        return d;
    }

    @Override
    public double[][] computeLocalFromPreviousObservations(int[][] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        double[][] dArray = new double[n3][n4];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[] nArray2 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray2[n2] = 0;
            for (n = 0; n < this.blocksize - 1; ++n) {
                int n5 = n2;
                nArray2[n5] = nArray2[n5] + nArray[n][n2];
                int n6 = n2;
                nArray2[n6] = nArray2[n6] * this.base;
            }
        }
        for (n2 = this.blocksize - 1; n2 < n3; ++n2) {
            n = 0;
            while (n < n4) {
                int n7 = n;
                nArray2[n7] = nArray2[n7] + nArray[n2][n];
                double d = (double)this.stateCount[nArray2[n]] / (double)this.observations;
                dArray[n2][n] = -Math.log(d) / this.log_2;
                this.average += dArray[n2][n];
                if (dArray[n2][n] > this.max) {
                    this.max = dArray[n2][n];
                } else if (dArray[n2][n] < this.min) {
                    this.min = dArray[n2][n];
                }
                int n8 = n;
                nArray2[n8] = nArray2[n8] - this.maxShiftedValue[nArray[n2 - this.blocksize + 1][n]];
                int n9 = n++;
                nArray2[n9] = nArray2[n9] * this.base;
            }
        }
        this.average /= (double)(n4 * (n3 - this.blocksize + 1));
        return dArray;
    }

    @Override
    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray.length;
        if (n6 == 0) {
            n5 = 0;
            n4 = 0;
        } else {
            n5 = nArray[0].length;
            n4 = n5 == 0 ? 0 : nArray[0][0].length;
        }
        double[][][] dArray = new double[n6][n5][n4];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[][] nArray2 = new int[n5][n4];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                nArray2[n3][n2] = 0;
                for (n = 0; n < this.blocksize - 1; ++n) {
                    int[] nArray3 = nArray2[n3];
                    int n7 = n2;
                    nArray3[n7] = nArray3[n7] + nArray[n][n3][n2];
                    int[] nArray4 = nArray2[n3];
                    int n8 = n2;
                    nArray4[n8] = nArray4[n8] * this.base;
                }
            }
        }
        for (n3 = this.blocksize - 1; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                n = 0;
                while (n < n4) {
                    int[] nArray5 = nArray2[n2];
                    int n9 = n;
                    nArray5[n9] = nArray5[n9] + nArray[n3][n2][n];
                    double d = (double)this.stateCount[nArray2[n2][n]] / (double)this.observations;
                    dArray[n3][n2][n] = -Math.log(d) / this.log_2;
                    this.average += dArray[n3][n2][n];
                    if (dArray[n3][n2][n] > this.max) {
                        this.max = dArray[n3][n2][n];
                    } else if (dArray[n3][n2][n] < this.min) {
                        this.min = dArray[n3][n2][n];
                    }
                    int[] nArray6 = nArray2[n2];
                    int n10 = n;
                    nArray6[n10] = nArray6[n10] - this.maxShiftedValue[nArray[n3 - this.blocksize + 1][n2][n]];
                    int[] nArray7 = nArray2[n2];
                    int n11 = n++;
                    nArray7[n11] = nArray7[n11] * this.base;
                }
            }
        }
        this.average /= (double)(n5 * n4 * (n6 - this.blocksize + 1));
        return dArray;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        int n4 = this.blocksize - 1;
        double[] dArray = new double[n3];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n5 = 0;
        for (n2 = 0; n2 < this.blocksize - 1; ++n2) {
            n5 += nArray[n2][n];
            n5 *= this.base;
        }
        for (n2 = n4; n2 < n3; ++n2) {
            double d = (double)this.stateCount[n5 += nArray[n2][n]] / (double)this.observations;
            dArray[n2] = -Math.log(d) / this.log_2;
            this.average += dArray[n2];
            if (dArray[n2] > this.max) {
                this.max = dArray[n2];
            } else if (dArray[n2] < this.min) {
                this.min = dArray[n2];
            }
            n5 -= this.maxShiftedValue[nArray[n2 - this.blocksize + 1][n]];
            n5 *= this.base;
        }
        this.average /= (double)(n3 - this.blocksize + 1);
        return dArray;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4 = nArray.length;
        int n5 = this.blocksize - 1;
        double[] dArray = new double[n4];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n6 = 0;
        for (n3 = 0; n3 < this.blocksize - 1; ++n3) {
            n6 += nArray[n3][n][n2];
            n6 *= this.base;
        }
        for (n3 = n5; n3 < n4; ++n3) {
            double d = (double)this.stateCount[n6 += nArray[n3][n][n2]] / (double)this.observations;
            dArray[n3] = -Math.log(d) / this.log_2;
            this.average += dArray[n3];
            if (dArray[n3] > this.max) {
                this.max = dArray[n3];
            } else if (dArray[n3] < this.min) {
                this.min = dArray[n3];
            }
            n6 -= this.maxShiftedValue[nArray[n3 - this.blocksize + 1][n][n2]];
            n6 *= this.base;
        }
        this.average /= (double)(n4 - this.blocksize + 1);
        return dArray;
    }
}

