/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.networkinference.interregional;

import infodynamics.measures.continuous.ChannelCalculatorMultiVariate;
import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.TransferEntropyCalculatorMultiVariate;
import infodynamics.networkinference.interregional.InterregionalMutualInfo;
import infodynamics.networkinference.interregional.InterregionalTransferEntropy;
import infodynamics.networkinference.interregional.MeasurementDistributionPermutationsOverSubsets;
import infodynamics.utils.ArrayFileReader;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.ParsedProperties;
import infodynamics.utils.RandomGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.Properties;

public abstract class InterregionalChannelMeasure {
    protected ChannelCalculatorMultiVariate channelCalc;
    protected int jointVars1;
    protected int jointVars2;
    protected boolean useAverageRegion1 = false;
    protected int totalVars1;
    protected boolean useAverageRegion2 = false;
    protected int totalVars2;
    protected int maxNumSubsets;
    protected boolean debug;
    protected boolean writeResults;
    protected double[][] region1;
    protected double[][] region2;
    protected boolean allValid;
    protected boolean validityForIndividualElements;
    protected boolean[] jointValidity1;
    protected boolean[] jointValidity2;
    protected boolean[][] individualValidity1;
    protected boolean[][] individualValidity2;
    protected double lastAverage;
    protected RandomGenerator rg;
    protected long seed;
    protected int[][] subsetsForEachRegion1;
    protected int[][] subsetsForEachRegion2;
    protected int numOfSets;
    protected double[] significanceLevelsForEachSubset;
    protected double[] tScoreForEachSubject;
    private String calculatorClass;
    protected Properties calculatorProperties;
    public static final String PROP_CALCULATOR_PROPERTIES_PREFIX = "props.interregionalChannel.calculatorProperties.";
    public static final String PROP_CALCULATOR_CLASS = "props.interregionalChannel.calculator";
    public static final String PROP_JOINT_VARS_1 = "props.interregionalChannel.jointVars1";
    public static final String PROP_JOINT_VARS_2 = "props.interregionalChannel.jointVars2";
    public static final String PROP_NUM_SUBSETS = "props.interregionalChannel.maxNumSets";
    public static final String PROP_SEED = "props.interregionalChannel.seed";
    public static final String PROP_GET_SIGNIFICANCE = "props.interregionalChannel.directRun.getSignificance";
    public static final String PROP_SIG_REORDERINGS = "props.interregionalChannel.directRun.numReorderingsForSignificance";
    public static final String PROP_SIGNIFICANCE_COMPARE_POPULATIONS = "props.interregionalChannel.directRun.compareSubsetPopulationsForSignificance";
    public static final String PROP_WRITE_RESULTS = "props.interregionalChannel.writeResultsToStdOut";
    public static final String PROP_DIRECT_FILE1 = "props.interregionalChannel.directRun.file1";
    public static final String PROP_DIRECT_FILE2 = "props.interregionalChannel.directRun.file2";
    public static final String PROP_DIRECT_OUTPUT_PREFIX = "props.interregionalChannel.directRun.outputPrefix";
    public static final String PROP_DEBUG = "props.debug";
    public static final String JOINT_VARS_SELECT_AVERAGE = "Av";

    public static InterregionalChannelMeasure newInstance(ParsedProperties parsedProperties) throws Exception {
        String string = parsedProperties.getStringProperty(PROP_CALCULATOR_CLASS);
        return InterregionalChannelMeasure.newInstance(string);
    }

    public static InterregionalChannelMeasure newInstance(String string) throws Exception {
        ChannelCalculatorMultiVariate channelCalculatorMultiVariate = (ChannelCalculatorMultiVariate)Class.forName(string).newInstance();
        if (TransferEntropyCalculatorMultiVariate.class.isInstance(channelCalculatorMultiVariate)) {
            return new InterregionalTransferEntropy();
        }
        if (MutualInfoCalculatorMultiVariate.class.isInstance(channelCalculatorMultiVariate)) {
            return new InterregionalMutualInfo();
        }
        throw new Exception("Calculator name not recognised");
    }

    protected InterregionalChannelMeasure() {
    }

    public void initialise(ParsedProperties parsedProperties) throws Exception {
        this.setCalculatorName(parsedProperties.getStringProperty(PROP_CALCULATOR_CLASS));
        this.useAverageRegion1 = parsedProperties.getProperty(PROP_JOINT_VARS_1).equalsIgnoreCase(JOINT_VARS_SELECT_AVERAGE);
        if (this.useAverageRegion1) {
            this.jointVars1 = 1;
        } else {
            this.setJointVars1(parsedProperties.getIntProperty(PROP_JOINT_VARS_1));
        }
        this.useAverageRegion2 = parsedProperties.getProperty(PROP_JOINT_VARS_2).equalsIgnoreCase(JOINT_VARS_SELECT_AVERAGE);
        if (this.useAverageRegion2) {
            this.jointVars2 = 1;
        } else {
            this.setJointVars2(parsedProperties.getIntProperty(PROP_JOINT_VARS_2));
        }
        this.setDebug(parsedProperties.getBooleanProperty(PROP_DEBUG));
        if (this.useAverageRegion1 && this.useAverageRegion2) {
            this.setMaxNumSubsets(1);
        } else {
            this.setMaxNumSubsets(parsedProperties.getIntProperty(PROP_NUM_SUBSETS));
        }
        this.setSeed(parsedProperties.getLongProperty(PROP_SEED));
        this.setWriteResults(parsedProperties.getBooleanProperty(PROP_WRITE_RESULTS));
        this.readInCalculatorProperties(parsedProperties);
        this.initialise();
    }

    public void initialise(int n, int n2, int n3) throws Exception {
        this.setJointVars1(n);
        this.setJointVars2(n2);
        this.useAverageRegion1 = false;
        this.useAverageRegion2 = false;
        this.setMaxNumSubsets(n3);
        this.initialise();
    }

    public void initialise() throws Exception {
        this.channelCalc = (ChannelCalculatorMultiVariate)Class.forName(this.calculatorClass).newInstance();
        this.channelCalc.setDebug(this.debug);
        this.setPropertiesOnCalculator(true);
        this.rg = new RandomGenerator();
        this.rg.setSeed(this.seed);
        this.subsetsForEachRegion1 = null;
        this.subsetsForEachRegion2 = null;
        this.significanceLevelsForEachSubset = null;
        this.tScoreForEachSubject = null;
        this.numOfSets = 0;
    }

    private void readInCalculatorProperties(ParsedProperties parsedProperties) {
        this.calculatorProperties = new Properties();
        for (Object object : parsedProperties.getProperties().keySet()) {
            String string = (String)object;
            if (!string.startsWith(PROP_CALCULATOR_PROPERTIES_PREFIX)) continue;
            String string2 = string.replaceFirst(PROP_CALCULATOR_PROPERTIES_PREFIX, "");
            this.calculatorProperties.setProperty(string2, parsedProperties.getProperty(string));
        }
    }

    public void setObservations(double[][] dArray, double[][] dArray2) {
        this.setRegion1And2Data(dArray, dArray2);
        this.allValid = true;
        this.finaliseSetObservations();
    }

    public void setObservations(double[][] dArray, double[][] dArray2, boolean[] blArray, boolean[] blArray2) {
        this.setRegion1And2Data(dArray, dArray2);
        this.jointValidity1 = blArray;
        this.jointValidity2 = blArray2;
        this.allValid = false;
        this.validityForIndividualElements = false;
        this.finaliseSetObservations();
    }

    public void setObservations(double[][] dArray, double[][] dArray2, boolean[][] blArray, boolean[][] blArray2) {
        this.setRegion1And2Data(dArray, dArray2);
        this.individualValidity1 = blArray;
        this.individualValidity2 = blArray2;
        this.allValid = false;
        this.validityForIndividualElements = true;
        this.finaliseSetObservations();
    }

    protected void setRegion1And2Data(double[][] dArray, double[][] dArray2) {
        if (this.useAverageRegion1) {
            this.region1 = new double[dArray.length][1];
            try {
                MatrixUtils.copyIntoColumn(this.region1, 0, MatrixUtils.meansOfRows(dArray));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            this.region1 = dArray;
        }
        if (this.useAverageRegion2) {
            this.region2 = new double[dArray2.length][1];
            try {
                MatrixUtils.copyIntoColumn(this.region2, 0, MatrixUtils.meansOfRows(dArray2));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            this.region2 = dArray2;
        }
    }

    protected void finaliseSetObservations() {
        this.totalVars1 = this.region1[0].length;
        this.totalVars2 = this.region2[0].length;
    }

    protected void initialiseCalculator() throws Exception {
        this.channelCalc.initialise(this.jointVars1, this.jointVars2);
    }

    protected void setPropertiesOnCalculator(boolean bl) throws Exception {
        boolean bl2 = this.debug;
        this.channelCalc.setDebug(this.debug || bl);
        for (Object object : this.calculatorProperties.keySet()) {
            this.channelCalc.setProperty((String)object, this.calculatorProperties.getProperty((String)object));
        }
        this.channelCalc.setDebug(bl2);
    }

    protected void checkSubsetsAreGenerated() {
        if (this.subsetsForEachRegion1 == null) {
            this.subsetsForEachRegion1 = this.rg.generateNRandomSets(this.totalVars1, this.jointVars1, this.maxNumSubsets);
            this.subsetsForEachRegion2 = this.rg.generateNRandomSets(this.totalVars2, this.jointVars2, this.maxNumSubsets);
            this.numOfSets = Math.min(this.subsetsForEachRegion1.length, this.subsetsForEachRegion2.length);
        }
    }

    public ChannelMeasurementDistribution computeMean() throws Exception {
        this.setPropertiesOnCalculator(false);
        this.checkSubsetsAreGenerated();
        double[] dArray = new double[this.numOfSets];
        for (int i = 0; i < this.numOfSets; ++i) {
            double[][] dArray2 = MatrixUtils.selectColumns(this.region1, this.subsetsForEachRegion1[i]);
            double[][] dArray3 = MatrixUtils.selectColumns(this.region2, this.subsetsForEachRegion2[i]);
            this.initialiseCalculator();
            if (this.allValid) {
                this.channelCalc.setObservations(dArray2, dArray3);
            } else if (this.validityForIndividualElements) {
                boolean[] blArray = MatrixUtils.andRowsOverSelectedColumns(this.individualValidity1, this.subsetsForEachRegion1[i]);
                boolean[] blArray2 = MatrixUtils.andRowsOverSelectedColumns(this.individualValidity2, this.subsetsForEachRegion2[i]);
                this.channelCalc.setObservations(dArray2, dArray3, blArray, blArray2);
            } else {
                this.channelCalc.setObservations(dArray2, dArray3, this.jointValidity1, this.jointValidity2);
            }
            dArray[i] = this.channelCalc.computeAverageLocalOfObservations();
            if (!this.writeResults) continue;
            System.out.print("Done average for subset " + i + " ");
            this.printSubset(System.out, this.subsetsForEachRegion1[i]);
            System.out.print(" -> ");
            this.printSubset(System.out, this.subsetsForEachRegion2[i]);
            System.out.println(": average = " + dArray[i]);
        }
        ChannelMeasurementDistribution channelMeasurementDistribution = new ChannelMeasurementDistribution();
        channelMeasurementDistribution.channelMeasurements = dArray;
        channelMeasurementDistribution.mean = MatrixUtils.mean(dArray);
        channelMeasurementDistribution.std = MatrixUtils.stdDev(dArray, channelMeasurementDistribution.mean);
        this.lastAverage = channelMeasurementDistribution.mean;
        if (this.writeResults) {
            System.out.println("Average across " + this.numOfSets + " subsets was " + this.lastAverage);
        }
        return channelMeasurementDistribution;
    }

    public int[][] generateReorderings(int n) throws Exception {
        int n2 = this.computeNumObservationsToReorder();
        return this.rg.generateDistinctRandomPerturbations(n2, n);
    }

    public MeasurementDistributionPermutationsOverSubsets computeSignificance(int n) throws Exception {
        return this.computeSignificance(this.generateReorderings(n));
    }

    public MeasurementDistributionPermutationsOverSubsets computeSignificance(int[][] nArray) throws Exception {
        int n = nArray.length;
        this.setPropertiesOnCalculator(false);
        this.checkSubsetsAreGenerated();
        double[] dArray = new double[this.numOfSets];
        double[][] dArrayArray = new double[this.numOfSets][];
        this.significanceLevelsForEachSubset = new double[this.numOfSets];
        this.tScoreForEachSubject = new double[this.numOfSets];
        for (int i = 0; i < this.numOfSets; ++i) {
            EmpiricalMeasurementDistribution empiricalMeasurementDistribution;
            double[][] dArray2 = MatrixUtils.selectColumns(this.region1, this.subsetsForEachRegion1[i]);
            double[][] dArray3 = MatrixUtils.selectColumns(this.region2, this.subsetsForEachRegion2[i]);
            this.initialiseCalculator();
            if (this.allValid) {
                this.channelCalc.setObservations(dArray2, dArray3);
            } else if (!this.validityForIndividualElements) {
                this.channelCalc.setObservations(dArray2, dArray3, this.jointValidity1, this.jointValidity2);
            } else {
                this.channelCalc.setObservations(dArray2, dArray3, this.individualValidity1, this.individualValidity2);
            }
            dArray[i] = this.channelCalc.computeAverageLocalOfObservations();
            if (this.allValid || !this.validityForIndividualElements) {
                empiricalMeasurementDistribution = this.channelCalc.computeSignificance(nArray);
            } else {
                empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
                empiricalMeasurementDistribution.actualValue = dArray[i];
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    double[][] dArray4 = MatrixUtils.extractSelectedTimePointsReusingArrays(dArray2, nArray[j]);
                    boolean[][] blArray = MatrixUtils.extractSelectedTimePointsReusingArrays(this.individualValidity1, nArray[j]);
                    this.initialiseCalculator();
                    this.channelCalc.setObservations(dArray4, dArray3, blArray, this.individualValidity2);
                    empiricalMeasurementDistribution.distribution[j] = this.channelCalc.computeAverageLocalOfObservations();
                    if (!(empiricalMeasurementDistribution.distribution[j] >= dArray[i])) continue;
                    ++n2;
                }
                empiricalMeasurementDistribution.pValue = (double)n2 / (double)n;
            }
            dArrayArray[i] = empiricalMeasurementDistribution.distribution;
            this.significanceLevelsForEachSubset[i] = empiricalMeasurementDistribution.pValue;
            this.tScoreForEachSubject[i] = empiricalMeasurementDistribution.getTSscore();
            if (!this.writeResults) continue;
            double d = MatrixUtils.mean(empiricalMeasurementDistribution.distribution);
            double d2 = MatrixUtils.stdDev(empiricalMeasurementDistribution.distribution, d);
            System.out.print("Significance for subset " + i + " ");
            this.printSubset(System.out, this.subsetsForEachRegion1[i]);
            System.out.print(" -> ");
            this.printSubset(System.out, this.subsetsForEachRegion2[i]);
            System.out.printf(" was %.3f (%.4f compared to %.4f +/- %.4f, t=%.4f, factor of %.2f)\n", empiricalMeasurementDistribution.pValue, empiricalMeasurementDistribution.actualValue, d, d2, this.tScoreForEachSubject[i], empiricalMeasurementDistribution.actualValue / d);
        }
        MeasurementDistributionPermutationsOverSubsets measurementDistributionPermutationsOverSubsets = new MeasurementDistributionPermutationsOverSubsets(dArrayArray, dArray);
        this.lastAverage = measurementDistributionPermutationsOverSubsets.actualValue;
        if (this.writeResults) {
            System.out.println("Significance across " + n + " permutations of " + this.numOfSets + " subsets averaged was " + measurementDistributionPermutationsOverSubsets.pValue);
        }
        return measurementDistributionPermutationsOverSubsets;
    }

    public LocalChannelMeasurementDistribution computeLocals() throws Exception {
        return this.computeLocals(-1.0, true);
    }

    public LocalChannelMeasurementDistribution computeLocals(double d, boolean bl) throws Exception {
        int n;
        this.setPropertiesOnCalculator(false);
        this.checkSubsetsAreGenerated();
        this.lastAverage = 0.0;
        double[] dArray = null;
        double[] dArray2 = null;
        int n2 = 0;
        double[] dArray3 = null;
        double[] dArray4 = null;
        for (n = 0; n < this.numOfSets; ++n) {
            Object[] objectArray;
            double[][] dArray5 = MatrixUtils.selectColumns(this.region1, this.subsetsForEachRegion1[n]);
            double[][] dArray6 = MatrixUtils.selectColumns(this.region2, this.subsetsForEachRegion2[n]);
            this.initialiseCalculator();
            if (this.allValid) {
                this.channelCalc.setObservations(dArray5, dArray6);
            } else if (this.validityForIndividualElements) {
                objectArray = MatrixUtils.andRowsOverSelectedColumns(this.individualValidity1, this.subsetsForEachRegion1[n]);
                boolean[] blArray = MatrixUtils.andRowsOverSelectedColumns(this.individualValidity2, this.subsetsForEachRegion2[n]);
                this.channelCalc.setObservations(dArray5, dArray6, (boolean[])objectArray, blArray);
            } else {
                this.channelCalc.setObservations(dArray5, dArray6, this.jointValidity1, this.jointValidity2);
            }
            this.channelCalc.setDebug(true);
            objectArray = this.channelCalc.computeLocalOfPreviousObservations();
            this.channelCalc.setDebug(this.debug);
            this.lastAverage += this.channelCalc.getLastAverage();
            if (dArray == null) {
                dArray = new double[objectArray.length];
                dArray2 = new double[objectArray.length];
            }
            MatrixUtils.addInPlace(dArray, (double[])objectArray);
            MatrixUtils.addSquaresInPlace(dArray2, (double[])objectArray);
            if (d >= 0.0 && this.significanceLevelsForEachSubset != null) {
                if (dArray3 == null) {
                    dArray3 = new double[objectArray.length];
                    dArray4 = new double[objectArray.length];
                }
                if (bl && this.significanceLevelsForEachSubset[n] <= d || !bl && this.tScoreForEachSubject[n] >= d) {
                    ++n2;
                    MatrixUtils.addInPlace(dArray3, (double[])objectArray);
                    MatrixUtils.addSquaresInPlace(dArray4, (double[])objectArray);
                }
            }
            if (!this.writeResults) continue;
            System.out.print("Done locals for subset " + n + " ");
            this.printSubset(System.out, this.subsetsForEachRegion1[n]);
            System.out.print(" -> ");
            this.printSubset(System.out, this.subsetsForEachRegion2[n]);
            System.out.printf(": (average = %.5f)\n", this.channelCalc.getLastAverage());
        }
        for (n = 0; n < dArray.length; ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] / (double)this.numOfSets;
            dArray2[n] = Math.sqrt((double)(dArray2[n] / (double)this.numOfSets - dArray[n] * dArray[n]));
        }
        this.lastAverage /= (double)this.numOfSets;
        if (this.writeResults) {
            System.out.println("Average (from locals) across " + this.numOfSets + " subsets was " + this.lastAverage);
        }
        LocalChannelMeasurementDistribution localChannelMeasurementDistribution = new LocalChannelMeasurementDistribution();
        localChannelMeasurementDistribution.meanLocalChannelMeasurements = dArray;
        localChannelMeasurementDistribution.stdLocalChannelMeasurements = dArray2;
        boolean bl2 = localChannelMeasurementDistribution.hasLocalsForSignificantChannelsOnly = d >= 0.0 && this.significanceLevelsForEachSubset != null;
        if (localChannelMeasurementDistribution.hasLocalsForSignificantChannelsOnly) {
            localChannelMeasurementDistribution.countOfSignificantChannels = n2;
            if (n2 > 0) {
                for (int i = 0; i < dArray.length; ++i) {
                    int n4 = i;
                    dArray3[n4] = dArray3[n4] / (double)n2;
                    dArray4[i] = Math.sqrt((double)(dArray4[i] / (double)n2 - dArray3[i] * dArray3[i]));
                }
            }
            localChannelMeasurementDistribution.meanLocalForSignificantChannelsOnly = dArray3;
            localChannelMeasurementDistribution.stdLocalForSignificantChannelsOnly = dArray4;
        }
        return localChannelMeasurementDistribution;
    }

    protected abstract int computeNumObservationsToReorder() throws Exception;

    public abstract int[] computeTimeIndicesForLocalValues() throws Exception;

    private void printSubset(PrintStream printStream, int[] nArray) {
        printStream.print("{");
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (bl) {
                printStream.print(", ");
            }
            printStream.print(nArray[i]);
            bl = true;
        }
        printStream.print("}");
    }

    public void setCalculatorName(String string) {
        this.calculatorClass = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setJointVars1(int n) {
        this.jointVars1 = n;
    }

    public void setJointVars2(int n) {
        this.jointVars2 = n;
    }

    public void setMaxNumSubsets(int n) {
        this.maxNumSubsets = n;
    }

    public void setSeed(long l) {
        this.seed = l;
    }

    private void setWriteResults(boolean bl) {
        this.writeResults = bl;
    }

    public double getLastAverage() {
        return this.lastAverage;
    }

    public static void main(String[] stringArray) throws Exception {
        ArrayFileReader arrayFileReader;
        ArrayFileReader arrayFileReader2;
        if (stringArray.length < 1) {
            System.err.println("Usage: InterregionalChannelMeasure <propsFile> [<dataFile1> <dataFile2>]");
            return;
        }
        String string = stringArray[0];
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File(string)));
        ParsedProperties parsedProperties = new ParsedProperties(properties);
        InterregionalChannelMeasure interregionalChannelMeasure = InterregionalChannelMeasure.newInstance(parsedProperties);
        if (stringArray.length < 3) {
            arrayFileReader2 = new ArrayFileReader(parsedProperties.getStringProperty(PROP_DIRECT_FILE1));
            arrayFileReader = new ArrayFileReader(parsedProperties.getStringProperty(PROP_DIRECT_FILE2));
        } else {
            arrayFileReader2 = new ArrayFileReader(stringArray[1]);
            arrayFileReader = new ArrayFileReader(stringArray[2]);
        }
        double[][] dArray = arrayFileReader2.getDouble2DMatrix();
        double[][] dArray2 = arrayFileReader.getDouble2DMatrix();
        interregionalChannelMeasure.initialise(parsedProperties);
        interregionalChannelMeasure.setObservations(dArray, dArray2);
        ChannelMeasurementDistribution channelMeasurementDistribution = interregionalChannelMeasure.computeMean();
        try {
            String string2 = parsedProperties.getStringProperty(PROP_DIRECT_OUTPUT_PREFIX);
            System.out.printf("%s", string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.printf("%.4f,%.4f", channelMeasurementDistribution.mean, channelMeasurementDistribution.std);
        if (parsedProperties.getBooleanProperty(PROP_GET_SIGNIFICANCE)) {
            int n = parsedProperties.getIntProperty(PROP_SIG_REORDERINGS);
            MeasurementDistributionPermutationsOverSubsets measurementDistributionPermutationsOverSubsets = interregionalChannelMeasure.computeSignificance(n);
            if (parsedProperties.getBooleanProperty(PROP_SIGNIFICANCE_COMPARE_POPULATIONS)) {
                int n2 = measurementDistributionPermutationsOverSubsets.avDistributionForSubsets.length;
                double d = MatrixUtils.mean(measurementDistributionPermutationsOverSubsets.avDistributionForSubsets);
                double d2 = MatrixUtils.stdDev(measurementDistributionPermutationsOverSubsets.avDistributionForSubsets, d);
                double d3 = channelMeasurementDistribution.std * channelMeasurementDistribution.std / (double)n2;
                double d4 = d2 * d2 / (double)n2;
                double d5 = Math.sqrt(d3 + d4);
                double d6 = (d3 + d4) * (d3 + d4) * (double)(n2 - 1) / (d3 * d3 + d4 * d4);
                double d7 = (channelMeasurementDistribution.mean - d) / d5;
                System.out.printf(",%.4f,%.4f,%.4f,%.1f", d, d2, d7, d6);
            } else {
                double d = (channelMeasurementDistribution.mean - measurementDistributionPermutationsOverSubsets.getMeanOfDistribution()) / measurementDistributionPermutationsOverSubsets.getStdOfDistribution();
                System.out.printf(",%.4f,%.4f,%.4f,%d", measurementDistributionPermutationsOverSubsets.getMeanOfDistribution(), measurementDistributionPermutationsOverSubsets.getStdOfDistribution(), d, n);
            }
        }
        System.out.println();
    }

    public class LocalChannelMeasurementDistribution {
        public double[] meanLocalChannelMeasurements;
        public double[] stdLocalChannelMeasurements;
        public boolean hasLocalsForSignificantChannelsOnly;
        public int countOfSignificantChannels;
        public double[] meanLocalForSignificantChannelsOnly;
        public double[] stdLocalForSignificantChannelsOnly;
    }

    public class ChannelMeasurementDistribution {
        public double[] channelMeasurements;
        public double mean;
        public double std;
    }
}

