/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class OctaveFileWriter
extends HashMap<String, Object> {
    public static final long serialVersionUID = 1L;
    private boolean writeLFOnly = true;
    private String octaveFilename = null;
    private static final String LINE_SEPARATOR_PROPERTY = "line.separator";
    private static final String LINE_SEPARATOR = "\n";
    private Hashtable<String, Integer> roundingHT = new Hashtable();

    public void setFilename(String string) {
        this.octaveFilename = string;
    }

    public void writeFile(String string) throws IOException {
        this.setFilename(string);
        this.writeFile();
    }

    public void writeFile() throws IOException {
        Serializable serializable;
        int n = 0;
        if (this.octaveFilename == null) {
            throw new IOException("No filename has been set");
        }
        String string = null;
        if (this.writeLFOnly) {
            string = System.getProperty(LINE_SEPARATOR_PROPERTY);
            System.setProperty(LINE_SEPARATOR_PROPERTY, LINE_SEPARATOR);
        }
        OctaveFileWriter.createDirectories(this.octaveFilename);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.octaveFilename)));
        String string2 = "null";
        try {
            serializable = InetAddress.getLocalHost();
            string2 = ((InetAddress)serializable).getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        printWriter.println("# Created on " + string2 + " by infodynamics.utils.OctaveFileWriter, " + new Date());
        serializable = new DecimalFormat();
        int n2 = -1;
        Set set = this.keySet();
        for (String string3 : set) {
            Object v = this.get(string3);
            try {
                Integer n3 = this.roundingHT.get(string3);
                if (n3 != null) {
                    n2 = n3;
                    ((DecimalFormat)serializable).setMaximumFractionDigits(n2);
                } else {
                    n2 = -1;
                }
                printWriter.println("# name: " + string3);
                if (v.getClass().isArray()) {
                    if (Array.getLength(v) > 0) {
                        int n4;
                        Object object;
                        int n5;
                        Object object2 = Array.get(v, 0);
                        boolean bl = String.class.isInstance(object2);
                        if (bl) {
                            printWriter.println("# type: string");
                            n = 0;
                            for (n5 = 0; n5 < Array.getLength(v); ++n5) {
                                if (((String)Array.get(v, n5)).length() <= n) continue;
                                n = ((String)Array.get(v, n5)).length();
                            }
                            printWriter.println("# elements: " + Array.getLength(v));
                        } else {
                            printWriter.println("# type: matrix");
                        }
                        if (object2.getClass().isArray()) {
                            printWriter.println("# rows: " + Array.getLength(v));
                            printWriter.println("# columns: " + Array.getLength(object2));
                            for (n5 = 0; n5 < Array.getLength(v); ++n5) {
                                object = Array.get(v, n5);
                                for (n4 = 0; n4 < Array.getLength(object); ++n4) {
                                    Object object3 = Array.get(object, n4);
                                    if (Boolean.class.isInstance(object3)) {
                                        printWriter.print(" " + ((Boolean)object3 != false ? "1" : "0"));
                                        continue;
                                    }
                                    if (n2 >= 0) {
                                        printWriter.print(" " + ((Format)serializable).format(object3));
                                        continue;
                                    }
                                    printWriter.print(" " + object3);
                                }
                                printWriter.println();
                            }
                            continue;
                        }
                        if (bl) {
                            for (n5 = 0; n5 < Array.getLength(v); ++n5) {
                                printWriter.println("# length: " + n);
                                object = (String)Array.get(v, n5);
                                printWriter.print((String)object);
                                for (n4 = ((String)object).length(); n4 < n; ++n4) {
                                    printWriter.print(' ');
                                }
                                printWriter.println();
                            }
                            continue;
                        }
                        printWriter.println("# rows: " + Array.getLength(v));
                        printWriter.println("# columns: 1");
                        for (n5 = 0; n5 < Array.getLength(v); ++n5) {
                            object = Array.get(v, n5);
                            if (Boolean.class.isInstance(object)) {
                                printWriter.print(" " + ((Boolean)object != false ? "1" : "0"));
                                continue;
                            }
                            if (n2 >= 0) {
                                printWriter.print(" " + ((Format)serializable).format(object));
                                continue;
                            }
                            printWriter.println(" " + object);
                        }
                        continue;
                    }
                    printWriter.println("# type: matrix");
                    printWriter.println("# rows: 0");
                    printWriter.println("# columns: 0");
                    continue;
                }
                if (String.class.isInstance(v)) {
                    printWriter.println("# type: string");
                    printWriter.println("# elements: 1");
                    printWriter.println("# length: " + ((String)v).length());
                    printWriter.println(v);
                    continue;
                }
                if (Boolean.class.isInstance(v)) {
                    printWriter.println("# type: bool");
                    printWriter.println((Boolean)v != false ? "1" : "0");
                    continue;
                }
                printWriter.println("# type: scalar");
                if (n2 >= 0) {
                    printWriter.println(((Format)serializable).format(v));
                    continue;
                }
                printWriter.println(v);
            }
            catch (Exception exception) {
                System.out.println("Problem writing variable " + string3 + " to the output file (value = " + v + "):");
                exception.printStackTrace();
                System.out.println("Continuing with file.");
            }
        }
        printWriter.println();
        printWriter.close();
        if (this.writeLFOnly) {
            System.setProperty(LINE_SEPARATOR_PROPERTY, string);
        }
    }

    public void put(String string, Object object, int n) {
        this.roundingHT.put(string, new Integer(n));
        this.put(string, object);
    }

    private static void createDirectories(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.isDirectory()) {
            file2.mkdirs();
        }
    }

    public void putAll(Properties properties) {
        for (Object object : properties.keySet()) {
            String string = (String)object;
            string = string.replaceAll("\\.", "__");
            this.put(string, properties.get(object));
        }
    }
}

