"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerListenerProtocol = exports.LoadBalancerType = exports.ContextProvider = void 0;
/**
 * Identifier for the context provider.
 *
 * @stability stable
 */
var ContextProvider;
(function (ContextProvider) {
    ContextProvider["AMI_PROVIDER"] = "ami";
    ContextProvider["AVAILABILITY_ZONE_PROVIDER"] = "availability-zones";
    ContextProvider["HOSTED_ZONE_PROVIDER"] = "hosted-zone";
    ContextProvider["SSM_PARAMETER_PROVIDER"] = "ssm";
    ContextProvider["VPC_PROVIDER"] = "vpc-provider";
    ContextProvider["ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER"] = "endpoint-service-availability-zones";
    ContextProvider["LOAD_BALANCER_PROVIDER"] = "load-balancer";
    ContextProvider["LOAD_BALANCER_LISTENER_PROVIDER"] = "load-balancer-listener";
    ContextProvider["SECURITY_GROUP_PROVIDER"] = "security-group";
})(ContextProvider = exports.ContextProvider || (exports.ContextProvider = {}));
/**
 * Type of load balancer.
 *
 * @stability stable
 */
var LoadBalancerType;
(function (LoadBalancerType) {
    LoadBalancerType["NETWORK"] = "network";
    LoadBalancerType["APPLICATION"] = "application";
})(LoadBalancerType = exports.LoadBalancerType || (exports.LoadBalancerType = {}));
/**
 * The protocol for connections from clients to the load balancer.
 *
 * @stability stable
 */
var LoadBalancerListenerProtocol;
(function (LoadBalancerListenerProtocol) {
    LoadBalancerListenerProtocol["HTTP"] = "HTTP";
    LoadBalancerListenerProtocol["HTTPS"] = "HTTPS";
    LoadBalancerListenerProtocol["TCP"] = "TCP";
    LoadBalancerListenerProtocol["TLS"] = "TLS";
    LoadBalancerListenerProtocol["UDP"] = "UDP";
    LoadBalancerListenerProtocol["TCP_UDP"] = "TCP_UDP";
})(LoadBalancerListenerProtocol = exports.LoadBalancerListenerProtocol || (exports.LoadBalancerListenerProtocol = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29udGV4dC1xdWVyaWVzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29udGV4dC1xdWVyaWVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBS0EsSUFBWSxlQTZDWDtBQTdDRCxXQUFZLGVBQWU7SUFJekIsdUNBQW9CLENBQUE7SUFLcEIsb0VBQWlELENBQUE7SUFLakQsdURBQW9DLENBQUE7SUFLcEMsaURBQThCLENBQUE7SUFLOUIsZ0RBQTZCLENBQUE7SUFLN0Isc0dBQW1GLENBQUE7SUFLbkYsMkRBQXdDLENBQUE7SUFLeEMsNkVBQTBELENBQUE7SUFLMUQsNkRBQTBDLENBQUE7QUFDNUMsQ0FBQyxFQTdDVyxlQUFlLEdBQWYsdUJBQWUsS0FBZix1QkFBZSxRQTZDMUI7Ozs7OztBQXNLRCxJQUFZLGdCQVVYO0FBVkQsV0FBWSxnQkFBZ0I7SUFJMUIsdUNBQW1CLENBQUE7SUFLbkIsK0NBQTJCLENBQUE7QUFDN0IsQ0FBQyxFQVZXLGdCQUFnQixHQUFoQix3QkFBZ0IsS0FBaEIsd0JBQWdCLFFBVTNCOzs7Ozs7QUEwQ0QsSUFBWSw0QkE4Qlg7QUE5QkQsV0FBWSw0QkFBNEI7SUFJdEMsNkNBQWEsQ0FBQTtJQUtiLCtDQUFlLENBQUE7SUFLZiwyQ0FBVyxDQUFBO0lBS1gsMkNBQVcsQ0FBQTtJQUtYLDJDQUFXLENBQUE7SUFLWCxtREFBbUIsQ0FBQTtBQUNyQixDQUFDLEVBOUJXLDRCQUE0QixHQUE1QixvQ0FBNEIsS0FBNUIsb0NBQTRCLFFBOEJ2QyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRhZyB9IGZyb20gJy4vbWV0YWRhdGEtc2NoZW1hJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gQ29udGV4dFByb3ZpZGVyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFNSV9QUk9WSURFUiA9ICdhbWknLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFWQUlMQUJJTElUWV9aT05FX1BST1ZJREVSID0gJ2F2YWlsYWJpbGl0eS16b25lcycsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBIT1NURURfWk9ORV9QUk9WSURFUiA9ICdob3N0ZWQtem9uZScsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBTU01fUEFSQU1FVEVSX1BST1ZJREVSID0gJ3NzbScsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFZQQ19QUk9WSURFUiA9ICd2cGMtcHJvdmlkZXInLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEVORFBPSU5UX1NFUlZJQ0VfQVZBSUxBQklMSVRZX1pPTkVfUFJPVklERVIgPSAnZW5kcG9pbnQtc2VydmljZS1hdmFpbGFiaWxpdHktem9uZXMnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgTE9BRF9CQUxBTkNFUl9QUk9WSURFUiA9ICdsb2FkLWJhbGFuY2VyJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIExPQURfQkFMQU5DRVJfTElTVEVORVJfUFJPVklERVIgPSAnbG9hZC1iYWxhbmNlci1saXN0ZW5lcicsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgU0VDVVJJVFlfR1JPVVBfUFJPVklERVIgPSAnc2VjdXJpdHktZ3JvdXAnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEFtaUNvbnRleHRRdWVyeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYWNjb3VudDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb246IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG93bmVycz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmaWx0ZXJzOiB7W2tleTogc3RyaW5nXTogc3RyaW5nW119O1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQXZhaWxhYmlsaXR5Wm9uZXNDb250ZXh0UXVlcnkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFjY291bnQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVnaW9uOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBIb3N0ZWRab25lQ29udGV4dFF1ZXJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhY2NvdW50OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlZ2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkb21haW5OYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJpdmF0ZVpvbmU/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdnBjSWQ/OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFNTTVBhcmFtZXRlckNvbnRleHRRdWVyeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYWNjb3VudDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb246IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwYXJhbWV0ZXJOYW1lOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgVnBjQ29udGV4dFF1ZXJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhY2NvdW50OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlZ2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZmlsdGVyOiB7W2tleTogc3RyaW5nXTogc3RyaW5nfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJldHVybkFzeW1tZXRyaWNTdWJuZXRzPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdWJuZXRHcm91cE5hbWVUYWc/OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEVuZHBvaW50U2VydmljZUF2YWlsYWJpbGl0eVpvbmVzQ29udGV4dFF1ZXJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhY2NvdW50OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlZ2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZXJ2aWNlTmFtZTogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gTG9hZEJhbGFuY2VyVHlwZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBORVRXT1JLID0gJ25ldHdvcmsnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVBQTElDQVRJT04gPSAnYXBwbGljYXRpb24nLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBMb2FkQmFsYW5jZXJGaWx0ZXIge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsb2FkQmFsYW5jZXJUeXBlOiBMb2FkQmFsYW5jZXJUeXBlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGxvYWRCYWxhbmNlckFybj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbG9hZEJhbGFuY2VyVGFncz86IFRhZ1tdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBMb2FkQmFsYW5jZXJDb250ZXh0UXVlcnkgZXh0ZW5kcyBMb2FkQmFsYW5jZXJGaWx0ZXIge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFjY291bnQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVnaW9uOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIExvYWRCYWxhbmNlckxpc3RlbmVyUHJvdG9jb2wge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEhUVFAgPSAnSFRUUCcsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgSFRUUFMgPSAnSFRUUFMnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBUQ1AgPSAnVENQJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVExTID0gJ1RMUycsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVURQID0gJ1VEUCcsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBUQ1BfVURQID0gJ1RDUF9VRFAnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBMb2FkQmFsYW5jZXJMaXN0ZW5lckNvbnRleHRRdWVyeSBleHRlbmRzIExvYWRCYWxhbmNlckZpbHRlciB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYWNjb3VudDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb246IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsaXN0ZW5lckFybj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsaXN0ZW5lclByb3RvY29sPzogTG9hZEJhbGFuY2VyTGlzdGVuZXJQcm90b2NvbDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbGlzdGVuZXJQb3J0PzogbnVtYmVyO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU2VjdXJpdHlHcm91cENvbnRleHRRdWVyeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYWNjb3VudDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb246IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZWN1cml0eUdyb3VwSWQ6IHN0cmluZztcbn1cblxuZXhwb3J0IHR5cGUgQ29udGV4dFF1ZXJ5UHJvcGVydGllcyA9IEFtaUNvbnRleHRRdWVyeVxufCBBdmFpbGFiaWxpdHlab25lc0NvbnRleHRRdWVyeVxufCBIb3N0ZWRab25lQ29udGV4dFF1ZXJ5XG58IFNTTVBhcmFtZXRlckNvbnRleHRRdWVyeVxufCBWcGNDb250ZXh0UXVlcnlcbnwgRW5kcG9pbnRTZXJ2aWNlQXZhaWxhYmlsaXR5Wm9uZXNDb250ZXh0UXVlcnlcbnwgTG9hZEJhbGFuY2VyQ29udGV4dFF1ZXJ5XG58IExvYWRCYWxhbmNlckxpc3RlbmVyQ29udGV4dFF1ZXJ5XG58IFNlY3VyaXR5R3JvdXBDb250ZXh0UXVlcnk7XG4iXX0=