import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { DefaultStackSynthesizer } from './default-synthesizer';
/**
 * Construction properties of {@link BootstraplessSynthesizer}.
 *
 * @stability stable
 */
export interface BootstraplessSynthesizerProps {
    /**
     * The deploy Role ARN to use.
     *
     * @default - No deploy role (use CLI credentials)
     * @stability stable
     */
    readonly deployRoleArn?: string;
    /**
     * The CFN execution Role ARN to use.
     *
     * @default - No CloudFormation role (use CLI credentials)
     * @stability stable
     */
    readonly cloudFormationExecutionRoleArn?: string;
}
/**
 * A special synthesizer that behaves similarly to DefaultStackSynthesizer, but doesn't require bootstrapping the environment it operates in.
 *
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 *
 * @stability stable
 */
export declare class BootstraplessSynthesizer extends DefaultStackSynthesizer {
    /**
     * @stability stable
     */
    constructor(props: BootstraplessSynthesizerProps);
    /**
     * Register a File Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @stability stable
     */
    addFileAsset(_asset: FileAssetSource): FileAssetLocation;
    /**
     * Register a Docker Image Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @stability stable
     */
    addDockerImageAsset(_asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * Synthesize the associated stack to the session.
     *
     * @stability stable
     */
    synthesize(session: ISynthesisSession): void;
}
