"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASSET_PREFIX_SEPARATOR = exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports.ASSET_RESOURCE_METADATA_PATH_KEY = exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0;
/**
 * If this is set in the context, the aws:asset:xxx metadata entries will not be
 * added to the template. This is used, for example, when we run integrationt
 * tests.
 */
exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = 'aws:cdk:enable-asset-metadata';
/**
 * Metadata added to the CloudFormation template entries that map local assets
 * to resources.
 */
exports.ASSET_RESOURCE_METADATA_PATH_KEY = 'aws:asset:path';
exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = 'aws:asset:property';
/**
 * Separator string that separates the prefix separator from the object key separator.
 *
 * Asset keys will look like:
 *
 *    /assets/MyConstruct12345678/||abcdef12345.zip
 *
 * This allows us to encode both the prefix and the full location in a single
 * CloudFormation Template Parameter.
 */
exports.ASSET_PREFIX_SEPARATOR = '||';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzZXRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXNzZXRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7O0dBSUc7QUFDVSxRQUFBLHVDQUF1QyxHQUFHLCtCQUErQixDQUFDO0FBRXZGOzs7R0FHRztBQUNVLFFBQUEsZ0NBQWdDLEdBQUcsZ0JBQWdCLENBQUM7QUFDcEQsUUFBQSxvQ0FBb0MsR0FBRyxvQkFBb0IsQ0FBQztBQUV6RTs7Ozs7Ozs7O0dBU0c7QUFDVSxRQUFBLHNCQUFzQixHQUFHLElBQUksQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogSWYgdGhpcyBpcyBzZXQgaW4gdGhlIGNvbnRleHQsIHRoZSBhd3M6YXNzZXQ6eHh4IG1ldGFkYXRhIGVudHJpZXMgd2lsbCBub3QgYmVcbiAqIGFkZGVkIHRvIHRoZSB0ZW1wbGF0ZS4gVGhpcyBpcyB1c2VkLCBmb3IgZXhhbXBsZSwgd2hlbiB3ZSBydW4gaW50ZWdyYXRpb250XG4gKiB0ZXN0cy5cbiAqL1xuZXhwb3J0IGNvbnN0IEFTU0VUX1JFU09VUkNFX01FVEFEQVRBX0VOQUJMRURfQ09OVEVYVCA9ICdhd3M6Y2RrOmVuYWJsZS1hc3NldC1tZXRhZGF0YSc7XG5cbi8qKlxuICogTWV0YWRhdGEgYWRkZWQgdG8gdGhlIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIGVudHJpZXMgdGhhdCBtYXAgbG9jYWwgYXNzZXRzXG4gKiB0byByZXNvdXJjZXMuXG4gKi9cbmV4cG9ydCBjb25zdCBBU1NFVF9SRVNPVVJDRV9NRVRBREFUQV9QQVRIX0tFWSA9ICdhd3M6YXNzZXQ6cGF0aCc7XG5leHBvcnQgY29uc3QgQVNTRVRfUkVTT1VSQ0VfTUVUQURBVEFfUFJPUEVSVFlfS0VZID0gJ2F3czphc3NldDpwcm9wZXJ0eSc7XG5cbi8qKlxuICogU2VwYXJhdG9yIHN0cmluZyB0aGF0IHNlcGFyYXRlcyB0aGUgcHJlZml4IHNlcGFyYXRvciBmcm9tIHRoZSBvYmplY3Qga2V5IHNlcGFyYXRvci5cbiAqXG4gKiBBc3NldCBrZXlzIHdpbGwgbG9vayBsaWtlOlxuICpcbiAqICAgIC9hc3NldHMvTXlDb25zdHJ1Y3QxMjM0NTY3OC98fGFiY2RlZjEyMzQ1LnppcFxuICpcbiAqIFRoaXMgYWxsb3dzIHVzIHRvIGVuY29kZSBib3RoIHRoZSBwcmVmaXggYW5kIHRoZSBmdWxsIGxvY2F0aW9uIGluIGEgc2luZ2xlXG4gKiBDbG91ZEZvcm1hdGlvbiBUZW1wbGF0ZSBQYXJhbWV0ZXIuXG4gKi9cbmV4cG9ydCBjb25zdCBBU1NFVF9QUkVGSVhfU0VQQVJBVE9SID0gJ3x8JztcbiJdfQ==