"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Expression = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Expression for events in Detector Model state.
 * @see https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
 */
class Expression {
    /**
     * Create a expression from the given string.
     */
    static fromString(value) {
        return new StringExpression(value);
    }
    /**
     * Create a expression for function `currentInput()`.
     * It is evaluated to true if the specified input message was received.
     */
    static currentInput(input) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_IInput(input);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.currentInput);
            }
            throw error;
        }
        return this.fromString(`currentInput("${input.inputName}")`);
    }
    /**
     * Create a expression for function `timeout("timer-name")`.
     * It is evaluated to true if the specified timer has elapsed.
     * You can define a timer only using the `setTimer` action.
     */
    static timeout(timerName) {
        return this.fromString(`timeout("${timerName}")`);
    }
    /**
     * Create a expression for get an input attribute as `$input.TemperatureInput.temperatures[2]`.
     */
    static inputAttribute(input, path) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_IInput(input);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inputAttribute);
            }
            throw error;
        }
        return this.fromString(`$input.${input.inputName}.${path}`);
    }
    /**
     * Create a expression for the Addition operator.
     */
    static add(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.add);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '+', right, 12);
    }
    /**
     * Create a expression for the Subtraction operator.
     */
    static subtract(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.subtract);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '-', right, 12);
    }
    /**
     * Create a expression for the Division operator.
     */
    static divide(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.divide);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '/', right, 13);
    }
    /**
     * Create a expression for the Multiplication operator.
     */
    static multiply(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.multiply);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '*', right, 13);
    }
    /**
     * Create a expression for the String Concatenation operator.
     */
    static concat(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.concat);
            }
            throw error;
        }
        return this.add(left, right);
    }
    /**
     * Create a expression for the Bitwise OR operator.
     */
    static bitwiseOr(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bitwiseOr);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '|', right, 6);
    }
    /**
     * Create a expression for the Bitwise AND operator.
     */
    static bitwiseAnd(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bitwiseAnd);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '&', right, 8);
    }
    /**
     * Create a expression for the Bitwise XOR operator.
     */
    static bitwiseXor(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bitwiseXor);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '^', right, 7);
    }
    /**
     * Create a expression for the Equal operator.
     */
    static eq(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.eq);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '==', right, 9);
    }
    /**
     * Create a expression for the Not Equal operator.
     */
    static neq(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.neq);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '!=', right, 9);
    }
    /**
     * Create a expression for the Less Than operator.
     */
    static lt(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.lt);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '<', right, 10);
    }
    /**
     * Create a expression for the Less Than Or Equal operator.
     */
    static lte(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.lte);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '<=', right, 10);
    }
    /**
     * Create a expression for the Greater Than operator.
     */
    static gt(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.gt);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '>', right, 10);
    }
    /**
     * Create a expression for the Greater Than Or Equal operator.
     */
    static gte(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.gte);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '>=', right, 10);
    }
    /**
     * Create a expression for the AND operator.
     */
    static and(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.and);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '&&', right, 5);
    }
    /**
     * Create a expression for the OR operator.
     */
    static or(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.or);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '||', right, 4);
    }
    constructor() {
    }
}
_a = JSII_RTTI_SYMBOL_1;
Expression[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.Expression", version: "2.73.0-alpha.0" };
exports.Expression = Expression;
class StringExpression extends Expression {
    constructor(value) {
        super();
        this.value = value;
    }
    evaluate() {
        return this.value;
    }
}
class BinaryOperationExpression extends Expression {
    constructor(left, operator, right, 
    /**
     * Indicates the priority of the operator.
     * This is intended to be set according to MDN rules.
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Operator_Precedence#table
     */
    priority) {
        super();
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.priority = priority;
    }
    evaluate(parentPriority) {
        const expression = `${this.left.evaluate(this.priority)} ${this.operator} ${this.right.evaluate(this.priority)}`;
        return parentPriority === undefined || parentPriority <= this.priority
            ? expression
            : `(${expression})`;
    }
}
//# sourceMappingURL=data:application/json;base64,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