# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into sdk package
from .models.api_key import APIKey
from .models.access_token import AccessToken
from .models.affiliate import Affiliate
from .models.announcement import Announcement
from .models.chat import Chat
from .models.chat_channel import ChatChannel
from .models.connected_users import ConnectedUsers
from .models.error import Error
from .models.error_error import ErrorError
from .models.execution import Execution
from .models.funding import Funding
from .models.index_composite import IndexComposite
from .models.inline_response_200 import InlineResponse200
from .models.instrument import Instrument
from .models.instrument_interval import InstrumentInterval
from .models.insurance import Insurance
from .models.leaderboard import Leaderboard
from .models.liquidation import Liquidation
from .models.margin import Margin
from .models.notification import Notification
from .models.order import Order
from .models.order_book import OrderBook
from .models.order_book_l2 import OrderBookL2
from .models.position import Position
from .models.quote import Quote
from .models.settlement import Settlement
from .models.stats import Stats
from .models.stats_history import StatsHistory
from .models.trade import Trade
from .models.trade_bin import TradeBin
from .models.transaction import Transaction
from .models.user import User
from .models.user_commission import UserCommission
from .models.user_preferences import UserPreferences
from .models.wallet import Wallet
from .models.x_any import XAny

# import apis into sdk package
from .apis.api_key_api import APIKeyApi
from .apis.announcement_api import AnnouncementApi
from .apis.chat_api import ChatApi
from .apis.execution_api import ExecutionApi
from .apis.funding_api import FundingApi
from .apis.instrument_api import InstrumentApi
from .apis.insurance_api import InsuranceApi
from .apis.leaderboard_api import LeaderboardApi
from .apis.liquidation_api import LiquidationApi
from .apis.notification_api import NotificationApi
from .apis.order_api import OrderApi
from .apis.order_book_api import OrderBookApi
from .apis.position_api import PositionApi
from .apis.quote_api import QuoteApi
from .apis.schema_api import SchemaApi
from .apis.settlement_api import SettlementApi
from .apis.stats_api import StatsApi
from .apis.trade_api import TradeApi
from .apis.user_api import UserApi

# import ApiClient
from .api_client import ApiClient

from .configuration import Configuration

configuration = Configuration()
